import("stdfaust.lib"); 

//  Based on simple Alembic F-2B vstudio preamp

normal_L = pre : fi.iir((b0/a0,b1/a0,b2/a0,b3/a0,b4/a0),(a1/a0,a2/a0,a3/a0,a4/a0)) : alembic_normclip with {
    LogPot(a, x) = ba.if(a, (exp(a * x) - 1) / (exp(a) - 1), x);
    Inverted(b, x) = ba.if(b, 1 - x, x);
    s = 0.993;
    fs = float(ma.SR);
    pre = _;


    Bass_L = vslider("Bass_L[name:Bass_L]", 0.5, 0, 1, 0.01) : Inverted(0) : LogPot(3) : si.smooth(s);


    Middle_L = vslider("Middle_L[name:Middle_L]", 0.5, 0, 1, 0.01) : Inverted(0) : si.smooth(s);

    Volume_L = vslider("Volume_L[name:Volume_L]", 0.5, 0, 1, 0.01) : Inverted(0) : LogPot(3) : si.smooth(s);


    Treble_L = vslider("Treble_L[name:Treble_L]", 0.5, 0, 1, 0.01) : Inverted(1) : si.smooth(s);

    b0 = Volume_L*(Bass_L*(Treble_L*pow(fs,3)*(1.17882146159178e-17*fs + 7.85880974394511e-17) + fs*(fs*(fs*(-1.17882146159178e-17*fs - 2.07004392829875e-15) - 1.0070880757276e-11) - 6.70506959004678e-11)) + Middle_L*(Bass_L*pow(fs,2)*(fs*(-1.65035004622849e-18*fs - 9.46515045560758e-15) - 6.30276541464398e-14) + fs*(fs*(-1.03234662466208e-16*fs - 5.91603840340603e-13) - 3.93943739504993e-12)) + Treble_L*fs*(fs*(7.37390446187197e-16*fs + 2.99972440013567e-14) + 1.67208717956279e-13) + fs*(fs*(-7.37390446187197e-16*fs - 2.99972440013567e-14) - 1.67208717956279e-13));

    b1 = Volume_L*(Bass_L*(Treble_L*pow(fs,3)*(-4.71528584636711e-17*fs - 1.57176194878902e-16) + fs*(pow(fs,2)*(4.71528584636711e-17*fs + 4.1400878565975e-15) - 1.34101391800936e-10)) + Middle_L*(Bass_L*pow(fs,3)*(6.60140018491395e-18*fs + 1.89303009112152e-14) + fs*(2.06469324932415e-16*pow(fs,2) - 7.87887479009986e-12)) + Treble_L*fs*(-1.47478089237439e-15*pow(fs,2) + 3.34417435912558e-13) + fs*(1.47478089237439e-15*pow(fs,2) - 3.34417435912558e-13));

    b2 = Volume_L*(Bass_L*(7.07292876955067e-17*Treble_L*pow(fs,4) + pow(fs,2)*(-7.07292876955067e-17*pow(fs,2) + 2.0141761514552e-11)) + Middle_L*(Bass_L*pow(fs,2)*(-9.90210027737093e-18*pow(fs,2) + 1.2605530829288e-13) + 1.18320768068121e-12*pow(fs,2)) - 5.99944880027134e-14*Treble_L*pow(fs,2) + 5.99944880027134e-14*pow(fs,2));

    b3 = Volume_L*(Bass_L*(Treble_L*pow(fs,3)*(-4.71528584636711e-17*fs + 1.57176194878902e-16) + fs*(pow(fs,2)*(4.71528584636711e-17*fs - 4.1400878565975e-15) + 1.34101391800936e-10)) + Middle_L*(Bass_L*pow(fs,3)*(6.60140018491395e-18*fs - 1.89303009112152e-14) + fs*(-2.06469324932415e-16*pow(fs,2) + 7.87887479009986e-12)) + Treble_L*fs*(1.47478089237439e-15*pow(fs,2) - 3.34417435912558e-13) + fs*(-1.47478089237439e-15*pow(fs,2) + 3.34417435912558e-13));

    b4 = Volume_L*(Bass_L*(Treble_L*pow(fs,3)*(1.17882146159178e-17*fs - 7.85880974394511e-17) + fs*(fs*(fs*(-1.17882146159178e-17*fs + 2.07004392829875e-15) - 1.0070880757276e-11) + 6.70506959004678e-11)) + Middle_L*(Bass_L*pow(fs,2)*(fs*(-1.65035004622849e-18*fs + 9.46515045560758e-15) - 6.30276541464398e-14) + fs*(fs*(1.03234662466208e-16*fs - 5.91603840340603e-13) + 3.93943739504993e-12)) + Treble_L*fs*(fs*(-7.37390446187197e-16*fs + 2.99972440013567e-14) - 1.67208717956279e-13) + fs*(fs*(7.37390446187197e-16*fs - 2.99972440013567e-14) + 1.67208717956279e-13));

    a0 = Bass_L*(Treble_L*(Treble_L*pow(fs,2)*(fs*(-6.53947709737567e-20*fs - 8.63258735389604e-18) - 9.72567351449023e-17) + fs*(fs*(fs*(5.86784894739014e-20*fs - 5.12285438072112e-16) - 6.87767642075504e-14) - 7.76108746456321e-13)) + fs*(fs*(fs*(2.95160491394304e-19*fs + 2.67064048181331e-15) + 3.79482593534319e-13) + 6.46231565548504e-12) + 2.61733091315125e-11) + Middle_L*(Bass_L*(Treble_L*(Treble_L*pow(fs,3)*(-4.86040672241183e-21*fs - 6.21913816572845e-20) + pow(fs,2)*(fs*(6.80456941137657e-21*fs - 3.86989777105262e-17) - 4.9628722562513e-16)) + fs*(fs*(fs*(2.8158557055486e-20*fs + 2.16252174019074e-16) + 4.38213044301358e-15) + 1.99261186829939e-14)) + Treble_L*(Treble_L*pow(fs,2)*(-3.04033952423208e-19*fs - 3.89026940579609e-18) + fs*(fs*(4.25647533392492e-19*fs - 2.42268872585805e-15) - 3.10692264109157e-14)) + fs*(fs*(1.76140761155593e-18*fs + 1.35192183493901e-14) + 2.58417996561413e-13) + 1.0469323652605e-12) + Treble_L*(Treble_L*fs*(fs*(-4.09065163112436e-18*fs - 3.1996842386608e-16) - 3.26835558922325e-15) + fs*(fs*(3.67052678836745e-18*fs - 3.2490595714095e-14) - 2.55967413440181e-12) - 2.61733091315125e-11) + fs*(fs*(1.8463230738282e-17*fs + 1.6533269438527e-13) + 1.28277858723121e-11) + 1.30866545657562e-10;

    a1 = Bass_L*(Treble_L*(Treble_L*pow(fs,3)*(2.61579083895027e-19*fs + 1.72651747077921e-17) + fs*(pow(fs,2)*(-2.34713957895606e-19*fs + 1.02457087614422e-15) - 1.55221749291264e-12)) + fs*(pow(fs,2)*(-1.18064196557721e-18*fs - 5.34128096362661e-15) + 1.29246313109701e-11) + 1.0469323652605e-10) + Middle_L*(Bass_L*(Treble_L*(Treble_L*pow(fs,3)*(1.94416268896473e-20*fs + 1.24382763314569e-19) + pow(fs,3)*(-2.72182776455063e-20*fs + 7.73979554210525e-17)) + fs*(pow(fs,2)*(-1.12634228221944e-19*fs - 4.32504348038148e-16) + 3.98522373659879e-14)) + Treble_L*(6.08067904846417e-19*Treble_L*pow(fs,3) + fs*(-8.51295066784983e-19*pow(fs,2) - 6.21384528218315e-14)) + fs*(-3.52281522311187e-18*pow(fs,2) + 5.16835993122826e-13) + 4.187729461042e-12) + Treble_L*(Treble_L*fs*(8.18130326224871e-18*pow(fs,2) - 6.5367111784465e-15) + fs*(-7.3410535767349e-18*pow(fs,2) - 5.11934826880362e-12) - 1.0469323652605e-10) + fs*(-3.69264614765639e-17*pow(fs,2) + 2.56555717446241e-11) + 5.2346618263025e-10;

    a2 = Bass_L*(Treble_L*(Treble_L*pow(fs,2)*(-3.9236862584254e-19*pow(fs,2) + 1.94513470289805e-16) + pow(fs,2)*(3.52070936843408e-19*pow(fs,2) + 1.37553528415101e-13)) + pow(fs,2)*(1.77096294836582e-18*pow(fs,2) - 7.58965187068638e-13) + 1.57039854789075e-10) + Middle_L*(Bass_L*(Treble_L*(-2.9162440334471e-20*Treble_L*pow(fs,4) + pow(fs,2)*(4.08274164682594e-20*pow(fs,2) + 9.9257445125026e-16)) + pow(fs,2)*(1.68951342332916e-19*pow(fs,2) - 8.76426088602715e-15)) + Treble_L*(7.78053881159219e-18*Treble_L*pow(fs,2) + 4.84537745171611e-15*pow(fs,2)) - 2.70384366987801e-14*pow(fs,2) + 6.281594191563e-12) + Treble_L*(6.3993684773216e-16*Treble_L*pow(fs,2) + 6.498119142819e-14*pow(fs,2) - 1.57039854789075e-10) - 3.3066538877054e-13*pow(fs,2) + 7.85199273945375e-10;

    a3 = Bass_L*(Treble_L*(Treble_L*pow(fs,3)*(2.61579083895027e-19*fs - 1.72651747077921e-17) + fs*(pow(fs,2)*(-2.34713957895606e-19*fs - 1.02457087614422e-15) + 1.55221749291264e-12)) + fs*(pow(fs,2)*(-1.18064196557721e-18*fs + 5.34128096362661e-15) - 1.29246313109701e-11) + 1.0469323652605e-10) + Middle_L*(Bass_L*(Treble_L*(Treble_L*pow(fs,3)*(1.94416268896473e-20*fs - 1.24382763314569e-19) + pow(fs,3)*(-2.72182776455063e-20*fs - 7.73979554210525e-17)) + fs*(pow(fs,2)*(-1.12634228221944e-19*fs + 4.32504348038148e-16) - 3.98522373659879e-14)) + Treble_L*(-6.08067904846417e-19*Treble_L*pow(fs,3) + fs*(8.51295066784983e-19*pow(fs,2) + 6.21384528218315e-14)) + fs*(3.52281522311187e-18*pow(fs,2) - 5.16835993122826e-13) + 4.187729461042e-12) + Treble_L*(Treble_L*fs*(-8.18130326224871e-18*pow(fs,2) + 6.5367111784465e-15) + fs*(7.3410535767349e-18*pow(fs,2) + 5.11934826880362e-12) - 1.0469323652605e-10) + fs*(3.69264614765639e-17*pow(fs,2) - 2.56555717446241e-11) + 5.2346618263025e-10;

    a4 = Bass_L*(Treble_L*(Treble_L*pow(fs,2)*(fs*(-6.53947709737567e-20*fs + 8.63258735389604e-18) - 9.72567351449023e-17) + fs*(fs*(fs*(5.86784894739014e-20*fs + 5.12285438072112e-16) - 6.87767642075504e-14) + 7.76108746456321e-13)) + fs*(fs*(fs*(2.95160491394304e-19*fs - 2.67064048181331e-15) + 3.79482593534319e-13) - 6.46231565548504e-12) + 2.61733091315125e-11) + Middle_L*(Bass_L*(Treble_L*(Treble_L*pow(fs,3)*(-4.86040672241183e-21*fs + 6.21913816572845e-20) + pow(fs,2)*(fs*(6.80456941137657e-21*fs + 3.86989777105262e-17) - 4.9628722562513e-16)) + fs*(fs*(fs*(2.8158557055486e-20*fs - 2.16252174019074e-16) + 4.38213044301358e-15) - 1.99261186829939e-14)) + Treble_L*(Treble_L*pow(fs,2)*(3.04033952423208e-19*fs - 3.89026940579609e-18) + fs*(fs*(-4.25647533392492e-19*fs - 2.42268872585805e-15) + 3.10692264109157e-14)) + fs*(fs*(-1.76140761155593e-18*fs + 1.35192183493901e-14) - 2.58417996561413e-13) + 1.0469323652605e-12) + Treble_L*(Treble_L*fs*(fs*(4.09065163112436e-18*fs - 3.1996842386608e-16) + 3.26835558922325e-15) + fs*(fs*(-3.67052678836745e-18*fs - 3.2490595714095e-14) + 2.55967413440181e-12) - 2.61733091315125e-11) + fs*(fs*(-1.8463230738282e-17*fs + 1.6533269438527e-13) - 1.28277858723121e-11) + 1.30866545657562e-10;
};

normal_R = pre : fi.iir((b0/a0,b1/a0,b2/a0,b3/a0,b4/a0),(a1/a0,a2/a0,a3/a0,a4/a0)) : alembic_normclip with {
    LogPot(a, x) = ba.if(a, (exp(a * x) - 1) / (exp(a) - 1), x);
    Inverted(b, x) = ba.if(b, 1 - x, x);
    s = 0.993;
    fs = float(ma.SR);
    pre = _;


    Bass_R = vslider("Bass_R[name:Bass_R]", 0.5, 0, 1, 0.01) : Inverted(0) : LogPot(3) : si.smooth(s);


    Middle_R = vslider("Middle_R[name:Middle_R]", 0.5, 0, 1, 0.01) : Inverted(0) : si.smooth(s);

    Volume_R = vslider("Volume_R[name:Volume_R]", 0.5, 0, 1, 0.01) : Inverted(0) : LogPot(3) : si.smooth(s);


    Treble_R = vslider("Treble_R[name:Treble_R]", 0.5, 0, 1, 0.01) : Inverted(1) : si.smooth(s);

    b0 = Volume_R*(Bass_R*(Treble_R*pow(fs,3)*(1.17882146159178e-17*fs + 7.85880974394511e-17) + fs*(fs*(fs*(-1.17882146159178e-17*fs - 2.07004392829875e-15) - 1.0070880757276e-11) - 6.70506959004678e-11)) + Middle_R*(Bass_R*pow(fs,2)*(fs*(-1.65035004622849e-18*fs - 9.46515045560758e-15) - 6.30276541464398e-14) + fs*(fs*(-1.03234662466208e-16*fs - 5.91603840340603e-13) - 3.93943739504993e-12)) + Treble_R*fs*(fs*(7.37390446187197e-16*fs + 2.99972440013567e-14) + 1.67208717956279e-13) + fs*(fs*(-7.37390446187197e-16*fs - 2.99972440013567e-14) - 1.67208717956279e-13));

    b1 = Volume_R*(Bass_R*(Treble_R*pow(fs,3)*(-4.71528584636711e-17*fs - 1.57176194878902e-16) + fs*(pow(fs,2)*(4.71528584636711e-17*fs + 4.1400878565975e-15) - 1.34101391800936e-10)) + Middle_R*(Bass_R*pow(fs,3)*(6.60140018491395e-18*fs + 1.89303009112152e-14) + fs*(2.06469324932415e-16*pow(fs,2) - 7.87887479009986e-12)) + Treble_R*fs*(-1.47478089237439e-15*pow(fs,2) + 3.34417435912558e-13) + fs*(1.47478089237439e-15*pow(fs,2) - 3.34417435912558e-13));

    b2 = Volume_R*(Bass_R*(7.07292876955067e-17*Treble_R*pow(fs,4) + pow(fs,2)*(-7.07292876955067e-17*pow(fs,2) + 2.0141761514552e-11)) + Middle_R*(Bass_R*pow(fs,2)*(-9.90210027737093e-18*pow(fs,2) + 1.2605530829288e-13) + 1.18320768068121e-12*pow(fs,2)) - 5.99944880027134e-14*Treble_R*pow(fs,2) + 5.99944880027134e-14*pow(fs,2));

    b3 = Volume_R*(Bass_R*(Treble_R*pow(fs,3)*(-4.71528584636711e-17*fs + 1.57176194878902e-16) + fs*(pow(fs,2)*(4.71528584636711e-17*fs - 4.1400878565975e-15) + 1.34101391800936e-10)) + Middle_R*(Bass_R*pow(fs,3)*(6.60140018491395e-18*fs - 1.89303009112152e-14) + fs*(-2.06469324932415e-16*pow(fs,2) + 7.87887479009986e-12)) + Treble_R*fs*(1.47478089237439e-15*pow(fs,2) - 3.34417435912558e-13) + fs*(-1.47478089237439e-15*pow(fs,2) + 3.34417435912558e-13));

    b4 = Volume_R*(Bass_R*(Treble_R*pow(fs,3)*(1.17882146159178e-17*fs - 7.85880974394511e-17) + fs*(fs*(fs*(-1.17882146159178e-17*fs + 2.07004392829875e-15) - 1.0070880757276e-11) + 6.70506959004678e-11)) + Middle_R*(Bass_R*pow(fs,2)*(fs*(-1.65035004622849e-18*fs + 9.46515045560758e-15) - 6.30276541464398e-14) + fs*(fs*(1.03234662466208e-16*fs - 5.91603840340603e-13) + 3.93943739504993e-12)) + Treble_R*fs*(fs*(-7.37390446187197e-16*fs + 2.99972440013567e-14) - 1.67208717956279e-13) + fs*(fs*(7.37390446187197e-16*fs - 2.99972440013567e-14) + 1.67208717956279e-13));

    a0 = Bass_R*(Treble_R*(Treble_R*pow(fs,2)*(fs*(-6.53947709737567e-20*fs - 8.63258735389604e-18) - 9.72567351449023e-17) + fs*(fs*(fs*(5.86784894739014e-20*fs - 5.12285438072112e-16) - 6.87767642075504e-14) - 7.76108746456321e-13)) + fs*(fs*(fs*(2.95160491394304e-19*fs + 2.67064048181331e-15) + 3.79482593534319e-13) + 6.46231565548504e-12) + 2.61733091315125e-11) + Middle_R*(Bass_R*(Treble_R*(Treble_R*pow(fs,3)*(-4.86040672241183e-21*fs - 6.21913816572845e-20) + pow(fs,2)*(fs*(6.80456941137657e-21*fs - 3.86989777105262e-17) - 4.9628722562513e-16)) + fs*(fs*(fs*(2.8158557055486e-20*fs + 2.16252174019074e-16) + 4.38213044301358e-15) + 1.99261186829939e-14)) + Treble_R*(Treble_R*pow(fs,2)*(-3.04033952423208e-19*fs - 3.89026940579609e-18) + fs*(fs*(4.25647533392492e-19*fs - 2.42268872585805e-15) - 3.10692264109157e-14)) + fs*(fs*(1.76140761155593e-18*fs + 1.35192183493901e-14) + 2.58417996561413e-13) + 1.0469323652605e-12) + Treble_R*(Treble_R*fs*(fs*(-4.09065163112436e-18*fs - 3.1996842386608e-16) - 3.26835558922325e-15) + fs*(fs*(3.67052678836745e-18*fs - 3.2490595714095e-14) - 2.55967413440181e-12) - 2.61733091315125e-11) + fs*(fs*(1.8463230738282e-17*fs + 1.6533269438527e-13) + 1.28277858723121e-11) + 1.30866545657562e-10;

    a1 = Bass_R*(Treble_R*(Treble_R*pow(fs,3)*(2.61579083895027e-19*fs + 1.72651747077921e-17) + fs*(pow(fs,2)*(-2.34713957895606e-19*fs + 1.02457087614422e-15) - 1.55221749291264e-12)) + fs*(pow(fs,2)*(-1.18064196557721e-18*fs - 5.34128096362661e-15) + 1.29246313109701e-11) + 1.0469323652605e-10) + Middle_R*(Bass_R*(Treble_R*(Treble_R*pow(fs,3)*(1.94416268896473e-20*fs + 1.24382763314569e-19) + pow(fs,3)*(-2.72182776455063e-20*fs + 7.73979554210525e-17)) + fs*(pow(fs,2)*(-1.12634228221944e-19*fs - 4.32504348038148e-16) + 3.98522373659879e-14)) + Treble_R*(6.08067904846417e-19*Treble_R*pow(fs,3) + fs*(-8.51295066784983e-19*pow(fs,2) - 6.21384528218315e-14)) + fs*(-3.52281522311187e-18*pow(fs,2) + 5.16835993122826e-13) + 4.187729461042e-12) + Treble_R*(Treble_R*fs*(8.18130326224871e-18*pow(fs,2) - 6.5367111784465e-15) + fs*(-7.3410535767349e-18*pow(fs,2) - 5.11934826880362e-12) - 1.0469323652605e-10) + fs*(-3.69264614765639e-17*pow(fs,2) + 2.56555717446241e-11) + 5.2346618263025e-10;

    a2 = Bass_R*(Treble_R*(Treble_R*pow(fs,2)*(-3.9236862584254e-19*pow(fs,2) + 1.94513470289805e-16) + pow(fs,2)*(3.52070936843408e-19*pow(fs,2) + 1.37553528415101e-13)) + pow(fs,2)*(1.77096294836582e-18*pow(fs,2) - 7.58965187068638e-13) + 1.57039854789075e-10) + Middle_R*(Bass_R*(Treble_R*(-2.9162440334471e-20*Treble_R*pow(fs,4) + pow(fs,2)*(4.08274164682594e-20*pow(fs,2) + 9.9257445125026e-16)) + pow(fs,2)*(1.68951342332916e-19*pow(fs,2) - 8.76426088602715e-15)) + Treble_R*(7.78053881159219e-18*Treble_R*pow(fs,2) + 4.84537745171611e-15*pow(fs,2)) - 2.70384366987801e-14*pow(fs,2) + 6.281594191563e-12) + Treble_R*(6.3993684773216e-16*Treble_R*pow(fs,2) + 6.498119142819e-14*pow(fs,2) - 1.57039854789075e-10) - 3.3066538877054e-13*pow(fs,2) + 7.85199273945375e-10;

    a3 = Bass_R*(Treble_R*(Treble_R*pow(fs,3)*(2.61579083895027e-19*fs - 1.72651747077921e-17) + fs*(pow(fs,2)*(-2.34713957895606e-19*fs - 1.02457087614422e-15) + 1.55221749291264e-12)) + fs*(pow(fs,2)*(-1.18064196557721e-18*fs + 5.34128096362661e-15) - 1.29246313109701e-11) + 1.0469323652605e-10) + Middle_R*(Bass_R*(Treble_R*(Treble_R*pow(fs,3)*(1.94416268896473e-20*fs - 1.24382763314569e-19) + pow(fs,3)*(-2.72182776455063e-20*fs - 7.73979554210525e-17)) + fs*(pow(fs,2)*(-1.12634228221944e-19*fs + 4.32504348038148e-16) - 3.98522373659879e-14)) + Treble_R*(-6.08067904846417e-19*Treble_R*pow(fs,3) + fs*(8.51295066784983e-19*pow(fs,2) + 6.21384528218315e-14)) + fs*(3.52281522311187e-18*pow(fs,2) - 5.16835993122826e-13) + 4.187729461042e-12) + Treble_R*(Treble_R*fs*(-8.18130326224871e-18*pow(fs,2) + 6.5367111784465e-15) + fs*(7.3410535767349e-18*pow(fs,2) + 5.11934826880362e-12) - 1.0469323652605e-10) + fs*(3.69264614765639e-17*pow(fs,2) - 2.56555717446241e-11) + 5.2346618263025e-10;

    a4 = Bass_R*(Treble_R*(Treble_R*pow(fs,2)*(fs*(-6.53947709737567e-20*fs + 8.63258735389604e-18) - 9.72567351449023e-17) + fs*(fs*(fs*(5.86784894739014e-20*fs + 5.12285438072112e-16) - 6.87767642075504e-14) + 7.76108746456321e-13)) + fs*(fs*(fs*(2.95160491394304e-19*fs - 2.67064048181331e-15) + 3.79482593534319e-13) - 6.46231565548504e-12) + 2.61733091315125e-11) + Middle_R*(Bass_R*(Treble_R*(Treble_R*pow(fs,3)*(-4.86040672241183e-21*fs + 6.21913816572845e-20) + pow(fs,2)*(fs*(6.80456941137657e-21*fs + 3.86989777105262e-17) - 4.9628722562513e-16)) + fs*(fs*(fs*(2.8158557055486e-20*fs - 2.16252174019074e-16) + 4.38213044301358e-15) - 1.99261186829939e-14)) + Treble_R*(Treble_R*pow(fs,2)*(3.04033952423208e-19*fs - 3.89026940579609e-18) + fs*(fs*(-4.25647533392492e-19*fs - 2.42268872585805e-15) + 3.10692264109157e-14)) + fs*(fs*(-1.76140761155593e-18*fs + 1.35192183493901e-14) - 2.58417996561413e-13) + 1.0469323652605e-12) + Treble_R*(Treble_R*fs*(fs*(4.09065163112436e-18*fs - 3.1996842386608e-16) + 3.26835558922325e-15) + fs*(fs*(-3.67052678836745e-18*fs - 3.2490595714095e-14) + 2.55967413440181e-12) - 2.61733091315125e-11) + fs*(fs*(-1.8463230738282e-17*fs + 1.6533269438527e-13) - 1.28277858723121e-11) + 1.30866545657562e-10;
};

alembic_normclip = _<: ba.if(signbit(_), alembic_norm_neg_clip, alembic_norm_clip) :>_ with {

    signbit = ffunction(int signbit(float), "math.h", "");

    alembic_norm_clip = ffunction(float alembic_normclip(float), "alembic_norm_table.h", "");

    alembic_norm_neg_clip = ffunction(float alembic_norm_negclip(float), "alembic_norm_neg_table.h", "");

};

bright_L = pre : fi.iir((b0/a0,b1/a0,b2/a0,b3/a0,b4/a0,b5/a0),(a1/a0,a2/a0,a3/a0,a4/a0,a5/a0)) : alembic_briteclip with {
    LogPot(a, x) = ba.if(a, (exp(a * x) - 1) / (exp(a) - 1), x);
    Inverted(b, x) = ba.if(b, 1 - x, x);
    s = 0.993;
    fs = float(ma.SR);
    pre = _;

    Bass_L = vslider("Bass_L[name:Bass_L]", 0.5, 0, 1, 0.01) : Inverted(0) : LogPot(3) : si.smooth(s);

    Middle_L = vslider("Middle_L[name:Middle_L]", 0.5, 0, 1, 0.01) : Inverted(0) : si.smooth(s);

    Volume_L = vslider("Volume_L[name:Volume_L]", 0.5, 0, 1, 0.01) : Inverted(0) : LogPot(3) : si.smooth(s);


    Treble_L = vslider("Treble_L[name:Treble_L]", 0.5, 0, 1, 0.01) : Inverted(1) : si.smooth(s);

    b0 = Volume_L*(Bass_L*(Treble_L*pow(fs,3)*(fs*(6.91874396840722e-22*fs + 2.88742248281528e-18) + 1.92187332455754e-17) + fs*(fs*(fs*(fs*(-6.91874396840722e-22*fs - 3.00430509368582e-18) - 1.09731017637039e-15) - 2.46677102772048e-12) - 1.63972596414378e-11)) + Middle_L*(Bass_L*pow(fs,2)*(fs*(fs*(-9.68624155577011e-23*fs - 9.59122413860399e-19) - 2.31840345387224e-15) - 1.54134240629515e-14) + fs*(fs*(fs*(-6.05905322850301e-21*fs - 5.99684930400747e-17) - 1.44908038300355e-13) - 9.63390117586717e-13)) + Treble_L*fs*(fs*(fs*(4.32789516321643e-20*fs + 1.82089564663e-16) + 7.34564519198978e-15) + 4.08909217990967e-14) + Volume_L*(Bass_L*(Treble_L*pow(fs,4)*(-6.91874396840722e-22*fs - 4.6124959789381e-21) + pow(fs,2)*(fs*(fs*(6.91874396840722e-22*fs + 1.21495106849477e-19) + 5.91080564497569e-16) + 3.93534231394506e-15)) + Middle_L*(Bass_L*pow(fs,3)*(fs*(9.68624155577011e-23*fs + 5.55529015703311e-19) + 3.69922177510836e-18) + pow(fs,2)*(fs*(6.05905322850301e-21*fs + 3.47224379213122e-17) + 2.31213628220812e-16)) + Treble_L*pow(fs,2)*(fs*(-4.32789516321643e-20*fs - 1.76059952898192e-18) - 9.8138212317832e-18) + pow(fs,2)*(fs*(4.32789516321643e-20*fs + 1.76059952898192e-18) + 9.8138212317832e-18)) + fs*(fs*(fs*(-4.32789516321643e-20*fs - 1.82089564663e-16) - 7.34564519198978e-15) - 4.08909217990967e-14));

    b1 = Volume_L*(Bass_L*(Treble_L*pow(fs,3)*(fs*(-3.45937198420361e-21*fs - 8.66226744844584e-18) - 1.92187332455754e-17) + fs*(fs*(fs*(fs*(3.45937198420361e-21*fs + 9.01291528105746e-18) + 1.09731017637039e-15) - 2.46677102772048e-12) - 4.91917789243133e-11)) + Middle_L*(Bass_L*pow(fs,2)*(fs*(fs*(4.84312077788506e-22*fs + 2.8773672415812e-18) + 2.31840345387224e-15) - 1.54134240629515e-14) + fs*(fs*(fs*(1.8177159685509e-20*fs + 5.99684930400747e-17) - 1.44908038300355e-13) - 2.89017035276015e-12)) + Treble_L*fs*(fs*(fs*(-1.29836854896493e-19*fs - 1.82089564663e-16) + 7.34564519198978e-15) + 1.2267276539729e-13) + Volume_L*(Bass_L*(Treble_L*pow(fs,4)*(3.45937198420361e-21*fs + 1.38374879368143e-20) + pow(fs,2)*(fs*(fs*(-3.45937198420361e-21*fs - 3.64485320548431e-19) - 5.91080564497569e-16) + 3.93534231394506e-15)) + Middle_L*(Bass_L*pow(fs,3)*(fs*(-4.84312077788506e-22*fs - 1.66658704710993e-18) - 3.69922177510836e-18) + pow(fs,2)*(fs*(-1.8177159685509e-20*fs - 3.47224379213122e-17) + 2.31213628220812e-16)) + Treble_L*pow(fs,2)*(fs*(1.29836854896493e-19*fs + 1.76059952898192e-18) - 9.8138212317832e-18) + pow(fs,2)*(fs*(-1.29836854896493e-19*fs - 1.76059952898192e-18) + 9.8138212317832e-18)) + fs*(fs*(fs*(1.29836854896493e-19*fs + 1.82089564663e-16) - 7.34564519198978e-15) - 1.2267276539729e-13));

    b2 = Volume_L*(Bass_L*(Treble_L*pow(fs,3)*(fs*(6.91874396840722e-21*fs + 5.77484496563056e-18) - 3.84374664911509e-17) + fs*(fs*(fs*(fs*(-6.91874396840722e-21*fs - 6.00861018737164e-18) + 2.19462035274078e-15) + 4.93354205544096e-12) - 3.27945192828755e-11)) + Middle_L*(Bass_L*pow(fs,2)*(fs*(fs*(-9.68624155577011e-22*fs - 1.9182448277208e-18) + 4.63680690774447e-15) + 3.0826848125903e-14) + fs*(fs*(fs*(-1.2118106457006e-20*fs + 1.19936986080149e-16) + 2.8981607660071e-13) - 1.92678023517343e-12)) + Treble_L*fs*(fs*(fs*(8.65579032643287e-20*fs - 3.64179129326e-16) - 1.46912903839796e-14) + 8.17818435981933e-14) + Volume_L*(Bass_L*(Treble_L*pow(fs,4)*(-6.91874396840722e-21*fs - 9.2249919578762e-21) + pow(fs,2)*(fs*(fs*(6.91874396840722e-21*fs + 2.42990213698954e-19) - 1.18216112899514e-15) - 7.87068462789012e-15)) + Middle_L*(Bass_L*pow(fs,3)*(fs*(9.68624155577011e-22*fs + 1.11105803140662e-18) - 7.39844355021672e-18) + pow(fs,2)*(fs*(1.2118106457006e-20*fs - 6.94448758426244e-17) - 4.62427256441624e-16)) + Treble_L*pow(fs,2)*(fs*(-8.65579032643287e-20*fs + 3.52119905796384e-18) + 1.96276424635664e-17) + pow(fs,2)*(fs*(8.65579032643287e-20*fs - 3.52119905796384e-18) - 1.96276424635664e-17)) + fs*(fs*(fs*(-8.65579032643287e-20*fs + 3.64179129326e-16) + 1.46912903839796e-14) - 8.17818435981933e-14));

    b3 = Volume_L*(Bass_L*(Treble_L*pow(fs,3)*(fs*(-6.91874396840722e-21*fs + 5.77484496563056e-18) + 3.84374664911509e-17) + fs*(fs*(fs*(fs*(6.91874396840722e-21*fs - 6.00861018737164e-18) - 2.19462035274078e-15) + 4.93354205544096e-12) + 3.27945192828755e-11)) + Middle_L*(Bass_L*pow(fs,2)*(fs*(fs*(9.68624155577011e-22*fs - 1.9182448277208e-18) - 4.63680690774447e-15) + 3.0826848125903e-14) + fs*(fs*(fs*(-1.2118106457006e-20*fs - 1.19936986080149e-16) + 2.8981607660071e-13) + 1.92678023517343e-12)) + Treble_L*fs*(fs*(fs*(8.65579032643287e-20*fs + 3.64179129326e-16) - 1.46912903839796e-14) - 8.17818435981933e-14) + Volume_L*(Bass_L*(Treble_L*pow(fs,4)*(6.91874396840722e-21*fs - 9.2249919578762e-21) + pow(fs,2)*(fs*(fs*(-6.91874396840722e-21*fs + 2.42990213698954e-19) + 1.18216112899514e-15) - 7.87068462789012e-15)) + Middle_L*(Bass_L*pow(fs,3)*(fs*(-9.68624155577011e-22*fs + 1.11105803140662e-18) + 7.39844355021672e-18) + pow(fs,2)*(fs*(1.2118106457006e-20*fs + 6.94448758426244e-17) - 4.62427256441624e-16)) + Treble_L*pow(fs,2)*(fs*(-8.65579032643287e-20*fs - 3.52119905796384e-18) + 1.96276424635664e-17) + pow(fs,2)*(fs*(8.65579032643287e-20*fs + 3.52119905796384e-18) - 1.96276424635664e-17)) + fs*(fs*(fs*(-8.65579032643287e-20*fs - 3.64179129326e-16) + 1.46912903839796e-14) + 8.17818435981933e-14));

    b4 = Volume_L*(Bass_L*(Treble_L*pow(fs,3)*(fs*(3.45937198420361e-21*fs - 8.66226744844584e-18) + 1.92187332455754e-17) + fs*(fs*(fs*(fs*(-3.45937198420361e-21*fs + 9.01291528105746e-18) - 1.09731017637039e-15) - 2.46677102772048e-12) + 4.91917789243133e-11)) + Middle_L*(Bass_L*pow(fs,2)*(fs*(fs*(-4.84312077788506e-22*fs + 2.8773672415812e-18) - 2.31840345387224e-15) - 1.54134240629515e-14) + fs*(fs*(fs*(1.8177159685509e-20*fs - 5.99684930400747e-17) - 1.44908038300355e-13) + 2.89017035276015e-12)) + Treble_L*fs*(fs*(fs*(-1.29836854896493e-19*fs + 1.82089564663e-16) + 7.34564519198978e-15) - 1.2267276539729e-13) + Volume_L*(Bass_L*(Treble_L*pow(fs,4)*(-3.45937198420361e-21*fs + 1.38374879368143e-20) + pow(fs,2)*(fs*(fs*(3.45937198420361e-21*fs - 3.64485320548431e-19) + 5.91080564497569e-16) + 3.93534231394506e-15)) + Middle_L*(Bass_L*pow(fs,3)*(fs*(4.84312077788506e-22*fs - 1.66658704710993e-18) + 3.69922177510836e-18) + pow(fs,2)*(fs*(-1.8177159685509e-20*fs + 3.47224379213122e-17) + 2.31213628220812e-16)) + Treble_L*pow(fs,2)*(fs*(1.29836854896493e-19*fs - 1.76059952898192e-18) - 9.8138212317832e-18) + pow(fs,2)*(fs*(-1.29836854896493e-19*fs + 1.76059952898192e-18) + 9.8138212317832e-18)) + fs*(fs*(fs*(1.29836854896493e-19*fs - 1.82089564663e-16) - 7.34564519198978e-15) + 1.2267276539729e-13));

    b5 = Volume_L*(Bass_L*(Treble_L*pow(fs,3)*(fs*(-6.91874396840722e-22*fs + 2.88742248281528e-18) - 1.92187332455754e-17) + fs*(fs*(fs*(fs*(6.91874396840722e-22*fs - 3.00430509368582e-18) + 1.09731017637039e-15) - 2.46677102772048e-12) + 1.63972596414378e-11)) + Middle_L*(Bass_L*pow(fs,2)*(fs*(fs*(9.68624155577011e-23*fs - 9.59122413860399e-19) + 2.31840345387224e-15) - 1.54134240629515e-14) + fs*(fs*(fs*(-6.05905322850301e-21*fs + 5.99684930400747e-17) - 1.44908038300355e-13) + 9.63390117586717e-13)) + Treble_L*fs*(fs*(fs*(4.32789516321643e-20*fs - 1.82089564663e-16) + 7.34564519198978e-15) - 4.08909217990967e-14) + Volume_L*(Bass_L*(Treble_L*pow(fs,4)*(6.91874396840722e-22*fs - 4.6124959789381e-21) + pow(fs,2)*(fs*(fs*(-6.91874396840722e-22*fs + 1.21495106849477e-19) - 5.91080564497569e-16) + 3.93534231394506e-15)) + Middle_L*(Bass_L*pow(fs,3)*(fs*(-9.68624155577011e-23*fs + 5.55529015703311e-19) - 3.69922177510836e-18) + pow(fs,2)*(fs*(6.05905322850301e-21*fs - 3.47224379213122e-17) + 2.31213628220812e-16)) + Treble_L*pow(fs,2)*(fs*(-4.32789516321643e-20*fs + 1.76059952898192e-18) - 9.8138212317832e-18) + pow(fs,2)*(fs*(4.32789516321643e-20*fs - 1.76059952898192e-18) + 9.8138212317832e-18)) + fs*(fs*(fs*(-4.32789516321643e-20*fs + 1.82089564663e-16) - 7.34564519198978e-15) + 4.08909217990967e-14));

    a0 = Bass_L*(Treble_L*(Treble_L*pow(fs,2)*(fs*(fs*(-3.83815344221861e-24*fs - 1.64989702525133e-20) - 2.11680921042765e-18) - 2.37841533602171e-17) + fs*(fs*(fs*(fs*(3.44396099549798e-24*fs - 1.57172472604439e-20) - 1.29316168998563e-16) - 1.68649232502658e-14) - 1.89797543814532e-13)) + fs*(fs*(fs*(fs*(3.9419244672063e-25*fs + 1.03020062404785e-19) + 6.59092588471003e-16) + 9.2998714565051e-14) + 1.58189673716889e-12) + 6.40068780224617e-12) + Middle_L*(Bass_L*(Treble_L*(Treble_L*pow(fs,3)*(fs*(-2.85267232541704e-25*fs - 1.19226360837823e-21) - 1.52089143936082e-20) + pow(fs,2)*(fs*(fs*(3.99374125558385e-25*fs - 6.07263463953272e-22) - 9.49297111470724e-18) - 1.21367136860993e-16)) + fs*(fs*(fs*(fs*(5.51869425408882e-26*fs + 1.04066508425183e-20) + 5.30246139994882e-17) + 1.0728203737318e-15) + 4.87293617171206e-15)) + Treble_L*(Treble_L*pow(fs,2)*(fs*(-1.78443758228215e-23*fs - 7.45798938006809e-20) - 9.51366134408682e-19) + fs*(fs*(fs*(2.49821261519501e-23*fs - 3.81003746381788e-20) - 5.94292545384613e-16) - 7.59798531833873e-15)) + fs*(fs*(fs*(3.45211938447258e-24*fs + 6.50953455217104e-19) + 3.31397583073083e-15) + 6.32576187894833e-14) + 2.56027512089847e-13) + Treble_L*(Treble_L*fs*(fs*(fs*(-2.40088747236654e-22*fs - 1.01914938263382e-18) - 7.84401701489674e-17) - 7.99276990472601e-16) + fs*(fs*(fs*(2.15430751633278e-22*fs - 1.00931167420926e-18) - 8.09581504534201e-15) - 6.27504999577649e-13) - 6.40068780224617e-12) + Volume_L*(Bass_L*(Treble_L*(Treble_L*pow(fs,3)*(fs*(3.83815344221861e-24*fs + 5.06664243269087e-22) + 5.70819680645209e-21) + pow(fs,2)*(fs*(fs*(-3.44396099549798e-24*fs + 3.00670847416855e-20) + 4.03664924154006e-18) + 4.55514105154877e-17)) + fs*(fs*(fs*(fs*(1.65351911090363e-23*fs + 9.5068384229614e-20) + 1.02988983768651e-17) - 1.30486302011578e-17) - 1.53616507253908e-15)) + Middle_L*(Bass_L*(Treble_L*(Treble_L*pow(fs,4)*(2.85267232541704e-25*fs + 3.65013945446597e-24) + pow(fs,3)*(fs*(-3.99374125558385e-25*fs + 2.27132232044654e-21) + 2.91281128466384e-20)) + pow(fs,2)*(fs*(fs*(1.54230955969265e-24*fs + 5.65134377825805e-21) - 2.30032611736055e-20) - 1.1695046812109e-18)) + Treble_L*(Treble_L*pow(fs,3)*(1.78443758228215e-23*fs + 2.28327872258084e-22) + pow(fs,2)*(fs*(-2.49821261519501e-23*fs + 1.42192566937971e-19) + 1.82351647640129e-18)) + fs*(fs*(fs*(9.64763852233277e-23*fs + 3.53068929659391e-19) - 5.29245486955245e-19) - 6.14466029015632e-17)) + Treble_L*(Treble_L*pow(fs,2)*(fs*(2.40088747236654e-22*fs + 1.8779602481101e-20) + 1.91826477713424e-19) + fs*(fs*(fs*(-2.15430751633278e-22*fs + 1.90693980601459e-18) + 1.50232520281226e-16) + 1.53616507253908e-15)) + Volume_L*(Bass_L*pow(fs,2)*(fs*(fs*(-1.6929383555757e-23*fs - 1.25906879957409e-19) - 1.62857548261884e-17) - 1.83118953550983e-16) + Middle_L*(Bass_L*pow(fs,3)*(fs*(-1.59749650223354e-24*fs - 9.17181360088287e-21) - 1.17096473699268e-19) + pow(fs,2)*(fs*(-9.99285046078002e-23*fs - 5.73269784908691e-19) - 7.31891791891218e-18)) + fs*(fs*(fs*(-1.05898697136012e-21*fs - 7.77799604390716e-18) - 6.02464692946613e-16) - 6.14466029015632e-15)) + fs*(fs*(fs*(1.03432897575674e-21*fs + 5.85227663541147e-18) + 4.52040346187673e-16) + 4.60849521761724e-15)) + fs*(fs*(fs*(2.46579956033756e-23*fs + 6.44090677084358e-18) + 4.05825720651041e-14) + 3.13857383051234e-12) + 3.20034390112309e-11;

    a1 = Bass_L*(Treble_L*(Treble_L*pow(fs,2)*(fs*(fs*(1.91907672110931e-23*fs + 4.94969107575399e-20) + 2.11680921042765e-18) - 2.37841533602171e-17) + fs*(fs*(fs*(fs*(-1.72198049774899e-23*fs + 4.71517417813316e-20) + 1.29316168998563e-16) - 1.68649232502658e-14) - 5.69392631443596e-13)) + fs*(fs*(fs*(fs*(-1.97096223360315e-24*fs - 3.09060187214354e-19) - 6.59092588471003e-16) + 9.2998714565051e-14) + 4.74569021150667e-12) + 3.20034390112309e-11) + Middle_L*(Bass_L*(Treble_L*(Treble_L*pow(fs,3)*(fs*(1.42633616270852e-24*fs + 3.5767908251347e-21) + 1.52089143936082e-20) + pow(fs,2)*(fs*(fs*(-1.99687062779193e-24*fs + 1.82179039185982e-21) + 9.49297111470724e-18) - 1.21367136860993e-16)) + fs*(fs*(fs*(fs*(-2.75934712704441e-25*fs - 3.12199525275548e-20) - 5.30246139994882e-17) + 1.0728203737318e-15) + 1.46188085151362e-14)) + Treble_L*(Treble_L*pow(fs,2)*(fs*(5.35331274684644e-23*fs + 7.45798938006809e-20) - 9.51366134408682e-19) + fs*(fs*(fs*(-7.49463784558502e-23*fs + 3.81003746381788e-20) - 5.94292545384613e-16) - 2.27939559550162e-14)) + fs*(fs*(fs*(-1.03563581534178e-23*fs - 6.50953455217104e-19) + 3.31397583073083e-15) + 1.8977285636845e-13) + 1.28013756044923e-12) + Treble_L*(Treble_L*fs*(fs*(fs*(7.20266241709961e-22*fs + 1.01914938263382e-18) - 7.84401701489674e-17) - 2.3978309714178e-15) + fs*(fs*(fs*(-6.46292254899834e-22*fs + 1.00931167420926e-18) - 8.09581504534201e-15) - 1.88251499873295e-12) - 3.20034390112309e-11) + Volume_L*(Bass_L*(Treble_L*(Treble_L*pow(fs,3)*(fs*(-1.91907672110931e-23*fs - 1.51999272980726e-21) - 5.70819680645209e-21) + pow(fs,2)*(fs*(fs*(1.72198049774899e-23*fs - 9.02012542250564e-20) - 4.03664924154006e-18) + 4.55514105154877e-17)) + fs*(fs*(fs*(fs*(-8.26759555451817e-23*fs - 2.85205152688842e-19) - 1.02988983768651e-17) - 1.30486302011578e-17) - 4.60849521761724e-15)) + Middle_L*(Bass_L*(Treble_L*(Treble_L*pow(fs,4)*(-1.42633616270852e-24*fs - 1.09504183633979e-23) + pow(fs,3)*(fs*(1.99687062779193e-24*fs - 6.81396696133963e-21) - 2.91281128466384e-20)) + pow(fs,2)*(fs*(fs*(-7.71154779846327e-24*fs - 1.69540313347742e-20) + 2.30032611736055e-20) - 1.1695046812109e-18)) + Treble_L*(Treble_L*pow(fs,3)*(-5.35331274684644e-23*fs - 2.28327872258084e-22) + pow(fs,2)*(fs*(7.49463784558502e-23*fs - 1.42192566937971e-19) + 1.82351647640129e-18)) + fs*(fs*(fs*(-2.89429155669983e-22*fs - 3.53068929659391e-19) - 5.29245486955245e-19) - 1.8433980870469e-16)) + Treble_L*(Treble_L*pow(fs,2)*(fs*(-7.20266241709961e-22*fs - 1.8779602481101e-20) + 1.91826477713424e-19) + fs*(fs*(fs*(6.46292254899834e-22*fs - 1.90693980601459e-18) + 1.50232520281226e-16) + 4.60849521761724e-15)) + Volume_L*(Bass_L*pow(fs,2)*(fs*(fs*(8.46469177787849e-23*fs + 3.77720639872226e-19) + 1.62857548261884e-17) - 1.83118953550983e-16) + Middle_L*(Bass_L*pow(fs,3)*(fs*(7.98748251116771e-24*fs + 2.75154408026486e-20) + 1.17096473699268e-19) + pow(fs,2)*(fs*(2.99785513823401e-22*fs + 5.73269784908691e-19) - 7.31891791891218e-18)) + fs*(fs*(fs*(3.17696091408035e-21*fs + 7.77799604390716e-18) - 6.02464692946613e-16) - 1.8433980870469e-14)) + fs*(fs*(fs*(-3.10298692727022e-21*fs - 5.85227663541147e-18) + 4.52040346187673e-16) + 1.38254856528517e-14)) + fs*(fs*(fs*(-7.39739868101268e-23*fs - 6.44090677084358e-18) + 4.05825720651041e-14) + 9.41572149153703e-12) + 1.60017195056154e-10;

    a2 = Bass_L*(Treble_L*(Treble_L*pow(fs,2)*(fs*(fs*(-3.83815344221861e-23*fs - 3.29979405050266e-20) + 4.23361842085529e-18) + 4.75683067204341e-17) + fs*(fs*(fs*(fs*(3.44396099549798e-23*fs - 3.14344945208878e-20) + 2.58632337997126e-16) + 3.37298465005315e-14) - 3.79595087629064e-13)) + fs*(fs*(fs*(fs*(3.9419244672063e-24*fs + 2.06040124809569e-19) - 1.31818517694201e-15) - 1.85997429130102e-13) + 3.16379347433778e-12) + 6.40068780224617e-11) + Middle_L*(Bass_L*(Treble_L*(Treble_L*pow(fs,3)*(fs*(-2.85267232541704e-24*fs - 2.38452721675646e-21) + 3.04178287872164e-20) + pow(fs,2)*(fs*(fs*(3.99374125558385e-24*fs - 1.21452692790654e-21) + 1.89859422294145e-17) + 2.42734273721987e-16)) + fs*(fs*(fs*(fs*(5.51869425408882e-25*fs + 2.08133016850365e-20) - 1.06049227998976e-16) - 2.1456407474636e-15) + 9.74587234342413e-15)) + Treble_L*(Treble_L*pow(fs,2)*(fs*(-3.56887516456429e-23*fs + 1.49159787601362e-19) + 1.90273226881736e-18) + fs*(fs*(fs*(4.99642523039001e-23*fs + 7.62007492763576e-20) + 1.18858509076923e-15) - 1.51959706366775e-14)) + fs*(fs*(fs*(6.90423876894517e-24*fs - 1.30190691043421e-18) - 6.62795166146167e-15) + 1.26515237578967e-13) + 2.56027512089847e-12) + Treble_L*(Treble_L*fs*(fs*(fs*(-4.80177494473307e-22*fs + 2.03829876526765e-18) + 1.56880340297935e-16) - 1.5985539809452e-15) + fs*(fs*(fs*(4.30861503266556e-22*fs + 2.01862334841852e-18) + 1.6191630090684e-14) - 1.2550099991553e-12) - 6.40068780224617e-11) + Volume_L*(Bass_L*(Treble_L*(Treble_L*pow(fs,3)*(fs*(3.83815344221861e-23*fs + 1.01332848653817e-21) - 1.14163936129042e-20) + pow(fs,2)*(fs*(fs*(-3.44396099549798e-23*fs + 6.01341694833709e-20) - 8.07329848308013e-18) - 9.11028210309754e-17)) + fs*(fs*(fs*(fs*(1.65351911090363e-22*fs + 1.90136768459228e-19) - 2.05977967537302e-17) + 2.60972604023156e-17) - 3.07233014507816e-15)) + Middle_L*(Bass_L*(Treble_L*(Treble_L*pow(fs,4)*(2.85267232541704e-24*fs + 7.30027890893193e-24) + pow(fs,3)*(fs*(-3.99374125558385e-24*fs + 4.54264464089309e-21) - 5.82562256932768e-20)) + pow(fs,2)*(fs*(fs*(1.54230955969265e-23*fs + 1.13026875565161e-20) + 4.60065223472111e-20) + 2.33900936242179e-18)) + Treble_L*(Treble_L*pow(fs,3)*(3.56887516456429e-23*fs - 4.56655744516168e-22) + pow(fs,2)*(fs*(-4.99642523039001e-23*fs - 2.84385133875941e-19) - 3.64703295280259e-18)) + fs*(fs*(fs*(1.92952770446655e-22*fs - 7.06137859318782e-19) + 1.05849097391049e-18) - 1.22893205803126e-16)) + Treble_L*(Treble_L*pow(fs,2)*(fs*(4.80177494473307e-22*fs - 3.75592049622019e-20) - 3.83652955426848e-19) + fs*(fs*(fs*(-4.30861503266556e-22*fs - 3.81387961202917e-18) - 3.00465040562453e-16) + 3.07233014507816e-15)) + Volume_L*(Bass_L*pow(fs,2)*(fs*(fs*(-1.6929383555757e-22*fs - 2.51813759914817e-19) + 3.25715096523769e-17) + 3.66237907101966e-16) + Middle_L*(Bass_L*pow(fs,3)*(fs*(-1.59749650223354e-23*fs - 1.83436272017657e-20) + 2.34192947398536e-19) + pow(fs,2)*(fs*(-1.998570092156e-22*fs + 1.14653956981738e-18) + 1.46378358378244e-17)) + fs*(fs*(fs*(-2.11797394272023e-21*fs + 1.55559920878143e-17) + 1.20492938589323e-15) - 1.22893205803126e-14)) + fs*(fs*(fs*(2.06865795151348e-21*fs - 1.17045532708229e-17) - 9.04080692375347e-16) + 9.21699043523448e-15)) + fs*(fs*(fs*(4.93159912067512e-23*fs - 1.28818135416872e-17) - 8.11651441302083e-14) + 6.27714766102469e-12) + 3.20034390112308e-10;

    a3 = Bass_L*(Treble_L*(Treble_L*pow(fs,2)*(fs*(fs*(3.83815344221861e-23*fs - 3.29979405050266e-20) - 4.23361842085529e-18) + 4.75683067204341e-17) + fs*(fs*(fs*(fs*(-3.44396099549798e-23*fs - 3.14344945208878e-20) - 2.58632337997126e-16) + 3.37298465005315e-14) + 3.79595087629064e-13)) + fs*(fs*(fs*(fs*(-3.9419244672063e-24*fs + 2.06040124809569e-19) + 1.31818517694201e-15) - 1.85997429130102e-13) - 3.16379347433778e-12) + 6.40068780224617e-11) + Middle_L*(Bass_L*(Treble_L*(Treble_L*pow(fs,3)*(fs*(2.85267232541704e-24*fs - 2.38452721675646e-21) - 3.04178287872164e-20) + pow(fs,2)*(fs*(fs*(-3.99374125558385e-24*fs - 1.21452692790654e-21) - 1.89859422294145e-17) + 2.42734273721987e-16)) + fs*(fs*(fs*(fs*(-5.51869425408882e-25*fs + 2.08133016850365e-20) + 1.06049227998976e-16) - 2.1456407474636e-15) - 9.74587234342413e-15)) + Treble_L*(Treble_L*pow(fs,2)*(fs*(-3.56887516456429e-23*fs - 1.49159787601362e-19) + 1.90273226881736e-18) + fs*(fs*(fs*(4.99642523039001e-23*fs - 7.62007492763576e-20) + 1.18858509076923e-15) + 1.51959706366775e-14)) + fs*(fs*(fs*(6.90423876894517e-24*fs + 1.30190691043421e-18) - 6.62795166146167e-15) - 1.26515237578967e-13) + 2.56027512089847e-12) + Treble_L*(Treble_L*fs*(fs*(fs*(-4.80177494473307e-22*fs - 2.03829876526765e-18) + 1.56880340297935e-16) + 1.5985539809452e-15) + fs*(fs*(fs*(4.30861503266556e-22*fs - 2.01862334841852e-18) + 1.6191630090684e-14) + 1.2550099991553e-12) - 6.40068780224617e-11) + Volume_L*(Bass_L*(Treble_L*(Treble_L*pow(fs,3)*(fs*(-3.83815344221861e-23*fs + 1.01332848653817e-21) + 1.14163936129042e-20) + pow(fs,2)*(fs*(fs*(3.44396099549798e-23*fs + 6.01341694833709e-20) + 8.07329848308013e-18) - 9.11028210309754e-17)) + fs*(fs*(fs*(fs*(-1.65351911090363e-22*fs + 1.90136768459228e-19) + 2.05977967537302e-17) + 2.60972604023156e-17) + 3.07233014507816e-15)) + Middle_L*(Bass_L*(Treble_L*(Treble_L*pow(fs,4)*(-2.85267232541704e-24*fs + 7.30027890893193e-24) + pow(fs,3)*(fs*(3.99374125558385e-24*fs + 4.54264464089309e-21) + 5.82562256932768e-20)) + pow(fs,2)*(fs*(fs*(-1.54230955969265e-23*fs + 1.13026875565161e-20) - 4.60065223472111e-20) + 2.33900936242179e-18)) + Treble_L*(Treble_L*pow(fs,3)*(3.56887516456429e-23*fs + 4.56655744516168e-22) + pow(fs,2)*(fs*(-4.99642523039001e-23*fs + 2.84385133875941e-19) - 3.64703295280259e-18)) + fs*(fs*(fs*(1.92952770446655e-22*fs + 7.06137859318782e-19) + 1.05849097391049e-18) + 1.22893205803126e-16)) + Treble_L*(Treble_L*pow(fs,2)*(fs*(4.80177494473307e-22*fs + 3.75592049622019e-20) - 3.83652955426848e-19) + fs*(fs*(fs*(-4.30861503266556e-22*fs + 3.81387961202917e-18) - 3.00465040562453e-16) - 3.07233014507816e-15)) + Volume_L*(Bass_L*pow(fs,2)*(fs*(fs*(1.6929383555757e-22*fs - 2.51813759914817e-19) - 3.25715096523769e-17) + 3.66237907101966e-16) + Middle_L*(Bass_L*pow(fs,3)*(fs*(1.59749650223354e-23*fs - 1.83436272017657e-20) - 2.34192947398536e-19) + pow(fs,2)*(fs*(-1.998570092156e-22*fs - 1.14653956981738e-18) + 1.46378358378244e-17)) + fs*(fs*(fs*(-2.11797394272023e-21*fs - 1.55559920878143e-17) + 1.20492938589323e-15) + 1.22893205803126e-14)) + fs*(fs*(fs*(2.06865795151348e-21*fs + 1.17045532708229e-17) - 9.04080692375347e-16) - 9.21699043523448e-15)) + fs*(fs*(fs*(4.93159912067512e-23*fs + 1.28818135416872e-17) - 8.11651441302083e-14) - 6.27714766102469e-12) + 3.20034390112308e-10;

    a4 = Bass_L*(Treble_L*(Treble_L*pow(fs,2)*(fs*(fs*(-1.91907672110931e-23*fs + 4.94969107575399e-20) - 2.11680921042765e-18) - 2.37841533602171e-17) + fs*(fs*(fs*(fs*(1.72198049774899e-23*fs + 4.71517417813316e-20) - 1.29316168998563e-16) - 1.68649232502658e-14) + 5.69392631443596e-13)) + fs*(fs*(fs*(fs*(1.97096223360315e-24*fs - 3.09060187214354e-19) + 6.59092588471003e-16) + 9.2998714565051e-14) - 4.74569021150667e-12) + 3.20034390112309e-11) + Middle_L*(Bass_L*(Treble_L*(Treble_L*pow(fs,3)*(fs*(-1.42633616270852e-24*fs + 3.5767908251347e-21) - 1.52089143936082e-20) + pow(fs,2)*(fs*(fs*(1.99687062779193e-24*fs + 1.82179039185982e-21) - 9.49297111470724e-18) - 1.21367136860993e-16)) + fs*(fs*(fs*(fs*(2.75934712704441e-25*fs - 3.12199525275548e-20) + 5.30246139994882e-17) + 1.0728203737318e-15) - 1.46188085151362e-14)) + Treble_L*(Treble_L*pow(fs,2)*(fs*(5.35331274684644e-23*fs - 7.45798938006809e-20) - 9.51366134408682e-19) + fs*(fs*(fs*(-7.49463784558502e-23*fs - 3.81003746381788e-20) - 5.94292545384613e-16) + 2.27939559550162e-14)) + fs*(fs*(fs*(-1.03563581534178e-23*fs + 6.50953455217104e-19) + 3.31397583073083e-15) - 1.8977285636845e-13) + 1.28013756044923e-12) + Treble_L*(Treble_L*fs*(fs*(fs*(7.20266241709961e-22*fs - 1.01914938263382e-18) - 7.84401701489674e-17) + 2.3978309714178e-15) + fs*(fs*(fs*(-6.46292254899834e-22*fs - 1.00931167420926e-18) - 8.09581504534201e-15) + 1.88251499873295e-12) - 3.20034390112309e-11) + Volume_L*(Bass_L*(Treble_L*(Treble_L*pow(fs,3)*(fs*(1.91907672110931e-23*fs - 1.51999272980726e-21) + 5.70819680645209e-21) + pow(fs,2)*(fs*(fs*(-1.72198049774899e-23*fs - 9.02012542250564e-20) + 4.03664924154006e-18) + 4.55514105154877e-17)) + fs*(fs*(fs*(fs*(8.26759555451817e-23*fs - 2.85205152688842e-19) + 1.02988983768651e-17) - 1.30486302011578e-17) + 4.60849521761724e-15)) + Middle_L*(Bass_L*(Treble_L*(Treble_L*pow(fs,4)*(1.42633616270852e-24*fs - 1.09504183633979e-23) + pow(fs,3)*(fs*(-1.99687062779193e-24*fs - 6.81396696133963e-21) + 2.91281128466384e-20)) + pow(fs,2)*(fs*(fs*(7.71154779846327e-24*fs - 1.69540313347742e-20) - 2.30032611736055e-20) - 1.1695046812109e-18)) + Treble_L*(Treble_L*pow(fs,3)*(-5.35331274684644e-23*fs + 2.28327872258084e-22) + pow(fs,2)*(fs*(7.49463784558502e-23*fs + 1.42192566937971e-19) + 1.82351647640129e-18)) + fs*(fs*(fs*(-2.89429155669983e-22*fs + 3.53068929659391e-19) - 5.29245486955245e-19) + 1.8433980870469e-16)) + Treble_L*(Treble_L*pow(fs,2)*(fs*(-7.20266241709961e-22*fs + 1.8779602481101e-20) + 1.91826477713424e-19) + fs*(fs*(fs*(6.46292254899834e-22*fs + 1.90693980601459e-18) + 1.50232520281226e-16) - 4.60849521761724e-15)) + Volume_L*(Bass_L*pow(fs,2)*(fs*(fs*(-8.46469177787849e-23*fs + 3.77720639872226e-19) - 1.62857548261884e-17) - 1.83118953550983e-16) + Middle_L*(Bass_L*pow(fs,3)*(fs*(-7.98748251116771e-24*fs + 2.75154408026486e-20) - 1.17096473699268e-19) + pow(fs,2)*(fs*(2.99785513823401e-22*fs - 5.73269784908691e-19) - 7.31891791891218e-18)) + fs*(fs*(fs*(3.17696091408035e-21*fs - 7.77799604390716e-18) - 6.02464692946613e-16) + 1.8433980870469e-14)) + fs*(fs*(fs*(-3.10298692727022e-21*fs + 5.85227663541147e-18) + 4.52040346187673e-16) - 1.38254856528517e-14)) + fs*(fs*(fs*(-7.39739868101268e-23*fs + 6.44090677084358e-18) + 4.05825720651041e-14) - 9.41572149153703e-12) + 1.60017195056154e-10;

    a5 = Bass_L*(Treble_L*(Treble_L*pow(fs,2)*(fs*(fs*(3.83815344221861e-24*fs - 1.64989702525133e-20) + 2.11680921042765e-18) - 2.37841533602171e-17) + fs*(fs*(fs*(fs*(-3.44396099549798e-24*fs - 1.57172472604439e-20) + 1.29316168998563e-16) - 1.68649232502658e-14) + 1.89797543814532e-13)) + fs*(fs*(fs*(fs*(-3.9419244672063e-25*fs + 1.03020062404785e-19) - 6.59092588471003e-16) + 9.2998714565051e-14) - 1.58189673716889e-12) + 6.40068780224617e-12) + Middle_L*(Bass_L*(Treble_L*(Treble_L*pow(fs,3)*(fs*(2.85267232541704e-25*fs - 1.19226360837823e-21) + 1.52089143936082e-20) + pow(fs,2)*(fs*(fs*(-3.99374125558385e-25*fs - 6.07263463953272e-22) + 9.49297111470724e-18) - 1.21367136860993e-16)) + fs*(fs*(fs*(fs*(-5.51869425408882e-26*fs + 1.04066508425183e-20) - 5.30246139994882e-17) + 1.0728203737318e-15) - 4.87293617171206e-15)) + Treble_L*(Treble_L*pow(fs,2)*(fs*(-1.78443758228215e-23*fs + 7.45798938006809e-20) - 9.51366134408682e-19) + fs*(fs*(fs*(2.49821261519501e-23*fs + 3.81003746381788e-20) - 5.94292545384613e-16) + 7.59798531833873e-15)) + fs*(fs*(fs*(3.45211938447258e-24*fs - 6.50953455217104e-19) + 3.31397583073083e-15) - 6.32576187894833e-14) + 2.56027512089847e-13) + Treble_L*(Treble_L*fs*(fs*(fs*(-2.40088747236654e-22*fs + 1.01914938263382e-18) - 7.84401701489674e-17) + 7.99276990472601e-16) + fs*(fs*(fs*(2.15430751633278e-22*fs + 1.00931167420926e-18) - 8.09581504534201e-15) + 6.27504999577649e-13) - 6.40068780224617e-12) + Volume_L*(Bass_L*(Treble_L*(Treble_L*pow(fs,3)*(fs*(-3.83815344221861e-24*fs + 5.06664243269087e-22) - 5.70819680645209e-21) + pow(fs,2)*(fs*(fs*(3.44396099549798e-24*fs + 3.00670847416855e-20) - 4.03664924154006e-18) + 4.55514105154877e-17)) + fs*(fs*(fs*(fs*(-1.65351911090363e-23*fs + 9.5068384229614e-20) - 1.02988983768651e-17) - 1.30486302011578e-17) + 1.53616507253908e-15)) + Middle_L*(Bass_L*(Treble_L*(Treble_L*pow(fs,4)*(-2.85267232541704e-25*fs + 3.65013945446597e-24) + pow(fs,3)*(fs*(3.99374125558385e-25*fs + 2.27132232044654e-21) - 2.91281128466384e-20)) + pow(fs,2)*(fs*(fs*(-1.54230955969265e-24*fs + 5.65134377825805e-21) + 2.30032611736055e-20) - 1.1695046812109e-18)) + Treble_L*(Treble_L*pow(fs,3)*(1.78443758228215e-23*fs - 2.28327872258084e-22) + pow(fs,2)*(fs*(-2.49821261519501e-23*fs - 1.42192566937971e-19) + 1.82351647640129e-18)) + fs*(fs*(fs*(9.64763852233277e-23*fs - 3.53068929659391e-19) - 5.29245486955245e-19) + 6.14466029015632e-17)) + Treble_L*(Treble_L*pow(fs,2)*(fs*(2.40088747236654e-22*fs - 1.8779602481101e-20) + 1.91826477713424e-19) + fs*(fs*(fs*(-2.15430751633278e-22*fs - 1.90693980601459e-18) + 1.50232520281226e-16) - 1.53616507253908e-15)) + Volume_L*(Bass_L*pow(fs,2)*(fs*(fs*(1.6929383555757e-23*fs - 1.25906879957409e-19) + 1.62857548261884e-17) - 1.83118953550983e-16) + Middle_L*(Bass_L*pow(fs,3)*(fs*(1.59749650223354e-24*fs - 9.17181360088287e-21) + 1.17096473699268e-19) + pow(fs,2)*(fs*(-9.99285046078002e-23*fs + 5.73269784908691e-19) - 7.31891791891218e-18)) + fs*(fs*(fs*(-1.05898697136012e-21*fs + 7.77799604390716e-18) - 6.02464692946613e-16) + 6.14466029015632e-15)) + fs*(fs*(fs*(1.03432897575674e-21*fs - 5.85227663541147e-18) + 4.52040346187673e-16) - 4.60849521761724e-15)) + fs*(fs*(fs*(2.46579956033756e-23*fs - 6.44090677084358e-18) + 4.05825720651041e-14) - 3.13857383051234e-12) + 3.20034390112309e-11;
};

bright_R = pre : fi.iir((b0/a0,b1/a0,b2/a0,b3/a0,b4/a0,b5/a0),(a1/a0,a2/a0,a3/a0,a4/a0,a5/a0)) : alembic_briteclip with {
    LogPot(a, x) = ba.if(a, (exp(a * x) - 1) / (exp(a) - 1), x);
    Inverted(b, x) = ba.if(b, 1 - x, x);
    s = 0.993;
    fs = float(ma.SR);
    pre = _;

    Bass_R = vslider("Bass_R[name:Bass_R]", 0.5, 0, 1, 0.01) : Inverted(0) : LogPot(3) : si.smooth(s);

    Middle_R = vslider("Middle_R[name:Middle_R]", 0.5, 0, 1, 0.01) : Inverted(0) : si.smooth(s);

    Volume_R = vslider("Volume_R[name:Volume_R]", 0.5, 0, 1, 0.01) : Inverted(0) : LogPot(3) : si.smooth(s);


    Treble_R = vslider("Treble_R[name:Treble_R]", 0.5, 0, 1, 0.01) : Inverted(1) : si.smooth(s);

    b0 = Volume_R*(Bass_R*(Treble_R*pow(fs,3)*(fs*(6.91874396840722e-22*fs + 2.88742248281528e-18) + 1.92187332455754e-17) + fs*(fs*(fs*(fs*(-6.91874396840722e-22*fs - 3.00430509368582e-18) - 1.09731017637039e-15) - 2.46677102772048e-12) - 1.63972596414378e-11)) + Middle_R*(Bass_R*pow(fs,2)*(fs*(fs*(-9.68624155577011e-23*fs - 9.59122413860399e-19) - 2.31840345387224e-15) - 1.54134240629515e-14) + fs*(fs*(fs*(-6.05905322850301e-21*fs - 5.99684930400747e-17) - 1.44908038300355e-13) - 9.63390117586717e-13)) + Treble_R*fs*(fs*(fs*(4.32789516321643e-20*fs + 1.82089564663e-16) + 7.34564519198978e-15) + 4.08909217990967e-14) + Volume_R*(Bass_R*(Treble_R*pow(fs,4)*(-6.91874396840722e-22*fs - 4.6124959789381e-21) + pow(fs,2)*(fs*(fs*(6.91874396840722e-22*fs + 1.21495106849477e-19) + 5.91080564497569e-16) + 3.93534231394506e-15)) + Middle_R*(Bass_R*pow(fs,3)*(fs*(9.68624155577011e-23*fs + 5.55529015703311e-19) + 3.69922177510836e-18) + pow(fs,2)*(fs*(6.05905322850301e-21*fs + 3.47224379213122e-17) + 2.31213628220812e-16)) + Treble_R*pow(fs,2)*(fs*(-4.32789516321643e-20*fs - 1.76059952898192e-18) - 9.8138212317832e-18) + pow(fs,2)*(fs*(4.32789516321643e-20*fs + 1.76059952898192e-18) + 9.8138212317832e-18)) + fs*(fs*(fs*(-4.32789516321643e-20*fs - 1.82089564663e-16) - 7.34564519198978e-15) - 4.08909217990967e-14));

    b1 = Volume_R*(Bass_R*(Treble_R*pow(fs,3)*(fs*(-3.45937198420361e-21*fs - 8.66226744844584e-18) - 1.92187332455754e-17) + fs*(fs*(fs*(fs*(3.45937198420361e-21*fs + 9.01291528105746e-18) + 1.09731017637039e-15) - 2.46677102772048e-12) - 4.91917789243133e-11)) + Middle_R*(Bass_R*pow(fs,2)*(fs*(fs*(4.84312077788506e-22*fs + 2.8773672415812e-18) + 2.31840345387224e-15) - 1.54134240629515e-14) + fs*(fs*(fs*(1.8177159685509e-20*fs + 5.99684930400747e-17) - 1.44908038300355e-13) - 2.89017035276015e-12)) + Treble_R*fs*(fs*(fs*(-1.29836854896493e-19*fs - 1.82089564663e-16) + 7.34564519198978e-15) + 1.2267276539729e-13) + Volume_R*(Bass_R*(Treble_R*pow(fs,4)*(3.45937198420361e-21*fs + 1.38374879368143e-20) + pow(fs,2)*(fs*(fs*(-3.45937198420361e-21*fs - 3.64485320548431e-19) - 5.91080564497569e-16) + 3.93534231394506e-15)) + Middle_R*(Bass_R*pow(fs,3)*(fs*(-4.84312077788506e-22*fs - 1.66658704710993e-18) - 3.69922177510836e-18) + pow(fs,2)*(fs*(-1.8177159685509e-20*fs - 3.47224379213122e-17) + 2.31213628220812e-16)) + Treble_R*pow(fs,2)*(fs*(1.29836854896493e-19*fs + 1.76059952898192e-18) - 9.8138212317832e-18) + pow(fs,2)*(fs*(-1.29836854896493e-19*fs - 1.76059952898192e-18) + 9.8138212317832e-18)) + fs*(fs*(fs*(1.29836854896493e-19*fs + 1.82089564663e-16) - 7.34564519198978e-15) - 1.2267276539729e-13));

    b2 = Volume_R*(Bass_R*(Treble_R*pow(fs,3)*(fs*(6.91874396840722e-21*fs + 5.77484496563056e-18) - 3.84374664911509e-17) + fs*(fs*(fs*(fs*(-6.91874396840722e-21*fs - 6.00861018737164e-18) + 2.19462035274078e-15) + 4.93354205544096e-12) - 3.27945192828755e-11)) + Middle_R*(Bass_R*pow(fs,2)*(fs*(fs*(-9.68624155577011e-22*fs - 1.9182448277208e-18) + 4.63680690774447e-15) + 3.0826848125903e-14) + fs*(fs*(fs*(-1.2118106457006e-20*fs + 1.19936986080149e-16) + 2.8981607660071e-13) - 1.92678023517343e-12)) + Treble_R*fs*(fs*(fs*(8.65579032643287e-20*fs - 3.64179129326e-16) - 1.46912903839796e-14) + 8.17818435981933e-14) + Volume_R*(Bass_R*(Treble_R*pow(fs,4)*(-6.91874396840722e-21*fs - 9.2249919578762e-21) + pow(fs,2)*(fs*(fs*(6.91874396840722e-21*fs + 2.42990213698954e-19) - 1.18216112899514e-15) - 7.87068462789012e-15)) + Middle_R*(Bass_R*pow(fs,3)*(fs*(9.68624155577011e-22*fs + 1.11105803140662e-18) - 7.39844355021672e-18) + pow(fs,2)*(fs*(1.2118106457006e-20*fs - 6.94448758426244e-17) - 4.62427256441624e-16)) + Treble_R*pow(fs,2)*(fs*(-8.65579032643287e-20*fs + 3.52119905796384e-18) + 1.96276424635664e-17) + pow(fs,2)*(fs*(8.65579032643287e-20*fs - 3.52119905796384e-18) - 1.96276424635664e-17)) + fs*(fs*(fs*(-8.65579032643287e-20*fs + 3.64179129326e-16) + 1.46912903839796e-14) - 8.17818435981933e-14));

    b3 = Volume_R*(Bass_R*(Treble_R*pow(fs,3)*(fs*(-6.91874396840722e-21*fs + 5.77484496563056e-18) + 3.84374664911509e-17) + fs*(fs*(fs*(fs*(6.91874396840722e-21*fs - 6.00861018737164e-18) - 2.19462035274078e-15) + 4.93354205544096e-12) + 3.27945192828755e-11)) + Middle_R*(Bass_R*pow(fs,2)*(fs*(fs*(9.68624155577011e-22*fs - 1.9182448277208e-18) - 4.63680690774447e-15) + 3.0826848125903e-14) + fs*(fs*(fs*(-1.2118106457006e-20*fs - 1.19936986080149e-16) + 2.8981607660071e-13) + 1.92678023517343e-12)) + Treble_R*fs*(fs*(fs*(8.65579032643287e-20*fs + 3.64179129326e-16) - 1.46912903839796e-14) - 8.17818435981933e-14) + Volume_R*(Bass_R*(Treble_R*pow(fs,4)*(6.91874396840722e-21*fs - 9.2249919578762e-21) + pow(fs,2)*(fs*(fs*(-6.91874396840722e-21*fs + 2.42990213698954e-19) + 1.18216112899514e-15) - 7.87068462789012e-15)) + Middle_R*(Bass_R*pow(fs,3)*(fs*(-9.68624155577011e-22*fs + 1.11105803140662e-18) + 7.39844355021672e-18) + pow(fs,2)*(fs*(1.2118106457006e-20*fs + 6.94448758426244e-17) - 4.62427256441624e-16)) + Treble_R*pow(fs,2)*(fs*(-8.65579032643287e-20*fs - 3.52119905796384e-18) + 1.96276424635664e-17) + pow(fs,2)*(fs*(8.65579032643287e-20*fs + 3.52119905796384e-18) - 1.96276424635664e-17)) + fs*(fs*(fs*(-8.65579032643287e-20*fs - 3.64179129326e-16) + 1.46912903839796e-14) + 8.17818435981933e-14));

    b4 = Volume_R*(Bass_R*(Treble_R*pow(fs,3)*(fs*(3.45937198420361e-21*fs - 8.66226744844584e-18) + 1.92187332455754e-17) + fs*(fs*(fs*(fs*(-3.45937198420361e-21*fs + 9.01291528105746e-18) - 1.09731017637039e-15) - 2.46677102772048e-12) + 4.91917789243133e-11)) + Middle_R*(Bass_R*pow(fs,2)*(fs*(fs*(-4.84312077788506e-22*fs + 2.8773672415812e-18) - 2.31840345387224e-15) - 1.54134240629515e-14) + fs*(fs*(fs*(1.8177159685509e-20*fs - 5.99684930400747e-17) - 1.44908038300355e-13) + 2.89017035276015e-12)) + Treble_R*fs*(fs*(fs*(-1.29836854896493e-19*fs + 1.82089564663e-16) + 7.34564519198978e-15) - 1.2267276539729e-13) + Volume_R*(Bass_R*(Treble_R*pow(fs,4)*(-3.45937198420361e-21*fs + 1.38374879368143e-20) + pow(fs,2)*(fs*(fs*(3.45937198420361e-21*fs - 3.64485320548431e-19) + 5.91080564497569e-16) + 3.93534231394506e-15)) + Middle_R*(Bass_R*pow(fs,3)*(fs*(4.84312077788506e-22*fs - 1.66658704710993e-18) + 3.69922177510836e-18) + pow(fs,2)*(fs*(-1.8177159685509e-20*fs + 3.47224379213122e-17) + 2.31213628220812e-16)) + Treble_R*pow(fs,2)*(fs*(1.29836854896493e-19*fs - 1.76059952898192e-18) - 9.8138212317832e-18) + pow(fs,2)*(fs*(-1.29836854896493e-19*fs + 1.76059952898192e-18) + 9.8138212317832e-18)) + fs*(fs*(fs*(1.29836854896493e-19*fs - 1.82089564663e-16) - 7.34564519198978e-15) + 1.2267276539729e-13));

    b5 = Volume_R*(Bass_R*(Treble_R*pow(fs,3)*(fs*(-6.91874396840722e-22*fs + 2.88742248281528e-18) - 1.92187332455754e-17) + fs*(fs*(fs*(fs*(6.91874396840722e-22*fs - 3.00430509368582e-18) + 1.09731017637039e-15) - 2.46677102772048e-12) + 1.63972596414378e-11)) + Middle_R*(Bass_R*pow(fs,2)*(fs*(fs*(9.68624155577011e-23*fs - 9.59122413860399e-19) + 2.31840345387224e-15) - 1.54134240629515e-14) + fs*(fs*(fs*(-6.05905322850301e-21*fs + 5.99684930400747e-17) - 1.44908038300355e-13) + 9.63390117586717e-13)) + Treble_R*fs*(fs*(fs*(4.32789516321643e-20*fs - 1.82089564663e-16) + 7.34564519198978e-15) - 4.08909217990967e-14) + Volume_R*(Bass_R*(Treble_R*pow(fs,4)*(6.91874396840722e-22*fs - 4.6124959789381e-21) + pow(fs,2)*(fs*(fs*(-6.91874396840722e-22*fs + 1.21495106849477e-19) - 5.91080564497569e-16) + 3.93534231394506e-15)) + Middle_R*(Bass_R*pow(fs,3)*(fs*(-9.68624155577011e-23*fs + 5.55529015703311e-19) - 3.69922177510836e-18) + pow(fs,2)*(fs*(6.05905322850301e-21*fs - 3.47224379213122e-17) + 2.31213628220812e-16)) + Treble_R*pow(fs,2)*(fs*(-4.32789516321643e-20*fs + 1.76059952898192e-18) - 9.8138212317832e-18) + pow(fs,2)*(fs*(4.32789516321643e-20*fs - 1.76059952898192e-18) + 9.8138212317832e-18)) + fs*(fs*(fs*(-4.32789516321643e-20*fs + 1.82089564663e-16) - 7.34564519198978e-15) + 4.08909217990967e-14));

    a0 = Bass_R*(Treble_R*(Treble_R*pow(fs,2)*(fs*(fs*(-3.83815344221861e-24*fs - 1.64989702525133e-20) - 2.11680921042765e-18) - 2.37841533602171e-17) + fs*(fs*(fs*(fs*(3.44396099549798e-24*fs - 1.57172472604439e-20) - 1.29316168998563e-16) - 1.68649232502658e-14) - 1.89797543814532e-13)) + fs*(fs*(fs*(fs*(3.9419244672063e-25*fs + 1.03020062404785e-19) + 6.59092588471003e-16) + 9.2998714565051e-14) + 1.58189673716889e-12) + 6.40068780224617e-12) + Middle_R*(Bass_R*(Treble_R*(Treble_R*pow(fs,3)*(fs*(-2.85267232541704e-25*fs - 1.19226360837823e-21) - 1.52089143936082e-20) + pow(fs,2)*(fs*(fs*(3.99374125558385e-25*fs - 6.07263463953272e-22) - 9.49297111470724e-18) - 1.21367136860993e-16)) + fs*(fs*(fs*(fs*(5.51869425408882e-26*fs + 1.04066508425183e-20) + 5.30246139994882e-17) + 1.0728203737318e-15) + 4.87293617171206e-15)) + Treble_R*(Treble_R*pow(fs,2)*(fs*(-1.78443758228215e-23*fs - 7.45798938006809e-20) - 9.51366134408682e-19) + fs*(fs*(fs*(2.49821261519501e-23*fs - 3.81003746381788e-20) - 5.94292545384613e-16) - 7.59798531833873e-15)) + fs*(fs*(fs*(3.45211938447258e-24*fs + 6.50953455217104e-19) + 3.31397583073083e-15) + 6.32576187894833e-14) + 2.56027512089847e-13) + Treble_R*(Treble_R*fs*(fs*(fs*(-2.40088747236654e-22*fs - 1.01914938263382e-18) - 7.84401701489674e-17) - 7.99276990472601e-16) + fs*(fs*(fs*(2.15430751633278e-22*fs - 1.00931167420926e-18) - 8.09581504534201e-15) - 6.27504999577649e-13) - 6.40068780224617e-12) + Volume_R*(Bass_R*(Treble_R*(Treble_R*pow(fs,3)*(fs*(3.83815344221861e-24*fs + 5.06664243269087e-22) + 5.70819680645209e-21) + pow(fs,2)*(fs*(fs*(-3.44396099549798e-24*fs + 3.00670847416855e-20) + 4.03664924154006e-18) + 4.55514105154877e-17)) + fs*(fs*(fs*(fs*(1.65351911090363e-23*fs + 9.5068384229614e-20) + 1.02988983768651e-17) - 1.30486302011578e-17) - 1.53616507253908e-15)) + Middle_R*(Bass_R*(Treble_R*(Treble_R*pow(fs,4)*(2.85267232541704e-25*fs + 3.65013945446597e-24) + pow(fs,3)*(fs*(-3.99374125558385e-25*fs + 2.27132232044654e-21) + 2.91281128466384e-20)) + pow(fs,2)*(fs*(fs*(1.54230955969265e-24*fs + 5.65134377825805e-21) - 2.30032611736055e-20) - 1.1695046812109e-18)) + Treble_R*(Treble_R*pow(fs,3)*(1.78443758228215e-23*fs + 2.28327872258084e-22) + pow(fs,2)*(fs*(-2.49821261519501e-23*fs + 1.42192566937971e-19) + 1.82351647640129e-18)) + fs*(fs*(fs*(9.64763852233277e-23*fs + 3.53068929659391e-19) - 5.29245486955245e-19) - 6.14466029015632e-17)) + Treble_R*(Treble_R*pow(fs,2)*(fs*(2.40088747236654e-22*fs + 1.8779602481101e-20) + 1.91826477713424e-19) + fs*(fs*(fs*(-2.15430751633278e-22*fs + 1.90693980601459e-18) + 1.50232520281226e-16) + 1.53616507253908e-15)) + Volume_R*(Bass_R*pow(fs,2)*(fs*(fs*(-1.6929383555757e-23*fs - 1.25906879957409e-19) - 1.62857548261884e-17) - 1.83118953550983e-16) + Middle_R*(Bass_R*pow(fs,3)*(fs*(-1.59749650223354e-24*fs - 9.17181360088287e-21) - 1.17096473699268e-19) + pow(fs,2)*(fs*(-9.99285046078002e-23*fs - 5.73269784908691e-19) - 7.31891791891218e-18)) + fs*(fs*(fs*(-1.05898697136012e-21*fs - 7.77799604390716e-18) - 6.02464692946613e-16) - 6.14466029015632e-15)) + fs*(fs*(fs*(1.03432897575674e-21*fs + 5.85227663541147e-18) + 4.52040346187673e-16) + 4.60849521761724e-15)) + fs*(fs*(fs*(2.46579956033756e-23*fs + 6.44090677084358e-18) + 4.05825720651041e-14) + 3.13857383051234e-12) + 3.20034390112309e-11;

    a1 = Bass_R*(Treble_R*(Treble_R*pow(fs,2)*(fs*(fs*(1.91907672110931e-23*fs + 4.94969107575399e-20) + 2.11680921042765e-18) - 2.37841533602171e-17) + fs*(fs*(fs*(fs*(-1.72198049774899e-23*fs + 4.71517417813316e-20) + 1.29316168998563e-16) - 1.68649232502658e-14) - 5.69392631443596e-13)) + fs*(fs*(fs*(fs*(-1.97096223360315e-24*fs - 3.09060187214354e-19) - 6.59092588471003e-16) + 9.2998714565051e-14) + 4.74569021150667e-12) + 3.20034390112309e-11) + Middle_R*(Bass_R*(Treble_R*(Treble_R*pow(fs,3)*(fs*(1.42633616270852e-24*fs + 3.5767908251347e-21) + 1.52089143936082e-20) + pow(fs,2)*(fs*(fs*(-1.99687062779193e-24*fs + 1.82179039185982e-21) + 9.49297111470724e-18) - 1.21367136860993e-16)) + fs*(fs*(fs*(fs*(-2.75934712704441e-25*fs - 3.12199525275548e-20) - 5.30246139994882e-17) + 1.0728203737318e-15) + 1.46188085151362e-14)) + Treble_R*(Treble_R*pow(fs,2)*(fs*(5.35331274684644e-23*fs + 7.45798938006809e-20) - 9.51366134408682e-19) + fs*(fs*(fs*(-7.49463784558502e-23*fs + 3.81003746381788e-20) - 5.94292545384613e-16) - 2.27939559550162e-14)) + fs*(fs*(fs*(-1.03563581534178e-23*fs - 6.50953455217104e-19) + 3.31397583073083e-15) + 1.8977285636845e-13) + 1.28013756044923e-12) + Treble_R*(Treble_R*fs*(fs*(fs*(7.20266241709961e-22*fs + 1.01914938263382e-18) - 7.84401701489674e-17) - 2.3978309714178e-15) + fs*(fs*(fs*(-6.46292254899834e-22*fs + 1.00931167420926e-18) - 8.09581504534201e-15) - 1.88251499873295e-12) - 3.20034390112309e-11) + Volume_R*(Bass_R*(Treble_R*(Treble_R*pow(fs,3)*(fs*(-1.91907672110931e-23*fs - 1.51999272980726e-21) - 5.70819680645209e-21) + pow(fs,2)*(fs*(fs*(1.72198049774899e-23*fs - 9.02012542250564e-20) - 4.03664924154006e-18) + 4.55514105154877e-17)) + fs*(fs*(fs*(fs*(-8.26759555451817e-23*fs - 2.85205152688842e-19) - 1.02988983768651e-17) - 1.30486302011578e-17) - 4.60849521761724e-15)) + Middle_R*(Bass_R*(Treble_R*(Treble_R*pow(fs,4)*(-1.42633616270852e-24*fs - 1.09504183633979e-23) + pow(fs,3)*(fs*(1.99687062779193e-24*fs - 6.81396696133963e-21) - 2.91281128466384e-20)) + pow(fs,2)*(fs*(fs*(-7.71154779846327e-24*fs - 1.69540313347742e-20) + 2.30032611736055e-20) - 1.1695046812109e-18)) + Treble_R*(Treble_R*pow(fs,3)*(-5.35331274684644e-23*fs - 2.28327872258084e-22) + pow(fs,2)*(fs*(7.49463784558502e-23*fs - 1.42192566937971e-19) + 1.82351647640129e-18)) + fs*(fs*(fs*(-2.89429155669983e-22*fs - 3.53068929659391e-19) - 5.29245486955245e-19) - 1.8433980870469e-16)) + Treble_R*(Treble_R*pow(fs,2)*(fs*(-7.20266241709961e-22*fs - 1.8779602481101e-20) + 1.91826477713424e-19) + fs*(fs*(fs*(6.46292254899834e-22*fs - 1.90693980601459e-18) + 1.50232520281226e-16) + 4.60849521761724e-15)) + Volume_R*(Bass_R*pow(fs,2)*(fs*(fs*(8.46469177787849e-23*fs + 3.77720639872226e-19) + 1.62857548261884e-17) - 1.83118953550983e-16) + Middle_R*(Bass_R*pow(fs,3)*(fs*(7.98748251116771e-24*fs + 2.75154408026486e-20) + 1.17096473699268e-19) + pow(fs,2)*(fs*(2.99785513823401e-22*fs + 5.73269784908691e-19) - 7.31891791891218e-18)) + fs*(fs*(fs*(3.17696091408035e-21*fs + 7.77799604390716e-18) - 6.02464692946613e-16) - 1.8433980870469e-14)) + fs*(fs*(fs*(-3.10298692727022e-21*fs - 5.85227663541147e-18) + 4.52040346187673e-16) + 1.38254856528517e-14)) + fs*(fs*(fs*(-7.39739868101268e-23*fs - 6.44090677084358e-18) + 4.05825720651041e-14) + 9.41572149153703e-12) + 1.60017195056154e-10;

    a2 = Bass_R*(Treble_R*(Treble_R*pow(fs,2)*(fs*(fs*(-3.83815344221861e-23*fs - 3.29979405050266e-20) + 4.23361842085529e-18) + 4.75683067204341e-17) + fs*(fs*(fs*(fs*(3.44396099549798e-23*fs - 3.14344945208878e-20) + 2.58632337997126e-16) + 3.37298465005315e-14) - 3.79595087629064e-13)) + fs*(fs*(fs*(fs*(3.9419244672063e-24*fs + 2.06040124809569e-19) - 1.31818517694201e-15) - 1.85997429130102e-13) + 3.16379347433778e-12) + 6.40068780224617e-11) + Middle_R*(Bass_R*(Treble_R*(Treble_R*pow(fs,3)*(fs*(-2.85267232541704e-24*fs - 2.38452721675646e-21) + 3.04178287872164e-20) + pow(fs,2)*(fs*(fs*(3.99374125558385e-24*fs - 1.21452692790654e-21) + 1.89859422294145e-17) + 2.42734273721987e-16)) + fs*(fs*(fs*(fs*(5.51869425408882e-25*fs + 2.08133016850365e-20) - 1.06049227998976e-16) - 2.1456407474636e-15) + 9.74587234342413e-15)) + Treble_R*(Treble_R*pow(fs,2)*(fs*(-3.56887516456429e-23*fs + 1.49159787601362e-19) + 1.90273226881736e-18) + fs*(fs*(fs*(4.99642523039001e-23*fs + 7.62007492763576e-20) + 1.18858509076923e-15) - 1.51959706366775e-14)) + fs*(fs*(fs*(6.90423876894517e-24*fs - 1.30190691043421e-18) - 6.62795166146167e-15) + 1.26515237578967e-13) + 2.56027512089847e-12) + Treble_R*(Treble_R*fs*(fs*(fs*(-4.80177494473307e-22*fs + 2.03829876526765e-18) + 1.56880340297935e-16) - 1.5985539809452e-15) + fs*(fs*(fs*(4.30861503266556e-22*fs + 2.01862334841852e-18) + 1.6191630090684e-14) - 1.2550099991553e-12) - 6.40068780224617e-11) + Volume_R*(Bass_R*(Treble_R*(Treble_R*pow(fs,3)*(fs*(3.83815344221861e-23*fs + 1.01332848653817e-21) - 1.14163936129042e-20) + pow(fs,2)*(fs*(fs*(-3.44396099549798e-23*fs + 6.01341694833709e-20) - 8.07329848308013e-18) - 9.11028210309754e-17)) + fs*(fs*(fs*(fs*(1.65351911090363e-22*fs + 1.90136768459228e-19) - 2.05977967537302e-17) + 2.60972604023156e-17) - 3.07233014507816e-15)) + Middle_R*(Bass_R*(Treble_R*(Treble_R*pow(fs,4)*(2.85267232541704e-24*fs + 7.30027890893193e-24) + pow(fs,3)*(fs*(-3.99374125558385e-24*fs + 4.54264464089309e-21) - 5.82562256932768e-20)) + pow(fs,2)*(fs*(fs*(1.54230955969265e-23*fs + 1.13026875565161e-20) + 4.60065223472111e-20) + 2.33900936242179e-18)) + Treble_R*(Treble_R*pow(fs,3)*(3.56887516456429e-23*fs - 4.56655744516168e-22) + pow(fs,2)*(fs*(-4.99642523039001e-23*fs - 2.84385133875941e-19) - 3.64703295280259e-18)) + fs*(fs*(fs*(1.92952770446655e-22*fs - 7.06137859318782e-19) + 1.05849097391049e-18) - 1.22893205803126e-16)) + Treble_R*(Treble_R*pow(fs,2)*(fs*(4.80177494473307e-22*fs - 3.75592049622019e-20) - 3.83652955426848e-19) + fs*(fs*(fs*(-4.30861503266556e-22*fs - 3.81387961202917e-18) - 3.00465040562453e-16) + 3.07233014507816e-15)) + Volume_R*(Bass_R*pow(fs,2)*(fs*(fs*(-1.6929383555757e-22*fs - 2.51813759914817e-19) + 3.25715096523769e-17) + 3.66237907101966e-16) + Middle_R*(Bass_R*pow(fs,3)*(fs*(-1.59749650223354e-23*fs - 1.83436272017657e-20) + 2.34192947398536e-19) + pow(fs,2)*(fs*(-1.998570092156e-22*fs + 1.14653956981738e-18) + 1.46378358378244e-17)) + fs*(fs*(fs*(-2.11797394272023e-21*fs + 1.55559920878143e-17) + 1.20492938589323e-15) - 1.22893205803126e-14)) + fs*(fs*(fs*(2.06865795151348e-21*fs - 1.17045532708229e-17) - 9.04080692375347e-16) + 9.21699043523448e-15)) + fs*(fs*(fs*(4.93159912067512e-23*fs - 1.28818135416872e-17) - 8.11651441302083e-14) + 6.27714766102469e-12) + 3.20034390112308e-10;

    a3 = Bass_R*(Treble_R*(Treble_R*pow(fs,2)*(fs*(fs*(3.83815344221861e-23*fs - 3.29979405050266e-20) - 4.23361842085529e-18) + 4.75683067204341e-17) + fs*(fs*(fs*(fs*(-3.44396099549798e-23*fs - 3.14344945208878e-20) - 2.58632337997126e-16) + 3.37298465005315e-14) + 3.79595087629064e-13)) + fs*(fs*(fs*(fs*(-3.9419244672063e-24*fs + 2.06040124809569e-19) + 1.31818517694201e-15) - 1.85997429130102e-13) - 3.16379347433778e-12) + 6.40068780224617e-11) + Middle_R*(Bass_R*(Treble_R*(Treble_R*pow(fs,3)*(fs*(2.85267232541704e-24*fs - 2.38452721675646e-21) - 3.04178287872164e-20) + pow(fs,2)*(fs*(fs*(-3.99374125558385e-24*fs - 1.21452692790654e-21) - 1.89859422294145e-17) + 2.42734273721987e-16)) + fs*(fs*(fs*(fs*(-5.51869425408882e-25*fs + 2.08133016850365e-20) + 1.06049227998976e-16) - 2.1456407474636e-15) - 9.74587234342413e-15)) + Treble_R*(Treble_R*pow(fs,2)*(fs*(-3.56887516456429e-23*fs - 1.49159787601362e-19) + 1.90273226881736e-18) + fs*(fs*(fs*(4.99642523039001e-23*fs - 7.62007492763576e-20) + 1.18858509076923e-15) + 1.51959706366775e-14)) + fs*(fs*(fs*(6.90423876894517e-24*fs + 1.30190691043421e-18) - 6.62795166146167e-15) - 1.26515237578967e-13) + 2.56027512089847e-12) + Treble_R*(Treble_R*fs*(fs*(fs*(-4.80177494473307e-22*fs - 2.03829876526765e-18) + 1.56880340297935e-16) + 1.5985539809452e-15) + fs*(fs*(fs*(4.30861503266556e-22*fs - 2.01862334841852e-18) + 1.6191630090684e-14) + 1.2550099991553e-12) - 6.40068780224617e-11) + Volume_R*(Bass_R*(Treble_R*(Treble_R*pow(fs,3)*(fs*(-3.83815344221861e-23*fs + 1.01332848653817e-21) + 1.14163936129042e-20) + pow(fs,2)*(fs*(fs*(3.44396099549798e-23*fs + 6.01341694833709e-20) + 8.07329848308013e-18) - 9.11028210309754e-17)) + fs*(fs*(fs*(fs*(-1.65351911090363e-22*fs + 1.90136768459228e-19) + 2.05977967537302e-17) + 2.60972604023156e-17) + 3.07233014507816e-15)) + Middle_R*(Bass_R*(Treble_R*(Treble_R*pow(fs,4)*(-2.85267232541704e-24*fs + 7.30027890893193e-24) + pow(fs,3)*(fs*(3.99374125558385e-24*fs + 4.54264464089309e-21) + 5.82562256932768e-20)) + pow(fs,2)*(fs*(fs*(-1.54230955969265e-23*fs + 1.13026875565161e-20) - 4.60065223472111e-20) + 2.33900936242179e-18)) + Treble_R*(Treble_R*pow(fs,3)*(3.56887516456429e-23*fs + 4.56655744516168e-22) + pow(fs,2)*(fs*(-4.99642523039001e-23*fs + 2.84385133875941e-19) - 3.64703295280259e-18)) + fs*(fs*(fs*(1.92952770446655e-22*fs + 7.06137859318782e-19) + 1.05849097391049e-18) + 1.22893205803126e-16)) + Treble_R*(Treble_R*pow(fs,2)*(fs*(4.80177494473307e-22*fs + 3.75592049622019e-20) - 3.83652955426848e-19) + fs*(fs*(fs*(-4.30861503266556e-22*fs + 3.81387961202917e-18) - 3.00465040562453e-16) - 3.07233014507816e-15)) + Volume_R*(Bass_R*pow(fs,2)*(fs*(fs*(1.6929383555757e-22*fs - 2.51813759914817e-19) - 3.25715096523769e-17) + 3.66237907101966e-16) + Middle_R*(Bass_R*pow(fs,3)*(fs*(1.59749650223354e-23*fs - 1.83436272017657e-20) - 2.34192947398536e-19) + pow(fs,2)*(fs*(-1.998570092156e-22*fs - 1.14653956981738e-18) + 1.46378358378244e-17)) + fs*(fs*(fs*(-2.11797394272023e-21*fs - 1.55559920878143e-17) + 1.20492938589323e-15) + 1.22893205803126e-14)) + fs*(fs*(fs*(2.06865795151348e-21*fs + 1.17045532708229e-17) - 9.04080692375347e-16) - 9.21699043523448e-15)) + fs*(fs*(fs*(4.93159912067512e-23*fs + 1.28818135416872e-17) - 8.11651441302083e-14) - 6.27714766102469e-12) + 3.20034390112308e-10;

    a4 = Bass_R*(Treble_R*(Treble_R*pow(fs,2)*(fs*(fs*(-1.91907672110931e-23*fs + 4.94969107575399e-20) - 2.11680921042765e-18) - 2.37841533602171e-17) + fs*(fs*(fs*(fs*(1.72198049774899e-23*fs + 4.71517417813316e-20) - 1.29316168998563e-16) - 1.68649232502658e-14) + 5.69392631443596e-13)) + fs*(fs*(fs*(fs*(1.97096223360315e-24*fs - 3.09060187214354e-19) + 6.59092588471003e-16) + 9.2998714565051e-14) - 4.74569021150667e-12) + 3.20034390112309e-11) + Middle_R*(Bass_R*(Treble_R*(Treble_R*pow(fs,3)*(fs*(-1.42633616270852e-24*fs + 3.5767908251347e-21) - 1.52089143936082e-20) + pow(fs,2)*(fs*(fs*(1.99687062779193e-24*fs + 1.82179039185982e-21) - 9.49297111470724e-18) - 1.21367136860993e-16)) + fs*(fs*(fs*(fs*(2.75934712704441e-25*fs - 3.12199525275548e-20) + 5.30246139994882e-17) + 1.0728203737318e-15) - 1.46188085151362e-14)) + Treble_R*(Treble_R*pow(fs,2)*(fs*(5.35331274684644e-23*fs - 7.45798938006809e-20) - 9.51366134408682e-19) + fs*(fs*(fs*(-7.49463784558502e-23*fs - 3.81003746381788e-20) - 5.94292545384613e-16) + 2.27939559550162e-14)) + fs*(fs*(fs*(-1.03563581534178e-23*fs + 6.50953455217104e-19) + 3.31397583073083e-15) - 1.8977285636845e-13) + 1.28013756044923e-12) + Treble_R*(Treble_R*fs*(fs*(fs*(7.20266241709961e-22*fs - 1.01914938263382e-18) - 7.84401701489674e-17) + 2.3978309714178e-15) + fs*(fs*(fs*(-6.46292254899834e-22*fs - 1.00931167420926e-18) - 8.09581504534201e-15) + 1.88251499873295e-12) - 3.20034390112309e-11) + Volume_R*(Bass_R*(Treble_R*(Treble_R*pow(fs,3)*(fs*(1.91907672110931e-23*fs - 1.51999272980726e-21) + 5.70819680645209e-21) + pow(fs,2)*(fs*(fs*(-1.72198049774899e-23*fs - 9.02012542250564e-20) + 4.03664924154006e-18) + 4.55514105154877e-17)) + fs*(fs*(fs*(fs*(8.26759555451817e-23*fs - 2.85205152688842e-19) + 1.02988983768651e-17) - 1.30486302011578e-17) + 4.60849521761724e-15)) + Middle_R*(Bass_R*(Treble_R*(Treble_R*pow(fs,4)*(1.42633616270852e-24*fs - 1.09504183633979e-23) + pow(fs,3)*(fs*(-1.99687062779193e-24*fs - 6.81396696133963e-21) + 2.91281128466384e-20)) + pow(fs,2)*(fs*(fs*(7.71154779846327e-24*fs - 1.69540313347742e-20) - 2.30032611736055e-20) - 1.1695046812109e-18)) + Treble_R*(Treble_R*pow(fs,3)*(-5.35331274684644e-23*fs + 2.28327872258084e-22) + pow(fs,2)*(fs*(7.49463784558502e-23*fs + 1.42192566937971e-19) + 1.82351647640129e-18)) + fs*(fs*(fs*(-2.89429155669983e-22*fs + 3.53068929659391e-19) - 5.29245486955245e-19) + 1.8433980870469e-16)) + Treble_R*(Treble_R*pow(fs,2)*(fs*(-7.20266241709961e-22*fs + 1.8779602481101e-20) + 1.91826477713424e-19) + fs*(fs*(fs*(6.46292254899834e-22*fs + 1.90693980601459e-18) + 1.50232520281226e-16) - 4.60849521761724e-15)) + Volume_R*(Bass_R*pow(fs,2)*(fs*(fs*(-8.46469177787849e-23*fs + 3.77720639872226e-19) - 1.62857548261884e-17) - 1.83118953550983e-16) + Middle_R*(Bass_R*pow(fs,3)*(fs*(-7.98748251116771e-24*fs + 2.75154408026486e-20) - 1.17096473699268e-19) + pow(fs,2)*(fs*(2.99785513823401e-22*fs - 5.73269784908691e-19) - 7.31891791891218e-18)) + fs*(fs*(fs*(3.17696091408035e-21*fs - 7.77799604390716e-18) - 6.02464692946613e-16) + 1.8433980870469e-14)) + fs*(fs*(fs*(-3.10298692727022e-21*fs + 5.85227663541147e-18) + 4.52040346187673e-16) - 1.38254856528517e-14)) + fs*(fs*(fs*(-7.39739868101268e-23*fs + 6.44090677084358e-18) + 4.05825720651041e-14) - 9.41572149153703e-12) + 1.60017195056154e-10;

    a5 = Bass_R*(Treble_R*(Treble_R*pow(fs,2)*(fs*(fs*(3.83815344221861e-24*fs - 1.64989702525133e-20) + 2.11680921042765e-18) - 2.37841533602171e-17) + fs*(fs*(fs*(fs*(-3.44396099549798e-24*fs - 1.57172472604439e-20) + 1.29316168998563e-16) - 1.68649232502658e-14) + 1.89797543814532e-13)) + fs*(fs*(fs*(fs*(-3.9419244672063e-25*fs + 1.03020062404785e-19) - 6.59092588471003e-16) + 9.2998714565051e-14) - 1.58189673716889e-12) + 6.40068780224617e-12) + Middle_R*(Bass_R*(Treble_R*(Treble_R*pow(fs,3)*(fs*(2.85267232541704e-25*fs - 1.19226360837823e-21) + 1.52089143936082e-20) + pow(fs,2)*(fs*(fs*(-3.99374125558385e-25*fs - 6.07263463953272e-22) + 9.49297111470724e-18) - 1.21367136860993e-16)) + fs*(fs*(fs*(fs*(-5.51869425408882e-26*fs + 1.04066508425183e-20) - 5.30246139994882e-17) + 1.0728203737318e-15) - 4.87293617171206e-15)) + Treble_R*(Treble_R*pow(fs,2)*(fs*(-1.78443758228215e-23*fs + 7.45798938006809e-20) - 9.51366134408682e-19) + fs*(fs*(fs*(2.49821261519501e-23*fs + 3.81003746381788e-20) - 5.94292545384613e-16) + 7.59798531833873e-15)) + fs*(fs*(fs*(3.45211938447258e-24*fs - 6.50953455217104e-19) + 3.31397583073083e-15) - 6.32576187894833e-14) + 2.56027512089847e-13) + Treble_R*(Treble_R*fs*(fs*(fs*(-2.40088747236654e-22*fs + 1.01914938263382e-18) - 7.84401701489674e-17) + 7.99276990472601e-16) + fs*(fs*(fs*(2.15430751633278e-22*fs + 1.00931167420926e-18) - 8.09581504534201e-15) + 6.27504999577649e-13) - 6.40068780224617e-12) + Volume_R*(Bass_R*(Treble_R*(Treble_R*pow(fs,3)*(fs*(-3.83815344221861e-24*fs + 5.06664243269087e-22) - 5.70819680645209e-21) + pow(fs,2)*(fs*(fs*(3.44396099549798e-24*fs + 3.00670847416855e-20) - 4.03664924154006e-18) + 4.55514105154877e-17)) + fs*(fs*(fs*(fs*(-1.65351911090363e-23*fs + 9.5068384229614e-20) - 1.02988983768651e-17) - 1.30486302011578e-17) + 1.53616507253908e-15)) + Middle_R*(Bass_R*(Treble_R*(Treble_R*pow(fs,4)*(-2.85267232541704e-25*fs + 3.65013945446597e-24) + pow(fs,3)*(fs*(3.99374125558385e-25*fs + 2.27132232044654e-21) - 2.91281128466384e-20)) + pow(fs,2)*(fs*(fs*(-1.54230955969265e-24*fs + 5.65134377825805e-21) + 2.30032611736055e-20) - 1.1695046812109e-18)) + Treble_R*(Treble_R*pow(fs,3)*(1.78443758228215e-23*fs - 2.28327872258084e-22) + pow(fs,2)*(fs*(-2.49821261519501e-23*fs - 1.42192566937971e-19) + 1.82351647640129e-18)) + fs*(fs*(fs*(9.64763852233277e-23*fs - 3.53068929659391e-19) - 5.29245486955245e-19) + 6.14466029015632e-17)) + Treble_R*(Treble_R*pow(fs,2)*(fs*(2.40088747236654e-22*fs - 1.8779602481101e-20) + 1.91826477713424e-19) + fs*(fs*(fs*(-2.15430751633278e-22*fs - 1.90693980601459e-18) + 1.50232520281226e-16) - 1.53616507253908e-15)) + Volume_R*(Bass_R*pow(fs,2)*(fs*(fs*(1.6929383555757e-23*fs - 1.25906879957409e-19) + 1.62857548261884e-17) - 1.83118953550983e-16) + Middle_R*(Bass_R*pow(fs,3)*(fs*(1.59749650223354e-24*fs - 9.17181360088287e-21) + 1.17096473699268e-19) + pow(fs,2)*(fs*(-9.99285046078002e-23*fs + 5.73269784908691e-19) - 7.31891791891218e-18)) + fs*(fs*(fs*(-1.05898697136012e-21*fs + 7.77799604390716e-18) - 6.02464692946613e-16) + 6.14466029015632e-15)) + fs*(fs*(fs*(1.03432897575674e-21*fs - 5.85227663541147e-18) + 4.52040346187673e-16) - 4.60849521761724e-15)) + fs*(fs*(fs*(2.46579956033756e-23*fs - 6.44090677084358e-18) + 4.05825720651041e-14) - 3.13857383051234e-12) + 3.20034390112309e-11;
};

alembic_briteclip = _<: ba.if(signbit(_), alembic_brite_neg_clip, alembic_brite_clip) :>_ with {

    signbit = ffunction(int signbit(float), "math.h", "");

    alembic_brite_clip = ffunction(float alembic_briteclip(float), "alembic_brite_table.h", "");

    alembic_brite_neg_clip = ffunction(float alembic_brite_negclip(float), "alembic_brite_neg_table.h", "");

};

output_L = pre : fi.iir((b0/a0,b1/a0,b2/a0),(a1/a0,a2/a0)) : alembic_outclip with {
    LogPot(a, x) = ba.if(a, (exp(a * x) - 1) / (exp(a) - 1), x);
    Inverted(b, x) = ba.if(b, 1 - x, x);
    s = 0.993;
    fs = float(ma.SR);
    pre = _;


    Master_L = vslider("Master_L[name:Master_L]", 0.5, 0, 1, 0.01) : Inverted(0) : LogPot(3) : si.smooth(s);

    b0 = Master_L*fs*(-2.54284690253705e-8*fs - 1.69523126835804e-7);

    b1 = 5.0856938050741e-8*Master_L*pow(fs,2);

    b2 = Master_L*fs*(-2.54284690253705e-8*fs + 1.69523126835804e-7);

    a0 = fs*(4.33864919358014e-10*fs + 7.81664517527894e-9) + 2.68307231780644e-8;

    a1 = -8.67729838716027e-10*pow(fs,2) + 5.36614463561288e-8;

    a2 = fs*(4.33864919358014e-10*fs - 7.81664517527894e-9) + 2.68307231780644e-8;
};
output_R = pre : fi.iir((b0/a0,b1/a0,b2/a0),(a1/a0,a2/a0)) : alembic_outclip with {
    LogPot(a, x) = ba.if(a, (exp(a * x) - 1) / (exp(a) - 1), x);
    Inverted(b, x) = ba.if(b, 1 - x, x);
    s = 0.993;
    fs = float(ma.SR);
    pre = _;


    Master_R = vslider("Master_R[name:Master_R]", 0.5, 0, 1, 0.01) : Inverted(0) : LogPot(3) : si.smooth(s);

    b0 = Master_R*fs*(-2.54284690253705e-8*fs - 1.69523126835804e-7);

    b1 = 5.0856938050741e-8*Master_R*pow(fs,2);

    b2 = Master_R*fs*(-2.54284690253705e-8*fs + 1.69523126835804e-7);

    a0 = fs*(4.33864919358014e-10*fs + 7.81664517527894e-9) + 2.68307231780644e-8;

    a1 = -8.67729838716027e-10*pow(fs,2) + 5.36614463561288e-8;

    a2 = fs*(4.33864919358014e-10*fs - 7.81664517527894e-9) + 2.68307231780644e-8;
};

alembic_outclip = _<: ba.if(signbit(_), alembic_out_neg_clip, alembic_out_clip) :>_ with {

    signbit = ffunction(int signbit(float), "math.h", "");

    alembic_out_clip = ffunction(float alembic_outclip(float), "alembic_out_table.h", "");

    alembic_out_neg_clip = ffunction(float alembic_out_negclip(float), "alembic_out_neg_table.h", "");

};

// Brite normal 
briteswitch_L = _<:bright_L,normal_L:select2( checkbox("bright_L" ));
briteswitch_R = _<:bright_R,normal_R:select2( checkbox("bright_R" ));

amp_L = briteswitch_L:output_L;
amp_R = briteswitch_R:output_R;
freq_split = fi.filterbank(3, (86.0,210.0,1200.0,6531.0));
channel_L    = freq_split: ( amp_L , amp_L , amp_L, amp_L, amp_L) :>_;
channel_R    = freq_split: ( amp_R , amp_R , amp_R, amp_R, amp_R) :>_;
process = channel_L, channel_R ;

