% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-.R, R/scale-binned.R,
%   R/scale-continuous.R, R/scale-date.R, R/scale-discrete-.R,
%   R/scale-identity.R
\docType{data}
\name{Scale}
\alias{Scale}
\alias{ScaleContinuous}
\alias{ScaleDiscrete}
\alias{ScaleBinned}
\alias{ScaleBinnedPosition}
\alias{ScaleContinuousPosition}
\alias{ScaleContinuousDatetime}
\alias{ScaleContinuousDate}
\alias{ScaleDiscretePosition}
\alias{ScaleDiscreteIdentity}
\alias{ScaleContinuousIdentity}
\title{Scales}
\description{
All \verb{scale_*()} functions (like \code{scale_fill_continuous()}) return a \verb{Scale*}
object. The main purpose of these objects is to translate data values to
aesthetic values and populating breaks and labels.
}
\details{
All \verb{scale_*} functions like \code{\link[=scale_x_continuous]{scale_x_continuous()}} return a \verb{Scale*} object
like \code{ScaleContinuous}. Each of the \verb{Scale*} objects is a \code{\link[=ggproto]{ggproto()}} object
descended from the top-level \code{Scale}.

Scales generally need to track three types of spaces:
\enumerate{
\item Data space. These are values as they are evaluated from the plot
or layer mapping, prior to any transformation.
\item Transformed space. This is the space after original data has been
transformed. Effectively, scales internally operate in transformed space
in that ranges and breaks get passed around in this space. Discrete scales
don't do transformations, so for these scales, transformed space is the
same as untransformed space.
\item Aesthetic space. Graphic values that are mapped from the transformed
space. This is dependent on the \code{palette} field for most scales and on the
\code{rescaler} field for continuous position scales.
}

The user is expected to give any vector-based \code{minor_breaks}, \code{breaks} or
\code{limits} in data space. When \code{breaks}, \code{limits} or \code{labels} is a function,
its input is expected to be in data space.

Before you attempt to create a new \verb{Scale*} class of your own, it is
recommended to think through whether your aims cannot be implemented with
one of the existing classes. Making a wrapper for the \code{continuous_scale()},
\code{discrete_scale()} and \code{binned_scale()} should cover many cases, and should
be considered prior to commiting to build a \verb{Scale*} extension.

For example, if you aim to develop a scale for a new data type, it should
generally be possible to create a new \link[scales:new_transform]{transformation}
instead. One reason to implement your own \verb{Scale*} class is to accommodate
a data type does not lend itself for continuous or discrete range training.

In such case, you can override the following:
\itemize{
\item The \code{range} field.
\item The \code{transform}, \code{train} and \code{map} methods.
\item The \code{get_limits()}, \code{get_breaks()} and \code{get_labels()} methods.
}
}
\section{Fields}{

\describe{
\item{\code{call}}{A \link[=call]{call} object with the user-facing constructor
function, for use in error messaging. This field is populated by scale
constructors.}

\item{\code{range}}{A \code{\link[scales:Range]{Range}} class object, like
\code{scales::ContinuousRange} or \code{scales::DiscreteRange}. These are 'trained'
to keep track of the data range (continuous) or data levels (discrete).
Continuous ranges are tracked in transformed space.}

\item{\code{aesthetics,palette,name,breaks,labels,limits,name,guide,position,na.value,expand}}{Fields populated by the scale constructor that can take on the same values
as described in e.g. \code{\link[=continuous_scale]{?continuous_scale}}.
Note that \code{limits} is expected in transformed space.}

\item{\code{transform_df,transform}}{\strong{Description}

A function method for orchestrating the transformation of aesthetics in a
data frame. Data transformation occurs before stats are computed.
The \code{transform_df()} method ensures the \code{transform()} method is applied
to the correct columns.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Scale$transform_df(df)
Scale$transform(x)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{df}}{A data frame with the layer's data.}
\item{\code{x}}{A vector of the relevant aesthetic.}
}

\strong{Value}

For \code{transform()} a vector of transformed values.
For \code{transform_df()}, a named list with transformed values for each
transformed aesthetic.}

\item{\code{train_df,train}}{\strong{Description}

A function method for orchestrating scale training for keeping track of
the data range or levels. The \code{train_df()} method ensures the \code{train()}
method is applied to the correct columns.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Scale$train_df(df)
Scale$train(x)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{df}}{A data frame with the layer's data.}
\item{\code{x}}{A vector of the relevant aesthetic.}
}

\strong{Value}

Nothing, these are called for their side effect of updating the \code{range}
field.}

\item{\code{map_df,map}}{\strong{Description}

A function method for orchestrating the mapping of data values to
aesthetics. The \code{map_df()} method ensures the \code{map()} method is applied
to the correct columns. When the scale uses a \code{palette()} function, it is
applied in the \code{map()} method.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Scale$map_df(df, i)
Scale$map(x, limits)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{df}}{A data frame with the layer's data.}
\item{\code{i}}{An integer vector giving an index to map a subset of data.
The default, \code{NULL}, will map all rows.}
\item{\code{x}}{A vector of the relevant aesthetic.}
\item{\code{limits}}{A vector of the relevant aesthetic, usually via
the \code{get_limits()} method.}
}

\strong{Value}

For \code{map()} a vector of mapped values in aesthetics space.
For \code{map_df()}, a named list with mapped values for each
aesthetic.}

\item{\code{recale}}{\strong{Description}

A function method for applying the recale function in the \code{rescaler} field.
It is used during the continuous \code{map()} and \code{Coord$transform()} methods
to ensure values are in the 0-1 range.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Scale$rescale(x, limits, range)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{x}}{A vector of values to rescale. Can contain out-of-bounds
or missing values depending on the \code{map()} method.}
\item{\code{limits}}{A length two vector giving the limits of the relevant
aesthetic, usually via the \code{get_limits()} method.}
\item{\code{range}}{A length two vector giving the range that should coincide
with the 0-1 points. For most purpuses, this should be the same as the
\code{limits} argument.}
}

\strong{Value}

A vector of values between 0 and 1 for in-bounds values of \code{x}.}

\item{\code{get_limits}}{\strong{Description}

A function method for resolving user input and getting the scale limits.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Scale$get_limits()
}\if{html}{\out{</div>}}

\strong{Value}

The scale limits, without any expansion applied, in transformed space.}

\item{\code{dimension}}{\strong{Description}

A function method for getting a continuous representation of the limits of
position scales. For continuous scales, the dimension is the same concept
as the limits. For discrete scales the dimension is the continuous range
occupied by the mapped breaks, which by default take integer positions.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Scale$dimension(expand, limits)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{expand}}{A length 4 vector giving scale \link[=expansion]{expansion}.
This is optional and defaults to no expansion.}
\item{\code{limits}}{A vector of the relevant aesthetic, usually via
the \code{get_limits()} method.}
}

\strong{Value}

A numeric vector of length 2}

\item{\code{get_breaks,get_breaks_minor}}{\strong{Description}

A function method for resolving user input and getting the scale breaks
or minor breaks. Note that these may return out-of-bounds values for the
purpose of coordinating with the \code{get_labels()} method.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Scale$get_breaks(limits)
Scale$get_breaks_minor(n, b, limits)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{limits}}{A vector of the relevant aesthetic, usually via
the \code{get_limits()} method.}
\item{\code{n}}{An integer setting the desired number of minor breaks per
major break. Note that the resulting minor breaks may coincide with
major breaks.}
\item{\code{b}}{A vector of mapped major breaks from the \code{get_breaks()}
method.}
}

\strong{Value}

A vector of breaks in transformed space.}

\item{\code{get_labels}}{\strong{Description}

A function method for resolving user input and getting the scale labels for
a set of breaks.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Scale$get_labels(breaks)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{breaks}}{A vector of unmapped major breaks from the \code{get_breaks()}
method, in transformed space.}
}

\strong{Value}

A vector of labels of the same length as \code{breaks}.}

\item{\code{get_transformation}}{\strong{Description}

A helper method to access the scale's transformation object.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Scale$get_transformation()
}\if{html}{\out{</div>}}

\strong{Value}

A \link[scales:new_transform]{transform} object.}

\item{\code{break_info}}{\strong{Description}

A function method for getting all break related information for position
scales. It is in use by coords that do not use the modern Guide system
and secondary axes.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Scale$break_info(range)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{range}}{A vector of the relevant aesthetic.}
}

\strong{Value}

A named list with the following structure:
\itemize{
\item \code{range} a length 2 vector giving continuous range
\item \code{labels} a character or expression vector of the same length as major breaks.
\item \code{major} a numeric vector with mapped numeric values for major breaks.
\item \code{major_source} a numeric vector with (transformed) data values for major breaks.
\item \code{minor} a numeric vector with mapped numeric values for minor breaks.
\item \code{minor_source} a numeric vector with (transformed) data values for minor breaks.
}}

\item{\code{break_position}}{\strong{Description}

A function method for getting mapped break positions. It is in use as a
default value in \code{get_breaks_minor()}, but is otherwise vestigial.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Scale$break_info(range)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{range}}{A vector of the relevant aesthetic.}
}

\strong{Value}

A vector with mapped break positions}

\item{\code{make_title,make_sec_title}}{\strong{Description}

A function method for picking the title to use. This is usually called in
the \code{Guide$extract_params()} or \code{Layout$resolve_label()} methods.
The hierarchy of titles goes from guide (highest priority), to scale, to
labs (lowest priority).
When the guide or scale title are functions, they're applied to the next
in line. The \code{make_sec_title()} method by default re-uses the primary
\code{make_title()} method and only applies to position aesthetics.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Scale$make_title(guide_title, scale_title, label_title)
Scale$make_sec_title(...)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{guide_title}}{The \code{title} parameter coming from a guide.}
\item{\code{scale_title}}{The \code{name} field of the Scale.}
\item{\code{label_title}}{The relevant entry in the \code{plot$labels} field.}
\item{\code{...}}{By default, arguments forwarded  to the \code{make_title()}
method}
}

\strong{Value}

A scalar character or expression title}

\item{\code{axis_order}}{\strong{Description}

A function method for setting the order of axes titles used to coordinate
with \code{Facet$draw_labels()}.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Scale$axis_order()
}\if{html}{\out{</div>}}

\strong{Value}

Either \code{c("primary", "secondary")} or \code{c("secondary", "primary")}.}

\item{\code{clone}}{\strong{Description}

A function method for making an untrained copy of the scale. Due to
reference semantics of ggproto objects, in contrast to copy-on-modify
semantics, scales need to be cloned at the start of plot building.
The cloned scale can be trained independently of the original.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Scale$clone()
}\if{html}{\out{</div>}}

\strong{Value}

A Scale object.}

\item{\code{reset}}{\strong{Description}

A function method for to reset the \code{range} field, effectively 'untraining'
the scale. This is used in the \code{Layout$reset_scales()} method, so that
scales can be re-trained on data with final position aesthetics.
For discrete scales, only the continuous range (\code{range_c}) is reset.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Scale$clone()
}\if{html}{\out{</div>}}

\strong{Value}

None, called for the side-effect of resetting the range.}

\item{\code{is_empty}}{\strong{Description}

A function method for determining whether a scale is empty, i.e. when no
information with which to calculate limits.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Scale$is_empty()
}\if{html}{\out{</div>}}

\strong{Value}

A scalar boolean value.}

\item{\code{is_empty}}{\strong{Description}

A function method for determining whether a scale is discrete.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Scale$is_discrete()
}\if{html}{\out{</div>}}

\strong{Value}

A scalar boolean value.}
}}

\section{Conventions}{


The object name that a new class is assigned to is typically the same as the
class name. Scale class names are in UpperCamelCase and start with the
\verb{Scale*} prefix, like \code{ScaleNew}.

In scales, there is a difference between user-facing and developer-facing
constructors. Developer facing constructors have the shape
\verb{\{foundation\}_scale()}, like \code{discrete_scale()} corresponding to
\code{ScaleDiscrete}. User-facing constructors have the \verb{scale_\{aesthetic\}_\{type\}}
as name. If you implement a new \verb{Scale*} class, you like want both these
types of constructor.
}

\examples{
# TODO: find easy to digest example
NULL
}
\keyword{datasets}
\keyword{internal}
