% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coord-flip.R
\name{coord_flip}
\alias{coord_flip}
\title{Cartesian coordinates with x and y flipped}
\usage{
coord_flip(xlim = NULL, ylim = NULL, expand = TRUE, clip = "on")
}
\arguments{
\item{xlim, ylim}{Limits for the x and y axes.}

\item{expand}{If \code{TRUE}, the default, adds a small expansion factor to
the limits to ensure that data and axes don't overlap. If \code{FALSE},
limits are taken exactly from the data or \code{xlim}/\code{ylim}.
Giving a logical vector will separately control the expansion for the four
directions (top, left, bottom and right). The \code{expand} argument will be
recycled to length 4 if necessary. Alternatively, can be a named logical
vector to control a single direction, e.g. \code{expand = c(bottom = FALSE)}.}

\item{clip}{Should drawing be clipped to the extent of the plot panel? A
setting of \code{"on"} (the default) means yes, and a setting of \code{"off"}
means no. In most cases, the default of \code{"on"} should not be changed,
as setting \code{clip = "off"} can cause unexpected results. It allows
drawing of data points anywhere on the plot, including in the plot margins. If
limits are set via \code{xlim} and \code{ylim} and some data points fall outside those
limits, then those data points may show up in places such as the axes, the
legend, the plot title, or the plot margins.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

This function is superseded because in many cases, \code{coord_flip()} can easily
be replaced by swapping the x and y aesthetics, or optionally setting the
\code{orientation} argument in geom and stat layers.

\code{coord_flip()} is useful for geoms and statistics that do not support
the \code{orientation} setting, and converting the display of y conditional on x,
to x conditional on y.
}
\details{
Coordinate systems interact with many parts of the plotting system. You can
expect the following for \code{coord_flip()}:
\itemize{
\item It does \emph{not} change the facet order in \code{facet_grid()} or \code{facet_wrap()}.
\item The \verb{scale_x_*()} functions apply to the vertical direction,
whereas \verb{scale_y_*()} functions apply to the horizontal direction. The
same holds for the \code{xlim} and \code{ylim} arguments of \code{coord_flip()} and the
\code{xlim()} and \code{ylim()} functions.
\item The x-axis theme settings, such as \code{axis.line.x} apply to the horizontal
direction. The y-axis theme settings, such as \code{axis.text.y} apply to the
vertical direction.
}
}
\examples{
# The preferred method of creating horizontal instead of vertical boxplots
ggplot(diamonds, aes(price, cut)) +
  geom_boxplot()

# Using `coord_flip()` to make the same plot
ggplot(diamonds, aes(cut, price)) +
  geom_boxplot() +
  coord_flip()

# With swapped aesthetics, the y-scale controls the left axis
ggplot(diamonds, aes(y = carat)) +
  geom_histogram() +
  scale_y_reverse()

# In `coord_flip()`, the x-scale controls the left axis
ggplot(diamonds, aes(carat)) +
  geom_histogram() +
  coord_flip() +
  scale_x_reverse()

# In line and area plots, swapped aesthetics require an explicit orientation
df <- data.frame(a = 1:5, b = (1:5) ^ 2)
ggplot(df, aes(b, a)) +
  geom_area(orientation = "y")

# The same plot with `coord_flip()`
ggplot(df, aes(a, b)) +
  geom_area() +
  coord_flip()
}
