% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-discrete-.R
\name{scale_x_discrete}
\alias{scale_x_discrete}
\alias{scale_y_discrete}
\title{Position scales for discrete data}
\usage{
scale_x_discrete(
  name = waiver(),
  ...,
  palette = seq_len,
  expand = waiver(),
  guide = waiver(),
  position = "bottom",
  sec.axis = waiver(),
  continuous.limits = NULL
)

scale_y_discrete(
  name = waiver(),
  ...,
  palette = seq_len,
  expand = waiver(),
  guide = waiver(),
  position = "left",
  sec.axis = waiver(),
  continuous.limits = NULL
)
}
\arguments{
\item{name}{The name of the scale. Used as the axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}

\item{...}{
  Arguments passed on to \code{\link[=discrete_scale]{discrete_scale}}
  \describe{
    \item{\code{breaks}}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks (the scale limits)
\item A character vector of breaks
\item A function that takes the limits as input and returns breaks
as output. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{limits}}{One of:
\itemize{
\item \code{NULL} to use the default scale values
\item A character vector that defines possible values of the scale and their
order
\item A function that accepts the existing (automatic) values and returns
new ones. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{drop}}{Should unused factor levels be omitted from the scale?
The default, \code{TRUE}, uses the levels that appear in the data;
\code{FALSE} includes the levels in the factor. Please note that to display
every level in a legend, the layer should use \code{show.legend = TRUE}.}
    \item{\code{na.translate}}{Unlike continuous scales, discrete scales can easily show
missing values, and do so by default. If you want to remove missing values
from a discrete scale, specify \code{na.translate = FALSE}.}
    \item{\code{na.value}}{If \code{na.translate = TRUE}, what aesthetic value should the
missing values be displayed as? Does not apply to position scales
where \code{NA} is always placed at the far right.}
    \item{\code{aesthetics}}{The names of the aesthetics that this scale works with.}
    \item{\code{minor_breaks}}{One of:
\itemize{
\item \code{NULL} for no minor breaks
\item \code{waiver()} for the default breaks (none for discrete, one minor break
between each major break for continuous)
\item A numeric vector of positions
\item A function that given the limits returns a vector of minor breaks. Also
accepts rlang \link[rlang:as_function]{lambda} function notation. When
the function has two arguments, it will be given the limits and major
break positions.
}}
    \item{\code{labels}}{One of the options below. Please note that when \code{labels} is a
vector, it is highly recommended to also set the \code{breaks} argument as a
vector to protect against unintended mismatches.
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item An expression vector (must be the same length as breaks). See ?plotmath for details.
\item A function that takes the breaks as input and returns labels
as output. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{call}}{The \code{call} used to construct the scale for reporting messages.}
    \item{\code{super}}{The super class to use for the constructed scale}
  }}

\item{palette}{A palette function that when called with a single integer
argument (the number of levels in the scale) returns the numerical values
that they should take.}

\item{expand}{For position scales, a vector of range expansion constants used to add some
padding around the data to ensure that they are placed some distance
away from the axes. Use the convenience function \code{\link[=expansion]{expansion()}}
to generate the values for the \code{expand} argument. The defaults are to
expand the scale by 5\% on each side for continuous variables, and by
0.6 units on each side for discrete variables.}

\item{guide}{A function used to create a guide or its name. See
\code{\link[=guides]{guides()}} for more information.}

\item{position}{For position scales, The position of the axis.
\code{left} or \code{right} for y axes, \code{top} or \code{bottom} for x axes.}

\item{sec.axis}{\code{\link[=dup_axis]{dup_axis()}} is used to specify a secondary axis.}

\item{continuous.limits}{One of:
\itemize{
\item \code{NULL} to use the default scale range
\item A numeric vector of length two providing a display range for the scale.
Use \code{NA} to refer to the existing minimum or maximum.
\item A function that accepts the limits and returns a numeric vector of
length two.
}}
}
\description{
\code{scale_x_discrete()} and \code{scale_y_discrete()} are used to set the values for
discrete x and y scale aesthetics. For simple manipulation of scale labels
and limits, you may wish to use \code{\link[=labs]{labs()}} and \code{\link[=lims]{lims()}} instead.
}
\details{
You can use continuous positions even with a discrete position scale -
this allows you (e.g.) to place labels between bars in a bar chart.
Continuous positions are numeric values starting at one for the first
level, and increasing by one for each level (i.e. the labels are placed
at integer positions).  This is what allows jittering to work.
}
\examples{
ggplot(diamonds, aes(cut)) + geom_bar()

\donttest{
# The discrete position scale is added automatically whenever you
# have a discrete position.

(d <- ggplot(subset(diamonds, carat > 1), aes(cut, clarity)) +
      geom_jitter())

d + scale_x_discrete("Cut")
d +
  scale_x_discrete(
    "Cut",
    labels = c(
      "Fair" = "F",
      "Good" = "G",
      "Very Good" = "VG",
      "Perfect" = "P",
      "Ideal" = "I"
    )
  )

# Use limits to adjust the which levels (and in what order)
# are displayed
d + scale_x_discrete(limits = c("Fair","Ideal"))

# you can also use the short hand functions xlim and ylim
d + xlim("Fair","Ideal", "Good")
d + ylim("I1", "IF")

# See ?reorder to reorder based on the values of another variable
ggplot(mpg, aes(manufacturer, cty)) +
  geom_point()
ggplot(mpg, aes(reorder(manufacturer, cty), cty)) +
  geom_point()
ggplot(mpg, aes(reorder(manufacturer, displ), cty)) +
  geom_point()

# Use abbreviate as a formatter to reduce long names
ggplot(mpg, aes(reorder(manufacturer, displ), cty)) +
  geom_point() +
  scale_x_discrete(labels = abbreviate)
}
}
\seealso{
The \link[=aes_position]{position documentation}.

The \href{https://ggplot2-book.org/scales-position#sec-discrete-position}{discrete position scales section} of the online ggplot2 book.

Other position scales: 
\code{\link{scale_x_binned}()},
\code{\link{scale_x_continuous}()},
\code{\link{scale_x_date}()}
}
\concept{position scales}
