# Generated by Django 4.2.15 on 2024-12-16 10:10

from django.db import migrations
from django.db.backends.base.schema import BaseDatabaseSchemaEditor
from django.db.migrations.state import StateApps


def fill_scope_label(
    apps: StateApps, schema_editor: BaseDatabaseSchemaEditor
) -> None:
    """Fill scope labels from scope names."""
    Scope = apps.get_model("db", "Scope")
    for scope in Scope.objects.filter(label=""):
        scope.label = scope.name.capitalize()
        scope.save()


def empty_scope_label(
    apps: StateApps, schema_editor: BaseDatabaseSchemaEditor
) -> None:
    """Reversing only removes labels that match automatic ones."""
    Scope = apps.get_model("db", "Scope")
    for scope in Scope.objects.all():
        if scope.label != scope.name.capitalize():
            continue
        scope.label = ""
        scope.save()


class Migration(migrations.Migration):
    dependencies = [
        ('db', '0107_add_scope_label_icon'),
    ]

    operations = [migrations.RunPython(fill_scope_label, empty_scope_label)]
