#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.

from fenrirscreenreader.core import debug


def get_prev_line(curr_x, curr_y, curr_text):
    end_of_screen = False
    if curr_text == "":
        return -1, -1, "", end_of_screen
    wrapped_lines = curr_text.split("\n")
    x = curr_x
    y = curr_y
    if y - 1 >= 0:
        y -= 1
    else:
        end_of_screen = True
    x = curr_x
    curr_line = ""
    if not end_of_screen:
        curr_line = wrapped_lines[y]
    return x, y, curr_line, end_of_screen


def get_current_line(curr_x, curr_y, curr_text):
    if curr_text == "":
        return -1, -1, ""
    wrapped_lines = curr_text.split("\n")
    x = curr_x
    y = curr_y
    x = 0
    curr_line = wrapped_lines[y]
    return x, y, curr_line


def get_next_line(curr_x, curr_y, curr_text):
    end_of_screen = False
    if curr_text == "":
        return -1, -1, "", end_of_screen
    wrapped_lines = curr_text.split("\n")
    x = curr_x
    y = curr_y
    if y + 1 < len(wrapped_lines):
        y += 1
    else:
        end_of_screen = True
    x = curr_x
    curr_line = ""
    if not end_of_screen:
        curr_line = wrapped_lines[y]
    return x, y, curr_line, end_of_screen
