/* init-loop.c - Server loop for console client library.
   Copyright (C) 2002 Free Software Foundation, Inc.
   Written by Marcus Brinkmann.

   This file is part of the GNU Hurd.

   The GNU Hurd is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2, or (at
   your option) any later version.

   The GNU Hurd is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA. */

#include <hurd/ports.h>
#include <pthread.h>

#include "cons.h"

void
cons_server_loop (void)
{
  pthread_setname_np (pthread_self (), "cons_demuxer");

  ports_manage_port_operations_one_thread (cons_port_bucket,
					   cons_demuxer, 0);
  /* Not reached.  */
}
