
/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

#include "_hypre_seq_mv.h"

#ifdef HYPRE_MIXED_PRECISION

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/


/*--------------------------------------------------------------------------*/

HYPRE_CSRMatrix
HYPRE_CSRMatrixCreate_pre( HYPRE_Precision precision, HYPRE_Int num_rows, HYPRE_Int num_cols, HYPRE_Int *row_sizes )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_CSRMatrixCreate_flt( num_rows, num_cols, row_sizes );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_CSRMatrixCreate_dbl( num_rows, num_cols, row_sizes );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_CSRMatrixCreate_long_dbl( num_rows, num_cols, row_sizes );
      default:
         { HYPRE_CSRMatrix value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_CSRMatrixDestroy_pre( HYPRE_Precision precision, HYPRE_CSRMatrix matrix )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_CSRMatrixDestroy_flt( matrix );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_CSRMatrixDestroy_dbl( matrix );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_CSRMatrixDestroy_long_dbl( matrix );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_CSRMatrixGetNumRows_pre( HYPRE_Precision precision, HYPRE_CSRMatrix matrix, HYPRE_Int *num_rows )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_CSRMatrixGetNumRows_flt( matrix, num_rows );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_CSRMatrixGetNumRows_dbl( matrix, num_rows );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_CSRMatrixGetNumRows_long_dbl( matrix, num_rows );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_CSRMatrixInitialize_pre( HYPRE_Precision precision, HYPRE_CSRMatrix matrix )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_CSRMatrixInitialize_flt( matrix );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_CSRMatrixInitialize_dbl( matrix );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_CSRMatrixInitialize_long_dbl( matrix );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

void
HYPRE_CSRMatrixPrint_pre( HYPRE_Precision precision, HYPRE_CSRMatrix matrix, char *file_name )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_CSRMatrixPrint_flt( matrix, file_name );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_CSRMatrixPrint_dbl( matrix, file_name );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_CSRMatrixPrint_long_dbl( matrix, file_name );
      default:
         hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision");
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_CSRMatrix
HYPRE_CSRMatrixRead_pre( HYPRE_Precision precision, char *file_name )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_CSRMatrixRead_flt( file_name );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_CSRMatrixRead_dbl( file_name );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_CSRMatrixRead_long_dbl( file_name );
      default:
         { HYPRE_CSRMatrix value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MappedMatrixAssemble_pre( HYPRE_Precision precision, HYPRE_MappedMatrix matrix )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MappedMatrixAssemble_flt( matrix );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MappedMatrixAssemble_dbl( matrix );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MappedMatrixAssemble_long_dbl( matrix );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_MappedMatrix
HYPRE_MappedMatrixCreate_pre( HYPRE_Precision precision )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MappedMatrixCreate_flt( );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MappedMatrixCreate_dbl( );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MappedMatrixCreate_long_dbl( );
      default:
         { HYPRE_MappedMatrix value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MappedMatrixDestroy_pre( HYPRE_Precision precision, HYPRE_MappedMatrix matrix )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MappedMatrixDestroy_flt( matrix );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MappedMatrixDestroy_dbl( matrix );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MappedMatrixDestroy_long_dbl( matrix );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MappedMatrixGetColIndex_pre( HYPRE_Precision precision, HYPRE_MappedMatrix matrix, HYPRE_Int j )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MappedMatrixGetColIndex_flt( matrix, j );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MappedMatrixGetColIndex_dbl( matrix, j );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MappedMatrixGetColIndex_long_dbl( matrix, j );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

void *
HYPRE_MappedMatrixGetMatrix_pre( HYPRE_Precision precision, HYPRE_MappedMatrix matrix )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MappedMatrixGetMatrix_flt( matrix );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MappedMatrixGetMatrix_dbl( matrix );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MappedMatrixGetMatrix_long_dbl( matrix );
      default:
         { void * value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MappedMatrixInitialize_pre( HYPRE_Precision precision, HYPRE_MappedMatrix matrix )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MappedMatrixInitialize_flt( matrix );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MappedMatrixInitialize_dbl( matrix );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MappedMatrixInitialize_long_dbl( matrix );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MappedMatrixLimitedDestroy_pre( HYPRE_Precision precision, HYPRE_MappedMatrix matrix )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MappedMatrixLimitedDestroy_flt( matrix );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MappedMatrixLimitedDestroy_dbl( matrix );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MappedMatrixLimitedDestroy_long_dbl( matrix );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

void
HYPRE_MappedMatrixPrint_pre( HYPRE_Precision precision, HYPRE_MappedMatrix matrix )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MappedMatrixPrint_flt( matrix );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MappedMatrixPrint_dbl( matrix );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MappedMatrixPrint_long_dbl( matrix );
      default:
         hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision");
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MappedMatrixSetMapData_pre( HYPRE_Precision precision, HYPRE_MappedMatrix matrix, void *MapData )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MappedMatrixSetMapData_flt( matrix, MapData );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MappedMatrixSetMapData_dbl( matrix, MapData );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MappedMatrixSetMapData_long_dbl( matrix, MapData );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MappedMatrixSetMatrix_pre( HYPRE_Precision precision, HYPRE_MappedMatrix matrix, void *matrix_data )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MappedMatrixSetMatrix_flt( matrix, matrix_data );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MappedMatrixSetMatrix_dbl( matrix, matrix_data );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MappedMatrixSetMatrix_long_dbl( matrix, matrix_data );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MultiblockMatrixAssemble_pre( HYPRE_Precision precision, HYPRE_MultiblockMatrix matrix )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MultiblockMatrixAssemble_flt( matrix );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MultiblockMatrixAssemble_dbl( matrix );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MultiblockMatrixAssemble_long_dbl( matrix );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_MultiblockMatrix
HYPRE_MultiblockMatrixCreate_pre( HYPRE_Precision precision )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MultiblockMatrixCreate_flt( );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MultiblockMatrixCreate_dbl( );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MultiblockMatrixCreate_long_dbl( );
      default:
         { HYPRE_MultiblockMatrix value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MultiblockMatrixDestroy_pre( HYPRE_Precision precision, HYPRE_MultiblockMatrix matrix )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MultiblockMatrixDestroy_flt( matrix );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MultiblockMatrixDestroy_dbl( matrix );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MultiblockMatrixDestroy_long_dbl( matrix );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MultiblockMatrixInitialize_pre( HYPRE_Precision precision, HYPRE_MultiblockMatrix matrix )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MultiblockMatrixInitialize_flt( matrix );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MultiblockMatrixInitialize_dbl( matrix );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MultiblockMatrixInitialize_long_dbl( matrix );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MultiblockMatrixLimitedDestroy_pre( HYPRE_Precision precision, HYPRE_MultiblockMatrix matrix )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MultiblockMatrixLimitedDestroy_flt( matrix );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MultiblockMatrixLimitedDestroy_dbl( matrix );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MultiblockMatrixLimitedDestroy_long_dbl( matrix );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

void
HYPRE_MultiblockMatrixPrint_pre( HYPRE_Precision precision, HYPRE_MultiblockMatrix matrix )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MultiblockMatrixPrint_flt( matrix );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MultiblockMatrixPrint_dbl( matrix );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MultiblockMatrixPrint_long_dbl( matrix );
      default:
         hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision");
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MultiblockMatrixSetNumSubmatrices_pre( HYPRE_Precision precision, HYPRE_MultiblockMatrix matrix, HYPRE_Int n )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MultiblockMatrixSetNumSubmatrices_flt( matrix, n );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MultiblockMatrixSetNumSubmatrices_dbl( matrix, n );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MultiblockMatrixSetNumSubmatrices_long_dbl( matrix, n );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MultiblockMatrixSetSubmatrixType_pre( HYPRE_Precision precision, HYPRE_MultiblockMatrix matrix, HYPRE_Int j, HYPRE_Int type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MultiblockMatrixSetSubmatrixType_flt( matrix, j, type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MultiblockMatrixSetSubmatrixType_dbl( matrix, j, type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MultiblockMatrixSetSubmatrixType_long_dbl( matrix, j, type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_VectorCopy_pre( HYPRE_Precision precision, HYPRE_Vector xvec, HYPRE_Vector yvec )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_VectorCopy_flt( xvec, yvec );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_VectorCopy_dbl( xvec, yvec );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_VectorCopy_long_dbl( xvec, yvec );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Vector
HYPRE_VectorCreate_pre( HYPRE_Precision precision, HYPRE_Int size )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_VectorCreate_flt( size );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_VectorCreate_dbl( size );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_VectorCreate_long_dbl( size );
      default:
         { HYPRE_Vector value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_VectorDestroy_pre( HYPRE_Precision precision, HYPRE_Vector vector )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_VectorDestroy_flt( vector );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_VectorDestroy_dbl( vector );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_VectorDestroy_long_dbl( vector );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_VectorInitialize_pre( HYPRE_Precision precision, HYPRE_Vector vector )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_VectorInitialize_flt( vector );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_VectorInitialize_dbl( vector );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_VectorInitialize_long_dbl( vector );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_VectorPrint_pre( HYPRE_Precision precision, HYPRE_Vector vector, char *file_name )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_VectorPrint_flt( vector, file_name );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_VectorPrint_dbl( vector, file_name );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_VectorPrint_long_dbl( vector, file_name );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Vector
HYPRE_VectorRead_pre( HYPRE_Precision precision, char *file_name )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_VectorRead_flt( file_name );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_VectorRead_dbl( file_name );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_VectorRead_long_dbl( file_name );
      default:
         { HYPRE_Vector value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}



#endif

