# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

import abc
from tempest.lib import exceptions
import testtools

from magnum_tempest_plugin.tests.api.v1.rbac import base


class MagnumServiceTest(base.RbacBaseTests, metaclass=abc.ABCMeta):

    """Tests for magnum-service with RBAC."""

    def __init__(self, *args, **kwargs):
        super(MagnumServiceTest, self).__init__(*args, **kwargs)

    @testtools.testcase.attr('negative')
    def test_magnum_service_list_needs_admin(self):
        self.assertRaises(exceptions.Forbidden,
                          self.service_member_client.magnum_service_list)

    @testtools.testcase.attr('positive')
    def test_magnum_service_list(self):
        # get json object
        resp, msvcs = self.service_admin_client.magnum_service_list()
        self.assertEqual(200, resp.status)
        mcond_svc = msvcs.mservices[0]
        self.assertEqual(mcond_svc['id'], 1)
        self.assertEqual('up', mcond_svc['state'])
        self.assertEqual('magnum-conductor', mcond_svc['binary'])
        self.assertGreater(mcond_svc['report_count'], 0)
