MapServer
=========

[![Build Status](https://github.com/mapserver/mapserver/actions/workflows/build.yml/badge.svg)](https://github.com/mapserver/mapserver/actions?query=workflow%3A%22build%22+branch%3Amain)
[![Appveyor Build Status](https://ci.appveyor.com/api/projects/status/vw1n07095a8bg23u?svg=true)](https://ci.appveyor.com/project/mapserver/mapserver)
[![Coveralls Status](https://coveralls.io/repos/github/MapServer/MapServer/badge.svg?branch=main)](https://coveralls.io/github/MapServer/MapServer?branch=main)
[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.6994443.svg)](https://doi.org/10.5281/zenodo.6994443)

-------
Summary
-------
   
MapServer is a system for developing web-based GIS applications. 
The basic system consists of a CGI program that can be configured to 
respond to a variety of spatial requests like making maps, scalebars, 
and point, area and feature queries. Virtually all aspects of an 
application, from web interface to map appearance can be developed 
without any programming. For the more ambitious user, MapServer 
applications can be enhanced using Python, PHP, Java, JavaScript or 
many other web technologies. For more  information and complete 
documentation please visit:

  https://mapserver.org/

Bug reports and enhancement submissions can be reported in the MapServer 
issue tracker at the following url.   If you do make changes and/or enhancements, 
please let us know so that they might be incorporated into future releases.

  https://github.com/MapServer/MapServer/issues


Join the MapServer user mailing list online at:

  https://mapserver.org/community/lists.html

Credits
-------

MapServer was originally written by Stephen Lime. Major funding for development of 
MapServer has been provided by NASA through cooperative argreements with 
the University of Minnesota, Department of Forest Resources.

PHP/MapScript developed by DM Solutions Group.

GDAL/OGR support and significant WMS support provided by DM Solutions Group 
which received funding support from Canadian Government's GeoConnections 
Program and the Canadian Forest Service.

Raster support developed by Pete Olson of the State of Minnesota, Land 
Management Information Center, and maintained by Frank Warmerdam (DM 
Solutions).

PostGIS spatial database support provided by Dave Blasby of Refractions 
Research.

PDF support developed by Jeff Spielberg and Jamie Wall of Market Insite Group, 
Inc.

OracleSpatial support developed by Rodrigo Cabral of CTTMAR/UNIVALI, Brazil.

Portions Copyright (c) 1998 State of Minnesota, Land Management Information 
Center.

Portions derived from Shapelib, Copyright 1995-1999 Frank Warmerdam.

Supporting packages are covered by their own copyrights.

License
-------

See [LICENSE.md](LICENSE.md)

Security policy
---------------

See [SECURITY.md](SECURITY.md)

How to Contribute
-----------------

See [CONTRIBUTING.md](CONTRIBUTING.md)

Documentation Repository
------------------------

Use the separate [MapServer-documentation](https://github.com/MapServer/MapServer-documentation) 
repository for filing documentation tickets and changes.