;;; matlab-ts-mode--builtins.el --- -*- lexical-binding: t -*-

;; URL: https://github.com/mathworks/Emacs-MATLAB-Mode
;; SPDX-License-Identifier: GPL-3.0-or-later
;;
;; Author: John Ciolfi <john.ciolfi.32@gmail.com>
;; Created: Jul-7-2025
;; Keywords: MATLAB

;; Copyright (C) 2025 Free Software Foundation, Inc.
;;
;; This file is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published
;; by the Free Software Foundation, either version 3 of the License,
;; or (at your option) any later version.
;;
;; This file is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this file.  If not, see <https://www.gnu.org/licenses/>.

;;; Commentary:
;;
;; MATLAB factory functions to highlight with font-lock-builtin-face.
;; These are MATLAB built-in functions such as sin, *.m/*.mex functions, class methods,
;; class enumerations, and class properties.  Any item that exists according to:
;;   >> which FunctionName
;; or,
;;   >> which ClassPath  % where ClassPath is all but the last .<property|enumeration>


;;; Code:

;; See contributing/genBuiltinsHashTable.m to update.

;; Generated using R2025a.update1 on Linux

(defvar matlab-ts-mode--builtins-ht
  #s(hash-table
     test equal
     size 153695
     data (
           "a2ynrow" t ;; (mFile)
           "aa2int" t ;; (mFile) Convert amino acid sequence from letter to integer representation
           "aa2nt" t ;; (mFile) Convert amino acid sequence to nucleotide sequence
           "aacount" t ;; (mFile) Count amino acids in sequence
           "aardvark" t ;; (mFile) Total Phase Aardvark Adapter connection
           "aardvarkfind" t ;; (mFile) Find Total Phase Aardvark controllers
           "aardvarklist" t ;; (mFile) List available Total Phase Aardvark controllers
           "abalone_dataset" t ;; (mFile)
           "abbreviations" t ;; (mFile) Table of common abbreviations
           "abcd2h" t ;; (mFile) Convert ABCD-parameters to hybrid h-parameters
           "abcd2s" t ;; (mFile) Convert ABCD-parameters to S-parameters
           "abcd2y" t ;; (mFile) Convert ABCD-parameters to Y-parameters
           "abcd2z" t ;; (mFile) Convert ABCD-parameters to Z-parameters
           "abcdchk" t ;; (mFile)
           "abcdchkm" t ;; (mFile)
           "abcdparameters" t ;; (mFile) Create ABCD parameter object
           "abcToAlpha_Beta_Zero_class" t ;; (pFile)
           "abcToDq0_class" t ;; (pFile)
           "aboutcommsystbx" t ;; (mFile)
           "aboutcst" t ;; (mFile)
           "aboutdspsystbx" t ;; (mFile)
           "aboutfixedpttlbx" t ;; (mFile)
           "aboutidenttbx" t ;; (mFile)
           "aboutmsblks" t ;; (mFile)
           "aboutphasedtbx" t ;; (mFile)
           "aboutradartbx" t ;; (mFile)
           "aboutserdestbx" t ;; (mFile)
           "aboutsignaltbx" t ;; (mFile)
           "aboutvipblks" t ;; (mFile)
           "abs" t ;; (mFile) Absolute value and complex magnitude
           "abs2active" t ;; (mFile) Convert constraints from absolute to active format
           "AbstractCodistributor" t ;; (mFile)
           "AbstractPortfolio" t ;; (mFile)
           "AbstractSim3DTruthSensor" t ;; (pFile)
           "abv" t ;; (mFile)
           "abyss" t ;; (mFile) Abyss colormap array
           "ac0Reader" t ;; (mFile) Converts AC analysis simulation results from Synopsys to CSV file or MATLAB table
           "AC1AExcitationSystem_class" t ;; (pFile)
           "ac2poly" t ;; (mFile) Convert autocorrelation sequence to prediction polynomial
           "ac2rc" t ;; (mFile) Convert autocorrelation sequence to reflection coefficients
           "AC4AExcitationSystem_class" t ;; (pFile)
           "AC5AExcitationSystem_class" t ;; (pFile)
           "accblock_callbackCreateSubsystemButton" t ;; (mFile)
           "accblock_MaskInitFcn" t ;; (mFile)
           "accblock_utilExportDataStruct" t ;; (mFile)
           "accblock_utilParameterCheck" t ;; (mFile)
           "accdemo" t ;; (mFile)
           "accel_default_tmf" t ;; (mFile)
           "accelbuild" t ;; (mFile)
           "accelbuild_private" t ;; (pFile)
           "accelBuildDir" t ;; (mFile)
           "accelcal" t ;; (mFile) Calibration parameters for accelerometer
           "accelload_private" t ;; (mFile)
           "accelparams" t ;; (mFile) Accelerometer sensor parameters
           "acceptancesa" t ;; (mFile)
           "accessPersistentProfileInfo" t ;; (mFile)
           "acceva" t ;; (mFile)
           "acceva2" t ;; (mFile)
           "accplt" t ;; (mFile)
           "accrfrac" t ;; (mFile) Fraction of coupon period before settlement
           "accroot" t ;; (mFile)
           "accumarray" t ;; (mFile) Accumulate vector elements
           "accumneg" t ;; (mFile) Subtract two fi objects or values
           "accumpos" t ;; (mFile) Add two fi objects or values
           "accumulatefi" t ;; (mFile)
           "accuracyMetric" t ;; (mFile) Deep learning accuracy metric
           "ACCurrentSource_class" t ;; (pFile)
           "acde" t ;; (mFile)
           "acfObjectDetector" t ;; (mFile) Detect objects using aggregate channel features
           "acfObjectDetector.getDefaultParameters" t ;; (method)
           "acfObjectDetector.matlabCodegenSoftNontunableProperties" t ;; (method)
           "acfObjectDetectorMonoCamera" t ;; (mFile) Detect objects in monocular camera using aggregate channel features
           "acfObjectDetectorMonoCamera.getDefaultParameters" t ;; (method)
           "acfObjectDetectorMonoCamera.matlabCodegenSoftNontunableProperties" t ;; (method)
           "acker" t ;; (mFile)
           "ackermannKinematics" t ;; (mFile) Car-like steering vehicle model
           "aconstrsh" t ;; (pFile)
           "acos" t ;; (mFile) Inverse cosine in radians
           "acosd" t ;; (mFile) Inverse cosine in degrees
           "acosh" t ;; (mFile) Inverse hyperbolic cosine
           "acot" t ;; (mFile) Inverse cotangent in radians
           "acotd" t ;; (mFile) Inverse cotangent in degrees
           "acoth" t ;; (mFile) Inverse hyperbolic cotangent
           "acousticFluctuation" t ;; (mFile) Perceived fluctuation strength of acoustic signal
           "acousticLoudness" t ;; (mFile) Perceived loudness of acoustic signal
           "acousticProminenceRatio" t ;; (mFile) Quantify tonality by comparing critical bands
           "acousticRoomResponse" t ;; (mFile) Synthesize room impulse response
           "acousticRoughness" t ;; (mFile) Perceived roughness of acoustic signal
           "acousticSharpness" t ;; (mFile) Perceived sharpness of acoustic signal
           "acousticToneToNoiseRatio" t ;; (mFile) Identify and quantify tones in acoustic signals
           "acrubond" t ;; (mFile) Accrued interest of security with periodic interest payments
           "acrudisc" t ;; (mFile) Accrued interest of discount security paying at maturity
           "acsc" t ;; (mFile) Inverse cosecant in radians
           "acscd" t ;; (mFile) Inverse cosecant in degrees
           "acsch" t ;; (mFile) Inverse hyperbolic cosecant
           "ACSourceInit" t ;; (pFile)
           "actdemo" t ;; (mFile)
           "action_highlight" t ;; (pFile)
           "action_highlight_sf" t ;; (pFile)
           "activateuimode" t ;; (mFile)
           "active2abs" t ;; (mFile) Convert constraints from active to absolute format
           "activecontour" t ;; (mFile) Segment image into foreground and background using active contours (snakes) region growing technique
           "ActiveRectifier_class" t ;; (pFile)
           "ActivityDiagramLibrary" t ;; (slxFile)
           "actorImportOptions" t ;; (mFile) Specify options for customizing actors imported with CSV files
           "actxcontrol" t ;; (mFile) (Removed) Create Microsoft ActiveX control in figure window
           "actxcontrolcreateproperty" t ;; (mFile)
           "actxcontrollist" t ;; (mFile) (Removed) List currently installed Microsoft ActiveX controls
           "actxcontrollist_internal" t ;; (mex)
           "actxcontrolselect" t ;; (mFile) (Removed) Create Microsoft ActiveX control from UI
           "actxGetRunningServer" t ;; (mFile) Handle to running instance of Automation server
           "actxproxy" t ;; (mFile)
           "actxserver" t ;; (mFile) Create COM server
           "ACVoltageSource_class" t ;; (pFile)
           "ACVoltageSourceCback" t ;; (pFile)
           "adamupdate" t ;; (mFile) Update parameters using adaptive moment estimation (Adam)
           "adapt_lms" t ;; (mFile)
           "adapthisteq" t ;; (mFile) Contrast-limited adaptive histogram equalization (CLAHE)
           "adaptiveAveragePooling2dLayer" t ;; (mFile) Adaptive average pooling 2-D layer
           "adaptkalman" t ;; (mFile)
           "adaptmesh" t ;; (mFile) Create adaptive 2-D mesh and solve PDE
           "adaptthresh" t ;; (mFile) Adaptive image threshold using local first-order statistics
           "adaptwb" t ;; (mFile) Adapt network with weight and bias learning rules
           "adasblocks_callbackEnablePanel" t ;; (mFile)
           "adasblocks_callbackUsesuboptimal" t ;; (mFile)
           "adasblocks_utilDicretizeModel" t ;; (mFile)
           "adasblocks_utilGetLatVehModelFromParam" t ;; (mFile)
           "adasblocks_utilGetLongVehModelFromParam" t ;; (mFile)
           "adasblocks_utilUpdateInport" t ;; (mFile)
           "adasblocks_utilUpdateOutport" t ;; (mFile)
           "adasblocks_utilUseExternal" t ;; (mFile)
           "add_block" t ;; (mFile) Add block to model
           "add_disk" t ;; (mFile)
           "add_engine_event_listener" t ;; (pFile)
           "add_exec_event_listener" t ;; (pFile) Register listener for block method execution event
           "add_line" t ;; (mFile) Add line to Simulink model
           "add_mpm_path" t ;; (mFile)
           "add_param" t ;; (mFile) Add parameter to Simulink model
           "add_slclientinfo" t ;; (mFile)
           "addbdtlevel" t ;; (mFile)
           "addBlock" t ;; (mFile) Add block to library
           "addBusinessCalendar" t ;; (mFile) Add business calendar awareness to timetables
           "addcsmenu" t ;; (mFile)
           "addCustomBasemap" t ;; (mFile) Add custom basemap
           "addCustomPackageRepositoryConnection" t ;; (mFile)
           "addCustomTerrain" t ;; (mFile) Add custom terrain data
           "adddatadlg" t ;; (mFile)
           "adddelay" t ;; (mFile) Add delay to neural network response
           "adddynprop" t ;; (mFile)
           "AddEditParameterDialog" t ;; (mlappFile)
           "AddEditParameterDialog.loadobj" t ;; (method)
           "AddEditTapsDialog" t ;; (mlappFile)
           "AddEditTapsDialog.loadobj" t ;; (method)
           "addedvarplot" t ;; (mFile) Create added variable plot using input data
           "addFilterBom" t ;; (pFile)
           "addFPGABoard" t ;; (mFile)
           "addfreqcsmenu" t ;; (mFile)
           "addin" t ;; (mFile)
           "additionLayer" t ;; (mFile) Addition layer
           "addlift" t ;; (mFile) (To be removed) Add lifting steps to lifting scheme
           "addlistener" t ;; (mFile)
           "addmavlinkkeys" t ;; (mFile) Add MAVLink keys from .env file
           "addmd" t ;; (mFile)
           "addmenu" t ;; (mFile)
           "addmf" t ;; (mFile)
           "addMinPhase" t ;; (mFile) Add minimum phase to frequency response magnitude
           "addmod" t ;; (mFile)
           "addNewBlock" t ;; (pFile)
           "addoutputspec" t ;; (mFile) Add output specification to operating point specification
           "addPanelBackgroundFromToolstrip" t ;; (pFile)
           "addpath" t ;; (mFile) Add folders to search path
           "addPix2PixHDLocalEnhancer" t ;; (mFile) Add local enhancer network to pix2pixHD generator network
           "addplugins" t ;; (mFile)
           "addpoints" t ;; (mFile) Add points to animated line
           "addPortCallback" t ;; (mFile)
           "addpref" t ;; (mFile) Add custom setting
           "addprops" t ;; (mFile)
           "addpv" t ;; (mFile)
           "addrule" t ;; (mFile) Add rule object to model
           "addss" t ;; (mFile)
           "addStandardInfo" t ;; (mFile)
           "addsubplot" t ;; (mFile)
           "addtdkfpgaconfig" t ;; (pFile)
           "addterms" t ;; (pFile) Add terminators to unconnected ports in model
           "addtimecsmenu" t ;; (mFile)
           "addtodate" t ;; (mFile) (Not recommended; use duration or calendarDuration) Add time to serial date number
           "addToHDLEntityList" t ;; (pFile)
           "addtoolbarbtn" t ;; (mFile)
           "addToolbarExplorationButtons" t ;; (pFile) Add data exploration buttons to figure toolbar
           "addToolbarMapButton" t ;; (mFile) Add map button to toolbar
           "addumd" t ;; (mFile)
           "AddVariablesToMask" t ;; (mFile)
           "AddVariablesToUserdata" t ;; (mFile)
           "addvsschoiceddg_cb" t ;; (pFile)
           "ade2metric" t ;; (mFile) Extract metric data from Cadence simulation run
           "ade2wave" t ;; (mFile) Extract waveform data from Cadence simulation run
           "adeDataReader" t ;; (mFile) Read adeInfo object and extract metrics for visualization and analysis
           "adeDataReader.processTabledata" t ;; (method)
           "adeDataReader.processTableForSorting" t ;; (method)
           "adeDataReader.trendTable" t ;; (method)
           "adeGet" t ;; (mFile) Extract simulation parameters and variables from Cadence Maestro
           "adeinfo2msa" t ;; (mFile) Extract simulation data from Cadence to Mixed Signal Analyzer app
           "adeSet" t ;; (mFile) Set simulation parameters and variables in Cadence ADE Maestro
           "adeSim" t ;; (mFile) Run simulation as setup in the Cadence ADE Maestro view
           "adftest" t ;; (mFile) Augmented Dickey-Fuller test
           "adis16505" t ;; (mFile) Connect to ADIS16505 sensor on Arduino hardware SPI bus
           "adis16505.InterruptPin" 'property
           "adjacentPairCorrelationModel" t ;; (mFile) Identify worst cell relative to other cells in serially connected lithium-ion battery pack
           "adjoint" t ;; (mFile) Classical adjoint (adjugate) of square matrix
           "adjustCoefficients" t ;; (mFile)
           "adjustedClosingPrices" t ;; (mFile) Adjust closing stock prices for splits and cash dividends
           "adline" t ;; (mFile) Accumulation/Distribution line
           "adosc" t ;; (mFile) Accumulation/Distribution oscillator
           "adptfiltsubsys" t ;; (mdlFile)
           "adsbCategory" t ;; (mFile) Enumeration of Automatic Dependent Surveillance-Broadcast categories
           "adsbCategory.Glider_Sailplane" 'enumeration
           "adsbCategory.Heavy" 'enumeration
           "adsbCategory.High_Performance" 'enumeration
           "adsbCategory.High_Vortex_Large" 'enumeration
           "adsbCategory.Large" 'enumeration
           "adsbCategory.Light" 'enumeration
           "adsbCategory.Lighter_than_air" 'enumeration
           "adsbCategory.No_Category_Information" 'enumeration
           "adsbCategory.Obstacle" 'enumeration
           "adsbCategory.Parachutist_Skydiver" 'enumeration
           "adsbCategory.Rotorcraft" 'enumeration
           "adsbCategory.Small" 'enumeration
           "adsbCategory.Space_Vehicle" 'enumeration
           "adsbCategory.Surface_Vehicle" 'enumeration
           "adsbCategory.Ultralight" 'enumeration
           "adsbCategory.Unmanned_Aerial_Vehicle" 'enumeration
           "adsbReceiver" t ;; (mFile) Automatic Dependent Surveillance-Broadcast (ADS-B) receiver
           "adsbTransponder" t ;; (mFile) Automatic Dependent Surveillance-Broadcast (ADS-B) transponder
           "adtest" t ;; (mFile) Anderson-Darling test
           "adtfFileReader" t ;; (mFile) Read stream information from ADTF DAT file
           "adtfFileReader.UnsupportedStreamTypes" 'property
           "adtfStreamReader" t ;; (mFile) Stream reader for ADTF DAT file
           "advantage" t ;; (mFile)
           "advice" t ;; (mFile) Analysis and recommendations for data or estimated linear models
           "Advisor.Action" t ;; (class)
           "Advisor.addExclusion" t ;; (function)
           "Advisor.AdvisorAlignTypeEnum" t ;; (class)
           "Advisor.AdvisorAlignTypeEnum.center" 'enumeration
           "Advisor.AdvisorAlignTypeEnum.left" 'enumeration
           "Advisor.AdvisorAlignTypeEnum.right" 'enumeration
           "Advisor.AdvisorClickBehaviorEnum" t ;; (class)
           "Advisor.AdvisorClickBehaviorEnum.hilight" 'enumeration
           "Advisor.AdvisorClickBehaviorEnum.open" 'enumeration
           "Advisor.AdvisorCollapsibleModeEnum" t ;; (class)
           "Advisor.AdvisorCollapsibleModeEnum.all" 'enumeration
           "Advisor.AdvisorCollapsibleModeEnum.none" 'enumeration
           "Advisor.AdvisorCollapsibleModeEnum.systemdefined" 'enumeration
           "Advisor.AdvisorDefaultCollapsibleStateEnum" t ;; (class)
           "Advisor.AdvisorDefaultCollapsibleStateEnum.collapsed" 'enumeration
           "Advisor.AdvisorDefaultCollapsibleStateEnum.expanded" 'enumeration
           "Advisor.AdvisorFactory" t ;; (class)
           "Advisor.AdvisorFactory.getAdvisorTypeObj" t ;; (method)
           "Advisor.AdvisorListTypeEnum" t ;; (class)
           "Advisor.AdvisorListTypeEnum.Bulleted" 'enumeration
           "Advisor.AdvisorListTypeEnum.Numbered" 'enumeration
           "Advisor.AdvisorTableStyleChoices" t ;; (class)
           "Advisor.AdvisorTableStyleChoices.AltRow" 'enumeration
           "Advisor.AdvisorTableStyleChoices.AltRowBgColor" 'enumeration
           "Advisor.AdvisorTableStyleChoices.AltRowBgColorBeginWithWhite" 'enumeration
           "Advisor.AdvisorTableStyleChoices.Default" 'enumeration
           "Advisor.AdvisorWindow" t ;; (class)
           "Advisor.AppBase" t ;; (class)
           "Advisor.Application" t ;; (class)
           "Advisor.authoring.AUTOSARSystemTargetFileParameterConstraint" t ;; (class)
           "Advisor.authoring.AUTOSARSystemTargetFileParameterConstraint.createComplexValueNode" t ;; (method)
           "Advisor.authoring.AUTOSARSystemTargetFileParameterConstraint.getParameterDataType" t ;; (method)
           "Advisor.authoring.AUTOSARSystemTargetFileParameterConstraint.SupportedParameterValues" 'property
           "Advisor.authoring.AUTOSARSystemTargetFileParameterConstraint.value2String" t ;; (method)
           "Advisor.authoring.BlockParameterConstraint" t ;; (function)
           "Advisor.authoring.BlockTypeConstraint" t ;; (function)
           "Advisor.authoring.CheckStorage" t ;; (class)
           "Advisor.authoring.CheckStorage.getInstance" t ;; (method)
           "Advisor.authoring.CompositeConstraint" t ;; (class)
           "Advisor.authoring.Constraint" t ;; (class)
           "Advisor.authoring.createBlockConstraintCheck" t ;; (function)
           "Advisor.authoring.CustomCheck" t ;; (class)
           "Advisor.authoring.CustomCheck.actionCallback" t ;; (method)
           "Advisor.authoring.CustomCheck.checkAlgorithmCallback" t ;; (method)
           "Advisor.authoring.CustomCheck.checkCallback" t ;; (method)
           "Advisor.authoring.CustomCheck.newStyleCheckCallback" t ;; (method)
           "Advisor.authoring.CustomCheck.newStyleReportCallback" t ;; (method)
           "Advisor.authoring.CustomCheck.outputFormattingCallback" t ;; (method)
           "Advisor.authoring.CustomCheck.verifyCompositeConstraintDependencies" t ;; (method)
           "Advisor.authoring.CustomCheck.verifyConstraintDependencies" t ;; (method)
           "Advisor.authoring.DataFile" t ;; (class)
           "Advisor.authoring.DataFile.generateTimeStamp" t ;; (method)
           "Advisor.authoring.DataFile.getSchemaFilePath" t ;; (method)
           "Advisor.authoring.DataFile.validate" t ;; (method)
           "Advisor.authoring.deleteCheck" t ;; (function)
           "Advisor.authoring.ERTSystemTargetFileParameterConstraint" t ;; (class)
           "Advisor.authoring.ERTSystemTargetFileParameterConstraint.createComplexValueNode" t ;; (method)
           "Advisor.authoring.ERTSystemTargetFileParameterConstraint.getParameterDataType" t ;; (method)
           "Advisor.authoring.ERTSystemTargetFileParameterConstraint.SupportedParameterValues" 'property
           "Advisor.authoring.ERTSystemTargetFileParameterConstraint.value2String" t ;; (method)
           "Advisor.authoring.generateBlockConstraintsDataFile" t ;; (function)
           "Advisor.authoring.generateConfigurationParameterDataFile" t ;; (function)
           "Advisor.authoring.ModelParameterConstraint" t ;; (class)
           "Advisor.authoring.ModelParameterConstraint.createComplexValueNode" t ;; (method)
           "Advisor.authoring.ModelParameterConstraint.getParameterDataType" t ;; (method)
           "Advisor.authoring.ModelParameterConstraint.value2String" t ;; (method)
           "Advisor.authoring.NegativeBlockParameterConstraint" t ;; (class)
           "Advisor.authoring.NegativeBlockTypeConstraint" t ;; (class)
           "Advisor.authoring.NegativeModelParameterConstraint" t ;; (class)
           "Advisor.authoring.NegativeModelParameterConstraint.createComplexValueNode" t ;; (method)
           "Advisor.authoring.NegativeModelParameterConstraint.getParameterDataType" t ;; (method)
           "Advisor.authoring.NegativeModelParameterConstraint.value2String" t ;; (method)
           "Advisor.authoring.OutputFormatting" t ;; (class)
           "Advisor.authoring.parseConstraintsArray" t ;; (function)
           "Advisor.authoring.PositiveBlockParameterConstraint" t ;; (class)
           "Advisor.authoring.PositiveBlockTypeConstraint" t ;; (class)
           "Advisor.authoring.PositiveModelParameterConstraint" t ;; (class)
           "Advisor.authoring.PositiveModelParameterConstraint.createComplexValueNode" t ;; (method)
           "Advisor.authoring.PositiveModelParameterConstraint.getParameterDataType" t ;; (method)
           "Advisor.authoring.PositiveModelParameterConstraint.value2String" t ;; (method)
           "Advisor.authoring.registerNewCheck" t ;; (function)
           "Advisor.authoring.utils.convertToNewBlockConstraintCheck" t ;; (function)
           "Advisor.authoring.utils.getXMLDataFromCheck" t ;; (function)
           "Advisor.BaseRegisterCGIRInspectorResults" t ;; (class)
           "Advisor.BaseRegisterCGIRInspectorResults.isValidMATLABFcnStartEndPostFix" t ;; (method)
           "Advisor.BaseRegisterCGIRInspectorResults.removeDuplicateEntries" t ;; (method)
           "Advisor.BaseRegisterCGIRInspectorResults.removeEmptyEntries" t ;; (method)
           "Advisor.BaseRegisterCGIRInspectorResults.splitUp" t ;; (method)
           "Advisor.BaseRegisterCGIRInspectors" t ;; (class)
           "Advisor.Callback" t ;; (class)
           "Advisor.CheckExecutionStartEventDataClass" t ;; (class)
           "Advisor.CheckSelector" t ;; (class)
           "Advisor.clearExclusion" t ;; (function)
           "Advisor.CompileModes" t ;; (class)
           "Advisor.CompileModes.CGIR" 'enumeration
           "Advisor.CompileModes.char2mode" t ;; (method)
           "Advisor.CompileModes.CommandLineSimulation" 'enumeration
           "Advisor.CompileModes.Coverage" 'enumeration
           "Advisor.CompileModes.DIY" 'enumeration
           "Advisor.CompileModes.None" 'enumeration
           "Advisor.CompileModes.RTW" 'enumeration
           "Advisor.CompileModes.SLDV" 'enumeration
           "Advisor.CompileModes.validateCompileMode" t ;; (method)
           "Advisor.component.Component" t ;; (class)
           "Advisor.component.Component.IsLinked" 'property
           "Advisor.component.ComponentIDGenerator" t ;; (class)
           "Advisor.component.ComponentIDGenerator.generateID" t ;; (method)
           "Advisor.component.ComponentManager" t ;; (class)
           "Advisor.component.getComponentFile" t ;; (function)
           "Advisor.component.getComponentPath" t ;; (function)
           "Advisor.component.getComponentSource" t ;; (function)
           "Advisor.component.isMWFile" t ;; (function)
           "Advisor.component.isValidAnalysisRoot" t ;; (function)
           "Advisor.component.Types" t ;; (class)
           "Advisor.component.Types.Chart" 'enumeration
           "Advisor.component.Types.LibraryBlock" 'enumeration
           "Advisor.component.Types.MATLABFunction" 'enumeration
           "Advisor.component.Types.MFile" 'enumeration
           "Advisor.component.Types.Model" 'enumeration
           "Advisor.component.Types.ProtectedModel" 'enumeration
           "Advisor.component.Types.SubSystem" 'enumeration
           "Advisor.Config" t ;; (class)
           "Advisor.Document" t ;; (class)
           "Advisor.Element" t ;; (class)
           "Advisor.ExclusionEditor" t ;; (class)
           "Advisor.ExclusionEditorBase" t ;; (class)
           "Advisor.ExclusionEditorUIService" t ;; (class)
           "Advisor.ExclusionEditorUIService.getInstance" t ;; (method)
           "Advisor.ExclusionEditorWindow" t ;; (class)
           "Advisor.Frame" t ;; (class)
           "Advisor.Frameset" t ;; (class)
           "Advisor.getExclusion" t ;; (function)
           "Advisor.getExclusionEditor" t ;; (function)
           "Advisor.Image" t ;; (class)
           "Advisor.justifyCheck" t ;; (function)
           "Advisor.LineBreak" t ;; (class)
           "Advisor.List" t ;; (class)
           "Advisor.loadAdvisor" t ;; (function)
           "Advisor.loadExclusion" t ;; (function)
           "Advisor.MAAppCB" t ;; (function)
           "Advisor.MACEUIController" t ;; (class)
           "Advisor.MACEWindow" t ;; (class)
           "Advisor.Manager" t ;; (class)
           "Advisor.Manager.createApplication" t ;; (method)
           "Advisor.Manager.getApplication" t ;; (method)
           "Advisor.Manager.refresh_customizations" t ;; (method)
           "Advisor.Manager.update_customizations" t ;; (method)
           "Advisor.Manager.writeCache" t ;; (method)
           "Advisor.MATLABFileDependencyService" t ;; (class)
           "Advisor.MATLABFileDependencyService.getInstance" t ;; (method)
           "Advisor.MATLABFileDependencyService.initialize" t ;; (method)
           "Advisor.MATLABFileDependencyService.reset" t ;; (method)
           "Advisor.ModelAdvisorCBContextEnum" t ;; (class)
           "Advisor.ModelAdvisorCBContextEnum.CGIR" 'enumeration
           "Advisor.ModelAdvisorCBContextEnum.Coverage" 'enumeration
           "Advisor.ModelAdvisorCBContextEnum.DIY" 'enumeration
           "Advisor.ModelAdvisorCBContextEnum.None" 'enumeration
           "Advisor.ModelAdvisorCBContextEnum.PostCompile" 'enumeration
           "Advisor.ModelAdvisorCBContextEnum.PostCompileForCodegen" 'enumeration
           "Advisor.ModelAdvisorCBContextEnum.RTW" 'enumeration
           "Advisor.ModelAdvisorCBContextEnum.SLDV" 'enumeration
           "Advisor.ModelAdvisorCBStyleEnum" t ;; (class)
           "Advisor.ModelAdvisorCBStyleEnum.DetailStyle" 'enumeration
           "Advisor.ModelAdvisorCBStyleEnum.StyleOne" 'enumeration
           "Advisor.ModelAdvisorCBStyleEnum.StyleThree" 'enumeration
           "Advisor.ModelAdvisorCBStyleEnum.StyleTwo" 'enumeration
           "Advisor.ModelAdvisorCheckTypeEnum" t ;; (class)
           "Advisor.ModelAdvisorCheckTypeEnum.Informational" 'enumeration
           "Advisor.ModelAdvisorCheckTypeEnum.Standard" 'enumeration
           "Advisor.ModelAdvisorTaskSeverity" t ;; (class)
           "Advisor.ModelAdvisorTaskSeverity.Optional" 'enumeration
           "Advisor.ModelAdvisorTaskSeverity.Required" 'enumeration
           "Advisor.ModelAdvisorTriStateEnum" t ;; (class)
           "Advisor.ModelAdvisorTriStateEnum.checked" 'enumeration
           "Advisor.ModelAdvisorTriStateEnum.partial" 'enumeration
           "Advisor.ModelAdvisorTriStateEnum.unchecked" 'enumeration
           "Advisor.ModelAdvisorViewModeEnum" t ;; (class)
           "Advisor.ModelAdvisorViewModeEnum.MADashboard" 'enumeration
           "Advisor.ModelAdvisorViewModeEnum.MAStandardUI" 'enumeration
           "Advisor.Options" t ;; (class)
           "Advisor.Options.getInstance" t ;; (method)
           "Advisor.Options.getOption" t ;; (method)
           "Advisor.Panel" t ;; (class)
           "Advisor.Paragraph" t ;; (class)
           "Advisor.RegisterCGIRInspectorResults" t ;; (class)
           "Advisor.RegisterCGIRInspectorResults.getInstance" t ;; (method)
           "Advisor.RegisterCGIRInspectorResults.isValidMATLABFcnStartEndPostFix" t ;; (method)
           "Advisor.RegisterCGIRInspectorResults.modelReferenceInfo" t ;; (method)
           "Advisor.RegisterCGIRInspectorResults.removeDuplicateEntries" t ;; (method)
           "Advisor.RegisterCGIRInspectorResults.removeEmptyEntries" t ;; (method)
           "Advisor.RegisterCGIRInspectorResults.splitUp" t ;; (method)
           "Advisor.RegisterCGIRInspectors" t ;; (class)
           "Advisor.RegisterCGIRInspectors.getInstance" t ;; (method)
           "Advisor.removeExclusion" t ;; (function)
           "Advisor.ResultData" t ;; (class)
           "Advisor.saveExclusion" t ;; (function)
           "Advisor.SLDVCompileService" t ;; (class)
           "Advisor.SLDVCompileService.getInstance" t ;; (method)
           "Advisor.SLDVCompileService.reset" t ;; (method)
           "Advisor.SLDVCompileService.runSLDV" t ;; (method)
           "Advisor.str2enum" t ;; (function)
           "Advisor.Table" t ;; (class)
           "Advisor.TaskManager" t ;; (class)
           "Advisor.Text" t ;; (class)
           "Advisor.Toolstrip" t ;; (class)
           "Advisor.Toolstrip.callbackHandler" t ;; (method)
           "Advisor.Toolstrip.constructCount" t ;; (method)
           "Advisor.Toolstrip.deleteCount" t ;; (method)
           "Advisor.UIController" t ;; (class)
           "Advisor.UIService" t ;; (class)
           "Advisor.UIService.getInstance" t ;; (method)
           "Advisor.Utils.AdvisorRootIds" t ;; (class)
           "Advisor.Utils.AdvisorRootIds.HDLAdvisor" 'property
           "Advisor.Utils.AdvisorRootIds.ModelReferenceConversionAdvisor" 'property
           "Advisor.Utils.AdvisorRootIds.PerformanceAdvisor" 'property
           "Advisor.Utils.connectTree" t ;; (function)
           "Advisor.Utils.convertMCOS" t ;; (function)
           "Advisor.Utils.convertProjectResultDataIntoResultDetailObjs" t ;; (function)
           "Advisor.Utils.copyTree" t ;; (function)
           "Advisor.Utils.createCheckObjForTree" t ;; (function)
           "Advisor.Utils.createDialogSchemaForInputParamBlockTable" t ;; (function)
           "Advisor.Utils.createEdittimeCheckData" t ;; (function)
           "Advisor.Utils.createJSONfromStruct" t ;; (function)
           "Advisor.Utils.createResultDetailObjs" t ;; (function)
           "Advisor.Utils.createStandardInputParameters" t ;; (function)
           "Advisor.Utils.defaultActionCBforEdittimeCheck" t ;; (function)
           "Advisor.Utils.edittimeCheckDefinedFixCallback" t ;; (function)
           "Advisor.Utils.Eml.getDataTypeFromMnode" t ;; (function)
           "Advisor.Utils.Eml.getEMLParentOfReferencedFile" t ;; (function)
           "Advisor.Utils.Eml.getEmlReport" t ;; (function)
           "Advisor.Utils.Eml.getEMLStandardInputParams" t ;; (function)
           "Advisor.Utils.Eml.getFullNameFromEmlObj" t ;; (function)
           "Advisor.Utils.Eml.getReferencedMFiles" t ;; (function)
           "Advisor.Utils.exportJSON" t ;; (function)
           "Advisor.Utils.filterBuiltInBlocks" t ;; (function)
           "Advisor.Utils.find_system" t ;; (function)
           "Advisor.Utils.fixConfigurationFile" t ;; (function)
           "Advisor.Utils.genericCheckCallback" t ;; (function)
           "Advisor.Utils.getAllMATLABFunctionBlocks" t ;; (function)
           "Advisor.Utils.getAllMATLABFunctions" t ;; (function)
           "Advisor.Utils.getAllowedSizesJunction" t ;; (function)
           "Advisor.Utils.getAllowedSizesSFArrow" t ;; (function)
           "Advisor.Utils.getConfigSetParameterUIPrompt" t ;; (function)
           "Advisor.Utils.getDefaultCheckObject" t ;; (function)
           "Advisor.Utils.getFullName" t ;; (function)
           "Advisor.Utils.getHighlightedMAText" t ;; (function)
           "Advisor.Utils.getHyperlinkToBlockParameter" t ;; (function)
           "Advisor.Utils.getHyperlinkToConfigSetParameter" t ;; (function)
           "Advisor.Utils.getInportFromSLFcn" t ;; (function)
           "Advisor.Utils.getInputParam_Bool" t ;; (function)
           "Advisor.Utils.getInputParam_Enum" t ;; (function)
           "Advisor.Utils.getInputParam_String" t ;; (function)
           "Advisor.Utils.getListReport" t ;; (function)
           "Advisor.Utils.getMtreeNodeInfo" t ;; (function)
           "Advisor.Utils.getStandardInputParameters" t ;; (function)
           "Advisor.Utils.getTableOfConflicts" t ;; (function)
           "Advisor.Utils.getTwoColumnReport" t ;; (function)
           "Advisor.Utils.Graph.calculateRanks" t ;; (function)
           "Advisor.Utils.Graph.findCycles" t ;; (function)
           "Advisor.Utils.Graph.getAdjMatFrmTransition" t ;; (function)
           "Advisor.Utils.Graph.getBlocksOnlyGraphFromSubsystem" t ;; (function)
           "Advisor.Utils.Graph.getConnectedComponents" t ;; (function)
           "Advisor.Utils.Graph.getDistances" t ;; (function)
           "Advisor.Utils.Graph.getPredecessors" t ;; (function)
           "Advisor.Utils.Graph.getStronglyConnectedComponents" t ;; (function)
           "Advisor.Utils.Graph.getSuccessors" t ;; (function)
           "Advisor.Utils.Graph.isBlockHandleInFeedbackLoop" t ;; (function)
           "Advisor.Utils.importConfigurationXML" t ;; (function)
           "Advisor.Utils.importEditTimeXML" t ;; (function)
           "Advisor.Utils.isaKeyword" t ;; (function)
           "Advisor.Utils.isChildOfShippingBlock" t ;; (function)
           "Advisor.Utils.isSFChart" t ;; (function)
           "Advisor.Utils.isValidMtree" t ;; (function)
           "Advisor.Utils.Justification.createSimulinkBanner" t ;; (function)
           "Advisor.Utils.Justification.justifyViolation" t ;; (function)
           "Advisor.Utils.Justification.serialize" t ;; (function)
           "Advisor.Utils.Justification.unjustifyViolation" t ;; (function)
           "Advisor.Utils.license" t ;; (function)
           "Advisor.Utils.license_AdvisorEditTimeCheckingMenu" t ;; (function)
           "Advisor.Utils.license_MACEMenu" t ;; (function)
           "Advisor.Utils.LoadLinkCharts" t ;; (function)
           "Advisor.Utils.LoadRestorePoint" t ;; (class)
           "Advisor.Utils.LoadRestorePoint.getLoadRestorePointObject" t ;; (method)
           "Advisor.Utils.LoadRestorePointForFPCA" t ;; (class)
           "Advisor.Utils.LoadRestorePointForFPCA.getLoadRestorePointObject" t ;; (method)
           "Advisor.Utils.LoadRestorePointForHDLAdvisor" t ;; (class)
           "Advisor.Utils.LoadRestorePointForHDLAdvisor.getLoadRestorePointObject" t ;; (method)
           "Advisor.Utils.LoadRestorePointForMdlRefAdvisor" t ;; (class)
           "Advisor.Utils.LoadRestorePointForMdlRefAdvisor.getLoadRestorePointObject" t ;; (method)
           "Advisor.Utils.LoadRestorePointForPerformanceAdvisor" t ;; (class)
           "Advisor.Utils.LoadRestorePointForPerformanceAdvisor.getLoadRestorePointObject" t ;; (method)
           "Advisor.Utils.Naming.checkBlockNames" t ;; (function)
           "Advisor.Utils.Naming.checkBusNames" t ;; (function)
           "Advisor.Utils.Naming.checkParameterNames" t ;; (function)
           "Advisor.Utils.Naming.checkPortNames" t ;; (function)
           "Advisor.Utils.Naming.checkSignalNames" t ;; (function)
           "Advisor.Utils.Naming.checkStateflowNames" t ;; (function)
           "Advisor.Utils.Naming.checkSystemComposerInterfaceStereotypeNames" t ;; (function)
           "Advisor.Utils.Naming.filterUsersInShippingLibraries" t ;; (function)
           "Advisor.Utils.Naming.formatFlaggedName" t ;; (function)
           "Advisor.Utils.Naming.getDASText" t ;; (function)
           "Advisor.Utils.Naming.getFailingReason" t ;; (function)
           "Advisor.Utils.Naming.getLengthRestrictionInputParams" t ;; (function)
           "Advisor.Utils.Naming.getNameLength" t ;; (function)
           "Advisor.Utils.Naming.getRegExp" t ;; (function)
           "Advisor.Utils.Naming.getReservedNames" t ;; (function)
           "Advisor.Utils.Naming.inputParam_NameLength" t ;; (function)
           "Advisor.Utils.Naming.isNameValid" t ;; (function)
           "Advisor.Utils.Naming.validateInputParam_Length" t ;; (function)
           "Advisor.Utils.Naming.verifySignal" t ;; (function)
           "Advisor.Utils.open_system" t ;; (function)
           "Advisor.Utils.refreshCurrentMATreeNodeDialog" t ;; (function)
           "Advisor.Utils.Report.highlightIndicesInText" t ;; (function)
           "Advisor.Utils.reportInvalidInputParams" t ;; (function)
           "Advisor.Utils.safeEvalinGlobalScope" t ;; (function)
           "Advisor.Utils.SaveRestorePoint" t ;; (class)
           "Advisor.Utils.SaveRestorePoint.getSaveRestorePointObject" t ;; (method)
           "Advisor.Utils.SaveRestorePointForFPCA" t ;; (class)
           "Advisor.Utils.SaveRestorePointForFPCA.getSaveRestorePointObject" t ;; (method)
           "Advisor.Utils.SaveRestorePointForMdlRefAdvisor" t ;; (class)
           "Advisor.Utils.SaveRestorePointForMdlRefAdvisor.getSaveRestorePointObject" t ;; (method)
           "Advisor.Utils.Simulink.block.convertBlkTypeList_into_cell" t ;; (function)
           "Advisor.Utils.Simulink.block.convertcell_into_BlkTypeList" t ;; (function)
           "Advisor.Utils.Simulink.block.getAllBlocks" t ;; (function)
           "Advisor.Utils.Simulink.block.getAutosarBlockSupportTable" t ;; (function)
           "Advisor.Utils.Simulink.block.getBlockTypeListFromLibrary" t ;; (function)
           "Advisor.Utils.Simulink.block.getBlockTypeListFromLibraryViaEval" t ;; (function)
           "Advisor.Utils.Simulink.block.getCSTBlockSupportTable" t ;; (function)
           "Advisor.Utils.Simulink.block.getCVSTBlockSupportTable" t ;; (function)
           "Advisor.Utils.Simulink.block.getDSTBlockSupportTable" t ;; (function)
           "Advisor.Utils.Simulink.block.getSimulinkBlockSupportTable" t ;; (function)
           "Advisor.Utils.Simulink.evalSimulinkBlockParameters" t ;; (function)
           "Advisor.Utils.Simulink.findVars" t ;; (function)
           "Advisor.Utils.Simulink.getConfigSetParameterHyperlink" t ;; (function)
           "Advisor.Utils.Simulink.getEmlHyperlink" t ;; (function)
           "Advisor.Utils.Simulink.getObjHyperLink" t ;; (function)
           "Advisor.Utils.Simulink.getReferencedMatlabFiles" t ;; (function)
           "Advisor.Utils.Simulink.getSegmentsFromObject" t ;; (function)
           "Advisor.Utils.Simulink.getSimulinkBusObjects" t ;; (function)
           "Advisor.Utils.Simulink.getTunableParameters" t ;; (function)
           "Advisor.Utils.Simulink.getTunableProperties" t ;; (function)
           "Advisor.Utils.Simulink.highlightWrongCharacter" t ;; (function)
           "Advisor.Utils.Simulink.isBlockCommented" t ;; (function)
           "Advisor.Utils.Simulink.isBusDataTypeStr" t ;; (function)
           "Advisor.Utils.Simulink.isEnumOutDataTypeStr" t ;; (function)
           "Advisor.Utils.Simulink.isNameValid" t ;; (function)
           "Advisor.Utils.Simulink.isSimulinkBasicType" t ;; (function)
           "Advisor.Utils.Simulink.isTunableBlockParameter" t ;; (function)
           "Advisor.Utils.Simulink.modelHasActiveTestHarness" t ;; (function)
           "Advisor.Utils.Simulink.outDataTypeStr2baseType" t ;; (function)
           "Advisor.Utils.Simulink.resolveConfigSetValue" t ;; (function)
           "Advisor.Utils.Simulink.standardFilter" t ;; (function)
           "Advisor.Utils.Stateflow" t ;; (class)
           "Advisor.Utils.Stateflow.AddIndiceHyperLinkToTable" t ;; (method)
           "Advisor.Utils.Stateflow.findAllEmCharts" t ;; (method)
           "Advisor.Utils.Stateflow.GetFailingExpressions" t ;; (method)
           "Advisor.Utils.Stateflow.highlightSFLabelByIndex" t ;; (method)
           "Advisor.Utils.useGUI" t ;; (function)
           "Advisor.Utils.Utils_hisl_0070" t ;; (class)
           "Advisor.Utils.Utils_hisl_0070.filterComponents" t ;; (method)
           "Advisor.Utils.Utils_hisl_0070.filterShipping" t ;; (method)
           "Advisor.Utils.Utils_hisl_0070.findMdlRefLink" t ;; (method)
           "Advisor.Utils.Utils_hisl_0070.getComponent_hisl_0070" t ;; (method)
           "Advisor.Utils.Utils_hisl_0070.getFailingComponent_hisl_0070" t ;; (method)
           "Advisor.Utils.Utils_hisl_0070.getFailingSDObj_hisl_0070" t ;; (method)
           "Advisor.Utils.Utils_jc_0903" t ;; (class)
           "Advisor.Utils.Utils_jc_0903.doLinesBlocksIntersect" t ;; (method)
           "Advisor.Utils.Utils_jc_0903.dosegmentsIntersectOrOverlap" t ;; (method)
           "Advisor.Utils.Utils_jc_0903.getBoundingBoxPoints" t ;; (method)
           "Advisor.Utils.Utils_jc_0903.getSplitSegmentsFromLine" t ;; (method)
           "Advisor.Utils.Utils_jc_0904" t ;; (class)
           "Advisor.Utils.Utils_jc_0904.getIntersectingandOverlappingTransitions" t ;; (method)
           "Advisor.Utils.Utils_jc_0904.getSfObjectsCrossingEachother" t ;; (method)
           "Advisor.Utils.Utils_jc_0904.getSfObjTextLabelExceedingBoundaries" t ;; (method)
           "Advisor.Utils.Utils_jc_0904.getTransitionsCrossingStateflowObjects" t ;; (method)
           "Advisor.Utils.Utils_jc_0904.getTransitionsOverlappingLabels" t ;; (method)
           "Advisor.Validation.fixCheck" t ;; (function)
           "Advisor.Validation.fixConfiguration" t ;; (function)
           "Advisor.Validation.loc_converIpToJSON" t ;; (function)
           "Advisor.Validation.loc_verify_inputparam" t ;; (function)
           "Advisor.Validation.skip_MAAB_find_system_inputparam" t ;; (function)
           "Advisor.Validation.StaticMetaType" t ;; (method)
           "Advisor.Validation.updateDisplayIcons" t ;; (function)
           "Advisor.Validation.updateFolderIconsAfterFixCheck" t ;; (function)
           "Advisor.Validation.updateFolderIconsAfterMarkingIssues" t ;; (function)
           "Advisor.Validation.validateAndMarkIssues" t ;; (function)
           "Advisor.Validation.ValidationCheckRegistration" t ;; (class)
           "Advisor.Validation.ValidationCheckRegistration.getInstance" t ;; (method)
           "Advisor.variant.Variant" t ;; (class)
           "Advisor.variant.VariantManager" t ;; (class)
           "Advisor.WindowBase" t ;; (class)
           "adxl345" t ;; (mFile) Connect to ADXL345, ADXL343, ADXL344, or ADXL346 sensor on Arduino hardware I2C bus
           "aebalance" t ;; (mFile)
           "aer2ecef" t ;; (mFile) Transform local spherical coordinates to geocentric Earth-centered Earth-fixed
           "aer2enu" t ;; (mFile) Transform local spherical coordinates to local east-north-up
           "aer2geodetic" t ;; (mFile) Transform local spherical coordinates to geodetic
           "aer2ned" t ;; (mFile) Transform local spherical coordinates to local north-east-down
           "Aero.Aircraft.CompositeCoefficient" t ;; (class)
           "Aero.Aircraft.CompositeCoefficient.calculate" t ;; (method)
           "Aero.Aircraft.ControlState" t ;; (class)
           "Aero.Aircraft.Environment" t ;; (class)
           "Aero.Aircraft.Properties" t ;; (class)
           "Aero.Animation" t ;; (class)
           "Aero.animation.interp3DoFArrayWithTime" t ;; (function)
           "Aero.animation.interp6DoFArrayWithTime" t ;; (function)
           "Aero.animation.interpStructWithTime" t ;; (function)
           "Aero.animation.interpTimeseries" t ;; (function)
           "Aero.animation.interpTimetable" t ;; (function)
           "Aero.animation.nullCoordTransform" t ;; (function)
           "Aero.Body" t ;; (class)
           "Aero.Camera" t ;; (class)
           "Aero.FixedWing.Coefficient" t ;; (class)
           "Aero.FixedWing.criteriaTable" t ;; (method)
           "Aero.FixedWing.FlyingQuality.DutchRollMode" t ;; (class)
           "Aero.FixedWing.FlyingQuality.FlyingQualitiesResult" t ;; (class)
           "Aero.FixedWing.FlyingQuality.PhugoidMode" t ;; (class)
           "Aero.FixedWing.FlyingQuality.RollSubsidenceMode" t ;; (class)
           "Aero.FixedWing.FlyingQuality.ShortPeriodMode" t ;; (class)
           "Aero.FixedWing.FlyingQuality.SpiralMode" t ;; (class)
           "Aero.FixedWing.Specification" t ;; (class)
           "Aero.FixedWing.State" t ;; (class)
           "Aero.FixedWing.Surface" t ;; (class)
           "Aero.FixedWing.Thrust" t ;; (class)
           "Aero.FlightGearAnimation" t ;; (class)
           "Aero.Geometry" t ;; (class)
           "Aero.graphics.primitive.BoundaryLine" t ;; (class)
           "Aero.graphics.primitive.BoundaryLine.loadobj" t ;; (method)
           "Aero.graphics.primitive.Data" t ;; (class)
           "Aero.graphics.primitive.Data.loadobj" t ;; (method)
           "Aero.jsbsim.jsbProperty2FWState" t ;; (function)
           "Aero.jsbsim.JSBSimState" t ;; (class)
           "Aero.Node" t ;; (class)
           "Aero.satellitescenario.CentralBodyOptions" t ;; (class)
           "Aero.satellitescenario.Eclipse" t ;; (class)
           "Aero.satellitescenario.EclipseType" t ;; (class)
           "Aero.satellitescenario.EclipseType.Antumbra" 'enumeration
           "Aero.satellitescenario.EclipseType.Penumbra" 'enumeration
           "Aero.satellitescenario.EclipseType.SunLight" 'enumeration
           "Aero.satellitescenario.EclipseType.Umbra" 'enumeration
           "Aero.satellitescenario.NumericalPropagatorOptions" t ;; (class)
           "Aero.satellitescenario.satellite.PhysicalProperties" t ;; (class)
           "Aero.spacecraft.analysis.createSatelliteScenarioFromSim" t ;; (function)
           "Aero.spacecraft.analysis.satelliteScenarioPlaybackMaskCallback" t ;; (function)
           "Aero.spacecraft.CentralBody" t ;; (class)
           "Aero.spacecraft.CentralBody.Earth" 'enumeration
           "Aero.spacecraft.centralbody.Earth" t ;; (class)
           "Aero.spacecraft.centralbody.Earth.EquatorialRadius" 'property
           "Aero.spacecraft.centralbody.Earth.Mu" 'property
           "Aero.spacecraft.centralbody.Earth.RotationRate" 'property
           "Aero.spacecraft.CentralBody.Jupiter" 'enumeration
           "Aero.spacecraft.CentralBody.Mars" 'enumeration
           "Aero.spacecraft.CentralBody.Mercury" 'enumeration
           "Aero.spacecraft.CentralBody.Moon" 'enumeration
           "Aero.spacecraft.centralbody.Moon" t ;; (class)
           "Aero.spacecraft.centralbody.Moon.EquatorialRadius" 'property
           "Aero.spacecraft.centralbody.Moon.Mu" 'property
           "Aero.spacecraft.centralbody.Moon.RotationRate" 'property
           "Aero.spacecraft.CentralBody.Neptune" 'enumeration
           "Aero.spacecraft.CentralBody.Saturn" 'enumeration
           "Aero.spacecraft.CentralBody.Sun" 'enumeration
           "Aero.spacecraft.centralbody.Sun" t ;; (class)
           "Aero.spacecraft.centralbody.Sun.EquatorialRadius" 'property
           "Aero.spacecraft.centralbody.Sun.Mu" 'property
           "Aero.spacecraft.centralbody.Sun.RotationRate" 'property
           "Aero.spacecraft.CentralBody.Uranus" 'enumeration
           "Aero.spacecraft.CentralBody.Venus" 'enumeration
           "Aero.spacecraft.CentralBodyOptions" t ;; (class)
           "Aero.spacecraft.NumericalPropagatorOptions" t ;; (class)
           "Aero.spacecraft.NumericalPropagatorOptions.loadobj" t ;; (method)
           "Aero.spacecraft.PhysicalProperties" t ;; (class)
           "Aero.ui.control.AirspeedIndicator" t ;; (class)
           "Aero.ui.control.AirspeedIndicator.loadobj" t ;; (method)
           "Aero.ui.control.Altimeter" t ;; (class)
           "Aero.ui.control.Altimeter.loadobj" t ;; (method)
           "Aero.ui.control.ArtificialHorizon" t ;; (class)
           "Aero.ui.control.ArtificialHorizon.loadobj" t ;; (method)
           "Aero.ui.control.ClimbIndicator" t ;; (class)
           "Aero.ui.control.ClimbIndicator.loadobj" t ;; (method)
           "Aero.ui.control.EGTIndicator" t ;; (class)
           "Aero.ui.control.EGTIndicator.loadobj" t ;; (method)
           "Aero.ui.control.HeadingIndicator" t ;; (class)
           "Aero.ui.control.HeadingIndicator.loadobj" t ;; (method)
           "Aero.ui.control.RPMIndicator" t ;; (class)
           "Aero.ui.control.RPMIndicator.Limits" 'property
           "Aero.ui.control.RPMIndicator.loadobj" t ;; (method)
           "Aero.ui.control.TurnCoordinator" t ;; (class)
           "Aero.ui.control.TurnCoordinator.loadobj" t ;; (method)
           "Aero.Viewpoint" t ;; (class)
           "Aero.VirtualRealityAnimation" t ;; (class)
           "aero_c" t ;; (mex)
           "aero_m" t ;; (mFile)
           "aeroassertmsg" t ;; (mFile)
           "aeroblkhmidlg.ClimbIndicatorBlock" t ;; (class)
           "aeroblkhmidlg.ClimbIndicatorBlock.cacheSignalSelection" t ;; (method)
           "aeroblkhmidlg.ClimbIndicatorBlock.clearCacheSignalSelection" t ;; (method)
           "aeroblkhmidlg.ClimbIndicatorBlock.enterKeyPressed" t ;; (method)
           "aeroblkhmidlg.ClimbIndicatorBlock.getBackgroundColor" t ;; (method)
           "aeroblkhmidlg.ClimbIndicatorBlock.getChannel" t ;; (method)
           "aeroblkhmidlg.ClimbIndicatorBlock.getFontColor" t ;; (method)
           "aeroblkhmidlg.ClimbIndicatorBlock.getForegroundColor" t ;; (method)
           "aeroblkhmidlg.ClimbIndicatorBlock.getGridColor" t ;; (method)
           "aeroblkhmidlg.ClimbIndicatorBlock.getInitialState" t ;; (method)
           "aeroblkhmidlg.ClimbIndicatorBlock.getPushButtonIconOffColor" t ;; (method)
           "aeroblkhmidlg.ClimbIndicatorBlock.getPushButtonIconOnColor" t ;; (method)
           "aeroblkhmidlg.ClimbIndicatorBlock.getPushButtonProperties" t ;; (method)
           "aeroblkhmidlg.ClimbIndicatorBlock.getScaleColors" t ;; (method)
           "aeroblkhmidlg.ClimbIndicatorBlock.highlightSignalInModel" t ;; (method)
           "aeroblkhmidlg.ClimbIndicatorBlock.setColorDisplayBlock" t ;; (method)
           "aeroblkhmidlg.ClimbIndicatorBlock.setPushButtonProperties" t ;; (method)
           "aeroblkhmidlg.ClimbIndicatorBlock.setScaleColors" t ;; (method)
           "aeroblkhmidlg.RPMIndicatorBlock" t ;; (class)
           "aeroblkhmidlg.RPMIndicatorBlock.cacheSignalSelection" t ;; (method)
           "aeroblkhmidlg.RPMIndicatorBlock.clearCacheSignalSelection" t ;; (method)
           "aeroblkhmidlg.RPMIndicatorBlock.enterKeyPressed" t ;; (method)
           "aeroblkhmidlg.RPMIndicatorBlock.getBackgroundColor" t ;; (method)
           "aeroblkhmidlg.RPMIndicatorBlock.getChannel" t ;; (method)
           "aeroblkhmidlg.RPMIndicatorBlock.getFontColor" t ;; (method)
           "aeroblkhmidlg.RPMIndicatorBlock.getForegroundColor" t ;; (method)
           "aeroblkhmidlg.RPMIndicatorBlock.getGridColor" t ;; (method)
           "aeroblkhmidlg.RPMIndicatorBlock.getInitialState" t ;; (method)
           "aeroblkhmidlg.RPMIndicatorBlock.getPushButtonIconOffColor" t ;; (method)
           "aeroblkhmidlg.RPMIndicatorBlock.getPushButtonIconOnColor" t ;; (method)
           "aeroblkhmidlg.RPMIndicatorBlock.getPushButtonProperties" t ;; (method)
           "aeroblkhmidlg.RPMIndicatorBlock.getScaleColors" t ;; (method)
           "aeroblkhmidlg.RPMIndicatorBlock.highlightSignalInModel" t ;; (method)
           "aeroblkhmidlg.RPMIndicatorBlock.setColorDisplayBlock" t ;; (method)
           "aeroblkhmidlg.RPMIndicatorBlock.setPushButtonProperties" t ;; (method)
           "aeroblkhmidlg.RPMIndicatorBlock.setScaleColors" t ;; (method)
           "aeroblkhmidlg.SimpleBlock" t ;; (class)
           "aeroblkhmidlg.SimpleBlock.cacheSignalSelection" t ;; (method)
           "aeroblkhmidlg.SimpleBlock.clearCacheSignalSelection" t ;; (method)
           "aeroblkhmidlg.SimpleBlock.enterKeyPressed" t ;; (method)
           "aeroblkhmidlg.SimpleBlock.getBackgroundColor" t ;; (method)
           "aeroblkhmidlg.SimpleBlock.getChannel" t ;; (method)
           "aeroblkhmidlg.SimpleBlock.getFontColor" t ;; (method)
           "aeroblkhmidlg.SimpleBlock.getForegroundColor" t ;; (method)
           "aeroblkhmidlg.SimpleBlock.getGridColor" t ;; (method)
           "aeroblkhmidlg.SimpleBlock.getInitialState" t ;; (method)
           "aeroblkhmidlg.SimpleBlock.getPushButtonIconOffColor" t ;; (method)
           "aeroblkhmidlg.SimpleBlock.getPushButtonIconOnColor" t ;; (method)
           "aeroblkhmidlg.SimpleBlock.getPushButtonProperties" t ;; (method)
           "aeroblkhmidlg.SimpleBlock.getScaleColors" t ;; (method)
           "aeroblkhmidlg.SimpleBlock.highlightSignalInModel" t ;; (method)
           "aeroblkhmidlg.SimpleBlock.setColorDisplayBlock" t ;; (method)
           "aeroblkhmidlg.SimpleBlock.setPushButtonProperties" t ;; (method)
           "aeroblkhmidlg.SimpleBlock.setScaleColors" t ;; (method)
           "aeroblkhmidlg.SimpleScaleColorBlock" t ;; (class)
           "aeroblkhmidlg.SimpleScaleColorBlock.cacheSignalSelection" t ;; (method)
           "aeroblkhmidlg.SimpleScaleColorBlock.clearCacheSignalSelection" t ;; (method)
           "aeroblkhmidlg.SimpleScaleColorBlock.enterKeyPressed" t ;; (method)
           "aeroblkhmidlg.SimpleScaleColorBlock.getBackgroundColor" t ;; (method)
           "aeroblkhmidlg.SimpleScaleColorBlock.getChannel" t ;; (method)
           "aeroblkhmidlg.SimpleScaleColorBlock.getFontColor" t ;; (method)
           "aeroblkhmidlg.SimpleScaleColorBlock.getForegroundColor" t ;; (method)
           "aeroblkhmidlg.SimpleScaleColorBlock.getGridColor" t ;; (method)
           "aeroblkhmidlg.SimpleScaleColorBlock.getInitialState" t ;; (method)
           "aeroblkhmidlg.SimpleScaleColorBlock.getPushButtonIconOffColor" t ;; (method)
           "aeroblkhmidlg.SimpleScaleColorBlock.getPushButtonIconOnColor" t ;; (method)
           "aeroblkhmidlg.SimpleScaleColorBlock.getPushButtonProperties" t ;; (method)
           "aeroblkhmidlg.SimpleScaleColorBlock.getScaleColors" t ;; (method)
           "aeroblkhmidlg.SimpleScaleColorBlock.highlightSignalInModel" t ;; (method)
           "aeroblkhmidlg.SimpleScaleColorBlock.setColorDisplayBlock" t ;; (method)
           "aeroblkhmidlg.SimpleScaleColorBlock.setPushButtonProperties" t ;; (method)
           "aeroblkhmidlg.SimpleScaleColorBlock.setScaleColors" t ;; (method)
           "aeroblksBrokenLinksMapping" t ;; (mFile)
           "aeroblksHMICreateDDGDialog" t ;; (pFile)
           "aeroblkssim3dBrokenLinksMapping" t ;; (mFile)
           "aeroDataPackage" t ;; (pFile) Start Add-On Explorer to download, install, or uninstall aerospace-specific data
           "aerogenfgrunscript" t ;; (mFile)
           "aeroicon" t ;; (mFile)
           "aeroimage" t ;; (mFile)
           "aerolib" t ;; (mFile)
           "aerolib3dof" t ;; (slxFile)
           "aerolib3dof2" t ;; (slxFile)
           "aerolib6dof" t ;; (slxFile)
           "aerolib6dof2" t ;; (slxFile)
           "aerolib6dofsys" t ;; (slxFile)
           "aerolibactuator" t ;; (slxFile)
           "aerolibadyn" t ;; (slxFile)
           "aerolibadynsys" t ;; (slxFile)
           "aerolibanim" t ;; (slxFile)
           "aerolibanimutils" t ;; (slxFile)
           "aerolibasang" t ;; (slxFile)
           "aerolibasangsys" t ;; (slxFile)
           "aerolibatmos" t ;; (slxFile)
           "aerolibatmos2" t ;; (slxFile)
           "aerolibatmossys" t ;; (slxFile)
           "aerolibattitudesys" t ;; (slxFile)
           "aerolibbdyn" t ;; (slxFile)
           "aerolibcelestial" t ;; (slxFile)
           "aerolibcommonsys" t ;; (slxFile)
           "aerolibconvert" t ;; (slxFile)
           "aerolibconvert2" t ;; (slxFile)
           "aerolibcubesat" t ;; (slxFile)
           "aerolibcubesatveh" t ;; (slxFile)
           "aerolibeomforward" t ;; (slxFile)
           "aerolibephsys" t ;; (slxFile)
           "aerolibfltsims" t ;; (slxFile)
           "aerolibfltsimssys" t ;; (slxFile)
           "aerolibgravity" t ;; (slxFile)
           "aerolibgravity2" t ;; (slxFile)
           "aerolibgravitysys" t ;; (slxFile)
           "aerolibguid" t ;; (slxFile)
           "aerolibhmi" t ;; (slxFile)
           "aeroliblist" t ;; (mFile)
           "aerolibnav" t ;; (slxFile)
           "aerolibnavsys" t ;; (slxFile)
           "aerolibobsolete" t ;; (slxFile)
           "aerolibpilot" t ;; (slxFile)
           "aerolibpilotsys" t ;; (slxFile)
           "aerolibprivatev1p5" t ;; (slxFile)
           "aerolibpropulsion" t ;; (slxFile)
           "aerolibpropulsion2" t ;; (slxFile)
           "aerolibpropulsionsys" t ;; (slxFile)
           "aerolibptmass" t ;; (slxFile)
           "aerolibsatdyn" t ;; (slxFile)
           "aerolibschedule" t ;; (slxFile)
           "aerolibsim3d" t ;; (slxFile)
           "aerolibsim3dfwd" t ;; (mFile)
           "aerolibsim3dpack" t ;; (slxFile)
           "aerolibtransform" t ;; (slxFile)
           "aerolibtransform2" t ;; (slxFile)
           "aerolibtransform2sys" t ;; (slxFile)
           "aerolibutil" t ;; (slxFile)
           "aerolibv1" t ;; (slxFile)
           "aerolibwind" t ;; (slxFile)
           "aerolibwind2" t ;; (slxFile)
           "aerolibwindfilters" t ;; (slxFile)
           "aeroReadIERSData" t ;; (mFile) File containing current International Astronomical Union (IAU) 2000A Earth orientation data
           "aeroReadSpaceWeatherData" t ;; (mFile) Output MAT file of space weather data
           "aeroshared" t ;; (pFile)
           "aerosharedhelp" t ;; (mFile)
           "aerosharedicon" t ;; (mFile)
           "aerosharedimage" t ;; (mFile)
           "aerosharedliblist" t ;; (mFile)
           "aerosharedtest" t ;; (pFile)
           "aerosim3dicon" t ;; (mFile)
           "aff2lft" t ;; (mFile)
           "aff2pol" t ;; (mFile) Convert affine parameter-dependent models to polytopic models
           "affine2d" t ;; (mFile) (Not recommended) 2-D affine geometric transformation using postmultiply convention
           "affine2d.Dimensionality" 'property
           "affine3d" t ;; (mFile) (Not recommended) 3-D affine geometric transformation using postmultiply convention
           "affine3d.Dimensionality" 'property
           "affineOutputView" t ;; (mFile) Create output view for warping images
           "affinetform2d" t ;; (mFile) 2-D affine geometric transformation
           "affinetform2d.Dimensionality" 'property
           "affinetform3d" t ;; (mFile) 3-D affine geometric transformation
           "affinetform3d.Dimensionality" 'property
           "affsim" t ;; (mFile)
           "agcloop" t ;; (mex)
           "ageCheckCB" t ;; (mFile)
           "agencyoas" t ;; (mFile) Determine option-adjusted spread of callable bond using Agency OAS model
           "agencyprice" t ;; (mFile) Price callable bond using Agency OAS model
           "AgeVerificationCallback" t ;; (mFile)
           "agferead" t ;; (mFile) Read Agilent Feature Extraction Software file
           "agv2str" t ;; (mFile)
           "ahrs10filter" t ;; (mFile) Height and orientation from MARG and altimeter readings
           "ahrsfilter" t ;; (mFile) Orientation from accelerometer, gyroscope, and magnetometer readings
           "ahrsfilter.defaultProcessNoise" t ;; (method)
           "ahrsfilter.getInitialProcCov" t ;; (method)
           "ahrsfilter.getInitialProcCovMask" t ;; (method)
           "aicbic" t ;; (mFile) Information criteria
           "aictest" t ;; (mFile) Dimension of signal subspace
           "aircraftEnvironment" t ;; (mFile) Create aircraft environment
           "aircraftProperties" t ;; (mFile) Create properties to define and manage aircraft
           "airspeed" t ;; (mFile) Airspeed from velocity
           "airy" t ;; (mFile) Airy Functions
           "aitoff" t ;; (mFile)
           "ajakesir" t ;; (mFile)
           "albersheim" t ;; (mFile) Required SNR using Albersheim’s equation
           "alexnet" t ;; (mFile) (Not recommended) AlexNet convolutional neural network
           "algdeintrlv" t ;; (mFile) Restore ordering of symbols using algebraically derived permutation table
           "algebraicEqnSolver" t ;; (mFile)
           "algexp2pc" t ;; (mex)
           "algintrlv" t ;; (mFile) Reorder symbols using algebraically derived permutation table
           "AlgorithmResponse" t ;; (pFile)
           "AlgorithmSettings" t ;; (pFile)
           "AlgorithmSettingsLoader" t ;; (pFile)
           "aliastypeddg" t ;; (pFile)
           "align" t ;; (mFile) Align UIControl components and Axes objects
           "align2cigar" t ;; (mFile) Convert aligned sequences to corresponding signatures in CIGAR format
           "align_names" t ;; (pFile)
           "alignsignals" t ;; (mFile) Align two signals by delaying earliest signal
           "alim" t ;; (mFile) Set or query axes alpha limits
           "all" t ;; (mFile) Determine if all array elements are nonzero or true
           "allanvar" t ;; (pFile) Allan variance
           "allbetween" t ;; (mFile) Determine if all elements are within specified range
           "allchild" t ;; (mFile) Find all children of specified objects
           "allfeasible" t ;; (mFile)
           "allFilter" t ;; (mFile)
           "allfinite" t ;; (mFile) Determine if all array elements are finite
           "allmargin" t ;; (mFile) Gain margin, phase margin, delay margin, and crossover frequencies
           "allMuPADNotebooks" t ;; (mFile)
           "allnodes" t ;; (mFile) Tree nodes
           "allocpim" t ;; (mFile)
           "allpass2wdf" t ;; (mFile) Allpass to Wave Digital Filter coefficient transformation
           "allpassbpc2bpc" t ;; (mFile) Allpass filter for complex bandpass transformation
           "allpasslp2bp" t ;; (mFile) Allpass filter for lowpass to bandpass transformation
           "allpasslp2bpc" t ;; (mFile) Allpass filter for lowpass to complex bandpass transformation
           "allpasslp2bs" t ;; (mFile) Allpass filter for lowpass to bandstop transformation
           "allpasslp2bsc" t ;; (mFile) Allpass filter for lowpass to complex bandstop transformation
           "allpasslp2hp" t ;; (mFile) Allpass filter for lowpass to highpass transformation
           "allpasslp2lp" t ;; (mFile) Allpass filter for lowpass to lowpass transformation
           "allpasslp2mb" t ;; (mFile) Allpass filter for lowpass to M-band transformation
           "allpasslp2mbc" t ;; (mFile) Allpass filter for lowpass to complex M-band transformation
           "allpasslp2xc" t ;; (mFile) Allpass filter for lowpass to complex N-point transformation
           "allpasslp2xn" t ;; (mFile) Allpass filter for lowpass to N-point transformation
           "allpassrateup" t ;; (mFile) Allpass filter for integer upsample transformation
           "allpassshift" t ;; (mFile) Allpass filter for real shift transformation
           "allpassshiftc" t ;; (mFile) Allpass filter for complex shift transformation
           "allunique" t ;; (mFile) Determine if all values are unique
           "alm.enableArtifactTracking" t ;; (function)
           "alm.enableTraceInfoCaching" t ;; (function)
           "alm.isArtifactTrackingEnabled" t ;; (function)
           "alm.isTraceInfoCachingEnabled" t ;; (function)
           "alm.settings.DigitalThreadSettingsWindow" t ;; (class)
           "alm.settings.open" t ;; (function)
           "almanac" t ;; (mFile) Parameters for Earth, planets, Sun, and Moon
           "alpha" t ;; (mFile) Add transparency to objects in axes
           "Alpha_Beta_ZeroToAbc_class" t ;; (pFile)
           "Alpha_Beta_ZeroToDq0_class" t ;; (pFile)
           "alphabeta" t ;; (mFile) Compute incidence and sideslip angles
           "alphamap" t ;; (mFile) Specify figure alphamap (transparency)
           "alphanumericBoundary" t ;; (mFile) Match boundary between alphanumeric and non-alphanumeric characters
           "alphanumericsPattern" t ;; (mFile) Match letter and digit characters
           "alphaShape" t ;; (mFile) Polygons and polyhedra from points in 2-D and 3-D
           "alsalib" t ;; (slxFile)
           "alslnsh" t ;; (pFile)
           "AlteraCycloneV.common.plugin_board" t ;; (function)
           "AlteraCycloneV.common.qsys_base_150.plugin_rd" t ;; (function)
           "AlteraCycloneV.common.qsys_base_160.plugin_rd" t ;; (function)
           "AlteraCycloneV.revC.hdlcoder_ref_design_customization" t ;; (function)
           "AlteraCycloneV.revC.plugin_board" t ;; (function)
           "AlteraCycloneV.revC.qsys_base_150.plugin_rd" t ;; (function)
           "AlteraCycloneV.revC.qsys_base_160.plugin_rd" t ;; (function)
           "AlteraCycloneV.revD.hdlcoder_ref_design_customization" t ;; (function)
           "AlteraCycloneV.revD.plugin_board" t ;; (function)
           "AlteraCycloneV.revD.qsys_base_150.plugin_rd" t ;; (function)
           "AlteraCycloneV.revD.qsys_base_160.plugin_rd" t ;; (function)
           "alteratarget" t ;; (pFile)
           "altimeterSensor" t ;; (mFile) Altimeter simulation model
           "altitudeEnvelopeContour" t ;; (mFile) Draw altitude envelope contour plot
           "ambgfun" t ;; (mFile) Ambiguity and crossambiguity function
           "ambisonicDecoderMatrix" t ;; (mFile) Generate matrix for ambisonics decoding
           "ambisonicEncoderMatrix" t ;; (mFile) Generate matrix for ambisonics encoding
           "amd" t ;; (mFile) Approximate minimum degree permutation
           "amdemod" t ;; (mFile) Amplitude demodulation
           "amdtarget" t ;; (pFile)
           "aminolookup" t ;; (mFile) Find amino acid codes, integers, abbreviations, names, and codons
           "amiq2sol" t ;; (mFile)
           "ammod" t ;; (mFile) Amplitude modulation
           "amortize" t ;; (mFile) Amortization schedule
           "amp1dae" t ;; (mFile)
           "ampcblock_ForwardingTable" t ;; (mFile)
           "ampcblock_InitFcn" t ;; (mFile)
           "ampcblock_MaskInitFcnParameter" t ;; (mFile)
           "ampcblock_MaskInitFcnResize" t ;; (mFile)
           "ampcblock_StartFcn" t ;; (mFile)
           "amplifier" t ;; (mFile) Create two-port amplifier element
           "AnalogModel" t ;; (mFile)
           "Analysis.checkGlobalAccess" t ;; (function)
           "Analysis.ExpandedSortedlist" t ;; (function)
           "Analysis.filterModelBlocksUnderNoReadWrite" t ;; (function)
           "Analysis.findInportBlocks" t ;; (function)
           "Analysis.fixSortedOrder" t ;; (function)
           "Analysis.getCompiledInfo" t ;; (function)
           "Analysis.getGlobalMemVars" t ;; (function)
           "Analysis.getIncome" t ;; (function)
           "Analysis.getReferencedModelBDHandles" t ;; (function)
           "Analysis.getRefMdltoMdlBlk" t ;; (function)
           "Analysis.getSignalObservers" t ;; (function)
           "Analysis.getSignalObserversForModel" t ;; (function)
           "Analysis.isRootOfMdlref" t ;; (function)
           "Analysis.isSinkBlock" t ;; (function)
           "AnalysisPoint" t ;; (mFile) Points of interest for linear analysis
           "AnalysisPoint.empty" t ;; (method)
           "AnalysisPoint.matchChannelNames" t ;; (method)
           "analyticalInverseKinematics" t ;; (mFile) Create analytical inverse kinematics solver
           "analyticalInverseKinematics.loadobj" t ;; (method)
           "analyze75info" t ;; (mFile) Read metadata from header file of Analyze 7.5 data set
           "analyze75read" t ;; (mFile) Read image data from image file of Analyze 7.5 data set
           "analyzeCodeCompatibility" t ;; (mFile) Create code compatibility analysis results
           "analyzeNetwork" t ;; (mFile) Analyze deep learning network architecture
           "analyzeNetworkForCodegen" t ;; (mFile) Analyze deep learning network for code generation
           "analyzeStats_TItarget" t ;; (mFile)
           "ancestor" t ;; (mFile) Ancestor of graphics object
           "anchorBoxLayer" t ;; (mFile)
           "and" t ;; (mFile) Find logical AND
           "andObjectFilter" t ;; (mFile)
           "andPropertyFilter" t ;; (mFile)
           "andrewsplot" t ;; (mFile) Andrews plot
           "anfis" t ;; (mFile) Tune Sugeno-type fuzzy inference system using training data
           "anfisedit" t ;; (mFile)
           "anfisOptions" t ;; (mFile) Option set for anfis function
           "anfisOutputFcn" t ;; (mFile)
           "angdiff" t ;; (mFile) Difference between two angles
           "angl2str" t ;; (mFile) Convert angles to character array
           "angle" t ;; (mFile) Phase angle
           "angle2dcm" t ;; (mFile) Convert rotation angles to direction cosine matrix
           "angle2quat" t ;; (mFile) Convert rotation angles to quaternion
           "angle2rod" t ;; (mFile) Convert rotation angles to Euler-Rodrigues vector
           "angledim" t ;; (mFile) Convert angles units
           "animatedline" t ;; (mFile) Create animated line
           "AnimateHysteresis" t ;; (pFile)
           "animationToFrame" t ;; (mFile) Return structure of frames from animation objects
           "animrule" t ;; (mFile)
           "annealingboltz" t ;; (mFile)
           "annealingfast" t ;; (mFile)
           "annotation" t ;; (mFile) Create annotations
           "annotationddg" t ;; (pFile)
           "annotationddg_cb" t ;; (pFile)
           "annurate" t ;; (mFile) Periodic interest rate of annuity
           "annuterm" t ;; (mFile) Number of periods to obtain value
           "anomaly.AnomalyDetector" t ;; (class)
           "anomaly.coder.AnomalyDetector" t ;; (class)
           "anomaly.coder.AnomalyDetector.additionalArguments" t ;; (method)
           "anomaly.coder.iforest.cfactor" t ;; (function)
           "anomaly.coder.iforest.IsolationTree" t ;; (class)
           "anomaly.coder.IsolationForest" t ;; (class)
           "anomaly.coder.IsolationForest.additionalArguments" t ;; (method)
           "anomaly.coder.ocsvm.Kernel" t ;; (class)
           "anomaly.coder.OneClassSVM" t ;; (class)
           "anomaly.coder.OneClassSVM.additionalArguments" t ;; (method)
           "anomaly.iforest.cfactor" t ;; (function)
           "anomaly.iforest.IsolationTree" t ;; (class)
           "anomaly.iforest.IsolationTree.fit" t ;; (method)
           "anomaly.lof.decodeCategorical" t ;; (function)
           "anomaly.rrcforest.codisplacement" t ;; (function)
           "anomaly.rrcforest.RobustRandomCutTree" t ;; (class)
           "anomaly.rrcforest.RobustRandomCutTree.fit" t ;; (method)
           "anomaly.rrcforest.sampleDimension" t ;; (function)
           "anomaly.rrcforest.separateData" t ;; (function)
           "anomaly.svm.optimalKernelScale" t ;; (function)
           "anomaly.svm.optimalLambda" t ;; (function)
           "anomaly.utils.getMu" t ;; (function)
           "anomaly.utils.getSigma" t ;; (function)
           "anomaly.utils.inttype" t ;; (function)
           "anomaly.utils.split" t ;; (function)
           "anomaly.utils.splitbits" t ;; (function)
           "anomaly.utils.splitVariable" t ;; (function)
           "anomaly.utils.standardize" t ;; (function)
           "anomaly.utils.standardizeXTest" t ;; (function)
           "anomalyCLI.deepanomaly.DeepantDetector" t ;; (class)
           "anomalyCLI.deepanomaly.TcnDetector" t ;; (class)
           "anomalyCLI.deepanomaly.UsadDetector" t ;; (class)
           "anomalyCLI.deepanomaly.VaelstmDetector" t ;; (class)
           "anova" t ;; (mFile) Analysis of variance (ANOVA) results
           "anova.argparse.parseAndValidateConstructorNVArgTypes" t ;; (function)
           "anova.argparse.parseFactorsAndNVArgs" t ;; (function)
           "anova.argparse.parseYAndConstructorNVArgs" t ;; (function)
           "anova.argparse.prepareMultcompareArgs" t ;; (function)
           "anova.utils.anovaMeanAndCovariance" t ;; (function)
           "anova.utils.createANOVADesignMatrix" t ;; (function)
           "anova.utils.createFactorValsTable" t ;; (function)
           "anova.utils.createNestedFactorGroupings" t ;; (function)
           "anova.utils.createValueSetsFromChars" t ;; (function)
           "anova.utils.designMatrixForNestedFactors" t ;; (function)
           "anova.utils.getExpectedMeanSquaresInfo" t ;; (function)
           "anova.utils.makeModelMatrixFromTerms" t ;; (function)
           "anova.utils.termcross" t ;; (function)
           "anova.utils.varianceComponentEstimate" t ;; (function)
           "anova.validation.validateAlpha" t ;; (function)
           "anova.validation.validateFactorAttributeArg" t ;; (function)
           "anova.validation.validateFactorsAndConvertToIdx" t ;; (function)
           "anova.validation.validateIndividualFactor" t ;; (function)
           "anova.validation.validateModelSpec" t ;; (function)
           "anova.validation.validateYAndFactorsTypes" t ;; (function)
           "anova.validation.verifyFactorNamesInTable" t ;; (function)
           "anova.validation.verifyInputIsLocal" t ;; (function)
           "anova1" t ;; (mFile) One-way analysis of variance
           "anova2" t ;; (mFile) Two-way analysis of variance
           "anovan" t ;; (mFile) N-way analysis of variance
           "ansaribradley" t ;; (mFile) Ansari-Bradley test
           "antenna.Circle" t ;; (class)
           "antenna.Ellipse" t ;; (class)
           "antenna.generateCirclePoints" t ;; (function)
           "antenna.generateRectanglePoints" t ;; (function)
           "antenna.insertElement" t ;; (function)
           "antenna.Polygon" t ;; (class)
           "antenna.Rectangle" t ;; (class)
           "antenna.Shape" t ;; (class)
           "antenna.Triangle" t ;; (class)
           "antennaArrayDesigner" t ;; (mFile) Design, visualize, and analyze arrays
           "antennaDesigner" t ;; (mFile) Design, visualize, and analyze antennas
           "antipode" t ;; (mFile) Point on opposite side of globe
           "any" t ;; (mFile) Determine if any array elements are nonzero
           "any2byte" t ;; (mex)
           "any2byte_svd" t ;; (mex)
           "anymissing" t ;; (mFile) Determine if any array element is missing
           "anynan" t ;; (mFile) Determine if any array element is NaN
           "aoctool" t ;; (mFile) Interactive analysis of covariance
           "aoicircle" t ;; (mFile) Define circular area of interest
           "aoiquad" t ;; (mFile) Define quadrangular or rectangular area of interest
           "ap2beamwidth" t ;; (mFile) Compute half-power beamwidth from aperture length
           "apacheCassandra" t ;; (mFile) Create Apache Cassandra database connection
           "apaseq" t ;; (mFile) Pseudorandom binary maximum length sequence
           "aperture2gain" t ;; (mFile) Convert effective aperture to gain
           "aperture2swath" t ;; (mFile) Swath extent for radar on ground plane
           "apianus" t ;; (mFile)
           "APIs.DataStorage" t ;; (class)
           "APIs.ExpensiveHandle" t ;; (class)
           "APIs.SurrogateEvaluator" t ;; (class)
           "APIs.SurrogateFitter" t ;; (class)
           "apmf2ls" t ;; (mFile)
           "apolloExportOptions" t ;; (mFile)
           "appcoef" t ;; (mFile) 1-D approximation coefficients
           "appcoef2" t ;; (mFile) 2-D approximation coefficients
           "appdesigner" t ;; (mFile) Create apps interactively
           "appdesigner.appmigration.ButtonGroupPropertiesConverter" t ;; (class)
           "appdesigner.appmigration.UIControlPropertiesConverter" t ;; (class)
           "appdesigner.customcomponent.configureMetadata" t ;; (function)
           "appdesigner.customcomponent.removeMetadata" t ;; (function)
           "appearance" t ;; (pFile)
           "append" t ;; (mFile) Combine strings
           "appendAbsolutePath" t ;; (pFile)
           "applicationCompiler" t ;; (mFile)
           "applycform" t ;; (mFile) Apply device-independent color space transformation
           "applyLinearFilter" t ;; (mFile)
           "applylut" t ;; (mFile) Neighborhood operations on binary images using lookup tables
           "applyPortHighlightByStatus" t ;; (pFile)
           "appmod" t ;; (mFile)
           "approximateEntropy" t ;; (mFile) Measure of regularity of nonlinear time series
           "aprecon" t ;; (mFile)
           "apskdemod" t ;; (mFile) Amplitude phase shift keying (APSK) demodulation
           "apskmod" t ;; (mFile) Amplitude phase shift keying (APSK) modulation
           "aptknt" t ;; (mFile) Acceptable knot sequence
           "ar" t ;; (mFile) Estimate parameters when identifying AR model or ARI model for scalar time series
           "aralog" t ;; (mex)
           "ArbitraryFiniteGapFeed" t ;; (pFile) Create an arbitrary finite gap feed object
           "arblk.argumentPrototype" t ;; (class)
           "arblk.clientServerInterface" t ;; (class)
           "arblk.convertPortNameToArgName" t ;; (function)
           "arblk.findAUTOSARClientBlks" t ;; (function)
           "arblk.findOperationConfigurableSubsystems" t ;; (function)
           "arblk.operationPrototype" t ;; (class)
           "arblk.parseOperationPrototype" t ;; (function)
           "arburg" t ;; (mFile) Autoregressive all-pole model parameters — Burg’s method
           "arcgridread" t ;; (mFile) (Not recommended) Read gridded data set in ArcGrid ASCII or GridFloat format
           "archdataeditor" t ;; (pFile)
           "archtest" t ;; (mFile) Engle test for residual heteroscedasticity
           "arcov" t ;; (mFile) Autoregressive all-pole model parameters — covariance method
           "ardemo" t ;; (mFile)
           "arduinoExplorer" t ;; (mFile)
           "ardupilotreader" t ;; (mFile) Read ArduPilot log file
           "are" t ;; (mFile)
           "area" t ;; (mFile) Filled area 2-D plot
           "areaint" t ;; (mFile) Surface area of polygon on sphere or ellipsoid
           "areamat" t ;; (mFile) Surface area covered by nonzero values in binary data grid
           "areaquad" t ;; (mFile) Surface area of latitude-longitude quadrangle
           "aresolv" t ;; (mFile)
           "argname2sysname" t ;; (mFile)
           "arguments" t ;; (mFile) Declare function argument validation
           "arima" t ;; (mFile) Create univariate autoregressive integrated moving average (ARIMA) model
           "arith2geom" t ;; (mFile) Arithmetic to geometric moments of asset returns
           "arithdeco" t ;; (mFile) Decode binary code by arithmetic decoding
           "arithenco" t ;; (mFile) Encode sequence of symbols by arithmetic encoding
           "ArithShift_ddg" t ;; (pFile)
           "arm_cortex_m.cmsis.cmsis_core" t ;; (class)
           "arm_cortex_m.cmsis.cmsis_core.getDefaultVersion" t ;; (method)
           "arm_cortex_m.cmsis.cmsis_dsp" t ;; (class)
           "arm_cortex_m.cmsis.cmsis_dsp.getDefaultVersion" t ;; (method)
           "arm_cortex_m.cmsis.ui.CMSISToolsSetupWorkflow" t ;; (class)
           "arm_cortex_m.cmsis.ui.SelectCMSISPackages" t ;; (class)
           "arm_cortex_m.cmsis.ui.SelectCMSISPackages.backButtonCallback" t ;; (method)
           "arm_cortex_m.cmsis.ui.SelectCMSISPackages.finish" t ;; (method)
           "arm_cortex_m.cmsis.ui.SelectCMSISPackages.getAllTemplateWidgetLayoutDetails" t ;; (method)
           "arm_cortex_m.cmsis.ui.SelectCMSISPackages.getWidgetPropertyNames" t ;; (method)
           "arm_cortex_m.cmsis.ui.SelectCMSISPackages.nextButtonCallback" t ;; (method)
           "arm_cortex_m.cmsis.ui.SelectCMSISPackages.setWidgetTags" t ;; (method)
           "arm_cortex_m.cmsis.ui.SetupCMSISCoreRegistration" t ;; (class)
           "arm_cortex_m.cmsis.ui.SetupCMSISCoreRegistration.backButtonCallback" t ;; (method)
           "arm_cortex_m.cmsis.ui.SetupCMSISCoreRegistration.finish" t ;; (method)
           "arm_cortex_m.cmsis.ui.SetupCMSISCoreRegistration.getAllTemplateWidgetLayoutDetails" t ;; (method)
           "arm_cortex_m.cmsis.ui.SetupCMSISCoreRegistration.getWidgetPropertyNames" t ;; (method)
           "arm_cortex_m.cmsis.ui.SetupCMSISCoreRegistration.nextButtonCallback" t ;; (method)
           "arm_cortex_m.cmsis.ui.SetupCMSISCoreRegistration.setWidgetTags" t ;; (method)
           "arm_cortex_m.cmsis.ui.SetupCMSISDspRegistration" t ;; (class)
           "arm_cortex_m.cmsis.ui.SetupCMSISDspRegistration.backButtonCallback" t ;; (method)
           "arm_cortex_m.cmsis.ui.SetupCMSISDspRegistration.finish" t ;; (method)
           "arm_cortex_m.cmsis.ui.SetupCMSISDspRegistration.getAllTemplateWidgetLayoutDetails" t ;; (method)
           "arm_cortex_m.cmsis.ui.SetupCMSISDspRegistration.getWidgetPropertyNames" t ;; (method)
           "arm_cortex_m.cmsis.ui.SetupCMSISDspRegistration.nextButtonCallback" t ;; (method)
           "arm_cortex_m.cmsis.ui.SetupCMSISDspRegistration.setWidgetTags" t ;; (method)
           "arm_cortex_m.cmsis.ui.ValidateCMSISCoreInstall" t ;; (class)
           "arm_cortex_m.cmsis.ui.ValidateCMSISCoreInstall.backButtonCallback" t ;; (method)
           "arm_cortex_m.cmsis.ui.ValidateCMSISCoreInstall.finish" t ;; (method)
           "arm_cortex_m.cmsis.ui.ValidateCMSISCoreInstall.getAllTemplateWidgetLayoutDetails" t ;; (method)
           "arm_cortex_m.cmsis.ui.ValidateCMSISCoreInstall.getWidgetPropertyNames" t ;; (method)
           "arm_cortex_m.cmsis.ui.ValidateCMSISCoreInstall.nextButtonCallback" t ;; (method)
           "arm_cortex_m.cmsis.ui.ValidateCMSISCoreInstall.setWidgetTags" t ;; (method)
           "arm_cortex_m.cmsis.ui.ValidateCMSISDspInstall" t ;; (class)
           "arm_cortex_m.cmsis.ui.ValidateCMSISDspInstall.backButtonCallback" t ;; (method)
           "arm_cortex_m.cmsis.ui.ValidateCMSISDspInstall.finish" t ;; (method)
           "arm_cortex_m.cmsis.ui.ValidateCMSISDspInstall.getAllTemplateWidgetLayoutDetails" t ;; (method)
           "arm_cortex_m.cmsis.ui.ValidateCMSISDspInstall.getWidgetPropertyNames" t ;; (method)
           "arm_cortex_m.cmsis.ui.ValidateCMSISDspInstall.nextButtonCallback" t ;; (method)
           "arm_cortex_m.cmsis.ui.ValidateCMSISDspInstall.setWidgetTags" t ;; (method)
           "arm_cortex_m.interrupt.checkSimulinkTaskPriorityLevels" t ;; (function)
           "arm_cortex_m.interrupt.disableSysTick" t ;; (function)
           "arm_cortex_m.interrupt.evalSimulinkTaskPriorityParameter" t ;; (function)
           "arm_cortex_m.interrupt.getModelBaseRatePriority" t ;; (function)
           "arm_cortex_m.interrupt.interruptsRead" t ;; (class)
           "arm_cortex_m.interrupt.rearrangeIrqPriority" t ;; (function)
           "arm_cortex_m_interrupt" t ;; (mex)
           "arm_cortex_m_interrupt_callback" t ;; (mFile)
           "arm_cortex_m_lib" t ;; (slxFile)
           "arma2ar" t ;; (mFile) Convert ARMA model to AR model
           "arma2ma" t ;; (mFile) Convert ARMA model to MA model
           "armafevd" t ;; (mFile) Generate or plot ARMA model forecast error variance decomposition (FEVD)
           "armairf" t ;; (mFile) Generate or plot ARMA model impulse responses
           "armaskedcaps" t ;; (pFile)
           "armax" t ;; (mFile) Estimate parameters of ARMAX, ARIMAX, ARMA, or ARIMA model using time-domain data
           "armaxOptions" t ;; (mFile) Option set for armax
           "armcov" t ;; (mFile) Autoregressive all-pole model parameters — modified covariance method
           "armlinuxdemolib" t ;; (slxFile)
           "ARMTFL.NEONMatrMatrAddEntry" t ;; (class)
           "ARMTFL.NEONMatrMatrMulEntry_16x8" t ;; (class)
           "ARMTFL.NEONMatrMatrMulEntry_32x4" t ;; (class)
           "ARMTFL.NEONMatrMatrMulEntry_8x16" t ;; (class)
           "ARMTFL.NEONMatrVectMulEntry_16x8" t ;; (class)
           "ARMTFL.NEONMatrVectMulEntry_32x4" t ;; (class)
           "ARMTFL.NEONMatrVectMulEntry_8x16" t ;; (class)
           "arOptions" t ;; (mFile) Option set for ar
           "array2cwtfilters" t ;; (mFile) Convert deep-learning CWT filter tensor to filter bank matrix
           "array2table" t ;; (mFile) Convert homogeneous array to table
           "array2timetable" t ;; (mFile) Convert homogeneous array to timetable
           "arrayConfig" t ;; (mFile) Create phased array configuration
           "arrayConfig.Element" 'property
           "arrayDatastore" t ;; (mFile) Datastore for in-memory data
           "arrayfactor" t ;; (mFile) Array factor of sensor arrays
           "arrayfun" t ;; (mFile) Apply function to each element of array
           "arrayscanloss" t ;; (mFile) Loss due to electronic scanning off broadside
           "arrayviewfunc" t ;; (mFile)
           "Arria10GX.hdlcoder_ref_design_customization" t ;; (function)
           "Arria10GX.plugin_board" t ;; (function)
           "Arria10GX.qsys_jtag_matlab_axi_master_171.plugin_rd" t ;; (function)
           "Arria10GX.qsys_pcie_axi_manager_171.plugin_rd" t ;; (function)
           "ArrowDECA.eth_matlab_axi_master.plugin_rd" t ;; (function)
           "ArrowDECA.hdlcoder_ref_design_customization" t ;; (function)
           "ArrowDECA.plugin_board" t ;; (function)
           "ArrowDECA.qsys_base_150.plugin_rd" t ;; (function)
           "ArrowDECA.qsys_base_160.plugin_rd" t ;; (function)
           "arrowline" t ;; (mFile)
           "ArrowSoCKit.hdlcoder_ref_design_customization" t ;; (function)
           "ArrowSoCKit.plugin_board" t ;; (function)
           "ArrowSoCKit.qsys_base_150.plugin_rd" t ;; (function)
           "ArrowSoCKit.qsys_base_160.plugin_rd" t ;; (function)
           "arx" t ;; (mFile) Estimate parameters of ARX, ARIX, AR, or ARI model
           "arx2th" t ;; (mFile)
           "arxml.arxml_private" t ;; (function)
           "arxml.ARXMLValidationErrorHandler" t ;; (class)
           "arxml.convertReleaseToSchema" t ;; (function)
           "arxml.getAdaptiveDefaultSchema" t ;; (function)
           "arxml.getDefaultSchemaVersion" t ;; (function)
           "arxml.getPIMInfoFromInternalData" t ;; (function)
           "arxml.getSchemaVersionForConfigSet" t ;; (function)
           "arxml.getSupportedAdaptiveSchemaVersions" t ;; (function)
           "arxml.getSupportedSchemaVersions" t ;; (function)
           "arxml.importer" t ;; (class)
           "arxml.SchemaDefinitionResolver" t ;; (class)
           "arxml.splitAbsolutePath" t ;; (function)
           "arxml.utils.ensureTrailingSeparator" t ;; (function)
           "arxml.utils.findArxmlFilePathsInFolder" t ;; (function)
           "arxml.xmlvalidate" t ;; (function)
           "arxmlDatabase" t ;; (pFile) Create ARXML database from ARXML file
           "arxOptions" t ;; (mFile) Option set for arx
           "arxRegul" t ;; (mFile) Determine regularization constants for ARX model estimation
           "arxRegulOptions" t ;; (mFile) Option set for arxRegul
           "arxstruc" t ;; (mFile) Compute loss functions for single-output ARX models
           "aryule" t ;; (mFile) Autoregressive all-pole model parameters — Yule-Walker method
           "asam.CDFX" t ;; (class)
           "asam.cdfx.axis.AxisContainer" t ;; (class)
           "asam.cdfx.axis.CommonAxis" t ;; (class)
           "asam.cdfx.axis.CurveAxis" t ;; (class)
           "asam.cdfx.axis.FixedAxis" t ;; (class)
           "asam.cdfx.axis.RescaledAxis" t ;; (class)
           "asam.cdfx.axis.StandardAxis" t ;; (class)
           "asam.cdfx.AxisContainerFactory" t ;; (function)
           "asam.cdfx.instance.ASCII" t ;; (class)
           "asam.cdfx.instance.Blob" t ;; (class)
           "asam.cdfx.instance.Boolean" t ;; (class)
           "asam.cdfx.instance.CommonAxis" t ;; (class)
           "asam.cdfx.instance.Cube4" t ;; (class)
           "asam.cdfx.instance.Cube5" t ;; (class)
           "asam.cdfx.instance.Cuboid" t ;; (class)
           "asam.cdfx.instance.Curve" t ;; (class)
           "asam.cdfx.instance.CurveAxis" t ;; (class)
           "asam.cdfx.instance.DependentValue" t ;; (class)
           "asam.cdfx.instance.Map" t ;; (class)
           "asam.cdfx.instance.RescaledAxis" t ;; (class)
           "asam.cdfx.instance.Structure" t ;; (class)
           "asam.cdfx.instance.Value" t ;; (class)
           "asam.cdfx.instance.ValueBlock" t ;; (class)
           "asam.cdfx.mf0.getCategory" t ;; (function)
           "asam.cdfx.mf0.getFeatureReference" t ;; (function)
           "asam.cdfx.mf0.getShortName" t ;; (function)
           "asam.cdfx.mf0.getUnitDisplayName" t ;; (function)
           "asam.cdfx.mf0.getValueContainer" t ;; (function)
           "asam.cdfx.mf0.getValueDimensions" t ;; (function)
           "asam.cdfx.mf0.getVariantProp" t ;; (function)
           "asam.cdfx.SWInstanceFactory" t ;; (function)
           "asam.cdfx.SWSystem" t ;; (class)
           "asam.mcd2mc.create" t ;; (function)
           "asam.mcd2mc.writeIFDataXCPInfo" t ;; (function)
           "asam.MDF" t ;; (class)
           "asam.mdf.AttachmentType" t ;; (class)
           "asam.mdf.AttachmentType.Embedded" 'enumeration
           "asam.mdf.AttachmentType.EmbeddedWithCompression" 'enumeration
           "asam.mdf.AttachmentType.External" 'enumeration
           "asam.mdf.AttachmentType.Missing" 'enumeration
           "asam.mdf.AttachmentType.Unspecified" 'enumeration
           "asam.mdf.castConversion" t ;; (function)
           "asam.mdf.castOperationType" t ;; (function)
           "asam.mdf.castReadIndexType" t ;; (function)
           "asam.mdf.castReadPosition" t ;; (function)
           "asam.mdf.ChannelComponentType" t ;; (class)
           "asam.mdf.ChannelComponentType.ArrayElement" 'enumeration
           "asam.mdf.ChannelComponentType.Missing" 'enumeration
           "asam.mdf.ChannelComponentType.None" 'enumeration
           "asam.mdf.ChannelComponentType.StructureMember" 'enumeration
           "asam.mdf.ChannelComponentType.Unspecified" 'enumeration
           "asam.mdf.ChannelCompositionType" t ;; (class)
           "asam.mdf.ChannelCompositionType.Array" 'enumeration
           "asam.mdf.ChannelCompositionType.Missing" 'enumeration
           "asam.mdf.ChannelCompositionType.None" 'enumeration
           "asam.mdf.ChannelCompositionType.Structure" 'enumeration
           "asam.mdf.ChannelCompositionType.Unspecified" 'enumeration
           "asam.mdf.ChannelConversionType" t ;; (class)
           "asam.mdf.ChannelConversionType.Algebraic" 'enumeration
           "asam.mdf.ChannelConversionType.BitfieldTextTable" 'enumeration
           "asam.mdf.ChannelConversionType.Exponential" 'enumeration
           "asam.mdf.ChannelConversionType.Linear" 'enumeration
           "asam.mdf.ChannelConversionType.Logarithmic" 'enumeration
           "asam.mdf.ChannelConversionType.Missing" 'enumeration
           "asam.mdf.ChannelConversionType.None" 'enumeration
           "asam.mdf.ChannelConversionType.OneToOne" 'enumeration
           "asam.mdf.ChannelConversionType.Polynomial" 'enumeration
           "asam.mdf.ChannelConversionType.Rational" 'enumeration
           "asam.mdf.ChannelConversionType.TextToText" 'enumeration
           "asam.mdf.ChannelConversionType.TextToValue" 'enumeration
           "asam.mdf.ChannelConversionType.Unspecified" 'enumeration
           "asam.mdf.ChannelConversionType.ValueRangeToText" 'enumeration
           "asam.mdf.ChannelConversionType.ValueRangeToValue" 'enumeration
           "asam.mdf.ChannelConversionType.ValueToText" 'enumeration
           "asam.mdf.ChannelConversionType.ValueToValueInterpolated" 'enumeration
           "asam.mdf.ChannelConversionType.ValueToValueNotInterpolated" 'enumeration
           "asam.mdf.ChannelDataType" t ;; (class)
           "asam.mdf.ChannelDataType.ByteArray" 'enumeration
           "asam.mdf.ChannelDataType.CANOpenDate" 'enumeration
           "asam.mdf.ChannelDataType.CANOpenTime" 'enumeration
           "asam.mdf.ChannelDataType.ComplexRealBigEndian" 'enumeration
           "asam.mdf.ChannelDataType.ComplexRealLittleEndian" 'enumeration
           "asam.mdf.ChannelDataType.IntegerSignedBigEndian" 'enumeration
           "asam.mdf.ChannelDataType.IntegerSignedLittleEndian" 'enumeration
           "asam.mdf.ChannelDataType.IntegerUnsignedBigEndian" 'enumeration
           "asam.mdf.ChannelDataType.IntegerUnsignedLittleEndian" 'enumeration
           "asam.mdf.ChannelDataType.MIMESample" 'enumeration
           "asam.mdf.ChannelDataType.MIMEStream" 'enumeration
           "asam.mdf.ChannelDataType.Missing" 'enumeration
           "asam.mdf.ChannelDataType.RealBigEndian" 'enumeration
           "asam.mdf.ChannelDataType.RealLittleEndian" 'enumeration
           "asam.mdf.ChannelDataType.StringASCII" 'enumeration
           "asam.mdf.ChannelDataType.StringUTF16BigEndian" 'enumeration
           "asam.mdf.ChannelDataType.StringUTF16LittleEndian" 'enumeration
           "asam.mdf.ChannelDataType.StringUTF8" 'enumeration
           "asam.mdf.ChannelDataType.Unspecified" 'enumeration
           "asam.mdf.ChannelSyncType" t ;; (class)
           "asam.mdf.ChannelSyncType.Angle" 'enumeration
           "asam.mdf.ChannelSyncType.Distance" 'enumeration
           "asam.mdf.ChannelSyncType.Index" 'enumeration
           "asam.mdf.ChannelSyncType.Missing" 'enumeration
           "asam.mdf.ChannelSyncType.None" 'enumeration
           "asam.mdf.ChannelSyncType.Time" 'enumeration
           "asam.mdf.ChannelSyncType.Unspecified" 'enumeration
           "asam.mdf.ChannelType" t ;; (class)
           "asam.mdf.ChannelType.FixedLength" 'enumeration
           "asam.mdf.ChannelType.Master" 'enumeration
           "asam.mdf.ChannelType.MaximumLength" 'enumeration
           "asam.mdf.ChannelType.Missing" 'enumeration
           "asam.mdf.ChannelType.Synchronization" 'enumeration
           "asam.mdf.ChannelType.Unspecified" 'enumeration
           "asam.mdf.ChannelType.VariableLength" 'enumeration
           "asam.mdf.ChannelType.VirtualData" 'enumeration
           "asam.mdf.ChannelType.VirtualMaster" 'enumeration
           "asam.mdf.Conversion" t ;; (class)
           "asam.mdf.Conversion.All" 'enumeration
           "asam.mdf.Conversion.Missing" 'enumeration
           "asam.mdf.Conversion.None" 'enumeration
           "asam.mdf.Conversion.Numeric" 'enumeration
           "asam.mdf.EventCause" t ;; (class)
           "asam.mdf.EventCause.Error" 'enumeration
           "asam.mdf.EventCause.Missing" 'enumeration
           "asam.mdf.EventCause.Other" 'enumeration
           "asam.mdf.EventCause.Script" 'enumeration
           "asam.mdf.EventCause.Tool" 'enumeration
           "asam.mdf.EventCause.Unspecified" 'enumeration
           "asam.mdf.EventCause.User" 'enumeration
           "asam.mdf.EventRangeType" t ;; (class)
           "asam.mdf.EventRangeType.Begin" 'enumeration
           "asam.mdf.EventRangeType.End" 'enumeration
           "asam.mdf.EventRangeType.Missing" 'enumeration
           "asam.mdf.EventRangeType.Point" 'enumeration
           "asam.mdf.EventRangeType.Unspecified" 'enumeration
           "asam.mdf.EventScopeType" t ;; (class)
           "asam.mdf.EventScopeType.Channel" 'enumeration
           "asam.mdf.EventScopeType.ChannelGroup" 'enumeration
           "asam.mdf.EventScopeType.File" 'enumeration
           "asam.mdf.EventScopeType.Missing" 'enumeration
           "asam.mdf.EventScopeType.Unspecified" 'enumeration
           "asam.mdf.EventType" t ;; (class)
           "asam.mdf.EventType.AcquisitionInterrupt" 'enumeration
           "asam.mdf.EventType.Marker" 'enumeration
           "asam.mdf.EventType.Missing" 'enumeration
           "asam.mdf.EventType.Recording" 'enumeration
           "asam.mdf.EventType.RecordingInterrupt" 'enumeration
           "asam.mdf.EventType.StartRecordingTrigger" 'enumeration
           "asam.mdf.EventType.StopRecordingTrigger" 'enumeration
           "asam.mdf.EventType.Trigger" 'enumeration
           "asam.mdf.EventType.Unspecified" 'enumeration
           "asam.mdf.FileInterface" t ;; (class)
           "asam.mdf.FileInterface.getChannelGroupPropertyNames" t ;; (method)
           "asam.mdf.FileInterface.getChannelPropertyNames" t ;; (method)
           "asam.mdf.FileInterface.getDefaultSourceInfoStruct" t ;; (method)
           "asam.mdf.FileInterface.getLatestMDFVersion" t ;; (method)
           "asam.mdf.FileInterface.platformCheck" t ;; (method)
           "asam.mdf.FileInterface.validateDestAttachmentFilePath" t ;; (method)
           "asam.mdf.FileInterface.validateDestMDFFilePath" t ;; (method)
           "asam.mdf.FileInterface.validateSourceMDFFilePath" t ;; (method)
           "asam.mdf.legacy.FileInterface" t ;; (class)
           "asam.mdf.legacy.FileInterface.ChannelGroupPropertyNames" 'property
           "asam.mdf.legacy.FileInterface.ChannelPropertyNames" 'property
           "asam.mdf.legacy.FileInterface.Close" t ;; (method)
           "asam.mdf.legacy.FileInterface.Open" t ;; (method)
           "asam.mdf.legacy.FileInterface.Parse" t ;; (method)
           "asam.mdf.legacy.FileInterface.SaveAttachment" t ;; (method)
           "asam.mdf.legacy.OperationType" t ;; (class)
           "asam.mdf.legacy.OperationType.Close" 'enumeration
           "asam.mdf.legacy.OperationType.Open" 'enumeration
           "asam.mdf.legacy.OperationType.Parse" 'enumeration
           "asam.mdf.legacy.OperationType.Read" 'enumeration
           "asam.mdf.legacy.OperationType.SaveAttachment" 'enumeration
           "asam.mdf.legacy.OutputFormat" t ;; (class)
           "asam.mdf.legacy.OutputFormat.TimeSeries" 'enumeration
           "asam.mdf.legacy.OutputFormat.Timetable" 'enumeration
           "asam.mdf.legacy.OutputFormat.Vector" 'enumeration
           "asam.mdf.MDFInfo" t ;; (class)
           "asam.mdf.OperationType" t ;; (class)
           "asam.mdf.OperationType.AddAttachment" 'enumeration
           "asam.mdf.OperationType.Close" 'enumeration
           "asam.mdf.OperationType.Create" 'enumeration
           "asam.mdf.OperationType.Finalize" 'enumeration
           "asam.mdf.OperationType.GetAttachmentInfo" 'enumeration
           "asam.mdf.OperationType.GetChannelGroupEvents" 'enumeration
           "asam.mdf.OperationType.GetChannelGroupInfo" 'enumeration
           "asam.mdf.OperationType.GetChannelInfo" 'enumeration
           "asam.mdf.OperationType.GetCreatorInfo" 'enumeration
           "asam.mdf.OperationType.GetFileEvents" 'enumeration
           "asam.mdf.OperationType.GetFileInfo" 'enumeration
           "asam.mdf.OperationType.Open" 'enumeration
           "asam.mdf.OperationType.Read" 'enumeration
           "asam.mdf.OperationType.RemoveAttachment" 'enumeration
           "asam.mdf.OperationType.Rewrite" 'enumeration
           "asam.mdf.OperationType.SaveAttachment" 'enumeration
           "asam.mdf.OperationType.SetFileHistory" 'enumeration
           "asam.mdf.OperationType.Sort" 'enumeration
           "asam.mdf.OperationType.Write" 'enumeration
           "asam.mdf.ReadIndexType" t ;; (class)
           "asam.mdf.ReadIndexType.All" 'enumeration
           "asam.mdf.ReadIndexType.Numeric" 'enumeration
           "asam.mdf.ReadIndexType.Timestamp" 'enumeration
           "asam.mdf.RemoteUtility" t ;; (class)
           "asam.mdf.RemoteUtility.hasRemotePrefix" t ;; (method)
           "asam.mdf.RemoteUtility.hasValidURLFormat" t ;; (method)
           "asam.mdf.SourceBusType" t ;; (class)
           "asam.mdf.SourceBusType.CAN" 'enumeration
           "asam.mdf.SourceBusType.Ethernet" 'enumeration
           "asam.mdf.SourceBusType.FlexRay" 'enumeration
           "asam.mdf.SourceBusType.KLine" 'enumeration
           "asam.mdf.SourceBusType.LIN" 'enumeration
           "asam.mdf.SourceBusType.Missing" 'enumeration
           "asam.mdf.SourceBusType.MOST" 'enumeration
           "asam.mdf.SourceBusType.None" 'enumeration
           "asam.mdf.SourceBusType.Other" 'enumeration
           "asam.mdf.SourceBusType.Unspecified" 'enumeration
           "asam.mdf.SourceBusType.USB" 'enumeration
           "asam.mdf.SourceType" t ;; (class)
           "asam.mdf.SourceType.Bus" 'enumeration
           "asam.mdf.SourceType.ECU" 'enumeration
           "asam.mdf.SourceType.IODevice" 'enumeration
           "asam.mdf.SourceType.Missing" 'enumeration
           "asam.mdf.SourceType.Other" 'enumeration
           "asam.mdf.SourceType.Tool" 'enumeration
           "asam.mdf.SourceType.Unspecified" 'enumeration
           "asam.mdf.SourceType.User" 'enumeration
           "asam.mdf.WriteMethod" t ;; (class)
           "asam.mdf.WriteMethod.FunctionWritePhysValueDouble" 'enumeration
           "asam.mdf.WriteMethod.FunctionWritePhysValueString" 'enumeration
           "asam.mdf.WriteMethod.FunctionWriteRawValueByteArray" 'enumeration
           "asam.mdf.WriteMethod.FunctionWriteRawValueDouble" 'enumeration
           "asam.mdf.WriteMethod.FunctionWriteRawValueInt64" 'enumeration
           "asam.mdf.WriteMethod.FunctionWriteRawValueString" 'enumeration
           "asam.mdf.WriteMethod.Missing" 'enumeration
           "AsamCalibrationAccessEnum" t ;; (mFile)
           "AsamCalibrationAccessEnum.Calibration" 'enumeration
           "AsamCalibrationAccessEnum.NoCalibration" 'enumeration
           "ASAP2.Parameter" t ;; (class)
           "ASAP2.Parameter.Dimensions" 'property
           "ASAP2.Signal" t ;; (class)
           "asap2_default_tmf" t ;; (mFile)
           "asap2indent" t ;; (mFile)
           "asap2post" t ;; (mFile)
           "asap2post_targets" t ;; (mFile)
           "asb6DOFTransform" t ;; (mFile)
           "asbAddOns" t ;; (pFile)
           "asbAngle2DcmTransform" t ;; (mFile)
           "asbAngle2QuatTransform" t ;; (mFile)
           "asbCubeSatBlockLib" t ;; (slxFile)
           "asbDcm2AngleTransform" t ;; (mFile)
           "asbDcm2QuatTransform" t ;; (mFile)
           "asbFlightControlAnalysis" t ;; (mFile) Start flight control analysis template
           "asbhelp" t ;; (mFile)
           "asbhmihelp" t ;; (pFile)
           "asbMultirotorTransform" t ;; (mFile)
           "asbPlanetaryEphemTransform" t ;; (mFile)
           "asbQuat2AngleTransform" t ;; (mFile)
           "asbQuat2DcmTransform" t ;; (mFile)
           "asbRotorTransform" t ;; (mFile)
           "asbsim3dhelp" t ;; (mFile)
           "asbWMMTransform" t ;; (mFile)
           "ASCET2Simulink.Block" t ;; (class)
           "ASCET2Simulink.BlockSequenceNumber" t ;; (class)
           "ASCET2Simulink.BlockTag" t ;; (class)
           "asec" t ;; (mFile) Inverse secant in radians
           "asecd" t ;; (mFile) Inverse secant in degrees
           "asech" t ;; (mFile) Inverse hyperbolic secant
           "asFewOfPattern" t ;; (mFile) Match pattern as few times as possible
           "asianbycrr" t ;; (mFile) Price Asian option from Cox-Ross-Rubinstein binomial tree
           "asianbyeqp" t ;; (mFile) Price Asian option from Equal Probabilities binomial tree
           "asianbyhhm" t ;; (mFile) Price European discrete arithmetic fixed Asian options using Haug, Haug, Margrabe model
           "asianbyitt" t ;; (mFile) Price Asian options using implied trinomial tree (ITT)
           "asianbykv" t ;; (mFile) Prices European geometric Asian options using Kemna-Vorst model
           "asianbylevy" t ;; (mFile) Price of European arithmetic Asian options using Levy model
           "asianbyls" t ;; (mFile) Price European or American Asian options using Monte Carlo simulations
           "asianbystocktree" t ;; (mFile)
           "asianbystt" t ;; (mFile) Price Asian options using standard trinomial tree
           "asianbytw" t ;; (mFile) Price European arithmetic fixed Asian options using Turnbull-Wakeman model
           "asiansensbyhhm" t ;; (mFile) Calculate price and sensitivities of European discrete arithmetic fixed Asian options using Haug, Haug, Margrabe model
           "asiansensbykv" t ;; (mFile) Calculate prices or sensitivities of European geometric Asian options using Kemna-Vorst model
           "asiansensbylevy" t ;; (mFile) Calculate prices or sensitivities of European arithmetic Asian options using Levy model
           "asiansensbyls" t ;; (mFile) Calculate price and sensitivities for European or American Asian options using Monte Carlo simulations
           "asiansensbytw" t ;; (mFile) Calculate price and sensitivities of European fixed arithmetic Asian options using Turnbull-Wakeman model
           "asiansenseng" t ;; (mFile)
           "asin" t ;; (mFile) Inverse sine in radians
           "asind" t ;; (mFile) Inverse sine in degrees
           "asinh" t ;; (mFile) Inverse hyperbolic sine
           "asiosettings" t ;; (pFile) Open settings panel for ASIO driver
           "asManyOfPattern" t ;; (mFile) Match pattern as many times as possible
           "asmGui" t ;; (pFile)
           "asne" t ;; (mFile)
           "asqpdense" t ;; (pFile)
           "asqpdenseWarmStart" t ;; (pFile)
           "asrf" t ;; (mFile) Asymptotic Single Risk Factor (ASRF) capital
           "assema" t ;; (mFile) (Not recommended) Assemble area integral contributions
           "assemb" t ;; (mFile) (Not recommended) Assemble boundary condition contributions
           "assembleFEMatrices" t ;; (mFile) Assemble finite element matrices
           "assembleNetwork" t ;; (mFile) (Not recommended) Assemble deep learning network from pretrained layers
           "assempde" t ;; (mFile) (Not recommended) Assemble finite element matrices and solve elliptic PDE
           "assert" t ;; (mFile) Throw error if condition false
           "assetbybls" t ;; (mFile) Determine price of asset-or-nothing digital options using Black-Scholes model
           "assetsensbybls" t ;; (mFile) Determine price or sensitivities of asset-or-nothing digital options using Black-Scholes model
           "assignauction" t ;; (mFile) Assignment using auction global nearest neighbor
           "assignDetectionsToTracks" t ;; (mFile) Assign detections to tracks for multiobject tracking
           "assignin" t ;; (mFile) Assign value to variable in specified workspace
           "assigninContext" t ;; (pFile)
           "assigninGlobalScope" t ;; (pFile)
           "assignjv" t ;; (mFile) Jonker-Volgenant global nearest neighbor assignment algorithm
           "assignkbest" t ;; (mFile) Assignment using k-best global nearest neighbor
           "assignkbestsd" t ;; (mFile) K-best S-D solution that minimizes total cost of assignment
           "assignmunkres" t ;; (mFile) Munkres global nearest neighbor assignment algorithm
           "assignsd" t ;; (mFile) S-D assignment using Lagrangian relaxation
           "assignTOMHT" t ;; (mFile) Track-oriented multi-hypotheses tracking assignment
           "assignVarToWorkspace" t ;; (pFile)
           "associateVariableTableDDG" t ;; (pFile)
           "associateVariableTableRow" t ;; (pFile)
           "associateVariableTableSource" t ;; (pFile)
           "assumptions" t ;; (mFile) Show assumptions affecting symbolic variable, expression, or function
           "ast1797ASpec" t ;; (mFile)
           "ast2DGeoidPlot" t ;; (mFile)
           "ast8785CSpec" t ;; (mFile)
           "astC182" t ;; (mFile)
           "astDehavillandBeaver" t ;; (mFile)
           "astDehavillandBeaverState" t ;; (mFile)
           "astFormatContourLines" t ;; (mFile)
           "astHelperNauticalCalculation" t ;; (pFile)
           "astHelperNauticalReduction" t ;; (pFile)
           "astReadEGMFile" t ;; (mFile)
           "astReadSHAFile" t ;; (mFile)
           "astSkyHogg" t ;; (mFile)
           "AsyncEvaluator" t ;; (mFile)
           "asyncFcnCall" t ;; (mex)
           "AsynchronousMachineCback" t ;; (pFile)
           "AsynchronousMachineConvert" t ;; (pFile)
           "AsynchronousMachineIcon" t ;; (pFile)
           "AsynchronousMachineInit" t ;; (pFile)
           "AsynchronousMachineParam" t ;; (pFile)
           "AsynchronousMachinePuUni_class" t ;; (pFile)
           "AsynchronousMachineSIUni_class" t ;; (pFile)
           "asyncioimpl.Channel" t ;; (class)
           "asyncioimpl.InputStream" t ;; (class)
           "asyncioimpl.MessageHandler" t ;; (class)
           "asyncioimpl.OutputStream" t ;; (class)
           "asys2ss" t ;; (mFile)
           "atamult" t ;; (mFile)
           "atan" t ;; (mFile) Inverse tangent in radians
           "atan2" t ;; (mFile) Four-quadrant inverse tangent
           "atan2d" t ;; (mFile) Four-quadrant inverse tangent in degrees
           "atand" t ;; (mFile) Inverse tangent in degrees
           "atanh" t ;; (mFile) Inverse hyperbolic tangent
           "atmoscira" t ;; (mFile) Use COSPAR International Reference Atmosphere 1986 model
           "atmoscoesa" t ;; (mFile) Use 1976 COESA model
           "atmoshwm" t ;; (mFile) Implement horizontal wind model
           "atmoshwm07" t ;; (mFile)
           "atmosisa" t ;; (mFile) Use International Standard Atmosphere model
           "atmositu" t ;; (mFile) Use ITU reference atmospheres
           "atmoslapse" t ;; (mFile) Use Lapse Rate Atmosphere model
           "atmosnonstd" t ;; (mFile) Use climatic data from MIL-STD-210 or MIL-HDBK-310
           "atmosnrlmsise00" t ;; (mFile) Implement mathematical representation of 2001 United States Naval Research Laboratory Mass Spectrometer and Incoherent Scatter Radar Exosphere
           "atmospalt" t ;; (mFile) Calculate pressure altitude based on ambient pressure
           "atom" t ;; (mFile)
           "atomiccomp" t ;; (mFile) Calculate atomic composition of protein
           "atomlist" t ;; (mFile)
           "attachConfigSet" t ;; (pFile) Associate configuration set or configuration reference with model
           "attachConfigSetCopy" t ;; (pFile) Copy configuration set or configuration reference and associate it with model
           "attachhdlcconfig" t ;; (pFile)
           "attachToResetBlocks_TItarget" t ;; (mFile)
           "attentionLayer" t ;; (mFile) Dot-product attention layer
           "attenuator" t ;; (mFile) Create two-port attenuator element
           "attributeType" t ;; (mFile) Attribute type enumerations for labeling
           "attributeType.List" 'enumeration
           "attributeType.Logical" 'enumeration
           "attributeType.None" 'enumeration
           "attributeType.Numeric" 'enumeration
           "attributeType.String" 'enumeration
           "aucMetric" t ;; (mFile) Deep learning area under ROC curve (AUC) metric
           "audio.ai.convtasnet.layers.decoderLayer" t ;; (class)
           "audio.ai.crepe.getMATFileName" t ;; (function)
           "audio.ai.crepe.getNetwork" t ;; (function)
           "audio.ai.layers.FlattenCStyleLayer" t ;; (class)
           "audio.ai.layers.groupedConvolution1dLayer" t ;; (class)
           "audio.ai.layers.learnableSigmoidLayer" t ;; (class)
           "audio.ai.layers.positionalEncodingLayer" t ;; (class)
           "audio.ai.metricgan.applyThreshold" t ;; (function)
           "audio.ai.metricgan.postprocess" t ;; (function)
           "audio.ai.metricgan.preprocess" t ;; (function)
           "audio.ai.openl3.getMATFileName" t ;; (function)
           "audio.ai.openl3.getNetwork" t ;; (function)
           "audio.ai.sepformer.layers.moveBtoSLayer" t ;; (class)
           "audio.ai.sepformer.layers.moveSpktoBLayer" t ;; (class)
           "audio.ai.sepformer.layers.moveStoBLayer" t ;; (class)
           "audio.ai.sepformer.layers.overlapAddLayer" t ;; (class)
           "audio.ai.sepformer.layers.segmentationLayer" t ;; (class)
           "audio.ai.sepformer.layers.swapSandTLayer" t ;; (class)
           "audio.ai.vadnet.getMATFileName" t ;; (function)
           "audio.ai.vadnet.getNetwork" t ;; (function)
           "audio.ai.vadnet.layers.layerNormalizationElementwiseLayer" t ;; (class)
           "audio.ai.vadnet.layers.paddingLayer" t ;; (class)
           "audio.ai.vadnet.layers.reformatAndFlattenLayer" t ;; (class)
           "audio.ai.vadnet.layers.reformatLayer" t ;; (class)
           "audio.ai.vadnet.layers.reverseTimeLayer" t ;; (class)
           "audio.ai.vggish.getMATFileName" t ;; (function)
           "audio.ai.vggish.getNetwork" t ;; (function)
           "audio.ai.visqol.loadNUSVR" t ;; (function)
           "audio.ai.visqol.nusvrPredict" t ;; (function)
           "audio.ai.wav2vec.getDictionary" t ;; (function)
           "audio.ai.wav2vec.layers.positionalEmbeddingLayer" t ;; (class)
           "audio.ai.yamnet.getClasses" t ;; (function)
           "audio.ai.yamnet.getMATFileName" t ;; (function)
           "audio.ai.yamnet.getNetwork" t ;; (function)
           "audio.simulink.AudioDelta" t ;; (class)
           "audio.simulink.AudioOscillator" t ;; (class)
           "audio.simulink.AuditorySpectrumExtractor" t ;; (class)
           "audio.simulink.CepstralCoefficients" t ;; (class)
           "audio.simulink.CepstralFeatureExtractor" t ;; (class)
           "audio.simulink.CrepePostprocess" t ;; (class)
           "audio.simulink.crossover" t ;; (class)
           "audio.simulink.DesignAuditoryFilterBank" t ;; (class)
           "audio.simulink.DesignmelFilterBank" t ;; (class)
           "audio.simulink.DynamicRangeCompressor" t ;; (class)
           "audio.simulink.DynamicRangeExpander" t ;; (class)
           "audio.simulink.DynamicRangeGate" t ;; (class)
           "audio.simulink.DynamicRangeLimiter" t ;; (class)
           "audio.simulink.GammatoneFilterBank" t ;; (class)
           "audio.simulink.GraphicEQ" t ;; (class)
           "audio.simulink.GraphicEQ.helpFilterAnalysis" t ;; (method)
           "audio.simulink.LoudnessMeter" t ;; (class)
           "audio.simulink.MultibandParametricEQ" t ;; (class)
           "audio.simulink.OctaveFilter" t ;; (class)
           "audio.simulink.OctaveFilter.helpFilterAnalysis" t ;; (method)
           "audio.simulink.OctaveFilterBank" t ;; (class)
           "audio.simulink.OpenL3Spectrogram" t ;; (class)
           "audio.simulink.ParamEQDesign" t ;; (class)
           "audio.simulink.ParametricEQ" t ;; (class)
           "audio.simulink.Reverberator" t ;; (class)
           "audio.simulink.ShelvingEQDesignEnum" t ;; (class)
           "audio.simulink.ShelvingEQDesignEnum.addClassNameToEnumNames" t ;; (method)
           "audio.simulink.ShelvingEQDesignEnum.high" 'enumeration
           "audio.simulink.ShelvingEQDesignEnum.low" 'enumeration
           "audio.simulink.ShelvingEqualizerDesign" t ;; (class)
           "audio.simulink.ShelvingFilter" t ;; (class)
           "audio.simulink.ShelvingFilter.helpFilterAnalysis" t ;; (method)
           "audio.simulink.VariableFilterDesignEnum" t ;; (class)
           "audio.simulink.VariableFilterDesignEnum.addClassNameToEnumNames" t ;; (method)
           "audio.simulink.VariableFilterDesignEnum.highpass" 'enumeration
           "audio.simulink.VariableFilterDesignEnum.lowpass" 'enumeration
           "audio.simulink.VariableSlopeFilterDesign" t ;; (class)
           "audio.simulink.VoiceActivityDetector" t ;; (class)
           "audio.simulink.WavetableSynthesizer" t ;; (class)
           "audio.sofa.datatype.FIR" t ;; (class)
           "audio.sofa.datatype.FIR.SamplingRateUnits" 'property
           "audio.sofa.datatype.FIRE" t ;; (class)
           "audio.sofa.datatype.FIRE.SamplingRateUnits" 'property
           "audio.sofa.datatype.SecondOrderSection" t ;; (class)
           "audio.sofa.datatype.SecondOrderSection.SamplingRateUnits" 'property
           "audio.sofa.datatype.TF" t ;; (class)
           "audio.sofa.datatype.TFE" t ;; (class)
           "audio.sofa.FreeFieldDirectivityTF" t ;; (class)
           "audio.sofa.FreeFieldDirectivityTF.DataType" 'property
           "audio.sofa.FreeFieldDirectivityTF.SOFAConventions" 'property
           "audio.sofa.FreeFieldHRIR" t ;; (class)
           "audio.sofa.FreeFieldHRIR.DataType" 'property
           "audio.sofa.FreeFieldHRIR.SamplingRateUnits" 'property
           "audio.sofa.FreeFieldHRIR.SOFAConventions" 'property
           "audio.sofa.FreeFieldHRTF" t ;; (class)
           "audio.sofa.FreeFieldHRTF.DataType" 'property
           "audio.sofa.FreeFieldHRTF.SOFAConventions" 'property
           "audio.sofa.GeneralFIR" t ;; (class)
           "audio.sofa.GeneralFIR.DataType" 'property
           "audio.sofa.GeneralFIR.SamplingRateUnits" 'property
           "audio.sofa.GeneralFIR.SOFAConventions" 'property
           "audio.sofa.GeneralFIRE" t ;; (class)
           "audio.sofa.GeneralFIRE.DataType" 'property
           "audio.sofa.GeneralFIRE.SamplingRateUnits" 'property
           "audio.sofa.GeneralFIRE.SOFAConventions" 'property
           "audio.sofa.GeneralSOS" t ;; (class)
           "audio.sofa.GeneralSOS.DataType" 'property
           "audio.sofa.GeneralSOS.SamplingRateUnits" 'property
           "audio.sofa.GeneralSOS.SOFAConventions" 'property
           "audio.sofa.GeneralTF" t ;; (class)
           "audio.sofa.GeneralTF.DataType" 'property
           "audio.sofa.GeneralTF.SOFAConventions" 'property
           "audio.sofa.GeneralTFE" t ;; (class)
           "audio.sofa.GeneralTFE.DataType" 'property
           "audio.sofa.GeneralTFE.SOFAConventions" 'property
           "audio.sofa.SimpleFreeFieldHRIR" t ;; (class)
           "audio.sofa.SimpleFreeFieldHRIR.DataType" 'property
           "audio.sofa.SimpleFreeFieldHRIR.SamplingRateUnits" 'property
           "audio.sofa.SimpleFreeFieldHRIR.SOFAConventions" 'property
           "audio.sofa.SimpleFreeFieldHRSOS" t ;; (class)
           "audio.sofa.SimpleFreeFieldHRSOS.DataType" 'property
           "audio.sofa.SimpleFreeFieldHRSOS.SamplingRateUnits" 'property
           "audio.sofa.SimpleFreeFieldHRSOS.SOFAConventions" 'property
           "audio.sofa.SimpleFreeFieldHRTF" t ;; (class)
           "audio.sofa.SimpleFreeFieldHRTF.DataType" 'property
           "audio.sofa.SimpleFreeFieldHRTF.SOFAConventions" 'property
           "audio.sofa.SimpleHeadphoneIR" t ;; (class)
           "audio.sofa.SimpleHeadphoneIR.DataType" 'property
           "audio.sofa.SimpleHeadphoneIR.RoomType" 'property
           "audio.sofa.SimpleHeadphoneIR.SamplingRateUnits" 'property
           "audio.sofa.SimpleHeadphoneIR.SOFAConventions" 'property
           "audio.sofa.SingleRoomMIMOSRIR" t ;; (class)
           "audio.sofa.SingleRoomMIMOSRIR.DataType" 'property
           "audio.sofa.SingleRoomMIMOSRIR.RoomTemperatureUnits" 'property
           "audio.sofa.SingleRoomMIMOSRIR.RoomVolumeUnits" 'property
           "audio.sofa.SingleRoomMIMOSRIR.SamplingRateUnits" 'property
           "audio.sofa.SingleRoomMIMOSRIR.SOFAConventions" 'property
           "audio.sofa.SingleRoomSRIR" t ;; (class)
           "audio.sofa.SingleRoomSRIR.DataType" 'property
           "audio.sofa.SingleRoomSRIR.RoomTemperatureUnits" 'property
           "audio.sofa.SingleRoomSRIR.RoomVolumeUnits" 'property
           "audio.sofa.SingleRoomSRIR.SamplingRateUnits" 'property
           "audio.sofa.SingleRoomSRIR.SOFAConventions" 'property
           "audio.ui.control.Meter" t ;; (class)
           "audio.ui.control.Meter.loadobj" t ;; (method)
           "audio.ui.scope.OctaveSpectrumVisualizer" t ;; (class)
           "audio_links" t ;; (mFile)
           "audioai" t ;; (slxFile)
           "audioblkAudioDeviceIO" t ;; (mFile)
           "audioblkauditory" t ;; (mFile)
           "audioblkclassifysound" t ;; (mFile)
           "audioblkcompression" t ;; (mFile)
           "audioblkcrepe" t ;; (mFile)
           "audioblkcrossover" t ;; (mFile)
           "audioblkEvalParameter" t ;; (mFile)
           "audioblkgraphicEQ" t ;; (mFile)
           "audioblkmfcc" t ;; (mFile)
           "audioblkmidisrc" t ;; (mFile)
           "audioblkmultibandEQ" t ;; (mFile)
           "audioblkoctave" t ;; (mFile)
           "audioblkopenl3" t ;; (mFile)
           "audioblkopenl3preprocess" t ;; (mFile)
           "audioblkparametriceqfilter" t ;; (mFile)
           "audioblkreverberator" t ;; (mFile)
           "audioblkshelving" t ;; (mFile)
           "audioblkweighting" t ;; (mFile)
           "audioBrokenLinksMapping" t ;; (mFile)
           "audioClassificationCustomLoopExperimentTemplate" t ;; (mFile)
           "audioClassificationExperimentTemplate" t ;; (mFile)
           "audioCleanUserData" t ;; (mFile)
           "audioCrossoverTransform" t ;; (mFile)
           "audioDataAugmenter" t ;; (mFile) Augment audio data
           "audioDatastore" t ;; (mFile) Datastore for collection of audio files
           "audioDatastore.DefaultOutputFormat" 'property
           "audioDatastore.SupportedOutputFormats" 'property
           "audioDelta" t ;; (mFile) Compute delta features
           "audioDeviceIOTransform" t ;; (mFile)
           "audioDeviceReader" t ;; (pFile) Record from sound card
           "audioDeviceWriter" t ;; (pFile) Play to sound card
           "audiodevinfo" t ;; (mFile) Information about audio device
           "audiodevreset" t ;; (mFile) Refresh list of available audio devices
           "audiodynamicrange" t ;; (slxFile)
           "audioeffects" t ;; (slxFile)
           "audioEnvelope" t ;; (mFile) Compute envelope of an audio file
           "audioexample.AGC" t ;; (class)
           "audioexample.ambisonics.ambiGenerateDecoderPlugin" t ;; (function)
           "audioexample.ambisonics.ambiGenerateEncoderPlugin" t ;; (function)
           "audioexample.AudioLoopTimer" t ;; (class)
           "audioexample.Chorus" t ;; (class)
           "audioexample.DampedParameter" t ;; (class)
           "audioexample.DampedParameter.loadobj" t ;; (method)
           "audioexample.DampedParameter.Tolerance" 'property
           "audioexample.DelayFilter" t ;; (class)
           "audioexample.DOADisplay" t ;; (class)
           "audioexample.Echo" t ;; (class)
           "audioexample.Flanger" t ;; (class)
           "audioexample.FreeverbReverberator" t ;; (class)
           "audioexample.FullWaveIntegrator" t ;; (class)
           "audioexample.getExampleID" t ;; (function)
           "audioexample.LFOFilterControlEnum" t ;; (class)
           "audioexample.LFOFilterControlEnum.addClassNameToEnumNames" t ;; (method)
           "audioexample.LFOFilterControlEnum.drawn" 'enumeration
           "audioexample.LFOFilterControlEnum.none" 'enumeration
           "audioexample.LFOFilterControlEnum.sawtooth" 'enumeration
           "audioexample.LFOFilterControlEnum.sine" 'enumeration
           "audioexample.LFOFilterControlEnum.square" 'enumeration
           "audioexample.LFOFilterDraw" t ;; (function)
           "audioexample.OnsetDetectionEnum" t ;; (class)
           "audioexample.OnsetDetectionEnum.addClassNameToEnumNames" t ;; (method)
           "audioexample.OnsetDetectionEnum.EnergyFlux" 'enumeration
           "audioexample.OnsetDetectionEnum.SpectralFlux" 'enumeration
           "audioexample.OnsetDetectionEnum.TimeEnvelope" 'enumeration
           "audioexample.PairArrayPreprocessor" t ;; (class)
           "audioexample.PitchDetectionEnum" t ;; (class)
           "audioexample.PitchDetectionEnum.Autocorrelation" 'enumeration
           "audioexample.PitchDetectionEnum.Both" 'enumeration
           "audioexample.PitchDetectionEnum.Spectral" 'enumeration
           "audioexample.Stack" t ;; (class)
           "audioexample.Stack.MaxCapacity" 'property
           "audioexample.StrobeFillEnum" t ;; (class)
           "audioexample.StrobeFillEnum.SawtoothModulation" 'enumeration
           "audioexample.StrobeFillEnum.Silence" 'enumeration
           "audioexample.StrobeFillEnum.SineModulation" 'enumeration
           "audioexample.WindowEnum" t ;; (class)
           "audioexample.WindowEnum.addClassNameToEnumNames" t ;; (method)
           "audioexample.WindowEnum.Blackman" 'enumeration
           "audioexample.WindowEnum.Hamming" 'enumeration
           "audioexample.WindowEnum.Hann" 'enumeration
           "audioexample.WindowEnum.Rectangle" 'enumeration
           "audioexample.WindowEnum.Triangle" 'enumeration
           "audioFeatureExtractor" t ;; (mFile) Streamline audio feature extraction
           "audioFeatureExtractor.loadobj" t ;; (method)
           "audiofeatures" t ;; (slxFile)
           "audiofilters" t ;; (slxFile)
           "audioinfo" t ;; (mFile) Information about audio file
           "audiointerface.audioDeviceReader" t ;; (class)
           "audiointerface.audioDeviceWriter" t ;; (class)
           "audioLabeler" t ;; (mFile) (Removed) Define and visualize ground-truth labels
           "audioLevelMeter" t ;; (mFile) Measure digital audio peak level
           "audiolib" t ;; (mFile)
           "audioliblist" t ;; (mFile)
           "audiolibv1" t ;; (slxFile)
           "audiomaskedcaps" t ;; (pFile)
           "audiomeasurements" t ;; (slxFile)
           "audioobslib" t ;; (slxFile)
           "audioOscillator" t ;; (mFile) Generate sine, square, and sawtooth waveforms
           "audioplayer" t ;; (mFile) Object for playing audio
           "audioPlayerRecorder" t ;; (pFile) Simultaneously play and record using an audio device
           "audioPlugin" t ;; (pFile) Base class for audio plugins
           "audioPluginBlockHelper" t ;; (mFile)
           "audioPluginConfig" t ;; (pFile) Specify coder configuration of audio plugin
           "audiopluginexample.AmbiDecoderPlugin" t ;; (class)
           "audiopluginexample.AmbiDecoderPlugin.loadobj" t ;; (method)
           "audiopluginexample.AmbiDecoderPlugin.PluginInterface" 'property
           "audiopluginexample.AmbiEncoderPlugin" t ;; (class)
           "audiopluginexample.AmbiEncoderPlugin.loadobj" t ;; (method)
           "audiopluginexample.AmbiEncoderPlugin.PluginInterface" 'property
           "audiopluginexample.AmbisonicBinauralizer" t ;; (class)
           "audiopluginexample.AmbisonicBinauralizer.loadobj" t ;; (method)
           "audiopluginexample.AmbisonicBinauralizer.PluginInterface" 'property
           "audiopluginexample.BandpassIIRFilter" t ;; (class)
           "audiopluginexample.BandpassIIRFilter.loadobj" t ;; (method)
           "audiopluginexample.BandpassIIRFilter.PluginInterface" 'property
           "audiopluginexample.BassEnhancer" t ;; (class)
           "audiopluginexample.BassEnhancer.loadobj" t ;; (method)
           "audiopluginexample.BeatDetector" t ;; (class)
           "audiopluginexample.BeatDetector.loadobj" t ;; (method)
           "audiopluginexample.BeatDetector.PluginInterface" 'property
           "audiopluginexample.Chorus" t ;; (class)
           "audiopluginexample.Chorus.loadobj" t ;; (method)
           "audiopluginexample.Chorus.PluginInterface" 'property
           "audiopluginexample.Denoiser" t ;; (class)
           "audiopluginexample.Denoiser.loadobj" t ;; (method)
           "audiopluginexample.Denoiser.PluginConfig" 'property
           "audiopluginexample.Denoiser.PluginInterface" 'property
           "audiopluginexample.Echo" t ;; (class)
           "audiopluginexample.Echo.loadobj" t ;; (method)
           "audiopluginexample.Echo.PluginInterface" 'property
           "audiopluginexample.FastConvolver" t ;; (class)
           "audiopluginexample.FastConvolver.loadobj" t ;; (method)
           "audiopluginexample.Flanger" t ;; (class)
           "audiopluginexample.Flanger.loadobj" t ;; (method)
           "audiopluginexample.Flanger.PluginInterface" 'property
           "audiopluginexample.HighpassIIRFilter" t ;; (class)
           "audiopluginexample.HighpassIIRFilter.loadobj" t ;; (method)
           "audiopluginexample.HighpassIIRFilter.PluginInterface" 'property
           "audiopluginexample.LFOFilter" t ;; (class)
           "audiopluginexample.LFOFilter.loadobj" t ;; (method)
           "audiopluginexample.LFOFilter.PluginInterface" 'property
           "audiopluginexample.LowpassIIRFilter" t ;; (class)
           "audiopluginexample.LowpassIIRFilter.loadobj" t ;; (method)
           "audiopluginexample.LowpassIIRFilter.PluginInterface" 'property
           "audiopluginexample.MultiNotchFilter" t ;; (class)
           "audiopluginexample.MultiNotchFilter.loadobj" t ;; (method)
           "audiopluginexample.MultiNotchFilter.PluginInterface" 'property
           "audiopluginexample.ParametricEqualizerWithUDP" t ;; (class)
           "audiopluginexample.Phaser" t ;; (class)
           "audiopluginexample.Phaser.loadobj" t ;; (method)
           "audiopluginexample.Phaser.PluginInterface" 'property
           "audiopluginexample.PitchShifter" t ;; (class)
           "audiopluginexample.PitchShifter.loadobj" t ;; (method)
           "audiopluginexample.private.AnalysisAndSynthesisBuffer" t ;; (class)
           "audiopluginexample.private.AnalysisAndSynthesisBuffer.loadobj" t ;; (method)
           "audiopluginexample.private.MeterUI" t ;; (class)
           "audiopluginexample.private.mwatlogo" t ;; (function)
           "audiopluginexample.private.OnsetDetector" t ;; (class)
           "audiopluginexample.private.OnsetDetector.loadobj" t ;; (method)
           "audiopluginexample.private.OnsetDetector.PluginInterface" 'property
           "audiopluginexample.private.SecondOrderIIRFilter" t ;; (class)
           "audiopluginexample.private.SecondOrderIIRFilter.loadobj" t ;; (method)
           "audiopluginexample.private.SynthesisBuffer" t ;; (class)
           "audiopluginexample.ShelvingEqualizer" t ;; (class)
           "audiopluginexample.SpectralSubtractor" t ;; (class)
           "audiopluginexample.SpectralSubtractor.loadobj" t ;; (method)
           "audiopluginexample.SpectralSubtractor.PluginInterface" 'property
           "audiopluginexample.SpeechPitchDetector" t ;; (class)
           "audiopluginexample.SpeechPitchDetector.loadobj" t ;; (method)
           "audiopluginexample.SpeechPitchDetector.PluginInterface" 'property
           "audiopluginexample.Strobe" t ;; (class)
           "audiopluginexample.Strobe.loadobj" t ;; (method)
           "audiopluginexample.Strobe.PluginInterface" 'property
           "audiopluginexample.UDPSender" t ;; (class)
           "audiopluginexample.UDPSender.loadobj" t ;; (method)
           "audiopluginexample.UDPSender.PluginInterface" 'property
           "audiopluginexample.VarSlopeBandpassFilter" t ;; (class)
           "audiopluginexample.VarSlopeBandpassFilter.PluginInterface" 'property
           "audiopluginexample.VolumeController" t ;; (class)
           "audiopluginexample.VolumeController.loadobj" t ;; (method)
           "audiopluginexample.VolumeController.PluginInterface" 'property
           "audioPluginGridLayout" t ;; (mFile) Specify layout for audio plugin UI
           "audioPluginInterface" t ;; (mFile) Specify audio plugin interface
           "audioPluginParameter" t ;; (mFile) Specify audio plugin parameters
           "audioPluginSource" t ;; (pFile) Base class for audio source plugins
           "audioPretrainedNetwork" t ;; (mFile) Pretrained audio neural networks
           "audioread" t ;; (mFile) Read audio file
           "audiorecorder" t ;; (mFile) Object for recording audio
           "audioReplaceNewParamWithEmpty" t ;; (mFile)
           "audioresample" t ;; (mFile) Sample-rate conversion of audio signals
           "audiosinks" t ;; (slxFile)
           "audiosources" t ;; (slxFile)
           "audiostreamer" t ;; (mFile) Create and manage audio streams for playing and recording
           "audiostreamer.getAudioDevices" t ;; (method)
           "audiostreamer.getDrivers" t ;; (method)
           "audiostreamer.getPlayerNames" t ;; (method)
           "audiostreamer.getRecorderNames" t ;; (method)
           "audioTestBench" t ;; (mFile) Debug, test, and tune audio plugins
           "audioTimeScaler" t ;; (mFile) Apply time scaling to streaming audio
           "audiouniquename" t ;; (mFile)
           "audioUpdateModel" t ;; (pFile)
           "audiouserdefined" t ;; (slxFile)
           "audioutils" t ;; (slxFile)
           "audiovideo.FileFormatInfo" t ;; (class)
           "audiovideo.writer.profile.Archival" t ;; (class)
           "audiovideo.writer.profile.Archival.FileExtensions" 'property
           "audiovideo.writer.profile.GrayscaleAVI" t ;; (class)
           "audiovideo.writer.profile.GrayscaleAVI.FileExtensions" 'property
           "audiovideo.writer.profile.IndexedAVI" t ;; (class)
           "audiovideo.writer.profile.IndexedAVI.FileExtensions" 'property
           "audiovideo.writer.profile.MJ2000" t ;; (class)
           "audiovideo.writer.profile.MJ2000.FileExtensions" 'property
           "audiovideo.writer.profile.MotionJpegAVI" t ;; (class)
           "audiovideo.writer.profile.MotionJpegAVI.FileExtensions" 'property
           "audiovideo.writer.profile.MPEG4" t ;; (class)
           "audiovideo.writer.profile.MPEG4.FileExtensions" 'property
           "audiovideo.writer.profile.UncompressedAVI" t ;; (class)
           "audiovideo.writer.profile.UncompressedAVI.FileExtensions" 'property
           "audiovideo.writer.properties.GrayscaleAviVideoProperties" t ;; (class)
           "audiovideo.writer.properties.IndexedAviVideoProperties" t ;; (class)
           "audiovideo.writer.properties.MJ2000VideoProperties" t ;; (class)
           "audiovideo.writer.properties.MJ2000VideoProperties.loadobj" t ;; (method)
           "audiovideo.writer.properties.MotionJpegVideoProperties" t ;; (class)
           "audiovideo.writer.properties.MPEG4VideoProperties" t ;; (class)
           "audiovideo.writer.properties.VideoProperties" t ;; (class)
           "audioViewer" t ;; (mFile) View and play audio signals
           "audiowrite" t ;; (mFile) Write audio file
           "augact" t ;; (mFile)
           "augd" t ;; (mFile)
           "augknt" t ;; (mFile) Augment knot sequence
           "augLagFun" t ;; (mFile)
           "augment" t ;; (mFile) Augment audio data
           "augmentedImageDatastore" t ;; (mFile) Transform batches to augment image data
           "augss" t ;; (mFile)
           "augstate" t ;; (mFile) Append state vector to output vector
           "augtf" t ;; (mFile)
           "auto_defaultlibrary" t ;; (mFile)
           "auto_private" t ;; (mFile)
           "autoblkAddHelpButton" t ;; (mFile)
           "autoblkAddPowerAnalysisButton" t ;; (mFile)
           "autoblkCIDynamometerStart" t ;; (mFile)
           "autoblkConVehShftOptStart" t ;; (mFile)
           "autoblkConVehStart" t ;; (mFile)
           "autoblkEvChargingStart" t ;; (mFile)
           "autoblkEvStart" t ;; (mFile)
           "autoblkFcEvTruckStart" t ;; (mFile)
           "autoblkHevIpsStart" t ;; (mFile)
           "autoblkHevP0Start" t ;; (mFile)
           "autoblkHevP1Start" t ;; (mFile)
           "autoblkHevP2Start" t ;; (mFile)
           "autoblkHevP3Start" t ;; (mFile)
           "autoblkHevP4Start" t ;; (mFile)
           "autoblkHevStart" t ;; (mFile)
           "autoblkMotDynamometerStart" t ;; (mFile)
           "autoblkOptimizeShiftScheduleForBestFuel" t ;; (pFile)
           "autoblkrefCommonExampleStart" t ;; (mFile)
           "autoblks.pwr.PlantInfo" t ;; (class)
           "autoblks.pwr.Signal" t ;; (class)
           "autoblks_create_block_xml_resource" t ;; (pFile)
           "autoblks_cvtdynamics" t ;; (pFile)
           "autoblks_cvtparam" t ;; (pFile)
           "autoblks_cvtratiosat" t ;; (pFile)
           "autoblks_cvtvariatorset" t ;; (pFile)
           "autoblks_FwdTbl" t ;; (pFile)
           "autoblksBlkSetupTask" t ;; (mFile)
           "autoblksBlockNameToSourceLibraryMap" t ;; (pFile)
           "autoblksCageSetupProject" t ;; (mFile)
           "autoblksCalApp" t ;; (mFile)
           "autoblksCalBlkGroupTask" t ;; (mFile)
           "autoblksCalBlkParamHandler" t ;; (mFile)
           "autoblksCalSimulinkBlkMbcTask" t ;; (mFile)
           "autoblkscheckparams" t ;; (pFile)
           "autoblkschecksimstopped" t ;; (pFile)
           "autoblksciengresize" t ;; (pFile)
           "autoblksclfuelcontrol" t ;; (pFile)
           "autoblksenableparameters" t ;; (pFile)
           "autoblksenabletext" t ;; (pFile)
           "autoblksEngFlwBlkClass" t ;; (pFile)
           "autoblksEngFlwPortClass" t ;; (pFile)
           "autoblksEngFlwSystemClass" t ;; (pFile)
           "autoblksFullTemplateName" t ;; (mFile)
           "autoblksGasMixture" t ;; (pFile)
           "autoblksGearNumType" t ;; (pFile)
           "autoblksgetblkportnames" t ;; (pFile)
           "autoblksgetblockconn" t ;; (pFile)
           "autoblksgetmaskparms" t ;; (pFile)
           "autoblksgetparam" t ;; (pFile)
           "autoblksgetportinfo" t ;; (pFile)
           "autoblksgetportlabels" t ;; (pFile)
           "autoblkshelp" t ;; (mFile)
           "autoblkSIDynamometerStart" t ;; (mFile)
           "autoblkSIH2DynamometerStart" t ;; (mFile)
           "autoblksImportDataFile" t ;; (mFile)
           "autoblksLsbTxFn" t ;; (pFile)
           "autoblksMAFilter" t ;; (pFile)
           "autoblksMbcApplyCalTask" t ;; (mFile)
           "autoblksMbcFitSurfMdlTask" t ;; (mFile)
           "autoblksMbcGenCalTask" t ;; (mFile)
           "autoblksMbcImportTask" t ;; (mFile)
           "autoblksMbcLicCheck" t ;; (mFile)
           "autoblksMbcSetupDataset" t ;; (mFile)
           "autoblksMbcSetupProject" t ;; (mFile)
           "autoblksMbcSetupTestplan" t ;; (mFile)
           "autoblksNewMbcFileName" t ;; (mFile)
           "autoblksreconnectblock" t ;; (pFile)
           "autoblksreferenceFullGenRefAppConfigFileName" t ;; (mFile)
           "autoblksreplaceblock" t ;; (pFile)
           "autoblkssetmaskparams" t ;; (pFile)
           "autoblkssetparam" t ;; (pFile)
           "autoblksSGFilter" t ;; (pFile)
           "autoblksSGFilterSingle" t ;; (pFile)
           "autoblkssharedFullMbcTemplateName" t ;; (mFile)
           "autoblkssharedFullPwrAnalysisScriptName" t ;; (mFile)
           "autoblkssidleval" t ;; (pFile)
           "autoblkssidlfit" t ;; (pFile)
           "autoblkssiengcal" t ;; (pFile)
           "autoblkssiengresize" t ;; (pFile)
           "autoblkssmoothstep" t ;; (pFile)
           "autoblkstabulatedefficiencydata" t ;; (pFile)
           "autoblkstabulatedlosssdata" t ;; (pFile)
           "autoblksTaskTree" t ;; (mFile)
           "autoblksTaskTree.ScaleFactor" 'property
           "autoblksunitconv" t ;; (pFile)
           "autoblksystimer" t ;; (pFile)
           "autoblkTogglePlantModel" t ;; (mFile)
           "autoblkVirtualFCEvStart" t ;; (mFile)
           "autoblkVirtualMotoStart" t ;; (mFile)
           "autoblkVirtualTruckStart" t ;; (mFile)
           "autoblkVirtualVehicleBuilder" t ;; (mFile)
           "autoblkVirtualVehicleStart" t ;; (mFile)
           "autoblkVVCMotoSimscapeModelNames" t ;; (mFile)
           "autoblkVVCSimscapeModelNames" t ;; (mFile)
           "autoblkVVCSimulinkModelNames" t ;; (mFile)
           "autoblkVVCTruckSimulinkModelNames" t ;; (mFile)
           "autocadExportOptions" t ;; (mFile)
           "autocorr" t ;; (mFile) Sample autocorrelation
           "autod" t ;; (mFile)
           "autoDataContainer" t ;; (pFile)
           "autoDetectBridgesOptions" t ;; (mFile)
           "Autoencoder" t ;; (mFile) Autoencoder class
           "autofixexp" t ;; (mFile) Automatically change scaling of fixed-point data types
           "autofixexp_autoScale" t ;; (mFile)
           "autofixwordlength" t ;; (mFile)
           "autoicon" t ;; (mFile)
           "autolib" t ;; (slxFile)
           "autolibalternator" t ;; (slxFile)
           "autolibalternatorcommon" t ;; (slxFile)
           "autolibbatterycommon" t ;; (slxFile)
           "autolibbldc" t ;; (slxFile)
           "autolibboost" t ;; (slxFile)
           "autolibboostcommon" t ;; (slxFile)
           "autolibcoreeng" t ;; (slxFile)
           "autolibcoreengcommon" t ;; (slxFile)
           "autolibcoupling" t ;; (slxFile)
           "autolibcycles" t ;; (slxFile)
           "autolibdatasheetbattery" t ;; (slxFile)
           "autolibdcdc" t ;; (slxFile)
           "autolibdcdccommon" t ;; (slxFile)
           "autolibdiff" t ;; (slxFile)
           "autolibdrivetrain" t ;; (slxFile)
           "autolibdrivetraincommon" t ;; (slxFile)
           "autolibdrivetraincomps" t ;; (slxFile)
           "autolibemachines" t ;; (slxFile)
           "autolibengctrlr" t ;; (slxFile)
           "autolibengctrlrcommon" t ;; (slxFile)
           "autolibenginesystems" t ;; (slxFile)
           "autolibevcharging" t ;; (slxFile)
           "autolibfluxpmsm" t ;; (slxFile)
           "autolibfluxpmsmcommon" t ;; (slxFile)
           "autolibfundflw" t ;; (slxFile)
           "autolibfundflwcommon" t ;; (slxFile)
           "autolibhdllut" t ;; (slxFile)
           "autolibhevctrlr" t ;; (slxFile)
           "autolibhevctrlrcommon" t ;; (slxFile)
           "autolibim" t ;; (slxFile)
           "autolibimcommon" t ;; (slxFile)
           "autolibinverter" t ;; (slxFile)
           "autolibmappedmotor" t ;; (slxFile)
           "autolibmappedmotorcommon" t ;; (slxFile)
           "autolibmotorctrlr" t ;; (slxFile)
           "autoliboperator" t ;; (slxFile)
           "autolibpmsmcommon" t ;; (slxFile)
           "autolibpmsmexterior" t ;; (slxFile)
           "autolibpmsmexterior_block_forwardv1" t ;; (pFile)
           "autolibpmsminterior" t ;; (slxFile)
           "autolibpmsminterior_block_forwardv1" t ;; (pFile)
           "autolibpowerinfoutils" t ;; (slxFile)
           "autolibpowerinfoutilscommon" t ;; (slxFile)
           "autolibptactuators" t ;; (slxFile)
           "autolibptsensors" t ;; (slxFile)
           "autolibrcnetworksystem" t ;; (slxFile)
           "autolibrcobserver" t ;; (slxFile)
           "autolibscenario" t ;; (slxFile)
           "autolibshared" t ;; (slxFile)
           "autolibsharedabs" t ;; (slxFile)
           "autolibsharedcommon" t ;; (slxFile)
           "autolibsharedcontrolcommon" t ;; (slxFile)
           "autolibsharedcoreengin" t ;; (slxFile)
           "autolibsharedcoupling" t ;; (slxFile)
           "autolibsharedcouplingcommon" t ;; (slxFile)
           "autolibshareddiff" t ;; (slxFile)
           "autolibshareddrivetraincommon" t ;; (slxFile)
           "autolibsharedengctrlcommon" t ;; (slxFile)
           "autolibsharedesc" t ;; (slxFile)
           "autolibsharedmappedengines" t ;; (slxFile)
           "autolibsharedmappedenginescommon" t ;; (slxFile)
           "autolibsharedtcs" t ;; (slxFile)
           "autolibsharedtransfixedgear" t ;; (slxFile)
           "autolibsimscapeutils" t ;; (slxFile)
           "autolibstarter" t ;; (slxFile)
           "autolibstartercommon" t ;; (slxFile)
           "autolibtrans" t ;; (slxFile)
           "autolibtransamt" t ;; (slxFile)
           "autolibtranscontrols" t ;; (slxFile)
           "autolibtranscontrolscommon" t ;; (slxFile)
           "autolibtranscvt" t ;; (slxFile)
           "autolibtranscvtcommon" t ;; (slxFile)
           "autolibtransdct" t ;; (slxFile)
           "autolibtransfixedgear" t ;; (slxFile)
           "autolibtrqconv" t ;; (slxFile)
           "autolibutils" t ;; (slxFile)
           "autolibvehdyn" t ;; (slxFile)
           "autolibvehdynlong" t ;; (slxFile)
           "autolibwheelslong" t ;; (slxFile)
           "autoline" t ;; (pFile)
           "automesh" t ;; (mFile)
           "automlclutchwet" t ;; (pFile)
           "automldcycltrck" t ;; (pFile)
           "automldiffas" t ;; (pFile)
           "automldiffast" t ;; (pFile)
           "automldiffls" t ;; (pFile)
           "automldiffopen" t ;; (pFile)
           "automldiv0protect" t ;; (pFile)
           "automlidealgearfwd" t ;; (pFile)
           "automlMotoChain" t ;; (pFile)
           "automlMotoFChain" t ;; (pFile)
           "automlMotoLngadf" t ;; (pFile)
           "automlMotoLngax" t ;; (pFile)
           "automlMotoLngaz" t ;; (pFile)
           "automlMotoLngBodyGeomInplane" t ;; (pFile)
           "automlMotoLngCMInfo" t ;; (pFile)
           "automlMotoLngCPFr" t ;; (pFile)
           "automlMotoLngXamu" t ;; (pFile)
           "automlMotoLngXamur" t ;; (pFile)
           "automlMotoLngYamu" t ;; (pFile)
           "automlMotoLngYamur" t ;; (pFile)
           "automlMotoVelocities" t ;; (pFile)
           "automlplanetarygearfwd" t ;; (pFile)
           "automlplanetarygearinv" t ;; (pFile)
           "automlravigearfwd" t ;; (pFile)
           "automlsatfunc" t ;; (pFile)
           "automltireFzmagic" t ;; (pFile)
           "automltirekappa" t ;; (pFile)
           "automltirelong" t ;; (pFile)
           "automltirelongFx" t ;; (pFile)
           "automltirelongFxMapped" t ;; (pFile)
           "automltirelongMy" t ;; (pFile)
           "automltirelongMyISO" t ;; (pFile)
           "automltirelongMyMapped" t ;; (pFile)
           "automltirelongMySAE" t ;; (pFile)
           "automltiremagic" t ;; (pFile)
           "automltirepurelongFx" t ;; (pFile)
           "automlvdynStrgParaArm" t ;; (pFile)
           "automlvehb2i" t ;; (pFile)
           "automlvehdynbicycle" t ;; (pFile)
           "automlvehdynbicycle3axles" t ;; (pFile)
           "automlvehdynbicycletrailer1axle" t ;; (pFile)
           "automlvehdynbicycletrailer2axles" t ;; (pFile)
           "automlvehdynbicycletrailer3axles" t ;; (pFile)
           "automlvehdyndualtrack" t ;; (pFile)
           "automlvehdyndualtrack3axles" t ;; (pFile)
           "automlvehdynftiresat" t ;; (pFile)
           "automlvehdynlatdriverplant" t ;; (pFile)
           "automlvehdynlatdriversetup" t ;; (pFile)
           "automlvehdynlatlongdriverplant" t ;; (pFile)
           "automlvehdynlatlongdriversetup" t ;; (pFile)
           "automlvehdynlongdriverplant" t ;; (pFile)
           "automlvehdynlongdriversetup" t ;; (pFile)
           "automlvehdyntrailerdualtrack1axle" t ;; (pFile)
           "automlvehdyntrailerdualtrack2axles" t ;; (pFile)
           "automlvehdyntrailerdualtrack3axles" t ;; (pFile)
           "autooptimizeLUTforHDL2D" t ;; (pFile)
           "autopopulate" t ;; (mex)
           "AutoPopulationSize" t ;; (pFile)
           "autosar.api.create" t ;; (function)
           "autosar.api.delete" t ;; (function)
           "autosar.api.export" t ;; (function)
           "autosar.api.getAUTOSARProperties" t ;; (class)
           "autosar.api.getSimulinkMapping" t ;; (class)
           "autosar.api.syncModel" t ;; (function)
           "autosar.api.validateModel" t ;; (function)
           "autosar.ara.AraCom_defineErrorEnumTypes" t ;; (function)
           "autosar.ara.initialize" t ;; (function)
           "autosar.arch.createModel" t ;; (function)
           "autosar.arch.loadModel" t ;; (function)
           "autosar.arch.ParameterComponent" t ;; (class)
           "autosar.arch.ParameterPort" t ;; (class)
           "autosar.block_services.PortOptimizationBlocker" t ;; (class)
           "autosar.block_services.PortOptimizationBlocker.preventPortOptimizationFor" t ;; (method)
           "autosar.blocks.adaptiveplatform.EventBlock" t ;; (class)
           "autosar.blocks.adaptiveplatform.EventBlock.isEventReceiveBlock" t ;; (method)
           "autosar.blocks.adaptiveplatform.EventBlock.isEventSendBlock" t ;; (method)
           "autosar.blocks.adaptiveplatform.EventBlock.isEventSendOrReceiveBlock" t ;; (method)
           "autosar.blocks.adaptiveplatform.EventBlock.updateBlock" t ;; (method)
           "autosar.blocks.InternalTriggerBlock" t ;; (class)
           "autosar.blocks.InternalTriggerBlock.findInternalTriggerBlocks" t ;; (method)
           "autosar.blocks.InternalTriggerBlock.isInternalTriggerBlock" t ;; (method)
           "autosar.blocks.InternalTriggerBlock.isInternalTriggerBlockMapped" t ;; (method)
           "autosar.blocks.InternalTriggerBlock.isServerCallPointMappedToInternalTriggerPoint" t ;; (method)
           "autosar.blocks.InternalTriggerBlock.mapInternalTriggerBlock" t ;; (method)
           "autosar.blocks.InternalTriggerBlock.syncMapping" t ;; (method)
           "autosar.blocks.InternalTriggerBlock.updateBlock" t ;; (method)
           "autosar.blocks.unlinkAndUnmaskBlock" t ;; (function)
           "autosar.bsw.BasicSoftwareCaller" t ;; (class)
           "autosar.bsw.BasicSoftwareCaller.boolean_spec" t ;; (method)
           "autosar.bsw.BasicSoftwareCaller.copyCallback" t ;; (method)
           "autosar.bsw.BasicSoftwareCaller.createBlock" t ;; (method)
           "autosar.bsw.BasicSoftwareCaller.dataTypeCallback" t ;; (method)
           "autosar.bsw.BasicSoftwareCaller.DemPath" 'property
           "autosar.bsw.BasicSoftwareCaller.deserializeCaller" t ;; (method)
           "autosar.bsw.BasicSoftwareCaller.FiMPath" 'property
           "autosar.bsw.BasicSoftwareCaller.find" t ;; (method)
           "autosar.bsw.BasicSoftwareCaller.forceSchemaSync" t ;; (method)
           "autosar.bsw.BasicSoftwareCaller.getConceptualOperationFromBlock" t ;; (method)
           "autosar.bsw.BasicSoftwareCaller.getConcreteOperationFromBlock" t ;; (method)
           "autosar.bsw.BasicSoftwareCaller.getServiceImpl" t ;; (method)
           "autosar.bsw.BasicSoftwareCaller.isBSWCallerBlock" t ;; (method)
           "autosar.bsw.BasicSoftwareCaller.NvMPath" 'property
           "autosar.bsw.BasicSoftwareCaller.operationCallback" t ;; (method)
           "autosar.bsw.BasicSoftwareCaller.RefLibName" 'property
           "autosar.bsw.BasicSoftwareCaller.registerIcons" t ;; (method)
           "autosar.bsw.BasicSoftwareCaller.reportOperationNotInSchema" t ;; (method)
           "autosar.bsw.BasicSoftwareCaller.set_param" t ;; (method)
           "autosar.bsw.BasicSoftwareCaller.syncBlock" t ;; (method)
           "autosar.bsw.BasicSoftwareCaller.syncBswCallerToSchema" t ;; (method)
           "autosar.bsw.BasicSoftwareCaller.syncModel" t ;; (method)
           "autosar.bsw.BasicSoftwareCaller.uint16_spec" t ;; (method)
           "autosar.bsw.BasicSoftwareCaller.uint32_spec" t ;; (method)
           "autosar.bsw.BasicSoftwareCaller.uint8_spec" t ;; (method)
           "autosar.bsw.BasicSoftwareCaller.updateBlock" t ;; (method)
           "autosar.bsw.BlockCallbacks" t ;; (class)
           "autosar.bsw.BlockCallbacks.assertGetDTCDimensions" t ;; (method)
           "autosar.bsw.BlockCallbacks.deleteBswOperation" t ;; (method)
           "autosar.bsw.BlockCallbacks.demFaultInjectMaskInit" t ;; (method)
           "autosar.bsw.BlockCallbacks.demFaultOverrideMaskInit" t ;; (method)
           "autosar.bsw.BlockCallbacks.demStatusInjectMaskInit" t ;; (method)
           "autosar.bsw.BlockCallbacks.demStatusOverrideLoadBlock" t ;; (method)
           "autosar.bsw.BlockCallbacks.demStatusOverrideMaskInit" t ;; (method)
           "autosar.bsw.BlockCallbacks.propagateParam" t ;; (method)
           "autosar.bsw.BlockCallbacks.setConditionsCallback" t ;; (method)
           "autosar.bsw.Compatibility" t ;; (class)
           "autosar.bsw.Compatibility.cacheFunctionPrototype" t ;; (method)
           "autosar.bsw.Compatibility.hasCachedPrototype" t ;; (method)
           "autosar.bsw.ConcreteOperationSelector" t ;; (class)
           "autosar.bsw.ConcreteOperationSelector.selectConcreteOperation" t ;; (method)
           "autosar.bsw.data.ApplicationFunction" t ;; (class)
           "autosar.bsw.data.ApplicationFunction.sort" t ;; (method)
           "autosar.bsw.data.ConceptualOperation" t ;; (class)
           "autosar.bsw.data.ConceptualOperation.canConfigurePortAccess" t ;; (method)
           "autosar.bsw.data.ConceptualOperation.Catalog" 'property
           "autosar.bsw.data.ConceptualOperation.CLEAR_PRESTORED_FREEZE_FRAME" 'enumeration
           "autosar.bsw.data.ConceptualOperation.ERASE_NVBLOCK" 'enumeration
           "autosar.bsw.data.ConceptualOperation.findByName" t ;; (method)
           "autosar.bsw.data.ConceptualOperation.GET_CYCLE_QUALIFIED" 'enumeration
           "autosar.bsw.data.ConceptualOperation.GET_DATA_INDEX" 'enumeration
           "autosar.bsw.data.ConceptualOperation.GET_DTC_OF_EVENT" 'enumeration
           "autosar.bsw.data.ConceptualOperation.GET_ERROR_STATUS" 'enumeration
           "autosar.bsw.data.ConceptualOperation.GET_EVENT_EXTENDED_DATA_RECORD" 'enumeration
           "autosar.bsw.data.ConceptualOperation.GET_EVENT_FAILED" 'enumeration
           "autosar.bsw.data.ConceptualOperation.GET_EVENT_FREEZE_FRAME_DATA" 'enumeration
           "autosar.bsw.data.ConceptualOperation.GET_EVENT_STATUS" 'enumeration
           "autosar.bsw.data.ConceptualOperation.GET_EVENT_TESTED" 'enumeration
           "autosar.bsw.data.ConceptualOperation.GET_FAULT_DETECTION_COUNTER" 'enumeration
           "autosar.bsw.data.ConceptualOperation.GET_FUNCTION_PERMISSION" 'enumeration
           "autosar.bsw.data.ConceptualOperation.GET_IUMPR_DENOMINATOR_CONDITION" 'enumeration
           "autosar.bsw.data.ConceptualOperation.GET_MONITOR_STATUS" 'enumeration
           "autosar.bsw.data.ConceptualOperation.GET_OPERATION_CYCLE_STATE" 'enumeration
           "autosar.bsw.data.ConceptualOperation.INVALIDATE_NVBLOCK" 'enumeration
           "autosar.bsw.data.ConceptualOperation.NULL" 'enumeration
           "autosar.bsw.data.ConceptualOperation.PRESTORE_FREEZE_FRAME" 'enumeration
           "autosar.bsw.data.ConceptualOperation.READ_BLOCK" 'enumeration
           "autosar.bsw.data.ConceptualOperation.REPORT_IUMPR_DENOMINATOR_LOCK" 'enumeration
           "autosar.bsw.data.ConceptualOperation.REPORT_IUMPR_DENOMINATOR_RELEASE" 'enumeration
           "autosar.bsw.data.ConceptualOperation.REPORT_IUMPR_FAULT_DETECT" 'enumeration
           "autosar.bsw.data.ConceptualOperation.RESET_EVENT_STATUS" 'enumeration
           "autosar.bsw.data.ConceptualOperation.RESET_MONITOR_STATUS" 'enumeration
           "autosar.bsw.data.ConceptualOperation.RESTART_OPERATION_CYCLE" 'enumeration
           "autosar.bsw.data.ConceptualOperation.RESTORE_BLOCK_DEFAULTS" 'enumeration
           "autosar.bsw.data.ConceptualOperation.SET_BLOCK_PROTECTION" 'enumeration
           "autosar.bsw.data.ConceptualOperation.SET_CYCLE_QUALIFIED" 'enumeration
           "autosar.bsw.data.ConceptualOperation.SET_DATA_INDEX" 'enumeration
           "autosar.bsw.data.ConceptualOperation.SET_ENABLE_CONDITION" 'enumeration
           "autosar.bsw.data.ConceptualOperation.SET_EVENT_AVAILABLE" 'enumeration
           "autosar.bsw.data.ConceptualOperation.SET_EVENT_DISABLED" 'enumeration
           "autosar.bsw.data.ConceptualOperation.SET_EVENT_STATUS" 'enumeration
           "autosar.bsw.data.ConceptualOperation.SET_FUNCTION_AVAILABLE" 'enumeration
           "autosar.bsw.data.ConceptualOperation.SET_IUMPR_DENOMINATOR_CONDITION" 'enumeration
           "autosar.bsw.data.ConceptualOperation.SET_OPERATION_CYCLE_STATE" 'enumeration
           "autosar.bsw.data.ConceptualOperation.SET_RAM_BLOCK_STATUS" 'enumeration
           "autosar.bsw.data.ConceptualOperation.SET_STORAGE_CONDITION" 'enumeration
           "autosar.bsw.data.ConceptualOperation.WRITE_BLOCK" 'enumeration
           "autosar.bsw.data.ConcreteOperation" t ;; (class)
           "autosar.bsw.data.ConcreteOperation.findCompatibleM3iInterface" t ;; (method)
           "autosar.bsw.data.ConcreteOperation.getNearestToSchema" t ;; (method)
           "autosar.bsw.data.ConcreteOperation.getSupportedSchemas" t ;; (method)
           "autosar.bsw.data.ConcreteOperation.sharesInterface" t ;; (method)
           "autosar.bsw.Dem_defineIntEnumTypes" t ;; (function)
           "autosar.bsw.DemDiagnosticInfo" t ;; (class)
           "autosar.bsw.DemDiagnosticInfo.configureForConcreteOperation" t ;; (method)
           "autosar.bsw.DemDiagnosticInfo.exportToPrevious" t ;; (method)
           "autosar.bsw.DemDiagnosticInfo.getBlockIconType" t ;; (method)
           "autosar.bsw.DemDiagnosticInfo.getDefaultClientPortName" t ;; (method)
           "autosar.bsw.DemDiagnosticInfo.getDescription" t ;; (method)
           "autosar.bsw.DemDiagnosticInfo.getHelp" t ;; (method)
           "autosar.bsw.DemDiagnosticInfo.getLibraryBlk" t ;; (method)
           "autosar.bsw.DemDiagnosticInfo.getSchemaMissingOperationMsg" t ;; (method)
           "autosar.bsw.DemDiagnosticInfo.getServiceImpls" t ;; (method)
           "autosar.bsw.DemDiagnosticInfo.getType" t ;; (method)
           "autosar.bsw.DemDiagnosticInfo.syncCallerToSchema" t ;; (method)
           "autosar.bsw.DemDiagnosticInfo.updateOperationTypeOptions" t ;; (method)
           "autosar.bsw.DemDiagnosticInfo.upgradeCaller" t ;; (method)
           "autosar.bsw.DemDiagnosticMonitor" t ;; (class)
           "autosar.bsw.DemDiagnosticMonitor.configureForConcreteOperation" t ;; (method)
           "autosar.bsw.DemDiagnosticMonitor.exportToPrevious" t ;; (method)
           "autosar.bsw.DemDiagnosticMonitor.getBlockIconType" t ;; (method)
           "autosar.bsw.DemDiagnosticMonitor.getDefaultClientPortName" t ;; (method)
           "autosar.bsw.DemDiagnosticMonitor.getDescription" t ;; (method)
           "autosar.bsw.DemDiagnosticMonitor.getHelp" t ;; (method)
           "autosar.bsw.DemDiagnosticMonitor.getLibraryBlk" t ;; (method)
           "autosar.bsw.DemDiagnosticMonitor.getSchemaMissingOperationMsg" t ;; (method)
           "autosar.bsw.DemDiagnosticMonitor.getServiceImpls" t ;; (method)
           "autosar.bsw.DemDiagnosticMonitor.getType" t ;; (method)
           "autosar.bsw.DemDiagnosticMonitor.syncCallerToSchema" t ;; (method)
           "autosar.bsw.DemDiagnosticMonitor.updateOperationTypeOptions" t ;; (method)
           "autosar.bsw.DemEnableCondition" t ;; (class)
           "autosar.bsw.DemEnableCondition.configureForConcreteOperation" t ;; (method)
           "autosar.bsw.DemEnableCondition.exportToPrevious" t ;; (method)
           "autosar.bsw.DemEnableCondition.getBlockIconType" t ;; (method)
           "autosar.bsw.DemEnableCondition.getDefaultClientPortName" t ;; (method)
           "autosar.bsw.DemEnableCondition.getDescription" t ;; (method)
           "autosar.bsw.DemEnableCondition.getHelp" t ;; (method)
           "autosar.bsw.DemEnableCondition.getLibraryBlk" t ;; (method)
           "autosar.bsw.DemEnableCondition.getSchemaMissingOperationMsg" t ;; (method)
           "autosar.bsw.DemEnableCondition.getServiceImpls" t ;; (method)
           "autosar.bsw.DemEnableCondition.getType" t ;; (method)
           "autosar.bsw.DemEnableCondition.syncCallerToSchema" t ;; (method)
           "autosar.bsw.DemEnableCondition.updateOperationTypeOptions" t ;; (method)
           "autosar.bsw.DemEventAvailable" t ;; (class)
           "autosar.bsw.DemEventAvailable.configureForConcreteOperation" t ;; (method)
           "autosar.bsw.DemEventAvailable.exportToPrevious" t ;; (method)
           "autosar.bsw.DemEventAvailable.getBlockIconType" t ;; (method)
           "autosar.bsw.DemEventAvailable.getDefaultClientPortName" t ;; (method)
           "autosar.bsw.DemEventAvailable.getDescription" t ;; (method)
           "autosar.bsw.DemEventAvailable.getHelp" t ;; (method)
           "autosar.bsw.DemEventAvailable.getLibraryBlk" t ;; (method)
           "autosar.bsw.DemEventAvailable.getSchemaMissingOperationMsg" t ;; (method)
           "autosar.bsw.DemEventAvailable.getServiceImpls" t ;; (method)
           "autosar.bsw.DemEventAvailable.getType" t ;; (method)
           "autosar.bsw.DemEventAvailable.syncCallerToSchema" t ;; (method)
           "autosar.bsw.DemEventAvailable.updateOperationTypeOptions" t ;; (method)
           "autosar.bsw.DemIUMPRDenominator" t ;; (class)
           "autosar.bsw.DemIUMPRDenominator.configureForConcreteOperation" t ;; (method)
           "autosar.bsw.DemIUMPRDenominator.exportToPrevious" t ;; (method)
           "autosar.bsw.DemIUMPRDenominator.getBlockIconType" t ;; (method)
           "autosar.bsw.DemIUMPRDenominator.getDefaultClientPortName" t ;; (method)
           "autosar.bsw.DemIUMPRDenominator.getDescription" t ;; (method)
           "autosar.bsw.DemIUMPRDenominator.getHelp" t ;; (method)
           "autosar.bsw.DemIUMPRDenominator.getLibraryBlk" t ;; (method)
           "autosar.bsw.DemIUMPRDenominator.getSchemaMissingOperationMsg" t ;; (method)
           "autosar.bsw.DemIUMPRDenominator.getServiceImpls" t ;; (method)
           "autosar.bsw.DemIUMPRDenominator.getType" t ;; (method)
           "autosar.bsw.DemIUMPRDenominator.syncCallerToSchema" t ;; (method)
           "autosar.bsw.DemIUMPRDenominator.updateOperationTypeOptions" t ;; (method)
           "autosar.bsw.DemIUMPRDenominatorCondition" t ;; (class)
           "autosar.bsw.DemIUMPRDenominatorCondition.configureForConcreteOperation" t ;; (method)
           "autosar.bsw.DemIUMPRDenominatorCondition.exportToPrevious" t ;; (method)
           "autosar.bsw.DemIUMPRDenominatorCondition.getBlockIconType" t ;; (method)
           "autosar.bsw.DemIUMPRDenominatorCondition.getDefaultClientPortName" t ;; (method)
           "autosar.bsw.DemIUMPRDenominatorCondition.getDescription" t ;; (method)
           "autosar.bsw.DemIUMPRDenominatorCondition.getHelp" t ;; (method)
           "autosar.bsw.DemIUMPRDenominatorCondition.getLibraryBlk" t ;; (method)
           "autosar.bsw.DemIUMPRDenominatorCondition.getSchemaMissingOperationMsg" t ;; (method)
           "autosar.bsw.DemIUMPRDenominatorCondition.getServiceImpls" t ;; (method)
           "autosar.bsw.DemIUMPRDenominatorCondition.getType" t ;; (method)
           "autosar.bsw.DemIUMPRDenominatorCondition.syncCallerToSchema" t ;; (method)
           "autosar.bsw.DemIUMPRDenominatorCondition.updateOperationTypeOptions" t ;; (method)
           "autosar.bsw.DemIUMPRNumerator" t ;; (class)
           "autosar.bsw.DemIUMPRNumerator.configureForConcreteOperation" t ;; (method)
           "autosar.bsw.DemIUMPRNumerator.exportToPrevious" t ;; (method)
           "autosar.bsw.DemIUMPRNumerator.getBlockIconType" t ;; (method)
           "autosar.bsw.DemIUMPRNumerator.getDefaultClientPortName" t ;; (method)
           "autosar.bsw.DemIUMPRNumerator.getDescription" t ;; (method)
           "autosar.bsw.DemIUMPRNumerator.getHelp" t ;; (method)
           "autosar.bsw.DemIUMPRNumerator.getLibraryBlk" t ;; (method)
           "autosar.bsw.DemIUMPRNumerator.getSchemaMissingOperationMsg" t ;; (method)
           "autosar.bsw.DemIUMPRNumerator.getServiceImpls" t ;; (method)
           "autosar.bsw.DemIUMPRNumerator.getType" t ;; (method)
           "autosar.bsw.DemIUMPRNumerator.syncCallerToSchema" t ;; (method)
           "autosar.bsw.DemIUMPRNumerator.updateOperationTypeOptions" t ;; (method)
           "autosar.bsw.DemOperationCycle" t ;; (class)
           "autosar.bsw.DemOperationCycle.configureForConcreteOperation" t ;; (method)
           "autosar.bsw.DemOperationCycle.exportToPrevious" t ;; (method)
           "autosar.bsw.DemOperationCycle.getBlockIconType" t ;; (method)
           "autosar.bsw.DemOperationCycle.getDefaultClientPortName" t ;; (method)
           "autosar.bsw.DemOperationCycle.getDescription" t ;; (method)
           "autosar.bsw.DemOperationCycle.getHelp" t ;; (method)
           "autosar.bsw.DemOperationCycle.getLibraryBlk" t ;; (method)
           "autosar.bsw.DemOperationCycle.getSchemaMissingOperationMsg" t ;; (method)
           "autosar.bsw.DemOperationCycle.getServiceImpls" t ;; (method)
           "autosar.bsw.DemOperationCycle.getType" t ;; (method)
           "autosar.bsw.DemOperationCycle.syncCallerToSchema" t ;; (method)
           "autosar.bsw.DemOperationCycle.updateOperationTypeOptions" t ;; (method)
           "autosar.bsw.DemPfcCycleQualified" t ;; (class)
           "autosar.bsw.DemPfcCycleQualified.configureForConcreteOperation" t ;; (method)
           "autosar.bsw.DemPfcCycleQualified.exportToPrevious" t ;; (method)
           "autosar.bsw.DemPfcCycleQualified.getBlockIconType" t ;; (method)
           "autosar.bsw.DemPfcCycleQualified.getDefaultClientPortName" t ;; (method)
           "autosar.bsw.DemPfcCycleQualified.getDescription" t ;; (method)
           "autosar.bsw.DemPfcCycleQualified.getHelp" t ;; (method)
           "autosar.bsw.DemPfcCycleQualified.getLibraryBlk" t ;; (method)
           "autosar.bsw.DemPfcCycleQualified.getSchemaMissingOperationMsg" t ;; (method)
           "autosar.bsw.DemPfcCycleQualified.getServiceImpls" t ;; (method)
           "autosar.bsw.DemPfcCycleQualified.getType" t ;; (method)
           "autosar.bsw.DemPfcCycleQualified.syncCallerToSchema" t ;; (method)
           "autosar.bsw.DemPfcCycleQualified.updateOperationTypeOptions" t ;; (method)
           "autosar.bsw.DemStatusInject" t ;; (class)
           "autosar.bsw.DemStatusInject.configureInjectBlockInternal" t ;; (method)
           "autosar.bsw.DemStatusInject.setConditions" t ;; (method)
           "autosar.bsw.DemStatusInject.updatePriority" t ;; (method)
           "autosar.bsw.DemStatusInject.updateTriggerMode" t ;; (method)
           "autosar.bsw.DemStatusOverride" t ;; (class)
           "autosar.bsw.DemStatusOverride.configureOverrideBlockInternal" t ;; (method)
           "autosar.bsw.DemStatusOverride.UDSBits" 'property
           "autosar.bsw.DemStatusOverride.updateOverrideBlockMask" t ;; (method)
           "autosar.bsw.DemStatusValidator" t ;; (class)
           "autosar.bsw.DemStatusValidator.findDemStatusBlocks" t ;; (method)
           "autosar.bsw.DemStatusValidator.getEventIds" t ;; (method)
           "autosar.bsw.DemStatusValidator.verifyNoDupeAndInject" t ;; (method)
           "autosar.bsw.DemStatusValidator.verifyNoSharedEventIds" t ;; (method)
           "autosar.bsw.DemStatusValidator.verifyServiceComponentPresent" t ;; (method)
           "autosar.bsw.DemStatusValidator.verifyValidEventIds" t ;; (method)
           "autosar.bsw.DemStorageCondition" t ;; (class)
           "autosar.bsw.DemStorageCondition.configureForConcreteOperation" t ;; (method)
           "autosar.bsw.DemStorageCondition.exportToPrevious" t ;; (method)
           "autosar.bsw.DemStorageCondition.getBlockIconType" t ;; (method)
           "autosar.bsw.DemStorageCondition.getDefaultClientPortName" t ;; (method)
           "autosar.bsw.DemStorageCondition.getDescription" t ;; (method)
           "autosar.bsw.DemStorageCondition.getHelp" t ;; (method)
           "autosar.bsw.DemStorageCondition.getLibraryBlk" t ;; (method)
           "autosar.bsw.DemStorageCondition.getSchemaMissingOperationMsg" t ;; (method)
           "autosar.bsw.DemStorageCondition.getServiceImpls" t ;; (method)
           "autosar.bsw.DemStorageCondition.getType" t ;; (method)
           "autosar.bsw.DemStorageCondition.syncCallerToSchema" t ;; (method)
           "autosar.bsw.DemStorageCondition.updateOperationTypeOptions" t ;; (method)
           "autosar.bsw.DiagnosticServiceComponent" t ;; (class)
           "autosar.bsw.DiagnosticServiceComponent.addBlocks" t ;; (method)
           "autosar.bsw.DiagnosticServiceComponent.addMaskObjectParameters" t ;; (method)
           "autosar.bsw.DiagnosticServiceComponent.getBlockIconType" t ;; (method)
           "autosar.bsw.DiagnosticServiceComponent.getDescription" t ;; (method)
           "autosar.bsw.DiagnosticServiceComponent.getDisplay" t ;; (method)
           "autosar.bsw.DiagnosticServiceComponent.getHelp" t ;; (method)
           "autosar.bsw.DiagnosticServiceComponent.getKeywords" t ;; (method)
           "autosar.bsw.DiagnosticServiceComponent.getType" t ;; (method)
           "autosar.bsw.FiM_ControlFunctionAvailable" t ;; (class)
           "autosar.bsw.FiM_ControlFunctionAvailable.configureForConcreteOperation" t ;; (method)
           "autosar.bsw.FiM_ControlFunctionAvailable.exportToPrevious" t ;; (method)
           "autosar.bsw.FiM_ControlFunctionAvailable.getBlockIconType" t ;; (method)
           "autosar.bsw.FiM_ControlFunctionAvailable.getDefaultClientPortName" t ;; (method)
           "autosar.bsw.FiM_ControlFunctionAvailable.getDescription" t ;; (method)
           "autosar.bsw.FiM_ControlFunctionAvailable.getHelp" t ;; (method)
           "autosar.bsw.FiM_ControlFunctionAvailable.getLibraryBlk" t ;; (method)
           "autosar.bsw.FiM_ControlFunctionAvailable.getSchemaMissingOperationMsg" t ;; (method)
           "autosar.bsw.FiM_ControlFunctionAvailable.getServiceImpls" t ;; (method)
           "autosar.bsw.FiM_ControlFunctionAvailable.getType" t ;; (method)
           "autosar.bsw.FiM_ControlFunctionAvailable.syncCallerToSchema" t ;; (method)
           "autosar.bsw.FiM_ControlFunctionAvailable.updateOperationTypeOptions" t ;; (method)
           "autosar.bsw.FiM_FunctionInhibition" t ;; (class)
           "autosar.bsw.FiM_FunctionInhibition.configureForConcreteOperation" t ;; (method)
           "autosar.bsw.FiM_FunctionInhibition.exportToPrevious" t ;; (method)
           "autosar.bsw.FiM_FunctionInhibition.getBlockIconType" t ;; (method)
           "autosar.bsw.FiM_FunctionInhibition.getDefaultClientPortName" t ;; (method)
           "autosar.bsw.FiM_FunctionInhibition.getDescription" t ;; (method)
           "autosar.bsw.FiM_FunctionInhibition.getHelp" t ;; (method)
           "autosar.bsw.FiM_FunctionInhibition.getLibraryBlk" t ;; (method)
           "autosar.bsw.FiM_FunctionInhibition.getSchemaMissingOperationMsg" t ;; (method)
           "autosar.bsw.FiM_FunctionInhibition.getServiceImpls" t ;; (method)
           "autosar.bsw.FiM_FunctionInhibition.getType" t ;; (method)
           "autosar.bsw.FiM_FunctionInhibition.syncCallerToSchema" t ;; (method)
           "autosar.bsw.FiM_FunctionInhibition.updateOperationTypeOptions" t ;; (method)
           "autosar.bsw.generateTriggerOnEventStatusCallers" t ;; (function)
           "autosar.bsw.getDataScope" t ;; (function)
           "autosar.bsw.NvM_defineIntEnumTypes" t ;; (function)
           "autosar.bsw.NvMAdmin" t ;; (class)
           "autosar.bsw.NvMAdmin.configureForConcreteOperation" t ;; (method)
           "autosar.bsw.NvMAdmin.exportToPrevious" t ;; (method)
           "autosar.bsw.NvMAdmin.getBlockIconType" t ;; (method)
           "autosar.bsw.NvMAdmin.getDefaultClientPortName" t ;; (method)
           "autosar.bsw.NvMAdmin.getDescription" t ;; (method)
           "autosar.bsw.NvMAdmin.getHelp" t ;; (method)
           "autosar.bsw.NvMAdmin.getLibraryBlk" t ;; (method)
           "autosar.bsw.NvMAdmin.getSchemaMissingOperationMsg" t ;; (method)
           "autosar.bsw.NvMAdmin.getServiceImpls" t ;; (method)
           "autosar.bsw.NvMAdmin.getType" t ;; (method)
           "autosar.bsw.NvMAdmin.syncCallerToSchema" t ;; (method)
           "autosar.bsw.NvMAdmin.updateOperationTypeOptions" t ;; (method)
           "autosar.bsw.NvMService" t ;; (class)
           "autosar.bsw.NvMService.configureForConcreteOperation" t ;; (method)
           "autosar.bsw.NvMService.exportToPrevious" t ;; (method)
           "autosar.bsw.NvMService.getBlockIconType" t ;; (method)
           "autosar.bsw.NvMService.getDefaultClientPortName" t ;; (method)
           "autosar.bsw.NvMService.getDescription" t ;; (method)
           "autosar.bsw.NvMService.getHelp" t ;; (method)
           "autosar.bsw.NvMService.getLibraryBlk" t ;; (method)
           "autosar.bsw.NvMService.getSchemaMissingOperationMsg" t ;; (method)
           "autosar.bsw.NvMService.getServiceImpls" t ;; (method)
           "autosar.bsw.NvMService.getType" t ;; (method)
           "autosar.bsw.NvMService.syncCallerToSchema" t ;; (method)
           "autosar.bsw.NvMService.updateOperationTypeOptions" t ;; (method)
           "autosar.bsw.NVRAMServiceComponent" t ;; (class)
           "autosar.bsw.NVRAMServiceComponent.addBlocks" t ;; (method)
           "autosar.bsw.NVRAMServiceComponent.addMaskObjectParameters" t ;; (method)
           "autosar.bsw.NVRAMServiceComponent.getBlockIconType" t ;; (method)
           "autosar.bsw.NVRAMServiceComponent.getDescription" t ;; (method)
           "autosar.bsw.NVRAMServiceComponent.getDisplay" t ;; (method)
           "autosar.bsw.NVRAMServiceComponent.getHelp" t ;; (method)
           "autosar.bsw.NVRAMServiceComponent.getKeywords" t ;; (method)
           "autosar.bsw.NVRAMServiceComponent.getType" t ;; (method)
           "autosar.bsw.rte.CallerDispatchRTEStrategy" t ;; (class)
           "autosar.bsw.rte.CallerDispatchRTEStrategy.getRTEStrategy" t ;; (method)
           "autosar.bsw.rte.CallerDispatchRTEStrategy.parseOperationAndPortNames" t ;; (method)
           "autosar.bsw.rte.CompFunctionTypeParser" t ;; (class)
           "autosar.bsw.rte.FaultInjector" t ;; (class)
           "autosar.bsw.rte.FaultInjector.findFaultBlkInFaultMdl" t ;; (method)
           "autosar.bsw.rte.FaultInjector.getFaultInjector" t ;; (method)
           "autosar.bsw.rte.FaultInjector.populateFault" t ;; (method)
           "autosar.bsw.rte.FreezeRte" t ;; (class)
           "autosar.bsw.rte.ManagedDatastoreRTEStrategy" t ;; (class)
           "autosar.bsw.rte.ManagedDatastoreRTEStrategy.getDefaultTypeStr" t ;; (method)
           "autosar.bsw.rte.ManagedDatastoreRTEStrategy.getRTEStrategy" t ;; (method)
           "autosar.bsw.rte.ManagedDatastoreRTEStrategy.NvramDsmControllerPath" 'property
           "autosar.bsw.rte.ManagedDatastoreRTEStrategy.parseOperationAndPortNames" t ;; (method)
           "autosar.bsw.rte.NullRTEStrategy" t ;; (class)
           "autosar.bsw.rte.NullRTEStrategy.getRTEStrategy" t ;; (method)
           "autosar.bsw.rte.NullRTEStrategy.parseOperationAndPortNames" t ;; (method)
           "autosar.bsw.rte.RTEStrategy" t ;; (class)
           "autosar.bsw.rte.RTEStrategy.getRTEStrategy" t ;; (method)
           "autosar.bsw.rte.RTEStrategy.parseOperationAndPortNames" t ;; (method)
           "autosar.bsw.schema.OperationCatalog" t ;; (class)
           "autosar.bsw.schema.OperationCatalog.generateOperationDefinitions" t ;; (method)
           "autosar.bsw.schema.SchemaVersionsEnum" t ;; (class)
           "autosar.bsw.schema.SchemaVersionsEnum.expand" t ;; (method)
           "autosar.bsw.schema.SchemaVersionsEnum.firstSupported" t ;; (method)
           "autosar.bsw.schema.SchemaVersionsEnum.Future" 'enumeration
           "autosar.bsw.schema.SchemaVersionsEnum.getAll" t ;; (method)
           "autosar.bsw.schema.SchemaVersionsEnum.getFromModel" t ;; (method)
           "autosar.bsw.schema.SchemaVersionsEnum.getFromString" t ;; (method)
           "autosar.bsw.schema.SchemaVersionsEnum.highest" t ;; (method)
           "autosar.bsw.schema.SchemaVersionsEnum.latestSupported" t ;; (method)
           "autosar.bsw.schema.SchemaVersionsEnum.lowest" t ;; (method)
           "autosar.bsw.schema.SchemaVersionsEnum.Schema_40" 'enumeration
           "autosar.bsw.schema.SchemaVersionsEnum.Schema_41" 'enumeration
           "autosar.bsw.schema.SchemaVersionsEnum.Schema_42" 'enumeration
           "autosar.bsw.schema.SchemaVersionsEnum.Schema_43" 'enumeration
           "autosar.bsw.schema.SchemaVersionsEnum.Schema_44" 'enumeration
           "autosar.bsw.schema.SchemaVersionsEnum.Schema_45" 'enumeration
           "autosar.bsw.schema.SchemaVersionsEnum.Schema_46" 'enumeration
           "autosar.bsw.schema.SchemaVersionsEnum.Schema_47" 'enumeration
           "autosar.bsw.schema.SchemaVersionsEnum.Schema_48" 'enumeration
           "autosar.bsw.schema.SchemaVersionsEnum.Schema_49" 'enumeration
           "autosar.bsw.ServiceComponent" t ;; (class)
           "autosar.bsw.ServiceComponent.containsBswOperation" t ;; (method)
           "autosar.bsw.ServiceComponent.createBlock" t ;; (method)
           "autosar.bsw.ServiceComponent.createPrototype" t ;; (method)
           "autosar.bsw.ServiceComponent.deleteRTELayer" t ;; (method)
           "autosar.bsw.ServiceComponent.DemServiceBlockMaskType" 'property
           "autosar.bsw.ServiceComponent.find" t ;; (method)
           "autosar.bsw.ServiceComponent.freezeRte" t ;; (method)
           "autosar.bsw.ServiceComponent.getBswCallerImplementation" t ;; (method)
           "autosar.bsw.ServiceComponent.getBswCompType" t ;; (method)
           "autosar.bsw.ServiceComponent.getServiceBlockForAppFcnName" t ;; (method)
           "autosar.bsw.ServiceComponent.isBswOperation" t ;; (method)
           "autosar.bsw.ServiceComponent.isBswServiceComponent" t ;; (method)
           "autosar.bsw.ServiceComponent.NvMServiceBlockMaskType" 'property
           "autosar.bsw.ServiceComponent.preCopyCallback" t ;; (method)
           "autosar.bsw.ServiceComponent.updateApplicationPorts" t ;; (method)
           "autosar.bsw.ServiceImplementation" t ;; (class)
           "autosar.bsw.ServiceImplementation.configureForConcreteOperation" t ;; (method)
           "autosar.bsw.ServiceImplementation.exportToPrevious" t ;; (method)
           "autosar.bsw.ServiceImplementation.getBlockIconType" t ;; (method)
           "autosar.bsw.ServiceImplementation.getDefaultClientPortName" t ;; (method)
           "autosar.bsw.ServiceImplementation.getDescription" t ;; (method)
           "autosar.bsw.ServiceImplementation.getHelp" t ;; (method)
           "autosar.bsw.ServiceImplementation.getLibraryBlk" t ;; (method)
           "autosar.bsw.ServiceImplementation.getSchemaMissingOperationMsg" t ;; (method)
           "autosar.bsw.ServiceImplementation.getServiceImpls" t ;; (method)
           "autosar.bsw.ServiceImplementation.getType" t ;; (method)
           "autosar.bsw.ServiceImplementation.syncCallerToSchema" t ;; (method)
           "autosar.bsw.ServiceImplementation.updateOperationTypeOptions" t ;; (method)
           "autosar.bsw.Std_defineIntEnumTypes" t ;; (function)
           "autosar.bsw.sync.CallerMappingInfo" t ;; (class)
           "autosar.bsw.sync.Synchronizer" t ;; (class)
           "autosar.bsw.sync.Synchronizer.syncModel" t ;; (method)
           "autosar.bsw.types.BswTypeCatalog" t ;; (class)
           "autosar.bsw.types.BswTypeCatalog.instance" t ;; (method)
           "autosar.bsw.types.EnumPrototype" t ;; (class)
           "autosar.bsw.types.EnumPrototype.create" t ;; (method)
           "autosar.bsw.types.IBswType" t ;; (class)
           "autosar.build.BuildHooksImpl" t ;; (class)
           "autosar.build.BuildHooksImpl.after_make" t ;; (method)
           "autosar.build.BuildHooksImpl.after_tlc" t ;; (method)
           "autosar.build.BuildHooksImpl.before_make" t ;; (method)
           "autosar.build.BuildHooksImpl.before_tlc" t ;; (method)
           "autosar.build.BuildHooksImpl.entry" t ;; (method)
           "autosar.build.BuildHooksImpl.error" t ;; (method)
           "autosar.build.BuildHooksImpl.exit" t ;; (method)
           "autosar.build.checkTopModelBuild" t ;; (function)
           "autosar.build.CRLHostLibraryHelper" t ;; (class)
           "autosar.build.PrototypeControl" t ;; (class)
           "autosar.build.PrototypeControl.addPrototypeControlInfo" t ;; (method)
           "autosar.build.PrototypeControl.clearPrototypeControlInfo" t ;; (method)
           "autosar.code.CodeReplacementHelper" t ;; (class)
           "autosar.code.CodeReplacementHelper.doTypeReplacement" t ;; (method)
           "autosar.code.CodeReplacementHelper.updateAraDataTypeHeaderPaths" t ;; (method)
           "autosar.code.HandCodedComponentImporter" t ;; (class)
           "autosar.code.ImportArgParser" t ;; (class)
           "autosar.code.Utils" t ;; (class)
           "autosar.code.Utils.shouldReplaceRTWTypesWithARTypes" t ;; (method)
           "autosar.composition.api.create" t ;; (function)
           "autosar.composition.arxml.exportComposition" t ;; (function)
           "autosar.composition.arxml.writeCompositionFile" t ;; (function)
           "autosar.composition.build.AssignPortInterfaces" t ;; (class)
           "autosar.composition.build.Builder" t ;; (class)
           "autosar.composition.build.GenerateASAP2File" t ;; (class)
           "autosar.composition.build.Packager" t ;; (class)
           "autosar.composition.build.Packager.findFilesWithExtension" t ;; (method)
           "autosar.composition.build.SharedElementsCopier" t ;; (class)
           "autosar.composition.build.SharedElementsCopier.copySharedElements" t ;; (method)
           "autosar.composition.build.SharedElementsCopier.copySharedElementsFromInterfaceDict" t ;; (method)
           "autosar.composition.build.SharedElementsCopier.copySharedElementsOwnedBySrcModelOnly" t ;; (method)
           "autosar.composition.build.SharedElementsCopier.findSharedPackagedElements" t ;; (method)
           "autosar.composition.build.VariantArchBuilder" t ;; (class)
           "autosar.composition.mm2sl.ArchASILBuilder" t ;; (class)
           "autosar.composition.mm2sl.ArchCompositionBuilder" t ;; (class)
           "autosar.composition.mm2sl.ArchCompositionBuilder.determinePlatformKind" t ;; (method)
           "autosar.composition.mm2sl.ArchConnector" t ;; (class)
           "autosar.composition.mm2sl.ArchConnector.getHiliteLineCommand" t ;; (method)
           "autosar.composition.mm2sl.ArchConnector.getLineLabel" t ;; (method)
           "autosar.composition.mm2sl.ComponentAndCompositionBuilder" t ;; (class)
           "autosar.composition.mm2sl.ComponentAndCompositionBuilder.splitAllUnder" t ;; (method)
           "autosar.composition.mm2sl.ComponentAndCompositionFinder" t ;; (class)
           "autosar.composition.mm2sl.DataDictionaryMerger" t ;; (class)
           "autosar.composition.mm2sl.M3IModelSplitter" t ;; (class)
           "autosar.composition.mm2sl.ModelBuilder" t ;; (class)
           "autosar.composition.mm2sl.ModelBuilder.isComponentImportedAsSimulinkModel" t ;; (method)
           "autosar.composition.mm2sl.parallel.ParallelSwComponentBuilder" t ;; (class)
           "autosar.composition.mm2sl.parallel.ParallelSwComponentBuilder.getBuilder" t ;; (method)
           "autosar.composition.mm2sl.parallel.ParallelSwComponentBuilder.modelLoadedOrExists" t ;; (method)
           "autosar.composition.mm2sl.parallel.ParallelSwComponentBuilder.resetCompuMethodExternalToolInfo" t ;; (method)
           "autosar.composition.mm2sl.parallel.ParallelTaskStatus" t ;; (class)
           "autosar.composition.mm2sl.private.ArgumentParser" t ;; (class)
           "autosar.composition.mm2sl.progresstracker.ImportOrUpdateProgressTracker" t ;; (class)
           "autosar.composition.mm2sl.progresstracker.ImportProgressTracker" t ;; (class)
           "autosar.composition.mm2sl.progresstracker.UpdateProgressTracker" t ;; (class)
           "autosar.composition.mm2sl.SLCompositionBuilder" t ;; (class)
           "autosar.composition.mm2sl.SLConnector" t ;; (class)
           "autosar.composition.mm2sl.SLConnector.getSrcAndDstComponentsAndPorts" t ;; (method)
           "autosar.composition.mm2sl.SLConnector.portRequiresWiredConnection" t ;; (method)
           "autosar.composition.mm2sl.SLModelBuilder" t ;; (class)
           "autosar.composition.mm2sl.SLModelBuilder.copyBreakpointsToCompositionModel" t ;; (method)
           "autosar.composition.mm2sl.SLModelBuilder.deleteUnconnectedCompositionPorts" t ;; (method)
           "autosar.composition.mm2sl.SLSignalLine" t ;; (class)
           "autosar.composition.mm2sl.SwComponentBuilder" t ;; (class)
           "autosar.composition.mm2sl.SwComponentBuilder.getBuilder" t ;; (method)
           "autosar.composition.mm2sl.SwComponentBuilder.modelLoadedOrExists" t ;; (method)
           "autosar.composition.mm2sl.SwComponentBuilder.resetCompuMethodExternalToolInfo" t ;; (method)
           "autosar.composition.mm2sl.TracibilityUtils" t ;; (class)
           "autosar.composition.mm2sl.TracibilityUtils.getHilitePortCommand" t ;; (method)
           "autosar.composition.pi.PropertyHandler" t ;; (class)
           "autosar.composition.pi.PropertyHandler.getPropertyValue" t ;; (method)
           "autosar.composition.pi.PropertyHandler.setPropertyValue" t ;; (method)
           "autosar.composition.pi.PropertyProvider" t ;; (class)
           "autosar.composition.pi.PropertyProvider.getAUTOSARPropertySpecs" t ;; (method)
           "autosar.composition.pi.PropertyProvider.getAUTOSARPropertyTagNames" t ;; (method)
           "autosar.composition.pi.PropertyProvider.getPropertyDisplayLabel" t ;; (method)
           "autosar.composition.pi.PropertyProvider.getPropertyEditor" t ;; (method)
           "autosar.composition.pi.PropertyProvider.getPropertyRenderMode" t ;; (method)
           "autosar.composition.pi.PropertyProvider.getPropertyValue" t ;; (method)
           "autosar.composition.pi.PropertyProvider.isPropertyEnabled" t ;; (method)
           "autosar.composition.pi.PropertyProvider.setPropertyValue" t ;; (method)
           "autosar.composition.report.ExportReport" t ;; (class)
           "autosar.composition.report.ExportReport.clearInstance" t ;; (method)
           "autosar.composition.report.ExportReport.closeDialog" t ;; (method)
           "autosar.composition.report.ExportReport.detectBuildFolder" t ;; (method)
           "autosar.composition.report.ExportReport.getBrowserDialog" t ;; (method)
           "autosar.composition.report.ExportReport.getBrowserDocument" t ;; (method)
           "autosar.composition.report.ExportReport.getCodeFileCategoryDisplayNames" t ;; (method)
           "autosar.composition.report.ExportReport.getCommentTag" t ;; (method)
           "autosar.composition.report.ExportReport.getHTMLFileName" t ;; (method)
           "autosar.composition.report.ExportReport.getMatlabCallHyperlink" t ;; (method)
           "autosar.composition.report.ExportReport.getReportInfoFromBuildDir" t ;; (method)
           "autosar.composition.report.ExportReport.getSInfo" t ;; (method)
           "autosar.composition.report.ExportReport.getSubsystemBuildFolder" t ;; (method)
           "autosar.composition.report.ExportReport.getURL" t ;; (method)
           "autosar.composition.report.ExportReport.instance" t ;; (method)
           "autosar.composition.report.ExportReport.loadMat" t ;; (method)
           "autosar.composition.report.ExportReport.newFileInfo" t ;; (method)
           "autosar.composition.report.ExportReport.newInstance" t ;; (method)
           "autosar.composition.report.ExportReport.openURL" t ;; (method)
           "autosar.composition.report.ExportReport.setInstance" t ;; (method)
           "autosar.composition.report.ExportReportSummary" t ;; (class)
           "autosar.composition.report.ExportReportSummary.createSimpleTable" t ;; (method)
           "autosar.composition.report.ExportReportSummary.createTable" t ;; (method)
           "autosar.composition.report.ExportReportSummary.genConfigCheckReportTable" t ;; (method)
           "autosar.composition.report.ExportReportSummary.getDefaultErrorHTML" t ;; (method)
           "autosar.composition.report.ExportReportSummary.getMatlabCallHyperlink" t ;; (method)
           "autosar.composition.report.ExportReportSummary.getRTWTableShrinkButton" t ;; (method)
           "autosar.composition.report.ReportBuilder" t ;; (class)
           "autosar.composition.sl2mm.ConnectorBuilder" t ;; (class)
           "autosar.composition.sl2mm.ConnectorBuilder.destroyM3IConnectors" t ;; (method)
           "autosar.composition.sl2mm.ConnectorBuilder.findCompositionSignalLinesFromSrcBlock" t ;; (method)
           "autosar.composition.sl2mm.ConnectorBuilder.findSLPortBlockFromPortNum" t ;; (method)
           "autosar.composition.sl2mm.ConnectorBuilder.getTerminusInfo" t ;; (method)
           "autosar.composition.sl2mm.ConnectorTypeEnum" t ;; (class)
           "autosar.composition.sl2mm.ConnectorTypeEnum.Assembly" 'enumeration
           "autosar.composition.sl2mm.ConnectorTypeEnum.Delegation" 'enumeration
           "autosar.composition.sl2mm.ConnectorTypeEnum.Unconnected" 'enumeration
           "autosar.composition.sl2mm.ModelBuilder" t ;; (class)
           "autosar.composition.sl2mm.ParameterConnectorBuilder" t ;; (class)
           "autosar.composition.sl2mm.private.AssemblyConnector" t ;; (class)
           "autosar.composition.sl2mm.private.AssemblyConnector.create" t ;; (method)
           "autosar.composition.sl2mm.private.AssemblyConnector.createEmpty" t ;; (method)
           "autosar.composition.sl2mm.private.ComponentPrototype" t ;; (class)
           "autosar.composition.sl2mm.private.DelegationConnector" t ;; (class)
           "autosar.composition.sl2mm.private.DelegationConnector.create" t ;; (method)
           "autosar.composition.sl2mm.private.DelegationConnector.createEmpty" t ;; (method)
           "autosar.composition.sl2mm.SLSignalLine" t ;; (class)
           "autosar.composition.sl2mm.SLSignalLine.from" t ;; (method)
           "autosar.composition.sl2mm.variant.VariantCompositionBuilder" t ;; (class)
           "autosar.composition.sl2mm.variant.VariantCompositionBuilder.expandConnectorToVariants" t ;; (method)
           "autosar.composition.studio.ActionStateGetter" t ;; (class)
           "autosar.composition.studio.ActionStateGetter.getStateForAction" t ;; (method)
           "autosar.composition.studio.ActionStateGetter.getValidSelectedBlocksForAction" t ;; (method)
           "autosar.composition.studio.AUTOSARComponentToImplConverter" t ;; (class)
           "autosar.composition.studio.AUTOSARComponentToImplConverter.createLocalDictionary" t ;; (method)
           "autosar.composition.studio.AUTOSARComponentToModelLinker" t ;; (class)
           "autosar.composition.studio.AUTOSARComponentToModelLinker.syncCompBlockWithImportedM3IComp" t ;; (method)
           "autosar.composition.studio.AUTOSARCompositionToAUTOSARArchitectureConverter" t ;; (class)
           "autosar.composition.studio.BEPInterfacePropagationUtils" t ;; (class)
           "autosar.composition.studio.BEPInterfacePropagationUtils.populateInterfaceInformationInModel" t ;; (method)
           "autosar.composition.studio.BEPInterfacePropagationUtils.propagateInterfacesFromConnections" t ;; (method)
           "autosar.composition.studio.CompBlockCreateModel" t ;; (class)
           "autosar.composition.studio.CompBlockCreateModel.getDefaultMdlName" t ;; (method)
           "autosar.composition.studio.CompBlockCreateModel.launchDialog" t ;; (method)
           "autosar.composition.studio.CompBlockReferenceModel" t ;; (class)
           "autosar.composition.studio.CompBlockReferenceModel.launchDialog" t ;; (method)
           "autosar.composition.studio.CompBlockReferenceModel.launchModelLinkingWizard" t ;; (method)
           "autosar.composition.studio.CompBlockReferenceModel.validateModel" t ;; (method)
           "autosar.composition.studio.CompBlockUtils" t ;; (class)
           "autosar.composition.studio.CompBlockUtils.getM3IComp" t ;; (method)
           "autosar.composition.studio.CompBlockUtils.getM3ICompTypeForSLComp" t ;; (method)
           "autosar.composition.studio.CompBlockUtils.setParam" t ;; (method)
           "autosar.composition.studio.CompImport" t ;; (class)
           "autosar.composition.studio.CompImport.importFromArxml" t ;; (method)
           "autosar.composition.studio.CompImport.updateFromArxml" t ;; (method)
           "autosar.composition.studio.CompositionFromSelectionCreator" t ;; (class)
           "autosar.composition.studio.CompositionFromSelectionCreator.canCreateFromSelection" t ;; (method)
           "autosar.composition.studio.CompositionFromSelectionCreator.createFromSelection" t ;; (method)
           "autosar.composition.studio.CreateAndLink" t ;; (class)
           "autosar.composition.studio.CreateAndLink.createModelForComp" t ;; (method)
           "autosar.composition.studio.CreateAndLink.exportComponentBlock" t ;; (method)
           "autosar.composition.studio.CreateAndLink.exportCompositionBlock" t ;; (method)
           "autosar.composition.studio.CreateAndLink.exportRootModel" t ;; (method)
           "autosar.composition.studio.CreateAndLink.importCompFromARXML" t ;; (method)
           "autosar.composition.studio.CreateAndLink.linkCompToModel" t ;; (method)
           "autosar.composition.studio.CreateAndLink.updateCompFromARXML" t ;; (method)
           "autosar.composition.studio.ExportDialog" t ;; (class)
           "autosar.composition.studio.ExportDialog.launchDialog" t ;; (method)
           "autosar.composition.studio.MetaModelSynchronizer" t ;; (class)
           "autosar.composition.studio.MetaModelSynchronizer.syncM3IComp" t ;; (method)
           "autosar.composition.studio.ModelLinkingFixer" t ;; (class)
           "autosar.composition.studio.ModelLinkingFixer.getFailureNames" t ;; (method)
           "autosar.composition.studio.ModelLinkingFixer.getWarningNames" t ;; (method)
           "autosar.composition.studio.ModelLinkingValidator" t ;; (class)
           "autosar.composition.studio.SimulinkListener" t ;; (class)
           "autosar.composition.studio.SimulinkListener.anyComponentPrototypesUsingCompType" t ;; (method)
           "autosar.composition.studio.SimulinkListener.blockAdded" t ;; (method)
           "autosar.composition.studio.SimulinkListener.blockCheckParamChange" t ;; (method)
           "autosar.composition.studio.SimulinkListener.blockParamChanged" t ;; (method)
           "autosar.composition.studio.SimulinkListener.blockRemoved" t ;; (method)
           "autosar.composition.studio.SimulinkListener.compositePortBlockRemoved" t ;; (method)
           "autosar.composition.studio.SimulinkListener.getOrAddComponent" t ;; (method)
           "autosar.composition.studio.SimulinkListener.modelParamChanged" t ;; (method)
           "autosar.composition.studio.SimulinkListener.registerM3IModelListener" t ;; (method)
           "autosar.composition.studio.SimulinkListener.validateBlockName" t ;; (method)
           "autosar.composition.studio.SimulinkListenerUtils" t ;; (class)
           "autosar.composition.studio.SimulinkListenerUtils.disableSimulinkListener" t ;; (method)
           "autosar.composition.Utils" t ;; (class)
           "autosar.composition.utils.ArchitecturePlatformKinds" t ;; (class)
           "autosar.composition.utils.ArchitecturePlatformKinds.Adaptive" 'enumeration
           "autosar.composition.utils.ArchitecturePlatformKinds.Classic" 'enumeration
           "autosar.composition.utils.ArchTypeHelper" t ;; (class)
           "autosar.composition.utils.ArchTypeHelper.getPlatform" t ;; (method)
           "autosar.composition.utils.ArchTypeHelper.getPlatformKindId" t ;; (method)
           "autosar.composition.utils.ArchTypeHelper.isAdaptivePlatform" t ;; (method)
           "autosar.composition.utils.ArchTypeHelper.isClassicPlatform" t ;; (method)
           "autosar.composition.utils.ArchTypeHelper.isModelMappedCompliantWithPlatform" t ;; (method)
           "autosar.composition.utils.ArchTypeHelper.setPlatformKind" t ;; (method)
           "autosar.composition.Utils.createDefaultCompositionMapping" t ;; (method)
           "autosar.composition.Utils.findAdapterBlocks" t ;; (method)
           "autosar.composition.Utils.findAdaptiveApplications" t ;; (method)
           "autosar.composition.Utils.findAtomicComponents" t ;; (method)
           "autosar.composition.Utils.findCompBlocks" t ;; (method)
           "autosar.composition.Utils.findComponentsMatchingMetaClass" t ;; (method)
           "autosar.composition.Utils.findCompositeInports" t ;; (method)
           "autosar.composition.Utils.findCompositeOutports" t ;; (method)
           "autosar.composition.Utils.findCompositionComponents" t ;; (method)
           "autosar.composition.Utils.findCompPrototypesInComposition" t ;; (method)
           "autosar.composition.Utils.findM3ICompositionParentForCompBlock" t ;; (method)
           "autosar.composition.Utils.findM3ICompPrototypeForCompBlock" t ;; (method)
           "autosar.composition.Utils.findM3ICompPrototypeWithName" t ;; (method)
           "autosar.composition.Utils.findM3ICompType" t ;; (method)
           "autosar.composition.Utils.findM3IObjectForCompositionElement" t ;; (method)
           "autosar.composition.Utils.findM3IObjectWithName" t ;; (method)
           "autosar.composition.Utils.findM3IPortForCompositePort" t ;; (method)
           "autosar.composition.Utils.findM3IPortForSignalPort" t ;; (method)
           "autosar.composition.Utils.findM3IPortWithName" t ;; (method)
           "autosar.composition.Utils.findM3iSwcImplementation" t ;; (method)
           "autosar.composition.Utils.findM3iSwcImplementationsForM3iComp" t ;; (method)
           "autosar.composition.Utils.findM3iSwcImplementationsForM3iComponent" t ;; (method)
           "autosar.composition.Utils.findSwComponents" t ;; (method)
           "autosar.composition.Utils.findTopoCompBlocks" t ;; (method)
           "autosar.composition.Utils.getComponentPrototypeName" t ;; (method)
           "autosar.composition.Utils.getM3ICompFromPortBlock" t ;; (method)
           "autosar.composition.Utils.getPathSkippingVariantSubsystems" t ;; (method)
           "autosar.composition.Utils.getSupportedComponentKinds" t ;; (method)
           "autosar.composition.Utils.getSupportedComponentKindsForARXMLImport" t ;; (method)
           "autosar.composition.Utils.getTabCompleteVariantNames" t ;; (method)
           "autosar.composition.Utils.isAdapterBlock" t ;; (method)
           "autosar.composition.Utils.isAUTOSARArchModel" t ;; (method)
           "autosar.composition.Utils.isCompBlockLinked" t ;; (method)
           "autosar.composition.Utils.isCompBlockNonLinked" t ;; (method)
           "autosar.composition.Utils.isComponentBlock" t ;; (method)
           "autosar.composition.Utils.isComponentOrCompositionBlock" t ;; (method)
           "autosar.composition.Utils.isCompositeInportBlock" t ;; (method)
           "autosar.composition.Utils.isCompositeOutportBlock" t ;; (method)
           "autosar.composition.Utils.isCompositePortBlock" t ;; (method)
           "autosar.composition.Utils.isCompositionBlock" t ;; (method)
           "autosar.composition.Utils.isCompositionModel" t ;; (method)
           "autosar.composition.Utils.isCompTypeInArchModel" t ;; (method)
           "autosar.composition.Utils.isDataReceiverPort" t ;; (method)
           "autosar.composition.Utils.isDataSenderPort" t ;; (method)
           "autosar.composition.Utils.isEmptyBlockDiagram" t ;; (method)
           "autosar.composition.Utils.isEmptyCompositionBlock" t ;; (method)
           "autosar.composition.Utils.isM3IComposition" t ;; (method)
           "autosar.composition.Utils.isM3ICompositionPrototype" t ;; (method)
           "autosar.composition.Utils.isModelInCompositionDomain" t ;; (method)
           "autosar.composition.Utils.isSwComponentSupported" t ;; (method)
           "autosar.composition.Utils.isVariantComponentOrComposition" t ;; (method)
           "autosar.composition.utils.M3IElementMover" t ;; (class)
           "autosar.composition.utils.M3IElementMover.moveElementsByMetaClass" t ;; (method)
           "autosar.composition.utils.M3IElementMover.moveElementsByNameAndMetaClass" t ;; (method)
           "autosar.composition.utils.ReferenceCompositionTraverser" t ;; (class)
           "autosar.composition.utils.Sequence" t ;; (class)
           "autosar.composition.utils.SLCompositionVisitor" t ;; (class)
           "autosar.composition.Utils.sortCompositionsInTopdownOrder" t ;; (method)
           "autosar.composition.utils.UuidUniquifier" t ;; (class)
           "autosar.composition.utils.UuidUniquifier.uniqifyUUIDs" t ;; (method)
           "autosar.composition.utils.VisitInfo" t ;; (class)
           "autosar.composition.utils.XmlOptionsCopier" t ;; (class)
           "autosar.composition.utils.XmlOptionsCopier.copyXmlOptionsAndSetToInherit" t ;; (method)
           "autosar.composition.validation.AdaptiveConnectorValidator" t ;; (class)
           "autosar.composition.validation.DDSServicePortDeploymentValidator" t ;; (class)
           "autosar.composition.validation.DDSServicePortDeploymentValidator.getDeploymentValidatorForPort" t ;; (method)
           "autosar.composition.validation.DDSServicePortDeploymentValidator.NetworkBindingType" 'property
           "autosar.composition.validation.ServicePortDeploymentValidator" t ;; (class)
           "autosar.composition.validation.ServicePortDeploymentValidator.getDeploymentValidatorForPort" t ;; (method)
           "autosar.composition.validation.ServicePortDeploymentValidator.NetworkBindingType" 'property
           "autosar.composition.validation.SOMEIPServicePortDeploymentValidator" t ;; (class)
           "autosar.composition.validation.SOMEIPServicePortDeploymentValidator.getDeploymentValidatorForPort" t ;; (method)
           "autosar.composition.validation.SOMEIPServicePortDeploymentValidator.NetworkBindingType" 'property
           "autosar.composition.validation.Validator" t ;; (class)
           "autosar.composition.validation.Validator.canInlineAUTOSARComposition" t ;; (method)
           "AUTOSAR.CSC.CalPrm" t ;; (class)
           "AUTOSAR.CSC.CalPrm.CommentSource" 'property
           "AUTOSAR.CSC.CalPrm.CustomAttributes" 'property
           "AUTOSAR.CSC.CalPrm.DataAccess" 'property
           "AUTOSAR.CSC.CalPrm.DataInit" 'property
           "AUTOSAR.CSC.CalPrm.DataScope" 'property
           "AUTOSAR.CSC.CalPrm.DeclareComment" 'property
           "AUTOSAR.CSC.CalPrm.DefineComment" 'property
           "AUTOSAR.CSC.CalPrm.DefinitionFile" 'property
           "AUTOSAR.CSC.CalPrm.HeaderFile" 'property
           "AUTOSAR.CSC.CalPrm.IsAddressable" 'property
           "AUTOSAR.CSC.CalPrm.IsConst" 'property
           "AUTOSAR.CSC.CalPrm.IsVolatile" 'property
           "AUTOSAR.CSC.CalPrm.Name" 'property
           "AUTOSAR.CSC.CalPrm.Package" 'property
           "AUTOSAR.CSC.CalPrm.Qualifiers" 'property
           "AUTOSAR.CSC.CalPrm.TypeComment" 'property
           "AUTOSAR.CSC.GenRTEHeaderFile" t ;; (function)
           "AUTOSAR.CSC.getRTEInstanceName" t ;; (function)
           "AUTOSAR.CSC.getRTEInstanceType" t ;; (function)
           "AUTOSAR.CSC.IsAutosar" t ;; (function)
           "AUTOSAR.csc_registration" t ;; (function)
           "AUTOSAR.CSCTypeAttributes_CalPrm" t ;; (class)
           "autosar.dictionary.ARAdaptivePlatformMapping" t ;; (class)
           "autosar.dictionary.ARClassicPlatformMapping" t ;; (class)
           "AUTOSAR.DualScaledParameter" t ;; (class)
           "AUTOSAR.DualScaledParameter.Dimensions" 'property
           "autosar.harness.generateBSWModule" t ;; (function)
           "AUTOSAR.InternalCalPrmAttributes" t ;; (class)
           "autosar.mm.arxml.ArxmlReadingTransformer" t ;; (class)
           "autosar.mm.arxml.ArxmlTransformer" t ;; (class)
           "autosar.mm.arxml.Exporter" t ;; (class)
           "autosar.mm.arxml.Exporter.createExporter" t ;; (method)
           "autosar.mm.arxml.Exporter.exportModel" t ;; (method)
           "autosar.mm.arxml.Exporter.exportPackagedElements" t ;; (method)
           "autosar.mm.arxml.Exporter.exportSharedAUTOSARDictionary" t ;; (method)
           "autosar.mm.arxml.Exporter.findByBaseType" t ;; (method)
           "autosar.mm.arxml.Exporter.getArxmlFileForPackagedElement" t ;; (method)
           "autosar.mm.arxml.Exporter.getComponentArxmlFileName" t ;; (method)
           "autosar.mm.arxml.Exporter.getCompositionArxmlFileName" t ;; (method)
           "autosar.mm.arxml.Exporter.getExecutionManifestArxmlFileName" t ;; (method)
           "autosar.mm.arxml.Exporter.getImplementationArxmlFileName" t ;; (method)
           "autosar.mm.arxml.Exporter.getMachineManifestArxmlFileName" t ;; (method)
           "autosar.mm.arxml.Exporter.getMajorMinorRevDefaults" t ;; (method)
           "autosar.mm.arxml.Exporter.getModelArxmlFolder" t ;; (method)
           "autosar.mm.arxml.Exporter.getModelArxmlStubFolder" t ;; (method)
           "autosar.mm.arxml.Exporter.getSystemArxmlFileName" t ;; (method)
           "autosar.mm.arxml.Exporter.getTimingExtensionArxmlFileName" t ;; (method)
           "autosar.mm.arxml.Exporter.hasExternalReference" t ;; (method)
           "autosar.mm.arxml.Exporter.isAncestorOf" t ;; (method)
           "autosar.mm.arxml.Exporter.isExternalReference" t ;; (method)
           "autosar.mm.arxml.Exporter.isPackagedElementImported" t ;; (method)
           "autosar.mm.arxml.Exporter.mergeArxmlFiles" t ;; (method)
           "autosar.mm.arxml.Exporter.setDefaultArxmlFileForM3iElem" t ;; (method)
           "autosar.mm.arxml.Importer" t ;; (class)
           "autosar.mm.arxml.Importer.validateFile" t ;; (method)
           "autosar.mm.arxml.MetaClassToFileNameManager" t ;; (class)
           "autosar.mm.arxml.MetaClassToFileNameManager.canSortM3IElemToSeparateARXMLFile" t ;; (method)
           "autosar.mm.arxml.MetaClassToFileNameManager.getArxmlFileName" t ;; (method)
           "autosar.mm.arxml.MetaClassToFileNameManager.MetaClassToPropNameMap" 'property
           "autosar.mm.arxml.schema.SchemaTransformerFactory" t ;; (class)
           "autosar.mm.arxml.schema.SchemaUtil" t ;; (class)
           "autosar.mm.arxml.schema.SchemaUtil.getDefaultVersion" t ;; (method)
           "autosar.mm.arxml.schema.SchemaUtil.getSchemaFile" t ;; (method)
           "autosar.mm.arxml.schema.SchemaUtil.getSchemaUri" t ;; (method)
           "autosar.mm.arxml.schema.SchemaUtil.getSchemaVersion" t ;; (method)
           "autosar.mm.arxml.schema.SchemaUtil.getXmlNamespaceSchemaFile" t ;; (method)
           "autosar.mm.arxml.schema.XformVer41To40" t ;; (class)
           "autosar.mm.arxml.schema.XformVer42To41" t ;; (class)
           "autosar.mm.arxml.schema.XformVer43To42" t ;; (class)
           "autosar.mm.arxml.schema.XformVer43To43" t ;; (class)
           "autosar.mm.arxml.schema.XformVer49To48" t ;; (class)
           "autosar.mm.arxml.schema.XformVer50To49" t ;; (class)
           "autosar.mm.arxml.schema.XformVer51To50" t ;; (class)
           "autosar.mm.arxml.schema.XformVer51To51" t ;; (class)
           "autosar.mm.arxml.variant.XformVariantBindingTimeOnRead" t ;; (class)
           "autosar.mm.arxml.variant.XformVariantBindingTimeOnWrite" t ;; (class)
           "autosar.mm.mm2ara.AdaptiveMappingData" t ;; (class)
           "autosar.mm.mm2ara.ARABuilder" t ;; (class)
           "autosar.mm.mm2ara.ARAGenerator" t ;; (class)
           "autosar.mm.mm2ara.ARAGenerator.addStaticARAHeaderFilesToBuildInfo" t ;; (method)
           "autosar.mm.mm2ara.ARAGenerator.addStaticARAHeaderFilesToReport" t ;; (method)
           "autosar.mm.mm2ara.ARAGenerator.getARAFilesFolder" t ;; (method)
           "autosar.mm.mm2ara.ARAGenerator.getARAFilesSubFolder" t ;; (method)
           "autosar.mm.mm2ara.ARAGenerator.StaticARAHeaderPathContainer" 'property
           "autosar.mm.mm2ara.ARAWriter" t ;; (class)
           "autosar.mm.mm2ara.com.ARAComProxyClassWriter" t ;; (function)
           "autosar.mm.mm2ara.com.ARAComProxyClassWriterSOA" t ;; (function)
           "autosar.mm.mm2ara.com.ARAComProxyEventWriter" t ;; (function)
           "autosar.mm.mm2ara.com.ARAComProxyFieldWriter" t ;; (function)
           "autosar.mm.mm2ara.com.ARAComProxyMethodWriter" t ;; (function)
           "autosar.mm.mm2ara.com.ARAComSkeletonClassWriter" t ;; (function)
           "autosar.mm.mm2ara.com.ARAComSkeletonClassWriterSOA" t ;; (function)
           "autosar.mm.mm2ara.com.ARAComSkeletonEventWriter" t ;; (function)
           "autosar.mm.mm2ara.com.ARAComSkeletonFieldWriter" t ;; (function)
           "autosar.mm.mm2ara.com.ARAComSkeletonImplClassWriter" t ;; (function)
           "autosar.mm.mm2ara.com.GenerateEventToSimPortMap" t ;; (function)
           "autosar.mm.mm2ara.com.populateAraComDataMembers" t ;; (function)
           "autosar.mm.mm2ara.com.RtpsIdlWriter" t ;; (function)
           "autosar.mm.mm2ara.com.RtpsProxyFieldSerializerWriter" t ;; (function)
           "autosar.mm.mm2ara.com.RtpsProxyMethodSerializerWriter" t ;; (function)
           "autosar.mm.mm2ara.com.RtpsSerializerWriter" t ;; (function)
           "autosar.mm.mm2ara.com.RtpsSerializerWriterUtils" t ;; (class)
           "autosar.mm.mm2ara.com.RtpsSerializerWriterUtils.cleanAppendSizeCode" t ;; (method)
           "autosar.mm.mm2ara.com.RtpsSerializerWriterUtils.GenerateArgDeserializationRoutine" t ;; (method)
           "autosar.mm.mm2ara.com.RtpsSerializerWriterUtils.GenerateArgSerializationRoutine" t ;; (method)
           "autosar.mm.mm2ara.com.RtpsSerializerWriterUtils.generateDeserializationArrayTypeLambda" t ;; (method)
           "autosar.mm.mm2ara.com.RtpsSerializerWriterUtils.generateDeserializationLambda" t ;; (method)
           "autosar.mm.mm2ara.com.RtpsSerializerWriterUtils.generateIdlToImplConversionArrayTypeLambda" t ;; (method)
           "autosar.mm.mm2ara.com.RtpsSerializerWriterUtils.generateIdlToImplConversionLambda" t ;; (method)
           "autosar.mm.mm2ara.com.RtpsSerializerWriterUtils.generateImplToIdlConversionArrayTypeLambda" t ;; (method)
           "autosar.mm.mm2ara.com.RtpsSerializerWriterUtils.generateImplToIdlConversionLambda" t ;; (method)
           "autosar.mm.mm2ara.com.RtpsSerializerWriterUtils.generateSerializationArrayTypeLambda" t ;; (method)
           "autosar.mm.mm2ara.com.RtpsSerializerWriterUtils.generateSerializationLambda" t ;; (method)
           "autosar.mm.mm2ara.com.RtpsSerializerWriterUtils.getArrSizeName" t ;; (method)
           "autosar.mm.mm2ara.com.RtpsSerializerWriterUtils.getCArrayTypeName" t ;; (method)
           "autosar.mm.mm2ara.com.RtpsSerializerWriterUtils.getCodeDataType" t ;; (method)
           "autosar.mm.mm2ara.com.RtpsSerializerWriterUtils.getFieldType" t ;; (method)
           "autosar.mm.mm2ara.com.RtpsSerializerWriterUtils.getGenCodeDataType" t ;; (method)
           "autosar.mm.mm2ara.com.RtpsSerializerWriterUtils.getLambdaName" t ;; (method)
           "autosar.mm.mm2ara.com.RtpsSerializerWriterUtils.getMatrixSize" t ;; (method)
           "autosar.mm.mm2ara.com.RtpsSerializerWriterUtils.getMethodsMappedToField" t ;; (method)
           "autosar.mm.mm2ara.com.RtpsSerializerWriterUtils.getRecursiveArrayType" t ;; (method)
           "autosar.mm.mm2ara.com.RtpsSerializerWriterUtils.getRetObjName" t ;; (method)
           "autosar.mm.mm2ara.com.RtpsSerializerWriterUtils.getRTPSMetaDataFromType" t ;; (method)
           "autosar.mm.mm2ara.com.RtpsSkeletonMethodSerializerWriter" t ;; (function)
           "autosar.mm.mm2ara.com.SerializerWriterSOA" t ;; (function)
           "autosar.mm.mm2ara.com.SerializerWriterUtilsSOA" t ;; (class)
           "autosar.mm.mm2ara.com.SerializerWriterUtilsSOA.generateDeserializationArrayTypeLambda" t ;; (method)
           "autosar.mm.mm2ara.com.SerializerWriterUtilsSOA.generateDeserializationLambda" t ;; (method)
           "autosar.mm.mm2ara.com.SerializerWriterUtilsSOA.generateSerializationArrayTypeLambda" t ;; (method)
           "autosar.mm.mm2ara.com.SerializerWriterUtilsSOA.generateSerializationLambda" t ;; (method)
           "autosar.mm.mm2ara.com.SomeipSerializerWriter" t ;; (function)
           "autosar.mm.mm2ara.NamespaceHelper" t ;; (class)
           "autosar.mm.mm2ara.NamespaceHelper.getCppStyleNamespaceFromCodeDescriptor" t ;; (method)
           "autosar.mm.mm2ara.NamespaceHelper.getCppStyleNamespaceFromM3I" t ;; (method)
           "autosar.mm.mm2ara.NamespaceHelper.getNamespacesFor" t ;; (method)
           "autosar.mm.mm2ara.NamespaceHelper.getNamespaceSymbolsFromCppStyleString" t ;; (method)
           "autosar.mm.mm2ara.NamespaceHelper.getNamespaceSymbolsFromM3IObj" t ;; (method)
           "autosar.mm.mm2ara.NamespaceHelper.getQualifiedTypeName" t ;; (method)
           "autosar.mm.mm2ara.NamespaceHelper.updateM3INamespaceFromCppStyleStr" t ;; (method)
           "autosar.mm.mm2ara.NamespaceHelper.writeBegNamespaces" t ;; (method)
           "autosar.mm.mm2ara.NamespaceHelper.writeEndNamespaces" t ;; (method)
           "autosar.mm.mm2ara.per.ARAPerKVSClassWriter" t ;; (function)
           "autosar.mm.mm2ara.ServiceInterfaceBuilder" t ;; (class)
           "autosar.mm.mm2ara.ServiceInterfaceWriter" t ;; (class)
           "autosar.mm.mm2ara.ServiceInterfaceWriter.getSchemaCompliantName" t ;; (method)
           "autosar.mm.mm2ara.ServiceInterfaceWriter.getSchemaVersion" t ;; (method)
           "autosar.mm.mm2ara.TypeBuilder" t ;; (class)
           "autosar.mm.mm2ara.TypeWriter" t ;; (class)
           "autosar.mm.mm2ara.TypeWriter.getUsingTypeName" t ;; (method)
           "autosar.mm.mm2rte.ASWCBuilder" t ;; (class)
           "autosar.mm.mm2rte.ASWCProperties" t ;; (class)
           "autosar.mm.mm2rte.ASWCWriter" t ;; (class)
           "autosar.mm.mm2rte.CfgBuilder" t ;; (class)
           "autosar.mm.mm2rte.CfgWriter" t ;; (class)
           "autosar.mm.mm2rte.ComponentOwned" t ;; (class)
           "autosar.mm.mm2rte.ErrorStatusPortTable" t ;; (class)
           "autosar.mm.mm2rte.ErrorStatusPortTable.fromDataInterfaceArray" t ;; (method)
           "autosar.mm.mm2rte.MemMapBuilder" t ;; (class)
           "autosar.mm.mm2rte.MemMapWriter" t ;; (class)
           "autosar.mm.mm2rte.PbCfgBuilder" t ;; (class)
           "autosar.mm.mm2rte.PbCfgWriter" t ;; (class)
           "autosar.mm.mm2rte.PbCfgWriter.RTETypeFileNameC" 'property
           "autosar.mm.mm2rte.PbCfgWriter.RTETypeFileNameH" 'property
           "autosar.mm.mm2rte.RTEBuilder" t ;; (class)
           "autosar.mm.mm2rte.RTEData" t ;; (class)
           "autosar.mm.mm2rte.RTEDataItemAccessFcn" t ;; (class)
           "autosar.mm.mm2rte.RTEDataItemARTypedPIM" t ;; (class)
           "autosar.mm.mm2rte.RTEDataItemCTypedPIM" t ;; (class)
           "autosar.mm.mm2rte.RTEDataItemExclusiveArea" t ;; (class)
           "autosar.mm.mm2rte.RTEDataItemInternalTriggeringPoint" t ;; (class)
           "autosar.mm.mm2rte.RTEDataItemIRVFcn" t ;; (class)
           "autosar.mm.mm2rte.RTEDataItemModeDeclGroupAccess" t ;; (class)
           "autosar.mm.mm2rte.RTEDataItemOperation" t ;; (class)
           "autosar.mm.mm2rte.RTEDataItemOperationArgument" t ;; (class)
           "autosar.mm.mm2rte.RTEDataItemOperationCall" t ;; (class)
           "autosar.mm.mm2rte.RTEDataItemParameter" t ;; (class)
           "autosar.mm.mm2rte.RTEDataItemPIM" t ;; (class)
           "autosar.mm.mm2rte.RTEDataItemRunnable" t ;; (class)
           "autosar.mm.mm2rte.RTEDataItemServer" t ;; (class)
           "autosar.mm.mm2rte.RTEDataItemSignInvInitValue" t ;; (class)
           "autosar.mm.mm2rte.RTEDataItemSwAddrMethod" t ;; (class)
           "autosar.mm.mm2rte.RTEDataItemUtils" t ;; (class)
           "autosar.mm.mm2rte.RTEDataItemUtils.getDeclarationTypeAndVar" t ;; (method)
           "autosar.mm.mm2rte.RTEDataItemVariationPoint" t ;; (class)
           "autosar.mm.mm2rte.RTEGenerator" t ;; (class)
           "autosar.mm.mm2rte.RTEGenerator.addGeneratedRTEIncludePathToSubModels" t ;; (method)
           "autosar.mm.mm2rte.RTEGenerator.addStaticRTEHeaderFilesToBuildInfo" t ;; (method)
           "autosar.mm.mm2rte.RTEGenerator.addStaticRTEHeaderFilesToReport" t ;; (method)
           "autosar.mm.mm2rte.RTEGenerator.createRTEFilesFolder" t ;; (method)
           "autosar.mm.mm2rte.RTEGenerator.getRTEFilesFolder" t ;; (method)
           "autosar.mm.mm2rte.RTEGenerator.getRTEFilesSubFolder" t ;; (method)
           "autosar.mm.mm2rte.RTEGenerator.getStaticRTEHeaderFileNames" t ;; (method)
           "autosar.mm.mm2rte.RTEGenerator.LSTPlatformTypesHeaderPath" 'property
           "autosar.mm.mm2rte.RTEGenerator.OtherStaticRTEHeaderFiles" 'property
           "autosar.mm.mm2rte.RTEGenerator.PlatformTypesHeaderFileName" 'property
           "autosar.mm.mm2rte.RTEGenerator.RTWTypesPlatformTypesHeaderPath" 'property
           "autosar.mm.mm2rte.RTEGenerator.StaticRTEHeaderPath" 'property
           "autosar.mm.mm2rte.RTEWriter" t ;; (class)
           "autosar.mm.mm2rte.SignalInvalidationPortTable" t ;; (class)
           "autosar.mm.mm2rte.SignalInvalidationPortTable.fromM3IComp" t ;; (method)
           "autosar.mm.mm2rte.SignalInvalidationPortTable.fromModelMapping" t ;; (method)
           "autosar.mm.mm2rte.TypeBuilder" t ;; (class)
           "autosar.mm.mm2rte.TypeBuilder.getAutosarType" t ;; (method)
           "autosar.mm.mm2rte.TypeData" t ;; (class)
           "autosar.mm.mm2rte.TypeData.createEnumDataItem" t ;; (method)
           "autosar.mm.mm2rte.TypeDataItems" t ;; (class)
           "autosar.mm.mm2rte.TypeWriter" t ;; (class)
           "autosar.mm.mm2rte.TypeWriter.RTETypeFileNameH" 'property
           "autosar.mm.mm2sl.AdaptiveSimulinkFunctionBuilder" t ;; (class)
           "autosar.mm.mm2sl.AdaptiveSimulinkFunctionBuilder.findBlockWithType" t ;; (method)
           "autosar.mm.mm2sl.BlockVariantBuilder" t ;; (class)
           "autosar.mm.mm2sl.CompositionM3IElementsCache" t ;; (class)
           "autosar.mm.mm2sl.ConstantBuilder" t ;; (class)
           "autosar.mm.mm2sl.ConstantBuilder.convertValueToString" t ;; (method)
           "autosar.mm.mm2sl.ConstantBuilder.getInitValuePropertyName" t ;; (method)
           "autosar.mm.mm2sl.EventRunnableFinder" t ;; (class)
           "autosar.mm.mm2sl.EventRunnableFinder.supportedEvent" t ;; (method)
           "autosar.mm.mm2sl.InitRunnableFinder" t ;; (class)
           "autosar.mm.mm2sl.InitRunnableFinder.supportedEvent" t ;; (method)
           "autosar.mm.mm2sl.InitRunnableFinder.UndefinedInitRunnableName" 'property
           "autosar.mm.mm2sl.InterfaceBuilder" t ;; (class)
           "autosar.mm.mm2sl.InterfaceBuilder.ImportMessage" 'property
           "autosar.mm.mm2sl.IRTRunnableType" t ;; (class)
           "autosar.mm.mm2sl.IRTRunnableType.Initialization" 'enumeration
           "autosar.mm.mm2sl.IRTRunnableType.NotAnIRTRunnable" 'enumeration
           "autosar.mm.mm2sl.IRTRunnableType.Reset" 'enumeration
           "autosar.mm.mm2sl.IRTRunnableType.Terminate" 'enumeration
           "autosar.mm.mm2sl.layout.BlockBeautifier" t ;; (class)
           "autosar.mm.mm2sl.layout.BlockBeautifier.beautifyBlock" t ;; (method)
           "autosar.mm.mm2sl.layout.LayeredLayoutStrategy" t ;; (class)
           "autosar.mm.mm2sl.layout.LayeredLayoutStrategy.getLayoutNodeName" t ;; (method)
           "autosar.mm.mm2sl.layout.LayeredLayoutStrategy.positionChains" t ;; (method)
           "autosar.mm.mm2sl.layout.LayoutGraphUtils" t ;; (class)
           "autosar.mm.mm2sl.layout.LayoutGraphUtils.getLayoutLayers" t ;; (method)
           "autosar.mm.mm2sl.layout.LayoutGraphUtils.plotDiGraphLayered" t ;; (method)
           "autosar.mm.mm2sl.layout.LayoutHelper" t ;; (class)
           "autosar.mm.mm2sl.layout.LayoutHelper.addLine" t ;; (method)
           "autosar.mm.mm2sl.layout.LayoutHelper.autoRouteLines" t ;; (method)
           "autosar.mm.mm2sl.layout.LayoutHelper.autoRouteLinesWithEdges" t ;; (method)
           "autosar.mm.mm2sl.layout.LayoutHelper.BlockTypeToLayoutBlockCategoryMap" 'property
           "autosar.mm.mm2sl.layout.LayoutHelper.CanvasLimit" 'property
           "autosar.mm.mm2sl.layout.LayoutHelper.CanvasMinX" 'property
           "autosar.mm.mm2sl.layout.LayoutHelper.CanvasMinY" 'property
           "autosar.mm.mm2sl.layout.LayoutHelper.canvasViewScrollTopLeft" t ;; (method)
           "autosar.mm.mm2sl.layout.LayoutHelper.deleteUnconnectedLines" t ;; (method)
           "autosar.mm.mm2sl.layout.LayoutHelper.findModelBoundingBox" t ;; (method)
           "autosar.mm.mm2sl.layout.LayoutHelper.getIdealGapForBlocksToHome" t ;; (method)
           "autosar.mm.mm2sl.layout.LayoutHelper.homeSrcAndDstBlocks" t ;; (method)
           "autosar.mm.mm2sl.layout.LayoutHelper.makeBlocksSameWidth" t ;; (method)
           "autosar.mm.mm2sl.layout.LayoutHelper.orderFcnCallInPortsFirst" t ;; (method)
           "autosar.mm.mm2sl.layout.LayoutHelper.setBlockPosition" t ;; (method)
           "autosar.mm.mm2sl.layout.LayoutHelper.tidySignalLines" t ;; (method)
           "autosar.mm.mm2sl.layout.LayoutLayers" t ;; (class)
           "autosar.mm.mm2sl.layout.LayoutManager" t ;; (class)
           "autosar.mm.mm2sl.layout.LayoutManagerFactory" t ;; (class)
           "autosar.mm.mm2sl.layout.LayoutManagerFactory.getLayoutManager" t ;; (method)
           "autosar.mm.mm2sl.layout.LayoutStrategy" t ;; (class)
           "autosar.mm.mm2sl.layout.MatrixLayoutStrategy" t ;; (class)
           "autosar.mm.mm2sl.layout.SkeletonModelBeautifier" t ;; (class)
           "autosar.mm.mm2sl.layout.SkeletonModelBeautifier.beautifyModel" t ;; (method)
           "autosar.mm.mm2sl.layout.SubSystemLayoutManager" t ;; (class)
           "autosar.mm.mm2sl.layout.TopModelLayoutManager" t ;; (class)
           "autosar.mm.mm2sl.MemorySectionBuilder" t ;; (class)
           "autosar.mm.mm2sl.MemorySectionBuilder.refreshAUTOSAR4MemorySections" t ;; (method)
           "autosar.mm.mm2sl.MessageTriggeredSSBuilder" t ;; (class)
           "autosar.mm.mm2sl.MessageTriggeredSSBuilder.findBlockWithType" t ;; (method)
           "autosar.mm.mm2sl.ModelBuilder" t ;; (class)
           "autosar.mm.mm2sl.ModelBuilder.checkModelFileName" t ;; (method)
           "autosar.mm.mm2sl.ModelBuilder.getM3IComp" t ;; (method)
           "autosar.mm.mm2sl.ModelBuilder.getOrCreateSimulinkModel" t ;; (method)
           "autosar.mm.mm2sl.MRLayoutManager" t ;; (class)
           "autosar.mm.mm2sl.MRLayoutManager.addGotoFrom" t ;; (method)
           "autosar.mm.mm2sl.MRLayoutManager.homeBlk" t ;; (method)
           "autosar.mm.mm2sl.MRLayoutManager.homeBlockLayers" t ;; (method)
           "autosar.mm.mm2sl.MRLayoutManager.homeServerPort" t ;; (method)
           "autosar.mm.mm2sl.MRLayoutManager.moveBlk" t ;; (method)
           "autosar.mm.mm2sl.MRLayoutManager.numConnections" t ;; (method)
           "autosar.mm.mm2sl.ObjectBuilder" t ;; (class)
           "autosar.mm.mm2sl.ObjectBuilder.compareAndLogChanges" t ;; (method)
           "autosar.mm.mm2sl.parameter.AbstractParamUpdater" t ;; (class)
           "autosar.mm.mm2sl.parameter.AbstractParamUpdater.getSlTypeInfo" t ;; (method)
           "autosar.mm.mm2sl.parameter.BreakpointParamUpdater" t ;; (class)
           "autosar.mm.mm2sl.parameter.BreakpointParamUpdater.getSlTypeInfo" t ;; (method)
           "autosar.mm.mm2sl.parameter.DefaultParamUpdater" t ;; (class)
           "autosar.mm.mm2sl.parameter.DefaultParamUpdater.getSlTypeInfo" t ;; (method)
           "autosar.mm.mm2sl.parameter.FixAxisLookupTableParamUpdater" t ;; (class)
           "autosar.mm.mm2sl.parameter.FixAxisLookupTableParamUpdater.getSlTypeInfo" t ;; (method)
           "autosar.mm.mm2sl.parameter.getM3IInitValue" t ;; (function)
           "autosar.mm.mm2sl.parameter.getParamUpdater" t ;; (function)
           "autosar.mm.mm2sl.parameter.LookupTableBreakpointConnector" t ;; (class)
           "autosar.mm.mm2sl.parameter.LookupTableParamUpdater" t ;; (class)
           "autosar.mm.mm2sl.parameter.LookupTableParamUpdater.getSlTypeInfo" t ;; (method)
           "autosar.mm.mm2sl.parameter.StdAxisLookupTableParamUpdater" t ;; (class)
           "autosar.mm.mm2sl.parameter.StdAxisLookupTableParamUpdater.getSlTypeInfo" t ;; (method)
           "autosar.mm.mm2sl.ParameterBuilder" t ;; (class)
           "autosar.mm.mm2sl.ParameterBuilder.compareAndLogChanges" t ;; (method)
           "autosar.mm.mm2sl.PeriodicRunnablesModelingStyleDeterminer" t ;; (class)
           "autosar.mm.mm2sl.PeriodicRunnablesModelingStyleDeterminer.collectPeriodicRunnableSampleTimes" t ;; (method)
           "autosar.mm.mm2sl.ResetRunnableFinder" t ;; (class)
           "autosar.mm.mm2sl.ResetRunnableFinder.supportedEvent" t ;; (method)
           "autosar.mm.mm2sl.RunnableAsAsyncSubsys" t ;; (class)
           "autosar.mm.mm2sl.RunnableAsAsyncSubsys.findBlockWithType" t ;; (method)
           "autosar.mm.mm2sl.RunnableAsAtomicSubsys" t ;; (class)
           "autosar.mm.mm2sl.RunnableAsAtomicSubsys.findBlockWithType" t ;; (method)
           "autosar.mm.mm2sl.RunnableAsFcnCallSubsys" t ;; (class)
           "autosar.mm.mm2sl.RunnableAsFcnCallSubsys.findBlockWithType" t ;; (method)
           "autosar.mm.mm2sl.RunnableAsInitFunctionBlock" t ;; (class)
           "autosar.mm.mm2sl.RunnableAsInitFunctionBlock.findBlockWithType" t ;; (method)
           "autosar.mm.mm2sl.RunnableAsResetFunctionBlock" t ;; (class)
           "autosar.mm.mm2sl.RunnableAsResetFunctionBlock.findBlockWithType" t ;; (method)
           "autosar.mm.mm2sl.RunnableAsSimulinkFunction" t ;; (class)
           "autosar.mm.mm2sl.RunnableAsSimulinkFunction.findBlockWithType" t ;; (method)
           "autosar.mm.mm2sl.RunnableAsTerminateFunctionBlock" t ;; (class)
           "autosar.mm.mm2sl.RunnableAsTerminateFunctionBlock.findBlockWithType" t ;; (method)
           "autosar.mm.mm2sl.RunnableBuilder" t ;; (class)
           "autosar.mm.mm2sl.RunnableBuilder.findBlockWithType" t ;; (method)
           "autosar.mm.mm2sl.RunnableBuilderFactory" t ;; (class)
           "autosar.mm.mm2sl.RunnableBuilderFactory.getBuilder" t ;; (method)
           "autosar.mm.mm2sl.RunnableHelper" t ;; (class)
           "autosar.mm.mm2sl.RunnableHelper.getPeriodicRunnablesCount" t ;; (method)
           "autosar.mm.mm2sl.RunnableHelper.hasIrvOrIOConnections" t ;; (method)
           "autosar.mm.mm2sl.RunnableHelper.isInternallyTriggeredRunnable" t ;; (method)
           "autosar.mm.mm2sl.RunnableHelper.isInvokedByEvent" t ;; (method)
           "autosar.mm.mm2sl.RunnableHelper.isServerRunnable" t ;; (method)
           "autosar.mm.mm2sl.SignalBuilder" t ;; (class)
           "autosar.mm.mm2sl.SignalBuilder.compareAndLogChanges" t ;; (method)
           "autosar.mm.mm2sl.SignalBuilder.isLegacyPIMSignalObject" t ;; (method)
           "autosar.mm.mm2sl.SimulinkFunctionBuilder" t ;; (class)
           "autosar.mm.mm2sl.SimulinkFunctionBuilder.findBlockWithType" t ;; (method)
           "autosar.mm.mm2sl.SLBusHelper" t ;; (class)
           "autosar.mm.mm2sl.SLLookupTableBuilder" t ;; (class)
           "autosar.mm.mm2sl.SLModelBuilder" t ;; (class)
           "autosar.mm.mm2sl.SLModelBuilder.createAddedBlockSimulinkArea" t ;; (method)
           "autosar.mm.mm2sl.SLModelBuilder.createAddedLineSimulinkArea" t ;; (method)
           "autosar.mm.mm2sl.SLModelBuilder.createDeleteBlockSimulinkArea" t ;; (method)
           "autosar.mm.mm2sl.SLModelBuilder.getAllDestinationPortsThroughVirtualBlocks" t ;; (method)
           "autosar.mm.mm2sl.SLModelBuilder.getSLBlockNameForPortElement" t ;; (method)
           "autosar.mm.mm2sl.SLModelBuilder.isQueuedPort" t ;; (method)
           "autosar.mm.mm2sl.SLModelBuilder.markBlkDeletion" t ;; (method)
           "autosar.mm.mm2sl.SLModelBuilder.set_param" t ;; (method)
           "autosar.mm.mm2sl.StateflowHelper" t ;; (class)
           "autosar.mm.mm2sl.StateflowHelper.createReceiverChart" t ;; (method)
           "autosar.mm.mm2sl.StateflowHelper.createSenderChart" t ;; (method)
           "autosar.mm.mm2sl.TerminateRunnableFinder" t ;; (class)
           "autosar.mm.mm2sl.TerminateRunnableFinder.supportedEvent" t ;; (method)
           "autosar.mm.mm2sl.TypeBuilder" t ;; (class)
           "autosar.mm.mm2sl.TypeBuilder.canSlTypeBeAssignedToWorkSpace" t ;; (method)
           "autosar.mm.mm2sl.TypeBuilder.createEnumerationFromCompuMethod" t ;; (method)
           "autosar.mm.mm2sl.TypeBuilder.createEnumsForBitfieldCompuMethod" t ;; (method)
           "autosar.mm.mm2sl.TypeBuilder.createNumericTypeFromCompuMethod" t ;; (method)
           "autosar.mm.mm2sl.TypeBuilder.getComErrorEnumBuilderArgs" t ;; (method)
           "autosar.mm.mm2sl.TypeBuilder.getDefaultSLDesignData" t ;; (method)
           "autosar.mm.mm2sl.TypeBuilder.getSLDimensions" t ;; (method)
           "autosar.mm.mm2sl.TypeBuilder.getUnderlyingType" t ;; (method)
           "autosar.mm.mm2sl.TypeBuilder.hasValidInputVariableType" t ;; (method)
           "autosar.mm.mm2sl.TypeBuilder.ImportMessage" 'property
           "autosar.mm.mm2sl.utils.areSimulinkVariantsEqual" t ;; (function)
           "autosar.mm.mm2sl.utils.checkAndCreateDD" t ;; (function)
           "autosar.mm.mm2sl.utils.convertSwCalibrationAccessKindToStr" t ;; (function)
           "autosar.mm.mm2sl.utils.doesPortUseE2EErrorHandlingTransformer" t ;; (function)
           "autosar.mm.mm2sl.utils.getM3iInitValueFromPort" t ;; (function)
           "autosar.mm.mm2sl.utils.InstantiationDataDefProps" t ;; (class)
           "autosar.mm.mm2sl.utils.InstantiationDataDefProps.getInstanceRef" t ;; (method)
           "autosar.mm.mm2sl.utils.isCompatibleSwAddrMethod" t ;; (function)
           "autosar.mm.mm2sl.utils.LookupTableUtils" t ;; (class)
           "autosar.mm.mm2sl.utils.LookupTableUtils.isFixAxis" t ;; (method)
           "autosar.mm.mm2sl.utils.LookupTableUtils.isFixAxisLUT" t ;; (method)
           "autosar.mm.mm2sl.utils.M3IConnectedPortFinder" t ;; (class)
           "autosar.mm.mm2sl.utils.ModelLookupTables" t ;; (class)
           "autosar.mm.mm2sl.utils.updateDataDictionaryNameArg" t ;; (function)
           "autosar.mm.mm2sl.utils.ValueTypeAutosarCompatibilityChecker" t ;; (class)
           "autosar.mm.mm2sl.utils.ValueTypeSimulinkCompatibilityChecker" t ;; (class)
           "autosar.mm.mm2sl.utils.ValueTypeSupportHelper" t ;; (class)
           "autosar.mm.mm2sl.utils.writeMemorySectionDefs" t ;; (function)
           "autosar.mm.Model" t ;; (class)
           "autosar.mm.Model.captureInterfaceToPortSeqMap" t ;; (method)
           "autosar.mm.Model.changeSequenceOwner" t ;; (method)
           "autosar.mm.Model.findChildByName" t ;; (method)
           "autosar.mm.Model.findChildByNameAndTypeName" t ;; (method)
           "autosar.mm.Model.findChildByTypeName" t ;; (method)
           "autosar.mm.Model.findComSpecForDataElement" t ;; (method)
           "autosar.mm.Model.findContaineeElementsByPortName" t ;; (method)
           "autosar.mm.Model.findElementInSequenceByName" t ;; (method)
           "autosar.mm.Model.findInstanceRef" t ;; (method)
           "autosar.mm.Model.findM3IPortByName" t ;; (method)
           "autosar.mm.Model.findM3IPortContaineeElements" t ;; (method)
           "autosar.mm.Model.findObjectByMetaClass" t ;; (method)
           "autosar.mm.Model.findObjectByName" t ;; (method)
           "autosar.mm.Model.findObjectByNameAndMetaClass" t ;; (method)
           "autosar.mm.Model.findObjectIndexInSequence" t ;; (method)
           "autosar.mm.Model.findObjectInSequenceByMetaClass" t ;; (method)
           "autosar.mm.Model.findObjectNamesByCategory" t ;; (method)
           "autosar.mm.Model.findPackageableElements" t ;; (method)
           "autosar.mm.Model.findPortInfo" t ;; (method)
           "autosar.mm.Model.findPortsUsingInterface" t ;; (method)
           "autosar.mm.Model.findRunnableByName" t ;; (method)
           "autosar.mm.Model.fromBytes" t ;; (method)
           "autosar.mm.Model.fromXmi" t ;; (method)
           "autosar.mm.Model.getArPackage" t ;; (method)
           "autosar.mm.Model.getExtraExternalToolInfo" t ;; (method)
           "autosar.mm.Model.getExtraInternalBehaviorInfo" t ;; (method)
           "autosar.mm.Model.getOrAddARPackage" t ;; (method)
           "autosar.mm.Model.getOrAddPackage" t ;; (method)
           "autosar.mm.Model.getOrCreateInstanceRef" t ;; (method)
           "autosar.mm.Model.getQualifiedName" t ;; (method)
           "autosar.mm.Model.isPortDataElementArraySizeOne" t ;; (method)
           "autosar.mm.Model.isValid" t ;; (method)
           "autosar.mm.Model.loadobj" t ;; (method)
           "autosar.mm.Model.newM3IModel" t ;; (method)
           "autosar.mm.Model.sequenceContainsItem" t ;; (method)
           "autosar.mm.Model.setExternalToolInfo" t ;; (method)
           "autosar.mm.Model.setExtraExternalToolInfo" t ;; (method)
           "autosar.mm.Model.splitObjectPath" t ;; (method)
           "autosar.mm.ModelMetaData" t ;; (class)
           "autosar.mm.ModelMetaData.InterfaceToElementsMetaClass" 'property
           "autosar.mm.ModelMetaData.InterfaceToElementsPropName" 'property
           "autosar.mm.ModelMetaData.InterfaceToPPortMetaClass" 'property
           "autosar.mm.ModelMetaData.InterfaceToRPortMetaClass" 'property
           "autosar.mm.ModelMetaData.PortMetaClassToPropName" 'property
           "autosar.mm.observer.Observer" t ;; (class)
           "autosar.mm.observer.ObserverARDictionaryUI" t ;; (class)
           "autosar.mm.observer.ObserverM3IModelChecker" t ;; (class)
           "autosar.mm.observer.ObserverModelMapping" t ;; (class)
           "autosar.mm.observer.ObserverModelMapping.handleInterfaceChange" t ;; (method)
           "autosar.mm.observer.ObserversDispatcher" t ;; (class)
           "autosar.mm.observer.ObserverSharedDictionary" t ;; (class)
           "autosar.mm.observer.ObserverSharedDictionaryDuringBuild" t ;; (class)
           "autosar.mm.sl2mm.AbstractModelBuilder" t ;; (class)
           "autosar.mm.sl2mm.AdaptiveModelBuilder" t ;; (class)
           "autosar.mm.sl2mm.ApplicationTypeChecker" t ;; (class)
           "autosar.mm.sl2mm.ApplicationTypeMapper" t ;; (class)
           "autosar.mm.sl2mm.ApplicationTypeTracker" t ;; (class)
           "autosar.mm.sl2mm.ASILBuilder" t ;; (class)
           "autosar.mm.sl2mm.ASILBuilder.getASILForM3IObj" t ;; (method)
           "autosar.mm.sl2mm.CodeDescriptorCache" t ;; (class)
           "autosar.mm.sl2mm.CodeDescriptorDimensionArrayAdapter" t ;; (class)
           "autosar.mm.sl2mm.CodeDescriptorDimensionArrayAdapter.getDimensionArray" t ;; (method)
           "autosar.mm.sl2mm.CodeDescriptorDimensionArrayAdapter.isMatrixOfSizeOne" t ;; (method)
           "autosar.mm.sl2mm.CodeDescriptorDimensionArrayAdapter.isNdMatrixType" t ;; (method)
           "autosar.mm.sl2mm.CompuMethodBuilder" t ;; (class)
           "autosar.mm.sl2mm.ComSpecBuilder" t ;; (class)
           "autosar.mm.sl2mm.ComSpecBuilder.addOrUpdateM3IComSpec" t ;; (method)
           "autosar.mm.sl2mm.ComSpecBuilder.checkAndGenerateComSpecsForMappedDataElements" t ;; (method)
           "autosar.mm.sl2mm.ComSpecBuilder.DataAccessModesWithoutComSpec" 'property
           "autosar.mm.sl2mm.ConstantBuilder" t ;; (class)
           "autosar.mm.sl2mm.ConstantBuilder.checkOrUpdateComSpecInitValue" t ;; (method)
           "autosar.mm.sl2mm.ConstantBuilder.convertLUTValuesToFixPointValues" t ;; (method)
           "autosar.mm.sl2mm.ConstantBuilder.createOrUpdateDataInitValueFromGlobalScopeObj" t ;; (method)
           "autosar.mm.sl2mm.ConstantBuilder.createOrUpdateLUTInitValueFromGlobalScopeObj" t ;; (method)
           "autosar.mm.sl2mm.ConstantBuilder.findOrCreateConstantSpecificationFromGlobalScopeObj" t ;; (method)
           "autosar.mm.sl2mm.ConstantBuilder.findOrCreateConstantSpecificationFromScalarValue" t ;; (method)
           "autosar.mm.sl2mm.ConstantBuilder.findOrCreateConstantSpecificationFromTypeGroundValue" t ;; (method)
           "autosar.mm.sl2mm.ConstantBuilder.findOrCreateValueSpecificationFromGlobalScopeObj" t ;; (method)
           "autosar.mm.sl2mm.ConstantBuilder.getDataObjValue" t ;; (method)
           "autosar.mm.sl2mm.ConstantBuilder.updateOrCreateValueSpecification" t ;; (method)
           "autosar.mm.sl2mm.DataConstrBuilder" t ;; (class)
           "autosar.mm.sl2mm.IncludedTypeSetBuilder" t ;; (class)
           "autosar.mm.sl2mm.IncludedTypeSetBuilder.getBaseType" t ;; (method)
           "autosar.mm.sl2mm.IncludedTypeSetBuilder.isTypeBuiltIn" t ;; (method)
           "autosar.mm.sl2mm.IncludedTypeSetBuilder.removeElementsFromMap" t ;; (method)
           "autosar.mm.sl2mm.interface.AdaptiveInterfaceBuilder" t ;; (class)
           "autosar.mm.sl2mm.interface.AdaptiveInterfaceBuilder.checkInterfaceCompatibleWithBusObject" t ;; (method)
           "autosar.mm.sl2mm.interface.AdaptiveInterfaceBuilder.verifyFunctionArgumentRenameIsTracible" t ;; (method)
           "autosar.mm.sl2mm.interface.AUTOSARInterfaceBuilder" t ;; (class)
           "autosar.mm.sl2mm.interface.AUTOSARInterfaceBuilder.checkInterfaceCompatibleWithBusObject" t ;; (method)
           "autosar.mm.sl2mm.interface.AUTOSARInterfaceBuilder.verifyFunctionArgumentRenameIsTracible" t ;; (method)
           "autosar.mm.sl2mm.interface.ClassicInterfaceBuilder" t ;; (class)
           "autosar.mm.sl2mm.interface.ClassicInterfaceBuilder.checkInterfaceCompatibleWithBusObject" t ;; (method)
           "autosar.mm.sl2mm.interface.ClassicInterfaceBuilder.validateBusForMSInterface" t ;; (method)
           "autosar.mm.sl2mm.interface.ClassicInterfaceBuilder.verifyFunctionArgumentRenameIsTracible" t ;; (method)
           "autosar.mm.sl2mm.LookupTableBuilder" t ;; (class)
           "autosar.mm.sl2mm.LookupTableBuilder.getApplicationDataTypeName" t ;; (method)
           "autosar.mm.sl2mm.LookupTableBuilder.getAxisNameFromIndex" t ;; (method)
           "autosar.mm.sl2mm.LookupTableBuilder.getBreakpointBaseTypeObj" t ;; (method)
           "autosar.mm.sl2mm.LookupTableBuilder.getBreakpointNamesOfComAxisLookupTable" t ;; (method)
           "autosar.mm.sl2mm.LookupTableBuilder.getBreakpointStructElementIndex" t ;; (method)
           "autosar.mm.sl2mm.LookupTableBuilder.getEmbeddedObjForBP" t ;; (method)
           "autosar.mm.sl2mm.LookupTableBuilder.getEmbeddedObjForTable" t ;; (method)
           "autosar.mm.sl2mm.LookupTableBuilder.getLookupTableTypeCategory" t ;; (method)
           "autosar.mm.sl2mm.LookupTableBuilder.getModelMajorityLabel" t ;; (method)
           "autosar.mm.sl2mm.LookupTableBuilder.getSymbolicDimensionsForSharedAxis" t ;; (method)
           "autosar.mm.sl2mm.LookupTableBuilder.getTableValuesStructElementIndex" t ;; (method)
           "autosar.mm.sl2mm.LookupTableBuilder.hasFixAxisLookupTableDataInterface" t ;; (method)
           "autosar.mm.sl2mm.LookupTableBuilder.hasIndependentlyTunableBreakpoint" t ;; (method)
           "autosar.mm.sl2mm.LookupTableBuilder.hasValidLookupTableDataInterface" t ;; (method)
           "autosar.mm.sl2mm.LookupTableBuilder.isComAxisLookupTable" t ;; (method)
           "autosar.mm.sl2mm.M3IGarbageCollector" t ;; (class)
           "autosar.mm.sl2mm.M3IGarbageCollector.logger" t ;; (method)
           "autosar.mm.sl2mm.M3IGarbageCollector.removeUnreferencedDataTypes" t ;; (method)
           "autosar.mm.sl2mm.MemorySectionBuilder" t ;; (class)
           "autosar.mm.sl2mm.ModelBuilder" t ;; (class)
           "autosar.mm.sl2mm.ModelBuilder.createAppDataTypeNameDualScaled" t ;; (method)
           "autosar.mm.sl2mm.ModelBuilder.createInSequenceNamedItem" t ;; (method)
           "autosar.mm.sl2mm.ModelBuilder.createOrUpdateM3ILongName" t ;; (method)
           "autosar.mm.sl2mm.ModelBuilder.destroyDTMappingSetsWithInvalidRefs" t ;; (method)
           "autosar.mm.sl2mm.ModelBuilder.findAndDestroyPackage" t ;; (method)
           "autosar.mm.sl2mm.ModelBuilder.findClientBlockPortOpNames" t ;; (method)
           "autosar.mm.sl2mm.ModelBuilder.findInSequenceNamedItem" t ;; (method)
           "autosar.mm.sl2mm.ModelBuilder.findModeGroup" t ;; (method)
           "autosar.mm.sl2mm.ModelBuilder.findOrCreateInSequenceNamedItem" t ;; (method)
           "autosar.mm.sl2mm.ModelBuilder.getAutosarSubModelParameterImplementation" t ;; (method)
           "autosar.mm.sl2mm.ModelBuilder.getDataObjectForDSM" t ;; (method)
           "autosar.mm.sl2mm.ModelBuilder.getDataObjectForDSMorSynthesizedDS" t ;; (method)
           "autosar.mm.sl2mm.ModelBuilder.getDataObjectForSynthesizedDataStore" t ;; (method)
           "autosar.mm.sl2mm.ModelBuilder.getMdgDataFromEnum" t ;; (method)
           "autosar.mm.sl2mm.ModelBuilder.getNodePathAndName" t ;; (method)
           "autosar.mm.sl2mm.ModelBuilder.getRunnableNameFromSymbol" t ;; (method)
           "autosar.mm.sl2mm.ModelBuilder.getSLAppTypeAttributes" t ;; (method)
           "autosar.mm.sl2mm.ModelBuilder.getSwCalibrationAccessForDataObject" t ;; (method)
           "autosar.mm.sl2mm.ModelBuilder.i_get_isCompatibleCSCForDSM" t ;; (method)
           "autosar.mm.sl2mm.ModelBuilder.isAutosarMemorySection" t ;; (method)
           "autosar.mm.sl2mm.ModelBuilder.isDSMMappedToPIMOrStaticMemory" t ;; (method)
           "autosar.mm.sl2mm.ModelBuilder.isPromotedPerInstanceParameterFromSubmodel" t ;; (method)
           "autosar.mm.sl2mm.ModelBuilder.isValidParamForSubModel" t ;; (method)
           "autosar.mm.sl2mm.ModelBuilder.removeEmptyPackages" t ;; (method)
           "autosar.mm.sl2mm.ModelBuilder.setSLObjDescriptionForM3iData" t ;; (method)
           "autosar.mm.sl2mm.ModelBuilder.sortByGraphicalName" t ;; (method)
           "autosar.mm.sl2mm.NativeDeclarationBuilder" t ;; (class)
           "autosar.mm.sl2mm.NativeDeclarationBuilder.CIntegralNames" 'property
           "autosar.mm.sl2mm.NativeDeclarationBuilder.TargetNativeDefaults" 'property
           "autosar.mm.sl2mm.NativeDeclarationBuilder.TargetNativeProperties" 'property
           "autosar.mm.sl2mm.PerInstanceMemoryBuilder" t ;; (class)
           "autosar.mm.sl2mm.PlatformTypesDecorator" t ;; (class)
           "autosar.mm.sl2mm.PlatformTypesDecorator.hasLegacyTypeNames" t ;; (method)
           "autosar.mm.sl2mm.PlatformTypesDecorator.moveToPlatformTypesPackage" t ;; (method)
           "autosar.mm.sl2mm.PortAPIOptionBuilder" t ;; (class)
           "autosar.mm.sl2mm.PortAPIOptionBuilder.createOrUpdatePortAPIOption" t ;; (method)
           "autosar.mm.sl2mm.refmodel.CodeDescParamAdapter" t ;; (class)
           "autosar.mm.sl2mm.refmodel.CodeDescParamInfo" t ;; (class)
           "autosar.mm.sl2mm.SwRecordLayoutBuilder" t ;; (class)
           "autosar.mm.sl2mm.TypeBuilder" t ;; (class)
           "autosar.mm.sl2mm.TypeBuilder.findOrCreateModeDeclarationGroup" t ;; (method)
           "autosar.mm.sl2mm.TypeBuilder.getAUTOSARTypeNameForCoderType" t ;; (method)
           "autosar.mm.sl2mm.TypeBuilder.getMatrixBaseCodeType" t ;; (method)
           "autosar.mm.sl2mm.TypeBuilder.getStructElementCodeType" t ;; (method)
           "autosar.mm.sl2mm.TypeBuilder.updateNumericType" t ;; (method)
           "autosar.mm.sl2mm.TypeEquivalencyChecker" t ;; (class)
           "autosar.mm.sl2mm.TypeEquivalencyChecker.bothTypesAreNumeric" t ;; (method)
           "autosar.mm.sl2mm.TypeEquivalencyChecker.bothTypesAreSymbolic" t ;; (method)
           "autosar.mm.sl2mm.TypeEquivalencyChecker.normalizeDimensionExpression" t ;; (method)
           "autosar.mm.sl2mm.UnitBuilder" t ;; (class)
           "autosar.mm.sl2mm.utils.AutosarMemoryHelper" t ;; (class)
           "autosar.mm.sl2mm.utils.AutosarMemoryHelper.checkInternalDataShortNameCompliance" t ;; (method)
           "autosar.mm.sl2mm.utils.AutosarMemoryHelper.extractInformationFromMemoryExpr" t ;; (method)
           "autosar.mm.sl2mm.utils.AutosarMemoryHelper.getAutosarVariableInfo" t ;; (method)
           "autosar.mm.sl2mm.utils.AutosarMemoryHelper.getBlockBySID" t ;; (method)
           "autosar.mm.sl2mm.utils.AutosarMemoryHelper.getHandleForAutosarMemoryMapping" t ;; (method)
           "autosar.mm.sl2mm.utils.AutosarMemoryHelper.getSignalObjectForAutosarMemory" t ;; (method)
           "autosar.mm.sl2mm.utils.AutosarMemoryHelper.isAutosarMemoryVariable" t ;; (method)
           "autosar.mm.sl2mm.utils.AutosarMemorySignalPortHandleFinder" t ;; (class)
           "autosar.mm.sl2mm.utils.DaVinciLUT" t ;; (class)
           "autosar.mm.sl2mm.utils.DaVinciLUT.addExternalToolInfoToM3iImpType" t ;; (method)
           "autosar.mm.sl2mm.utils.DaVinciLUT.getLookupTableFieldNames" t ;; (method)
           "autosar.mm.sl2mm.utils.DaVinciLUT.isRowMajorLookupTable" t ;; (method)
           "autosar.mm.sl2mm.utils.DaVinciLUT.removeExternalToolInfoFromM3iImpType" t ;; (method)
           "autosar.mm.sl2mm.utils.ExclusiveAreasCleaner" t ;; (class)
           "autosar.mm.sl2mm.utils.init_value_name_for_datatype" t ;; (function)
           "autosar.mm.sl2mm.utils.invalid_value_name_for_datatype" t ;; (function)
           "autosar.mm.sl2mm.utils.M3iBuiltTypeNamesSet" t ;; (class)
           "autosar.mm.sl2mm.utils.TimingInterface" t ;; (class)
           "autosar.mm.sl2mm.variant.BindingTimeEnum" t ;; (class)
           "autosar.mm.sl2mm.variant.BindingTimeEnum.CodeGenerationTime" 'enumeration
           "autosar.mm.sl2mm.variant.BindingTimeEnum.getFromActivationTime" t ;; (method)
           "autosar.mm.sl2mm.variant.BindingTimeEnum.PostBuild" 'enumeration
           "autosar.mm.sl2mm.variant.BindingTimeEnum.PreCompileTime" 'enumeration
           "autosar.mm.sl2mm.variant.ConditionBuilder" t ;; (class)
           "autosar.mm.sl2mm.variant.ConditionBuilder.getConditionFromAnnotation" t ;; (method)
           "autosar.mm.sl2mm.variant.ConditionBuilder.simplifyConditionExpression" t ;; (method)
           "autosar.mm.sl2mm.variant.PostBuildVariantCriterionBuilder" t ;; (class)
           "autosar.mm.sl2mm.variant.PredefinedVariantBuilder" t ;; (class)
           "autosar.mm.sl2mm.variant.SystemConstantBuilder" t ;; (class)
           "autosar.mm.sl2mm.variant.Utils" t ;; (class)
           "autosar.mm.sl2mm.variant.Utils.addSymbolicDimensions" t ;; (method)
           "autosar.mm.sl2mm.variant.Utils.getDimensionsIdentifier" t ;; (method)
           "autosar.mm.sl2mm.variant.Utils.isMappedSystemConstant" t ;; (method)
           "autosar.mm.sl2mm.variant.Utils.isPostBuildVariantCriterion" t ;; (method)
           "autosar.mm.sl2mm.variant.Utils.isSimulinkVariantControlWithSysConValue" t ;; (method)
           "autosar.mm.sl2mm.variant.Utils.isSimulinkVariantVariableWithSysConSpec" t ;; (method)
           "autosar.mm.sl2mm.variant.Utils.isSlParamWithCSC" t ;; (method)
           "autosar.mm.sl2mm.variant.Utils.isSystemConstant" t ;; (method)
           "autosar.mm.sl2mm.variant.Utils.isValidCodeCompileParam" t ;; (method)
           "autosar.mm.sl2mm.variant.Utils.stripRtePrefix" t ;; (method)
           "autosar.mm.sl2mm.variant.VariantAnnotationsCache" t ;; (class)
           "autosar.mm.sl2mm.variant.VariantBuilder" t ;; (class)
           "autosar.mm.sl2mm.variant.VariationPoint" t ;; (class)
           "autosar.mm.sl2mm.variant.VariationPoint.attachPostBuildConditions" t ;; (method)
           "autosar.mm.sl2mm.variant.VariationPointCatalog" t ;; (class)
           "autosar.mm.util.ArgumentDirectionHelper" t ;; (class)
           "autosar.mm.util.ArgumentDirectionHelper.getValidDirectionsFor" t ;; (method)
           "autosar.mm.util.BiMap" t ;; (class)
           "autosar.mm.util.BuiltInTypeMapper" t ;; (class)
           "autosar.mm.util.BuiltInTypeMapper.convertToAutosarBuiltInTypeName" t ;; (method)
           "autosar.mm.util.BuiltInTypeMapper.getAdaptivePlatformTypeName" t ;; (method)
           "autosar.mm.util.BuiltInTypeMapper.getAR4PlatformTypeName" t ;; (method)
           "autosar.mm.util.BuiltInTypeMapper.getAUTOSARPlatformTypeName" t ;; (method)
           "autosar.mm.util.BuiltInTypeMapper.getAUTOSARPlatformTypeNames" t ;; (method)
           "autosar.mm.util.BuiltInTypeMapper.getClassicPlatformTypeNameForTypeReplacement" t ;; (method)
           "autosar.mm.util.BuiltInTypeMapper.getLegacyPlatformTypeName" t ;; (method)
           "autosar.mm.util.BuiltInTypeMapper.getRTWToPlatformTypeMap" t ;; (method)
           "autosar.mm.util.BuiltInTypeMapper.getRTWTypeName" t ;; (method)
           "autosar.mm.util.BuiltInTypeMapper.isARBuiltIn" t ;; (method)
           "autosar.mm.util.BuiltInTypeMapper.isAUTOSARPlatformType" t ;; (method)
           "autosar.mm.util.BuiltInTypeMapper.isEquivalent" t ;; (method)
           "autosar.mm.util.BuiltInTypeMapper.isFixPtTypeEquivalent" t ;; (method)
           "autosar.mm.util.BuiltInTypeMapper.isLegacyAUTOSARPlatformType" t ;; (method)
           "autosar.mm.util.BuiltInTypeMapper.isLegacyAUTOSARPlatformTypeName" t ;; (method)
           "autosar.mm.util.BuiltInTypeMapper.isMATLABTypeName" t ;; (method)
           "autosar.mm.util.BuiltInTypeMapper.isRTWBuiltIn" t ;; (method)
           "autosar.mm.util.BuiltInTypeMapper.RTWBuiltInNames" 'property
           "autosar.mm.util.checkAmbigousXmlOptions" t ;; (function)
           "autosar.mm.util.checkDataTypeCompuMethodCompatibility" t ;; (function)
           "autosar.mm.util.checkImplementationDataTypeCompatibility" t ;; (function)
           "autosar.mm.util.CodeDescriptorTypeVisitor" t ;; (class)
           "autosar.mm.util.compuMethodCategoryToString" t ;; (function)
           "autosar.mm.util.ConstantVisitor" t ;; (class)
           "autosar.mm.util.DefaultNamesHelper" t ;; (class)
           "autosar.mm.util.DefaultNamesHelper.getDefaultIBShortNameFromSwcName" t ;; (method)
           "autosar.mm.util.DescriptionHelper" t ;; (class)
           "autosar.mm.util.DescriptionHelper.createOrUpdateM3IDescription" t ;; (method)
           "autosar.mm.util.DescriptionHelper.createOrUpdateM3IDescriptionForM3iType" t ;; (method)
           "autosar.mm.util.DescriptionHelper.getDescriptionForPortBlock" t ;; (method)
           "autosar.mm.util.DescriptionHelper.getSLDescForEmbeddedObj" t ;; (method)
           "autosar.mm.util.DescriptionHelper.getSLDescFromM3IDesc" t ;; (method)
           "autosar.mm.util.DescriptionHelper.getSLDescFromM3IType" t ;; (method)
           "autosar.mm.util.DescriptionHelper.isDescriptionEquivalent" t ;; (method)
           "autosar.mm.util.Dimensions" t ;; (class)
           "autosar.mm.util.evaluateSystemConstantExpression" t ;; (function)
           "autosar.mm.util.ExternalToolInfoAdapter" t ;; (class)
           "autosar.mm.util.ExternalToolInfoAdapter.get" t ;; (method)
           "autosar.mm.util.ExternalToolInfoAdapter.getEnumPropertyValues" t ;; (method)
           "autosar.mm.util.ExternalToolInfoAdapter.getValidProperties" t ;; (method)
           "autosar.mm.util.ExternalToolInfoAdapter.isProperty" t ;; (method)
           "autosar.mm.util.ExternalToolInfoAdapter.set" t ;; (method)
           "autosar.mm.util.extractCondExpressionFromM3iCondAccess" t ;; (function)
           "autosar.mm.util.extractSwVerFromMdlVer" t ;; (function)
           "autosar.mm.util.extractSystemConstantExpressionFromM3I" t ;; (function)
           "autosar.mm.util.FcnCallerHelper" t ;; (class)
           "autosar.mm.util.FcnCallerHelper.createWorkspaceObjects" t ;; (method)
           "autosar.mm.util.FcnCallerHelper.getBlkType" t ;; (method)
           "autosar.mm.util.FcnCallerHelper.getDefaultFunctionName" t ;; (method)
           "autosar.mm.util.findAmbigousPkgElementNames" t ;; (function)
           "autosar.mm.util.findM3iDataElementFromPortParameterMapping" t ;; (function)
           "autosar.mm.util.FormulaExpression" t ;; (class)
           "autosar.mm.util.FormulaExpression.arxmlToMStyle" t ;; (method)
           "autosar.mm.util.FormulaExpression.createFromARXML" t ;; (method)
           "autosar.mm.util.FormulaExpression.transformFormulaExpression" t ;; (method)
           "autosar.mm.util.getBaseEnumName" t ;; (function)
           "autosar.mm.util.getCanBeInvokedConcurrentlyDiagnostic" t ;; (function)
           "autosar.mm.util.getCodeGenPropsFromAdaptiveDict" t ;; (function)
           "autosar.mm.util.getIsAutosarConstantMemory" t ;; (function)
           "autosar.mm.util.getIsAutosarConstantMemoryObject" t ;; (function)
           "autosar.mm.util.getIsAutosarStaticMemory" t ;; (function)
           "autosar.mm.util.getIsAutosarStaticMemoryObject" t ;; (function)
           "autosar.mm.util.getLiteralsFromTextTableCompuMethods" t ;; (function)
           "autosar.mm.util.getLookupTableMemberSwappedIndex" t ;; (function)
           "autosar.mm.util.getMethodInfoFromAdaptiveDict" t ;; (function)
           "autosar.mm.util.getPlatformKindIdFromSTF" t ;; (function)
           "autosar.mm.util.getScalingFromLinearCompuMethod" t ;; (function)
           "autosar.mm.util.getSLFcnCanBeInvokedConcurrently" t ;; (function)
           "autosar.mm.util.getStorageTypeForEnumOrMdg" t ;; (function)
           "autosar.mm.util.getStorageTypeFromImpDataType" t ;; (function)
           "autosar.mm.util.getValueFromGlobalScope" t ;; (function)
           "autosar.mm.util.getVariableRoleFromM3IData" t ;; (function)
           "autosar.mm.util.getVariantBlocks" t ;; (function)
           "autosar.mm.util.InstanceRefAdapter" t ;; (class)
           "autosar.mm.util.InstanceRefAdapter.getValidShortIds" t ;; (method)
           "autosar.mm.util.InstanceRefDeleter" t ;; (class)
           "autosar.mm.util.InstanceRefHelper" t ;; (class)
           "autosar.mm.util.InstanceRefHelper.getOrSetId" t ;; (method)
           "autosar.mm.util.InstanceRefVisitor" t ;; (class)
           "autosar.mm.util.InterfaceVisitor" t ;; (class)
           "autosar.mm.util.LiteralPrefixHelper" t ;; (class)
           "autosar.mm.util.LSTHelper" t ;; (class)
           "autosar.mm.util.LSTHelper.isModelUsingLST" t ;; (method)
           "autosar.mm.util.M3IModelMerger" t ;; (class)
           "autosar.mm.util.M3IModelMerger.merge" t ;; (method)
           "autosar.mm.util.M3ISequenceOrderer" t ;; (class)
           "autosar.mm.util.M3ISequenceOrderer.getElementNamesFromM3ISequence" t ;; (method)
           "autosar.mm.util.M3ISequenceOrderer.setM3ISequenceOrder" t ;; (method)
           "autosar.mm.util.M3ISequenceOrderer.swapNeighbourElementsInM3ISequence" t ;; (method)
           "autosar.mm.util.makeFileNameUnique" t ;; (function)
           "autosar.mm.util.Map" t ;; (class)
           "autosar.mm.util.mapSLDataType" t ;; (function)
           "autosar.mm.util.mapSLDataTypes" t ;; (function)
           "autosar.mm.util.Message" t ;; (class)
           "autosar.mm.util.MessageReporter" t ;; (class)
           "autosar.mm.util.MessageReporter.createWarning" t ;; (method)
           "autosar.mm.util.MessageReporter.hyperlinkFile" t ;; (method)
           "autosar.mm.util.MessageReporter.hyperlinkUri" t ;; (method)
           "autosar.mm.util.MessageReporter.print" t ;; (method)
           "autosar.mm.util.MessageReporter.select" t ;; (method)
           "autosar.mm.util.MessageReporter.show" t ;; (method)
           "autosar.mm.util.MessageReporter.suppressWarningTrace" t ;; (method)
           "autosar.mm.util.MessageReporter.throwException" t ;; (method)
           "autosar.mm.util.MessageStreamHandler" t ;; (class)
           "autosar.mm.util.MessageStreamHandler.initMessageStreamHandler" t ;; (method)
           "autosar.mm.util.MessageStreamHandler.instance" t ;; (method)
           "autosar.mm.util.MinMaxHelper" t ;; (class)
           "autosar.mm.util.MinMaxHelper.getLowerUpperLimitsForNumericType" t ;; (method)
           "autosar.mm.util.MinMaxHelper.getMetaclassLimitsFromM3IType" t ;; (method)
           "autosar.mm.util.MinMaxHelper.getMinMaxValuesFromM3iType" t ;; (method)
           "autosar.mm.util.MinMaxHelper.getNumericValue" t ;; (method)
           "autosar.mm.util.MinMaxHelper.isSLMinMaxEqualToM3iMinMax" t ;; (method)
           "autosar.mm.util.MinMaxHelper.needToUpdateMinMaxOfM3IAppType" t ;; (method)
           "autosar.mm.util.MinMaxHelper.resolveSLMinMaxToNumericValue" t ;; (method)
           "autosar.mm.util.MinMaxHelper.tolerantIsEqual" t ;; (method)
           "autosar.mm.util.NamespaceHelper" t ;; (class)
           "autosar.mm.util.NamespaceHelper.getCppStyleNamespaceFromCodeDescriptor" t ;; (method)
           "autosar.mm.util.NamespaceHelper.getCppStyleNamespaceFromM3I" t ;; (method)
           "autosar.mm.util.NamespaceHelper.getNamespacesFor" t ;; (method)
           "autosar.mm.util.NamespaceHelper.getNamespaceSymbolsFromCppStyleString" t ;; (method)
           "autosar.mm.util.NamespaceHelper.getNamespaceSymbolsFromM3IObj" t ;; (method)
           "autosar.mm.util.NamespaceHelper.getQualifiedTypeName" t ;; (method)
           "autosar.mm.util.NamespaceHelper.updateM3INamespaceFromCppStyleStr" t ;; (method)
           "autosar.mm.util.NvBlockNeedsCodePropsHelper" t ;; (class)
           "autosar.mm.util.NvBlockNeedsCodePropsHelper.convertNvBlockNeedFromLogicalToString" t ;; (method)
           "autosar.mm.util.NvBlockNeedsCodePropsHelper.convertNvBlockNeedFromStringToLogical" t ;; (method)
           "autosar.mm.util.NvBlockNeedsCodePropsHelper.createStructOfNvBlockNeeds" t ;; (method)
           "autosar.mm.util.NvBlockNeedsCodePropsHelper.getSupportedNvBlockNeedsAttributes" t ;; (method)
           "autosar.mm.util.NvBlockNeedsCodePropsHelper.updateNvBlockNeedCodeMappingArguments" t ;; (method)
           "autosar.mm.util.NvBlockNeedsCodePropsHelper.updateNvBlockNeedsFromCodeProperties" t ;; (method)
           "autosar.mm.util.PortToInterfaceNamespaceHelper" t ;; (class)
           "autosar.mm.util.PortToInterfaceNamespaceHelper.getInterfaceNamesAndNamespacesForPortNames" t ;; (method)
           "autosar.mm.util.PortToInterfaceNamespaceHelper.getMappedARServicePortNames" t ;; (method)
           "autosar.mm.util.QualifiedNameSequenceMerger" t ;; (class)
           "autosar.mm.util.removeEnumClassNamePrefix" t ;; (function)
           "autosar.mm.util.resolveM3ITypeDimensions" t ;; (function)
           "autosar.mm.util.resolveM3ITypeDimensionsFromModel" t ;; (function)
           "autosar.mm.util.SequenceMerger" t ;; (class)
           "autosar.mm.util.ServiceDiscoveryEnum" t ;; (class)
           "autosar.mm.util.ServiceDiscoveryEnum.DynamicDiscovery" 'enumeration
           "autosar.mm.util.ServiceDiscoveryEnum.OneTime" 'enumeration
           "autosar.mm.util.ServiceDiscoveryUtils" t ;; (class)
           "autosar.mm.util.ServiceDiscoveryUtils.getServiceDiscoveryModeForPortVec" t ;; (method)
           "autosar.mm.util.ServiceDiscoveryUtils.setServiceDiscoveryModeForUI" t ;; (method)
           "autosar.mm.util.ServiceDiscoveryUtils.validateServiceDiscoveryMode" t ;; (method)
           "autosar.mm.util.ServiceInterfaceUtils" t ;; (class)
           "autosar.mm.util.ServiceInterfaceUtils.getFunctionArgumentsFromM3IOperation" t ;; (method)
           "autosar.mm.util.Set" t ;; (class)
           "autosar.mm.util.setCompuMethodSlDataType" t ;; (function)
           "autosar.mm.util.SlAppTypeAttributes" t ;; (class)
           "autosar.mm.util.SlAppTypeAttributes.getAppTypeName" t ;; (method)
           "autosar.mm.util.SlAppTypeAttributesGetter" t ;; (class)
           "autosar.mm.util.SlAppTypeAttributesGetter.fromBlock" t ;; (method)
           "autosar.mm.util.SlAppTypeAttributesGetter.fromDataObj" t ;; (method)
           "autosar.mm.util.SlAppTypeAttributesGetter.fromDataObjOrItsType" t ;; (method)
           "autosar.mm.util.SlAppTypeAttributesGetter.fromDualScaledParameter" t ;; (method)
           "autosar.mm.util.SlAppTypeAttributesGetter.fromPort" t ;; (method)
           "autosar.mm.util.SwAddrMethodHelper" t ;; (class)
           "autosar.mm.util.SwAddrMethodHelper.findSwAddrMethodsForCategory" t ;; (method)
           "autosar.mm.util.SwAddrMethodHelper.findSwAddrMethodsForSubcomponent" t ;; (method)
           "autosar.mm.util.SwAddrMethodHelper.getAcceptedSectionTypesForCategory" t ;; (method)
           "autosar.mm.util.SwAddrMethodHelper.getSwAddrMethodCategoryFromM3IObject" t ;; (method)
           "autosar.mm.util.SwAddrMethodHelper.sectionTypeStrToValue" t ;; (method)
           "autosar.mm.util.SwAddrMethodHelper.updateSwAddrMethodsInMapping" t ;; (method)
           "autosar.mm.util.syncCalibrationProperties" t ;; (function)
           "autosar.mm.util.transformFormulaExpression" t ;; (function)
           "autosar.mm.util.TypeVisitor" t ;; (class)
           "autosar.mm.util.validate" t ;; (function)
           "autosar.mm.util.validateArg" t ;; (function)
           "autosar.mm.util.validateM3iArg" t ;; (function)
           "autosar.mm.util.validateModel" t ;; (function)
           "autosar.mm.util.XmlOption" t ;; (class)
           "autosar.mm.util.XmlOption.Double" 'property
           "autosar.mm.util.XmlOption.Enumeration" 'property
           "autosar.mm.util.XmlOption.Logical" 'property
           "autosar.mm.util.XmlOption.String" 'property
           "autosar.mm.util.XmlOption.verifyValidLogical" t ;; (method)
           "autosar.mm.util.XmlOption.verifyXmlOptionsFileName" t ;; (method)
           "autosar.mm.util.XmlOption.verifyXmlOptionsPackage" t ;; (method)
           "autosar.mm.util.XmlOption.verifyXmlOptionsQualifiedName" t ;; (method)
           "autosar.mm.util.XmlOptionsAdapter" t ;; (class)
           "autosar.mm.util.XmlOptionsAdapter.get" t ;; (method)
           "autosar.mm.util.XmlOptionsAdapter.getEnumPropertyValues" t ;; (method)
           "autosar.mm.util.XmlOptionsAdapter.getValidProperties" t ;; (method)
           "autosar.mm.util.XmlOptionsAdapter.getXmlOptionNamesForPackages" t ;; (method)
           "autosar.mm.util.XmlOptionsAdapter.isProperty" t ;; (method)
           "autosar.mm.util.XmlOptionsAdapter.isVisibleProperty" t ;; (method)
           "autosar.mm.util.XmlOptionsAdapter.set" t ;; (method)
           "autosar.mm.util.XmlOptionsAdapter.verify" t ;; (method)
           "autosar.mm.util.XmlOptionsDefaultFileNames" t ;; (class)
           "autosar.mm.util.XmlOptionsDefaultFileNames.Datatypes" 'property
           "autosar.mm.util.XmlOptionsDefaultPackages" t ;; (class)
           "autosar.mm.util.XmlOptionsDefaultPackages.AdaptivePlatformTypes" 'property
           "autosar.mm.util.XmlOptionsDefaultPackages.ApplicationDataTypes" 'property
           "autosar.mm.util.XmlOptionsDefaultPackages.ComponentsPackage" 'property
           "autosar.mm.util.XmlOptionsDefaultPackages.CompuMethods" 'property
           "autosar.mm.util.XmlOptionsDefaultPackages.ConstantSpecifications" 'property
           "autosar.mm.util.XmlOptionsDefaultPackages.DataConstrs" 'property
           "autosar.mm.util.XmlOptionsDefaultPackages.DataTypeMappingSets" 'property
           "autosar.mm.util.XmlOptionsDefaultPackages.DataTypesPackage" 'property
           "autosar.mm.util.XmlOptionsDefaultPackages.getImplementationQualifiedName" t ;; (method)
           "autosar.mm.util.XmlOptionsDefaultPackages.getXmlOptionsPackage" t ;; (method)
           "autosar.mm.util.XmlOptionsDefaultPackages.InterfacesPackage" 'property
           "autosar.mm.util.XmlOptionsDefaultPackages.ModeDeclarationGroups" 'property
           "autosar.mm.util.XmlOptionsDefaultPackages.PostBuildCriterions" 'property
           "autosar.mm.util.XmlOptionsDefaultPackages.setAllEmptyXmlOptionsToDefault" t ;; (method)
           "autosar.mm.util.XmlOptionsDefaultPackages.SwAddressMethods" 'property
           "autosar.mm.util.XmlOptionsDefaultPackages.SwBaseTypes" 'property
           "autosar.mm.util.XmlOptionsDefaultPackages.SwRecordLayouts" 'property
           "autosar.mm.util.XmlOptionsDefaultPackages.SystemConstants" 'property
           "autosar.mm.util.XmlOptionsDefaultPackages.SystemPackage" 'property
           "autosar.mm.util.XmlOptionsDefaultPackages.TimingPackage" 'property
           "autosar.mm.util.XmlOptionsDefaultPackages.Units" 'property
           "autosar.mm.util.XmlOptionsGetter" t ;; (class)
           "autosar.mm.util.XMLOptionsLookupTableUtils" t ;; (class)
           "autosar.mm.util.XMLOptionsLookupTableUtils.canExportLUTApplicationValueSpecification" t ;; (method)
           "autosar.mm.util.XMLOptionsPlatformTypesUtils" t ;; (class)
           "autosar.mm.util.XMLOptionsPlatformTypesUtils.inferImportedDefaults" t ;; (method)
           "autosar.mm.util.XMLOptionsPlatformTypesUtils.movePlatformDataTypes" t ;; (method)
           "autosar.mm.util.XMLOptionsPlatformTypesUtils.verifyXmlOptionsPackage" t ;; (method)
           "autosar.mm.util.XmlOptionsSetter" t ;; (class)
           "autosar.mm.util.XmlOptionsSetter.setCommonXmlOpts" t ;; (method)
           "autosar.mm.util.XmlOptionsSourceEnum" t ;; (class)
           "autosar.mm.util.XmlOptionsSourceEnum.Inherit" 'enumeration
           "autosar.mm.util.XmlOptionsSourceEnum.Inlined" 'enumeration
           "autosar.mm.util.XmlOptionVisibilityEnum" t ;; (class)
           "autosar.mm.util.XmlOptionVisibilityEnum.Adaptive" 'enumeration
           "autosar.mm.util.XmlOptionVisibilityEnum.AdaptiveComposition" 'enumeration
           "autosar.mm.util.XmlOptionVisibilityEnum.All" 'enumeration
           "autosar.mm.util.XmlOptionVisibilityEnum.Classic" 'enumeration
           "autosar.mm.util.XmlOptionVisibilityEnum.ClassicComposition" 'enumeration
           "AUTOSAR.Parameter" t ;; (class)
           "AUTOSAR.Parameter.Dimensions" 'property
           "AUTOSAR.PIMAttributes" t ;; (class)
           "autosar.routines.BlockUtils" t ;; (class)
           "autosar.routines.BlockUtils.findAllBlocksOfMaskType" t ;; (method)
           "autosar.routines.BlockUtils.replaceBlk" t ;; (method)
           "autosar.routines.BlockUtils.setBlkPortLabels" t ;; (method)
           "autosar.routines.BlockUtils.switchInportAndConstantBlks" t ;; (method)
           "autosar.routines.BlockUtils.validateCRLLibrary" t ;; (method)
           "autosar.routines.CrlCache" t ;; (class)
           "autosar.routines.CrlCache.getInstance" t ;; (method)
           "autosar.routines.efxmfl.Ramp" t ;; (class)
           "autosar.routines.efxmfl.Ramp.initialize" t ;; (method)
           "autosar.routines.efxmfl.Ramp.throwErrorForNegativeInputValue" t ;; (method)
           "autosar.routines.generator.AUTOSARCRLComponentGenerator" t ;; (class)
           "autosar.routines.generator.AUTOSARCRLComponentGenerator.BaseUnitTestFolder" 'property
           "autosar.routines.generator.AUTOSARCRLComponentGenerator.ComponentLocation" 'property
           "autosar.routines.generator.AUTOSARCRLComponentGenerator.ComponentName" 'property
           "autosar.routines.generator.AUTOSARCRLComponentGenerator.CrlTables" 'property
           "autosar.routines.generator.AUTOSARCRLComponentGenerator.ExpectedCRL" 'property
           "autosar.routines.generator.AUTOSARCRLComponentGenerator.ParamsFile" 'property
           "autosar.routines.generator.AUTOSARCRLComponentGenerator.ParamsFolder" 'property
           "autosar.routines.generator.AUTOSARCRLComponentGenerator.postProcess" t ;; (method)
           "autosar.routines.generator.AUTOSARCRLComponentGenerator.TestcasesFolder" 'property
           "autosar.routines.generator.buildCRLFunctionsParameters" t ;; (function)
           "autosar.routines.generator.ERTCRLLibraryBuilder" t ;; (class)
           "autosar.routines.generator.ERTCRLLibraryBuilder.Develop" 'property
           "autosar.routines.generator.ERTCRLLibraryBuilder.ParamsFolder" 'property
           "autosar.routines.generator.ERTCRLLibraryBuilder.TemplatesFolder" 'property
           "autosar.routines.generator.ERTCRLLibraryBuilder.TestcasesFolder" 'property
           "autosar.routines.generator.ERTCRLSourceCodeHandler" t ;; (class)
           "autosar.routines.generator.ERTCRLUtils" t ;; (class)
           "autosar.routines.generator.ERTCRLUtils.buildTargetedRoutineName" t ;; (method)
           "autosar.routines.generator.ERTCRLUtils.checkDataType" t ;; (method)
           "autosar.routines.generator.ERTCRLUtils.findArgumentIndex" t ;; (method)
           "autosar.routines.generator.ERTCRLUtils.getArgumentStructTypeString" t ;; (method)
           "autosar.routines.generator.ERTCRLUtils.getArgumentTypeString" t ;; (method)
           "autosar.routines.generator.ERTCRLUtils.validInputCombination" t ;; (method)
           "autosar.routines.ifxifl.Curve" t ;; (class)
           "autosar.routines.ifxifl.Curve.find" t ;; (method)
           "autosar.routines.ifxifl.Curve.getRoutineLib" t ;; (method)
           "autosar.routines.ifxifl.Curve.isConfiguredForIFL" t ;; (method)
           "autosar.routines.ifxifl.Curve.isConfiguredForIFX" t ;; (method)
           "autosar.routines.ifxifl.Curve.logErrorCallback" t ;; (method)
           "autosar.routines.ifxifl.Curve.resetErrorsCallback" t ;; (method)
           "autosar.routines.ifxifl.Curve.setupDataTypesCallback" t ;; (method)
           "autosar.routines.ifxifl.Curve.updateCallback" t ;; (method)
           "autosar.routines.ifxifl.Curve.updateMaskCallback" t ;; (method)
           "autosar.routines.ifxifl.CurveUsingPrelookup" t ;; (class)
           "autosar.routines.ifxifl.CurveUsingPrelookup.find" t ;; (method)
           "autosar.routines.ifxifl.CurveUsingPrelookup.getRoutineLib" t ;; (method)
           "autosar.routines.ifxifl.CurveUsingPrelookup.isConfiguredForIFL" t ;; (method)
           "autosar.routines.ifxifl.CurveUsingPrelookup.isConfiguredForIFX" t ;; (method)
           "autosar.routines.ifxifl.CurveUsingPrelookup.logErrorCallback" t ;; (method)
           "autosar.routines.ifxifl.CurveUsingPrelookup.resetErrorsCallback" t ;; (method)
           "autosar.routines.ifxifl.CurveUsingPrelookup.setupDataTypesCallback" t ;; (method)
           "autosar.routines.ifxifl.CurveUsingPrelookup.updateCallback" t ;; (method)
           "autosar.routines.ifxifl.CurveUsingPrelookup.updateMaskCallback" t ;; (method)
           "autosar.routines.ifxifl.IFXIFLMaskBuilder" t ;; (class)
           "autosar.routines.ifxifl.Map" t ;; (class)
           "autosar.routines.ifxifl.Map.find" t ;; (method)
           "autosar.routines.ifxifl.Map.getRoutineLib" t ;; (method)
           "autosar.routines.ifxifl.Map.isConfiguredForIFL" t ;; (method)
           "autosar.routines.ifxifl.Map.isConfiguredForIFX" t ;; (method)
           "autosar.routines.ifxifl.Map.logErrorCallback" t ;; (method)
           "autosar.routines.ifxifl.Map.resetErrorsCallback" t ;; (method)
           "autosar.routines.ifxifl.Map.setupDataTypesCallback" t ;; (method)
           "autosar.routines.ifxifl.Map.updateCallback" t ;; (method)
           "autosar.routines.ifxifl.Map.updateMaskCallback" t ;; (method)
           "autosar.routines.ifxifl.MapUsingPrelookup" t ;; (class)
           "autosar.routines.ifxifl.MapUsingPrelookup.find" t ;; (method)
           "autosar.routines.ifxifl.MapUsingPrelookup.getRoutineLib" t ;; (method)
           "autosar.routines.ifxifl.MapUsingPrelookup.isConfiguredForIFL" t ;; (method)
           "autosar.routines.ifxifl.MapUsingPrelookup.isConfiguredForIFX" t ;; (method)
           "autosar.routines.ifxifl.MapUsingPrelookup.logErrorCallback" t ;; (method)
           "autosar.routines.ifxifl.MapUsingPrelookup.resetErrorsCallback" t ;; (method)
           "autosar.routines.ifxifl.MapUsingPrelookup.setupDataTypesCallback" t ;; (method)
           "autosar.routines.ifxifl.MapUsingPrelookup.updateCallback" t ;; (method)
           "autosar.routines.ifxifl.MapUsingPrelookup.updateMaskCallback" t ;; (method)
           "autosar.routines.ifxifl.Prelookup" t ;; (class)
           "autosar.routines.ifxifl.Prelookup.find" t ;; (method)
           "autosar.routines.ifxifl.Prelookup.getRoutineLib" t ;; (method)
           "autosar.routines.ifxifl.Prelookup.isConfiguredForIFL" t ;; (method)
           "autosar.routines.ifxifl.Prelookup.isConfiguredForIFX" t ;; (method)
           "autosar.routines.ifxifl.Prelookup.logErrorCallback" t ;; (method)
           "autosar.routines.ifxifl.Prelookup.resetErrorsCallback" t ;; (method)
           "autosar.routines.ifxifl.Prelookup.setOutputTypes" t ;; (method)
           "autosar.routines.ifxifl.Prelookup.setupDataTypesCallback" t ;; (method)
           "autosar.routines.ifxifl.Prelookup.updateCallback" t ;; (method)
           "autosar.routines.ifxifl.Prelookup.updateIcon" t ;; (method)
           "autosar.routines.ifxifl.Prelookup.updateMaskCallback" t ;; (method)
           "autosar.routines.ifxifl.SinglePointInterpolate" t ;; (class)
           "autosar.routines.ifxifl.SinglePointInterpolate.initFcn" t ;; (method)
           "autosar.routines.ifxifl.SinglePointInterpolate.initialize" t ;; (method)
           "autosar.routines.ifxifl.Utils" t ;; (class)
           "autosar.routines.ifxifl.Utils.resolveValue" t ;; (method)
           "autosar.routines.mask.Curve" t ;; (class)
           "autosar.routines.mask.Curve.BreakpointsSpecification" t ;; (method)
           "autosar.routines.mask.Curve.DataSpecification" t ;; (method)
           "autosar.routines.mask.Curve.EditButton" t ;; (method)
           "autosar.routines.mask.Curve.IndexSearchMode" t ;; (method)
           "autosar.routines.mask.Curve.InterpMode" t ;; (method)
           "autosar.routines.mask.Curve.MaskInitialization" t ;; (method)
           "autosar.routines.mask.Curve.RndMode" t ;; (method)
           "autosar.routines.mask.Curve.TableDataTypeStr" t ;; (method)
           "autosar.routines.mask.Curve.TargetRoutineLibrary" t ;; (method)
           "autosar.routines.mask.CurveUsingPrelookup" t ;; (class)
           "autosar.routines.mask.CurveUsingPrelookup.EditButton" t ;; (method)
           "autosar.routines.mask.CurveUsingPrelookup.InterpMode" t ;; (method)
           "autosar.routines.mask.CurveUsingPrelookup.MaskInitialization" t ;; (method)
           "autosar.routines.mask.CurveUsingPrelookup.RndMode" t ;; (method)
           "autosar.routines.mask.CurveUsingPrelookup.TableDataTypeStr" t ;; (method)
           "autosar.routines.mask.CurveUsingPrelookup.TableSpecification" t ;; (method)
           "autosar.routines.mask.CurveUsingPrelookup.TargetRoutineLibrary" t ;; (method)
           "autosar.routines.mask.Map" t ;; (class)
           "autosar.routines.mask.Map.BreakpointsSpecification" t ;; (method)
           "autosar.routines.mask.Map.DataSpecification" t ;; (method)
           "autosar.routines.mask.Map.EditButton" t ;; (method)
           "autosar.routines.mask.Map.IndexSearchMode" t ;; (method)
           "autosar.routines.mask.Map.InterpMode" t ;; (method)
           "autosar.routines.mask.Map.MaskInitialization" t ;; (method)
           "autosar.routines.mask.Map.RndMode" t ;; (method)
           "autosar.routines.mask.Map.TableDataTypeStr" t ;; (method)
           "autosar.routines.mask.Map.TargetRoutineLibrary" t ;; (method)
           "autosar.routines.mask.MapUsingPrelookup" t ;; (class)
           "autosar.routines.mask.MapUsingPrelookup.EditButton" t ;; (method)
           "autosar.routines.mask.MapUsingPrelookup.InterpMode" t ;; (method)
           "autosar.routines.mask.MapUsingPrelookup.MaskInitialization" t ;; (method)
           "autosar.routines.mask.MapUsingPrelookup.RndMode" t ;; (method)
           "autosar.routines.mask.MapUsingPrelookup.TableDataTypeStr" t ;; (method)
           "autosar.routines.mask.MapUsingPrelookup.TableSpecification" t ;; (method)
           "autosar.routines.mask.MapUsingPrelookup.TargetRoutineLibrary" t ;; (method)
           "autosar.routines.mask.Prelookup" t ;; (class)
           "autosar.routines.mask.Prelookup.BPSpecification" t ;; (method)
           "autosar.routines.mask.Prelookup.IndexSearchMode" t ;; (method)
           "autosar.routines.mask.Prelookup.MaskInitialization" t ;; (method)
           "autosar.routines.mask.Prelookup.RndMode" t ;; (method)
           "autosar.routines.mask.Prelookup.TargetRoutineLibrary" t ;; (method)
           "autosar.routines.mask.SinglePointInterpolation" t ;; (class)
           "autosar.routines.mask.SinglePointInterpolation.MaskInitialization" t ;; (method)
           "autosar.routines.RoutineBlock" t ;; (class)
           "autosar.routines.RoutineBlock.find" t ;; (method)
           "autosar.routines.RoutineBlock.getRoutineLib" t ;; (method)
           "autosar.routines.RoutineBlock.isConfiguredForIFL" t ;; (method)
           "autosar.routines.RoutineBlock.isConfiguredForIFX" t ;; (method)
           "autosar.routines.RoutineBlock.logErrorCallback" t ;; (method)
           "autosar.routines.RoutineBlock.resetErrorsCallback" t ;; (method)
           "autosar.routines.RoutineBlock.setupDataTypesCallback" t ;; (method)
           "autosar.routines.RoutineBlock.updateCallback" t ;; (method)
           "autosar.routines.RoutineBlock.updateMaskCallback" t ;; (method)
           "autosar.routines.RoutineCallbacks" t ;; (class)
           "autosar.routines.RoutineCallbacks.applyFixit" t ;; (method)
           "autosar.routines.RoutineCallbacks.clearErrors" t ;; (method)
           "autosar.routines.RoutineCallbacks.disableParamIfParameterHasValue" t ;; (method)
           "autosar.routines.RoutineCallbacks.enableParamIfParameterHasValue" t ;; (method)
           "autosar.routines.RoutineCallbacks.hideDCIfParameterHasValue" t ;; (method)
           "autosar.routines.RoutineCallbacks.hideParamIfParameterHasValue" t ;; (method)
           "autosar.routines.RoutineCallbacks.propagateParam" t ;; (method)
           "autosar.routines.RoutineCallbacks.setDefaultDataTypes" t ;; (method)
           "autosar.routines.RoutineCallbacks.setFractionDataTypeStr" t ;; (method)
           "autosar.routines.RoutineCallbacks.setupDiagnosticModeParam" t ;; (method)
           "autosar.routines.RoutineCallbacks.showDCIfParameterHasValue" t ;; (method)
           "autosar.routines.RoutineCallbacks.showParamIfParameterHasValue" t ;; (method)
           "autosar.routines.RoutineCallbacks.updateBreakpointOptions" t ;; (method)
           "autosar.routines.RoutineCallbacks.updateDataTypeOptions" t ;; (method)
           "autosar.routines.RoutineCallbacks.updateIndexSearchOptions" t ;; (method)
           "autosar.routines.RoutineCallbacks.updateRoundModeWarning" t ;; (method)
           "autosar.serviceinterface.classic.getMappingType" t ;; (function)
           "autosar.serviceinterface.classic.mapping.AbstractAutosarMappingAdaptor" t ;; (class)
           "autosar.serviceinterface.classic.mapping.AutosarMappingAdaptor" t ;; (class)
           "autosar.serviceinterface.classic.mapping.ServiceInterfaceMappingAdaptor" t ;; (class)
           "autosar.serviceinterface.classic.mapping.syncMappings" t ;; (function)
           "autosar.serviceinterface.classic.MappingMigrator" t ;; (class)
           "autosar.serviceinterface.classic.migrateMapping" t ;; (function)
           "AUTOSAR.Signal" t ;; (class)
           "autosar.simulink.bep.AbstractBusElementPort" t ;; (class)
           "autosar.simulink.bep.AbstractBusElementPort.applyMapping" t ;; (method)
           "autosar.simulink.bep.AbstractBusElementPort.BusElementPortFactory" t ;; (method)
           "autosar.simulink.bep.AbstractBusElementPort.cacheBlockProperties" t ;; (method)
           "autosar.simulink.bep.AbstractBusElementPort.cachePortInfo" t ;; (method)
           "autosar.simulink.bep.AbstractBusElementPort.createDefaultMapping" t ;; (method)
           "autosar.simulink.bep.AbstractBusElementPort.extractNameValuePair" t ;; (method)
           "autosar.simulink.bep.AbstractBusElementPort.getMappedElementName" t ;; (method)
           "autosar.simulink.bep.AbstractBusElementPort.getMatchingMappingforBlk" t ;; (method)
           "autosar.simulink.bep.AbstractBusElementPort.isMessagePort" t ;; (method)
           "autosar.simulink.bep.AbstractBusElementPort.isQoSPort" t ;; (method)
           "autosar.simulink.bep.AbstractBusElementPort.restoreBlockProperties" t ;; (method)
           "autosar.simulink.bep.AbstractBusElementPort.restoreCachedPortInfo" t ;; (method)
           "autosar.simulink.bep.AbstractBusElementPort.setMessageQueueProperties" t ;; (method)
           "autosar.simulink.bep.AbstractBusElementPort.updateMappingForElementNameChange" t ;; (method)
           "autosar.simulink.bep.AbstractBusElementPort.updateMappingForPortNameChange" t ;; (method)
           "autosar.simulink.bep.AdaptiveBusElementPort" t ;; (class)
           "autosar.simulink.bep.AdaptiveBusElementPort.applyMapping" t ;; (method)
           "autosar.simulink.bep.AdaptiveBusElementPort.BusElementPortFactory" t ;; (method)
           "autosar.simulink.bep.AdaptiveBusElementPort.cacheBlockProperties" t ;; (method)
           "autosar.simulink.bep.AdaptiveBusElementPort.cachePortInfo" t ;; (method)
           "autosar.simulink.bep.AdaptiveBusElementPort.createDefaultMapping" t ;; (method)
           "autosar.simulink.bep.AdaptiveBusElementPort.extractNameValuePair" t ;; (method)
           "autosar.simulink.bep.AdaptiveBusElementPort.getMappedElementName" t ;; (method)
           "autosar.simulink.bep.AdaptiveBusElementPort.getMatchingMappingforBlk" t ;; (method)
           "autosar.simulink.bep.AdaptiveBusElementPort.isMessagePort" t ;; (method)
           "autosar.simulink.bep.AdaptiveBusElementPort.isQoSPort" t ;; (method)
           "autosar.simulink.bep.AdaptiveBusElementPort.restoreBlockProperties" t ;; (method)
           "autosar.simulink.bep.AdaptiveBusElementPort.restoreCachedPortInfo" t ;; (method)
           "autosar.simulink.bep.AdaptiveBusElementPort.setMessageQueueProperties" t ;; (method)
           "autosar.simulink.bep.AdaptiveBusElementPort.updateMappingForElementNameChange" t ;; (method)
           "autosar.simulink.bep.AdaptiveBusElementPort.updateMappingForPortNameChange" t ;; (method)
           "autosar.simulink.bep.BlockReplaceUtils" t ;; (class)
           "autosar.simulink.bep.BlockReplaceUtils.getBlkDataAndDeleteLines" t ;; (method)
           "autosar.simulink.bep.BlockReplaceUtils.restoreBlockData" t ;; (method)
           "autosar.simulink.bep.CallbackToggle" t ;; (class)
           "autosar.simulink.bep.ClassicBusElementPort" t ;; (class)
           "autosar.simulink.bep.ClassicBusElementPort.applyMapping" t ;; (method)
           "autosar.simulink.bep.ClassicBusElementPort.BusElementPortFactory" t ;; (method)
           "autosar.simulink.bep.ClassicBusElementPort.cacheBlockProperties" t ;; (method)
           "autosar.simulink.bep.ClassicBusElementPort.cachePortInfo" t ;; (method)
           "autosar.simulink.bep.ClassicBusElementPort.createDefaultMapping" t ;; (method)
           "autosar.simulink.bep.ClassicBusElementPort.extractNameValuePair" t ;; (method)
           "autosar.simulink.bep.ClassicBusElementPort.getMappedElementName" t ;; (method)
           "autosar.simulink.bep.ClassicBusElementPort.getMatchingMappingforBlk" t ;; (method)
           "autosar.simulink.bep.ClassicBusElementPort.getQueueCapacityString" t ;; (method)
           "autosar.simulink.bep.ClassicBusElementPort.isMessagePort" t ;; (method)
           "autosar.simulink.bep.ClassicBusElementPort.isQoSPort" t ;; (method)
           "autosar.simulink.bep.ClassicBusElementPort.restoreBlockProperties" t ;; (method)
           "autosar.simulink.bep.ClassicBusElementPort.restoreCachedPortInfo" t ;; (method)
           "autosar.simulink.bep.ClassicBusElementPort.setMessageQueueProperties" t ;; (method)
           "autosar.simulink.bep.ClassicBusElementPort.updateMappingForElementNameChange" t ;; (method)
           "autosar.simulink.bep.ClassicBusElementPort.updateMappingForPortNameChange" t ;; (method)
           "autosar.simulink.bep.Mapping" t ;; (class)
           "autosar.simulink.bep.Mapping.BEPCallbackToggle" 'property
           "autosar.simulink.bep.Mapping.blockCheckParamChange" t ;; (method)
           "autosar.simulink.bep.Mapping.dataElementNameChanged" t ;; (method)
           "autosar.simulink.bep.Mapping.portAdded" t ;; (method)
           "autosar.simulink.bep.Mapping.portHasValidDataPortMapping" t ;; (method)
           "autosar.simulink.bep.Mapping.portHasValidMapping" t ;; (method)
           "autosar.simulink.bep.Mapping.portNameChanged" t ;; (method)
           "autosar.simulink.bep.Mapping.syncBusPort" t ;; (method)
           "autosar.simulink.bep.Mapping.syncDictionary" t ;; (method)
           "autosar.simulink.bep.RefactorModelInterface" t ;; (class)
           "autosar.simulink.bep.RefactorModelInterface.canConvertSignalToBEPs" t ;; (method)
           "autosar.simulink.bep.RefactorModelInterface.canRefactorModelInterface" t ;; (method)
           "autosar.simulink.bep.RefactorModelInterface.canRefactorModelInterfaceBeforeLinking" t ;; (method)
           "autosar.simulink.bep.RefactorModelInterface.convertMappedBusPortsToSignalPorts" t ;; (method)
           "autosar.simulink.bep.RefactorModelInterface.convertPortUsingBlockMapping" t ;; (method)
           "autosar.simulink.bep.RefactorModelInterface.convertToBEPs" t ;; (method)
           "autosar.simulink.bep.RefactorModelInterface.exportToPreviousConverter" t ;; (method)
           "autosar.simulink.bep.RefactorModelInterface.exportToPreviousConverterForMessages" t ;; (method)
           "autosar.simulink.bep.RefactorModelInterface.getSortedPortMappings" t ;; (method)
           "autosar.simulink.bep.Utils" t ;; (class)
           "autosar.simulink.bep.Utils.addBusElement" t ;; (method)
           "autosar.simulink.bep.Utils.addPortBlock" t ;; (method)
           "autosar.simulink.bep.Utils.findBusElementPortsAtRoot" t ;; (method)
           "autosar.simulink.bep.Utils.getBusPortBlockTypeStr" t ;; (method)
           "autosar.simulink.bep.Utils.getElements" t ;; (method)
           "autosar.simulink.bep.Utils.getParam" t ;; (method)
           "autosar.simulink.bep.Utils.isBepModePort" t ;; (method)
           "autosar.simulink.bep.Utils.isBEPUsingBusObject" t ;; (method)
           "autosar.simulink.bep.Utils.isRootPort" t ;; (method)
           "autosar.simulink.bep.Utils.setParam" t ;; (method)
           "autosar.simulink.BlockFinder" t ;; (class)
           "autosar.simulink.BlockFinder.findBlocks" t ;; (method)
           "autosar.simulink.BlockFinder.findBlocksWithType" t ;; (method)
           "autosar.simulink.BlockFinder.findUniqueBlock" t ;; (method)
           "autosar.simulink.enum.createEnumBuilder" t ;; (function)
           "autosar.simulink.enum.EnumAbstractBuilder" t ;; (class)
           "autosar.simulink.enum.EnumDataDictionaryBuilder" t ;; (class)
           "autosar.simulink.enum.EnumDynamicMCOSBuilder" t ;; (class)
           "autosar.simulink.functionPorts.AdaptiveDictionarySyncer" t ;; (class)
           "autosar.simulink.functionPorts.AdaptiveDictionarySyncer.get" t ;; (method)
           "autosar.simulink.functionPorts.AdaptiveDictionarySyncer.getClientPortClass" t ;; (method)
           "autosar.simulink.functionPorts.AdaptiveDictionarySyncer.getClientPortSeq" t ;; (method)
           "autosar.simulink.functionPorts.AdaptiveDictionarySyncer.getInterfaceClass" t ;; (method)
           "autosar.simulink.functionPorts.AdaptiveDictionarySyncer.getServerPortClass" t ;; (method)
           "autosar.simulink.functionPorts.AdaptiveDictionarySyncer.getServerPortSeq" t ;; (method)
           "autosar.simulink.functionPorts.AdaptiveDictionarySyncer.getUsedClientPorts" t ;; (method)
           "autosar.simulink.functionPorts.AdaptiveDictionarySyncer.getUsedServerPorts" t ;; (method)
           "autosar.simulink.functionPorts.AdaptiveDictionarySyncer.isSupported" t ;; (method)
           "autosar.simulink.functionPorts.AdaptiveDictionarySyncer.populateM3iInterface" t ;; (method)
           "autosar.simulink.functionPorts.AdaptiveDictionarySyncer.ServiceInterfaceAutosarMetaClass" 'property
           "autosar.simulink.functionPorts.ClassicDictionarySyncer" t ;; (class)
           "autosar.simulink.functionPorts.ClassicDictionarySyncer.get" t ;; (method)
           "autosar.simulink.functionPorts.ClassicDictionarySyncer.getClientPortClass" t ;; (method)
           "autosar.simulink.functionPorts.ClassicDictionarySyncer.getClientPortSeq" t ;; (method)
           "autosar.simulink.functionPorts.ClassicDictionarySyncer.getInterfaceClass" t ;; (method)
           "autosar.simulink.functionPorts.ClassicDictionarySyncer.getServerPortClass" t ;; (method)
           "autosar.simulink.functionPorts.ClassicDictionarySyncer.getServerPortSeq" t ;; (method)
           "autosar.simulink.functionPorts.ClassicDictionarySyncer.getUsedClientPorts" t ;; (method)
           "autosar.simulink.functionPorts.ClassicDictionarySyncer.getUsedServerPorts" t ;; (method)
           "autosar.simulink.functionPorts.ClassicDictionarySyncer.isSupported" t ;; (method)
           "autosar.simulink.functionPorts.ClassicDictionarySyncer.populateM3iInterface" t ;; (method)
           "autosar.simulink.functionPorts.ClassicDictionarySyncer.ServiceInterfaceAutosarMetaClass" 'property
           "autosar.simulink.functionPorts.DictionarySyncer" t ;; (class)
           "autosar.simulink.functionPorts.DictionarySyncer.get" t ;; (method)
           "autosar.simulink.functionPorts.DictionarySyncer.getClientPortClass" t ;; (method)
           "autosar.simulink.functionPorts.DictionarySyncer.getClientPortSeq" t ;; (method)
           "autosar.simulink.functionPorts.DictionarySyncer.getInterfaceClass" t ;; (method)
           "autosar.simulink.functionPorts.DictionarySyncer.getServerPortClass" t ;; (method)
           "autosar.simulink.functionPorts.DictionarySyncer.getServerPortSeq" t ;; (method)
           "autosar.simulink.functionPorts.DictionarySyncer.getUsedClientPorts" t ;; (method)
           "autosar.simulink.functionPorts.DictionarySyncer.getUsedServerPorts" t ;; (method)
           "autosar.simulink.functionPorts.DictionarySyncer.isSupported" t ;; (method)
           "autosar.simulink.functionPorts.DictionarySyncer.populateM3iInterface" t ;; (method)
           "autosar.simulink.functionPorts.Mapping" t ;; (class)
           "autosar.simulink.functionPorts.Mapping.getMappingNameForPortScopedServerFcn" t ;; (method)
           "autosar.simulink.functionPorts.Mapping.getPortMapping" t ;; (method)
           "autosar.simulink.functionPorts.Mapping.m3iRunnableUsesFunctionPorts" t ;; (method)
           "autosar.simulink.functionPorts.Utils" t ;; (class)
           "autosar.simulink.functionPorts.Utils.escapeBrackets" t ;; (method)
           "autosar.simulink.functionPorts.Utils.findClientPorts" t ;; (method)
           "autosar.simulink.functionPorts.Utils.findServerPorts" t ;; (method)
           "autosar.simulink.functionPorts.Utils.getArgumentsFromFunctionPort" t ;; (method)
           "autosar.simulink.functionPorts.Utils.getBlocksLinkedToFcnPort" t ;; (method)
           "autosar.simulink.functionPorts.Utils.getPortAndMethodForBlock" t ;; (method)
           "autosar.simulink.functionPorts.Utils.isAsyncFunctionOrCaller" t ;; (method)
           "autosar.simulink.functionPorts.Utils.isClientServerPort" t ;; (method)
           "autosar.simulink.functionPorts.Utils.isModelWithPortScopedClientServerFunctions" t ;; (method)
           "autosar.simulink.msgTrigSS.Utils" t ;; (class)
           "autosar.simulink.msgTrigSS.Utils.findMessageTriggeredSubsystems" t ;; (method)
           "autosar.simulink.msgTrigSS.Utils.findOnMessageTriggeredSSBlks" t ;; (method)
           "autosar.simulink.msgTrigSS.Utils.isMessageTriggeredSS" t ;; (method)
           "autosar.slrealtime.migrateModel" t ;; (function)
           "autosar.slrealtime.ui.ExportToSLRTDialog" t ;; (class)
           "autosar.slrealtime.ui.ExportToSLRTDialog.launchDialog" t ;; (method)
           "autosar.studio.CompositionMenu" t ;; (function)
           "autosar.studio.CreateCompositionFromSelectionCB" t ;; (function)
           "autosar.system.sl2mm.EcuExtractBuilder" t ;; (class)
           "autosar.system.sl2mm.FlattenCompositionBuilder" t ;; (class)
           "autosar.system.sl2mm.FlattenCompositionBuilder.isFlat" t ;; (method)
           "autosar.system.Utils" t ;; (class)
           "autosar.system.Utils.findM3iSystemAmongstSystemsForM3iComp" t ;; (method)
           "autosar.timing.mm2sl.SwcViewBuilder" t ;; (class)
           "autosar.timing.mm2sl.SwcViewBuilder.hasExecutionOrderConstraints" t ;; (method)
           "autosar.timing.mm2sl.SwcViewBuilder.isViolatingRateMonotonicPolicy" t ;; (method)
           "autosar.timing.mm2sl.VfbViewBuilder" t ;; (class)
           "autosar.timing.mm2sl.VfbViewBuilder.findM3iVfbTimingAmongstTimingsForM3iComp" t ;; (method)
           "autosar.timing.mm2sl.VfbViewBuilder.hasExecutionOrderConstraints" t ;; (method)
           "autosar.timing.mm2sl.VfbViewBuilder.isViolatingRateMonotonicPolicy" t ;; (method)
           "autosar.timing.ScheduleEditorArch" t ;; (class)
           "autosar.timing.ScheduleEditorArch.almostEqual" t ;; (method)
           "autosar.timing.ScheduleEditorArch.isMultipleOf" t ;; (method)
           "autosar.timing.ScheduleEditorComponent" t ;; (class)
           "autosar.timing.sl2mm.SwcViewBuilder" t ;; (class)
           "autosar.timing.sl2mm.SwcViewBuilder.findM3iRunnableForRootSlEntryPointFunctionOfModel" t ;; (method)
           "autosar.timing.sl2mm.VfbViewBuilder" t ;; (class)
           "autosar.timing.Utils" t ;; (class)
           "autosar.timing.Utils.findM3iSwcTimings" t ;; (method)
           "autosar.timing.Utils.findM3iTimingAmongstTimingsForM3iComp" t ;; (method)
           "autosar.timing.Utils.findM3iTimingForM3iComponent" t ;; (method)
           "autosar.ui.app.base.Gui" t ;; (class)
           "autosar.ui.app.base.GuiBase" t ;; (class)
           "autosar.ui.app.base.OptionBase" t ;; (class)
           "autosar.ui.app.base.QuestionBase" t ;; (class)
           "autosar.ui.app.import.CompImportWizardBase" t ;; (class)
           "autosar.ui.app.import.CompImportWizardManager" t ;; (class)
           "autosar.ui.app.import.CompImportWizardManager.importWizard" t ;; (method)
           "autosar.ui.app.import.CompImportWizardManager.unregisterImportWizard" t ;; (method)
           "autosar.ui.app.import.ComponentImportWizard" t ;; (class)
           "autosar.ui.app.import.CompositionImportWizard" t ;; (class)
           "autosar.ui.app.import.CompositionUpdateWizard" t ;; (class)
           "autosar.ui.app.import.CompUpdateWizardManager" t ;; (class)
           "autosar.ui.app.import.CompUpdateWizardManager.unregisterUpdateWizard" t ;; (method)
           "autosar.ui.app.import.CompUpdateWizardManager.updateWizard" t ;; (method)
           "autosar.ui.app.link.ModelLinkingWizard" t ;; (class)
           "autosar.ui.app.link.ModelLinkingWizardBase" t ;; (class)
           "autosar.ui.app.link.ModelLinkingWizardManager" t ;; (class)
           "autosar.ui.app.link.ModelLinkingWizardManager.launchWizard" t ;; (method)
           "autosar.ui.app.link.ModelLinkingWizardManager.unregisterModelLinkingWizard" t ;; (method)
           "autosar.ui.app.option.Component_MapToComponent" t ;; (class)
           "autosar.ui.app.option.Component_Name" t ;; (class)
           "autosar.ui.app.option.Component_Pkg" t ;; (class)
           "autosar.ui.app.option.Component_RefFromComponentModel" t ;; (class)
           "autosar.ui.app.option.Component_Type" t ;; (class)
           "autosar.ui.app.option.ImportCompFromArxml_CompName" t ;; (class)
           "autosar.ui.app.option.ImportCompFromArxml_ComponentModels" t ;; (class)
           "autosar.ui.app.option.ImportCompFromArxml_DataDictionary" t ;; (class)
           "autosar.ui.app.option.ImportCompFromArxml_ExcludeInternalBehavior" t ;; (class)
           "autosar.ui.app.option.ImportCompFromArxml_FileSelect" t ;; (class)
           "autosar.ui.app.option.ImportCompFromArxml_InitializationRunnable" t ;; (class)
           "autosar.ui.app.option.ImportCompFromArxml_Modeling" t ;; (class)
           "autosar.ui.app.option.ImportCompFromArxml_ModelPeriodicRunnablesAs" t ;; (class)
           "autosar.ui.app.option.ImportCompFromArxml_PredefinedVariant" t ;; (class)
           "autosar.ui.app.option.ImportCompFromArxml_UseFunctionPorts" t ;; (class)
           "autosar.ui.app.option.Properties_Arxml" t ;; (class)
           "autosar.ui.app.option.Properties_Default" t ;; (class)
           "autosar.ui.app.option.Properties_Import" t ;; (class)
           "autosar.ui.app.option.SystemTargetFile_Adaptive" t ;; (class)
           "autosar.ui.app.option.SystemTargetFile_Classic" t ;; (class)
           "autosar.ui.app.question.Component" t ;; (class)
           "autosar.ui.app.question.CreateCompInSimulink" t ;; (class)
           "autosar.ui.app.question.Finish" t ;; (class)
           "autosar.ui.app.question.ImportCompFromArxml" t ;; (class)
           "autosar.ui.app.question.Properties" t ;; (class)
           "autosar.ui.app.question.SystemTargetFile" t ;; (class)
           "autosar.ui.app.question.ValidateModel" t ;; (class)
           "autosar.ui.app.question.ValidateModel.loc_getInitAnalysisTable" t ;; (method)
           "autosar.ui.app.quickstart.Wizard" t ;; (class)
           "autosar.ui.app.quickstart.WizardManager" t ;; (class)
           "autosar.ui.app.quickstart.WizardManager.unregisterQuickStartWizard" t ;; (method)
           "autosar.ui.app.quickstart.WizardManager.wizard" t ;; (method)
           "autosar.ui.bsw.ClientPort" t ;; (class)
           "autosar.ui.bsw.Fault" t ;; (class)
           "autosar.ui.bsw.Fault.create" t ;; (method)
           "autosar.ui.bsw.Fault.triggerTypeOptions" 'property
           "autosar.ui.bsw.FaultSpreadsheet" t ;; (class)
           "autosar.ui.bsw.FaultSpreadsheet.addFault" t ;; (method)
           "autosar.ui.bsw.FaultSpreadsheet.faultInjectOptions" 'property
           "autosar.ui.bsw.FaultSpreadsheet.isAddButtonEnabled" t ;; (method)
           "autosar.ui.bsw.FaultSpreadsheet.isRemoveButtonEnabled" t ;; (method)
           "autosar.ui.bsw.FaultSpreadsheet.onItemClicked" t ;; (method)
           "autosar.ui.bsw.FaultSpreadsheet.removeFault" t ;; (method)
           "autosar.ui.bsw.FaultSpreadsheet.setFaultInjectType" t ;; (method)
           "autosar.ui.bsw.FaultSpreadsheet.setFaultOverrideBit" t ;; (method)
           "autosar.ui.bsw.FaultSpreadsheet.setFaultStartTime" t ;; (method)
           "autosar.ui.bsw.FaultSpreadsheet.setFaultTriggerType" t ;; (method)
           "autosar.ui.bsw.FaultSpreadsheetInnerRow" t ;; (class)
           "autosar.ui.bsw.FaultSpreadsheetInnerRow.NameColumn" 'property
           "autosar.ui.bsw.FaultSpreadsheetInnerRow.TypeColumn" 'property
           "autosar.ui.bsw.FaultSpreadsheetRow" t ;; (class)
           "autosar.ui.bsw.FaultSpreadsheetRow.EventIdColumn" 'property
           "autosar.ui.bsw.FaultTab" t ;; (class)
           "autosar.ui.bsw.FaultTab.getTab" t ;; (method)
           "autosar.ui.bsw.FaultTab.tag" 'property
           "autosar.ui.bsw.FidMask" t ;; (class)
           "autosar.ui.bsw.FidMask.stringToVal" t ;; (method)
           "autosar.ui.bsw.FidMask.valToString" t ;; (method)
           "autosar.ui.bsw.FiMMatrixSpreadsheet" t ;; (class)
           "autosar.ui.bsw.FiMMatrixSpreadsheet.addInhibitionCondition" t ;; (method)
           "autosar.ui.bsw.FiMMatrixSpreadsheet.isAddButtonEnabled" t ;; (method)
           "autosar.ui.bsw.FiMMatrixSpreadsheet.isRemoveButtonEnabled" t ;; (method)
           "autosar.ui.bsw.FiMMatrixSpreadsheet.removeInhibitionCondition" t ;; (method)
           "autosar.ui.bsw.FiMMatrixSpreadsheetInnerRow" t ;; (class)
           "autosar.ui.bsw.FiMMatrixSpreadsheetInnerRow.EventIdColumn" 'property
           "autosar.ui.bsw.FiMMatrixSpreadsheetInnerRow.IdColumn" 'property
           "autosar.ui.bsw.FiMMatrixSpreadsheetInnerRow.MaskColumn" 'property
           "autosar.ui.bsw.FiMMatrixSpreadsheetRow" t ;; (class)
           "autosar.ui.bsw.FiMMatrixSpreadsheetRow.FIDColumn" 'property
           "autosar.ui.bsw.FimTab" t ;; (class)
           "autosar.ui.bsw.FimTab.getTab" t ;; (method)
           "autosar.ui.bsw.FimTab.tag" 'property
           "autosar.ui.bsw.MainTab" t ;; (class)
           "autosar.ui.bsw.MainTab.getTab" t ;; (method)
           "autosar.ui.bsw.MainTab.tag" 'property
           "autosar.ui.bsw.NvMInitValSpreadsheet" t ;; (class)
           "autosar.ui.bsw.NvMInitValSpreadsheetRow" t ;; (class)
           "autosar.ui.bsw.NvMInitValSpreadsheetRow.IdColumn" 'property
           "autosar.ui.bsw.NvMInitValSpreadsheetRow.InitValColumn" 'property
           "autosar.ui.bsw.NvMInitValSpreadsheetRow.NvBlockPortsColumn" 'property
           "autosar.ui.bsw.NvMTab" t ;; (class)
           "autosar.ui.bsw.NvMTab.getTab" t ;; (method)
           "autosar.ui.bsw.NvMTab.tag" 'property
           "autosar.ui.bsw.PortConfigTab" t ;; (class)
           "autosar.ui.bsw.PortConfigTab.getTab" t ;; (method)
           "autosar.ui.bsw.PortConfigTab.tag" 'property
           "autosar.ui.bsw.ServiceComponentListener" t ;; (class)
           "autosar.ui.bsw.ServiceComponentListener.updateDiagnosticServiceComponentUI" t ;; (method)
           "autosar.ui.bsw.ServiceComponentListener.updateNVRAMServiceComponentUI" t ;; (method)
           "autosar.ui.bsw.ServiceComponentSpreadsheet" t ;; (class)
           "autosar.ui.bsw.ServiceComponentSpreadsheetRow" t ;; (class)
           "autosar.ui.bsw.ServiceComponentSpreadsheetRow.BlockIdColumn" 'property
           "autosar.ui.bsw.ServiceComponentSpreadsheetRow.ClientPortColumn" 'property
           "autosar.ui.bsw.ServiceComponentSpreadsheetRow.IdColumn" 'property
           "autosar.ui.bsw.ServiceComponentSpreadsheetRow.IdTypeColumn" 'property
           "autosar.ui.bsw.Spreadsheet" t ;; (class)
           "autosar.ui.bsw.SpreadsheetBase" t ;; (class)
           "autosar.ui.bsw.SpreadsheetRow" t ;; (class)
           "autosar.ui.bsw.Tab" t ;; (class)
           "autosar.ui.codemapping.PortCalibrationAttributeHandler" t ;; (class)
           "autosar.ui.codemapping.PortCalibrationAttributeHandler.getCalibrationAttributeValueForPropertyInspector" t ;; (method)
           "autosar.ui.codemapping.PortCalibrationAttributeHandler.getLongNameValueFromMultiLanguageLongName" t ;; (method)
           "autosar.ui.codemapping.PortCalibrationAttributeHandler.getParentM3iObjFromLLongName" t ;; (method)
           "autosar.ui.codemapping.PortCalibrationAttributeHandler.getSupportedPortCalibrationAttributes" t ;; (method)
           "autosar.ui.codemapping.PortCalibrationAttributeHandler.getValidCalibrationAttributesForPort" t ;; (method)
           "autosar.ui.codemapping.PortCalibrationAttributeHandler.setCalibrationAttributeValueForPropertyInspector" t ;; (method)
           "autosar.ui.codemapping.PortCalibrationAttributeHandler.SupportedPortCalibrationAttributes" 'property
           "autosar.ui.comspec.ComSpecPropertyHandler" t ;; (class)
           "autosar.ui.comspec.ComSpecPropertyHandler.buildSlInitValueFromMetaModel" t ;; (method)
           "autosar.ui.comspec.ComSpecPropertyHandler.checkComSpecPropertyValue" t ;; (method)
           "autosar.ui.comspec.ComSpecPropertyHandler.convertPropertyValueFromUI" t ;; (method)
           "autosar.ui.comspec.ComSpecPropertyHandler.convertValueExpressionToScalarValueString" t ;; (method)
           "autosar.ui.comspec.ComSpecPropertyHandler.convertValueStrToValue" t ;; (method)
           "autosar.ui.comspec.ComSpecPropertyHandler.convertValueToString" t ;; (method)
           "autosar.ui.comspec.ComSpecPropertyHandler.createDefaultInitValuesForUnspecifiedFields" t ;; (method)
           "autosar.ui.comspec.ComSpecPropertyHandler.DefaultAliveTimeout" 'property
           "autosar.ui.comspec.ComSpecPropertyHandler.DefaultHandleNeverReceived" 'property
           "autosar.ui.comspec.ComSpecPropertyHandler.DefaultInitValue" 'property
           "autosar.ui.comspec.ComSpecPropertyHandler.DefaultQueueLength" 'property
           "autosar.ui.comspec.ComSpecPropertyHandler.evaluateInitValueExpression" t ;; (method)
           "autosar.ui.comspec.ComSpecPropertyHandler.getComSpecDefaultPropertyValue" t ;; (method)
           "autosar.ui.comspec.ComSpecPropertyHandler.getComSpecDefaultPropertyValueStr" t ;; (method)
           "autosar.ui.comspec.ComSpecPropertyHandler.getComSpecPropertyAllowedValues" t ;; (method)
           "autosar.ui.comspec.ComSpecPropertyHandler.getComSpecPropertyDataType" t ;; (method)
           "autosar.ui.comspec.ComSpecPropertyHandler.getComSpecPropertyValue" t ;; (method)
           "autosar.ui.comspec.ComSpecPropertyHandler.getComSpecPropertyValueForPropertyInspector" t ;; (method)
           "autosar.ui.comspec.ComSpecPropertyHandler.getComSpecPropertyValueStr" t ;; (method)
           "autosar.ui.comspec.ComSpecPropertyHandler.getInitValueFromExternalToolInfo" t ;; (method)
           "autosar.ui.comspec.ComSpecPropertyHandler.getM3iTypeFromDataElement" t ;; (method)
           "autosar.ui.comspec.ComSpecPropertyHandler.getSupportedComSpecProperties" t ;; (method)
           "autosar.ui.comspec.ComSpecPropertyHandler.getUserInputInitValue" t ;; (method)
           "autosar.ui.comspec.ComSpecPropertyHandler.getValidComSpecPropertiesForPort" t ;; (method)
           "autosar.ui.comspec.ComSpecPropertyHandler.getValidComSpecPropertiesFromDAM" t ;; (method)
           "autosar.ui.comspec.ComSpecPropertyHandler.setComSpecPropertyValue" t ;; (method)
           "autosar.ui.comspec.ComSpecPropertyHandler.setComSpecPropertyValueForPropertyInspector" t ;; (method)
           "autosar.ui.comspec.ComSpecPropertyHandler.setInitValue" t ;; (method)
           "autosar.ui.comspec.ComSpecPropertyHandler.SupportedComSpecProperties" 'property
           "autosar.ui.comspec.ComSpecUtils" t ;; (class)
           "autosar.ui.comspec.ComSpecUtils.findM3IPortByName" t ;; (method)
           "autosar.ui.comspec.ComSpecUtils.findM3IPortInfoForDataElement" t ;; (method)
           "autosar.ui.comspec.ComSpecUtils.findOrCreateParamComponentComSpec" t ;; (method)
           "autosar.ui.comspec.ComSpecUtils.getM3IComSpec" t ;; (method)
           "autosar.ui.comspec.getDlgSchema" t ;; (function)
           "autosar.ui.comspec.Spreadsheet" t ;; (class)
           "autosar.ui.comspec.SpreadsheetRow" t ;; (class)
           "autosar.ui.configuration.NamespaceString" t ;; (class)
           "autosar.ui.configuration.NamespaceString.ActiveMapping" 'property
           "autosar.ui.configuration.NamespaceString.AdaptiveEntryPointFunctionsPropertyNames" 'property
           "autosar.ui.configuration.NamespaceString.AdaptiveFunctionCallerPropertyNames" 'property
           "autosar.ui.configuration.NamespaceString.AdaptivePortPropertyNames" 'property
           "autosar.ui.configuration.NamespaceString.ArgumentData" 'property
           "autosar.ui.configuration.NamespaceString.ARParameterClass" 'property
           "autosar.ui.configuration.NamespaceString.ClientPortNameProperty" 'property
           "autosar.ui.configuration.NamespaceString.ClientPortOpProperty" 'property
           "autosar.ui.configuration.NamespaceString.ComponentClass" 'property
           "autosar.ui.configuration.NamespaceString.Components" 'property
           "autosar.ui.configuration.NamespaceString.DataElement" 'property
           "autosar.ui.configuration.NamespaceString.DataTransfer" 'property
           "autosar.ui.configuration.NamespaceString.DataTransferClass" 'property
           "autosar.ui.configuration.NamespaceString.DataTransferMapClass" 'property
           "autosar.ui.configuration.NamespaceString.DataTransferProperty" 'property
           "autosar.ui.configuration.NamespaceString.DefaultNode" 'property
           "autosar.ui.configuration.NamespaceString.Element" 'property
           "autosar.ui.configuration.NamespaceString.EntryPointFcns" 'property
           "autosar.ui.configuration.NamespaceString.EntryPointMapClass" 'property
           "autosar.ui.configuration.NamespaceString.ErrIconMap" 'property
           "autosar.ui.configuration.NamespaceString.Events" 'property
           "autosar.ui.configuration.NamespaceString.ExportedFuncPrefix" 'property
           "autosar.ui.configuration.NamespaceString.FcnCallInports" 'property
           "autosar.ui.configuration.NamespaceString.FcnCallInportsProperty" 'property
           "autosar.ui.configuration.NamespaceString.FieldData" 'property
           "autosar.ui.configuration.NamespaceString.FunctionCallers" 'property
           "autosar.ui.configuration.NamespaceString.FunctionCallersProperty" 'property
           "autosar.ui.configuration.NamespaceString.FunctionInports" 'property
           "autosar.ui.configuration.NamespaceString.FunctionOutports" 'property
           "autosar.ui.configuration.NamespaceString.Handle" 'property
           "autosar.ui.configuration.NamespaceString.IconMap" 'property
           "autosar.ui.configuration.NamespaceString.IdentifierProperty" 'property
           "autosar.ui.configuration.NamespaceString.Initialization" 'property
           "autosar.ui.configuration.NamespaceString.InitProperty" 'property
           "autosar.ui.configuration.NamespaceString.Inports" 'property
           "autosar.ui.configuration.NamespaceString.Interfaces" 'property
           "autosar.ui.configuration.NamespaceString.InternalDataObjWithSwAddrMethods" 'property
           "autosar.ui.configuration.NamespaceString.IRV" 'property
           "autosar.ui.configuration.NamespaceString.IrvAccess" 'property
           "autosar.ui.configuration.NamespaceString.IrvAccessModeProperty" 'property
           "autosar.ui.configuration.NamespaceString.IrvNameProperty" 'property
           "autosar.ui.configuration.NamespaceString.LookupTableMapClass" 'property
           "autosar.ui.configuration.NamespaceString.LookupTables" 'property
           "autosar.ui.configuration.NamespaceString.LookupTablesProperty" 'property
           "autosar.ui.configuration.NamespaceString.MapModel" 'property
           "autosar.ui.configuration.NamespaceString.mappingAccLabel" 'property
           "autosar.ui.configuration.NamespaceString.mappingAccName" 'property
           "autosar.ui.configuration.NamespaceString.MappingLink" 'property
           "autosar.ui.configuration.NamespaceString.MappingObjWithRunnables" 'property
           "autosar.ui.configuration.NamespaceString.MapRootName" 'property
           "autosar.ui.configuration.NamespaceString.Model" 'property
           "autosar.ui.configuration.NamespaceString.ModelMapClass" 'property
           "autosar.ui.configuration.NamespaceString.Name" 'property
           "autosar.ui.configuration.NamespaceString.NoMetaModelMsg" 'property
           "autosar.ui.configuration.NamespaceString.NoMetaModelOption1" 'property
           "autosar.ui.configuration.NamespaceString.NoMetaModelOption2" 'property
           "autosar.ui.configuration.NamespaceString.Operation" 'property
           "autosar.ui.configuration.NamespaceString.OutportIdentifier" 'property
           "autosar.ui.configuration.NamespaceString.Outports" 'property
           "autosar.ui.configuration.NamespaceString.ParameterAccessMode" 'property
           "autosar.ui.configuration.NamespaceString.ParameterClass" 'property
           "autosar.ui.configuration.NamespaceString.ParameterData" 'property
           "autosar.ui.configuration.NamespaceString.PeriodicBlock" 'property
           "autosar.ui.configuration.NamespaceString.PersistencyData" 'property
           "autosar.ui.configuration.NamespaceString.Port" 'property
           "autosar.ui.configuration.NamespaceString.PortElementClass" 'property
           "autosar.ui.configuration.NamespaceString.PortMapClass" 'property
           "autosar.ui.configuration.NamespaceString.PortOperationClass" 'property
           "autosar.ui.configuration.NamespaceString.Ports" 'property
           "autosar.ui.configuration.NamespaceString.PrefixAutosar" 'property
           "autosar.ui.configuration.NamespaceString.QuestionDlgTitle" 'property
           "autosar.ui.configuration.NamespaceString.RateTransitionProperty" 'property
           "autosar.ui.configuration.NamespaceString.ReceiverDataAccess" 'property
           "autosar.ui.configuration.NamespaceString.ResetFunction" 'property
           "autosar.ui.configuration.NamespaceString.ResetProperty" 'property
           "autosar.ui.configuration.NamespaceString.RunnableClass" 'property
           "autosar.ui.configuration.NamespaceString.RunnableProperty" 'property
           "autosar.ui.configuration.NamespaceString.Runnables" 'property
           "autosar.ui.configuration.NamespaceString.SelectOption" 'property
           "autosar.ui.configuration.NamespaceString.SenderDataAccess" 'property
           "autosar.ui.configuration.NamespaceString.ServerFunctionsProperty" 'property
           "autosar.ui.configuration.NamespaceString.StepNodeName" 'property
           "autosar.ui.configuration.NamespaceString.StepNodeSampleTime" 'property
           "autosar.ui.configuration.NamespaceString.StepsProperty" 'property
           "autosar.ui.configuration.NamespaceString.SymbolProps" 'property
           "autosar.ui.configuration.NamespaceString.SyncButtonStr" 'property
           "autosar.ui.configuration.NamespaceString.targetAccLabel" 'property
           "autosar.ui.configuration.NamespaceString.targetAccName" 'property
           "autosar.ui.configuration.NamespaceString.TerminateProperty" 'property
           "autosar.ui.configuration.NamespaceString.Termination" 'property
           "autosar.ui.configuration.NamespaceString.TipHelp" 'property
           "autosar.ui.configuration.NamespaceString.TipMap" 'property
           "autosar.ui.configuration.NamespaceString.TipViewName" 'property
           "autosar.ui.configuration.NamespaceString.Title" 'property
           "autosar.ui.configuration.NamespaceString.Triggers" 'property
           "autosar.ui.configuration.NamespaceString.UITitle" 'property
           "autosar.ui.configuration.NamespaceString.ValAutosar" 'property
           "autosar.ui.configuration.NamespaceString.ValidateButtonStr" 'property
           "autosar.ui.configuration.NamespaceString.ValidatePartialSucceed" 'property
           "autosar.ui.configuration.NamespaceString.ValidateSucceed" 'property
           "autosar.ui.configuration.NamespaceString.ValidInitValue" 'property
           "autosar.ui.configuration.NamespaceString.ValModel" 'property
           "autosar.ui.configuration.NamespaceString.VariableData" 'property
           "autosar.ui.configuration.NamespaceString.WaitMsg" 'property
           "autosar.ui.Explorer" t ;; (class)
           "autosar.ui.ExplorerManager" t ;; (class)
           "autosar.ui.ExplorerManager.areAnyExplorersOpen" t ;; (method)
           "autosar.ui.ExplorerManager.closeExplorerForSharedAUTOSARDictionary" t ;; (method)
           "autosar.ui.ExplorerManager.closeExplorerUIForIndex" t ;; (method)
           "autosar.ui.ExplorerManager.closeExplorerUIForModel" t ;; (method)
           "autosar.ui.ExplorerManager.getExplorerForM3IModel" t ;; (method)
           "autosar.ui.ExplorerManager.getExplorerForModel" t ;; (method)
           "autosar.ui.ExplorerManager.getExplorerForSharedAUTOSARDictionary" t ;; (method)
           "autosar.ui.ExplorerManager.getExplorerForTitle" t ;; (method)
           "autosar.ui.ExplorerManager.launchNewExplorer" t ;; (method)
           "autosar.ui.manifest.applyManifestProperties" t ;; (function)
           "autosar.ui.manifest.getDlgSchema" t ;; (function)
           "autosar.ui.metamodel.CompuMethod" t ;; (class)
           "autosar.ui.metamodel.CompuMethod.getBottomUpSupportedCategories" t ;; (method)
           "autosar.ui.metamodel.Event" t ;; (class)
           "autosar.ui.metamodel.M3INode" t ;; (class)
           "autosar.ui.metamodel.M3INode.isUINodeReadOnly" t ;; (method)
           "autosar.ui.metamodel.M3ITerminalNode" t ;; (class)
           "autosar.ui.metamodel.M3IToGUIMappingUtil" t ;; (class)
           "autosar.ui.metamodel.M3IToGUIMappingUtil.findDictionaryNodeFromRoot" t ;; (method)
           "autosar.ui.metamodel.M3IToGUIMappingUtil.findMCOSObjInTree" t ;; (method)
           "autosar.ui.metamodel.M3IToGUIMappingUtil.findParentMCOSObjInTree" t ;; (method)
           "autosar.ui.metamodel.NamespaceString" t ;; (class)
           "autosar.ui.metamodel.NamespaceString.AdaptiveApplicationsNodeName" 'property
           "autosar.ui.metamodel.NamespaceString.AddIcon" 'property
           "autosar.ui.metamodel.NamespaceString.AddStr" 'property
           "autosar.ui.metamodel.NamespaceString.ApplicationComponent" 'property
           "autosar.ui.metamodel.NamespaceString.argumentsNode" 'property
           "autosar.ui.metamodel.NamespaceString.ArgumentSwAddrMethodSectionTypes" 'property
           "autosar.ui.metamodel.NamespaceString.AtomicComponentsNodeName" 'property
           "autosar.ui.metamodel.NamespaceString.AutosarRootClass" 'property
           "autosar.ui.metamodel.NamespaceString.behaviorNode" 'property
           "autosar.ui.metamodel.NamespaceString.BehaviorProperty" 'property
           "autosar.ui.metamodel.NamespaceString.BooleanClass" 'property
           "autosar.ui.metamodel.NamespaceString.browseLabel" 'property
           "autosar.ui.metamodel.NamespaceString.Category" 'property
           "autosar.ui.metamodel.NamespaceString.ClientPort" 'property
           "autosar.ui.metamodel.NamespaceString.clientPortsNode" 'property
           "autosar.ui.metamodel.NamespaceString.ClientServerInterfacesNodeName" 'property
           "autosar.ui.metamodel.NamespaceString.CommonAdditionalNativeTypeQualifierProperties" 'property
           "autosar.ui.metamodel.NamespaceString.ComponentClass" 'property
           "autosar.ui.metamodel.NamespaceString.ComponentName" 'property
           "autosar.ui.metamodel.NamespaceString.ComponentsCell" 'property
           "autosar.ui.metamodel.NamespaceString.CompositionComponentsNodeName" 'property
           "autosar.ui.metamodel.NamespaceString.CompuMethod" 'property
           "autosar.ui.metamodel.NamespaceString.CompuMethodClass" 'property
           "autosar.ui.metamodel.NamespaceString.CompuMethodName" 'property
           "autosar.ui.metamodel.NamespaceString.CompuMethods" 'property
           "autosar.ui.metamodel.NamespaceString.CseCode" 'property
           "autosar.ui.metamodel.NamespaceString.CseCodeFactor" 'property
           "autosar.ui.metamodel.NamespaceString.CSInterface" 'property
           "autosar.ui.metamodel.NamespaceString.DataClass" 'property
           "autosar.ui.metamodel.NamespaceString.dataElementsNode" 'property
           "autosar.ui.metamodel.NamespaceString.DataElementSwAddrMethodSectionTypes" 'property
           "autosar.ui.metamodel.NamespaceString.DatatypePackage" 'property
           "autosar.ui.metamodel.NamespaceString.DefaultMemoryAllocationKeywordPolicy" 'property
           "autosar.ui.metamodel.NamespaceString.DefaultPersistencyKeyValueInterfaceName" 'property
           "autosar.ui.metamodel.NamespaceString.DefaultPersistencyProvidedRequiredPortName" 'property
           "autosar.ui.metamodel.NamespaceString.DefaultProvidedPortName" 'property
           "autosar.ui.metamodel.NamespaceString.DefaultProvidedServiceInterfaceName" 'property
           "autosar.ui.metamodel.NamespaceString.DefaultRequiredPortName" 'property
           "autosar.ui.metamodel.NamespaceString.DefaultRequiredServiceInterfaceName" 'property
           "autosar.ui.metamodel.NamespaceString.DefaultSectionType" 'property
           "autosar.ui.metamodel.NamespaceString.DefaultSwAddrMethods" 'property
           "autosar.ui.metamodel.NamespaceString.DeleteIcon" 'property
           "autosar.ui.metamodel.NamespaceString.DeleteStr" 'property
           "autosar.ui.metamodel.NamespaceString.DictionaryNameToken" 'property
           "autosar.ui.metamodel.NamespaceString.DisplayFormat" 'property
           "autosar.ui.metamodel.NamespaceString.DupDataElement" 'property
           "autosar.ui.metamodel.NamespaceString.DupEvent" 'property
           "autosar.ui.metamodel.NamespaceString.DupInterface" 'property
           "autosar.ui.metamodel.NamespaceString.DupIrv" 'property
           "autosar.ui.metamodel.NamespaceString.DupPort" 'property
           "autosar.ui.metamodel.NamespaceString.DupRunnable" 'property
           "autosar.ui.metamodel.NamespaceString.editLabel" 'property
           "autosar.ui.metamodel.NamespaceString.EnumerationClass" 'property
           "autosar.ui.metamodel.NamespaceString.errorEnumLabel" 'property
           "autosar.ui.metamodel.NamespaceString.ErrorTitle" 'property
           "autosar.ui.metamodel.NamespaceString.eventNode" 'property
           "autosar.ui.metamodel.NamespaceString.eventsNodeName" 'property
           "autosar.ui.metamodel.NamespaceString.ExportButtonText" 'property
           "autosar.ui.metamodel.NamespaceString.ExportedXMLFilePackaging" 'property
           "autosar.ui.metamodel.NamespaceString.ExportIcon" 'property
           "autosar.ui.metamodel.NamespaceString.False" 'property
           "autosar.ui.metamodel.NamespaceString.fieldNode" 'property
           "autosar.ui.metamodel.NamespaceString.fieldsNodeName" 'property
           "autosar.ui.metamodel.NamespaceString.FloatingPointClass" 'property
           "autosar.ui.metamodel.NamespaceString.HideTag" 'property
           "autosar.ui.metamodel.NamespaceString.IconMap" 'property
           "autosar.ui.metamodel.NamespaceString.ImplementationDataType" 'property
           "autosar.ui.metamodel.NamespaceString.ImplementationDataTypeAdditionalProps" 'property
           "autosar.ui.metamodel.NamespaceString.ImplementationDataTypes" 'property
           "autosar.ui.metamodel.NamespaceString.ImplementationName" 'property
           "autosar.ui.metamodel.NamespaceString.ImportButtonText" 'property
           "autosar.ui.metamodel.NamespaceString.ImportDlgTitle" 'property
           "autosar.ui.metamodel.NamespaceString.ImportFileTypes" 'property
           "autosar.ui.metamodel.NamespaceString.ImportFileTypesDes" 'property
           "autosar.ui.metamodel.NamespaceString.ImportIcon" 'property
           "autosar.ui.metamodel.NamespaceString.IntegerClass" 'property
           "autosar.ui.metamodel.NamespaceString.InterfaceClass" 'property
           "autosar.ui.metamodel.NamespaceString.InterfacePackage" 'property
           "autosar.ui.metamodel.NamespaceString.InterfacesCell" 'property
           "autosar.ui.metamodel.NamespaceString.InterfacesNodeName" 'property
           "autosar.ui.metamodel.NamespaceString.InterfaceTypes" 'property
           "autosar.ui.metamodel.NamespaceString.InternalBehaviorName" 'property
           "autosar.ui.metamodel.NamespaceString.InternalDataSwAddrMethodSectionTypes" 'property
           "autosar.ui.metamodel.NamespaceString.irvNode" 'property
           "autosar.ui.metamodel.NamespaceString.IRVSwAddrMethodSectionTypes" 'property
           "autosar.ui.metamodel.NamespaceString.IsConstString" 'property
           "autosar.ui.metamodel.NamespaceString.IsVolatileString" 'property
           "autosar.ui.metamodel.NamespaceString.LogicalView" 'property
           "autosar.ui.metamodel.NamespaceString.LongName" 'property
           "autosar.ui.metamodel.NamespaceString.LongNameClass" 'property
           "autosar.ui.metamodel.NamespaceString.M3IBoolean" 'property
           "autosar.ui.metamodel.NamespaceString.M3IClassName" 'property
           "autosar.ui.metamodel.NamespaceString.M3IImmutableDataType" 'property
           "autosar.ui.metamodel.NamespaceString.M3IImmutableEnumeration" 'property
           "autosar.ui.metamodel.NamespaceString.M3IImmutableValueName" 'property
           "autosar.ui.metamodel.NamespaceString.M3IInteger" 'property
           "autosar.ui.metamodel.NamespaceString.M3IObjectName" 'property
           "autosar.ui.metamodel.NamespaceString.M3IString" 'property
           "autosar.ui.metamodel.NamespaceString.M3IValueName" 'property
           "autosar.ui.metamodel.NamespaceString.majorVersionNode" 'property
           "autosar.ui.metamodel.NamespaceString.MdgSupportedStorageTypesStr" 'property
           "autosar.ui.metamodel.NamespaceString.MdgSupportedStorageTypesStrARVersionLowerThan4x" 'property
           "autosar.ui.metamodel.NamespaceString.MemoryAllocationKeywordPolicy" 'property
           "autosar.ui.metamodel.NamespaceString.MemoryAllocationKeywordPolicyClass" 'property
           "autosar.ui.metamodel.NamespaceString.methodNode" 'property
           "autosar.ui.metamodel.NamespaceString.methodsNodeName" 'property
           "autosar.ui.metamodel.NamespaceString.minorVersionNode" 'property
           "autosar.ui.metamodel.NamespaceString.Mode" 'property
           "autosar.ui.metamodel.NamespaceString.ModeAccessType" 'property
           "autosar.ui.metamodel.NamespaceString.ModeDeclaration" 'property
           "autosar.ui.metamodel.NamespaceString.ModeDeclarationClass" 'property
           "autosar.ui.metamodel.NamespaceString.ModeDeclarationGroup" 'property
           "autosar.ui.metamodel.NamespaceString.ModeDeclarationGroupClass" 'property
           "autosar.ui.metamodel.NamespaceString.ModeDeclarationGroupElementClass" 'property
           "autosar.ui.metamodel.NamespaceString.ModeDeclarationGroupPackageStr" 'property
           "autosar.ui.metamodel.NamespaceString.ModeDeclarationGroupsColonStr" 'property
           "autosar.ui.metamodel.NamespaceString.ModeDeclarationGroupsNodeName" 'property
           "autosar.ui.metamodel.NamespaceString.ModeDeclarationGroupStr" 'property
           "autosar.ui.metamodel.NamespaceString.ModeDeclarationNodeName" 'property
           "autosar.ui.metamodel.NamespaceString.ModeDeclarationsStr" 'property
           "autosar.ui.metamodel.NamespaceString.ModeDeclarationStr" 'property
           "autosar.ui.metamodel.NamespaceString.ModeGroup" 'property
           "autosar.ui.metamodel.NamespaceString.ModeGroupStr" 'property
           "autosar.ui.metamodel.NamespaceString.ModelNameToken" 'property
           "autosar.ui.metamodel.NamespaceString.ModeReceiverPort" 'property
           "autosar.ui.metamodel.NamespaceString.ModeReceiverPortNodeName" 'property
           "autosar.ui.metamodel.NamespaceString.ModeReceiverPortsStr" 'property
           "autosar.ui.metamodel.NamespaceString.ModeSenderPort" 'property
           "autosar.ui.metamodel.NamespaceString.ModeSenderPortNodeName" 'property
           "autosar.ui.metamodel.NamespaceString.ModeSenderPortsStr" 'property
           "autosar.ui.metamodel.NamespaceString.ModeSwitchInterface" 'property
           "autosar.ui.metamodel.NamespaceString.ModeSwitchInterfaceAdditionalProps" 'property
           "autosar.ui.metamodel.NamespaceString.ModeSwitchInterfacesNodeName" 'property
           "autosar.ui.metamodel.NamespaceString.Name" 'property
           "autosar.ui.metamodel.NamespaceString.NamedProperty" 'property
           "autosar.ui.metamodel.NamespaceString.namespaceNode" 'property
           "autosar.ui.metamodel.NamespaceString.namespacesNodeName" 'property
           "autosar.ui.metamodel.NamespaceString.NoneSelection" 'property
           "autosar.ui.metamodel.NamespaceString.NoneStr" 'property
           "autosar.ui.metamodel.NamespaceString.NoRootErr" 'property
           "autosar.ui.metamodel.NamespaceString.NoUnit" 'property
           "autosar.ui.metamodel.NamespaceString.NvDataInterface" 'property
           "autosar.ui.metamodel.NamespaceString.NvDataInterfacesNodeName" 'property
           "autosar.ui.metamodel.NamespaceString.NvReceiverPort" 'property
           "autosar.ui.metamodel.NamespaceString.nvReceiverPortsNode" 'property
           "autosar.ui.metamodel.NamespaceString.NvSenderPort" 'property
           "autosar.ui.metamodel.NamespaceString.nvSenderPortsNode" 'property
           "autosar.ui.metamodel.NamespaceString.NvSenderReceiverPort" 'property
           "autosar.ui.metamodel.NamespaceString.nvSenderReceiverPortsNode" 'property
           "autosar.ui.metamodel.NamespaceString.OpArgument" 'property
           "autosar.ui.metamodel.NamespaceString.Operation" 'property
           "autosar.ui.metamodel.NamespaceString.OperationClass" 'property
           "autosar.ui.metamodel.NamespaceString.OperationLabel" 'property
           "autosar.ui.metamodel.NamespaceString.operationsNode" 'property
           "autosar.ui.metamodel.NamespaceString.packageClass" 'property
           "autosar.ui.metamodel.NamespaceString.packageDlgTitle" 'property
           "autosar.ui.metamodel.NamespaceString.packageLabel" 'property
           "autosar.ui.metamodel.NamespaceString.packagesNode" 'property
           "autosar.ui.metamodel.NamespaceString.packageTreeLabel" 'property
           "autosar.ui.metamodel.NamespaceString.PackageView" 'property
           "autosar.ui.metamodel.NamespaceString.Parameter" 'property
           "autosar.ui.metamodel.NamespaceString.ParameterAdditionalNativeTypeQualifierProperties" 'property
           "autosar.ui.metamodel.NamespaceString.ParameterComponentsNodeName" 'property
           "autosar.ui.metamodel.NamespaceString.ParameterInterface" 'property
           "autosar.ui.metamodel.NamespaceString.ParameterInterfacesNodeName" 'property
           "autosar.ui.metamodel.NamespaceString.ParameterKind" 'property
           "autosar.ui.metamodel.NamespaceString.parameterNode" 'property
           "autosar.ui.metamodel.NamespaceString.ParameterReceiverPort" 'property
           "autosar.ui.metamodel.NamespaceString.ParameterReceiverPortNodeName" 'property
           "autosar.ui.metamodel.NamespaceString.ParameterSwAddrMethodSectionTypes" 'property
           "autosar.ui.metamodel.NamespaceString.PersistencyKeyValueInterface" 'property
           "autosar.ui.metamodel.NamespaceString.PersistencyKeyValueInterfaceChildrenNames" 'property
           "autosar.ui.metamodel.NamespaceString.PersistencyKeyValueInterfacesNodeName" 'property
           "autosar.ui.metamodel.NamespaceString.persistencyProvidedPort" 'property
           "autosar.ui.metamodel.NamespaceString.persistencyProvidedPortsNode" 'property
           "autosar.ui.metamodel.NamespaceString.persistencyProvidedRequiredPort" 'property
           "autosar.ui.metamodel.NamespaceString.persistencyProvidedRequiredPortsNode" 'property
           "autosar.ui.metamodel.NamespaceString.persistencyRequiredPort" 'property
           "autosar.ui.metamodel.NamespaceString.persistencyRequiredPortsNode" 'property
           "autosar.ui.metamodel.NamespaceString.PortClass" 'property
           "autosar.ui.metamodel.NamespaceString.PortTypes" 'property
           "autosar.ui.metamodel.NamespaceString.Preferences" 'property
           "autosar.ui.metamodel.NamespaceString.providedPort" 'property
           "autosar.ui.metamodel.NamespaceString.providedPortsNode" 'property
           "autosar.ui.metamodel.NamespaceString.QualifierString" 'property
           "autosar.ui.metamodel.NamespaceString.ReceiverPort" 'property
           "autosar.ui.metamodel.NamespaceString.receiverPortsNode" 'property
           "autosar.ui.metamodel.NamespaceString.requiredPort" 'property
           "autosar.ui.metamodel.NamespaceString.requiredPortsNode" 'property
           "autosar.ui.metamodel.NamespaceString.RootName" 'property
           "autosar.ui.metamodel.NamespaceString.RunnableClass" 'property
           "autosar.ui.metamodel.NamespaceString.RunnableInternalDataSwAddrMethodSectionTypes" 'property
           "autosar.ui.metamodel.NamespaceString.runnableNode" 'property
           "autosar.ui.metamodel.NamespaceString.RunnableSwAddrMethodSectionTypes" 'property
           "autosar.ui.metamodel.NamespaceString.RunnableSymbol" 'property
           "autosar.ui.metamodel.NamespaceString.SectionType" 'property
           "autosar.ui.metamodel.NamespaceString.SectionTypeClass" 'property
           "autosar.ui.metamodel.NamespaceString.SenderPort" 'property
           "autosar.ui.metamodel.NamespaceString.senderPortsNode" 'property
           "autosar.ui.metamodel.NamespaceString.SenderReceiverPort" 'property
           "autosar.ui.metamodel.NamespaceString.senderReceiverPortsNode" 'property
           "autosar.ui.metamodel.NamespaceString.SensorActuatorComponent" 'property
           "autosar.ui.metamodel.NamespaceString.ServerPort" 'property
           "autosar.ui.metamodel.NamespaceString.serverPortsNode" 'property
           "autosar.ui.metamodel.NamespaceString.ServiceInterface" 'property
           "autosar.ui.metamodel.NamespaceString.ServiceInterfaceChildrenNames" 'property
           "autosar.ui.metamodel.NamespaceString.ServiceInterfacesNodeName" 'property
           "autosar.ui.metamodel.NamespaceString.SimulinkFcnLabel" 'property
           "autosar.ui.metamodel.NamespaceString.SlDataTypes" 'property
           "autosar.ui.metamodel.NamespaceString.SlDataTypesToolID" 'property
           "autosar.ui.metamodel.NamespaceString.SLTypes" 'property
           "autosar.ui.metamodel.NamespaceString.SRInterface" 'property
           "autosar.ui.metamodel.NamespaceString.SwAddrMethod" 'property
           "autosar.ui.metamodel.NamespaceString.SwAddrMethodClass" 'property
           "autosar.ui.metamodel.NamespaceString.SwAddrMethods" 'property
           "autosar.ui.metamodel.NamespaceString.SwAlignment" 'property
           "autosar.ui.metamodel.NamespaceString.TargetClassName" 'property
           "autosar.ui.metamodel.NamespaceString.TargetRootClass" 'property
           "autosar.ui.metamodel.NamespaceString.Title" 'property
           "autosar.ui.metamodel.NamespaceString.TriggerInterface" 'property
           "autosar.ui.metamodel.NamespaceString.TriggerInterfacesNodeName" 'property
           "autosar.ui.metamodel.NamespaceString.triggerNode" 'property
           "autosar.ui.metamodel.NamespaceString.TriggerReceiverPort" 'property
           "autosar.ui.metamodel.NamespaceString.TriggerReceiverPortNodeName" 'property
           "autosar.ui.metamodel.NamespaceString.TriggerReceiverPortsStr" 'property
           "autosar.ui.metamodel.NamespaceString.True" 'property
           "autosar.ui.metamodel.NamespaceString.TypeProperty" 'property
           "autosar.ui.metamodel.NamespaceString.Undefined" 'property
           "autosar.ui.metamodel.NamespaceString.Unit" 'property
           "autosar.ui.metamodel.NamespaceString.UnitClass" 'property
           "autosar.ui.metamodel.NamespaceString.UnknownType" 'property
           "autosar.ui.metamodel.NamespaceString.ValueTypeClass" 'property
           "autosar.ui.metamodel.Operation" t ;; (class)
           "autosar.ui.metamodel.PackageTree" t ;; (class)
           "autosar.ui.metamodel.PackageTreeNode" t ;; (class)
           "autosar.ui.metamodel.SimulinkDataType" t ;; (class)
           "autosar.ui.metamodel.SimulinkDataType.isAllowedSlTypeName" t ;; (method)
           "autosar.ui.metamodel.SwAddrMethod" t ;; (class)
           "autosar.ui.metamodel.SwAddrMethod.getDefaultSwAddrMethodPackage" t ;; (method)
           "autosar.ui.report.utils.createDialogForReport" t ;; (function)
           "autosar.ui.Tip" t ;; (class)
           "autosar.ui.toolstrip.AutosarAppContext" t ;; (class)
           "autosar.ui.toolstrip.AutosarAppContext.constructCount" t ;; (method)
           "autosar.ui.toolstrip.AutosarAppContext.deleteCount" t ;; (method)
           "autosar.ui.toolstrip.AutosarAppContext.flushOtherCoderApps" t ;; (method)
           "autosar.ui.toolstrip.AutosarAppContext.toggleCoderApp" t ;; (method)
           "autosar.ui.toolstrip.callback.addComponentOfType" t ;; (function)
           "autosar.ui.toolstrip.callback.applyASILProfile" t ;; (function)
           "autosar.ui.toolstrip.callback.createLinkOrImport" t ;; (function)
           "autosar.ui.toolstrip.callback.createOrLinkToInterfaceDictionary" t ;; (function)
           "autosar.ui.toolstrip.callback.deliverPlatformMappingNotification" t ;; (function)
           "autosar.ui.toolstrip.callback.export" t ;; (function)
           "autosar.ui.toolstrip.callback.exportToSLRT" t ;; (function)
           "autosar.ui.toolstrip.callback.interfaceEditorCB" t ;; (function)
           "autosar.ui.toolstrip.callback.launchAUTOSARDictionary" t ;; (function)
           "autosar.ui.toolstrip.callback.openInterfaceDictionary" t ;; (function)
           "autosar.ui.toolstrip.callback.setPlatformKind" t ;; (function)
           "autosar.ui.toolstrip.callback.toggleAutosarAppCB" t ;; (function)
           "autosar.ui.toolstrip.isAutosarLicensed" t ;; (function)
           "autosar.ui.toolstrip.refresher.isAutosarArchModelASILDisabled" t ;; (function)
           "autosar.ui.toolstrip.refresher.isAutosarArchModelASILEnabled" t ;; (function)
           "autosar.ui.toolstrip.refresher.isAutosarArchModelMergeBlockEnabled" t ;; (function)
           "autosar.ui.toolstrip.refresher.isSaveCompositionFeatureEnabled" t ;; (function)
           "autosar.ui.toolstrip.refresher.isVariantComponentForAUTOSAREnabled" t ;; (function)
           "autosar.ui.toolstrip.refresher.isZCProfilesForAUTOSARFeatureEnabled" t ;; (function)
           "autosar.ui.toolstrip.refresher.refreshAddBehaviorGalleryTool" t ;; (function)
           "autosar.ui.toolstrip.refresher.refreshAutosarApp" t ;; (function)
           "autosar.ui.toolstrip.refresher.refreshCreateOrLinkToInterfaceDictionary" t ;; (function)
           "autosar.ui.toolstrip.refresher.refreshExportTool" t ;; (function)
           "autosar.ui.toolstrip.refresher.refreshImportFromARXMLAction" t ;; (function)
           "autosar.ui.toolstrip.refresher.refreshLaunchAUTOSARDictionary" t ;; (function)
           "autosar.ui.utils.addArguments" t ;; (function)
           "autosar.ui.utils.addEventToTable" t ;; (function)
           "autosar.ui.utils.addNode" t ;; (function)
           "autosar.ui.utils.addWizard" t ;; (function)
           "autosar.ui.utils.applyComponentOptionsChange" t ;; (function)
           "autosar.ui.utils.applyPackageChange" t ;; (function)
           "autosar.ui.utils.arrangeSystem" t ;; (function)
           "autosar.ui.utils.assignSimulinkDataTypeDlg" t ;; (function)
           "autosar.ui.utils.buildOrUpdateEventData" t ;; (function)
           "autosar.ui.utils.checkDuplicateInSequence" t ;; (function)
           "autosar.ui.utils.closeCallbackForRunnableDlg" t ;; (function)
           "autosar.ui.utils.closeDictionaryUI" t ;; (function)
           "autosar.ui.utils.closeUIAndApp" t ;; (function)
           "autosar.ui.utils.collectObject" t ;; (function)
           "autosar.ui.utils.convertSLObjectNameToGraphicalName" t ;; (function)
           "autosar.ui.utils.deleteEventFromTable" t ;; (function)
           "autosar.ui.utils.deleteNode" t ;; (function)
           "autosar.ui.utils.editPackage" t ;; (function)
           "autosar.ui.utils.eventApplyCallback" t ;; (function)
           "autosar.ui.utils.eventTriggerPortChanged" t ;; (function)
           "autosar.ui.utils.exportedXmlFilePackagingChangedCallback" t ;; (function)
           "autosar.ui.utils.getAutosarMaxShortNameLength" t ;; (function)
           "autosar.ui.utils.getAutosarSchemaVersion" t ;; (function)
           "autosar.ui.utils.getDlgSchemaForRunnable" t ;; (function)
           "autosar.ui.utils.getEditToolbar" t ;; (function)
           "autosar.ui.utils.getEventIndex" t ;; (function)
           "autosar.ui.utils.getExplorerTitle" t ;; (function)
           "autosar.ui.utils.getModelFromExplorer" t ;; (function)
           "autosar.ui.utils.getModeReceiverPorts" t ;; (function)
           "autosar.ui.utils.getOpSignature" t ;; (function)
           "autosar.ui.utils.getPreferencesDlg" t ;; (function)
           "autosar.ui.utils.getSlFunctionDisplayName" t ;; (function)
           "autosar.ui.utils.getSlFunctionName" t ;; (function)
           "autosar.ui.utils.isaValidUIObject" t ;; (function)
           "autosar.ui.utils.isValidARIdentifier" t ;; (function)
           "autosar.ui.utils.listenerCallback" t ;; (function)
           "autosar.ui.utils.listSelChangedCallback" t ;; (function)
           "autosar.ui.utils.modeActivationChanged" t ;; (function)
           "autosar.ui.utils.modeDeclarationChanged" t ;; (function)
           "autosar.ui.utils.modeReceiverPortChanged" t ;; (function)
           "autosar.ui.utils.mostFrequentString" t ;; (function)
           "autosar.ui.utils.parseException" t ;; (function)
           "autosar.ui.utils.populateInterface" t ;; (function)
           "autosar.ui.utils.registerListenerCB" t ;; (function)
           "autosar.ui.utils.selChangedCallback" t ;; (function)
           "autosar.ui.utils.selectElement" t ;; (function)
           "autosar.ui.utils.selectTargetTreeElement" t ;; (function)
           "autosar.ui.utils.UIViewType" t ;; (class)
           "autosar.ui.utils.UIViewType.Logical" 'enumeration
           "autosar.ui.utils.UIViewType.Package" 'enumeration
           "autosar.ui.utils.unAssignSimulinkDataType" t ;; (function)
           "autosar.ui.utils.updateEvents" t ;; (function)
           "autosar.ui.utils.updateEventsForAddRemove" t ;; (function)
           "autosar.ui.utils.updateEventsTriggerPort" t ;; (function)
           "autosar.ui.utils.viewAUTOSAR" t ;; (function)
           "autosar.ui.utils.XmlOptionsDlgTabKind" t ;; (class)
           "autosar.ui.utils.XmlOptionsDlgTabKind.File" 'enumeration
           "autosar.ui.utils.XmlOptionsDlgTabKind.General" 'enumeration
           "autosar.ui.utils.XmlOptionsDlgTabKind.Package" 'enumeration
           "autosar.ui.utils.XmlOptionsRow" t ;; (class)
           "autosar.ui.utils.xmlOptionsSourceChangedCallback" t ;; (function)
           "autosar.ui.wizard.builder.AdaptiveComponentAdapter" t ;; (class)
           "autosar.ui.wizard.builder.AdaptiveComponentAdapter.getAutosarOperationName" t ;; (method)
           "autosar.ui.wizard.builder.AdaptiveComponentAdapter.getComponentAdapter" t ;; (method)
           "autosar.ui.wizard.builder.ClassicComponentAdapter" t ;; (class)
           "autosar.ui.wizard.builder.ClassicComponentAdapter.getAutosarOperationName" t ;; (method)
           "autosar.ui.wizard.builder.ClassicComponentAdapter.getComponentAdapter" t ;; (method)
           "autosar.ui.wizard.builder.ClientServerInterface" t ;; (class)
           "autosar.ui.wizard.builder.Component" t ;; (class)
           "autosar.ui.wizard.builder.Component.deleteUnusedM3IIRVs" t ;; (method)
           "autosar.ui.wizard.builder.Component.deleteUnusedM3IRunnables" t ;; (method)
           "autosar.ui.wizard.builder.Component.getForceCompiledData" t ;; (method)
           "autosar.ui.wizard.builder.ComponentAdapter" t ;; (class)
           "autosar.ui.wizard.builder.ComponentAdapter.getAutosarOperationName" t ;; (method)
           "autosar.ui.wizard.builder.ComponentAdapter.getComponentAdapter" t ;; (method)
           "autosar.ui.wizard.builder.Interface" t ;; (class)
           "autosar.ui.wizard.builder.ModeSwitchInterface" t ;; (class)
           "autosar.ui.wizard.builder.NvDataInterface" t ;; (class)
           "autosar.ui.wizard.builder.ParameterInterface" t ;; (class)
           "autosar.ui.wizard.builder.PersistencyKeyValueInterface" t ;; (class)
           "autosar.ui.wizard.builder.Port" t ;; (class)
           "autosar.ui.wizard.builder.SenderReceiverInterface" t ;; (class)
           "autosar.ui.wizard.builder.ServiceInterface" t ;; (class)
           "autosar.ui.wizard.builder.TriggerInterface" t ;; (class)
           "autosar.ui.wizard.launch" t ;; (function)
           "autosar.ui.wizard.NamespaceString" t ;; (class)
           "autosar.ui.wizard.NamespaceString.ClientPorts" 'property
           "autosar.ui.wizard.NamespaceString.ClientPortsStr" 'property
           "autosar.ui.wizard.NamespaceString.ComponentTypes" 'property
           "autosar.ui.wizard.NamespaceString.DataElementNewName" 'property
           "autosar.ui.wizard.NamespaceString.DataElements" 'property
           "autosar.ui.wizard.NamespaceString.DefaultAllocateMemory" 'property
           "autosar.ui.wizard.NamespaceString.DefaultComponentType" 'property
           "autosar.ui.wizard.NamespaceString.DefaultCSInterface" 'property
           "autosar.ui.wizard.NamespaceString.DefaultDataAccessInport" 'property
           "autosar.ui.wizard.NamespaceString.DefaultDataAccessMSInport" 'property
           "autosar.ui.wizard.NamespaceString.DefaultDataAccessMSOutport" 'property
           "autosar.ui.wizard.NamespaceString.DefaultDataAccessOutport" 'property
           "autosar.ui.wizard.NamespaceString.DefaultDataElementFormatCtl" 'property
           "autosar.ui.wizard.NamespaceString.DefaultEventName" 'property
           "autosar.ui.wizard.NamespaceString.DefaultInterface" 'property
           "autosar.ui.wizard.NamespaceString.DefaultInterfaceFormatCtl" 'property
           "autosar.ui.wizard.NamespaceString.DefaultIRVName" 'property
           "autosar.ui.wizard.NamespaceString.DefaultMetamodelName" 'property
           "autosar.ui.wizard.NamespaceString.DefaultNVInterface" 'property
           "autosar.ui.wizard.NamespaceString.DefaultPersistencyKeyValueInterface" 'property
           "autosar.ui.wizard.NamespaceString.DefaultPersistencyPort1" 'property
           "autosar.ui.wizard.NamespaceString.DefaultPersistencyPort2" 'property
           "autosar.ui.wizard.NamespaceString.DefaultPersistencyPort3" 'property
           "autosar.ui.wizard.NamespaceString.DefaultPort1" 'property
           "autosar.ui.wizard.NamespaceString.DefaultPort2" 'property
           "autosar.ui.wizard.NamespaceString.DefaultPort3" 'property
           "autosar.ui.wizard.NamespaceString.DefaultPort4" 'property
           "autosar.ui.wizard.NamespaceString.DefaultPortFormatCtl" 'property
           "autosar.ui.wizard.NamespaceString.DefaultQueuedDataAccessInport" 'property
           "autosar.ui.wizard.NamespaceString.DefaultQueuedDataAccessOutport" 'property
           "autosar.ui.wizard.NamespaceString.DefaultServiceInterface" 'property
           "autosar.ui.wizard.NamespaceString.DefaultServicePort1" 'property
           "autosar.ui.wizard.NamespaceString.DefaultServicePort2" 'property
           "autosar.ui.wizard.NamespaceString.DefaultSignalInvalidationDataAccess" 'property
           "autosar.ui.wizard.NamespaceString.DefaultTriggerInterface" 'property
           "autosar.ui.wizard.NamespaceString.EventNewName" 'property
           "autosar.ui.wizard.NamespaceString.EventPrefix" 'property
           "autosar.ui.wizard.NamespaceString.EventTableTitle" 'property
           "autosar.ui.wizard.NamespaceString.EventTypes" 'property
           "autosar.ui.wizard.NamespaceString.FcnCallSuffix" 'property
           "autosar.ui.wizard.NamespaceString.FieldNewName" 'property
           "autosar.ui.wizard.NamespaceString.InterfaceMulDeleteError" 'property
           "autosar.ui.wizard.NamespaceString.InterfacesTitle" 'property
           "autosar.ui.wizard.NamespaceString.InterfaceToolTip" 'property
           "autosar.ui.wizard.NamespaceString.InterfaceTypes" 'property
           "autosar.ui.wizard.NamespaceString.InvalidIndexError" 'property
           "autosar.ui.wizard.NamespaceString.MethodNewName" 'property
           "autosar.ui.wizard.NamespaceString.ModeReceiverPorts" 'property
           "autosar.ui.wizard.NamespaceString.ModeSenderPorts" 'property
           "autosar.ui.wizard.NamespaceString.NewName" 'property
           "autosar.ui.wizard.NamespaceString.NvDataNewName" 'property
           "autosar.ui.wizard.NamespaceString.NvReceiverPorts" 'property
           "autosar.ui.wizard.NamespaceString.NvReceiverPortsStr" 'property
           "autosar.ui.wizard.NamespaceString.NvSenderPorts" 'property
           "autosar.ui.wizard.NamespaceString.NvSenderPortsStr" 'property
           "autosar.ui.wizard.NamespaceString.NvSenderReceiverPorts" 'property
           "autosar.ui.wizard.NamespaceString.NvSenderReceiverPortsStr" 'property
           "autosar.ui.wizard.NamespaceString.OperationNewName" 'property
           "autosar.ui.wizard.NamespaceString.ParameterReceiverPorts" 'property
           "autosar.ui.wizard.NamespaceString.PortMulDeleteError" 'property
           "autosar.ui.wizard.NamespaceString.PortsTitle" 'property
           "autosar.ui.wizard.NamespaceString.PortToolTip" 'property
           "autosar.ui.wizard.NamespaceString.PortTypes" 'property
           "autosar.ui.wizard.NamespaceString.ReceiverPorts" 'property
           "autosar.ui.wizard.NamespaceString.ReceiverPortsStr" 'property
           "autosar.ui.wizard.NamespaceString.RemoveInterfaceDlgTitle" 'property
           "autosar.ui.wizard.NamespaceString.RemoveInterfaceError" 'property
           "autosar.ui.wizard.NamespaceString.SenderPorts" 'property
           "autosar.ui.wizard.NamespaceString.SenderPortsStr" 'property
           "autosar.ui.wizard.NamespaceString.SenderReceiverPorts" 'property
           "autosar.ui.wizard.NamespaceString.SenderReceiverPortsStr" 'property
           "autosar.ui.wizard.NamespaceString.ServerPorts" 'property
           "autosar.ui.wizard.NamespaceString.ServerPortsStr" 'property
           "autosar.ui.wizard.NamespaceString.Title" 'property
           "autosar.ui.wizard.NamespaceString.TransitionTypes" 'property
           "autosar.ui.wizard.NamespaceString.TriggerReceiverPorts" 'property
           "autosar.ui.wizard.NamespaceString.Triggers" 'property
           "autosar.ui.wizard.NamespaceString.TriggersNewName" 'property
           "autosar.ui.wizard.saveCallback" t ;; (function)
           "autosar.ui.wizard.WizardDialog" t ;; (class)
           "autosar.ui.wizard.WizardDialogState" t ;; (class)
           "autosar.ui.wizard.WizardDialogState.CSInterfaces" 'enumeration
           "autosar.ui.wizard.WizardDialogState.CSPorts" 'enumeration
           "autosar.ui.wizard.WizardDialogState.Interfaces" 'enumeration
           "autosar.ui.wizard.WizardDialogState.Ports" 'enumeration
           "autosar.ui.xmlOptions.ArchitectureModelXmlOptionsModifier" t ;; (class)
           "autosar.ui.xmlOptions.ArchitectureModelXmlOptionsModifier.applyChanges" t ;; (method)
           "autosar.ui.xmlOptions.ArchitectureModelXmlOptionsModifier.getModifier" t ;; (method)
           "autosar.ui.xmlOptions.ComponentModelXmlOptionsModifier" t ;; (class)
           "autosar.ui.xmlOptions.ComponentModelXmlOptionsModifier.applyChanges" t ;; (method)
           "autosar.ui.xmlOptions.ComponentModelXmlOptionsModifier.getModifier" t ;; (method)
           "autosar.ui.xmlOptions.SharedDictionaryXmlOptionsModifier" t ;; (class)
           "autosar.ui.xmlOptions.SharedDictionaryXmlOptionsModifier.applyChanges" t ;; (method)
           "autosar.ui.xmlOptions.SLModelXmlOptionsModifier" t ;; (class)
           "autosar.ui.xmlOptions.SLModelXmlOptionsModifier.applyChanges" t ;; (method)
           "autosar.ui.xmlOptions.SLModelXmlOptionsModifier.getModifier" t ;; (method)
           "autosar.ui.xmlOptions.XmlOptionsModifier" t ;; (class)
           "autosar.ui.xmlOptions.XmlOptionsModifier.applyChanges" t ;; (method)
           "autosar.units.AutosarUnitMapping" t ;; (class)
           "autosar.units.AutosarUnitMapping.ARDimsToSLPhysQuantity" 'property
           "autosar.units.AutosarUnitMapping.ARFundamentalDims" 'property
           "autosar.units.AutosarUnitMapping.ARFundementalDimsToSLSIUnits" 'property
           "autosar.units.AutosarUnitMapping.ARFundementalSIUnitSymbols" 'property
           "autosar.units.AutosarUnitMapping.SLFundamentalSIUnitSymbols" 'property
           "autosar.units.AutosarUnitMapping.SLPhysicalQuantity" 'property
           "autosar.units.UnitsImporter" t ;; (class)
           "autosar.units.UnitsImporter.createSlUnitExpression" t ;; (method)
           "autosar.units.UnitsImporter.isPhysQuanBuiltIn" t ;; (method)
           "autosar.units.UnitsImporter.isPhysQuanEquivelent" t ;; (method)
           "autosar.units.UnitsImporter.isUnitBuiltIn" t ;; (method)
           "autosar.updater.ArchCompositionMatcher" t ;; (class)
           "autosar.updater.ArchConnectorMatcher" t ;; (class)
           "autosar.updater.ArchConnectorMatcher.delete_fcn" 'property
           "autosar.updater.ArchConnectorMatcher.mark_delete_fcn" 'property
           "autosar.updater.ArchConnectorMatcher.no_mark_fcn" 'property
           "autosar.updater.ArchDataSectionReport" t ;; (class)
           "autosar.updater.ArchDataSectionReport.dispHelpLine" t ;; (method)
           "autosar.updater.ArchDataSectionReport.getBlkHyperlink" t ;; (method)
           "autosar.updater.ArchDataSectionReport.getMATLABHyperlink" t ;; (method)
           "autosar.updater.ArchDataSectionReport.getReport" t ;; (method)
           "autosar.updater.ArchDataSectionReport.launchReport" t ;; (method)
           "autosar.updater.ArchDataSectionReport.launchReportNow" t ;; (method)
           "autosar.updater.ChangeLogger" t ;; (class)
           "autosar.updater.Comparator" t ;; (class)
           "autosar.updater.copyCSErrorArgs" t ;; (function)
           "autosar.updater.copyXmlOptions" t ;; (function)
           "autosar.updater.ElementCopier" t ;; (class)
           "autosar.updater.ElementCopier.SupportedCategories" 'property
           "autosar.updater.ElementCopier.ValidDatatypeCategories" 'property
           "autosar.updater.ElementCopier.ValidInterfaceCategories" 'property
           "autosar.updater.ElementCopier.ValidOtherCategories" 'property
           "autosar.updater.modelMapping.ArgIn" t ;; (class)
           "autosar.updater.modelMapping.ArgIn.delete_fcn" 'property
           "autosar.updater.modelMapping.ArgIn.mark_delete_fcn" 'property
           "autosar.updater.modelMapping.ArgIn.no_mark_fcn" 'property
           "autosar.updater.modelMapping.ArgOut" t ;; (class)
           "autosar.updater.modelMapping.ArgOut.delete_fcn" 'property
           "autosar.updater.modelMapping.ArgOut.mark_delete_fcn" 'property
           "autosar.updater.modelMapping.ArgOut.no_mark_fcn" 'property
           "autosar.updater.modelMapping.DataStore" t ;; (class)
           "autosar.updater.modelMapping.DataStore.delete_fcn" 'property
           "autosar.updater.modelMapping.DataStore.generateLegacyPimInfo" t ;; (method)
           "autosar.updater.modelMapping.DataStore.generatePimInfo" t ;; (method)
           "autosar.updater.modelMapping.DataStore.getPimMappings" t ;; (method)
           "autosar.updater.modelMapping.DataStore.getShortNameFromMapping" t ;; (method)
           "autosar.updater.modelMapping.DataStore.mark_delete_fcn" 'property
           "autosar.updater.modelMapping.DataStore.no_mark_fcn" 'property
           "autosar.updater.modelMapping.DataStore.supportsLegacyMapping" t ;; (method)
           "autosar.updater.modelMapping.DataTransfer" t ;; (class)
           "autosar.updater.modelMapping.DataTransfer.delete_fcn" 'property
           "autosar.updater.modelMapping.DataTransfer.mark_delete_fcn" 'property
           "autosar.updater.modelMapping.DataTransfer.no_mark_fcn" 'property
           "autosar.updater.modelMapping.FcnCallInport" t ;; (class)
           "autosar.updater.modelMapping.FcnCallInport.delete_fcn" 'property
           "autosar.updater.modelMapping.FcnCallInport.mark_delete_fcn" 'property
           "autosar.updater.modelMapping.FcnCallInport.no_mark_fcn" 'property
           "autosar.updater.modelMapping.FunctionCaller" t ;; (class)
           "autosar.updater.modelMapping.FunctionCaller.delete_fcn" 'property
           "autosar.updater.modelMapping.FunctionCaller.mark_delete_fcn" 'property
           "autosar.updater.modelMapping.FunctionCaller.no_mark_fcn" 'property
           "autosar.updater.modelMapping.InitializeFunction" t ;; (class)
           "autosar.updater.modelMapping.InitializeFunction.delete_fcn" 'property
           "autosar.updater.modelMapping.InitializeFunction.mark_delete_fcn" 'property
           "autosar.updater.modelMapping.InitializeFunction.no_mark_fcn" 'property
           "autosar.updater.modelMapping.InternalTrigger" t ;; (class)
           "autosar.updater.modelMapping.InternalTrigger.delete_fcn" 'property
           "autosar.updater.modelMapping.InternalTrigger.mark_delete_fcn" 'property
           "autosar.updater.modelMapping.InternalTrigger.no_mark_fcn" 'property
           "autosar.updater.modelMapping.ModelScopedParameter" t ;; (class)
           "autosar.updater.modelMapping.ModelScopedParameter.delete_fcn" 'property
           "autosar.updater.modelMapping.ModelScopedParameter.mark_delete_fcn" 'property
           "autosar.updater.modelMapping.ModelScopedParameter.no_mark_fcn" 'property
           "autosar.updater.modelMapping.PIMMapping" t ;; (class)
           "autosar.updater.modelMapping.PIMMapping.delete_fcn" 'property
           "autosar.updater.modelMapping.PIMMapping.generateLegacyPimInfo" t ;; (method)
           "autosar.updater.modelMapping.PIMMapping.generatePimInfo" t ;; (method)
           "autosar.updater.modelMapping.PIMMapping.getPimMappings" t ;; (method)
           "autosar.updater.modelMapping.PIMMapping.getShortNameFromMapping" t ;; (method)
           "autosar.updater.modelMapping.PIMMapping.mark_delete_fcn" 'property
           "autosar.updater.modelMapping.PIMMapping.no_mark_fcn" 'property
           "autosar.updater.modelMapping.PIMMapping.supportsLegacyMapping" t ;; (method)
           "autosar.updater.modelMapping.Port" t ;; (class)
           "autosar.updater.modelMapping.Port.delete_fcn" 'property
           "autosar.updater.modelMapping.Port.mark_delete_fcn" 'property
           "autosar.updater.modelMapping.Port.no_mark_fcn" 'property
           "autosar.updater.modelMapping.RateTransition" t ;; (class)
           "autosar.updater.modelMapping.RateTransition.delete_fcn" 'property
           "autosar.updater.modelMapping.RateTransition.mark_delete_fcn" 'property
           "autosar.updater.modelMapping.RateTransition.no_mark_fcn" 'property
           "autosar.updater.modelMapping.ResetFunction" t ;; (class)
           "autosar.updater.modelMapping.ResetFunction.delete_fcn" 'property
           "autosar.updater.modelMapping.ResetFunction.mark_delete_fcn" 'property
           "autosar.updater.modelMapping.ResetFunction.no_mark_fcn" 'property
           "autosar.updater.modelMapping.ServerFunction" t ;; (class)
           "autosar.updater.modelMapping.ServerFunction.delete_fcn" 'property
           "autosar.updater.modelMapping.ServerFunction.mark_delete_fcn" 'property
           "autosar.updater.modelMapping.ServerFunction.no_mark_fcn" 'property
           "autosar.updater.modelMapping.Signal" t ;; (class)
           "autosar.updater.modelMapping.Signal.delete_fcn" 'property
           "autosar.updater.modelMapping.Signal.generateLegacyPimInfo" t ;; (method)
           "autosar.updater.modelMapping.Signal.generatePimInfo" t ;; (method)
           "autosar.updater.modelMapping.Signal.getPimMappings" t ;; (method)
           "autosar.updater.modelMapping.Signal.getShortNameFromMapping" t ;; (method)
           "autosar.updater.modelMapping.Signal.mark_delete_fcn" 'property
           "autosar.updater.modelMapping.Signal.no_mark_fcn" 'property
           "autosar.updater.modelMapping.Signal.supportsLegacyMapping" t ;; (method)
           "autosar.updater.modelMapping.State" t ;; (class)
           "autosar.updater.modelMapping.State.delete_fcn" 'property
           "autosar.updater.modelMapping.State.generateLegacyPimInfo" t ;; (method)
           "autosar.updater.modelMapping.State.generatePimInfo" t ;; (method)
           "autosar.updater.modelMapping.State.getPimMappings" t ;; (method)
           "autosar.updater.modelMapping.State.getShortNameFromMapping" t ;; (method)
           "autosar.updater.modelMapping.State.mark_delete_fcn" 'property
           "autosar.updater.modelMapping.State.no_mark_fcn" 'property
           "autosar.updater.modelMapping.State.supportsLegacyMapping" t ;; (method)
           "autosar.updater.modelMapping.StepFunction" t ;; (class)
           "autosar.updater.modelMapping.StepFunction.delete_fcn" 'property
           "autosar.updater.modelMapping.StepFunction.mark_delete_fcn" 'property
           "autosar.updater.modelMapping.StepFunction.no_mark_fcn" 'property
           "autosar.updater.modelMapping.SynthesizedDataStore" t ;; (class)
           "autosar.updater.modelMapping.SynthesizedDataStore.delete_fcn" 'property
           "autosar.updater.modelMapping.SynthesizedDataStore.generateLegacyPimInfo" t ;; (method)
           "autosar.updater.modelMapping.SynthesizedDataStore.generatePimInfo" t ;; (method)
           "autosar.updater.modelMapping.SynthesizedDataStore.getPimMappings" t ;; (method)
           "autosar.updater.modelMapping.SynthesizedDataStore.getShortNameFromMapping" t ;; (method)
           "autosar.updater.modelMapping.SynthesizedDataStore.mark_delete_fcn" 'property
           "autosar.updater.modelMapping.SynthesizedDataStore.no_mark_fcn" 'property
           "autosar.updater.modelMapping.SynthesizedDataStore.supportsLegacyMapping" t ;; (method)
           "autosar.updater.modelMapping.TerminateFunction" t ;; (class)
           "autosar.updater.modelMapping.TerminateFunction.delete_fcn" 'property
           "autosar.updater.modelMapping.TerminateFunction.mark_delete_fcn" 'property
           "autosar.updater.modelMapping.TerminateFunction.no_mark_fcn" 'property
           "autosar.updater.ModelMappingMatcher" t ;; (class)
           "autosar.updater.ModelMappingMatcher.delete_fcn" 'property
           "autosar.updater.ModelMappingMatcher.mark_delete_fcn" 'property
           "autosar.updater.ModelMappingMatcher.no_mark_fcn" 'property
           "autosar.updater.ModelReport" t ;; (class)
           "autosar.updater.ModelReport.dispHelpLine" t ;; (method)
           "autosar.updater.ModelReport.getBlkHyperlink" t ;; (method)
           "autosar.updater.ModelReport.getMATLABHyperlink" t ;; (method)
           "autosar.updater.ModelReport.getReport" t ;; (method)
           "autosar.updater.ModelReport.launchReport" t ;; (method)
           "autosar.updater.ModelReport.launchReportNow" t ;; (method)
           "autosar.updater.Report" t ;; (class)
           "autosar.updater.Report.dispHelpLine" t ;; (method)
           "autosar.updater.Report.getBlkHyperlink" t ;; (method)
           "autosar.updater.Report.getMATLABHyperlink" t ;; (method)
           "autosar.updater.Report.getReport" t ;; (method)
           "autosar.updater.Report.launchReport" t ;; (method)
           "autosar.updater.Report.launchReportNow" t ;; (method)
           "autosar.updater.SLComponentMatcher" t ;; (class)
           "autosar.updater.SLCompositionMatcher" t ;; (class)
           "autosar.updater.SLCompositionMatcher.deleteBlockAndLeafElements" t ;; (method)
           "autosar.updater.SLCompositionMatcher.findCompositionSignalLinesFromSrcBlock" t ;; (method)
           "autosar.updater.updateMappingForComp" t ;; (function)
           "autosar.updater.updateMappingForSharedElements" t ;; (function)
           "autosar.updater.XmlOptionsComparator" t ;; (class)
           "autosar.utils.DataDictionaryCloner" t ;; (class)
           "autosar.utils.DataDictionaryCloner.backupDictionary" t ;; (method)
           "autosar.utils.Debug" t ;; (class)
           "autosar.utils.Debug.disable" t ;; (method)
           "autosar.utils.Debug.enable" t ;; (method)
           "autosar.utils.Debug.showStackTrace" t ;; (method)
           "autosar.utils.Debug.validateXMLFiles" t ;; (method)
           "autosar.utils.Debug.warnForDictionaryRepairer" t ;; (method)
           "autosar.utils.DiagnosticViewer" t ;; (class)
           "autosar.utils.DiagnosticViewer.open" t ;; (method)
           "autosar.utils.DiagnosticViewer.report" t ;; (method)
           "autosar.utils.File" t ;; (class)
           "autosar.utils.File.dropPath" t ;; (method)
           "autosar.utils.getActiveConfigSet" t ;; (function)
           "autosar.utils.InitResetTermFcnBlock" t ;; (class)
           "autosar.utils.InitResetTermFcnBlock.findInitFunctionBlocks" t ;; (method)
           "autosar.utils.InitResetTermFcnBlock.findIRTBlocks" t ;; (method)
           "autosar.utils.InitResetTermFcnBlock.findReinitializeFunctionBlocks" t ;; (method)
           "autosar.utils.InitResetTermFcnBlock.findResetFunctionBlocks" t ;; (method)
           "autosar.utils.InitResetTermFcnBlock.findResetFunctionBlocksWithName" t ;; (method)
           "autosar.utils.InitResetTermFcnBlock.findTermFunctionBlocks" t ;; (method)
           "autosar.utils.M3ITransaction" t ;; (class)
           "autosar.utils.mappingCategories" t ;; (class)
           "autosar.utils.mappingCategories.getDataCategoriesForDataDefaults" t ;; (method)
           "autosar.utils.mappingCategories.getMappedToCategoriesForEndToEndProtectionMethods" t ;; (method)
           "autosar.utils.mappingCategories.getMappedToCategoriesForInternalData" t ;; (method)
           "autosar.utils.mappingCategories.getMappedToCategoriesForParameters" t ;; (method)
           "autosar.utils.Math" t ;; (class)
           "autosar.utils.Math.isPow2" t ;; (method)
           "autosar.utils.Math.toLowerAndUpperLimit" t ;; (method)
           "autosar.utils.MessageLogger" t ;; (class)
           "autosar.utils.SimulinkFunction" t ;; (class)
           "autosar.utils.SimulinkFunction.getGlobalFunctionCallerHandles" t ;; (method)
           "autosar.utils.SimulinkFunction.getSFunctionHandles" t ;; (method)
           "autosar.utils.SimulinkFunction.getSimulinkFunctionsForCaller" t ;; (method)
           "autosar.utils.SimulinkFunction.isGlobalSimulinkFunction" t ;; (method)
           "autosar.utils.SimulinkFunction.removeTrailingSFunctionStr" t ;; (method)
           "autosar.utils.SimulinkModelCloner" t ;; (class)
           "autosar.utils.SimulinkModelCloner.backupModel" t ;; (method)
           "autosar.utils.splitQualifiedName" t ;; (function)
           "autosar.utils.StripPrefix" t ;; (function)
           "autosar.utils.SyncMapping" t ;; (class)
           "autosar.utils.SyncMapping.syncStatesSignalsAndDSMs" t ;; (method)
           "autosar.utils.Workspace" t ;; (class)
           "autosar.utils.Workspace.objectExistsInModelScope" t ;; (method)
           "autosar.validation.AdaptiveBusPortValidator" t ;; (class)
           "autosar.validation.AdaptiveBusPortValidator.getBusPortValidator" t ;; (method)
           "autosar.validation.AdaptiveConfigSetValidator" t ;; (class)
           "autosar.validation.AdaptiveConfigSetValidator.isModelProvidingService" t ;; (method)
           "autosar.validation.AdaptiveEventCommunicationValidator" t ;; (class)
           "autosar.validation.AdaptiveFieldsValidator" t ;; (class)
           "autosar.validation.AdaptiveFieldsValidator.hasAdaptiveFieldMapping" t ;; (method)
           "autosar.validation.AdaptiveMappingValidator" t ;; (class)
           "autosar.validation.AdaptiveMetaModelValidator" t ;; (class)
           "autosar.validation.AdaptiveMethodsValidator" t ;; (class)
           "autosar.validation.AdaptiveMethodsValidator.getM3IMethodForFcnPort" t ;; (method)
           "autosar.validation.AdaptiveMethodsValidator.isCommErrorEnum" t ;; (method)
           "autosar.validation.AdaptiveModelingStylesValidator" t ;; (class)
           "autosar.validation.AdaptiveModelingStylesValidator.verifyWordSizeOfDataType" t ;; (method)
           "autosar.validation.AdaptiveModelingStylesValidator.verifyWordSizeSideIOForSS" t ;; (method)
           "autosar.validation.AdaptiveNonClassicValidator" t ;; (class)
           "autosar.validation.AdaptiveSetupValidator" t ;; (class)
           "autosar.validation.AdaptiveSLFunctionValidator" t ;; (class)
           "autosar.validation.AdaptiveSLPortValidator" t ;; (class)
           "autosar.validation.AutosarUtils" t ;; (class)
           "autosar.validation.AutosarUtils.checkAdaptiveModelSetup" t ;; (method)
           "autosar.validation.AutosarUtils.checkDataTypeForErrArg" t ;; (method)
           "autosar.validation.AutosarUtils.checkDataTypeForErrArgPort" t ;; (method)
           "autosar.validation.AutosarUtils.checkDdsIdentifier" t ;; (method)
           "autosar.validation.AutosarUtils.checkDisplayFormat" t ;; (method)
           "autosar.validation.AutosarUtils.checkFnmatchPattern" t ;; (method)
           "autosar.validation.AutosarUtils.checkNonNegativeNumericValue" t ;; (method)
           "autosar.validation.AutosarUtils.checkServiceInstanceId" t ;; (method)
           "autosar.validation.AutosarUtils.checkShortNameCaseClash" t ;; (method)
           "autosar.validation.AutosarUtils.checkStructElementTypeNameClash" t ;; (method)
           "autosar.validation.AutosarUtils.checkSymbol" t ;; (method)
           "autosar.validation.AutosarUtils.checkVersion" t ;; (method)
           "autosar.validation.AutosarUtils.convertLogicalToString" t ;; (method)
           "autosar.validation.AutosarUtils.doWordSizeCheck" t ;; (method)
           "autosar.validation.AutosarUtils.findM3IDataElement" t ;; (method)
           "autosar.validation.AutosarUtils.getFullBlockPathsForError" t ;; (method)
           "autosar.validation.AutosarUtils.getInterface" t ;; (method)
           "autosar.validation.AutosarUtils.getInterfaceElementProperty" t ;; (method)
           "autosar.validation.AutosarUtils.getInterfaceForPortOperation" t ;; (method)
           "autosar.validation.AutosarUtils.getInterfaceForRunnable" t ;; (method)
           "autosar.validation.AutosarUtils.isDataTypeValidForErrorArgument" t ;; (method)
           "autosar.validation.AutosarUtils.isErrorArgument" t ;; (method)
           "autosar.validation.AutosarUtils.isNotCKeyword" t ;; (method)
           "autosar.validation.AutosarUtils.isValidIdentifier" t ;; (method)
           "autosar.validation.AutosarUtils.isValidPerInstanceProperty" t ;; (method)
           "autosar.validation.AutosarUtils.removeNewLine" t ;; (method)
           "autosar.validation.AutosarUtils.reportErrorWithFixit" t ;; (method)
           "autosar.validation.AutosarUtils.validateInputIsANumericWithinRange" t ;; (method)
           "autosar.validation.AutosarUtils.validateLongNameValue" t ;; (method)
           "autosar.validation.AutosarUtils.validateSubModelShortNames" t ;; (method)
           "autosar.validation.AutosarUtils.validateSubModelShortNamesForCodeGen" t ;; (method)
           "autosar.validation.AutosarUtils.verifyNonNegativeNumber" t ;; (method)
           "autosar.validation.BasicSoftwareValidator" t ;; (class)
           "autosar.validation.BusPortValidatorAdapter" t ;; (class)
           "autosar.validation.BusPortValidatorAdapter.getBusPortValidator" t ;; (method)
           "autosar.validation.ClassicBusPortValidator" t ;; (class)
           "autosar.validation.ClassicBusPortValidator.containsMixedMessageSignalPorts" t ;; (method)
           "autosar.validation.ClassicBusPortValidator.getBusPortValidator" t ;; (method)
           "autosar.validation.ClassicConfigSetValidator" t ;; (class)
           "autosar.validation.ClassicMappingValidator" t ;; (class)
           "autosar.validation.ClassicMetaModelValidator" t ;; (class)
           "autosar.validation.ClassicMetaModelValidator.verifyEventsForRunnable" t ;; (method)
           "autosar.validation.ClassicMetaModelValidator.verifyModeSwitchInterface" t ;; (method)
           "autosar.validation.ClassicMetaModelValidator.verifyPRPort" t ;; (method)
           "autosar.validation.ClassicModelingStylesValidator" t ;; (class)
           "autosar.validation.ClassicModelReferenceValidator" t ;; (class)
           "autosar.validation.ClassicModelReferenceValidator.validate" t ;; (method)
           "autosar.validation.ClassicSLPortValidator" t ;; (class)
           "autosar.validation.ClassicSubComponentMappingValidator" t ;; (class)
           "autosar.validation.ClassicSubComponentMappingValidator.validate" t ;; (method)
           "autosar.validation.ClassicSwAddrMethodValidator" t ;; (class)
           "autosar.validation.ClassicSwAddrMethodValidator.verifySwAddrMethods" t ;; (method)
           "autosar.validation.ClientOperationValidator" t ;; (class)
           "autosar.validation.ClientServerValidator" t ;; (class)
           "autosar.validation.ClientServerValidator.canConfigurePortAccess" t ;; (method)
           "autosar.validation.ClientServerValidator.checkAppErr" t ;; (method)
           "autosar.validation.ClientServerValidator.checkArguments" t ;; (method)
           "autosar.validation.ClientServerValidator.checkFcnCallerMappableToInternalTriggerPoint" t ;; (method)
           "autosar.validation.ClientServerValidator.checkFcnCallerMappableToOperation" t ;; (method)
           "autosar.validation.ClientServerValidator.checkOperationHasErrorArg" t ;; (method)
           "autosar.validation.ClientServerValidator.checkSlFcnMappableToInternallyTrigRunnable" t ;; (method)
           "autosar.validation.ClientServerValidator.checkSlFcnMappableToOperation" t ;; (method)
           "autosar.validation.ClientServerValidator.checkSlFcnMappableToRunnable" t ;; (method)
           "autosar.validation.ClientServerValidator.checkSlFcnMappableToServerRunnable" t ;; (method)
           "autosar.validation.ClientServerValidator.checkValidRunnableConfig" t ;; (method)
           "autosar.validation.ClientServerValidator.findM3iOpFromPortOpName" t ;; (method)
           "autosar.validation.ClientServerValidator.findM3iRunnableFromName" t ;; (method)
           "autosar.validation.ClientServerValidator.getAllRunnableOperations" t ;; (method)
           "autosar.validation.ClientServerValidator.getBlockInOutParams" t ;; (method)
           "autosar.validation.ClientServerValidator.getFcnInOutParamNames" t ;; (method)
           "autosar.validation.ClientServerValidator.isFunctionCallerMappable" t ;; (method)
           "autosar.validation.ClientServerValidator.isNvMService" t ;; (method)
           "autosar.validation.ClientServerValidator.isSimulinkFunctionMappable" t ;; (method)
           "autosar.validation.CommonConfigSetValidator" t ;; (class)
           "autosar.validation.CommonConfigSetValidator.isCodeInterfacePackagingReusable" t ;; (method)
           "autosar.validation.CommonModelingStylesValidator" t ;; (class)
           "autosar.validation.CommonModelingStylesValidator.busElementIsInvalid" t ;; (method)
           "autosar.validation.CommonModelingStylesValidator.checkBusPortNameCaseInsensitive" t ;; (method)
           "autosar.validation.CommonModelingStylesValidator.checkBusPortSharedInterfaces" t ;; (method)
           "autosar.validation.CommonModelingStylesValidator.checkBusPortValidElement" t ;; (method)
           "autosar.validation.CommonModelingStylesValidator.checkModeBepPortsHaveOneElement" t ;; (method)
           "autosar.validation.CommonModelingStylesValidator.checkMsgMergeBlks" t ;; (method)
           "autosar.validation.CommonModelingStylesValidator.checkNoBepVirtualBusElements" t ;; (method)
           "autosar.validation.CommonModelingStylesValidator.checkRootNodeIsVirtual" t ;; (method)
           "autosar.validation.CommonModelingStylesValidator.checkVirtualBusDrivingBusPort" t ;; (method)
           "autosar.validation.CommonSLPortValidator" t ;; (class)
           "autosar.validation.CompiledModelUtils" t ;; (class)
           "autosar.validation.CompiledModelUtils.forceCompiledModel" t ;; (method)
           "autosar.validation.CompiledModelUtils.forceCompiledModelForRTW" t ;; (method)
           "autosar.validation.CompiledModelUtils.getReferencedWSVars" t ;; (method)
           "autosar.validation.CompiledModelUtils.isCompiled" t ;; (method)
           "autosar.validation.DataObjectValidator" t ;; (class)
           "autosar.validation.DataObjectValidator.getConstMemoryPrmNames" t ;; (method)
           "autosar.validation.DataObjectValidator.getDSMPIMNames" t ;; (method)
           "autosar.validation.DataObjectValidator.getInternalCalPrmNames" t ;; (method)
           "autosar.validation.DataObjectValidator.getStaticMemoryVarNames" t ;; (method)
           "autosar.validation.DataObjectValidator.verifyBreakpointObject" t ;; (method)
           "autosar.validation.ExportFcnValidator" t ;; (class)
           "autosar.validation.ExportFcnValidator.findRunnableOwner" t ;; (method)
           "autosar.validation.ExportFcnValidator.getRunnableHdls" t ;; (method)
           "autosar.validation.ExportFcnValidator.isExportFcn" t ;; (method)
           "autosar.validation.ExportFcnValidator.isModelWideEvent" t ;; (method)
           "autosar.validation.ExportFcnValidator.isPortScopedFunctionCallerBlock" t ;; (method)
           "autosar.validation.ExportFcnValidator.isPortScopedSimulinkFunction" t ;; (method)
           "autosar.validation.ExportFcnValidator.isPublicScopedSimulinkFunction" t ;; (method)
           "autosar.validation.ExportFcnValidator.isScopedSimulinkFunction" t ;; (method)
           "autosar.validation.ExportFcnValidator.isServerSubSys" t ;; (method)
           "autosar.validation.ExportFcnValidator.isTopModelAsyncFcnCall" t ;; (method)
           "autosar.validation.ExportFcnValidator.isTopModelExportFcn" t ;; (method)
           "autosar.validation.fixits.addDSMForField" t ;; (function)
           "autosar.validation.fixits.addStdMutexCRL" t ;; (function)
           "autosar.validation.fixits.changeAccessMode" t ;; (function)
           "autosar.validation.fixits.changeInitValue" t ;; (function)
           "autosar.validation.fixits.configureQueueForAUTOSAR" t ;; (function)
           "autosar.validation.fixits.connectPortToEventRouting" t ;; (function)
           "autosar.validation.fixits.convertToBusPort" t ;; (function)
           "autosar.validation.fixits.convertToBusPortsWithInterface" t ;; (function)
           "autosar.validation.fixits.createAndUseComErrorEnum" t ;; (function)
           "autosar.validation.fixits.createDefaultComponentModel" t ;; (function)
           "autosar.validation.fixits.deleteParameterFromDict" t ;; (function)
           "autosar.validation.fixits.deletePort" t ;; (function)
           "autosar.validation.fixits.deleteUnusedRunnablesAndIRVs" t ;; (function)
           "autosar.validation.fixits.hiliteBlocks" t ;; (function)
           "autosar.validation.fixits.makeFunctionOrCallerSynchronous" t ;; (function)
           "autosar.validation.fixits.renameImplementationQualifiedName" t ;; (function)
           "autosar.validation.fixits.renameMappedComponent" t ;; (function)
           "autosar.validation.fixits.setArgumentDirectionToOut" t ;; (function)
           "autosar.validation.fixits.setDataScopeForDataType" t ;; (function)
           "autosar.validation.fixits.setEndToEndProtectionMethodToProtectionWrapper" t ;; (function)
           "autosar.validation.fixits.setFieldProperty" t ;; (function)
           "autosar.validation.fixits.setHeaderFileForDataType" t ;; (function)
           "autosar.validation.fixits.setModelSettingForAllComponents" t ;; (function)
           "autosar.validation.fixits.setPlatformTypesTo3x" t ;; (function)
           "autosar.validation.fixits.setPlatformTypesTo4x" t ;; (function)
           "autosar.validation.fixits.setSwCalibrationAccess" t ;; (function)
           "autosar.validation.fixits.setTimeoutTo" t ;; (function)
           "autosar.validation.fixits.setTopicName" t ;; (function)
           "autosar.validation.InitValueChecker" t ;; (class)
           "autosar.validation.InitValueChecker.checkInitValue" t ;; (method)
           "autosar.validation.InterfaceDictionaryValidator" t ;; (class)
           "autosar.validation.InterfaceDictionaryValidator.checkClientServerInterfacesPresentInDict" t ;; (method)
           "autosar.validation.InterfaceDictionaryValidator.checkDictPlatformMapping" t ;; (method)
           "autosar.validation.InterfaceDictionaryValidator.checkM3IModelsAreLinked" t ;; (method)
           "autosar.validation.InterfaceDictionaryValidator.checkNoInterfacesOutsideInterfaceDict" t ;; (method)
           "autosar.validation.InterfaceDictionaryValidator.checkRegularPorts" t ;; (method)
           "autosar.validation.InterfaceDictionaryValidator.checkSingleInterfaceDict" t ;; (method)
           "autosar.validation.InterfaceDictionaryValidator.findRootLevelBEPsUsingNonInterfaceDictInterfaces" t ;; (method)
           "autosar.validation.InterfaceDictionaryValidator.runChecks" t ;; (method)
           "autosar.validation.InterfaceDictionaryValidator.runNoInterfaceDictionaryChecks" t ;; (method)
           "autosar.validation.InternalTriggerValidator" t ;; (class)
           "autosar.validation.MetaModelCommonValidator" t ;; (class)
           "autosar.validation.MetaModelMappedComponentValidator" t ;; (class)
           "autosar.validation.p_checkIrvs" t ;; (function)
           "autosar.validation.PhasedValidator" t ;; (class)
           "autosar.validation.Validator" t ;; (class)
           "autosar.validation.Validator.flushMessages" t ;; (method)
           "autosar.validation.Validator.getValidationLevel" t ;; (method)
           "autosar.validation.Validator.logError" t ;; (method)
           "autosar.validation.Validator.logErrorAndFlush" t ;; (method)
           "autosar.validation.Validator.logMessage" t ;; (method)
           "autosar.validation.Validator.logWarning" t ;; (method)
           "autosar.validation.walkThruVirtualBlockToDsts" t ;; (function)
           "autosar.validation.XmlOptionsValidator" t ;; (class)
           "autosar.validation.XmlOptionsValidator.areImpAndAppTypePackagesDifferent" t ;; (method)
           "AUTOSAR4.csc_registration" t ;; (function)
           "AUTOSAR4.Parameter" t ;; (class)
           "AUTOSAR4.Parameter.Dimensions" 'property
           "AUTOSAR4.Signal" t ;; (class)
           "autosar_adaptive_make_rtw_hook" t ;; (mFile)
           "autosar_adaptive_servicegen_make_rtw_hook" t ;; (pFile)
           "autosar_make_rtw_hook" t ;; (mFile)
           "autosar_rtwoptions_callback" t ;; (pFile)
           "autosar_ui_close" t ;; (pFile) Close AUTOSAR Dictionary dialog box
           "autosar_ui_launch" t ;; (pFile) Open AUTOSAR Dictionary dialog box
           "autosarcore.checkCloseMdl" t ;; (function)
           "autosarcore.checkIdentifier" t ;; (function)
           "autosarcore.checkIdentifierErrID" t ;; (function)
           "autosarcore.checkSaveAsMdl" t ;; (function)
           "autosarcore.Constants" t ;; (class)
           "autosarcore.Constants.MaxIdentifierLength" 'property
           "autosarcore.destroyLoadedM3IModel" t ;; (function)
           "autosarcore.getARAFilesReportGroupName" t ;; (function)
           "autosarcore.getMaxIdentifierLength" t ;; (function)
           "autosarcore.getPortComSpecInfo" t ;; (function)
           "autosarcore.getRTEFilesReportGroupName" t ;; (function)
           "autosarcore.importFromPreviousVersion" t ;; (function)
           "autosarcore.isInstalledAndLicensed" t ;; (function)
           "autosarcore.isValidAutosarBuild" t ;; (function)
           "autosarcore.M3IModelLoader" t ;; (class)
           "autosarcore.M3IModelLoader.createXmiReader" t ;; (method)
           "autosarcore.M3IModelLoader.loadM3IModel" t ;; (method)
           "autosarcore.M3IModelLoader.loadSharedM3IModel" t ;; (method)
           "autosarcore.M3IModelLoader.runSharedAUTOSARDictChecks" t ;; (method)
           "autosarcore.mm.compatibility.transform" t ;; (function)
           "autosarcore.mm.compatibility.Transformer" t ;; (class)
           "autosarcore.mm.compatibility.TransformerChain" t ;; (class)
           "autosarcore.mm.sl2mm.SwBaseTypeBuilder" t ;; (class)
           "autosarcore.mm.sl2mm.SwBaseTypeBuilder.DefaultPackage" 'property
           "autosarcore.mm.sl2mm.SwBaseTypeBuilder.getAdaptivePlatformTypes" t ;; (method)
           "autosarcore.mm.sl2mm.SwBaseTypeBuilder.getSwBaseTypeNameFromImpType" t ;; (method)
           "autosarcore.rtwOptions" t ;; (function)
           "autosarcore.setArchModelCallbacks" t ;; (function)
           "autosarcore.setModelCallbacks" t ;; (function)
           "autosarcore.unregisterListenerCB" t ;; (function)
           "autosarcore.unregisterListenerCBTemporarily" t ;; (function)
           "autosarcore.XmlOptionsEvolver" t ;; (class)
           "autosarcore.XmlOptionsEvolver.execute" t ;; (method)
           "autosarhandcodedcomponentimporter_CheckSimMode" t ;; (mex)
           "autosarinstalled" t ;; (pFile)
           "autosarlegacylib" t ;; (slxFile)
           "autosarlib" t ;; (slxFile)
           "autosarlibaprouting" t ;; (slxFile)
           "autosarlibara" t ;; (slxFile)
           "autosarlibcprouting" t ;; (slxFile)
           "autosarlibdem" t ;; (slxFile)
           "autosarlibefxmfl" t ;; (slxFile)
           "autosarlibfim" t ;; (slxFile)
           "autosarlibiflifx" t ;; (slxFile)
           "autosarlibnvm" t ;; (slxFile)
           "autosarrawdata" t ;; (slxFile)
           "autosarroot" t ;; (pFile)
           "autosarspkglib" t ;; (slxFile)
           "autosarspkglib_internal" t ;; (slxFile)
           "autosarspkglib_internal_utils" t ;; (slxFile)
           "autosc" t ;; (mFile)
           "autoSetPLLSettings" t ;; (mFile)
           "autoshared" t ;; (pFile)
           "autosharedeval" t ;; (pFile)
           "autosharedhelp" t ;; (mFile)
           "autosharedicon" t ;; (mFile)
           "autosharedtest" t ;; (pFile)
           "autumn" t ;; (mFile) Autumn colormap array
           "auxvar" t ;; (mFile)
           "aveknt" t ;; (mFile) Provide knot averages
           "averagePooling1dLayer" t ;; (mFile) 1-D average pooling layer
           "averagePooling2dLayer" t ;; (mFile) Average pooling layer
           "averagePooling3dLayer" t ;; (mFile) 3-D average pooling layer
           "avgate" t ;; (mFile)
           "avhrrgoode" t ;; (mFile) Read AVHRR data product stored in Goode Projection
           "avhrrlambert" t ;; (mFile) Read AVHRR data product stored in eqaazim projection
           "avifinfo" t ;; (mFile)
           "aviinfo" t ;; (mFile) Information about Audio/Video Interleaved (AVI) file
           "avtharnesslib" t ;; (slxFile)
           "AvtUI.MEProxy" t ;; (class)
           "AvtUI.Progress" t ;; (class)
           "AvtUI.ProxyModelComp" t ;; (class)
           "awgn" t ;; (mFile) Add white Gaussian noise to signal
           "awtcreate" t ;; (mFile)
           "awtinvoke" t ;; (mFile)
           "axang2quat" t ;; (mFile) Convert axis-angle rotation to quaternion
           "axang2rotm" t ;; (mFile) Convert axis-angle rotation to rotation matrix
           "axang2tform" t ;; (mFile) Convert axis-angle rotation to homogeneous transformation
           "axes" t ;; (mFile) Create Cartesian axes
           "axes2ecc" t ;; (mFile) Eccentricity of ellipse from axes lengths
           "axes2pix" t ;; (mFile) Convert axes coordinates to pixel coordinates
           "axescheck" t ;; (mFile)
           "axesm" t ;; (mFile) Create axesm-based map
           "axesmui" t ;; (mFile) Define axesm-based map and modify projection and display properties
           "axesscale" t ;; (mFile) Resize axes for equivalent scale
           "axestext" t ;; (mFile)
           "axis" t ;; (mFile) Set axis limits and aspect ratios
           "axischild" t ;; (mFile)
           "axisobj" t ;; (mFile)
           "axistext" t ;; (mFile)
           "axtoolbar" t ;; (mFile) Create axes toolbar
           "axtoolbarbtn" t ;; (mFile) Add buttons to axes toolbar
           "axxbc" t ;; (mFile)
           "az2broadside" t ;; (mFile) Convert azimuth and elevation angle to broadside angle
           "azel2phitheta" t ;; (mFile) Convert angles from azimuth-elevation form to phi-theta form
           "azel2phithetapat" t ;; (mFile) Convert radiation pattern from azimuth-elevation coordinates to phi-theta coordinates
           "azel2uv" t ;; (mFile) Convert azimuth/elevation angles to u/v coordinates
           "azel2uvpat" t ;; (mFile) Convert radiation pattern from azimuth/elevation form to u/v form
           "azelaxes" t ;; (mFile) Spherical basis vectors in 3-by-3 matrix form
           "azelcut2pat" t ;; (mFile) Create 3-D response pattern from azimuth and elevation cuts
           "azimuth" t ;; (mFile) Azimuth between points on sphere or ellipsoid
           "BA.Abstraction.abstractCPInfoByName" t ;; (class)
           "BA.Abstraction.abstractCPInfoByName.createNode" t ;; (method)
           "BA.Abstraction.abstractCPInfoByName.findMatchingObject" t ;; (method)
           "BA.Abstraction.abstractCPInfoByType" t ;; (class)
           "BA.Abstraction.abstractCPInfoByType.createNode" t ;; (method)
           "BA.Abstraction.abstractCPInfoByType.findMatchingObject" t ;; (method)
           "BA.Abstraction.abstractCPInfoByType.LOOKAHEADSTEP" 'property
           "BA.Abstraction.abstractCriticalPathInfo" t ;; (class)
           "BA.Abstraction.abstractCriticalPathInfo.createNode" t ;; (method)
           "BA.Abstraction.abstractCriticalPathInfo.findMatchingObject" t ;; (method)
           "BA.Abstraction.OPTYPE" t ;; (class)
           "BA.Abstraction.OPTYPE.ADD" 'enumeration
           "BA.Abstraction.OPTYPE.DELAY" 'enumeration
           "BA.Abstraction.OPTYPE.DIV" 'enumeration
           "BA.Abstraction.OPTYPE.getDefaultValue" t ;; (method)
           "BA.Abstraction.OPTYPE.INSTANCE" 'enumeration
           "BA.Abstraction.OPTYPE.MULT" 'enumeration
           "BA.Abstraction.OPTYPE.RELOP" 'enumeration
           "BA.Abstraction.OPTYPE.SFEML" 'enumeration
           "BA.Abstraction.OPTYPE.UNKNOWN" 'enumeration
           "BA.Algorithm.CPAnnotationStrategy" t ;; (class)
           "BA.Algorithm.CPAnnotationStrategy.createCGIR2PIRSignalMap" t ;; (method)
           "BA.Algorithm.CPAnnotationStrategy.createCGIR2PIRSignalMapForCtx" t ;; (method)
           "BA.Algorithm.CPAnnotationStrategy.createCGIR2PIRSignalMapFromSignals" t ;; (method)
           "BA.Algorithm.CPAnnotationStrategy.getNearestMatchInPIR" t ;; (method)
           "BA.Algorithm.CPAnnotationStrategy.hasMultipleInstances" t ;; (method)
           "BA.Algorithm.CPAnnotationStrategy.isCompAddedByPIR" t ;; (method)
           "BA.Algorithm.CPAnnotationStrategy.isOutputOfDelay" t ;; (method)
           "BA.Algorithm.CPAnnotationStrategy.printSkippedMatches" t ;; (method)
           "BA.Algorithm.CPAnnotationStrategy.reportWarnings" t ;; (method)
           "BA.Algorithm.CPAnnotationStrategy.setCPIndices" t ;; (method)
           "BA.Algorithm.generateCPhtmlReport" t ;; (function)
           "BA.Algorithm.One2OneStrategy" t ;; (class)
           "BA.Algorithm.One2OneStrategy.createCGIR2PIRSignalMap" t ;; (method)
           "BA.Algorithm.One2OneStrategy.createCGIR2PIRSignalMapForCtx" t ;; (method)
           "BA.Algorithm.One2OneStrategy.createCGIR2PIRSignalMapFromSignals" t ;; (method)
           "BA.Algorithm.One2OneStrategy.getNearestMatchInPIR" t ;; (method)
           "BA.Algorithm.One2OneStrategy.hasMultipleInstances" t ;; (method)
           "BA.Algorithm.One2OneStrategy.isCompAddedByPIR" t ;; (method)
           "BA.Algorithm.One2OneStrategy.isOutputOfDelay" t ;; (method)
           "BA.Algorithm.One2OneStrategy.printSkippedMatches" t ;; (method)
           "BA.Algorithm.One2OneStrategy.reportWarnings" t ;; (method)
           "BA.Algorithm.One2OneStrategy.setCPIndices" t ;; (method)
           "BA.Algorithm.OperationType" t ;; (class)
           "BA.Algorithm.OperationType.get" t ;; (method)
           "BA.Algorithm.OperationType.getNumDimension" t ;; (method)
           "BA.Algorithm.OperationType.isAdd" t ;; (method)
           "BA.Algorithm.OperationType.isDelay" t ;; (method)
           "BA.Algorithm.OperationType.isDiv" t ;; (method)
           "BA.Algorithm.OperationType.isEMLComp" t ;; (method)
           "BA.Algorithm.OperationType.isMult" t ;; (method)
           "BA.Algorithm.OperationType.isRelop" t ;; (method)
           "BA.Algorithm.pirInterpolationStrategy" t ;; (class)
           "BA.Algorithm.pirInterpolationStrategy.createCGIR2PIRSignalMap" t ;; (method)
           "BA.Algorithm.pirInterpolationStrategy.createCGIR2PIRSignalMapForCtx" t ;; (method)
           "BA.Algorithm.pirInterpolationStrategy.createCGIR2PIRSignalMapFromSignals" t ;; (method)
           "BA.Algorithm.pirInterpolationStrategy.getNearestMatchInPIR" t ;; (method)
           "BA.Algorithm.pirInterpolationStrategy.hasMultipleInstances" t ;; (method)
           "BA.Algorithm.pirInterpolationStrategy.isCompAddedByPIR" t ;; (method)
           "BA.Algorithm.pirInterpolationStrategy.isOutputOfDelay" t ;; (method)
           "BA.Algorithm.pirInterpolationStrategy.printSkippedMatches" t ;; (method)
           "BA.Algorithm.pirInterpolationStrategy.reportWarnings" t ;; (method)
           "BA.Algorithm.pirInterpolationStrategy.setCPIndices" t ;; (method)
           "BA.Algorithm.pirInterpolationWithBlkTypesStrategy" t ;; (class)
           "BA.Algorithm.pirInterpolationWithBlkTypesStrategy.createCGIR2PIRSignalMap" t ;; (method)
           "BA.Algorithm.pirInterpolationWithBlkTypesStrategy.createCGIR2PIRSignalMapForCtx" t ;; (method)
           "BA.Algorithm.pirInterpolationWithBlkTypesStrategy.createCGIR2PIRSignalMapFromSignals" t ;; (method)
           "BA.Algorithm.pirInterpolationWithBlkTypesStrategy.getNearestMatchInPIR" t ;; (method)
           "BA.Algorithm.pirInterpolationWithBlkTypesStrategy.hasMultipleInstances" t ;; (method)
           "BA.Algorithm.pirInterpolationWithBlkTypesStrategy.isCompAddedByPIR" t ;; (method)
           "BA.Algorithm.pirInterpolationWithBlkTypesStrategy.isOutputOfDelay" t ;; (method)
           "BA.Algorithm.pirInterpolationWithBlkTypesStrategy.printSkippedMatches" t ;; (method)
           "BA.Algorithm.pirInterpolationWithBlkTypesStrategy.reportWarnings" t ;; (method)
           "BA.Algorithm.pirInterpolationWithBlkTypesStrategy.setCPIndices" t ;; (method)
           "BA.Annotator.colorManager" t ;; (class)
           "BA.Annotator.uncolorManager" t ;; (class)
           "BA.Main.baDriver" t ;; (class)
           "BA.Main.baDriver.flattenHierarchicalNames" t ;; (method)
           "BA.Main.baDriver.getFullPath" t ;; (method)
           "BA.Main.baDriver.resolveHierarchicalNames" t ;; (method)
           "BA.New.BackAnnotator" t ;; (class)
           "BA.New.CP.CriticalComponent" t ;; (class)
           "BA.New.CP.CriticalPath" t ;; (class)
           "BA.New.CP.Report2CP" t ;; (class)
           "BA.New.CP.Report2CP.parse" t ;; (method)
           "BA.New.Optional" t ;; (class)
           "BA.New.Optional.none" t ;; (method)
           "BA.New.Optional.some" t ;; (method)
           "BA.New.ReportIR.Path" t ;; (class)
           "BA.New.ReportIR.PrettyPrintable" t ;; (class)
           "BA.New.ReportIR.Report" t ;; (class)
           "BA.New.ReportParser.XilinxVivadoTvrParser" t ;; (class)
           "BA.New.ReportParser.XilinxVivadoTvrParser.parse" t ;; (method)
           "BA.New.Util" t ;; (class)
           "BA.New.Util.all" t ;; (method)
           "BA.New.Util.any" t ;; (method)
           "BA.New.Util.approximateCP" t ;; (method)
           "BA.New.Util.asTableStr" t ;; (method)
           "BA.New.Util.componentPath" t ;; (method)
           "BA.New.Util.editDistance" t ;; (method)
           "BA.New.Util.extractKeyValuePairs" t ;; (method)
           "BA.New.Util.extractKeyValuePairsAcc" t ;; (method)
           "BA.New.Util.filter" t ;; (method)
           "BA.New.Util.findMatchingDriver" t ;; (method)
           "BA.New.Util.flatMap" t ;; (method)
           "BA.New.Util.forEach" t ;; (method)
           "BA.New.Util.grep" t ;; (method)
           "BA.New.Util.highlight_with_path" t ;; (method)
           "BA.New.Util.ifElse" t ;; (method)
           "BA.New.Util.map" t ;; (method)
           "BA.New.Util.modified" t ;; (method)
           "BA.New.Util.partitionByBeginEnd" t ;; (method)
           "BA.New.Util.reachableNICs" t ;; (method)
           "BA.New.Util.readlines" t ;; (method)
           "BA.New.Util.safecast2cell" t ;; (method)
           "BA.New.Util.uniq" t ;; (method)
           "BA.New.Util.uniqAccumulate" t ;; (method)
           "BA.Parser.AlteraCP_IR" t ;; (class)
           "BA.Parser.AlteraCP_IR.assertValidFormat" t ;; (method)
           "BA.Parser.alteraCriticalPathInfo" t ;; (class)
           "BA.Parser.alteraCriticalPathInfo.createNode" t ;; (method)
           "BA.Parser.alteraCriticalPathInfo.getOpType" t ;; (method)
           "BA.Parser.AlteraFactory" t ;; (class)
           "BA.Parser.CP_IR" t ;; (class)
           "BA.Parser.CP_IR.assertValidFormat" t ;; (method)
           "BA.Parser.criticalPathInfo" t ;; (class)
           "BA.Parser.criticalPathInfo.createNode" t ;; (method)
           "BA.Parser.Factory" t ;; (class)
           "BA.Parser.XilinxCP_IR" t ;; (class)
           "BA.Parser.XilinxCP_IR.assertValidFormat" t ;; (method)
           "BA.Parser.xilinxCriticalPathInfo" t ;; (class)
           "BA.Parser.xilinxCriticalPathInfo.createNode" t ;; (method)
           "BA.Parser.XilinxFactory" t ;; (class)
           "BA.Parser.XilinxVivadoCP_IR" t ;; (class)
           "BA.Parser.XilinxVivadoCP_IR.assertValidFormat" t ;; (method)
           "BA.Parser.xilinxVivadoCriticalPathInfo" t ;; (class)
           "BA.Parser.xilinxVivadoCriticalPathInfo.createNode" t ;; (method)
           "BA.Parser.XilinxVivadoFactory" t ;; (class)
           "backannotate" t ;; (pFile)
           "backbusyptr" t ;; (mFile)
           "backcast_frequency" t ;; (mFile)
           "backcast_time" t ;; (mFile)
           "backgroundPool" t ;; (mFile) Environment for running code in the background
           "backscatterBicyclist" t ;; (mFile) Backscatter radar signals from bicyclist
           "backscatterPedestrian" t ;; (mFile) Backscatter radar signals from pedestrian
           "backtestEngine" t ;; (mFile) Create backtestEngine object to backtest strategies and analyze results
           "backtestStrategy" t ;; (mFile) Create backtestStrategy object to define portfolio allocation strategy
           "bagOfFeatures" t ;; (mFile) Bag of visual words object
           "bagOfFeatures.createExtractorTemplate" t ;; (method)
           "bagOfFeaturesDBoW" t ;; (mFile) Bag of visual words using DBoW2 library
           "bagOfNgrams" t ;; (mFile) Bag-of-n-grams model
           "bagOfWords" t ;; (mFile) Bag-of-words model
           "balance" t ;; (mFile) Diagonal scaling to improve eigenvalue accuracy
           "balanceBoxLabels" t ;; (mFile) Balance bounding box labels for object detection
           "balancePixelLabels" t ;; (mFile) Balance pixel labels by oversampling block locations in large images
           "baldemo" t ;; (mFile)
           "ballode" t ;; (mFile)
           "ballrepel0" t ;; (slxFile)
           "balmr" t ;; (mFile)
           "balreal" t ;; (mFile) Balanced state-space realization
           "balrealOptions" t ;; (mFile)
           "balredOptions" t ;; (mFile) (Not recommended) Create option set for model order reduction
           "balsq" t ;; (mFile)
           "balthsrt" t ;; (mFile)
           "balunCoupledLine" t ;; (mFile) Create multisection coupled-line balun on X-Y plane
           "balunMarchand" t ;; (mFile) Create Marchand balun in microstrip form
           "baminfo" t ;; (mFile) Return information about BAM file
           "bamread" t ;; (mFile) Read data from BAM file
           "bamsort" t ;; (mFile) Sort BAM files
           "bandpass" t ;; (mFile) Bandpass-filter signals
           "bandpower" t ;; (mFile) Band power
           "bandstop" t ;; (mFile) Bandstop-filter signals
           "bandwidth" t ;; (mFile) Lower and upper matrix bandwidth
           "bar" t ;; (mFile) Bar graph
           "bar3" t ;; (mFile) 3-D bar graph
           "bar3h" t ;; (mFile) Horizontal 3-D bar graph
           "barerr" t ;; (mFile)
           "barh" t ;; (mFile) Horizontal bar graph
           "bark2hz" t ;; (mFile) Convert from Bark scale to hertz
           "barometerSensor" t ;; (mFile) Barometer sensor model with noise
           "barplot" t ;; (mex)
           "barplotm" t ;; (mFile)
           "barrageJammer" t ;; (mFile) Barrage jammer
           "barrier" t ;; (pFile) Barrier instrument object
           "barrierblseng" t ;; (mFile)
           "barrierbybls" t ;; (mFile) Price European barrier options using Black-Scholes option pricing model
           "barrierbycrr" t ;; (mFile) Price barrier option from Cox-Ross-Rubinstein binomial tree
           "barrierbyeqp" t ;; (mFile) Price barrier option from Equal Probabilities binomial tree
           "barrierbyfd" t ;; (mFile) Calculate barrier option prices using finite difference method
           "barrierbyitt" t ;; (mFile) Price barrier options using implied trinomial tree (ITT)
           "barrierbyls" t ;; (mFile) Price European or American barrier options using Monte Carlo simulations
           "barrierbystocktree" t ;; (mFile)
           "barrierbystt" t ;; (mFile) Price barrier options using standard trinomial tree
           "barrierPenalty" t ;; (mFile) Logarithmic barrier penalty value for a point with respect to a bounded region
           "barrierpricebysim" t ;; (mFile)
           "barriersensbybls" t ;; (mFile) Calculate price or sensitivities for European barrier options using Black-Scholes option pricing model
           "barriersensbyfd" t ;; (mFile) Calculate barrier option prices or sensitivities using finite difference method
           "barriersensbyls" t ;; (mFile) Calculate price and sensitivities for European or American barrier options using Monte Carlo simulations
           "barthannwin" t ;; (mFile) Modified Bartlett-Hann window
           "bartlett" t ;; (mFile) Bartlett window
           "barttest" t ;; (mFile) Bartlett’s test
           "base2dec" t ;; (mFile) Convert text representation of base-n integer to double value
           "basebandReceiver" t ;; (pFile) Configure SDR as baseband receiver
           "basebandTransceiver" t ;; (pFile) Configure SDR as baseband transceiver
           "basebandTransmitter" t ;; (pFile) Configure SDR as baseband transmitter
           "basecount" t ;; (mFile) Count nucleotides in sequence
           "baseline2Bias" t ;; (pFile)
           "baseline2BoundSignalFlatThreshold" t ;; (pFile)
           "baseline2InvertedLogical" t ;; (pFile)
           "baseline2Scaled" t ;; (pFile)
           "baseline2TimeShift" t ;; (pFile)
           "baseline2ToleranceBoundSignal" t ;; (pFile)
           "baselines.approval.ApprovalStrategy" t ;; (class)
           "baselines.constraints.BaselineableConstraint" t ;; (class)
           "baselines.constraints.BaselineableConstraint.extractActualResults" t ;; (method)
           "baselines.constraints.BaselineFileSpecification" t ;; (class)
           "baselines.constraints.BaselineSpecification" t ;; (class)
           "baselines.constraints.convertLegacySimBaselines" t ;; (function)
           "baselines.constraints.FcnHandleBaseline" t ;; (class)
           "baselines.constraints.MATFileBaseline" t ;; (class)
           "baselines.constraints.SimulationOutputBaseline" t ;; (class)
           "baselines.dataupdate.BaselineDataUpdater" t ;; (class)
           "baselines.dataupdate.BaselineDataUpdater.SupportedSpecifications" 'property
           "baselines.plugins.BaselineGenerationPlugin" t ;; (class)
           "baselookup" t ;; (mFile) Find nucleotide codes, integers, names, and complements
           "baseUnits" t ;; (mFile) Base units of unit system
           "BaseValues" t ;; (pFile)
           "basicfitdatastat" t ;; (mFile)
           "basiclmi" t ;; (mFile)
           "basketbyju" t ;; (mFile) Price European basket options using Nengjiu Ju approximation model
           "basketbyls" t ;; (mFile) Price European or American basket options using Monte Carlo simulations
           "basketsensbyju" t ;; (mFile) Determine European basket options price or sensitivities using Nengjiu Ju approximation model
           "basketsensbyls" t ;; (mFile) Calculate price and sensitivities for European or American basket options using Monte Carlo simulations
           "basketsenseng" t ;; (mFile)
           "basketstockspec" t ;; (mFile) Specify basket stock structure using Longstaff-Schwartz model
           "batch" t ;; (mFile) Run MATLAB script or function on worker
           "batchNormalizationLayer" t ;; (mFile) Batch normalization layer
           "batchsim" t ;; (pFile) Offload simulations to run on a compute cluster
           "batchStartupOptionUsed" t ;; (mFile) Determine if MATLAB started with -batch option
           "bates" t ;; (mFile) Bates stochastic volatility model
           "batonode" t ;; (mFile)
           "batt.bms.lib" t ;; (function)
           "batt.cells.batteryCalendarAging" t ;; (function)
           "batt.cells.batteryCyclingAging" t ;; (function)
           "batt.cells.batteryEquivalentCircuit" t ;; (function)
           "batt.cells.batteryFaults" t ;; (function)
           "batt.cells.batteryRCEquivalentCircuitTableBased" t ;; (function)
           "batt.cells.electrochemical.batteryFaults" t ;; (function)
           "batt.cells.electrochemical.batterySingleParticle" t ;; (function)
           "batt.cells.electrochemical.electrode" t ;; (function)
           "batt.cells.electrochemical.electrolyte" t ;; (function)
           "batt.cells.electrochemical.lib" t ;; (function)
           "batt.cells.electrochemical.reactionKinetics" t ;; (function)
           "batt.cells.fuelCellDynamicOverpotential" t ;; (function)
           "batt.cells.fuelCellEquivalentCircuit" t ;; (function)
           "batt.cells.fuelCellMembrane" t ;; (function)
           "batt.cells.fuelCellPotential" t ;; (function)
           "batt.cells.lib" t ;; (function)
           "batt.cells.parameterCyclingChange" t ;; (function)
           "batt.cells.thermalHeightDistributedMass" t ;; (function)
           "batt.cells.thermalLumpedMass" t ;; (function)
           "batt.cells.variableResistor" t ;; (function)
           "batt.connectors.arrayOfElectricalNodesConnector" t ;; (function)
           "batt.connectors.lib" t ;; (function)
           "batt.cyclers.charger" t ;; (function)
           "batt.cyclers.cycler" t ;; (function)
           "batt.cyclers.discharger" t ;; (function)
           "batt.cyclers.lib" t ;; (function)
           "batt.datasheet.cells.BatteryEquivalentCircuitDigitalDatasheet" t ;; (function)
           "batt.datasheet.cells.BatteryEquivalentCircuitUtility" t ;; (class)
           "batt.datasheet.cells.BatteryEquivalentCircuitUtility.BlockLibraryPath" 'property
           "batt.datasheet.cells.BatteryEquivalentCircuitUtility.DatasheetBlock" 'property
           "batt.datasheet.getBlockParameters" t ;; (function)
           "batt.hil.active" t ;; (function)
           "batt.hil.lib" t ;; (function)
           "batt.hil.passive" t ;; (function)
           "batt.hil.passiveBalancingInterface" t ;; (function)
           "batt.lib" t ;; (function)
           "batt.sl_postprocess" t ;; (function)
           "batt.thermal.arrayOfThermalNodesConnector" t ;; (function)
           "batt.thermal.coolingChannelsMapping" t ;; (function)
           "batt.thermal.coolingPlateDimensions" t ;; (function)
           "batt.thermal.coolingPlateFlatPlate" t ;; (function)
           "batt.thermal.coolingPlateFlatSheet" t ;; (function)
           "batt.thermal.coolingPlateNodeMapping" t ;; (function)
           "batt.thermal.coolingPlateWithEdgeCooling" t ;; (function)
           "batt.thermal.coolingPlateWithFlatChannels" t ;; (function)
           "batt.thermal.coolingPlateWithParallelChannels" t ;; (function)
           "batt.thermal.lib" t ;; (function)
           "batt_customizelibdef" t ;; (mFile)
           "batt_lib" t ;; (slxFile)
           "batt_private" t ;; (pFile)
           "batt_sl_lib" t ;; (slxFile)
           "battery.control.estimators.ComputeQhatLeastSquares" t ;; (function)
           "battery.control.estimators.CovarianceUpdate" t ;; (function)
           "battery.control.estimators.UnscentedTransformationUpdate" t ;; (function)
           "Battery.DistributedParameterManager" t ;; (class)
           "Battery.getSimulationOutputs" t ;; (function)
           "Battery.loadDataFromMatFile" t ;; (function)
           "Battery.lookupSocFromVoltage" t ;; (function)
           "battery.mask.callbackCoolantControlStrategy" t ;; (function)
           "battery.mask.callbackLeastSquaresAlgorithm" t ;; (function)
           "battery.mask.callbackPopupChargeDynamics" t ;; (function)
           "battery.mask.callbackPopupKalmanFilter" t ;; (function)
           "battery.mask.callbackPopupLeastSquaresAlgorithm" t ;; (function)
           "battery.mask.callbackTypeKalmanFilter" t ;; (function)
           "battery.mask.callbackTypeKalmanFilterStateEstimation" t ;; (function)
           "battery.mask.initializeCapacityEstimator" t ;; (function)
           "battery.mask.initializeCapacityEstimatorLeastSquares" t ;; (function)
           "battery.mask.initializeCCCV" t ;; (function)
           "battery.mask.initializeCellContactMonitoring" t ;; (function)
           "battery.mask.initializeChargingDischargingLimits" t ;; (function)
           "battery.mask.initializeCoolantControl" t ;; (function)
           "battery.mask.initializeCoulombCounter" t ;; (function)
           "battery.mask.initializeCurrentInputPartition" t ;; (function)
           "battery.mask.initializeCurrentMonitoring" t ;; (function)
           "battery.mask.initializeDeltaSOCKalmanFilter" t ;; (function)
           "battery.mask.initializeEnergyCounting" t ;; (function)
           "battery.mask.initializeFaultQualification" t ;; (function)
           "battery.mask.initializeHeaterControl" t ;; (function)
           "battery.mask.initializeKalmanFilter" t ;; (function)
           "battery.mask.initializeKalmanFilterSoe" t ;; (function)
           "battery.mask.initializePassiveCellBalancing" t ;; (function)
           "battery.mask.initializePowerEstimator" t ;; (function)
           "battery.mask.initializeSOHEstimator" t ;; (function)
           "battery.mask.initializeSOHEstimatorCapacityBased" t ;; (function)
           "battery.mask.initializeTemperatureMonitoring" t ;; (function)
           "battery.mask.initializeVoltageMonitoring" t ;; (function)
           "battery.mask.refreshVariants" t ;; (function)
           "Battery.MetaData" t ;; (class)
           "Battery.Parameters" t ;; (class)
           "Battery.Pulse" t ;; (class)
           "Battery.PulseSequence" t ;; (class)
           "Battery.repairTimeVector" t ;; (function)
           "battery_builder_rtmsupport" t ;; (pFile)
           "Battery_class" t ;; (pFile)
           "battery_sli_rtmsupport" t ;; (pFile)
           "BatteryBalancing" t ;; (slxFile)
           "batteryBuilder" t ;; (pFile)
           "BatteryCallback" t ;; (pFile)
           "batteryCell" t ;; (pFile) Create single electrochemical battery cell
           "batteryCellModelBlock" t ;; (pFile) Set of conditional parameters for Cell object
           "batteryChart" t ;; (pFile) Visualize battery objects
           "BatteryCurrentManagement" t ;; (slxFile)
           "batteryCylindricalGeometry" t ;; (pFile) Cylindrical geometry for battery cell
           "batteryecm.battery" t ;; (function)
           "batteryecm.lib" t ;; (function)
           "batteryecm.sl_postprocess" t ;; (function)
           "batteryecm.table_battery" t ;; (function)
           "batteryecm.tableBatteryCalendarAging" t ;; (function)
           "batteryecm.tableBatteryCyclingAging" t ;; (function)
           "batteryecm.tableBatteryEquivalentCircuit" t ;; (function)
           "batteryecm.tableBatteryThermalLumpedMass" t ;; (function)
           "batteryecm_lib" t ;; (slxFile)
           "batteryecmdocfcn" t ;; (pFile)
           "batteryecmlibdef" t ;; (pFile)
           "BatteryEstim3RC_PTBS" t ;; (slxFile)
           "BatteryEstim3RC_PTBS_EQ" t ;; (slxFile)
           "BatteryEstimators" t ;; (slxFile)
           "batteryModule" t ;; (pFile) Create module of battery parallel assemblies
           "batteryModuleAssembly" t ;; (pFile) Create assembly of battery modules
           "batteryPack" t ;; (pFile) Create pack of module assemblies
           "BatteryPack.battery_cell" t ;; (function)
           "BatteryPack.battery_pack" t ;; (function)
           "BatteryPack_lib" t ;; (slxFile)
           "batteryParallelAssembly" t ;; (pFile) Create parallel assembly of battery cells
           "BatteryParamInit" t ;; (pFile)
           "batteryPouchGeometry" t ;; (pFile) Pouch geometry for battery cell
           "BatteryPowerEstimators" t ;; (slxFile)
           "batteryPrismaticGeometry" t ;; (pFile) Prismatic geometry for battery cell
           "BatteryProtection" t ;; (slxFile)
           "batterySimulationChart" t ;; (pFile) Dynamically visualize battery objects
           "batterySimulationLog" t ;; (pFile) Store logged Simscape simulation data of battery block in Simulink model
           "BatterySoeEstimators" t ;; (slxFile)
           "batteryTestDataParser" t ;; (mFile) Convert data produced by battery lab testing into a format that is compatible with analysis and feature extraction
           "batteryTestFeatureExtractor" t ;; (mFile) Specify feature set to extract from parsed battery cycling data
           "BatteryThermalManagement" t ;; (slxFile)
           "BatteryThermalRunaway.battery_thermalRunaway" t ;; (function)
           "BatteryThermalRunaway.battery_thermalRunawayConduction" t ;; (function)
           "BatteryThermalRunaway.battery_thermalRunawayMass" t ;; (function)
           "BatteryThermalRunaway_lib" t ;; (slxFile)
           "bawpriceeng" t ;; (mFile)
           "BayesianOptimization" t ;; (mFile) Bayesian optimization results
           "bayeslm" t ;; (mFile) Create Bayesian linear regression model object
           "bayesopt" t ;; (mFile) Select optimal machine learning hyperparameters using Bayesian optimization
           "bayesoptim.anyFlagsSet" t ;; (function)
           "bayesoptim.augmentVariableDescriptionsForASHA" t ;; (function)
           "bayesoptim.BayesOptGPModel" t ;; (class)
           "bayesoptim.BayesOptModel" t ;; (class)
           "bayesoptim.BayesoptOptions" t ;; (class)
           "bayesoptim.BayesoptOptions.DefaultMaxObjectiveEvaluations" t ;; (method)
           "bayesoptim.BayesoptOptions.DefaultMaxTime" t ;; (method)
           "bayesoptim.BayesoptParallel" t ;; (class)
           "bayesoptim.BayesOptPrint" t ;; (class)
           "bayesoptim.BayesOptPrintFitauto" t ;; (class)
           "bayesoptim.BayesOptRFModel" t ;; (class)
           "bayesoptim.callObjFcnParallel" t ;; (function)
           "bayesoptim.ClassificationMultiModelOptim" t ;; (class)
           "bayesoptim.ClassificationMultiModelOptim.AllLearners" 'property
           "bayesoptim.ClassificationMultiModelOptim.FitFunctions" 'property
           "bayesoptim.err" t ;; (function)
           "bayesoptim.expectedImprovement" t ;; (function)
           "bayesoptim.expectedImprovementPerSecond" t ;; (function)
           "bayesoptim.fitrmultigp" t ;; (function)
           "bayesoptim.fitrmultirf" t ;; (function)
           "bayesoptim.fminsearch" t ;; (function)
           "bayesoptim.funStd" t ;; (function)
           "bayesoptim.GPStrategy" t ;; (class)
           "bayesoptim.holdOn" t ;; (function)
           "bayesoptim.infoString" t ;; (function)
           "bayesoptim.intCodeCategorical" t ;; (function)
           "bayesoptim.isAllFiniteReal" t ;; (function)
           "bayesoptim.isAllFiniteRealOrNaN" t ;; (function)
           "bayesoptim.isCharInCellstr" t ;; (function)
           "bayesoptim.isInteger" t ;; (function)
           "bayesoptim.isLogicalScalar" t ;; (function)
           "bayesoptim.isLowerBoundedIntScalar" t ;; (function)
           "bayesoptim.isNonnegativeInteger" t ;; (function)
           "bayesoptim.isNonnegativeRealScalar" t ;; (function)
           "bayesoptim.isPlusMinusOneOrNaN" t ;; (function)
           "bayesoptim.lowerConfidenceBound" t ;; (function)
           "bayesoptim.message" t ;; (function)
           "bayesoptim.ModelStrategy" t ;; (class)
           "bayesoptim.MultiGP" t ;; (class)
           "bayesoptim.MultiGPStrategy" t ;; (class)
           "bayesoptim.MultiModelOptim" t ;; (class)
           "bayesoptim.MultiModelOptim.AllLearners" 'property
           "bayesoptim.MultiModelOptim.FitFunctions" 'property
           "bayesoptim.MultiModelOptimOptions" t ;; (class)
           "bayesoptim.MultiTreeBagger" t ;; (class)
           "bayesoptim.MultiTreeBaggerStrategy" t ;; (class)
           "bayesoptim.NDGrid" t ;; (function)
           "bayesoptim.parseArgValue" t ;; (function)
           "bayesoptim.printInfo" t ;; (function)
           "bayesoptim.printInfoNoReturn" t ;; (function)
           "bayesoptim.probabilityOfImprovement" t ;; (function)
           "bayesoptim.RegressionMultiModelOptim" t ;; (class)
           "bayesoptim.RegressionMultiModelOptim.AllLearners" 'property
           "bayesoptim.RegressionMultiModelOptim.FitFunctions" 'property
           "bayesoptim.reverse" t ;; (function)
           "bayesoptim.RFStrategy" t ;; (class)
           "bayesoptim.setAxesScaleAndLimits" t ;; (function)
           "bayesoptim.SingleTreeBaggerStrategy" t ;; (class)
           "bayesoptim.suppressWarnings" t ;; (function)
           "bayesoptim.uniformPointsWithinBounds" t ;; (function)
           "bayesoptim.updateMaxObjectiveEvaluations" t ;; (function)
           "bayesoptim.VariableSpecification" t ;; (class)
           "bayesoptim.VariableSpecification.loadobj" t ;; (method)
           "bayesoptim.warn" t ;; (function)
           "bayesvarm" t ;; (mFile) Create prior Bayesian vector autoregression (VAR) model object
           "bbalgodef" t ;; (mFile)
           "bbdesign" t ;; (mFile) Box-Behnken design
           "bbox2points" t ;; (mFile) Convert rectangle to corner points list
           "bboxCameraToLidar" t ;; (mFile) Estimate 3-D bounding boxes in point cloud from 2-D bounding boxes in image
           "bboxcrop" t ;; (mFile) Crop bounding boxes
           "bboxerase" t ;; (mFile) Remove bounding boxes
           "bboxLidarToCamera" t ;; (mFile) Estimate 2-D bounding box in camera frame using 3-D bounding box in lidar frame
           "bboxOverlapRatio" t ;; (mFile) Compute bounding box overlap ratio
           "bboxPrecisionRecall" t ;; (mFile) Compute bounding box precision and recall against ground truth
           "bboxresize" t ;; (mFile) Resize bounding boxes
           "bboxwarp" t ;; (mFile) Apply geometric transformation to bounding boxes
           "bchcore" t ;; (mFile)
           "bchdec" t ;; (mFile) BCH decoder
           "bchenc" t ;; (mFile) BCH encoder
           "bchgenpoly" t ;; (mFile) Produce generator polynomials for BCH code
           "bchnumerr" t ;; (mFile) Number of correctable errors for BCH code
           "bcstCreateCap" t ;; (pFile)
           "bcstHighLight" t ;; (pFile)
           "bdclose" t ;; (pFile) Close any or all Simulink model windows unconditionally
           "bdIsDirty" t ;; (pFile) Determine whether model, subsystem, or library has unsaved changes
           "bdIsLibrary" t ;; (pFile) Determine whether model is library
           "bdIsLoaded" t ;; (pFile) Determine whether model, subsystem, or library is loaded
           "bdIsSubsystem" t ;; (pFile) Determine whether model is subsystem
           "bdqz" t ;; (mFile) Block-diagonal QZ decomposition
           "bdroot" t ;; (mFile) Top-level model of current system
           "bdschur" t ;; (mFile) Block-diagonal Schur factorization
           "bdtfindeffrates" t ;; (mFile)
           "bdtprice" t ;; (mFile) Instrument prices from Black-Derman-Toy interest-rate tree
           "bdtsens" t ;; (mFile) Instrument prices and sensitivities from Black-Derman-Toy interest-rate tree
           "bdttimespec" t ;; (mFile) Specify time structure for Black-Derman-Toy interest-rate tree
           "bdttree" t ;; (mFile) Build Black-Derman-Toy interest-rate tree
           "bdttreetime" t ;; (mFile)
           "bdtvolspec" t ;; (mFile) Specify Black-Derman-Toy interest-rate volatility process
           "beagleboard" t ;; (slxFile)
           "beamdwellfactor" t ;; (mFile) Range-dependent loss for rapidly scanning beam
           "beamloss" t ;; (mFile) Beam shape loss for Gaussian antenna pattern
           "beamwidth2ap" t ;; (mFile) Computes aperture length of unweighted antenna from beamwidth
           "beamwidth2gain" t ;; (mFile) Compute antenna gain from azimuth and elevation beamwidths
           "bearingFaultBands" t ;; (mFile) Generate frequency bands around the characteristic fault frequencies of ball or roller bearings for spectral feature extraction
           "beat2range" t ;; (mFile) Convert beat frequency to range
           "beep" t ;; (mFile) Produce operating system beep sound
           "behrmann" t ;; (mFile)
           "bellir" t ;; (mFile)
           "bench" t ;; (mFile) MATLAB benchmark
           "bendCurved" t ;; (mFile) Create curved bend shape on X-Y plane
           "bendCurved.isRFPCBPart" 'property
           "bendMitered" t ;; (mFile) Create mitered bend shape on X-Y plane
           "bendMitered.isRFPCBPart" 'property
           "bendRightAngle" t ;; (mFile) Create right-angle bend shape on X-Y plane
           "bendRightAngle.isRFPCBPart" 'property
           "berawgn" t ;; (mFile) BER and SER for uncoded data over AWGN channels
           "bercoding" t ;; (mFile) BER for coded AWGN channels
           "berconfint" t ;; (mFile) Error probability estimate and confidence interval of Monte Carlo simulation
           "berfading" t ;; (mFile) BER and SER for uncoded data over Rayleigh and Rician fading channels
           "berfit" t ;; (mFile) Fit curve to nonsmooth empirical BER data
           "berlekampDecode" t ;; (mex)
           "bernstein" t ;; (mFile) Bernstein polynomials
           "bernsteinMatrix" t ;; (mFile) Bernstein matrix
           "bersync" t ;; (mFile) BER for imperfect synchronization
           "bert" t ;; (mFile) Pretrained BERT model
           "bertDocumentClassifier" t ;; (mFile) BERT document classifier
           "bertool" t ;; (mlappFile) Analyze BER performance of communications systems
           "bertool.loadobj" t ;; (method)
           "bertooltemplate" t ;; (mFile)
           "bertTokenizer" t ;; (mFile) WordPiece BERT tokenizer
           "besselap" t ;; (mFile) Bessel analog lowpass filter prototype
           "besself" t ;; (mFile) Bessel analog filter design
           "besselh" t ;; (mFile) Bessel function of third kind (Hankel function)
           "besseli" t ;; (mFile) Modified Bessel function of first kind
           "besselj" t ;; (mFile) Bessel function of first kind
           "besselk" t ;; (mFile) Modified Bessel function of second kind
           "bessely" t ;; (mFile) Bessel function of second kind
           "bestblk" t ;; (mFile) Determine optimal block size for block processing
           "bestMemberData" t ;; (pFile)
           "beta" t ;; (mFile) Beta function
           "betacdf" t ;; (mFile) Beta cumulative distribution function
           "betafit" t ;; (mFile) Beta parameter estimates
           "betainc" t ;; (mFile) Incomplete beta function
           "betaincinv" t ;; (mFile) Beta inverse cumulative distribution function
           "betainv" t ;; (mFile) Beta inverse cumulative distribution function
           "betalike" t ;; (mFile) Beta negative log-likelihood
           "betaln" t ;; (mFile) Logarithm of beta function
           "betapdf" t ;; (mFile) Beta probability density function
           "betarnd" t ;; (mFile) Beta random numbers
           "betastat" t ;; (mFile) Beta mean and variance
           "beytbill" t ;; (mFile) Bond equivalent yield for Treasury bill
           "bfloat16" t ;; (mFile)
           "bfscore" t ;; (mFile) Contour matching score for image segmentation
           "bhattacharyyaDistance" t ;; (mFile) One-dimensional Bhattacharyya distance between two independent data groups to measure class separability
           "bi2de" t ;; (mFile) (Not recommended) Convert Binary to Base-P
           "bicg" t ;; (mFile) Solve system of linear equations — biconjugate gradients method
           "bicgstab" t ;; (mFile) Solve system of linear equations — stabilized biconjugate gradients method
           "bicgstabl" t ;; (mFile) Solve system of linear equations — stabilized biconjugate gradients (l) method
           "bicone" t ;; (mFile) Create biconical antenna
           "biconeStrip" t ;; (mFile) Create stripped biconical antenna
           "bicycleKinematics" t ;; (mFile) Bicycle vehicle model
           "bigaussianir" t ;; (mFile)
           "bigimage" t ;; (mFile) (To be removed) Out-of-core processing of very large images
           "bigimage.isTIFF" t ;; (method)
           "bigimage.loadobj" t ;; (method)
           "bigimageDatastore" t ;; (mFile) (To be removed) Datastore to manage blocks of bigimage data
           "bigimageDatastore.loadobj" t ;; (method)
           "bigimageshow" t ;; (pFile) Display 2-D blockedImage object
           "BilevelMeasurementsConfiguration" t ;; (pFile) Measure transitions, aberrations, and cycles of bilevel signals
           "bilexp" t ;; (mFile)
           "bilin" t ;; (mFile) Multivariable bilinear transform of frequency (s or z)
           "bilinear" t ;; (mFile) Bilinear transformation method for analog-to-digital filter conversion
           "bilins2z" t ;; (mFile)
           "bilinz2s" t ;; (mFile)
           "billingsleyicm" t ;; (mFile) Billingsley’s intrinsic clutter motion (ICM) model
           "bilstmLayer" t ;; (mFile) Bidirectional long short-term memory (BiLSTM) layer for recurrent neural network (RNN)
           "bin2dec" t ;; (mFile) Convert text representation of binary integer to double value
           "binaryFeatures" t ;; (mFile) Object for storing binary feature vectors
           "binaryintloss" t ;; (mFile) Loss due to M-of-N binary pulse integration
           "binaryOccupancyMap" t ;; (mFile) Create occupancy grid with binary values
           "binaryOccupancyMap.loadobj" t ;; (method)
           "bind" t ;; (mFile) Connect app components to simulation signals and variables
           "BindMode.AssessmentsSourceData" t ;; (class)
           "BindMode.BindableData" t ;; (class)
           "BindMode.BindableData.fromStruct" t ;; (method)
           "BindMode.BindableMetaData" t ;; (class)
           "BindMode.BindableRow" t ;; (class)
           "BindMode.BindableTypeEnum" t ;; (class)
           "BindMode.BindableTypeEnum.BUSLEAFSIGNAL" 'enumeration
           "BindMode.BindableTypeEnum.BUSOBJECT" 'enumeration
           "BindMode.BindableTypeEnum.DSM" 'enumeration
           "BindMode.BindableTypeEnum.EXPRESSION" 'enumeration
           "BindMode.BindableTypeEnum.getEnumTypeFromChar" t ;; (method)
           "BindMode.BindableTypeEnum.NONE" 'enumeration
           "BindMode.BindableTypeEnum.SFCHART" 'enumeration
           "BindMode.BindableTypeEnum.SFDATA" 'enumeration
           "BindMode.BindableTypeEnum.SFSTATE" 'enumeration
           "BindMode.BindableTypeEnum.SIMSCAPEVARIABLE" 'enumeration
           "BindMode.BindableTypeEnum.SLPARAMETER" 'enumeration
           "BindMode.BindableTypeEnum.SLPORT" 'enumeration
           "BindMode.BindableTypeEnum.SLSIGNAL" 'enumeration
           "BindMode.BindableTypeEnum.VARIABLE" 'enumeration
           "BindMode.BindingTableDialog" t ;; (class)
           "BindMode.BindModeSelectionData" t ;; (class)
           "BindMode.BindModeSourceData" t ;; (class)
           "BindMode.ClientNameEnum" t ;; (class)
           "BindMode.ClientNameEnum.APPDESIGNER" 'enumeration
           "BindMode.ClientNameEnum.ASSESSMENTS" 'enumeration
           "BindMode.ClientNameEnum.CONDITIONALS" 'enumeration
           "BindMode.ClientNameEnum.FAULTDATAINPORT" 'enumeration
           "BindMode.ClientNameEnum.HMI" 'enumeration
           "BindMode.ClientNameEnum.MAPPINGS" 'enumeration
           "BindMode.ClientNameEnum.MULTISIMBLOCKSELECTOR" 'enumeration
           "BindMode.ClientNameEnum.OBSERVERS" 'enumeration
           "BindMode.ClientNameEnum.REDUCEDORDERMODELING" 'enumeration
           "BindMode.ClientNameEnum.SIMSCAPEPROBE" 'enumeration
           "BindMode.ClientNameEnum.SLRT" 'enumeration
           "BindMode.ClientNameEnum.SSM" 'enumeration
           "BindMode.ClientNameEnum.STMSIGSELECTOR" 'enumeration
           "BindMode.ClientNameEnum.TESTCLIENT" 'enumeration
           "BindMode.ConditionalSourceData" t ;; (class)
           "BindMode.FaultDataInportSourceData" t ;; (class)
           "BindMode.HMISourceData" t ;; (class)
           "BindMode.MultiSimBlockSelectorSourceData" t ;; (class)
           "BindMode.ObserverSourceData" t ;; (class)
           "BindMode.PortSelectorSourceData" t ;; (class)
           "BindMode.SelectionStyleEnum" t ;; (class)
           "BindMode.SelectionStyleEnum.MARQUEE" 'enumeration
           "BindMode.SelectionStyleEnum.NONE" 'enumeration
           "BindMode.SelectionStyleEnum.SINGLE" 'enumeration
           "BindMode.SelectionStyleEnum.SPREADSHEET" 'enumeration
           "BindMode.SelectionTypeEnum" t ;; (class)
           "BindMode.SelectionTypeEnum.NONE" 'enumeration
           "BindMode.SelectionTypeEnum.SFDATA" 'enumeration
           "BindMode.SelectionTypeEnum.SFEVENT" 'enumeration
           "BindMode.SelectionTypeEnum.SFMESSAGE" 'enumeration
           "BindMode.SelectionTypeEnum.SFSLFUNCTION" 'enumeration
           "BindMode.SelectionTypeEnum.SFSTATE" 'enumeration
           "BindMode.SelectionTypeEnum.SFTRANSITION" 'enumeration
           "BindMode.SelectionTypeEnum.SLBLOCK" 'enumeration
           "BindMode.SelectionTypeEnum.SLSIGNAL" 'enumeration
           "BindMode.SelectionTypeEnum.VARIABLE" 'enumeration
           "BindMode.SFChartMetaData" t ;; (class)
           "BindMode.SFDataMetaData" t ;; (class)
           "BindMode.SFStateMetaData" t ;; (class)
           "BindMode.SignalOfInterestConfigData" t ;; (class)
           "BindMode.SignalSelectorSourceData" t ;; (class)
           "BindMode.SLBusElementMetaData" t ;; (class)
           "BindMode.SLDSMMetaData" t ;; (class)
           "BindMode.SLParamMetaData" t ;; (class)
           "BindMode.SLPortMetaData" t ;; (class)
           "BindMode.SLSignalMetaData" t ;; (class)
           "BindMode.STMSignalSelectorSourceData" t ;; (class)
           "BindMode.utils.combineSelectedAndConnectedRows" t ;; (function)
           "BindMode.utils.createBindableRowsFromFieldReferences" t ;; (function)
           "BindMode.utils.disableBindMode" t ;; (function)
           "BindMode.utils.expressionIsPureStructReference" t ;; (function)
           "BindMode.utils.filterSLElementsFromSelection" t ;; (function)
           "BindMode.utils.getAllEditorsForModel" t ;; (function)
           "BindMode.utils.getAllStudiosForModel" t ;; (function)
           "BindMode.utils.getBindableData" t ;; (function)
           "BindMode.utils.getBindableMetaDataFromStruct" t ;; (function)
           "BindMode.utils.getCurrentMousePosition" t ;; (function)
           "BindMode.utils.getDataStoreHandleFromReadWriteBlock" t ;; (function)
           "BindMode.utils.getDropDownElements" t ;; (function)
           "BindMode.utils.getDSMRowsInSelection" t ;; (function)
           "BindMode.utils.getHierarchicalPathArray" t ;; (function)
           "BindMode.utils.getHierarchicalPathUsingBindModeSource" t ;; (function)
           "BindMode.utils.getLastActiveEditor" t ;; (function)
           "BindMode.utils.getParameterRowsInSelection" t ;; (function)
           "BindMode.utils.getParametersUsedByBlk" t ;; (function)
           "BindMode.utils.getPureStructReferencesInBlockDialogParameters" t ;; (function)
           "BindMode.utils.getSFChartActivityInSelection" t ;; (function)
           "BindMode.utils.getSFDataInSelection" t ;; (function)
           "BindMode.utils.getSFHierarchicalPathArray" t ;; (function)
           "BindMode.utils.getSFSelectionType" t ;; (function)
           "BindMode.utils.getSFStatesInSelection" t ;; (function)
           "BindMode.utils.getSignalRowsInSelection" t ;; (function)
           "BindMode.utils.highlightElementInModel" t ;; (function)
           "BindMode.utils.highlightParameterInModel" t ;; (function)
           "BindMode.utils.highlightSignalInModel" t ;; (function)
           "BindMode.utils.isBindModeEnabled" t ;; (function)
           "BindMode.utils.isSameModelInstance" t ;; (function)
           "BindMode.utils.isSelectionAboveSource" t ;; (function)
           "BindMode.utils.mtreeRepresentsPureStructReference" t ;; (function)
           "BindMode.utils.notifySFSymbolsOfBindModeStateChange" t ;; (function)
           "BindMode.utils.onModelSelectionChange" t ;; (function)
           "BindMode.utils.onSFChartSelectionChange" t ;; (function)
           "BindMode.utils.onSFSymbolSelectionChange" t ;; (function)
           "BindMode.utils.processForSelectionInCtxModel" t ;; (function)
           "BindMode.utils.showHelperNotification" t ;; (function)
           "BindMode.VariableMetaData" t ;; (class)
           "BindMode.VarWorkspaceTypeEnum" t ;; (class)
           "BindMode.VarWorkspaceTypeEnum.BASE" 'enumeration
           "BindMode.VarWorkspaceTypeEnum.DATA_DICTIONARY" 'enumeration
           "BindMode.VarWorkspaceTypeEnum.EXTERNAL_SOURCE" 'enumeration
           "BindMode.VarWorkspaceTypeEnum.getEnumTypeFromStr" t ;; (method)
           "BindMode.VarWorkspaceTypeEnum.MODEL" 'enumeration
           "binlinfo" t ;; (mFile)
           "binlwavf" t ;; (mFile)
           "binmask2sigroi" t ;; (mFile) Convert binary mask to matrix of ROI limits
           "binningExplorer" t ;; (mFile) Bin data and export creditscorecard object or generate function
           "binningTabularSynthesizer" t ;; (mFile) Binning-based synthesizer for tabular data synthesis
           "binocdf" t ;; (mFile) Binomial cumulative distribution function
           "binofit" t ;; (mFile) Binomial parameter estimates
           "binoinv" t ;; (mFile) Binomial inverse cumulative distribution function
           "binopdf" t ;; (mFile) Binomial probability density function
           "binoptpriceeng" t ;; (mFile)
           "binornd" t ;; (mFile) Random numbers from binomial distribution
           "binostat" t ;; (mFile) Binomial mean and variance
           "binprice" t ;; (mFile) Binomial put and call American option pricing using Cox-Ross-Rubinstein model
           "binscatter" t ;; (mFile) Binned scatter plot
           "binstocktree" t ;; (mFile)
           "bintimespec" t ;; (mFile)
           "bintreetime" t ;; (mFile)
           "BioIndexedFile" t ;; (mFile) Allow quick and efficient access to large text file with nonuniform-size entries
           "bioinfo.blastplus.BLASTNOptions" t ;; (class)
           "bioinfo.blastplus.BLASTNOptions.Version" 'property
           "bioinfo.blastplus.BLASTPOptions" t ;; (class)
           "bioinfo.blastplus.BLASTPOptions.Version" 'property
           "bioinfo.blastplus.BLASTXOptions" t ;; (class)
           "bioinfo.blastplus.BLASTXOptions.Version" 'property
           "bioinfo.blastplus.Default" t ;; (class)
           "bioinfo.blastplus.MakeDatabaseOptions" t ;; (class)
           "bioinfo.blastplus.MakeDatabaseOptions.Version" 'property
           "bioinfo.blastplus.ReportFormat" t ;; (class)
           "bioinfo.blastplus.ReportFormat.BLASTArchive" 'enumeration
           "bioinfo.blastplus.ReportFormat.BLASTXML" 'enumeration
           "bioinfo.blastplus.ReportFormat.CommaSeparated" 'enumeration
           "bioinfo.blastplus.ReportFormat.FlatQuery" 'enumeration
           "bioinfo.blastplus.ReportFormat.FlatQueryNoIdentities" 'enumeration
           "bioinfo.blastplus.ReportFormat.MultiBLASTJSON" 'enumeration
           "bioinfo.blastplus.ReportFormat.MultiBLASTXML2" 'enumeration
           "bioinfo.blastplus.ReportFormat.OrganismReport" 'enumeration
           "bioinfo.blastplus.ReportFormat.Pairwise" 'enumeration
           "bioinfo.blastplus.ReportFormat.QueryAnchored" 'enumeration
           "bioinfo.blastplus.ReportFormat.QueryAnchoredNoIdentities" 'enumeration
           "bioinfo.blastplus.ReportFormat.SAM" 'enumeration
           "bioinfo.blastplus.ReportFormat.SeqalignBinary" 'enumeration
           "bioinfo.blastplus.ReportFormat.SeqalignJSON" 'enumeration
           "bioinfo.blastplus.ReportFormat.SeqalignText" 'enumeration
           "bioinfo.blastplus.ReportFormat.SingleBLASTJSON" 'enumeration
           "bioinfo.blastplus.ReportFormat.SingleBLASTXML2" 'enumeration
           "bioinfo.blastplus.ReportFormat.Tabular" 'enumeration
           "bioinfo.blastplus.ReportFormat.TabularCommented" 'enumeration
           "bioinfo.blastplus.TBLASTNOptions" t ;; (class)
           "bioinfo.blastplus.TBLASTNOptions.Version" 'property
           "bioinfo.blastplus.TBLASTXOptions" t ;; (class)
           "bioinfo.blastplus.TBLASTXOptions.Version" 'property
           "bioinfo.pipeline.Block" t ;; (class)
           "bioinfo.pipeline.block.BamSort" t ;; (class)
           "bioinfo.pipeline.block.BLASTN" t ;; (class)
           "bioinfo.pipeline.block.BLASTP" t ;; (class)
           "bioinfo.pipeline.block.BLASTX" t ;; (class)
           "bioinfo.pipeline.block.Bowtie2" t ;; (class)
           "bioinfo.pipeline.block.Bowtie2Build" t ;; (class)
           "bioinfo.pipeline.block.BwaIndex" t ;; (class)
           "bioinfo.pipeline.block.BwaMEM" t ;; (class)
           "bioinfo.pipeline.block.CuffCompare" t ;; (class)
           "bioinfo.pipeline.block.CuffDiff" t ;; (class)
           "bioinfo.pipeline.block.Cufflinks" t ;; (class)
           "bioinfo.pipeline.block.CuffMerge" t ;; (class)
           "bioinfo.pipeline.block.CuffNorm" t ;; (class)
           "bioinfo.pipeline.block.CuffQuant" t ;; (class)
           "bioinfo.pipeline.block.FeatureCount" t ;; (class)
           "bioinfo.pipeline.block.FileChooser" t ;; (class)
           "bioinfo.pipeline.block.GenomicsViewer" t ;; (class)
           "bioinfo.pipeline.block.Load" t ;; (class)
           "bioinfo.pipeline.block.MakeBlastDatabase" t ;; (class)
           "bioinfo.pipeline.block.SamSort" t ;; (class)
           "bioinfo.pipeline.block.Save" t ;; (class)
           "bioinfo.pipeline.block.SeqFilter" t ;; (class)
           "bioinfo.pipeline.block.SeqSplit" t ;; (class)
           "bioinfo.pipeline.block.SeqTrim" t ;; (class)
           "bioinfo.pipeline.block.SRAFasterqDump" t ;; (class)
           "bioinfo.pipeline.block.SRASAMDump" t ;; (class)
           "bioinfo.pipeline.block.TBLASTN" t ;; (class)
           "bioinfo.pipeline.block.TBLASTX" t ;; (class)
           "bioinfo.pipeline.block.UserFunction" t ;; (class)
           "bioinfo.pipeline.Connection" t ;; (class)
           "bioinfo.pipeline.datatype.File" t ;; (class)
           "bioinfo.pipeline.datatype.Incomplete" t ;; (class)
           "bioinfo.pipeline.datatype.ResultsPlaceholder" t ;; (class)
           "bioinfo.pipeline.datatype.Unset" t ;; (class)
           "bioinfo.pipeline.Input" t ;; (class)
           "bioinfo.pipeline.library.addLibrary" t ;; (function)
           "bioinfo.pipeline.library.getLibrary" t ;; (function)
           "bioinfo.pipeline.library.Library" t ;; (class)
           "bioinfo.pipeline.library.loadLibrary" t ;; (function)
           "bioinfo.pipeline.library.removeLibrary" t ;; (function)
           "bioinfo.pipeline.library.saveLibrary" t ;; (function)
           "bioinfo.pipeline.LogLevel" t ;; (class)
           "bioinfo.pipeline.LogLevel.Debug" 'enumeration
           "bioinfo.pipeline.LogLevel.Error" 'enumeration
           "bioinfo.pipeline.LogLevel.Info" 'enumeration
           "bioinfo.pipeline.LogLevel.Off" 'enumeration
           "bioinfo.pipeline.LogLevel.Warn" 'enumeration
           "bioinfo.pipeline.options.FeatureCountOptions" t ;; (class)
           "bioinfo.pipeline.options.SeqFilterOptions" t ;; (class)
           "bioinfo.pipeline.options.SeqSplitOptions" t ;; (class)
           "bioinfo.pipeline.options.SeqTrimOptions" t ;; (class)
           "bioinfo.pipeline.Output" t ;; (class)
           "bioinfo.pipeline.Pipeline" t ;; (class)
           "bioinfo.pipeline.RunMode" t ;; (class)
           "bioinfo.pipeline.RunMode.Full" 'enumeration
           "bioinfo.pipeline.RunMode.Minimal" 'enumeration
           "bioinfo.pipeline.RunStatus" t ;; (class)
           "bioinfo.pipeline.RunStatus.Completed" 'enumeration
           "bioinfo.pipeline.RunStatus.Error" 'enumeration
           "bioinfo.pipeline.RunStatus.Queued" 'enumeration
           "bioinfo.pipeline.RunStatus.Running" 'enumeration
           "bioinfo.pipeline.RunStatus.Waiting" 'enumeration
           "bioinfo.sra.SplitType" t ;; (class)
           "bioinfo.sra.SplitType.create" t ;; (method)
           "bioinfo.sra.SplitType.fromFlagName" t ;; (method)
           "bioinfo.sra.SplitType.SplitFiles" 'enumeration
           "bioinfo.sra.SplitType.SplitSpot" 'enumeration
           "bioinfo.sra.SplitType.SplitThree" 'enumeration
           "bioinfochecknargin" t ;; (mFile)
           "bioinfoprivate.affinegapmex" t ;; (function)
           "bioinfoprivate.AnnotationDataAdapter" t ;; (class)
           "bioinfoprivate.BAMIndexedFile" t ;; (class)
           "bioinfoprivate.BAMSequenceDataAdapter" t ;; (class)
           "bioinfoprivate.BIFAnnotationDataAdapter" t ;; (class)
           "bioinfoprivate.BIFSequenceDataAdapter" t ;; (class)
           "bioinfoprivate.bioclsrethrow" t ;; (function)
           "bioinfoprivate.bioerrorrethrow" t ;; (function)
           "bioinfoprivate.bioFigureHelpMenu" t ;; (function)
           "bioinfoprivate.bioReadMixedData" t ;; (function)
           "bioinfoprivate.bioToggleListenerState" t ;; (function)
           "bioinfoprivate.CellAnnotationDataAdapter" t ;; (class)
           "bioinfoprivate.cigar2endmex" t ;; (function)
           "bioinfoprivate.cigar2gappedsequence" t ;; (function)
           "bioinfoprivate.cigar2gappedsequencemex" t ;; (function)
           "bioinfoprivate.cigar2segmentsmex" t ;; (function)
           "bioinfoprivate.colorSpecLookUp" t ;; (function)
           "bioinfoprivate.createMenuItem" t ;; (function)
           "bioinfoprivate.createToolbarButton" t ;; (function)
           "bioinfoprivate.DatasetAnnotationDataAdapter" t ;; (class)
           "bioinfoprivate.getCountsByRangemex" t ;; (function)
           "bioinfoprivate.getCountsByRangeNSmex" t ;; (function)
           "bioinfoprivate.getCoverageBaseByBasemex" t ;; (function)
           "bioinfoprivate.getIndexByRangemex" t ;; (function)
           "bioinfoprivate.indexedFigureName" t ;; (function)
           "bioinfoprivate.isaa" t ;; (function)
           "bioinfoprivate.isdna" t ;; (function)
           "bioinfoprivate.isnt" t ;; (function)
           "bioinfoprivate.isrna" t ;; (function)
           "bioinfoprivate.localalignmex" t ;; (function)
           "bioinfoprivate.masmooth" t ;; (function)
           "bioinfoprivate.MemoryMappedFastaFile" t ;; (class)
           "bioinfoprivate.optAlphabet" t ;; (function)
           "bioinfoprivate.optPartialMatch" t ;; (function)
           "bioinfoprivate.opttf" t ;; (function)
           "bioinfoprivate.pvpair" t ;; (function)
           "bioinfoprivate.readIcon" t ;; (function)
           "bioinfoprivate.seqfromstruct" t ;; (function)
           "bioinfoprivate.seqread" t ;; (function)
           "bioinfoprivate.SequenceDataAdapter" t ;; (class)
           "bioinfoprivate.simplegapmex" t ;; (function)
           "bioinfoprivate.StructAnnotationDataAdapter" t ;; (class)
           "bioinfoprivate.structSequenceDataAdapter" t ;; (class)
           "bioinfoprivate.taggedFigureIndex" t ;; (function)
           "bioinfoprivate.toggleState" t ;; (function)
           "bioinfoprivate.uisav" t ;; (class)
           "bioinfoservices.bioinfoAbout" t ;; (function)
           "bioinfoservices.bioinfoComponentHelp" t ;; (function)
           "bioinfoservices.bioinfoFeedback" t ;; (function)
           "bioinfoservices.bioinfoHelp" t ;; (function)
           "biolearning.classperformance" t ;; (class)
           "bioma.AExperiment" t ;; (class)
           "bioma.data.DataMatrix" t ;; (class)
           "bioma.data.ExptData" t ;; (class)
           "bioma.data.MetaData" t ;; (class)
           "bioma.data.MIAME" t ;; (class)
           "bioma.ExpressionSet" t ;; (class)
           "bioma.util.appendUniqueNumToNames" t ;; (function)
           "bioma.util.catCellStrToStr" t ;; (function)
           "bioma.util.disableHGBehaviors" t ;; (function)
           "bioma.util.errorUnknownNames" t ;; (function)
           "bioma.util.findLabelIndices" t ;; (function)
           "bioma.util.isColon" t ;; (function)
           "bioma.util.isString" t ;; (function)
           "bioma.util.nameList" t ;; (function)
           "bioma.util.parentResizeCB" t ;; (function)
           "bioma.util.printOneLineMultiNames" t ;; (function)
           "bioma.util.setDimNames" t ;; (function)
           "bioma.util.validateMatrix" t ;; (function)
           "bioma.util.validateMethodProps" t ;; (function)
           "BioMap" t ;; (mFile) Contain sequence, quality, alignment, and mapping data
           "biopipelineDesigner" t ;; (mFile)
           "BioRead" t ;; (mFile) Contain sequence reads and their quality data
           "biorfilt" t ;; (mFile) Biorthogonal wavelet filter set
           "biorlift" t ;; (mFile)
           "biorwavf" t ;; (mFile) Biorthogonal spline wavelet filter
           "BioSeq" t ;; (mFile)
           "biplot" t ;; (mFile) Biplot
           "bipolaradc" t ;; (mFile)
           "biquad" t ;; (mFile) Create biquad or double-biquad antenna
           "birdcage" t ;; (mFile) Creates birdcage (MRI coil)
           "birdsEyePlot" t ;; (mFile) Plot detections, tracks, and sensor coverages around vehicle
           "birdsEyeView" t ;; (mFile) Create bird's-eye view using inverse perspective mapping
           "bisenetv2" t ;; (mFile) Create BiSeNet v2 convolutional neural network for semantic segmentation
           "Bistable_class" t ;; (pFile)
           "BistableInit" t ;; (pFile)
           "bistaticConstantSNR" t ;; (mFile) Create bistatic constant SNR contours or surfaces
           "bistaticFreeSpacePath" t ;; (mFile) Bistatic free space propagation path
           "bistaticposest" t ;; (mFile) Estimate position of targets using bistatic range/range sum and angle-of-arrival measurements
           "bistaticReceiver" t ;; (mFile) Create bistatic receiver
           "bistaticReceiver.matlabCodegenNontunableProperties" t ;; (method)
           "bistaticTransmitter" t ;; (mFile) Create bistatic transmitter
           "bistaticTransmitter.matlabCodegenNontunableProperties" t ;; (method)
           "bistaticTransmitter.matlabCodegenOnceNames" t ;; (method)
           "bit2int" t ;; (mFile) Convert bits to integers
           "bitand" t ;; (mFile) Bit-wise AND
           "bitcmp" t ;; (mFile) Bit-wise complement
           "bitconcat" t ;; (mFile) Concatenate bits of fi objects
           "biterr" t ;; (mFile) Compute number of bit errors and bit error rate (BER)
           "bitget" t ;; (mFile) Get bit at specified position
           "bitor" t ;; (mFile) Bit-wise OR
           "bitrevorder" t ;; (mFile) Permute data into bit-reversed order
           "bitset" t ;; (mFile) Set bit at specific location
           "bitshift" t ;; (mFile) Shift bits specified number of places
           "bitsll" t ;; (mFile) Bit shift left logical
           "bitsra" t ;; (mFile) Bit shift right arithmetic
           "bitsrl" t ;; (mFile) Bit shift right logical
           "bitxor" t ;; (mFile) Bit-wise XOR
           "bj" t ;; (mFile) Estimate Box-Jenkins polynomial model using time-domain data
           "bjOptions" t ;; (mFile) Option set for bj
           "bjspriceeng" t ;; (mFile)
           "bkbrk" t ;; (mFile) Part(s) of almost block-diagonal matrix
           "bkcall" t ;; (mFile) Price European call option on bonds using Black model
           "bkfilter" t ;; (mFile) Baxter-King filter for trend and cyclical components
           "bkprice" t ;; (mFile) Instrument prices from Black-Karasinski interest-rate tree
           "bkput" t ;; (mFile) Price European put option on bonds using Black model
           "bksens" t ;; (mFile) Instrument prices and sensitivities from Black-Karasinski interest-rate tree
           "bktimespec" t ;; (mFile) Specify time structure for Black-Karasinski tree
           "bktree" t ;; (mFile) Build Black-Karasinski interest-rate tree
           "bkvolspec" t ;; (mFile) Specify Black-Karasinski interest-rate volatility process
           "blackimage" t ;; (mFile)
           "blackman" t ;; (mFile) Blackman window
           "blackmanharris" t ;; (mFile) Minimum four-term Blackman-Harris window
           "blackvolbyrebonato" t ;; (mFile) Compute Black volatility for LIBOR Market Model using Rebonato formula
           "blackvolbysabr" t ;; (mFile) Calculate implied Black volatility using SABR model
           "blakechart" t ;; (mFile) Range-angle-height (Blake) chart
           "blanks" t ;; (mFile) Create character array of blanks
           "blastncbi" t ;; (mFile) Create remote NCBI BLAST report request ID or link to NCBI BLAST report
           "blastplus" t ;; (mFile) Search local BLAST+ database
           "blastplusdatabase" t ;; (mFile) Create a local BLAST+ database
           "blastplusoptions" t ;; (mFile) Create options for BLAST query program
           "blastread" t ;; (mFile) Read data from NCBI BLAST report file
           "ble" t ;; (mFile) Connect to Bluetooth Low Energy peripheral device
           "bleAngleEstimate" t ;; (mFile) Estimate AoA or AoD of Bluetooth LE signal
           "bleAngleEstimateConfig" t ;; (mFile) Bluetooth LE angle estimation configuration parameters
           "bleATTPDU" t ;; (mFile) Generate Bluetooth LE ATT PDU
           "bleATTPDUConfig" t ;; (mFile) Bluetooth LE ATT PDU configuration parameters
           "bleATTPDUDecode" t ;; (mFile) Decode Bluetooth LE ATT PDU
           "bleChannelSelection" t ;; (mFile) Bluetooth LE channel index selection
           "bleCSConfig" t ;; (mFile) Bluetooth LE CS PHY waveform configuration parameters
           "bleCSWaveform" t ;; (mFile) Generate Bluetooth LE CS PHY waveform
           "bleCTEIQSample" t ;; (mFile) Perform IQ sampling on CTE field of Bluetooth LE packet
           "bleGAPDataBlock" t ;; (mFile) Generate Bluetooth LE GAP data block
           "bleGAPDataBlockConfig" t ;; (mFile) Bluetooth LE GAP data block configuration parameters
           "bleGAPDataBlockDecode" t ;; (mFile) Decode Bluetooth LE GAP data block
           "bleIdealReceiver" t ;; (mFile) Decode Bluetooth LE PHY waveform
           "bleL2CAPFrame" t ;; (mFile) Generate Bluetooth LE L2CAP frame
           "bleL2CAPFrameConfig" t ;; (mFile) Bluetooth LE L2CAP frame configuration parameters
           "bleL2CAPFrameDecode" t ;; (mFile) Decode Bluetooth LE L2CAP frame
           "blelist" t ;; (mFile) Scan nearby Bluetooth Low Energy peripheral devices
           "bleLLAdvertisingChannelPDU" t ;; (mFile) Generate Bluetooth LE LL advertising channel PDU
           "bleLLAdvertisingChannelPDUConfig" t ;; (mFile) Bluetooth LE LL advertising channel PDU configuration parameters
           "bleLLAdvertisingChannelPDUDecode" t ;; (mFile) Decode Bluetooth LE LL advertising channel PDU
           "bleLLControlPDUConfig" t ;; (mFile) Bluetooth LE LL control PDU payload configuration parameters
           "bleLLDataChannelPDU" t ;; (mFile) Generate Bluetooth LE LL data channel PDU
           "bleLLDataChannelPDUConfig" t ;; (mFile) Bluetooth LE LL data channel PDU configuration parameters
           "bleLLDataChannelPDUConfig.matlabCodegenNontunableProperties" t ;; (method)
           "bleLLDataChannelPDUDecode" t ;; (mFile) Decode Bluetooth LE LL data channel PDU
           "blendexposure" t ;; (mFile) Create well-exposed image from images with different exposures
           "blePacketDecodeStatus" t ;; (mFile)
           "blePacketDecodeStatus.CRCFailed" 'enumeration
           "blePacketDecodeStatus.ExpectedNonZeroPayload" 'enumeration
           "blePacketDecodeStatus.IllegalL2CAPSignalIdentifier" 'enumeration
           "blePacketDecodeStatus.IncompleteATTPDU" 'enumeration
           "blePacketDecodeStatus.IncompleteL2CAPDataFrame" 'enumeration
           "blePacketDecodeStatus.IncompleteL2CAPSignalFrame" 'enumeration
           "blePacketDecodeStatus.IncompleteLLAdvertisingChannelPDU" 'enumeration
           "blePacketDecodeStatus.IncompleteLLDataChannelPDU" 'enumeration
           "blePacketDecodeStatus.InvalidATTDataFormat" 'enumeration
           "blePacketDecodeStatus.InvalidATTErrorCode" 'enumeration
           "blePacketDecodeStatus.InvalidATTExecuteWriteFlag" 'enumeration
           "blePacketDecodeStatus.InvalidATTReqOpcodeInErrorResp" 'enumeration
           "blePacketDecodeStatus.InvalidAttributeHandleRange" 'enumeration
           "blePacketDecodeStatus.InvalidAttributeType" 'enumeration
           "blePacketDecodeStatus.InvalidATTRxMTU" 'enumeration
           "blePacketDecodeStatus.InvalidBluetoothVersion" 'enumeration
           "blePacketDecodeStatus.InvalidGAPADLength" 'enumeration
           "blePacketDecodeStatus.InvalidGAPAdvertisingInterval" 'enumeration
           "blePacketDecodeStatus.InvalidGAPConnectionIntervalMaximum" 'enumeration
           "blePacketDecodeStatus.InvalidGAPConnectionIntervalMinimum" 'enumeration
           "blePacketDecodeStatus.InvalidGAPConnectionIntervalRange" 'enumeration
           "blePacketDecodeStatus.InvalidL2CAPChannelIdentifier" 'enumeration
           "blePacketDecodeStatus.InvalidL2CAPChannelMPS" 'enumeration
           "blePacketDecodeStatus.InvalidL2CAPChannelMTU" 'enumeration
           "blePacketDecodeStatus.InvalidL2CAPCommand" 'enumeration
           "blePacketDecodeStatus.InvalidL2CAPCommandRejectReason" 'enumeration
           "blePacketDecodeStatus.InvalidL2CAPConnectionIntervalMaximum" 'enumeration
           "blePacketDecodeStatus.InvalidL2CAPConnectionIntervalMinimum" 'enumeration
           "blePacketDecodeStatus.InvalidL2CAPConnectionIntervalRange" 'enumeration
           "blePacketDecodeStatus.InvalidL2CAPConnectionResult" 'enumeration
           "blePacketDecodeStatus.InvalidL2CAPConnectionTimeout" 'enumeration
           "blePacketDecodeStatus.InvalidL2CAPParameterUpdateResult" 'enumeration
           "blePacketDecodeStatus.InvalidL2CAPPeripheralLatency" 'enumeration
           "blePacketDecodeStatus.InvalidL2CAPSDULength" 'enumeration
           "blePacketDecodeStatus.InvalidLECredits" 'enumeration
           "blePacketDecodeStatus.InvalidLEPSM" 'enumeration
           "blePacketDecodeStatus.InvalidLLAdvertisingDataLength" 'enumeration
           "blePacketDecodeStatus.InvalidLLChannelMap" 'enumeration
           "blePacketDecodeStatus.InvalidLLConnectionInterval" 'enumeration
           "blePacketDecodeStatus.InvalidLLConnectionTimeout" 'enumeration
           "blePacketDecodeStatus.InvalidLLErrorCode" 'enumeration
           "blePacketDecodeStatus.InvalidLLHopIncrement" 'enumeration
           "blePacketDecodeStatus.InvalidLLID" 'enumeration
           "blePacketDecodeStatus.InvalidLLPeripheralLatency" 'enumeration
           "blePacketDecodeStatus.InvalidLLScanResponseDataLength" 'enumeration
           "blePacketDecodeStatus.InvalidLLWindowOffset" 'enumeration
           "blePacketDecodeStatus.InvalidLLWindowSize" 'enumeration
           "blePacketDecodeStatus.L2CAPSegmentationUnsupported" 'enumeration
           "blePacketDecodeStatus.LLPDULengthMismatch" 'enumeration
           "blePacketDecodeStatus.MICNotSupported" 'enumeration
           "blePacketDecodeStatus.MismatchAttributeDataLength" 'enumeration
           "blePacketDecodeStatus.MismatchGAPADLength" 'enumeration
           "blePacketDecodeStatus.MismatchL2CAPHeaderLength" 'enumeration
           "blePacketDecodeStatus.MismatchL2CAPSignalFrameLength" 'enumeration
           "blePacketDecodeStatus.Success" 'enumeration
           "blePacketDecodeStatus.UnsupportedATTOpcode" 'enumeration
           "blePacketDecodeStatus.UnsupportedGAPADType" 'enumeration
           "blePacketDecodeStatus.UnsupportedLLAdvertisingPDUType" 'enumeration
           "blePacketDecodeStatus.UnsupportedLLOpCode" 'enumeration
           "blePCAPWriter" t ;; (mFile) PCAP or PCAPNG file writer of Bluetooth LE LL packets
           "blePositionEstimate" t ;; (mFile) Estimate Bluetooth LE node position
           "bleuEvaluationScore" t ;; (mFile) Evaluate translation or summarization with BLEU similarity score
           "bleWaveformGenerator" t ;; (mFile) Generate Bluetooth LE PHY waveform
           "blfinfo" t ;; (mFile) Get information about Vector BLF file
           "blfread" t ;; (pFile) Read data from Vector BLF file
           "blfwrite" t ;; (mFile) Write data to Vector BLF file
           "blindrangemap" t ;; (mFile) Create blind range map for pulsed radar
           "blindvelocitymap" t ;; (mFile) Create blind velocity map for pulsed radar
           "blindzonemap" t ;; (mFile) Create blind zone map for pulsed radar
           "blk2idx" t ;; (mFile)
           "blk_allgoals" t ;; (pFile)
           "blkbuild" t ;; (mFile)
           "blkdiag" t ;; (mFile) Block diagonal matrix
           "blkdiagbfweights" t ;; (mFile) MIMO channel block diagonalized weights
           "blkEditTimeCheck" t ;; (pFile)
           "blkimpv" t ;; (mFile) Implied volatility for futures options from Black model
           "blknorm" t ;; (mFile)
           "blknrms" t ;; (mFile)
           "blkprice" t ;; (mFile) Black model for pricing futures options
           "blkproc" t ;; (mFile)
           "blkrsch" t ;; (mFile)
           "blm" t ;; (mFile)
           "blmodlin" t ;; (pFile)
           "blobAnalysisBlockTransform" t ;; (mFile)
           "blocicon" t ;; (pFile)
           "blocinit" t ;; (pFile)
           "blockedImage" t ;; (mFile) Big or multiresolution image made from discrete blocks
           "blockedImageDatastore" t ;; (mFile) Datastore for use with blocks from blockedImage objects
           "blockedNetwork" t ;; (mFile) Create network with repeating block structure
           "blockedPointCloud" t ;; (mFile) Point cloud made from discrete blocks
           "blockedPointCloudDatastore" t ;; (mFile) Datastore for use with blocks from blockedPointCloud objects
           "blockGetDialogSchema" t ;; (mFile)
           "blockLocationSet" t ;; (mFile) List of block locations in large images
           "blockLocationSet.loadobj" t ;; (method)
           "blockLocationsWithROI" t ;; (mFile) Select image block locations that contain bounding box ROIs
           "BlockPathUtil" t ;; (mFile)
           "blockproc" t ;; (mFile) Distinct block processing for image
           "blockpropddg" t ;; (pFile)
           "blocksethelp" t ;; (mFile)
           "BlockTransform" t ;; (pFile)
           "bloombergHypermedia" t ;; (mFile) Create Bloomberg Hypermedia connection
           "bloombergHypermedia.clientSecretToBytes" t ;; (method)
           "bloombergHypermedia.generateResourcePostfix" t ;; (method)
           "bloombergHypermedia.jwtTokenGenerator" t ;; (method)
           "bloombergHypermedia.payloadToBytes" t ;; (method)
           "blosum" t ;; (mFile) Return BLOSUM scoring matrix
           "blosum100" t ;; (mFile)
           "blosum30" t ;; (mFile)
           "blosum35" t ;; (mFile)
           "blosum40" t ;; (mFile)
           "blosum45" t ;; (mFile)
           "blosum50" t ;; (mFile)
           "blosum55" t ;; (mFile)
           "blosum60" t ;; (mFile)
           "blosum62" t ;; (mFile)
           "blosum65" t ;; (mFile)
           "blosum70" t ;; (mFile)
           "blosum75" t ;; (mFile)
           "blosum80" t ;; (mFile)
           "blosum85" t ;; (mFile)
           "blosum90" t ;; (mFile)
           "blosumn" t ;; (mFile)
           "blscalf" t ;; (mFile) Best-localized Daubechies scaling filter
           "blscheck" t ;; (mFile)
           "blsdelta" t ;; (mFile) Black-Scholes sensitivity to underlying price change
           "blsgamma" t ;; (mFile) Black-Scholes sensitivity to underlying delta change
           "blsimpv" t ;; (mFile) Black-Scholes implied volatility
           "blslambda" t ;; (mFile) Black-Scholes elasticity
           "blsprice" t ;; (mFile) Black-Scholes put and call option pricing
           "blspriceeng" t ;; (mFile)
           "blsrho" t ;; (mFile) Black-Scholes sensitivity to interest-rate change
           "blstheta" t ;; (mFile) Black-Scholes sensitivity to time-until-maturity change
           "blsvega" t ;; (mFile) Black-Scholes sensitivity to underlying price volatility
           "Bluetooth" t ;; (mFile) (To be removed) Create Bluetooth object
           "bluetooth" t ;; (mFile) Connect to Bluetooth Classic device
           "Bluetooth.loadobj" t ;; (method)
           "bluetoothConnectionConfig" t ;; (mFile) Bluetooth BR/EDR connection configuration parameters
           "bluetoothFrequencyHop" t ;; (mFile) Bluetooth BR/EDR channel index for frequency hopping
           "bluetoothIdealReceiver" t ;; (mFile) Decode Bluetooth BR/EDR PHY waveform
           "bluetoothLEBIGConfig" t ;; (mFile) Bluetooth LE BIG configuration parameters
           "bluetoothLECISConfig" t ;; (mFile) Bluetooth LE CIS configuration parameters
           "bluetoothLEConnectionConfig" t ;; (mFile) Bluetooth LE LL connection configuration parameters
           "bluetoothLEPeriodicAdvConfig" t ;; (mFile) Bluetooth LE periodic advertisements configuration parameters
           "bluetoothlist" t ;; (mFile) Scan nearby Bluetooth Classic devices
           "bluetoothMeshFriendshipConfig" t ;; (mFile) Bluetooth mesh friendship configuration parameters
           "bluetoothMeshProfileConfig" t ;; (mFile) Bluetooth mesh profile configuration parameters
           "bluetoothPacketDuration" t ;; (mFile) Compute Bluetooth BR/EDR or LE packet duration
           "bluetoothPathLoss" t ;; (mFile) Estimate path loss between Bluetooth BR/EDR or LE devices
           "bluetoothPathLossConfig" t ;; (mFile) Bluetooth BR/EDR or LE path loss configuration parameters
           "bluetoothPhyConfig" t ;; (mFile) Bluetooth BR/EDR PHY configuration parameters
           "bluetoothRange" t ;; (mFile) Estimate range between two Bluetooth BR/EDR or LE devices
           "bluetoothRangeConfig" t ;; (mFile) Bluetooth BR/EDR or LE range estimation configuration parameters
           "bluetoothRFPHYTestConfig" t ;; (mFile) Bluetooth LE RF-PHY test configuration parameters
           "bluetoothTestWaveform" t ;; (mFile) Generate Bluetooth BR/EDR or LE test waveform
           "bluetoothTestWaveformConfig" t ;; (mFile) Bluetooth BR/EDR or LE test waveform configuration parameters
           "bluetoothTestWaveformValidate" t ;; (mFile) Validate Bluetooth LE RF-PHY test waveform
           "bluetoothWaveformConfig" t ;; (mFile) Bluetooth BR/EDR waveform generator configuration parameters
           "bluetoothWaveformGenerator" t ;; (mFile) Generate Bluetooth BR/EDR PHY waveform
           "bluetoothWhiten" t ;; (mFile) Whiten or dewhiten input data bits
           "bm" t ;; (mFile) Brownian motion (BM) models
           "bm25Similarity" t ;; (mFile) Document similarities with BM25 algorithm
           "bmi160" t ;; (mFile) Connect to BMI160 sensor on Arduino hardware I2C bus
           "bmp280" t ;; (mFile) Connect to BMP280 sensor on Arduino hardware I2C bus
           "bndconvp" t ;; (mFile) Bond convexity given price
           "bndconvy" t ;; (mFile) Bond convexity given yield
           "bnddurp" t ;; (mFile) Bond duration given price
           "bnddury" t ;; (mFile) Bond duration given yield
           "bndfutimprepo" t ;; (mFile) Implied repo rates for bond future given price
           "bndfutprice" t ;; (mFile) Price bond future given repo rates
           "bndkrdur" t ;; (mFile) Bond key rate duration given zero curve
           "bndprice" t ;; (mFile) Price fixed-income security from yield to maturity
           "bndspread" t ;; (mFile) Static spread over spot curve
           "bndtotalreturn" t ;; (mFile) Total return of fixed-coupon bond
           "bndyield" t ;; (mFile) Yield to maturity for fixed-income security
           "bnlssm" t ;; (mFile) Create Bayesian nonlinear non-Gaussian state-space model
           "bno055" t ;; (mFile) Connect to BNO055 sensor on Arduino hardware I2C bus
           "boardmanagergui.AddUsingTemplate" t ;; (class)
           "boardmanagergui.BoardValidation" t ;; (class)
           "boardmanagergui.CopyBoard" t ;; (class)
           "boardmanagergui.FPGABoardEditor" t ;; (class)
           "boardmanagergui.FPGABoardEditor.ClockTypeEnum" 'property
           "boardmanagergui.FPGABoardEditor.ResetActiveLevelEnum" 'property
           "boardmanagergui.FPGABoardManager" t ;; (class)
           "boardmanagergui.InterfaceEditor" t ;; (class)
           "boardmanagergui.NewBoardWizard" t ;; (class)
           "boardmanagergui.NewInterface" t ;; (class)
           "boardmanagergui.updateParentGUI" t ;; (function)
           "boardprocsel" t ;; (mFile)
           "bocmod" t ;; (mFile) Binary offset carrier modulation
           "bode" t ;; (mFile) Bode frequency response of dynamic system
           "bodeoptions" t ;; (mFile) Plot options for bodeplot
           "bodyfat_dataset" t ;; (mFile)
           "bohmanwin" t ;; (mFile) Bohman window
           "bolling" t ;; (mFile)
           "bollinger" t ;; (mFile) Time series Bollinger band
           "bondbybdt" t ;; (mFile) Price bond from Black-Derman-Toy interest-rate tree
           "bondbybk" t ;; (mFile) Price bond from Black-Karasinski interest-rate tree
           "bondbycir" t ;; (mFile) Price bond from Cox-Ingersoll-Ross interest-rate tree
           "bondbyhjm" t ;; (mFile) Price bond from Heath-Jarrow-Morton interest-rate tree
           "bondbyhw" t ;; (mFile) Price bond from Hull-White interest-rate tree
           "bondbytrintree" t ;; (mFile)
           "bondbyzero" t ;; (mFile) Price bond from set of zero curves
           "bondconv" t ;; (mFile)
           "bondDefaultBootstrap" t ;; (mFile) Bootstrap default probability curve from bond prices
           "bonddur" t ;; (mFile)
           "bone" t ;; (mFile) Bone colormap array
           "bonne" t ;; (mFile)
           "boolean" t ;; (pFile)
           "BoostConverter_class" t ;; (pFile)
           "bootci" t ;; (mFile) Bootstrap confidence interval
           "bootstrp" t ;; (mFile) Bootstrap sampling
           "bornhuetterFerguson" t ;; (mFile) Create bornhuetterFerguson object
           "boundary" t ;; (mFile) Boundary of a set of points in 2-D or 3-D
           "boundaryline" t ;; (mFile) Draw boundary line plot
           "boundarymask" t ;; (mFile) Find region boundaries of segmentation
           "boundaryModelWrapper" t ;; (mFile)
           "boundaryshape" t ;; (mFile) Create polyshape from 2-D triangulation
           "bounds" t ;; (mFile) Minimum and maximum values of an array
           "boustrophedonOptions" t ;; (mFile) Options for boustrophedon polygon decomposition algorithm
           "boustrophedonOptions.defaultConnectedCostFcn" t ;; (method)
           "boustrophedonOptions.defaultDisconnectedCostFcn" t ;; (method)
           "bowtie2" t ;; (mFile) Map sequence reads to reference sequence
           "Bowtie2AlignOptions" t ;; (mFile) Options to map reads to reference sequence
           "Bowtie2AlignOptions.Version" 'property
           "Bowtie2Base" t ;; (mFile)
           "Bowtie2Base.Version" 'property
           "bowtie2build" t ;; (mFile) Create Bowtie 2 index files from reference sequences
           "Bowtie2BuildOptions" t ;; (mFile) Contain options to create Bowtie 2 index files from reference sequences
           "Bowtie2BuildOptions.Version" 'property
           "bowtie2inspect" t ;; (mFile) Inspect Bowtie 2 index files
           "Bowtie2InspectOptions" t ;; (mFile) Contain options to inspect Bowtie 2 index files
           "Bowtie2InspectOptions.Version" 'property
           "bowtieRounded" t ;; (mFile) Create planar bowtie dipole antenna with rounded edges
           "bowtieTriangular" t ;; (mFile) Create planar bowtie dipole antenna
           "box" t ;; (mFile) Display axes outline
           "boxcar" t ;; (mFile)
           "boxchart" t ;; (mFile) Box chart (box plot)
           "boxcox" t ;; (mFile) Box-Cox transformation
           "boxddg" t ;; (pFile)
           "boxdist" t ;; (mFile) Distance between two position vectors
           "boxdist.apply" t ;; (function)
           "boxdist.backprop" t ;; (function)
           "boxdist.backstop" t ;; (function)
           "boxdist.backstopParallel" t ;; (function)
           "boxdist.discontinuity" t ;; (function)
           "boxdist.distance" t ;; (function)
           "boxdist.dz_dp" t ;; (function)
           "boxdist.dz_dw" t ;; (function)
           "boxdist.forwardprop" t ;; (function)
           "boxdist.forwardstart" t ;; (function)
           "boxdist.inputDerivType" t ;; (function)
           "boxdist.name" t ;; (function)
           "boxdist.parameterInfo" t ;; (function)
           "boxdist.simulinkParameters" t ;; (function)
           "boxdist.size" t ;; (function)
           "boxdist.type" t ;; (function)
           "boxdist.weightDerivType" t ;; (function)
           "boxLabelDatastore" t ;; (mFile) Datastore for bounding box label data
           "boxmesh" t ;; (mFile)
           "boxplot" t ;; (mFile) Visualize summary statistics with box plot
           "bpeTokenizer" t ;; (mFile) Byte pair encoding tokenizer
           "bpsEncoder" t ;; (mFile) Basis point set encoder
           "branch" t ;; (mFile)
           "braun" t ;; (mFile)
           "BraytonCycle.Compressor" t ;; (function)
           "BraytonCycle.lib" t ;; (function)
           "BraytonCycle.Turbine" t ;; (function)
           "BraytonCycle_lib" t ;; (slxFile)
           "Breaker_class" t ;; (pFile)
           "BreakerCback" t ;; (pFile)
           "breakHdlSim" t ;; (pFile) Execute stop command in HDL simulator from MATLAB
           "breakpointddg_cb" t ;; (pFile)
           "breakpointobjectddg" t ;; (pFile)
           "breusing" t ;; (mFile)
           "BridgeFiringUnit_AC__class" t ;; (pFile)
           "BridgeFiringUnit_DC__class" t ;; (pFile)
           "bries" t ;; (mFile)
           "brighten" t ;; (mFile) Brighten or darken colormap
           "brinsonAttribution" t ;; (mFile) Create brinsonAttribution object to analyze performance attribution
           "BRISKPoints" t ;; (mFile) Object for storing BRISK interest points
           "brisque" t ;; (mFile) Blind/Referenceless Image Spatial Quality Evaluator (BRISQUE) no-reference image quality score
           "brisqueModel" t ;; (mFile) Blind/Referenceless Image Spatial Quality Evaluator (BRISQUE) model
           "brk2knt" t ;; (mFile) Convert breaks with multiplicities into knots
           "broadside2az" t ;; (mFile) Convert broadside angle to azimuth angle
           "brush" t ;; (mFile) Interactively mark data values in a chart
           "brushing.HistBrushing" t ;; (class)
           "brushing.HistBrushing.histBarCameraCoords" t ;; (method)
           "brushing.HistBrushing.loadobj" t ;; (method)
           "brushing.select2d" t ;; (class)
           "brushing.select2d.axeshittest" t ;; (method)
           "brushing.select2d.clearBrushing" t ;; (method)
           "brushing.select2d.getArraySelection" t ;; (method)
           "brushing.select2d.inpolygon" t ;; (method)
           "brushing.select2d.transformCameraToFigCoord" t ;; (method)
           "brushing.select2d.translateToContainer" t ;; (method)
           "brushing.select3d" t ;; (class)
           "brushing.select3d.axeshittest" t ;; (method)
           "brushing.select3d.clearBrushing" t ;; (method)
           "brushing.select3d.convertFromFigPixels" t ;; (method)
           "brushing.select3d.convertToFigNormalized" t ;; (method)
           "brushing.select3d.doTransform" t ;; (method)
           "brushing.select3d.getArraySelection" t ;; (method)
           "brushing.select3d.getAxesTransform" t ;; (method)
           "brushing.select3d.inpolygon" t ;; (method)
           "brushing.select3d.transformCameraToFigCoord" t ;; (method)
           "brushing.select3d.translateToContainer" t ;; (method)
           "BrushlessDCMotorDrive_class" t ;; (pFile)
           "brussode" t ;; (mFile)
           "bsam" t ;; (mFile)
           "bsc" t ;; (mFile) Binary symmetric channel
           "bscost" t ;; (mFile)
           "bspligui" t ;; (mFile) Experiment with B-spline as function of its knots
           "bspline" t ;; (mFile) Plot B-spline and its polynomial pieces
           "BSplineEvalSFnV1" t ;; (mex)
           "bsplinepolytraj" t ;; (mFile) Generate polynomial trajectories using B-splines
           "bssm" t ;; (mFile) Create Bayesian state-space model
           "bstschml" t ;; (mFile)
           "bstschmr" t ;; (mFile)
           "bsw_create_dialog" t ;; (pFile)
           "bswdialog.Component" t ;; (class)
           "bswfun" t ;; (mFile) Biorthogonal scaling and wavelet functions
           "bsxfun" t ;; (mFile) Apply element-wise operation to two arrays with implicit expansion enabled
           "btndown" t ;; (mFile)
           "btngroup" t ;; (mFile)
           "btnicon" t ;; (mFile)
           "btnpress" t ;; (mFile)
           "btnresize" t ;; (mFile)
           "btnstate" t ;; (mFile)
           "btnup" t ;; (mFile)
           "bttderiv" t ;; (mFile) Backpropagation through time derivative function
           "bubblechart" t ;; (mFile) Bubble chart
           "bubblechart3" t ;; (mFile) 3-D bubble chart
           "bubblecloud" t ;; (mFile) Create bubble cloud chart
           "bubblelegend" t ;; (mFile) Create legend for bubble chart
           "bubblelim" t ;; (pFile) Map bubble sizes to data range
           "bubblesize" t ;; (pFile) Set minimum and maximum bubble sizes in points
           "BuckConverter_class" t ;; (pFile)
           "bucky" t ;; (mFile)
           "buffer" t ;; (mFile) Buffer signal vector into matrix of data frames
           "BufferAction" t ;; (pFile)
           "bufferm" t ;; (mFile) Buffer zones for latitude-longitude polygons
           "bufgeoquad" t ;; (mFile) Expand limits of geographic quadrangle
           "build_rfnoc_bitstream" t ;; (pFile)
           "buildBattery" t ;; (pFile) Build custom library blocks from battery objects
           "buildBlockEditContextMenu" t ;; (pFile)
           "builddocsearchdb" t ;; (mFile) Build searchable documentation database
           "BuildExampleModelSkip" t ;; (pFile)
           "BuildExampleSLXC" t ;; (pFile)
           "buildExists" t ;; (pFile)
           "building_dataset" t ;; (mFile)
           "buildingMaterialPermittivity" t ;; (mFile) Permittivity and conductivity of building materials
           "buildInstrumentedMex" t ;; (mFile) Generate compiled C code function including logging instrumentation
           "buildMap" t ;; (mFile) Build occupancy map from lidar scans
           "buildplan" t ;; (mFile) Create build plan
           "buildRacTarget" t ;; (pFile)
           "buildStandaloneCoderAssumptions" t ;; (mFile) Create application to check code generator assumptions
           "buildtool" t ;; (mFile) Invoke build tool
           "built_huffcode" t ;; (mFile)
           "builtin" t ;; (mFile) Execute built-in function from overloaded method
           "bundleAdjustment" t ;; (mFile) Adjust collection of 3-D points and camera poses
           "bundleAdjustmentMotion" t ;; (mFile) Adjust collection of 3-D points and camera poses using motion-only bundle adjustment
           "bundleAdjustmentSinglePattern" t ;; (mFile)
           "bundleAdjustmentStructure" t ;; (mFile) Refine 3-D points using structure-only bundle adjustment
           "burgersode" t ;; (mFile)
           "BurstEvent" t ;; (pFile)
           "burstinterpolant" t ;; (mFile) Create high-resolution image from set of low-resolution burst mode images
           "bus2RLSpec" t ;; (mFile) Create reinforcement learning data specifications for elements of a Simulink bus
           "BusCustomizationInternal" t ;; (mFile)
           "busdate" t ;; (mFile) Next or previous business day
           "busdays" t ;; (mFile) Business days for given period
           "busddg" t ;; (pFile)
           "busddg_applyrevertcbs" t ;; (pFile)
           "busddg_cb" t ;; (pFile)
           "buseditor" t ;; (pFile)
           "buselementddg" t ;; (pFile)
           "BusElementPort_ddg" t ;; (pFile)
           "bushbranch2state" t ;; (mFile)
           "bushguistate" t ;; (mFile)
           "bushloc2branch" t ;; (mFile)
           "bushpath" t ;; (mFile) Extract entries from node of bushy tree
           "bushprice" t ;; (mFile)
           "bushshape" t ;; (mFile) Retrieve shape of bushy tree
           "BusObjectSpreadsheet" t ;; (pFile)
           "BusObjectSpreadsheetCBHandler" t ;; (pFile)
           "BusObjectSpreadsheetrow" t ;; (pFile)
           "buttap" t ;; (mFile) Butterworth analog lowpass filter prototype
           "butter" t ;; (mFile) Butterworth IIR digital filter design
           "buttord" t ;; (mFile) Butterworth filter order and cutoff frequency
           "bvar" t ;; (mFile)
           "bvp4c" t ;; (mFile) Solve boundary value problem — fourth-order method
           "bvp5c" t ;; (mFile) Solve boundary value problem — fifth-order method
           "bvpget" t ;; (mFile) Extract properties from options structure created with bvpset
           "bvpinit" t ;; (mFile) Form initial guess for boundary value problem solver
           "bvpset" t ;; (mFile) Create or alter options structure of boundary value problem
           "bvpxtend" t ;; (mFile) Form guess structure for extending boundary value solutions
           "bw2range" t ;; (mFile) Convert bandwidth to range resolution
           "bw2rangeres" t ;; (mFile) Convert bandwidth to range resolution
           "BWABase" t ;; (mFile)
           "BWABase.Version" 'property
           "bwaindex" t ;; (mFile) Create BWA indices from reference sequence
           "BWAIndexOptions" t ;; (mFile) Option set for bwaindex
           "BWAIndexOptions.Version" 'property
           "bwamem" t ;; (mFile) Map sequence reads to reference genome using BWA
           "BWAMEMOptions" t ;; (mFile) Option set for bwamem
           "BWAMEMOptions.Version" 'property
           "bwarea" t ;; (mFile) Area of objects in binary image
           "bwareafilt" t ;; (mFile) Extract objects from binary image by size
           "bwareaopen" t ;; (mFile) Remove small objects from binary image
           "bwboundaries" t ;; (mFile) Trace object boundaries in binary image
           "bwc_algo" t ;; (mFile)
           "bwconncomp" t ;; (mFile) Find and count connected components in binary image
           "bwcontr" t ;; (mFile)
           "bwconvhull" t ;; (mFile) Generate convex hull image from binary image
           "bwdist" t ;; (mFile) Distance transform of binary image
           "bwdist_old" t ;; (mFile)
           "bwdistgeodesic" t ;; (mFile) Geodesic distance transform of binary image
           "bweuler" t ;; (mFile) Euler number of binary image
           "bwferet" t ;; (mFile) Measure Feret properties
           "bwfill" t ;; (mFile)
           "bwhitmiss" t ;; (mFile) Binary hit-miss operation
           "bwlabel" t ;; (mFile) Label connected components in 2-D binary image
           "bwlabeln" t ;; (mFile) Label connected components in binary image
           "bwlookup" t ;; (mFile) Nonlinear filtering using lookup tables
           "bwmorph" t ;; (mFile) Morphological operations on binary images
           "bwmorph3" t ;; (mFile) Morphological operations on binary volume
           "bwpack" t ;; (mFile) Pack binary image
           "bwperim" t ;; (mFile) Find perimeter of objects in binary image
           "bwpropfilt" t ;; (mFile) Extract objects from binary image using properties
           "bwselect" t ;; (mFile) Select objects in binary image
           "bwselect3" t ;; (mFile) Select objects in binary volume
           "bwskel" t ;; (mFile) Reduce all objects to lines in 2-D binary image or 3-D binary volume
           "bwtraceboundary" t ;; (mFile) Trace object in binary image
           "bwulterode" t ;; (mFile) Ultimate erosion
           "bwunpack" t ;; (mFile) Unpack binary image
           "byte2any" t ;; (mex)
           "byte2any_svd" t ;; (mex)
           "bytepack_callback" t ;; (mFile)
           "byteunpack_callback" t ;; (mFile)
           "c2000_validateModelAfterMake" t ;; (mFile)
           "c2000_validateModelEntry" t ;; (mFile)
           "c2000canlib" t ;; (slxFile)
           "c2000cap_callback" t ;; (mFile)
           "c2000chipsupportlib" t ;; (slxFile)
           "c2000cla" t ;; (mex)
           "c2000customlib" t ;; (slxFile)
           "c2000demolib" t ;; (slxFile)
           "c2000dspcorelib" t ;; (slxFile)
           "c2000hostsci_callback" t ;; (mFile)
           "c2000hostsci_rx" t ;; (mFile)
           "c2000hostsci_setup" t ;; (mFile)
           "c2000hostsci_tx" t ;; (mFile)
           "c2000HostSCISetPreferences" t ;; (mFile)
           "c2000lib" t ;; (slxFile)
           "c2000optimizedblks" t ;; (slxFile)
           "c2000qep_callback" t ;; (mFile)
           "c2000scilib" t ;; (slxFile)
           "c2000sensorslib" t ;; (slxFile)
           "c2000setup" t ;; (mFile) Launch C2000 Microcontroller Blockset hardware setup interface
           "c2000tgtpreflib" t ;; (slxFile)
           "c2000utilitieslib" t ;; (slxFile)
           "c280013xlib" t ;; (slxFile)
           "c280015xlib" t ;; (slxFile)
           "c28002xlib" t ;; (slxFile)
           "c28003xlib" t ;; (slxFile)
           "c28004xlib" t ;; (slxFile)
           "c2800dspchiplib" t ;; (slxFile)
           "c2800spi_callback" t ;; (mFile)
           "c2802xadc" t ;; (mex)
           "c2802xadc_block_forwarding" t ;; (mFile)
           "c2802xadc_callback" t ;; (mFile)
           "c2802xaio_di" t ;; (mex)
           "c2802xaio_do" t ;; (mex)
           "c2802xcomp" t ;; (mex)
           "c2802xcomp_block_forwarding_v1" t ;; (mFile)
           "c2802xcomp_callback" t ;; (mFile)
           "c2802xdspchiplib" t ;; (slxFile)
           "c2802xlib" t ;; (slxFile)
           "c2802xpwm" t ;; (mex)
           "c2802xpwm_block_forwarding" t ;; (mFile)
           "c2802xpwm_block_forwarding_v1" t ;; (mFile)
           "c2802xpwm_block_forwarding_v2" t ;; (mFile)
           "c2803xlib" t ;; (slxFile)
           "c2803xlin_callback" t ;; (mFile)
           "c2803xlinrcv" t ;; (mex)
           "c2803xlinxmt" t ;; (mex)
           "c2805xlib" t ;; (slxFile)
           "c2806xlib" t ;; (slxFile)
           "c2807xlib" t ;; (slxFile)
           "c280xadc" t ;; (mex)
           "c280xadc_callback" t ;; (mFile)
           "c280xcanrcv" t ;; (mex)
           "c280xcanxmt" t ;; (mex)
           "c280xcap" t ;; (mex)
           "c280xcap_callback" t ;; (mFile)
           "c280xCCP_block_forwarding" t ;; (mFile)
           "c280xDMCPIDControl_callback" t ;; (mFile)
           "c280xDMCRampGen_callback" t ;; (mFile)
           "c280xDMCSpeedMeas_callback" t ;; (mFile)
           "c280xdspchiplib" t ;; (slxFile)
           "c280xgpio_di" t ;; (mex)
           "c280xgpio_di_callback" t ;; (mFile)
           "c280xgpio_do" t ;; (mex)
           "c280xgpio_do_callback" t ;; (mFile)
           "c280xi2c_callback" t ;; (mFile)
           "c280xi2c_rx" t ;; (mex)
           "c280xi2c_tx" t ;; (mex)
           "c280xlib" t ;; (slxFile)
           "c280xpwm" t ;; (mex)
           "c280xpwm_block_forwarding_v1" t ;; (mFile)
           "c280xpwm_callback" t ;; (mFile)
           "c280xqep" t ;; (mex)
           "c280xqep_callback" t ;; (mFile)
           "c280xsci_block_forwarding" t ;; (mFile)
           "c280xsciRx_block_forwarding" t ;; (mFile)
           "c280xspi_block_forwarding_v1" t ;; (mFile)
           "c280xspi_block_forwarding_v2" t ;; (mFile)
           "c280xspi_rx" t ;; (mex)
           "c280xspi_tx" t ;; (mex)
           "c281xdspchiplib" t ;; (slxFile)
           "c281xlib" t ;; (slxFile)
           "c2833xdspchiplib" t ;; (slxFile)
           "c2833xlib" t ;; (slxFile)
           "c2834xlib" t ;; (slxFile)
           "c2837xdac_callback" t ;; (mFile)
           "c2837xDlib" t ;; (slxFile)
           "c2837xSlib" t ;; (slxFile)
           "c2838x_M4_lib" t ;; (slxFile)
           "c2838xlib" t ;; (slxFile)
           "c2838xparentlib" t ;; (slxFile)
           "c28P55xlib" t ;; (slxFile)
           "c28P65xlib" t ;; (slxFile)
           "C28x_CRL.C28xCustomFastIntDivEntry" t ;; (class)
           "C28x_CRL.C28xCustomMulEntry" t ;; (class)
           "c28xadc" t ;; (mex)
           "c28xadc_callback" t ;; (mFile)
           "c28xanalogio_output_callback" t ;; (mFile)
           "c28xcan_block_forwarding" t ;; (mFile)
           "c28xcan_callback" t ;; (mFile)
           "c28xcanrcv" t ;; (mex)
           "c28xcanxmt" t ;; (mex)
           "c28xcap" t ;; (mex)
           "c28xcla_block_forwarding" t ;; (mFile)
           "c28xcla_callback" t ;; (mFile)
           "c28xcmipc_rx" t ;; (mex)
           "c28xcmipc_tx" t ;; (mex)
           "c28xcmpssBlockForwarding" t ;; (mFile)
           "c28xdmclib" t ;; (slxFile)
           "c28xevtimer" t ;; (mex)
           "c28xevtimer_callback" t ;; (mFile)
           "c28xgpio_callback" t ;; (mFile)
           "c28xgpio_di" t ;; (mex)
           "c28xgpio_do" t ;; (mex)
           "c28xHardwareProfiler" t ;; (mex)
           "c28xipc_rx" t ;; (mex)
           "c28xipc_tx" t ;; (mex)
           "c28xisr_c2000" t ;; (mex)
           "c28xpwm" t ;; (mex)
           "c28xpwm_callback" t ;; (mFile)
           "c28xqep" t ;; (mex)
           "c28xsci_callback" t ;; (mFile)
           "c28xsci_rx" t ;; (mex)
           "c28xsci_tx" t ;; (mex)
           "c28xspi_rx" t ;; (mex)
           "c28xspi_tx" t ;; (mex)
           "c28xswtrigint" t ;; (mex)
           "c28xwatchdog" t ;; (mex)
           "c28xwatchdog_callback" t ;; (mFile)
           "c29H85xlib" t ;; (slxFile)
           "c2bprociolib" t ;; (slxFile)
           "c2btestbenchlib" t ;; (slxFile)
           "c2char2num" t ;; (mex)
           "c2d" t ;; (mFile) Convert model from continuous to discrete time
           "c2de" t ;; (mFile)
           "c2dm" t ;; (mFile)
           "c2dmp" t ;; (mFile)
           "c2dOptions" t ;; (mFile) Specify discretization method for continuous-time to discrete-time conversions
           "c2dt" t ;; (mFile)
           "c2num2char" t ;; (mex)
           "c_beautifier" t ;; (mex)
           "c_indent" t ;; (mFile)
           "ca2tf" t ;; (mFile) Convert coupled allpass filter to transfer function form
           "cacheCurrentHighlightState" t ;; (pFile)
           "cad.Actions" t ;; (class)
           "cad.AddAction" t ;; (class)
           "cad.AddVariableAction" t ;; (class)
           "cad.BooleanOperation" t ;; (class)
           "cad.Cad2DCanvas" t ;; (class)
           "cad.Cad2DController" t ;; (class)
           "cad.CAD2DDesignerTool" t ;; (class)
           "cad.Cad2DView" t ;; (class)
           "cad.CADDesignTab" t ;; (class)
           "cad.CADModel" t ;; (class)
           "cad.ChangeVariableAction" t ;; (class)
           "cad.Controller" t ;; (class)
           "cad.CopyAction" t ;; (class)
           "cad.CutAction" t ;; (class)
           "cad.DeleteAction" t ;; (class)
           "cad.DeleteVariableAction" t ;; (class)
           "cad.DependentObject" t ;; (class)
           "cad.DependentObject.AdditionalValidation" 'property
           "cad.DependentObject.ComplexValidation" 'property
           "cad.DependentObject.NoValidationHandle" 'property
           "cad.Dialog" t ;; (class)
           "cad.events.AddEventData" t ;; (class)
           "cad.events.DeleteEventData" t ;; (class)
           "cad.events.ModelChangedEventData" t ;; (class)
           "cad.events.MoveLayerEventData" t ;; (class)
           "cad.events.SelectionEventData" t ;; (class)
           "cad.events.ValidationEventData" t ;; (class)
           "cad.events.ValueChangedEventData" t ;; (class)
           "cad.events.VariableEventData" t ;; (class)
           "cad.KeyBoardBehaviour" t ;; (class)
           "cad.Layer" t ;; (class)
           "cad.Layer.AdditionalValidation" 'property
           "cad.Layer.ComplexValidation" 'property
           "cad.Layer.NoValidationHandle" 'property
           "cad.MouseBehaviour" t ;; (class)
           "cad.MoveAction" t ;; (class)
           "cad.Operation" t ;; (class)
           "cad.OperationsFactory" t ;; (class)
           "cad.PasteAction" t ;; (class)
           "cad.Polygon" t ;; (class)
           "cad.Polygon.AdditionalValidation" 'property
           "cad.Polygon.ComplexValidation" 'property
           "cad.Polygon.NoValidationHandle" 'property
           "cad.ResizeView" t ;; (class)
           "cad.SelectionDeleteAction" t ;; (class)
           "cad.Shape" t ;; (class)
           "cad.ShapeFactory" t ;; (class)
           "cad.ShapeView" t ;; (class)
           "cad.TreeNode" t ;; (class)
           "cad.TreeNodeController" t ;; (class)
           "cad.TreeNodeView" t ;; (class)
           "cad.utilities.SlicingInteractivity" t ;; (class)
           "cad.utilities.SlicingInteractivity.addButton" t ;; (method)
           "cad.ValueChangedAction" t ;; (class)
           "cad.Variable" t ;; (class)
           "cad.Variable.AdditionalValidation" 'property
           "cad.Variable.ComplexValidation" 'property
           "cad.Variable.NoValidationHandle" 'property
           "cad.VariableMap" t ;; (class)
           "cad.VariablesController" t ;; (class)
           "cad.VariablesManager" t ;; (class)
           "cad.View" t ;; (class)
           "cadnet" t ;; (pFile) Create a cadnet object
           "cadnetView" t ;; (pFile)
           "cage" t ;; (mFile) Generate optimal lookup tables for model-based calibration
           "cagedelay" t ;; (mFile)
           "cagefilter" t ;; (mFile)
           "cagefirstorder" t ;; (mFile)
           "cageintegrator" t ;; (mFile)
           "CageList" t ;; (mFile)
           "CageList.ScaleFactor" 'property
           "CageTypes" t ;; (mFile)
           "CageTypes.dataset" 'enumeration
           "CageTypes.DataTypes" t ;; (method)
           "CageTypes.DefaultType" t ;; (method)
           "CageTypes.feature" 'enumeration
           "CageTypes.findType" t ;; (method)
           "CageTypes.model" 'enumeration
           "CageTypes.optim" 'enumeration
           "CageTypes.ProcessTypes" t ;; (method)
           "CageTypes.table" 'enumeration
           "CageTypes.tradeoff" 'enumeration
           "CageTypes.variable" 'enumeration
           "cageview.browser.Actions" t ;; (class)
           "cageview.browser.Browser" t ;; (class)
           "cageview.browser.Browser.ScaleFactor" 'property
           "cageview.browser.BrowserView" t ;; (class)
           "cageview.browser.BrowserView.ScaleFactor" 'property
           "cageview.browser.CAGE" t ;; (class)
           "cageview.browser.CAGE.create" t ;; (method)
           "cageview.browser.CAGE.find" t ;; (method)
           "cageview.browser.cgbrowser" t ;; (class)
           "cageview.browser.EditActions" t ;; (class)
           "cageview.browser.FileActions" t ;; (class)
           "cageview.browser.FrameworkView" t ;; (class)
           "cageview.browser.FrameworkView.ScaleFactor" 'property
           "cageview.browser.ListView" t ;; (class)
           "cageview.browser.ListView.ScaleFactor" 'property
           "cageview.browser.MessageService" t ;; (class)
           "cageview.browser.MultiviewCard" t ;; (class)
           "cageview.browser.MultiviewCard.ScaleFactor" 'property
           "cageview.browser.TreeView" t ;; (class)
           "cageview.browser.TreeView.ScaleFactor" 'property
           "cageview.browser.TypeChoosers" t ;; (class)
           "cageview.browser.TypeChoosers.ScaleFactor" 'property
           "cageview.datadictionary.FileActions" t ;; (class)
           "cageview.dataset.FileActions" t ;; (class)
           "cageview.feature.Actions" t ;; (class)
           "cageview.feature.FileActions" t ;; (class)
           "cageview.feature.FillerList" t ;; (class)
           "cageview.feature.FillerList.ScaleFactor" 'property
           "cageview.feature.FrameWork" t ;; (class)
           "cageview.feature.FrameWork.createFigure" t ;; (method)
           "cageview.feature.FrameWork.creategui" t ;; (method)
           "cageview.feature.FrameWork.ScaleFactor" 'property
           "cageview.feature.HistoryEditor" t ;; (class)
           "cageview.feature.HistoryEditor.ScaleFactor" 'property
           "cageview.feature.MessageService" t ;; (class)
           "cageview.feature.TableViewer" t ;; (class)
           "cageview.feature.TableViewer.ScaleFactor" 'property
           "cageview.feature.updateStrategy" t ;; (function)
           "cageview.feature.ValidationPlots" t ;; (class)
           "cageview.feature.ValidationPlots.ScaleFactor" 'property
           "cageview.model.Actions" t ;; (class)
           "cageview.model.BasicSliceGraph" t ;; (class)
           "cageview.model.BasicSliceGraph.ScaleFactor" 'property
           "cageview.model.ExpressionView" t ;; (class)
           "cageview.model.ExpressionView.ScaleFactor" 'property
           "cageview.model.FileActions" t ;; (class)
           "cageview.model.FrameWork" t ;; (class)
           "cageview.model.FrameWork.creategui" t ;; (method)
           "cageview.model.FrameWork.ScaleFactor" 'property
           "cageview.model.MessageService" t ;; (class)
           "cageview.optim.Actions" t ;; (class)
           "cageview.optim.ConstraintActions" t ;; (class)
           "cageview.optim.ConstraintListView" t ;; (class)
           "cageview.optim.ConstraintListView.ScaleFactor" 'property
           "cageview.optim.DataImportUITable" t ;; (class)
           "cageview.optim.DataImportUITable.ScaleFactor" 'property
           "cageview.optim.DatasetListView" t ;; (class)
           "cageview.optim.DatasetListView.ScaleFactor" 'property
           "cageview.optim.FileActions" t ;; (class)
           "cageview.optim.FrameWork" t ;; (class)
           "cageview.optim.FrameWork.creategui" t ;; (method)
           "cageview.optim.FrameWork.ScaleFactor" 'property
           "cageview.optim.InputValuesUITableView" t ;; (class)
           "cageview.optim.InputValuesUITableView.ScaleFactor" 'property
           "cageview.optim.MessageService" t ;; (class)
           "cageview.optim.ObjectiveActions" t ;; (class)
           "cageview.optim.ObjectiveListView" t ;; (class)
           "cageview.optim.ObjectiveListView.ScaleFactor" 'property
           "cageview.optim.OptimItemListView" t ;; (class)
           "cageview.optim.OptimItemListView.ScaleFactor" 'property
           "cageview.optim.OptimProgress" t ;; (class)
           "cageview.optim.SetupInfoView" t ;; (class)
           "cageview.optim.SetupInfoView.ScaleFactor" 'property
           "cageview.optimoutput.Actions" t ;; (class)
           "cageview.optimoutput.ConGraphView" t ;; (class)
           "cageview.optimoutput.ConGraphView.ScaleFactor" 'property
           "cageview.optimoutput.ConGraphViewCell" t ;; (class)
           "cageview.optimoutput.ConGraphViewCell.ScaleFactor" 'property
           "cageview.optimoutput.ConGraphViewData" t ;; (class)
           "cageview.optimoutput.ConSummaryView" t ;; (class)
           "cageview.optimoutput.ConSummaryView.ScaleFactor" 'property
           "cageview.optimoutput.ContourAction" t ;; (class)
           "cageview.optimoutput.FrameWork" t ;; (class)
           "cageview.optimoutput.FrameWork.creategui" t ;; (method)
           "cageview.optimoutput.FrameWork.createMultiView" t ;; (method)
           "cageview.optimoutput.FrameWork.createMultiViewSurface" t ;; (method)
           "cageview.optimoutput.FrameWork.ScaleFactor" 'property
           "cageview.optimoutput.FreeValuesView" t ;; (class)
           "cageview.optimoutput.FreeValuesView.ScaleFactor" 'property
           "cageview.optimoutput.IndexerView" t ;; (class)
           "cageview.optimoutput.IndexerView.MultiObjectiveSuccess" 'property
           "cageview.optimoutput.IndexerView.ScaleFactor" 'property
           "cageview.optimoutput.IndexerView.SingleObjectiveSuccess" 'property
           "cageview.optimoutput.InfoPane" t ;; (class)
           "cageview.optimoutput.InfoPane.ScaleFactor" 'property
           "cageview.optimoutput.MessageService" t ;; (class)
           "cageview.optimoutput.ModalSolutionSelector" t ;; (class)
           "cageview.optimoutput.ModalSolutionSelector.ScaleFactor" 'property
           "cageview.optimoutput.ObjContourView" t ;; (class)
           "cageview.optimoutput.ObjContourView.ScaleFactor" 'property
           "cageview.optimoutput.ObjGraphView" t ;; (class)
           "cageview.optimoutput.ObjGraphView.ScaleFactor" 'property
           "cageview.optimoutput.ObjGraphViewCell" t ;; (class)
           "cageview.optimoutput.ObjGraphViewCell.ScaleFactor" 'property
           "cageview.optimoutput.ObjGraphViewData" t ;; (class)
           "cageview.optimoutput.ParetoView" t ;; (class)
           "cageview.optimoutput.ParetoView.ScaleFactor" 'property
           "cageview.optimoutput.ParetoViewCell" t ;; (class)
           "cageview.optimoutput.ParetoViewCell.ScaleFactor" 'property
           "cageview.optimoutput.ParetoViewData" t ;; (class)
           "cageview.optimoutput.ResultType" t ;; (class)
           "cageview.optimoutput.ResultType.exitFlagToResultType" t ;; (method)
           "cageview.optimoutput.ResultType.failure" 'enumeration
           "cageview.optimoutput.ResultType.success" 'enumeration
           "cageview.optimoutput.ResultType.warning" 'enumeration
           "cageview.optimoutput.RowHeader" t ;; (class)
           "cageview.optimoutput.RowHeader.ScaleFactor" 'property
           "cageview.optimoutput.StatsView" t ;; (class)
           "cageview.optimoutput.StatsView.ScaleFactor" 'property
           "cageview.optimoutput.Values1dView" t ;; (class)
           "cageview.optimoutput.Values1dView.ScaleFactor" 'property
           "cageview.optimoutput.Values2dView" t ;; (class)
           "cageview.optimoutput.Values2dView.ScaleFactor" 'property
           "cageview.optimoutput.ValuesContourView" t ;; (class)
           "cageview.optimoutput.ValuesContourView.ScaleFactor" 'property
           "cageview.optimoutput.ValuesCurveView" t ;; (class)
           "cageview.optimoutput.ValuesCurveView.ScaleFactor" 'property
           "cageview.optimoutput.ValuesSurfaceView" t ;; (class)
           "cageview.optimoutput.ValuesSurfaceView.ScaleFactor" 'property
           "cageview.optimoutput.ValuesUITableView" t ;; (class)
           "cageview.optimoutput.ValuesUITableView.ScaleFactor" 'property
           "cageview.project.ButtonPanel" t ;; (class)
           "cageview.project.ButtonPanel.AppDescription" 'property
           "cageview.project.ButtonPanel.AppName" 'property
           "cageview.project.ButtonPanel.ScaleFactor" 'property
           "cageview.project.CategoryFileActions" t ;; (class)
           "cageview.project.FileActions" t ;; (class)
           "cageview.project.GetStartedPane" t ;; (class)
           "cageview.project.GetStartedPane.ScaleFactor" 'property
           "cageview.project.ProjectActions" t ;; (class)
           "cageview.project.ProjectActions.Examples" 'property
           "cageview.project.RerunDialog" t ;; (class)
           "cageview.project.StartActions" t ;; (class)
           "cageview.project.Summary" t ;; (class)
           "cageview.project.Summary.ScaleFactor" 'property
           "cageview.table.Actions" t ;; (class)
           "cageview.table.FileActions" t ;; (class)
           "cageview.table.FrameWork" t ;; (class)
           "cageview.table.FrameWork.creategui" t ;; (method)
           "cageview.table.FrameWork.ScaleFactor" 'property
           "cageview.table.InfoPane" t ;; (class)
           "cageview.table.InfoPane.ScaleFactor" 'property
           "cageview.table.LinePlot" t ;; (class)
           "cageview.table.LinePlot.ScaleFactor" 'property
           "cageview.table.LUTWidget" t ;; (class)
           "cageview.table.LUTWidget.ScaleFactor" 'property
           "cageview.table.MessageService" t ;; (class)
           "cageview.table.SliceSelector" t ;; (class)
           "cageview.table.SliceSelector.ScaleFactor" 'property
           "cageview.table.SurfacePlot" t ;; (class)
           "cageview.table.SurfacePlot.ScaleFactor" 'property
           "cageview.table.tableCreatorDialog" t ;; (function)
           "cageview.table.TableView" t ;; (class)
           "cageview.table.TableView.ScaleFactor" 'property
           "cageview.tradeoff.Actions" t ;; (class)
           "cageview.tradeoff.datasetDialog" t ;; (function)
           "cageview.tradeoff.Executor" t ;; (class)
           "cageview.tradeoff.FileActions" t ;; (class)
           "cageview.tradeoff.FrameWork" t ;; (class)
           "cageview.tradeoff.FrameWork.creategui" t ;; (method)
           "cageview.tradeoff.FrameWork.ScaleFactor" 'property
           "cageview.tradeoff.GraphView" t ;; (class)
           "cageview.tradeoff.GraphView.ScaleFactor" 'property
           "cageview.tradeoff.InfoBarView" t ;; (class)
           "cageview.tradeoff.InfoBarView.ScaleFactor" 'property
           "cageview.tradeoff.LookupUITable" t ;; (class)
           "cageview.tradeoff.LookupUITable.ScaleFactor" 'property
           "cageview.tradeoff.MessageService" t ;; (class)
           "cageview.tradeoff.OptimSummary" t ;; (class)
           "cageview.tradeoff.OptimSummary.ScaleFactor" 'property
           "cageview.tradeoff.TableSurfaceView" t ;; (class)
           "cageview.tradeoff.TableSurfaceView.ScaleFactor" 'property
           "cageview.tradeoff.TableView" t ;; (class)
           "cageview.tradeoff.TableView.ScaleFactor" 'property
           "calcADCClockAndAcquistionWindow" t ;; (mFile)
           "calcADCModuleClockPrompt" t ;; (mFile)
           "calcCpuClockSpeed" t ;; (mFile)
           "calceCANBaudRatePrescaler" t ;; (mFile)
           "calcI2CFrequencies" t ;; (mFile)
           "calcI2CMasterClockFrequencyPrompt" t ;; (mFile)
           "calcjjdjj" t ;; (mFile)
           "calcLINBaudRate" t ;; (mFile)
           "calcSCIBaudRatePrescaler" t ;; (mFile)
           "calcSPIBaudRate" t ;; (mFile)
           "calcSPIBaudRateFactor" t ;; (mFile)
           "calculateCoulombSaturation" t ;; (pFile)
           "calculateExchangeCurrentDerived" t ;; (pFile)
           "CalculateInitialFluxes" t ;; (pFile)
           "calculateMappingAvailable" t ;; (pFile)
           "calculateNernstModifiers" t ;; (pFile)
           "calculateNominalFuelUtilization" t ;; (pFile)
           "calculatePartialPressure" t ;; (pFile)
           "calculateSNR" t ;; (mFile)
           "calculateStackResistance" t ;; (pFile)
           "calculateTafelSlope" t ;; (pFile)
           "calculateUtilization" t ;; (pFile)
           "calculateVapourPartialPressure" t ;; (pFile)
           "calculateVoltageLossLeadAcid" t ;; (pFile)
           "calculateVoltageLossLithiumIon" t ;; (pFile)
           "calculateVoltageLossNickel" t ;; (pFile)
           "calcWatchdogParemeters" t ;; (mFile)
           "calcWatchdogTimePeriod" t ;; (mFile)
           "caldays" t ;; (mFile) Calendar duration in days
           "calendar" t ;; (mFile) Calendar for specified month
           "calendarDuration" t ;; (mFile) Lengths of time in variable-length calendar units
           "calibrateADC" t ;; (mFile) Remove offset and gain errors from ADC output
           "calibrateDAC" t ;; (mFile) Compensate DAC input for offset and gain errors
           "calibrateMicrophone" t ;; (mFile) Calibration factor for microphone
           "calibratepmsm" t ;; (mFile) Calculate optimal Id and Iq tables for Permanent Magnet Synchronous Machine (PMSM)
           "callback_function_management" t ;; (mFile)
           "callbackinfo_get_selection" t ;; (mFile)
           "callbackPWMInitialDelay" t ;; (pFile)
           "CallbackTracing" t ;; (pFile)
           "CallbackTracingReport" t ;; (pFile)
           "CallbackTracingReport_Callbacks" t ;; (pFile)
           "CallbackTracingReportSpreadsheet" t ;; (pFile)
           "CallbackTracingReportSpreadsheetRow" t ;; (pFile)
           "CallerBlock_ddg" t ;; (pFile)
           "calllib" t ;; (mFile) Call function in C shared library
           "callSIMetrixInterface" t ;; (mex)
           "callSimulinkBlockUpgradeFunction" t ;; (mFile)
           "callSoapService" t ;; (mFile) (Removed) Send SOAP (Simple Object Access Protocol) message to endpoint
           "callWithStringSerializedData" t ;; (mFile)
           "calmonths" t ;; (mFile) Calendar duration in months
           "calquarters" t ;; (mFile) Calendar duration in quarters
           "calweeks" t ;; (mFile) Calendar duration in weeks
           "calyears" t ;; (mFile) Calendar duration in years
           "camdolly" t ;; (mFile) Move camera position and target
           "cameas" t ;; (mFile) Measurement function for constant-acceleration motion model
           "cameasjac" t ;; (mFile) Jacobian of measurement function for constant-acceleration motion model
           "cameraCalibrationErrors" t ;; (mFile) Object for storing standard errors of estimated camera parameters
           "cameraCalibrator" t ;; (mFile) Estimate geometric parameters of a single camera
           "cameraIMUCalibrationOptions" t ;; (mFile) Options for calibrating camera and IMU
           "cameraIMUParameters" t ;; (mFile) Object for storing estimated camera-to-IMU parameters
           "cameraIntrinsics" t ;; (mFile) Object for storing intrinsic camera parameters
           "cameraIntrinsicsFromOpenCV" t ;; (mFile) Convert camera intrinsic parameters from OpenCV to MATLAB
           "cameraIntrinsicsKB" t ;; (mFile) Intrinsic camera parameters based on Kannala-Brandt model
           "cameraIntrinsicsToOpenCV" t ;; (mFile) Convert camera intrinsic parameters from MATLAB to OpenCV
           "cameraMatrix" t ;; (mFile) (Not recommended) Camera projection matrix
           "cameramenu" t ;; (mFile)
           "cameraParameters" t ;; (mFile) Object for storing camera parameters
           "cameraParameters.checkDetectedKeypoints" t ;; (method)
           "cameraParameters.checkEstimateSkew" t ;; (method)
           "cameraParameters.checkEstimateTangentialDistortion" t ;; (method)
           "cameraParameters.checkImageSize" t ;; (method)
           "cameraParameters.checkIntrinsicMatrix" t ;; (method)
           "cameraParameters.checkIntrinsicMatrixPostMultiply" t ;; (method)
           "cameraParameters.checkNumRadialCoeffs" t ;; (method)
           "cameraParameters.checkRadialDistortion" t ;; (method)
           "cameraParameters.checkReprojectionErrors" t ;; (method)
           "cameraParameters.checkRotationVectors" t ;; (method)
           "cameraParameters.checkTangentialDistortion" t ;; (method)
           "cameraParameters.checkTranslationVectors" t ;; (method)
           "cameraParameters.checkWorldPoints" t ;; (method)
           "cameraParameters.checkWorldUnits" t ;; (method)
           "cameraParameters.matlabCodegenRedirect" t ;; (method)
           "cameraPose" t ;; (mFile) Compute relative rotation and translation between camera poses
           "cameraPoseToExtrinsics" t ;; (mFile) (Not recommended) Convert camera pose to extrinsics
           "cameraProjection" t ;; (mFile) Camera projection matrix
           "cameratoolbar" t ;; (mFile) Control camera toolbar programmatically
           "camlight" t ;; (mFile) Create or move light object in camera coordinates
           "camlookat" t ;; (mFile) Position camera to view object or group of objects
           "camorbit" t ;; (mFile) Rotate camera position around camera target
           "campan" t ;; (mFile) Rotate camera target around camera position
           "campos" t ;; (mFile) Set or query camera position
           "camposm" t ;; (mFile) Set camera position for axesm-based map using geographic coordinates
           "camproj" t ;; (mFile) Set or query projection type
           "camresponse" t ;; (mFile) Estimate camera response function
           "camroll" t ;; (mFile) Rotate camera about view axis
           "camrotate" t ;; (mFile)
           "camtarget" t ;; (mFile) Set or query location of camera target
           "camtargm" t ;; (mFile) Set camera target for axesm-based map using geographic coordinates
           "camup" t ;; (mFile) Set or query camera up vector
           "camupm" t ;; (mFile) Set camera up vector for axesm-based map using geographic coordinates
           "camva" t ;; (mFile) Set or query camera view angle
           "camzoom" t ;; (mFile) Zoom in and out on scene
           "can.CANMapper" t ;; (class)
           "can.Channel" t ;; (class)
           "can.Database" t ;; (class)
           "can.kvaser.Channel" t ;; (class)
           "can.kvaser.Channel.loadobj" t ;; (method)
           "can.mathworks.Channel" t ;; (class)
           "can.mathworks.Channel.loadobj" t ;; (method)
           "can.Message" t ;; (class)
           "can.ni.xnet.Channel" t ;; (class)
           "can.ni.xnet.Channel.loadobj" t ;; (method)
           "can.peaksystem.pcanbasic.Channel" t ;; (class)
           "can.peaksystem.pcanbasic.Channel.loadobj" t ;; (method)
           "can.slrealtime.Channel" t ;; (class)
           "can.socketcan.Channel" t ;; (class)
           "can.socketcan.Channel.loadobj" t ;; (method)
           "can.validateCANdbFile" t ;; (function)
           "can.vector.Channel" t ;; (class)
           "can.vector.Channel.loadobj" t ;; (method)
           "canapplet.applet.CANApplet" t ;; (class)
           "canapplet.applet.CANApplet.AppletIconID" 'property
           "canapplet.applet.CANApplet.AppSharedUserData" 'property
           "canapplet.applet.CANApplet.ContextTabTag" 'property
           "canapplet.applet.CANApplet.DisplayName" 'property
           "canapplet.applet.CANApplet.isDeviceSupported" t ;; (method)
           "canapplet.applet.modules.CANManager" t ;; (class)
           "canapplets_shared.interfaces.IChannelConfigData" t ;; (class)
           "canapplets_shared.interfaces.IChannelPropController" t ;; (class)
           "canapplets_shared.interfaces.IChannelPropView" t ;; (class)
           "canapplets_shared.interfaces.IChannelPropView.AckModeFieldOptions" 'property
           "canapplets_shared.interfaces.IChannelPropView.AckModeInitialValue" 'property
           "canapplets_shared.interfaces.IChannelPropView.FontSize" 'property
           "canapplets_shared.interfaces.ITestable" t ;; (class)
           "canapplets_shared.modules.AppletSpaceManager" t ;; (class)
           "canapplets_shared.modules.AppletSpaceManager.LayoutGrid" 'property
           "canapplets_shared.modules.AppletSpaceManager.MessagePanelGridLocation" 'property
           "canapplets_shared.modules.AppletSpaceManager.SignalPanelGridLocation" 'property
           "canapplets_shared.modules.AppletSpaceManager.TimeScopePanelGridLocation" 'property
           "canapplets_shared.modules.AppStateManager" t ;; (class)
           "canapplets_shared.modules.ChannelConfigManager" t ;; (class)
           "canapplets_shared.modules.DatabaseDialogManager" t ;; (class)
           "canapplets_shared.modules.DataExportManager" t ;; (class)
           "canapplets_shared.modules.DataExportManager.WaitbarExportCompletedMessage" 'property
           "canapplets_shared.modules.DataExportManager.WaitbarExportInProgressMessage" 'property
           "canapplets_shared.modules.DataExportManager.WaitbarTitle" 'property
           "canapplets_shared.modules.ErrorDisplayManager" t ;; (class)
           "canapplets_shared.modules.GenerateScriptManager" t ;; (class)
           "canapplets_shared.modules.MessagePanelManager" t ;; (class)
           "canapplets_shared.modules.SignalPanelManager" t ;; (class)
           "canapplets_shared.modules.SignalSelectorManager" t ;; (class)
           "canapplets_shared.modules.TimeScopePanelManager" t ;; (class)
           "canapplets_shared.modules.TimeScopePanelManager.NumTimeScopes" 'property
           "canapplets_shared.modules.ToolstripTabManager" t ;; (class)
           "canapplets_shared.modules.WarningDisplayManager" t ;; (class)
           "canapplets_shared.utilities.ConvertedEventData" t ;; (class)
           "canapplets_shared.utilities.GenerateScriptUtil" t ;; (class)
           "canapplets_shared.utilities.getDefaultChannelConfigParams" t ;; (function)
           "canapplets_shared.utilities.QEUtil" t ;; (class)
           "canapplets_shared.utilities.QEUtil.addDatabase" t ;; (method)
           "canapplets_shared.utilities.QEUtil.addSignal" t ;; (method)
           "canapplets_shared.utilities.QEUtil.getChannelConfigDialogHandle" t ;; (method)
           "canapplets_shared.utilities.QEUtil.getDatabaseManagerDialogHandle" t ;; (method)
           "canapplets_shared.utilities.QEUtil.getSignalSelectorDialogHandle" t ;; (method)
           "canapplets_shared.utilities.QEUtil.setChannelConfig" t ;; (method)
           "canblocks" t ;; (mdlFile)
           "cancer_dataset" t ;; (mFile)
           "canChannel" t ;; (mFile) Construct CAN channel connected to specified device
           "canChannelList" t ;; (mFile) Information on available CAN devices
           "canDatabase" t ;; (mFile) Create handle to CAN database file
           "candexch" t ;; (mFile) D-optimal design from candidate set using row exchanges
           "candgen" t ;; (mFile) Candidate set generation
           "candidateset" t ;; (mFile)
           "candle" t ;; (mFile) Candlestick chart
           "canExplorer" t ;; (mFile) Acquire and visualize CAN data
           "canfdapplet.applet.CANFDApplet" t ;; (class)
           "canfdapplet.applet.CANFDApplet.AppletIconSource" 'property
           "canfdapplet.applet.CANFDApplet.AppSharedUserData" 'property
           "canfdapplet.applet.CANFDApplet.ContextTabTag" 'property
           "canfdapplet.applet.CANFDApplet.DisplayName" 'property
           "canfdapplet.applet.CANFDApplet.isDeviceSupported" t ;; (method)
           "canfdapplet.applet.modules.CANFDManager" t ;; (class)
           "canFDChannel" t ;; (mFile) Construct CAN FD channel connected to specified device
           "canFDChannelList" t ;; (mFile) Information on available CAN FD device channels
           "canFDExplorer" t ;; (mFile)
           "canfdlib" t ;; (slxFile)
           "canFDMessage" t ;; (mFile) Build CAN FD message based on user-specified structure
           "canFDMessageBusType" t ;; (mFile) Create Simulink CAN FD message bus
           "canFDMessageClearBusObject" t ;; (mFile)
           "canFDMessageReplayBlockStruct" t ;; (mFile) Convert CAN FD messages for use as CAN Replay block output
           "canFDMessageTimetable" t ;; (mFile) Convert CAN or CAN FD messages into timetable
           "canfdmsglib" t ;; (slxFile)
           "canform" t ;; (mFile)
           "canlib" t ;; (slxFile)
           "canlib.csc_registration" t ;; (function)
           "canlib.CustomAttributes" t ;; (class)
           "canlib.Parameter" t ;; (class)
           "canlib.Parameter.Dimensions" 'property
           "canlib.Signal" t ;; (class)
           "canlib_loading" t ;; (mFile)
           "canMessage" t ;; (mFile) Build CAN message based on user-specified structure
           "canMessageBusCheck" t ;; (mFile)
           "canMessageBusType" t ;; (mFile) Create Simulink CAN message bus
           "canMessageImport" t ;; (mFile) Import CAN messages from third-party log file
           "canMessageReplayBlockStruct" t ;; (mFile) Convert CAN messages for use as CAN Replay block output
           "canMessageTimetable" t ;; (pFile) Convert CAN messages into timetable
           "CANMsg" t ;; (mFile)
           "canmsgblksmaskedcaps" t ;; (mFile)
           "canmsglib" t ;; (slxFile)
           "canon" t ;; (mFile) (Not recommended) Canonical state-space realization
           "canoncorr" t ;; (mFile) Canonical correlation
           "canSignalImport" t ;; (mFile) Import CAN log file into decoded signal timetables
           "canSignalTimetable" t ;; (mFile) Create CAN signal timetable from CAN message timetable
           "canslgate" t ;; (mFile)
           "canstart" t ;; (mFile)
           "canSupport" t ;; (mFile) Generate technical support log
           "canTool" t ;; (mFile)
           "canUseGPU" t ;; (mFile) Verify supported GPU is available for computation
           "canUseParallelPool" t ;; (mFile) Verify that parallel functions can use a parallel pool
           "capability" t ;; (mFile) Process capability indices
           "capacitor" t ;; (mFile) Capacitor object
           "Capacitors.IdealCapacitor" t ;; (function)
           "Capacitors.IdealUltraCapacitor" t ;; (function)
           "Capacitors.LossyUltraCapacitor" t ;; (function)
           "Capacitors_lib" t ;; (slxFile)
           "capaplot" t ;; (mFile) Process capability plot
           "capbybdt" t ;; (mFile) Price cap instrument from Black-Derman-Toy interest-rate tree
           "capbybk" t ;; (mFile) Price cap instrument from Black-Karasinski interest-rate tree
           "capbyblk" t ;; (mFile) Price caps using Black option pricing model
           "capbycir" t ;; (mFile) Price cap instrument from Cox-Ingersoll-Ross interest-rate tree
           "capbyhjm" t ;; (mFile) Price cap instrument from Heath-Jarrow-Morton interest-rate tree
           "capbyhw" t ;; (mFile) Price cap instrument from Hull-White interest-rate tree
           "capbylg2f" t ;; (mFile) Price cap using Linear Gaussian two-factor model
           "capbynormal" t ;; (mFile) Price caps using Normal or Bachelier pricing model
           "capbytrintree" t ;; (mFile)
           "capeCod" t ;; (mFile) Create capeCod object
           "capfloorbyblack" t ;; (mFile)
           "capfloorvolstrip" t ;; (mFile)
           "capsuleApproximation" t ;; (mFile) Approximate collision geometries of rigid body tree with capsules
           "capturescreen" t ;; (mFile)
           "capturewarnings" t ;; (mFile)
           "capvolstrip" t ;; (mFile) Strip caplet volatilities from flat cap volatilities
           "cardb" t ;; (mFile)
           "cardg" t ;; (mFile)
           "care" t ;; (mFile) (Not recommended) Solve continuous-time algebraic Riccati equation
           "cares" t ;; (mFile)
           "carlaExportOptions" t ;; (mFile)
           "carlaFilmboxExportOptions" t ;; (mFile)
           "cart2grn" t ;; (mFile) Transform projected coordinates on axesm-based map to Greenwich system
           "cart2hom" t ;; (mFile) Convert Cartesian coordinates to homogeneous coordinates
           "cart2pol" t ;; (mFile) Transform Cartesian coordinates to polar or cylindrical
           "cart2sph" t ;; (mFile) Transform Cartesian coordinates to spherical
           "cart2sphvec" t ;; (mFile) Convert vector from Cartesian components to spherical representation
           "cascade" t ;; (mFile) Cascade of filter system objects
           "cascadeforwardnet" t ;; (mFile) Generate cascade-forward neural network
           "cascadesparams" t ;; (mFile) Combine S-parameters to form cascade network
           "cascor2dlnetwork" t ;; (mFile)
           "caseInsensitivePattern" t ;; (mFile) Match pattern regardless of case
           "caseread" t ;; (mFile) Read case names from file
           "caseSensitivePattern" t ;; (mFile) Match pattern with case sensitivity
           "casewrite" t ;; (mFile) Write case names to file
           "cashbybls" t ;; (mFile) Determine price of cash-or-nothing digital options using Black-Scholes model
           "cashsensbybls" t ;; (mFile) Determine price or sensitivities of cash-or-nothing digital options using Black-Scholes model
           "casmmod" t ;; (mFile) CASM modulation
           "cassegrain" t ;; (mFile) Create Cassegrain antenna
           "cassegrainOffset" t ;; (mFile) Create offset Cassegrain antenna
           "cassini" t ;; (mFile)
           "cassinistd" t ;; (mFile)
           "cast" t ;; (mFile) Convert variable to different data type
           "cast64BitFiToInt" t ;; (mFile) Cast fi object types that can be exactly represented to a 64-bit integer data type
           "cast64BitIntToFi" t ;; (mFile) Cast 64-bit integer types to an equivalent fi object type
           "cast_to_fi" t ;; (mFile)
           "castFiToInt" t ;; (mFile) Cast fi object to equivalent integer data type
           "castFiToMATLAB" t ;; (mFile) Cast fi object type to an equivalent built-in MATLAB data type
           "castIntToFi" t ;; (mFile) Cast an integer data type to equivalent fi type
           "cat" t ;; (mFile) Concatenate arrays
           "catalan" t ;; (mFile) Catalan constant
           "catalogOptions" t ;; (mFile)
           "categorical" t ;; (mFile) Array that contains values assigned to categories
           "catelements" t ;; (mFile) Concatenate neural network data elements
           "catsamples" t ;; (mFile) Concatenate neural network data samples
           "catsignals" t ;; (mFile) Concatenate neural network data signals
           "cattimesteps" t ;; (mFile) Concatenate neural network data timesteps
           "cavity" t ;; (mFile) Create square or rectangular cavity-backed antenna
           "cavityCircular" t ;; (mFile) Create circular cavity-backed antenna
           "caxis" t ;; (mFile)
           "cb_browseCustomFile" t ;; (pFile)
           "cb_editplayscript" t ;; (pFile)
           "cb_generateplayscript" t ;; (pFile)
           "cb_mapbutton" t ;; (pFile)
           "cb_mapscenarios" t ;; (pFile)
           "cb_resultsTableSelected" t ;; (pFile)
           "cbApplyToModel" t ;; (pFile)
           "cbfweights" t ;; (mFile) Conventional beamformer weights
           "cbondbycrr" t ;; (mFile) Price convertible bonds from CRR binomial tree
           "cbondbyeqp" t ;; (mFile) Price convertible bonds from EQP binomial tree
           "cbondbyitt" t ;; (mFile) Price convertible bonds from ITT trinomial tree
           "cbondbystocktree" t ;; (mFile)
           "cbondbystt" t ;; (mFile) Price convertible bonds from standard trinomial tree
           "cc2bw" t ;; (mFile) Convert connected components to binary image
           "cccopyfcn" t ;; (mFile)
           "ccdesign" t ;; (mFile) Central composite design
           "cceps" t ;; (mFile) Complex cepstral analysis
           "ccoder" t ;; (pFile)
           "cconv" t ;; (mFile) Modulo-n circular convolution
           "ccopenfcn" t ;; (mFile)
           "ccsaddsource" t ;; (pFile)
           "ccsboardinfo" t ;; (mFile)
           "ccsdsHPEWaveformGenerator" t ;; (mFile) Generate CCSDS optical HPE waveform
           "ccsdsp" t ;; (mFile)
           "ccsdsRSDecode" t ;; (mFile) Decode CCSDS-complaint RS codes
           "ccsdsRSEncode" t ;; (mFile) Encode CCSDS-compliant RS codes
           "ccsdsSCPPMDecode" t ;; (mFile) Decode CCSDS-compliant SCPPM codes
           "ccsdsSCPPMEncode" t ;; (mFile) Encode CCSDS-compliant SCPPM codes
           "ccsdsTCConfig" t ;; (mFile) CCSDS TC configuration parameters
           "ccsdsTCIdealReceiver" t ;; (mFile) Ideal receiver for CCSDS TC waveform
           "ccsdsTCWaveform" t ;; (mFile) Generate CCSDS TC waveform
           "ccsdsTMFrameSynchronizer" t ;; (mFile) Synchronize CCSDS frames
           "ccsdsTMWaveformGenerator" t ;; (mFile) Generate CCSDS TM waveform
           "ccshotcoeff" t ;; (mFile)
           "ccslink_ert_make_rtw_hook" t ;; (mFile)
           "ccslink_extmode_registration" t ;; (mFile)
           "ccslink_getRtwGenSettings" t ;; (mFile)
           "ccslink_grt_make_rtw_hook" t ;; (mFile)
           "ccslinklib_c280x" t ;; (slxFile)
           "ccslinklib_c281x" t ;; (slxFile)
           "ccslinklib_core" t ;; (slxFile)
           "ccslinklib_tgtpref" t ;; (slxFile)
           "ccslinktgtpref_ccsv4_getChipListPath" t ;; (mFile)
           "ccslinktgtpref_ccsv4_setChipListPath" t ;; (mFile)
           "ccslinktgtpref_ccsv5_getChipListPath" t ;; (mFile)
           "ccslinktgtpref_ccsv5_setChipListPath" t ;; (mFile)
           "ccslinktgtpref_getChipListPath" t ;; (mFile)
           "ccslinktgtpref_setChipListPath" t ;; (mFile)
           "ccsTarget_extmode_registration" t ;; (mFile)
           "ccylin" t ;; (mFile)
           "cd" t ;; (mFile) Change current folder
           "cdai" t ;; (mFile) Accrued interest on certificate of deposit
           "cde" t ;; (mFile)
           "cdf" t ;; (mFile) Cumulative distribution function for Gaussian mixture distribution
           "cdf2rdf" t ;; (mFile) Convert complex diagonal form to real block diagonal form
           "cdfcalc" t ;; (mFile)
           "cdfepoch" t ;; (mFile) (Not recommended) Convert date text or serial date number to CDF formatted dates
           "cdfinfo" t ;; (mFile) Information about Common Data Format (CDF) file
           "cdflib.breakdownTT2000" t ;; (function)
           "cdflib.close" t ;; (function)
           "cdflib.closeVar" t ;; (function)
           "cdflib.computeEpoch" t ;; (function)
           "cdflib.computeEpoch16" t ;; (function)
           "cdflib.computeTT2000" t ;; (function)
           "cdflib.Contents" t ;; (function)
           "cdflib.create" t ;; (function)
           "cdflib.createAttr" t ;; (function)
           "cdflib.createVar" t ;; (function)
           "cdflib.delete" t ;; (function)
           "cdflib.deleteAttr" t ;; (function)
           "cdflib.deleteAttrEntry" t ;; (function)
           "cdflib.deleteAttrgEntry" t ;; (function)
           "cdflib.deleteVar" t ;; (function)
           "cdflib.deleteVarRecords" t ;; (function)
           "cdflib.epoch16Breakdown" t ;; (function)
           "cdflib.epochBreakdown" t ;; (function)
           "cdflib.getAttrEntry" t ;; (function)
           "cdflib.getAttrgEntry" t ;; (function)
           "cdflib.getAttrMaxEntry" t ;; (function)
           "cdflib.getAttrMaxgEntry" t ;; (function)
           "cdflib.getAttrName" t ;; (function)
           "cdflib.getAttrNum" t ;; (function)
           "cdflib.getAttrScope" t ;; (function)
           "cdflib.getCacheSize" t ;; (function)
           "cdflib.getChecksum" t ;; (function)
           "cdflib.getCompression" t ;; (function)
           "cdflib.getCompressionCacheSize" t ;; (function)
           "cdflib.getConstantNames" t ;; (function)
           "cdflib.getConstantValue" t ;; (function)
           "cdflib.getCopyright" t ;; (function)
           "cdflib.getFileBackward" t ;; (function)
           "cdflib.getFormat" t ;; (function)
           "cdflib.getLibraryCopyright" t ;; (function)
           "cdflib.getLibraryVersion" t ;; (function)
           "cdflib.getMajority" t ;; (function)
           "cdflib.getName" t ;; (function)
           "cdflib.getNumAttrEntries" t ;; (function)
           "cdflib.getNumAttrgEntries" t ;; (function)
           "cdflib.getNumAttributes" t ;; (function)
           "cdflib.getNumgAttributes" t ;; (function)
           "cdflib.getReadOnlyMode" t ;; (function)
           "cdflib.getStageCacheSize" t ;; (function)
           "cdflib.getValidate" t ;; (function)
           "cdflib.getVarAllocRecords" t ;; (function)
           "cdflib.getVarBlockingFactor" t ;; (function)
           "cdflib.getVarCacheSize" t ;; (function)
           "cdflib.getVarCompression" t ;; (function)
           "cdflib.getVarData" t ;; (function)
           "cdflib.getVarMaxAllocRecNum" t ;; (function)
           "cdflib.getVarMaxWrittenRecNum" t ;; (function)
           "cdflib.getVarName" t ;; (function)
           "cdflib.getVarNum" t ;; (function)
           "cdflib.getVarNumRecsWritten" t ;; (function)
           "cdflib.getVarPadValue" t ;; (function)
           "cdflib.getVarRecordData" t ;; (function)
           "cdflib.getVarReservePercent" t ;; (function)
           "cdflib.getVarsMaxWrittenRecNum" t ;; (function)
           "cdflib.getVarSparseRecords" t ;; (function)
           "cdflib.getVersion" t ;; (function)
           "cdflib.hyperGetVarData" t ;; (function)
           "cdflib.hyperPutVarData" t ;; (function)
           "cdflib.inquire" t ;; (function)
           "cdflib.inquireAttr" t ;; (function)
           "cdflib.inquireAttrEntry" t ;; (function)
           "cdflib.inquireAttrgEntry" t ;; (function)
           "cdflib.inquireVar" t ;; (function)
           "cdflib.open" t ;; (function)
           "cdflib.putAttrEntry" t ;; (function)
           "cdflib.putAttrgEntry" t ;; (function)
           "cdflib.putVarData" t ;; (function)
           "cdflib.putVarRecordData" t ;; (function)
           "cdflib.renameAttr" t ;; (function)
           "cdflib.renameVar" t ;; (function)
           "cdflib.setCacheSize" t ;; (function)
           "cdflib.setChecksum" t ;; (function)
           "cdflib.setCompression" t ;; (function)
           "cdflib.setCompressionCacheSize" t ;; (function)
           "cdflib.setFileBackward" t ;; (function)
           "cdflib.setFormat" t ;; (function)
           "cdflib.setMajority" t ;; (function)
           "cdflib.setReadOnlyMode" t ;; (function)
           "cdflib.setStageCacheSize" t ;; (function)
           "cdflib.setValidate" t ;; (function)
           "cdflib.setVarAllocBlockRecords" t ;; (function)
           "cdflib.setVarBlockingFactor" t ;; (function)
           "cdflib.setVarCacheSize" t ;; (function)
           "cdflib.setVarCompression" t ;; (function)
           "cdflib.setVarInitialRecs" t ;; (function)
           "cdflib.setVarPadValue" t ;; (function)
           "cdflib.setVarReservePercent" t ;; (function)
           "cdflib.setVarsCacheSize" t ;; (function)
           "cdflib.setVarSparseRecords" t ;; (function)
           "cdflift" t ;; (mFile)
           "cdfplot" t ;; (mFile) Empirical cumulative distribution function (cdf) plot
           "cdfread" t ;; (mFile) Read data from Common Data Format (CDF) file
           "cdfwrite" t ;; (mFile) (Not recommended) Write data to Common Data Format (CDF) file
           "cdfx" t ;; (pFile) Access information contained in CDFX file
           "cdma2000ForwardReferenceChannels" t ;; (mFile) Define cdma2000 forward reference channel
           "cdma2000ForwardWaveformGenerator" t ;; (mFile) Generate cdma2000 forward link waveform
           "cdma2000ReverseReferenceChannels" t ;; (mFile) Define cdma2000 reverse reference channel
           "cdma2000ReverseWaveformGenerator" t ;; (mFile) Generate cdma2000 reverse link waveform
           "cdprice" t ;; (mFile) Price of certificate of deposit
           "cdsbootstrap" t ;; (mFile) Bootstrap default probability curve from credit default swap market quotes
           "cdsoptprice" t ;; (mFile) Price payer and receiver credit default swap options
           "cdsprice" t ;; (mFile) Determine price for credit default swap
           "cdsrpv01" t ;; (mFile) Compute risky present value of a basis point for credit default swap
           "cdsspread" t ;; (mFile) Determine spread of credit default swap
           "cdyield" t ;; (mFile) Yield on certificate of deposit (CD)
           "ceil" t ;; (mFile) Round toward positive infinity
           "ceilDiv" t ;; (mFile) Round the result of division toward positive infinity
           "cell" t ;; (mFile) Cell array
           "cell2dataset" t ;; (mFile) (Not Recommended) Convert cell array to dataset array
           "cell2mat" t ;; (mFile) Convert cell array to ordinary array
           "cell2sos" t ;; (mFile) Convert second-order sections cell array to matrix
           "cell2struct" t ;; (mFile) Convert cell array to structure array
           "cell2sym" t ;; (mFile) Convert cell array to symbolic array
           "cell2table" t ;; (mFile) Convert cell array to table
           "cellarrayfeval" t ;; (mFile)
           "celldisp" t ;; (mFile) Display cell array contents
           "cellengunits" t ;; (mFile)
           "cellfun" t ;; (mFile) Apply function to each cell in cell array
           "cellIC" t ;; (mFile) Initial conditions on geometry cell
           "cellline" t ;; (pFile)
           "cellLoad" t ;; (mFile) Load on geometry cell
           "cellmat" t ;; (mFile) Create cell array of matrices
           "cellplot" t ;; (mFile) Graphically display structure of cell array
           "cellQualitySearch" t ;; (mFile)
           "cellstr" t ;; (mFile) Convert to cell array of character vectors
           "celltext" t ;; (pFile)
           "CensoredLinearModel" t ;; (mFile) Censored linear regression model
           "centerCropWindow2d" t ;; (mFile) Create rectangular center cropping window
           "centerCropWindow3d" t ;; (mFile) Create cuboidal center cropping window
           "centerfig" t ;; (mFile)
           "centfrq" t ;; (mFile) Wavelet center frequency
           "Centre2LTRB" t ;; (mFile)
           "cepstralCoefficients" t ;; (mFile) Extract cepstral coefficients
           "certkitiec" t ;; (pFile) Set up or open IEC Certification Kit project
           "certkitiec_envinfo" t ;; (pFile)
           "certkitiec_ma" t ;; (pFile)
           "certkitmenus" t ;; (pFile)
           "certqualkitCheckFolder" t ;; (pFile)
           "cev" t ;; (mFile) Constant Elasticity of Variance (CEV) model
           "cf2sys" t ;; (mFile)
           "cfalslnsh" t ;; (pFile)
           "cfamounts" t ;; (mFile) Cash flow and time mapping for bond portfolio
           "cfarloss" t ;; (mFile) Loss due to constant false alarm rate (CFAR) adaptive processing
           "cfbybdt" t ;; (mFile) Price cash flows from Black-Derman-Toy interest-rate tree
           "cfbybk" t ;; (mFile) Price cash flows from Black-Karasinski interest-rate tree
           "cfbycir" t ;; (mFile) Price cash flows from Cox-Ingersoll-Ross interest-rate tree
           "cfbyhjm" t ;; (mFile) Price cash flows from Heath-Jarrow-Morton interest-rate tree
           "cfbyhw" t ;; (mFile) Price cash flows from Hull-White interest-rate tree
           "cfbytrintree" t ;; (mFile)
           "cfbyzero" t ;; (mFile) Price cash flows from set of zero curves
           "cfconv" t ;; (mFile) Cash flow convexity
           "cfdates" t ;; (mFile) Cash flow dates for fixed-income security
           "cfdatesq" t ;; (mFile) Quasi-coupon dates for fixed-income security
           "cfdur" t ;; (mFile) Cash-flow duration and modified duration
           "cffilter" t ;; (mFile) Christiano-Fitzgerald filter for trend and cyclical components
           "cfInterrupt" t ;; (mFile)
           "cfirpm" t ;; (mFile) Complex and nonlinear-phase equiripple FIR filter design
           "cfit" t ;; (mFile) Constructor for cfit object
           "cflibhelp" t ;; (mFile)
           "cflscftsh" t ;; (pFile)
           "cfplot" t ;; (mFile) Visualize cash flows of financial instruments
           "cfport" t ;; (mFile) Portfolio form of cash flow amounts
           "cfprice" t ;; (mFile) Compute price for cash flow given yield to maturity
           "cfs2wdt" t ;; (mFile)
           "cfs2wpt" t ;; (mFile) Wavelet packet tree construction from coefficients
           "cfspread" t ;; (mFile) Compute spread over yield curve for cash flow
           "cftimes" t ;; (mFile) Time factors corresponding to bond cash flow dates
           "cftool" t ;; (mFile)
           "CFunctionDialog.BlockDialog" t ;; (class)
           "cfyield" t ;; (mFile) Compute yield to maturity for cash flow given price
           "cg1dtablegradoperator" t ;; (mFile)
           "cg2dtablegradoperator" t ;; (mFile)
           "cg_about" t ;; (mFile)
           "cg_shutdown" t ;; (mFile)
           "cg_widgets_ddg_cb" t ;; (pFile)
           "cgauwavf" t ;; (mFile) Complex Gaussian wavelet
           "cgbranch" t ;; (mFile)
           "cgbrowser" t ;; (mFile)
           "cgbstart" t ;; (mFile)
           "cgcalmanager" t ;; (mFile)
           "cgcalreadtxt" t ;; (mFile)
           "cgcalsetup.completionPage" t ;; (function)
           "cgcalsetup.ConstraintPage" t ;; (class)
           "cgcalsetup.ConstraintPage.createPage" t ;; (method)
           "cgcalsetup.ConstraintPage.ScaleFactor" 'property
           "cgcalsetup.ModelData" t ;; (class)
           "cgcalsetup.ModelPage" t ;; (class)
           "cgcalsetup.ModelPage.createPage" t ;; (method)
           "cgcalsetup.ModelPage.ScaleFactor" 'property
           "cgcalsetup.NormalizerEditor" t ;; (class)
           "cgcalsetup.NormalizerEditor.ScaleFactor" 'property
           "cgcalsetup.NormalizerPage" t ;; (class)
           "cgcalsetup.NormalizerPage.createPage" t ;; (method)
           "cgcalsetup.NormalizerPage.ScaleFactor" 'property
           "cgcalsetup.ObjectivePage" t ;; (class)
           "cgcalsetup.ObjectivePage.createPage" t ;; (method)
           "cgcalsetup.ObjectivePage.ScaleFactor" 'property
           "cgcalsetup.OperatingPointsPage" t ;; (class)
           "cgcalsetup.OperatingPointsPage.createPage" t ;; (method)
           "cgcalsetup.OperatingPointsPage.ScaleFactor" 'property
           "cgcalsetup.OptimData" t ;; (class)
           "cgcalsetup.OptimData.OptimizationTypes" 'property
           "cgcalsetup.OptimVariable" t ;; (class)
           "cgcalsetup.OptimVariable.ScaleFactor" 'property
           "cgcalsetup.TableData" t ;; (class)
           "cgcalsetup.TablePage" t ;; (class)
           "cgcalsetup.TablePage.createPage" t ;; (method)
           "cgcalsetup.TablePage.ScaleFactor" 'property
           "cgcalsetup.WelcomePage" t ;; (class)
           "cgcalsetup.WelcomePage.createPage" t ;; (method)
           "cgcalsetup.WelcomePage.ScaleFactor" 'property
           "cgcalsetup.WizardPage" t ;; (class)
           "cgcalsetup.WizardPage.createPage" t ;; (method)
           "cgcalsetup.WizardPage.ScaleFactor" 'property
           "cgchecktableinputs" t ;; (mFile)
           "cgclipexpr" t ;; (mFile)
           "cgCompositeModel" t ;; (mFile)
           "cgCompositeModel.convertToDouble" t ;; (method)
           "cgconconstraint" t ;; (mFile)
           "cgconstant" t ;; (mFile)
           "cgconstraint" t ;; (mFile)
           "cgconstvalue" t ;; (mFile)
           "cgcontainer" t ;; (mFile)
           "cgCopyStrategy" t ;; (mFile)
           "cgcreateproject" t ;; (mFile)
           "cgcreatetable" t ;; (mFile)
           "cgdatasetgui.DatasetList" t ;; (class)
           "cgdatasetgui.DatasetList.ScaleFactor" 'property
           "cgdatasetgui.DatasetType" t ;; (class)
           "cgdatasetgui.DatasetType.error" 'enumeration
           "cgdatasetgui.DatasetType.feature" 'enumeration
           "cgdatasetgui.DatasetType.link" 'enumeration
           "cgdatasetgui.DatasetType.linkedvariable" 'enumeration
           "cgdatasetgui.DatasetType.model" 'enumeration
           "cgdatasetgui.DatasetType.table" 'enumeration
           "cgdatasetgui.DatasetType.variable" 'enumeration
           "cgdatasetgui.UITable" t ;; (class)
           "cgdatasetgui.UITable.ScaleFactor" 'property
           "cgDatasetList" t ;; (mFile)
           "cgdatasetnode" t ;; (mFile)
           "cgddnode" t ;; (mFile)
           "cgdivexpr" t ;; (mFile)
           "cgdotproduct" t ;; (mFile)
           "cgeditnomvalues" t ;; (mFile)
           "cgeqlib" t ;; (slxFile)
           "cgeqlibprivate" t ;; (slxFile)
           "cgexpr" t ;; (mFile)
           "cgExpr2Model" t ;; (mFile)
           "cgexpr2sl" t ;; (mFile)
           "cgexprconstraint" t ;; (mFile)
           "cgexprfactory" t ;; (mFile)
           "cgexprgroup" t ;; (mFile)
           "cgexprgui.EquationView" t ;; (class)
           "cgexprgui.EquationView.ScaleFactor" 'property
           "cgexprgui.InputSelector" t ;; (class)
           "cgexprgui.InputSelector.ScaleFactor" 'property
           "cgexprgui.NamedList" t ;; (class)
           "cgexprgui.NamedList.ScaleFactor" 'property
           "cgexprmodel" t ;; (mFile)
           "cgexprmodel.convertToDouble" t ;; (method)
           "cgexprmodel.loadobj" t ;; (method)
           "cgf" t ;; (mFile)
           "cgfeattblnode" t ;; (mFile)
           "cgfeature" t ;; (mFile)
           "cgfeaturenode" t ;; (mFile)
           "cgfillsetup.FillPage" t ;; (class)
           "cgfillsetup.FillPage.createPage" t ;; (method)
           "cgfillsetup.FillPage.ScaleFactor" 'property
           "cgfillsetup.RulesPage" t ;; (class)
           "cgfillsetup.RulesPage.createPage" t ;; (method)
           "cgfillsetup.RulesPage.ScaleFactor" 'property
           "cgfillsetup.TableFiller" t ;; (class)
           "cgfillsetup.TablePage" t ;; (class)
           "cgfillsetup.TablePage.createPage" t ;; (method)
           "cgfillsetup.TablePage.ScaleFactor" 'property
           "cgfuncexpr" t ;; (mFile)
           "cgfuncmodel" t ;; (mFile)
           "cgfuncmodel.convertToDouble" t ;; (method)
           "cgfuncmodel.loadobj" t ;; (method)
           "cghcbs" t ;; (mFile) Perform circular binary segmentation (CBS) on array-based comparative genomic hybridization (aCGH) data
           "cghelpbutton" t ;; (mFile)
           "cghelpmenu" t ;; (mFile)
           "cghelptool" t ;; (mFile)
           "cghelptoolbutton" t ;; (mFile)
           "cghfreqplot" t ;; (mFile) Display frequency of DNA copy number alterations across multiple samples
           "cghistorymanager" t ;; (mFile)
           "cgidentifyconsts" t ;; (mFile)
           "cgifexpr" t ;; (mFile)
           "cgimportptr" t ;; (mFile)
           "cgimporttool" t ;; (mFile)
           "cgindependentvars" t ;; (mFile)
           "cginitinputs" t ;; (mFile)
           "cgisindependentvars" t ;; (mFile)
           "cgivens" t ;; (mFile)
           "cgloci" t ;; (mFile)
           "cgloci2" t ;; (mFile)
           "cglookup" t ;; (mFile)
           "cglookupnd" t ;; (mFile)
           "cglookupone" t ;; (mFile)
           "cglookuptwo" t ;; (mFile)
           "cgmergesetup.CageModelPage" t ;; (class)
           "cgmergesetup.CageModelPage.createPage" t ;; (method)
           "cgmergesetup.CageModelPage.ScaleFactor" 'property
           "cgmergesetup.CageModels" t ;; (class)
           "cgmergesetup.MergeItems" t ;; (class)
           "cgmergesetup.MergeItemsPage" t ;; (class)
           "cgmergesetup.MergeItemsPage.createPage" t ;; (method)
           "cgmergesetup.MergeItemsPage.ScaleFactor" 'property
           "cgmergesetup.ModePage" t ;; (class)
           "cgmergesetup.ModePage.createPage" t ;; (method)
           "cgmergesetup.ModePage.ScaleFactor" 'property
           "cgmergesetup.ResponsePage" t ;; (class)
           "cgmergesetup.ResponsePage.createPage" t ;; (method)
           "cgmergesetup.ResponsePage.ScaleFactor" 'property
           "cgmergesetup.TestplanPage" t ;; (class)
           "cgmergesetup.TestplanPage.createPage" t ;; (method)
           "cgmergesetup.TestplanPage.ScaleFactor" 'property
           "cgmergesetup.Testplans" t ;; (class)
           "cgminmaxexpr" t ;; (mFile)
           "cgmodelnode" t ;; (mFile)
           "cgmodexpr" t ;; (mFile)
           "cgmswitchexpr" t ;; (mFile)
           "cgnbi" t ;; (mFile)
           "cgnbiom2options" t ;; (mFile)
           "cgnbioptimset" t ;; (mFile)
           "cgnbishadow" t ;; (mFile)
           "cgnbisubproblem" t ;; (mFile)
           "cgnode" t ;; (mFile)
           "cgnormaliser" t ;; (mFile)
           "cgNormaliserHistory" t ;; (mFile)
           "cgNormaliserHistory.convertFromCell" t ;; (method)
           "cgnormfunction" t ;; (mFile)
           "cgnormnode" t ;; (mFile)
           "cgnumindependentvars" t ;; (mFile)
           "cgobjectivefunc" t ;; (mFile)
           "cgobjectivesum" t ;; (mFile)
           "cgoppoint" t ;; (mFile)
           "cgoptcsol" t ;; (mFile)
           "cgoptim" t ;; (mFile)
           "cgoptimconstraint" t ;; (mFile)
           "cgoptimdataset" t ;; (mFile)
           "cgoptimdataset.loadobj" t ;; (method)
           "cgoptimdatasetfiller" t ;; (mFile)
           "cgoptimexport" t ;; (mFile)
           "cgoptimexprgroup" t ;; (mFile)
           "cgoptimextoptions" t ;; (mFile)
           "cgoptimextoptions.loadobj" t ;; (method)
           "cgoptimfuncs" t ;; (mFile)
           "cgoptimgui.BoundSelector" t ;; (class)
           "cgoptimgui.BoundSelector.ScaleFactor" 'property
           "cgoptimgui.ExpressionSelector" t ;; (class)
           "cgoptimgui.ExpressionSelector.ScaleFactor" 'property
           "cgoptimgui.objectivetypeselector" t ;; (class)
           "cgoptimgui.objectivetypeselector.ScaleFactor" 'property
           "cgoptimgui.optimfuncseditor" t ;; (class)
           "cgoptimgui.optimfuncseditor.ScaleFactor" 'property
           "cgoptimgui.optimList" t ;; (class)
           "cgoptimgui.optimList.ScaleFactor" 'property
           "cgoptimgui.optionsEditor" t ;; (class)
           "cgoptimgui.optionsEditor.ScaleFactor" 'property
           "cgoptimgui.OutputList" t ;; (class)
           "cgoptimgui.OutputList.ScaleFactor" 'property
           "cgoptimgui.vectorEditor" t ;; (class)
           "cgoptimgui.vectorEditor.ScaleFactor" 'property
           "cgoptimitem" t ;; (mFile)
           "cgoptimnode" t ;; (mFile)
           "cgoptimobjective" t ;; (mFile)
           "cgoptimoptions" t ;; (mFile)
           "cgoptimoptions.loadobj" t ;; (method)
           "cgoptimoutnode" t ;; (mFile)
           "cgoptimoutput" t ;; (mFile)
           "cgoptimrunner" t ;; (mFile)
           "cgoptimrunner.Builtin" 'property
           "cgoptimrunner.LinearBoundaryAlgorithms" 'property
           "cgoptimrunner.loadobj" t ;; (method)
           "cgoptimstore" t ;; (mFile)
           "cgoptimtablefiller" t ;; (mFile)
           "cgoptionsgui" t ;; (mFile)
           "cgpointconstraint" t ;; (mFile)
           "cgpointobjective" t ;; (mFile)
           "cgprec" t ;; (mFile)
           "cgprecClassList" t ;; (mFile)
           "cgprecfix" t ;; (mFile)
           "cgprecfloat" t ;; (mFile)
           "cgpreclookupfix" t ;; (mFile)
           "cgprecpolyfix" t ;; (mFile)
           "cgprojconnections" t ;; (mFile)
           "cgproject" t ;; (mFile)
           "cgProjectItemSelector" t ;; (mFile)
           "cgrangeconstraint" t ;; (mFile)
           "cgrelexpr" t ;; (mFile)
           "cgresload" t ;; (mFile)
           "cgrespath" t ;; (mFile)
           "cgrules" t ;; (mFile)
           "cgs" t ;; (mFile) Solve system of linear equations — conjugate gradients squared method
           "cgsetblockpos" t ;; (mFile)
           "cgsimfill.BSpline" t ;; (class)
           "cgsimfill.BSpline2" t ;; (class)
           "cgsimfill.BSplineND" t ;; (class)
           "cgsimfill.Chebyshev1D" t ;; (class)
           "cgsimfill.Chebyshev1D.autoOrder" t ;; (method)
           "cgsimfill.Chebyshev1D.scalarTerms" t ;; (method)
           "cgsimfill.Chebyshev2D" t ;; (class)
           "cgsimfill.Chebyshev2D.loadobj" t ;; (method)
           "cgsimfill.ChebyshevND" t ;; (class)
           "cgsimfill.ChebyshevND.create" t ;; (method)
           "cgsimfill.Constant" t ;; (class)
           "cgsimfill.EvalPoints" t ;; (class)
           "cgsimfill.ExpressionChain" t ;; (class)
           "cgsimfill.ExpressionChain.fastEvaluate" t ;; (method)
           "cgsimfill.ExpressionChain.htmlchar" t ;; (method)
           "cgsimfill.ExpressionChain.loadobj" t ;; (method)
           "cgsimfill.Feature" t ;; (class)
           "cgsimfill.LargeScaleOptimization" t ;; (class)
           "cgsimfill.LargeScaleOptimization.loadobj" t ;; (method)
           "cgsimfill.PointerInterface" t ;; (class)
           "cgsimfill.Table" t ;; (class)
           "cgsimfill.Table.loadobj" t ;; (method)
           "cgSimulinkBrowser" t ;; (mFile)
           "cgSimulinkBrowser.create" t ;; (method)
           "cgslblock" t ;; (mFile)
           "cgslparser" t ;; (mFile)
           "cgslparser.isCalibrateable" t ;; (method)
           "cgslparser.testParse" t ;; (method)
           "cgstaticdataset" t ;; (mFile)
           "cgstaticdataset.createFromStruct" t ;; (method)
           "cgStrategyTables" t ;; (mFile)
           "cgsubexpr" t ;; (mFile)
           "cgsumconstraint" t ;; (mFile)
           "cgsumobjective" t ;; (mFile)
           "cgsurfaceviewer" t ;; (mFile)
           "cgsurfview.abstractoptions" t ;; (class)
           "cgsurfview.abstractplot" t ;; (class)
           "cgsurfview.abstractplot.ScaleFactor" 'property
           "cgsurfview.app" t ;; (class)
           "cgsurfview.contouroptions" t ;; (class)
           "cgsurfview.contourplot" t ;; (class)
           "cgsurfview.contourplot.ScaleFactor" 'property
           "cgsurfview.datasel" t ;; (class)
           "cgsurfview.datasel.ScaleFactor" 'property
           "cgsurfview.dataviewer" t ;; (class)
           "cgsurfview.dataviewer.ScaleFactor" 'property
           "cgsurfview.draw_surface" t ;; (function)
           "cgsurfview.evalpanel" t ;; (class)
           "cgsurfview.evalpanel.ScaleFactor" 'property
           "cgsurfview.inputlist" t ;; (class)
           "cgsurfview.inputlist.ScaleFactor" 'property
           "cgsurfview.lineoptions" t ;; (class)
           "cgsurfview.lineplot" t ;; (class)
           "cgsurfview.lineplot.ScaleFactor" 'property
           "cgsurfview.movieplot" t ;; (class)
           "cgsurfview.movieplot.ScaleFactor" 'property
           "cgsurfview.nodesel" t ;; (class)
           "cgsurfview.nodesel.ScaleFactor" 'property
           "cgsurfview.plottype" t ;; (class)
           "cgsurfview.plottype.ScaleFactor" 'property
           "cgsurfview.pointplot" t ;; (class)
           "cgsurfview.pointplot.ScaleFactor" 'property
           "cgsurfview.setup_axes" t ;; (function)
           "cgsurfview.surfaceoptions" t ;; (class)
           "cgsurfview.surfaceplot" t ;; (class)
           "cgsurfview.surfaceplot.ScaleFactor" 'property
           "cgsurfview.svdata" t ;; (class)
           "cgsurfview.table1plot" t ;; (class)
           "cgsurfview.table1plot.ScaleFactor" 'property
           "cgsurfview.table2plot" t ;; (class)
           "cgsurfview.table2plot.ScaleFactor" 'property
           "cgsymvalue" t ;; (mFile)
           "cgtabgradconstraint" t ;; (mFile)
           "cgTableHistory" t ;; (mFile)
           "cgTableHistory.convertFromCell" t ;; (method)
           "cgtablenode" t ;; (mFile)
           "cgThinplateSpline" t ;; (mFile)
           "cgThinplateSpline.fit" t ;; (method)
           "cgThinplateSpline.interpByMode" t ;; (method)
           "cgThinplateSpline.interpData" t ;; (method)
           "cgtools.AbstractFilteredProjectView" t ;; (class)
           "cgtools.AbstractFilteredProjectView.ScaleFactor" 'property
           "cgtools.breakpointeditor" t ;; (class)
           "cgtools.breakpointeditor.ScaleFactor" 'property
           "cgtools.CAGEFilteredProjectView" t ;; (class)
           "cgtools.CAGEFilteredProjectView.ScaleFactor" 'property
           "cgtools.CageTableProvider" t ;; (class)
           "cgtools.cglinedragger" t ;; (class)
           "cgtools.cgsurfacedragger" t ;; (class)
           "cgtools.comparisonpane" t ;; (class)
           "cgtools.comparisonpane.ScaleFactor" 'property
           "cgtools.exprList" t ;; (class)
           "cgtools.exprList.ScaleFactor" 'property
           "cgtools.ItemFilter" t ;; (class)
           "cgtools.ItemFilter.ScaleFactor" 'property
           "cgtools.itemList" t ;; (class)
           "cgtools.itemList.ScaleFactor" 'property
           "cgtools.MBCModelFilteredProjectView" t ;; (class)
           "cgtools.MBCModelFilteredProjectView.ScaleFactor" 'property
           "cgtools.nodeList" t ;; (class)
           "cgtools.nodeList.ScaleFactor" 'property
           "cgtools.NormalizerUITable" t ;; (class)
           "cgtools.NormalizerUITable.ScaleFactor" 'property
           "cgtools.normcomp" t ;; (class)
           "cgtools.normcomp.ScaleFactor" 'property
           "cgtools.ObjectList" t ;; (class)
           "cgtools.ObjectList.ScaleFactor" 'property
           "cgtools.projectList" t ;; (class)
           "cgtools.projectList.ScaleFactor" 'property
           "cgtools.UIObjectList" t ;; (class)
           "cgtools.UIObjectList.ScaleFactor" 'property
           "cgtradeoff" t ;; (mFile)
           "cgtradeoffgui.modelSetupList" t ;; (class)
           "cgtradeoffgui.modelSetupList.ScaleFactor" 'property
           "cgtradeoffgui.setupUI" t ;; (class)
           "cgtradeoffgui.setupUI.ScaleFactor" 'property
           "cgtradeoffgui.tableSetupList" t ;; (class)
           "cgtradeoffgui.tableSetupList.ScaleFactor" 'property
           "cgtradeoffgui.toGVCell" t ;; (class)
           "cgtradeoffgui.toGVCell.ScaleFactor" 'property
           "cgtradeoffgui.toGVColumnHeader" t ;; (class)
           "cgtradeoffgui.toGVColumnHeader.ScaleFactor" 'property
           "cgtradeoffgui.toGVDataModel" t ;; (class)
           "cgtradeoffkeytable" t ;; (mFile)
           "cgtradeoffnode" t ;; (mFile)
           "cgtradeofftblnode" t ;; (mFile)
           "cgv.Batch" t ;; (class)
           "cgv.CGV" t ;; (class)
           "cgv.Config" t ;; (class)
           "cgv.Config.isERTTargetOrGRTTarget" t ;; (method)
           "cgvalue" t ;; (mFile)
           "cgvardiff" t ;; (mFile)
           "cgvariable" t ;; (mFile)
           "cgvTarget.TargetBase" t ;; (class)
           "cgvTarget.TargetModelBlock" t ;; (class)
           "cgvTarget.TargetTopModel" t ;; (class)
           "cgwinlist" t ;; (mFile)
           "cgxe" t ;; (mex)
           "CGXE.Coder.code_append_syslibs_to_objlist_file" t ;; (function)
           "CGXE.Coder.code_append_user_external_link_flags_for_library" t ;; (function)
           "CGXE.Coder.code_mingw_make_file" t ;; (function)
           "CGXE.Coder.code_model_header_file" t ;; (function)
           "CGXE.Coder.code_model_interface_header_file" t ;; (function)
           "CGXE.Coder.code_model_objlist_file" t ;; (function)
           "CGXE.Coder.code_model_registry_file" t ;; (function)
           "CGXE.Coder.code_model_source_file" t ;; (function)
           "CGXE.Coder.code_module_header_file" t ;; (function)
           "CGXE.Coder.code_module_source_file" t ;; (function)
           "CGXE.Coder.code_msvc_make_file" t ;; (function)
           "CGXE.Coder.code_unix_make_file" t ;; (function)
           "CGXE.Coder.create_mexopts_caller_bat_file" t ;; (function)
           "CGXE.Coder.createCFunctionBlockCCFiles" t ;; (function)
           "CGXE.Coder.customCodeEmitFiles" t ;; (function)
           "CGXE.Coder.customCodeMakefile" t ;; (function)
           "CGXE.Coder.dump_module" t ;; (function)
           "CGXE.Coder.errorIfNoMEXCompiler" t ;; (function)
           "CGXE.Coder.genOOPWrapperHeaderAndSource" t ;; (function)
           "CGXE.Coder.getProjDir" t ;; (function)
           "CGXE.Coder.glue_module_code" t ;; (function)
           "CGXE.Coder.try_indenting_file" t ;; (function)
           "CGXE.Coder.writeCCSLFcnCallDispatch" t ;; (function)
           "CGXE.Coder.writeXilGetHostToTargetData" t ;; (function)
           "CGXE.Coder.writeXilGetTargetToHostData" t ;; (function)
           "CGXE.CustomCode.adjustMexCompilers" t ;; (function)
           "CGXE.CustomCode.cgxe_extract_objsyms_mex" t ;; (function)
           "CGXE.CustomCode.CheckSumInfo" t ;; (class)
           "CGXE.CustomCode.CheckSumInfo.computeTextCheckSum" t ;; (method)
           "CGXE.CustomCode.CheckSumInfo.setupOptions" t ;; (method)
           "CGXE.CustomCode.CheckSumInfo.timeStampGreaterThan" t ;; (method)
           "CGXE.CustomCode.CheckSumManager" t ;; (class)
           "CGXE.CustomCode.CustomCodeSettings" t ;; (class)
           "CGXE.CustomCode.CustomCodeSettings.convertHeadersListToCode" t ;; (method)
           "CGXE.CustomCode.CustomCodeSettings.createForBlockCC" t ;; (method)
           "CGXE.CustomCode.CustomCodeSettings.createFromModel" t ;; (method)
           "CGXE.CustomCode.CxxFEOptionsManager" t ;; (class)
           "CGXE.CustomCode.CxxFEOptionsManager.instance" 'property
           "CGXE.CustomCode.CxxFEOptionsManager.reset" t ;; (method)
           "CGXE.CustomCode.extractLibrarySymbols" t ;; (function)
           "CGXE.CustomCode.extractRelevantDirs" t ;; (function)
           "CGXE.CustomCode.extractUserDefines" t ;; (function)
           "CGXE.CustomCode.getAllFrontEndOptions" t ;; (function)
           "CGXE.CustomCode.getAllUniqueUserDefines" t ;; (function)
           "CGXE.CustomCode.getCustomCodeFrontEndOptions" t ;; (function)
           "CGXE.CustomCode.getCustomCodeLibFullName" t ;; (function)
           "CGXE.CustomCode.getCustomLibNameFromModel" t ;; (function)
           "CGXE.CustomCode.getFrontEndOptions" t ;; (function)
           "CGXE.CustomCode.getOverrideFlags" t ;; (function)
           "CGXE.CustomCode.SettingChecksum2InterfaceAndFullChecksumManager" t ;; (class)
           "CGXE.CustomCode.SettingChecksum2InterfaceAndFullChecksumManager.getCached" t ;; (method)
           "CGXE.CustomCode.SettingChecksum2InterfaceAndFullChecksumManager.hasCached" t ;; (method)
           "CGXE.CustomCode.SettingChecksum2InterfaceAndFullChecksumManager.instance" 'property
           "CGXE.CustomCode.SettingChecksum2InterfaceAndFullChecksumManager.reset" t ;; (method)
           "CGXE.CustomCode.SettingChecksum2InterfaceAndFullChecksumManager.setCached" t ;; (method)
           "CGXE.CustomCode.strcxxtrim" t ;; (function)
           "CGXE.Debug.DebugRuntimeManager" t ;; (class)
           "CGXE.Debug.DebugRuntimeManager.dbcont" t ;; (method)
           "CGXE.Debug.DebugRuntimeManager.dbquit" t ;; (method)
           "CGXE.Debug.DebugRuntimeManager.exitDebugLoop" t ;; (method)
           "CGXE.Debug.DebugRuntimeManager.hasValueChanged" t ;; (method)
           "CGXE.Debug.DebugRuntimeManager.isDebuggerEnabledForCurrentBlock" t ;; (method)
           "CGXE.Debug.DebugRuntimeManager.isDebuggerOn" t ;; (method)
           "CGXE.Debug.get_help_str" t ;; (function)
           "CGXE.Debug.removeMatlabBreakpointsFromEml" t ;; (function)
           "CGXE.JIT.getProjDir" t ;; (function)
           "CGXE.Utils.disallowLCC" t ;; (function)
           "CGXE.Utils.fix_windows_paths_for_make_file" t ;; (function)
           "CGXE.Utils.getRootDirectory" t ;; (function)
           "CGXE.Utils.getRootOfReferenceBlock" t ;; (function)
           "CGXE.Utils.getSearchDirectoriesFromPath" t ;; (function)
           "CGXE.Utils.isFolderWritable" t ;; (function)
           "CGXE.Utils.isInterleavedComplex" t ;; (function)
           "CGXE.Utils.isRaccelOrMdfRefSimTarget" t ;; (function)
           "CGXE.Utils.isSimOptimizationsOn" t ;; (function)
           "CGXE.Utils.md5" t ;; (function)
           "CGXE.Utils.orderedUniquePaths" t ;; (function)
           "CGXE.Utils.reportTokenizerDiagnostic" t ;; (function)
           "CGXE.Utils.stripPathFromName" t ;; (function)
           "CGXE.Utils.tokenize" t ;; (function)
           "CGXE.Utils.tokenizeFileFromModel" t ;; (function)
           "cgxeprivate" t ;; (pFile)
           "chaikosc" t ;; (mFile) Chaikin oscillator
           "chaikvolat" t ;; (mFile) Chaikin volatility
           "chainLadder" t ;; (mFile) Create chainLadder object
           "changedisplay" t ;; (mFile)
           "changem" t ;; (mFile) Replace values in array
           "changeseriestype" t ;; (mFile)
           "ChannelData" t ;; (mFile)
           "channelDelay" t ;; (mFile) Channel timing delay
           "ChannelMeasurementsConfiguration" t ;; (pFile) Compute and display occupied bandwidth or adjacent channel power ratio on the spectrum analyzer
           "chanupd" t ;; (mFile)
           "char" t ;; (mFile) Character array
           "characteristicFcnBates" t ;; (mFile)
           "characteristicFcnHeston" t ;; (mFile)
           "characteristicFcnMerton76" t ;; (mFile)
           "characteristicViewer" t ;; (slxFile)
           "characterization.getCharacterizationDataPath" t ;; (function)
           "characterization.getCharacterizationPathAltera" t ;; (function)
           "characterization.getCharacterizationPathXilinx" t ;; (function)
           "characterization.getCharacterizationPathXilinxGeneric" t ;; (function)
           "characterization.getHardwarePipeliningDataPath" t ;; (function)
           "characterization.ParamDesc" t ;; (class)
           "characterization.PortDesc" t ;; (class)
           "characterization.readCharacterizationData" t ;; (function)
           "characterization.STA.CadenceGenus.validateTargetSettings" t ;; (function)
           "characterization.STA.Characterization" t ;; (class)
           "characterization.STA.Characterization.HDL_PARAM" 'property
           "characterization.STA.Characterization.InvalidDelay" 'property
           "characterization.STA.Characterization.InvalidPort" 'property
           "characterization.STA.Characterization.RegisterPort" 'property
           "characterization.STA.Characterization.REMAINING_PORTS" 'property
           "characterization.STA.Characterization.SIMULINK_PARAM" 'property
           "characterization.STA.CharacterizationDriver" t ;; (class)
           "characterization.STA.CharacterizationDriver.getCharacterizationSpecMap" t ;; (method)
           "characterization.STA.CharacterizationKeyGenerator" t ;; (class)
           "characterization.STA.CharacterizationParamParser" t ;; (class)
           "characterization.STA.CharacterizationPortParser" t ;; (class)
           "characterization.STA.CharacterizationSpecs.AbsCharSpec" t ;; (function)
           "characterization.STA.CharacterizationSpecs.BitOpsCharSpec" t ;; (function)
           "characterization.STA.CharacterizationSpecs.BitReduceCharSpec" t ;; (function)
           "characterization.STA.CharacterizationSpecs.BitRotateCharSpec" t ;; (function)
           "characterization.STA.CharacterizationSpecs.BitShiftCharSpec" t ;; (function)
           "characterization.STA.CharacterizationSpecs.DataTypeCharSpec" t ;; (function)
           "characterization.STA.CharacterizationSpecs.Deserializer1DCharSpec" t ;; (function)
           "characterization.STA.CharacterizationSpecs.DotProductTreeCharSpec" t ;; (function)
           "characterization.STA.CharacterizationSpecs.GainCharSpec" t ;; (function)
           "characterization.STA.CharacterizationSpecs.HDLCounterCharSpec" t ;; (function)
           "characterization.STA.CharacterizationSpecs.LogicCharSpec" t ;; (function)
           "characterization.STA.CharacterizationSpecs.LookupTableNDCharSpec" t ;; (function)
           "characterization.STA.CharacterizationSpecs.MathFunctionCharSpecs" t ;; (function)
           "characterization.STA.CharacterizationSpecs.MultiPortSwitchCharSpec" t ;; (function)
           "characterization.STA.CharacterizationSpecs.NFPReinterpretCastCharSpec" t ;; (function)
           "characterization.STA.CharacterizationSpecs.ProductCharSpec" t ;; (function)
           "characterization.STA.CharacterizationSpecs.RateTransitionCharSpec" t ;; (function)
           "characterization.STA.CharacterizationSpecs.RecipNewtonSingleRateCharSpec" t ;; (function)
           "characterization.STA.CharacterizationSpecs.ReciprocalNewtonCharSpec" t ;; (function)
           "characterization.STA.CharacterizationSpecs.ReciprocalRsqrtBasedNewtonCharSpec" t ;; (function)
           "characterization.STA.CharacterizationSpecs.ReciprocalRsqrtBasedNewtonSingleRateCharSpec" t ;; (function)
           "characterization.STA.CharacterizationSpecs.RecipSqrtNewtonCharSpec" t ;; (function)
           "characterization.STA.CharacterizationSpecs.RecipSqrtNewtonSingleRateCharSpec" t ;; (function)
           "characterization.STA.CharacterizationSpecs.RelationalOperatorCharSpec" t ;; (function)
           "characterization.STA.CharacterizationSpecs.RoundingFunctionCharSpec" t ;; (function)
           "characterization.STA.CharacterizationSpecs.SaturationCharSpec" t ;; (function)
           "characterization.STA.CharacterizationSpecs.Serializer1DCharSpec" t ;; (function)
           "characterization.STA.CharacterizationSpecs.SignumCharSpec" t ;; (function)
           "characterization.STA.CharacterizationSpecs.SqrtFunctionCharSpec" t ;; (function)
           "characterization.STA.CharacterizationSpecs.SqrtNewtonCharSpec" t ;; (function)
           "characterization.STA.CharacterizationSpecs.SqrtNewtonSingleRateCharSpec" t ;; (function)
           "characterization.STA.CharacterizationSpecs.SumCharSpec" t ;; (function)
           "characterization.STA.CharacterizationSpecs.SwitchCharSpec" t ;; (function)
           "characterization.STA.CharacterizationSpecs.TappedDelayCharSpec" t ;; (function)
           "characterization.STA.CharacterizationSpecs.TrigonometricFunctionCharSpec" t ;; (function)
           "characterization.STA.CharacterizationSpecs.UnaryMinusCharSpec" t ;; (function)
           "characterization.STA.CharacterizationSpecs.UnitDelayCharSpec" t ;; (function)
           "characterization.STA.CharacterizationSpecs.UnitDelayEnabledCharSpec" t ;; (function)
           "characterization.STA.CharacterizationSpecs.UnitDelayEnabledResettableCharSpec" t ;; (function)
           "characterization.STA.CharacterizationSpecs.UnitDelayResettableCharSpec" t ;; (function)
           "characterization.STA.DoubleIterator" t ;; (class)
           "characterization.STA.genhdltdb" t ;; (function)
           "characterization.STA.ImplBlockCharacterization" t ;; (class)
           "characterization.STA.ImplCallBacks.BitShiftCallback" t ;; (class)
           "characterization.STA.ImplCallBacks.DataTypeConversionCallback" t ;; (class)
           "characterization.STA.ImplCallBacks.Deserializer1DCallback" t ;; (class)
           "characterization.STA.ImplCallBacks.HDLCounterCallback" t ;; (class)
           "characterization.STA.ImplCallBacks.LogicCallback" t ;; (class)
           "characterization.STA.ImplCallBacks.LookupTableCallback" t ;; (class)
           "characterization.STA.ImplCallBacks.MultiPortSwitchCallback" t ;; (class)
           "characterization.STA.ImplCallBacks.ProductCallback" t ;; (class)
           "characterization.STA.ImplCallBacks.ProductDSPCallback" t ;; (class)
           "characterization.STA.ImplCallBacks.RateTransitionCallback" t ;; (class)
           "characterization.STA.ImplCallBacks.SaturationCallback" t ;; (class)
           "characterization.STA.ImplCallBacks.Serializer1DCallback" t ;; (class)
           "characterization.STA.ImplCallBacks.UnitDelayCallback" t ;; (class)
           "characterization.STA.ImplCallBacks.UnitDelayEnabledCallback" t ;; (class)
           "characterization.STA.ImplCallBacks.UnitDelayEnabledResettableCallback" t ;; (class)
           "characterization.STA.ImplCallBacks.UnitDelayResettableCallback" t ;; (class)
           "characterization.STA.ImplementationCallback" t ;; (class)
           "characterization.STA.ImplementationConfigCallback" t ;; (class)
           "characterization.STA.ImplModelCreation" t ;; (class)
           "characterization.STA.IntelQuartus.validateTargetSettings" t ;; (function)
           "characterization.STA.ListIterator" t ;; (class)
           "characterization.STA.MatFileNameGenerator" t ;; (class)
           "characterization.STA.MultiIterator" t ;; (class)
           "characterization.STA.RegexpCatalog" t ;; (class)
           "characterization.STA.RegexpCatalog.DecimalNumber" 'property
           "characterization.STA.StepIterator" t ;; (class)
           "characterization.STA.SynthesisDriver" t ;; (class)
           "characterization.STA.TimingLogReader" t ;; (class)
           "characterization.STA.XilinxVivado.validateTargetSettings" t ;; (function)
           "characterListPattern" t ;; (mFile) Match characters from list
           "chartsimplifier" t ;; (mFile)
           "chbpnt" t ;; (mFile) Chebyshev-Demko points
           "chckxywp" t ;; (mFile)
           "cheb1ap" t ;; (mFile) Chebyshev Type I analog lowpass filter prototype
           "cheb1ord" t ;; (mFile) Chebyshev Type I filter order
           "cheb2ap" t ;; (mFile) Chebyshev Type II analog lowpass filter prototype
           "cheb2ord" t ;; (mFile) Chebyshev Type II filter order
           "chebwin" t ;; (mFile) Chebyshev window
           "cheby1" t ;; (mFile) Chebyshev Type I filter using specification object
           "cheby2" t ;; (mFile) Chebyshev Type II filter using specification object
           "check_DMA_ch" t ;; (mFile)
           "check_DMA_ext" t ;; (mFile)
           "check_PWM_module" t ;; (mFile)
           "check_run_enabled" t ;; (pFile)
           "checkangleunits" t ;; (mFile)
           "checkBlockNum" t ;; (mFile)
           "checkbounds" t ;; (mFile)
           "checkByteOrderSetting" t ;; (mFile)
           "checkcode" t ;; (mFile) Check MATLAB code files for possible problems
           "checkCollision" t ;; (mFile) Check if two geometries are in collision
           "checkControlSystemTunerInstallation" t ;; (mFile)
           "checkCounterParams" t ;; (mFile)
           "checkcreditcrv" t ;; (mFile)
           "checkellipsoid" t ;; (mFile)
           "checkePWMLink" t ;; (mFile)
           "checkerboard" t ;; (mFile) Create checkerboard image
           "checkFeedback" t ;; (mFile) Identify possible feedback data
           "checkfis" t ;; (mFile)
           "checkfpgadesign" t ;; (pFile)
           "checkgeoquad" t ;; (mFile)
           "checkGradients" t ;; (mFile) Check first derivative function against finite-difference approximation
           "checkhdl" t ;; (mFile) Check subsystem or model for HDL code generation compatibility
           "checkIfAllSameWithPath" t ;; (mFile)
           "checkinp" t ;; (mFile)
           "checkinputsigdim" t ;; (mFile)
           "checklatlon" t ;; (mFile)
           "checkLayer" t ;; (mFile) Check validity of custom or function layer
           "checkMapCollision" t ;; (mFile) Check for collision between 3-D occupancy map and geometry
           "checkMeshIncompatible" t ;; (mFile)
           "checkMeshValidity" t ;; (mFile)
           "checkMeshWatertight" t ;; (mFile)
           "checkMixedDataTypes" t ;; (pFile)
           "checkmvnrsetup" t ;; (mFile)
           "CheckNetworkData" t ;; (mFile)
           "checkOneDriveFileAvailability" t ;; (mFile)
           "checkoptionsize" t ;; (mFile)
           "checkpack.absCheckDlg" t ;; (class)
           "checkpack.absCheckDlg.configBlk" t ;; (method)
           "checkpack.absCheckDlg.getMaskDisplayString" t ;; (method)
           "checkpack.absCheckDlg.loadBlkFcn" t ;; (method)
           "checkpack.absCheckDlg.openBlkFcn" t ;; (method)
           "checkpack.absCheckDlg.openBlkView" t ;; (method)
           "checkpack.absCheckTimeDlg" t ;; (class)
           "checkpack.absCheckTimeDlg.configBlk" t ;; (method)
           "checkpack.absCheckTimeDlg.copyBlkFcn" t ;; (method)
           "checkpack.absCheckTimeDlg.createBlockScope" t ;; (method)
           "checkpack.absCheckTimeDlg.getCoreBlock" t ;; (method)
           "checkpack.absCheckTimeDlg.getDefaultPos" t ;; (method)
           "checkpack.absCheckTimeDlg.getMaskDisplayString" t ;; (method)
           "checkpack.absCheckTimeDlg.loadBlkFcn" t ;; (method)
           "checkpack.absCheckTimeDlg.openBlkFcn" t ;; (method)
           "checkpack.absCheckTimeDlg.openBlkView" t ;; (method)
           "checkpack.absCheckVisual" t ;; (class)
           "checkpack.absCheckVisual.getAllBlocks" t ;; (method)
           "checkpack.absCheckVisual.getDefaultObject" t ;; (method)
           "checkpack.absCheckVisual.getPropertySet" t ;; (method)
           "checkpack.CheckAgainstReferenceDlg" t ;; (class)
           "checkpack.CheckAgainstReferenceDlg.configBlk" t ;; (method)
           "checkpack.CheckAgainstReferenceDlg.copyBlkFcn" t ;; (method)
           "checkpack.CheckAgainstReferenceDlg.createBlockScope" t ;; (method)
           "checkpack.CheckAgainstReferenceDlg.customizeConstr" t ;; (method)
           "checkpack.CheckAgainstReferenceDlg.getBounds" t ;; (method)
           "checkpack.CheckAgainstReferenceDlg.getCoreBlock" t ;; (method)
           "checkpack.CheckAgainstReferenceDlg.getDefaultPos" t ;; (method)
           "checkpack.CheckAgainstReferenceDlg.getMaskDisplayString" t ;; (method)
           "checkpack.CheckAgainstReferenceDlg.loadBlkFcn" t ;; (method)
           "checkpack.CheckAgainstReferenceDlg.newconstr" t ;; (method)
           "checkpack.CheckAgainstReferenceDlg.openBlkFcn" t ;; (method)
           "checkpack.CheckAgainstReferenceDlg.openBlkView" t ;; (method)
           "checkpack.CheckAgainstReferenceDlg.setBounds" t ;; (method)
           "checkpack.checkblkviews.CheckBlockScopeCLI" t ;; (class)
           "checkpack.checkblkviews.CheckBlockScopeVisData" t ;; (class)
           "checkpack.checkblkviews.SrcSLEventCoreData" t ;; (class)
           "checkpack.checkblkviews.TimeScope" t ;; (function)
           "checkpack.checkblkviews.TimeScopeCfg" t ;; (class)
           "checkpack.CheckCustomBoundsDlg" t ;; (class)
           "checkpack.CheckCustomBoundsDlg.configBlk" t ;; (method)
           "checkpack.CheckCustomBoundsDlg.copyBlkFcn" t ;; (method)
           "checkpack.CheckCustomBoundsDlg.createBlockScope" t ;; (method)
           "checkpack.CheckCustomBoundsDlg.customizeConstr" t ;; (method)
           "checkpack.CheckCustomBoundsDlg.getBounds" t ;; (method)
           "checkpack.CheckCustomBoundsDlg.getCoreBlock" t ;; (method)
           "checkpack.CheckCustomBoundsDlg.getDefaultPos" t ;; (method)
           "checkpack.CheckCustomBoundsDlg.getMaskDisplayString" t ;; (method)
           "checkpack.CheckCustomBoundsDlg.getPWLData" t ;; (method)
           "checkpack.CheckCustomBoundsDlg.loadBlkFcn" t ;; (method)
           "checkpack.CheckCustomBoundsDlg.newconstr" t ;; (method)
           "checkpack.CheckCustomBoundsDlg.openBlkFcn" t ;; (method)
           "checkpack.CheckCustomBoundsDlg.openBlkView" t ;; (method)
           "checkpack.CheckCustomBoundsDlg.setBounds" t ;; (method)
           "checkpack.CheckStepResponseDlg" t ;; (class)
           "checkpack.CheckStepResponseDlg.configBlk" t ;; (method)
           "checkpack.CheckStepResponseDlg.copyBlkFcn" t ;; (method)
           "checkpack.CheckStepResponseDlg.createBlockScope" t ;; (method)
           "checkpack.CheckStepResponseDlg.customizeConstr" t ;; (method)
           "checkpack.CheckStepResponseDlg.getBounds" t ;; (method)
           "checkpack.CheckStepResponseDlg.getCoreBlock" t ;; (method)
           "checkpack.CheckStepResponseDlg.getDefaultPos" t ;; (method)
           "checkpack.CheckStepResponseDlg.getMaskDisplayString" t ;; (method)
           "checkpack.CheckStepResponseDlg.getPWLData" t ;; (method)
           "checkpack.CheckStepResponseDlg.loadBlkFcn" t ;; (method)
           "checkpack.CheckStepResponseDlg.newconstr" t ;; (method)
           "checkpack.CheckStepResponseDlg.openBlkFcn" t ;; (method)
           "checkpack.CheckStepResponseDlg.openBlkView" t ;; (method)
           "checkpack.CheckStepResponseDlg.setBounds" t ;; (method)
           "checkpack.checkVisualizationDirty" t ;; (function)
           "checkpack.CheckVisualZoom" t ;; (class)
           "checkpack.CheckVisualZoom.getDefaultObject" t ;; (method)
           "checkpack.CheckVisualZoom.getPropertySet" t ;; (method)
           "checkpack.createCheckDlg" t ;; (function)
           "checkpack.RequirementTool" t ;; (class)
           "checkpack.RequirementTool.getDefaultObject" t ;; (method)
           "checkpack.RequirementTool.getPropertySet" t ;; (method)
           "checkpack.SrcSLEvent" t ;; (class)
           "checkpack.SrcSLEvent.getDefaultObject" t ;; (method)
           "checkpack.SrcSLEvent.getPropertySet" t ;; (method)
           "checkpack.TimeVisual" t ;; (class)
           "checkpack.TimeVisual.getAllBlocks" t ;; (method)
           "checkpack.TimeVisual.getDefaultObject" t ;; (method)
           "checkpack.TimeVisual.getPropertySet" t ;; (method)
           "checkpacklib" t ;; (slxFile)
           "checkPathValidity" t ;; (mFile) Check validity of planned vehicle path
           "checkPluginClass" t ;; (pFile)
           "checkrng" t ;; (mFile)
           "checkSDEinputs" t ;; (mFile)
           "checkSDRProductRequirements" t ;; (pFile)
           "checkSelfIntersections" t ;; (mFile)
           "checkSelfIntersections_atx" t ;; (pFile)
           "checkSensorParameters" t ;; (pFile)
           "checkSerDesBlocks" t ;; (pFile)
           "checkSerDesBlocksAction" t ;; (pFile)
           "checkSingleTaskingSolver" t ;; (pFile)
           "checksiz" t ;; (mFile)
           "checkstruct" t ;; (mFile)
           "checksymmetry" t ;; (pFile)
           "checkSyntacticWarnings" t ;; (mFile)
           "checktree" t ;; (mFile)
           "checktyp" t ;; (mFile)
           "checkvolcrv" t ;; (mFile)
           "CheckZ" t ;; (mFile)
           "checkzerocrv" t ;; (mFile)
           "chemical_dataset" t ;; (mFile)
           "chgwdeccfs" t ;; (mFile) Change multisignal 1-D decomposition coefficients
           "chhsparm" t ;; (mFile)
           "chi2cdf" t ;; (mFile) Chi-square cumulative distribution function
           "chi2gof" t ;; (mFile) Chi-square goodness-of-fit test
           "chi2inv" t ;; (mFile) Chi-square inverse cumulative distribution function
           "chi2pdf" t ;; (mFile) Chi-square probability density function
           "chi2rnd" t ;; (mFile) Chi-square random numbers
           "chi2stat" t ;; (mFile) Chi-square mean and variance
           "chickenpox_dataset" t ;; (mFile)
           "chirp" t ;; (mFile) Swept-frequency cosine
           "chkbonddateparams" t ;; (mFile)
           "ChkIfBlockReusable" t ;; (mFile)
           "cho_dataset" t ;; (mFile)
           "chol" t ;; (mFile) Cholesky factorization
           "cholcov" t ;; (mFile) Cholesky-like covariance decomposition
           "cholupdate" t ;; (mFile) Rank 1 update to Cholesky factorization
           "chomega" t ;; (mFile)
           "chompCollisionOptions" t ;; (mFile) Collision options for CHOMP trajectories
           "chompSmoothnessOptions" t ;; (mFile) Smoothness options for CHOMP trajectories
           "chompSolverOptions" t ;; (mFile) Solver options for CHOMP motion planner
           "chooserbybls" t ;; (mFile) Price European simple chooser options using Black-Scholes model
           "chop" t ;; (mFile)
           "Chopper_class" t ;; (pFile)
           "chowtest" t ;; (mFile) Chow test for structural change
           "chromadapt" t ;; (mFile) Adjust color balance of RGB image with chromatic adaptation
           "chromosomeplot" t ;; (mFile) Plot chromosome ideogram with G-banding pattern
           "chstr" t ;; (mFile)
           "ciccompdecimator" t ;; (mFile)
           "ciccompinterpolator" t ;; (mFile)
           "cicdecimator" t ;; (mFile)
           "cicinterpolator" t ;; (mFile)
           "cicnulls" t ;; (mFile)
           "cigar2align" t ;; (mFile) Convert unaligned sequences to aligned sequences using signatures in CIGAR format
           "cipmatch" t ;; (mFile)
           "cir" t ;; (mFile) Cox-Ingersoll-Ross (CIR) mean-reverting square root diffusion model
           "circ2ss" t ;; (mFile)
           "circcirc" t ;; (mFile) Find intersection of circles in Cartesian coordinates
           "circleb1" t ;; (mFile)
           "circleb2" t ;; (mFile)
           "circlef" t ;; (mFile)
           "circleg" t ;; (mFile)
           "circlepick" t ;; (mFile)
           "circles2mask" t ;; (mFile) Create binary masks from circles
           "circpol2pol" t ;; (mFile) Convert circular component representation of field to linear component representation
           "circshift" t ;; (mFile) Shift array circularly
           "circuit" t ;; (mFile) Circuit object
           "circuit.ElementTypes" 'property
           "circuitWizard" t ;; (mFile) Build block or analyze circuit from circuit object
           "circularArray" t ;; (mFile) Create circular antenna array
           "CirculatingCurrentInduct_class" t ;; (pFile)
           "cirprice" t ;; (mFile) Instrument prices from Cox-Ingersoll-Ross interest-rate model
           "cirsb" t ;; (mFile)
           "cirsens" t ;; (mFile) Instrument sensitivities and prices from Cox-Ingersoll-Ross interest-rate model
           "cirsg" t ;; (mFile)
           "cirtimespec" t ;; (mFile) Specify time structure for Cox-Ingersoll-Ross tree
           "cirtree" t ;; (mFile) Build a Cox-Ingersoll-Ross interest-rate tree
           "cirtreetime" t ;; (mFile)
           "cirvolspec" t ;; (mFile) Specify Cox-Ingersoll-Ross interest-rate volatility process
           "cjt" t ;; (mFile)
           "cl2tf" t ;; (mFile) Convert coupled allpass lattice to transfer function form
           "cla" t ;; (mFile) Clear axes
           "clabel" t ;; (mFile) Label contour plot elevation
           "clabelm" t ;; (mFile) Label map contour plot
           "claMathCallback" t ;; (mFile)
           "clang_tools_validator" t ;; (mFile)
           "clangSetupFcn" t ;; (mFile)
           "class" t ;; (mFile) Class of object
           "classdiagram.app.core.ClassDiagramApp" t ;; (class)
           "classdiagram.app.core.ClassDiagramFactory" t ;; (class)
           "classdiagram.app.core.ClassDiagramLaunchManager" t ;; (class)
           "classdiagram.app.core.ClassDiagramLaunchManager.closeClassViewer" t ;; (method)
           "classdiagram.app.core.ClassDiagramLaunchManager.getViewer" t ;; (method)
           "classdiagram.app.core.ClassDiagramLaunchManager.importClassesFrom" t ;; (method)
           "classdiagram.app.core.ClassDiagramLaunchManager.launchClassViewer" t ;; (method)
           "classdiagram.app.core.ClassDiagramWindow" t ;; (class)
           "classdiagram.app.core.commands.addPrototypes" t ;; (function)
           "classdiagram.app.core.commands.ClassDiagramChangeDiagramSettingCommand" t ;; (class)
           "classdiagram.app.core.commands.ClassDiagramChangeDiagramSettingCommand.commandSource" 'property
           "classdiagram.app.core.commands.ClassDiagramChangeDiagramSettingCommand.Constants" 'property
           "classdiagram.app.core.commands.ClassDiagramChangeDiagramSettingCommand.delta" 'property
           "classdiagram.app.core.commands.ClassDiagramChangeDiagramSettingCommand.description" 'property
           "classdiagram.app.core.commands.ClassDiagramChangeDiagramSettingCommand.syntax" 'property
           "classdiagram.app.core.commands.ClassDiagramChangeDiagramSettingCommand.type" 'property
           "classdiagram.app.core.commands.ClassDiagramCreateCommand" t ;; (class)
           "classdiagram.app.core.commands.ClassDiagramCreateCommand.commandSource" 'property
           "classdiagram.app.core.commands.ClassDiagramCreateCommand.Constants" 'property
           "classdiagram.app.core.commands.ClassDiagramCreateCommand.delta" 'property
           "classdiagram.app.core.commands.ClassDiagramCreateCommand.description" 'property
           "classdiagram.app.core.commands.ClassDiagramCreateCommand.syntax" 'property
           "classdiagram.app.core.commands.ClassDiagramCreateCommand.type" 'property
           "classdiagram.app.core.commands.ClassDiagramDeleteCommand" t ;; (class)
           "classdiagram.app.core.commands.ClassDiagramDeleteCommand.commandSource" 'property
           "classdiagram.app.core.commands.ClassDiagramDeleteCommand.Constants" 'property
           "classdiagram.app.core.commands.ClassDiagramDeleteCommand.delta" 'property
           "classdiagram.app.core.commands.ClassDiagramDeleteCommand.description" 'property
           "classdiagram.app.core.commands.ClassDiagramDeleteCommand.syntax" 'property
           "classdiagram.app.core.commands.ClassDiagramDeleteCommand.type" 'property
           "classdiagram.app.core.commands.ClassDiagramExpandCommand" t ;; (class)
           "classdiagram.app.core.commands.ClassDiagramExpandCommand.commandSource" 'property
           "classdiagram.app.core.commands.ClassDiagramExpandCommand.Constants" 'property
           "classdiagram.app.core.commands.ClassDiagramExpandCommand.delta" 'property
           "classdiagram.app.core.commands.ClassDiagramExpandCommand.description" 'property
           "classdiagram.app.core.commands.ClassDiagramExpandCommand.syntax" 'property
           "classdiagram.app.core.commands.ClassDiagramExpandCommand.type" 'property
           "classdiagram.app.core.commands.ClassDiagramLayoutCommand" t ;; (class)
           "classdiagram.app.core.commands.ClassDiagramLayoutCommand.commandSource" 'property
           "classdiagram.app.core.commands.ClassDiagramLayoutCommand.Constants" 'property
           "classdiagram.app.core.commands.ClassDiagramLayoutCommand.delta" 'property
           "classdiagram.app.core.commands.ClassDiagramLayoutCommand.description" 'property
           "classdiagram.app.core.commands.ClassDiagramLayoutCommand.syntax" 'property
           "classdiagram.app.core.commands.ClassDiagramLayoutCommand.type" 'property
           "classdiagram.app.core.commands.ClassDiagramRefreshCommand" t ;; (class)
           "classdiagram.app.core.commands.ClassDiagramRefreshCommand.commandSource" 'property
           "classdiagram.app.core.commands.ClassDiagramRefreshCommand.Constants" 'property
           "classdiagram.app.core.commands.ClassDiagramRefreshCommand.delta" 'property
           "classdiagram.app.core.commands.ClassDiagramRefreshCommand.description" 'property
           "classdiagram.app.core.commands.ClassDiagramRefreshCommand.syntax" 'property
           "classdiagram.app.core.commands.ClassDiagramRefreshCommand.type" 'property
           "classdiagram.app.core.commands.ClassDiagramUndoRedo" t ;; (class)
           "classdiagram.app.core.commands.ClassDiagramUndoRedo.Constants" 'property
           "classdiagram.app.core.commands.CommandWithError" t ;; (class)
           "classdiagram.app.core.commands.CommandWithError.commandSource" 'property
           "classdiagram.app.core.commands.CommandWithError.delta" 'property
           "classdiagram.app.core.commands.CommandWithError.description" 'property
           "classdiagram.app.core.commands.CommandWithError.syntax" 'property
           "classdiagram.app.core.commands.CommandWithError.type" 'property
           "classdiagram.app.core.commands.registerCustomCommands" t ;; (function)
           "classdiagram.app.core.domain.BaseObject" t ;; (class)
           "classdiagram.app.core.domain.Class" t ;; (class)
           "classdiagram.app.core.domain.Class.ConstantType" 'property
           "classdiagram.app.core.domain.Class.DefaultIcon" 'property
           "classdiagram.app.core.domain.ClassDiagramTypes" t ;; (class)
           "classdiagram.app.core.domain.ElementState" t ;; (class)
           "classdiagram.app.core.domain.ElementState.Normal" 'enumeration
           "classdiagram.app.core.domain.ElementState.NotOnPath" 'enumeration
           "classdiagram.app.core.domain.ElementState.Stale" 'enumeration
           "classdiagram.app.core.domain.Enum" t ;; (class)
           "classdiagram.app.core.domain.Enum.ConstantType" 'property
           "classdiagram.app.core.domain.Enum.DefaultIcon" 'property
           "classdiagram.app.core.domain.EnumLiteral" t ;; (class)
           "classdiagram.app.core.domain.EnumLiteral.ConstantType" 'property
           "classdiagram.app.core.domain.Event" t ;; (class)
           "classdiagram.app.core.domain.Event.ConstantType" 'property
           "classdiagram.app.core.domain.Folder" t ;; (class)
           "classdiagram.app.core.domain.Folder.classNameFromClassFolder" t ;; (method)
           "classdiagram.app.core.domain.Folder.classNameFromPath" t ;; (method)
           "classdiagram.app.core.domain.Folder.classPathsFromFolder" t ;; (method)
           "classdiagram.app.core.domain.Folder.ConstantType" 'property
           "classdiagram.app.core.domain.Folder.DefaultIcon" 'property
           "classdiagram.app.core.domain.Folder.getImmediateSubFolders" t ;; (method)
           "classdiagram.app.core.domain.Folder.getNamespaceElementNames" t ;; (method)
           "classdiagram.app.core.domain.Folder.getNearestPlainFolder" t ;; (method)
           "classdiagram.app.core.domain.Folder.getPathParts" t ;; (method)
           "classdiagram.app.core.domain.Folder.isClassFolder" t ;; (method)
           "classdiagram.app.core.domain.Folder.isNamespaceFolder" t ;; (method)
           "classdiagram.app.core.domain.Folder.isOnPath" t ;; (method)
           "classdiagram.app.core.domain.Folder.PackageFolderIcon" 'property
           "classdiagram.app.core.domain.FolderElement" t ;; (class)
           "classdiagram.app.core.domain.FolderElement.classNameFromClassFolder" t ;; (method)
           "classdiagram.app.core.domain.FolderElement.classNameFromPath" t ;; (method)
           "classdiagram.app.core.domain.FolderElement.classPathsFromFolder" t ;; (method)
           "classdiagram.app.core.domain.FolderElement.getImmediateSubFolders" t ;; (method)
           "classdiagram.app.core.domain.FolderElement.getNamespaceElementNames" t ;; (method)
           "classdiagram.app.core.domain.FolderElement.getNearestPlainFolder" t ;; (method)
           "classdiagram.app.core.domain.FolderElement.getPathParts" t ;; (method)
           "classdiagram.app.core.domain.FolderElement.isClassFolder" t ;; (method)
           "classdiagram.app.core.domain.FolderElement.isNamespaceFolder" t ;; (method)
           "classdiagram.app.core.domain.FolderElement.isOnPath" t ;; (method)
           "classdiagram.app.core.domain.Method" t ;; (class)
           "classdiagram.app.core.domain.Method.ConstantType" 'property
           "classdiagram.app.core.domain.Namespace" t ;; (class)
           "classdiagram.app.core.domain.Namespace.ConstantType" 'property
           "classdiagram.app.core.domain.Namespace.DefaultIcon" 'property
           "classdiagram.app.core.domain.Namespace.hasNamespaceElements" t ;; (method)
           "classdiagram.app.core.domain.NamespaceElement" t ;; (class)
           "classdiagram.app.core.domain.Package" t ;; (class)
           "classdiagram.app.core.domain.Package.classNameFromClassFolder" t ;; (method)
           "classdiagram.app.core.domain.Package.classNameFromPath" t ;; (method)
           "classdiagram.app.core.domain.Package.classPathsFromFolder" t ;; (method)
           "classdiagram.app.core.domain.Package.ConstantType" 'property
           "classdiagram.app.core.domain.Package.DefaultIcon" 'property
           "classdiagram.app.core.domain.Package.getImmediateSubFolders" t ;; (method)
           "classdiagram.app.core.domain.Package.getNamespaceElementNames" t ;; (method)
           "classdiagram.app.core.domain.Package.getNearestPlainFolder" t ;; (method)
           "classdiagram.app.core.domain.Package.getPathParts" t ;; (method)
           "classdiagram.app.core.domain.Package.isClassFolder" t ;; (method)
           "classdiagram.app.core.domain.Package.isNamespaceFolder" t ;; (method)
           "classdiagram.app.core.domain.Package.isOnPath" t ;; (method)
           "classdiagram.app.core.domain.Project" t ;; (class)
           "classdiagram.app.core.domain.Project.classNameFromClassFolder" t ;; (method)
           "classdiagram.app.core.domain.Project.classNameFromPath" t ;; (method)
           "classdiagram.app.core.domain.Project.classPathsFromFolder" t ;; (method)
           "classdiagram.app.core.domain.Project.ConstantType" 'property
           "classdiagram.app.core.domain.Project.DefaultIcon" 'property
           "classdiagram.app.core.domain.Project.getImmediateSubFolders" t ;; (method)
           "classdiagram.app.core.domain.Project.getNamespaceElementNames" t ;; (method)
           "classdiagram.app.core.domain.Project.getNearestPlainFolder" t ;; (method)
           "classdiagram.app.core.domain.Project.getPathParts" t ;; (method)
           "classdiagram.app.core.domain.Project.isClassFolder" t ;; (method)
           "classdiagram.app.core.domain.Project.isNamespaceFolder" t ;; (method)
           "classdiagram.app.core.domain.Project.isOnPath" t ;; (method)
           "classdiagram.app.core.domain.Project.Stale" 'property
           "classdiagram.app.core.domain.Property" t ;; (class)
           "classdiagram.app.core.domain.Property.ConstantType" 'property
           "classdiagram.app.core.domain.Relationship" t ;; (class)
           "classdiagram.app.core.domain.Relationship.ConstantType" 'property
           "classdiagram.app.core.domain.RelationshipEnd" t ;; (class)
           "classdiagram.app.core.domain.RelationshipEnd.ConstantType" 'property
           "classdiagram.app.core.ElementCreator" t ;; (class)
           "classdiagram.app.core.ElementCreator.Constants" 'property
           "classdiagram.app.core.Exporter" t ;; (class)
           "classdiagram.app.core.feature.cfb" t ;; (function)
           "classdiagram.app.core.feature.isOn" t ;; (function)
           "classdiagram.app.core.feature.notifications" t ;; (function)
           "classdiagram.app.core.Importer" t ;; (class)
           "classdiagram.app.core.inspector.AssociationPropertySchema" t ;; (class)
           "classdiagram.app.core.inspector.DiagramPropertySchema" t ;; (class)
           "classdiagram.app.core.inspector.InheritancePropertySchema" t ;; (class)
           "classdiagram.app.core.inspector.Inspector" t ;; (class)
           "classdiagram.app.core.inspector.InspectorProvider" t ;; (class)
           "classdiagram.app.core.inspector.InspectorProvider.onEditComplete" t ;; (method)
           "classdiagram.app.core.inspector.InspectorProvider.onFilterRequest" t ;; (method)
           "classdiagram.app.core.inspector.InspectorProvider.onGroupByRequest" t ;; (method)
           "classdiagram.app.core.inspector.InspectorProvider.onSortRequest" t ;; (method)
           "classdiagram.app.core.inspector.InspectorProvider.RootID" 'property
           "classdiagram.app.core.inspector.PropertyInfo" t ;; (class)
           "classdiagram.app.core.inspector.PropertySchemaInterface" t ;; (class)
           "classdiagram.app.core.notifications.Batchlist" t ;; (class)
           "classdiagram.app.core.notifications.ClassDiagramCleanUpRules" t ;; (class)
           "classdiagram.app.core.notifications.CleanUpRules" t ;; (class)
           "classdiagram.app.core.notifications.createElementDiagnosticWidget" t ;; (function)
           "classdiagram.app.core.notifications.DeletedWidgetEventData" t ;; (class)
           "classdiagram.app.core.notifications.DWRegistry" t ;; (class)
           "classdiagram.app.core.notifications.LozengeType" t ;; (class)
           "classdiagram.app.core.notifications.LozengeType.StandardMessage" 'enumeration
           "classdiagram.app.core.notifications.LozengeType.UndoRedo" 'enumeration
           "classdiagram.app.core.notifications.mapUtils" t ;; (class)
           "classdiagram.app.core.notifications.mapUtils.addEntries" t ;; (method)
           "classdiagram.app.core.notifications.mapUtils.addEntry" t ;; (method)
           "classdiagram.app.core.notifications.mapUtils.getValsByMultipleKeys" t ;; (method)
           "classdiagram.app.core.notifications.mapUtils.mergeMaps" t ;; (method)
           "classdiagram.app.core.notifications.mapUtils.removeEntry" t ;; (method)
           "classdiagram.app.core.notifications.mapUtils.removeKey" t ;; (method)
           "classdiagram.app.core.notifications.Modality" t ;; (class)
           "classdiagram.app.core.notifications.Modality.MODAL" 'enumeration
           "classdiagram.app.core.notifications.Modality.MODELESS" 'enumeration
           "classdiagram.app.core.notifications.Modality.SOME" 'enumeration
           "classdiagram.app.core.notifications.Mode" t ;; (class)
           "classdiagram.app.core.notifications.Mode.CL" 'enumeration
           "classdiagram.app.core.notifications.Mode.UI" 'enumeration
           "classdiagram.app.core.notifications.Mode.WAIT" 'enumeration
           "classdiagram.app.core.notifications.notifications.AbstractNotification" t ;; (class)
           "classdiagram.app.core.notifications.notifications.BlockLimitReachedInfo" t ;; (class)
           "classdiagram.app.core.notifications.notifications.BlockLimitSurpassedWarn" t ;; (class)
           "classdiagram.app.core.notifications.notifications.DiagramNotification" t ;; (class)
           "classdiagram.app.core.notifications.notifications.ElementNotification" t ;; (class)
           "classdiagram.app.core.notifications.notifications.ErrMInvalidMCOSClass" t ;; (class)
           "classdiagram.app.core.notifications.notifications.ErrMInvalidMCOSNamespace" t ;; (class)
           "classdiagram.app.core.notifications.notifications.ErrMInvalidMCOSObject" t ;; (class)
           "classdiagram.app.core.notifications.notifications.ErrMInvalidMCOSPackage" t ;; (class)
           "classdiagram.app.core.notifications.notifications.ErrMNotInDiagram" t ;; (class)
           "classdiagram.app.core.notifications.notifications.ErrMNotSupported" t ;; (class)
           "classdiagram.app.core.notifications.notifications.makeCDVMessage" t ;; (function)
           "classdiagram.app.core.notifications.notifications.makeMessage" t ;; (function)
           "classdiagram.app.core.notifications.notifications.MExceptionNotification" t ;; (class)
           "classdiagram.app.core.notifications.notifications.NClassesAddedInfo" t ;; (class)
           "classdiagram.app.core.notifications.notifications.NClassesRemovedInfo" t ;; (class)
           "classdiagram.app.core.notifications.notifications.OutOfSyncClass" t ;; (class)
           "classdiagram.app.core.notifications.notifications.PIError" t ;; (class)
           "classdiagram.app.core.notifications.notifications.Success" t ;; (class)
           "classdiagram.app.core.notifications.notifications.WDFCommandNotification" t ;; (class)
           "classdiagram.app.core.notifications.notifications.WDFNotification" t ;; (class)
           "classdiagram.app.core.notifications.Notifier" t ;; (class)
           "classdiagram.app.core.notifications.output.DiagnosticWidget" t ;; (class)
           "classdiagram.app.core.notifications.output.DiagnosticWidget.getDefaultWidgetConfiguration" t ;; (method)
           "classdiagram.app.core.notifications.output.DiagnosticWidgetData" t ;; (class)
           "classdiagram.app.core.notifications.output.PositionSpecification" t ;; (class)
           "classdiagram.app.core.notifications.output.utils.PreferredSide" t ;; (class)
           "classdiagram.app.core.notifications.output.utils.PreferredSide.BOTTOM" 'enumeration
           "classdiagram.app.core.notifications.output.utils.PreferredSide.LEFT" 'enumeration
           "classdiagram.app.core.notifications.output.utils.PreferredSide.RIGHT" 'enumeration
           "classdiagram.app.core.notifications.output.utils.PreferredSide.TOP" 'enumeration
           "classdiagram.app.core.notifications.output.WDFNotificationsProvider" t ;; (class)
           "classdiagram.app.core.notifications.output.WDFNotificationsProvider.isNotifObj" t ;; (method)
           "classdiagram.app.core.notifications.output.WDFNotificationsProvider.onEditComplete" t ;; (method)
           "classdiagram.app.core.notifications.output.WDFNotificationsProvider.onFilterRequest" t ;; (method)
           "classdiagram.app.core.notifications.output.WDFNotificationsProvider.onGroupByRequest" t ;; (method)
           "classdiagram.app.core.notifications.output.WDFNotificationsProvider.onSortRequest" t ;; (method)
           "classdiagram.app.core.notifications.output.WDFNotificationsProvider.Root" 'property
           "classdiagram.app.core.notifications.output.WDFNotificationsProvider.TotalsType" 'property
           "classdiagram.app.core.notifications.Severity" t ;; (class)
           "classdiagram.app.core.notifications.Severity.Error" 'enumeration
           "classdiagram.app.core.notifications.Severity.Info" 'enumeration
           "classdiagram.app.core.notifications.Severity.Success" 'enumeration
           "classdiagram.app.core.notifications.Severity.Warning" 'enumeration
           "classdiagram.app.core.notifications.struct2vector" t ;; (function)
           "classdiagram.app.core.notifications.Target" t ;; (class)
           "classdiagram.app.core.notifications.Target.Custom" 'enumeration
           "classdiagram.app.core.notifications.Target.Diagram" 'enumeration
           "classdiagram.app.core.notifications.Target.Element" 'enumeration
           "classdiagram.app.core.notifications.Waitlist" t ;; (class)
           "classdiagram.app.core.notifications.WDFNotificationsErrorHandler" t ;; (class)
           "classdiagram.app.core.notifications.WDFNotifier" t ;; (class)
           "classdiagram.app.core.ProjectLaunchManager" t ;; (class)
           "classdiagram.app.core.ProjectLaunchManager.closeProjectInClassViewer" t ;; (method)
           "classdiagram.app.core.ProjectLaunchManager.showProjectInClassViewer" t ;; (method)
           "classdiagram.app.core.Refresher" t ;; (class)
           "classdiagram.app.core.relationships.AssociationsHandler" t ;; (class)
           "classdiagram.app.core.relationships.AssociationsHandler.Primitives" 'property
           "classdiagram.app.core.relationships.ClassDiagramConnectionHandler" t ;; (class)
           "classdiagram.app.core.relationships.ClassDiagramConnectionHandler.findPropertyLineForAssociation" t ;; (method)
           "classdiagram.app.core.relationships.ClassDiagramConnectionHandler.horzOffset" 'property
           "classdiagram.app.core.relationships.ClassDiagramConnectionHandler.logPortPosition" t ;; (method)
           "classdiagram.app.core.relationships.ClassDiagramConnectionHandler.portSyntaxOffset" 'property
           "classdiagram.app.core.relationships.ClassDiagramConnectionHandler.vertOffset" 'property
           "classdiagram.app.core.relationships.InheritanceFlags" t ;; (class)
           "classdiagram.app.core.relationships.InheritanceFlags.DISABLEALL" 'enumeration
           "classdiagram.app.core.relationships.InheritanceFlags.DISABLEIMMEDIATE" 'enumeration
           "classdiagram.app.core.relationships.InheritanceFlags.HANDLE" 'enumeration
           "classdiagram.app.core.relationships.InheritanceFlags.MIXINS" 'enumeration
           "classdiagram.app.core.relationships.InheritanceFlags.NONE" 'enumeration
           "classdiagram.app.core.relationships.InheritanceFlags.OTHER" 'enumeration
           "classdiagram.app.core.relationships.InheritanceFlagsQuery" t ;; (class)
           "classdiagram.app.core.relationships.InheritanceGraph" t ;; (class)
           "classdiagram.app.core.relationships.InheritanceHandler" t ;; (class)
           "classdiagram.app.core.relationships.NamespaceMaps" t ;; (class)
           "classdiagram.app.core.Settings" t ;; (class)
           "classdiagram.app.core.Settings.getDefaultValue" t ;; (method)
           "classdiagram.app.core.Settings.propNameToFuncName" t ;; (method)
           "classdiagram.app.core.utils.Bitops" t ;; (class)
           "classdiagram.app.core.utils.Bitops.getCumulative" t ;; (method)
           "classdiagram.app.core.utils.Bitops.isAllSet" t ;; (method)
           "classdiagram.app.core.utils.Bitops.isAnySet" t ;; (method)
           "classdiagram.app.core.utils.Bitops.setFlag" t ;; (method)
           "classdiagram.app.core.utils.Bitops.unsetFlag" t ;; (method)
           "classdiagram.app.core.utils.Constants" t ;; (class)
           "classdiagram.app.core.utils.Constants.ClassTitleHeight" 'property
           "classdiagram.app.core.utils.Constants.ClassWidth" 'property
           "classdiagram.app.core.utils.Constants.EnumTitleHeight" 'property
           "classdiagram.app.core.utils.Constants.FooterHeight" 'property
           "classdiagram.app.core.utils.Constants.LineHeight" 'property
           "classdiagram.app.core.utils.Constants.Mixins" 'property
           "classdiagram.app.core.utils.Constants.PortWidth" 'property
           "classdiagram.app.core.utils.debugDisplay" t ;; (function)
           "classdiagram.app.core.utils.doDebug" t ;; (class)
           "classdiagram.app.core.utils.doDebug.debugPrint" t ;; (method)
           "classdiagram.app.core.utils.FileDialog" t ;; (class)
           "classdiagram.app.core.utils.filterMixins" t ;; (function)
           "classdiagram.app.core.utils.getListOfMixins" t ;; (function)
           "classdiagram.app.core.utils.getNextAppId" t ;; (function)
           "classdiagram.app.core.utils.isMixin" t ;; (function)
           "classdiagram.app.core.utils.logClose" t ;; (function)
           "classdiagram.app.core.utils.ObjectIDUtility" t ;; (class)
           "classdiagram.app.core.utils.ObjectIDUtility.containsPackageName" t ;; (method)
           "classdiagram.app.core.utils.ObjectIDUtility.generateClassID" t ;; (method)
           "classdiagram.app.core.utils.ObjectIDUtility.generateEnumID" t ;; (method)
           "classdiagram.app.core.utils.ObjectIDUtility.generateEnumLiteralID" t ;; (method)
           "classdiagram.app.core.utils.ObjectIDUtility.generateEventID" t ;; (method)
           "classdiagram.app.core.utils.ObjectIDUtility.generateFolderID" t ;; (method)
           "classdiagram.app.core.utils.ObjectIDUtility.generateID" t ;; (method)
           "classdiagram.app.core.utils.ObjectIDUtility.generateMethodID" t ;; (method)
           "classdiagram.app.core.utils.ObjectIDUtility.generateNamespaceID" t ;; (method)
           "classdiagram.app.core.utils.ObjectIDUtility.generatePackageID" t ;; (method)
           "classdiagram.app.core.utils.ObjectIDUtility.generateProjectID" t ;; (method)
           "classdiagram.app.core.utils.ObjectIDUtility.generatePropertyID" t ;; (method)
           "classdiagram.app.core.utils.ObjectIDUtility.generateRelationshipEndID" t ;; (method)
           "classdiagram.app.core.utils.ObjectIDUtility.generateRelationshipID" t ;; (method)
           "classdiagram.app.core.utils.ObjectIDUtility.getInfoFromID" t ;; (method)
           "classdiagram.app.core.utils.ObjectIDUtility.getPackageNameFromPath" t ;; (method)
           "classdiagram.app.core.utils.ObjectIDUtility.MethodPropDelimiter" 'property
           "classdiagram.app.core.utils.ObjectIDUtility.parseID" t ;; (method)
           "classdiagram.app.core.utils.ObjectIDUtility.stripType" t ;; (method)
           "classdiagram.app.core.utils.ObjectIDUtility.TypeDelimiter" 'property
           "classdiagram.app.core.utils.removeEmptyCells" t ;; (function)
           "classdiagram.app.core.utils.sortNames" t ;; (function)
           "classdiagram.app.core.visitors.DeleteObjectVisitor" t ;; (class)
           "classdiagram.app.core.visitors.GenerateIDVisitor" t ;; (class)
           "classdiagram.app.core.visitors.Visitor" t ;; (class)
           "classdiagram.app.core.WindowManager" t ;; (class)
           "classdiagram.app.core.WindowManager.Instance" 'property
           "classdiagram.app.io.ClassDiagramIOModelBuilder" t ;; (class)
           "classdiagram.app.io.FileClassDiagramFactory" t ;; (class)
           "classdiagram.app.io.FileClassDiagramFactory.getSectionByName" t ;; (method)
           "classdiagram.app.io.getCanonicalPath" t ;; (function)
           "classdiagram.app.io.IOMgr" t ;; (class)
           "classdiagram.app.mcos.ClassBrowser" t ;; (class)
           "classdiagram.app.mcos.InputParameters" t ;; (class)
           "classdiagram.app.mcos.InputParameters.IsDebugInput" 'property
           "classdiagram.app.mcos.InputParameters.ShowAssociationsInput" 'property
           "classdiagram.app.mcos.InputParameters.ShowHiddenInput" 'property
           "classdiagram.app.mcos.inspector.ClassPropertySchema" t ;; (class)
           "classdiagram.app.mcos.inspector.EnumPropertySchema" t ;; (class)
           "classdiagram.app.mcos.inspector.EventPropertySchema" t ;; (class)
           "classdiagram.app.mcos.inspector.MethodPropertySchema" t ;; (class)
           "classdiagram.app.mcos.inspector.PropPropertySchema" t ;; (class)
           "classdiagram.app.mcos.MCOSApp" t ;; (class)
           "classdiagram.app.mcos.MCOSClassDiagramFactory" t ;; (class)
           "classdiagram.app.mcos.MCOSConstants" t ;; (class)
           "classdiagram.app.mcos.MCOSConstants.FilteredMethods" 'property
           "classdiagram.app.mcos.MCOSContentProvider" t ;; (class)
           "classdiagram.app.mcos.MCOSContentProvider.onEditComplete" t ;; (method)
           "classdiagram.app.mcos.MCOSContentProvider.onFilterRequest" t ;; (method)
           "classdiagram.app.mcos.MCOSContentProvider.onGroupByRequest" t ;; (method)
           "classdiagram.app.mcos.MCOSContentProvider.onSortRequest" t ;; (method)
           "classdiagram.app.mcos.MCOSContentProvider.Root" 'property
           "classdiagram.app.mcos.MCOSDomain" t ;; (class)
           "classdiagram.app.mcos.MCOSDomain.getAllNamespaces" t ;; (method)
           "classdiagram.app.mcos.MCOSDomain.getClassDataFromName" t ;; (method)
           "classdiagram.app.mcos.MCOSDomain.getEmptyClassData" t ;; (method)
           "classdiagram.app.mcos.MCOSDomain.getInnerNamespaceDataFromMeta" t ;; (method)
           "classdiagram.app.mcos.MCOSDomain.getNamespaceDataFromClassName" t ;; (method)
           "classdiagram.app.mcos.MCOSDomain.getNamespaceDataFromName" t ;; (method)
           "classdiagram.app.mcos.MCOSDomain.getOuterNamespaceDataFromMeta" t ;; (method)
           "classdiagram.app.mcos.MCOSDomain.getOwningPackageIdForFolder" t ;; (method)
           "classdiagram.app.mcos.MCOSDomain.getPackageData" t ;; (method)
           "classdiagram.app.mcos.MCOSDomain.getPackagePath" t ;; (method)
           "classdiagram.app.mcos.MCOSDomain.getSubclassData" t ;; (method)
           "classdiagram.app.mcos.MCOSPackageProvider" t ;; (class)
           "classdiagram.app.mcos.MCOSPackageProvider.getFolderLabel" t ;; (method)
           "classdiagram.app.mcos.MCOSPackageProvider.hasChildren" t ;; (method)
           "classdiagram.app.mcos.MCOSPackageProvider.onEditComplete" t ;; (method)
           "classdiagram.app.mcos.MCOSPackageProvider.onFilterRequest" t ;; (method)
           "classdiagram.app.mcos.MCOSPackageProvider.onGroupByRequest" t ;; (method)
           "classdiagram.app.mcos.MCOSPackageProvider.onSortRequest" t ;; (method)
           "classdiagram.app.mcos.openClassViewerFromFile" t ;; (function)
           "classDiagramViewer" t ;; (mFile)
           "classfin" t ;; (mFile) Create financial structure or return financial structure class name
           "classID" t ;; (mFile)
           "ClassificationDiscriminant" t ;; (mFile) Discriminant analysis classification
           "ClassificationECOC" t ;; (mFile) Multiclass model for support vector machines (SVMs) and other classifiers
           "ClassificationGAM" t ;; (mFile) Generalized additive model (GAM) for binary classification
           "ClassificationKernel" t ;; (mFile) Gaussian kernel classification model using random feature expansion
           "ClassificationKNN" t ;; (mFile) k-nearest neighbor classification
           "classificationLayer" t ;; (mFile) (Not recommended) Classification output layer
           "classificationLearner" t ;; (mFile) Train models to classify data using supervised machine learning
           "ClassificationLinear" t ;; (mFile) Linear model for binary classification of high-dimensional data
           "ClassificationNaiveBayes" t ;; (mFile) Naive Bayes classification for multiclass classification
           "ClassificationNeuralNetwork" t ;; (mFile) Neural network model for classification
           "ClassificationSVM" t ;; (mFile) Support vector machine (SVM) for one-class and binary classification
           "ClassificationTree" t ;; (mFile) Binary decision tree for multiclass classification
           "classify" t ;; (mFile) Classify observations using discriminant analysis
           "classifySound" t ;; (mFile) Classify sounds in audio signal
           "classperf" t ;; (mFile) Evaluate classifier performance
           "classreg.coderutils.canBeCompacted" t ;; (function)
           "classreg.coderutils.castStructFieldsForCodegen" t ;; (function)
           "classreg.coderutils.checkstruct" t ;; (function)
           "classreg.coderutils.classregModelIsSupportedForCodegen" t ;; (function)
           "classreg.coderutils.coderSupportedClassregModels" t ;; (function)
           "classreg.coderutils.coderSupportedStatsModels" t ;; (function)
           "classreg.coderutils.coderSupportedTypes" t ;; (function)
           "classreg.coderutils.convertStructToNV" t ;; (function)
           "classreg.coderutils.handleCustomType" t ;; (function)
           "classreg.coderutils.inttype" t ;; (function)
           "classreg.coderutils.learnerSize" t ;; (function)
           "classreg.coderutils.parseArgs" t ;; (function)
           "classreg.coderutils.save" t ;; (function)
           "classreg.coderutils.structToCodegenModel" t ;; (function)
           "classreg.coderutils.structToModel" t ;; (function)
           "classreg.coderutils.validatePredictionForMissing" t ;; (function)
           "classreg.learning.classif.ClassifByBinaryRegr" t ;; (class)
           "classreg.learning.classif.ClassifByBinaryRegr.fit" t ;; (method)
           "classreg.learning.classif.ClassificationBaggedEnsemble" t ;; (class)
           "classreg.learning.classif.ClassificationEnsemble" t ;; (class)
           "classreg.learning.classif.ClassificationModel" t ;; (class)
           "classreg.learning.classif.CompactClassifByBinaryRegr" t ;; (class)
           "classreg.learning.classif.CompactClassificationDiscriminant" t ;; (class)
           "classreg.learning.classif.CompactClassificationECOC" t ;; (class)
           "classreg.learning.classif.CompactClassificationEnsemble" t ;; (class)
           "classreg.learning.classif.CompactClassificationGAM" t ;; (class)
           "classreg.learning.classif.CompactClassificationNaiveBayes" t ;; (class)
           "classreg.learning.classif.CompactClassificationNeuralNetwork" t ;; (class)
           "classreg.learning.classif.CompactClassificationSVM" t ;; (class)
           "classreg.learning.classif.CompactClassificationTree" t ;; (class)
           "classreg.learning.classif.FullClassificationModel" t ;; (class)
           "classreg.learning.classif.FullClassificationModel.fit" t ;; (method)
           "classreg.learning.classificationModels" t ;; (function)
           "classreg.learning.classProbFromCost" t ;; (function)
           "classreg.learning.coder.classif.ClassificationKernel" t ;; (class)
           "classreg.learning.coder.classif.ClassificationKernel.checkClassificationDependencyConstraints" t ;; (method)
           "classreg.learning.coder.classif.ClassificationKernel.fromStruct" t ;; (method)
           "classreg.learning.coder.classif.ClassificationKernel.validateClassificationParams" t ;; (method)
           "classreg.learning.coder.classif.ClassificationKNN" t ;; (class)
           "classreg.learning.coder.classif.ClassificationKNN.checkClassificationDependencyConstraints" t ;; (method)
           "classreg.learning.coder.classif.ClassificationKNN.fromStruct" t ;; (method)
           "classreg.learning.coder.classif.ClassificationKNN.validateClassificationParams" t ;; (method)
           "classreg.learning.coder.classif.ClassificationLinear" t ;; (class)
           "classreg.learning.coder.classif.ClassificationLinear.checkClassificationDependencyConstraints" t ;; (method)
           "classreg.learning.coder.classif.ClassificationLinear.fromStruct" t ;; (method)
           "classreg.learning.coder.classif.ClassificationLinear.validateClassificationParams" t ;; (method)
           "classreg.learning.coder.classif.CompactClassificationDiscriminant" t ;; (class)
           "classreg.learning.coder.classif.CompactClassificationDiscriminant.checkClassificationDependencyConstraints" t ;; (method)
           "classreg.learning.coder.classif.CompactClassificationDiscriminant.fromStruct" t ;; (method)
           "classreg.learning.coder.classif.CompactClassificationDiscriminant.validateClassificationParams" t ;; (method)
           "classreg.learning.coder.classif.CompactClassificationECOC" t ;; (class)
           "classreg.learning.coder.classif.CompactClassificationECOC.checkClassificationDependencyConstraints" t ;; (method)
           "classreg.learning.coder.classif.CompactClassificationECOC.fromStruct" t ;; (method)
           "classreg.learning.coder.classif.CompactClassificationECOC.validateClassificationParams" t ;; (method)
           "classreg.learning.coder.classif.CompactClassificationEnsemble" t ;; (class)
           "classreg.learning.coder.classif.CompactClassificationEnsemble.checkClassificationDependencyConstraints" t ;; (method)
           "classreg.learning.coder.classif.CompactClassificationEnsemble.fromStruct" t ;; (method)
           "classreg.learning.coder.classif.CompactClassificationEnsemble.fromStructUsingTypes" t ;; (method)
           "classreg.learning.coder.classif.CompactClassificationEnsemble.validateClassificationParams" t ;; (method)
           "classreg.learning.coder.classif.CompactClassificationModel" t ;; (class)
           "classreg.learning.coder.classif.CompactClassificationModel.checkClassificationDependencyConstraints" t ;; (method)
           "classreg.learning.coder.classif.CompactClassificationModel.validateClassificationParams" t ;; (method)
           "classreg.learning.coder.classif.CompactClassificationNaiveBayes" t ;; (class)
           "classreg.learning.coder.classif.CompactClassificationNaiveBayes.checkClassificationDependencyConstraints" t ;; (method)
           "classreg.learning.coder.classif.CompactClassificationNaiveBayes.fromStruct" t ;; (method)
           "classreg.learning.coder.classif.CompactClassificationNaiveBayes.validateClassificationParams" t ;; (method)
           "classreg.learning.coder.classif.CompactClassificationNeuralNetwork" t ;; (class)
           "classreg.learning.coder.classif.CompactClassificationNeuralNetwork.activate" t ;; (method)
           "classreg.learning.coder.classif.CompactClassificationNeuralNetwork.checkClassificationDependencyConstraints" t ;; (method)
           "classreg.learning.coder.classif.CompactClassificationNeuralNetwork.fromStruct" t ;; (method)
           "classreg.learning.coder.classif.CompactClassificationNeuralNetwork.localcellfun" t ;; (method)
           "classreg.learning.coder.classif.CompactClassificationNeuralNetwork.parseObservationsIn" t ;; (method)
           "classreg.learning.coder.classif.CompactClassificationNeuralNetwork.standardize" t ;; (method)
           "classreg.learning.coder.classif.CompactClassificationNeuralNetwork.validateClassificationParams" t ;; (method)
           "classreg.learning.coder.classif.CompactClassificationSVM" t ;; (class)
           "classreg.learning.coder.classif.CompactClassificationSVM.checkClassificationDependencyConstraints" t ;; (method)
           "classreg.learning.coder.classif.CompactClassificationSVM.fromStruct" t ;; (method)
           "classreg.learning.coder.classif.CompactClassificationSVM.fromStructUsingTypes" t ;; (method)
           "classreg.learning.coder.classif.CompactClassificationSVM.validateClassificationParams" t ;; (method)
           "classreg.learning.coder.classif.CompactClassificationTree" t ;; (class)
           "classreg.learning.coder.classif.CompactClassificationTree.checkClassificationDependencyConstraints" t ;; (method)
           "classreg.learning.coder.classif.CompactClassificationTree.fromStruct" t ;; (method)
           "classreg.learning.coder.classif.CompactClassificationTree.fromStructUsingTypes" t ;; (method)
           "classreg.learning.coder.classif.CompactClassificationTree.validateClassificationParams" t ;; (method)
           "classreg.learning.coder.CompactPredictor" t ;; (class)
           "classreg.learning.coder.config.BinaryLearnerInput" t ;; (class)
           "classreg.learning.coder.config.checkDataSummary" t ;; (function)
           "classreg.learning.coder.config.ClassificationECOCCoderConfigurer" t ;; (class)
           "classreg.learning.coder.config.EnumeratedInput" t ;; (class)
           "classreg.learning.coder.config.getCoderType" t ;; (function)
           "classreg.learning.coder.config.LearnerCoderConfigurer" t ;; (class)
           "classreg.learning.coder.config.LearnerCoderInput" t ;; (class)
           "classreg.learning.coder.config.linear.ClassificationLinearCoderConfigurer" t ;; (class)
           "classreg.learning.coder.config.linear.RegressionLinearCoderConfigurer" t ;; (class)
           "classreg.learning.coder.config.svm.ClassificationSVMCoderConfigurer" t ;; (class)
           "classreg.learning.coder.config.svm.RegressionSVMCoderConfigurer" t ;; (class)
           "classreg.learning.coder.config.tree.ClassificationTreeCoderConfigurer" t ;; (class)
           "classreg.learning.coder.config.tree.RegressionTreeCoderConfigurer" t ;; (class)
           "classreg.learning.coder.config.validator.ClassificationCoderValidator" t ;; (class)
           "classreg.learning.coder.config.validator.LinearCoderValidator" t ;; (class)
           "classreg.learning.coder.config.validator.SVMCoderValidator" t ;; (class)
           "classreg.learning.coder.config.validator.TreeCoderValidator" t ;; (class)
           "classreg.learning.coder.config.validator.Validator" t ;; (class)
           "classreg.learning.coder.discrutils.CholeskyDiscriminant" t ;; (function)
           "classreg.learning.coder.discrutils.DiagonalDiscriminant" t ;; (function)
           "classreg.learning.coder.discrutils.rdivideFinite" t ;; (function)
           "classreg.learning.coder.discrutils.RegularizedDiscriminant" t ;; (function)
           "classreg.learning.coder.ensembleutils.aggregatePredict" t ;; (function)
           "classreg.learning.coder.ensembleutils.predictOneWithCache" t ;; (function)
           "classreg.learning.coder.ensembleutils.updateCache" t ;; (function)
           "classreg.learning.coder.gputils.calcDistance" t ;; (function)
           "classreg.learning.coder.gputils.CustomKernel" t ;; (function)
           "classreg.learning.coder.gputils.exponentialARDKfun" t ;; (function)
           "classreg.learning.coder.gputils.exponentialKfun" t ;; (function)
           "classreg.learning.coder.gputils.matern32ARDKfun" t ;; (function)
           "classreg.learning.coder.gputils.matern32Kfun" t ;; (function)
           "classreg.learning.coder.gputils.matern52ARDKfun" t ;; (function)
           "classreg.learning.coder.gputils.matern52Kfun" t ;; (function)
           "classreg.learning.coder.gputils.rationalQuadraticARDKfun" t ;; (function)
           "classreg.learning.coder.gputils.rationalQuadraticKfun" t ;; (function)
           "classreg.learning.coder.gputils.squaredExponentialARDKfun" t ;; (function)
           "classreg.learning.coder.gputils.squaredExponentialKfun" t ;; (function)
           "classreg.learning.coder.kernel.fxpt.expFxpNegInputsLinearInterp" t ;; (function)
           "classreg.learning.coder.kernel.fxpt.Gaussian" t ;; (function)
           "classreg.learning.coder.kernel.fxpt.Linear" t ;; (function)
           "classreg.learning.coder.kernel.fxpt.Poly" t ;; (function)
           "classreg.learning.coder.kernel.Gaussian" t ;; (function)
           "classreg.learning.coder.kernel.Linear" t ;; (function)
           "classreg.learning.coder.kernel.Poly" t ;; (function)
           "classreg.learning.coder.loss.indexFind" t ;; (function)
           "classreg.learning.coder.loss.lossfun" t ;; (function)
           "classreg.learning.coder.loss.unnormalized.binodeviance" t ;; (function)
           "classreg.learning.coder.loss.unnormalized.classiferror" t ;; (function)
           "classreg.learning.coder.loss.unnormalized.epsiloninsensitive" t ;; (function)
           "classreg.learning.coder.loss.unnormalized.exponential" t ;; (function)
           "classreg.learning.coder.loss.unnormalized.hinge" t ;; (function)
           "classreg.learning.coder.loss.unnormalized.logit" t ;; (function)
           "classreg.learning.coder.loss.unnormalized.mse" t ;; (function)
           "classreg.learning.coder.loss.unnormalized.quadratic" t ;; (function)
           "classreg.learning.coder.model.CompactEnsemble" t ;; (class)
           "classreg.learning.coder.model.CompactNeuralNetwork" t ;; (class)
           "classreg.learning.coder.model.CompactNeuralNetwork.activate" t ;; (method)
           "classreg.learning.coder.model.CompactNeuralNetwork.fromStruct" t ;; (method)
           "classreg.learning.coder.model.CompactNeuralNetwork.localcellfun" t ;; (method)
           "classreg.learning.coder.model.CompactNeuralNetwork.matlabCodegenNontunableProperties" t ;; (method)
           "classreg.learning.coder.model.CompactNeuralNetwork.standardize" t ;; (method)
           "classreg.learning.coder.model.CompactSVM" t ;; (class)
           "classreg.learning.coder.model.CompactTree" t ;; (class)
           "classreg.learning.coder.model.Kernel" t ;; (class)
           "classreg.learning.coder.model.Linear" t ;; (class)
           "classreg.learning.coder.regr.CompactRegressionEnsemble" t ;; (class)
           "classreg.learning.coder.regr.CompactRegressionEnsemble.fromStruct" t ;; (method)
           "classreg.learning.coder.regr.CompactRegressionEnsemble.fromStructUsingTypes" t ;; (method)
           "classreg.learning.coder.regr.CompactRegressionGP" t ;; (class)
           "classreg.learning.coder.regr.CompactRegressionGP.fromStruct" t ;; (method)
           "classreg.learning.coder.regr.CompactRegressionModel" t ;; (class)
           "classreg.learning.coder.regr.CompactRegressionNeuralNetwork" t ;; (class)
           "classreg.learning.coder.regr.CompactRegressionNeuralNetwork.activate" t ;; (method)
           "classreg.learning.coder.regr.CompactRegressionNeuralNetwork.fromStruct" t ;; (method)
           "classreg.learning.coder.regr.CompactRegressionNeuralNetwork.localcellfun" t ;; (method)
           "classreg.learning.coder.regr.CompactRegressionNeuralNetwork.parsePredictArgs" t ;; (method)
           "classreg.learning.coder.regr.CompactRegressionNeuralNetwork.standardize" t ;; (method)
           "classreg.learning.coder.regr.CompactRegressionSVM" t ;; (class)
           "classreg.learning.coder.regr.CompactRegressionSVM.fromStruct" t ;; (method)
           "classreg.learning.coder.regr.CompactRegressionSVM.fromStructUsingTypes" t ;; (method)
           "classreg.learning.coder.regr.CompactRegressionTree" t ;; (class)
           "classreg.learning.coder.regr.CompactRegressionTree.fromStruct" t ;; (method)
           "classreg.learning.coder.regr.CompactRegressionTree.fromStructUsingTypes" t ;; (method)
           "classreg.learning.coder.regr.RegressionKernel" t ;; (class)
           "classreg.learning.coder.regr.RegressionKernel.fromStruct" t ;; (method)
           "classreg.learning.coder.regr.RegressionLinear" t ;; (class)
           "classreg.learning.coder.regr.RegressionLinear.fromStruct" t ;; (method)
           "classreg.learning.coder.rkeutils.batch.fastfood" t ;; (function)
           "classreg.learning.coder.rkeutils.batch.kitchensinks" t ;; (function)
           "classreg.learning.coder.rkeutils.batch.map" t ;; (function)
           "classreg.learning.coder.rkeutils.helper.fwh" t ;; (function)
           "classreg.learning.coder.rkeutils.helper.fwhcore" t ;; (function)
           "classreg.learning.coder.rkeutils.helper.fwhspecialized" t ;; (function)
           "classreg.learning.coder.rkeutils.iter.fastfood" t ;; (function)
           "classreg.learning.coder.rkeutils.iter.kitchensinks" t ;; (function)
           "classreg.learning.coder.rkeutils.iter.map" t ;; (function)
           "classreg.learning.coder.svmtransform.constant" t ;; (function)
           "classreg.learning.coder.svmtransform.fxpt.constant" t ;; (function)
           "classreg.learning.coder.svmtransform.fxpt.sigmoid" t ;; (function)
           "classreg.learning.coder.svmtransform.fxpt.step" t ;; (function)
           "classreg.learning.coder.svmtransform.sigmoid" t ;; (function)
           "classreg.learning.coder.svmtransform.step" t ;; (function)
           "classreg.learning.coder.transform.doublelogit" t ;; (function)
           "classreg.learning.coder.transform.fxpt.doublelogit" t ;; (function)
           "classreg.learning.coder.transform.fxpt.ismax" t ;; (function)
           "classreg.learning.coder.transform.fxpt.logit" t ;; (function)
           "classreg.learning.coder.transform.fxpt.sign" t ;; (function)
           "classreg.learning.coder.transform.fxpt.symmetric" t ;; (function)
           "classreg.learning.coder.transform.fxpt.symmetricismax" t ;; (function)
           "classreg.learning.coder.transform.fxpt.symmetriclogit" t ;; (function)
           "classreg.learning.coder.transform.identity" t ;; (function)
           "classreg.learning.coder.transform.invlogit" t ;; (function)
           "classreg.learning.coder.transform.ismax" t ;; (function)
           "classreg.learning.coder.transform.logit" t ;; (function)
           "classreg.learning.coder.transform.sign" t ;; (function)
           "classreg.learning.coder.transform.symmetric" t ;; (function)
           "classreg.learning.coder.transform.symmetricismax" t ;; (function)
           "classreg.learning.coder.transform.symmetriclogit" t ;; (function)
           "classreg.learning.coder.treeutils.findNode" t ;; (function)
           "classreg.learning.coderutils.checkClassificationDependencyConstraints" t ;; (function)
           "classreg.learning.coderutils.checkSupportedNumeric" t ;; (function)
           "classreg.learning.coderutils.classificationParamValues" t ;; (function)
           "classreg.learning.coderutils.classifToStruct" t ;; (function)
           "classreg.learning.coderutils.coderStructToKernelParams" t ;; (function)
           "classreg.learning.coderutils.coderStructToLinearParams" t ;; (function)
           "classreg.learning.coderutils.cutCategories2cutCategoryLevels" t ;; (function)
           "classreg.learning.coderutils.ecoc.learnerPredict" t ;; (function)
           "classreg.learning.coderutils.ecoc.loopBodyPredict" t ;; (function)
           "classreg.learning.coderutils.ecoc.loss" t ;; (function)
           "classreg.learning.coderutils.ecoc.parseECOCInputs" t ;; (function)
           "classreg.learning.coderutils.ecoc.prepareForPredict" t ;; (function)
           "classreg.learning.coderutils.ecoc.validateBinaryLearners" t ;; (function)
           "classreg.learning.coderutils.ecoc.validateECOCParamStruct" t ;; (function)
           "classreg.learning.coderutils.ecoc.validateInputLearners" t ;; (function)
           "classreg.learning.coderutils.expandCategorical" t ;; (function)
           "classreg.learning.coderutils.fxpt.aggregateLearnerTypes" t ;; (function)
           "classreg.learning.coderutils.fxpt.convertStructToFixedPoint" t ;; (function)
           "classreg.learning.coderutils.fxpt.isfxpt" t ;; (function)
           "classreg.learning.coderutils.fxpt.proposeEnsembleTypes" t ;; (function)
           "classreg.learning.coderutils.fxpt.proposeSVMTypes" t ;; (function)
           "classreg.learning.coderutils.fxpt.proposeTreeTypes" t ;; (function)
           "classreg.learning.coderutils.fxpt.proposeType" t ;; (function)
           "classreg.learning.coderutils.fxpt.proposeTypes" t ;; (function)
           "classreg.learning.coderutils.fxpt.validateDataTypeStruct" t ;; (function)
           "classreg.learning.coderutils.fxpt.writeDataTypeStructToFile" t ;; (function)
           "classreg.learning.coderutils.getPredictorSize" t ;; (function)
           "classreg.learning.coderutils.iscellarray" t ;; (function)
           "classreg.learning.coderutils.kernelParamsToCoderStruct" t ;; (function)
           "classreg.learning.coderutils.linear.handleModelTrainedWithTall" t ;; (function)
           "classreg.learning.coderutils.linear.parseLinearInputs" t ;; (function)
           "classreg.learning.coderutils.linear.validateLinearInput" t ;; (function)
           "classreg.learning.coderutils.linear.validateLinearParamStruct" t ;; (function)
           "classreg.learning.coderutils.linearParamsToCoderStruct" t ;; (function)
           "classreg.learning.coderutils.predictionForMissingValue" t ;; (function)
           "classreg.learning.coderutils.predictorAndRangeAreCompatible" t ;; (function)
           "classreg.learning.coderutils.regrToStruct" t ;; (function)
           "classreg.learning.coderutils.structToClassif" t ;; (function)
           "classreg.learning.coderutils.structToRegr" t ;; (function)
           "classreg.learning.coderutils.svm.KernelFunction" t ;; (class)
           "classreg.learning.coderutils.svm.KernelFunction.gaussian" 'enumeration
           "classreg.learning.coderutils.svm.KernelFunction.linear" 'enumeration
           "classreg.learning.coderutils.svm.KernelFunction.polynomial" 'enumeration
           "classreg.learning.coderutils.svm.KernelFunction.rbf" 'enumeration
           "classreg.learning.coderutils.svm.parseSVMInputs" t ;; (function)
           "classreg.learning.coderutils.svm.validateSVMInput" t ;; (function)
           "classreg.learning.coderutils.svm.validateSVMParamStruct" t ;; (function)
           "classreg.learning.coderutils.table2PredictMatrix" t ;; (function)
           "classreg.learning.coderutils.Transform" t ;; (class)
           "classreg.learning.coderutils.Transform.Doublelogit" 'enumeration
           "classreg.learning.coderutils.Transform.Identity" 'enumeration
           "classreg.learning.coderutils.Transform.Invlogit" 'enumeration
           "classreg.learning.coderutils.Transform.Ismax" 'enumeration
           "classreg.learning.coderutils.Transform.Logit" 'enumeration
           "classreg.learning.coderutils.Transform.Sign" 'enumeration
           "classreg.learning.coderutils.Transform.Symmetric" 'enumeration
           "classreg.learning.coderutils.Transform.Symmetricismax" 'enumeration
           "classreg.learning.coderutils.Transform.Symmetriclogit" 'enumeration
           "classreg.learning.coderutils.transformToCoderStruct" t ;; (function)
           "classreg.learning.coderutils.tree.parseTreeInputs" t ;; (function)
           "classreg.learning.coderutils.tree.validateTreeInput" t ;; (function)
           "classreg.learning.coderutils.tree.validateTreeParamStruct" t ;; (function)
           "classreg.learning.coderutils.updatedClassificationStruct" t ;; (function)
           "classreg.learning.coderutils.validateClassificationParams" t ;; (function)
           "classreg.learning.coderutils.validateCost" t ;; (function)
           "classreg.learning.coderutils.validateModelInput" t ;; (function)
           "classreg.learning.combiner.WeightedAverage" t ;; (class)
           "classreg.learning.combiner.WeightedSum" t ;; (class)
           "classreg.learning.ConvertibleClassregNeuralNetwork" t ;; (class)
           "classreg.learning.ecocutils.loss" t ;; (function)
           "classreg.learning.ecocutils.posteriorFromRatio" t ;; (function)
           "classreg.learning.ecocutils.prepareForPredictECOC" t ;; (function)
           "classreg.learning.ensemble.BaggedEnsemble" t ;; (class)
           "classreg.learning.ensemble.CompactEnsemble" t ;; (class)
           "classreg.learning.ensemble.Ensemble" t ;; (class)
           "classreg.learning.ensembleModels" t ;; (function)
           "classreg.learning.FitTemplate" t ;; (class)
           "classreg.learning.fsutils.FeatureSelectionNCAClassificationImpl" t ;; (class)
           "classreg.learning.fsutils.FeatureSelectionNCAImpl" t ;; (class)
           "classreg.learning.fsutils.FeatureSelectionNCAModel" t ;; (class)
           "classreg.learning.fsutils.FeatureSelectionNCAParams" t ;; (class)
           "classreg.learning.fsutils.FeatureSelectionNCARegressionImpl" t ;; (class)
           "classreg.learning.fsutils.fminlbfgs" t ;; (function)
           "classreg.learning.fsutils.fminsgd" t ;; (function)
           "classreg.learning.fsutils.miXy" t ;; (function)
           "classreg.learning.fsutils.Solver" t ;; (class)
           "classreg.learning.FullClassificationRegressionModel" t ;; (class)
           "classreg.learning.FullClassificationRegressionModel.fit" t ;; (method)
           "classreg.learning.generator.BlankGenerator" t ;; (class)
           "classreg.learning.generator.Generator" t ;; (class)
           "classreg.learning.generator.MajorityUndersampler" t ;; (class)
           "classreg.learning.generator.MajorityUndersampler.processArgs" t ;; (method)
           "classreg.learning.generator.Partitioner" t ;; (class)
           "classreg.learning.generator.Partitioner.processArgs" t ;; (method)
           "classreg.learning.generator.Resampler" t ;; (class)
           "classreg.learning.generator.Resampler.processArgs" t ;; (method)
           "classreg.learning.generator.ResamplerForParFit" t ;; (class)
           "classreg.learning.generator.ResamplerForParFit.processArgs" t ;; (method)
           "classreg.learning.generator.ResamplerWithUniformUpdate" t ;; (class)
           "classreg.learning.generator.ResamplerWithUniformUpdate.processArgs" t ;; (method)
           "classreg.learning.generator.SubspaceSampler" t ;; (class)
           "classreg.learning.generator.SubspaceSampler.processArgs" t ;; (method)
           "classreg.learning.GpuSupportedEnsembleModels" t ;; (function)
           "classreg.learning.gputils.bcdGPR" t ;; (function)
           "classreg.learning.gputils.calcDistance" t ;; (function)
           "classreg.learning.gputils.calcDistanceARD" t ;; (function)
           "classreg.learning.gputils.CustomKernel" t ;; (class)
           "classreg.learning.gputils.CustomKernel.makeFromTheta" t ;; (method)
           "classreg.learning.gputils.CustomKernel.Name" 'property
           "classreg.learning.gputils.disableSigmaLowerBoundWarning" t ;; (function)
           "classreg.learning.gputils.Exponential" t ;; (class)
           "classreg.learning.gputils.Exponential.makeFromTheta" t ;; (method)
           "classreg.learning.gputils.Exponential.Name" 'property
           "classreg.learning.gputils.ExponentialARD" t ;; (class)
           "classreg.learning.gputils.ExponentialARD.makeFromTheta" t ;; (method)
           "classreg.learning.gputils.ExponentialARD.Name" 'property
           "classreg.learning.gputils.fminqn" t ;; (function)
           "classreg.learning.gputils.initialHyperparameters" t ;; (function)
           "classreg.learning.gputils.initializeGamma0" t ;; (function)
           "classreg.learning.gputils.Kernel" t ;; (class)
           "classreg.learning.gputils.Kernel.makeFromTheta" t ;; (method)
           "classreg.learning.gputils.Kernel.Name" 'property
           "classreg.learning.gputils.makeBasisFunction" t ;; (function)
           "classreg.learning.gputils.makeKernelObject" t ;; (function)
           "classreg.learning.gputils.Matern32" t ;; (class)
           "classreg.learning.gputils.Matern32.makeFromTheta" t ;; (method)
           "classreg.learning.gputils.Matern32.Name" 'property
           "classreg.learning.gputils.Matern32ARD" t ;; (class)
           "classreg.learning.gputils.Matern32ARD.makeFromTheta" t ;; (method)
           "classreg.learning.gputils.Matern32ARD.Name" 'property
           "classreg.learning.gputils.Matern52" t ;; (class)
           "classreg.learning.gputils.Matern52.makeFromTheta" t ;; (method)
           "classreg.learning.gputils.Matern52.Name" 'property
           "classreg.learning.gputils.Matern52ARD" t ;; (class)
           "classreg.learning.gputils.Matern52ARD.makeFromTheta" t ;; (method)
           "classreg.learning.gputils.Matern52ARD.Name" 'property
           "classreg.learning.gputils.optimoptionsFromStruct" t ;; (function)
           "classreg.learning.gputils.optimoptionsToStruct" t ;; (function)
           "classreg.learning.gputils.optimsetFromStruct" t ;; (function)
           "classreg.learning.gputils.optimsetToStruct" t ;; (function)
           "classreg.learning.gputils.RationalQuadratic" t ;; (class)
           "classreg.learning.gputils.RationalQuadratic.makeFromTheta" t ;; (method)
           "classreg.learning.gputils.RationalQuadratic.Name" 'property
           "classreg.learning.gputils.RationalQuadraticARD" t ;; (class)
           "classreg.learning.gputils.RationalQuadraticARD.makeFromTheta" t ;; (method)
           "classreg.learning.gputils.RationalQuadraticARD.Name" 'property
           "classreg.learning.gputils.selectActiveSet" t ;; (function)
           "classreg.learning.gputils.simulink.generateCode" t ;; (function)
           "classreg.learning.gputils.solveTrustRegionProblemExact" t ;; (function)
           "classreg.learning.gputils.SquaredExponential" t ;; (class)
           "classreg.learning.gputils.SquaredExponential.makeFromTheta" t ;; (method)
           "classreg.learning.gputils.SquaredExponential.Name" 'property
           "classreg.learning.gputils.SquaredExponentialARD" t ;; (class)
           "classreg.learning.gputils.SquaredExponentialARD.makeFromTheta" t ;; (method)
           "classreg.learning.gputils.SquaredExponentialARD.Name" 'property
           "classreg.learning.gputils.standardizeData" t ;; (function)
           "classreg.learning.gputils.statsetFromStruct" t ;; (function)
           "classreg.learning.gputils.statsetToStruct" t ;; (function)
           "classreg.learning.gputils.suppliedSigmaLBToleranceOrDefault" t ;; (function)
           "classreg.learning.impl.ChainEnsembleImpl" t ;; (class)
           "classreg.learning.impl.ChainEnsembleImpl.make" t ;; (method)
           "classreg.learning.impl.CholeskyDiscriminantCalculator" t ;; (class)
           "classreg.learning.impl.CompactEnsembleImpl" t ;; (class)
           "classreg.learning.impl.CompactGAMImpl" t ;; (class)
           "classreg.learning.impl.CompactGAMImpl.parseIncludeArgs" t ;; (method)
           "classreg.learning.impl.CompactGAMImpl.validateNumericLogicalOrCharVector" t ;; (method)
           "classreg.learning.impl.CompactGPImpl" t ;; (class)
           "classreg.learning.impl.CompactGPImpl.fromStruct" t ;; (method)
           "classreg.learning.impl.CompactSVMImpl" t ;; (class)
           "classreg.learning.impl.CompactSVMImpl.fromStruct" t ;; (method)
           "classreg.learning.impl.createDlnetworkTrainingOptions" t ;; (function)
           "classreg.learning.impl.DiagonalDiscriminantCalculator" t ;; (class)
           "classreg.learning.impl.DiscriminantCalculator" t ;; (class)
           "classreg.learning.impl.DiscriminantImpl" t ;; (class)
           "classreg.learning.impl.DiscriminantImpl.AllowedTypes" 'property
           "classreg.learning.impl.DiscriminantImpl.centerMu" t ;; (method)
           "classreg.learning.impl.DlnetworkImpl" t ;; (class)
           "classreg.learning.impl.DlnetworkImpl.make" t ;; (method)
           "classreg.learning.impl.GAMImpl" t ;; (class)
           "classreg.learning.impl.GAMImpl.binPredictorsForInteractionDetection" t ;; (method)
           "classreg.learning.impl.GAMImpl.boost1d" t ;; (method)
           "classreg.learning.impl.GAMImpl.boost2d" t ;; (method)
           "classreg.learning.impl.GAMImpl.getUserInputPairs" t ;; (method)
           "classreg.learning.impl.GAMImpl.imposeMuLimits" t ;; (method)
           "classreg.learning.impl.GAMImpl.loopOverLearners" t ;; (method)
           "classreg.learning.impl.GAMImpl.make" t ;; (method)
           "classreg.learning.impl.GAMImpl.parseIncludeArgs" t ;; (method)
           "classreg.learning.impl.GAMImpl.printEarlyTerminationMessage" t ;; (method)
           "classreg.learning.impl.GAMImpl.printHeader" t ;; (method)
           "classreg.learning.impl.GAMImpl.printNextLine" t ;; (method)
           "classreg.learning.impl.GAMImpl.processFormula" t ;; (method)
           "classreg.learning.impl.GAMImpl.separateInteractionTerms" t ;; (method)
           "classreg.learning.impl.GAMImpl.validateNumericLogicalOrCharVector" t ;; (method)
           "classreg.learning.impl.GPImpl" t ;; (class)
           "classreg.learning.impl.GPImpl.checkExplicitBasisRank" t ;; (method)
           "classreg.learning.impl.GPImpl.doLBFGS" t ;; (method)
           "classreg.learning.impl.GPImpl.fromStruct" t ;; (method)
           "classreg.learning.impl.GPImpl.make" t ;; (method)
           "classreg.learning.impl.LinearDiscriminantImpl" t ;; (class)
           "classreg.learning.impl.LinearDiscriminantImpl.AllowedTypes" 'property
           "classreg.learning.impl.LinearDiscriminantImpl.centerMu" t ;; (method)
           "classreg.learning.impl.LinearImpl" t ;; (class)
           "classreg.learning.impl.LinearImpl.fromStruct" t ;; (method)
           "classreg.learning.impl.LinearImpl.make" t ;; (method)
           "classreg.learning.impl.LinearImpl.makeNoFit" t ;; (method)
           "classreg.learning.impl.NetworkImpl" t ;; (class)
           "classreg.learning.impl.NeuralNetworkImpl" t ;; (class)
           "classreg.learning.impl.NeuralNetworkImpl.make" t ;; (method)
           "classreg.learning.impl.NeuralNetworkImpl.makePostFit" t ;; (method)
           "classreg.learning.impl.NeuralNetworkImpl.removeIrrelevantWeightsBiases" t ;; (method)
           "classreg.learning.impl.QuadraticDiscriminantImpl" t ;; (class)
           "classreg.learning.impl.QuadraticDiscriminantImpl.AllowedTypes" 'property
           "classreg.learning.impl.QuadraticDiscriminantImpl.centerMu" t ;; (method)
           "classreg.learning.impl.RegularizedDiscriminantCalculator" t ;; (class)
           "classreg.learning.impl.SVMImpl" t ;; (class)
           "classreg.learning.impl.SVMImpl.fromStruct" t ;; (method)
           "classreg.learning.impl.SVMImpl.make" t ;; (method)
           "classreg.learning.impl.TreeImpl" t ;; (class)
           "classreg.learning.impl.TreeImpl.fromStruct" t ;; (method)
           "classreg.learning.impl.TreeImpl.makeFromData" t ;; (method)
           "classreg.learning.Kernel" t ;; (class)
           "classreg.learning.Linear" t ;; (class)
           "classreg.learning.linearutils.ADMMimpl" t ;; (function)
           "classreg.learning.linearutils.fitbias" t ;; (function)
           "classreg.learning.linearutils.gpu.BarzilaiBorwein" t ;; (class)
           "classreg.learning.linearutils.gpu.BarzilaiBorwein.MaxAlpha" 'property
           "classreg.learning.linearutils.gpu.BarzilaiBorwein.MaxHistorySize" 'property
           "classreg.learning.linearutils.gpu.BarzilaiBorwein.MinAlpha" 'property
           "classreg.learning.linearutils.gpu.BaseBFGS" t ;; (class)
           "classreg.learning.linearutils.gpu.BaseBFGS.C1" 'property
           "classreg.learning.linearutils.gpu.BaseBFGS.C2" 'property
           "classreg.learning.linearutils.gpu.BFGS" t ;; (class)
           "classreg.learning.linearutils.gpu.BFGS.C1" 'property
           "classreg.learning.linearutils.gpu.BFGS.C2" 'property
           "classreg.learning.linearutils.gpu.ConvergenceHelper" t ;; (class)
           "classreg.learning.linearutils.gpu.createLoss" t ;; (function)
           "classreg.learning.linearutils.gpu.EpsilonInsensitiveLoss" t ;; (class)
           "classreg.learning.linearutils.gpu.HingeLoss" t ;; (class)
           "classreg.learning.linearutils.gpu.LBFGS" t ;; (class)
           "classreg.learning.linearutils.gpu.LBFGS.C1" 'property
           "classreg.learning.linearutils.gpu.LBFGS.C2" 'property
           "classreg.learning.linearutils.gpu.LogitLoss" t ;; (class)
           "classreg.learning.linearutils.gpu.Loss" t ;; (class)
           "classreg.learning.linearutils.gpu.objgrad" t ;; (function)
           "classreg.learning.linearutils.gpu.QuadraticLoss" t ;; (class)
           "classreg.learning.linearutils.gpu.solve" t ;; (function)
           "classreg.learning.linearutils.gpu.Solver" t ;; (class)
           "classreg.learning.linearutils.LBFGSimpl" t ;; (function)
           "classreg.learning.linearutils.linearSolverProgressFunction" t ;; (class)
           "classreg.learning.linearutils.objgrad" t ;; (function)
           "classreg.learning.linearutils.preprocessPredictorsAndResponseForRegression" t ;; (function)
           "classreg.learning.linearutils.solve" t ;; (function)
           "classreg.learning.loss.binodeviance" t ;; (function)
           "classreg.learning.loss.classifcost" t ;; (function)
           "classreg.learning.loss.classifedge" t ;; (function)
           "classreg.learning.loss.classiferror" t ;; (function)
           "classreg.learning.loss.classifmargin" t ;; (function)
           "classreg.learning.loss.crossentropy" t ;; (function)
           "classreg.learning.loss.epsiloninsensitive" t ;; (function)
           "classreg.learning.loss.exponential" t ;; (function)
           "classreg.learning.loss.hinge" t ;; (function)
           "classreg.learning.loss.logit" t ;; (function)
           "classreg.learning.loss.mincost" t ;; (function)
           "classreg.learning.loss.mse" t ;; (function)
           "classreg.learning.loss.quadratic" t ;; (function)
           "classreg.learning.loss.quantile" t ;; (function)
           "classreg.learning.loss.sumquantile" t ;; (function)
           "classreg.learning.loss.unnormalized.binodeviance" t ;; (function)
           "classreg.learning.loss.unnormalized.classifcost" t ;; (function)
           "classreg.learning.loss.unnormalized.classifedge" t ;; (function)
           "classreg.learning.loss.unnormalized.classiferror" t ;; (function)
           "classreg.learning.loss.unnormalized.epsiloninsensitive" t ;; (function)
           "classreg.learning.loss.unnormalized.exponential" t ;; (function)
           "classreg.learning.loss.unnormalized.hinge" t ;; (function)
           "classreg.learning.loss.unnormalized.logit" t ;; (function)
           "classreg.learning.loss.unnormalized.mincost" t ;; (function)
           "classreg.learning.loss.unnormalized.mse" t ;; (function)
           "classreg.learning.loss.unnormalized.quadratic" t ;; (function)
           "classreg.learning.loss.unnormalized.quantile" t ;; (function)
           "classreg.learning.modelparams.ByBinaryRegrParams" t ;; (class)
           "classreg.learning.modelparams.ChainEnsembleParams" t ;; (class)
           "classreg.learning.modelparams.DiscriminantParams" t ;; (class)
           "classreg.learning.modelparams.ECOCParams" t ;; (class)
           "classreg.learning.modelparams.EnsembleParams" t ;; (class)
           "classreg.learning.modelparams.GAMParams" t ;; (class)
           "classreg.learning.modelparams.GAMParams.isNumericRealScalarNoNaNInf" t ;; (method)
           "classreg.learning.modelparams.GPParams" t ;; (class)
           "classreg.learning.modelparams.GPParams.isNumericRealVectorNoNaNInf" t ;; (method)
           "classreg.learning.modelparams.GPParams.isTrueFalseZeroOne" t ;; (method)
           "classreg.learning.modelparams.GPParams.validateStringOrFunctionHandle" t ;; (method)
           "classreg.learning.modelparams.KernelParams" t ;; (class)
           "classreg.learning.modelparams.KNNParams" t ;; (class)
           "classreg.learning.modelparams.LinearParams" t ;; (class)
           "classreg.learning.modelparams.ModelParams" t ;; (class)
           "classreg.learning.modelparams.NaiveBayesParams" t ;; (class)
           "classreg.learning.modelparams.NeuralNetworkParams" t ;; (class)
           "classreg.learning.modelparams.QuantileLinearParams" t ;; (class)
           "classreg.learning.modelparams.QuantileNeuralNetworkParams" t ;; (class)
           "classreg.learning.modelparams.SVMParams" t ;; (class)
           "classreg.learning.modelparams.TreeParams" t ;; (class)
           "classreg.learning.modifier.AdaBoostM1" t ;; (class)
           "classreg.learning.modifier.AdaBoostM1.FitInfoDescription" 'property
           "classreg.learning.modifier.AdaBoostM2" t ;; (class)
           "classreg.learning.modifier.AdaBoostM2.FitInfoDescription" 'property
           "classreg.learning.modifier.AdaBoostMH" t ;; (class)
           "classreg.learning.modifier.AdaBoostMH.FitInfoDescription" 'property
           "classreg.learning.modifier.BlankModifier" t ;; (class)
           "classreg.learning.modifier.BlankModifier.FitInfoDescription" 'property
           "classreg.learning.modifier.BlankModifierForParFit" t ;; (class)
           "classreg.learning.modifier.BlankModifierForParFit.FitInfoDescription" 'property
           "classreg.learning.modifier.GentleBoost" t ;; (class)
           "classreg.learning.modifier.GentleBoost.FitInfoDescription" 'property
           "classreg.learning.modifier.LogitBoost" t ;; (class)
           "classreg.learning.modifier.LogitBoost.FitInfoDescription" 'property
           "classreg.learning.modifier.LPBoost" t ;; (class)
           "classreg.learning.modifier.LPBoost.FitInfoDescription" 'property
           "classreg.learning.modifier.LSBoost" t ;; (class)
           "classreg.learning.modifier.LSBoost.FitInfoDescription" 'property
           "classreg.learning.modifier.Modifier" t ;; (class)
           "classreg.learning.modifier.Modifier.FitInfoDescription" 'property
           "classreg.learning.modifier.RobustBoost" t ;; (class)
           "classreg.learning.modifier.RobustBoost.FitInfoDescription" 'property
           "classreg.learning.modifier.RUSBoost" t ;; (class)
           "classreg.learning.modifier.RUSBoost.FitInfoDescription" 'property
           "classreg.learning.modifier.TotalBoost" t ;; (class)
           "classreg.learning.modifier.TotalBoost.FitInfoDescription" 'property
           "classreg.learning.nbutils.checkMNData" t ;; (function)
           "classreg.learning.nbutils.findCategoricalLevels" t ;; (function)
           "classreg.learning.nbutils.logScore" t ;; (function)
           "classreg.learning.nbutils.univariateLogP" t ;; (function)
           "classreg.learning.omputils.checkInputsSaturatedGroupedOMP" t ;; (function)
           "classreg.learning.omputils.leastSquaresOMP" t ;; (function)
           "classreg.learning.omputils.leastSquaresSaturatedGroupedOMP" t ;; (function)
           "classreg.learning.omputils.logisticSaturatedGroupedOMP" t ;; (function)
           "classreg.learning.omputils.solveSaturatedGroupedOMP" t ;; (function)
           "classreg.learning.paramoptim.adjustConstantFitFunctionArgs" t ;; (function)
           "classreg.learning.paramoptim.AggregateBayesianOptimization" t ;; (class)
           "classreg.learning.paramoptim.anyArgPassed" t ;; (function)
           "classreg.learning.paramoptim.BayesoptInfo" t ;; (class)
           "classreg.learning.paramoptim.BayesoptInfo.argsFromTable" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfo.enableOptimization" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfo.hasVariables" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfo.makeBayesoptInfo" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfo.setModelParamsProperty" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCDiscr" t ;; (class)
           "classreg.learning.paramoptim.BayesoptInfoCDiscr.argsFromTable" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCDiscr.enableOptimization" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCDiscr.hasVariables" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCDiscr.makeBayesoptInfo" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCDiscr.setModelParamsProperty" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCECOC" t ;; (class)
           "classreg.learning.paramoptim.BayesoptInfoCECOC.argsFromTable" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCECOC.ECOCVariableDescriptions" 'property
           "classreg.learning.paramoptim.BayesoptInfoCECOC.enableOptimization" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCECOC.hasVariables" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCECOC.makeBayesoptInfo" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCECOC.setModelParamsProperty" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCEnsemble" t ;; (class)
           "classreg.learning.paramoptim.BayesoptInfoCEnsemble.argsFromTable" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCEnsemble.enableOptimization" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCEnsemble.hasVariables" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCEnsemble.makeBayesoptInfo" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCEnsemble.setModelParamsProperty" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCGAM" t ;; (class)
           "classreg.learning.paramoptim.BayesoptInfoCGAM.argsFromTable" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCGAM.checkAndUpdateVariableDescriptions" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCGAM.checkInteractionsInFunctionArgsAndFormula" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCGAM.completeOptionString" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCGAM.enableOptimization" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCGAM.gamCVF" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCGAM.getGAMVariableDescriptions" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCGAM.hasVariables" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCGAM.makeBayesoptInfo" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCGAM.setModelParamsProperty" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCKernel" t ;; (class)
           "classreg.learning.paramoptim.BayesoptInfoCKernel.argsFromTable" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCKernel.enableOptimization" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCKernel.hasVariables" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCKernel.makeBayesoptInfo" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCKernel.setModelParamsProperty" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCKNN" t ;; (class)
           "classreg.learning.paramoptim.BayesoptInfoCKNN.argsFromTable" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCKNN.enableOptimization" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCKNN.hasVariables" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCKNN.makeBayesoptInfo" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCKNN.setModelParamsProperty" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCLinear" t ;; (class)
           "classreg.learning.paramoptim.BayesoptInfoCLinear.argsFromTable" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCLinear.enableOptimization" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCLinear.hasVariables" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCLinear.makeBayesoptInfo" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCLinear.setModelParamsProperty" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCNB" t ;; (class)
           "classreg.learning.paramoptim.BayesoptInfoCNB.argsFromTable" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCNB.enableOptimization" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCNB.hasVariables" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCNB.makeBayesoptInfo" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCNB.setModelParamsProperty" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCNeuralNetwork" t ;; (class)
           "classreg.learning.paramoptim.BayesoptInfoCNeuralNetwork.argsFromTable" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCNeuralNetwork.enableOptimization" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCNeuralNetwork.hasVariables" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCNeuralNetwork.LayerSizeLimit" 'property
           "classreg.learning.paramoptim.BayesoptInfoCNeuralNetwork.makeBayesoptInfo" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCNeuralNetwork.NumOptimLayers" 'property
           "classreg.learning.paramoptim.BayesoptInfoCNeuralNetwork.NumOptimLayersLimit" 'property
           "classreg.learning.paramoptim.BayesoptInfoCNeuralNetwork.setModelParamsProperty" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCSVM" t ;; (class)
           "classreg.learning.paramoptim.BayesoptInfoCSVM.argsFromTable" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCSVM.enableOptimization" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCSVM.hasVariables" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCSVM.makeBayesoptInfo" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCSVM.setModelParamsProperty" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCTree" t ;; (class)
           "classreg.learning.paramoptim.BayesoptInfoCTree.argsFromTable" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCTree.enableOptimization" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCTree.hasVariables" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCTree.makeBayesoptInfo" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoCTree.setModelParamsProperty" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoGAM" t ;; (class)
           "classreg.learning.paramoptim.BayesoptInfoGAM.argsFromTable" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoGAM.checkAndUpdateVariableDescriptions" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoGAM.checkInteractionsInFunctionArgsAndFormula" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoGAM.completeOptionString" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoGAM.enableOptimization" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoGAM.gamCVF" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoGAM.getGAMVariableDescriptions" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoGAM.hasVariables" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoGAM.makeBayesoptInfo" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoGAM.setModelParamsProperty" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoREnsemble" t ;; (class)
           "classreg.learning.paramoptim.BayesoptInfoREnsemble.argsFromTable" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoREnsemble.enableOptimization" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoREnsemble.hasVariables" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoREnsemble.makeBayesoptInfo" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoREnsemble.REnsembleVariableDescriptions" 'property
           "classreg.learning.paramoptim.BayesoptInfoREnsemble.setModelParamsProperty" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRGAM" t ;; (class)
           "classreg.learning.paramoptim.BayesoptInfoRGAM.argsFromTable" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRGAM.checkAndUpdateVariableDescriptions" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRGAM.checkInteractionsInFunctionArgsAndFormula" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRGAM.completeOptionString" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRGAM.enableOptimization" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRGAM.gamCVF" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRGAM.getGAMVariableDescriptions" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRGAM.hasVariables" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRGAM.makeBayesoptInfo" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRGAM.setModelParamsProperty" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRGP" t ;; (class)
           "classreg.learning.paramoptim.BayesoptInfoRGP.argsFromTable" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRGP.enableOptimization" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRGP.hasVariables" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRGP.makeBayesoptInfo" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRGP.setModelParamsProperty" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRKernel" t ;; (class)
           "classreg.learning.paramoptim.BayesoptInfoRKernel.argsFromTable" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRKernel.enableOptimization" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRKernel.hasVariables" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRKernel.makeBayesoptInfo" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRKernel.setModelParamsProperty" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRLinear" t ;; (class)
           "classreg.learning.paramoptim.BayesoptInfoRLinear.argsFromTable" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRLinear.enableOptimization" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRLinear.hasVariables" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRLinear.makeBayesoptInfo" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRLinear.setModelParamsProperty" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRNeuralNetwork" t ;; (class)
           "classreg.learning.paramoptim.BayesoptInfoRNeuralNetwork.argsFromTable" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRNeuralNetwork.enableOptimization" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRNeuralNetwork.hasVariables" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRNeuralNetwork.LayerSizeLimit" 'property
           "classreg.learning.paramoptim.BayesoptInfoRNeuralNetwork.makeBayesoptInfo" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRNeuralNetwork.NumOptimLayers" 'property
           "classreg.learning.paramoptim.BayesoptInfoRNeuralNetwork.NumOptimLayersLimit" 'property
           "classreg.learning.paramoptim.BayesoptInfoRNeuralNetwork.setModelParamsProperty" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRQuantileLinear" t ;; (class)
           "classreg.learning.paramoptim.BayesoptInfoRQuantileLinear.argsFromTable" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRQuantileLinear.enableOptimization" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRQuantileLinear.hasVariables" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRQuantileLinear.makeBayesoptInfo" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRQuantileLinear.setModelParamsProperty" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRQuantileNeuralNetwork" t ;; (class)
           "classreg.learning.paramoptim.BayesoptInfoRQuantileNeuralNetwork.argsFromTable" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRQuantileNeuralNetwork.enableOptimization" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRQuantileNeuralNetwork.hasVariables" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRQuantileNeuralNetwork.LayerSizeLimit" 'property
           "classreg.learning.paramoptim.BayesoptInfoRQuantileNeuralNetwork.makeBayesoptInfo" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRQuantileNeuralNetwork.NumOptimLayers" 'property
           "classreg.learning.paramoptim.BayesoptInfoRQuantileNeuralNetwork.NumOptimLayersLimit" 'property
           "classreg.learning.paramoptim.BayesoptInfoRQuantileNeuralNetwork.setModelParamsProperty" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRSVM" t ;; (class)
           "classreg.learning.paramoptim.BayesoptInfoRSVM.argsFromTable" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRSVM.enableOptimization" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRSVM.hasVariables" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRSVM.makeBayesoptInfo" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRSVM.setModelParamsProperty" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRTree" t ;; (class)
           "classreg.learning.paramoptim.BayesoptInfoRTree.argsFromTable" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRTree.enableOptimization" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRTree.hasVariables" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRTree.makeBayesoptInfo" t ;; (method)
           "classreg.learning.paramoptim.BayesoptInfoRTree.setModelParamsProperty" t ;; (method)
           "classreg.learning.paramoptim.BayesOptPrintGAM" t ;; (class)
           "classreg.learning.paramoptim.BayesOptPrintNeuralNetwork" t ;; (class)
           "classreg.learning.paramoptim.createObjFcn" t ;; (function)
           "classreg.learning.paramoptim.err" t ;; (function)
           "classreg.learning.paramoptim.errMsg" t ;; (function)
           "classreg.learning.paramoptim.expectedNumberOfOutputs" t ;; (function)
           "classreg.learning.paramoptim.extractOptimizationResultsTable" t ;; (function)
           "classreg.learning.paramoptim.fitoptimizing" t ;; (function)
           "classreg.learning.paramoptim.fitToFullDataset" t ;; (function)
           "classreg.learning.paramoptim.HyperparameterOptimizationOptions" t ;; (class)
           "classreg.learning.paramoptim.infoString" t ;; (function)
           "classreg.learning.paramoptim.observationsInColumns" t ;; (function)
           "classreg.learning.paramoptim.parseArg" t ;; (function)
           "classreg.learning.paramoptim.parseFitoptimizingArgs" t ;; (function)
           "classreg.learning.paramoptim.parseOptimizationArgs" t ;; (function)
           "classreg.learning.paramoptim.parseWeightArg" t ;; (function)
           "classreg.learning.paramoptim.partialStringMatchLayerSize" t ;; (function)
           "classreg.learning.paramoptim.prefixMatch" t ;; (function)
           "classreg.learning.paramoptim.prepareArgValue" t ;; (function)
           "classreg.learning.paramoptim.printInfo" t ;; (function)
           "classreg.learning.paramoptim.suppressWarnings" t ;; (function)
           "classreg.learning.paramoptim.tallTable2FitMatrix" t ;; (function)
           "classreg.learning.paramoptim.warn" t ;; (function)
           "classreg.learning.partition.ClassificationPartitionedECOC" t ;; (class)
           "classreg.learning.partition.ClassificationPartitionedEnsemble" t ;; (class)
           "classreg.learning.partition.ClassificationPartitionedGAM" t ;; (class)
           "classreg.learning.partition.ClassificationPartitionedKernel" t ;; (class)
           "classreg.learning.partition.ClassificationPartitionedKernelECOC" t ;; (class)
           "classreg.learning.partition.ClassificationPartitionedLinear" t ;; (class)
           "classreg.learning.partition.ClassificationPartitionedLinearECOC" t ;; (class)
           "classreg.learning.partition.ClassificationPartitionedModel" t ;; (class)
           "classreg.learning.partition.CompactClassificationPartitionedModel" t ;; (class)
           "classreg.learning.partition.CompactPartitionedModel" t ;; (class)
           "classreg.learning.partition.CompactRegressionPartitionedModel" t ;; (class)
           "classreg.learning.partition.PartitionedECOC" t ;; (class)
           "classreg.learning.partition.PartitionedEnsemble" t ;; (class)
           "classreg.learning.partition.PartitionedGAM" t ;; (class)
           "classreg.learning.partition.PartitionedModel" t ;; (class)
           "classreg.learning.partition.regressionLossWithMissingPredictorValues" t ;; (function)
           "classreg.learning.partition.RegressionPartitionedEnsemble" t ;; (class)
           "classreg.learning.partition.RegressionPartitionedGAM" t ;; (class)
           "classreg.learning.partition.RegressionPartitionedGP" t ;; (class)
           "classreg.learning.partition.RegressionPartitionedKernel" t ;; (class)
           "classreg.learning.partition.RegressionPartitionedLinear" t ;; (class)
           "classreg.learning.partition.RegressionPartitionedModel" t ;; (class)
           "classreg.learning.partition.RegressionPartitionedNeuralNetwork" t ;; (class)
           "classreg.learning.partition.RegressionPartitionedQuantileModel" t ;; (class)
           "classreg.learning.partition.RegressionPartitionedSVM" t ;; (class)
           "classreg.learning.partitionModels" t ;; (function)
           "classreg.learning.Predictor" t ;; (class)
           "classreg.learning.regr.CompactRegressionChainEnsemble" t ;; (class)
           "classreg.learning.regr.CompactRegressionEnsemble" t ;; (class)
           "classreg.learning.regr.CompactRegressionGAM" t ;; (class)
           "classreg.learning.regr.CompactRegressionGP" t ;; (class)
           "classreg.learning.regr.CompactRegressionNeuralNetwork" t ;; (class)
           "classreg.learning.regr.CompactRegressionQuantileLinear" t ;; (class)
           "classreg.learning.regr.CompactRegressionQuantileNeuralNetwork" t ;; (class)
           "classreg.learning.regr.CompactRegressionSVM" t ;; (class)
           "classreg.learning.regr.CompactRegressionTree" t ;; (class)
           "classreg.learning.regr.FullRegressionModel" t ;; (class)
           "classreg.learning.regr.FullRegressionModel.fit" t ;; (method)
           "classreg.learning.regr.QuantileRegressionModel" t ;; (class)
           "classreg.learning.regr.RegressionBaggedEnsemble" t ;; (class)
           "classreg.learning.regr.RegressionEnsemble" t ;; (class)
           "classreg.learning.regr.RegressionModel" t ;; (class)
           "classreg.learning.regressionModels" t ;; (function)
           "classreg.learning.rkeutils.featureMapper" t ;; (class)
           "classreg.learning.rkeutils.fwht" t ;; (function)
           "classreg.learning.simpleModels" t ;; (function)
           "classreg.learning.svmutils.optimalKernelScale" t ;; (function)
           "classreg.learning.svmutils.predict" t ;; (function)
           "classreg.learning.svmutils.solve" t ;; (function)
           "classreg.learning.transform.doublelogit" t ;; (function)
           "classreg.learning.transform.identity" t ;; (function)
           "classreg.learning.transform.invlogit" t ;; (function)
           "classreg.learning.transform.ismax" t ;; (function)
           "classreg.learning.transform.logit" t ;; (function)
           "classreg.learning.transform.sign" t ;; (function)
           "classreg.learning.transform.symmetric" t ;; (function)
           "classreg.learning.transform.symmetricismax" t ;; (function)
           "classreg.learning.transform.symmetriclogit" t ;; (function)
           "classreg.learning.treeutils.binPredictors" t ;; (function)
           "classreg.learning.treeutils.computePruneInfo" t ;; (function)
           "classreg.learning.treeutils.findNode" t ;; (function)
           "classreg.learning.treeutils.gpu.AdaBoostM1" t ;; (class)
           "classreg.learning.treeutils.gpu.AdaBoostM2" t ;; (class)
           "classreg.learning.treeutils.gpu.binPredictors" t ;; (function)
           "classreg.learning.treeutils.gpu.findNode" t ;; (function)
           "classreg.learning.treeutils.gpu.GentleBoost" t ;; (class)
           "classreg.learning.treeutils.gpu.growEnsemble" t ;; (function)
           "classreg.learning.treeutils.gpu.growSingleTree" t ;; (function)
           "classreg.learning.treeutils.gpu.growTree" t ;; (function)
           "classreg.learning.treeutils.gpu.LogitBoost" t ;; (class)
           "classreg.learning.treeutils.gpu.LSBoost" t ;; (class)
           "classreg.learning.treeutils.gpu.Modifier" t ;; (class)
           "classreg.learning.treeutils.gpu.preprocessPredictors" t ;; (function)
           "classreg.learning.treeutils.growEnsemble" t ;; (function)
           "classreg.learning.treeutils.growTree" t ;; (function)
           "classreg.learning.treeutils.nodeVariableRangeCellToStruct" t ;; (function)
           "classreg.learning.treeutils.TreeDrawer" t ;; (class)
           "classreg.learning.treeutils.TreeDrawer.adjustmenu" t ;; (method)
           "classreg.learning.treeutils.TreeDrawer.drawtree" t ;; (method)
           "classreg.learning.treeutils.TreeDrawer.removelabels" t ;; (method)
           "classreg.learning.treeutils.TreeDrawer.setupfigure" t ;; (method)
           "classreg.learning.treeutils.TreeDrawer.updateenable" t ;; (method)
           "classreg.learning.treeutils.TreeDrawer.updatelevel" t ;; (method)
           "classreg.learning.weakLearners" t ;; (function)
           "classreg.regr.coder.CompactGeneralizedLinearModel" t ;; (class)
           "classreg.regr.coder.CompactGeneralizedLinearModel.fromStruct" t ;; (method)
           "classreg.regr.coder.CompactLinearModel" t ;; (class)
           "classreg.regr.coder.CompactLinearModel.fromStruct" t ;; (method)
           "classreg.regr.coder.CompactTermsRegression" t ;; (class)
           "classreg.regr.coderutils.regrToStruct" t ;; (function)
           "classreg.regr.coderutils.structToRegr" t ;; (function)
           "classreg.regr.CompactCensoredLinearModel" t ;; (class)
           "classreg.regr.CompactContinuousRegression" t ;; (class)
           "classreg.regr.CompactFitObject" t ;; (class)
           "classreg.regr.CompactGeneralizedLinearModel" t ;; (class)
           "classreg.regr.CompactLinearModel" t ;; (class)
           "classreg.regr.CompactParametricRegression" t ;; (class)
           "classreg.regr.CompactPredictor" t ;; (class)
           "classreg.regr.CompactTermsRegression" t ;; (class)
           "classreg.regr.FitObject" t ;; (class)
           "classreg.regr.FitObject.fit" t ;; (method)
           "classreg.regr.FormulaProcessor" t ;; (class)
           "classreg.regr.FormulaProcessor.isModelAlias" t ;; (method)
           "classreg.regr.FormulaProcessor.isTermsMatrix" t ;; (method)
           "classreg.regr.LinearFormula" t ;; (class)
           "classreg.regr.LinearFormula.isModelAlias" t ;; (method)
           "classreg.regr.LinearFormula.isTermsMatrix" t ;; (method)
           "classreg.regr.LinearFormulaWithNesting" t ;; (class)
           "classreg.regr.LinearFormulaWithNesting.isModelAlias" t ;; (method)
           "classreg.regr.LinearFormulaWithNesting.isTermsMatrix" t ;; (method)
           "classreg.regr.LinearLikeMixedModel" t ;; (class)
           "classreg.regr.LinearLikeMixedModel.fit" t ;; (method)
           "classreg.regr.LinearMixedFormula" t ;; (class)
           "classreg.regr.lmeutils.covmats.BlockedCovariance" t ;; (class)
           "classreg.regr.lmeutils.covmats.BlockedCovariance.createCovariance" t ;; (method)
           "classreg.regr.lmeutils.covmats.BlockedCovariance.singularLowerChol" t ;; (method)
           "classreg.regr.lmeutils.covmats.CompoundSymmetryCovariance" t ;; (class)
           "classreg.regr.lmeutils.covmats.CompoundSymmetryCovariance.createCovariance" t ;; (method)
           "classreg.regr.lmeutils.covmats.CompoundSymmetryCovariance.singularLowerChol" t ;; (method)
           "classreg.regr.lmeutils.covmats.CovarianceMatrix" t ;; (class)
           "classreg.regr.lmeutils.covmats.CovarianceMatrix.createCovariance" t ;; (method)
           "classreg.regr.lmeutils.covmats.CovarianceMatrix.singularLowerChol" t ;; (method)
           "classreg.regr.lmeutils.covmats.DiagonalCovariance" t ;; (class)
           "classreg.regr.lmeutils.covmats.DiagonalCovariance.createCovariance" t ;; (method)
           "classreg.regr.lmeutils.covmats.DiagonalCovariance.singularLowerChol" t ;; (method)
           "classreg.regr.lmeutils.covmats.FixedWeightsCovariance" t ;; (class)
           "classreg.regr.lmeutils.covmats.FixedWeightsCovariance.createCovariance" t ;; (method)
           "classreg.regr.lmeutils.covmats.FixedWeightsCovariance.singularLowerChol" t ;; (method)
           "classreg.regr.lmeutils.covmats.FullCholeskyCovariance" t ;; (class)
           "classreg.regr.lmeutils.covmats.FullCholeskyCovariance.createCovariance" t ;; (method)
           "classreg.regr.lmeutils.covmats.FullCholeskyCovariance.singularLowerChol" t ;; (method)
           "classreg.regr.lmeutils.covmats.FullCovariance" t ;; (class)
           "classreg.regr.lmeutils.covmats.FullCovariance.createCovariance" t ;; (method)
           "classreg.regr.lmeutils.covmats.FullCovariance.singularLowerChol" t ;; (method)
           "classreg.regr.lmeutils.covmats.IsotropicCovariance" t ;; (class)
           "classreg.regr.lmeutils.covmats.IsotropicCovariance.createCovariance" t ;; (method)
           "classreg.regr.lmeutils.covmats.IsotropicCovariance.singularLowerChol" t ;; (method)
           "classreg.regr.lmeutils.covmats.PatternedCovariance" t ;; (class)
           "classreg.regr.lmeutils.covmats.PatternedCovariance.createCovariance" t ;; (method)
           "classreg.regr.lmeutils.covmats.PatternedCovariance.singularLowerChol" t ;; (method)
           "classreg.regr.lmeutils.datasetcopier" t ;; (function)
           "classreg.regr.lmeutils.StandardGeneralizedLinearMixedModel" t ;; (class)
           "classreg.regr.lmeutils.StandardGeneralizedLinearMixedModel.assertThat" t ;; (method)
           "classreg.regr.lmeutils.StandardGeneralizedLinearMixedModel.checkPositiveDefinite" t ;; (method)
           "classreg.regr.lmeutils.StandardGeneralizedLinearMixedModel.computeNewtonStepForB" t ;; (method)
           "classreg.regr.lmeutils.StandardGeneralizedLinearMixedModel.computeNewtonStepForBetaB" t ;; (method)
           "classreg.regr.lmeutils.StandardGeneralizedLinearMixedModel.constrainVector" t ;; (method)
           "classreg.regr.lmeutils.StandardGeneralizedLinearMixedModel.convertOptionsToFSolveOptions" t ;; (method)
           "classreg.regr.lmeutils.StandardGeneralizedLinearMixedModel.covarianceOnNaturalScale" t ;; (method)
           "classreg.regr.lmeutils.StandardGeneralizedLinearMixedModel.fullrankH" t ;; (method)
           "classreg.regr.lmeutils.StandardGeneralizedLinearMixedModel.getGradient" t ;; (method)
           "classreg.regr.lmeutils.StandardGeneralizedLinearMixedModel.getHessian" t ;; (method)
           "classreg.regr.lmeutils.StandardGeneralizedLinearMixedModel.getHessian2" t ;; (method)
           "classreg.regr.lmeutils.StandardGeneralizedLinearMixedModel.hasNaNInf" t ;; (method)
           "classreg.regr.lmeutils.StandardGeneralizedLinearMixedModel.logAbsDetTriangular" t ;; (method)
           "classreg.regr.lmeutils.StandardGeneralizedLinearMixedModel.mymvnrnd" t ;; (method)
           "classreg.regr.lmeutils.StandardGeneralizedLinearMixedModel.solveUsingQR" t ;; (method)
           "classreg.regr.lmeutils.StandardLinearLikeMixedModel" t ;; (class)
           "classreg.regr.lmeutils.StandardLinearLikeMixedModel.assertThat" t ;; (method)
           "classreg.regr.lmeutils.StandardLinearLikeMixedModel.checkPositiveDefinite" t ;; (method)
           "classreg.regr.lmeutils.StandardLinearLikeMixedModel.constrainVector" t ;; (method)
           "classreg.regr.lmeutils.StandardLinearLikeMixedModel.covarianceOnNaturalScale" t ;; (method)
           "classreg.regr.lmeutils.StandardLinearLikeMixedModel.fullrankH" t ;; (method)
           "classreg.regr.lmeutils.StandardLinearLikeMixedModel.getGradient" t ;; (method)
           "classreg.regr.lmeutils.StandardLinearLikeMixedModel.getHessian" t ;; (method)
           "classreg.regr.lmeutils.StandardLinearLikeMixedModel.getHessian2" t ;; (method)
           "classreg.regr.lmeutils.StandardLinearLikeMixedModel.hasNaNInf" t ;; (method)
           "classreg.regr.lmeutils.StandardLinearLikeMixedModel.logAbsDetTriangular" t ;; (method)
           "classreg.regr.lmeutils.StandardLinearLikeMixedModel.mymvnrnd" t ;; (method)
           "classreg.regr.lmeutils.StandardLinearLikeMixedModel.solveUsingQR" t ;; (method)
           "classreg.regr.lmeutils.StandardLinearMixedModel" t ;; (class)
           "classreg.regr.lmeutils.StandardLinearMixedModel.assertThat" t ;; (method)
           "classreg.regr.lmeutils.StandardLinearMixedModel.checkPositiveDefinite" t ;; (method)
           "classreg.regr.lmeutils.StandardLinearMixedModel.constrainVector" t ;; (method)
           "classreg.regr.lmeutils.StandardLinearMixedModel.covarianceOnNaturalScale" t ;; (method)
           "classreg.regr.lmeutils.StandardLinearMixedModel.fullrankH" t ;; (method)
           "classreg.regr.lmeutils.StandardLinearMixedModel.getGradient" t ;; (method)
           "classreg.regr.lmeutils.StandardLinearMixedModel.getHessian" t ;; (method)
           "classreg.regr.lmeutils.StandardLinearMixedModel.getHessian2" t ;; (method)
           "classreg.regr.lmeutils.StandardLinearMixedModel.hasNaNInf" t ;; (method)
           "classreg.regr.lmeutils.StandardLinearMixedModel.logAbsDetTriangular" t ;; (method)
           "classreg.regr.lmeutils.StandardLinearMixedModel.mymvnrnd" t ;; (method)
           "classreg.regr.lmeutils.StandardLinearMixedModel.solveUsingQR" t ;; (method)
           "classreg.regr.lmeutils.titleddataset" t ;; (class)
           "classreg.regr.lmeutils.titleddataset.empty" t ;; (method)
           "classreg.regr.modelutils.designmatrix" t ;; (function)
           "classreg.regr.modelutils.getAFcnGLMDerivatives" t ;; (function)
           "classreg.regr.modelutils.getDataRangesForPredictorData" t ;; (function)
           "classreg.regr.modelutils.handleLMDataArgs" t ;; (function)
           "classreg.regr.modelutils.ishierarchical" t ;; (function)
           "classreg.regr.modelutils.linearModelPredCI" t ;; (function)
           "classreg.regr.modelutils.model2terms" t ;; (function)
           "classreg.regr.modelutils.modelcriterion" t ;; (function)
           "classreg.regr.modelutils.parseAxesAndOptionalArg" t ;; (function)
           "classreg.regr.modelutils.parseFigureAndModel" t ;; (function)
           "classreg.regr.modelutils.parseParentAxesNVArg" t ;; (function)
           "classreg.regr.modelutils.plotDiagnostics" t ;; (function)
           "classreg.regr.modelutils.plotProfileLikelihood" t ;; (function)
           "classreg.regr.modelutils.plotResiduals" t ;; (function)
           "classreg.regr.modelutils.plotSlice" t ;; (function)
           "classreg.regr.modelutils.predictormatrix" t ;; (function)
           "classreg.regr.modelutils.profileLikelihood" t ;; (function)
           "classreg.regr.modelutils.rsquared" t ;; (function)
           "classreg.regr.modelutils.terms2names" t ;; (function)
           "classreg.regr.modelutils.tstats" t ;; (function)
           "classreg.regr.modelutils.validateLikelihoodPenalty" t ;; (function)
           "classreg.regr.MultivariateLinearFormula" t ;; (class)
           "classreg.regr.MultivariateLinearFormula.isModelAlias" t ;; (method)
           "classreg.regr.MultivariateLinearFormula.isTermsMatrix" t ;; (method)
           "classreg.regr.NonLinearFormula" t ;; (class)
           "classreg.regr.NonLinearFormula.isOpaqueFun" t ;; (method)
           "classreg.regr.ParametricRegression" t ;; (class)
           "classreg.regr.ParametricRegression.fit" t ;; (method)
           "classreg.regr.Predictor" t ;; (class)
           "classreg.regr.Predictor.fit" t ;; (method)
           "classreg.regr.TermsRegression" t ;; (class)
           "classreg.regr.TermsRegression.fit" t ;; (method)
           "classregblks.callbacks.refreshLearnerInfo" t ;; (function)
           "classregblks.callbacks.scoreVisibility" t ;; (function)
           "classregblks.discr.callbackCostVisibility" t ;; (function)
           "classregblks.discr.maskInitialization" t ;; (function)
           "classregblks.discr.utilLoadLearnerParameters" t ;; (function)
           "classregblks.discr.utilMaskVisibilities" t ;; (function)
           "classregblks.discr.utilRefreshLearnerInfo" t ;; (function)
           "classregblks.discr.utilSyncDataType" t ;; (function)
           "classregblks.discr.utilUpdateIOPorts" t ;; (function)
           "classregblks.discr.utilUpdateVariants" t ;; (function)
           "classregblks.ecoc.callbackPBScoreVisibility" t ;; (function)
           "classregblks.ecoc.callbackScoreVisibility" t ;; (function)
           "classregblks.ecoc.maskInitialization" t ;; (function)
           "classregblks.ecoc.utilLoadLearnerParameters" t ;; (function)
           "classregblks.ecoc.utilMaskVisibilities" t ;; (function)
           "classregblks.ecoc.utilRefreshLearnerInfo" t ;; (function)
           "classregblks.ecoc.utilSyncDataType" t ;; (function)
           "classregblks.ecoc.utilUpdateBinaryLearners" t ;; (function)
           "classregblks.ecoc.utilUpdateIOPorts" t ;; (function)
           "classregblks.ecoc.utilUpdateVariants" t ;; (function)
           "classregblks.ensemble.maskInitialization" t ;; (function)
           "classregblks.ensemble.utilLoadLearnerParameters" t ;; (function)
           "classregblks.ensemble.utilMaskVisibilities" t ;; (function)
           "classregblks.ensemble.utilRefreshLearnerInfo" t ;; (function)
           "classregblks.ensemble.utilSyncDataType" t ;; (function)
           "classregblks.ensemble.utilUpdateVariants" t ;; (function)
           "classregblks.gp.callbackMaskVisibilities" t ;; (function)
           "classregblks.gp.maskInitialization" t ;; (function)
           "classregblks.gp.utilLoadLearnerParameters" t ;; (function)
           "classregblks.gp.utilMaskVisibilities" t ;; (function)
           "classregblks.gp.utilRefreshLearnerInfo" t ;; (function)
           "classregblks.gp.utilSyncDataType" t ;; (function)
           "classregblks.gp.utilUpdateIOPorts" t ;; (function)
           "classregblks.gp.utilUpdateVariants" t ;; (function)
           "classregblks.kernel.maskInitialization" t ;; (function)
           "classregblks.kernel.utilLoadLearnerParameters" t ;; (function)
           "classregblks.kernel.utilMaskVisibilities" t ;; (function)
           "classregblks.kernel.utilRefreshLearnerInfo" t ;; (function)
           "classregblks.kernel.utilSyncDataType" t ;; (function)
           "classregblks.kernel.utilUpdateVariants" t ;; (function)
           "classregblks.knn.callbackCostVisibility" t ;; (function)
           "classregblks.knn.maskInitialization" t ;; (function)
           "classregblks.knn.utilLoadLearnerParameters" t ;; (function)
           "classregblks.knn.utilMaskVisibilities" t ;; (function)
           "classregblks.knn.utilRefreshLearnerInfo" t ;; (function)
           "classregblks.knn.utilSyncDataType" t ;; (function)
           "classregblks.knn.utilUpdateIOPorts" t ;; (function)
           "classregblks.knn.utilUpdateVariants" t ;; (function)
           "classregblks.knnsearch.callbackDistanceMetricVisibility" t ;; (function)
           "classregblks.knnsearch.callbackDistanceVisibility" t ;; (function)
           "classregblks.knnsearch.maskInitialization" t ;; (function)
           "classregblks.knnsearch.setMaskPropEnableVisible" t ;; (function)
           "classregblks.knnsearch.utilLoadLearnerParameters" t ;; (function)
           "classregblks.knnsearch.utilMaskVisibilities" t ;; (function)
           "classregblks.knnsearch.utilRefreshLearnerInfo" t ;; (function)
           "classregblks.knnsearch.utilSyncDataType" t ;; (function)
           "classregblks.knnsearch.utilUpdateIOPorts" t ;; (function)
           "classregblks.knnsearch.utilUpdateVariants" t ;; (function)
           "classregblks.linear.maskInitialization" t ;; (function)
           "classregblks.linear.utilLoadLearnerParameters" t ;; (function)
           "classregblks.linear.utilMaskVisibilities" t ;; (function)
           "classregblks.linear.utilRefreshLearnerInfo" t ;; (function)
           "classregblks.linear.utilSyncDataType" t ;; (function)
           "classregblks.linear.utilUpdateVariants" t ;; (function)
           "classregblks.nb.callbackCostVisibility" t ;; (function)
           "classregblks.nb.maskInitialization" t ;; (function)
           "classregblks.nb.utilLoadLearnerParameters" t ;; (function)
           "classregblks.nb.utilMaskVisibilities" t ;; (function)
           "classregblks.nb.utilRefreshLearnerInfo" t ;; (function)
           "classregblks.nb.utilSyncDataType" t ;; (function)
           "classregblks.nb.utilUpdateDefaultDistrMethod" t ;; (function)
           "classregblks.nb.utilUpdateDistrMethod" t ;; (function)
           "classregblks.nb.utilUpdateIOPorts" t ;; (function)
           "classregblks.nb.utilUpdateVariants" t ;; (function)
           "classregblks.nnet.callbackLayerVisibility" t ;; (function)
           "classregblks.nnet.maskInitialization" t ;; (function)
           "classregblks.nnet.utilLoadLearnerParameters" t ;; (function)
           "classregblks.nnet.utilMaskVisibilities" t ;; (function)
           "classregblks.nnet.utilRefreshLearnerInfo" t ;; (function)
           "classregblks.nnet.utilSyncDataType" t ;; (function)
           "classregblks.nnet.utilUpdateLayers" t ;; (function)
           "classregblks.nnet.utilUpdateVariants" t ;; (function)
           "classregblks.svm.maskInitialization" t ;; (function)
           "classregblks.svm.utilLoadLearnerParameters" t ;; (function)
           "classregblks.svm.utilMaskVisibilities" t ;; (function)
           "classregblks.svm.utilRefreshLearnerInfo" t ;; (function)
           "classregblks.svm.utilSyncDataType" t ;; (function)
           "classregblks.svm.utilUpdateVariants" t ;; (function)
           "classregblks.tree.maskInitialization" t ;; (function)
           "classregblks.tree.utilLoadLearnerParameters" t ;; (function)
           "classregblks.tree.utilLoadWeakLearnerParameters" t ;; (function)
           "classregblks.tree.utilMaskVisibilities" t ;; (function)
           "classregblks.tree.utilRefreshLearnerInfo" t ;; (function)
           "classregblks.tree.utilSyncDataType" t ;; (function)
           "classregblks.tree.utilUpdateVariants" t ;; (function)
           "classregblks.tree.utilValidateTreeModel" t ;; (function)
           "classregblks.util.blockMaskCapabilities" t ;; (function)
           "classregblks.util.configureEnumClass" t ;; (function)
           "classregblks.util.configureLabelDataType" t ;; (function)
           "classregblks.util.getFixedPointType" t ;; (function)
           "classregblks.util.getScoreTransformInfo" t ;; (function)
           "classregblks.util.loadLookupTableParams" t ;; (function)
           "classregblks.util.maskVisibilities" t ;; (function)
           "classregblks.util.setMaskPropEnableVisible" t ;; (function)
           "classregblks.util.syncDataType" t ;; (function)
           "classregblks.util.updateIOPorts" t ;; (function)
           "classregblks.validateLearner" t ;; (function)
           "clc" t ;; (mFile) Clear Command Window
           "cleanAndOpenExample" t ;; (mFile)
           "cleanBlockNameForQuotedDisp" t ;; (pFile)
           "cleanerrormsg" t ;; (mFile)
           "cleanout_slprj_for_deployment" t ;; (pFile)
           "clear" t ;; (mFile) Remove items from workspace, freeing up system memory
           "clear_model_playbackinfo" t ;; (mFile)
           "clearAllMemoizedCaches" t ;; (mFile) Clear caches for all MemoizedFunction objects
           "clearBlockSelectionFromJs" t ;; (pFile)
           "clearHighlightState" t ;; (pFile)
           "clearInportsOfSelected" t ;; (pFile)
           "clearInputRepository" t ;; (pFile)
           "clearInstrumentationResults" t ;; (mFile) Clear results logged by instrumented, compiled C code function
           "clearpoints" t ;; (mFile) Clear points from animated line
           "clearvars" t ;; (mFile) Clear variables from memory
           "cleave" t ;; (mFile) Cleave amino acid sequence with enzyme
           "cleavelookup" t ;; (mFile) Find cleavage rule for enzyme or compound
           "clegendm" t ;; (mFile) Add legend labels to map contour display
           "clf" t ;; (mFile) Clear figure
           "clib" t ;; (mFile)
           "clibArray" t ;; (mFile) Create MATLAB clib array for C++ library functions
           "clibConfiguration" t ;; (mFile) Set run-time configuration parameters for C++ library interface
           "clibConvertArray" t ;; (mFile) Convert MATLAB fundamental or struct array to MATLAB array of C++ objects
           "clibgen.api.CallableDefinition" t ;; (class)
           "clibgen.api.ClassDefinition" t ;; (class)
           "clibgen.api.ConstructorDefinition" t ;; (class)
           "clibgen.api.EnumDefinition" t ;; (class)
           "clibgen.api.FunctionDefinition" t ;; (class)
           "clibgen.api.FunctionTypeDefinition" t ;; (class)
           "clibgen.api.InputArgumentDefinition" t ;; (class)
           "clibgen.api.InterfaceDefinition" t ;; (class)
           "clibgen.api.LibraryConfiguration" t ;; (class)
           "clibgen.api.MethodDefinition" t ;; (class)
           "clibgen.api.OpaqueTypeDefinition" t ;; (class)
           "clibgen.api.OutputArgumentDefinition" t ;; (class)
           "clibgen.api.PropertyDefinition" t ;; (class)
           "clibgen.api.UnsupportedClass" t ;; (class)
           "clibgen.api.UnsupportedEnum" t ;; (class)
           "clibgen.api.UnsupportedFunction" t ;; (class)
           "clibgen.api.UnsupportedMethod" t ;; (class)
           "clibgen.api.UnsupportedProperty" t ;; (class)
           "clibgen.api.UnsupportedSymbol" t ;; (class)
           "clibgen.buildInterface" t ;; (function)
           "clibgen.ClassDefinition" t ;; (class)
           "clibgen.ClassDefinition.isSupported" t ;; (method)
           "clibgen.ConstructorDefinition" t ;; (class)
           "clibgen.EnumDefinition" t ;; (class)
           "clibgen.FunctionDefinition" t ;; (class)
           "clibgen.FunctionTypeDefinition" t ;; (class)
           "clibgen.generateLibraryDefinition" t ;; (function)
           "clibgen.LibraryDefinition" t ;; (class)
           "clibgen.MethodDefinition" t ;; (class)
           "clibgen.OpaqueTypeDefinition" t ;; (class)
           "clibgen.PropertyDefinition" t ;; (class)
           "clibIsNull" t ;; (mFile) Determine if C++ object is null
           "clibIsReadOnly" t ;; (mFile) Determine if C++ object is read-only
           "clibPublishInterfaceWorkflow" t ;; (mFile) Publish interface for C++ library in the Live Editor
           "clibRelease" t ;; (mFile) Release C++ object from MATLAB
           "clibTestCoderService_getSymbolInfo" t ;; (mFile)
           "clibTestCoderService_resolveMethodOverload" t ;; (mFile)
           "clim" t ;; (mFile) Set colormap limits (Renamed from caxis in R2022a)
           "climateScenario" t ;; (mFile) Create climate scenario object
           "clip" t ;; (mFile) Clip data to range
           "clipboard" t ;; (mFile) Copy and paste text to and from system clipboard
           "clippedReluLayer" t ;; (mFile) Clipped Rectified Linear Unit (ReLU) layer
           "clma" t ;; (mFile) Clear current axesm-based map
           "clmo" t ;; (mFile) Clear graphics objects from axesm-based map
           "clock" t ;; (mFile) (Not recommended; use datetime) Current date and time as date vector
           "clock_times_writer" t ;; (mex)
           "clockJitterMeasure" t ;; (mFile)
           "clonedetection" t ;; (pFile) Open Clone Detector app
           "CloneDetectionApp" t ;; (pFile)
           "CloneDetector.ExclusionEditor" t ;; (class)
           "CloneDetector.ExclusionEditorUIService" t ;; (class)
           "CloneDetector.ExclusionEditorUIService.getInstance" t ;; (method)
           "CloneDetector.ExclusionEditorWindow" t ;; (class)
           "CloneDetector.Exclusions" t ;; (class)
           "CloneDetector.Exclusions.clearFilterManagerForModel" t ;; (method)
           "CloneDetector.getExclusionEditor" t ;; (function)
           "CloneDetector.MenuOptionsExclusionEditor" t ;; (class)
           "CloneDetector.Utils.DefaultFileChooser" t ;; (class)
           "CloneDetector.Utils.DefaultFileSaver" t ;; (class)
           "CloneDetector.Utils.FileChooser" t ;; (class)
           "CloneDetector.Utils.getFilterFilePath" t ;; (function)
           "cloop" t ;; (mFile)
           "close" t ;; (pFile) Close one or more figures
           "close_system" t ;; (pFile) Close Simulink model window or block dialog box
           "closeloop" t ;; (mFile) Convert neural network open-loop feedback to closed loop
           "closePolygonParts" t ;; (mFile) Close all rings in multipart polygon
           "closepreview" t ;; (mFile)
           "closereq" t ;; (mFile)
           "closeShellLibrary" t ;; (mFile)
           "closeSimulationManager" t ;; (pFile)
           "closeSlicerDDG" t ;; (pFile)
           "closest_match" t ;; (pFile)
           "clothoidLaneBoundary" t ;; (mFile) Clothoid-shaped lane boundary model
           "cloverleaf" t ;; (mFile) Create three-petal cloverleaf antenna
           "clrmenu" t ;; (mFile) (Removed) Add colormap menu to figure window
           "clrpopup" t ;; (mFile)
           "cluster" t ;; (mFile) Construct agglomerative clusters from linkages
           "clusterConnectedFaces" t ;; (mFile) Cluster connected faces
           "clusterdata" t ;; (mFile) Construct agglomerative clusters from data
           "clusterDBSCAN" t ;; (mFile) Density-based algorithm for clustering data
           "clusterDBSCAN.discoverClusters" t ;; (method)
           "clusterDBSCAN.estimateEpsilon" t ;; (method)
           "clustergram" t ;; (mFile) Object containing hierarchical clustering analysis data
           "clustering.evaluation.CalinskiHarabaszEvaluation" t ;; (class)
           "clustering.evaluation.ClusterCriterion" t ;; (class)
           "clustering.evaluation.DaviesBouldinEvaluation" t ;; (class)
           "clustering.evaluation.GapEvaluation" t ;; (class)
           "clustering.evaluation.SilhouetteEvaluation" t ;; (class)
           "clustering.ldautils.checkInputs" t ;; (function)
           "clustering.ldautils.code2str" t ;; (function)
           "clustering.ldautils.learnThetaAtFixedPhi" t ;; (function)
           "clustering.ldautils.nkj2theta" t ;; (function)
           "clustering.ldautils.nwk2phi" t ;; (function)
           "clustering.ldautils.phi2nwk" t ;; (function)
           "clustering.ldautils.prepareData" t ;; (function)
           "clustering.ldautils.sample_topics" t ;; (function)
           "clustering.ldautils.showfitinfo" t ;; (function)
           "clustering.ldautils.showseparator" t ;; (function)
           "clustering.ldautils.simplex" t ;; (function)
           "clustering.ldautils.solve_em" t ;; (function)
           "clustering.ldautils.theta2nkj" t ;; (function)
           "clusterTrackBranches" t ;; (mFile) Cluster track-oriented multi-hypothesis history
           "clutterSurfaceRangeDopplerRCS" t ;; (mFile) Surface RCS as a function of range and Doppler
           "clutterSurfaceRCS" t ;; (mFile) Surface clutter radar cross section
           "clutterVolumeRCS" t ;; (mFile) Radar cross-section of volume clutter
           "clxbode" t ;; (mFile)
           "clyap" t ;; (mFile)
           "cm_get_custom_schemas" t ;; (mFile)
           "cmap2gray" t ;; (mFile) Convert RGB colormap to grayscale colormap
           "cmapeditor" t ;; (mFile)
           "cmd_window_buffering" t ;; (mFile)
           "cmddenoise" t ;; (mFile) Interval-dependent denoising
           "cmdscale" t ;; (mFile) Classical multidimensional scaling
           "cmdsep" t ;; (mFile) Command separator for current platform
           "cmdWindowDDG" t ;; (pFile)
           "cmdWindowDDG_cb" t ;; (pFile)
           "cmfdlg" t ;; (mFile)
           "cmgamdef" t ;; (mFile)
           "cmgamma" t ;; (mFile)
           "cmmusyn" t ;; (mFile)
           "cmorwavf" t ;; (mFile) Complex Morlet wavelet
           "cmosched" t ;; (mFile) Generate principal balance schedule for planned amortization class (PAC) or targeted amortization class (TAC) bond
           "cmoschedcf" t ;; (mFile) Generate cash flows for scheduled collateralized mortgage obligation (CMO) using PAC or TAC model
           "cmoseqcf" t ;; (mFile) Generate cash flows for sequential collateralized mortgage obligation (CMO)
           "cmpc" t ;; (mFile)
           "cmpermute" t ;; (mFile) Rearrange colors in colormap
           "CmpsrExtEllipseMdl" t ;; (mFile)
           "CmpsrExtEllipseMdl.CallUserDefinedFcn" t ;; (method)
           "cmsclsyn" t ;; (mFile) Approximately solve constant-matrix, upper bound µ-synthesis problem
           "cmthdlg" t ;; (mFile)
           "cmunique" t ;; (mFile) Eliminate duplicate colors in colormap; convert grayscale or truecolor image to indexed image
           "cnncodegen" t ;; (mFile) Generate code for a deep learning network to target the ARM Mali GPU
           "cntrlFinDiffInsideBnds" t ;; (pFile)
           "co2di" t ;; (mFile)
           "CoaxialFeed" t ;; (pFile) Create a coaxial feed object
           "code2html" t ;; (mFile)
           "codeAnalyzer" t ;; (mFile)
           "codebuild" t ;; (mFile) Compile and link generated code
           "codebuilder.buildCodeComponent" t ;; (function)
           "codebuilder.buildFMU" t ;; (function)
           "codebuilder.buildSFunction" t ;; (function)
           "codebuilder.setup" t ;; (function)
           "codebuildTest" t ;; (mFile)
           "codebuildTestFolder" t ;; (mFile)
           "codec" t ;; (mFile)
           "CodeCompatibilityAnalysis" t ;; (mFile) Code compatibility analysis results
           "codeCompatibilityAnalyzer" t ;; (mFile)
           "codeCompatibilityReport" t ;; (mFile) Create code compatibility report
           "codegen" t ;; (pFile) Generate C/C++ code from MATLAB code
           "CodeGenAdvisor.Group" t ;; (class)
           "CodeGenAdvisor.Group.closeExplorer" t ;; (method)
           "CodeGenAdvisor.Group.continuerun" t ;; (method)
           "CodeGenAdvisor.Group.deselect" t ;; (method)
           "CodeGenAdvisor.Group.opencsh" t ;; (method)
           "CodeGenAdvisor.Group.resetall" t ;; (method)
           "CodeGenAdvisor.Group.resetgui" t ;; (method)
           "CodeGenAdvisor.Group.run" t ;; (method)
           "CodeGenAdvisor.Group.runtofailure" t ;; (method)
           "CodeGenAdvisor.Group.runtohere" t ;; (method)
           "CodeGenAdvisor.Group.select" t ;; (method)
           "CodeGenAdvisor.Group.toggleCheckResultOverlay" t ;; (method)
           "CodeGenAdvisor.Group.toggleExclusiontab" t ;; (method)
           "CodeGenAdvisor.Group.toggleSourcetab" t ;; (method)
           "CodeGenAdvisor.Group.toggleTreeview" t ;; (method)
           "CodeGenAdvisor.SystemSelectorForConfigSet" t ;; (class)
           "codeinstrumprivate" t ;; (pFile)
           "codeIssues" t ;; (mFile) Identify code issues in files
           "codeIssues.loadobj" t ;; (method)
           "codeQualityDashboard" t ;; (pFile) View code quality metrics for projects
           "coder" t ;; (pFile) Open MATLAB Coder app
           "Coder.CSC.CustomStorageClassCodeGeneration" t ;; (class)
           "Coder.CSC.CustomStorageClassCodeGeneration.CommentSource" 'property
           "Coder.CSC.CustomStorageClassCodeGeneration.CustomAttributes" 'property
           "Coder.CSC.CustomStorageClassCodeGeneration.DataAccess" 'property
           "Coder.CSC.CustomStorageClassCodeGeneration.DataInit" 'property
           "Coder.CSC.CustomStorageClassCodeGeneration.DataScope" 'property
           "Coder.CSC.CustomStorageClassCodeGeneration.DeclareComment" 'property
           "Coder.CSC.CustomStorageClassCodeGeneration.DefineComment" 'property
           "Coder.CSC.CustomStorageClassCodeGeneration.DefinitionFile" 'property
           "Coder.CSC.CustomStorageClassCodeGeneration.HeaderFile" 'property
           "Coder.CSC.CustomStorageClassCodeGeneration.IsAddressable" 'property
           "Coder.CSC.CustomStorageClassCodeGeneration.IsConst" 'property
           "Coder.CSC.CustomStorageClassCodeGeneration.IsVolatile" 'property
           "Coder.CSC.CustomStorageClassCodeGeneration.Name" 'property
           "Coder.CSC.CustomStorageClassCodeGeneration.Package" 'property
           "Coder.CSC.CustomStorageClassCodeGeneration.Qualifiers" 'property
           "Coder.CSC.CustomStorageClassCodeGeneration.TypeComment" 'property
           "Coder.CSC.ExportedDefineCodeGeneration" t ;; (class)
           "Coder.CSC.ExportedDefineCodeGeneration.CommentSource" 'property
           "Coder.CSC.ExportedDefineCodeGeneration.CustomAttributes" 'property
           "Coder.CSC.ExportedDefineCodeGeneration.DataAccess" 'property
           "Coder.CSC.ExportedDefineCodeGeneration.DataInit" 'property
           "Coder.CSC.ExportedDefineCodeGeneration.DataScope" 'property
           "Coder.CSC.ExportedDefineCodeGeneration.DeclareComment" 'property
           "Coder.CSC.ExportedDefineCodeGeneration.DefineComment" 'property
           "Coder.CSC.ExportedDefineCodeGeneration.DefinitionFile" 'property
           "Coder.CSC.ExportedDefineCodeGeneration.HeaderFile" 'property
           "Coder.CSC.ExportedDefineCodeGeneration.IsAddressable" 'property
           "Coder.CSC.ExportedDefineCodeGeneration.IsConst" 'property
           "Coder.CSC.ExportedDefineCodeGeneration.IsVolatile" 'property
           "Coder.CSC.ExportedDefineCodeGeneration.Name" 'property
           "Coder.CSC.ExportedDefineCodeGeneration.Package" 'property
           "Coder.CSC.ExportedDefineCodeGeneration.Qualifiers" 'property
           "Coder.CSC.ExportedDefineCodeGeneration.TypeComment" 'property
           "Coder.CSC.ExportedGlobalCodeGeneration" t ;; (class)
           "Coder.CSC.ExportedGlobalCodeGeneration.CommentSource" 'property
           "Coder.CSC.ExportedGlobalCodeGeneration.CustomAttributes" 'property
           "Coder.CSC.ExportedGlobalCodeGeneration.DataAccess" 'property
           "Coder.CSC.ExportedGlobalCodeGeneration.DataInit" 'property
           "Coder.CSC.ExportedGlobalCodeGeneration.DataScope" 'property
           "Coder.CSC.ExportedGlobalCodeGeneration.DeclareComment" 'property
           "Coder.CSC.ExportedGlobalCodeGeneration.DefineComment" 'property
           "Coder.CSC.ExportedGlobalCodeGeneration.DefinitionFile" 'property
           "Coder.CSC.ExportedGlobalCodeGeneration.HeaderFile" 'property
           "Coder.CSC.ExportedGlobalCodeGeneration.IsAddressable" 'property
           "Coder.CSC.ExportedGlobalCodeGeneration.IsConst" 'property
           "Coder.CSC.ExportedGlobalCodeGeneration.IsVolatile" 'property
           "Coder.CSC.ExportedGlobalCodeGeneration.Name" 'property
           "Coder.CSC.ExportedGlobalCodeGeneration.Package" 'property
           "Coder.CSC.ExportedGlobalCodeGeneration.Qualifiers" 'property
           "Coder.CSC.ExportedGlobalCodeGeneration.TypeComment" 'property
           "Coder.CSC.FieldCodeGeneration" t ;; (class)
           "Coder.CSC.FieldCodeGeneration.Dimension" 'property
           "Coder.CSC.FieldCodeGeneration.FieldName" 'property
           "Coder.CSC.FieldCodeGeneration.FieldType" 'property
           "Coder.CSC.FieldCodeGeneration.IsBoolean" 'property
           "Coder.CSC.GetSetCodeGeneration" t ;; (class)
           "Coder.CSC.GetSetCodeGeneration.CommentSource" 'property
           "Coder.CSC.GetSetCodeGeneration.CustomAttributes" 'property
           "Coder.CSC.GetSetCodeGeneration.DataAccess" 'property
           "Coder.CSC.GetSetCodeGeneration.DataInit" 'property
           "Coder.CSC.GetSetCodeGeneration.DataScope" 'property
           "Coder.CSC.GetSetCodeGeneration.DeclareComment" 'property
           "Coder.CSC.GetSetCodeGeneration.DefineComment" 'property
           "Coder.CSC.GetSetCodeGeneration.DefinitionFile" 'property
           "Coder.CSC.GetSetCodeGeneration.HeaderFile" 'property
           "Coder.CSC.GetSetCodeGeneration.IsAddressable" 'property
           "Coder.CSC.GetSetCodeGeneration.IsConst" 'property
           "Coder.CSC.GetSetCodeGeneration.IsVolatile" 'property
           "Coder.CSC.GetSetCodeGeneration.Name" 'property
           "Coder.CSC.GetSetCodeGeneration.Package" 'property
           "Coder.CSC.GetSetCodeGeneration.Qualifiers" 'property
           "Coder.CSC.GetSetCodeGeneration.TypeComment" 'property
           "Coder.CSC.ImportedExternCodeGeneration" t ;; (class)
           "Coder.CSC.ImportedExternCodeGeneration.CommentSource" 'property
           "Coder.CSC.ImportedExternCodeGeneration.CustomAttributes" 'property
           "Coder.CSC.ImportedExternCodeGeneration.DataAccess" 'property
           "Coder.CSC.ImportedExternCodeGeneration.DataInit" 'property
           "Coder.CSC.ImportedExternCodeGeneration.DataScope" 'property
           "Coder.CSC.ImportedExternCodeGeneration.DeclareComment" 'property
           "Coder.CSC.ImportedExternCodeGeneration.DefineComment" 'property
           "Coder.CSC.ImportedExternCodeGeneration.DefinitionFile" 'property
           "Coder.CSC.ImportedExternCodeGeneration.HeaderFile" 'property
           "Coder.CSC.ImportedExternCodeGeneration.IsAddressable" 'property
           "Coder.CSC.ImportedExternCodeGeneration.IsConst" 'property
           "Coder.CSC.ImportedExternCodeGeneration.IsVolatile" 'property
           "Coder.CSC.ImportedExternCodeGeneration.Name" 'property
           "Coder.CSC.ImportedExternCodeGeneration.Package" 'property
           "Coder.CSC.ImportedExternCodeGeneration.Qualifiers" 'property
           "Coder.CSC.ImportedExternCodeGeneration.TypeComment" 'property
           "Coder.CSC.ImportedExternPointerCodeGeneration" t ;; (class)
           "Coder.CSC.ImportedExternPointerCodeGeneration.CommentSource" 'property
           "Coder.CSC.ImportedExternPointerCodeGeneration.CustomAttributes" 'property
           "Coder.CSC.ImportedExternPointerCodeGeneration.DataAccess" 'property
           "Coder.CSC.ImportedExternPointerCodeGeneration.DataInit" 'property
           "Coder.CSC.ImportedExternPointerCodeGeneration.DataScope" 'property
           "Coder.CSC.ImportedExternPointerCodeGeneration.DeclareComment" 'property
           "Coder.CSC.ImportedExternPointerCodeGeneration.DefineComment" 'property
           "Coder.CSC.ImportedExternPointerCodeGeneration.DefinitionFile" 'property
           "Coder.CSC.ImportedExternPointerCodeGeneration.HeaderFile" 'property
           "Coder.CSC.ImportedExternPointerCodeGeneration.IsAddressable" 'property
           "Coder.CSC.ImportedExternPointerCodeGeneration.IsConst" 'property
           "Coder.CSC.ImportedExternPointerCodeGeneration.IsVolatile" 'property
           "Coder.CSC.ImportedExternPointerCodeGeneration.Name" 'property
           "Coder.CSC.ImportedExternPointerCodeGeneration.Package" 'property
           "Coder.CSC.ImportedExternPointerCodeGeneration.Qualifiers" 'property
           "Coder.CSC.ImportedExternPointerCodeGeneration.TypeComment" 'property
           "Coder.CSC.SingleEntityCodeGeneration" t ;; (class)
           "Coder.CSC.SingleEntityCodeGeneration.CommentSource" 'property
           "Coder.CSC.SingleEntityCodeGeneration.CustomAttributes" 'property
           "Coder.CSC.SingleEntityCodeGeneration.DataAccess" 'property
           "Coder.CSC.SingleEntityCodeGeneration.DataInit" 'property
           "Coder.CSC.SingleEntityCodeGeneration.DataScope" 'property
           "Coder.CSC.SingleEntityCodeGeneration.DeclareComment" 'property
           "Coder.CSC.SingleEntityCodeGeneration.DefineComment" 'property
           "Coder.CSC.SingleEntityCodeGeneration.DefinitionFile" 'property
           "Coder.CSC.SingleEntityCodeGeneration.HeaderFile" 'property
           "Coder.CSC.SingleEntityCodeGeneration.IsAddressable" 'property
           "Coder.CSC.SingleEntityCodeGeneration.IsConst" 'property
           "Coder.CSC.SingleEntityCodeGeneration.IsVolatile" 'property
           "Coder.CSC.SingleEntityCodeGeneration.Name" 'property
           "Coder.CSC.SingleEntityCodeGeneration.Package" 'property
           "Coder.CSC.SingleEntityCodeGeneration.Qualifiers" 'property
           "Coder.CSC.SingleEntityCodeGeneration.TypeComment" 'property
           "Coder.CSC.StructCodeGeneration" t ;; (class)
           "Coder.CSC.StructCodeGeneration.BitPackBoolean" 'property
           "Coder.CSC.StructCodeGeneration.CommentSource" 'property
           "Coder.CSC.StructCodeGeneration.CustomAttributes" 'property
           "Coder.CSC.StructCodeGeneration.DataAccess" 'property
           "Coder.CSC.StructCodeGeneration.DataInit" 'property
           "Coder.CSC.StructCodeGeneration.DataScope" 'property
           "Coder.CSC.StructCodeGeneration.DeclareComment" 'property
           "Coder.CSC.StructCodeGeneration.DefineComment" 'property
           "Coder.CSC.StructCodeGeneration.DefinitionFile" 'property
           "Coder.CSC.StructCodeGeneration.Fields" 'property
           "Coder.CSC.StructCodeGeneration.HeaderFile" 'property
           "Coder.CSC.StructCodeGeneration.IsAddressable" 'property
           "Coder.CSC.StructCodeGeneration.IsConst" 'property
           "Coder.CSC.StructCodeGeneration.IsVolatile" 'property
           "Coder.CSC.StructCodeGeneration.Name" 'property
           "Coder.CSC.StructCodeGeneration.Package" 'property
           "Coder.CSC.StructCodeGeneration.Qualifiers" 'property
           "Coder.CSC.StructCodeGeneration.StructName" 'property
           "Coder.CSC.StructCodeGeneration.TypeComment" 'property
           "Coder.CSC.StructCodeGeneration.TypeDef" 'property
           "Coder.CSC.StructCodeGeneration.TypeName" 'property
           "Coder.CSC.StructCodeGeneration.TypeTag" 'property
           "Coder.CSC.StructCodeGeneration.TypeToken" 'property
           "Coder.CSC.UnsupportedCSCCodeGeneration" t ;; (class)
           "Coder.CSC.UnsupportedCSCCodeGeneration.CommentSource" 'property
           "Coder.CSC.UnsupportedCSCCodeGeneration.CustomAttributes" 'property
           "Coder.CSC.UnsupportedCSCCodeGeneration.DataAccess" 'property
           "Coder.CSC.UnsupportedCSCCodeGeneration.DataInit" 'property
           "Coder.CSC.UnsupportedCSCCodeGeneration.DataScope" 'property
           "Coder.CSC.UnsupportedCSCCodeGeneration.DeclareComment" 'property
           "Coder.CSC.UnsupportedCSCCodeGeneration.DefineComment" 'property
           "Coder.CSC.UnsupportedCSCCodeGeneration.DefinitionFile" 'property
           "Coder.CSC.UnsupportedCSCCodeGeneration.HeaderFile" 'property
           "Coder.CSC.UnsupportedCSCCodeGeneration.IsAddressable" 'property
           "Coder.CSC.UnsupportedCSCCodeGeneration.IsConst" 'property
           "Coder.CSC.UnsupportedCSCCodeGeneration.IsVolatile" 'property
           "Coder.CSC.UnsupportedCSCCodeGeneration.Name" 'property
           "Coder.CSC.UnsupportedCSCCodeGeneration.Package" 'property
           "Coder.CSC.UnsupportedCSCCodeGeneration.Qualifiers" 'property
           "Coder.CSC.UnsupportedCSCCodeGeneration.TypeComment" 'property
           "coder__log" t ;; (pFile)
           "coder_coverage_ui.CodeCovDlg" t ;; (class)
           "coder_sysobj_get" t ;; (mFile)
           "coderdemodir" t ;; (mFile)
           "coderdi.CoderDI" t ;; (class)
           "coderdi.CoderDI.StaticMetaClass" t ;; (method)
           "coderdi.CoderDIAssignment" t ;; (class)
           "coderdi.CoderDIAssignment.StaticMetaClass" t ;; (method)
           "coderdi.CoderDISrcType" t ;; (class)
           "coderdi.CoderDISrcType.CoderDataGroup" 'enumeration
           "coderdi.CoderDISrcType.DataObject" 'enumeration
           "coderdi.CoderDISrcType.Null" 'enumeration
           "coderdi.CoderDISrcType.SimulinkGlobal" 'enumeration
           "coderdi.CoderDISrcType.SlFeature" 'enumeration
           "coderdi.Inspector" t ;; (class)
           "coderdi.MEBlockBased" t ;; (class)
           "coderdi.MEBlockBased.diAssignments" 'property
           "coderdi.MEBlockBased.StaticMetaClass" t ;; (method)
           "coderdi.MEBlockOutput" t ;; (class)
           "coderdi.MEBlockOutput.diAssignments" 'property
           "coderdi.MEBlockOutput.StaticMetaClass" t ;; (method)
           "coderdi.MEDataStore" t ;; (class)
           "coderdi.MEDataStore.diAssignments" 'property
           "coderdi.MEDataStore.StaticMetaClass" t ;; (method)
           "coderdi.MEParameter" t ;; (class)
           "coderdi.MEParameter.diAssignments" 'property
           "coderdi.MEParameter.StaticMetaClass" t ;; (method)
           "coderdi.MERootInport" t ;; (class)
           "coderdi.MERootInport.diAssignments" 'property
           "coderdi.MERootInport.StaticMetaClass" t ;; (method)
           "coderdi.MERootOutport" t ;; (class)
           "coderdi.MERootOutport.diAssignments" 'property
           "coderdi.MERootOutport.StaticMetaClass" t ;; (method)
           "coderdi.MESignal" t ;; (class)
           "coderdi.MESignal.diAssignments" 'property
           "coderdi.MESignal.StaticMetaClass" t ;; (method)
           "coderdi.MEState" t ;; (class)
           "coderdi.MEState.diAssignments" 'property
           "coderdi.MEState.StaticMetaClass" t ;; (method)
           "coderdi.ModelingElement" t ;; (class)
           "coderdi.ModelingElement.diAssignments" 'property
           "coderdi.ModelingElement.StaticMetaClass" t ;; (method)
           "coderEnableLog" t ;; (pFile)
           "codergui.evalprivate" t ;; (function)
           "codergui.ReportServices" t ;; (class)
           "codergui.ReportServices.Generator" 'enumeration
           "codergui.ReportServices.loadConfigObject" t ;; (method)
           "codergui.ReportServices.TypeEditorFactory" 'enumeration
           "codergui.ReportServices.ViewerFactory" 'enumeration
           "codergui.ReportServices.WebClientFactory" 'enumeration
           "codergui.ReportType" t ;; (class)
           "codergui.ReportType.ClientTypeValue" 'property
           "codergui.ReportType.FileCategory" 'property
           "codergui.ReportViewer" t ;; (class)
           "codergui.ReportViewer.byId" t ;; (method)
           "codergui.ReportViewer.closeAll" t ;; (method)
           "codergui.ReportViewer.getReportViewers" t ;; (method)
           "codergui.WebClient" t ;; (class)
           "codergui.WebClient.disposeAll" t ;; (method)
           "codergui.WebClient.disposeById" t ;; (method)
           "codergui.WebClient.getWebClients" t ;; (method)
           "coderprivate.AnalyzeStructures" t ;; (function)
           "coderprivate.compiler_supports_eml_ipp" t ;; (function)
           "coderprivate.compiler_supports_eml_openmp" t ;; (function)
           "coderprivate.convertMessagesToJavaArray" t ;; (function)
           "coderprivate.emlscreener_kernel" t ;; (function)
           "coderprivate.EMLScreening" t ;; (class)
           "coderprivate.Float2FixedManager" t ;; (class)
           "coderprivate.Float2FixedManager.applyFunctionReplacementsToConfig" t ;; (method)
           "coderprivate.Float2FixedManager.BuildApproxationObj" t ;; (method)
           "coderprivate.Float2FixedManager.FilterForcePushToCloudMessage" t ;; (method)
           "coderprivate.Float2FixedManager.getInputs" t ;; (method)
           "coderprivate.Float2FixedManager.getMathFcnGenConfigs" t ;; (method)
           "coderprivate.Float2FixedManager.getMathFcnGenConfigsFromXml" t ;; (method)
           "coderprivate.Float2FixedManager.instance" t ;; (method)
           "coderprivate.getBinfoMATFileAndCodeName" t ;; (function)
           "coderprivate.hasEmbeddedCoder" t ;; (function)
           "coderprivate.hasFixptPointDesignerLicense" t ;; (function)
           "coderprivate.hasHDLCoderLicense" t ;; (function)
           "coderprivate.hasPLCCoderLicense" t ;; (function)
           "coderprivate.inMATLABToolbox" t ;; (function)
           "coderprivate.isFixedPointConversionEnabled" t ;; (function)
           "coderprivate.isHDLCoderProject" t ;; (function)
           "coderprivate.makeCause" t ;; (function)
           "coderprivate.MFileInfo" t ;; (class)
           "coderprivate.msgSafeException" t ;; (function)
           "coderprivate.supportedEMLFunctions" t ;; (function)
           "coderprivate.transferCauses" t ;; (function)
           "coderprivate.warnBacktraceOff" t ;; (function)
           "codertarget.arm_cortex_a.blocks.isInvalidRegisterUseCase" t ;; (function)
           "codertarget.arm_cortex_a.pil.profilingTimer" t ;; (function)
           "codertarget.arm_cortex_a.pil.TargetApplicationFramework" t ;; (class)
           "codertarget.arm_cortex_m.pil.Timer" t ;; (class)
           "codertarget.armM.registry.EthernetAddressCallback" t ;; (function)
           "codertarget.armM.registry.EthernetIPAddressCallback" t ;; (function)
           "codertarget.armM.registry.EthernetMacAddressCallback" t ;; (function)
           "codertarget.armM.registry.ExtModePILVisibilityCallback" t ;; (function)
           "codertarget.armM.registry.serialPortChangeCallback" t ;; (function)
           "codertarget.armM.registry.serialPortEntriesCallback" t ;; (function)
           "codertarget.armM.registry.serialPortRefreshCallback" t ;; (function)
           "codertarget.armM.registry.serialPortValueCallback" t ;; (function)
           "codertarget.armM4.blocks.BlockSampleTime" t ;; (class)
           "codertarget.armM4.blocks.CANFDRead" t ;; (class)
           "codertarget.armM4.blocks.CANFDRead.getDescriptiveName" t ;; (method)
           "codertarget.armM4.blocks.CANFDRead.isSupportedContext" t ;; (method)
           "codertarget.armM4.blocks.CANFDRead.updateBuildInfo" t ;; (method)
           "codertarget.armM4.blocks.CANFDWrite" t ;; (class)
           "codertarget.armM4.blocks.CANFDWrite.getDescriptiveName" t ;; (method)
           "codertarget.armM4.blocks.CANFDWrite.isSupportedContext" t ;; (method)
           "codertarget.armM4.blocks.CANFDWrite.updateBuildInfo" t ;; (method)
           "codertarget.armM4.blocks.MCANInterruptStatus" t ;; (class)
           "codertarget.armM4.blocks.MCANInterruptStatus.getDescriptiveName" t ;; (method)
           "codertarget.armM4.blocks.MCANInterruptStatus.isSupportedContext" t ;; (method)
           "codertarget.armM4.blocks.MCANInterruptStatus.updateBuildInfo" t ;; (method)
           "codertarget.armM4.blocks.TcpReceive" t ;; (class)
           "codertarget.armM4.blocks.TcpReceive.getDescriptiveName" t ;; (method)
           "codertarget.armM4.blocks.TcpReceive.isSupportedContext" t ;; (method)
           "codertarget.armM4.blocks.TcpReceive.updateBuildInfo" t ;; (method)
           "codertarget.armM4.blocks.TcpSend" t ;; (class)
           "codertarget.armM4.blocks.TcpSend.getDescriptiveName" t ;; (method)
           "codertarget.armM4.blocks.TcpSend.isSupportedContext" t ;; (method)
           "codertarget.armM4.blocks.TcpSend.parseDataType" t ;; (method)
           "codertarget.armM4.blocks.TcpSend.updateBuildInfo" t ;; (method)
           "codertarget.armM4.blocks.UartReceive" t ;; (class)
           "codertarget.armM4.blocks.UartReceive.getDescriptiveName" t ;; (method)
           "codertarget.armM4.blocks.UartReceive.isSupportedContext" t ;; (method)
           "codertarget.armM4.blocks.UartReceive.macroNameParity" t ;; (method)
           "codertarget.armM4.blocks.UartReceive.updateBuildInfo" t ;; (method)
           "codertarget.armM4.blocks.UartSend" t ;; (class)
           "codertarget.armM4.blocks.UartSend.getDescriptiveName" t ;; (method)
           "codertarget.armM4.blocks.UartSend.isSupportedContext" t ;; (method)
           "codertarget.armM4.blocks.UartSend.macroNameParity" t ;; (method)
           "codertarget.armM4.blocks.UartSend.parseDataType" t ;; (method)
           "codertarget.armM4.blocks.UartSend.updateBuildInfo" t ;; (method)
           "codertarget.armM4.blocks.UdpReceive" t ;; (class)
           "codertarget.armM4.blocks.UdpReceive.getDescriptiveName" t ;; (method)
           "codertarget.armM4.blocks.UdpReceive.isSupportedContext" t ;; (method)
           "codertarget.armM4.blocks.UdpReceive.updateBuildInfo" t ;; (method)
           "codertarget.armM4.blocks.UdpSend" t ;; (class)
           "codertarget.armM4.blocks.UdpSend.getDescriptiveName" t ;; (method)
           "codertarget.armM4.blocks.UdpSend.isSupportedContext" t ;; (method)
           "codertarget.armM4.blocks.UdpSend.parseDataType" t ;; (method)
           "codertarget.armM4.blocks.UdpSend.updateBuildInfo" t ;; (method)
           "codertarget.armM4.pil.EthernetConnectivityConfig" t ;; (class)
           "codertarget.armM4.pil.EthernetTargetApplicationFramework" t ;; (class)
           "codertarget.armM4.pil.SerialConnectivityConfig" t ;; (class)
           "codertarget.armM4.pil.SerialLauncher" t ;; (class)
           "codertarget.armM4.pil.SerialLauncher.setStartApplicationPause" t ;; (method)
           "codertarget.armM4.pil.SerialTargetApplicationFramework" t ;; (class)
           "codertarget.armM4.registry.Clocking_SysCLKControl_UICallback" t ;; (function)
           "codertarget.armM4.registry.conflict_mngt_cm_uart_receive" t ;; (function)
           "codertarget.armM4.registry.conflict_mngt_cm_uart_transmit" t ;; (function)
           "codertarget.armM4.registry.EthernetCallback" t ;; (function)
           "codertarget.armM4.registry.EthernetConfigIPAddressExternalMode" t ;; (function)
           "codertarget.armM4.registry.ExtModeSetUpHook" t ;; (function)
           "codertarget.armM4.registry.getMCANConfigParameters" t ;; (function)
           "codertarget.armM4.registry.getMCANData" t ;; (function)
           "codertarget.armM4.registry.MCANCallback" t ;; (function)
           "codertarget.armM4.registry.mcanFilterInformationCallback" t ;; (function)
           "codertarget.armM4.registry.mcanProtocolChangeCallback" t ;; (function)
           "codertarget.armM4.registry.mcanVisibleCallback" t ;; (function)
           "codertarget.armM4.registry.MCANWidgetChangedCallback" t ;; (function)
           "codertarget.armM4.registry.registerARMPeripheralBlocks" t ;; (function)
           "codertarget.armM4.registry.UARTConfigBaudRate" t ;; (function)
           "codertarget.armM4.registry.UARTConfigBaudRateExternalMode" t ;; (function)
           "codertarget.armM4.registry.UARTConfigCallback" t ;; (function)
           "codertarget.asyncioplugins.udp.ByteServer" t ;; (class)
           "codertarget.asyncioplugins.udp.Channel" t ;; (class)
           "codertarget.asyncioplugins.udp.Channel.matlabCodegenRedirect" t ;; (method)
           "codertarget.attributes.AttributeInfo" t ;; (class)
           "codertarget.attributes.AttributeInfo.addNewElementToArrayProperty" t ;; (method)
           "codertarget.attributes.AttributeInfo.createDocument" t ;; (method)
           "codertarget.attributes.AttributeInfo.createParameter" t ;; (method)
           "codertarget.attributes.AttributeInfo.createParameterGroup" t ;; (method)
           "codertarget.attributes.AttributeInfo.getElement" t ;; (method)
           "codertarget.attributes.AttributeInfo.read" t ;; (method)
           "codertarget.attributes.AttributeInfo.setAttribute" t ;; (method)
           "codertarget.attributes.AttributeInfo.setElement" t ;; (method)
           "codertarget.attributes.AttributeInfo.write" t ;; (method)
           "codertarget.attributes.BuildConfigurationInfo" t ;; (class)
           "codertarget.attributes.BuildConfigurationInfo.addNewElementToArrayProperty" t ;; (method)
           "codertarget.attributes.BuildConfigurationInfo.createDocument" t ;; (method)
           "codertarget.attributes.BuildConfigurationInfo.createParameter" t ;; (method)
           "codertarget.attributes.BuildConfigurationInfo.createParameterGroup" t ;; (method)
           "codertarget.attributes.BuildConfigurationInfo.getElement" t ;; (method)
           "codertarget.attributes.BuildConfigurationInfo.read" t ;; (method)
           "codertarget.attributes.BuildConfigurationInfo.setAttribute" t ;; (method)
           "codertarget.attributes.BuildConfigurationInfo.setElement" t ;; (method)
           "codertarget.attributes.BuildConfigurationInfo.write" t ;; (method)
           "codertarget.attributes.CANIOInterface" t ;; (class)
           "codertarget.attributes.CustomIOInterface" t ;; (class)
           "codertarget.attributes.ExternalModeInfo" t ;; (class)
           "codertarget.attributes.getAttribute" t ;; (function)
           "codertarget.attributes.getConnectionInfo" t ;; (function)
           "codertarget.attributes.getCPUSyncAttribute" t ;; (function)
           "codertarget.attributes.getExtModeData" t ;; (function)
           "codertarget.attributes.getProcessingUnitAttributes" t ;; (function)
           "codertarget.attributes.getRegisteredAttributes" t ;; (function)
           "codertarget.attributes.getTargetHardwareAttributes" t ;; (function)
           "codertarget.attributes.getTargetHardwareAttributesForHardwareName" t ;; (function)
           "codertarget.attributes.IOInterface" t ;; (class)
           "codertarget.attributes.isExtModeInBackground" t ;; (function)
           "codertarget.attributes.isExtModeOptionVisible" t ;; (function)
           "codertarget.attributes.resetExtModeData" t ;; (function)
           "codertarget.attributes.resetExtModeProtocolInfo" t ;; (function)
           "codertarget.attributes.SerialIOInterface" t ;; (class)
           "codertarget.attributes.setExtModeData" t ;; (function)
           "codertarget.attributes.supportTargetServicesFeature" t ;; (function)
           "codertarget.attributes.TaskInfo" t ;; (class)
           "codertarget.attributes.TCPIPIOInterface" t ;; (class)
           "codertarget.attributes.XCPProtocolConfiguration" t ;; (class)
           "codertarget.attributes.XCPProtocolConfiguration.getProtocolConfigurationWidgetNames" t ;; (method)
           "codertarget.attributes.XCPProtocolConfiguration.getSupportedHostInterfaces" t ;; (method)
           "codertarget.blocks.utils.connectInport" t ;; (function)
           "codertarget.blocks.utils.connectOutport" t ;; (function)
           "codertarget.blocks.utils.createDriverBlock" t ;; (function)
           "codertarget.blocks.utils.manageInport" t ;; (function)
           "codertarget.blocks.utils.manageOutport" t ;; (function)
           "codertarget.blocks.utils.promotedParametersCallback" t ;; (function)
           "codertarget.blocks.utils.simCheckBoxCb" t ;; (function)
           "codertarget.blocks.utils.sysObjVisibilityCtrl" t ;; (function)
           "codertarget.bootloader.supportsFieldProgramming" t ;; (function)
           "codertarget.concerto.pil.EthernetConnectivityConfig" t ;; (class)
           "codertarget.concerto.pil.EthernetTargetApplicationFramework" t ;; (class)
           "codertarget.concerto.pil.SerialConnectivityConfig" t ;; (class)
           "codertarget.concerto.pil.SerialLauncher" t ;; (class)
           "codertarget.concerto.pil.SerialLauncher.setStartApplicationPause" t ;; (method)
           "codertarget.concerto.pil.SerialTargetApplicationFramework" t ;; (class)
           "codertarget.concerto.registry.ACIBClockDisplayCallback" t ;; (function)
           "codertarget.concerto.registry.autoPLLEnable" t ;; (function)
           "codertarget.concerto.registry.checkGPIOEnabled" t ;; (function)
           "codertarget.concerto.registry.Clocking_SysCLKControl_UICallback" t ;; (function)
           "codertarget.concerto.registry.ConcertoExtModeSetUpHook" t ;; (function)
           "codertarget.concerto.registry.ConfigEnableLoopback" t ;; (function)
           "codertarget.concerto.registry.conflict_mngt_concerto_uart_receive" t ;; (function)
           "codertarget.concerto.registry.conflict_mngt_concerto_uart_transmit" t ;; (function)
           "codertarget.concerto.registry.DeviceIDSelectionCallback" t ;; (function)
           "codertarget.concerto.registry.ePWMTripSelectionCallback" t ;; (function)
           "codertarget.concerto.registry.EthernetCallback" t ;; (function)
           "codertarget.concerto.registry.EthernetConfigIPAddressExternalMode" t ;; (function)
           "codertarget.concerto.registry.getMaximumAllowedFreq" t ;; (function)
           "codertarget.concerto.registry.GPIOConfigEnable" t ;; (function)
           "codertarget.concerto.registry.GPIOConfigVisible" t ;; (function)
           "codertarget.concerto.registry.registerARMPeripheralBlocks" t ;; (function)
           "codertarget.concerto.registry.SetExtModeTrigDuration" t ;; (function)
           "codertarget.concerto.registry.UARTConfigBaudRate" t ;; (function)
           "codertarget.concerto.registry.UARTConfigBaudRateExternalMode" t ;; (function)
           "codertarget.concerto.registry.UARTConfigCallback" t ;; (function)
           "codertarget.concerto.utils.concertoAutoSetPLLSettings" t ;; (function)
           "codertarget.connectedIO.tic2000.c2000ADC" t ;; (class)
           "codertarget.connectedIO.tic2000.c2000ADC.ADCUnconfigure" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ADC.AssignBitsInRegister" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ADC.clearVar" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ADC.clearVariables" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ADC.CombineBitsInRegisterAndCreateMask" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ADC.connectServer" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ADC.CreateMask" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ADC.ePWMUnconfigure" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ADC.getADCRegAdd" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ADC.getSelectedGPIOPinNumbers" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ADC.getType1and2ADCRegAdd" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ADC.init" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ADC.initType1and2ADC" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ADC.outputs" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ADC.outputType1and2ADC" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ADC.PositionBitsInRegisterAndCreateMask" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ADC.readWriteRegisterValue" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ADC.setgetADCModules" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ADC.setgetADCRegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ADC.setgetADCType1and2RegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ADC.setgetADCTypes" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ADC.setgetC2000RegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ADC.setgetCMPALinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ADC.setgetCMPBLinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ADC.setgetCMPCLinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ADC.setgetCMPDLinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ADC.setgetePWMPinObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ADC.setgetePWMRegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ADC.setgetEPWMSync" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ADC.setgetGPIOReadRegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ADC.setgetGPIOWriteRegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ADC.setgetIOEnabledObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ADC.setgetIOProtocolObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ADC.setgetModelHandleObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ADC.setgetTBPRDLinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ADC.setgetTransportLayerObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ePWM" t ;; (class)
           "codertarget.connectedIO.tic2000.c2000ePWM.ADCUnconfigure" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ePWM.AssignBitsInRegister" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ePWM.clearVar" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ePWM.clearVariables" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ePWM.cofigureEPWMRegsC2802x" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ePWM.cofigureEPWMRegsC280x" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ePWM.CombineBitsInRegisterAndCreateMask" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ePWM.config_ePWM0x33x_TripZone" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ePWM.config_ePWM_GPIO" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ePWM.config_ePWM_SYNC" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ePWM.config_ePWM_TBSync" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ePWM.config_ePWM_TripZone" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ePWM.connectServer" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ePWM.CreateMask" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ePWM.ePWMUnconfigure" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ePWM.getCMPValueFromInputPort" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ePWM.getDBFromInputPort" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ePWM.getDecreaseValue" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ePWM.getPWMClock" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ePWM.getSelectedGPIOPinNumbers" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ePWM.getTimerPeriodFromInputPort" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ePWM.init" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ePWM.init0xand33xEPWM" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ePWM.modifyPWMRegisterValue" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ePWM.outputs" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ePWM.PositionBitsInRegisterAndCreateMask" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ePWM.readWritePWMRegisterValue" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ePWM.readWriteRegisterValue" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ePWM.setgetADCModules" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ePWM.setgetADCRegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ePWM.setgetADCType1and2RegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ePWM.setgetADCTypes" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ePWM.setgetC2000RegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ePWM.setgetCMPALinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ePWM.setgetCMPBLinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ePWM.setgetCMPCLinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ePWM.setgetCMPDLinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ePWM.setgetePWMPinObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ePWM.setgetePWMRegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ePWM.setgetEPWMSync" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ePWM.setgetGPIOReadRegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ePWM.setgetGPIOWriteRegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ePWM.setgetIOEnabledObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ePWM.setgetIOProtocolObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ePWM.setgetModelHandleObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ePWM.setgetTBPRDLinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000ePWM.setgetTransportLayerObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIORead" t ;; (class)
           "codertarget.connectedIO.tic2000.c2000GPIORead.ADCUnconfigure" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIORead.AssignBitsInRegister" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIORead.clearVar" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIORead.clearVariables" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIORead.CombineBitsInRegisterAndCreateMask" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIORead.connectServer" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIORead.CreateMask" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIORead.ePWMUnconfigure" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIORead.getGPIOCtrlRegAdd" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIORead.getGPIOQualOpt" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIORead.getGPIOQualPRDStatus" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIORead.getRegMemAdd" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIORead.getSelectedGPIOPinNumbers" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIORead.GPIOQualSelConfig" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIORead.init" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIORead.isGPIOQualPRDenabled" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIORead.outputs" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIORead.PositionBitsInRegisterAndCreateMask" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIORead.QualPrdSetting" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIORead.readWriteRegisterValue" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIORead.setgetADCModules" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIORead.setgetADCRegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIORead.setgetADCType1and2RegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIORead.setgetADCTypes" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIORead.setgetC2000RegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIORead.setgetCMPALinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIORead.setgetCMPBLinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIORead.setgetCMPCLinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIORead.setgetCMPDLinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIORead.setgetePWMPinObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIORead.setgetePWMRegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIORead.setgetEPWMSync" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIORead.setgetGPIOReadRegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIORead.setgetGPIOWriteRegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIORead.setgetIOEnabledObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIORead.setgetIOProtocolObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIORead.setgetModelHandleObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIORead.setgetTBPRDLinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIORead.setgetTransportLayerObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIORead.writeGPIOCtrlRegValue" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIOWrite" t ;; (class)
           "codertarget.connectedIO.tic2000.c2000GPIOWrite.ADCUnconfigure" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIOWrite.AssignBitsInRegister" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIOWrite.clearVar" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIOWrite.clearVariables" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIOWrite.CombineBitsInRegisterAndCreateMask" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIOWrite.connectServer" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIOWrite.CreateMask" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIOWrite.ePWMUnconfigure" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIOWrite.getGPIOCtrlRegAdd" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIOWrite.getGPIOQualOpt" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIOWrite.getGPIOQualPRDStatus" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIOWrite.getRegMemAdd" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIOWrite.getSelectedGPIOPinNumbers" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIOWrite.GPIOQualSelConfig" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIOWrite.init" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIOWrite.isGPIOQualPRDenabled" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIOWrite.outputs" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIOWrite.PositionBitsInRegisterAndCreateMask" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIOWrite.QualPrdSetting" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIOWrite.readWriteRegisterValue" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIOWrite.setgetADCModules" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIOWrite.setgetADCRegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIOWrite.setgetADCType1and2RegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIOWrite.setgetADCTypes" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIOWrite.setgetC2000RegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIOWrite.setgetCMPALinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIOWrite.setgetCMPBLinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIOWrite.setgetCMPCLinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIOWrite.setgetCMPDLinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIOWrite.setgetePWMPinObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIOWrite.setgetePWMRegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIOWrite.setgetEPWMSync" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIOWrite.setgetGPIOReadRegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIOWrite.setgetGPIOWriteRegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIOWrite.setgetIOEnabledObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIOWrite.setgetIOProtocolObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIOWrite.setgetModelHandleObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIOWrite.setgetTBPRDLinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIOWrite.setgetTransportLayerObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000GPIOWrite.writeGPIOCtrlRegValue" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CRead" t ;; (class)
           "codertarget.connectedIO.tic2000.c2000I2CRead.ADCUnconfigure" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CRead.AssignBitsInRegister" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CRead.clearVar" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CRead.clearVariables" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CRead.CombineBitsInRegisterAndCreateMask" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CRead.connectServer" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CRead.CreateMask" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CRead.ePWMUnconfigure" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CRead.getOutputData" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CRead.getResponseSize" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CRead.getSelectedGPIOPinNumbers" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CRead.init" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CRead.outputs" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CRead.PositionBitsInRegisterAndCreateMask" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CRead.readWriteRegisterValue" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CRead.setgetADCModules" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CRead.setgetADCRegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CRead.setgetADCType1and2RegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CRead.setgetADCTypes" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CRead.setgetC2000RegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CRead.setgetCMPALinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CRead.setgetCMPBLinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CRead.setgetCMPCLinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CRead.setgetCMPDLinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CRead.setgetePWMPinObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CRead.setgetePWMRegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CRead.setgetEPWMSync" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CRead.setgetGPIOReadRegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CRead.setgetGPIOWriteRegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CRead.setgetIOEnabledObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CRead.setgetIOProtocolObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CRead.setgetModelHandleObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CRead.setgetTBPRDLinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CRead.setgetTransportLayerObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CWrite" t ;; (class)
           "codertarget.connectedIO.tic2000.c2000I2CWrite.ADCUnconfigure" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CWrite.AssignBitsInRegister" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CWrite.clearVar" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CWrite.clearVariables" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CWrite.CombineBitsInRegisterAndCreateMask" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CWrite.connectServer" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CWrite.CreateMask" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CWrite.ePWMUnconfigure" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CWrite.getDatalength" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CWrite.getSelectedGPIOPinNumbers" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CWrite.init" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CWrite.outputs" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CWrite.PositionBitsInRegisterAndCreateMask" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CWrite.readWriteRegisterValue" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CWrite.setgetADCModules" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CWrite.setgetADCRegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CWrite.setgetADCType1and2RegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CWrite.setgetADCTypes" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CWrite.setgetC2000RegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CWrite.setgetCMPALinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CWrite.setgetCMPBLinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CWrite.setgetCMPCLinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CWrite.setgetCMPDLinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CWrite.setgetePWMPinObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CWrite.setgetePWMRegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CWrite.setgetEPWMSync" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CWrite.setgetGPIOReadRegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CWrite.setgetGPIOWriteRegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CWrite.setgetIOEnabledObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CWrite.setgetIOProtocolObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CWrite.setgetModelHandleObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CWrite.setgetTBPRDLinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000I2CWrite.setgetTransportLayerObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCIReceive" t ;; (class)
           "codertarget.connectedIO.tic2000.c2000SCIReceive.ADCUnconfigure" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCIReceive.AssignBitsInRegister" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCIReceive.clearVar" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCIReceive.CombineBitsInRegisterAndCreateMask" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCIReceive.connectServer" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCIReceive.CreateMask" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCIReceive.ePWMUnconfigure" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCIReceive.getSelectedGPIOPinNumbers" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCIReceive.init" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCIReceive.PositionBitsInRegisterAndCreateMask" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCIReceive.readWriteRegisterValue" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCIReceive.setgetADCModules" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCIReceive.setgetADCRegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCIReceive.setgetADCType1and2RegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCIReceive.setgetADCTypes" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCIReceive.setgetC2000RegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCIReceive.setgetCMPALinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCIReceive.setgetCMPBLinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCIReceive.setgetCMPCLinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCIReceive.setgetCMPDLinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCIReceive.setgetePWMPinObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCIReceive.setgetePWMRegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCIReceive.setgetEPWMSync" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCIReceive.setgetGPIOReadRegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCIReceive.setgetGPIOWriteRegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCIReceive.setgetIOEnabledObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCIReceive.setgetIOProtocolObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCIReceive.setgetModelHandleObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCIReceive.setgetTBPRDLinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCIReceive.setgetTransportLayerObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCITransmit" t ;; (class)
           "codertarget.connectedIO.tic2000.c2000SCITransmit.ADCUnconfigure" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCITransmit.AssignBitsInRegister" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCITransmit.clearVar" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCITransmit.CombineBitsInRegisterAndCreateMask" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCITransmit.connectServer" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCITransmit.CreateMask" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCITransmit.ePWMUnconfigure" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCITransmit.getSelectedGPIOPinNumbers" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCITransmit.init" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCITransmit.PositionBitsInRegisterAndCreateMask" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCITransmit.readWriteRegisterValue" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCITransmit.setgetADCModules" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCITransmit.setgetADCRegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCITransmit.setgetADCType1and2RegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCITransmit.setgetADCTypes" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCITransmit.setgetC2000RegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCITransmit.setgetCMPALinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCITransmit.setgetCMPBLinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCITransmit.setgetCMPCLinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCITransmit.setgetCMPDLinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCITransmit.setgetePWMPinObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCITransmit.setgetePWMRegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCITransmit.setgetEPWMSync" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCITransmit.setgetGPIOReadRegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCITransmit.setgetGPIOWriteRegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCITransmit.setgetIOEnabledObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCITransmit.setgetIOProtocolObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCITransmit.setgetModelHandleObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCITransmit.setgetTBPRDLinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.c2000SCITransmit.setgetTransportLayerObj" t ;; (method)
           "codertarget.connectedIO.tic2000.c2bAutoGeneratedPeripheralWrappersRequestID" t ;; (class)
           "codertarget.connectedIO.tic2000.commonFunction" t ;; (class)
           "codertarget.connectedIO.tic2000.commonFunction.ADCUnconfigure" t ;; (method)
           "codertarget.connectedIO.tic2000.commonFunction.AssignBitsInRegister" t ;; (method)
           "codertarget.connectedIO.tic2000.commonFunction.clearVar" t ;; (method)
           "codertarget.connectedIO.tic2000.commonFunction.CombineBitsInRegisterAndCreateMask" t ;; (method)
           "codertarget.connectedIO.tic2000.commonFunction.connectServer" t ;; (method)
           "codertarget.connectedIO.tic2000.commonFunction.CreateMask" t ;; (method)
           "codertarget.connectedIO.tic2000.commonFunction.ePWMUnconfigure" t ;; (method)
           "codertarget.connectedIO.tic2000.commonFunction.getSelectedGPIOPinNumbers" t ;; (method)
           "codertarget.connectedIO.tic2000.commonFunction.PositionBitsInRegisterAndCreateMask" t ;; (method)
           "codertarget.connectedIO.tic2000.commonFunction.readWriteRegisterValue" t ;; (method)
           "codertarget.connectedIO.tic2000.commonFunction.setgetADCModules" t ;; (method)
           "codertarget.connectedIO.tic2000.commonFunction.setgetADCRegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.commonFunction.setgetADCType1and2RegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.commonFunction.setgetADCTypes" t ;; (method)
           "codertarget.connectedIO.tic2000.commonFunction.setgetC2000RegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.commonFunction.setgetCMPALinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.commonFunction.setgetCMPBLinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.commonFunction.setgetCMPCLinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.commonFunction.setgetCMPDLinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.commonFunction.setgetePWMPinObj" t ;; (method)
           "codertarget.connectedIO.tic2000.commonFunction.setgetePWMRegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.commonFunction.setgetEPWMSync" t ;; (method)
           "codertarget.connectedIO.tic2000.commonFunction.setgetGPIOReadRegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.commonFunction.setgetGPIOWriteRegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.commonFunction.setgetIOEnabledObj" t ;; (method)
           "codertarget.connectedIO.tic2000.commonFunction.setgetIOProtocolObj" t ;; (method)
           "codertarget.connectedIO.tic2000.commonFunction.setgetModelHandleObj" t ;; (method)
           "codertarget.connectedIO.tic2000.commonFunction.setgetTBPRDLinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.commonFunction.setgetTransportLayerObj" t ;; (method)
           "codertarget.connectedIO.tic2000.commonGPIOFunction" t ;; (class)
           "codertarget.connectedIO.tic2000.commonGPIOFunction.ADCUnconfigure" t ;; (method)
           "codertarget.connectedIO.tic2000.commonGPIOFunction.AssignBitsInRegister" t ;; (method)
           "codertarget.connectedIO.tic2000.commonGPIOFunction.clearVar" t ;; (method)
           "codertarget.connectedIO.tic2000.commonGPIOFunction.CombineBitsInRegisterAndCreateMask" t ;; (method)
           "codertarget.connectedIO.tic2000.commonGPIOFunction.connectServer" t ;; (method)
           "codertarget.connectedIO.tic2000.commonGPIOFunction.CreateMask" t ;; (method)
           "codertarget.connectedIO.tic2000.commonGPIOFunction.ePWMUnconfigure" t ;; (method)
           "codertarget.connectedIO.tic2000.commonGPIOFunction.getGPIOCtrlRegAdd" t ;; (method)
           "codertarget.connectedIO.tic2000.commonGPIOFunction.getGPIOQualOpt" t ;; (method)
           "codertarget.connectedIO.tic2000.commonGPIOFunction.getGPIOQualPRDStatus" t ;; (method)
           "codertarget.connectedIO.tic2000.commonGPIOFunction.getSelectedGPIOPinNumbers" t ;; (method)
           "codertarget.connectedIO.tic2000.commonGPIOFunction.GPIOQualSelConfig" t ;; (method)
           "codertarget.connectedIO.tic2000.commonGPIOFunction.isGPIOQualPRDenabled" t ;; (method)
           "codertarget.connectedIO.tic2000.commonGPIOFunction.PositionBitsInRegisterAndCreateMask" t ;; (method)
           "codertarget.connectedIO.tic2000.commonGPIOFunction.QualPrdSetting" t ;; (method)
           "codertarget.connectedIO.tic2000.commonGPIOFunction.readWriteRegisterValue" t ;; (method)
           "codertarget.connectedIO.tic2000.commonGPIOFunction.setgetADCModules" t ;; (method)
           "codertarget.connectedIO.tic2000.commonGPIOFunction.setgetADCRegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.commonGPIOFunction.setgetADCType1and2RegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.commonGPIOFunction.setgetADCTypes" t ;; (method)
           "codertarget.connectedIO.tic2000.commonGPIOFunction.setgetC2000RegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.commonGPIOFunction.setgetCMPALinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.commonGPIOFunction.setgetCMPBLinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.commonGPIOFunction.setgetCMPCLinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.commonGPIOFunction.setgetCMPDLinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.commonGPIOFunction.setgetePWMPinObj" t ;; (method)
           "codertarget.connectedIO.tic2000.commonGPIOFunction.setgetePWMRegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.commonGPIOFunction.setgetEPWMSync" t ;; (method)
           "codertarget.connectedIO.tic2000.commonGPIOFunction.setgetGPIOReadRegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.commonGPIOFunction.setgetGPIOWriteRegObj" t ;; (method)
           "codertarget.connectedIO.tic2000.commonGPIOFunction.setgetIOEnabledObj" t ;; (method)
           "codertarget.connectedIO.tic2000.commonGPIOFunction.setgetIOProtocolObj" t ;; (method)
           "codertarget.connectedIO.tic2000.commonGPIOFunction.setgetModelHandleObj" t ;; (method)
           "codertarget.connectedIO.tic2000.commonGPIOFunction.setgetTBPRDLinkedModules" t ;; (method)
           "codertarget.connectedIO.tic2000.commonGPIOFunction.setgetTransportLayerObj" t ;; (method)
           "codertarget.connectedIO.tic2000.commonGPIOFunction.writeGPIOCtrlRegValue" t ;; (method)
           "codertarget.connectedIO.tic2000.getModelTransportInfo" t ;; (function)
           "codertarget.connectedIO.tic2000.getRegisterAdd" t ;; (function)
           "codertarget.connectedIO.tic2000.updateServer" t ;; (function)
           "codertarget.connectedIO.tic2000.validateConnectedIO" t ;; (function)
           "codertarget.createDriverProject" t ;; (function)
           "codertarget.data.coderTargetDataIncludeWriter" t ;; (class)
           "codertarget.data.getCurrentVersion" t ;; (function)
           "codertarget.data.getData" t ;; (function)
           "codertarget.data.getIOBlocksMode" t ;; (function)
           "codertarget.data.getParameterValue" t ;; (function)
           "codertarget.data.getPeripheralInfo" t ;; (function)
           "codertarget.data.getRTOSBaseRatePriority" t ;; (function)
           "codertarget.data.getSystemClock" t ;; (function)
           "codertarget.data.getVersionFor" t ;; (function)
           "codertarget.data.initializeTargetData" t ;; (function)
           "codertarget.data.isParameterInitialized" t ;; (function)
           "codertarget.data.isValidParameter" t ;; (function)
           "codertarget.data.setData" t ;; (function)
           "codertarget.data.setIOBlocksMode" t ;; (function)
           "codertarget.data.setParameterValue" t ;; (function)
           "codertarget.data.setParameterValueForWidget" t ;; (function)
           "codertarget.data.setPeripheralInfo" t ;; (function)
           "codertarget.data.setVersion" t ;; (function)
           "codertarget.data.update" t ;; (function)
           "codertarget.data.writeCoderTargetDataInclude" t ;; (function)
           "codertarget.DataModelAdapter" t ;; (class)
           "codertarget.forwarding.apply" t ;; (function)
           "codertarget.forwarding.ForwardingInfo" t ;; (class)
           "codertarget.forwarding.ForwardingInfo.addNewElementToArrayProperty" t ;; (method)
           "codertarget.forwarding.ForwardingInfo.createDocument" t ;; (method)
           "codertarget.forwarding.ForwardingInfo.createParameter" t ;; (method)
           "codertarget.forwarding.ForwardingInfo.createParameterGroup" t ;; (method)
           "codertarget.forwarding.ForwardingInfo.getElement" t ;; (method)
           "codertarget.forwarding.ForwardingInfo.read" t ;; (method)
           "codertarget.forwarding.ForwardingInfo.setAttribute" t ;; (method)
           "codertarget.forwarding.ForwardingInfo.setElement" t ;; (method)
           "codertarget.forwarding.ForwardingInfo.write" t ;; (method)
           "codertarget.forwarding.getRegistryFolder" t ;; (function)
           "codertarget.hwmapping.App" t ;; (class)
           "codertarget.hwmapping.App.deleteWaitBar" t ;; (method)
           "codertarget.hwmapping.App.getInstance" t ;; (method)
           "codertarget.hwmapping.App.open" t ;; (method)
           "codertarget.hwmapping.controller.AppController" t ;; (class)
           "codertarget.hwmapping.controller.BrowserPanelController" t ;; (class)
           "codertarget.hwmapping.controller.CPUViewController" t ;; (class)
           "codertarget.hwmapping.controller.FPGAMemoryControllerViewController" t ;; (class)
           "codertarget.hwmapping.controller.FPGAPeripheralsViewController" t ;; (class)
           "codertarget.hwmapping.controller.FPGARegistersViewController" t ;; (class)
           "codertarget.hwmapping.controller.HelpButtonController" t ;; (class)
           "codertarget.hwmapping.controller.PeripheralsViewController" t ;; (class)
           "codertarget.hwmapping.controller.TaskViewController" t ;; (class)
           "codertarget.hwmapping.controller.ToolstripController" t ;; (class)
           "codertarget.hwmapping.controller.ViewController" t ;; (class)
           "codertarget.hwmapping.model.AppModel" t ;; (class)
           "codertarget.hwmapping.model.CustomEventData" t ;; (class)
           "codertarget.hwmapping.model.MemoryMapData" t ;; (class)
           "codertarget.hwmapping.model.PeripheralMapData" t ;; (class)
           "codertarget.hwmapping.model.TaskMapData" t ;; (class)
           "codertarget.hwmapping.view.AppView" t ;; (class)
           "codertarget.hwmapping.view.AppView.CPUIdx" 'property
           "codertarget.hwmapping.view.AppView.EvtIdx" 'property
           "codertarget.hwmapping.view.AppView.GrpIdx" 'property
           "codertarget.hwmapping.view.AppView.IntIdx" 'property
           "codertarget.hwmapping.view.AppView.OrdIdx" 'property
           "codertarget.hwmapping.view.AppView.TskIdx" 'property
           "codertarget.hwmapping.view.AppView.WidgetFactory" 'property
           "codertarget.hwmapping.view.BrowserPanel" t ;; (class)
           "codertarget.hwmapping.view.BrowserPanel.Region" 'property
           "codertarget.hwmapping.view.BrowserPanel.Title" 'property
           "codertarget.hwmapping.view.CPUDocument" t ;; (class)
           "codertarget.hwmapping.view.Details" t ;; (class)
           "codertarget.hwmapping.view.DetailsPanel" t ;; (class)
           "codertarget.hwmapping.view.DetailsPanel.Region" 'property
           "codertarget.hwmapping.view.DetailsPanel.Title" 'property
           "codertarget.hwmapping.view.Document" t ;; (class)
           "codertarget.hwmapping.view.DocumentGroup" t ;; (class)
           "codertarget.hwmapping.view.FPGAMemoryControllerDocument" t ;; (class)
           "codertarget.hwmapping.view.FPGAMemoryControllerDocument.ColumnEditable" 'property
           "codertarget.hwmapping.view.FPGAMemoryControllerDocument.ColumnNames" 'property
           "codertarget.hwmapping.view.FPGAMemoryDetails" t ;; (class)
           "codertarget.hwmapping.view.FPGAPeripheralsDocument" t ;; (class)
           "codertarget.hwmapping.view.FPGAPeripheralsDocument.ColumnEditable" 'property
           "codertarget.hwmapping.view.FPGAPeripheralsDocument.ColumnNames" 'property
           "codertarget.hwmapping.view.FPGARegistersDocument" t ;; (class)
           "codertarget.hwmapping.view.FPGARegistersDocument.ColumnEditable" 'property
           "codertarget.hwmapping.view.FPGARegistersDocument.ColumnNames" 'property
           "codertarget.hwmapping.view.HelpButton" t ;; (class)
           "codertarget.hwmapping.view.PeripheralsDocument" t ;; (class)
           "codertarget.hwmapping.view.Report" t ;; (class)
           "codertarget.hwmapping.view.StatusBar" t ;; (class)
           "codertarget.hwmapping.view.TaskDocument" t ;; (class)
           "codertarget.hwmapping.view.Toolstrip" t ;; (class)
           "codertarget.hwmapping.view.util.SemanticColors" t ;; (class)
           "codertarget.hwmapping.view.util.SemanticColors.applySemanticColor" t ;; (method)
           "codertarget.hwmapping.view.util.SemanticColors.BackgroundColor" 'property
           "codertarget.hwmapping.view.util.SemanticColors.ErrorColor" 'property
           "codertarget.hwmapping.view.util.SemanticColors.getIconIDStyle" t ;; (method)
           "codertarget.hwmapping.view.util.SemanticColors.getSemanticStyle" t ;; (method)
           "codertarget.hwmapping.view.util.SemanticColors.ReadOnlyBackgroundColor" 'property
           "codertarget.hwmapping.view.util.SemanticColors.ReadOnlyFontColor" 'property
           "codertarget.hwmapping.view.util.SemanticColors.TitleBackgroundColor" 'property
           "codertarget.hwmapping.view.util.SemanticColors.WidgetHighlightColor" 'property
           "codertarget.Info" t ;; (class)
           "codertarget.Info.addNewElementToArrayProperty" t ;; (method)
           "codertarget.Info.createDocument" t ;; (method)
           "codertarget.Info.createParameter" t ;; (method)
           "codertarget.Info.createParameterGroup" t ;; (method)
           "codertarget.Info.getElement" t ;; (method)
           "codertarget.Info.read" t ;; (method)
           "codertarget.Info.setAttribute" t ;; (method)
           "codertarget.Info.setElement" t ;; (method)
           "codertarget.Info.write" t ;; (method)
           "codertarget.interrupts.Event" t ;; (class)
           "codertarget.interrupts.Event.convertEventStruct" t ;; (method)
           "codertarget.interrupts.FPGAInterrupts" t ;; (class)
           "codertarget.interrupts.FPGAInterrupts.addNewElementToArrayProperty" t ;; (method)
           "codertarget.interrupts.FPGAInterrupts.createDocument" t ;; (method)
           "codertarget.interrupts.FPGAInterrupts.createParameter" t ;; (method)
           "codertarget.interrupts.FPGAInterrupts.createParameterGroup" t ;; (method)
           "codertarget.interrupts.FPGAInterrupts.getElement" t ;; (method)
           "codertarget.interrupts.FPGAInterrupts.read" t ;; (method)
           "codertarget.interrupts.FPGAInterrupts.setAttribute" t ;; (method)
           "codertarget.interrupts.FPGAInterrupts.setElement" t ;; (method)
           "codertarget.interrupts.FPGAInterrupts.write" t ;; (method)
           "codertarget.interrupts.FPGAInterruptsInfo" t ;; (class)
           "codertarget.interrupts.FPGAInterruptsInfo.addNewElementToArrayProperty" t ;; (method)
           "codertarget.interrupts.FPGAInterruptsInfo.createDocument" t ;; (method)
           "codertarget.interrupts.FPGAInterruptsInfo.createParameter" t ;; (method)
           "codertarget.interrupts.FPGAInterruptsInfo.createParameterGroup" t ;; (method)
           "codertarget.interrupts.FPGAInterruptsInfo.getElement" t ;; (method)
           "codertarget.interrupts.FPGAInterruptsInfo.read" t ;; (method)
           "codertarget.interrupts.FPGAInterruptsInfo.setAttribute" t ;; (method)
           "codertarget.interrupts.FPGAInterruptsInfo.setElement" t ;; (method)
           "codertarget.interrupts.FPGAInterruptsInfo.write" t ;; (method)
           "codertarget.interrupts.getAttribute" t ;; (function)
           "codertarget.interrupts.getFPGAInterupts" t ;; (function)
           "codertarget.interrupts.HWInterruptInfo" t ;; (class)
           "codertarget.interrupts.HWInterruptInfo.addNewElementToArrayProperty" t ;; (method)
           "codertarget.interrupts.HWInterruptInfo.createDocument" t ;; (method)
           "codertarget.interrupts.HWInterruptInfo.createParameter" t ;; (method)
           "codertarget.interrupts.HWInterruptInfo.createParameterGroup" t ;; (method)
           "codertarget.interrupts.HWInterruptInfo.getElement" t ;; (method)
           "codertarget.interrupts.HWInterruptInfo.getNonUniqueEntriesInCell" t ;; (method)
           "codertarget.interrupts.HWInterruptInfo.read" t ;; (method)
           "codertarget.interrupts.HWInterruptInfo.setAttribute" t ;; (method)
           "codertarget.interrupts.HWInterruptInfo.setElement" t ;; (method)
           "codertarget.interrupts.HWInterruptInfo.write" t ;; (method)
           "codertarget.interrupts.Interrupt" t ;; (class)
           "codertarget.interrupts.Interrupt.addNewElementToArrayProperty" t ;; (method)
           "codertarget.interrupts.Interrupt.createDocument" t ;; (method)
           "codertarget.interrupts.Interrupt.createParameter" t ;; (method)
           "codertarget.interrupts.Interrupt.createParameterGroup" t ;; (method)
           "codertarget.interrupts.Interrupt.getElement" t ;; (method)
           "codertarget.interrupts.Interrupt.read" t ;; (method)
           "codertarget.interrupts.Interrupt.setAttribute" t ;; (method)
           "codertarget.interrupts.Interrupt.setElement" t ;; (method)
           "codertarget.interrupts.Interrupt.write" t ;; (method)
           "codertarget.interrupts.InterruptGroup" t ;; (class)
           "codertarget.interrupts.InterruptGroup.addNewElementToArrayProperty" t ;; (method)
           "codertarget.interrupts.InterruptGroup.createDocument" t ;; (method)
           "codertarget.interrupts.InterruptGroup.createParameter" t ;; (method)
           "codertarget.interrupts.InterruptGroup.createParameterGroup" t ;; (method)
           "codertarget.interrupts.InterruptGroup.getElement" t ;; (method)
           "codertarget.interrupts.InterruptGroup.read" t ;; (method)
           "codertarget.interrupts.InterruptGroup.setAttribute" t ;; (method)
           "codertarget.interrupts.InterruptGroup.setElement" t ;; (method)
           "codertarget.interrupts.InterruptGroup.write" t ;; (method)
           "codertarget.interrupts.rearrangeIrqPriority" t ;; (function)
           "codertarget.ipc.getTargetHardwareIPC" t ;; (function)
           "codertarget.ipc.IPCInfo" t ;; (class)
           "codertarget.ipc.IPCInfo.addNewElementToArrayProperty" t ;; (method)
           "codertarget.ipc.IPCInfo.createDocument" t ;; (method)
           "codertarget.ipc.IPCInfo.createParameter" t ;; (method)
           "codertarget.ipc.IPCInfo.createParameterGroup" t ;; (method)
           "codertarget.ipc.IPCInfo.getElement" t ;; (method)
           "codertarget.ipc.IPCInfo.read" t ;; (method)
           "codertarget.ipc.IPCInfo.setAttribute" t ;; (method)
           "codertarget.ipc.IPCInfo.setElement" t ;; (method)
           "codertarget.ipc.IPCInfo.write" t ;; (method)
           "codertarget.ipc.IPCTypes" t ;; (class)
           "codertarget.ipc.IPCTypes.Pipes" 'enumeration
           "codertarget.ipc.IPCTypes.Semaphores" 'enumeration
           "codertarget.ipc.IPCTypes.SharedMemory" 'enumeration
           "codertarget.ipc.IPCTypes.Sockets" 'enumeration
           "codertarget.ipc.IPCTypes.UNSPECIFIED" 'enumeration
           "codertarget.model.getBuildSingleExecutable" t ;; (function)
           "codertarget.model.getCustomLinkerFile" t ;; (function)
           "codertarget.model.getDeviceSeries" t ;; (function)
           "codertarget.model.getFPGADesignDiagnosticLevel" t ;; (function)
           "codertarget.model.getProcessingUnit" t ;; (function)
           "codertarget.model.getProcessingUnitID" t ;; (function)
           "codertarget.model.getUseCustomLinker" t ;; (function)
           "codertarget.model.setBuildSingleExecutable" t ;; (function)
           "codertarget.model.setCustomLinkerFile" t ;; (function)
           "codertarget.model.setDeviceSeries" t ;; (function)
           "codertarget.model.setFPGADesignDiagnosticLevel" t ;; (function)
           "codertarget.model.setProcessingUnit" t ;; (function)
           "codertarget.model.setUseCustomLinker" t ;; (function)
           "codertarget.options.standard" t ;; (function)
           "codertarget.parameter.getBuildOptionsEntries" t ;; (function)
           "codertarget.parameter.getParameterDialogInfo" t ;; (function)
           "codertarget.parameter.ParameterInfo" t ;; (class)
           "codertarget.parameter.ParameterInfo.addNewElementToArrayProperty" t ;; (method)
           "codertarget.parameter.ParameterInfo.createDocument" t ;; (method)
           "codertarget.parameter.ParameterInfo.createParameter" t ;; (method)
           "codertarget.parameter.ParameterInfo.createParameterGroup" t ;; (method)
           "codertarget.parameter.ParameterInfo.getElement" t ;; (method)
           "codertarget.parameter.ParameterInfo.read" t ;; (method)
           "codertarget.parameter.ParameterInfo.setAttribute" t ;; (method)
           "codertarget.parameter.ParameterInfo.setElement" t ;; (method)
           "codertarget.parameter.ParameterInfo.write" t ;; (method)
           "codertarget.peripherals.AppModel" t ;; (class)
           "codertarget.peripherals.AppModel.isProcessorModel" t ;; (method)
           "codertarget.peripherals.AppWidgetFactory" t ;; (class)
           "codertarget.peripherals.AppWidgetFactory.createParameterGrid" t ;; (method)
           "codertarget.peripherals.AppWidgetFactory.createParameterGroup" t ;; (method)
           "codertarget.peripherals.AppWidgetFactory.createParameterTab" t ;; (method)
           "codertarget.peripherals.AppWidgetFactory.createParameterTabGroup" t ;; (method)
           "codertarget.peripherals.AppWidgetFactory.createTasksGrid" t ;; (method)
           "codertarget.peripherals.AppWidgetFactory.createTasksTable" t ;; (method)
           "codertarget.peripherals.AppWidgetFactory.getBackgroundColorForWidgetHighlighting" t ;; (method)
           "codertarget.peripherals.AppWidgetFactory.getBackgroundColorFromParent" t ;; (method)
           "codertarget.peripherals.getPeripheralInfo" t ;; (function)
           "codertarget.peripherals.PeripheralCodegenHook" t ;; (class)
           "codertarget.peripherals.PeripheralInfo" t ;; (class)
           "codertarget.peripherals.PeripheralInfo.addNewElementToArrayProperty" t ;; (method)
           "codertarget.peripherals.PeripheralInfo.createDocument" t ;; (method)
           "codertarget.peripherals.PeripheralInfo.createParameter" t ;; (method)
           "codertarget.peripherals.PeripheralInfo.createParameterGroup" t ;; (method)
           "codertarget.peripherals.PeripheralInfo.getElement" t ;; (method)
           "codertarget.peripherals.PeripheralInfo.read" t ;; (method)
           "codertarget.peripherals.PeripheralInfo.setAttribute" t ;; (method)
           "codertarget.peripherals.PeripheralInfo.setElement" t ;; (method)
           "codertarget.peripherals.PeripheralInfo.write" t ;; (method)
           "codertarget.peripherals.register.Parameter" t ;; (class)
           "codertarget.peripherals.register.ParameterGroup" t ;; (class)
           "codertarget.peripherals.register.Peripheral" t ;; (class)
           "codertarget.peripherals.register.PeripheralBlock" t ;; (class)
           "codertarget.peripherals.register.PeripheralGroup" t ;; (class)
           "codertarget.peripherals.ReportGenerator" t ;; (class)
           "codertarget.peripherals.TIDelfinoF28379DLaunchPad" t ;; (class)
           "codertarget.peripherals.TIDelfinoF28379DLaunchPad.validatePeripheralConfig" t ;; (method)
           "codertarget.peripherals.TIDelfinoF2837xD" t ;; (class)
           "codertarget.peripherals.TIDelfinoF2837xD.validatePeripheralConfig" t ;; (method)
           "codertarget.peripherals.UIComponentFactory" t ;; (class)
           "codertarget.peripherals.UIComponentFactory.createAccordian" t ;; (method)
           "codertarget.peripherals.UIComponentFactory.createAccordianPanel" t ;; (method)
           "codertarget.peripherals.UIComponentFactory.createCheckbox" t ;; (method)
           "codertarget.peripherals.UIComponentFactory.createDropdown" t ;; (method)
           "codertarget.peripherals.UIComponentFactory.createEditText" t ;; (method)
           "codertarget.peripherals.UIComponentFactory.createGridLayout" t ;; (method)
           "codertarget.peripherals.UIComponentFactory.createLabel" t ;; (method)
           "codertarget.peripherals.UIComponentFactory.createPanel" t ;; (method)
           "codertarget.peripherals.UIComponentFactory.createTable" t ;; (method)
           "codertarget.peripherals.UIComponentFactory.createTree" t ;; (method)
           "codertarget.peripherals.utils.addMissingFields" t ;; (function)
           "codertarget.peripherals.utils.getBlockPath" t ;; (function)
           "codertarget.peripherals.utils.getBlockSID" t ;; (function)
           "codertarget.peripherals.utils.getDefFileNameForBoard" t ;; (function)
           "codertarget.peripherals.utils.getModelNameSID" t ;; (function)
           "codertarget.peripherals.utils.getPeripheralDataHdrName" t ;; (function)
           "codertarget.peripherals.utils.getPeripheralDataStructType" t ;; (function)
           "codertarget.peripherals.utils.getPeripheralEntries" t ;; (function)
           "codertarget.peripherals.utils.getPeripheralInfoFromRefModels" t ;; (function)
           "codertarget.peripherals.utils.isPeripheralUsed" t ;; (function)
           "codertarget.peripherals.utils.mustBeNonEmptyText" t ;; (function)
           "codertarget.peripherals.utils.openPeripheralConfiguration" t ;; (function)
           "codertarget.peripherals.utils.openPeripheralConfigurationFromBlockCb" t ;; (function)
           "codertarget.peripherals.utils.peripheralBlkCopyFcn" t ;; (function)
           "codertarget.peripherals.utils.peripheralBlkDeleteFcn" t ;; (function)
           "codertarget.peripherals.utils.peripheralBlkLoadFcn" t ;; (function)
           "codertarget.peripherals.utils.peripheralBlkPreSaveFcn" t ;; (function)
           "codertarget.peripherals.utils.PeripheralsConfigCheck" t ;; (class)
           "codertarget.peripherals.utils.setBlockMaskButtonVisibility" t ;; (function)
           "codertarget.peripherals.utils.updateSavedSID" t ;; (function)
           "codertarget.postCodeGenHookCommand" t ;; (function)
           "codertarget.postCodeGenHookMATLABTarget" t ;; (function)
           "codertarget.profile.codeGenHook" t ;; (function)
           "codertarget.profile.getData" t ;; (function)
           "codertarget.profile.Timer" t ;; (class)
           "codertarget.registers.RegisterGroup" t ;; (class)
           "codertarget.registers.RegisterGroup.addNewElementToArrayProperty" t ;; (method)
           "codertarget.registers.RegisterGroup.createDocument" t ;; (method)
           "codertarget.registers.RegisterGroup.createParameter" t ;; (method)
           "codertarget.registers.RegisterGroup.createParameterGroup" t ;; (method)
           "codertarget.registers.RegisterGroup.getElement" t ;; (method)
           "codertarget.registers.RegisterGroup.read" t ;; (method)
           "codertarget.registers.RegisterGroup.setAttribute" t ;; (method)
           "codertarget.registers.RegisterGroup.setElement" t ;; (method)
           "codertarget.registers.RegisterGroup.write" t ;; (method)
           "codertarget.registers.RegisterStruct" t ;; (class)
           "codertarget.registers.RegisterStruct.addNewElementToArrayProperty" t ;; (method)
           "codertarget.registers.RegisterStruct.createDocument" t ;; (method)
           "codertarget.registers.RegisterStruct.createParameter" t ;; (method)
           "codertarget.registers.RegisterStruct.createParameterGroup" t ;; (method)
           "codertarget.registers.RegisterStruct.getElement" t ;; (method)
           "codertarget.registers.RegisterStruct.read" t ;; (method)
           "codertarget.registers.RegisterStruct.setAttribute" t ;; (method)
           "codertarget.registers.RegisterStruct.setElement" t ;; (method)
           "codertarget.registers.RegisterStruct.write" t ;; (method)
           "codertarget.registers.TargetRegisterInfo" t ;; (class)
           "codertarget.registers.TargetRegisterInfo.addNewElementToArrayProperty" t ;; (method)
           "codertarget.registers.TargetRegisterInfo.createDocument" t ;; (method)
           "codertarget.registers.TargetRegisterInfo.createParameter" t ;; (method)
           "codertarget.registers.TargetRegisterInfo.createParameterGroup" t ;; (method)
           "codertarget.registers.TargetRegisterInfo.getElement" t ;; (method)
           "codertarget.registers.TargetRegisterInfo.read" t ;; (method)
           "codertarget.registers.TargetRegisterInfo.setAttribute" t ;; (method)
           "codertarget.registers.TargetRegisterInfo.setElement" t ;; (method)
           "codertarget.registers.TargetRegisterInfo.write" t ;; (method)
           "codertarget.registry.ADCAcqWindowValueCallback" t ;; (function)
           "codertarget.registry.ADCClockDisplayCallback" t ;; (function)
           "codertarget.registry.autosetPLL" t ;; (function)
           "codertarget.registry.auxilliaryClockVisibilityEnable" t ;; (function)
           "codertarget.registry.BootloaderCompatibleOS" t ;; (function)
           "codertarget.registry.BootloaderLoadOptionsVisible" t ;; (function)
           "codertarget.registry.BootloaderOptionsVisible" t ;; (function)
           "codertarget.registry.BootloaderVisible" t ;; (function)
           "codertarget.registry.CANConfigurationVisibility" t ;; (function)
           "codertarget.registry.CCSHWConfigurationFileBrowseCallback" t ;; (function)
           "codertarget.registry.CCSHWConfigurationFileEditCallback" t ;; (function)
           "codertarget.registry.cfgParameterEnable" t ;; (function)
           "codertarget.registry.checkCLBFileEntries" t ;; (function)
           "codertarget.registry.claLSRAMChangeCallback" t ;; (function)
           "codertarget.registry.claLSRAMMemoryConfig" t ;; (function)
           "codertarget.registry.CLBClockConfiguration" t ;; (function)
           "codertarget.registry.CLBConfigurationFileEditCallback" t ;; (function)
           "codertarget.registry.CLBConfigurationHeaderFileBrowseCallback" t ;; (function)
           "codertarget.registry.CLBConfigurationSourceFileBrowseCallback" t ;; (function)
           "codertarget.registry.CLBFieldEnable" t ;; (function)
           "codertarget.registry.Clocking_SysCLKControl_UICallback" t ;; (function)
           "codertarget.registry.clockParameterDefaultValue" t ;; (function)
           "codertarget.registry.CMPSS_COMPx_DFx_Enable" t ;; (function)
           "codertarget.registry.CMPSS_COMPx_Enable" t ;; (function)
           "codertarget.registry.CMPSSEnable" t ;; (function)
           "codertarget.registry.commonLinkerFileSelect" t ;; (function)
           "codertarget.registry.CPUSelectionVisibility" t ;; (function)
           "codertarget.registry.CustomLinkerEnable" t ;; (function)
           "codertarget.registry.DeviceIDSelectionCallback" t ;; (function)
           "codertarget.registry.DMAEnable" t ;; (function)
           "codertarget.registry.DMAExtPinEnable" t ;; (function)
           "codertarget.registry.DMAOneShotEnable" t ;; (function)
           "codertarget.registry.DMASyncModeEnable" t ;; (function)
           "codertarget.registry.eCANBaudRateCalc" t ;; (function)
           "codertarget.registry.eCANSAMCallback" t ;; (function)
           "codertarget.registry.eCANTSEGCallback" t ;; (function)
           "codertarget.registry.EMIF_UICallback" t ;; (function)
           "codertarget.registry.EMIFClockCallback" t ;; (function)
           "codertarget.registry.EMIFDataWidth" t ;; (function)
           "codertarget.registry.EMIFEnable" t ;; (function)
           "codertarget.registry.EMIFWaitEnable" t ;; (function)
           "codertarget.registry.enableMCANFilterForXCP" t ;; (function)
           "codertarget.registry.EnableWatchDog" t ;; (function)
           "codertarget.registry.ExtModeCloseHook" t ;; (function)
           "codertarget.registry.ExtModePreConnectHook" t ;; (function)
           "codertarget.registry.ExtModeSetUpHook" t ;; (function)
           "codertarget.registry.getDigitalOutputPinRange" t ;; (function)
           "codertarget.registry.getExtModeCANBusSpeed" t ;; (function)
           "codertarget.registry.getExtModeHostBaud" t ;; (function)
           "codertarget.registry.getFileName" t ;; (function)
           "codertarget.registry.getGPIONumberCallback" t ;; (function)
           "codertarget.registry.getInputXbarInitValue" t ;; (function)
           "codertarget.registry.getMaximumAllowedFreq" t ;; (function)
           "codertarget.registry.getMinimumAllowedFrequency" t ;; (function)
           "codertarget.registry.getOutputXbarNum" t ;; (function)
           "codertarget.registry.getPinMuxVal" t ;; (function)
           "codertarget.registry.getSDFMConfigParameters" t ;; (function)
           "codertarget.registry.I2CBaudRateCalc" t ;; (function)
           "codertarget.registry.I2COwnAddressCallback" t ;; (function)
           "codertarget.registry.inputXbarChangeCallback" t ;; (function)
           "codertarget.registry.isInvalidRegisterUseCase" t ;; (function)
           "codertarget.registry.linkerFileSelect" t ;; (function)
           "codertarget.registry.LinkerOBJBrowseCallback" t ;; (function)
           "codertarget.registry.LinkerOBJEditCallback" t ;; (function)
           "codertarget.registry.LinkerSelectCallback" t ;; (function)
           "codertarget.registry.MasterClkDividerEnable" t ;; (function)
           "codertarget.registry.MasterClkVisibility" t ;; (function)
           "codertarget.registry.MemoryAllocateFuncs" t ;; (function)
           "codertarget.registry.muxInputChangeCallback" t ;; (function)
           "codertarget.registry.OSCCLKEnable" t ;; (function)
           "codertarget.registry.overrunDetectionVisibleCallback" t ;; (function)
           "codertarget.registry.PINSelect" t ;; (function)
           "codertarget.registry.PLLEnable" t ;; (function)
           "codertarget.registry.qualificationSamplingPeriodCallback" t ;; (function)
           "codertarget.registry.refreshMuxSelect" t ;; (function)
           "codertarget.registry.register281xQEP" t ;; (function)
           "codertarget.registry.registerC2806xePWM" t ;; (function)
           "codertarget.registry.registerC280xADCBlocks" t ;; (function)
           "codertarget.registry.registerC280xCANBlocks" t ;; (function)
           "codertarget.registry.registerC280xeCAPBlocks" t ;; (function)
           "codertarget.registry.registerC280xGPIOBlocks" t ;; (function)
           "codertarget.registry.registerC280xi2cBlocks" t ;; (function)
           "codertarget.registry.registerC280xi2cRxBlocks" t ;; (function)
           "codertarget.registry.registerC280xi2cTxBlocks" t ;; (function)
           "codertarget.registry.registerC280xSCIRxBlocks" t ;; (function)
           "codertarget.registry.registerC280xSCITxBlocks" t ;; (function)
           "codertarget.registry.registerC280xSPIRxBlocks" t ;; (function)
           "codertarget.registry.registerC280xSPITxBlocks" t ;; (function)
           "codertarget.registry.registerC280xWatchdogBlocks" t ;; (function)
           "codertarget.registry.registerC281xADCBlocks" t ;; (function)
           "codertarget.registry.registerC281xCAPBlocks" t ;; (function)
           "codertarget.registry.registerC281xPWM" t ;; (function)
           "codertarget.registry.registerC28xEVTimerBlocks" t ;; (function)
           "codertarget.registry.registerC28xHardwareProfilerBlocks" t ;; (function)
           "codertarget.registry.registerC28xHWInterruptBlocks" t ;; (function)
           "codertarget.registry.registerC28xNonPeripheralBlocks" t ;; (function)
           "codertarget.registry.registerC28xPeripheralBlocks" t ;; (function)
           "codertarget.registry.registerC28xSWIntTrigBlocks" t ;; (function)
           "codertarget.registry.registerC80xePWM" t ;; (function)
           "codertarget.registry.registerCLABlocks" t ;; (function)
           "codertarget.registry.registerCMIPCBlocks" t ;; (function)
           "codertarget.registry.registereQEP" t ;; (function)
           "codertarget.registry.registerIdleTaskBlocks" t ;; (function)
           "codertarget.registry.registerIPCBlocks" t ;; (function)
           "codertarget.registry.registerLINRxBlocks" t ;; (function)
           "codertarget.registry.registerLINTxBlocks" t ;; (function)
           "codertarget.registry.registerPiccoloADCBlocks" t ;; (function)
           "codertarget.registry.registerPiccoloPWMBlocks" t ;; (function)
           "codertarget.registry.registerSPI" t ;; (function)
           "codertarget.registry.registerSPI_Receive" t ;; (function)
           "codertarget.registry.registerSPI_Transmit" t ;; (function)
           "codertarget.registry.registerTIC2000HWInterruptBlocks" t ;; (function)
           "codertarget.registry.RxInterruptEnable" t ;; (function)
           "codertarget.registry.SCIBaudRateCalc" t ;; (function)
           "codertarget.registry.SCIBaudRateCalcExternalMode" t ;; (function)
           "codertarget.registry.SCIInterruptVisible" t ;; (function)
           "codertarget.registry.SDCardLogging_UICallback" t ;; (function)
           "codertarget.registry.SDCardLoggingEnable" t ;; (function)
           "codertarget.registry.SDFMEnable_Parameter" t ;; (function)
           "codertarget.registry.serialConfigurationVisibility" t ;; (function)
           "codertarget.registry.serialPortChangeCallback" t ;; (function)
           "codertarget.registry.serialPortEntriesCallback" t ;; (function)
           "codertarget.registry.serialPortRefreshCallback" t ;; (function)
           "codertarget.registry.serialPortValueCallback" t ;; (function)
           "codertarget.registry.setC28xCLASubSystem" t ;; (function)
           "codertarget.registry.SetExtModeTrigDuration" t ;; (function)
           "codertarget.registry.SlaveAddressRegisterEnable" t ;; (function)
           "codertarget.registry.SlaveDataEnable" t ;; (function)
           "codertarget.registry.SPIBaudRateCalc" t ;; (function)
           "codertarget.registry.SPIBaudrateVisibleCallback" t ;; (function)
           "codertarget.registry.SPIFIFOEnable" t ;; (function)
           "codertarget.registry.SPIInterruptEnable" t ;; (function)
           "codertarget.registry.SPIPINSelect" t ;; (function)
           "codertarget.registry.SPIThreeWirePinEnable" t ;; (function)
           "codertarget.registry.staticMemorySizeforSDCard" t ;; (function)
           "codertarget.registry.SysInterruptEnable" t ;; (function)
           "codertarget.registry.TxInterruptEnable" t ;; (function)
           "codertarget.registry.validateFunctionName" t ;; (function)
           "codertarget.registry.validateSCIpinAssignmentConnectedIO" t ;; (function)
           "codertarget.registry.VerboseCheck" t ;; (function)
           "codertarget.registry.visibilityEnable" t ;; (function)
           "codertarget.registry.VRef_Enable" t ;; (function)
           "codertarget.registry.vrefChangeCallback" t ;; (function)
           "codertarget.registry.WDClockCalc" t ;; (function)
           "codertarget.registry.WDCounterClock" t ;; (function)
           "codertarget.registry.XBAREnable" t ;; (function)
           "codertarget.registry.xcpExternalModeHardwareTimerData" t ;; (function)
           "codertarget.resourcemanager.add" t ;; (function)
           "codertarget.resourcemanager.addunique" t ;; (function)
           "codertarget.resourcemanager.get" t ;; (function)
           "codertarget.resourcemanager.getAllResources" t ;; (function)
           "codertarget.resourcemanager.getarr" t ;; (function)
           "codertarget.resourcemanager.increment" t ;; (function)
           "codertarget.resourcemanager.isblockregistered" t ;; (function)
           "codertarget.resourcemanager.isregistered" t ;; (function)
           "codertarget.resourcemanager.register" t ;; (function)
           "codertarget.resourcemanager.registerblock" t ;; (function)
           "codertarget.resourcemanager.resetAllResources" t ;; (function)
           "codertarget.resourcemanager.set" t ;; (function)
           "codertarget.resourcemanager.setAllResources" t ;; (function)
           "codertarget.resourcemanager.unregister" t ;; (function)
           "codertarget.rtos.getBaseRateTriggers" t ;; (function)
           "codertarget.rtos.getDefines" t ;; (function)
           "codertarget.rtos.getEventAddBlockCall" t ;; (function)
           "codertarget.rtos.getEventAddHandlerCall" t ;; (function)
           "codertarget.rtos.getEventDataType" t ;; (function)
           "codertarget.rtos.getEventRestoreHandlerCall" t ;; (function)
           "codertarget.rtos.getEventSendCall" t ;; (function)
           "codertarget.rtos.getEventWaitCall" t ;; (function)
           "codertarget.rtos.getIncludeFiles" t ;; (function)
           "codertarget.rtos.getIncludePaths" t ;; (function)
           "codertarget.rtos.getInitCall" t ;; (function)
           "codertarget.rtos.getNamesOfSupportedRTOSForHardwareName" t ;; (function)
           "codertarget.rtos.getPropertyForModel" t ;; (function)
           "codertarget.rtos.getSemaphoreDataType" t ;; (function)
           "codertarget.rtos.getSemaphoreDestroyCall" t ;; (function)
           "codertarget.rtos.getSemaphoreInitCall" t ;; (function)
           "codertarget.rtos.getSemaphorePostCall" t ;; (function)
           "codertarget.rtos.getSemaphoreWaitCall" t ;; (function)
           "codertarget.rtos.getSourceFiles" t ;; (function)
           "codertarget.rtos.getSupportedRTOSInfoForHardwareName" t ;; (function)
           "codertarget.rtos.getTargetHardwareRTOS" t ;; (function)
           "codertarget.rtos.getTaskCreateCall" t ;; (function)
           "codertarget.rtos.getTaskDataType" t ;; (function)
           "codertarget.rtos.getTaskExitCall" t ;; (function)
           "codertarget.rtos.getTaskJoinCall" t ;; (function)
           "codertarget.rtos.RTOSInfo" t ;; (class)
           "codertarget.rtos.RTOSInfo.addNewElementToArrayProperty" t ;; (method)
           "codertarget.rtos.RTOSInfo.createDocument" t ;; (method)
           "codertarget.rtos.RTOSInfo.createParameter" t ;; (method)
           "codertarget.rtos.RTOSInfo.createParameterGroup" t ;; (method)
           "codertarget.rtos.RTOSInfo.getElement" t ;; (method)
           "codertarget.rtos.RTOSInfo.isValidFuncCallIncludingArgs" t ;; (method)
           "codertarget.rtos.RTOSInfo.myGetElementArray" t ;; (method)
           "codertarget.rtos.RTOSInfo.myGetSingleElement" t ;; (method)
           "codertarget.rtos.RTOSInfo.mySetElementArray" t ;; (method)
           "codertarget.rtos.RTOSInfo.mySetSingleElement" t ;; (method)
           "codertarget.rtos.RTOSInfo.read" t ;; (method)
           "codertarget.rtos.RTOSInfo.setAttribute" t ;; (method)
           "codertarget.rtos.RTOSInfo.setElement" t ;; (method)
           "codertarget.rtos.RTOSInfo.write" t ;; (method)
           "codertarget.scheduler.getSupportedSchedulerNames" t ;; (function)
           "codertarget.scheduler.getTargetHardwareScheduler" t ;; (function)
           "codertarget.scheduler.getTargetHardwareSchedulerConfigure" t ;; (function)
           "codertarget.scheduler.getTargetHardwareSchedulerInterruptDisable" t ;; (function)
           "codertarget.scheduler.getTargetHardwareSchedulerInterruptEnable" t ;; (function)
           "codertarget.scheduler.getTargetHardwareSchedulerStopConfigure" t ;; (function)
           "codertarget.scheduler.SchedulerInfo" t ;; (class)
           "codertarget.scheduler.SchedulerInfo.addNewElementToArrayProperty" t ;; (method)
           "codertarget.scheduler.SchedulerInfo.createDocument" t ;; (method)
           "codertarget.scheduler.SchedulerInfo.createParameter" t ;; (method)
           "codertarget.scheduler.SchedulerInfo.createParameterGroup" t ;; (method)
           "codertarget.scheduler.SchedulerInfo.getElement" t ;; (method)
           "codertarget.scheduler.SchedulerInfo.read" t ;; (method)
           "codertarget.scheduler.SchedulerInfo.setAttribute" t ;; (method)
           "codertarget.scheduler.SchedulerInfo.setElement" t ;; (method)
           "codertarget.scheduler.SchedulerInfo.write" t ;; (method)
           "codertarget.scheduler.targetHardwareHasScheduler" t ;; (function)
           "CoderTarget.SettingsController.getDialogCustomizations" t ;; (function)
           "CoderTarget.SettingsController.getName" t ;; (function)
           "CoderTarget.SettingsController.kernelLatencyChangedCallback" t ;; (function)
           "CoderTarget.SettingsController.processingUnitChangedCallback" t ;; (function)
           "CoderTarget.SettingsController.rtosChangedCallback" t ;; (function)
           "CoderTarget.SettingsController.update" t ;; (function)
           "CoderTarget.SettingsController.widgetChangedCallback" t ;; (function)
           "codertarget.Sink" t ;; (class)
           "codertarget.Sink.getDescriptiveName" t ;; (method)
           "codertarget.Sink.isSupportedContext" t ;; (method)
           "codertarget.Sink.updateBuildInfo" t ;; (method)
           "codertarget.sltoolstrip.EmbeddedHardwareBoardContext" t ;; (class)
           "codertarget.sltoolstrip.EmbeddedHardwareBoardContext.batchModeHardwareBoardActionCB" t ;; (method)
           "codertarget.sltoolstrip.EmbeddedHardwareBoardContext.buildDeployHardwareBoardActionCB" t ;; (method)
           "codertarget.sltoolstrip.EmbeddedHardwareBoardContext.buildDeployStartHardwareBoardActionCB" t ;; (method)
           "codertarget.sltoolstrip.EmbeddedHardwareBoardContext.buildDeployStartHardwareBoardActionRF" t ;; (method)
           "codertarget.sltoolstrip.EmbeddedHardwareBoardContext.buildExtModeHardwareBoardActionCB" t ;; (method)
           "codertarget.sltoolstrip.EmbeddedHardwareBoardContext.buildHardwareBoardActionCB" t ;; (method)
           "codertarget.sltoolstrip.EmbeddedHardwareBoardContext.configureBuildCB" t ;; (method)
           "codertarget.sltoolstrip.EmbeddedHardwareBoardContext.configureBuildDeployStartCB" t ;; (method)
           "codertarget.sltoolstrip.EmbeddedHardwareBoardContext.configureExtModeCB" t ;; (method)
           "codertarget.sltoolstrip.EmbeddedHardwareBoardContext.configureExtModeRF" t ;; (method)
           "codertarget.sltoolstrip.EmbeddedHardwareBoardContext.connectModelExtModeHardwareBoardActionCB" t ;; (method)
           "codertarget.sltoolstrip.EmbeddedHardwareBoardContext.connectTargetHardwareBoardActionCB" t ;; (method)
           "codertarget.sltoolstrip.EmbeddedHardwareBoardContext.constructCount" t ;; (method)
           "codertarget.sltoolstrip.EmbeddedHardwareBoardContext.deleteCount" t ;; (method)
           "codertarget.sltoolstrip.EmbeddedHardwareBoardContext.deployExtModeHardwareBoardActionCB" t ;; (method)
           "codertarget.sltoolstrip.EmbeddedHardwareBoardContext.disconnectModelExtModeHardwareBoardActionCB" t ;; (method)
           "codertarget.sltoolstrip.EmbeddedHardwareBoardContext.disconnectTargetHardwareBoardActionCB" t ;; (method)
           "codertarget.sltoolstrip.EmbeddedHardwareBoardContext.extModeCtrlPanelCB" t ;; (method)
           "codertarget.sltoolstrip.EmbeddedHardwareBoardContext.extModeHardwareBoardActionCB" t ;; (method)
           "codertarget.sltoolstrip.EmbeddedHardwareBoardContext.extModeHardwareBoardActionRF" t ;; (method)
           "codertarget.sltoolstrip.EmbeddedHardwareBoardContext.isDialogSupported" t ;; (method)
           "codertarget.sltoolstrip.EmbeddedHardwareBoardContext.isSoCBProfilingSupported" t ;; (method)
           "codertarget.sltoolstrip.EmbeddedHardwareBoardContext.launchHardwareMappingCB" t ;; (method)
           "codertarget.sltoolstrip.EmbeddedHardwareBoardContext.launchHardwareSetupCB" t ;; (method)
           "codertarget.sltoolstrip.EmbeddedHardwareBoardContext.openDeviceDriverApp" t ;; (method)
           "codertarget.sltoolstrip.EmbeddedHardwareBoardContext.openModelConfigParamHardwareBoardActionCB" t ;; (method)
           "codertarget.sltoolstrip.EmbeddedHardwareBoardContext.openSoCPerformanceAppCb" t ;; (method)
           "codertarget.sltoolstrip.EmbeddedHardwareBoardContext.removeConfiguration" t ;; (method)
           "codertarget.sltoolstrip.EmbeddedHardwareBoardContext.restartExtModeHardwareBoardActionCB" t ;; (method)
           "codertarget.sltoolstrip.EmbeddedHardwareBoardContext.selectIOModeConnectedCB" t ;; (method)
           "codertarget.sltoolstrip.EmbeddedHardwareBoardContext.selectIOModeDeployedCB" t ;; (method)
           "codertarget.sltoolstrip.EmbeddedHardwareBoardContext.setupConfigSet" t ;; (method)
           "codertarget.sltoolstrip.EmbeddedHardwareBoardContext.showMATLABWorkspaceCB" t ;; (method)
           "codertarget.sltoolstrip.EmbeddedHardwareBoardContext.startExtModeHardwareBoardActionCB" t ;; (method)
           "codertarget.sltoolstrip.EmbeddedHardwareBoardContext.startStopConnectedIOCB" t ;; (method)
           "codertarget.sltoolstrip.EmbeddedHardwareBoardContext.startStopConnectedIORF" t ;; (method)
           "codertarget.sltoolstrip.EmbeddedHardwareBoardContext.stopExtModeHardwareBoardActionCB" t ;; (method)
           "codertarget.sltoolstrip.EmbeddedHardwareBoardContext.toggleSoCProfilingStateCB" t ;; (method)
           "codertarget.sltoolstrip.EmbeddedHardwareBoardContext.updateAllParametersHardwareBoardActionCB" t ;; (method)
           "codertarget.sltoolstrip.EmbeddedHardwareBoardContext.updateEnableSoCExecutionReportRF" t ;; (method)
           "codertarget.sltoolstrip.EmbeddedHardwareBoardContext.updateEnableSoCProfilingRF" t ;; (method)
           "codertarget.sltoolstrip.EmbeddedHardwareBoardContext.updateHardwareBoardSettingsRF" t ;; (method)
           "codertarget.sltoolstrip.EmbeddedHardwareBoardHandler" t ;; (class)
           "codertarget.sltoolstrip.SetupConfigSetDialog" t ;; (class)
           "codertarget.sltoolstrip.SetupConfigSetDialog.closeModelDialogs" t ;; (method)
           "codertarget.sltoolstrip.SetupConfigSetDialog.getDialogTag" t ;; (method)
           "codertarget.Source" t ;; (class)
           "codertarget.Source.getDescriptiveName" t ;; (method)
           "codertarget.Source.isSupportedContext" t ;; (method)
           "codertarget.Source.updateBuildInfo" t ;; (method)
           "codertarget.target.checkReleaseCompatibility" t ;; (function)
           "codertarget.target.codeGenEntryHook" t ;; (function)
           "codertarget.target.CoderTargetConfigurationMarshallingPlugin" t ;; (class)
           "codertarget.target.configureModelIfRequired" t ;; (function)
           "codertarget.target.copyInactiveCodeMappingsIfNeeded" t ;; (function)
           "codertarget.target.getAllHardwareBoards" t ;; (function)
           "codertarget.target.getAttributeRegistryFolder" t ;; (function)
           "codertarget.target.getHardwareName" t ;; (function)
           "codertarget.target.getIsOneClickEnabled" t ;; (function)
           "codertarget.target.getParameterRegistryFolder" t ;; (function)
           "codertarget.target.getPeripheralRegistryFolder" t ;; (function)
           "codertarget.target.getReferenceTargets" t ;; (function)
           "codertarget.target.getRegisteredTargetFolders" t ;; (function)
           "codertarget.target.getRegisteredTargetNames" t ;; (function)
           "codertarget.target.getRegisteredTargets" t ;; (function)
           "codertarget.target.getRTOSRegistryFolder" t ;; (function)
           "codertarget.target.getSchedulerRegistryFolder" t ;; (function)
           "codertarget.target.getTargetCertificate" t ;; (function)
           "codertarget.target.getTargetFolder" t ;; (function)
           "codertarget.target.getTargetforHardwareName" t ;; (function)
           "codertarget.target.getTargetHardware" t ;; (function)
           "codertarget.target.getTargetHardwareDisplayNameFromName" t ;; (function)
           "codertarget.target.getTargetHardwareInfo" t ;; (function)
           "codertarget.target.getTargetHardwareName" t ;; (function)
           "codertarget.target.getTargetHardwareNameFromDisplayName" t ;; (function)
           "codertarget.target.getTargetHardwareRegistryFolder" t ;; (function)
           "codertarget.target.getTargetMapFileString" t ;; (function)
           "codertarget.target.getTargetName" t ;; (function)
           "codertarget.target.getTargetNameForAlias" t ;; (function)
           "codertarget.target.getTargetRootFolder" t ;; (function)
           "codertarget.target.getTargetShortName" t ;; (function)
           "codertarget.target.getTargetType" t ;; (function)
           "codertarget.target.getTargetVersion" t ;; (function)
           "codertarget.target.getThirdPartyToolsRegistrationFileName" t ;; (function)
           "codertarget.target.getThirdPartyToolsRegistryFolder" t ;; (function)
           "codertarget.target.getToolchainRootFolder" t ;; (function)
           "codertarget.target.initializeTarget" t ;; (function)
           "codertarget.target.isCodeInstrumentationProfiling" t ;; (function)
           "codertarget.target.isCoderTarget" t ;; (function)
           "codertarget.target.isKernelProfiling" t ;; (function)
           "codertarget.target.isSimulinkTarget" t ;; (function)
           "codertarget.target.isTargetRegistered" t ;; (function)
           "codertarget.target.openModelHook" t ;; (function)
           "codertarget.target.register" t ;; (function)
           "codertarget.target.setModelForCoderTarget" t ;; (function)
           "codertarget.target.setTargetHardware" t ;; (function)
           "codertarget.target.supportsCoderTarget" t ;; (function)
           "codertarget.target.targetHardwareChanged" t ;; (function)
           "codertarget.target.unregister" t ;; (function)
           "codertarget.target.updateCSOptionsForCoderTarget" t ;; (function)
           "codertarget.target.useCoderTarget" t ;; (function)
           "codertarget.targethardware.arePeripheralsSupported" t ;; (function)
           "codertarget.targethardware.BaseProductID" t ;; (class)
           "codertarget.targethardware.BaseProductID.C2B" 'enumeration
           "codertarget.targethardware.BaseProductID.EC" 'enumeration
           "codertarget.targethardware.BaseProductID.EC_SOC" 'enumeration
           "codertarget.targethardware.BaseProductID.ROS" 'enumeration
           "codertarget.targethardware.BaseProductID.SL" 'enumeration
           "codertarget.targethardware.BaseProductID.SLC" 'enumeration
           "codertarget.targethardware.BaseProductID.SOC" 'enumeration
           "codertarget.targethardware.BaseProductID.UNSPECIFIED" 'enumeration
           "codertarget.targethardware.doWidgetChangedCallback" t ;; (function)
           "codertarget.targethardware.errorIfUnavailable" t ;; (function)
           "codertarget.targethardware.EventRegistrationMethod" t ;; (class)
           "codertarget.targethardware.EventRegistrationMethod.AUTOMAP" 'enumeration
           "codertarget.targethardware.EventRegistrationMethod.DYNAMIC" 'enumeration
           "codertarget.targethardware.EventRegistrationMethod.ISEDIT" 'enumeration
           "codertarget.targethardware.EventRegistrationMethod.STATIC" 'enumeration
           "codertarget.targethardware.EventRegistrationMethod.UNSUPPORTED" 'enumeration
           "codertarget.targethardware.findHwBoardsForID" t ;; (function)
           "codertarget.targethardware.getBaseProductID" t ;; (function)
           "codertarget.targethardware.getBoardsForHardwareApp" t ;; (function)
           "codertarget.targethardware.getDefaultIOBlocksMode" t ;; (function)
           "codertarget.targethardware.getEnvironment" t ;; (function)
           "codertarget.targethardware.getEventRegistrationMethod" t ;; (function)
           "codertarget.targethardware.getHardwareConfiguration" t ;; (function)
           "codertarget.targethardware.getNumberOfCores" t ;; (function)
           "codertarget.targethardware.getPeripheralInfoFile" t ;; (function)
           "codertarget.targethardware.getProcessingUnitInfo" t ;; (function)
           "codertarget.targethardware.getProcessingUnitName" t ;; (function)
           "codertarget.targethardware.getProcessingUnits" t ;; (function)
           "codertarget.targethardware.getProcessingUnitsForTargetHardware" t ;; (function)
           "codertarget.targethardware.getProcessingUnitType" t ;; (function)
           "codertarget.targethardware.getRegisteredSimulinkTargetHardwareNames" t ;; (function)
           "codertarget.targethardware.getRegisteredTargetHardware" t ;; (function)
           "codertarget.targethardware.getRegisteredTargetHardwareNames" t ;; (function)
           "codertarget.targethardware.getSupportedHardwareBoardsForID" t ;; (function)
           "codertarget.targethardware.getSupportsSingleExecutable" t ;; (function)
           "codertarget.targethardware.getSupportsSoCShared" t ;; (function)
           "codertarget.targethardware.getTargetHardware" t ;; (function)
           "codertarget.targethardware.getTargetHardwareFromName" t ;; (function)
           "codertarget.targethardware.getTargetHardwareFromNameForEC" t ;; (function)
           "codertarget.targethardware.getTargetHardwareFromNameForSoC" t ;; (function)
           "codertarget.targethardware.getTargetHardwareIncludeFiles" t ;; (function)
           "codertarget.targethardware.getTargetHardwareInitializationCall" t ;; (function)
           "codertarget.targethardware.getTargetHardwareInterruptDisableCall" t ;; (function)
           "codertarget.targethardware.getTargetHardwareInterruptEnableCall" t ;; (function)
           "codertarget.targethardware.getTargetHardwareName" t ;; (function)
           "codertarget.targethardware.getTargetHardwareTerminationCall" t ;; (function)
           "codertarget.targethardware.getTargetModelStopCall" t ;; (function)
           "codertarget.targethardware.getTargetRTOS" t ;; (function)
           "codertarget.targethardware.hasBoardConfiguration" t ;; (function)
           "codertarget.targethardware.hasCPUProcessingUnit" t ;; (function)
           "codertarget.targethardware.hasMultipleProcessingUnits" t ;; (function)
           "codertarget.targethardware.isAutoMappingSupported" t ;; (function)
           "codertarget.targethardware.isBoardSimOnly" t ;; (function)
           "codertarget.targethardware.isConnectedIOSupported" t ;; (function)
           "codertarget.targethardware.isDeviceDriverAppSupported" t ;; (function)
           "codertarget.targethardware.isDynamicEventRegistrationSupported" t ;; (function)
           "codertarget.targethardware.isESBCompatible" t ;; (function)
           "codertarget.targethardware.isProcessingUnitSelectionAvailable" t ;; (function)
           "codertarget.targethardware.isTaskMapEditingSupported" t ;; (function)
           "codertarget.targethardware.isTaskMappingSupported" t ;; (function)
           "codertarget.targethardware.mapTargetTypeToBaseProductID" t ;; (function)
           "codertarget.targethardware.MasterSlaveSyncInfo" t ;; (class)
           "codertarget.targethardware.MasterSlaveSyncInfo.addNewElementToArrayProperty" t ;; (method)
           "codertarget.targethardware.MasterSlaveSyncInfo.createDocument" t ;; (method)
           "codertarget.targethardware.MasterSlaveSyncInfo.createParameter" t ;; (method)
           "codertarget.targethardware.MasterSlaveSyncInfo.createParameterGroup" t ;; (method)
           "codertarget.targethardware.MasterSlaveSyncInfo.getElement" t ;; (method)
           "codertarget.targethardware.MasterSlaveSyncInfo.read" t ;; (method)
           "codertarget.targethardware.MasterSlaveSyncInfo.setAttribute" t ;; (method)
           "codertarget.targethardware.MasterSlaveSyncInfo.setElement" t ;; (method)
           "codertarget.targethardware.MasterSlaveSyncInfo.write" t ;; (method)
           "codertarget.targethardware.ProcessingUnitInfo" t ;; (class)
           "codertarget.targethardware.ProcessingUnitInfo.addNewElementToArrayProperty" t ;; (method)
           "codertarget.targethardware.ProcessingUnitInfo.createDocument" t ;; (method)
           "codertarget.targethardware.ProcessingUnitInfo.createParameter" t ;; (method)
           "codertarget.targethardware.ProcessingUnitInfo.createParameterGroup" t ;; (method)
           "codertarget.targethardware.ProcessingUnitInfo.getElement" t ;; (method)
           "codertarget.targethardware.ProcessingUnitInfo.read" t ;; (method)
           "codertarget.targethardware.ProcessingUnitInfo.setAttribute" t ;; (method)
           "codertarget.targethardware.ProcessingUnitInfo.setElement" t ;; (method)
           "codertarget.targethardware.ProcessingUnitInfo.write" t ;; (method)
           "codertarget.targethardware.setBaseProductID" t ;; (function)
           "codertarget.targethardware.setProcessingUnitName" t ;; (function)
           "codertarget.targethardware.TargetHardwareInfo" t ;; (class)
           "codertarget.targethardware.TargetHardwareInfo.addNewElementToArrayProperty" t ;; (method)
           "codertarget.targethardware.TargetHardwareInfo.createDocument" t ;; (method)
           "codertarget.targethardware.TargetHardwareInfo.createParameter" t ;; (method)
           "codertarget.targethardware.TargetHardwareInfo.createParameterGroup" t ;; (method)
           "codertarget.targethardware.TargetHardwareInfo.getElement" t ;; (method)
           "codertarget.targethardware.TargetHardwareInfo.read" t ;; (method)
           "codertarget.targethardware.TargetHardwareInfo.setAttribute" t ;; (method)
           "codertarget.targethardware.TargetHardwareInfo.setElement" t ;; (method)
           "codertarget.targethardware.TargetHardwareInfo.write" t ;; (method)
           "codertarget.targethardware.TargetHardwareRegEntry" t ;; (class)
           "codertarget.targethardware.TargetHardwareRegEntry.addNewElementToArrayProperty" t ;; (method)
           "codertarget.targethardware.TargetHardwareRegEntry.createDocument" t ;; (method)
           "codertarget.targethardware.TargetHardwareRegEntry.createParameter" t ;; (method)
           "codertarget.targethardware.TargetHardwareRegEntry.createParameterGroup" t ;; (method)
           "codertarget.targethardware.TargetHardwareRegEntry.getElement" t ;; (method)
           "codertarget.targethardware.TargetHardwareRegEntry.read" t ;; (method)
           "codertarget.targethardware.TargetHardwareRegEntry.setAttribute" t ;; (method)
           "codertarget.targethardware.TargetHardwareRegEntry.setElement" t ;; (method)
           "codertarget.targethardware.TargetHardwareRegEntry.write" t ;; (method)
           "codertarget.TargetListener" t ;; (class)
           "codertarget.TargetListener.addListenerToTargetRegistry" t ;; (method)
           "codertarget.targetservices.ApplicationService" t ;; (class)
           "codertarget.targetservices.getTargetServiceArgs" t ;; (function)
           "codertarget.targetservices.needsCommService" t ;; (function)
           "codertarget.targetservices.TargetApplicationServiceBuilder" t ;; (class)
           "codertarget.targetservices.TargetService" t ;; (class)
           "codertarget.thirdpartytools.CustomTpRegistry" t ;; (class)
           "codertarget.thirdpartytools.ThirdPartyToolInfo" t ;; (class)
           "codertarget.tic2000.backward.accessBoardInitFileName" t ;; (function)
           "codertarget.tic2000.backward.forwardingHook" t ;; (function)
           "codertarget.tic2000.backward.forwardTaskMappingDataForHWIBlocks" t ;; (function)
           "codertarget.tic2000.backward.getCompatibleTHWRData" t ;; (function)
           "codertarget.tic2000.backward.getTaskToEventMappingForwardingData" t ;; (function)
           "codertarget.tic2000.backward.getTaskToEventMappingForwardingDataV2" t ;; (function)
           "codertarget.tic2000.backward.getTgtPrefPeripherals" t ;; (function)
           "codertarget.tic2000.backward.upgradeModelToCoderTarget" t ;; (function)
           "codertarget.tic2000.blocks.C29xUartReceive" t ;; (class)
           "codertarget.tic2000.blocks.C29xUartReceive.getDescriptiveName" t ;; (method)
           "codertarget.tic2000.blocks.C29xUartReceive.isSupportedContext" t ;; (method)
           "codertarget.tic2000.blocks.C29xUartReceive.macroNameParity" t ;; (method)
           "codertarget.tic2000.blocks.C29xUartReceive.updateBuildInfo" t ;; (method)
           "codertarget.tic2000.blocks.C29xUartSend" t ;; (class)
           "codertarget.tic2000.blocks.C29xUartSend.getDescriptiveName" t ;; (method)
           "codertarget.tic2000.blocks.C29xUartSend.isSupportedContext" t ;; (method)
           "codertarget.tic2000.blocks.C29xUartSend.macroNameParity" t ;; (method)
           "codertarget.tic2000.blocks.C29xUartSend.parseDataType" t ;; (method)
           "codertarget.tic2000.blocks.C29xUartSend.updateBuildInfo" t ;; (method)
           "codertarget.tic2000.blocks.CMPSSBlock" t ;; (class)
           "codertarget.tic2000.blocks.CMPSSBlock.allowedDataType" t ;; (method)
           "codertarget.tic2000.blocks.CMPSSBlock.getDescriptiveName" t ;; (method)
           "codertarget.tic2000.blocks.CMPSSBlock.isSupportedContext" t ;; (method)
           "codertarget.tic2000.blocks.CMPSSBlock.updateBuildInfo" t ;; (method)
           "codertarget.tic2000.blocks.CMPSSBlock.validateDACRegisterValue" t ;; (method)
           "codertarget.tic2000.blocks.CMPSSBlock.validateRampDECRegisterValue" t ;; (method)
           "codertarget.tic2000.blocks.CMPSSBlock.validateRampDLYRegisterValue" t ;; (method)
           "codertarget.tic2000.blocks.CMPSSBlock.validateRampREFRegisterValue" t ;; (method)
           "codertarget.tic2000.blocks.DACWrite" t ;; (class)
           "codertarget.tic2000.blocks.DACWrite.ADCUnconfigure" t ;; (method)
           "codertarget.tic2000.blocks.DACWrite.AssignBitsInRegister" t ;; (method)
           "codertarget.tic2000.blocks.DACWrite.clearVar" t ;; (method)
           "codertarget.tic2000.blocks.DACWrite.CombineBitsInRegisterAndCreateMask" t ;; (method)
           "codertarget.tic2000.blocks.DACWrite.connectServer" t ;; (method)
           "codertarget.tic2000.blocks.DACWrite.CreateMask" t ;; (method)
           "codertarget.tic2000.blocks.DACWrite.ePWMUnconfigure" t ;; (method)
           "codertarget.tic2000.blocks.DACWrite.getDescriptiveName" t ;; (method)
           "codertarget.tic2000.blocks.DACWrite.getSelectedGPIOPinNumbers" t ;; (method)
           "codertarget.tic2000.blocks.DACWrite.isSupportedContext" t ;; (method)
           "codertarget.tic2000.blocks.DACWrite.PositionBitsInRegisterAndCreateMask" t ;; (method)
           "codertarget.tic2000.blocks.DACWrite.readWriteRegisterValue" t ;; (method)
           "codertarget.tic2000.blocks.DACWrite.setgetADCModules" t ;; (method)
           "codertarget.tic2000.blocks.DACWrite.setgetADCRegObj" t ;; (method)
           "codertarget.tic2000.blocks.DACWrite.setgetADCType1and2RegObj" t ;; (method)
           "codertarget.tic2000.blocks.DACWrite.setgetADCTypes" t ;; (method)
           "codertarget.tic2000.blocks.DACWrite.setgetC2000RegObj" t ;; (method)
           "codertarget.tic2000.blocks.DACWrite.setgetCMPALinkedModules" t ;; (method)
           "codertarget.tic2000.blocks.DACWrite.setgetCMPBLinkedModules" t ;; (method)
           "codertarget.tic2000.blocks.DACWrite.setgetCMPCLinkedModules" t ;; (method)
           "codertarget.tic2000.blocks.DACWrite.setgetCMPDLinkedModules" t ;; (method)
           "codertarget.tic2000.blocks.DACWrite.setgetePWMPinObj" t ;; (method)
           "codertarget.tic2000.blocks.DACWrite.setgetePWMRegObj" t ;; (method)
           "codertarget.tic2000.blocks.DACWrite.setgetEPWMSync" t ;; (method)
           "codertarget.tic2000.blocks.DACWrite.setgetGPIOReadRegObj" t ;; (method)
           "codertarget.tic2000.blocks.DACWrite.setgetGPIOWriteRegObj" t ;; (method)
           "codertarget.tic2000.blocks.DACWrite.setgetIOEnabledObj" t ;; (method)
           "codertarget.tic2000.blocks.DACWrite.setgetIOProtocolObj" t ;; (method)
           "codertarget.tic2000.blocks.DACWrite.setgetModelHandleObj" t ;; (method)
           "codertarget.tic2000.blocks.DACWrite.setgetTBPRDLinkedModules" t ;; (method)
           "codertarget.tic2000.blocks.DACWrite.setgetTransportLayerObj" t ;; (method)
           "codertarget.tic2000.blocks.DACWrite.updateBuildInfo" t ;; (method)
           "codertarget.tic2000.blocks.HRCAPBlock" t ;; (class)
           "codertarget.tic2000.blocks.HRCAPBlock.getDescriptiveName" t ;; (method)
           "codertarget.tic2000.blocks.HRCAPBlock.isSupportedContext" t ;; (method)
           "codertarget.tic2000.blocks.HRCAPBlock.updateBuildInfo" t ;; (method)
           "codertarget.tic2000.blocks.MemoryIO" t ;; (class)
           "codertarget.tic2000.blocks.MemoryIO.getDescriptiveName" t ;; (method)
           "codertarget.tic2000.blocks.MemoryIO.isSupportedContext" t ;; (method)
           "codertarget.tic2000.blocks.MemoryIO.updateBuildInfo" t ;; (method)
           "codertarget.tic2000.blocks.RegisterRWBlock" t ;; (class)
           "codertarget.tic2000.blocks.RegisterRWBlock.ADCUnconfigure" t ;; (method)
           "codertarget.tic2000.blocks.RegisterRWBlock.AssignBitsInRegister" t ;; (method)
           "codertarget.tic2000.blocks.RegisterRWBlock.clearVar" t ;; (method)
           "codertarget.tic2000.blocks.RegisterRWBlock.CombineBitsInRegisterAndCreateMask" t ;; (method)
           "codertarget.tic2000.blocks.RegisterRWBlock.connectServer" t ;; (method)
           "codertarget.tic2000.blocks.RegisterRWBlock.CreateMask" t ;; (method)
           "codertarget.tic2000.blocks.RegisterRWBlock.ePWMUnconfigure" t ;; (method)
           "codertarget.tic2000.blocks.RegisterRWBlock.getDescriptiveName" t ;; (method)
           "codertarget.tic2000.blocks.RegisterRWBlock.getSelectedGPIOPinNumbers" t ;; (method)
           "codertarget.tic2000.blocks.RegisterRWBlock.isSupportedContext" t ;; (method)
           "codertarget.tic2000.blocks.RegisterRWBlock.PositionBitsInRegisterAndCreateMask" t ;; (method)
           "codertarget.tic2000.blocks.RegisterRWBlock.readWriteRegisterValue" t ;; (method)
           "codertarget.tic2000.blocks.RegisterRWBlock.setgetADCModules" t ;; (method)
           "codertarget.tic2000.blocks.RegisterRWBlock.setgetADCRegObj" t ;; (method)
           "codertarget.tic2000.blocks.RegisterRWBlock.setgetADCType1and2RegObj" t ;; (method)
           "codertarget.tic2000.blocks.RegisterRWBlock.setgetADCTypes" t ;; (method)
           "codertarget.tic2000.blocks.RegisterRWBlock.setgetC2000RegObj" t ;; (method)
           "codertarget.tic2000.blocks.RegisterRWBlock.setgetCMPALinkedModules" t ;; (method)
           "codertarget.tic2000.blocks.RegisterRWBlock.setgetCMPBLinkedModules" t ;; (method)
           "codertarget.tic2000.blocks.RegisterRWBlock.setgetCMPCLinkedModules" t ;; (method)
           "codertarget.tic2000.blocks.RegisterRWBlock.setgetCMPDLinkedModules" t ;; (method)
           "codertarget.tic2000.blocks.RegisterRWBlock.setgetePWMPinObj" t ;; (method)
           "codertarget.tic2000.blocks.RegisterRWBlock.setgetePWMRegObj" t ;; (method)
           "codertarget.tic2000.blocks.RegisterRWBlock.setgetEPWMSync" t ;; (method)
           "codertarget.tic2000.blocks.RegisterRWBlock.setgetGPIOReadRegObj" t ;; (method)
           "codertarget.tic2000.blocks.RegisterRWBlock.setgetGPIOWriteRegObj" t ;; (method)
           "codertarget.tic2000.blocks.RegisterRWBlock.setgetIOEnabledObj" t ;; (method)
           "codertarget.tic2000.blocks.RegisterRWBlock.setgetIOProtocolObj" t ;; (method)
           "codertarget.tic2000.blocks.RegisterRWBlock.setgetModelHandleObj" t ;; (method)
           "codertarget.tic2000.blocks.RegisterRWBlock.setgetTBPRDLinkedModules" t ;; (method)
           "codertarget.tic2000.blocks.RegisterRWBlock.setgetTransportLayerObj" t ;; (method)
           "codertarget.tic2000.blocks.RegisterRWBlock.updateBuildInfo" t ;; (method)
           "codertarget.tic2000.blocks.SDFM004x" t ;; (class)
           "codertarget.tic2000.blocks.SDFM004x.getDescriptiveName" t ;; (method)
           "codertarget.tic2000.blocks.SDFM004x.isSupportedContext" t ;; (method)
           "codertarget.tic2000.blocks.SDFM004x.updateBuildInfo" t ;; (method)
           "codertarget.tic2000.blocks.SDFM38x" t ;; (class)
           "codertarget.tic2000.blocks.SDFM38x.getDescriptiveName" t ;; (method)
           "codertarget.tic2000.blocks.SDFM38x.isSupportedContext" t ;; (method)
           "codertarget.tic2000.blocks.SDFM38x.updateBuildInfo" t ;; (method)
           "codertarget.tic2000.blocks.SDFMBlock" t ;; (class)
           "codertarget.tic2000.blocks.SDFMBlock.getDescriptiveName" t ;; (method)
           "codertarget.tic2000.blocks.SDFMBlock.isSupportedContext" t ;; (method)
           "codertarget.tic2000.blocks.SDFMBlock.updateBuildInfo" t ;; (method)
           "codertarget.tic2000.blocks.SPIBlock" t ;; (class)
           "codertarget.tic2000.blocks.SPIBlock.ADCUnconfigure" t ;; (method)
           "codertarget.tic2000.blocks.SPIBlock.allowedDataType" t ;; (method)
           "codertarget.tic2000.blocks.SPIBlock.AssignBitsInRegister" t ;; (method)
           "codertarget.tic2000.blocks.SPIBlock.clearVar" t ;; (method)
           "codertarget.tic2000.blocks.SPIBlock.CombineBitsInRegisterAndCreateMask" t ;; (method)
           "codertarget.tic2000.blocks.SPIBlock.connectServer" t ;; (method)
           "codertarget.tic2000.blocks.SPIBlock.CreateMask" t ;; (method)
           "codertarget.tic2000.blocks.SPIBlock.ePWMUnconfigure" t ;; (method)
           "codertarget.tic2000.blocks.SPIBlock.getNumberOfBytes" t ;; (method)
           "codertarget.tic2000.blocks.SPIBlock.getSelectedGPIOPinNumbers" t ;; (method)
           "codertarget.tic2000.blocks.SPIBlock.PositionBitsInRegisterAndCreateMask" t ;; (method)
           "codertarget.tic2000.blocks.SPIBlock.readWriteRegisterValue" t ;; (method)
           "codertarget.tic2000.blocks.SPIBlock.setgetADCModules" t ;; (method)
           "codertarget.tic2000.blocks.SPIBlock.setgetADCRegObj" t ;; (method)
           "codertarget.tic2000.blocks.SPIBlock.setgetADCType1and2RegObj" t ;; (method)
           "codertarget.tic2000.blocks.SPIBlock.setgetADCTypes" t ;; (method)
           "codertarget.tic2000.blocks.SPIBlock.setgetC2000RegObj" t ;; (method)
           "codertarget.tic2000.blocks.SPIBlock.setgetCMPALinkedModules" t ;; (method)
           "codertarget.tic2000.blocks.SPIBlock.setgetCMPBLinkedModules" t ;; (method)
           "codertarget.tic2000.blocks.SPIBlock.setgetCMPCLinkedModules" t ;; (method)
           "codertarget.tic2000.blocks.SPIBlock.setgetCMPDLinkedModules" t ;; (method)
           "codertarget.tic2000.blocks.SPIBlock.setgetePWMPinObj" t ;; (method)
           "codertarget.tic2000.blocks.SPIBlock.setgetePWMRegObj" t ;; (method)
           "codertarget.tic2000.blocks.SPIBlock.setgetEPWMSync" t ;; (method)
           "codertarget.tic2000.blocks.SPIBlock.setgetGPIOReadRegObj" t ;; (method)
           "codertarget.tic2000.blocks.SPIBlock.setgetGPIOWriteRegObj" t ;; (method)
           "codertarget.tic2000.blocks.SPIBlock.setgetIOEnabledObj" t ;; (method)
           "codertarget.tic2000.blocks.SPIBlock.setgetIOProtocolObj" t ;; (method)
           "codertarget.tic2000.blocks.SPIBlock.setgetModelHandleObj" t ;; (method)
           "codertarget.tic2000.blocks.SPIBlock.setgetTBPRDLinkedModules" t ;; (method)
           "codertarget.tic2000.blocks.SPIBlock.setgetTransportLayerObj" t ;; (method)
           "codertarget.tic2000.blocks.SPIBlock.validateDataLength" t ;; (method)
           "codertarget.tic2000.blocks.SPIBlock.validateRegisterAddress" t ;; (method)
           "codertarget.tic2000.blocks.SPIMasterTransfer" t ;; (class)
           "codertarget.tic2000.blocks.SPIMasterTransfer.ADCUnconfigure" t ;; (method)
           "codertarget.tic2000.blocks.SPIMasterTransfer.allowedDataType" t ;; (method)
           "codertarget.tic2000.blocks.SPIMasterTransfer.AssignBitsInRegister" t ;; (method)
           "codertarget.tic2000.blocks.SPIMasterTransfer.clearVar" t ;; (method)
           "codertarget.tic2000.blocks.SPIMasterTransfer.CombineBitsInRegisterAndCreateMask" t ;; (method)
           "codertarget.tic2000.blocks.SPIMasterTransfer.connectServer" t ;; (method)
           "codertarget.tic2000.blocks.SPIMasterTransfer.CreateMask" t ;; (method)
           "codertarget.tic2000.blocks.SPIMasterTransfer.ePWMUnconfigure" t ;; (method)
           "codertarget.tic2000.blocks.SPIMasterTransfer.getDescriptiveName" t ;; (method)
           "codertarget.tic2000.blocks.SPIMasterTransfer.getNumberOfBytes" t ;; (method)
           "codertarget.tic2000.blocks.SPIMasterTransfer.getSelectedGPIOPinNumbers" t ;; (method)
           "codertarget.tic2000.blocks.SPIMasterTransfer.isSupportedContext" t ;; (method)
           "codertarget.tic2000.blocks.SPIMasterTransfer.PositionBitsInRegisterAndCreateMask" t ;; (method)
           "codertarget.tic2000.blocks.SPIMasterTransfer.readWriteRegisterValue" t ;; (method)
           "codertarget.tic2000.blocks.SPIMasterTransfer.setgetADCModules" t ;; (method)
           "codertarget.tic2000.blocks.SPIMasterTransfer.setgetADCRegObj" t ;; (method)
           "codertarget.tic2000.blocks.SPIMasterTransfer.setgetADCType1and2RegObj" t ;; (method)
           "codertarget.tic2000.blocks.SPIMasterTransfer.setgetADCTypes" t ;; (method)
           "codertarget.tic2000.blocks.SPIMasterTransfer.setgetC2000RegObj" t ;; (method)
           "codertarget.tic2000.blocks.SPIMasterTransfer.setgetCMPALinkedModules" t ;; (method)
           "codertarget.tic2000.blocks.SPIMasterTransfer.setgetCMPBLinkedModules" t ;; (method)
           "codertarget.tic2000.blocks.SPIMasterTransfer.setgetCMPCLinkedModules" t ;; (method)
           "codertarget.tic2000.blocks.SPIMasterTransfer.setgetCMPDLinkedModules" t ;; (method)
           "codertarget.tic2000.blocks.SPIMasterTransfer.setgetePWMPinObj" t ;; (method)
           "codertarget.tic2000.blocks.SPIMasterTransfer.setgetePWMRegObj" t ;; (method)
           "codertarget.tic2000.blocks.SPIMasterTransfer.setgetEPWMSync" t ;; (method)
           "codertarget.tic2000.blocks.SPIMasterTransfer.setgetGPIOReadRegObj" t ;; (method)
           "codertarget.tic2000.blocks.SPIMasterTransfer.setgetGPIOWriteRegObj" t ;; (method)
           "codertarget.tic2000.blocks.SPIMasterTransfer.setgetIOEnabledObj" t ;; (method)
           "codertarget.tic2000.blocks.SPIMasterTransfer.setgetIOProtocolObj" t ;; (method)
           "codertarget.tic2000.blocks.SPIMasterTransfer.setgetModelHandleObj" t ;; (method)
           "codertarget.tic2000.blocks.SPIMasterTransfer.setgetTBPRDLinkedModules" t ;; (method)
           "codertarget.tic2000.blocks.SPIMasterTransfer.setgetTransportLayerObj" t ;; (method)
           "codertarget.tic2000.blocks.SPIMasterTransfer.updateBuildInfo" t ;; (method)
           "codertarget.tic2000.blocks.SPIMasterTransfer.validateDataLength" t ;; (method)
           "codertarget.tic2000.blocks.SPIMasterTransfer.validateRegisterAddress" t ;; (method)
           "codertarget.tic2000.blocks.SPIRead" t ;; (class)
           "codertarget.tic2000.blocks.SPIRead.ADCUnconfigure" t ;; (method)
           "codertarget.tic2000.blocks.SPIRead.allowedDataType" t ;; (method)
           "codertarget.tic2000.blocks.SPIRead.AssignBitsInRegister" t ;; (method)
           "codertarget.tic2000.blocks.SPIRead.clearVar" t ;; (method)
           "codertarget.tic2000.blocks.SPIRead.CombineBitsInRegisterAndCreateMask" t ;; (method)
           "codertarget.tic2000.blocks.SPIRead.connectServer" t ;; (method)
           "codertarget.tic2000.blocks.SPIRead.CreateMask" t ;; (method)
           "codertarget.tic2000.blocks.SPIRead.ePWMUnconfigure" t ;; (method)
           "codertarget.tic2000.blocks.SPIRead.getDescriptiveName" t ;; (method)
           "codertarget.tic2000.blocks.SPIRead.getNumberOfBytes" t ;; (method)
           "codertarget.tic2000.blocks.SPIRead.getSelectedGPIOPinNumbers" t ;; (method)
           "codertarget.tic2000.blocks.SPIRead.isSupportedContext" t ;; (method)
           "codertarget.tic2000.blocks.SPIRead.PositionBitsInRegisterAndCreateMask" t ;; (method)
           "codertarget.tic2000.blocks.SPIRead.readWriteRegisterValue" t ;; (method)
           "codertarget.tic2000.blocks.SPIRead.setgetADCModules" t ;; (method)
           "codertarget.tic2000.blocks.SPIRead.setgetADCRegObj" t ;; (method)
           "codertarget.tic2000.blocks.SPIRead.setgetADCType1and2RegObj" t ;; (method)
           "codertarget.tic2000.blocks.SPIRead.setgetADCTypes" t ;; (method)
           "codertarget.tic2000.blocks.SPIRead.setgetC2000RegObj" t ;; (method)
           "codertarget.tic2000.blocks.SPIRead.setgetCMPALinkedModules" t ;; (method)
           "codertarget.tic2000.blocks.SPIRead.setgetCMPBLinkedModules" t ;; (method)
           "codertarget.tic2000.blocks.SPIRead.setgetCMPCLinkedModules" t ;; (method)
           "codertarget.tic2000.blocks.SPIRead.setgetCMPDLinkedModules" t ;; (method)
           "codertarget.tic2000.blocks.SPIRead.setgetePWMPinObj" t ;; (method)
           "codertarget.tic2000.blocks.SPIRead.setgetePWMRegObj" t ;; (method)
           "codertarget.tic2000.blocks.SPIRead.setgetEPWMSync" t ;; (method)
           "codertarget.tic2000.blocks.SPIRead.setgetGPIOReadRegObj" t ;; (method)
           "codertarget.tic2000.blocks.SPIRead.setgetGPIOWriteRegObj" t ;; (method)
           "codertarget.tic2000.blocks.SPIRead.setgetIOEnabledObj" t ;; (method)
           "codertarget.tic2000.blocks.SPIRead.setgetIOProtocolObj" t ;; (method)
           "codertarget.tic2000.blocks.SPIRead.setgetModelHandleObj" t ;; (method)
           "codertarget.tic2000.blocks.SPIRead.setgetTBPRDLinkedModules" t ;; (method)
           "codertarget.tic2000.blocks.SPIRead.setgetTransportLayerObj" t ;; (method)
           "codertarget.tic2000.blocks.SPIRead.updateBuildInfo" t ;; (method)
           "codertarget.tic2000.blocks.SPIRead.validateDataLength" t ;; (method)
           "codertarget.tic2000.blocks.SPIRead.validateRegisterAddress" t ;; (method)
           "codertarget.tic2000.blocks.SPIWrite" t ;; (class)
           "codertarget.tic2000.blocks.SPIWrite.ADCUnconfigure" t ;; (method)
           "codertarget.tic2000.blocks.SPIWrite.allowedDataType" t ;; (method)
           "codertarget.tic2000.blocks.SPIWrite.AssignBitsInRegister" t ;; (method)
           "codertarget.tic2000.blocks.SPIWrite.clearVar" t ;; (method)
           "codertarget.tic2000.blocks.SPIWrite.CombineBitsInRegisterAndCreateMask" t ;; (method)
           "codertarget.tic2000.blocks.SPIWrite.connectServer" t ;; (method)
           "codertarget.tic2000.blocks.SPIWrite.CreateMask" t ;; (method)
           "codertarget.tic2000.blocks.SPIWrite.ePWMUnconfigure" t ;; (method)
           "codertarget.tic2000.blocks.SPIWrite.getDescriptiveName" t ;; (method)
           "codertarget.tic2000.blocks.SPIWrite.getNumberOfBytes" t ;; (method)
           "codertarget.tic2000.blocks.SPIWrite.getSelectedGPIOPinNumbers" t ;; (method)
           "codertarget.tic2000.blocks.SPIWrite.isSupportedContext" t ;; (method)
           "codertarget.tic2000.blocks.SPIWrite.PositionBitsInRegisterAndCreateMask" t ;; (method)
           "codertarget.tic2000.blocks.SPIWrite.readWriteRegisterValue" t ;; (method)
           "codertarget.tic2000.blocks.SPIWrite.setgetADCModules" t ;; (method)
           "codertarget.tic2000.blocks.SPIWrite.setgetADCRegObj" t ;; (method)
           "codertarget.tic2000.blocks.SPIWrite.setgetADCType1and2RegObj" t ;; (method)
           "codertarget.tic2000.blocks.SPIWrite.setgetADCTypes" t ;; (method)
           "codertarget.tic2000.blocks.SPIWrite.setgetC2000RegObj" t ;; (method)
           "codertarget.tic2000.blocks.SPIWrite.setgetCMPALinkedModules" t ;; (method)
           "codertarget.tic2000.blocks.SPIWrite.setgetCMPBLinkedModules" t ;; (method)
           "codertarget.tic2000.blocks.SPIWrite.setgetCMPCLinkedModules" t ;; (method)
           "codertarget.tic2000.blocks.SPIWrite.setgetCMPDLinkedModules" t ;; (method)
           "codertarget.tic2000.blocks.SPIWrite.setgetePWMPinObj" t ;; (method)
           "codertarget.tic2000.blocks.SPIWrite.setgetePWMRegObj" t ;; (method)
           "codertarget.tic2000.blocks.SPIWrite.setgetEPWMSync" t ;; (method)
           "codertarget.tic2000.blocks.SPIWrite.setgetGPIOReadRegObj" t ;; (method)
           "codertarget.tic2000.blocks.SPIWrite.setgetGPIOWriteRegObj" t ;; (method)
           "codertarget.tic2000.blocks.SPIWrite.setgetIOEnabledObj" t ;; (method)
           "codertarget.tic2000.blocks.SPIWrite.setgetIOProtocolObj" t ;; (method)
           "codertarget.tic2000.blocks.SPIWrite.setgetModelHandleObj" t ;; (method)
           "codertarget.tic2000.blocks.SPIWrite.setgetTBPRDLinkedModules" t ;; (method)
           "codertarget.tic2000.blocks.SPIWrite.setgetTransportLayerObj" t ;; (method)
           "codertarget.tic2000.blocks.SPIWrite.updateBuildInfo" t ;; (method)
           "codertarget.tic2000.blocks.SPIWrite.validateDataLength" t ;; (method)
           "codertarget.tic2000.blocks.SPIWrite.validateRegisterAddress" t ;; (method)
           "codertarget.tic2000.hwsetup.ConfirmTPInstallation" t ;; (class)
           "codertarget.tic2000.hwsetup.ConfirmTPInstallation.backButtonCallback" t ;; (method)
           "codertarget.tic2000.hwsetup.ConfirmTPInstallation.finish" t ;; (method)
           "codertarget.tic2000.hwsetup.ConfirmTPInstallation.getAllTemplateWidgetLayoutDetails" t ;; (method)
           "codertarget.tic2000.hwsetup.ConfirmTPInstallation.getWidgetPropertyNames" t ;; (method)
           "codertarget.tic2000.hwsetup.ConfirmTPInstallation.nextButtonCallback" t ;; (method)
           "codertarget.tic2000.hwsetup.ConfirmTPInstallation.setWidgetTags" t ;; (method)
           "codertarget.tic2000.hwsetup.ConnectHardware" t ;; (class)
           "codertarget.tic2000.hwsetup.ConnectHardware.backButtonCallback" t ;; (method)
           "codertarget.tic2000.hwsetup.ConnectHardware.finish" t ;; (method)
           "codertarget.tic2000.hwsetup.ConnectHardware.getAllTemplateWidgetLayoutDetails" t ;; (method)
           "codertarget.tic2000.hwsetup.ConnectHardware.getWidgetPropertyNames" t ;; (method)
           "codertarget.tic2000.hwsetup.ConnectHardware.nextButtonCallback" t ;; (method)
           "codertarget.tic2000.hwsetup.ConnectHardware.setWidgetTags" t ;; (method)
           "codertarget.tic2000.hwsetup.getTIC2000Root" t ;; (function)
           "codertarget.tic2000.hwsetup.HardwareInterface" t ;; (class)
           "codertarget.tic2000.hwsetup.HardwareInterface.getInstance" t ;; (method)
           "codertarget.tic2000.hwsetup.InstallTpSoftware1" t ;; (class)
           "codertarget.tic2000.hwsetup.InstallTpSoftware1.backButtonCallback" t ;; (method)
           "codertarget.tic2000.hwsetup.InstallTpSoftware1.finish" t ;; (method)
           "codertarget.tic2000.hwsetup.InstallTpSoftware1.getAllTemplateWidgetLayoutDetails" t ;; (method)
           "codertarget.tic2000.hwsetup.InstallTpSoftware1.getWidgetPropertyNames" t ;; (method)
           "codertarget.tic2000.hwsetup.InstallTpSoftware1.nextButtonCallback" t ;; (method)
           "codertarget.tic2000.hwsetup.InstallTpSoftware1.setWidgetTags" t ;; (method)
           "codertarget.tic2000.hwsetup.InstallTpSoftware2" t ;; (class)
           "codertarget.tic2000.hwsetup.InstallTpSoftware2.backButtonCallback" t ;; (method)
           "codertarget.tic2000.hwsetup.InstallTpSoftware2.finish" t ;; (method)
           "codertarget.tic2000.hwsetup.InstallTpSoftware2.getAllTemplateWidgetLayoutDetails" t ;; (method)
           "codertarget.tic2000.hwsetup.InstallTpSoftware2.getWidgetPropertyNames" t ;; (method)
           "codertarget.tic2000.hwsetup.InstallTpSoftware2.nextButtonCallback" t ;; (method)
           "codertarget.tic2000.hwsetup.InstallTpSoftware2.setWidgetTags" t ;; (method)
           "codertarget.tic2000.hwsetup.launch" t ;; (function)
           "codertarget.tic2000.hwsetup.LinuxHardwareModule" t ;; (class)
           "codertarget.tic2000.hwsetup.LinuxHardwareModule.getInstance" t ;; (method)
           "codertarget.tic2000.hwsetup.SelectProcessors" t ;; (class)
           "codertarget.tic2000.hwsetup.SelectProcessors.backButtonCallback" t ;; (method)
           "codertarget.tic2000.hwsetup.SelectProcessors.finish" t ;; (method)
           "codertarget.tic2000.hwsetup.SelectProcessors.getAllTemplateWidgetLayoutDetails" t ;; (method)
           "codertarget.tic2000.hwsetup.SelectProcessors.getWidgetPropertyNames" t ;; (method)
           "codertarget.tic2000.hwsetup.SelectProcessors.nextButtonCallback" t ;; (method)
           "codertarget.tic2000.hwsetup.SelectProcessors.setWidgetTags" t ;; (method)
           "codertarget.tic2000.hwsetup.SetupComplete" t ;; (class)
           "codertarget.tic2000.hwsetup.SetupComplete.backButtonCallback" t ;; (method)
           "codertarget.tic2000.hwsetup.SetupComplete.finish" t ;; (method)
           "codertarget.tic2000.hwsetup.SetupComplete.getAllTemplateWidgetLayoutDetails" t ;; (method)
           "codertarget.tic2000.hwsetup.SetupComplete.getWidgetPropertyNames" t ;; (method)
           "codertarget.tic2000.hwsetup.SetupComplete.nextButtonCallback" t ;; (method)
           "codertarget.tic2000.hwsetup.SetupComplete.setWidgetTags" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateARMCGT" t ;; (class)
           "codertarget.tic2000.hwsetup.ValidateARMCGT.backButtonCallback" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateARMCGT.finish" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateARMCGT.getAllTemplateWidgetLayoutDetails" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateARMCGT.getWidgetPropertyNames" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateARMCGT.nextButtonCallback" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateARMCGT.setWidgetTags" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateARMCGTSoC" t ;; (class)
           "codertarget.tic2000.hwsetup.ValidateARMCGTSoC.backButtonCallback" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateARMCGTSoC.finish" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateARMCGTSoC.getAllTemplateWidgetLayoutDetails" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateARMCGTSoC.getWidgetPropertyNames" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateARMCGTSoC.nextButtonCallback" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateARMCGTSoC.setWidgetTags" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateC2000Ware" t ;; (class)
           "codertarget.tic2000.hwsetup.ValidateC2000Ware.backButtonCallback" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateC2000Ware.finish" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateC2000Ware.getAllTemplateWidgetLayoutDetails" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateC2000Ware.getWidgetPropertyNames" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateC2000Ware.nextButtonCallback" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateC2000Ware.setWidgetTags" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateC29xCGT" t ;; (class)
           "codertarget.tic2000.hwsetup.ValidateC29xCGT.backButtonCallback" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateC29xCGT.finish" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateC29xCGT.getAllTemplateWidgetLayoutDetails" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateC29xCGT.getWidgetPropertyNames" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateC29xCGT.nextButtonCallback" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateC29xCGT.setWidgetTags" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateC29xSDK" t ;; (class)
           "codertarget.tic2000.hwsetup.ValidateC29xSDK.backButtonCallback" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateC29xSDK.finish" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateC29xSDK.getAllTemplateWidgetLayoutDetails" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateC29xSDK.getWidgetPropertyNames" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateC29xSDK.nextButtonCallback" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateC29xSDK.setWidgetTags" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateCCS" t ;; (class)
           "codertarget.tic2000.hwsetup.ValidateCCS.backButtonCallback" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateCCS.finish" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateCCS.getAllTemplateWidgetLayoutDetails" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateCCS.getWidgetPropertyNames" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateCCS.nextButtonCallback" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateCCS.setWidgetTags" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateCGT" t ;; (class)
           "codertarget.tic2000.hwsetup.ValidateCGT.backButtonCallback" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateCGT.finish" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateCGT.getAllTemplateWidgetLayoutDetails" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateCGT.getWidgetPropertyNames" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateCGT.nextButtonCallback" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateCGT.setWidgetTags" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateControlSUITE" t ;; (class)
           "codertarget.tic2000.hwsetup.ValidateControlSUITE.backButtonCallback" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateControlSUITE.finish" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateControlSUITE.getAllTemplateWidgetLayoutDetails" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateControlSUITE.getWidgetPropertyNames" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateControlSUITE.nextButtonCallback" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateControlSUITE.setWidgetTags" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateF28044" t ;; (class)
           "codertarget.tic2000.hwsetup.ValidateF28044.backButtonCallback" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateF28044.finish" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateF28044.getAllTemplateWidgetLayoutDetails" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateF28044.getWidgetPropertyNames" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateF28044.nextButtonCallback" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateF28044.setWidgetTags" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateF280x" t ;; (class)
           "codertarget.tic2000.hwsetup.ValidateF280x.backButtonCallback" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateF280x.finish" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateF280x.getAllTemplateWidgetLayoutDetails" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateF280x.getWidgetPropertyNames" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateF280x.nextButtonCallback" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateF280x.setWidgetTags" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateF281x" t ;; (class)
           "codertarget.tic2000.hwsetup.ValidateF281x.backButtonCallback" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateF281x.finish" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateF281x.getAllTemplateWidgetLayoutDetails" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateF281x.getWidgetPropertyNames" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateF281x.nextButtonCallback" t ;; (method)
           "codertarget.tic2000.hwsetup.ValidateF281x.setWidgetTags" t ;; (method)
           "codertarget.tic2000.hwsetup.WindowsHardwareModule" t ;; (class)
           "codertarget.tic2000.hwsetup.WindowsHardwareModule.getInstance" t ;; (method)
           "codertarget.tic2000.masks.adc.type4.getADCMaskParams" t ;; (function)
           "codertarget.tic2000.masks.adc.type4P2.getADCMaskParams" t ;; (function)
           "codertarget.tic2000.masks.adc.type5.getADCMaskParams" t ;; (function)
           "codertarget.tic2000.masks.adc.type6.getADCMaskParams" t ;; (function)
           "codertarget.tic2000.masks.adc.type7.getADCMaskParams" t ;; (function)
           "codertarget.tic2000.masks.cla.type1.getMaskParams" t ;; (function)
           "codertarget.tic2000.masks.cla.type2.getMaskParams" t ;; (function)
           "codertarget.tic2000.masks.cla.type2p1.getMaskParams" t ;; (function)
           "codertarget.tic2000.masks.cla.type2p2.getMaskParams" t ;; (function)
           "codertarget.tic2000.masks.cla.type2p3.getMaskParams" t ;; (function)
           "codertarget.tic2000.masks.cla.type2p4.getMaskParams" t ;; (function)
           "codertarget.tic2000.masks.ePWM.type1.getMaskParams" t ;; (function)
           "codertarget.tic2000.masks.ePWM.type2.getMaskParams" t ;; (function)
           "codertarget.tic2000.masks.ePWM.type4.getMaskParams" t ;; (function)
           "codertarget.tic2000.pinmap.F280013x.getADCAnalogGPIOPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F280013x.getAnalogGPIOPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F280013x.getECANPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F280013x.getECAPPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F280013x.getEPWMPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F280013x.getEQEPPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F280013x.getGPIOGroups" t ;; (function)
           "codertarget.tic2000.pinmap.F280013x.getGPIOPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F280013x.getI2CPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F280013x.getInterruptDefinitions" t ;; (function)
           "codertarget.tic2000.pinmap.F280013x.getMUXInputforePWMXbar" t ;; (function)
           "codertarget.tic2000.pinmap.F280013x.getMUXInputforOutputXbar" t ;; (function)
           "codertarget.tic2000.pinmap.F280013x.getProcessorInfo" t ;; (function)
           "codertarget.tic2000.pinmap.F280013x.getRegisterGroups" t ;; (function)
           "codertarget.tic2000.pinmap.F280013x.getSCIPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F280013x.getSPIPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F280015x.getADCAnalogGPIOPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F280015x.getAnalogGPIOPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F280015x.getECANPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F280015x.getECAPPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F280015x.getEPWMPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F280015x.getEQEPPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F280015x.getGPIOGroups" t ;; (function)
           "codertarget.tic2000.pinmap.F280015x.getGPIOPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F280015x.getI2CPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F280015x.getInterruptDefinitions" t ;; (function)
           "codertarget.tic2000.pinmap.F280015x.getMCANPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F280015x.getMUXInputforePWMXbar" t ;; (function)
           "codertarget.tic2000.pinmap.F280015x.getMUXInputforOutputXbar" t ;; (function)
           "codertarget.tic2000.pinmap.F280015x.getProcessorInfo" t ;; (function)
           "codertarget.tic2000.pinmap.F280015x.getRegisterGroups" t ;; (function)
           "codertarget.tic2000.pinmap.F280015x.getSCIPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F280015x.getSPIPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28002x.getDMAInterruptSource" t ;; (function)
           "codertarget.tic2000.pinmap.F28002x.getECANPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28002x.getECAPPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28002x.getEPWMPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28002x.getEQEPPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28002x.getGPIOGroups" t ;; (function)
           "codertarget.tic2000.pinmap.F28002x.getGPIOPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28002x.getHRCAPISRData" t ;; (function)
           "codertarget.tic2000.pinmap.F28002x.getI2CPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28002x.getInputforCLBTile" t ;; (function)
           "codertarget.tic2000.pinmap.F28002x.getInterruptDefinitions" t ;; (function)
           "codertarget.tic2000.pinmap.F28002x.getMUXInputforClbXbar" t ;; (function)
           "codertarget.tic2000.pinmap.F28002x.getMUXInputforePWMXbar" t ;; (function)
           "codertarget.tic2000.pinmap.F28002x.getMUXInputforOutputXbar" t ;; (function)
           "codertarget.tic2000.pinmap.F28002x.getProcessorInfo" t ;; (function)
           "codertarget.tic2000.pinmap.F28002x.getRegisterGroups" t ;; (function)
           "codertarget.tic2000.pinmap.F28002x.getSCIPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28002x.getSPIPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28003x.getAnalogGPIOPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28003x.getDMAInterruptSource" t ;; (function)
           "codertarget.tic2000.pinmap.F28003x.getECANPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28003x.getECAPPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28003x.getEPWMPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28003x.getEQEPPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28003x.getGPIOGroups" t ;; (function)
           "codertarget.tic2000.pinmap.F28003x.getGPIOPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28003x.getHRCAPISRData" t ;; (function)
           "codertarget.tic2000.pinmap.F28003x.getI2CPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28003x.getInputforCLBTile" t ;; (function)
           "codertarget.tic2000.pinmap.F28003x.getInterruptDefinitions" t ;; (function)
           "codertarget.tic2000.pinmap.F28003x.getMCANPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28003x.getMUXInputforClbXbar" t ;; (function)
           "codertarget.tic2000.pinmap.F28003x.getMUXInputforePWMXbar" t ;; (function)
           "codertarget.tic2000.pinmap.F28003x.getMUXInputforOutputXbar" t ;; (function)
           "codertarget.tic2000.pinmap.F28003x.getProcessorInfo" t ;; (function)
           "codertarget.tic2000.pinmap.F28003x.getRegisterGroups" t ;; (function)
           "codertarget.tic2000.pinmap.F28003x.getSCIPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28003x.getSDFMPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28003x.getSPIPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28004x.getAnalogGPIOPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28004x.getECANPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28004x.getECAPPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28004x.getEPWMPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28004x.getEQEPPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28004x.getGPIOGroups" t ;; (function)
           "codertarget.tic2000.pinmap.F28004x.getGPIOPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28004x.getHRCAPISRData" t ;; (function)
           "codertarget.tic2000.pinmap.F28004x.getI2CPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28004x.getInputforCLBTile" t ;; (function)
           "codertarget.tic2000.pinmap.F28004x.getInterruptDefinitions" t ;; (function)
           "codertarget.tic2000.pinmap.F28004x.getMUXInputforClbXbar" t ;; (function)
           "codertarget.tic2000.pinmap.F28004x.getMUXInputforePWMXbar" t ;; (function)
           "codertarget.tic2000.pinmap.F28004x.getMUXInputforOutputXbar" t ;; (function)
           "codertarget.tic2000.pinmap.F28004x.getProcessorInfo" t ;; (function)
           "codertarget.tic2000.pinmap.F28004x.getRegisterGroups" t ;; (function)
           "codertarget.tic2000.pinmap.F28004x.getSCIPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2802x.getEPWMPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2802x.getGPIOGroups" t ;; (function)
           "codertarget.tic2000.pinmap.F2802x.getGPIOPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2802x.getI2CPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2802x.getInterruptDefinitions" t ;; (function)
           "codertarget.tic2000.pinmap.F2802x.getProcessorInfo" t ;; (function)
           "codertarget.tic2000.pinmap.F2802x.getRegisterGroups" t ;; (function)
           "codertarget.tic2000.pinmap.F2802x.getSCIPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2803x.getECANPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2803x.getEPWMPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2803x.getGPIOGroups" t ;; (function)
           "codertarget.tic2000.pinmap.F2803x.getGPIOPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2803x.getHRCAPPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2803x.getI2CPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2803x.getInterruptDefinitions" t ;; (function)
           "codertarget.tic2000.pinmap.F2803x.getProcessorInfo" t ;; (function)
           "codertarget.tic2000.pinmap.F2803x.getRegisterGroups" t ;; (function)
           "codertarget.tic2000.pinmap.F2803x.getSCIPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2804x.getEPWMPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2804x.getGPIOGroups" t ;; (function)
           "codertarget.tic2000.pinmap.F2804x.getGPIOPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2804x.getI2CPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2804x.getInterruptDefinitions" t ;; (function)
           "codertarget.tic2000.pinmap.F2804x.getProcessorInfo" t ;; (function)
           "codertarget.tic2000.pinmap.F2804x.getRegisterGroups" t ;; (function)
           "codertarget.tic2000.pinmap.F2804x.getSCIPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2805x.getECANPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2805x.getEPWMPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2805x.getGPIOGroups" t ;; (function)
           "codertarget.tic2000.pinmap.F2805x.getGPIOPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2805x.getI2CPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2805x.getInterruptDefinitions" t ;; (function)
           "codertarget.tic2000.pinmap.F2805x.getProcessorInfo" t ;; (function)
           "codertarget.tic2000.pinmap.F2805x.getRegisterGroups" t ;; (function)
           "codertarget.tic2000.pinmap.F2805x.getSCIPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2806x.getECANPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2806x.getEPWMPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2806x.getGPIOGroups" t ;; (function)
           "codertarget.tic2000.pinmap.F2806x.getGPIOPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2806x.getHRCAPPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2806x.getI2CPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2806x.getInterruptDefinitions" t ;; (function)
           "codertarget.tic2000.pinmap.F2806x.getProcessorInfo" t ;; (function)
           "codertarget.tic2000.pinmap.F2806x.getRegisterGroups" t ;; (function)
           "codertarget.tic2000.pinmap.F2806x.getSCIPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2807x.getEPWMPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2807x.getGPIOGroups" t ;; (function)
           "codertarget.tic2000.pinmap.F2807x.getGPIOPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2807x.getI2CPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2807x.getInputforCLBTile" t ;; (function)
           "codertarget.tic2000.pinmap.F2807x.getInterruptDefinitions" t ;; (function)
           "codertarget.tic2000.pinmap.F2807x.getMUXInputforClbXbar" t ;; (function)
           "codertarget.tic2000.pinmap.F2807x.getMUXInputforePWMXbar" t ;; (function)
           "codertarget.tic2000.pinmap.F2807x.getMUXInputforOutputXbar" t ;; (function)
           "codertarget.tic2000.pinmap.F2807x.getProcessorInfo" t ;; (function)
           "codertarget.tic2000.pinmap.F2807x.getRegisterGroups" t ;; (function)
           "codertarget.tic2000.pinmap.F280x.getECANPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F280x.getEPWMPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F280x.getGPIOGroups" t ;; (function)
           "codertarget.tic2000.pinmap.F280x.getGPIOPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F280x.getI2CPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F280x.getInterruptDefinitions" t ;; (function)
           "codertarget.tic2000.pinmap.F280x.getProcessorInfo" t ;; (function)
           "codertarget.tic2000.pinmap.F280x.getRegisterGroups" t ;; (function)
           "codertarget.tic2000.pinmap.F280x.getSCIPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F281x.getGPIOGroups" t ;; (function)
           "codertarget.tic2000.pinmap.F281x.getInterruptDefinitions" t ;; (function)
           "codertarget.tic2000.pinmap.F281x.getProcessorInfo" t ;; (function)
           "codertarget.tic2000.pinmap.F281x.getRegisterGroups" t ;; (function)
           "codertarget.tic2000.pinmap.F2833x.getECANPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2833x.getEPWMPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2833x.getGPIOGroups" t ;; (function)
           "codertarget.tic2000.pinmap.F2833x.getGPIOPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2833x.getI2CPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2833x.getInterruptDefinitions" t ;; (function)
           "codertarget.tic2000.pinmap.F2833x.getProcessorInfo" t ;; (function)
           "codertarget.tic2000.pinmap.F2833x.getRegisterGroups" t ;; (function)
           "codertarget.tic2000.pinmap.F2833x.getSCIPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2834x.getECANPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2834x.getEPWMPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2834x.getGPIOGroups" t ;; (function)
           "codertarget.tic2000.pinmap.F2834x.getGPIOPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2834x.getI2CPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2834x.getInterruptDefinitions" t ;; (function)
           "codertarget.tic2000.pinmap.F2834x.getProcessorInfo" t ;; (function)
           "codertarget.tic2000.pinmap.F2834x.getRegisterGroups" t ;; (function)
           "codertarget.tic2000.pinmap.F2834x.getSCIPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2837xS.getECANPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2837xS.getECAPPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2837xS.getEPWMPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2837xS.getEQEPPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2837xS.getGPIOGroups" t ;; (function)
           "codertarget.tic2000.pinmap.F2837xS.getGPIOPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2837xS.getI2CPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2837xS.getInterruptDefinitions" t ;; (function)
           "codertarget.tic2000.pinmap.F2837xS.getMUXInputforClbXbar" t ;; (function)
           "codertarget.tic2000.pinmap.F2837xS.getMUXInputforePWMXbar" t ;; (function)
           "codertarget.tic2000.pinmap.F2837xS.getMUXInputforOutputXbar" t ;; (function)
           "codertarget.tic2000.pinmap.F2837xS.getProcessorInfo" t ;; (function)
           "codertarget.tic2000.pinmap.F2837xS.getRegisterGroups" t ;; (function)
           "codertarget.tic2000.pinmap.F2837xS.getSCIPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2838x.getAnalogGPIOPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2838x.getECANPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2838x.getECAPPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2838x.getEPWMPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2838x.getEQEPPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2838x.getGPIOGroups" t ;; (function)
           "codertarget.tic2000.pinmap.F2838x.getGPIOPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2838x.getHRCAPISRData" t ;; (function)
           "codertarget.tic2000.pinmap.F2838x.getI2CPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2838x.getInputforCLBTile" t ;; (function)
           "codertarget.tic2000.pinmap.F2838x.getInterruptDefinitions" t ;; (function)
           "codertarget.tic2000.pinmap.F2838x.getMCANPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F2838x.getMUXInputforClbXbar" t ;; (function)
           "codertarget.tic2000.pinmap.F2838x.getMUXInputforePWMXbar" t ;; (function)
           "codertarget.tic2000.pinmap.F2838x.getMUXInputforOutputXbar" t ;; (function)
           "codertarget.tic2000.pinmap.F2838x.getProcessorInfo" t ;; (function)
           "codertarget.tic2000.pinmap.F2838x.getRegisterGroups" t ;; (function)
           "codertarget.tic2000.pinmap.F2838x.getSCIPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28M35x.getEPWMPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28M35x.getGPIOGroups" t ;; (function)
           "codertarget.tic2000.pinmap.F28M35x.getGPIOPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28M35x.getI2CPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28M35x.getInterruptDefinitions" t ;; (function)
           "codertarget.tic2000.pinmap.F28M35x.getProcessorInfo" t ;; (function)
           "codertarget.tic2000.pinmap.F28M35x.getRegisterGroups" t ;; (function)
           "codertarget.tic2000.pinmap.F28M35x.getSCIPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28M36x.getEPWMPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28M36x.getGPIOGroups" t ;; (function)
           "codertarget.tic2000.pinmap.F28M36x.getGPIOPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28M36x.getI2CPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28M36x.getInterruptDefinitions" t ;; (function)
           "codertarget.tic2000.pinmap.F28M36x.getProcessorInfo" t ;; (function)
           "codertarget.tic2000.pinmap.F28M36x.getRegisterGroups" t ;; (function)
           "codertarget.tic2000.pinmap.F28M36x.getSCIPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28p55x.getADCAnalogGPIOPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28p55x.getAnalogGPIOPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28p55x.getDMAInterruptSource" t ;; (function)
           "codertarget.tic2000.pinmap.F28p55x.getECAPPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28p55x.getEPWMPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28p55x.getEQEPPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28p55x.getGPIOGroups" t ;; (function)
           "codertarget.tic2000.pinmap.F28p55x.getGPIOPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28p55x.getI2CPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28p55x.getInputforCLBTile" t ;; (function)
           "codertarget.tic2000.pinmap.F28p55x.getInterruptDefinitions" t ;; (function)
           "codertarget.tic2000.pinmap.F28p55x.getMCANPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28p55x.getMUXInputforClbXbar" t ;; (function)
           "codertarget.tic2000.pinmap.F28p55x.getMUXInputforePWMXbar" t ;; (function)
           "codertarget.tic2000.pinmap.F28p55x.getMUXInputforOutputXbar" t ;; (function)
           "codertarget.tic2000.pinmap.F28p55x.getProcessorInfo" t ;; (function)
           "codertarget.tic2000.pinmap.F28p55x.getRegisterGroups" t ;; (function)
           "codertarget.tic2000.pinmap.F28p55x.getSCIPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28p55x.getSPIPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28p65x.getADCAnalogGPIOPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28p65x.getAnalogGPIOPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28p65x.getDMAInterruptSource" t ;; (function)
           "codertarget.tic2000.pinmap.F28p65x.getECANPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28p65x.getECAPPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28p65x.getEPWMPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28p65x.getEQEPPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28p65x.getGPIOGroups" t ;; (function)
           "codertarget.tic2000.pinmap.F28p65x.getGPIOPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28p65x.getHRCAPISRData" t ;; (function)
           "codertarget.tic2000.pinmap.F28p65x.getI2CPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28p65x.getInputforCLBTile" t ;; (function)
           "codertarget.tic2000.pinmap.F28p65x.getInterruptDefinitions" t ;; (function)
           "codertarget.tic2000.pinmap.F28p65x.getMCANPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28p65x.getMUXInputforClbXbar" t ;; (function)
           "codertarget.tic2000.pinmap.F28p65x.getMUXInputforePWMXbar" t ;; (function)
           "codertarget.tic2000.pinmap.F28p65x.getMUXInputforOutputXbar" t ;; (function)
           "codertarget.tic2000.pinmap.F28p65x.getProcessorInfo" t ;; (function)
           "codertarget.tic2000.pinmap.F28p65x.getRegisterGroups" t ;; (function)
           "codertarget.tic2000.pinmap.F28p65x.getSCIPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28p65x.getSDFMPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F28p65x.getSPIPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F29h85x.getADCAnalogGPIOPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F29h85x.getAnalogGPIOPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F29h85x.getEPWMPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F29h85x.getGPIOGroups" t ;; (function)
           "codertarget.tic2000.pinmap.F29h85x.getGPIOPinData" t ;; (function)
           "codertarget.tic2000.pinmap.F29h85x.getInterruptDefinitions" t ;; (function)
           "codertarget.tic2000.pinmap.F29h85x.getMUXInputforePWMXbar" t ;; (function)
           "codertarget.tic2000.pinmap.F29h85x.getProcessorInfo" t ;; (function)
           "codertarget.tic2000.pinmap.F29h85x.getUARTPinData" t ;; (function)
           "codertarget.tic2000.pinmap.getCLBData" t ;; (function)
           "codertarget.tic2000.pinmap.getFamily1InterruptEvents" t ;; (function)
           "codertarget.tic2000.pinmap.getFamily2InterruptEvents" t ;; (function)
           "codertarget.tic2000.pinmap.getGPIOListForPeripheral" t ;; (function)
           "codertarget.tic2000.pinmap.getGPIOProfilerPinData" t ;; (function)
           "codertarget.tic2000.pinmap.getProcessorsWithParmeter" t ;; (function)
           "codertarget.tic2000.pinmap.getTargetFamiliesMapWithToolChain" t ;; (function)
           "codertarget.tic2000.pinmap.getTargetFamiliesWithFINTDIV" t ;; (function)
           "codertarget.tic2000.pinmap.getTargetFamiliesWithTMU1" t ;; (function)
           "codertarget.tic2000.pinmap.getTargetFamilyFileFormat" t ;; (function)
           "codertarget.tic2000.pinmap.getTIDriverTokenAndPath" t ;; (function)
           "codertarget.tic2000.procinfo.F28377D" t ;; (function)
           "codertarget.tic2000.procinfo.F28379D" t ;; (function)
           "codertarget.tic2000.procinfo.F28384D" t ;; (function)
           "codertarget.tic2000.procinfo.F28384S" t ;; (function)
           "codertarget.tic2000.procinfo.F28386D" t ;; (function)
           "codertarget.tic2000.procinfo.F28386S" t ;; (function)
           "codertarget.tic2000.procinfo.F28388D" t ;; (function)
           "codertarget.tic2000.procinfo.F28388S" t ;; (function)
           "codertarget.tic2000.sensors.c2000.getTargetSensorUtilities" t ;; (function)
           "codertarget.tic2000.sensors.c2000.getValidatedI2CModuleInfo" t ;; (function)
           "codertarget.tic2000.sensors.c2000.I2CSensorUtilities" t ;; (class)
           "codertarget.tic2000.sensors.c2000.I2CSensorUtilities.getDescriptiveName" t ;; (method)
           "codertarget.tic2000.sensors.c2000.I2CSensorUtilities.isSupportedContext" t ;; (method)
           "codertarget.tic2000.sensors.c2000.I2CSensorUtilities.updateBuildInfo" t ;; (method)
           "codertarget.tic2000.setExecutionProfileBufferLength" t ;; (function)
           "codertarget.tic2000.setSerialPortPreferences" t ;; (function)
           "codertarget.tools.AfterCodeGenGlobals" t ;; (class)
           "codertarget.tools.AfterCodeGenGlobals.clear" t ;; (method)
           "codertarget.tools.AfterCodeGenGlobals.getIsNewGeneratedCode" t ;; (method)
           "codertarget.tools.AfterCodeGenGlobals.getIsPil" t ;; (method)
           "codertarget.tools.AfterCodeGenGlobals.setIsNewGeneratedCode" t ;; (method)
           "codertarget.tools.AfterCodeGenGlobals.setIsPil" t ;; (method)
           "codertarget.tools.deprecationNotification" t ;; (function)
           "codertarget.tools.getApplicationExtension" t ;; (function)
           "codertarget.tools.getAuxiliaryMakefileContent" t ;; (function)
           "codertarget.tools.getThirdPartyToolDir" t ;; (function)
           "codertarget.tools.TargetSLHook" t ;; (class)
           "codertarget.updateExtension" t ;; (function)
           "codertarget.utils.configureXCPExtModeSimulationTime" t ;; (function)
           "codertarget.utils.enableXCPExtModeInterface" t ;; (function)
           "codertarget.utils.externalModeBuildActionParameterCallback" t ;; (function)
           "codertarget.utils.findCLATaskManager" t ;; (function)
           "codertarget.utils.findTaskManager" t ;; (function)
           "codertarget.utils.getCLAConfiguration" t ;; (function)
           "codertarget.utils.getDebugFileExtension" t ;; (function)
           "codertarget.utils.getDefaultHardwareBoardSelection" t ;; (function)
           "codertarget.utils.getDefaultToolchainName" t ;; (function)
           "codertarget.utils.getDialogCustomizations" t ;; (function)
           "codertarget.utils.getDropDownItemFromBoard" t ;; (function)
           "codertarget.utils.getEvaledParameterInfo" t ;; (function)
           "codertarget.utils.getExecutableFile" t ;; (function)
           "codertarget.utils.getExtModeWidgets" t ;; (function)
           "codertarget.utils.getFilesInFolder" t ;; (function)
           "codertarget.utils.getFPGADesignWidgets" t ;; (function)
           "codertarget.utils.getHardwareDiagnosticsWidgets" t ;; (function)
           "codertarget.utils.getMaxPhysicalCores" t ;; (function)
           "codertarget.utils.getModelForBlock" t ;; (function)
           "codertarget.utils.getNumHardwareInterruptBlocks" t ;; (function)
           "codertarget.utils.getOrSetSTFInfo" t ;; (function)
           "codertarget.utils.getParallelBuildArg" t ;; (function)
           "codertarget.utils.getParameterDialogInfo" t ;; (function)
           "codertarget.utils.getProfilerWidgets" t ;; (function)
           "codertarget.utils.getRegisteredCPUs" t ;; (function)
           "codertarget.utils.getRTOSWidgets" t ;; (function)
           "codertarget.utils.getSchedulerWidgets" t ;; (function)
           "codertarget.utils.getSimulationDiagnosticsWidgets" t ;; (function)
           "codertarget.utils.getSimulationStopTimeInTicks" t ;; (function)
           "codertarget.utils.getSimulationWidgets" t ;; (function)
           "codertarget.utils.getTargetFrameworkBoardEntries" t ;; (function)
           "codertarget.utils.getTargetHardwareDetailWidgets" t ;; (function)
           "codertarget.utils.getTargetHardwareSelectionWidget" t ;; (function)
           "codertarget.utils.getTargetHardwareSelectionWidgetEntries" t ;; (function)
           "codertarget.utils.getTargetLinkObj" t ;; (function)
           "codertarget.utils.invokeDownloader" t ;; (function)
           "codertarget.utils.isBaremetal" t ;; (function)
           "codertarget.utils.isBoardECCompatible" t ;; (function)
           "codertarget.utils.isBoardSoCCompatible" t ;; (function)
           "codertarget.utils.isC2000Installed" t ;; (function)
           "codertarget.utils.isCLATaskManagerBlock" t ;; (function)
           "codertarget.utils.isCLATaskManagerFound" t ;; (function)
           "codertarget.utils.isConfiguredForSocShared" t ;; (function)
           "codertarget.utils.isECInstalled" t ;; (function)
           "codertarget.utils.isESBEnabled" t ;; (function)
           "codertarget.utils.isESBProcessorOnly" t ;; (function)
           "codertarget.utils.isHeterogenousProcessorBoard" t ;; (function)
           "codertarget.utils.isMdlConfiguredForSoC" t ;; (function)
           "codertarget.utils.isMdlSetForSoCBoard" t ;; (function)
           "codertarget.utils.isPeripheralBlockUsed" t ;; (function)
           "codertarget.utils.isSoCInstalled" t ;; (function)
           "codertarget.utils.isSoCInstalledAndModelConfiguredForSoC" t ;; (function)
           "codertarget.utils.isSoCSpPkgInstalledForSelectedBoard" t ;; (function)
           "codertarget.utils.isSpPkgInstalledForSelectedBoard" t ;; (function)
           "codertarget.utils.isTargetFrameworkTarget" t ;; (function)
           "codertarget.utils.isTaskAutoMappingSupported" t ;; (function)
           "codertarget.utils.isTaskBlockUsed" t ;; (function)
           "codertarget.utils.isTaskManagerFound" t ;; (function)
           "codertarget.utils.isTaskMappingEditable" t ;; (function)
           "codertarget.utils.isTaskMappingSupported" t ;; (function)
           "codertarget.utils.isUseStreamingProfiler" t ;; (function)
           "codertarget.utils.isXCPBuild" t ;; (function)
           "codertarget.utils.replacePathSep" t ;; (function)
           "codertarget.utils.replaceTokens" t ;; (function)
           "codertarget.utils.replaceTokensforHardwareName" t ;; (function)
           "codertarget.utils.replaceTokensFromTokenArray" t ;; (function)
           "codertarget.utils.setCodeGenFolderStructure" t ;; (function)
           "codertarget.utils.setESBPluginAttached" t ;; (function)
           "codertarget.utils.shouldESBPluginBeAttached" t ;; (function)
           "codertarget.utils.toggleXCPfeatures" t ;; (function)
           "codertarget.utils.updateParameterValue" t ;; (function)
           "codertarget.utils.XCPMemoryConfiguration" t ;; (class)
           "codertarget.utils.XCPMemoryConfiguration.getProtocolConfig" t ;; (method)
           "codertest.diagnostics.ExportableDiagnostic" t ;; (class)
           "codertest.diagnostics.ExportableDiagnostic.join" t ;; (method)
           "codertest.diagnostics.MATLABCodeGenerationOutputDiagnostic" t ;; (class)
           "codertest.diagnostics.MATLABCodeGenerationOutputDiagnostic.join" t ;; (method)
           "codertest.diagnostics.MATLABCodeGenerationReproStepsDiagnostic" t ;; (class)
           "codertest.diagnostics.MATLABCodeGenerationReproStepsDiagnostic.join" t ;; (method)
           "codertest.diagnostics.MexProgramExecutionReproStepsDiagnostic" t ;; (class)
           "codertest.diagnostics.MexProgramExecutionReproStepsDiagnostic.join" t ;; (method)
           "coderTypeEditor" t ;; (pFile) Launch the Coder Type Editor dialog box
           "codetoolsswitchyard" t ;; (mFile)
           "codistributed" t ;; (mFile) Access elements of arrays distributed among workers in parallel pool
           "codistributed.build" t ;; (method)
           "codistributed.cell" t ;; (method)
           "codistributed.colon" t ;; (method)
           "codistributed.linspace" t ;; (method)
           "codistributed.loadobj" t ;; (method)
           "codistributed.logspace" t ;; (method)
           "codistributed.spalloc" t ;; (method)
           "codistributed.speye" t ;; (method)
           "codistributed.sprand" t ;; (method)
           "codistributed.sprandn" t ;; (method)
           "codistributed.sprandsym" t ;; (method)
           "codistributor" t ;; (mFile) Create codistributor object for codistributed arrays
           "codistributor1d" t ;; (mFile) 1-D distribution scheme for codistributed array
           "codistributor1d.defaultPartition" t ;; (method)
           "codistributor1d.unsetDimension" 'property
           "codistributor1d.unsetPartition" 'property
           "codistributor2dbc" t ;; (mFile) 2-D block-cyclic distribution scheme for codistributed array
           "codistributor2dbc.defaultBlockSize" 'property
           "codistributor2dbc.defaultOrientation" 'property
           "codistributor2dbc.defaultWorkerGrid" t ;; (method)
           "codonbias" t ;; (mFile) Calculate codon frequency for each amino acid coded for in nucleotide sequence
           "codoncount" t ;; (mFile) Count codons in nucleotide sequence
           "coeread" t ;; (mFile) Read Xilinx COE file
           "coewrite" t ;; (mFile) Write Xilinx COE file
           "cohere" t ;; (mFile)
           "coiflift" t ;; (mFile)
           "coifwavf" t ;; (mFile) Coiflet wavelet filter
           "coincidence" t ;; (mFile) Coincidence algorithm
           "col2im" t ;; (mFile) Rearrange matrix columns into blocks
           "colamd" t ;; (mFile) Column approximate minimum degree permutation
           "colbut" t ;; (mFile)
           "colfilt" t ;; (mFile) Column-wise neighborhood operations
           "collig" t ;; (mFile)
           "collintest" t ;; (mFile) Belsley collinearity diagnostics
           "collisionBox" t ;; (mFile) Create box collision geometry
           "collisionCapsule" t ;; (mFile) Capsule primitive collision geometry
           "collisionCylinder" t ;; (mFile) Create collision cylinder geometry
           "collisionMesh" t ;; (mFile) Create convex mesh collision geometry
           "collisionSphere" t ;; (mFile) Create sphere collision geometry
           "collisionVHACD" t ;; (mFile) Decompose mesh into convex collision meshes using V-HACD
           "colon" t ;; (mFile) Vector creation, array subscripting, and for-loop iteration
           "color2background" t ;; (mFile)
           "colorangle" t ;; (mFile) Angle between two RGB vectors
           "colorbar" t ;; (mFile) Colorbar showing color scale
           "colorChecker" t ;; (mFile) Calibrite ColorChecker test chart
           "colorcloud" t ;; (mFile) Display 3-D color gamut as point cloud in specified color space
           "colorcube" t ;; (mFile) Colorcube colormap array
           "colordef" t ;; (mFile) (Removed) Set default property values to display different color schemes
           "colormap" t ;; (mFile) View and set current colormap
           "colormapeditor" t ;; (mFile)
           "colormaplist" t ;; (mFile) List available colormaps
           "colornone" t ;; (mFile)
           "colororder" t ;; (mFile) Set or query color order palette
           "colorThresholder" t ;; (mFile) Threshold color image
           "ColorUtil" t ;; (mFile)
           "ColorUtil.Instance" t ;; (method)
           "colperm" t ;; (mFile) Sparse column permutation based on nonzero count
           "colstyle" t ;; (mFile)
           "combinations" t ;; (mFile) Generate all element combinations of arrays
           "combine" t ;; (mFile) Combine data from multiple datastores
           "combineExternalSources" t ;; (pFile)
           "combnk" t ;; (mFile) (Not recommended) Enumeration of combinations
           "combvec" t ;; (mFile) Create all combinations of vectors
           "comet" t ;; (mFile) 2-D comet plot
           "comet3" t ;; (mFile) 3-D comet plot
           "comm.ACPR" t ;; (class)
           "comm.AGC" t ;; (class)
           "comm.Amplifier" t ;; (class)
           "comm.APPDecoder" t ;; (class)
           "comm.AWGNChannel" t ;; (class)
           "comm.BarkerCode" t ;; (class)
           "comm.BasebandFileReader" t ;; (class)
           "comm.BasebandFileWriter" t ;; (class)
           "comm.BCHDecoder" t ;; (class)
           "comm.BCHEncoder" t ;; (class)
           "comm.BPSKDemodulator" t ;; (class)
           "comm.BPSKDemodulator.helpFixedPoint" t ;; (method)
           "comm.BPSKModulator" t ;; (class)
           "comm.BPSKModulator.helpFixedPoint" t ;; (method)
           "comm.CarrierSynchronizer" t ;; (class)
           "comm.CCDF" t ;; (class)
           "comm.ChannelFilter" t ;; (class)
           "comm.CoarseFrequencyCompensator" t ;; (class)
           "comm.CommonSets" t ;; (class)
           "comm.CommonSets.AlgebraicIntlvMethod" 'property
           "comm.CommonSets.Algorithm" 'property
           "comm.CommonSets.AutoOrProperty" 'property
           "comm.CommonSets.BinaryGrayCustom" 'property
           "comm.CommonSets.BinaryOrGray" 'property
           "comm.CommonSets.BitDataType" 'property
           "comm.CommonSets.DecisionOptions" 'property
           "comm.CommonSets.DoubleInt8" 'property
           "comm.CommonSets.DoubleLogicalSmallestUnsigned" 'property
           "comm.CommonSets.DoubleOrSingle" 'property
           "comm.CommonSets.FrequencyPulseShapes" 'property
           "comm.CommonSets.getSet" t ;; (method)
           "comm.CommonSets.IntDataType" 'property
           "comm.CommonSets.LogicalOrDouble" 'property
           "comm.CommonSets.NoneOrProperty" 'property
           "comm.CommonSets.NormalizationMethods" 'property
           "comm.CommonSets.OutDataType" 'property
           "comm.CommonSets.Polarity" 'property
           "comm.CommonSets.ResetOptions" 'property
           "comm.CommonSets.SameAsInputDoubleLogical" 'property
           "comm.CommonSets.SignedIntDataType" 'property
           "comm.CommonSets.SignedOutDataType" 'property
           "comm.CommonSets.SpecifyInputs" 'property
           "comm.CommonSets.TerminationMethod" 'property
           "comm.CommonSets.UnsignedBitDataType" 'property
           "comm.CommonSets.UnsignedIntDataType" 'property
           "comm.CommonSetsHDL" t ;; (class)
           "comm.CommonSetsHDL.AlgebraicIntlvMethod" 'property
           "comm.CommonSetsHDL.Algorithm" 'property
           "comm.CommonSetsHDL.AutoOrProperty" 'property
           "comm.CommonSetsHDL.BinaryGrayCustom" 'property
           "comm.CommonSetsHDL.BinaryOrGray" 'property
           "comm.CommonSetsHDL.BitDataType" 'property
           "comm.CommonSetsHDL.DecisionOptions" 'property
           "comm.CommonSetsHDL.DoubleInt8" 'property
           "comm.CommonSetsHDL.DoubleLogicalSmallestUnsigned" 'property
           "comm.CommonSetsHDL.DoubleOrSingle" 'property
           "comm.CommonSetsHDL.FrequencyPulseShapes" 'property
           "comm.CommonSetsHDL.getSet" t ;; (method)
           "comm.CommonSetsHDL.IntDataType" 'property
           "comm.CommonSetsHDL.LogicalOrDouble" 'property
           "comm.CommonSetsHDL.NoneOrProperty" 'property
           "comm.CommonSetsHDL.NormalizationMethods" 'property
           "comm.CommonSetsHDL.OutDataType" 'property
           "comm.CommonSetsHDL.Polarity" 'property
           "comm.CommonSetsHDL.ResetOptions" 'property
           "comm.CommonSetsHDL.SameAsInputDoubleLogical" 'property
           "comm.CommonSetsHDL.SignedIntDataType" 'property
           "comm.CommonSetsHDL.SignedOutDataType" 'property
           "comm.CommonSetsHDL.SpecifyInputs" 'property
           "comm.CommonSetsHDL.TerminationMethod" 'property
           "comm.CommonSetsHDL.UnsignedBitDataType" 'property
           "comm.CommonSetsHDL.UnsignedIntDataType" 'property
           "comm.ConstellationDiagram" t ;; (class)
           "comm.Contents" t ;; (function)
           "comm.ConvolutionalDeinterleaver" t ;; (class)
           "comm.ConvolutionalEncoder" t ;; (class)
           "comm.ConvolutionalInterleaver" t ;; (class)
           "comm.CPFSKDemodulator" t ;; (class)
           "comm.CPFSKModulator" t ;; (class)
           "comm.CPMDemodulator" t ;; (class)
           "comm.CPMModulator" t ;; (class)
           "comm.CRCDetector" t ;; (class)
           "comm.CRCGenerator" t ;; (class)
           "comm.DBPSKDemodulator" t ;; (class)
           "comm.DBPSKModulator" t ;; (class)
           "comm.DecisionFeedbackEqualizer" t ;; (class)
           "comm.Descrambler" t ;; (class)
           "comm.DifferentialDecoder" t ;; (class)
           "comm.DifferentialEncoder" t ;; (class)
           "comm.DiscreteTimeVCO" t ;; (class)
           "comm.DPD" t ;; (class)
           "comm.DPDCoefficientEstimator" t ;; (class)
           "comm.DPSKDemodulator" t ;; (class)
           "comm.DPSKModulator" t ;; (class)
           "comm.DQPSKDemodulator" t ;; (class)
           "comm.DQPSKModulator" t ;; (class)
           "comm.ErrorRate" t ;; (class)
           "comm.EVM" t ;; (class)
           "comm.FMBroadcastDemodulator" t ;; (class)
           "comm.FMBroadcastModulator" t ;; (class)
           "comm.FMDemodulator" t ;; (class)
           "comm.FMModulator" t ;; (class)
           "comm.FSKDemodulator" t ;; (class)
           "comm.FSKModulator" t ;; (class)
           "comm.GeneralQAMDemodulator" t ;; (class)
           "comm.GeneralQAMDemodulator.helpFixedPoint" t ;; (method)
           "comm.GeneralQAMModulator" t ;; (class)
           "comm.GeneralQAMModulator.helpFixedPoint" t ;; (method)
           "comm.GeneralQAMTCMDemodulator" t ;; (class)
           "comm.GeneralQAMTCMModulator" t ;; (class)
           "comm.GMSKDemodulator" t ;; (class)
           "comm.GMSKModulator" t ;; (class)
           "comm.GMSKTimingSynchronizer" t ;; (class)
           "comm.GoldSequence" t ;; (class)
           "comm.gpu.AWGNChannel" t ;; (class)
           "comm.gpu.BlockDeinterleaver" t ;; (class)
           "comm.gpu.BlockInterleaver" t ;; (class)
           "comm.gpu.ConvolutionalDeinterleaver" t ;; (class)
           "comm.gpu.ConvolutionalEncoder" t ;; (class)
           "comm.gpu.ConvolutionalInterleaver" t ;; (class)
           "comm.gpu.LDPCDecoder" t ;; (class)
           "comm.gpu.PSKDemodulator" t ;; (class)
           "comm.gpu.PSKModulator" t ;; (class)
           "comm.gpu.TurboDecoder" t ;; (class)
           "comm.gpu.ViterbiDecoder" t ;; (class)
           "comm.HadamardCode" t ;; (class)
           "comm.HDLCRCDetector" t ;; (class)
           "comm.HDLCRCGenerator" t ;; (class)
           "comm.HDLRSDecoder" t ;; (class)
           "comm.HDLRSEncoder" t ;; (class)
           "comm.HelicalDeinterleaver" t ;; (class)
           "comm.HelicalInterleaver" t ;; (class)
           "comm.IntegrateAndDumpFilter" t ;; (class)
           "comm.IntegrateAndDumpFilter.helpFixedPoint" t ;; (method)
           "comm.internalcodegen.IntegerRSDecoder" t ;; (class)
           "comm.internalcodegen.IntegerRSEncoder" t ;; (class)
           "comm.IQImbalanceCompensator" t ;; (class)
           "comm.KasamiSequence" t ;; (class)
           "comm.LDPCDecoder" t ;; (class)
           "comm.LDPCEncoder" t ;; (class)
           "comm.LinearEqualizer" t ;; (class)
           "comm.MemorylessNonlinearity" t ;; (class)
           "comm.MER" t ;; (class)
           "comm.MIMOChannel" t ;; (class)
           "comm.MLSEEqualizer" t ;; (class)
           "comm.MSKDemodulator" t ;; (class)
           "comm.MSKModulator" t ;; (class)
           "comm.MSKTimingSynchronizer" t ;; (class)
           "comm.MultibandCombiner" t ;; (class)
           "comm.MultiplexedDeinterleaver" t ;; (class)
           "comm.MultiplexedInterleaver" t ;; (class)
           "comm.OFDMDemodulator" t ;; (class)
           "comm.OFDMModulator" t ;; (class)
           "comm.OQPSKDemodulator" t ;; (class)
           "comm.OQPSKModulator" t ;; (class)
           "comm.OSTBCCombiner" t ;; (class)
           "comm.OSTBCCombiner.helpFixedPoint" t ;; (method)
           "comm.OSTBCEncoder" t ;; (class)
           "comm.OSTBCEncoder.helpFixedPoint" t ;; (method)
           "comm.OVSFCode" t ;; (class)
           "comm.PAMDemodulator" t ;; (class)
           "comm.PAMDemodulator.helpFixedPoint" t ;; (method)
           "comm.PAMModulator" t ;; (class)
           "comm.PAMModulator.helpFixedPoint" t ;; (method)
           "comm.PhaseFrequencyOffset" t ;; (class)
           "comm.PhaseNoise" t ;; (class)
           "comm.PNSequence" t ;; (class)
           "comm.PreambleDetector" t ;; (class)
           "comm.PSKDemodulator" t ;; (class)
           "comm.PSKDemodulator.helpFixedPoint" t ;; (method)
           "comm.PSKModulator" t ;; (class)
           "comm.PSKModulator.helpFixedPoint" t ;; (method)
           "comm.PSKTCMDemodulator" t ;; (class)
           "comm.PSKTCMModulator" t ;; (class)
           "comm.QPSKDemodulator" t ;; (class)
           "comm.QPSKDemodulator.helpFixedPoint" t ;; (method)
           "comm.QPSKModulator" t ;; (class)
           "comm.QPSKModulator.helpFixedPoint" t ;; (method)
           "comm.RaisedCosineReceiveFilter" t ;; (class)
           "comm.RaisedCosineReceiveFilter.helpFilterAnalysis" t ;; (method)
           "comm.RaisedCosineTransmitFilter" t ;; (class)
           "comm.RaisedCosineTransmitFilter.helpFilterAnalysis" t ;; (method)
           "comm.Ray" t ;; (class)
           "comm.RayleighChannel" t ;; (class)
           "comm.RayTracingChannel" t ;; (class)
           "comm.RBDSWaveformGenerator" t ;; (class)
           "comm.RectangularQAMTCMDemodulator" t ;; (class)
           "comm.RectangularQAMTCMModulator" t ;; (class)
           "comm.RicianChannel" t ;; (class)
           "comm.RSDecoder" t ;; (class)
           "comm.RSEncoder" t ;; (class)
           "comm.SampleRateOffset" t ;; (class)
           "comm.scopes.evalReferenceConstellation" t ;; (function)
           "comm.scopes.evaluateExpression" t ;; (function)
           "comm.scopes.evalValidateReferenceConstellation" t ;; (function)
           "comm.scopes.getActualRefCon" t ;; (function)
           "comm.scopes.getNumInputMATLABExpression" t ;; (function)
           "comm.Scrambler" t ;; (class)
           "comm.SphereDecoder" t ;; (class)
           "comm.SymbolSynchronizer" t ;; (class)
           "comm.ThermalNoise" t ;; (class)
           "comm.TurboDecoder" t ;; (class)
           "comm.TurboEncoder" t ;; (class)
           "comm.ViterbiDecoder" t ;; (class)
           "comm.ViterbiDecoder.helpFixedPoint" t ;; (method)
           "comm.WalshCode" t ;; (class)
           "comm_links" t ;; (mFile) Library link information for Communications Toolbox blocks
           "commAmplifierTransform" t ;; (mFile)
           "commanabbnd3" t ;; (slxFile)
           "commanapbnd3" t ;; (slxFile)
           "commandhistory" t ;; (mFile) View previously run statements
           "commandwindow" t ;; (mFile) Enter statements at the command line
           "commAPSKDemodTransform" t ;; (mFile)
           "commautoscaler.GenQAMModulatorAutoscaler" t ;; (class)
           "commautoscaler.InheritAnyExceptDTypeFromRefPort" t ;; (class)
           "commautoscaler.ModulatorAutoscaler" t ;; (class)
           "commautoscaler.MPAMModulatorAutoscaler" t ;; (class)
           "commautoscaler.MPSKModulatorAutoscaler" t ;; (class)
           "commautoscaler.OQPSKModulatorAutoscaler" t ;; (class)
           "commautoscaler.RectQAMModulatorAutoscaler" t ;; (class)
           "commAWGNBlockCompileCheck" t ;; (mFile)
           "commAWGNChannelTransform" t ;; (mFile)
           "commblkagctransform" t ;; (mFile)
           "commblkalgintrlvr" t ;; (mFile)
           "commblkam3" t ;; (mFile)
           "commblkampmod" t ;; (mFile)
           "commblkangmod" t ;; (mFile)
           "commblkapp" t ;; (mFile)
           "commblkawgnchan2" t ;; (mFile)
           "commblkbchrs" t ;; (mFile)
           "commblkbernoullicb" t ;; (mFile)
           "commblkbitounipolar" t ;; (mFile)
           "commblkbittointeger" t ;; (mFile)
           "commblkbschan" t ;; (mFile)
           "commblkCheckInistates" t ;; (mFile)
           "commblkCheckPolynomial" t ;; (mFile)
           "commblkcod2" t ;; (slxFile)
           "commblkconvcod2" t ;; (mFile)
           "commblkcpfskdemod" t ;; (mFile)
           "commblkcpfskmod" t ;; (mFile)
           "commblkcpmdemod" t ;; (mFile)
           "commblkcpmmod" t ;; (mFile)
           "commblkcrcgen" t ;; (mFile)
           "commblkcurrentlib" t ;; (mFile)
           "commblkdemodpm3" t ;; (mFile)
           "commblkdigbbndmod" t ;; (mFile)
           "commblkdrpt2" t ;; (mFile)
           "commblkeqsignlms" t ;; (mFile)
           "commblkequpdateports" t ;; (mFile)
           "commblkerrrate" t ;; (mFile)
           "commblkfadingchan2" t ;; (mFile)
           "commblkfinddelay" t ;; (mFile)
           "commblkfreqoffset" t ;; (mFile)
           "commblkgaussfilt" t ;; (mFile)
           "commblkgcgen3" t ;; (mFile)
           "commblkgeneralqamdemod" t ;; (mFile)
           "commblkgentcmdec" t ;; (mFile)
           "commblkgentcmenc" t ;; (mFile)
           "commblkGetCommFiltDTRowInfo" t ;; (mFile)
           "commblkGetModDemodBlkIconStrM_ary" t ;; (mFile)
           "commblkgmskdemod" t ;; (mFile)
           "commblkgmskmod" t ;; (mFile)
           "commblkinterl" t ;; (mFile)
           "commblkintrlv2" t ;; (slxFile)
           "commblkksgen3" t ;; (mFile)
           "commblkldpcdecode" t ;; (mFile)
           "commblkmapdata" t ;; (mFile)
           "commblkmemorylessnonlin" t ;; (mFile)
           "commblkmlseeq" t ;; (mFile)
           "commblkmorelib" t ;; (mFile)
           "commblkmpamdemod" t ;; (mFile)
           "commblkmpskdemod" t ;; (mFile)
           "commblkmskdemod" t ;; (mFile)
           "commblkmskmod" t ;; (mFile)
           "commblkMultibandCombiner" t ;; (mFile)
           "commblkoqpskmod" t ;; (mFile)
           "commblkostbcenccomb" t ;; (mFile)
           "commblkovsfcgen" t ;; (mFile)
           "commblkpnseq3" t ;; (mFile)
           "commblkpsktcmdec" t ;; (mFile)
           "commblkpsktcmenc" t ;; (mFile)
           "commblkqamtcmdec" t ;; (mFile)
           "commblkqamtcmenc" t ;; (mFile)
           "commblkquantdec" t ;; (mFile)
           "commblkquantenc" t ;; (mFile)
           "commblkrandsrctransform" t ;; (mFile)
           "commblkrcfiltrx" t ;; (mFile)
           "commblkrcfilttransform" t ;; (mFile)
           "commblkrcfilttx" t ;; (mFile)
           "commblkrectpulse" t ;; (mFile)
           "commblkrectqamdemod" t ;; (mFile)
           "commblkSampleRateMatch" t ;; (mFile)
           "commblksBrokenLinksMapping" t ;; (mFile)
           "commblkscram2" t ;; (mFile)
           "commblksdrrshell" t ;; (mFile)
           "commblkseqgen2cb" t ;; (mFile)
           "commblkseqgentransform" t ;; (mFile)
           "commblksGetTrellisInfo" t ;; (mFile)
           "commblksprivate" t ;; (slxFile)
           "commblksSlupdateHelper" t ;; (mFile)
           "commblksViewConst" t ;; (mFile)
           "commblksViewConstCloseFigs" t ;; (mFile)
           "commblksynch" t ;; (mFile)
           "commblktcmdec_drawicon" t ;; (mFile)
           "commblktcmenc_cbopmode" t ;; (mFile)
           "commblktimrec" t ;; (mFile)
           "commblktimrecechk" t ;; (mFile)
           "commblktriggeredbuffer" t ;; (mFile)
           "commblkturbodec" t ;; (mFile)
           "commblkunitobipolar" t ;; (mFile)
           "commblkuserdefinedmapping" t ;; (mFile)
           "commblkvarlms" t ;; (mFile)
           "commblkviterbi2" t ;; (mFile)
           "commblkviterbi2cb" t ;; (mFile)
           "commblkwcgen" t ;; (mFile)
           "commblkwininteg" t ;; (mFile)
           "commblkwinintegchk" t ;; (mFile)
           "commBSCTransform" t ;; (mFile)
           "commchan3" t ;; (slxFile)
           "commcnvcod2" t ;; (slxFile)
           "commcnvintrlv2" t ;; (slxFile)
           "commcodegen.APPDecoder" t ;; (class)
           "commcodegen.BCHDecoder" t ;; (class)
           "commcodegen.BCHEncoder" t ;; (class)
           "commcodegen.BPSKDemodulator" t ;; (class)
           "commcodegen.BPSKModulator" t ;; (class)
           "commcodegen.ConvolutionalDeinterleaver" t ;; (class)
           "commcodegen.ConvolutionalEncoder" t ;; (class)
           "commcodegen.ConvolutionalInterleaver" t ;; (class)
           "commcodegen.CRCDetector" t ;; (class)
           "commcodegen.CRCGenerator" t ;; (class)
           "commcodegen.DBPSKModulator" t ;; (class)
           "commcodegen.Descrambler" t ;; (class)
           "commcodegen.DPSKDemodulator" t ;; (class)
           "commcodegen.DPSKModulator" t ;; (class)
           "commcodegen.DQPSKDemodulator" t ;; (class)
           "commcodegen.DQPSKModulator" t ;; (class)
           "commcodegen.FSKDemodulator" t ;; (class)
           "commcodegen.FSKModulator" t ;; (class)
           "commcodegen.GeneralQAMDemodulator" t ;; (class)
           "commcodegen.GeneralQAMModulator" t ;; (class)
           "commcodegen.GeneralQAMTCMDemodulator" t ;; (class)
           "commcodegen.GMSKTimingSynchronizer" t ;; (class)
           "commcodegen.IntegrateAndDumpFilter" t ;; (class)
           "commcodegen.KasamiSequence" t ;; (class)
           "commcodegen.LDPCEncoder" t ;; (class)
           "commcodegen.MLSEEqualizer" t ;; (class)
           "commcodegen.MSKTimingSynchronizer" t ;; (class)
           "commcodegen.MultiplexedDeinterleaver" t ;; (class)
           "commcodegen.MultiplexedInterleaver" t ;; (class)
           "commcodegen.OSTBCCombiner" t ;; (class)
           "commcodegen.OSTBCEncoder" t ;; (class)
           "commcodegen.PAMModulator" t ;; (class)
           "commcodegen.PNSequence" t ;; (class)
           "commcodegen.PSKDemodulator" t ;; (class)
           "commcodegen.PSKModulator" t ;; (class)
           "commcodegen.PSKTCMDemodulator" t ;; (class)
           "commcodegen.QPSKDemodulator" t ;; (class)
           "commcodegen.QPSKModulator" t ;; (class)
           "commcodegen.RectangularQAMTCMDemodulator" t ;; (class)
           "commcodegen.Scrambler" t ;; (class)
           "commcodegen.ViterbiDecoder" t ;; (class)
           "commcrc2" t ;; (slxFile)
           "commCRCTransform" t ;; (mFile)
           "commDBPSKDemodBlockCompileCheck" t ;; (mFile)
           "commDBPSKTransform" t ;; (mFile)
           "commdemoslib" t ;; (slxFile)
           "commdevice.abstractDevice" t ;; (class)
           "commdhelp" t ;; (mFile)
           "commdigbbnd2" t ;; (slxFile)
           "commdigbbndam3" t ;; (slxFile)
           "commdigbbndapm" t ;; (slxFile)
           "commdigbbndcpm2" t ;; (slxFile)
           "commdigbbndfm2" t ;; (slxFile)
           "commdigbbndpm2ReplaceBlocks" t ;; (mFile)
           "commdigbbndpm3" t ;; (slxFile)
           "commdigbbndstd" t ;; (slxFile)
           "commdigbbndtcm2" t ;; (slxFile)
           "commDVBSAPSKTransform" t ;; (mFile)
           "commedac2" t ;; (slxFile)
           "commeq3" t ;; (slxFile)
           "commeqprivlib" t ;; (slxFile)
           "commfilt2" t ;; (slxFile)
           "commFixBrokenLinksIdealRecPulse" t ;; (mFile)
           "commFixBrokenLinksRateOption" t ;; (mFile)
           "commFixBrokenLinksRCos" t ;; (mFile)
           "commFrameUpgradeIPTransform" t ;; (mFile)
           "commFrameUpgradeROTransform" t ;; (mFile)
           "commgen2" t ;; (slxFile)
           "commgenrandsrc3" t ;; (slxFile)
           "commgenseqgen3" t ;; (slxFile)
           "commgraycode" t ;; (slxFile)
           "commhdlblkcod" t ;; (slxFile)
           "commhdlcnvcod" t ;; (slxFile)
           "commhdlcrc" t ;; (slxFile)
           "commhdldigbbndam" t ;; (slxFile)
           "commhdldigbbndpm" t ;; (slxFile)
           "commhdledac" t ;; (slxFile)
           "commhdledac2" t ;; (slxFile)
           "commhdlfilt" t ;; (slxFile)
           "commhdlframetosamples" t ;; (pFile)
           "commhdlinterleave" t ;; (slxFile)
           "commhdlio" t ;; (slxFile)
           "commhdllib" t ;; (slxFile)
           "commhdlmod" t ;; (slxFile)
           "commhdlMultipleFramesToSamples" t ;; (pFile)
           "commhdlSamplesToMultipleFrames" t ;; (pFile)
           "commhdlsink" t ;; (slxFile)
           "commhdlsource" t ;; (slxFile)
           "commhdlutilities" t ;; (slxFile)
           "comminterleave2" t ;; (slxFile)
           "commlib" t ;; (mFile) Open main Communications Toolbox block library
           "commlibhelp" t ;; (mFile)
           "commliblist" t ;; (mFile)
           "commlibv2" t ;; (slxFile)
           "commmaskedcaps" t ;; (pFile)
           "commMILQAMDemodTransform" t ;; (mFile)
           "commmimo" t ;; (slxFile)
           "commMIMOChannelTransform" t ;; (mFile)
           "commMNLTransform" t ;; (mFile)
           "commmod2" t ;; (slxFile)
           "commNewSISOChannelTransform" t ;; (mFile)
           "commobslib" t ;; (slxFile)
           "commofdm" t ;; (slxFile)
           "common.cgir.eml.mlfunctioninfo" t ;; (function)
           "commonplotfunc" t ;; (mFile)
           "commPhaseNoiseTransform" t ;; (mFile)
           "commprivate" t ;; (mFile)
           "commrandsrc2" t ;; (slxFile)
           "commrandsrc3" t ;; (slxFile)
           "commrfcorlib" t ;; (slxFile)
           "commrflib2" t ;; (slxFile)
           "comms" t ;; (mFile)
           "commseqgen2" t ;; (slxFile)
           "commseqgen3" t ;; (slxFile)
           "commsequence2" t ;; (slxFile)
           "commsink2" t ;; (slxFile)
           "commSISOChannelTransform" t ;; (mFile)
           "commsource2" t ;; (slxFile)
           "commsrc.combinedjitter" t ;; (class)
           "commsrc.diracjitter" t ;; (class)
           "commsrc.nrz" t ;; (class)
           "commsrc.pattern" t ;; (class)
           "commsrc.periodicjitter" t ;; (class)
           "commsrc.pn" t ;; (class)
           "commsrc.pn.loadobj" t ;; (method)
           "commsrc.randomjitter" t ;; (class)
           "commsrc.rz" t ;; (class)
           "commsrccod2" t ;; (slxFile)
           "commstr2poly" t ;; (mFile)
           "commSupportPackageCheck" t ;; (mFile)
           "commsync2" t ;; (slxFile)
           "commsynccomp2" t ;; (slxFile)
           "commThermalNoiseBlockReplace" t ;; (mFile)
           "commThermalNoiseTransform" t ;; (mFile)
           "commtimrec2" t ;; (slxFile)
           "commutil2" t ;; (slxFile)
           "commvarsize" t ;; (slxFile)
           "commviewers2" t ;; (slxFile)
           "commwcdma_ratematching" t ;; (mex)
           "commwman80216_2009" t ;; (slxFile)
           "commwman80216_2009_init" t ;; (mFile)
           "commwman80216_2009_intrlvr" t ;; (mFile)
           "commwman80216_2009_lib" t ;; (slxFile)
           "commwman80216_2009_slotconcat" t ;; (mFile)
           "commwman80216d_channel" t ;; (mFile)
           "compactCreditScorecard" t ;; (mFile) Create compactCreditScorecard object for a credit scorecard model
           "CompactTreeBagger" t ;; (mFile) Compact ensemble of bagged decision trees
           "compan" t ;; (mFile) Companion matrix
           "compand" t ;; (mFile) Source coding mu-law or A-law compressor or expander
           "compare" t ;; (mFile) Compare runs referenced by Simulink.sdi.DatasetRef objects
           "comparefis" t ;; (mFile) Plot simulated output of fuzzy systems for comparison
           "compareOptions" t ;; (mFile) Option set for compare
           "compareplot" t ;; (mFile)
           "compareTrajectories" t ;; (mFile) Compare estimated trajectory against ground truth
           "comparison.s3_20_s_var" t ;; (function)
           "comparison.s3_20_s_var_simscape_functions.i0" t ;; (function)
           "comparison.s3_20_s_var_simscape_functions.idiod" t ;; (function)
           "comparison.s3_20_s_var_simscape_functions.idiode" t ;; (function)
           "comparison.s3_20_s_var_simscape_functions.ig" t ;; (function)
           "comparisons.Comparison" t ;; (class)
           "comparisons.ExternalSCMLink" t ;; (class)
           "comparisons.ExternalSCMLink.AutoMergeExecutablePath" 'property
           "comparisons.ExternalSCMLink.DiffExecutablePath" 'property
           "comparisons.ExternalSCMLink.MergeExecutablePath" 'property
           "comparisons.ExternalSCMLink.setup" t ;; (method)
           "comparisons.ExternalSCMLink.setupGitAutoMergeDriver" t ;; (method)
           "comparisons.ExternalSCMLink.setupGitConfig" t ;; (method)
           "comparisons.ExternalSCMLink.setupGitDiffTool" t ;; (method)
           "comparisons.ExternalSCMLink.setupGitMergeTool" t ;; (method)
           "comparisons.MlappComparison" t ;; (class)
           "comparisons.TextComparison" t ;; (class)
           "comparisons_private" t ;; (pFile)
           "compass" t ;; (mFile) (Not recommended) Arrows emanating from origin
           "compassAngle" t ;; (mFile) Navigational heading relative to north
           "compassplot" t ;; (mFile) Polar plot with arrows emanating from origin
           "compatibleTrackBranches" t ;; (mFile) Formulate global hypotheses from clusters
           "compDblWithMinMaxFixPtValue" t ;; (mex)
           "CompDelay_ddg" t ;; (pFile)
           "compdir" t ;; (mFile)
           "compet" t ;; (mFile) Competitive transfer function
           "compet.activeInputRange" t ;; (function)
           "compet.apply" t ;; (function)
           "compet.backprop" t ;; (function)
           "compet.da_dn" t ;; (function)
           "compet.discontinuity" t ;; (function)
           "compet.forwardprop" t ;; (function)
           "compet.hardlim" t ;; (function)
           "compet.isScalar" t ;; (function)
           "compet.name" t ;; (function)
           "compet.outputRange" t ;; (function)
           "compet.parameterInfo" t ;; (function)
           "compet.simulinkParameters" t ;; (function)
           "compet.type" t ;; (function)
           "competlayer" t ;; (mFile) Competitive layer
           "compiler.build.cppSharedLibrary" t ;; (function)
           "compiler.build.CppSharedLibraryOptions" t ;; (class)
           "compiler.build.cSharedLibrary" t ;; (function)
           "compiler.build.CSharedLibraryOptions" t ;; (class)
           "compiler.build.dotNETAssembly" t ;; (function)
           "compiler.build.DotNETAssemblyOptions" t ;; (class)
           "compiler.build.javaPackage" t ;; (function)
           "compiler.build.JavaPackageOptions" t ;; (class)
           "compiler.build.productionServerArchive" t ;; (function)
           "compiler.build.ProductionServerArchiveOptions" t ;; (class)
           "compiler.build.pythonPackage" t ;; (function)
           "compiler.build.PythonPackageOptions" t ;; (class)
           "compiler.build.Results" t ;; (class)
           "compiler.build.standaloneApplication" t ;; (function)
           "compiler.build.StandaloneApplicationOptions" t ;; (class)
           "compiler.build.webAppArchive" t ;; (function)
           "compiler.build.WebAppArchiveOptions" t ;; (class)
           "compiler.codetools.deployableSupportPackages" t ;; (function)
           "compiler.package.docker" t ;; (function)
           "compiler.package.DockerOptions" t ;; (class)
           "compiler.package.installer" t ;; (function)
           "compiler.package.InstallerOptions" t ;; (class)
           "compiler.package.InstallerOptions.updateInputsFromResultsObject" t ;; (method)
           "compiler.package.microserviceDockerImage" t ;; (function)
           "compiler.package.MicroserviceDockerImageOptions" t ;; (class)
           "compiler.project.getCOMLibraryConfiguration" t ;; (function)
           "compiler.project.getCppSharedLibraryConfiguration" t ;; (function)
           "compiler.project.getCSharedLibraryConfiguration" t ;; (function)
           "compiler.project.getDotNETLibraryConfiguration" t ;; (function)
           "compiler.project.getExcelAddInConfiguration" t ;; (function)
           "compiler.project.getJavaLibraryConfiguration" t ;; (function)
           "compiler.project.getProductionServerArchiveConfiguration" t ;; (function)
           "compiler.project.getPythonLibraryConfiguration" t ;; (function)
           "compiler.project.getStandaloneDesktopAppConfiguration" t ;; (function)
           "compiler.project.getToolboxConfiguration" t ;; (function)
           "compiler.project.getWebAppConfiguration" t ;; (function)
           "compiler.runtime.createDockerImage" t ;; (function)
           "compiler.runtime.createInstallerDockerImage" t ;; (function)
           "compiler.runtime.customInstaller" t ;; (function)
           "compiler.runtime.Dependencies" t ;; (class)
           "compiler.runtime.download" t ;; (function)
           "compiler.runtime.installer" t ;; (function)
           "compiler.runtime.version" t ;; (function)
           "compiler.UserInfo" t ;; (class)
           "comple" t ;; (mFile)
           "complementaryFilter" t ;; (mFile) Estimate orientation using complementary filter
           "completefreqresp" t ;; (mFile)
           "complex" t ;; (mFile) Create complex array
           "complexify" t ;; (mFile) Replace ureal atoms by summations of ureal and ucomplex (or ultidyn) atoms
           "complexityinfo" t ;; (mFile) Retrieve cyclomatic complexity coverage information from cvdata object
           "complexReluLayer" t ;; (mFile) Complex rectified linear unit (ReLU) layer
           "complexToRealLayer" t ;; (mFile) Complex-to-real layer
           "compnorm" t ;; (mFile)
           "component" t ;; (pFile) Create component object
           "compose" t ;; (mFile) Format data into multiple strings
           "Composite" t ;; (mFile) Create and access nondistributed variables on multiple workers from client
           "compositebusddg" t ;; (pFile)
           "compositebusddg_cb" t ;; (pFile)
           "compositeLaneSpec" t ;; (mFile) Create multiple lane specifications for road
           "compositePreApply" t ;; (mFile)
           "compoundbycrr" t ;; (mFile) Price compound option from Cox-Ross-Rubinstein binomial tree
           "compoundbyeqp" t ;; (mFile) Price compound option from Equal Probabilities binomial tree
           "compoundbyitt" t ;; (mFile) Price compound option from implied trinomial tree (ITT)
           "compoundbystocktree" t ;; (mFile)
           "compoundbystt" t ;; (mFile) Price compound options using standard trinomial tree
           "compressor" t ;; (mFile) Dynamic range compressor
           "compute_value_from_rtwoptions" t ;; (mFile)
           "computeApproxLLR_Opt_PSK" t ;; (mex)
           "computeApproxLLR_Opt_QAM" t ;; (mex)
           "computeApproxLLR_QAM" t ;; (mex)
           "computeBaseRate" t ;; (mex)
           "computeFinDiffGradAndJac" t ;; (pFile)
           "computeGridSubsample" t ;; (mFile)
           "computeKKTErrorForQPLP" t ;; (mFile)
           "computeLateralDirectionalFlyingQualities" t ;; (mFile) Calculate dutch roll mode, roll mode, and spiral mode characteristics of state-space model
           "computeLLR" t ;; (mex)
           "computeLongitudinalFlyingQualities" t ;; (mFile) Calculate short-period and long-period (phugoid) mode characteristics of specified state-space model
           "computeMaxChannelsForDevice" t ;; (mFile)
           "computepsd" t ;; (mFile)
           "computer" t ;; (mFile) Information about computer on which MATLAB is running
           "computils.MockFileChooser" t ;; (class)
           "compwiz" t ;; (mFile) Create custom MATLAB Report Generator components
           "comserver" t ;; (mFile) Register, unregister, or query MATLAB COM server
           "con2seq" t ;; (mFile) Convert concurrent vectors to sequential vectors
           "conbase" t ;; (mFile)
           "conboolean" t ;; (mFile)
           "concatenationLayer" t ;; (mFile) Concatenation layer
           "concatValuesOfCellArray" t ;; (pFile)
           "concentrationIndices" t ;; (mFile) Compute ad-hoc concentration indices for a portfolio
           "concerto.BlockSampleTime" t ;; (class)
           "concerto.TcpReceive" t ;; (class)
           "concerto.TcpReceive.getDescriptiveName" t ;; (method)
           "concerto.TcpReceive.isSupportedContext" t ;; (method)
           "concerto.TcpReceive.updateBuildInfo" t ;; (method)
           "concerto.TcpSend" t ;; (class)
           "concerto.TcpSend.getDescriptiveName" t ;; (method)
           "concerto.TcpSend.isSupportedContext" t ;; (method)
           "concerto.TcpSend.parseDataType" t ;; (method)
           "concerto.TcpSend.updateBuildInfo" t ;; (method)
           "concerto.UartReceive" t ;; (class)
           "concerto.UartReceive.getDescriptiveName" t ;; (method)
           "concerto.UartReceive.isSupportedContext" t ;; (method)
           "concerto.UartReceive.macroNameGpio" t ;; (method)
           "concerto.UartReceive.macroNameParity" t ;; (method)
           "concerto.UartReceive.macroNameSysCtl" t ;; (method)
           "concerto.UartReceive.macroNameUart" t ;; (method)
           "concerto.UartReceive.updateBuildInfo" t ;; (method)
           "concerto.UartSend" t ;; (class)
           "concerto.UartSend.getDescriptiveName" t ;; (method)
           "concerto.UartSend.isSupportedContext" t ;; (method)
           "concerto.UartSend.macroNameGpio" t ;; (method)
           "concerto.UartSend.macroNameParity" t ;; (method)
           "concerto.UartSend.macroNameSysCtl" t ;; (method)
           "concerto.UartSend.macroNameUart" t ;; (method)
           "concerto.UartSend.parseDataType" t ;; (method)
           "concerto.UartSend.updateBuildInfo" t ;; (method)
           "concerto.UdpReceive" t ;; (class)
           "concerto.UdpReceive.getDescriptiveName" t ;; (method)
           "concerto.UdpReceive.isSupportedContext" t ;; (method)
           "concerto.UdpReceive.updateBuildInfo" t ;; (method)
           "concerto.UdpSend" t ;; (class)
           "concerto.UdpSend.getDescriptiveName" t ;; (method)
           "concerto.UdpSend.isSupportedContext" t ;; (method)
           "concerto.UdpSend.parseDataType" t ;; (method)
           "concerto.UdpSend.updateBuildInfo" t ;; (method)
           "concerto_arm_dio_callback" t ;; (mFile)
           "concerto_di_read" t ;; (mex)
           "concerto_do_write" t ;; (mex)
           "concerto_lib_callback" t ;; (mFile)
           "concgmodel" t ;; (mFile)
           "conclassifier" t ;; (mFile)
           "conconvexhull" t ;; (mFile)
           "concur" t ;; (mFile) Create concurrent bias vectors
           "cond" t ;; (mFile) Condition number for inversion
           "condeig" t ;; (mFile) Condition number with respect to eigenvalues
           "condest" t ;; (mFile) 1-norm condition number estimate
           "conditioninfo" t ;; (mFile) Retrieve condition coverage information from cvdata object
           "coneangle2size" t ;; (mFile) Calculates equivalent cone height, broad radius, and narrow radius
           "conellipsoid" t ;; (mFile)
           "conemesh" t ;; (mFile)
           "coneplot" t ;; (mFile) Plot velocity vectors as cones in 3-D vector field
           "coneprog" t ;; (mFile) Second-order cone programming solver
           "config_dlg_configure_param" t ;; (pFile)
           "configblkddg" t ;; (mFile)
           "configblkddg_cb" t ;; (mFile)
           "configset.addParamListener" t ;; (function)
           "configset.autosar_adaptive.addStdMutexCRL" t ;; (function)
           "configset.autosar_adaptive.getAdaptiveAutosarUseCustomXCPSlave" t ;; (function)
           "configset.autosar_adaptive.getAdaptiveAutosarXCPSlavePort" t ;; (function)
           "configset.autosar_adaptive.getAdaptiveAutosarXCPSlaveTCPIPAddress" t ;; (function)
           "configset.autosar_adaptive.getAdaptiveAutosarXCPSlaveTransportLayer" t ;; (function)
           "configset.autosar_adaptive.getAdaptiveAutosarXCPSlaveVerbosity" t ;; (function)
           "configset.autosar_adaptive.setAdaptiveAutosarUseCustomXCPSlave" t ;; (function)
           "configset.autosar_adaptive.setAdaptiveAutosarXCPSlavePort" t ;; (function)
           "configset.autosar_adaptive.setAdaptiveAutosarXCPSlaveTCPIPAddress" t ;; (function)
           "configset.autosar_adaptive.setAdaptiveAutosarXCPSlaveTransportLayer" t ;; (function)
           "configset.autosar_adaptive.setAdaptiveAutosarXCPSlaveVerbosity" t ;; (function)
           "configset.autosar_adaptive.setAutosarSchemaVersion" t ;; (function)
           "configset.autosar_adaptive.update" t ;; (function)
           "configset.clearParameterHighlights" t ;; (function)
           "configset.cppComponent.allowParentAndChildToHaveUnmatchedComponent" t ;; (function)
           "configset.cppComponent.attachDefaultRTWCPPFcnClass" t ;; (function)
           "configset.cppComponent.getExternalIOMemberVisibility" t ;; (function)
           "configset.cppComponent.getGenerateAccessMethods" t ;; (function)
           "configset.cppComponent.getGenerateExternalIOAccessMethods" t ;; (function)
           "configset.cppComponent.getGenerateInternalMemberAccessMethods" t ;; (function)
           "configset.cppComponent.getGenerateIOAccessMethods" t ;; (function)
           "configset.cppComponent.getGenerateParameterAccessMethods" t ;; (function)
           "configset.cppComponent.getGeneratePrivateDataMembers" t ;; (function)
           "configset.cppComponent.getInlineAccessMethods" t ;; (function)
           "configset.cppComponent.getInternalMemberVisibility" t ;; (function)
           "configset.cppComponent.getName" t ;; (function)
           "configset.cppComponent.getParam" t ;; (function)
           "configset.cppComponent.getParameterMemberVisibility" t ;; (function)
           "configset.cppComponent.setExternalIOMemberVisibility" t ;; (function)
           "configset.cppComponent.setGenerateAccessMethods" t ;; (function)
           "configset.cppComponent.setGenerateExternalIOAccessMethods" t ;; (function)
           "configset.cppComponent.setGenerateInternalMemberAccessMethods" t ;; (function)
           "configset.cppComponent.setGenerateIOAccessMethods" t ;; (function)
           "configset.cppComponent.setGenerateParameterAccessMethods" t ;; (function)
           "configset.cppComponent.setGeneratePrivateDataMembers" t ;; (function)
           "configset.cppComponent.setInlineAccessMethods" t ;; (function)
           "configset.cppComponent.setInternalMemberVisibility" t ;; (function)
           "configset.cppComponent.setParam" t ;; (function)
           "configset.cppComponent.setParameterMemberVisibility" t ;; (function)
           "configset.cppComponent.skipModelReferenceComparison" t ;; (function)
           "configset.cppComponent.update" t ;; (function)
           "configset.cppComponent.upgrade" t ;; (function)
           "configset.customtarget.getMdlRefComplianceTable" t ;; (function)
           "configset.customtarget.getStringFormat" t ;; (function)
           "configset.dialog.Connector" t ;; (class)
           "configset.dialog.Connector.channel" 'property
           "configset.dialog.Connector.getInstance" t ;; (method)
           "configset.dialog.Customizer" t ;; (class)
           "configset.dialog.Customizer.addCustomization" t ;; (method)
           "configset.dialog.Customizer.clearCustomization" t ;; (method)
           "configset.dialog.Customizer.getCustomizationFunction" t ;; (method)
           "configset.dialog.Customizer.getCustomizationResults" t ;; (method)
           "configset.dialog.Customizer.getCustomizationXML" t ;; (method)
           "configset.dialog.HTMLView" t ;; (class)
           "configset.dialog.HTMLView.Name" 'property
           "configset.dialog.HTMLView.Tag" 'property
           "configset.dialog.setWidgetValue" t ;; (function)
           "configset.ert.getCPPComponent" t ;; (function)
           "configset.ert.getEnableDataOwnership" t ;; (function)
           "configset.ert.getExtModeStaticAlloc" t ;; (function)
           "configset.ert.getGroupDataTransfer" t ;; (function)
           "configset.ert.getGroupInstanceSpecificParameters" t ;; (function)
           "configset.ert.getGroupInternal" t ;; (function)
           "configset.ert.getGroupModelData" t ;; (function)
           "configset.ert.getGroupParameters" t ;; (function)
           "configset.ert.getGroupRootInputs" t ;; (function)
           "configset.ert.getGroupRootIO" t ;; (function)
           "configset.ert.getGroupRootOutputs" t ;; (function)
           "configset.ert.getGroupSharedLocalDataStores" t ;; (function)
           "configset.ert.getInlinedParameterPlacement" t ;; (function)
           "configset.ert.getIOGroup" t ;; (function)
           "configset.ert.getMdlRefComplianceTable" t ;; (function)
           "configset.ert.getSigAttribFullClassList" t ;; (function)
           "configset.ert.getStringFormat" t ;; (function)
           "configset.ert.getter" t ;; (function)
           "configset.ert.okToAttach" t ;; (function)
           "configset.ert.okToDetach" t ;; (function)
           "configset.ert.setArrayContainerType" t ;; (function)
           "configset.ert.setBooleanFalseId" t ;; (function)
           "configset.ert.setBooleanTrueId" t ;; (function)
           "configset.ert.setDefaultCppNamespace" t ;; (function)
           "configset.ert.setDefaults" t ;; (function)
           "configset.ert.setEnableDataOwnership" t ;; (function)
           "configset.ert.setERTCustomFileTemplate" t ;; (function)
           "configset.ert.setExtModeMaxTrigDuration" t ;; (function)
           "configset.ert.setExtModeStaticAlloc" t ;; (function)
           "configset.ert.setExtModeStaticAllocSize" t ;; (function)
           "configset.ert.setExtModeTransport" t ;; (function)
           "configset.ert.setGenerateASAP2" t ;; (function)
           "configset.ert.setInitialValueSource" t ;; (function)
           "configset.ert.setMaxIdInt16" t ;; (function)
           "configset.ert.setMaxIdInt32" t ;; (function)
           "configset.ert.setMaxIdInt64" t ;; (function)
           "configset.ert.setMaxIdInt8" t ;; (function)
           "configset.ert.setMaxIdUint16" t ;; (function)
           "configset.ert.setMaxIdUint32" t ;; (function)
           "configset.ert.setMaxIdUint64" t ;; (function)
           "configset.ert.setMaxIdUint8" t ;; (function)
           "configset.ert.setMaxLineWidth" t ;; (function)
           "configset.ert.setMemSecFuncExecute" t ;; (function)
           "configset.ert.setMinIdInt16" t ;; (function)
           "configset.ert.setMinIdInt32" t ;; (function)
           "configset.ert.setMinIdInt64" t ;; (function)
           "configset.ert.setMinIdInt8" t ;; (function)
           "configset.ert.setModuleNamingRule" t ;; (function)
           "configset.ert.setRateTransitionBlockCode" t ;; (function)
           "configset.ert.setReplacementTypes" t ;; (function)
           "configset.ert.setTargetOS" t ;; (function)
           "configset.ert.setTypeLimitIdReplacement" t ;; (function)
           "configset.ert.update" t ;; (function)
           "configset.ert.upgrade" t ;; (function)
           "configset.getParameterInfo" t ;; (function)
           "configset.highlightParameter" t ;; (function)
           "configset.htmlview.custom_functions.get_AUTOSAR_AUTOSARAdaptiveTargetCC_ComponentData" t ;; (function)
           "configset.htmlview.custom_functions.get_AUTOSAR_AUTOSARAdaptiveTargetCC_data" t ;; (function)
           "configset.htmlview.custom_functions.get_dpigen_DPIERTTargetCC_ComponentData" t ;; (function)
           "configset.htmlview.custom_functions.get_dpigen_DPIERTTargetCC_data" t ;; (function)
           "configset.htmlview.custom_functions.get_dpigen_DPIGRTTargetCC_ComponentData" t ;; (function)
           "configset.htmlview.custom_functions.get_dpigen_DPIGRTTargetCC_data" t ;; (function)
           "configset.htmlview.custom_functions.get_hdlcoderui_hdlcc_ComponentData" t ;; (function)
           "configset.htmlview.custom_functions.get_hdlcoderui_hdlcc_data" t ;; (function)
           "configset.htmlview.custom_functions.get_MDX_MDXTargetCC_data" t ;; (function)
           "configset.htmlview.custom_functions.get_Modbus_ConfigSetCC_ComponentData" t ;; (function)
           "configset.htmlview.custom_functions.get_Modbus_ConfigSetCC_data" t ;; (function)
           "configset.htmlview.custom_functions.get_ModelAdvisor_ConfigsetCC_ComponentData" t ;; (function)
           "configset.htmlview.custom_functions.get_ModelAdvisor_ConfigsetCC_data" t ;; (function)
           "configset.htmlview.custom_functions.get_MQTT_ConfigSetCC_ComponentData" t ;; (function)
           "configset.htmlview.custom_functions.get_MQTT_ConfigSetCC_data" t ;; (function)
           "configset.htmlview.custom_functions.get_OPCConfiguration_ConfigsetCC_ComponentData" t ;; (function)
           "configset.htmlview.custom_functions.get_OPCConfiguration_ConfigsetCC_data" t ;; (function)
           "configset.htmlview.custom_functions.get_PLCCoder_ConfigComp_ComponentData" t ;; (function)
           "configset.htmlview.custom_functions.get_PLCCoder_ConfigComp_data" t ;; (function)
           "configset.htmlview.custom_functions.get_pslink_ConfigComp_ComponentData" t ;; (function)
           "configset.htmlview.custom_functions.get_pslink_ConfigComp_data" t ;; (function)
           "configset.htmlview.custom_functions.get_RTW_RSimTargetCC_ComponentData" t ;; (function)
           "configset.htmlview.custom_functions.get_RTW_RSimTargetCC_data" t ;; (function)
           "configset.htmlview.custom_functions.get_RTW_TornadoTargetCC_data" t ;; (function)
           "configset.htmlview.custom_functions.get_simmechanics_ConfigurationSet_ComponentData" t ;; (function)
           "configset.htmlview.custom_functions.get_simmechanics_ConfigurationSet_data" t ;; (function)
           "configset.htmlview.custom_functions.get_simmechanics_DiagnosticsConfigSet_ComponentData" t ;; (function)
           "configset.htmlview.custom_functions.get_simmechanics_DiagnosticsConfigSet_data" t ;; (function)
           "configset.htmlview.custom_functions.get_simmechanics_ExplorerConfigSet_ComponentData" t ;; (function)
           "configset.htmlview.custom_functions.get_simmechanics_ExplorerConfigSet_data" t ;; (function)
           "configset.htmlview.custom_functions.get_Simulink_CodeAppCC_data" t ;; (function)
           "configset.htmlview.custom_functions.get_Simulink_ConfigSet_data" t ;; (function)
           "configset.htmlview.custom_functions.get_Simulink_CPPComponent_data" t ;; (function)
           "configset.htmlview.custom_functions.get_Simulink_DataIOCC_data" t ;; (function)
           "configset.htmlview.custom_functions.get_Simulink_DebuggingCC_data" t ;; (function)
           "configset.htmlview.custom_functions.get_Simulink_ERTTargetCC_data" t ;; (function)
           "configset.htmlview.custom_functions.get_Simulink_GRTTargetCC_data" t ;; (function)
           "configset.htmlview.custom_functions.get_Simulink_HardwareCC_data" t ;; (function)
           "configset.htmlview.custom_functions.get_Simulink_ModelReferenceCC_data" t ;; (function)
           "configset.htmlview.custom_functions.get_Simulink_OptimizationCC_data" t ;; (function)
           "configset.htmlview.custom_functions.get_Simulink_RaccelTargetCC_data" t ;; (function)
           "configset.htmlview.custom_functions.get_Simulink_RTWCC_data" t ;; (function)
           "configset.htmlview.custom_functions.get_Simulink_SFSimCC_data" t ;; (function)
           "configset.htmlview.custom_functions.get_Simulink_SolverCC_data" t ;; (function)
           "configset.htmlview.custom_functions.get_Simulink_TargetCC_data" t ;; (function)
           "configset.htmlview.custom_functions.get_SimulinkDesktopRealTime_SimulinkDesktopRealTimeCC_ComponentData" t ;; (function)
           "configset.htmlview.custom_functions.get_SimulinkDesktopRealTime_SimulinkDesktopRealTimeCC_data" t ;; (function)
           "configset.htmlview.custom_functions.get_SimulinkDesktopRealTime_SimulinkDesktopRealTimeERTCC_ComponentData" t ;; (function)
           "configset.htmlview.custom_functions.get_SimulinkDesktopRealTime_SimulinkDesktopRealTimeERTCC_data" t ;; (function)
           "configset.htmlview.custom_functions.get_SimulinkRealTime_SimulinkRealTimeCC_data" t ;; (function)
           "configset.htmlview.custom_functions.get_SimulinkRealTime_SimulinkRealTimeERTCC_data" t ;; (function)
           "configset.htmlview.custom_functions.get_SlCovCC_ConfigComp_ComponentData" t ;; (function)
           "configset.htmlview.custom_functions.get_SlCovCC_ConfigComp_data" t ;; (function)
           "configset.htmlview.custom_functions.get_Sldv_ConfigComp_ComponentData" t ;; (function)
           "configset.htmlview.custom_functions.get_Sldv_ConfigComp_data" t ;; (function)
           "configset.htmlview.custom_functions.get_slrealtime_SimulinkRealTimeTargetCC_ComponentData" t ;; (function)
           "configset.htmlview.custom_functions.get_slrealtime_SimulinkRealTimeTargetCC_data" t ;; (function)
           "configset.htmlview.custom_functions.get_slrtlinux_slrtlinuxTargetCC_ComponentData" t ;; (function)
           "configset.htmlview.custom_functions.get_slrtlinux_slrtlinuxTargetCC_data" t ;; (function)
           "configset.htmlview.custom_functions.get_SSC_SimscapeCC_ComponentData" t ;; (function)
           "configset.htmlview.custom_functions.get_SSC_SimscapeCC_data" t ;; (function)
           "configset.htmlview.custom_functions.get_tlmg_TLMERTTargetCC_ComponentData" t ;; (function)
           "configset.htmlview.custom_functions.get_tlmg_TLMERTTargetCC_data" t ;; (function)
           "configset.htmlview.custom_functions.get_tlmg_TLMGRTTargetCC_ComponentData" t ;; (function)
           "configset.htmlview.custom_functions.get_tlmg_TLMGRTTargetCC_data" t ;; (function)
           "configset.htmlview.custom_functions.getComponentData" t ;; (function)
           "configset.htmlview.custom_functions.getLayoutFeatures" t ;; (function)
           "configset.isSimulinkLoaded" t ;; (function)
           "configset.layout.CategoryUIGroup" t ;; (class)
           "configset.layout.ComponentConfigLayout" t ;; (class)
           "configset.layout.ComponentConfigLayout.BaseMatFile" 'property
           "configset.layout.ComponentConfigLayout.BasePath" 'property
           "configset.layout.ComponentConfigLayout.buildAll" t ;; (method)
           "configset.layout.ComponentConfigLayout.CustomCCPath" 'property
           "configset.layout.ComponentConfigLayout.DataPath" 'property
           "configset.layout.ComponentConfigLayout.getMatFile" t ;; (method)
           "configset.layout.ComponentConfigLayout.getSTFPageDisplayPath" t ;; (method)
           "configset.layout.ComponentConfigLayout.getXmlFile" t ;; (method)
           "configset.layout.ComponentConfigLayout.SaveFile" 'property
           "configset.layout.ComponentConfigLayout.XmlFileName" 'property
           "configset.layout.custom.getIDELinkUpgradeWidget" t ;; (function)
           "configset.layout.custom.getSimscapeMultibodyText" t ;; (function)
           "configset.layout.custom.getTargetHardwareDialogSchema" t ;; (function)
           "configset.layout.MetaConfigLayout" t ;; (class)
           "configset.layout.MetaConfigLayout.BaseMatFile" 'property
           "configset.layout.MetaConfigLayout.BasePath" 'property
           "configset.layout.MetaConfigLayout.buildAll" t ;; (method)
           "configset.layout.MetaConfigLayout.CustomCCPath" 'property
           "configset.layout.MetaConfigLayout.DataPath" 'property
           "configset.layout.MetaConfigLayout.getInstance" t ;; (method)
           "configset.layout.MetaConfigLayout.getMatFile" t ;; (method)
           "configset.layout.MetaConfigLayout.getSTFPageDisplayPath" t ;; (method)
           "configset.layout.MetaConfigLayout.getXmlFile" t ;; (method)
           "configset.layout.MetaConfigLayout.SaveFile" 'property
           "configset.layout.MetaConfigLayout.XmlFileName" 'property
           "configset.ParameterInfo" t ;; (class)
           "configset.ParameterInfoBase" t ;; (class)
           "configset.ParameterStaticInfo" t ;; (class)
           "configset.ParamListener" t ;; (class)
           "configset.propHasDefaultValue" t ;; (function)
           "configset.raccel.getMdlRefComplianceTable" t ;; (function)
           "configset.raccel.getStringFormat" t ;; (function)
           "configset.raccel.update" t ;; (function)
           "configset.reference.getOverriddenParameters" t ;; (function)
           "configset.reference.hasOverriddenParameters" t ;; (function)
           "configset.reference.isParameterOverridden" t ;; (function)
           "configset.reference.overrideParameter" t ;; (function)
           "configset.reference.restoreAllOverriddenParameters" t ;; (function)
           "configset.reference.restoreOverriddenParameter" t ;; (function)
           "configset.rsim.setExtModeTransport" t ;; (function)
           "configset.showParameterGroup" t ;; (function)
           "configset.sldrt.dialogCallback" t ;; (function)
           "configset.sldrt.getMdlRefComplianceTable" t ;; (function)
           "configset.sldrt.getSLDRTDir" t ;; (function)
           "configset.sldrt.getStringFormat" t ;; (function)
           "configset.sldrt.getTargetArch" t ;; (function)
           "configset.sldrt.removeFromItems" t ;; (function)
           "configset.sldrt.update" t ;; (function)
           "configset.sldrt.updateHandler" t ;; (function)
           "configset.sldrt.upgradeFromRTWin" t ;; (function)
           "configset.sldrtert.getMdlRefComplianceTable" t ;; (function)
           "configset.sldrtert.getSLDRTDir" t ;; (function)
           "configset.sldrtert.getStringFormat" t ;; (function)
           "configset.sldrtert.getTargetArch" t ;; (function)
           "configset.sldrtert.update" t ;; (function)
           "configset.sldrtert.updateHandler" t ;; (function)
           "configset.slrt.getMdlRefComplianceTable" t ;; (function)
           "configset.slrt.getStringFormat" t ;; (function)
           "configset.slrt.update" t ;; (function)
           "configset.systemverilog_dpi_ert.getDPIComponentTemplateType" t ;; (function)
           "configset.systemverilog_dpi_ert.getDPIGenerateTestBench" t ;; (function)
           "configset.systemverilog_dpi_ert.getDPIReportRunTimeError" t ;; (function)
           "configset.systemverilog_dpi_ert.getPropFromTag" t ;; (function)
           "configset.systemverilog_dpi_ert.pushButtonCallBack" t ;; (function)
           "configset.systemverilog_dpi_ert.setDPITestBenchSimulator" t ;; (function)
           "configset.systemverilog_dpi_grt.getDPIComponentTemplateType" t ;; (function)
           "configset.systemverilog_dpi_grt.getDPIGenerateTestBench" t ;; (function)
           "configset.systemverilog_dpi_grt.getDPIReportRunTimeError" t ;; (function)
           "configset.systemverilog_dpi_grt.getExtensionDialogSchema" t ;; (function)
           "configset.systemverilog_dpi_grt.getPropFromTag" t ;; (function)
           "configset.systemverilog_dpi_grt.getStringFormat" t ;; (function)
           "configset.systemverilog_dpi_grt.pushButtonCallBack" t ;; (function)
           "configset.systemverilog_dpi_grt.setDPITestBenchSimulator" t ;; (function)
           "configset.systemverilog_dpi_grt.setGenerateASAP2" t ;; (function)
           "configset.systemverilog_dpi_grt.update" t ;; (function)
           "configset.tlmgenerator_grt.setGenerateASAP2" t ;; (function)
           "configset.util.ConfigSetDialogSourceManager" t ;; (class)
           "configset.util.ConfigSetDiff" t ;; (class)
           "configset.util.convertToCSRef" t ;; (function)
           "configset.util.deduceType" t ;; (function)
           "configset.util.ExportToM" t ;; (class)
           "configset.util.getConfigSetObject" t ;; (function)
           "configset.util.getCurrentViewObject" t ;; (function)
           "configset.util.getSource" t ;; (function)
           "configset.util.mat2json" t ;; (function)
           "configset.util.message" t ;; (function)
           "configset.util.Model" t ;; (class)
           "configset.util.Propagation" t ;; (class)
           "configset.util.rectMatlab2Udd" t ;; (function)
           "configset.util.rectUdd2Matlab" t ;; (function)
           "configset.util.SourceManager" t ;; (class)
           "configset.util.toString" t ;; (function)
           "configurationtab.interfaces.IDescriptorFactory" t ;; (class)
           "configurationtab.interfaces.ITestable" t ;; (class)
           "configurationtab.modbus.BaseDescriptor" t ;; (class)
           "configurationtab.modbus.BaseDescriptor.BaudRateDefault" 'property
           "configurationtab.modbus.BaseDescriptor.BaudRateList" 'property
           "configurationtab.modbus.BaseDescriptor.CustomDataFields" 'property
           "configurationtab.modbus.BaseDescriptor.DataBitsList" 'property
           "configurationtab.modbus.BaseDescriptor.DeviceAppletData" 'property
           "configurationtab.modbus.BaseDescriptor.DeviceIconID" 'property
           "configurationtab.modbus.BaseDescriptor.ErrorTitle" 'property
           "configurationtab.modbus.BaseDescriptor.ModbusApplet" 'property
           "configurationtab.modbus.BaseDescriptor.ModbusSerialWidgetIcon" 'property
           "configurationtab.modbus.BaseDescriptor.ModbusTcpipWidgetIcon" 'property
           "configurationtab.modbus.BaseDescriptor.OrderList" 'property
           "configurationtab.modbus.BaseDescriptor.ParityList" 'property
           "configurationtab.modbus.BaseDescriptor.PortDefault" 'property
           "configurationtab.modbus.BaseDescriptor.PrecisionsCoilList" 'property
           "configurationtab.modbus.BaseDescriptor.PrecisionsHRList" 'property
           "configurationtab.modbus.BaseDescriptor.PropertiesSection" 'property
           "configurationtab.modbus.BaseDescriptor.ReadButtonIcon" 'property
           "configurationtab.modbus.BaseDescriptor.RegisterTypeList" 'property
           "configurationtab.modbus.BaseDescriptor.ServerIdDefault" 'property
           "configurationtab.modbus.BaseDescriptor.ServerIDRange" 'property
           "configurationtab.modbus.BaseDescriptor.StopBitsList" 'property
           "configurationtab.modbus.BaseDescriptor.TestConnectionSection" 'property
           "configurationtab.modbus.BaseDescriptor.TimeoutDefault" 'property
           "configurationtab.modbus.BaseDescriptor.ToolboxBaseCode" 'property
           "configurationtab.modbus.BaseDescriptorFactory" t ;; (class)
           "configurationtab.modbus.BaseDescriptorFactory.BaudRateDefault" 'property
           "configurationtab.modbus.BaseDescriptorFactory.BaudRateList" 'property
           "configurationtab.modbus.BaseDescriptorFactory.CustomDataFields" 'property
           "configurationtab.modbus.BaseDescriptorFactory.DataBitsList" 'property
           "configurationtab.modbus.BaseDescriptorFactory.DeviceIconID" 'property
           "configurationtab.modbus.BaseDescriptorFactory.ModbusSerialWidgetIcon" 'property
           "configurationtab.modbus.BaseDescriptorFactory.ModbusTcpipWidgetIcon" 'property
           "configurationtab.modbus.BaseDescriptorFactory.OrderList" 'property
           "configurationtab.modbus.BaseDescriptorFactory.ParityList" 'property
           "configurationtab.modbus.BaseDescriptorFactory.PortDefault" 'property
           "configurationtab.modbus.BaseDescriptorFactory.PrecisionsCoilList" 'property
           "configurationtab.modbus.BaseDescriptorFactory.PrecisionsHRList" 'property
           "configurationtab.modbus.BaseDescriptorFactory.PropertiesSection" 'property
           "configurationtab.modbus.BaseDescriptorFactory.ReadButtonIcon" 'property
           "configurationtab.modbus.BaseDescriptorFactory.RegisterTypeList" 'property
           "configurationtab.modbus.BaseDescriptorFactory.ServerIdDefault" 'property
           "configurationtab.modbus.BaseDescriptorFactory.ServerIDRange" 'property
           "configurationtab.modbus.BaseDescriptorFactory.StopBitsList" 'property
           "configurationtab.modbus.BaseDescriptorFactory.TestConnectionSection" 'property
           "configurationtab.modbus.BaseDescriptorFactory.TimeoutDefault" 'property
           "configurationtab.modbus.BaseValidator" t ;; (class)
           "configurationtab.modbus.DescriptorConstants" t ;; (class)
           "configurationtab.modbus.DescriptorConstants.BaudRateDefault" 'property
           "configurationtab.modbus.DescriptorConstants.BaudRateList" 'property
           "configurationtab.modbus.DescriptorConstants.CustomDataFields" 'property
           "configurationtab.modbus.DescriptorConstants.DataBitsList" 'property
           "configurationtab.modbus.DescriptorConstants.DeviceIconID" 'property
           "configurationtab.modbus.DescriptorConstants.ModbusSerialWidgetIcon" 'property
           "configurationtab.modbus.DescriptorConstants.ModbusTcpipWidgetIcon" 'property
           "configurationtab.modbus.DescriptorConstants.OrderList" 'property
           "configurationtab.modbus.DescriptorConstants.ParityList" 'property
           "configurationtab.modbus.DescriptorConstants.PortDefault" 'property
           "configurationtab.modbus.DescriptorConstants.PrecisionsCoilList" 'property
           "configurationtab.modbus.DescriptorConstants.PrecisionsHRList" 'property
           "configurationtab.modbus.DescriptorConstants.PropertiesSection" 'property
           "configurationtab.modbus.DescriptorConstants.ReadButtonIcon" 'property
           "configurationtab.modbus.DescriptorConstants.RegisterTypeList" 'property
           "configurationtab.modbus.DescriptorConstants.ServerIdDefault" 'property
           "configurationtab.modbus.DescriptorConstants.ServerIDRange" 'property
           "configurationtab.modbus.DescriptorConstants.StopBitsList" 'property
           "configurationtab.modbus.DescriptorConstants.TestConnectionSection" 'property
           "configurationtab.modbus.DescriptorConstants.TimeoutDefault" 'property
           "configurationtab.modbus.DescriptorProperties" t ;; (class)
           "configurationtab.modbus.DescriptorProperties.IcommMap" 'property
           "configurationtab.modbus.IDescriptor" t ;; (class)
           "configurationtab.modbus.IValidator" t ;; (class)
           "configurationtab.modbus.SerialDescriptor" t ;; (class)
           "configurationtab.modbus.SerialDescriptor.BaudRateDefault" 'property
           "configurationtab.modbus.SerialDescriptor.BaudRateList" 'property
           "configurationtab.modbus.SerialDescriptor.CustomDataFields" 'property
           "configurationtab.modbus.SerialDescriptor.DataBitsList" 'property
           "configurationtab.modbus.SerialDescriptor.DeviceAppletData" 'property
           "configurationtab.modbus.SerialDescriptor.DeviceIconID" 'property
           "configurationtab.modbus.SerialDescriptor.ErrorTitle" 'property
           "configurationtab.modbus.SerialDescriptor.MapTopicID" 'property
           "configurationtab.modbus.SerialDescriptor.ModbusApplet" 'property
           "configurationtab.modbus.SerialDescriptor.ModbusSerialWidgetIcon" 'property
           "configurationtab.modbus.SerialDescriptor.ModbusTcpipWidgetIcon" 'property
           "configurationtab.modbus.SerialDescriptor.OrderList" 'property
           "configurationtab.modbus.SerialDescriptor.ParityList" 'property
           "configurationtab.modbus.SerialDescriptor.PortDefault" 'property
           "configurationtab.modbus.SerialDescriptor.PrecisionsCoilList" 'property
           "configurationtab.modbus.SerialDescriptor.PrecisionsHRList" 'property
           "configurationtab.modbus.SerialDescriptor.PropertiesSection" 'property
           "configurationtab.modbus.SerialDescriptor.ReadButtonIcon" 'property
           "configurationtab.modbus.SerialDescriptor.RegisterTypeList" 'property
           "configurationtab.modbus.SerialDescriptor.ServerIdDefault" 'property
           "configurationtab.modbus.SerialDescriptor.ServerIDRange" 'property
           "configurationtab.modbus.SerialDescriptor.StopBitsList" 'property
           "configurationtab.modbus.SerialDescriptor.TestConnectionSection" 'property
           "configurationtab.modbus.SerialDescriptor.TimeoutDefault" 'property
           "configurationtab.modbus.SerialDescriptor.ToolboxBaseCode" 'property
           "configurationtab.modbus.SerialDescriptorFactory" t ;; (class)
           "configurationtab.modbus.SerialDescriptorFactory.BaudRateDefault" 'property
           "configurationtab.modbus.SerialDescriptorFactory.BaudRateList" 'property
           "configurationtab.modbus.SerialDescriptorFactory.CustomDataFields" 'property
           "configurationtab.modbus.SerialDescriptorFactory.DataBitsList" 'property
           "configurationtab.modbus.SerialDescriptorFactory.DeviceIconID" 'property
           "configurationtab.modbus.SerialDescriptorFactory.ModbusSerialWidgetIcon" 'property
           "configurationtab.modbus.SerialDescriptorFactory.ModbusTcpipWidgetIcon" 'property
           "configurationtab.modbus.SerialDescriptorFactory.OrderList" 'property
           "configurationtab.modbus.SerialDescriptorFactory.ParityList" 'property
           "configurationtab.modbus.SerialDescriptorFactory.PortDefault" 'property
           "configurationtab.modbus.SerialDescriptorFactory.PrecisionsCoilList" 'property
           "configurationtab.modbus.SerialDescriptorFactory.PrecisionsHRList" 'property
           "configurationtab.modbus.SerialDescriptorFactory.PropertiesSection" 'property
           "configurationtab.modbus.SerialDescriptorFactory.ReadButtonIcon" 'property
           "configurationtab.modbus.SerialDescriptorFactory.RegisterTypeList" 'property
           "configurationtab.modbus.SerialDescriptorFactory.ServerIdDefault" 'property
           "configurationtab.modbus.SerialDescriptorFactory.ServerIDRange" 'property
           "configurationtab.modbus.SerialDescriptorFactory.StopBitsList" 'property
           "configurationtab.modbus.SerialDescriptorFactory.TestConnectionSection" 'property
           "configurationtab.modbus.SerialDescriptorFactory.TimeoutDefault" 'property
           "configurationtab.modbus.SerialValidator" t ;; (class)
           "configurationtab.modbus.TcpipDescriptor" t ;; (class)
           "configurationtab.modbus.TcpipDescriptor.BaudRateDefault" 'property
           "configurationtab.modbus.TcpipDescriptor.BaudRateList" 'property
           "configurationtab.modbus.TcpipDescriptor.CustomDataFields" 'property
           "configurationtab.modbus.TcpipDescriptor.DataBitsList" 'property
           "configurationtab.modbus.TcpipDescriptor.DeviceAppletData" 'property
           "configurationtab.modbus.TcpipDescriptor.DeviceIconID" 'property
           "configurationtab.modbus.TcpipDescriptor.ErrorTitle" 'property
           "configurationtab.modbus.TcpipDescriptor.MapTopicID" 'property
           "configurationtab.modbus.TcpipDescriptor.ModbusApplet" 'property
           "configurationtab.modbus.TcpipDescriptor.ModbusSerialWidgetIcon" 'property
           "configurationtab.modbus.TcpipDescriptor.ModbusTcpipWidgetIcon" 'property
           "configurationtab.modbus.TcpipDescriptor.OrderList" 'property
           "configurationtab.modbus.TcpipDescriptor.ParityList" 'property
           "configurationtab.modbus.TcpipDescriptor.PortDefault" 'property
           "configurationtab.modbus.TcpipDescriptor.PrecisionsCoilList" 'property
           "configurationtab.modbus.TcpipDescriptor.PrecisionsHRList" 'property
           "configurationtab.modbus.TcpipDescriptor.PropertiesSection" 'property
           "configurationtab.modbus.TcpipDescriptor.ReadButtonIcon" 'property
           "configurationtab.modbus.TcpipDescriptor.RegisterTypeList" 'property
           "configurationtab.modbus.TcpipDescriptor.ServerIdDefault" 'property
           "configurationtab.modbus.TcpipDescriptor.ServerIDRange" 'property
           "configurationtab.modbus.TcpipDescriptor.StopBitsList" 'property
           "configurationtab.modbus.TcpipDescriptor.TestConnectionSection" 'property
           "configurationtab.modbus.TcpipDescriptor.TimeoutDefault" 'property
           "configurationtab.modbus.TcpipDescriptor.ToolboxBaseCode" 'property
           "configurationtab.modbus.TcpipDescriptorFactory" t ;; (class)
           "configurationtab.modbus.TcpipDescriptorFactory.BaudRateDefault" 'property
           "configurationtab.modbus.TcpipDescriptorFactory.BaudRateList" 'property
           "configurationtab.modbus.TcpipDescriptorFactory.CustomDataFields" 'property
           "configurationtab.modbus.TcpipDescriptorFactory.DataBitsList" 'property
           "configurationtab.modbus.TcpipDescriptorFactory.DeviceIconID" 'property
           "configurationtab.modbus.TcpipDescriptorFactory.ModbusSerialWidgetIcon" 'property
           "configurationtab.modbus.TcpipDescriptorFactory.ModbusTcpipWidgetIcon" 'property
           "configurationtab.modbus.TcpipDescriptorFactory.OrderList" 'property
           "configurationtab.modbus.TcpipDescriptorFactory.ParityList" 'property
           "configurationtab.modbus.TcpipDescriptorFactory.PortDefault" 'property
           "configurationtab.modbus.TcpipDescriptorFactory.PrecisionsCoilList" 'property
           "configurationtab.modbus.TcpipDescriptorFactory.PrecisionsHRList" 'property
           "configurationtab.modbus.TcpipDescriptorFactory.PropertiesSection" 'property
           "configurationtab.modbus.TcpipDescriptorFactory.ReadButtonIcon" 'property
           "configurationtab.modbus.TcpipDescriptorFactory.RegisterTypeList" 'property
           "configurationtab.modbus.TcpipDescriptorFactory.ServerIdDefault" 'property
           "configurationtab.modbus.TcpipDescriptorFactory.ServerIDRange" 'property
           "configurationtab.modbus.TcpipDescriptorFactory.StopBitsList" 'property
           "configurationtab.modbus.TcpipDescriptorFactory.TestConnectionSection" 'property
           "configurationtab.modbus.TcpipDescriptorFactory.TimeoutDefault" 'property
           "configurationtab.modbus.TcpipValidator" t ;; (class)
           "configureDetectorMonoCamera" t ;; (mFile) Configure object detector for using calibrated monocular camera
           "configureDictionary" t ;; (mFile) Create dictionary with specified key and value types
           "configureDiscretizedSecondOrderIntegrator" t ;; (mFile)
           "configureJDBCDataSource" t ;; (mFile) (To be removed) Configure JDBC data source
           "configureKalmanFilter" t ;; (mFile) Create Kalman filter for object tracking
           "configureMIDI" t ;; (pFile) Configure MIDI connections between audio object and MIDI controller
           "configureOceanOpticsDriver" t ;; (pFile)
           "configureOptionalOutport" t ;; (pFile)
           "conflict_mngt_concerto_gpio" t ;; (mFile)
           "conflict_mngt_interrupt_block" t ;; (mFile)
           "conformalArray" t ;; (mFile) Create conformal array
           "conformalArray.calcArraySize" t ;; (method)
           "confusion" t ;; (mFile) Classification confusion matrix
           "confusionchart" t ;; (mFile) Create confusion matrix chart for classification problem
           "confusionmat" t ;; (mFile) Compute confusion matrix for classification problem
           "coninputfactor" t ;; (mFile)
           "conj" t ;; (mFile) Complex conjugate
           "conjugateblm" t ;; (mFile) Bayesian linear regression model with conjugate prior for data likelihood
           "conjugatebvarm" t ;; (mFile) Bayesian vector autoregression (VAR) model with conjugate prior for data likelihood
           "conlinear" t ;; (mFile)
           "conndef" t ;; (mFile) Create connectivity array
           "connect" t ;; (mFile) Connect AUTOSAR architecture components and compositions
           "connectionelementddg" t ;; (pFile)
           "connectionelementddg_cb" t ;; (pFile)
           "ConnectionPort_class" t ;; (pFile)
           "connectline" t ;; (mFile)
           "connectOptions" t ;; (mFile) Options for the connect command
           "connector" t ;; (pFile)
           "ConnectorPlacement.BlockTransform" t ;; (class)
           "ConnectorPlacement.BlockTransform.StaticMetaType" t ;; (method)
           "ConnectorPlacement.ConnectorPositionOnRectBoundary" t ;; (class)
           "ConnectorPlacement.ConnectorPositionOnRectBoundary.connectorPositions" 'property
           "ConnectorPlacement.ConnectorPositionOnRectBoundary.StaticMetaClass" t ;; (method)
           "ConnectorPlacement.EquallySpacedConnector" t ;; (class)
           "ConnectorPlacement.EquallySpacedConnector.sides" 'property
           "ConnectorPlacement.EquallySpacedConnector.StaticMetaClass" t ;; (method)
           "ConnectorPlacement.EquallySpacedRectSide" t ;; (class)
           "ConnectorPlacement.EquallySpacedRectSide.connectorIds" 'property
           "ConnectorPlacement.EquallySpacedRectSide.StaticMetaClass" t ;; (method)
           "ConnectorPlacement.Fraction" t ;; (class)
           "ConnectorPlacement.Fraction.StaticMetaType" t ;; (method)
           "ConnectorPlacement.GraphicalContext" t ;; (class)
           "ConnectorPlacement.GraphicalContext.StaticMetaType" t ;; (method)
           "ConnectorPlacement.PlacementSchema" t ;; (class)
           "ConnectorPlacement.PlacementSchema.StaticMetaClass" t ;; (method)
           "ConnectorPlacement.RectBoundaryConnectorPosition" t ;; (class)
           "ConnectorPlacement.RectBoundaryConnectorPosition.StaticMetaClass" t ;; (method)
           "ConnectorPlacement.RectSide" t ;; (class)
           "ConnectorPlacement.RectSide.BOTTOM" 'enumeration
           "ConnectorPlacement.RectSide.HIDDEN" 'enumeration
           "ConnectorPlacement.RectSide.LEFT" 'enumeration
           "ConnectorPlacement.RectSide.RIGHT" 'enumeration
           "ConnectorPlacement.RectSide.TOP" 'enumeration
           "ConnectorPosition" t ;; (mFile)
           "ConnectorPosition.Both" 'enumeration
           "ConnectorPosition.Left" 'enumeration
           "ConnectorPosition.Right" 'enumeration
           "ConnectorTaperShape" t ;; (mFile)
           "ConnectorTaperShape.Linear" 'enumeration
           "ConnectorTaperShape.None" 'enumeration
           "conofinf" t ;; (mFile)
           "conrange" t ;; (mFile)
           "constacc" t ;; (mFile) State transition function for constant-acceleration motion model
           "constaccjac" t ;; (mFile) Jacobian of state transition function based on constant-acceleration motion model
           "constantDGub" t ;; (pFile)
           "constantExternalAudioPlugin" t ;; (pFile)
           "constantExternalAudioPluginSource" t ;; (pFile)
           "constantGammaClutter" t ;; (mFile) Simulate constant gamma clutter
           "constantplane" t ;; (mFile) Infinite plane in 3-D coordinates
           "constar" t ;; (mFile)
           "Constraint" t ;; (pFile)
           "constraint_manager" t ;; (pFile)
           "constraintAiming" t ;; (mFile) Create aiming constraint for pointing at a target location
           "constraintCartesianBounds" t ;; (mFile) Create constraint to keep body origin inside Cartesian bounds
           "constraintDistanceBounds" t ;; (mFile) Constrain body within distance bounds of reference body
           "constraintFixedJoint" t ;; (mFile) Fixed joint constraint between bodies
           "constraintJointBounds" t ;; (mFile) Create constraint on joint positions of robot model
           "constraintManager" t ;; (pFile)
           "constraintOrientationTarget" t ;; (mFile) Create constraint on relative orientation of body
           "constraintPoseTarget" t ;; (mFile) Create constraint on relative pose of body
           "constraintPositionTarget" t ;; (mFile) Create constraint on relative position of body
           "constraintPrismaticJoint" t ;; (mFile) Prismatic joint constraint between bodies
           "constraintRevoluteJoint" t ;; (mFile) Revolute joint constraint between bodies
           "constrfunEvaluator" t ;; (mFile)
           "constrfunFinDiffEvaluator" t ;; (mFile)
           "constrfungradEvaluator" t ;; (mFile)
           "constrgradEvaluator" t ;; (mFile)
           "constructIfSwitchSubsystem" t ;; (mFile)
           "constturn" t ;; (mFile) State transition function for constant turn-rate and velocity-magnitude motion model
           "constturnjac" t ;; (mFile) Jacobian of state transition function based on constant turn-rate and velocity-magnitude motion
           "constvel" t ;; (mFile) State transition function for constant-velocity motion model
           "constveljac" t ;; (mFile) Jacobian of state transition function based on constant-velocity motion model
           "constvelmsc" t ;; (mFile) State transition function for constant-velocity motion model in MSC frame
           "constvelmscjac" t ;; (mFile) Jacobian of state transition function based on constant-velocity motion model in MSC frame
           "consumcgmodel" t ;; (mFile)
           "conswitch" t ;; (mFile)
           "contable1" t ;; (mFile)
           "contable2" t ;; (mFile)
           "containers.Map" t ;; (class)
           "containers.Map.empty" t ;; (method)
           "contains" t ;; (mFile) Determine if pattern is in strings
           "Contents" t ;; (mFile)
           "contextMenuCloneDetection" t ;; (pFile)
           "continueSadea4Optimisation" t ;; (mFile)
           "continueSadea4OptimisationWithPlots" t ;; (mFile)
           "continueSadeaOptimisation" t ;; (mFile)
           "continueSadeaOptimisationWithPlots" t ;; (mFile)
           "contopptraj" t ;; (mFile) Generate trajectory subject to kinematic constraints
           "contour" t ;; (mFile) Contour plot of matrix
           "contour3" t ;; (mFile) 3-D contour plot
           "contour3m" t ;; (mFile) Project 3-D contour plot of map data
           "contourc" t ;; (mFile) Low-level contour matrix computation
           "contourcbar" t ;; (mFile) Color bar for filled contour map display
           "contourcmap" t ;; (mFile) Contour colormap and color bar
           "contourf" t ;; (mFile) Filled 2-D contour plot
           "contourfm" t ;; (mFile) Project filled 2-D contour plot of map data
           "contourm" t ;; (mFile) Project 2-D contour plot of map data
           "contours" t ;; (mFile)
           "contourslice" t ;; (mFile) Draw contours in volume slice planes
           "contrast" t ;; (mFile) Create grayscale colormap for indexed image
           "controlchart" t ;; (mFile) Control charts
           "controldesign.blockconfig.checkVariableParameter" t ;; (function)
           "controldesign.blockconfig.CStateSpace" t ;; (class)
           "controldesign.blockconfig.CStateSpace.getMDRC" t ;; (method)
           "controldesign.blockconfig.CStateSpaceIO" t ;; (class)
           "controldesign.blockconfig.CStateSpaceIO.getMDRC" t ;; (method)
           "controldesign.blockconfig.CTransferFcn" t ;; (class)
           "controldesign.blockconfig.CTransferFcn.getMDRC" t ;; (method)
           "controldesign.blockconfig.CTransferFcnIC" t ;; (class)
           "controldesign.blockconfig.CTransferFcnIC.getMDRC" t ;; (method)
           "controldesign.blockconfig.CTransferFcnIO" t ;; (class)
           "controldesign.blockconfig.CTransferFcnIO.getMDRC" t ;; (method)
           "controldesign.blockconfig.CustomBlockConfiguration" t ;; (class)
           "controldesign.blockconfig.CustomBlockConfiguration.getMDRC" t ;; (method)
           "controldesign.blockconfig.CZPK" t ;; (class)
           "controldesign.blockconfig.CZPK.getMDRC" t ;; (method)
           "controldesign.blockconfig.CZPKIC" t ;; (class)
           "controldesign.blockconfig.CZPKIC.getMDRC" t ;; (method)
           "controldesign.blockconfig.CZPKIO" t ;; (class)
           "controldesign.blockconfig.CZPKIO.getMDRC" t ;; (method)
           "controldesign.blockconfig.DFilterFcn" t ;; (class)
           "controldesign.blockconfig.DFilterFcn.getMDRC" t ;; (method)
           "controldesign.blockconfig.DStateSpace" t ;; (class)
           "controldesign.blockconfig.DStateSpace.getMDRC" t ;; (method)
           "controldesign.blockconfig.DTFFirstOrder" t ;; (class)
           "controldesign.blockconfig.DTFFirstOrder.getMDRC" t ;; (method)
           "controldesign.blockconfig.DTFLeadLag" t ;; (class)
           "controldesign.blockconfig.DTFLeadLag.getMDRC" t ;; (method)
           "controldesign.blockconfig.DTFRealZero" t ;; (class)
           "controldesign.blockconfig.DTFRealZero.getMDRC" t ;; (method)
           "controldesign.blockconfig.DTransferFcn" t ;; (class)
           "controldesign.blockconfig.DTransferFcn.getMDRC" t ;; (method)
           "controldesign.blockconfig.DTransferFcnIC" t ;; (class)
           "controldesign.blockconfig.DTransferFcnIC.getMDRC" t ;; (method)
           "controldesign.blockconfig.DTransferFcnIO" t ;; (class)
           "controldesign.blockconfig.DTransferFcnIO.getMDRC" t ;; (method)
           "controldesign.blockconfig.DZPK" t ;; (class)
           "controldesign.blockconfig.DZPK.getMDRC" t ;; (method)
           "controldesign.blockconfig.DZPKIC" t ;; (class)
           "controldesign.blockconfig.DZPKIC.getMDRC" t ;; (method)
           "controldesign.blockconfig.DZPKIO" t ;; (class)
           "controldesign.blockconfig.DZPKIO.getMDRC" t ;; (method)
           "controldesign.blockconfig.EML" t ;; (class)
           "controldesign.blockconfig.EML.getMDRC" t ;; (method)
           "controldesign.blockconfig.GainBlock" t ;; (class)
           "controldesign.blockconfig.GainBlock.getMDRC" t ;; (method)
           "controldesign.blockconfig.GainSurface" t ;; (class)
           "controldesign.blockconfig.GainSurface.getMDRC" t ;; (method)
           "controldesign.blockconfig.GenericPID" t ;; (class)
           "controldesign.blockconfig.GenericPID.getMDRC" t ;; (method)
           "controldesign.blockconfig.GenericSS" t ;; (class)
           "controldesign.blockconfig.GenericSS.getMDRC" t ;; (method)
           "controldesign.blockconfig.GenericTF" t ;; (class)
           "controldesign.blockconfig.GenericTF.getMDRC" t ;; (method)
           "controldesign.blockconfig.GenericZPK" t ;; (class)
           "controldesign.blockconfig.GenericZPK.getMDRC" t ;; (method)
           "controldesign.blockconfig.getMultiParamBlockSubs" t ;; (function)
           "controldesign.blockconfig.LTIBlock" t ;; (class)
           "controldesign.blockconfig.LTIBlock.getMDRC" t ;; (method)
           "controldesign.blockconfig.MDLTIBlock" t ;; (class)
           "controldesign.blockconfig.MDLTIBlock.getMDRC" t ;; (method)
           "controldesign.blockconfig.MDStateSpace" t ;; (class)
           "controldesign.blockconfig.MDStateSpace.getMDRC" t ;; (method)
           "controldesign.blockconfig.MDTransferFcn" t ;; (class)
           "controldesign.blockconfig.MDTransferFcn.getMDRC" t ;; (method)
           "controldesign.blockconfig.MDTransferFcnIC" t ;; (class)
           "controldesign.blockconfig.MDTransferFcnIC.getMDRC" t ;; (method)
           "controldesign.blockconfig.MDZPK" t ;; (class)
           "controldesign.blockconfig.MDZPK.getMDRC" t ;; (method)
           "controldesign.blockconfig.NDInterp" t ;; (class)
           "controldesign.blockconfig.NDInterp.getMDRC" t ;; (method)
           "controldesign.blockconfig.NDLookUp" t ;; (class)
           "controldesign.blockconfig.NDLookUp.getMDRC" t ;; (method)
           "controldesign.blockconfig.NDMatrixInterp" t ;; (class)
           "controldesign.blockconfig.NDMatrixInterp.getMDRC" t ;; (method)
           "controldesign.blockconfig.NullConfig" t ;; (class)
           "controldesign.blockconfig.NullConfig.getMDRC" t ;; (method)
           "controldesign.blockconfig.PIDApproxBlock" t ;; (class)
           "controldesign.blockconfig.PIDApproxBlock.getMDRC" t ;; (method)
           "controldesign.blockconfig.PIDBlock" t ;; (class)
           "controldesign.blockconfig.PIDBlock.getMDRC" t ;; (method)
           "controldesign.blockconfig.PIDBlock1DOF" t ;; (class)
           "controldesign.blockconfig.PIDBlock1DOF.getMDRC" t ;; (method)
           "controldesign.blockconfig.PIDBlock2DOF" t ;; (class)
           "controldesign.blockconfig.PIDBlock2DOF.getMDRC" t ;; (method)
           "controldesign.blockconfig.slBlockConfig" t ;; (class)
           "controldesign.blockconfig.slBlockConfig.getMDRC" t ;; (method)
           "controldesign.blockconfig.updateBlockParameters" t ;; (function)
           "controldesign.createTunedBlocks" t ;; (function)
           "controldesign.findTunableBlocks" t ;; (function)
           "ControlDesignBlock" t ;; (mFile)
           "ControlDesignBlock.empty" t ;; (method)
           "ControlDesignBlock.matchChannelNames" t ;; (method)
           "ControlledCurrentSource_class" t ;; (pFile)
           "ControlledSourcesCback" t ;; (pFile)
           "ControlledVoltageSource_class" t ;; (pFile)
           "controllerMPPI" t ;; (mFile)
           "controllerPurePursuit" t ;; (mFile) Create controller to follow set of waypoints
           "controllerTEB" t ;; (mFile) Avoid unseen obstacles with time-optimal trajectories
           "controllerVFH" t ;; (mFile) Avoid obstacles using vector field histogram
           "controllerVFH3D" t ;; (mFile) Avoid obstacles using 3D vector field histogram
           "controllib.chart.BodePlot" t ;; (class)
           "controllib.chart.BodePlot.doloadobj" t ;; (method)
           "controllib.chart.BodePlot.loadobj" t ;; (method)
           "controllib.chart.DiskMarginPlot" t ;; (class)
           "controllib.chart.DiskMarginPlot.doloadobj" t ;; (method)
           "controllib.chart.DiskMarginPlot.loadobj" t ;; (method)
           "controllib.chart.editor.BodeEditor" t ;; (class)
           "controllib.chart.editor.BodeEditor.doloadobj" t ;; (method)
           "controllib.chart.editor.BodeEditor.loadobj" t ;; (method)
           "controllib.chart.editor.NicholsEditor" t ;; (class)
           "controllib.chart.editor.NicholsEditor.doloadobj" t ;; (method)
           "controllib.chart.editor.NicholsEditor.loadobj" t ;; (method)
           "controllib.chart.editor.response.BodeEditorResponse" t ;; (class)
           "controllib.chart.editor.response.BodeEditorResponse.finalizeIncomingObject" t ;; (method)
           "controllib.chart.editor.response.BodeEditorResponse.modifyIncomingSerializationContent" t ;; (method)
           "controllib.chart.editor.response.BodeEditorResponse.modifyOutgoingSerializationContent" t ;; (method)
           "controllib.chart.editor.response.NicholsEditorResponse" t ;; (class)
           "controllib.chart.editor.response.NicholsEditorResponse.finalizeIncomingObject" t ;; (method)
           "controllib.chart.editor.response.NicholsEditorResponse.modifyIncomingSerializationContent" t ;; (method)
           "controllib.chart.editor.response.NicholsEditorResponse.modifyOutgoingSerializationContent" t ;; (method)
           "controllib.chart.editor.response.RootLocusEditorResponse" t ;; (class)
           "controllib.chart.editor.response.RootLocusEditorResponse.finalizeIncomingObject" t ;; (method)
           "controllib.chart.editor.response.RootLocusEditorResponse.modifyIncomingSerializationContent" t ;; (method)
           "controllib.chart.editor.response.RootLocusEditorResponse.modifyOutgoingSerializationContent" t ;; (method)
           "controllib.chart.editor.RLocusEditor" t ;; (class)
           "controllib.chart.editor.RLocusEditor.doloadobj" t ;; (method)
           "controllib.chart.editor.RLocusEditor.loadobj" t ;; (method)
           "controllib.chart.editor.view.BodeView" t ;; (class)
           "controllib.chart.editor.view.NicholsView" t ;; (class)
           "controllib.chart.editor.view.RLocusView" t ;; (class)
           "controllib.chart.HSVPlot" t ;; (class)
           "controllib.chart.HSVPlot.doloadobj" t ;; (method)
           "controllib.chart.HSVPlot.loadobj" t ;; (method)
           "controllib.chart.ImpulsePlot" t ;; (class)
           "controllib.chart.ImpulsePlot.doloadobj" t ;; (method)
           "controllib.chart.ImpulsePlot.loadobj" t ;; (method)
           "controllib.chart.InitialPlot" t ;; (class)
           "controllib.chart.InitialPlot.doloadobj" t ;; (method)
           "controllib.chart.InitialPlot.loadobj" t ;; (method)
           "controllib.chart.IOPZPlot" t ;; (class)
           "controllib.chart.IOPZPlot.doloadobj" t ;; (method)
           "controllib.chart.IOPZPlot.loadobj" t ;; (method)
           "controllib.chart.LSimPlot" t ;; (class)
           "controllib.chart.LSimPlot.doloadobj" t ;; (method)
           "controllib.chart.LSimPlot.loadobj" t ;; (method)
           "controllib.chart.NicholsPlot" t ;; (class)
           "controllib.chart.NicholsPlot.doloadobj" t ;; (method)
           "controllib.chart.NicholsPlot.loadobj" t ;; (method)
           "controllib.chart.NyquistPlot" t ;; (class)
           "controllib.chart.NyquistPlot.doloadobj" t ;; (method)
           "controllib.chart.NyquistPlot.loadobj" t ;; (method)
           "controllib.chart.options.CharacteristicOption" t ;; (class)
           "controllib.chart.options.CharacteristicsManager" t ;; (class)
           "controllib.chart.PassivePlot" t ;; (class)
           "controllib.chart.PassivePlot.doloadobj" t ;; (method)
           "controllib.chart.PassivePlot.loadobj" t ;; (method)
           "controllib.chart.PZPlot" t ;; (class)
           "controllib.chart.PZPlot.doloadobj" t ;; (method)
           "controllib.chart.PZPlot.loadobj" t ;; (method)
           "controllib.chart.response.BodeResponse" t ;; (class)
           "controllib.chart.response.BodeResponse.finalizeIncomingObject" t ;; (method)
           "controllib.chart.response.BodeResponse.modifyIncomingSerializationContent" t ;; (method)
           "controllib.chart.response.BodeResponse.modifyOutgoingSerializationContent" t ;; (method)
           "controllib.chart.response.DiskMarginResponse" t ;; (class)
           "controllib.chart.response.DiskMarginResponse.finalizeIncomingObject" t ;; (method)
           "controllib.chart.response.DiskMarginResponse.modifyIncomingSerializationContent" t ;; (method)
           "controllib.chart.response.DiskMarginResponse.modifyOutgoingSerializationContent" t ;; (method)
           "controllib.chart.response.HSVResponse" t ;; (class)
           "controllib.chart.response.HSVResponse.finalizeIncomingObject" t ;; (method)
           "controllib.chart.response.HSVResponse.modifyIncomingSerializationContent" t ;; (method)
           "controllib.chart.response.HSVResponse.modifyOutgoingSerializationContent" t ;; (method)
           "controllib.chart.response.ImpulseResponse" t ;; (class)
           "controllib.chart.response.ImpulseResponse.finalizeIncomingObject" t ;; (method)
           "controllib.chart.response.ImpulseResponse.modifyIncomingSerializationContent" t ;; (method)
           "controllib.chart.response.ImpulseResponse.modifyOutgoingSerializationContent" t ;; (method)
           "controllib.chart.response.InitialResponse" t ;; (class)
           "controllib.chart.response.InitialResponse.finalizeIncomingObject" t ;; (method)
           "controllib.chart.response.InitialResponse.modifyIncomingSerializationContent" t ;; (method)
           "controllib.chart.response.InitialResponse.modifyOutgoingSerializationContent" t ;; (method)
           "controllib.chart.response.IOPZResponse" t ;; (class)
           "controllib.chart.response.IOPZResponse.finalizeIncomingObject" t ;; (method)
           "controllib.chart.response.IOPZResponse.modifyIncomingSerializationContent" t ;; (method)
           "controllib.chart.response.IOPZResponse.modifyOutgoingSerializationContent" t ;; (method)
           "controllib.chart.response.LinearSimulationResponse" t ;; (class)
           "controllib.chart.response.LinearSimulationResponse.finalizeIncomingObject" t ;; (method)
           "controllib.chart.response.LinearSimulationResponse.modifyIncomingSerializationContent" t ;; (method)
           "controllib.chart.response.LinearSimulationResponse.modifyOutgoingSerializationContent" t ;; (method)
           "controllib.chart.response.NicholsResponse" t ;; (class)
           "controllib.chart.response.NicholsResponse.finalizeIncomingObject" t ;; (method)
           "controllib.chart.response.NicholsResponse.modifyIncomingSerializationContent" t ;; (method)
           "controllib.chart.response.NicholsResponse.modifyOutgoingSerializationContent" t ;; (method)
           "controllib.chart.response.NyquistResponse" t ;; (class)
           "controllib.chart.response.NyquistResponse.finalizeIncomingObject" t ;; (method)
           "controllib.chart.response.NyquistResponse.modifyIncomingSerializationContent" t ;; (method)
           "controllib.chart.response.NyquistResponse.modifyOutgoingSerializationContent" t ;; (method)
           "controllib.chart.response.PassiveResponse" t ;; (class)
           "controllib.chart.response.PassiveResponse.finalizeIncomingObject" t ;; (method)
           "controllib.chart.response.PassiveResponse.modifyIncomingSerializationContent" t ;; (method)
           "controllib.chart.response.PassiveResponse.modifyOutgoingSerializationContent" t ;; (method)
           "controllib.chart.response.PZResponse" t ;; (class)
           "controllib.chart.response.PZResponse.finalizeIncomingObject" t ;; (method)
           "controllib.chart.response.PZResponse.modifyIncomingSerializationContent" t ;; (method)
           "controllib.chart.response.PZResponse.modifyOutgoingSerializationContent" t ;; (method)
           "controllib.chart.response.RootLocusResponse" t ;; (class)
           "controllib.chart.response.RootLocusResponse.finalizeIncomingObject" t ;; (method)
           "controllib.chart.response.RootLocusResponse.modifyIncomingSerializationContent" t ;; (method)
           "controllib.chart.response.RootLocusResponse.modifyOutgoingSerializationContent" t ;; (method)
           "controllib.chart.response.SectorResponse" t ;; (class)
           "controllib.chart.response.SectorResponse.finalizeIncomingObject" t ;; (method)
           "controllib.chart.response.SectorResponse.modifyIncomingSerializationContent" t ;; (method)
           "controllib.chart.response.SectorResponse.modifyOutgoingSerializationContent" t ;; (method)
           "controllib.chart.response.SigmaResponse" t ;; (class)
           "controllib.chart.response.SigmaResponse.finalizeIncomingObject" t ;; (method)
           "controllib.chart.response.SigmaResponse.modifyIncomingSerializationContent" t ;; (method)
           "controllib.chart.response.SigmaResponse.modifyOutgoingSerializationContent" t ;; (method)
           "controllib.chart.response.StepResponse" t ;; (class)
           "controllib.chart.response.StepResponse.finalizeIncomingObject" t ;; (method)
           "controllib.chart.response.StepResponse.modifyIncomingSerializationContent" t ;; (method)
           "controllib.chart.response.StepResponse.modifyOutgoingSerializationContent" t ;; (method)
           "controllib.chart.RLocusPlot" t ;; (class)
           "controllib.chart.RLocusPlot.doloadobj" t ;; (method)
           "controllib.chart.RLocusPlot.loadobj" t ;; (method)
           "controllib.chart.SectorPlot" t ;; (class)
           "controllib.chart.SectorPlot.doloadobj" t ;; (method)
           "controllib.chart.SectorPlot.loadobj" t ;; (method)
           "controllib.chart.SigmaPlot" t ;; (class)
           "controllib.chart.SigmaPlot.doloadobj" t ;; (method)
           "controllib.chart.SigmaPlot.loadobj" t ;; (method)
           "controllib.chart.StepPlot" t ;; (class)
           "controllib.chart.StepPlot.doloadobj" t ;; (method)
           "controllib.chart.StepPlot.loadobj" t ;; (method)
           "controllibutils.AbstractDelayedCallback" t ;; (class)
           "controllibutils.CSTCustomSettings" t ;; (class)
           "controllibutils.CSTCustomSettings.getControlSystemDesignerVersion" t ;; (method)
           "controllibutils.CSTCustomSettings.getCSTPlotsVersion" t ;; (method)
           "controllibutils.CSTCustomSettings.getInstance" t ;; (method)
           "controllibutils.CSTCustomSettings.getMPCPlotsVersion" t ;; (method)
           "controllibutils.CSTCustomSettings.getResppackLayoutUpdate" t ;; (method)
           "controllibutils.CSTCustomSettings.setControlSystemDesignerVersion" t ;; (method)
           "controllibutils.CSTCustomSettings.setCSTPlotsVersion" t ;; (method)
           "controllibutils.CSTCustomSettings.setMPCPlotsVersion" t ;; (method)
           "controllibutils.CSTCustomSettings.setResppackLayoutUpdate" t ;; (method)
           "controllibutils.getAutoFreqUnits" t ;; (function)
           "controllibutils.getPosition" t ;; (function)
           "controllibutils.isLiveTaskFigure" t ;; (function)
           "controllibutils.isSITBInstalled" t ;; (function)
           "controllibutils.ListenerManager" t ;; (class)
           "controllibutils.ListenerManager.createVectListeners" t ;; (method)
           "controllibutils.utCustomCopyLineObj" t ;; (function)
           "controllibutils.utGetFrequencyUnitsMsgID" t ;; (function)
           "controllibutils.utGetValidFrequencyUnits" t ;; (function)
           "controllibutils.utGetValidTimeUnits" t ;; (function)
           "controllibutils.utXlateUnitsString" t ;; (function)
           "controlmenus" t ;; (mFile)
           "controlplotfunc" t ;; (mFile)
           "controlrules" t ;; (mFile) Western Electric and Nelson control rules
           "controlSystemDesigner" t ;; (mFile) Design single-input, single-output (SISO) controllers
           "controlSystemTuner" t ;; (mFile) Tune fixed-structure control systems
           "contwostage" t ;; (mFile)
           "conv" t ;; (mFile) Convolution and polynomial multiplication
           "conv2" t ;; (mFile) 2-D convolution
           "conv2hdlsharedtypes" t ;; (pFile)
           "convacc" t ;; (mFile) Convert from acceleration units to specified acceleration units
           "convang" t ;; (mFile) Convert from angle units to specified angle units
           "convangacc" t ;; (mFile) Convert from angular acceleration units to specified angular acceleration units
           "convangvel" t ;; (mFile) Convert from angular velocity units to desired angular velocity units
           "ConvClass" t ;; (pFile)
           "convcore" t ;; (mex)
           "convdeintrlv" t ;; (mFile) Restore ordering of symbols using shift registers
           "convdensity" t ;; (mFile) Convert from density units to specified density units
           "convenc" t ;; (mFile) Convolutionally encode binary message
           "convergent" t ;; (mFile) Round toward nearest integer with ties rounding to nearest even integer
           "ConversionFactorEnum" t ;; (pFile)
           "convert2annual" t ;; (mFile) Aggregate timetable data to annual periodicity
           "convert2daily" t ;; (mFile) Aggregate timetable data to daily periodicity
           "convert2db" t ;; (mFile)
           "convert2deg" t ;; (mFile)
           "convert2engstrs" t ;; (mFile)
           "convert2monthly" t ;; (mFile) Aggregate timetable data to monthly periodicity
           "convert2quarterly" t ;; (mFile) Aggregate timetable data to quarterly periodicity
           "convert2semiannual" t ;; (mFile) Aggregate timetable data to semiannual periodicity
           "convert2sq" t ;; (mFile)
           "convert2sur" t ;; (mFile) Convert multivariate normal regression model to seemingly unrelated regression (SUR) model
           "convert2vector" t ;; (mFile)
           "convert2weekly" t ;; (mFile) Aggregate timetable data to weekly periodicity
           "convertCharsToStrings" t ;; (mFile) Convert character arrays to string arrays, leaving other arrays unaltered
           "convertClientJsonToServerJson" t ;; (pFile)
           "convertContainedStringsToChars" t ;; (mFile) Convert string arrays at any level of cell array or structure
           "convertfis" t ;; (mFile) Convert previous versions of fuzzy inference data in current format
           "convertfrequnits" t ;; (mFile)
           "convertHDLCellArray2Str" t ;; (pFile)
           "convertlat" t ;; (mFile) Convert between geodetic and auxiliary latitudes
           "convertmagunits" t ;; (mFile)
           "convertMaskValueToInt" t ;; (pFile)
           "convertOdbDataToNative" t ;; (mFile)
           "convertParamEQToBiquad" t ;; (mFile)
           "convertSignalsToDataset" t ;; (pFile)
           "convertSNR" t ;; (mFile) Convert SNR values
           "convertSpreadsheetDates" t ;; (mFile)
           "convertSpreadsheetExcelDates" t ;; (mFile)
           "convertStringsToChars" t ;; (mFile) Convert string arrays to character arrays, leaving other arrays unaltered
           "converttobls" t ;; (mFile)
           "convertToGUIDECallbackArguments" t ;; (mFile)
           "convertToSingle" t ;; (pFile) Convert double-precision MATLAB code to single-precision MATLAB code
           "convertToSLDataset" t ;; (pFile) Convert contents of MAT file to Simulink.SimulationData.Dataset object in another MAT file
           "convertVibration" t ;; (mFile) Compute baseline-corrected and filtered acceleration, velocity, and displacement signals from vibration measurements using a single sensor output from either an accelerometer, velocity sensor, or displacement sensor
           "convertWidgetToSlim" t ;; (mFile)
           "convfactor" t ;; (mFile) Bond conversion factors
           "convforce" t ;; (mFile) Convert from force units to specified force units
           "convhull" t ;; (mFile) Convex hull
           "convhulln" t ;; (mFile) N-D convex hull
           "convintrlv" t ;; (mFile) Permute symbols using shift registers
           "convlength" t ;; (mFile) Convert from length units to desired length units
           "convmass" t ;; (mFile) Convert from mass units to specified mass units
           "convmtx" t ;; (mFile) Convolution matrix of Galois field vector
           "convmtx2" t ;; (mFile) 2-D convolution matrix
           "convn" t ;; (mFile) N-D convolution
           "convolution1dLayer" t ;; (mFile) 1-D convolutional layer
           "convolution2dLayer" t ;; (mFile) 2-D convolutional layer
           "convolution3dLayer" t ;; (mFile) 3-D convolutional layer
           "convpres" t ;; (mFile) Convert from pressure units to specified pressure units
           "convtemp" t ;; (mFile) Convert to desired temperature units
           "convvel" t ;; (mFile) Convert from current velocity units to desired velocity units
           "convwf" t ;; (mFile) Convolution weight function
           "convwf.apply" t ;; (function)
           "convwf.backprop" t ;; (function)
           "convwf.backstop" t ;; (function)
           "convwf.backstopParallel" t ;; (function)
           "convwf.discontinuity" t ;; (function)
           "convwf.dz_dp" t ;; (function)
           "convwf.dz_dw" t ;; (function)
           "convwf.forwardprop" t ;; (function)
           "convwf.forwardstart" t ;; (function)
           "convwf.inputDerivType" t ;; (function)
           "convwf.name" t ;; (function)
           "convwf.parameterInfo" t ;; (function)
           "convwf.simulinkParameters" t ;; (function)
           "convwf.size" t ;; (function)
           "convwf.type" t ;; (function)
           "convwf.weightDerivType" t ;; (function)
           "cool" t ;; (mFile) Cool colormap array
           "CoordinateReferenceSystem" t ;; (pFile)
           "cophenet" t ;; (mFile) Cophenetic correlation coefficient
           "coplanarWaveguide" t ;; (mFile) Create coplanar waveguide transmission line
           "copper" t ;; (mFile) Copper colormap array
           "copulacdf" t ;; (mFile) Copula cumulative distribution function
           "copulafit" t ;; (mFile) Fit copula to data
           "copulaparam" t ;; (mFile) Copula parameters as function of rank correlation
           "copulapdf" t ;; (mFile) Copula probability density function
           "copularnd" t ;; (mFile) Copula random numbers
           "copulastat" t ;; (mFile) Copula rank correlation
           "copy_object_properties" t ;; (pFile)
           "copyCosimDemoFiles" t ;; (pFile)
           "copyExampleCacheFiles" t ;; (pFile)
           "copyfile" t ;; (mFile) Copy file or folder
           "copyFunctionHandleToWorkers" t ;; (mFile)
           "copygraphics" t ;; (pFile) Copy plot or graphics content to clipboard
           "copyobj" t ;; (mFile) Copy graphics objects and their children
           "copyoptionsfcn" t ;; (mFile)
           "copyright_blk_callback" t ;; (mFile)
           "copyWebPanelToModel" t ;; (pFile)
           "cordexch" t ;; (mFile) Coordinate-exchange D-optimal design
           "cordicabs" t ;; (mFile) CORDIC-based absolute value
           "cordicacos" t ;; (mFile) CORDIC-based approximation of inverse cosine
           "cordicangle" t ;; (mFile) CORDIC-based phase angle
           "cordicasin" t ;; (mFile) CORDIC-based approximation of inverse sine
           "cordicatan2" t ;; (mFile) CORDIC-based four quadrant inverse tangent
           "cordiccart2pol" t ;; (mFile) CORDIC-based transformation of Cartesian coordinates to polar
           "cordiccexp" t ;; (mFile) CORDIC-based approximation of complex exponential
           "cordiccos" t ;; (mFile) CORDIC-b