//------------------------------------------------------------------------------
// <copyright file="ControlUtil.cs" company="Microsoft">
//     Copyright (c) Microsoft Corporation.  All rights reserved.
// </copyright>
//------------------------------------------------------------------------------
 
using System;
using System.Collections.Generic;
using System.Text;
using System.Web.Resources;
using System.Web.UI;

namespace System.Web.UI {
    internal class ControlUtil {
        internal static Control FindTargetControl(string controlID, Control control, bool searchNamingContainers) {
            Control foundControl;
            if (searchNamingContainers) {
                Control currentContainer;
                foundControl = null;

                // DevDiv 73305: Do not assume starting control is not a naming container.
                if (control is INamingContainer) {
                    currentContainer = control;
                }
                else {
                    currentContainer = control.NamingContainer;
                }

                do {
                    foundControl = currentContainer.FindControl(controlID);
                    currentContainer = currentContainer.NamingContainer;
                }
                while (foundControl == null && currentContainer != null);
            }
            else {
                foundControl = control.FindControl(controlID);
            }

            return foundControl;
        }

        internal static bool IsBuiltInHiddenField(string hiddenFieldName) {
            // Returns true is the field name represents a hidden field generated
            // by ASP.NET's core runtime. This includes fields such as ViewState and
            // EventValidation, but not ones generated by specific controls such as
            // TreeView and WebParts.

            // If the field is less than two chars long it's not built-in. (Perf)
            if (hiddenFieldName.Length <= 2) {
                return false;
            }

            // If it doesn't start with two underscores, it's not built-in. (Perf)
            if (hiddenFieldName[0] != '_' ||
                hiddenFieldName[1] != '_') {
                return false;
            }

            // Examine list of built-in ASP.NET fields. The list was created by examining
            // the ASP.NET source code for hidden field registration and rendering.
            // We exclude __VIEWSTATEENCRYPTED and __VIEWSTATEFIELDCOUNT from the list
            // since they're covered by the general __VIEWSTATE part.
            return
                hiddenFieldName.StartsWith("__VIEWSTATE", StringComparison.Ordinal) ||
                String.Equals(hiddenFieldName, "__EVENTVALIDATION", StringComparison.Ordinal) ||
                String.Equals(hiddenFieldName, "__LASTFOCUS", StringComparison.Ordinal) ||
                String.Equals(hiddenFieldName, "__SCROLLPOSITIONX", StringComparison.Ordinal) ||
                String.Equals(hiddenFieldName, "__SCROLLPOSITIONY", StringComparison.Ordinal) ||
                String.Equals(hiddenFieldName, "__EVENTTARGET", StringComparison.Ordinal) ||
                String.Equals(hiddenFieldName, "__EVENTARGUMENT", StringComparison.Ordinal) ||
                String.Equals(hiddenFieldName, "__PREVIOUSPAGE", StringComparison.Ordinal);
        }
    }
}
