# Reference

<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

### Classes

* [`haproxy`](#haproxy): A Puppet module, using storeconfigs, to model an haproxy configuration. Currently VERY limited - assumes Redhat/CentOS setup. Pull requests a
* [`haproxy::globals`](#haproxy--globals): For global configuration options used by all haproxy instances.
* [`haproxy::params`](#haproxy--params): This is a container class holding default parameters for for haproxy class.

### Defined types

#### Public Defined types

* [`haproxy::backend`](#haproxy--backend): This type will setup a backend service configuration block inside the
haproxy.cfg file on an haproxy load balancer.
* [`haproxy::balancermember`](#haproxy--balancermember): This type will setup a balancer member inside a listening service
configuration block in /etc/haproxy/haproxy.cfg on the load balancer.
* [`haproxy::defaults`](#haproxy--defaults): This type will setup a additional defaults configuration block inside the
haproxy.cfg file on an haproxy load balancer.
* [`haproxy::frontend`](#haproxy--frontend): This type will setup a frontend service configuration block inside
the haproxy.cfg file on an haproxy load balancer.
* [`haproxy::instance`](#haproxy--instance): Manages haproxy permitting multiple instances to run on the same machine.
* [`haproxy::instance_service`](#haproxy--instance_service): Set up the environment for an haproxy service.
* [`haproxy::listen`](#haproxy--listen): This type will setup a listening service configuration block inside
the haproxy.cfg file on an haproxy load balancer.
* [`haproxy::mailer`](#haproxy--mailer): This type will set up a mailer entry inside the mailers configuration block in
haproxy.cfg on the load balancer.
* [`haproxy::mailers`](#haproxy--mailers): This type will set up a mailers entry in haproxy.cfg on the load balancer.
* [`haproxy::mapfile`](#haproxy--mapfile): Manage an HAProxy map file as documented in
https://cbonte.github.io/haproxy-dconv/configuration-1.5.html#7.3.1-map
* [`haproxy::mapfile::entry`](#haproxy--mapfile--entry): Manage an HAProxy map file as documented in
https://cbonte.github.io/haproxy-dconv/configuration-1.5.html#7.3.1-map
* [`haproxy::peer`](#haproxy--peer): This type will set up a peer entry inside the peers configuration block in haproxy.cfg on the load balancer.
* [`haproxy::peer::collect_exported`](#haproxy--peer--collect_exported): Private define
* [`haproxy::peers`](#haproxy--peers): This type will set up a peers entry in haproxy.cfg
* [`haproxy::resolver`](#haproxy--resolver): This type will setup resolvers configuration block inside
the haproxy.cfg file on an haproxy load balancer.
* [`haproxy::userlist`](#haproxy--userlist): This type will set up a userlist configuration block inside the haproxy.cfg
file on an haproxy load balancer.

#### Private Defined types

* `haproxy::balancermember::collect_exported`
* `haproxy::config`: HAProxy configuration
* `haproxy::install`: Install haproxy
* `haproxy::mailer::collect_exported`
* `haproxy::service`: HAProxy service

### Functions

* [`haproxy::generate_error_message`](#haproxy--generate_error_message): Function created to generate error message. Any string as error message can be passed and the function can be called in epp templates.
* [`haproxy::sort_bind`](#haproxy--sort_bind)
* [`haproxy::validate_ip_addr`](#haproxy--validate_ip_addr)

### Data types

* [`Haproxy::Ports`](#Haproxy--Ports): Port or list of ports for haproxy. Supports `,` seperated list of ports also.

## Classes

### <a name="haproxy"></a>`haproxy`

A Puppet module, using storeconfigs, to model an haproxy configuration.
Currently VERY limited - assumes Redhat/CentOS setup. Pull requests accepted!

Currently requires the puppetlabs/concat module on the Puppet Forge and
 uses storeconfigs on the Puppet Server to export/collect resources
 from all balancer members.

#### Examples

##### 

```puppet
class { 'haproxy':
  global_options   => {
    'log'     => "${::ipaddress} local0",
    'chroot'  => '/var/lib/haproxy',
    'pidfile' => '/var/run/haproxy.pid',
    'maxconn' => '4000',
    'user'    => 'haproxy',
    'group'   => 'haproxy',
    'daemon'  => '',
    'stats'   => 'socket /var/lib/haproxy/stats'
  },
  defaults_options => {
    'log'     => 'global',
    'stats'   => 'enable',
    'option'  => 'redispatch',
    'retries' => '3',
    'timeout' => [
      'http-request 10s',
      'queue 1m',
      'connect 10s',
      'client 1m',
      'server 1m',
      'check 10s'
    ],
    'maxconn' => '8000'
  },
}
```

#### Parameters

The following parameters are available in the `haproxy` class:

* [`package_ensure`](#-haproxy--package_ensure)
* [`package_name`](#-haproxy--package_name)
* [`service_ensure`](#-haproxy--service_ensure)
* [`service_manage`](#-haproxy--service_manage)
* [`service_name`](#-haproxy--service_name)
* [`service_options`](#-haproxy--service_options)
* [`chroot_dir_manage`](#-haproxy--chroot_dir_manage)
* [`sysconfig_options`](#-haproxy--sysconfig_options)
* [`global_options`](#-haproxy--global_options)
* [`defaults_options`](#-haproxy--defaults_options)
* [`merge_options`](#-haproxy--merge_options)
* [`restart_command`](#-haproxy--restart_command)
* [`custom_fragment`](#-haproxy--custom_fragment)
* [`config_dir`](#-haproxy--config_dir)
* [`config_file`](#-haproxy--config_file)
* [`config_validate_cmd`](#-haproxy--config_validate_cmd)
* [`manage_config_dir`](#-haproxy--manage_config_dir)
* [`manage_service`](#-haproxy--manage_service)
* [`enable`](#-haproxy--enable)

##### <a name="-haproxy--package_ensure"></a>`package_ensure`

Data type: `Variant[Enum['present', 'absent', 'purged', 'disabled', 'installed', 'latest'], String[1]]`

Ensure the package is present (installed), absent or a specific version.
Defaults to 'present'

Default value: `'present'`

##### <a name="-haproxy--package_name"></a>`package_name`

Data type: `String`

The package name of haproxy. Defaults to 'haproxy'
NOTE: haproxy::instance has a different default.

Default value: `$haproxy::params::package_name`

##### <a name="-haproxy--service_ensure"></a>`service_ensure`

Data type: `Variant[Enum['running', 'stopped'], Boolean]`

Chooses whether the haproxy service should be running & enabled at boot, or
stopped and disabled at boot. Defaults to 'running'

Default value: `'running'`

##### <a name="-haproxy--service_manage"></a>`service_manage`

Data type: `Boolean`

Chooses whether the haproxy service state should be managed by puppet at
all. Defaults to true

Default value: `true`

##### <a name="-haproxy--service_name"></a>`service_name`

Data type: `String`

The service name for haproxy. Defaults to 'haproxy'
NOTE: haproxy::instance has a different default.

Default value: `$haproxy::params::service_name`

##### <a name="-haproxy--service_options"></a>`service_options`

Data type: `String`

Contents for the `/etc/defaults/haproxy` file on Debian. Defaults to "ENABLED=1\n" on Debian, and is ignored on other systems.

Default value: `$haproxy::params::service_options`

##### <a name="-haproxy--chroot_dir_manage"></a>`chroot_dir_manage`

Data type: `Boolean`

Chooses whether the haproxy chroot directory should be managed by puppet
at all. Defaults to true

Default value: `true`

##### <a name="-haproxy--sysconfig_options"></a>`sysconfig_options`

Data type: `String`

Contents for the `/etc/sysconfig/haproxy` file on RedHat(-based) systems.
Defaults to OPTIONS="" on RedHat(-based) systems and is ignored on others

Default value: `$haproxy::params::sysconfig_options`

##### <a name="-haproxy--global_options"></a>`global_options`

Data type: `Hash`

A hash of all the haproxy global options. If you want to specify more
 than one option (i.e. multiple timeout or stats options), pass those
 options as an array and you will get a line for each of them in the
 resultant haproxy.cfg file.

Default value: `$haproxy::params::global_options`

##### <a name="-haproxy--defaults_options"></a>`defaults_options`

Data type: `Hash`

A hash of all the haproxy defaults options. If you want to specify more
 than one option (i.e. multiple timeout or stats options), pass those
 options as an array and you will get a line for each of them in the
 resultant haproxy.cfg file.

Default value: `$haproxy::params::defaults_options`

##### <a name="-haproxy--merge_options"></a>`merge_options`

Data type: `Boolean`

Whether to merge the user-supplied `global_options`/`defaults_options`
hashes with their default values set in params.pp. Merging allows to change
or add options without having to recreate the entire hash. Defaults to
false, but will default to true in future releases.

Default value: `$haproxy::params::merge_options`

##### <a name="-haproxy--restart_command"></a>`restart_command`

Data type: `Optional[String]`

Command to use when restarting the on config changes.
 Passed directly as the <code>'restart'</code> parameter to the service resource.
 Defaults to undef i.e. whatever the service default is.

Default value: `undef`

##### <a name="-haproxy--custom_fragment"></a>`custom_fragment`

Data type: `Optional[String]`

Allows arbitrary HAProxy configuration to be passed through to support
additional configuration not available via parameters, or to short-circute
the defined resources such as haproxy::listen when an operater would rather
just write plain configuration. Accepts a string (ie, output from the
template() function). Defaults to undef

Default value: `undef`

##### <a name="-haproxy--config_dir"></a>`config_dir`

Data type: `Stdlib::Absolutepath`

Path to the directory in which the main configuration file `haproxy.cfg`
resides. Will also be used for storing any managed map files (see
`haproxy::mapfile`). Default depends on platform.

Default value: `$haproxy::params::config_dir`

##### <a name="-haproxy--config_file"></a>`config_file`

Data type: `Optional[Stdlib::Absolutepath]`

Optional. Path to the haproxy config file.
Default depends on platform.

Default value: `$haproxy::params::config_file`

##### <a name="-haproxy--config_validate_cmd"></a>`config_validate_cmd`

Data type: `Variant[Stdlib::Absolutepath, String]`

Optional. Command used by concat validate_cmd to validate new
config file concat is a valid haproxy config.
Default /usr/sbin/haproxy -f % -c

Default value: `$haproxy::params::config_validate_cmd`

##### <a name="-haproxy--manage_config_dir"></a>`manage_config_dir`

Data type: `Boolean`

Optional.

Default value: `$haproxy::params::manage_config_dir`

##### <a name="-haproxy--manage_service"></a>`manage_service`

Data type: `Optional[Boolean]`

Deprecated

Default value: `undef`

##### <a name="-haproxy--enable"></a>`enable`

Data type: `Optional[Boolean]`

Deprecated

Default value: `undef`

### <a name="haproxy--globals"></a>`haproxy::globals`

For global configuration options used by all haproxy instances.

#### Parameters

The following parameters are available in the `haproxy::globals` class:

* [`sort_options_alphabetic`](#-haproxy--globals--sort_options_alphabetic)

##### <a name="-haproxy--globals--sort_options_alphabetic"></a>`sort_options_alphabetic`

Data type: `Boolean`

Sort options either alphabetic or custom like haproxy internal sorts them.
Defaults to true.

Default value: `true`

### <a name="haproxy--params"></a>`haproxy::params`

This is a container class holding default parameters for for haproxy class.

* **Note** Currently, only the Redhat family is supported, but this can be easily
extended by changing package names and configuration file paths.

## Defined types

### <a name="haproxy--backend"></a>`haproxy::backend`

=== Authors

Gary Larizza <gary@puppetlabs.com>
Jeremy Kitchen <jeremy@nationbuilder.com>

* **Note** Each backend service needs one
or more backend member servers (that can be declared with the
haproxy::balancermember defined resource type).  Using storeconfigs, you can
export the haproxy::balancermember resources on all load balancer member
servers and then collect them on a single haproxy load balancer server.

#### Examples

##### 

```puppet
haproxy::backend { 'puppet00':
  options   => {
    'option'  => [
      'tcplog',
      'ssl-hello-chk'
    ],
    'balance' => 'roundrobin'
  },
}
```

#### Parameters

The following parameters are available in the `haproxy::backend` defined type:

* [`section_name`](#-haproxy--backend--section_name)
* [`mode`](#-haproxy--backend--mode)
* [`description`](#-haproxy--backend--description)
* [`options`](#-haproxy--backend--options)
* [`collect_exported`](#-haproxy--backend--collect_exported)
* [`config_file`](#-haproxy--backend--config_file)
* [`sort_options_alphabetic`](#-haproxy--backend--sort_options_alphabetic)
* [`defaults`](#-haproxy--backend--defaults)
* [`instance`](#-haproxy--backend--instance)

##### <a name="-haproxy--backend--section_name"></a>`section_name`

Data type: `String[1]`

This name goes right after the 'backend' statement in haproxy.cfg
Default: $name (the namevar of the resource).

Default value: `$name`

##### <a name="-haproxy--backend--mode"></a>`mode`

Data type: `Optional[Enum['tcp', 'http', 'health']]`

The mode of operation for the backend service. Valid values are undef,
 'tcp', 'http', and 'health'.

Default value: `undef`

##### <a name="-haproxy--backend--description"></a>`description`

Data type: `Optional[String]`

Allows to add a sentence to describe the related object in the HAProxy HTML
stats page. The description will be printed on the right of the object name
it describes. Usefull in huge environments

Default value: `undef`

##### <a name="-haproxy--backend--options"></a>`options`

Data type: `Variant[Hash, Array[Hash]]`

A hash of options that are inserted into the backend configuration block.

Default value:

```puppet
{
    'balance' => 'roundrobin',
  }
```

##### <a name="-haproxy--backend--collect_exported"></a>`collect_exported`

Data type: `Boolean`

Boolean, default 'true'. True means 'collect exported @@balancermember
 resources' (for the case when every balancermember node exports itself),
 false means 'rely on the existing declared balancermember resources' (for
 the case when you know the full set of balancermember in advance and use
 haproxy::balancermember with array arguments, which allows you to deploy
 everything in 1 run)

Default value: `true`

##### <a name="-haproxy--backend--config_file"></a>`config_file`

Data type: `Optional[Stdlib::Absolutepath]`

Optional. Path of the config file where this entry will be added.
Assumes that the parent directory exists.
Default: $haproxy::params::config_file

Default value: `undef`

##### <a name="-haproxy--backend--sort_options_alphabetic"></a>`sort_options_alphabetic`

Data type: `Boolean`

Sort options either alphabetic or custom like haproxy internal sorts them.
Defaults to true.

Default value: `true`

##### <a name="-haproxy--backend--defaults"></a>`defaults`

Data type: `Optional[String]`

Name of the defaults section this backend will use.
Defaults to undef which means the global defaults section will be used.

Default value: `undef`

##### <a name="-haproxy--backend--instance"></a>`instance`

Data type: `String`

Optional. Defaults to 'haproxy'

Default value: `'haproxy'`

### <a name="haproxy--balancermember"></a>`haproxy::balancermember`

This type will setup a balancer member inside a listening service
configuration block in /etc/haproxy/haproxy.cfg on the load balancer.

* **Note** Currently it only has the ability to specify the instance name,
ip address, port, and whether or not it is a backup. More features
can be added as needed. The best way to implement this is to export
this resource for all haproxy balancer member servers, and then collect
them on the main haproxy load balancer.

#### Examples

##### 

```puppet
Exporting the resource for a balancer member:

@@haproxy::balancermember { 'haproxy':
  listening_service => 'puppet00',
  ports             => [8140],
  server_names      => $::hostname,
  ipaddresses       => $::ipaddress,
  options           => 'check',
}

Collecting the resource on a load balancer

Haproxy::Balancermember <<| listening_service == 'puppet00' |>>
```

##### 

```puppet
Creating the resource for multiple balancer members at once
(for single-pass installation of haproxy without requiring a first
pass to export the resources if you know the members in advance):

haproxy::balancermember { 'haproxy':
  listening_service => 'puppet00',
  ports             => 8140,
  server_names      => ['server01', 'server02'],
  ipaddresses       => ['192.168.56.200', '192.168.56.201'],
  options           => 'check',
}
```

##### 

```puppet
Implemented in HAPROXY 1.8:
Set a template to initialize servers with shared parameters.
The names of these servers are built from <prefix> and <amount> parameters.

  Initializes 5 servers with srv1, srv2, srv3, srv4 and srv5 as names,
  myserver.example.com as FQDN, 8140 as port, and health-check enabled.

haproxy::balancermember { 'haproxy':
  listening_service => 'puppet00',
  type              => 'server-template'
  port              => '8140',
  prefix            => 'srv',
  amount            => '1-5',
  fqdn              => 'myserver.example.com',
  options           => 'check',
}

(this resource can be declared anywhere)
```

#### Parameters

The following parameters are available in the `haproxy::balancermember` defined type:

* [`listening_service`](#-haproxy--balancermember--listening_service)
* [`ports`](#-haproxy--balancermember--ports)
* [`port`](#-haproxy--balancermember--port)
* [`server_names`](#-haproxy--balancermember--server_names)
* [`ipaddresses`](#-haproxy--balancermember--ipaddresses)
* [`prefix`](#-haproxy--balancermember--prefix)
* [`amount`](#-haproxy--balancermember--amount)
* [`fqdn`](#-haproxy--balancermember--fqdn)
* [`options`](#-haproxy--balancermember--options)
* [`define_cookies`](#-haproxy--balancermember--define_cookies)
* [`defaults`](#-haproxy--balancermember--defaults)
* [`config_file`](#-haproxy--balancermember--config_file)
* [`verifyhost`](#-haproxy--balancermember--verifyhost)
* [`weight`](#-haproxy--balancermember--weight)
* [`instance`](#-haproxy--balancermember--instance)
* [`type`](#-haproxy--balancermember--type)

##### <a name="-haproxy--balancermember--listening_service"></a>`listening_service`

Data type: `String`

The haproxy service's instance name (or, the title of the
 haproxy::listen resource). This must match up with a declared
 haproxy::listen resource.

##### <a name="-haproxy--balancermember--ports"></a>`ports`

Data type: `Optional[Haproxy::Ports]`

An array or commas-separated list of ports for which the balancer member
 will accept connections from the load balancer. Note that cookie values
 aren't yet supported, but shouldn't be difficult to add to the
 configuration. If you use an array in server_names and ipaddresses, the
 same port is used for all balancermembers.

Default value: `undef`

##### <a name="-haproxy--balancermember--port"></a>`port`

Data type: `Optional[Variant[String, Stdlib::Port]]`

A port for server-template. It is an optional specification.

Default value: `undef`

##### <a name="-haproxy--balancermember--server_names"></a>`server_names`

Data type: `Variant[String[1], Array]`

The name of the balancer member server as known to haproxy in the
 listening service's configuration block. This defaults to the
 hostname. Can be an array of the same length as ipaddresses,
 in which case a balancermember is created for each pair of
 server_names and ipaddresses (in lockstep).

Default value: `$facts['networking']['hostname']`

##### <a name="-haproxy--balancermember--ipaddresses"></a>`ipaddresses`

Data type: `Variant[String, Array]`

The ip address used to contact the balancer member server.
 Can be an array, see documentation to server_names.

Default value: `$facts['networking']['ip']`

##### <a name="-haproxy--balancermember--prefix"></a>`prefix`

Data type: `String`

A prefix for the server-template for the server names to be built.

Default value: `'server'`

##### <a name="-haproxy--balancermember--amount"></a>`amount`

Data type: `String`

If "amount" is provided, the server-template initializes <num> servers
 with 1 up to <num> as server name suffixes. A range of numbers
 <num_low>-<num_high> may also be used to use <num_low> up to
 <num_high> as server name suffixes.

Default value: `'1'`

##### <a name="-haproxy--balancermember--fqdn"></a>`fqdn`

Data type: `Optional[String]`

A FQDN for all the servers the server-template initializes.

Default value: `undef`

##### <a name="-haproxy--balancermember--options"></a>`options`

Data type: `Optional[Variant[String, Array]]`

An array of options to be specified after the server declaration
 in the listening service's configuration block.

Default value: `undef`

##### <a name="-haproxy--balancermember--define_cookies"></a>`define_cookies`

Data type: `Boolean`

If true, then add "cookie SERVERID" stickiness options.
 Default false.

Default value: `false`

##### <a name="-haproxy--balancermember--defaults"></a>`defaults`

Data type: `Optional[String]`

Name of the defaults section the backend or listener use.
Defaults to undef.

Default value: `undef`

##### <a name="-haproxy--balancermember--config_file"></a>`config_file`

Data type: `Optional[Stdlib::Absolutepath]`

Optional. Path of the config file where this entry will be added.
Assumes that the parent directory exists.
Default: $haproxy::params::config_file

Default value: `undef`

##### <a name="-haproxy--balancermember--verifyhost"></a>`verifyhost`

Data type: `Boolean`

Optional. Will add the verifyhost option to the server line, using the
specific host from server_names as an argument.
Default: false

Default value: `false`

##### <a name="-haproxy--balancermember--weight"></a>`weight`

Data type: `Optional[Variant[String, Integer]]`

Optional. Will add the weight option to the server line
Default: undef

Default value: `undef`

##### <a name="-haproxy--balancermember--instance"></a>`instance`

Data type: `String`

Optional. Defaults to 'haproxy'

Default value: `'haproxy'`

##### <a name="-haproxy--balancermember--type"></a>`type`

Data type: `Enum['server', 'default-server', 'server-template']`

Optional. Defaults to 'server'

Default value: `'server'`

### <a name="haproxy--defaults"></a>`haproxy::defaults`

This type will setup a additional defaults configuration block inside the
haproxy.cfg file on an haproxy load balancer.

* **Note** A new default configuration block resets all defaults of prior defaults configuration blocks.
Listener, Backends, Frontends and Balancermember can be configured behind a default
configuration block by setting the defaults parameter to the corresponding
defaults name.

#### Parameters

The following parameters are available in the `haproxy::defaults` defined type:

* [`options`](#-haproxy--defaults--options)
* [`sort_options_alphabetic`](#-haproxy--defaults--sort_options_alphabetic)
* [`merge_options`](#-haproxy--defaults--merge_options)
* [`instance`](#-haproxy--defaults--instance)

##### <a name="-haproxy--defaults--options"></a>`options`

Data type: `Hash`

A hash of options that are inserted into the defaults configuration block.

Default value: `{}`

##### <a name="-haproxy--defaults--sort_options_alphabetic"></a>`sort_options_alphabetic`

Data type: `Boolean`

Sort options either alphabetic or custom like haproxy internal sorts them.
Defaults to true.

Default value: `true`

##### <a name="-haproxy--defaults--merge_options"></a>`merge_options`

Data type: `Boolean`

Whether to merge the user-supplied `options` hash with the
`default_options` values set in params.pp. Merging allows to change
or add options without having to recreate the entire hash.

Default value: `$haproxy::params::merge_options`

##### <a name="-haproxy--defaults--instance"></a>`instance`

Data type: `String`

Optional. Defaults to 'haproxy'.

Default value: `'haproxy'`

### <a name="haproxy--frontend"></a>`haproxy::frontend`

=== Authors

Gary Larizza <gary@puppetlabs.com>

* **Note** Currently requires the puppetlabs/concat module on the Puppet Forge and
uses storeconfigs on the Puppet Server to export/collect resources
from all balancer members.

#### Examples

##### 

```puppet
Exporting the resource for a balancer member:

haproxy::frontend { 'puppet00':
  ipaddress    => $::ipaddress,
  ports        => [18140],
  mode         => 'tcp',
  bind_options => 'accept-proxy',
  options      => {
    'option'   => [
      'tcplog',
      'accept-invalid-http-request',
    ],
    'timeout client' => '30s',
    'balance'    => 'roundrobin'
  },
}
```

#### Parameters

The following parameters are available in the `haproxy::frontend` defined type:

* [`section_name`](#-haproxy--frontend--section_name)
* [`ports`](#-haproxy--frontend--ports)
* [`bind`](#-haproxy--frontend--bind)
* [`ipaddress`](#-haproxy--frontend--ipaddress)
* [`mode`](#-haproxy--frontend--mode)
* [`description`](#-haproxy--frontend--description)
* [`bind_options`](#-haproxy--frontend--bind_options)
* [`options`](#-haproxy--frontend--options)
* [`sort_options_alphabetic`](#-haproxy--frontend--sort_options_alphabetic)
* [`defaults`](#-haproxy--frontend--defaults)
* [`defaults_use_backend`](#-haproxy--frontend--defaults_use_backend)
* [`config_file`](#-haproxy--frontend--config_file)
* [`collect_exported`](#-haproxy--frontend--collect_exported)
* [`instance`](#-haproxy--frontend--instance)

##### <a name="-haproxy--frontend--section_name"></a>`section_name`

Data type: `String[1]`

This name goes right after the 'frontend' statement in haproxy.cfg
Default: $name (the namevar of the resource).

Default value: `$name`

##### <a name="-haproxy--frontend--ports"></a>`ports`

Data type: `Optional[Haproxy::Ports]`

Ports on which the proxy will listen for connections on the ip address
 specified in the ipaddress parameter. Accepts either a single
 comma-separated string or an array of strings which may be ports or
 hyphenated port ranges.

Default value: `undef`

##### <a name="-haproxy--frontend--bind"></a>`bind`

Data type: `Optional[Hash]`

Set of ip addresses, port and bind options
$bind = { '10.0.0.1:80' => ['ssl', 'crt', '/path/to/my/crt.pem'] }

Default value: `undef`

##### <a name="-haproxy--frontend--ipaddress"></a>`ipaddress`

Data type: `Optional[Variant[String, Array]]`

The ip address the proxy binds to.
 Empty addresses, '*', and '0.0.0.0' mean that the proxy listens
 to all valid addresses on the system.

Default value: `undef`

##### <a name="-haproxy--frontend--mode"></a>`mode`

Data type: `Optional[Enum['tcp', 'http', 'health']]`

The mode of operation for the frontend service. Valid values are undef,
 'tcp', 'http', and 'health'.

Default value: `undef`

##### <a name="-haproxy--frontend--description"></a>`description`

Data type: `Optional[String]`

Allows to add a sentence to describe the related object in the HAProxy HTML
stats page. The description will be printed on the right of the object name
it describes. Usefull in huge environments

Default value: `undef`

##### <a name="-haproxy--frontend--bind_options"></a>`bind_options`

Data type: `Optional[Array]`

(Deprecated) An array of options to be specified after the bind declaration
 in the listening serivce's configuration block.

Default value: `undef`

##### <a name="-haproxy--frontend--options"></a>`options`

Data type: `Variant[Hash, Array[Hash]]`

A hash of options that are inserted into the frontend service
 configuration block.

Default value:

```puppet
{
    'option'                                    => [
      'tcplog',
    ],
  }
```

##### <a name="-haproxy--frontend--sort_options_alphabetic"></a>`sort_options_alphabetic`

Data type: `Boolean`

Sort options either alphabetic or custom like haproxy internal sorts them.
Defaults to true.

Default value: `true`

##### <a name="-haproxy--frontend--defaults"></a>`defaults`

Data type: `Optional[String]`

Name of the defaults section this backend will use.
Defaults to undef which means the global defaults section will be used.

Default value: `undef`

##### <a name="-haproxy--frontend--defaults_use_backend"></a>`defaults_use_backend`

Data type: `Boolean`

If defaults are used and a default backend is configured use the backend
name for ordering. This means that the frontend is placed in the
configuration file before the backend configuration.
Defaults to true.

Default value: `true`

##### <a name="-haproxy--frontend--config_file"></a>`config_file`

Data type: `Optional[Stdlib::Absolutepath]`

Optional. Path of the config file where this entry will be added.
Assumes that the parent directory exists.
Default: $haproxy::params::config_file

Default value: `undef`

##### <a name="-haproxy--frontend--collect_exported"></a>`collect_exported`

Data type: `Boolean`

Boolean. Default true

Default value: `true`

##### <a name="-haproxy--frontend--instance"></a>`instance`

Data type: `String`

Optional. Defaults to 'haproxy'

Default value: `'haproxy'`

### <a name="haproxy--instance"></a>`haproxy::instance`

template() function). Defaults to undef

* **Note** Normally users use the Class['haproxy'], which runs a single haproxy
daemon on a machine.

#### Examples

##### 

```puppet
A single instance of haproxy with all defaults
i.e. emulate Class['haproxy']
 package{ 'haproxy': ensure => present }->haproxy::instance { 'haproxy': }->
 haproxy::listen { 'puppet00':
   instance         => 'haproxy',
   collect_exported => false,
   ipaddress        => $::ipaddress,
   ports            => '8140',
 }
```

##### 

```puppet
Multiple instances of haproxy:
 haproxy::instance { 'group1': }
 haproxy::instance_service { 'group1':
   haproxy_init_source => "puppet:///modules/${module_name}/haproxy-group1.init",
 }
 haproxy::listen { 'puppet00':
   instance         => 'group1',
   collect_exported => false,
   ipaddress        => $::ipaddress,
   ports            => '8800',
   requires         => Package['haproxy'],
 }
 haproxy::instance { 'group2': }
 haproxy::instance_service { 'group2':
   haproxy_init_source => "puppet:///modules/${module_name}/haproxy-group1.init",
 }
 haproxy::listen { 'puppet00':
   instance         => 'group2',
   collect_exported => false,
   ipaddress        => $::ipaddress,
   ports            => '9900',
   requires         => Package['haproxy'],
 }
```

##### 

```puppet
Multiple instances of haproxy, one with a custom haproxy package:
 haproxy::instance { 'group1': }
 haproxy::instance_service { 'group1':
   haproxy_init_source => "puppet:///modules/${module_name}/haproxy-group1.init",
 }
 haproxy::listen { 'puppet00':
   instance         => 'group1',
   collect_exported => false,
   ipaddress        => $::ipaddress,
   ports            => '8800',
   requires         => Package['haproxy'],
 }
 haproxy::instance { 'group2': }
 haproxy::instance_service { 'group2':
   haproxy_package     => 'custom_haproxy',
   haproxy_init_source => "puppet:///modules/${module_name}/haproxy-group2.init",
 }
 haproxy::listen { 'puppet00':
   instance         => 'group2',
   collect_exported => false,
   ipaddress        => $::ipaddress,
   ports            => '9900',
   requires         => Package['haproxy'],
 }
```

#### Parameters

The following parameters are available in the `haproxy::instance` defined type:

* [`package_ensure`](#-haproxy--instance--package_ensure)
* [`package_name`](#-haproxy--instance--package_name)
* [`service_ensure`](#-haproxy--instance--service_ensure)
* [`service_manage`](#-haproxy--instance--service_manage)
* [`chroot_dir_manage`](#-haproxy--instance--chroot_dir_manage)
* [`service_name`](#-haproxy--instance--service_name)
* [`global_options`](#-haproxy--instance--global_options)
* [`defaults_options`](#-haproxy--instance--defaults_options)
* [`restart_command`](#-haproxy--instance--restart_command)
* [`custom_fragment`](#-haproxy--instance--custom_fragment)
* [`config_file`](#-haproxy--instance--config_file)
* [`config_validate_cmd`](#-haproxy--instance--config_validate_cmd)
* [`config_dir`](#-haproxy--instance--config_dir)
* [`merge_options`](#-haproxy--instance--merge_options)
* [`service_options`](#-haproxy--instance--service_options)
* [`sysconfig_options`](#-haproxy--instance--sysconfig_options)

##### <a name="-haproxy--instance--package_ensure"></a>`package_ensure`

Data type: `Variant[Enum['present', 'absent', 'purged', 'disabled', 'installed', 'latest'], String[1]]`

Ensure the package is present (installed), absent or a specific version.
Defaults to 'present'

Default value: `'present'`

##### <a name="-haproxy--instance--package_name"></a>`package_name`

Data type: `Optional[String]`

The package name of haproxy. Defaults to undef, and no package is installed.
NOTE: Class['haproxy'] has a different default.

Default value: `undef`

##### <a name="-haproxy--instance--service_ensure"></a>`service_ensure`

Data type: `Variant[Enum['running', 'stopped'], Boolean]`

Chooses whether the haproxy service should be running & enabled at boot, or
stopped and disabled at boot. Defaults to 'running'

Default value: `'running'`

##### <a name="-haproxy--instance--service_manage"></a>`service_manage`

Data type: `Boolean`

Chooses whether the haproxy service state should be managed by puppet at
all. Defaults to true

Default value: `true`

##### <a name="-haproxy--instance--chroot_dir_manage"></a>`chroot_dir_manage`

Data type: `Boolean`

Chooses whether the haproxy chroot directory should be managed by puppet
at all. Defaults to true

Default value: `true`

##### <a name="-haproxy--instance--service_name"></a>`service_name`

Data type: `Optional[String]`

The service name for haproxy. Defaults to undef. If no name is given then
the value computed for $instance_name will be used.
NOTE: Class['haproxy'] has a different default.

Default value: `undef`

##### <a name="-haproxy--instance--global_options"></a>`global_options`

Data type: `Optional[Hash]`

A hash of all the haproxy global options. If you want to specify more
 than one option (i.e. multiple timeout or stats options), pass those
 options as an array and you will get a line for each of them in the
 resultant haproxy.cfg file.

Default value: `undef`

##### <a name="-haproxy--instance--defaults_options"></a>`defaults_options`

Data type: `Optional[Hash]`

A hash of all the haproxy defaults options. If you want to specify more
 than one option (i.e. multiple timeout or stats options), pass those
 options as an array and you will get a line for each of them in the
 resultant haproxy.cfg file.

Default value: `undef`

##### <a name="-haproxy--instance--restart_command"></a>`restart_command`

Data type: `Optional[String]`

Command to use when restarting the on config changes.
 Passed directly as the <code>'restart'</code> parameter to the service
 resource.  #    Defaults to undef i.e. whatever the service default is.

Default value: `undef`

##### <a name="-haproxy--instance--custom_fragment"></a>`custom_fragment`

Data type: `Optional[String]`

Allows arbitrary HAProxy configuration to be passed through to support
additional configuration not available via parameters, or to short-circuit
the defined resources such as haproxy::listen when an operater would rather
just write plain configuration. Accepts a string (ie, output from the

Default value: `undef`

##### <a name="-haproxy--instance--config_file"></a>`config_file`

Data type: `Optional[Stdlib::Absolutepath]`

Allows arbitrary config filename to be specified. If this is used,
it is assumed that the directory path to the file exists and has
owner/group/permissions as desired.  If set to undef, the name
will be generated as follows:
  If $title is 'haproxy', the operating system default will be used.
  Otherwise, /etc/haproxy-$title/haproxy-$title.conf (Linux),
  or /usr/local/etc/haproxy-$title/haproxy-$title.conf (FreeBSD)
  The parent directory will be created automatically.
Defaults to undef.

Default value: `undef`

##### <a name="-haproxy--instance--config_validate_cmd"></a>`config_validate_cmd`

Data type: `Variant[Stdlib::Absolutepath, String]`

Command used by concat validate_cmd to validate new
config file concat is a valid haproxy config.
Default /usr/sbin/haproxy -f % -c

Default value: `$haproxy::params::config_validate_cmd`

##### <a name="-haproxy--instance--config_dir"></a>`config_dir`

Data type: `Optional[Stdlib::Absolutepath]`

Optional. Default undef.

Default value: `undef`

##### <a name="-haproxy--instance--merge_options"></a>`merge_options`

Data type: `Boolean`



Default value: `$haproxy::params::merge_options`

##### <a name="-haproxy--instance--service_options"></a>`service_options`

Data type: `String`



Default value: `$haproxy::params::service_options`

##### <a name="-haproxy--instance--sysconfig_options"></a>`sysconfig_options`

Data type: `String`



Default value: `$haproxy::params::sysconfig_options`

### <a name="haproxy--instance_service"></a>`haproxy::instance_service`

Set up the environment for an haproxy service.

* **Note** * Associate an haproxy instance with the haproxy package it should use.
* Create the start/restart/stop functions needed by Service[].
In other words: sets things up so that Service[$instance_name] will work.

In particular:
* Create a link to the binary an instance will be using. This
  way each instance can link to a different binary.
  If you have an instance called "foo", you know "haproxy-foo"
  is a link to the binary it should be using.
* Create an init.d file named after the instance. This way
  Service[$instance] can start/restart the service.

#### Parameters

The following parameters are available in the `haproxy::instance_service` defined type:

* [`haproxy_package`](#-haproxy--instance_service--haproxy_package)
* [`bindir`](#-haproxy--instance_service--bindir)
* [`haproxy_init_source`](#-haproxy--instance_service--haproxy_init_source)
* [`haproxy_unit_template`](#-haproxy--instance_service--haproxy_unit_template)

##### <a name="-haproxy--instance_service--haproxy_package"></a>`haproxy_package`

Data type: `String`

The name of the package to be installed. This is useful if
you package your own custom version of haproxy.
Defaults to 'haproxy'

Default value: `'haproxy'`

##### <a name="-haproxy--instance_service--bindir"></a>`bindir`

Data type: `Stdlib::Absolutepath`

Where to put symlinks to the binary used for each instance.
Defaults to '/opt/haproxy'

Default value: `'/opt/haproxy/bin'`

##### <a name="-haproxy--instance_service--haproxy_init_source"></a>`haproxy_init_source`

Data type: `Optional[String]`

The init.d script that will start/restart/reload this instance.

Default value: `undef`

##### <a name="-haproxy--instance_service--haproxy_unit_template"></a>`haproxy_unit_template`

Data type: `String`

The template that will be used to create an unit file.

Default value: `'haproxy/instance_service_unit.epp'`

### <a name="haproxy--listen"></a>`haproxy::listen`

=== Authors

Gary Larizza <gary@puppetlabs.com>

* **Note** Each listening service
configuration needs one or more load balancer member server (that can be
declared with the haproxy::balancermember defined resource type). Using
storeconfigs, you can export the haproxy::balancermember resources on all
load balancer member servers, and then collect them on a single haproxy
load balancer server.

#### Examples

##### 

```puppet
haproxy::listen { 'puppet00':
  ipaddress => $::ipaddress,
  ports     => [18140],
  mode      => 'tcp',
  options   => {
    'option'  => [
      'tcplog',
      'ssl-hello-chk'
    ],
    'balance' => 'roundrobin'
  },
}
```

#### Parameters

The following parameters are available in the `haproxy::listen` defined type:

* [`section_name`](#-haproxy--listen--section_name)
* [`ports`](#-haproxy--listen--ports)
* [`ipaddress`](#-haproxy--listen--ipaddress)
* [`bind`](#-haproxy--listen--bind)
* [`mode`](#-haproxy--listen--mode)
* [`description`](#-haproxy--listen--description)
* [`options`](#-haproxy--listen--options)
* [`bind_options`](#-haproxy--listen--bind_options)
* [`collect_exported`](#-haproxy--listen--collect_exported)
* [`sort_options_alphabetic`](#-haproxy--listen--sort_options_alphabetic)
* [`defaults`](#-haproxy--listen--defaults)
* [`config_file`](#-haproxy--listen--config_file)
* [`instance`](#-haproxy--listen--instance)

##### <a name="-haproxy--listen--section_name"></a>`section_name`

Data type: `String[1]`

This name goes right after the 'listen' statement in haproxy.cfg
Default: $name (the namevar of the resource).

Default value: `$name`

##### <a name="-haproxy--listen--ports"></a>`ports`

Data type: `Optional[Haproxy::Ports]`

Ports on which the proxy will listen for connections on the ip address
 specified in the ipaddress parameter. Accepts either a single
 comma-separated string or an array of strings which may be ports or
 hyphenated port ranges.

Default value: `undef`

##### <a name="-haproxy--listen--ipaddress"></a>`ipaddress`

Data type: `Optional[Variant[String, Array]]`

The ip address the proxy binds to.
 Empty addresses, '*', and '0.0.0.0' mean that the proxy listens
 to all valid addresses on the system.

Default value: `undef`

##### <a name="-haproxy--listen--bind"></a>`bind`

Data type: `Optional[Hash]`

Set of ip addresses, port and bind options
$bind = { '10.0.0.1:80' => ['ssl', 'crt', '/path/to/my/crt.pem'] }

Default value: `undef`

##### <a name="-haproxy--listen--mode"></a>`mode`

Data type: `Optional[Enum['tcp', 'http', 'health']]`

The mode of operation for the listening service. Valid values are undef,
 'tcp', 'http', and 'health'.

Default value: `undef`

##### <a name="-haproxy--listen--description"></a>`description`

Data type: `Optional[String]`

Allows to add a sentence to describe the related object in the HAProxy HTML
stats page. The description will be printed on the right of the object name
it describes. Usefull in huge environments

Default value: `undef`

##### <a name="-haproxy--listen--options"></a>`options`

Data type: `Variant[Hash, Array[Hash]]`

A hash of options that are inserted into the listening service
 configuration block.

Default value:

```puppet
{
    'option'                                    => [
      'tcplog',
    ],
    'balance'                                   => 'roundrobin',
  }
```

##### <a name="-haproxy--listen--bind_options"></a>`bind_options`

Data type: `Optional[Array]`

(Deprecated) An array of options to be specified after the bind declaration
 in the listening serivce's configuration block.

Default value: `undef`

##### <a name="-haproxy--listen--collect_exported"></a>`collect_exported`

Data type: `Boolean`

Boolean, default 'true'. True means 'collect exported @@balancermember resources'
 (for the case when every balancermember node exports itself), false means
 'rely on the existing declared balancermember resources' (for the case when you
 know the full set of balancermembers in advance and use haproxy::balancermember
 with array arguments, which allows you to deploy everything in 1 run)

Default value: `true`

##### <a name="-haproxy--listen--sort_options_alphabetic"></a>`sort_options_alphabetic`

Data type: `Boolean`

Sort options either alphabetic or custom like haproxy internal sorts them.
Defaults to true.

Default value: `true`

##### <a name="-haproxy--listen--defaults"></a>`defaults`

Data type: `Optional[String]`

Name of the defaults section this backend will use.
Defaults to undef which means the global defaults section will be used.

Default value: `undef`

##### <a name="-haproxy--listen--config_file"></a>`config_file`

Data type: `Optional[Stdlib::Absolutepath]`

Optional. Path of the config file where this entry will be added.
Assumes that the parent directory exists.
Default: $haproxy::params::config_file

Default value: `undef`

##### <a name="-haproxy--listen--instance"></a>`instance`

Data type: `String`

Optional. Defaults to 'haproxy'

Default value: `'haproxy'`

### <a name="haproxy--mailer"></a>`haproxy::mailer`

This type will set up a mailer entry inside the mailers configuration block in
haproxy.cfg on the load balancer.

* **Note** Currently, it has the ability to
specify the instance name, ip address, ports and server_names.
Automatic discovery of mailer nodes may be implemented by exporting the mailer
resource for all HAProxy balancer servers that are configured in the same HA
block and then collecting them on all load balancers.

#### Parameters

The following parameters are available in the `haproxy::mailer` defined type:

* [`mailers_name`](#-haproxy--mailer--mailers_name)
* [`server_names`](#-haproxy--mailer--server_names)
* [`ipaddresses`](#-haproxy--mailer--ipaddresses)
* [`port`](#-haproxy--mailer--port)
* [`instance`](#-haproxy--mailer--instance)

##### <a name="-haproxy--mailer--mailers_name"></a>`mailers_name`

Data type: `String`

Specifies the mailer in which this load balancer needs to be added.

##### <a name="-haproxy--mailer--server_names"></a>`server_names`

Data type: `Variant[String[1], Array]`

Sets the name of the mailer server in the mailers configuration block.
 Defaults to the hostname. Can be an array. If this parameter is
 specified as an array, it must be the same length as the
 ipaddresses parameter's array. A mailer is created for each pair
 of server\_names and ipaddresses in the array.

Default value: `$facts['networking']['hostname']`

##### <a name="-haproxy--mailer--ipaddresses"></a>`ipaddresses`

Data type: `Variant[String, Array]`

Specifies the IP address used to contact the mailer member server.
 Can be an array. If this parameter is specified as an array it
 must be the same length as the server\_names parameter's array.
 A mailer is created for each pair of address and server_name.

Default value: `$facts['networking']['ip']`

##### <a name="-haproxy--mailer--port"></a>`port`

Data type: `Variant[String, Stdlib::Port]`

Sets the port on which the mailer is going to share the state.

##### <a name="-haproxy--mailer--instance"></a>`instance`

Data type: `String`

The instance name of the mailer entry. Default value: 'haproxy'.

Default value: `'haproxy'`

### <a name="haproxy--mailers"></a>`haproxy::mailers`

This type will set up a mailers entry in haproxy.cfg on the load balancer.

* **Note** This setting makes it possible to send emails during state changes.

#### Parameters

The following parameters are available in the `haproxy::mailers` defined type:

* [`instance`](#-haproxy--mailers--instance)
* [`collect_exported`](#-haproxy--mailers--collect_exported)

##### <a name="-haproxy--mailers--instance"></a>`instance`

Data type: `String`

Optional. Defaults to 'haproxy'.

Default value: `'haproxy'`

##### <a name="-haproxy--mailers--collect_exported"></a>`collect_exported`

Data type: `Boolean`

Boolean. Defaults to true.

Default value: `true`

### <a name="haproxy--mapfile"></a>`haproxy::mapfile`

Manage an HAProxy map file as documented in
https://cbonte.github.io/haproxy-dconv/configuration-1.5.html#7.3.1-map

* **Note** A map file contains one key + value per line. These key-value pairs are
specified in the `mappings` array or by additional `haproxy::mapfile::entry`
definitions.

#### Parameters

The following parameters are available in the `haproxy::mapfile` defined type:

* [`name`](#-haproxy--mapfile--name)
* [`mappings`](#-haproxy--mapfile--mappings)
* [`ensure`](#-haproxy--mapfile--ensure)
* [`owner`](#-haproxy--mapfile--owner)
* [`group`](#-haproxy--mapfile--group)
* [`mode`](#-haproxy--mapfile--mode)
* [`instances`](#-haproxy--mapfile--instances)

##### <a name="-haproxy--mapfile--name"></a>`name`

The namevar of the defined resource type is the filename of the map file
(without any extension), relative to the `haproxy::config_dir` directory.
A '.map' extension will be added automatically.

##### <a name="-haproxy--mapfile--mappings"></a>`mappings`

Data type: `Array[Variant[String, Hash]]`

An array of mappings for this map file. Array elements may be Hashes with a
single key-value pair each (preferably) or simple Strings. Default: `[]`

Default value: `[]`

##### <a name="-haproxy--mapfile--ensure"></a>`ensure`

Data type: `Enum['present', 'absent']`

The state of the underlying file resource, either 'present' or 'absent'.
Default: 'present'

Default value: `'present'`

##### <a name="-haproxy--mapfile--owner"></a>`owner`

Data type: `String`

The owner of the underlying file resource. Defaut: 'root'

Default value: `'root'`

##### <a name="-haproxy--mapfile--group"></a>`group`

Data type: `String`

The group of the underlying file resource. Defaut: 'root'

Default value: `'root'`

##### <a name="-haproxy--mapfile--mode"></a>`mode`

Data type: `String`

The mode of the underlying file resource. Defaut: '0644'

Default value: `'0644'`

##### <a name="-haproxy--mapfile--instances"></a>`instances`

Data type: `Array`

Array of managed HAproxy instance names to notify (restart/reload) when the
map file is updated. This is so that the same map file can be used with
multiple HAproxy instances. Default: `[ 'haproxy' ]`

Default value: `['haproxy']`

### <a name="haproxy--mapfile--entry"></a>`haproxy::mapfile::entry`

Manage an HAProxy map file as documented in
https://cbonte.github.io/haproxy-dconv/configuration-1.5.html#7.3.1-map

* **Note** A map file contains one key + value per line. These key-value pairs are
specified in the `mappings` array.

#### Parameters

The following parameters are available in the `haproxy::mapfile::entry` defined type:

* [`name`](#-haproxy--mapfile--entry--name)
* [`mappings`](#-haproxy--mapfile--entry--mappings)
* [`mapfile`](#-haproxy--mapfile--entry--mapfile)
* [`order`](#-haproxy--mapfile--entry--order)

##### <a name="-haproxy--mapfile--entry--name"></a>`name`

The namevar of the defined resource type is the filename of the map file
(without any extension), relative to the `haproxy::config_dir` directory.
A '.map' extension will be added automatically.

##### <a name="-haproxy--mapfile--entry--mappings"></a>`mappings`

Data type: `Array[Variant[String, Hash]]`

An array of mappings for this map file. Array elements may be Hashes with a
single key-value pair each (preferably) or simple Strings. Default: `[]`

Default value: `[$title]`

##### <a name="-haproxy--mapfile--entry--mapfile"></a>`mapfile`

Data type: `String`

A string that specifies the name of the mapfile. Default value: ''.

##### <a name="-haproxy--mapfile--entry--order"></a>`order`

Data type: `Variant[String, Integer]`

Defines the order for the mapfile. Accepts Integer or Strings. Default value: '10'.

Default value: `'10'`

### <a name="haproxy--peer"></a>`haproxy::peer`

This type will set up a peer entry inside the peers configuration block in haproxy.cfg on the load balancer.

* **Note** Currently, it has the ability to
specify the instance name, ip address, ports and server_names.

#### Parameters

The following parameters are available in the `haproxy::peer` defined type:

* [`peers_name`](#-haproxy--peer--peers_name)
* [`server_names`](#-haproxy--peer--server_names)
* [`ipaddresses`](#-haproxy--peer--ipaddresses)
* [`port`](#-haproxy--peer--port)
* [`config_file`](#-haproxy--peer--config_file)
* [`instance`](#-haproxy--peer--instance)

##### <a name="-haproxy--peer--peers_name"></a>`peers_name`

Data type: `String`

Specifies the peer in which this load balancer needs to be added.

##### <a name="-haproxy--peer--server_names"></a>`server_names`

Data type: `Variant[String[1], Array]`

Sets the name of the peer server in the peers configuration block.
Defaults to the hostname. Can be an array. If this parameter is
specified as an array, it must be the same length as the
ipaddresses parameter's array. A peer is created for each pair
of server\_names and ipaddresses in the array.

Default value: `$facts['networking']['hostname']`

##### <a name="-haproxy--peer--ipaddresses"></a>`ipaddresses`

Data type: `Variant[String, Array]`

Specifies the IP address used to contact the peer member server.
Can be an array. If this parameter is specified as an array it
must be the same length as the server\_names parameter's array.
A peer is created for each pair of address and server_name.

Default value: `$facts['networking']['ip']`

##### <a name="-haproxy--peer--port"></a>`port`

Data type: `Variant[String, Stdlib::Port]`

Sets the port on which the peer is going to share the state.

##### <a name="-haproxy--peer--config_file"></a>`config_file`

Data type: `Optional[Stdlib::Absolutepath]`

Optional. Path of the config file where this entry will be added.
Assumes that the parent directory exists.
Default: $haproxy::params::config_file

Default value: `undef`

##### <a name="-haproxy--peer--instance"></a>`instance`

Data type: `String`

The instance name of the mailer entry. Default value: 'haproxy'.

Default value: `'haproxy'`

### <a name="haproxy--peer--collect_exported"></a>`haproxy::peer::collect_exported`

Private define

### <a name="haproxy--peers"></a>`haproxy::peers`

on the load balancer. This setting is required to share the
current state of HAproxy with other HAproxy in High available
configurations.

#### Parameters

The following parameters are available in the `haproxy::peers` defined type:

* [`name`](#-haproxy--peers--name)
* [`config_file`](#-haproxy--peers--config_file)
* [`instance`](#-haproxy--peers--instance)
* [`collect_exported`](#-haproxy--peers--collect_exported)

##### <a name="-haproxy--peers--name"></a>`name`

Sets the peers' name. Generally it will be the namevar of the
 defined resource type. This value appears right after the
 'peers' statement in haproxy.cfg

##### <a name="-haproxy--peers--config_file"></a>`config_file`

Data type: `Optional[Stdlib::Absolutepath]`

Optional. Path of the config file where this entry will be added.
Assumes that the parent directory exists.
Default: $haproxy::params::config_file

Default value: `undef`

##### <a name="-haproxy--peers--instance"></a>`instance`

Data type: `String`

Optional. Defaults to 'haproxy'

Default value: `'haproxy'`

##### <a name="-haproxy--peers--collect_exported"></a>`collect_exported`

Data type: `Boolean`

Boolean. Defaults to true

Default value: `true`

### <a name="haproxy--resolver"></a>`haproxy::resolver`

=== Authors

Gary Larizza <gary@puppetlabs.com>
Ricardo Rosales <missingcharacter@gmail.com>

* **Note** Currently requires the puppetlabs/concat module on the Puppet Forge and
uses storeconfigs on the Puppet Server to export/collect resources
from all balancer members.

#### Examples

##### 

```puppet
Exporting the resource for a balancer member:

haproxy::resolver { 'puppet00':
  nameservers           => {
    'dns1' => '10.0.0.1:53',
    'dns2' => '10.0.0.2:53'
  },
  hold                  => {
    'nx'    => '30s',
    'valid' => '10s'
  },
  resolve_retries       => 3,
  timeout               => {
    'retry' => '1s'
  },
  accepted_payload_size => 512,
}
```

#### Parameters

The following parameters are available in the `haproxy::resolver` defined type:

* [`section_name`](#-haproxy--resolver--section_name)
* [`nameservers`](#-haproxy--resolver--nameservers)
* [`parse_resolv_conf`](#-haproxy--resolver--parse_resolv_conf)
* [`hold`](#-haproxy--resolver--hold)
* [`resolve_retries`](#-haproxy--resolver--resolve_retries)
* [`timeout`](#-haproxy--resolver--timeout)
* [`accepted_payload_size`](#-haproxy--resolver--accepted_payload_size)
* [`collect_exported`](#-haproxy--resolver--collect_exported)
* [`config_file`](#-haproxy--resolver--config_file)
* [`sort_options_alphabetic`](#-haproxy--resolver--sort_options_alphabetic)
* [`defaults`](#-haproxy--resolver--defaults)
* [`instance`](#-haproxy--resolver--instance)

##### <a name="-haproxy--resolver--section_name"></a>`section_name`

Data type: `String[1]`

This name goes right after the 'resolvers' statement in haproxy.cfg
Default: $name (the namevar of the resource).

Default value: `$name`

##### <a name="-haproxy--resolver--nameservers"></a>`nameservers`

Data type: `Hash`

Set of id, ip addresses and port options.
$nameservers = { 'dns1' => '10.0.0.1:53', 'dns2' => '10.0.0.2:53' }
Either the 'nameservers' or the 'parse_resolv_conf' parameter must be
specified in order for the resolver to work.
Default: none specified.

Default value: `{}`

##### <a name="-haproxy--resolver--parse_resolv_conf"></a>`parse_resolv_conf`

Data type: `Boolean`

If true, parse resolv.conf to retrieve an ordered set of nameservers.
This can be used instead of (or in addition to) the 'nameservers'
parameter.
Default: false

Default value: `false`

##### <a name="-haproxy--resolver--hold"></a>`hold`

Data type: `Optional[Hash]`

Defines <period> during which the last name resolution should be kept
  based on last valid resolution status.
$hold = { 'nx' => '30s', 'valid' => '10s' }

Default value: `undef`

##### <a name="-haproxy--resolver--resolve_retries"></a>`resolve_retries`

Data type: `Optional[Integer]`

Defines the number <nb> of queries to send to resolve a server name before
 giving up.
$resolve_retries = 3

Default value: `undef`

##### <a name="-haproxy--resolver--timeout"></a>`timeout`

Data type: `Optional[Hash]`

Defines timeouts related to name resolution in the listening serivce's
 configuration block.
$timeout = { 'retry' => '1s' }

Default value: `undef`

##### <a name="-haproxy--resolver--accepted_payload_size"></a>`accepted_payload_size`

Data type: `Optional[Integer[512, 8192]]`

Defines the maximum payload size accepted by HAProxy and announced to all the
name servers configured in this resolvers section.
<nb> is in bytes. If not set, HAProxy announces 512. (minimal value defined
by RFC 6891)
Note: the maximum allowed value is 8192.

Default value: `undef`

##### <a name="-haproxy--resolver--collect_exported"></a>`collect_exported`

Data type: `Boolean`

Boolean, default 'true'. True means 'collect exported @@balancermember
 resources' (for the case when every balancermember node exports itself),
 false means 'rely on the existing declared balancermember resources' (for
 the case when you know the full set of balancermember in advance and use
 haproxy::balancermember with array arguments, which allows you to deploy
 everything in 1 run)

Default value: `true`

##### <a name="-haproxy--resolver--config_file"></a>`config_file`

Data type: `Optional[Stdlib::Absolutepath]`

Optional. Path of the config file where this entry will be added.
Assumes that the parent directory exists.
Default: $haproxy::params::config_file

Default value: `undef`

##### <a name="-haproxy--resolver--sort_options_alphabetic"></a>`sort_options_alphabetic`

Data type: `Boolean`

Sort options either alphabetic or custom like haproxy internal sorts them.
Defaults to true.

Default value: `true`

##### <a name="-haproxy--resolver--defaults"></a>`defaults`

Data type: `Optional[String]`

Name of the defaults section this backend will use.
Defaults to undef which means the global defaults section will be used.

Default value: `undef`

##### <a name="-haproxy--resolver--instance"></a>`instance`

Data type: `String`

Optional. Defaults to 'haproxy'

Default value: `'haproxy'`

### <a name="haproxy--userlist"></a>`haproxy::userlist`

=== Authors

Jeremy Kitchen <jeremy@nationbuilder.com>

* **Note** See http://cbonte.github.io/haproxy-dconv/configuration-1.4.html#3.4 for more info

#### Parameters

The following parameters are available in the `haproxy::userlist` defined type:

* [`section_name`](#-haproxy--userlist--section_name)
* [`users`](#-haproxy--userlist--users)
* [`groups`](#-haproxy--userlist--groups)
* [`config_file`](#-haproxy--userlist--config_file)
* [`instance`](#-haproxy--userlist--instance)

##### <a name="-haproxy--userlist--section_name"></a>`section_name`

Data type: `String[1]`

This name goes right after the 'userlist' statement in haproxy.cfg
Default: $name (the namevar of the resource).

Default value: `$name`

##### <a name="-haproxy--userlist--users"></a>`users`

Data type: `Optional[Array[Variant[String, Sensitive[String]]]]`

An array of users in the userlist.
See http://cbonte.github.io/haproxy-dconv/configuration-1.4.html#3.4-user

Default value: `undef`

##### <a name="-haproxy--userlist--groups"></a>`groups`

Data type: `Optional[Array[String]]`

An array of groups in the userlist.
See http://cbonte.github.io/haproxy-dconv/configuration-1.4.html#3.4-group

Default value: `undef`

##### <a name="-haproxy--userlist--config_file"></a>`config_file`

Data type: `Optional[Stdlib::Absolutepath]`

Optional. Path of the config file where this entry will be added.
Assumes that the parent directory exists.
Default: $haproxy::params::config_file

Default value: `undef`

##### <a name="-haproxy--userlist--instance"></a>`instance`

Data type: `String`

Optional. Defaults to 'haproxy'

Default value: `'haproxy'`

## Functions

### <a name="haproxy--generate_error_message"></a>`haproxy::generate_error_message`

Type: Ruby 4.x API

Function created to generate error message. Any string as error message can be passed and the function can
be called in epp templates.

#### `haproxy::generate_error_message(String $error_message)`

Function created to generate error message. Any string as error message can be passed and the function can
be called in epp templates.

Returns: `Any`

##### `error_message`

Data type: `String`



### <a name="haproxy--sort_bind"></a>`haproxy::sort_bind`

Type: Ruby 4.x API

The haproxy::sort_bind function.

#### `haproxy::sort_bind(Hash $bind)`

The haproxy::sort_bind function.

Returns: `Array`

##### `bind`

Data type: `Hash`



### <a name="haproxy--validate_ip_addr"></a>`haproxy::validate_ip_addr`

Type: Ruby 4.x API

The haproxy::validate_ip_addr function.

#### `haproxy::validate_ip_addr(String $virtual_ip)`

The haproxy::validate_ip_addr function.

Returns: `Boolean`

##### `virtual_ip`

Data type: `String`



## Data types

### <a name="Haproxy--Ports"></a>`Haproxy::Ports`

Port or list of ports for haproxy. Supports `,` seperated list of ports also.

Alias of `Variant[Array[Variant[Pattern[/^[0-9]+$/],Stdlib::Port],0], Pattern[/^[0-9,]+$/], Stdlib::Port]`

