# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.applicationinsights import ApplicationInsightsManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-applicationinsights
# USAGE
    python workbook_template_add.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = ApplicationInsightsManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="subid",
    )

    response = client.workbook_templates.create_or_update(
        resource_group_name="my-resource-group",
        resource_name="testtemplate2",
        workbook_template_properties={
            "location": "west us",
            "properties": {
                "author": "Contoso",
                "galleries": [
                    {
                        "category": "Failures",
                        "name": "Simple Template",
                        "order": 100,
                        "resourceType": "microsoft.insights/components",
                        "type": "tsg",
                    }
                ],
                "priority": 1,
                "templateData": {
                    "$schema": "https://github.com/Microsoft/Application-Insights-Workbooks/blob/master/schema/workbook.json",
                    "items": [
                        {
                            "content": {
                                "json": "## New workbook\n---\n\nWelcome to your new workbook.  This area will display text formatted as markdown.\n\n\nWe've included a basic analytics query to get you started. Use the `Edit` button below each section to configure it or add more sections."
                            },
                            "name": "text - 2",
                            "type": 1,
                        },
                        {
                            "content": {
                                "exportToExcelOptions": "visible",
                                "query": "union withsource=TableName *\n| summarize Count=count() by TableName\n| render barchart",
                                "queryType": 0,
                                "resourceType": "microsoft.operationalinsights/workspaces",
                                "size": 1,
                                "version": "KqlItem/1.0",
                            },
                            "name": "query - 2",
                            "type": 3,
                        },
                    ],
                    "styleSettings": {},
                    "version": "Notebook/1.0",
                },
            },
            "tags": None,
        },
    )
    print(response)


# x-ms-original-file: specification/applicationinsights/resource-manager/Microsoft.Insights/stable/2020-11-20/examples/WorkbookTemplateAdd.json
if __name__ == "__main__":
    main()
