# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.datafactory.aio import DataFactoryManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDataFactoryManagementChangeDataCaptureOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DataFactoryManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_change_data_capture_list_by_factory(self, resource_group):
        response = self.client.change_data_capture.list_by_factory(
            resource_group_name=resource_group.name,
            factory_name="str",
            api_version="2018-06-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_change_data_capture_create_or_update(self, resource_group):
        response = await self.client.change_data_capture.create_or_update(
            resource_group_name=resource_group.name,
            factory_name="str",
            change_data_capture_name="str",
            change_data_capture={
                "policy": {"mode": "str", "recurrence": {"frequency": "str", "interval": 0}},
                "sourceConnectionsInfo": [
                    {
                        "connection": {
                            "type": "str",
                            "commonDslConnectorProperties": [{"name": "str", "value": {}}],
                            "isInlineDataset": bool,
                            "linkedService": {"referenceName": "str", "type": "str", "parameters": {"str": {}}},
                            "linkedServiceType": "str",
                        },
                        "sourceEntities": [
                            {
                                "dslConnectorProperties": [{"name": "str", "value": {}}],
                                "name": "str",
                                "schema": [{"dataType": "str", "name": "str"}],
                            }
                        ],
                    }
                ],
                "targetConnectionsInfo": [
                    {
                        "connection": {
                            "type": "str",
                            "commonDslConnectorProperties": [{"name": "str", "value": {}}],
                            "isInlineDataset": bool,
                            "linkedService": {"referenceName": "str", "type": "str", "parameters": {"str": {}}},
                            "linkedServiceType": "str",
                        },
                        "dataMapperMappings": [
                            {
                                "attributeMappingInfo": {
                                    "attributeMappings": [
                                        {
                                            "attributeReference": {
                                                "entity": "str",
                                                "entityConnectionReference": {"connectionName": "str", "type": "str"},
                                                "name": "str",
                                            },
                                            "attributeReferences": [
                                                {
                                                    "entity": "str",
                                                    "entityConnectionReference": {
                                                        "connectionName": "str",
                                                        "type": "str",
                                                    },
                                                    "name": "str",
                                                }
                                            ],
                                            "expression": "str",
                                            "functionName": "str",
                                            "name": "str",
                                            "type": "str",
                                        }
                                    ]
                                },
                                "sourceConnectionReference": {"connectionName": "str", "type": "str"},
                                "sourceDenormalizeInfo": {},
                                "sourceEntityName": "str",
                                "targetEntityName": "str",
                            }
                        ],
                        "relationships": [{}],
                        "targetEntities": [
                            {
                                "dslConnectorProperties": [{"name": "str", "value": {}}],
                                "name": "str",
                                "schema": [{"dataType": "str", "name": "str"}],
                            }
                        ],
                    }
                ],
                "allowVNetOverride": bool,
                "description": "str",
                "etag": "str",
                "folder": {"name": "str"},
                "id": "str",
                "name": "str",
                "status": "str",
                "type": "str",
            },
            api_version="2018-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_change_data_capture_get(self, resource_group):
        response = await self.client.change_data_capture.get(
            resource_group_name=resource_group.name,
            factory_name="str",
            change_data_capture_name="str",
            api_version="2018-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_change_data_capture_delete(self, resource_group):
        response = await self.client.change_data_capture.delete(
            resource_group_name=resource_group.name,
            factory_name="str",
            change_data_capture_name="str",
            api_version="2018-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_change_data_capture_start(self, resource_group):
        response = await self.client.change_data_capture.start(
            resource_group_name=resource_group.name,
            factory_name="str",
            change_data_capture_name="str",
            api_version="2018-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_change_data_capture_stop(self, resource_group):
        response = await self.client.change_data_capture.stop(
            resource_group_name=resource_group.name,
            factory_name="str",
            change_data_capture_name="str",
            api_version="2018-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_change_data_capture_status(self, resource_group):
        response = await self.client.change_data_capture.status(
            resource_group_name=resource_group.name,
            factory_name="str",
            change_data_capture_name="str",
            api_version="2018-06-01",
        )

        # please add some check logic here by yourself
        # ...
