// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from NameService.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.jsonrpc {
  public class NameService : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("jsonrpc.NameService:1.0.0", null);

    public NameService(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public NameService(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new NameService StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new NameService(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public class LookupResult {
      public ObjectProxy _ret_;
    }

    public LookupResult lookup(string name) {
      var _parameters = new LightJson.JsonObject();
      _parameters["name"] = name;

      var _result = RpcCall("lookup", _parameters);
      var _ret = new LookupResult();
      _ret._ret_ = ObjectProxy.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest lookup(string name, AsyncRpcResponse<LookupResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return lookup(name, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest lookup(string name, AsyncRpcResponse<LookupResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["name"] = name;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("lookup", _parameters,
        _result => {
          try {
            var _ret = new LookupResult();
            _ret._ret_ = ObjectProxy.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
