# 2021-09-07 Triage Log

A busy week, with lots of mixed changes, though in the end only a few were deemed significant enough to report here.

Triage done by **@pnkfelix**.
Revision range: [fe37929e4cba2c5c21e6805805769630c736bc3d..69c4aa2901ffadf69deaf91b2f90604bcbc2eb36](https://perf.rust-lang.org/?start=fe37929e4cba2c5c21e6805805769630c736bc3d&end=69c4aa2901ffadf69deaf91b2f90604bcbc2eb36&absolute=false&stat=instructions%3Au)

3 Regressions, 1 Improvements, 3 Mixed; 0 of them in rollups
57 comparisons made in total

#### Regressions

Shrink Session a bit [#88530](https://github.com/rust-lang/rust/issues/88530)
- Large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=64929313f53181636e4dd37e25836973205477e4&end=fcce644119cf4e8e36001368e514bb5ed67cb855&stat=instructions:u) (up to 2.6% on `full` builds of `deeply-nested-async`)

Concrete regions can show up in mir borrowck if the originated from there [#88533](https://github.com/rust-lang/rust/issues/88533)
- Very small regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=29ef6cf1637aa8317f8911f93f14e18d404c1b0e&end=a3956106d12cebec91be0637759e29ab6908b4cd&stat=instructions:u) (up to 1.0% on `incr-patched: add static arr item` builds of `coercions`)
- This is a small regression to `coercions` and that may be noise. However, there are many others that are over 0.4% regression to instruction counts. The combination of those two factors led pnkfelix to think that we may want to take a second look at the effects of this PR.

Introduce `let...else` [#87688](https://github.com/rust-lang/rust/issues/87688)
- Small improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=a3956106d12cebec91be0637759e29ab6908b4cd&end=c2a408840ad18f74280805535f0b7193528ff3df&stat=instructions:u) (up to -0.3% on `incr-unchanged` builds of `deeply-nested-closures`)
- Small regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=a3956106d12cebec91be0637759e29ab6908b4cd&end=c2a408840ad18f74280805535f0b7193528ff3df&stat=instructions:u) (up to 0.4% on `full` builds of `issue-46449`)
- Small regression (approximately 1%) in instruction counts on several of the *-doc tests, found via human eye.

#### Improvements

Move global analyses from lowering to resolution [#88597](https://github.com/rust-lang/rust/issues/88597)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=c5799b2a73bd03d1d7b4a432fa0a0cb93e7288db&end=577a76f0031f727735410b99a5cc5f0b61b92eef&stat=instructions:u) (up to -1.6% on `incr-unchanged` builds of `keccak`)


#### Mixed

Preserve most sub-obligations in the projection cache [#85868](https://github.com/rust-lang/rust/issues/85868)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=b834c4c1bad7521af47f38f44a4048be0a1fe2ee&end=371f3cd3fe523d0b398ed1db1620667c53ba7d02&stat=instructions:u) (up to -6.9% on `incr-unchanged` builds of `deeply-nested`)
- Very large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=b834c4c1bad7521af47f38f44a4048be0a1fe2ee&end=371f3cd3fe523d0b398ed1db1620667c53ba7d02&stat=instructions:u) (up to 9.4% on `full` builds of `deeply-nested`)


BTreeMap/BTreeSet::from_iter: use bulk building to improve the performance [#88448](https://github.com/rust-lang/rust/issues/88448)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=11bbb5231349a0a144d86d5c0c21061a06d1969d&end=ffaf857045f4f4d8bb563e0a5077f9b065f42916&stat=instructions:u) (up to -3.0% on `full` builds of `inflate`)
- Large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=11bbb5231349a0a144d86d5c0c21061a06d1969d&end=ffaf857045f4f4d8bb563e0a5077f9b065f42916&stat=instructions:u) (up to 4.5% on `incr-patched: println` builds of `clap-rs`)

Avoid invoking the hir_crate query to traverse the HIR [#88435](https://github.com/rust-lang/rust/issues/88435)
- Small improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=e30b68353fe22b00f40d021e7914eeb78473b3c1&end=7849e3e9dda60e8ec826ee245c6b180e73911b37&stat=instructions:u) (up to -1.2% on `incr-patched: add static arr item` builds of `coercions`)
- Small regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=e30b68353fe22b00f40d021e7914eeb78473b3c1&end=7849e3e9dda60e8ec826ee245c6b180e73911b37&stat=instructions:u) (up to 0.5% on `incr-unchanged` builds of `helloworld`)
- pnkfelix included this one as notable largely because the expected perf changes from [the actual PR](https://github.com/rust-lang/rust/pull/88435#issuecomment-907700333) largely showed slight improvements across the board, while after it landed on nightly, it is best categorized as "Mixed"

#### Untriaged Pull Requests

- [#88597 Move global analyses from lowering to resolution](https://github.com/rust-lang/rust/pull/88597)
- [#88552 Stop allocating vtable entries for non-object-safe methods](https://github.com/rust-lang/rust/pull/88552)
- [#88312 Treat types in unnormalized function signatures as well-formed](https://github.com/rust-lang/rust/pull/88312)
- [#87815 encode `generics_of` for fields and ty params](https://github.com/rust-lang/rust/pull/87815)
- [#87781 Remove box syntax from compiler and tools](https://github.com/rust-lang/rust/pull/87781)
- [#87640 Rollup of 9 pull requests](https://github.com/rust-lang/rust/pull/87640)
- [#87587 Various refactorings of the TAIT infrastructure](https://github.com/rust-lang/rust/pull/87587)
- [#87570 Upgrade to LLVM 13](https://github.com/rust-lang/rust/pull/87570)
- [#87244 Better diagnostics with mismatched types due to implicit static lifetime](https://github.com/rust-lang/rust/pull/87244)
- [#86898 Add fast path for Path::cmp that skips over long shared prefixes](https://github.com/rust-lang/rust/pull/86898)
- [#86777 Include terminators in instance size estimate](https://github.com/rust-lang/rust/pull/86777)
- [#86698 Move OnDiskCache to rustc_query_impl.](https://github.com/rust-lang/rust/pull/86698)
- [#86588 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/86588)
- [#86034 Change entry point to 🛡️ against 💥 💥-payloads](https://github.com/rust-lang/rust/pull/86034)
- [#85556 Warn about unreachable code following an expression with an uninhabited type](https://github.com/rust-lang/rust/pull/85556)
- [#84560 Inline Iterator as IntoIterator.](https://github.com/rust-lang/rust/pull/84560)
- [#83302 Get piece unchecked in `write`](https://github.com/rust-lang/rust/pull/83302)
