# Code of Conduct
## Purpose
People can be discouraged from participating in XaoS development because of certain patterns of communication that strike them as unfriendly, unwelcoming, rejecting, or harsh. This discouragement particularly affects members of disprivileged demographics, but it is not limited to them. Therefore, we ask all contributors to make a conscious effort, in XaoS Project discussions, to communicate in ways that avoid that outcome—to avoid practices that will predictably and unnecessarily risk putting some contributors off.

These guidelines suggest specific ways to accomplish that goal.

## Guidelines
1. Please assume other participants are posting in good faith, even if you disagree with what they say. When people present code or text as their own work, please accept it as their work. Please do not criticize people for wrongs that you only speculate they may have done; stick to what they actually say and actually do.
Please think about how to treat other participants with respect, especially when you disagree with them. For instance, call them by the names they use, and honor their preferences about their gender identity.

2. Please do not take a harsh tone towards other participants, and especially don't make personal attacks against them. Go out of your way to show that you are criticizing a statement, not a person.
Please recognize that criticism of your statements is not a personal attack on you. If you feel that someone has attacked you, or offended your personal dignity, please don't “hit back” with another personal attack. That tends to start a vicious circle of escalating verbal aggression. A private response, politely stating your feelings as feelings, and asking for peace, may calm things down. Write it, set it aside for hours or a day, revise it to remove the anger, and only then send it.

3. Please avoid statements about the presumed typical desires, capabilities or actions of some demographic group. They can offend people in that group, and they are always off-topic in XaoS Project discussions.

4. Please be especially kind to other contributors when saying they made a mistake. Programming means making lots of mistakes, and we all do so—this is why regression tests are useful. Conscientious programmers make mistakes, and then fix them. It is helpful to show contributors that being imperfect is normal, so we don't hold it against them, and that we appreciate their imperfect contributions though we hope they follow through by fixing any problems in them.

5. Likewise, be kind when pointing out to other contributors that they should stop using certain nonfree software. For their own sake, they ought to free themselves, but we welcome their contributions to our software packages even if they don't do that. So these reminders should be gentle and not too frequent—don't nag.
By contrast, to suggest that others run a nonfree program opposes the basic principles of XaoS, so it is not allowed in XaoS Project discussions.

6. Please respond to what people actually said, not to exaggerations of their views. Your criticism will not be constructive if it is aimed at a target other than their real views.

7. If in a discussion someone brings up a tangent to the topic at hand, please keep the discussion on track by focusing on the current topic rather than the tangent. This is not to say that the tangent is bad, or not interesting to discuss—only that it shouldn't interfere with discussion of the issue at hand. In most cases, it is also off-topic, so those interested ought to discuss it somewhere else.

8. If you think the tangent is an important and pertinent issue, please bring it up as a separate discussion, with a Subject field to fit, and consider waiting for the end of the current discussion.

9. Rather than trying to have the last word, look for the times when there is no need to reply, perhaps because you already made the relevant point clear enough. If you know something about the game of Go, this analogy might clarify that: when the other player's move is not strong enough to require a direct response, it is advantageous to give it none and instead move elsewhere.

10. Please don't argue unceasingly for your preferred course of action when a decision for some other course has already been made. That tends to block the activity's progress.

11. If others have irritated you, perhaps by disregarding these guidelines, please don't excoriate them, and especially please don't hold a grudge against them. The constructive approach is to encourage and help other people to do better. When they are trying to learn to do better, please give them plenty of chances.
If other participants complain about the way you express your ideas, please make an effort to cater to them. You can find ways to express the same points while making others more comfortable. You are more likely to persuade others if you don't arouse ire about secondary things.

12. Please don't raise unrelated political issues in XaoS Project discussions, because they are off-topic. The only political positions that the XaoS Project endorses are that users should have control of their own computing (for instance, through free software) and  supporting basic human rights in computing. We don't require you as a contributor to agree with these two points, but you do need to accept that our decisions will be based on them.

###### These guidelines are adapted from [GNU Kind Communications Guidelines](https://www.gnu.org/philosophy/kind-communication.en.html)
