/******************************************************************************
* Copyright (C) 2022 Xilinx, Inc. All rights reserved.
* Copyright (C) 2022-2024 Advanced Micro Devices, Inc. All rights reserved.
* SPDX-License-Identifier: MIT
******************************************************************************/


/*****************************************************************************/
/**
* @file xaie_util_events.c
* @{
*
* This file contains function implementations for AIE utilities
*
* <pre>
* MODIFICATION HISTORY:
*
* Ver   Who     Date     Changes
* ----- ------  -------- -----------------------------------------------------
* 1.0   Gregory 03/31/2022  Initial creation
* </pre>
*
******************************************************************************/

/***************************** Include Files *********************************/
#include "xaie_feature_config.h"
#include "xaie_util_events.h"

#ifdef XAIE_FEATURE_UTIL_ENABLE

/**************************** Variable Definitions *******************************/
/* Event string lookup table indexed by event number */
static const char* XAie_EventStrings[] = {
	/* All core module events of aie tile */
	[XAIE_EVENT_NONE_CORE] = "NONE_CORE",
	[XAIE_EVENT_TRUE_CORE] = "TRUE_CORE",
	[XAIE_EVENT_GROUP_0_CORE] =	"GROUP_0_CORE",
	[XAIE_EVENT_TIMER_SYNC_CORE] =	"TIMER_SYNC_CORE",
	[XAIE_EVENT_TIMER_VALUE_REACHED_CORE] =	"TIMER_VALUE_REACHED_CORE",
	[XAIE_EVENT_PERF_CNT_0_CORE] =	"PERF_CNT_0_CORE",
	[XAIE_EVENT_PERF_CNT_1_CORE] =	"PERF_CNT_1_CORE",
	[XAIE_EVENT_PERF_CNT_2_CORE] =	"PERF_CNT_2_CORE",
	[XAIE_EVENT_PERF_CNT_3_CORE] =	"PERF_CNT_3_CORE",
	[XAIE_EVENT_COMBO_EVENT_0_CORE] =	"COMBO_EVENT_0_CORE",
	[XAIE_EVENT_COMBO_EVENT_1_CORE] =	"COMBO_EVENT_1_CORE",
	[XAIE_EVENT_COMBO_EVENT_2_CORE] =	"COMBO_EVENT_2_CORE",
	[XAIE_EVENT_COMBO_EVENT_3_CORE] =	"COMBO_EVENT_3_CORE",
	[XAIE_EVENT_GROUP_PC_EVENT_CORE] =	"GROUP_PC_EVENT_CORE",
	[XAIE_EVENT_PC_0_CORE] =	"PC_0_CORE",
	[XAIE_EVENT_PC_1_CORE] =	"PC_1_CORE",
	[XAIE_EVENT_PC_2_CORE] =	"PC_2_CORE",
	[XAIE_EVENT_PC_3_CORE] =	"PC_3_CORE",
	[XAIE_EVENT_PC_RANGE_0_1_CORE] =	"PC_RANGE_0_1_CORE",
	[XAIE_EVENT_PC_RANGE_2_3_CORE] =	"PC_RANGE_2_3_CORE",
	[XAIE_EVENT_GROUP_CORE_STALL_CORE] =	"GROUP_CORE_STALL_CORE",
	[XAIE_EVENT_MEMORY_STALL_CORE] =	"MEMORY_STALL_CORE",
	[XAIE_EVENT_STREAM_STALL_CORE] =	"STREAM_STALL_CORE",
	[XAIE_EVENT_CASCADE_STALL_CORE] =	"CASCADE_STALL_CORE",
	[XAIE_EVENT_LOCK_STALL_CORE] =	"LOCK_STALL_CORE",
	[XAIE_EVENT_DEBUG_HALTED_CORE] =	"DEBUG_HALTED_CORE",
	[XAIE_EVENT_ACTIVE_CORE] =	"ACTIVE_CORE",
	[XAIE_EVENT_DISABLED_CORE] =	"DISABLED_CORE",
	[XAIE_EVENT_ECC_ERROR_STALL_CORE] =	"ECC_ERROR_STALL_CORE",
	[XAIE_EVENT_ECC_SCRUBBING_STALL_CORE] =	"ECC_SCRUBBING_STALL_CORE",
	[XAIE_EVENT_GROUP_CORE_PROGRAM_FLOW_CORE] =	"GROUP_CORE_PROGRAM_FLOW_CORE",
	[XAIE_EVENT_INSTR_EVENT_0_CORE] =	"INSTR_EVENT_0_CORE",
	[XAIE_EVENT_INSTR_EVENT_1_CORE] =	"INSTR_EVENT_1_CORE",
	[XAIE_EVENT_INSTR_CALL_CORE] =	"INSTR_CALL_CORE",
	[XAIE_EVENT_INSTR_RETURN_CORE] =	"INSTR_RETURN_CORE",
	[XAIE_EVENT_INSTR_VECTOR_CORE] =	"INSTR_VECTOR_CORE",
	[XAIE_EVENT_INSTR_LOAD_CORE] =	"INSTR_LOAD_CORE",
	[XAIE_EVENT_INSTR_STORE_CORE] =	"INSTR_STORE_CORE",
	[XAIE_EVENT_INSTR_STREAM_GET_CORE] =	"INSTR_STREAM_GET_CORE",
	[XAIE_EVENT_INSTR_STREAM_PUT_CORE] =	"INSTR_STREAM_PUT_CORE",
	[XAIE_EVENT_INSTR_CASCADE_GET_CORE] =	"INSTR_CASCADE_GET_CORE",
	[XAIE_EVENT_INSTR_CASCADE_PUT_CORE] =	"INSTR_CASCADE_PUT_CORE",
	[XAIE_EVENT_INSTR_LOCK_ACQUIRE_REQ_CORE] =	"INSTR_LOCK_ACQUIRE_REQ_CORE",
	[XAIE_EVENT_INSTR_LOCK_RELEASE_REQ_CORE] =	"INSTR_LOCK_RELEASE_REQ_CORE",
	[XAIE_EVENT_GROUP_ERRORS_0_CORE] =	"GROUP_ERRORS_0_CORE",
	[XAIE_EVENT_GROUP_ERRORS_1_CORE] =	"GROUP_ERRORS_1_CORE",
	[XAIE_EVENT_SRS_SATURATE_CORE] =	"SRS_SATURATE_CORE",
	[XAIE_EVENT_UPS_SATURATE_CORE] =	"UPS_SATURATE_CORE",
	[XAIE_EVENT_FP_OVERFLOW_CORE] =	"FP_OVERFLOW_CORE",
	[XAIE_EVENT_FP_UNDERFLOW_CORE] =	"FP_UNDERFLOW_CORE",
	[XAIE_EVENT_FP_INVALID_CORE] =	"FP_INVALID_CORE",
	[XAIE_EVENT_FP_DIV_BY_ZERO_CORE] =	"FP_DIV_BY_ZERO_CORE",
	[XAIE_EVENT_TLAST_IN_WSS_WORDS_0_2_CORE] =	"TLAST_IN_WSS_WORDS_0_2_CORE",
	[XAIE_EVENT_PM_REG_ACCESS_FAILURE_CORE] =	"PM_REG_ACCESS_FAILURE_CORE",
	[XAIE_EVENT_STREAM_PKT_PARITY_ERROR_CORE] =	"STREAM_PKT_PARITY_ERROR_CORE",
	[XAIE_EVENT_CONTROL_PKT_ERROR_CORE] =	"CONTROL_PKT_ERROR_CORE",
	[XAIE_EVENT_AXI_MM_SLAVE_ERROR_CORE] =	"AXI_MM_SLAVE_ERROR_CORE",
	[XAIE_EVENT_INSTR_DECOMPRSN_ERROR_CORE] =	"INSTR_DECOMPRSN_ERROR_CORE",
	[XAIE_EVENT_DM_ADDRESS_OUT_OF_RANGE_CORE] =	"DM_ADDRESS_OUT_OF_RANGE_CORE",
	[XAIE_EVENT_PM_ECC_ERROR_SCRUB_CORRECTED_CORE] =	"PM_ECC_ERROR_SCRUB_CORRECTED_CORE",
	[XAIE_EVENT_PM_ECC_ERROR_SCRUB_2BIT_CORE] =	"PM_ECC_ERROR_SCRUB_2BIT_CORE",
	[XAIE_EVENT_PM_ECC_ERROR_1BIT_CORE] =	"PM_ECC_ERROR_1BIT_CORE",
	[XAIE_EVENT_PM_ECC_ERROR_2BIT_CORE] =	"PM_ECC_ERROR_2BIT_CORE",
	[XAIE_EVENT_PM_ADDRESS_OUT_OF_RANGE_CORE] =	"PM_ADDRESS_OUT_OF_RANGE_CORE",
	[XAIE_EVENT_DM_ACCESS_TO_UNAVAILABLE_CORE] =	"DM_ACCESS_TO_UNAVAILABLE_CORE",
	[XAIE_EVENT_LOCK_ACCESS_TO_UNAVAILABLE_CORE] =	"LOCK_ACCESS_TO_UNAVAILABLE_CORE",
	[XAIE_EVENT_INSTR_EVENT_2] =	"INSTR_EVENT_2",
	[XAIE_EVENT_INSTR_EVENT_3] =	"INSTR_EVENT_3",
	[XAIE_EVENT_GROUP_STREAM_SWITCH_CORE] =	"GROUP_STREAM_SWITCH_CORE",
	[XAIE_EVENT_PORT_IDLE_0_CORE] =	"PORT_IDLE_0_CORE",
	[XAIE_EVENT_PORT_RUNNING_0_CORE] =	"PORT_RUNNING_0_CORE",
	[XAIE_EVENT_PORT_STALLED_0_CORE] =	"PORT_STALLED_0_CORE",
	[XAIE_EVENT_PORT_TLAST_0_CORE] =	"PORT_TLAST_0_CORE",
	[XAIE_EVENT_PORT_IDLE_1_CORE] =	"PORT_IDLE_1_CORE",
	[XAIE_EVENT_PORT_RUNNING_1_CORE] =	"PORT_RUNNING_1_CORE",
	[XAIE_EVENT_PORT_STALLED_1_CORE] =	"PORT_STALLED_1_CORE",
	[XAIE_EVENT_PORT_TLAST_1_CORE] =	"PORT_TLAST_1_CORE",
	[XAIE_EVENT_PORT_IDLE_2_CORE] =	"PORT_IDLE_2_CORE",
	[XAIE_EVENT_PORT_RUNNING_2_CORE] =	"PORT_RUNNING_2_CORE",
	[XAIE_EVENT_PORT_STALLED_2_CORE] =	"PORT_STALLED_2_CORE",
	[XAIE_EVENT_PORT_TLAST_2_CORE] =	"PORT_TLAST_2_CORE",
	[XAIE_EVENT_PORT_IDLE_3_CORE] =	"PORT_IDLE_3_CORE",
	[XAIE_EVENT_PORT_RUNNING_3_CORE] =	"PORT_RUNNING_3_CORE",
	[XAIE_EVENT_PORT_STALLED_3_CORE] =	"PORT_STALLED_3_CORE",
	[XAIE_EVENT_PORT_TLAST_3_CORE] =	"PORT_TLAST_3_CORE",
	[XAIE_EVENT_PORT_IDLE_4_CORE] =	"PORT_IDLE_4_CORE",
	[XAIE_EVENT_PORT_RUNNING_4_CORE] =	"PORT_RUNNING_4_CORE",
	[XAIE_EVENT_PORT_STALLED_4_CORE] =	"PORT_STALLED_4_CORE",
	[XAIE_EVENT_PORT_TLAST_4_CORE] =	"PORT_TLAST_4_CORE",
	[XAIE_EVENT_PORT_IDLE_5_CORE] =	"PORT_IDLE_5_CORE",
	[XAIE_EVENT_PORT_RUNNING_5_CORE] =	"PORT_RUNNING_5_CORE",
	[XAIE_EVENT_PORT_STALLED_5_CORE] =	"PORT_STALLED_5_CORE",
	[XAIE_EVENT_PORT_TLAST_5_CORE] =	"PORT_TLAST_5_CORE",
	[XAIE_EVENT_PORT_IDLE_6_CORE] =	"PORT_IDLE_6_CORE",
	[XAIE_EVENT_PORT_RUNNING_6_CORE] =	"PORT_RUNNING_6_CORE",
	[XAIE_EVENT_PORT_STALLED_6_CORE] =	"PORT_STALLED_6_CORE",
	[XAIE_EVENT_PORT_TLAST_6_CORE] =	"PORT_TLAST_6_CORE",
	[XAIE_EVENT_PORT_IDLE_7_CORE] =	"PORT_IDLE_7_CORE",
	[XAIE_EVENT_PORT_RUNNING_7_CORE] =	"PORT_RUNNING_7_CORE",
	[XAIE_EVENT_PORT_STALLED_7_CORE] =	"PORT_STALLED_7_CORE",
	[XAIE_EVENT_PORT_TLAST_7_CORE] =	"PORT_TLAST_7_CORE",
	[XAIE_EVENT_GROUP_BROADCAST_CORE] =	"GROUP_BROADCAST_CORE",
	[XAIE_EVENT_BROADCAST_0_CORE] =	"BROADCAST_0_CORE",
	[XAIE_EVENT_BROADCAST_1_CORE] =	"BROADCAST_1_CORE",
	[XAIE_EVENT_BROADCAST_2_CORE] =	"BROADCAST_2_CORE",
	[XAIE_EVENT_BROADCAST_3_CORE] =	"BROADCAST_3_CORE",
	[XAIE_EVENT_BROADCAST_4_CORE] =	"BROADCAST_4_CORE",
	[XAIE_EVENT_BROADCAST_5_CORE] =	"BROADCAST_5_CORE",
	[XAIE_EVENT_BROADCAST_6_CORE] =	"BROADCAST_6_CORE",
	[XAIE_EVENT_BROADCAST_7_CORE] =	"BROADCAST_7_CORE",
	[XAIE_EVENT_BROADCAST_8_CORE] =	"BROADCAST_8_CORE",
	[XAIE_EVENT_BROADCAST_9_CORE] =	"BROADCAST_9_CORE",
	[XAIE_EVENT_BROADCAST_10_CORE] =	"BROADCAST_10_CORE",
	[XAIE_EVENT_BROADCAST_11_CORE] =	"BROADCAST_11_CORE",
	[XAIE_EVENT_BROADCAST_12_CORE] =	"BROADCAST_12_CORE",
	[XAIE_EVENT_BROADCAST_13_CORE] =	"BROADCAST_13_CORE",
	[XAIE_EVENT_BROADCAST_14_CORE] =	"BROADCAST_14_CORE",
	[XAIE_EVENT_BROADCAST_15_CORE] =	"BROADCAST_15_CORE",
	[XAIE_EVENT_GROUP_USER_EVENT_CORE] =	"GROUP_USER_EVENT_CORE",
	[XAIE_EVENT_USER_EVENT_0_CORE] =	"USER_EVENT_0_CORE",
	[XAIE_EVENT_USER_EVENT_1_CORE] =	"USER_EVENT_1_CORE",
	[XAIE_EVENT_USER_EVENT_2_CORE] =	"USER_EVENT_2_CORE",
	[XAIE_EVENT_USER_EVENT_3_CORE] =	"USER_EVENT_3_CORE",
	[XAIE_EVENT_EDGE_DETECTION_EVENT_0_CORE] =	"EDGE_DETECTION_EVENT_0_CORE",
	[XAIE_EVENT_EDGE_DETECTION_EVENT_1_CORE] =	"EDGE_DETECTION_EVENT_1_CORE",
	[XAIE_EVENT_FP_HUGE_CORE] =	"FP_HUGE_CORE",
	[XAIE_EVENT_INT_FP_0_CORE] =	"INT_FP_0_CORE",
	[XAIE_EVENT_FP_INF_CORE] =	"FP_INF_CORE",
	[XAIE_EVENT_INSTR_WARNING_CORE] =	"INSTR_WARNING_CORE",
	[XAIE_EVENT_INSTR_ERROR_CORE] =	"INSTR_ERROR_CORE",
	[XAIE_EVENT_DECOMPRESSION_UNDERFLOW_CORE] =	"DECOMPRESSION_UNDERFLOW_CORE",
	[XAIE_EVENT_STREAM_SWITCH_PORT_PARITY_ERROR_CORE] =	"STREAM_SWITCH_PORT_PARITY_ERROR_CORE",
	[XAIE_EVENT_PROCESSOR_BUS_ERROR_CORE] =	"PROCESSOR_BUS_ERROR_CORE",
	[XAIE_EVENT_SPARSITY_OVERFLOW_CORE] =	"SPARSITY_OVERFLOW_CORE",

	/* All memory module events of the aie tile */
	[XAIE_EVENT_NONE_MEM] =	"NONE_MEM",
	[XAIE_EVENT_TRUE_MEM] =	"TRUE_MEM",
	[XAIE_EVENT_GROUP_0_MEM] =	"GROUP_0_MEM",
	[XAIE_EVENT_TIMER_SYNC_MEM] =	"TIMER_SYNC_MEM",
	[XAIE_EVENT_TIMER_VALUE_REACHED_MEM] =	"TIMER_VALUE_REACHED_MEM",
	[XAIE_EVENT_PERF_CNT_0_MEM] =	"PERF_CNT_0_MEM",
	[XAIE_EVENT_PERF_CNT_1_MEM] =	"PERF_CNT_1_MEM",
	[XAIE_EVENT_COMBO_EVENT_0_MEM] =	"COMBO_EVENT_0_MEM",
	[XAIE_EVENT_COMBO_EVENT_1_MEM] =	"COMBO_EVENT_1_MEM",
	[XAIE_EVENT_COMBO_EVENT_2_MEM] =	"COMBO_EVENT_2_MEM",
	[XAIE_EVENT_COMBO_EVENT_3_MEM] =	"COMBO_EVENT_3_MEM",
	[XAIE_EVENT_GROUP_WATCHPOINT_MEM] =	"GROUP_WATCHPOINT_MEM",
	[XAIE_EVENT_WATCHPOINT_0_MEM] =	"WATCHPOINT_0_MEM",
	[XAIE_EVENT_WATCHPOINT_1_MEM] =	"WATCHPOINT_1_MEM",
	[XAIE_EVENT_GROUP_DMA_ACTIVITY_MEM] =	"GROUP_DMA_ACTIVITY_MEM",
	[XAIE_EVENT_DMA_S2MM_0_START_BD_MEM] =	"DMA_S2MM_0_START_BD_MEM",
	[XAIE_EVENT_DMA_S2MM_1_START_BD_MEM] =	"DMA_S2MM_1_START_BD_MEM",
	[XAIE_EVENT_DMA_MM2S_0_START_BD_MEM] =	"DMA_MM2S_0_START_BD_MEM",
	[XAIE_EVENT_DMA_MM2S_1_START_BD_MEM] =	"DMA_MM2S_1_START_BD_MEM",
	[XAIE_EVENT_DMA_S2MM_0_FINISHED_BD_MEM] =	"DMA_S2MM_0_FINISHED_BD_MEM",
	[XAIE_EVENT_DMA_S2MM_1_FINISHED_BD_MEM] =	"DMA_S2MM_1_FINISHED_BD_MEM",
	[XAIE_EVENT_DMA_MM2S_0_FINISHED_BD_MEM] =	"DMA_MM2S_0_FINISHED_BD_MEM",
	[XAIE_EVENT_DMA_MM2S_1_FINISHED_BD_MEM] =	"DMA_MM2S_1_FINISHED_BD_MEM",
	[XAIE_EVENT_DMA_S2MM_0_GO_TO_IDLE_MEM] =	"DMA_S2MM_0_GO_TO_IDLE_MEM",
	[XAIE_EVENT_DMA_S2MM_1_GO_TO_IDLE_MEM] =	"DMA_S2MM_1_GO_TO_IDLE_MEM",
	[XAIE_EVENT_DMA_MM2S_0_GO_TO_IDLE_MEM] =	"DMA_MM2S_0_GO_TO_IDLE_MEM",
	[XAIE_EVENT_DMA_MM2S_1_GO_TO_IDLE_MEM] =	"DMA_MM2S_1_GO_TO_IDLE_MEM",
	[XAIE_EVENT_DMA_S2MM_0_STALLED_LOCK_ACQUIRE_MEM] =	"DMA_S2MM_0_STALLED_LOCK_ACQUIRE_MEM",
	[XAIE_EVENT_DMA_S2MM_1_STALLED_LOCK_ACQUIRE_MEM] =	"DMA_S2MM_1_STALLED_LOCK_ACQUIRE_MEM",
	[XAIE_EVENT_DMA_MM2S_0_STALLED_LOCK_ACQUIRE_MEM] =	"DMA_MM2S_0_STALLED_LOCK_ACQUIRE_MEM",
	[XAIE_EVENT_DMA_MM2S_1_STALLED_LOCK_ACQUIRE_MEM] =	"DMA_MM2S_1_STALLED_LOCK_ACQUIRE_MEM",
	[XAIE_EVENT_DMA_S2MM_0_MEMORY_CONFLICT_MEM] =	"DMA_S2MM_0_MEMORY_CONFLICT_MEM",
	[XAIE_EVENT_DMA_S2MM_1_MEMORY_CONFLICT_MEM] =	"DMA_S2MM_1_MEMORY_CONFLICT_MEM",
	[XAIE_EVENT_DMA_MM2S_0_MEMORY_CONFLICT_MEM] =	"DMA_MM2S_0_MEMORY_CONFLICT_MEM",
	[XAIE_EVENT_DMA_MM2S_1_MEMORY_CONFLICT_MEM] =	"DMA_MM2S_1_MEMORY_CONFLICT_MEM",
	[XAIE_EVENT_GROUP_LOCK_MEM] =	"GROUP_LOCK_MEM",
	[XAIE_EVENT_LOCK_0_ACQ_MEM] =	"LOCK_0_ACQ_MEM",
	[XAIE_EVENT_LOCK_0_REL_MEM] =	"LOCK_0_REL_MEM",
	[XAIE_EVENT_LOCK_1_ACQ_MEM] =	"LOCK_1_ACQ_MEM",
	[XAIE_EVENT_LOCK_1_REL_MEM] =	"LOCK_1_REL_MEM",
	[XAIE_EVENT_LOCK_2_ACQ_MEM] =	"LOCK_2_ACQ_MEM",
	[XAIE_EVENT_LOCK_2_REL_MEM] =	"LOCK_2_REL_MEM",
	[XAIE_EVENT_LOCK_3_ACQ_MEM] =	"LOCK_3_ACQ_MEM",
	[XAIE_EVENT_LOCK_3_REL_MEM] =	"LOCK_3_REL_MEM",
	[XAIE_EVENT_LOCK_4_ACQ_MEM] =	"LOCK_4_ACQ_MEM",
	[XAIE_EVENT_LOCK_4_REL_MEM] =	"LOCK_4_REL_MEM",
	[XAIE_EVENT_LOCK_5_ACQ_MEM] =	"LOCK_5_ACQ_MEM",
	[XAIE_EVENT_LOCK_5_REL_MEM] =	"LOCK_5_REL_MEM",
	[XAIE_EVENT_LOCK_6_ACQ_MEM] =	"LOCK_6_ACQ_MEM",
	[XAIE_EVENT_LOCK_6_REL_MEM] =	"LOCK_6_REL_MEM",
	[XAIE_EVENT_LOCK_7_ACQ_MEM] =	"LOCK_7_ACQ_MEM",
	[XAIE_EVENT_LOCK_7_REL_MEM] =	"LOCK_7_REL_MEM",
	[XAIE_EVENT_LOCK_8_ACQ_MEM] =	"LOCK_8_ACQ_MEM",
	[XAIE_EVENT_LOCK_8_REL_MEM] =	"LOCK_8_REL_MEM",
	[XAIE_EVENT_LOCK_9_ACQ_MEM] =	"LOCK_9_ACQ_MEM",
	[XAIE_EVENT_LOCK_9_REL_MEM] =	"LOCK_9_REL_MEM",
	[XAIE_EVENT_LOCK_10_ACQ_MEM] =	"LOCK_10_ACQ_MEM",
	[XAIE_EVENT_LOCK_10_REL_MEM] =	"LOCK_10_REL_MEM",
	[XAIE_EVENT_LOCK_11_ACQ_MEM] =	"LOCK_11_ACQ_MEM",
	[XAIE_EVENT_LOCK_11_REL_MEM] =	"LOCK_11_REL_MEM",
	[XAIE_EVENT_LOCK_12_ACQ_MEM] =	"LOCK_12_ACQ_MEM",
	[XAIE_EVENT_LOCK_12_REL_MEM] =	"LOCK_12_REL_MEM",
	[XAIE_EVENT_LOCK_13_ACQ_MEM] =	"LOCK_13_ACQ_MEM",
	[XAIE_EVENT_LOCK_13_REL_MEM] =	"LOCK_13_REL_MEM",
	[XAIE_EVENT_LOCK_14_ACQ_MEM] =	"LOCK_14_ACQ_MEM",
	[XAIE_EVENT_LOCK_14_REL_MEM] =	"LOCK_14_REL_MEM",
	[XAIE_EVENT_LOCK_15_ACQ_MEM] =	"LOCK_15_ACQ_MEM",
	[XAIE_EVENT_LOCK_15_REL_MEM] =	"LOCK_15_REL_MEM",
	[XAIE_EVENT_GROUP_MEMORY_CONFLICT_MEM] =	"GROUP_MEMORY_CONFLICT_MEM",
	[XAIE_EVENT_CONFLICT_DM_BANK_0_MEM] =	"CONFLICT_DM_BANK_0_MEM",
	[XAIE_EVENT_CONFLICT_DM_BANK_1_MEM] =	"CONFLICT_DM_BANK_1_MEM",
	[XAIE_EVENT_CONFLICT_DM_BANK_2_MEM] =	"CONFLICT_DM_BANK_2_MEM",
	[XAIE_EVENT_CONFLICT_DM_BANK_3_MEM] =	"CONFLICT_DM_BANK_3_MEM",
	[XAIE_EVENT_CONFLICT_DM_BANK_4_MEM] =	"CONFLICT_DM_BANK_4_MEM",
	[XAIE_EVENT_CONFLICT_DM_BANK_5_MEM] =	"CONFLICT_DM_BANK_5_MEM",
	[XAIE_EVENT_CONFLICT_DM_BANK_6_MEM] =	"CONFLICT_DM_BANK_6_MEM",
	[XAIE_EVENT_CONFLICT_DM_BANK_7_MEM] =	"CONFLICT_DM_BANK_7_MEM",
	[XAIE_EVENT_GROUP_ERRORS_MEM] =	"GROUP_ERRORS_MEM",
	[XAIE_EVENT_DM_ECC_ERROR_SCRUB_CORRECTED_MEM] =	"DM_ECC_ERROR_SCRUB_CORRECTED_MEM",
	[XAIE_EVENT_DM_ECC_ERROR_SCRUB_2BIT_MEM] =	"DM_ECC_ERROR_SCRUB_2BIT_MEM",
	[XAIE_EVENT_DM_ECC_ERROR_1BIT_MEM] =	"DM_ECC_ERROR_1BIT_MEM",
	[XAIE_EVENT_DM_ECC_ERROR_2BIT_MEM] =	"DM_ECC_ERROR_2BIT_MEM",
	[XAIE_EVENT_DM_PARITY_ERROR_BANK_2_MEM] =	"DM_PARITY_ERROR_BANK_2_MEM",
	[XAIE_EVENT_DM_PARITY_ERROR_BANK_3_MEM] =	"DM_PARITY_ERROR_BANK_3_MEM",
	[XAIE_EVENT_DM_PARITY_ERROR_BANK_4_MEM] =	"DM_PARITY_ERROR_BANK_4_MEM",
	[XAIE_EVENT_DM_PARITY_ERROR_BANK_5_MEM] =	"DM_PARITY_ERROR_BANK_5_MEM",
	[XAIE_EVENT_DM_PARITY_ERROR_BANK_6_MEM] =	"DM_PARITY_ERROR_BANK_6_MEM",
	[XAIE_EVENT_DM_PARITY_ERROR_BANK_7_MEM] =	"DM_PARITY_ERROR_BANK_7_MEM",
	[XAIE_EVENT_DMA_S2MM_0_ERROR_MEM] =	"DMA_S2MM_0_ERROR_MEM",
	[XAIE_EVENT_DMA_S2MM_1_ERROR_MEM] =	"DMA_S2MM_1_ERROR_MEM",
	[XAIE_EVENT_DMA_MM2S_0_ERROR_MEM] =	"DMA_MM2S_0_ERROR_MEM",
	[XAIE_EVENT_DMA_MM2S_1_ERROR_MEM] =	"DMA_MM2S_1_ERROR_MEM",
	[XAIE_EVENT_GROUP_BROADCAST_MEM] =	"GROUP_BROADCAST_MEM",
	[XAIE_EVENT_BROADCAST_0_MEM] =	"BROADCAST_0_MEM",
	[XAIE_EVENT_BROADCAST_1_MEM] =	"BROADCAST_1_MEM",
	[XAIE_EVENT_BROADCAST_2_MEM] =	"BROADCAST_2_MEM",
	[XAIE_EVENT_BROADCAST_3_MEM] =	"BROADCAST_3_MEM",
	[XAIE_EVENT_BROADCAST_4_MEM] =	"BROADCAST_4_MEM",
	[XAIE_EVENT_BROADCAST_5_MEM] =	"BROADCAST_5_MEM",
	[XAIE_EVENT_BROADCAST_6_MEM] =	"BROADCAST_6_MEM",
	[XAIE_EVENT_BROADCAST_7_MEM] =	"BROADCAST_7_MEM",
	[XAIE_EVENT_BROADCAST_8_MEM] =	"BROADCAST_8_MEM",
	[XAIE_EVENT_BROADCAST_9_MEM] =	"BROADCAST_9_MEM",
	[XAIE_EVENT_BROADCAST_10_MEM] =	"BROADCAST_10_MEM",
	[XAIE_EVENT_BROADCAST_11_MEM] =	"BROADCAST_11_MEM",
	[XAIE_EVENT_BROADCAST_12_MEM] =	"BROADCAST_12_MEM",
	[XAIE_EVENT_BROADCAST_13_MEM] =	"BROADCAST_13_MEM",
	[XAIE_EVENT_BROADCAST_14_MEM] =	"BROADCAST_14_MEM",
	[XAIE_EVENT_BROADCAST_15_MEM] =	"BROADCAST_15_MEM",
	[XAIE_EVENT_GROUP_USER_EVENT_MEM] =	"GROUP_USER_EVENT_MEM",
	[XAIE_EVENT_USER_EVENT_0_MEM] =	"USER_EVENT_0_MEM",
	[XAIE_EVENT_USER_EVENT_1_MEM] =	"USER_EVENT_1_MEM",
	[XAIE_EVENT_USER_EVENT_2_MEM] =	"USER_EVENT_2_MEM",
	[XAIE_EVENT_USER_EVENT_3_MEM] =	"USER_EVENT_3_MEM",
	[XAIE_EVENT_EDGE_DETECTION_EVENT_0_MEM] =	"EDGE_DETECTION_EVENT_0_MEM",
	[XAIE_EVENT_EDGE_DETECTION_EVENT_1_MEM] =	"EDGE_DETECTION_EVENT_1_MEM",
	[XAIE_EVENT_DMA_S2MM_0_START_TASK_MEM] =	"DMA_S2MM_0_START_TASK_MEM",
	[XAIE_EVENT_DMA_S2MM_1_START_TASK_MEM] =	"DMA_S2MM_1_START_TASK_MEM",
	[XAIE_EVENT_DMA_MM2S_0_START_TASK_MEM] =	"DMA_MM2S_0_START_TASK_MEM",
	[XAIE_EVENT_DMA_MM2S_1_START_TASK_MEM] =	"DMA_MM2S_1_START_TASK_MEM",
	[XAIE_EVENT_DMA_S2MM_0_FINISHED_TASK_MEM] =	"DMA_S2MM_0_FINISHED_TASK_MEM",
	[XAIE_EVENT_DMA_S2MM_1_FINISHED_TASK_MEM] =	"DMA_S2MM_1_FINISHED_TASK_MEM",
	[XAIE_EVENT_DMA_MM2S_0_FINISHED_TASK_MEM] =	"DMA_MM2S_0_FINISHED_TASK_MEM",
	[XAIE_EVENT_DMA_MM2S_1_FINISHED_TASK_MEM] =	"DMA_MM2S_1_FINISHED_TASK_MEM",
	[XAIE_EVENT_DMA_S2MM_0_STALLED_LOCK_MEM] =	"DMA_S2MM_0_STALLED_LOCK_MEM",
	[XAIE_EVENT_DMA_S2MM_1_STALLED_LOCK_MEM] =	"DMA_S2MM_1_STALLED_LOCK_MEM",
	[XAIE_EVENT_DMA_MM2S_0_STALLED_LOCK_MEM] =	"DMA_MM2S_0_STALLED_LOCK_MEM",
	[XAIE_EVENT_DMA_MM2S_1_STALLED_LOCK_MEM] =	"DMA_MM2S_1_STALLED_LOCK_MEM",
	[XAIE_EVENT_DMA_S2MM_0_STREAM_STARVATION_MEM] =	"DMA_S2MM_0_STREAM_STARVATION_MEM",
	[XAIE_EVENT_DMA_S2MM_1_STREAM_STARVATION_MEM] =	"DMA_S2MM_1_STREAM_STARVATION_MEM",
	[XAIE_EVENT_DMA_MM2S_0_STREAM_BACKPRESSURE_MEM] =	"DMA_MM2S_0_STREAM_BACKPRESSURE_MEM",
	[XAIE_EVENT_DMA_MM2S_1_STREAM_BACKPRESSURE_MEM] =	"DMA_MM2S_1_STREAM_BACKPRESSURE_MEM",
	[XAIE_EVENT_DMA_S2MM_0_MEMORY_BACKPRESSURE_MEM] =	"DMA_S2MM_0_MEMORY_BACKPRESSURE_MEM",
	[XAIE_EVENT_DMA_S2MM_1_MEMORY_BACKPRESSURE_MEM] =	"DMA_S2MM_1_MEMORY_BACKPRESSURE_MEM",
	[XAIE_EVENT_DMA_MM2S_0_MEMORY_STARVATION_MEM] =	"DMA_MM2S_0_MEMORY_STARVATION_MEM",
	[XAIE_EVENT_DMA_MM2S_1_MEMORY_STARVATION_MEM] =	"DMA_MM2S_1_MEMORY_STARVATION_MEM",
	[XAIE_EVENT_LOCK_SEL0_ACQ_EQ_MEM] =	"LOCK_SEL0_ACQ_EQ_MEM",
	[XAIE_EVENT_LOCK_SEL0_ACQ_GE_MEM] =	"LOCK_SEL0_ACQ_GE_MEM",
	[XAIE_EVENT_LOCK_SEL0_EQUAL_TO_VALUE_MEM] =	"LOCK_SEL0_EQUAL_TO_VALUE_MEM",
	[XAIE_EVENT_LOCK_SEL1_ACQ_EQ_MEM] =	"LOCK_SEL1_ACQ_EQ_MEM",
	[XAIE_EVENT_LOCK_SEL1_ACQ_GE_MEM] =	"LOCK_SEL1_ACQ_GE_MEM",
	[XAIE_EVENT_LOCK_SEL1_EQUAL_TO_VALUE_MEM] =	"LOCK_SEL1_EQUAL_TO_VALUE_MEM",
	[XAIE_EVENT_LOCK_SEL2_ACQ_EQ_MEM] =	"LOCK_SEL2_ACQ_EQ_MEM",
	[XAIE_EVENT_LOCK_SEL2_ACQ_GE_MEM] =	"LOCK_SEL2_ACQ_GE_MEM",
	[XAIE_EVENT_LOCK_SEL2_EQUAL_TO_VALUE_MEM] =	"LOCK_SEL2_EQUAL_TO_VALUE_MEM",
	[XAIE_EVENT_LOCK_SEL3_ACQ_EQ_MEM] =	"LOCK_SEL3_ACQ_EQ_MEM",
	[XAIE_EVENT_LOCK_SEL3_ACQ_GE_MEM] =	"LOCK_SEL3_ACQ_GE_MEM",
	[XAIE_EVENT_LOCK_SEL3_EQUAL_TO_VALUE_MEM] =	"LOCK_SEL3_EQUAL_TO_VALUE_MEM",
	[XAIE_EVENT_LOCK_SEL4_ACQ_EQ_MEM] =	"LOCK_SEL4_ACQ_EQ_MEM",
	[XAIE_EVENT_LOCK_SEL4_ACQ_GE_MEM] =	"LOCK_SEL4_ACQ_GE_MEM",
	[XAIE_EVENT_LOCK_SEL4_EQUAL_TO_VALUE_MEM] =	"LOCK_SEL4_EQUAL_TO_VALUE_MEM",
	[XAIE_EVENT_LOCK_SEL5_ACQ_EQ_MEM] =	"LOCK_SEL5_ACQ_EQ_MEM",
	[XAIE_EVENT_LOCK_SEL5_ACQ_GE_MEM] =	"LOCK_SEL5_ACQ_GE_MEM",
	[XAIE_EVENT_LOCK_SEL5_EQUAL_TO_VALUE_MEM] =	"LOCK_SEL5_EQUAL_TO_VALUE_MEM",
	[XAIE_EVENT_LOCK_SEL6_ACQ_EQ_MEM] =	"LOCK_SEL6_ACQ_EQ_MEM",
	[XAIE_EVENT_LOCK_SEL6_ACQ_GE_MEM] =	"LOCK_SEL6_ACQ_GE_MEM",
	[XAIE_EVENT_LOCK_SEL6_EQUAL_TO_VALUE_MEM] =	"LOCK_SEL6_EQUAL_TO_VALUE_MEM",
	[XAIE_EVENT_LOCK_SEL7_ACQ_EQ_MEM] =	"LOCK_SEL7_ACQ_EQ_MEM",
	[XAIE_EVENT_LOCK_SEL7_ACQ_GE_MEM] =	"LOCK_SEL7_ACQ_GE_MEM",
	[XAIE_EVENT_LOCK_SEL7_EQUAL_TO_VALUE_MEM] =	"LOCK_SEL7_EQUAL_TO_VALUE_MEM",
	[XAIE_EVENT_LOCK_ERROR_MEM] =	"LOCK_ERROR_MEM",
	[XAIE_EVENT_DMA_TASK_TOKEN_STALL_MEM] =	"DMA_TASK_TOKEN_STALL_MEM",

	/* All PL/Noc module events */
	[XAIE_EVENT_NONE_PL] =	"NONE_PL",
	[XAIE_EVENT_TRUE_PL] =	"TRUE_PL",
	[XAIE_EVENT_GROUP_0_PL] =	"GROUP_0_PL",
	[XAIE_EVENT_TIMER_SYNC_PL] =	"TIMER_SYNC_PL",
	[XAIE_EVENT_TIMER_VALUE_REACHED_PL] =	"TIMER_VALUE_REACHED_PL",
	[XAIE_EVENT_PERF_CNT_0_PL] =	"PERF_CNT_0_PL",
	[XAIE_EVENT_PERF_CNT_1_PL] =	"PERF_CNT_1_PL",
	[XAIE_EVENT_COMBO_EVENT_0_PL] =	"COMBO_EVENT_0_PL",
	[XAIE_EVENT_COMBO_EVENT_1_PL] =	"COMBO_EVENT_1_PL",
	[XAIE_EVENT_COMBO_EVENT_2_PL] =	"COMBO_EVENT_2_PL",
	[XAIE_EVENT_COMBO_EVENT_3_PL] =	"COMBO_EVENT_3_PL",
	[XAIE_EVENT_GROUP_DMA_ACTIVITY_PL] =	"GROUP_DMA_ACTIVITY_PL",
	[XAIE_EVENT_DMA_S2MM_0_START_BD_PL] =	"DMA_S2MM_0_START_BD_PL",
	[XAIE_EVENT_DMA_S2MM_1_START_BD_PL] =	"DMA_S2MM_1_START_BD_PL",
	[XAIE_EVENT_DMA_MM2S_0_START_BD_PL] =	"DMA_MM2S_0_START_BD_PL",
	[XAIE_EVENT_DMA_MM2S_1_START_BD_PL] =	"DMA_MM2S_1_START_BD_PL",
	[XAIE_EVENT_DMA_S2MM_0_FINISHED_BD_PL] =	"DMA_S2MM_0_FINISHED_BD_PL",
	[XAIE_EVENT_DMA_S2MM_1_FINISHED_BD_PL] =	"DMA_S2MM_1_FINISHED_BD_PL",
	[XAIE_EVENT_DMA_MM2S_0_FINISHED_BD_PL] =	"DMA_MM2S_0_FINISHED_BD_PL",
	[XAIE_EVENT_DMA_MM2S_1_FINISHED_BD_PL] =	"DMA_MM2S_1_FINISHED_BD_PL",
	[XAIE_EVENT_DMA_S2MM_0_GO_TO_IDLE_PL] =	"DMA_S2MM_0_GO_TO_IDLE_PL",
	[XAIE_EVENT_DMA_S2MM_1_GO_TO_IDLE_PL] =	"DMA_S2MM_1_GO_TO_IDLE_PL",
	[XAIE_EVENT_DMA_MM2S_0_GO_TO_IDLE_PL] =	"DMA_MM2S_0_GO_TO_IDLE_PL",
	[XAIE_EVENT_DMA_MM2S_1_GO_TO_IDLE_PL] =	"DMA_MM2S_1_GO_TO_IDLE_PL",
	[XAIE_EVENT_DMA_S2MM_0_STALLED_LOCK_ACQUIRE_PL] =	"DMA_S2MM_0_STALLED_LOCK_ACQUIRE_PL",
	[XAIE_EVENT_DMA_S2MM_1_STALLED_LOCK_ACQUIRE_PL] =	"DMA_S2MM_1_STALLED_LOCK_ACQUIRE_PL",
	[XAIE_EVENT_DMA_MM2S_0_STALLED_LOCK_ACQUIRE_PL] =	"DMA_MM2S_0_STALLED_LOCK_ACQUIRE_PL",
	[XAIE_EVENT_DMA_MM2S_1_STALLED_LOCK_ACQUIRE_PL] =	"DMA_MM2S_1_STALLED_LOCK_ACQUIRE_PL",
	[XAIE_EVENT_GROUP_LOCK_PL] =	"GROUP_LOCK_PL",
	[XAIE_EVENT_LOCK_0_ACQUIRED_PL] =	"LOCK_0_ACQUIRED_PL",
	[XAIE_EVENT_LOCK_0_RELEASED_PL] =	"LOCK_0_RELEASED_PL",
	[XAIE_EVENT_LOCK_1_ACQUIRED_PL] =	"LOCK_1_ACQUIRED_PL",
	[XAIE_EVENT_LOCK_1_RELEASED_PL] =	"LOCK_1_RELEASED_PL",
	[XAIE_EVENT_LOCK_2_ACQUIRED_PL] =	"LOCK_2_ACQUIRED_PL",
	[XAIE_EVENT_LOCK_2_RELEASED_PL] =	"LOCK_2_RELEASED_PL",
	[XAIE_EVENT_LOCK_3_ACQUIRED_PL] =	"LOCK_3_ACQUIRED_PL",
	[XAIE_EVENT_LOCK_3_RELEASED_PL] =	"LOCK_3_RELEASED_PL",
	[XAIE_EVENT_LOCK_4_ACQUIRED_PL] =	"LOCK_4_ACQUIRED_PL",
	[XAIE_EVENT_LOCK_4_RELEASED_PL] =	"LOCK_4_RELEASED_PL",
	[XAIE_EVENT_LOCK_5_ACQUIRED_PL] =	"LOCK_5_ACQUIRED_PL",
	[XAIE_EVENT_LOCK_5_RELEASED_PL] =	"LOCK_5_RELEASED_PL",
	[XAIE_EVENT_LOCK_6_ACQUIRED_PL] =	"LOCK_6_ACQUIRED_PL",
	[XAIE_EVENT_LOCK_6_RELEASED_PL] =	"LOCK_6_RELEASED_PL",
	[XAIE_EVENT_LOCK_7_ACQUIRED_PL] =	"LOCK_7_ACQUIRED_PL",
	[XAIE_EVENT_LOCK_7_RELEASED_PL] =	"LOCK_7_RELEASED_PL",
	[XAIE_EVENT_LOCK_8_ACQUIRED_PL] =	"LOCK_8_ACQUIRED_PL",
	[XAIE_EVENT_LOCK_8_RELEASED_PL] =	"LOCK_8_RELEASED_PL",
	[XAIE_EVENT_LOCK_9_ACQUIRED_PL] =	"LOCK_9_ACQUIRED_PL",
	[XAIE_EVENT_LOCK_9_RELEASED_PL] =	"LOCK_9_RELEASED_PL",
	[XAIE_EVENT_LOCK_10_ACQUIRED_PL] =	"LOCK_10_ACQUIRED_PL",
	[XAIE_EVENT_LOCK_10_RELEASED_PL] =	"LOCK_10_RELEASED_PL",
	[XAIE_EVENT_LOCK_11_ACQUIRED_PL] =	"LOCK_11_ACQUIRED_PL",
	[XAIE_EVENT_LOCK_11_RELEASED_PL] =	"LOCK_11_RELEASED_PL",
	[XAIE_EVENT_LOCK_12_ACQUIRED_PL] =	"LOCK_12_ACQUIRED_PL",
	[XAIE_EVENT_LOCK_12_RELEASED_PL] =	"LOCK_12_RELEASED_PL",
	[XAIE_EVENT_LOCK_13_ACQUIRED_PL] =	"LOCK_13_ACQUIRED_PL",
	[XAIE_EVENT_LOCK_13_RELEASED_PL] =	"LOCK_13_RELEASED_PL",
	[XAIE_EVENT_LOCK_14_ACQUIRED_PL] =	"LOCK_14_ACQUIRED_PL",
	[XAIE_EVENT_LOCK_14_RELEASED_PL] =	"LOCK_14_RELEASED_PL",
	[XAIE_EVENT_LOCK_15_ACQUIRED_PL] =	"LOCK_15_ACQUIRED_PL",
	[XAIE_EVENT_LOCK_15_RELEASED_PL] =	"LOCK_15_RELEASED_PL",
	[XAIE_EVENT_GROUP_ERRORS_PL] =	"GROUP_ERRORS_PL",
	[XAIE_EVENT_AXI_MM_SLAVE_TILE_ERROR_PL] =	"AXI_MM_SLAVE_TILE_ERROR_PL",
	[XAIE_EVENT_CONTROL_PKT_ERROR_PL] =	"CONTROL_PKT_ERROR_PL",
	[XAIE_EVENT_AXI_MM_DECODE_NSU_ERROR_PL] =	"AXI_MM_DECODE_NSU_ERROR_PL",
	[XAIE_EVENT_AXI_MM_SLAVE_NSU_ERROR_PL] =	"AXI_MM_SLAVE_NSU_ERROR_PL",
	[XAIE_EVENT_AXI_MM_UNSUPPORTED_TRAFFIC_PL] =	"AXI_MM_UNSUPPORTED_TRAFFIC_PL",
	[XAIE_EVENT_AXI_MM_UNSECURE_ACCESS_IN_SECURE_MODE_PL] =	"AXI_MM_UNSECURE_ACCESS_IN_SECURE_MODE_PL",
	[XAIE_EVENT_AXI_MM_BYTE_STROBE_ERROR_PL] =	"AXI_MM_BYTE_STROBE_ERROR_PL",
	[XAIE_EVENT_DMA_S2MM_0_ERROR_PL] =	"DMA_S2MM_0_ERROR_PL",
	[XAIE_EVENT_DMA_S2MM_1_ERROR_PL] =	"DMA_S2MM_1_ERROR_PL",
	[XAIE_EVENT_DMA_MM2S_0_ERROR_PL] =	"DMA_MM2S_0_ERROR_PL",
	[XAIE_EVENT_DMA_MM2S_1_ERROR_PL] =	"DMA_MM2S_1_ERROR_PL",
	[XAIE_EVENT_GROUP_STREAM_SWITCH_PL] =	"GROUP_STREAM_SWITCH_PL",
	[XAIE_EVENT_PORT_IDLE_0_PL] =	"PORT_IDLE_0_PL",
	[XAIE_EVENT_PORT_RUNNING_0_PL] =	"PORT_RUNNING_0_PL",
	[XAIE_EVENT_PORT_STALLED_0_PL] =	"PORT_STALLED_0_PL",
	[XAIE_EVENT_PORT_TLAST_0_PL] =	"PORT_TLAST_0_PL",
	[XAIE_EVENT_PORT_IDLE_1_PL] =	"PORT_IDLE_1_PL",
	[XAIE_EVENT_PORT_RUNNING_1_PL] =	"PORT_RUNNING_1_PL",
	[XAIE_EVENT_PORT_STALLED_1_PL] =	"PORT_STALLED_1_PL",
	[XAIE_EVENT_PORT_TLAST_1_PL] =	"PORT_TLAST_1_PL",
	[XAIE_EVENT_PORT_IDLE_2_PL] =	"PORT_IDLE_2_PL",
	[XAIE_EVENT_PORT_RUNNING_2_PL] =	"PORT_RUNNING_2_PL",
	[XAIE_EVENT_PORT_STALLED_2_PL] =	"PORT_STALLED_2_PL",
	[XAIE_EVENT_PORT_TLAST_2_PL] =	"PORT_TLAST_2_PL",
	[XAIE_EVENT_PORT_IDLE_3_PL] =	"PORT_IDLE_3_PL",
	[XAIE_EVENT_PORT_RUNNING_3_PL] =	"PORT_RUNNING_3_PL",
	[XAIE_EVENT_PORT_STALLED_3_PL] =	"PORT_STALLED_3_PL",
	[XAIE_EVENT_PORT_TLAST_3_PL] =	"PORT_TLAST_3_PL",
	[XAIE_EVENT_PORT_IDLE_4_PL] =	"PORT_IDLE_4_PL",
	[XAIE_EVENT_PORT_RUNNING_4_PL] =	"PORT_RUNNING_4_PL",
	[XAIE_EVENT_PORT_STALLED_4_PL] =	"PORT_STALLED_4_PL",
	[XAIE_EVENT_PORT_TLAST_4_PL] =	"PORT_TLAST_4_PL",
	[XAIE_EVENT_PORT_IDLE_5_PL] =	"PORT_IDLE_5_PL",
	[XAIE_EVENT_PORT_RUNNING_5_PL] =	"PORT_RUNNING_5_PL",
	[XAIE_EVENT_PORT_STALLED_5_PL] =	"PORT_STALLED_5_PL",
	[XAIE_EVENT_PORT_TLAST_5_PL] =	"PORT_TLAST_5_PL",
	[XAIE_EVENT_PORT_IDLE_6_PL] =	"PORT_IDLE_6_PL",
	[XAIE_EVENT_PORT_RUNNING_6_PL] =	"PORT_RUNNING_6_PL",
	[XAIE_EVENT_PORT_STALLED_6_PL] =	"PORT_STALLED_6_PL",
	[XAIE_EVENT_PORT_TLAST_6_PL] =	"PORT_TLAST_6_PL",
	[XAIE_EVENT_PORT_IDLE_7_PL] =	"PORT_IDLE_7_PL",
	[XAIE_EVENT_PORT_RUNNING_7_PL] =	"PORT_RUNNING_7_PL",
	[XAIE_EVENT_PORT_STALLED_7_PL] =	"PORT_STALLED_7_PL",
	[XAIE_EVENT_PORT_TLAST_7_PL] =	"PORT_TLAST_7_PL",
	[XAIE_EVENT_GROUP_BROADCAST_A_PL] =	"GROUP_BROADCAST_A_PL",
	[XAIE_EVENT_BROADCAST_A_0_PL] =	"BROADCAST_A_0_PL",
	[XAIE_EVENT_BROADCAST_A_1_PL] =	"BROADCAST_A_1_PL",
	[XAIE_EVENT_BROADCAST_A_2_PL] =	"BROADCAST_A_2_PL",
	[XAIE_EVENT_BROADCAST_A_3_PL] =	"BROADCAST_A_3_PL",
	[XAIE_EVENT_BROADCAST_A_4_PL] =	"BROADCAST_A_4_PL",
	[XAIE_EVENT_BROADCAST_A_5_PL] =	"BROADCAST_A_5_PL",
	[XAIE_EVENT_BROADCAST_A_6_PL] =	"BROADCAST_A_6_PL",
	[XAIE_EVENT_BROADCAST_A_7_PL] =	"BROADCAST_A_7_PL",
	[XAIE_EVENT_BROADCAST_A_8_PL] =	"BROADCAST_A_8_PL",
	[XAIE_EVENT_BROADCAST_A_9_PL] =	"BROADCAST_A_9_PL",
	[XAIE_EVENT_BROADCAST_A_10_PL] =	"BROADCAST_A_10_PL",
	[XAIE_EVENT_BROADCAST_A_11_PL] =	"BROADCAST_A_11_PL",
	[XAIE_EVENT_BROADCAST_A_12_PL] =	"BROADCAST_A_12_PL",
	[XAIE_EVENT_BROADCAST_A_13_PL] =	"BROADCAST_A_13_PL",
	[XAIE_EVENT_BROADCAST_A_14_PL] =	"BROADCAST_A_14_PL",
	[XAIE_EVENT_BROADCAST_A_15_PL] =	"BROADCAST_A_15_PL",
	[XAIE_EVENT_GROUP_USER_EVENT_PL] =	"GROUP_USER_EVENT_PL",
	[XAIE_EVENT_USER_EVENT_0_PL] =	"USER_EVENT_0_PL",
	[XAIE_EVENT_USER_EVENT_1_PL] =	"USER_EVENT_1_PL",
	[XAIE_EVENT_USER_EVENT_2_PL] =	"USER_EVENT_2_PL",
	[XAIE_EVENT_USER_EVENT_3_PL] =	"USER_EVENT_3_PL",
	[XAIE_EVENT_EDGE_DETECTION_EVENT_0_PL] =	"EDGE_DETECTION_EVENT_0_PL",
	[XAIE_EVENT_EDGE_DETECTION_EVENT_1_PL] =	"EDGE_DETECTION_EVENT_1_PL",
	[XAIE_EVENT_DMA_S2MM_0_START_TASK_PL] =	"DMA_S2MM_0_START_TASK_PL",
	[XAIE_EVENT_DMA_S2MM_1_START_TASK_PL] =	"DMA_S2MM_1_START_TASK_PL",
	[XAIE_EVENT_DMA_MM2S_0_START_TASK_PL] =	"DMA_MM2S_0_START_TASK_PL",
	[XAIE_EVENT_DMA_MM2S_1_START_TASK_PL] =	"DMA_MM2S_1_START_TASK_PL",
	[XAIE_EVENT_DMA_S2MM_0_FINISHED_TASK_PL] =	"DMA_S2MM_0_FINISHED_TASK_PL",
	[XAIE_EVENT_DMA_S2MM_1_FINISHED_TASK_PL] =	"DMA_S2MM_1_FINISHED_TASK_PL",
	[XAIE_EVENT_DMA_MM2S_0_FINISHED_TASK_PL] =	"DMA_MM2S_0_FINISHED_TASK_PL",
	[XAIE_EVENT_DMA_MM2S_1_FINISHED_TASK_PL] =	"DMA_MM2S_1_FINISHED_TASK_PL",
	[XAIE_EVENT_DMA_S2MM_0_STALLED_LOCK_PL] =	"DMA_S2MM_0_STALLED_LOCK_PL",
	[XAIE_EVENT_DMA_S2MM_1_STALLED_LOCK_PL] =	"DMA_S2MM_1_STALLED_LOCK_PL",
	[XAIE_EVENT_DMA_MM2S_0_STALLED_LOCK_PL] =	"DMA_MM2S_0_STALLED_LOCK_PL",
	[XAIE_EVENT_DMA_MM2S_1_STALLED_LOCK_PL] =	"DMA_MM2S_1_STALLED_LOCK_PL",
	[XAIE_EVENT_DMA_S2MM_0_STREAM_STARVATION_PL] =	"DMA_S2MM_0_STREAM_STARVATION_PL",
	[XAIE_EVENT_DMA_S2MM_1_STREAM_STARVATION_PL] =	"DMA_S2MM_1_STREAM_STARVATION_PL",
	[XAIE_EVENT_DMA_MM2S_0_STREAM_BACKPRESSURE_PL] =	"DMA_MM2S_0_STREAM_BACKPRESSURE_PL",
	[XAIE_EVENT_DMA_MM2S_1_STREAM_BACKPRESSURE_PL] =	"DMA_MM2S_1_STREAM_BACKPRESSURE_PL",
	[XAIE_EVENT_DMA_S2MM_0_MEMORY_BACKPRESSURE_PL] =	"DMA_S2MM_0_MEMORY_BACKPRESSURE_PL",
	[XAIE_EVENT_DMA_S2MM_1_MEMORY_BACKPRESSURE_PL] =	"DMA_S2MM_1_MEMORY_BACKPRESSURE_PL",
	[XAIE_EVENT_DMA_MM2S_0_MEMORY_STARVATION_PL] =	"DMA_MM2S_0_MEMORY_STARVATION_PL",
	[XAIE_EVENT_DMA_MM2S_1_MEMORY_STARVATION_PL] =	"DMA_MM2S_1_MEMORY_STARVATION_PL",
	[XAIE_EVENT_LOCK_0_ACQ_EQ_PL] =	"LOCK_0_ACQ_EQ_PL",
	[XAIE_EVENT_LOCK_0_ACQ_GE_PL] =	"LOCK_0_ACQ_GE_PL",
	[XAIE_EVENT_LOCK_0_EQUAL_TO_VALUE_PL] =	"LOCK_0_EQUAL_TO_VALUE_PL",
	[XAIE_EVENT_LOCK_1_ACQ_EQ_PL] =	"LOCK_1_ACQ_EQ_PL",
	[XAIE_EVENT_LOCK_1_ACQ_GE_PL] =	"LOCK_1_ACQ_GE_PL",
	[XAIE_EVENT_LOCK_1_EQUAL_TO_VALUE_PL] =	"LOCK_1_EQUAL_TO_VALUE_PL",
	[XAIE_EVENT_LOCK_2_ACQ_EQ_PL] =	"LOCK_2_ACQ_EQ_PL",
	[XAIE_EVENT_LOCK_2_ACQ_GE_PL] =	"LOCK_2_ACQ_GE_PL",
	[XAIE_EVENT_LOCK_2_EQUAL_TO_VALUE_PL] =	"LOCK_2_EQUAL_TO_VALUE_PL",
	[XAIE_EVENT_LOCK_3_ACQ_EQ_PL] =	"LOCK_3_ACQ_EQ_PL",
	[XAIE_EVENT_LOCK_3_ACQ_GE_PL] =	"LOCK_3_ACQ_GE_PL",
	[XAIE_EVENT_LOCK_3_EQUAL_TO_VALUE_PL] =	"LOCK_3_EQUAL_TO_VALUE_PL",
	[XAIE_EVENT_LOCK_4_ACQ_EQ_PL] =	"LOCK_4_ACQ_EQ_PL",
	[XAIE_EVENT_LOCK_4_ACQ_GE_PL] =	"LOCK_4_ACQ_GE_PL",
	[XAIE_EVENT_LOCK_4_EQUAL_TO_VALUE_PL] =	"LOCK_4_EQUAL_TO_VALUE_PL",
	[XAIE_EVENT_LOCK_5_ACQ_EQ_PL] =	"LOCK_5_ACQ_EQ_PL",
	[XAIE_EVENT_LOCK_5_ACQ_GE_PL] =	"LOCK_5_ACQ_GE_PL",
	[XAIE_EVENT_LOCK_5_EQUAL_TO_VALUE_PL] =	"LOCK_5_EQUAL_TO_VALUE_PL",
	[XAIE_EVENT_STREAM_SWITCH_PARITY_ERROR_PL] =	"STREAM_SWITCH_PARITY_ERROR_PL",
	[XAIE_EVENT_DMA_S2MM_ERROR_PL] =	"DMA_S2MM_ERROR_PL",
	[XAIE_EVENT_DMA_MM2S_ERROR_PL] =	"DMA_MM2S_ERROR_PL",
	[XAIE_EVENT_LOCK_ERROR_PL] =	"LOCK_ERROR_PL",
	[XAIE_EVENT_DMA_TASK_TOKEN_STALL_PL] =	"DMA_TASK_TOKEN_STALL_PL",

	/* All Mem Tile events */
	[XAIE_EVENT_NONE_MEM_TILE] =	"NONE_MEM_TILE",
	[XAIE_EVENT_TRUE_MEM_TILE] =	"TRUE_MEM_TILE",
	[XAIE_EVENT_GROUP_0_MEM_TILE] =	"GROUP_0_MEM_TILE",
	[XAIE_EVENT_TIMER_SYNC_MEM_TILE] =	"TIMER_SYNC_MEM_TILE",
	[XAIE_EVENT_TIMER_VALUE_REACHED_MEM_TILE] =	"TIMER_VALUE_REACHED_MEM_TILE",
	[XAIE_EVENT_PERF_CNT0_EVENT_MEM_TILE] =	"PERF_CNT0_EVENT_MEM_TILE",
	[XAIE_EVENT_PERF_CNT1_EVENT_MEM_TILE] =	"PERF_CNT1_EVENT_MEM_TILE",
	[XAIE_EVENT_PERF_CNT2_EVENT_MEM_TILE] =	"PERF_CNT2_EVENT_MEM_TILE",
	[XAIE_EVENT_PERF_CNT3_EVENT_MEM_TILE] =	"PERF_CNT3_EVENT_MEM_TILE",
	[XAIE_EVENT_COMBO_EVENT_0_MEM_TILE] =	"COMBO_EVENT_0_MEM_TILE",
	[XAIE_EVENT_COMBO_EVENT_1_MEM_TILE] =	"COMBO_EVENT_1_MEM_TILE",
	[XAIE_EVENT_COMBO_EVENT_2_MEM_TILE] =	"COMBO_EVENT_2_MEM_TILE",
	[XAIE_EVENT_COMBO_EVENT_3_MEM_TILE] =	"COMBO_EVENT_3_MEM_TILE",
	[XAIE_EVENT_EDGE_DETECTION_EVENT_0_MEM_TILE] =	"EDGE_DETECTION_EVENT_0_MEM_TILE",
	[XAIE_EVENT_EDGE_DETECTION_EVENT_1_MEM_TILE] =	"EDGE_DETECTION_EVENT_1_MEM_TILE",
	[XAIE_EVENT_GROUP_WATCHPOINT_MEM_TILE] =	"GROUP_WATCHPOINT_MEM_TILE",
	[XAIE_EVENT_WATCHPOINT_0_MEM_TILE] =	"WATCHPOINT_0_MEM_TILE",
	[XAIE_EVENT_WATCHPOINT_1_MEM_TILE] =	"WATCHPOINT_1_MEM_TILE",
	[XAIE_EVENT_WATCHPOINT_2_MEM_TILE] =	"WATCHPOINT_2_MEM_TILE",
	[XAIE_EVENT_WATCHPOINT_3_MEM_TILE] =	"WATCHPOINT_3_MEM_TILE",
	[XAIE_EVENT_GROUP_DMA_ACTIVITY_MEM_TILE] =	"GROUP_DMA_ACTIVITY_MEM_TILE",
	[XAIE_EVENT_DMA_S2MM_SEL0_START_TASK_MEM_TILE] =	"DMA_S2MM_SEL0_START_TASK_MEM_TILE",
	[XAIE_EVENT_DMA_S2MM_SEL1_START_TASK_MEM_TILE] =	"DMA_S2MM_SEL1_START_TASK_MEM_TILE",
	[XAIE_EVENT_DMA_MM2S_SEL0_START_TASK_MEM_TILE] =	"DMA_MM2S_SEL0_START_TASK_MEM_TILE",
	[XAIE_EVENT_DMA_MM2S_SEL1_START_TASK_MEM_TILE] =	"DMA_MM2S_SEL1_START_TASK_MEM_TILE",
	[XAIE_EVENT_DMA_S2MM_SEL0_FINISHED_BD_MEM_TILE] =	"DMA_S2MM_SEL0_FINISHED_BD_MEM_TILE",
	[XAIE_EVENT_DMA_S2MM_SEL1_FINISHED_BD_MEM_TILE] =	"DMA_S2MM_SEL1_FINISHED_BD_MEM_TILE",
	[XAIE_EVENT_DMA_MM2S_SEL0_FINISHED_BD_MEM_TILE] =	"DMA_MM2S_SEL0_FINISHED_BD_MEM_TILE",
	[XAIE_EVENT_DMA_MM2S_SEL1_FINISHED_BD_MEM_TILE] =	"DMA_MM2S_SEL1_FINISHED_BD_MEM_TILE",
	[XAIE_EVENT_DMA_S2MM_SEL0_FINISHED_TASK_MEM_TILE] =	"DMA_S2MM_SEL0_FINISHED_TASK_MEM_TILE",
	[XAIE_EVENT_DMA_S2MM_SEL1_FINISHED_TASK_MEM_TILE] =	"DMA_S2MM_SEL1_FINISHED_TASK_MEM_TILE",
	[XAIE_EVENT_DMA_MM2S_SEL0_FINISHED_TASK_MEM_TILE] =	"DMA_MM2S_SEL0_FINISHED_TASK_MEM_TILE",
	[XAIE_EVENT_DMA_MM2S_SEL1_FINISHED_TASK_MEM_TILE] =	"DMA_MM2S_SEL1_FINISHED_TASK_MEM_TILE",
	[XAIE_EVENT_DMA_S2MM_SEL0_STALLED_LOCK_ACQUIRE_MEM_TILE] =	"DMA_S2MM_SEL0_STALLED_LOCK_ACQUIRE_MEM_TILE",
	[XAIE_EVENT_DMA_S2MM_SEL1_STALLED_LOCK_ACQUIRE_MEM_TILE] =	"DMA_S2MM_SEL1_STALLED_LOCK_ACQUIRE_MEM_TILE",
	[XAIE_EVENT_DMA_MM2S_SEL0_STALLED_LOCK_ACQUIRE_MEM_TILE] =	"DMA_MM2S_SEL0_STALLED_LOCK_ACQUIRE_MEM_TILE",
	[XAIE_EVENT_DMA_MM2S_SEL1_STALLED_LOCK_ACQUIRE_MEM_TILE] =	"DMA_MM2S_SEL1_STALLED_LOCK_ACQUIRE_MEM_TILE",
	[XAIE_EVENT_DMA_S2MM_SEL0_STREAM_STARVATION_MEM_TILE] =	"DMA_S2MM_SEL0_STREAM_STARVATION_MEM_TILE",
	[XAIE_EVENT_DMA_S2MM_SEL1_STREAM_STARVATION_MEM_TILE] =	"DMA_S2MM_SEL1_STREAM_STARVATION_MEM_TILE",
	[XAIE_EVENT_DMA_MM2S_SEL0_STREAM_BACKPRESSURE_MEM_TILE] =	"DMA_MM2S_SEL0_STREAM_BACKPRESSURE_MEM_TILE",
	[XAIE_EVENT_DMA_MM2S_SEL1_STREAM_BACKPRESSURE_MEM_TILE] =	"DMA_MM2S_SEL1_STREAM_BACKPRESSURE_MEM_TILE",
	[XAIE_EVENT_DMA_S2MM_SEL0_MEMORY_BACKPRESSURE_MEM_TILE] =	"DMA_S2MM_SEL0_MEMORY_BACKPRESSURE_MEM_TILE",
	[XAIE_EVENT_DMA_S2MM_SEL1_MEMORY_BACKPRESSURE_MEM_TILE] =	"DMA_S2MM_SEL1_MEMORY_BACKPRESSURE_MEM_TILE",
	[XAIE_EVENT_DMA_MM2S_SEL0_MEMORY_STARVATION_MEM_TILE] =	"DMA_MM2S_SEL0_MEMORY_STARVATION_MEM_TILE",
	[XAIE_EVENT_DMA_MM2S_SEL1_MEMORY_STARVATION_MEM_TILE] =	"DMA_MM2S_SEL1_MEMORY_STARVATION_MEM_TILE",
	[XAIE_EVENT_GROUP_LOCK_MEM_TILE] =	"GROUP_LOCK_MEM_TILE",
	[XAIE_EVENT_LOCK_SEL0_ACQ_EQ_MEM_TILE] =	"LOCK_SEL0_ACQ_EQ_MEM_TILE",
	[XAIE_EVENT_LOCK_SEL0_ACQ_GE_MEM_TILE] =	"LOCK_SEL0_ACQ_GE_MEM_TILE",
	[XAIE_EVENT_LOCK_SEL0_REL_MEM_TILE] =	"LOCK_SEL0_REL_MEM_TILE",
	[XAIE_EVENT_LOCK_SEL0_EQUAL_TO_VALUE_MEM_TILE] =	"LOCK_SEL0_EQUAL_TO_VALUE_MEM_TILE",
	[XAIE_EVENT_LOCK_SEL1_ACQ_EQ_MEM_TILE] =	"LOCK_SEL1_ACQ_EQ_MEM_TILE",
	[XAIE_EVENT_LOCK_SEL1_ACQ_GE_MEM_TILE] =	"LOCK_SEL1_ACQ_GE_MEM_TILE",
	[XAIE_EVENT_LOCK_SEL1_REL_MEM_TILE] =	"LOCK_SEL1_REL_MEM_TILE",
	[XAIE_EVENT_LOCK_SEL1_EQUAL_TO_VALUE_MEM_TILE] =	"LOCK_SEL1_EQUAL_TO_VALUE_MEM_TILE",
	[XAIE_EVENT_LOCK_SEL2_ACQ_EQ_MEM_TILE] =	"LOCK_SEL2_ACQ_EQ_MEM_TILE",
	[XAIE_EVENT_LOCK_SEL2_ACQ_GE_MEM_TILE] =	"LOCK_SEL2_ACQ_GE_MEM_TILE",
	[XAIE_EVENT_LOCK_SEL2_REL_MEM_TILE] =	"LOCK_SEL2_REL_MEM_TILE",
	[XAIE_EVENT_LOCK_SEL2_EQUAL_TO_VALUE_MEM_TILE] =	"LOCK_SEL2_EQUAL_TO_VALUE_MEM_TILE",
	[XAIE_EVENT_LOCK_SEL3_ACQ_EQ_MEM_TILE] =	"LOCK_SEL3_ACQ_EQ_MEM_TILE",
	[XAIE_EVENT_LOCK_SEL3_ACQ_GE_MEM_TILE] =	"LOCK_SEL3_ACQ_GE_MEM_TILE",
	[XAIE_EVENT_LOCK_SEL3_REL_MEM_TILE] =	"LOCK_SEL3_REL_MEM_TILE",
	[XAIE_EVENT_LOCK_SEL3_EQUAL_TO_VALUE_MEM_TILE] =	"LOCK_SEL3_EQUAL_TO_VALUE_MEM_TILE",
	[XAIE_EVENT_LOCK_SEL4_ACQ_EQ_MEM_TILE] =	"LOCK_SEL4_ACQ_EQ_MEM_TILE",
	[XAIE_EVENT_LOCK_SEL4_ACQ_GE_MEM_TILE] =	"LOCK_SEL4_ACQ_GE_MEM_TILE",
	[XAIE_EVENT_LOCK_SEL4_REL_MEM_TILE] =	"LOCK_SEL4_REL_MEM_TILE",
	[XAIE_EVENT_LOCK_SEL4_EQUAL_TO_VALUE_MEM_TILE] =	"LOCK_SEL4_EQUAL_TO_VALUE_MEM_TILE",
	[XAIE_EVENT_LOCK_SEL5_ACQ_EQ_MEM_TILE] =	"LOCK_SEL5_ACQ_EQ_MEM_TILE",
	[XAIE_EVENT_LOCK_SEL5_ACQ_GE_MEM_TILE] =	"LOCK_SEL5_ACQ_GE_MEM_TILE",
	[XAIE_EVENT_LOCK_SEL5_REL_MEM_TILE] =	"LOCK_SEL5_REL_MEM_TILE",
	[XAIE_EVENT_LOCK_SEL5_EQUAL_TO_VALUE_MEM_TILE] =	"LOCK_SEL5_EQUAL_TO_VALUE_MEM_TILE",
	[XAIE_EVENT_LOCK_SEL6_ACQ_EQ_MEM_TILE] =	"LOCK_SEL6_ACQ_EQ_MEM_TILE",
	[XAIE_EVENT_LOCK_SEL6_ACQ_GE_MEM_TILE] =	"LOCK_SEL6_ACQ_GE_MEM_TILE",
	[XAIE_EVENT_LOCK_SEL6_REL_MEM_TILE] =	"LOCK_SEL6_REL_MEM_TILE",
	[XAIE_EVENT_LOCK_SEL6_EQUAL_TO_VALUE_MEM_TILE] =	"LOCK_SEL6_EQUAL_TO_VALUE_MEM_TILE",
	[XAIE_EVENT_LOCK_SEL7_ACQ_EQ_MEM_TILE] =	"LOCK_SEL7_ACQ_EQ_MEM_TILE",
	[XAIE_EVENT_LOCK_SEL7_ACQ_GE_MEM_TILE] =	"LOCK_SEL7_ACQ_GE_MEM_TILE",
	[XAIE_EVENT_LOCK_SEL7_REL_MEM_TILE] =	"LOCK_SEL7_REL_MEM_TILE",
	[XAIE_EVENT_LOCK_SEL7_EQUAL_TO_VALUE_MEM_TILE] =	"LOCK_SEL7_EQUAL_TO_VALUE_MEM_TILE",
	[XAIE_EVENT_GROUP_STREAM_SWITCH_MEM_TILE] =	"GROUP_STREAM_SWITCH_MEM_TILE",
	[XAIE_EVENT_PORT_IDLE_0_MEM_TILE] =	"PORT_IDLE_0_MEM_TILE",
	[XAIE_EVENT_PORT_RUNNING_0_MEM_TILE] =	"PORT_RUNNING_0_MEM_TILE",
	[XAIE_EVENT_PORT_STALLED_0_MEM_TILE] =	"PORT_STALLED_0_MEM_TILE",
	[XAIE_EVENT_PORT_TLAST_0_MEM_TILE] =	"PORT_TLAST_0_MEM_TILE",
	[XAIE_EVENT_PORT_IDLE_1_MEM_TILE] =	"PORT_IDLE_1_MEM_TILE",
	[XAIE_EVENT_PORT_RUNNING_1_MEM_TILE] =	"PORT_RUNNING_1_MEM_TILE",
	[XAIE_EVENT_PORT_STALLED_1_MEM_TILE] =	"PORT_STALLED_1_MEM_TILE",
	[XAIE_EVENT_PORT_TLAST_1_MEM_TILE] =	"PORT_TLAST_1_MEM_TILE",
	[XAIE_EVENT_PORT_IDLE_2_MEM_TILE] =	"PORT_IDLE_2_MEM_TILE",
	[XAIE_EVENT_PORT_RUNNING_2_MEM_TILE] =	"PORT_RUNNING_2_MEM_TILE",
	[XAIE_EVENT_PORT_STALLED_2_MEM_TILE] =	"PORT_STALLED_2_MEM_TILE",
	[XAIE_EVENT_PORT_TLAST_2_MEM_TILE] =	"PORT_TLAST_2_MEM_TILE",
	[XAIE_EVENT_PORT_IDLE_3_MEM_TILE] =	"PORT_IDLE_3_MEM_TILE",
	[XAIE_EVENT_PORT_RUNNING_3_MEM_TILE] =	"PORT_RUNNING_3_MEM_TILE",
	[XAIE_EVENT_PORT_STALLED_3_MEM_TILE] =	"PORT_STALLED_3_MEM_TILE",
	[XAIE_EVENT_PORT_TLAST_3_MEM_TILE] =	"PORT_TLAST_3_MEM_TILE",
	[XAIE_EVENT_PORT_IDLE_4_MEM_TILE] =	"PORT_IDLE_4_MEM_TILE",
	[XAIE_EVENT_PORT_RUNNING_4_MEM_TILE] =	"PORT_RUNNING_4_MEM_TILE",
	[XAIE_EVENT_PORT_STALLED_4_MEM_TILE] =	"PORT_STALLED_4_MEM_TILE",
	[XAIE_EVENT_PORT_TLAST_4_MEM_TILE] =	"PORT_TLAST_4_MEM_TILE",
	[XAIE_EVENT_PORT_IDLE_5_MEM_TILE] =	"PORT_IDLE_5_MEM_TILE",
	[XAIE_EVENT_PORT_RUNNING_5_MEM_TILE] =	"PORT_RUNNING_5_MEM_TILE",
	[XAIE_EVENT_PORT_STALLED_5_MEM_TILE] =	"PORT_STALLED_5_MEM_TILE",
	[XAIE_EVENT_PORT_TLAST_5_MEM_TILE] =	"PORT_TLAST_5_MEM_TILE",
	[XAIE_EVENT_PORT_IDLE_6_MEM_TILE] =	"PORT_IDLE_6_MEM_TILE",
	[XAIE_EVENT_PORT_RUNNING_6_MEM_TILE] =	"PORT_RUNNING_6_MEM_TILE",
	[XAIE_EVENT_PORT_STALLED_6_MEM_TILE] =	"PORT_STALLED_6_MEM_TILE",
	[XAIE_EVENT_PORT_TLAST_6_MEM_TILE] =	"PORT_TLAST_6_MEM_TILE",
	[XAIE_EVENT_PORT_IDLE_7_MEM_TILE] =	"PORT_IDLE_7_MEM_TILE",
	[XAIE_EVENT_PORT_RUNNING_7_MEM_TILE] =	"PORT_RUNNING_7_MEM_TILE",
	[XAIE_EVENT_PORT_STALLED_7_MEM_TILE] =	"PORT_STALLED_7_MEM_TILE",
	[XAIE_EVENT_PORT_TLAST_7_MEM_TILE] =	"PORT_TLAST_7_MEM_TILE",
	[XAIE_EVENT_GROUP_MEMORY_CONFLICT_MEM_TILE] =	"GROUP_MEMORY_CONFLICT_MEM_TILE",
	[XAIE_EVENT_CONFLICT_DM_BANK_0_MEM_TILE] =	"CONFLICT_DM_BANK_0_MEM_TILE",
	[XAIE_EVENT_CONFLICT_DM_BANK_1_MEM_TILE] =	"CONFLICT_DM_BANK_1_MEM_TILE",
	[XAIE_EVENT_CONFLICT_DM_BANK_2_MEM_TILE] =	"CONFLICT_DM_BANK_2_MEM_TILE",
	[XAIE_EVENT_CONFLICT_DM_BANK_3_MEM_TILE] =	"CONFLICT_DM_BANK_3_MEM_TILE",
	[XAIE_EVENT_CONFLICT_DM_BANK_4_MEM_TILE] =	"CONFLICT_DM_BANK_4_MEM_TILE",
	[XAIE_EVENT_CONFLICT_DM_BANK_5_MEM_TILE] =	"CONFLICT_DM_BANK_5_MEM_TILE",
	[XAIE_EVENT_CONFLICT_DM_BANK_6_MEM_TILE] =	"CONFLICT_DM_BANK_6_MEM_TILE",
	[XAIE_EVENT_CONFLICT_DM_BANK_7_MEM_TILE] =	"CONFLICT_DM_BANK_7_MEM_TILE",
	[XAIE_EVENT_CONFLICT_DM_BANK_8_MEM_TILE] =	"CONFLICT_DM_BANK_8_MEM_TILE",
	[XAIE_EVENT_CONFLICT_DM_BANK_9_MEM_TILE] =	"CONFLICT_DM_BANK_9_MEM_TILE",
	[XAIE_EVENT_CONFLICT_DM_BANK_10_MEM_TILE] =	"CONFLICT_DM_BANK_10_MEM_TILE",
	[XAIE_EVENT_CONFLICT_DM_BANK_11_MEM_TILE] =	"CONFLICT_DM_BANK_11_MEM_TILE",
	[XAIE_EVENT_CONFLICT_DM_BANK_12_MEM_TILE] =	"CONFLICT_DM_BANK_12_MEM_TILE",
	[XAIE_EVENT_CONFLICT_DM_BANK_13_MEM_TILE] =	"CONFLICT_DM_BANK_13_MEM_TILE",
	[XAIE_EVENT_CONFLICT_DM_BANK_14_MEM_TILE] =	"CONFLICT_DM_BANK_14_MEM_TILE",
	[XAIE_EVENT_CONFLICT_DM_BANK_15_MEM_TILE] =	"CONFLICT_DM_BANK_15_MEM_TILE",
	[XAIE_EVENT_GROUP_ERRORS_MEM_TILE] =	"GROUP_ERRORS_MEM_TILE",
	[XAIE_EVENT_DM_ECC_ERROR_SCRUB_CORRECTED_MEM_TILE] =	"DM_ECC_ERROR_SCRUB_CORRECTED_MEM_TILE",
	[XAIE_EVENT_DM_ECC_ERROR_SCRUB_2BIT_MEM_TILE] =	"DM_ECC_ERROR_SCRUB_2BIT_MEM_TILE",
	[XAIE_EVENT_DM_ECC_ERROR_1BIT_MEM_TILE] =	"DM_ECC_ERROR_1BIT_MEM_TILE",
	[XAIE_EVENT_DM_ECC_ERROR_2BIT_MEM_TILE] =	"DM_ECC_ERROR_2BIT_MEM_TILE",
	[XAIE_EVENT_DMA_S2MM_ERROR_MEM_TILE] =	"DMA_S2MM_ERROR_MEM_TILE",
	[XAIE_EVENT_DMA_MM2S_ERROR_MEM_TILE] =	"DMA_MM2S_ERROR_MEM_TILE",
	[XAIE_EVENT_STREAM_SWITCH_PARITY_ERROR_MEM_TILE] =	"STREAM_SWITCH_PARITY_ERROR_MEM_TILE",
	[XAIE_EVENT_STREAM_PKT_ERROR_MEM_TILE] =	"STREAM_PKT_ERROR_MEM_TILE",
	[XAIE_EVENT_CONTROL_PKT_ERROR_MEM_TILE] =	"CONTROL_PKT_ERROR_MEM_TILE",
	[XAIE_EVENT_AXI_MM_SLAVE_ERROR_MEM_TILE] =	"AXI_MM_SLAVE_ERROR_MEM_TILE",
	[XAIE_EVENT_LOCK_ERROR_MEM_TILE] =	"LOCK_ERROR_MEM_TILE",
	[XAIE_EVENT_DMA_TASK_TOKEN_STALL_MEM_TILE] =	"DMA_TASK_TOKEN_STALL_MEM_TILE",
	[XAIE_EVENT_GROUP_BROADCAST_MEM_TILE] =	"GROUP_BROADCAST_MEM_TILE",
	[XAIE_EVENT_BROADCAST_0_MEM_TILE] =	"BROADCAST_0_MEM_TILE",
	[XAIE_EVENT_BROADCAST_1_MEM_TILE] =	"BROADCAST_1_MEM_TILE",
	[XAIE_EVENT_BROADCAST_2_MEM_TILE] =	"BROADCAST_2_MEM_TILE",
	[XAIE_EVENT_BROADCAST_3_MEM_TILE] =	"BROADCAST_3_MEM_TILE",
	[XAIE_EVENT_BROADCAST_4_MEM_TILE] =	"BROADCAST_4_MEM_TILE",
	[XAIE_EVENT_BROADCAST_5_MEM_TILE] =	"BROADCAST_5_MEM_TILE",
	[XAIE_EVENT_BROADCAST_6_MEM_TILE] =	"BROADCAST_6_MEM_TILE",
	[XAIE_EVENT_BROADCAST_7_MEM_TILE] =	"BROADCAST_7_MEM_TILE",
	[XAIE_EVENT_BROADCAST_8_MEM_TILE] =	"BROADCAST_8_MEM_TILE",
	[XAIE_EVENT_BROADCAST_9_MEM_TILE] =	"BROADCAST_9_MEM_TILE",
	[XAIE_EVENT_BROADCAST_10_MEM_TILE] =	"BROADCAST_10_MEM_TILE",
	[XAIE_EVENT_BROADCAST_11_MEM_TILE] =	"BROADCAST_11_MEM_TILE",
	[XAIE_EVENT_BROADCAST_12_MEM_TILE] =	"BROADCAST_12_MEM_TILE",
	[XAIE_EVENT_BROADCAST_13_MEM_TILE] =	"BROADCAST_13_MEM_TILE",
	[XAIE_EVENT_BROADCAST_14_MEM_TILE] =	"BROADCAST_14_MEM_TILE",
	[XAIE_EVENT_BROADCAST_15_MEM_TILE] =	"BROADCAST_15_MEM_TILE",
	[XAIE_EVENT_GROUP_USER_EVENT_MEM_TILE] =	"GROUP_USER_EVENT_MEM_TILE",
	[XAIE_EVENT_USER_EVENT_0_MEM_TILE] =	"USER_EVENT_0_MEM_TILE",
	[XAIE_EVENT_USER_EVENT_1_MEM_TILE] =	"USER_EVENT_1_MEM_TILE",

};

/**************************** Function Definitions *******************************/
/*****************************************************************************/
/**
*
* This API takes input of an Event id and returns a string describing the event
*
* @param	Event - Event ID
*
* @return	String corresponding to Event ID
*
* @note		None
*
******************************************************************************/
const char* XAie_EventGetString(XAie_Events Event) {
	return XAie_EventStrings[Event];
}

#endif /* XAIE_FEATURE_UTIL_ENABLE */
/** @} */
