/******************************************************************************
* Copyright (C) 2021-2022 Xilinx, Inc. All rights reserved.
* Copyright (C) 2022-2023 Advanced Micro Devices, Inc. All rights reserved.
* SPDX-License-Identifier: MIT
******************************************************************************/


/*****************************************************************************/
/**
*
* @file xaie2pgbl_params.h
* @{
*
* This file contains the macro definitions for the AIE registers, generated from
* regdb headers.
*
* <pre>
* MODIFICATION HISTORY:
*
* Ver   Who     Date     Changes
* ----- ------  -------- -----------------------------------------------------
* 1.0   Tejus   09/07/2021  Initial creation
* </pre>
*
******************************************************************************/
#ifndef XAIE2PGBL_PARAMS_H
#define XAIE2PGBL_PARAMS_H

/* AIE2P core module register definitions */

/**
 * @name Core Module register definitions
 * This registers contains core module information
 * @{
 */
/**
 * Register:XAIE2PGBL_CORE_MODULE
 */
#define XAIE2PGBL_CORE_MODULE_PROGRAM_MEMORY                            0x00020000
#define XAIE2PGBL_CORE_MODULE_PROGRAM_MEMORY_WIDTH                      128
#define XAIE2PGBL_CORE_MODULE_PROGRAM_MEMORY_MASK                       0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_PROGRAM_MEMORY_A_LSB                    0
#define XAIE2PGBL_CORE_MODULE_PROGRAM_MEMORY_A_WIDTH                  128
#define XAIE2PGBL_CORE_MODULE_PROGRAM_MEMORY_A_MASK                   0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_PROGRAM_MEMORY_A_DEFVAL                 0x0

#define XAIE2PGBL_CORE_MODULE_PROGRAM_MEMORY_ERROR_INJECTION            0x00024000
#define XAIE2PGBL_CORE_MODULE_PROGRAM_MEMORY_ERROR_INJECTION_WIDTH      128
#define XAIE2PGBL_CORE_MODULE_PROGRAM_MEMORY_ERROR_INJECTION_MASK       0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_PROGRAM_MEMORY_ERROR_INJECTION_A_LSB    0
#define XAIE2PGBL_CORE_MODULE_PROGRAM_MEMORY_ERROR_INJECTION_A_WIDTH  128
#define XAIE2PGBL_CORE_MODULE_PROGRAM_MEMORY_ERROR_INJECTION_A_MASK   0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_PROGRAM_MEMORY_ERROR_INJECTION_A_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMLL0_PART1                          0x00030000
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL0_PART1_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL0_PART1_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL0_PART1_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL0_PART1_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL0_PART1_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL0_PART1_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMLL0_PART2                          0x00030010
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL0_PART2_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL0_PART2_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL0_PART2_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL0_PART2_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL0_PART2_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL0_PART2_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMLL0_PART3                          0x00030020
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL0_PART3_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL0_PART3_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL0_PART3_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL0_PART3_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL0_PART3_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL0_PART3_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMLL0_PART4                          0x00030030
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL0_PART4_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL0_PART4_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL0_PART4_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL0_PART4_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL0_PART4_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL0_PART4_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMLH0_PART1                          0x00030040
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH0_PART1_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH0_PART1_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH0_PART1_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH0_PART1_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH0_PART1_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH0_PART1_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMLH0_PART2                          0x00030050
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH0_PART2_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH0_PART2_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH0_PART2_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH0_PART2_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH0_PART2_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH0_PART2_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMLH0_PART3                          0x00030060
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH0_PART3_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH0_PART3_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH0_PART3_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH0_PART3_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH0_PART3_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH0_PART3_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMLH0_PART4                          0x00030070
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH0_PART4_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH0_PART4_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH0_PART4_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH0_PART4_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH0_PART4_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH0_PART4_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMHL0_PART1                          0x00030080
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL0_PART1_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL0_PART1_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL0_PART1_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL0_PART1_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL0_PART1_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL0_PART1_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMHL0_PART2                          0x00030090
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL0_PART2_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL0_PART2_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL0_PART2_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL0_PART2_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL0_PART2_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL0_PART2_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMHL0_PART3                          0x000300A0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL0_PART3_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL0_PART3_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL0_PART3_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL0_PART3_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL0_PART3_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL0_PART3_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMHL0_PART4                          0x000300B0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL0_PART4_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL0_PART4_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL0_PART4_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL0_PART4_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL0_PART4_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL0_PART4_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMHH0_PART1                          0x000300C0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH0_PART1_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH0_PART1_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH0_PART1_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH0_PART1_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH0_PART1_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH0_PART1_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMHH0_PART2                          0x000300D0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH0_PART2_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH0_PART2_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH0_PART2_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH0_PART2_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH0_PART2_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH0_PART2_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMHH0_PART3                          0x000300E0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH0_PART3_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH0_PART3_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH0_PART3_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH0_PART3_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH0_PART3_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH0_PART3_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMHH0_PART4                          0x000300F0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH0_PART4_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH0_PART4_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH0_PART4_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH0_PART4_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH0_PART4_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH0_PART4_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMLL1_PART1                          0x00030100
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL1_PART1_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL1_PART1_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL1_PART1_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL1_PART1_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL1_PART1_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL1_PART1_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMLL1_PART2                          0x00030110
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL1_PART2_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL1_PART2_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL1_PART2_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL1_PART2_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL1_PART2_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL1_PART2_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMLL1_PART3                          0x00030120
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL1_PART3_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL1_PART3_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL1_PART3_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL1_PART3_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL1_PART3_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL1_PART3_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMLL1_PART4                          0x00030130
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL1_PART4_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL1_PART4_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL1_PART4_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL1_PART4_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL1_PART4_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL1_PART4_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMLH1_PART1                          0x00030140
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH1_PART1_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH1_PART1_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH1_PART1_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH1_PART1_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH1_PART1_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH1_PART1_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMLH1_PART2                          0x00030150
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH1_PART2_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH1_PART2_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH1_PART2_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH1_PART2_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH1_PART2_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH1_PART2_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMLH1_PART3                          0x00030160
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH1_PART3_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH1_PART3_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH1_PART3_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH1_PART3_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH1_PART3_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH1_PART3_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMLH1_PART4                          0x00030170
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH1_PART4_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH1_PART4_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH1_PART4_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH1_PART4_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH1_PART4_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH1_PART4_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMHL1_PART1                          0x00030180
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL1_PART1_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL1_PART1_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL1_PART1_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL1_PART1_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL1_PART1_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL1_PART1_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMHL1_PART2                          0x00030190
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL1_PART2_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL1_PART2_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL1_PART2_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL1_PART2_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL1_PART2_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL1_PART2_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMHL1_PART3                          0x000301A0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL1_PART3_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL1_PART3_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL1_PART3_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL1_PART3_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL1_PART3_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL1_PART3_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMHL1_PART4                          0x000301B0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL1_PART4_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL1_PART4_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL1_PART4_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL1_PART4_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL1_PART4_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL1_PART4_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMHH1_PART1                          0x000301C0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH1_PART1_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH1_PART1_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH1_PART1_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH1_PART1_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH1_PART1_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH1_PART1_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMHH1_PART2                          0x000301D0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH1_PART2_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH1_PART2_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH1_PART2_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH1_PART2_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH1_PART2_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH1_PART2_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMHH1_PART3                          0x000301E0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH1_PART3_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH1_PART3_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH1_PART3_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH1_PART3_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH1_PART3_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH1_PART3_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMHH1_PART4                          0x000301F0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH1_PART4_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH1_PART4_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH1_PART4_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH1_PART4_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH1_PART4_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH1_PART4_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMLL2_PART1                          0x00030200
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL2_PART1_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL2_PART1_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL2_PART1_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL2_PART1_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL2_PART1_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL2_PART1_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMLL2_PART2                          0x00030210
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL2_PART2_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL2_PART2_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL2_PART2_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL2_PART2_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL2_PART2_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL2_PART2_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMLL2_PART3                          0x00030220
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL2_PART3_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL2_PART3_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL2_PART3_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL2_PART3_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL2_PART3_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL2_PART3_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMLL2_PART4                          0x00030230
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL2_PART4_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL2_PART4_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL2_PART4_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL2_PART4_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL2_PART4_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL2_PART4_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMLH2_PART1                          0x00030240
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH2_PART1_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH2_PART1_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH2_PART1_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH2_PART1_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH2_PART1_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH2_PART1_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMLH2_PART2                          0x00030250
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH2_PART2_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH2_PART2_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH2_PART2_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH2_PART2_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH2_PART2_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH2_PART2_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMLH2_PART3                          0x00030260
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH2_PART3_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH2_PART3_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH2_PART3_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH2_PART3_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH2_PART3_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH2_PART3_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMLH2_PART4                          0x00030270
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH2_PART4_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH2_PART4_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH2_PART4_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH2_PART4_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH2_PART4_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH2_PART4_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMHL2_PART1                          0x00030280
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL2_PART1_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL2_PART1_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL2_PART1_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL2_PART1_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL2_PART1_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL2_PART1_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMHL2_PART2                          0x00030290
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL2_PART2_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL2_PART2_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL2_PART2_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL2_PART2_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL2_PART2_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL2_PART2_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMHL2_PART3                          0x000302A0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL2_PART3_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL2_PART3_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL2_PART3_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL2_PART3_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL2_PART3_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL2_PART3_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMHL2_PART4                          0x000302B0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL2_PART4_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL2_PART4_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL2_PART4_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL2_PART4_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL2_PART4_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL2_PART4_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMHH2_PART1                          0x000302C0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH2_PART1_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH2_PART1_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH2_PART1_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH2_PART1_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH2_PART1_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH2_PART1_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMHH2_PART2                          0x000302D0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH2_PART2_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH2_PART2_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH2_PART2_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH2_PART2_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH2_PART2_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH2_PART2_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMHH2_PART3                          0x000302E0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH2_PART3_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH2_PART3_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH2_PART3_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH2_PART3_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH2_PART3_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH2_PART3_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMHH2_PART4                          0x000302F0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH2_PART4_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH2_PART4_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH2_PART4_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH2_PART4_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH2_PART4_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH2_PART4_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMLL3_PART1                          0x00030300
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL3_PART1_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL3_PART1_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL3_PART1_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL3_PART1_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL3_PART1_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL3_PART1_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMLL3_PART2                          0x00030310
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL3_PART2_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL3_PART2_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL3_PART2_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL3_PART2_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL3_PART2_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL3_PART2_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMLL3_PART3                          0x00030320
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL3_PART3_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL3_PART3_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL3_PART3_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL3_PART3_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL3_PART3_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL3_PART3_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMLL3_PART4                          0x00030330
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL3_PART4_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL3_PART4_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL3_PART4_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL3_PART4_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL3_PART4_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL3_PART4_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMLH3_PART1                          0x00030340
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH3_PART1_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH3_PART1_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH3_PART1_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH3_PART1_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH3_PART1_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH3_PART1_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMLH3_PART2                          0x00030350
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH3_PART2_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH3_PART2_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH3_PART2_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH3_PART2_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH3_PART2_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH3_PART2_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMLH3_PART3                          0x00030360
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH3_PART3_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH3_PART3_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH3_PART3_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH3_PART3_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH3_PART3_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH3_PART3_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMLH3_PART4                          0x00030370
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH3_PART4_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH3_PART4_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH3_PART4_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH3_PART4_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH3_PART4_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH3_PART4_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMHL3_PART1                          0x00030380
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL3_PART1_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL3_PART1_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL3_PART1_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL3_PART1_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL3_PART1_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL3_PART1_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMHL3_PART2                          0x00030390
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL3_PART2_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL3_PART2_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL3_PART2_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL3_PART2_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL3_PART2_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL3_PART2_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMHL3_PART3                          0x000303A0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL3_PART3_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL3_PART3_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL3_PART3_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL3_PART3_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL3_PART3_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL3_PART3_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMHL3_PART4                          0x000303B0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL3_PART4_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL3_PART4_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL3_PART4_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL3_PART4_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL3_PART4_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL3_PART4_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMHH3_PART1                          0x000303C0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH3_PART1_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH3_PART1_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH3_PART1_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH3_PART1_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH3_PART1_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH3_PART1_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMHH3_PART2                          0x000303D0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH3_PART2_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH3_PART2_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH3_PART2_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH3_PART2_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH3_PART2_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH3_PART2_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMHH3_PART3                          0x000303E0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH3_PART3_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH3_PART3_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH3_PART3_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH3_PART3_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH3_PART3_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH3_PART3_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMHH3_PART4                          0x000303F0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH3_PART4_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH3_PART4_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH3_PART4_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH3_PART4_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH3_PART4_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH3_PART4_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMLL4_PART1                          0x00030400
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL4_PART1_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL4_PART1_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL4_PART1_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL4_PART1_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL4_PART1_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL4_PART1_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMLL4_PART2                          0x00030410
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL4_PART2_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL4_PART2_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL4_PART2_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL4_PART2_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL4_PART2_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL4_PART2_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMLL4_PART3                          0x00030420
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL4_PART3_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL4_PART3_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL4_PART3_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL4_PART3_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL4_PART3_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL4_PART3_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMLL4_PART4                          0x00030430
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL4_PART4_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL4_PART4_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL4_PART4_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL4_PART4_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL4_PART4_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLL4_PART4_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMLH4_PART1                          0x00030440
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH4_PART1_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH4_PART1_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH4_PART1_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH4_PART1_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH4_PART1_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH4_PART1_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMLH4_PART2                          0x00030450
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH4_PART2_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH4_PART2_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH4_PART2_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH4_PART2_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH4_PART2_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH4_PART2_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMLH4_PART3                          0x00030460
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH4_PART3_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH4_PART3_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH4_PART3_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH4_PART3_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH4_PART3_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH4_PART3_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMLH4_PART4                          0x00030470
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH4_PART4_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH4_PART4_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH4_PART4_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH4_PART4_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH4_PART4_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMLH4_PART4_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMHL4_PART1                          0x00030480
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL4_PART1_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL4_PART1_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL4_PART1_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL4_PART1_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL4_PART1_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL4_PART1_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMHL4_PART2                          0x00030490
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL4_PART2_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL4_PART2_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL4_PART2_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL4_PART2_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL4_PART2_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL4_PART2_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMHL4_PART3                          0x000304A0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL4_PART3_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL4_PART3_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL4_PART3_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL4_PART3_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL4_PART3_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL4_PART3_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMHL4_PART4                          0x000304B0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL4_PART4_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL4_PART4_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL4_PART4_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL4_PART4_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL4_PART4_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHL4_PART4_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMHH4_PART1                          0x000304C0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH4_PART1_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH4_PART1_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH4_PART1_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH4_PART1_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH4_PART1_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH4_PART1_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMHH4_PART2                          0x000304D0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH4_PART2_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH4_PART2_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH4_PART2_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH4_PART2_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH4_PART2_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH4_PART2_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMHH4_PART3                          0x000304E0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH4_PART3_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH4_PART3_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH4_PART3_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH4_PART3_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH4_PART3_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH4_PART3_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_BMHH4_PART4                          0x000304F0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH4_PART4_WIDTH                    128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH4_PART4_MASK                     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH4_PART4_REGISTER_VALUE_LSB     0
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH4_PART4_REGISTER_VALUE_WIDTH   128
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH4_PART4_REGISTER_VALUE_MASK    0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_BMHH4_PART4_REGISTER_VALUE_DEFVAL  0x0

#define XAIE2PGBL_CORE_MODULE_CORE_WL0_PART1                            0x00030800
#define XAIE2PGBL_CORE_MODULE_CORE_WL0_PART1_WIDTH                      128
#define XAIE2PGBL_CORE_MODULE_CORE_WL0_PART1_MASK                       0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WL0_PART1_REGISTER_VALUE_LSB       0
#define XAIE2PGBL_CORE_MODULE_CORE_WL0_PART1_REGISTER_VALUE_WIDTH     128
#define XAIE2PGBL_CORE_MODULE_CORE_WL0_PART1_REGISTER_VALUE_MASK      0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WL0_PART1_REGISTER_VALUE_DEFVAL    0x0

#define XAIE2PGBL_CORE_MODULE_CORE_WL0_PART2                            0x00030810
#define XAIE2PGBL_CORE_MODULE_CORE_WL0_PART2_WIDTH                      128
#define XAIE2PGBL_CORE_MODULE_CORE_WL0_PART2_MASK                       0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WL0_PART2_REGISTER_VALUE_LSB       0
#define XAIE2PGBL_CORE_MODULE_CORE_WL0_PART2_REGISTER_VALUE_WIDTH     128
#define XAIE2PGBL_CORE_MODULE_CORE_WL0_PART2_REGISTER_VALUE_MASK      0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WL0_PART2_REGISTER_VALUE_DEFVAL    0x0

#define XAIE2PGBL_CORE_MODULE_CORE_WH0_PART1                            0x00030820
#define XAIE2PGBL_CORE_MODULE_CORE_WH0_PART1_WIDTH                      128
#define XAIE2PGBL_CORE_MODULE_CORE_WH0_PART1_MASK                       0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WH0_PART1_REGISTER_VALUE_LSB       0
#define XAIE2PGBL_CORE_MODULE_CORE_WH0_PART1_REGISTER_VALUE_WIDTH     128
#define XAIE2PGBL_CORE_MODULE_CORE_WH0_PART1_REGISTER_VALUE_MASK      0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WH0_PART1_REGISTER_VALUE_DEFVAL    0x0

#define XAIE2PGBL_CORE_MODULE_CORE_WH0_PART2                            0x00030830
#define XAIE2PGBL_CORE_MODULE_CORE_WH0_PART2_WIDTH                      128
#define XAIE2PGBL_CORE_MODULE_CORE_WH0_PART2_MASK                       0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WH0_PART2_REGISTER_VALUE_LSB       0
#define XAIE2PGBL_CORE_MODULE_CORE_WH0_PART2_REGISTER_VALUE_WIDTH     128
#define XAIE2PGBL_CORE_MODULE_CORE_WH0_PART2_REGISTER_VALUE_MASK      0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WH0_PART2_REGISTER_VALUE_DEFVAL    0x0

#define XAIE2PGBL_CORE_MODULE_CORE_WL1_PART1                            0x00030840
#define XAIE2PGBL_CORE_MODULE_CORE_WL1_PART1_WIDTH                      128
#define XAIE2PGBL_CORE_MODULE_CORE_WL1_PART1_MASK                       0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WL1_PART1_REGISTER_VALUE_LSB       0
#define XAIE2PGBL_CORE_MODULE_CORE_WL1_PART1_REGISTER_VALUE_WIDTH     128
#define XAIE2PGBL_CORE_MODULE_CORE_WL1_PART1_REGISTER_VALUE_MASK      0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WL1_PART1_REGISTER_VALUE_DEFVAL    0x0

#define XAIE2PGBL_CORE_MODULE_CORE_WL1_PART2                            0x00030850
#define XAIE2PGBL_CORE_MODULE_CORE_WL1_PART2_WIDTH                      128
#define XAIE2PGBL_CORE_MODULE_CORE_WL1_PART2_MASK                       0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WL1_PART2_REGISTER_VALUE_LSB       0
#define XAIE2PGBL_CORE_MODULE_CORE_WL1_PART2_REGISTER_VALUE_WIDTH     128
#define XAIE2PGBL_CORE_MODULE_CORE_WL1_PART2_REGISTER_VALUE_MASK      0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WL1_PART2_REGISTER_VALUE_DEFVAL    0x0

#define XAIE2PGBL_CORE_MODULE_CORE_WH1_PART1                            0x00030860
#define XAIE2PGBL_CORE_MODULE_CORE_WH1_PART1_WIDTH                      128
#define XAIE2PGBL_CORE_MODULE_CORE_WH1_PART1_MASK                       0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WH1_PART1_REGISTER_VALUE_LSB       0
#define XAIE2PGBL_CORE_MODULE_CORE_WH1_PART1_REGISTER_VALUE_WIDTH     128
#define XAIE2PGBL_CORE_MODULE_CORE_WH1_PART1_REGISTER_VALUE_MASK      0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WH1_PART1_REGISTER_VALUE_DEFVAL    0x0

#define XAIE2PGBL_CORE_MODULE_CORE_WH1_PART2                            0x00030870
#define XAIE2PGBL_CORE_MODULE_CORE_WH1_PART2_WIDTH                      128
#define XAIE2PGBL_CORE_MODULE_CORE_WH1_PART2_MASK                       0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WH1_PART2_REGISTER_VALUE_LSB       0
#define XAIE2PGBL_CORE_MODULE_CORE_WH1_PART2_REGISTER_VALUE_WIDTH     128
#define XAIE2PGBL_CORE_MODULE_CORE_WH1_PART2_REGISTER_VALUE_MASK      0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WH1_PART2_REGISTER_VALUE_DEFVAL    0x0

#define XAIE2PGBL_CORE_MODULE_CORE_WL2_PART1                            0x00030880
#define XAIE2PGBL_CORE_MODULE_CORE_WL2_PART1_WIDTH                      128
#define XAIE2PGBL_CORE_MODULE_CORE_WL2_PART1_MASK                       0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WL2_PART1_REGISTER_VALUE_LSB       0
#define XAIE2PGBL_CORE_MODULE_CORE_WL2_PART1_REGISTER_VALUE_WIDTH     128
#define XAIE2PGBL_CORE_MODULE_CORE_WL2_PART1_REGISTER_VALUE_MASK      0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WL2_PART1_REGISTER_VALUE_DEFVAL    0x0

#define XAIE2PGBL_CORE_MODULE_CORE_WL2_PART2                            0x00030890
#define XAIE2PGBL_CORE_MODULE_CORE_WL2_PART2_WIDTH                      128
#define XAIE2PGBL_CORE_MODULE_CORE_WL2_PART2_MASK                       0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WL2_PART2_REGISTER_VALUE_LSB       0
#define XAIE2PGBL_CORE_MODULE_CORE_WL2_PART2_REGISTER_VALUE_WIDTH     128
#define XAIE2PGBL_CORE_MODULE_CORE_WL2_PART2_REGISTER_VALUE_MASK      0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WL2_PART2_REGISTER_VALUE_DEFVAL    0x0

#define XAIE2PGBL_CORE_MODULE_CORE_WH2_PART1                            0x000308A0
#define XAIE2PGBL_CORE_MODULE_CORE_WH2_PART1_WIDTH                      128
#define XAIE2PGBL_CORE_MODULE_CORE_WH2_PART1_MASK                       0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WH2_PART1_REGISTER_VALUE_LSB       0
#define XAIE2PGBL_CORE_MODULE_CORE_WH2_PART1_REGISTER_VALUE_WIDTH     128
#define XAIE2PGBL_CORE_MODULE_CORE_WH2_PART1_REGISTER_VALUE_MASK      0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WH2_PART1_REGISTER_VALUE_DEFVAL    0x0

#define XAIE2PGBL_CORE_MODULE_CORE_WH2_PART2                            0x000308B0
#define XAIE2PGBL_CORE_MODULE_CORE_WH2_PART2_WIDTH                      128
#define XAIE2PGBL_CORE_MODULE_CORE_WH2_PART2_MASK                       0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WH2_PART2_REGISTER_VALUE_LSB       0
#define XAIE2PGBL_CORE_MODULE_CORE_WH2_PART2_REGISTER_VALUE_WIDTH     128
#define XAIE2PGBL_CORE_MODULE_CORE_WH2_PART2_REGISTER_VALUE_MASK      0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WH2_PART2_REGISTER_VALUE_DEFVAL    0x0

#define XAIE2PGBL_CORE_MODULE_CORE_WL3_PART1                            0x000308C0
#define XAIE2PGBL_CORE_MODULE_CORE_WL3_PART1_WIDTH                      128
#define XAIE2PGBL_CORE_MODULE_CORE_WL3_PART1_MASK                       0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WL3_PART1_REGISTER_VALUE_LSB       0
#define XAIE2PGBL_CORE_MODULE_CORE_WL3_PART1_REGISTER_VALUE_WIDTH     128
#define XAIE2PGBL_CORE_MODULE_CORE_WL3_PART1_REGISTER_VALUE_MASK      0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WL3_PART1_REGISTER_VALUE_DEFVAL    0x0

#define XAIE2PGBL_CORE_MODULE_CORE_WL3_PART2                            0x000308D0
#define XAIE2PGBL_CORE_MODULE_CORE_WL3_PART2_WIDTH                      128
#define XAIE2PGBL_CORE_MODULE_CORE_WL3_PART2_MASK                       0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WL3_PART2_REGISTER_VALUE_LSB       0
#define XAIE2PGBL_CORE_MODULE_CORE_WL3_PART2_REGISTER_VALUE_WIDTH     128
#define XAIE2PGBL_CORE_MODULE_CORE_WL3_PART2_REGISTER_VALUE_MASK      0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WL3_PART2_REGISTER_VALUE_DEFVAL    0x0

#define XAIE2PGBL_CORE_MODULE_CORE_WH3_PART1                            0x000308E0
#define XAIE2PGBL_CORE_MODULE_CORE_WH3_PART1_WIDTH                      128
#define XAIE2PGBL_CORE_MODULE_CORE_WH3_PART1_MASK                       0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WH3_PART1_REGISTER_VALUE_LSB       0
#define XAIE2PGBL_CORE_MODULE_CORE_WH3_PART1_REGISTER_VALUE_WIDTH     128
#define XAIE2PGBL_CORE_MODULE_CORE_WH3_PART1_REGISTER_VALUE_MASK      0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WH3_PART1_REGISTER_VALUE_DEFVAL    0x0

#define XAIE2PGBL_CORE_MODULE_CORE_WH3_PART2                            0x000308F0
#define XAIE2PGBL_CORE_MODULE_CORE_WH3_PART2_WIDTH                      128
#define XAIE2PGBL_CORE_MODULE_CORE_WH3_PART2_MASK                       0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WH3_PART2_REGISTER_VALUE_LSB       0
#define XAIE2PGBL_CORE_MODULE_CORE_WH3_PART2_REGISTER_VALUE_WIDTH     128
#define XAIE2PGBL_CORE_MODULE_CORE_WH3_PART2_REGISTER_VALUE_MASK      0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WH3_PART2_REGISTER_VALUE_DEFVAL    0x0

#define XAIE2PGBL_CORE_MODULE_CORE_WL4_PART1                            0x00030900
#define XAIE2PGBL_CORE_MODULE_CORE_WL4_PART1_WIDTH                      128
#define XAIE2PGBL_CORE_MODULE_CORE_WL4_PART1_MASK                       0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WL4_PART1_REGISTER_VALUE_LSB       0
#define XAIE2PGBL_CORE_MODULE_CORE_WL4_PART1_REGISTER_VALUE_WIDTH     128
#define XAIE2PGBL_CORE_MODULE_CORE_WL4_PART1_REGISTER_VALUE_MASK      0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WL4_PART1_REGISTER_VALUE_DEFVAL    0x0

#define XAIE2PGBL_CORE_MODULE_CORE_WL4_PART2                            0x00030910
#define XAIE2PGBL_CORE_MODULE_CORE_WL4_PART2_WIDTH                      128
#define XAIE2PGBL_CORE_MODULE_CORE_WL4_PART2_MASK                       0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WL4_PART2_REGISTER_VALUE_LSB       0
#define XAIE2PGBL_CORE_MODULE_CORE_WL4_PART2_REGISTER_VALUE_WIDTH     128
#define XAIE2PGBL_CORE_MODULE_CORE_WL4_PART2_REGISTER_VALUE_MASK      0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WL4_PART2_REGISTER_VALUE_DEFVAL    0x0

#define XAIE2PGBL_CORE_MODULE_CORE_WH4_PART1                            0x00030920
#define XAIE2PGBL_CORE_MODULE_CORE_WH4_PART1_WIDTH                      128
#define XAIE2PGBL_CORE_MODULE_CORE_WH4_PART1_MASK                       0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WH4_PART1_REGISTER_VALUE_LSB       0
#define XAIE2PGBL_CORE_MODULE_CORE_WH4_PART1_REGISTER_VALUE_WIDTH     128
#define XAIE2PGBL_CORE_MODULE_CORE_WH4_PART1_REGISTER_VALUE_MASK      0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WH4_PART1_REGISTER_VALUE_DEFVAL    0x0

#define XAIE2PGBL_CORE_MODULE_CORE_WH4_PART2                            0x00030930
#define XAIE2PGBL_CORE_MODULE_CORE_WH4_PART2_WIDTH                      128
#define XAIE2PGBL_CORE_MODULE_CORE_WH4_PART2_MASK                       0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WH4_PART2_REGISTER_VALUE_LSB       0
#define XAIE2PGBL_CORE_MODULE_CORE_WH4_PART2_REGISTER_VALUE_WIDTH     128
#define XAIE2PGBL_CORE_MODULE_CORE_WH4_PART2_REGISTER_VALUE_MASK      0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WH4_PART2_REGISTER_VALUE_DEFVAL    0x0

#define XAIE2PGBL_CORE_MODULE_CORE_WL5_PART1                            0x00030940
#define XAIE2PGBL_CORE_MODULE_CORE_WL5_PART1_WIDTH                      128
#define XAIE2PGBL_CORE_MODULE_CORE_WL5_PART1_MASK                       0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WL5_PART1_REGISTER_VALUE_LSB       0
#define XAIE2PGBL_CORE_MODULE_CORE_WL5_PART1_REGISTER_VALUE_WIDTH     128
#define XAIE2PGBL_CORE_MODULE_CORE_WL5_PART1_REGISTER_VALUE_MASK      0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WL5_PART1_REGISTER_VALUE_DEFVAL    0x0

#define XAIE2PGBL_CORE_MODULE_CORE_WL5_PART2                            0x00030950
#define XAIE2PGBL_CORE_MODULE_CORE_WL5_PART2_WIDTH                      128
#define XAIE2PGBL_CORE_MODULE_CORE_WL5_PART2_MASK                       0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WL5_PART2_REGISTER_VALUE_LSB       0
#define XAIE2PGBL_CORE_MODULE_CORE_WL5_PART2_REGISTER_VALUE_WIDTH     128
#define XAIE2PGBL_CORE_MODULE_CORE_WL5_PART2_REGISTER_VALUE_MASK      0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WL5_PART2_REGISTER_VALUE_DEFVAL    0x0

#define XAIE2PGBL_CORE_MODULE_CORE_WH5_PART1                            0x00030960
#define XAIE2PGBL_CORE_MODULE_CORE_WH5_PART1_WIDTH                      128
#define XAIE2PGBL_CORE_MODULE_CORE_WH5_PART1_MASK                       0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WH5_PART1_REGISTER_VALUE_LSB       0
#define XAIE2PGBL_CORE_MODULE_CORE_WH5_PART1_REGISTER_VALUE_WIDTH     128
#define XAIE2PGBL_CORE_MODULE_CORE_WH5_PART1_REGISTER_VALUE_MASK      0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WH5_PART1_REGISTER_VALUE_DEFVAL    0x0

#define XAIE2PGBL_CORE_MODULE_CORE_WH5_PART2                            0x00030970
#define XAIE2PGBL_CORE_MODULE_CORE_WH5_PART2_WIDTH                      128
#define XAIE2PGBL_CORE_MODULE_CORE_WH5_PART2_MASK                       0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WH5_PART2_REGISTER_VALUE_LSB       0
#define XAIE2PGBL_CORE_MODULE_CORE_WH5_PART2_REGISTER_VALUE_WIDTH     128
#define XAIE2PGBL_CORE_MODULE_CORE_WH5_PART2_REGISTER_VALUE_MASK      0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WH5_PART2_REGISTER_VALUE_DEFVAL    0x0

#define XAIE2PGBL_CORE_MODULE_CORE_WL6_PART1                            0x00030980
#define XAIE2PGBL_CORE_MODULE_CORE_WL6_PART1_WIDTH                      128
#define XAIE2PGBL_CORE_MODULE_CORE_WL6_PART1_MASK                       0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WL6_PART1_REGISTER_VALUE_LSB       0
#define XAIE2PGBL_CORE_MODULE_CORE_WL6_PART1_REGISTER_VALUE_WIDTH     128
#define XAIE2PGBL_CORE_MODULE_CORE_WL6_PART1_REGISTER_VALUE_MASK      0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WL6_PART1_REGISTER_VALUE_DEFVAL    0x0

#define XAIE2PGBL_CORE_MODULE_CORE_WL6_PART2                            0x00030990
#define XAIE2PGBL_CORE_MODULE_CORE_WL6_PART2_WIDTH                      128
#define XAIE2PGBL_CORE_MODULE_CORE_WL6_PART2_MASK                       0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WL6_PART2_REGISTER_VALUE_LSB       0
#define XAIE2PGBL_CORE_MODULE_CORE_WL6_PART2_REGISTER_VALUE_WIDTH     128
#define XAIE2PGBL_CORE_MODULE_CORE_WL6_PART2_REGISTER_VALUE_MASK      0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WL6_PART2_REGISTER_VALUE_DEFVAL    0x0

#define XAIE2PGBL_CORE_MODULE_CORE_WH6_PART1                            0x000309A0
#define XAIE2PGBL_CORE_MODULE_CORE_WH6_PART1_WIDTH                      128
#define XAIE2PGBL_CORE_MODULE_CORE_WH6_PART1_MASK                       0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WH6_PART1_REGISTER_VALUE_LSB       0
#define XAIE2PGBL_CORE_MODULE_CORE_WH6_PART1_REGISTER_VALUE_WIDTH     128
#define XAIE2PGBL_CORE_MODULE_CORE_WH6_PART1_REGISTER_VALUE_MASK      0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WH6_PART1_REGISTER_VALUE_DEFVAL    0x0

#define XAIE2PGBL_CORE_MODULE_CORE_WH6_PART2                            0x000309B0
#define XAIE2PGBL_CORE_MODULE_CORE_WH6_PART2_WIDTH                      128
#define XAIE2PGBL_CORE_MODULE_CORE_WH6_PART2_MASK                       0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WH6_PART2_REGISTER_VALUE_LSB       0
#define XAIE2PGBL_CORE_MODULE_CORE_WH6_PART2_REGISTER_VALUE_WIDTH     128
#define XAIE2PGBL_CORE_MODULE_CORE_WH6_PART2_REGISTER_VALUE_MASK      0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WH6_PART2_REGISTER_VALUE_DEFVAL    0x0

#define XAIE2PGBL_CORE_MODULE_CORE_WL7_PART1                            0x000309C0
#define XAIE2PGBL_CORE_MODULE_CORE_WL7_PART1_WIDTH                      128
#define XAIE2PGBL_CORE_MODULE_CORE_WL7_PART1_MASK                       0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WL7_PART1_REGISTER_VALUE_LSB       0
#define XAIE2PGBL_CORE_MODULE_CORE_WL7_PART1_REGISTER_VALUE_WIDTH     128
#define XAIE2PGBL_CORE_MODULE_CORE_WL7_PART1_REGISTER_VALUE_MASK      0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WL7_PART1_REGISTER_VALUE_DEFVAL    0x0

#define XAIE2PGBL_CORE_MODULE_CORE_WL7_PART2                            0x000309D0
#define XAIE2PGBL_CORE_MODULE_CORE_WL7_PART2_WIDTH                      128
#define XAIE2PGBL_CORE_MODULE_CORE_WL7_PART2_MASK                       0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WL7_PART2_REGISTER_VALUE_LSB       0
#define XAIE2PGBL_CORE_MODULE_CORE_WL7_PART2_REGISTER_VALUE_WIDTH     128
#define XAIE2PGBL_CORE_MODULE_CORE_WL7_PART2_REGISTER_VALUE_MASK      0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WL7_PART2_REGISTER_VALUE_DEFVAL    0x0

#define XAIE2PGBL_CORE_MODULE_CORE_WH7_PART1                            0x000309E0
#define XAIE2PGBL_CORE_MODULE_CORE_WH7_PART1_WIDTH                      128
#define XAIE2PGBL_CORE_MODULE_CORE_WH7_PART1_MASK                       0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WH7_PART1_REGISTER_VALUE_LSB       0
#define XAIE2PGBL_CORE_MODULE_CORE_WH7_PART1_REGISTER_VALUE_WIDTH     128
#define XAIE2PGBL_CORE_MODULE_CORE_WH7_PART1_REGISTER_VALUE_MASK      0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WH7_PART1_REGISTER_VALUE_DEFVAL    0x0

#define XAIE2PGBL_CORE_MODULE_CORE_WH7_PART2                            0x000309F0
#define XAIE2PGBL_CORE_MODULE_CORE_WH7_PART2_WIDTH                      128
#define XAIE2PGBL_CORE_MODULE_CORE_WH7_PART2_MASK                       0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WH7_PART2_REGISTER_VALUE_LSB       0
#define XAIE2PGBL_CORE_MODULE_CORE_WH7_PART2_REGISTER_VALUE_WIDTH     128
#define XAIE2PGBL_CORE_MODULE_CORE_WH7_PART2_REGISTER_VALUE_MASK      0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WH7_PART2_REGISTER_VALUE_DEFVAL    0x0

#define XAIE2PGBL_CORE_MODULE_CORE_WL8_PART1                            0x00030A00
#define XAIE2PGBL_CORE_MODULE_CORE_WL8_PART1_WIDTH                      128
#define XAIE2PGBL_CORE_MODULE_CORE_WL8_PART1_MASK                       0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WL8_PART1_REGISTER_VALUE_LSB       0
#define XAIE2PGBL_CORE_MODULE_CORE_WL8_PART1_REGISTER_VALUE_WIDTH     128
#define XAIE2PGBL_CORE_MODULE_CORE_WL8_PART1_REGISTER_VALUE_MASK      0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WL8_PART1_REGISTER_VALUE_DEFVAL    0x0

#define XAIE2PGBL_CORE_MODULE_CORE_WL8_PART2                            0x00030A10
#define XAIE2PGBL_CORE_MODULE_CORE_WL8_PART2_WIDTH                      128
#define XAIE2PGBL_CORE_MODULE_CORE_WL8_PART2_MASK                       0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WL8_PART2_REGISTER_VALUE_LSB       0
#define XAIE2PGBL_CORE_MODULE_CORE_WL8_PART2_REGISTER_VALUE_WIDTH     128
#define XAIE2PGBL_CORE_MODULE_CORE_WL8_PART2_REGISTER_VALUE_MASK      0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WL8_PART2_REGISTER_VALUE_DEFVAL    0x0

#define XAIE2PGBL_CORE_MODULE_CORE_WH8_PART1                            0x00030A20
#define XAIE2PGBL_CORE_MODULE_CORE_WH8_PART1_WIDTH                      128
#define XAIE2PGBL_CORE_MODULE_CORE_WH8_PART1_MASK                       0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WH8_PART1_REGISTER_VALUE_LSB       0
#define XAIE2PGBL_CORE_MODULE_CORE_WH8_PART1_REGISTER_VALUE_WIDTH     128
#define XAIE2PGBL_CORE_MODULE_CORE_WH8_PART1_REGISTER_VALUE_MASK      0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WH8_PART1_REGISTER_VALUE_DEFVAL    0x0

#define XAIE2PGBL_CORE_MODULE_CORE_WH8_PART2                            0x00030A30
#define XAIE2PGBL_CORE_MODULE_CORE_WH8_PART2_WIDTH                      128
#define XAIE2PGBL_CORE_MODULE_CORE_WH8_PART2_MASK                       0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WH8_PART2_REGISTER_VALUE_LSB       0
#define XAIE2PGBL_CORE_MODULE_CORE_WH8_PART2_REGISTER_VALUE_WIDTH     128
#define XAIE2PGBL_CORE_MODULE_CORE_WH8_PART2_REGISTER_VALUE_MASK      0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WH8_PART2_REGISTER_VALUE_DEFVAL    0x0

#define XAIE2PGBL_CORE_MODULE_CORE_WL9_PART1                            0x00030A40
#define XAIE2PGBL_CORE_MODULE_CORE_WL9_PART1_WIDTH                      128
#define XAIE2PGBL_CORE_MODULE_CORE_WL9_PART1_MASK                       0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WL9_PART1_REGISTER_VALUE_LSB       0
#define XAIE2PGBL_CORE_MODULE_CORE_WL9_PART1_REGISTER_VALUE_WIDTH     128
#define XAIE2PGBL_CORE_MODULE_CORE_WL9_PART1_REGISTER_VALUE_MASK      0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WL9_PART1_REGISTER_VALUE_DEFVAL    0x0

#define XAIE2PGBL_CORE_MODULE_CORE_WL9_PART2                            0x00030A50
#define XAIE2PGBL_CORE_MODULE_CORE_WL9_PART2_WIDTH                      128
#define XAIE2PGBL_CORE_MODULE_CORE_WL9_PART2_MASK                       0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WL9_PART2_REGISTER_VALUE_LSB       0
#define XAIE2PGBL_CORE_MODULE_CORE_WL9_PART2_REGISTER_VALUE_WIDTH     128
#define XAIE2PGBL_CORE_MODULE_CORE_WL9_PART2_REGISTER_VALUE_MASK      0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WL9_PART2_REGISTER_VALUE_DEFVAL    0x0

#define XAIE2PGBL_CORE_MODULE_CORE_WH9_PART1                            0x00030A60
#define XAIE2PGBL_CORE_MODULE_CORE_WH9_PART1_WIDTH                      128
#define XAIE2PGBL_CORE_MODULE_CORE_WH9_PART1_MASK                       0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WH9_PART1_REGISTER_VALUE_LSB       0
#define XAIE2PGBL_CORE_MODULE_CORE_WH9_PART1_REGISTER_VALUE_WIDTH     128
#define XAIE2PGBL_CORE_MODULE_CORE_WH9_PART1_REGISTER_VALUE_MASK      0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WH9_PART1_REGISTER_VALUE_DEFVAL    0x0

#define XAIE2PGBL_CORE_MODULE_CORE_WH9_PART2                            0x00030A70
#define XAIE2PGBL_CORE_MODULE_CORE_WH9_PART2_WIDTH                      128
#define XAIE2PGBL_CORE_MODULE_CORE_WH9_PART2_MASK                       0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WH9_PART2_REGISTER_VALUE_LSB       0
#define XAIE2PGBL_CORE_MODULE_CORE_WH9_PART2_REGISTER_VALUE_WIDTH     128
#define XAIE2PGBL_CORE_MODULE_CORE_WH9_PART2_REGISTER_VALUE_MASK      0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WH9_PART2_REGISTER_VALUE_DEFVAL    0x0

#define XAIE2PGBL_CORE_MODULE_CORE_WL10_PART1                           0x00030A80
#define XAIE2PGBL_CORE_MODULE_CORE_WL10_PART1_WIDTH                     128
#define XAIE2PGBL_CORE_MODULE_CORE_WL10_PART1_MASK                      0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WL10_PART1_REGISTER_VALUE_LSB      0
#define XAIE2PGBL_CORE_MODULE_CORE_WL10_PART1_REGISTER_VALUE_WIDTH    128
#define XAIE2PGBL_CORE_MODULE_CORE_WL10_PART1_REGISTER_VALUE_MASK     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WL10_PART1_REGISTER_VALUE_DEFVAL   0x0

#define XAIE2PGBL_CORE_MODULE_CORE_WL10_PART2                           0x00030A90
#define XAIE2PGBL_CORE_MODULE_CORE_WL10_PART2_WIDTH                     128
#define XAIE2PGBL_CORE_MODULE_CORE_WL10_PART2_MASK                      0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WL10_PART2_REGISTER_VALUE_LSB      0
#define XAIE2PGBL_CORE_MODULE_CORE_WL10_PART2_REGISTER_VALUE_WIDTH    128
#define XAIE2PGBL_CORE_MODULE_CORE_WL10_PART2_REGISTER_VALUE_MASK     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WL10_PART2_REGISTER_VALUE_DEFVAL   0x0

#define XAIE2PGBL_CORE_MODULE_CORE_WH10_PART1                           0x00030AA0
#define XAIE2PGBL_CORE_MODULE_CORE_WH10_PART1_WIDTH                     128
#define XAIE2PGBL_CORE_MODULE_CORE_WH10_PART1_MASK                      0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WH10_PART1_REGISTER_VALUE_LSB      0
#define XAIE2PGBL_CORE_MODULE_CORE_WH10_PART1_REGISTER_VALUE_WIDTH    128
#define XAIE2PGBL_CORE_MODULE_CORE_WH10_PART1_REGISTER_VALUE_MASK     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WH10_PART1_REGISTER_VALUE_DEFVAL   0x0

#define XAIE2PGBL_CORE_MODULE_CORE_WH10_PART2                           0x00030AB0
#define XAIE2PGBL_CORE_MODULE_CORE_WH10_PART2_WIDTH                     128
#define XAIE2PGBL_CORE_MODULE_CORE_WH10_PART2_MASK                      0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WH10_PART2_REGISTER_VALUE_LSB      0
#define XAIE2PGBL_CORE_MODULE_CORE_WH10_PART2_REGISTER_VALUE_WIDTH    128
#define XAIE2PGBL_CORE_MODULE_CORE_WH10_PART2_REGISTER_VALUE_MASK     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WH10_PART2_REGISTER_VALUE_DEFVAL   0x0

#define XAIE2PGBL_CORE_MODULE_CORE_WL11_PART1                           0x00030AC0
#define XAIE2PGBL_CORE_MODULE_CORE_WL11_PART1_WIDTH                     128
#define XAIE2PGBL_CORE_MODULE_CORE_WL11_PART1_MASK                      0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WL11_PART1_REGISTER_VALUE_LSB      0
#define XAIE2PGBL_CORE_MODULE_CORE_WL11_PART1_REGISTER_VALUE_WIDTH    128
#define XAIE2PGBL_CORE_MODULE_CORE_WL11_PART1_REGISTER_VALUE_MASK     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WL11_PART1_REGISTER_VALUE_DEFVAL   0x0

#define XAIE2PGBL_CORE_MODULE_CORE_WL11_PART2                           0x00030AD0
#define XAIE2PGBL_CORE_MODULE_CORE_WL11_PART2_WIDTH                     128
#define XAIE2PGBL_CORE_MODULE_CORE_WL11_PART2_MASK                      0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WL11_PART2_REGISTER_VALUE_LSB      0
#define XAIE2PGBL_CORE_MODULE_CORE_WL11_PART2_REGISTER_VALUE_WIDTH    128
#define XAIE2PGBL_CORE_MODULE_CORE_WL11_PART2_REGISTER_VALUE_MASK     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WL11_PART2_REGISTER_VALUE_DEFVAL   0x0

#define XAIE2PGBL_CORE_MODULE_CORE_WH11_PART1                           0x00030AE0
#define XAIE2PGBL_CORE_MODULE_CORE_WH11_PART1_WIDTH                     128
#define XAIE2PGBL_CORE_MODULE_CORE_WH11_PART1_MASK                      0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WH11_PART1_REGISTER_VALUE_LSB      0
#define XAIE2PGBL_CORE_MODULE_CORE_WH11_PART1_REGISTER_VALUE_WIDTH    128
#define XAIE2PGBL_CORE_MODULE_CORE_WH11_PART1_REGISTER_VALUE_MASK     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WH11_PART1_REGISTER_VALUE_DEFVAL   0x0

#define XAIE2PGBL_CORE_MODULE_CORE_WH11_PART2                           0x00030AF0
#define XAIE2PGBL_CORE_MODULE_CORE_WH11_PART2_WIDTH                     128
#define XAIE2PGBL_CORE_MODULE_CORE_WH11_PART2_MASK                      0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WH11_PART2_REGISTER_VALUE_LSB      0
#define XAIE2PGBL_CORE_MODULE_CORE_WH11_PART2_REGISTER_VALUE_WIDTH    128
#define XAIE2PGBL_CORE_MODULE_CORE_WH11_PART2_REGISTER_VALUE_MASK     0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_WH11_PART2_REGISTER_VALUE_DEFVAL   0x0

#define XAIE2PGBL_CORE_MODULE_CORE_Q0                                   0x00030C00
#define XAIE2PGBL_CORE_MODULE_CORE_Q0_WIDTH                             128
#define XAIE2PGBL_CORE_MODULE_CORE_Q0_MASK                              0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_Q0_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_Q0_REGISTER_VALUE_WIDTH            128
#define XAIE2PGBL_CORE_MODULE_CORE_Q0_REGISTER_VALUE_MASK             0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_Q0_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_CORE_Q1                                   0x00030C10
#define XAIE2PGBL_CORE_MODULE_CORE_Q1_WIDTH                             128
#define XAIE2PGBL_CORE_MODULE_CORE_Q1_MASK                              0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_Q1_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_Q1_REGISTER_VALUE_WIDTH            128
#define XAIE2PGBL_CORE_MODULE_CORE_Q1_REGISTER_VALUE_MASK             0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_Q1_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_CORE_Q2                                   0x00030C20
#define XAIE2PGBL_CORE_MODULE_CORE_Q2_WIDTH                             128
#define XAIE2PGBL_CORE_MODULE_CORE_Q2_MASK                              0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_Q2_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_Q2_REGISTER_VALUE_WIDTH            128
#define XAIE2PGBL_CORE_MODULE_CORE_Q2_REGISTER_VALUE_MASK             0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_Q2_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_CORE_Q3                                   0x00030C30
#define XAIE2PGBL_CORE_MODULE_CORE_Q3_WIDTH                             128
#define XAIE2PGBL_CORE_MODULE_CORE_Q3_MASK                              0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_Q3_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_Q3_REGISTER_VALUE_WIDTH            128
#define XAIE2PGBL_CORE_MODULE_CORE_Q3_REGISTER_VALUE_MASK             0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_Q3_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_CORE_E0                                   0x00030D00
#define XAIE2PGBL_CORE_MODULE_CORE_E0_WIDTH                             64
#define XAIE2PGBL_CORE_MODULE_CORE_E0_MASK                              0xFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_E0_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_E0_REGISTER_VALUE_WIDTH            64
#define XAIE2PGBL_CORE_MODULE_CORE_E0_REGISTER_VALUE_MASK             0xFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_E0_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_CORE_E1                                   0x00030D10
#define XAIE2PGBL_CORE_MODULE_CORE_E1_WIDTH                             64
#define XAIE2PGBL_CORE_MODULE_CORE_E1_MASK                              0xFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_E1_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_E1_REGISTER_VALUE_WIDTH            64
#define XAIE2PGBL_CORE_MODULE_CORE_E1_REGISTER_VALUE_MASK             0xFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_E1_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_CORE_E2                                   0x00030D20
#define XAIE2PGBL_CORE_MODULE_CORE_E2_WIDTH                             64
#define XAIE2PGBL_CORE_MODULE_CORE_E2_MASK                              0xFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_E2_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_E2_REGISTER_VALUE_WIDTH            64
#define XAIE2PGBL_CORE_MODULE_CORE_E2_REGISTER_VALUE_MASK             0xFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_E2_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_CORE_E3                                   0x00030D30
#define XAIE2PGBL_CORE_MODULE_CORE_E3_WIDTH                             64
#define XAIE2PGBL_CORE_MODULE_CORE_E3_MASK                              0xFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_E3_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_E3_REGISTER_VALUE_WIDTH            64
#define XAIE2PGBL_CORE_MODULE_CORE_E3_REGISTER_VALUE_MASK             0xFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_E3_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_CORE_E4                                   0x00030D40
#define XAIE2PGBL_CORE_MODULE_CORE_E4_WIDTH                             64
#define XAIE2PGBL_CORE_MODULE_CORE_E4_MASK                              0xFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_E4_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_E4_REGISTER_VALUE_WIDTH            64
#define XAIE2PGBL_CORE_MODULE_CORE_E4_REGISTER_VALUE_MASK             0xFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_E4_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_CORE_E5                                   0x00030D50
#define XAIE2PGBL_CORE_MODULE_CORE_E5_WIDTH                             64
#define XAIE2PGBL_CORE_MODULE_CORE_E5_MASK                              0xFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_E5_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_E5_REGISTER_VALUE_WIDTH            64
#define XAIE2PGBL_CORE_MODULE_CORE_E5_REGISTER_VALUE_MASK             0xFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_E5_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_CORE_E6                                   0x00030D60
#define XAIE2PGBL_CORE_MODULE_CORE_E6_WIDTH                             64
#define XAIE2PGBL_CORE_MODULE_CORE_E6_MASK                              0xFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_E6_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_E6_REGISTER_VALUE_WIDTH            64
#define XAIE2PGBL_CORE_MODULE_CORE_E6_REGISTER_VALUE_MASK             0xFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_E6_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_CORE_E7                                   0x00030D70
#define XAIE2PGBL_CORE_MODULE_CORE_E7_WIDTH                             64
#define XAIE2PGBL_CORE_MODULE_CORE_E7_MASK                              0xFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_E7_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_E7_REGISTER_VALUE_WIDTH            64
#define XAIE2PGBL_CORE_MODULE_CORE_E7_REGISTER_VALUE_MASK             0xFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_E7_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_CORE_E8                                   0x00030D80
#define XAIE2PGBL_CORE_MODULE_CORE_E8_WIDTH                             64
#define XAIE2PGBL_CORE_MODULE_CORE_E8_MASK                              0xFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_E8_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_E8_REGISTER_VALUE_WIDTH            64
#define XAIE2PGBL_CORE_MODULE_CORE_E8_REGISTER_VALUE_MASK             0xFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_E8_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_CORE_E9                                   0x00030D90
#define XAIE2PGBL_CORE_MODULE_CORE_E9_WIDTH                             64
#define XAIE2PGBL_CORE_MODULE_CORE_E9_MASK                              0xFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_E9_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_E9_REGISTER_VALUE_WIDTH            64
#define XAIE2PGBL_CORE_MODULE_CORE_E9_REGISTER_VALUE_MASK             0xFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_E9_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_CORE_E10                                  0x00030DA0
#define XAIE2PGBL_CORE_MODULE_CORE_E10_WIDTH                            64
#define XAIE2PGBL_CORE_MODULE_CORE_E10_MASK                             0xFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_E10_REGISTER_VALUE_LSB             0
#define XAIE2PGBL_CORE_MODULE_CORE_E10_REGISTER_VALUE_WIDTH           64
#define XAIE2PGBL_CORE_MODULE_CORE_E10_REGISTER_VALUE_MASK            0xFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_E10_REGISTER_VALUE_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_CORE_E11                                  0x00030DB0
#define XAIE2PGBL_CORE_MODULE_CORE_E11_WIDTH                            64
#define XAIE2PGBL_CORE_MODULE_CORE_E11_MASK                             0xFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_E11_REGISTER_VALUE_LSB             0
#define XAIE2PGBL_CORE_MODULE_CORE_E11_REGISTER_VALUE_WIDTH           64
#define XAIE2PGBL_CORE_MODULE_CORE_E11_REGISTER_VALUE_MASK            0xFFFFFFFFFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_E11_REGISTER_VALUE_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_CORE_PC                                   0x00030E00
#define XAIE2PGBL_CORE_MODULE_CORE_PC_WIDTH                             32
#define XAIE2PGBL_CORE_MODULE_CORE_PC_MASK                              0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_PC_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_PC_REGISTER_VALUE_WIDTH            20
#define XAIE2PGBL_CORE_MODULE_CORE_PC_REGISTER_VALUE_MASK             0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_PC_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_CORE_FC                                   0x00030E10
#define XAIE2PGBL_CORE_MODULE_CORE_FC_WIDTH                             32
#define XAIE2PGBL_CORE_MODULE_CORE_FC_MASK                              0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_FC_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_FC_REGISTER_VALUE_WIDTH            20
#define XAIE2PGBL_CORE_MODULE_CORE_FC_REGISTER_VALUE_MASK             0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_FC_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_CORE_SP                                   0x00030E20
#define XAIE2PGBL_CORE_MODULE_CORE_SP_WIDTH                             32
#define XAIE2PGBL_CORE_MODULE_CORE_SP_MASK                              0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_SP_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_SP_REGISTER_VALUE_WIDTH            20
#define XAIE2PGBL_CORE_MODULE_CORE_SP_REGISTER_VALUE_MASK             0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_SP_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_CORE_LR                                   0x00030E30
#define XAIE2PGBL_CORE_MODULE_CORE_LR_WIDTH                             32
#define XAIE2PGBL_CORE_MODULE_CORE_LR_MASK                              0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_LR_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_LR_REGISTER_VALUE_WIDTH            20
#define XAIE2PGBL_CORE_MODULE_CORE_LR_REGISTER_VALUE_MASK             0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_LR_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_CORE_LS                                   0x00030E40
#define XAIE2PGBL_CORE_MODULE_CORE_LS_WIDTH                             32
#define XAIE2PGBL_CORE_MODULE_CORE_LS_MASK                              0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_LS_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_LS_REGISTER_VALUE_WIDTH            20
#define XAIE2PGBL_CORE_MODULE_CORE_LS_REGISTER_VALUE_MASK             0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_LS_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_CORE_LE                                   0x00030E50
#define XAIE2PGBL_CORE_MODULE_CORE_LE_WIDTH                             32
#define XAIE2PGBL_CORE_MODULE_CORE_LE_MASK                              0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_LE_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_LE_REGISTER_VALUE_WIDTH            20
#define XAIE2PGBL_CORE_MODULE_CORE_LE_REGISTER_VALUE_MASK             0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_LE_REGISTER_VALUE_DEFVAL           0xFFFFF

#define XAIE2PGBL_CORE_MODULE_CORE_LC                                   0x00030E60
#define XAIE2PGBL_CORE_MODULE_CORE_LC_WIDTH                             32
#define XAIE2PGBL_CORE_MODULE_CORE_LC_MASK                              0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_LC_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_LC_REGISTER_VALUE_WIDTH            32
#define XAIE2PGBL_CORE_MODULE_CORE_LC_REGISTER_VALUE_MASK             0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_LC_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_CORE_CR1                                  0x00030E70
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_WIDTH                            32
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_MASK                             0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_PACKSIZE_LSB                   31
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_PACKSIZE_WIDTH                 1
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_PACKSIZE_MASK                  0x80000000
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_PACKSIZE_DEFVAL                0x0
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_UPS_MODE_LSB                   30
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_UPS_MODE_WIDTH                 1
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_UPS_MODE_MASK                  0x40000000
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_UPS_MODE_DEFVAL                0x0
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_SRS_MODE_LSB                   29
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_SRS_MODE_WIDTH                 1
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_SRS_MODE_MASK                  0x20000000
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_SRS_MODE_DEFVAL                0x0
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_UNPACKSIZE_LSB                 28
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_UNPACKSIZE_WIDTH               1
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_UNPACKSIZE_MASK                0x10000000
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_UNPACKSIZE_DEFVAL              0x0
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_FLOAT_TO_BFLOAT_HUGE_MASK_LSB  27
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_FLOAT_TO_BFLOAT_HUGE_MASK_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_FLOAT_TO_BFLOAT_HUGE_MASK_MASK 0x08000000
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_FLOAT_TO_BFLOAT_HUGE_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_FLOAT_TO_BFLOAT_TINY_MASK_LSB  26
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_FLOAT_TO_BFLOAT_TINY_MASK_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_FLOAT_TO_BFLOAT_TINY_MASK_MASK 0x04000000
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_FLOAT_TO_BFLOAT_TINY_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_FLOAT_TO_BFLOAT_INVALID_MASK_LSB 25
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_FLOAT_TO_BFLOAT_INVALID_MASK_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_FLOAT_TO_BFLOAT_INVALID_MASK_MASK 0x02000000
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_FLOAT_TO_BFLOAT_INVALID_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_FLOAT_TO_BFLOAT_INFINITY_MASK_LSB 24
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_FLOAT_TO_BFLOAT_INFINITY_MASK_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_FLOAT_TO_BFLOAT_INFINITY_MASK_MASK 0x01000000
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_FLOAT_TO_BFLOAT_INFINITY_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_FLOAT_TO_BFLOAT_ZERO_MASK_LSB  23
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_FLOAT_TO_BFLOAT_ZERO_MASK_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_FLOAT_TO_BFLOAT_ZERO_MASK_MASK 0x00800000
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_FLOAT_TO_BFLOAT_ZERO_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_BFLOAT_TO_INT_HUGE_MASK_LSB    22
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_BFLOAT_TO_INT_HUGE_MASK_WIDTH  1
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_BFLOAT_TO_INT_HUGE_MASK_MASK   0x00400000
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_BFLOAT_TO_INT_HUGE_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_BFLOAT_TO_INT_TINY_MASK_LSB    21
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_BFLOAT_TO_INT_TINY_MASK_WIDTH  1
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_BFLOAT_TO_INT_TINY_MASK_MASK   0x00200000
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_BFLOAT_TO_INT_TINY_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_BFLOAT_TO_INT_INVALID_MASK_LSB 20
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_BFLOAT_TO_INT_INVALID_MASK_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_BFLOAT_TO_INT_INVALID_MASK_MASK 0x00100000
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_BFLOAT_TO_INT_INVALID_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_BFLOAT_TO_INT_ZERO_MASK_LSB    18
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_BFLOAT_TO_INT_ZERO_MASK_WIDTH  1
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_BFLOAT_TO_INT_ZERO_MASK_MASK   0x00040000
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_BFLOAT_TO_INT_ZERO_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_SCD_ENABLE_LSB                 12
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_SCD_ENABLE_WIDTH               1
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_SCD_ENABLE_MASK                0x00001000
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_SCD_ENABLE_DEFVAL              0x1
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_MCD_ENABLE_LSB                 11
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_MCD_ENABLE_WIDTH               1
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_MCD_ENABLE_MASK                0x00000800
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_MCD_ENABLE_DEFVAL              0x1
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_FLOAT_MAC_HUGE_MASK_LSB        10
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_FLOAT_MAC_HUGE_MASK_WIDTH      1
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_FLOAT_MAC_HUGE_MASK_MASK       0x00000400
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_FLOAT_MAC_HUGE_MASK_DEFVAL     0x0
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_FLOAT_MAC_TINY_MASK_LSB        9
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_FLOAT_MAC_TINY_MASK_WIDTH      1
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_FLOAT_MAC_TINY_MASK_MASK       0x00000200
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_FLOAT_MAC_TINY_MASK_DEFVAL     0x0
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_FLOAT_MAC_INVALID_MASK_LSB     8
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_FLOAT_MAC_INVALID_MASK_WIDTH   1
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_FLOAT_MAC_INVALID_MASK_MASK    0x00000100
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_FLOAT_MAC_INVALID_MASK_DEFVAL  0x0
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_FLOAT_MAC_INFINITY_MASK_LSB    7
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_FLOAT_MAC_INFINITY_MASK_WIDTH  1
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_FLOAT_MAC_INFINITY_MASK_MASK   0x00000080
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_FLOAT_MAC_INFINITY_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_FLOAT_MAC_ZERO_MASK_LSB        6
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_FLOAT_MAC_ZERO_MASK_WIDTH      1
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_FLOAT_MAC_ZERO_MASK_MASK       0x00000040
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_FLOAT_MAC_ZERO_MASK_DEFVAL     0x0
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_ROUND_MODE_LSB                 2
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_ROUND_MODE_WIDTH               4
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_ROUND_MODE_MASK                0x0000003C
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_ROUND_MODE_DEFVAL              0x0
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_SATURATION_MODE_LSB            0
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_SATURATION_MODE_WIDTH          2
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_SATURATION_MODE_MASK           0x00000003
#define XAIE2PGBL_CORE_MODULE_CORE_CR1_SATURATION_MODE_DEFVAL         0x0

#define XAIE2PGBL_CORE_MODULE_CORE_CR2                                  0x00030E80
#define XAIE2PGBL_CORE_MODULE_CORE_CR2_WIDTH                            32
#define XAIE2PGBL_CORE_MODULE_CORE_CR2_MASK                             0x000003FF
#define XAIE2PGBL_CORE_MODULE_CORE_CR2_SRS_SIGN1_LSB                  9
#define XAIE2PGBL_CORE_MODULE_CORE_CR2_SRS_SIGN1_WIDTH                1
#define XAIE2PGBL_CORE_MODULE_CORE_CR2_SRS_SIGN1_MASK                 0x00000200
#define XAIE2PGBL_CORE_MODULE_CORE_CR2_SRS_SIGN1_DEFVAL               0x1
#define XAIE2PGBL_CORE_MODULE_CORE_CR2_SRS_SIGN0_LSB                  8
#define XAIE2PGBL_CORE_MODULE_CORE_CR2_SRS_SIGN0_WIDTH                1
#define XAIE2PGBL_CORE_MODULE_CORE_CR2_SRS_SIGN0_MASK                 0x00000100
#define XAIE2PGBL_CORE_MODULE_CORE_CR2_SRS_SIGN0_DEFVAL               0x0
#define XAIE2PGBL_CORE_MODULE_CORE_CR2_UPS_SIGN1_LSB                  7
#define XAIE2PGBL_CORE_MODULE_CORE_CR2_UPS_SIGN1_WIDTH                1
#define XAIE2PGBL_CORE_MODULE_CORE_CR2_UPS_SIGN1_MASK                 0x00000080
#define XAIE2PGBL_CORE_MODULE_CORE_CR2_UPS_SIGN1_DEFVAL               0x1
#define XAIE2PGBL_CORE_MODULE_CORE_CR2_UPS_SIGN0_LSB                  6
#define XAIE2PGBL_CORE_MODULE_CORE_CR2_UPS_SIGN0_WIDTH                1
#define XAIE2PGBL_CORE_MODULE_CORE_CR2_UPS_SIGN0_MASK                 0x00000040
#define XAIE2PGBL_CORE_MODULE_CORE_CR2_UPS_SIGN0_DEFVAL               0x0
#define XAIE2PGBL_CORE_MODULE_CORE_CR2_PACK_SIGN1_LSB                 5
#define XAIE2PGBL_CORE_MODULE_CORE_CR2_PACK_SIGN1_WIDTH               1
#define XAIE2PGBL_CORE_MODULE_CORE_CR2_PACK_SIGN1_MASK                0x00000020
#define XAIE2PGBL_CORE_MODULE_CORE_CR2_PACK_SIGN1_DEFVAL              0x1
#define XAIE2PGBL_CORE_MODULE_CORE_CR2_PACK_SIGN0_LSB                 4
#define XAIE2PGBL_CORE_MODULE_CORE_CR2_PACK_SIGN0_WIDTH               1
#define XAIE2PGBL_CORE_MODULE_CORE_CR2_PACK_SIGN0_MASK                0x00000010
#define XAIE2PGBL_CORE_MODULE_CORE_CR2_PACK_SIGN0_DEFVAL              0x0
#define XAIE2PGBL_CORE_MODULE_CORE_CR2_UNPACK_SIGN1_LSB               3
#define XAIE2PGBL_CORE_MODULE_CORE_CR2_UNPACK_SIGN1_WIDTH             1
#define XAIE2PGBL_CORE_MODULE_CORE_CR2_UNPACK_SIGN1_MASK              0x00000008
#define XAIE2PGBL_CORE_MODULE_CORE_CR2_UNPACK_SIGN1_DEFVAL            0x1
#define XAIE2PGBL_CORE_MODULE_CORE_CR2_UNPACK_SIGN0_LSB               2
#define XAIE2PGBL_CORE_MODULE_CORE_CR2_UNPACK_SIGN0_WIDTH             1
#define XAIE2PGBL_CORE_MODULE_CORE_CR2_UNPACK_SIGN0_MASK              0x00000004
#define XAIE2PGBL_CORE_MODULE_CORE_CR2_UNPACK_SIGN0_DEFVAL            0x0
#define XAIE2PGBL_CORE_MODULE_CORE_CR2_VADD_SIGN1_LSB                 1
#define XAIE2PGBL_CORE_MODULE_CORE_CR2_VADD_SIGN1_WIDTH               1
#define XAIE2PGBL_CORE_MODULE_CORE_CR2_VADD_SIGN1_MASK                0x00000002
#define XAIE2PGBL_CORE_MODULE_CORE_CR2_VADD_SIGN1_DEFVAL              0x1
#define XAIE2PGBL_CORE_MODULE_CORE_CR2_VADD_SIGN0_LSB                 0
#define XAIE2PGBL_CORE_MODULE_CORE_CR2_VADD_SIGN0_WIDTH               1
#define XAIE2PGBL_CORE_MODULE_CORE_CR2_VADD_SIGN0_MASK                0x00000001
#define XAIE2PGBL_CORE_MODULE_CORE_CR2_VADD_SIGN0_DEFVAL              0x0

#define XAIE2PGBL_CORE_MODULE_CORE_SR                                   0x00030E90
#define XAIE2PGBL_CORE_MODULE_CORE_SR_WIDTH                             32
#define XAIE2PGBL_CORE_MODULE_CORE_SR_MASK                              0x01FFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_SR_FIFO_UNDERFLOW_LSB              24
#define XAIE2PGBL_CORE_MODULE_CORE_SR_FIFO_UNDERFLOW_WIDTH            1
#define XAIE2PGBL_CORE_MODULE_CORE_SR_FIFO_UNDERFLOW_MASK             0x01000000
#define XAIE2PGBL_CORE_MODULE_CORE_SR_FIFO_UNDERFLOW_DEFVAL           0x0
#define XAIE2PGBL_CORE_MODULE_CORE_SR_FIFO_OVERFLOW_LSB               23
#define XAIE2PGBL_CORE_MODULE_CORE_SR_FIFO_OVERFLOW_WIDTH             1
#define XAIE2PGBL_CORE_MODULE_CORE_SR_FIFO_OVERFLOW_MASK              0x00800000
#define XAIE2PGBL_CORE_MODULE_CORE_SR_FIFO_OVERFLOW_DEFVAL            0x0
#define XAIE2PGBL_CORE_MODULE_CORE_SR_SPARSE_OVERFLOW_LSB             22
#define XAIE2PGBL_CORE_MODULE_CORE_SR_SPARSE_OVERFLOW_WIDTH           1
#define XAIE2PGBL_CORE_MODULE_CORE_SR_SPARSE_OVERFLOW_MASK            0x00400000
#define XAIE2PGBL_CORE_MODULE_CORE_SR_SPARSE_OVERFLOW_DEFVAL          0x0
#define XAIE2PGBL_CORE_MODULE_CORE_SR_FLOAT_TO_BFLOAT_HUGE_FLAG_LSB   21
#define XAIE2PGBL_CORE_MODULE_CORE_SR_FLOAT_TO_BFLOAT_HUGE_FLAG_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_CORE_SR_FLOAT_TO_BFLOAT_HUGE_FLAG_MASK  0x00200000
#define XAIE2PGBL_CORE_MODULE_CORE_SR_FLOAT_TO_BFLOAT_HUGE_FLAG_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_CORE_SR_FLOAT_TO_BFLOAT_TINY_FLAG_LSB   20
#define XAIE2PGBL_CORE_MODULE_CORE_SR_FLOAT_TO_BFLOAT_TINY_FLAG_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_CORE_SR_FLOAT_TO_BFLOAT_TINY_FLAG_MASK  0x00100000
#define XAIE2PGBL_CORE_MODULE_CORE_SR_FLOAT_TO_BFLOAT_TINY_FLAG_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_CORE_SR_FLOAT_TO_BFLOAT_INVALID_FLAG_LSB 19
#define XAIE2PGBL_CORE_MODULE_CORE_SR_FLOAT_TO_BFLOAT_INVALID_FLAG_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_CORE_SR_FLOAT_TO_BFLOAT_INVALID_FLAG_MASK 0x00080000
#define XAIE2PGBL_CORE_MODULE_CORE_SR_FLOAT_TO_BFLOAT_INVALID_FLAG_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_CORE_SR_FLOAT_TO_BFLOAT_INFINITY_FLAG_LSB 18
#define XAIE2PGBL_CORE_MODULE_CORE_SR_FLOAT_TO_BFLOAT_INFINITY_FLAG_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_CORE_SR_FLOAT_TO_BFLOAT_INFINITY_FLAG_MASK 0x00040000
#define XAIE2PGBL_CORE_MODULE_CORE_SR_FLOAT_TO_BFLOAT_INFINITY_FLAG_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_CORE_SR_FLOAT_TO_BFLOAT_ZERO_FLAG_LSB   17
#define XAIE2PGBL_CORE_MODULE_CORE_SR_FLOAT_TO_BFLOAT_ZERO_FLAG_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_CORE_SR_FLOAT_TO_BFLOAT_ZERO_FLAG_MASK  0x00020000
#define XAIE2PGBL_CORE_MODULE_CORE_SR_FLOAT_TO_BFLOAT_ZERO_FLAG_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_CORE_SR_BFLOAT_TO_INT_HUGE_FLAG_LSB     16
#define XAIE2PGBL_CORE_MODULE_CORE_SR_BFLOAT_TO_INT_HUGE_FLAG_WIDTH   1
#define XAIE2PGBL_CORE_MODULE_CORE_SR_BFLOAT_TO_INT_HUGE_FLAG_MASK    0x00010000
#define XAIE2PGBL_CORE_MODULE_CORE_SR_BFLOAT_TO_INT_HUGE_FLAG_DEFVAL  0x0
#define XAIE2PGBL_CORE_MODULE_CORE_SR_BFLOAT_TO_INT_TINY_FLAG_LSB     15
#define XAIE2PGBL_CORE_MODULE_CORE_SR_BFLOAT_TO_INT_TINY_FLAG_WIDTH   1
#define XAIE2PGBL_CORE_MODULE_CORE_SR_BFLOAT_TO_INT_TINY_FLAG_MASK    0x00008000
#define XAIE2PGBL_CORE_MODULE_CORE_SR_BFLOAT_TO_INT_TINY_FLAG_DEFVAL  0x0
#define XAIE2PGBL_CORE_MODULE_CORE_SR_BFLOAT_TO_INT_INVALID_FLAG_LSB  14
#define XAIE2PGBL_CORE_MODULE_CORE_SR_BFLOAT_TO_INT_INVALID_FLAG_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_CORE_SR_BFLOAT_TO_INT_INVALID_FLAG_MASK 0x00004000
#define XAIE2PGBL_CORE_MODULE_CORE_SR_BFLOAT_TO_INT_INVALID_FLAG_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_CORE_SR_BFLOAT_TO_INT_ZERO_FLAG_LSB     12
#define XAIE2PGBL_CORE_MODULE_CORE_SR_BFLOAT_TO_INT_ZERO_FLAG_WIDTH   1
#define XAIE2PGBL_CORE_MODULE_CORE_SR_BFLOAT_TO_INT_ZERO_FLAG_MASK    0x00001000
#define XAIE2PGBL_CORE_MODULE_CORE_SR_BFLOAT_TO_INT_ZERO_FLAG_DEFVAL  0x0
#define XAIE2PGBL_CORE_MODULE_CORE_SR_FLOAT_MAC_HUGE_FLAG_LSB         11
#define XAIE2PGBL_CORE_MODULE_CORE_SR_FLOAT_MAC_HUGE_FLAG_WIDTH       1
#define XAIE2PGBL_CORE_MODULE_CORE_SR_FLOAT_MAC_HUGE_FLAG_MASK        0x00000800
#define XAIE2PGBL_CORE_MODULE_CORE_SR_FLOAT_MAC_HUGE_FLAG_DEFVAL      0x0
#define XAIE2PGBL_CORE_MODULE_CORE_SR_FLOAT_MAC_TINY_FLAG_LSB         10
#define XAIE2PGBL_CORE_MODULE_CORE_SR_FLOAT_MAC_TINY_FLAG_WIDTH       1
#define XAIE2PGBL_CORE_MODULE_CORE_SR_FLOAT_MAC_TINY_FLAG_MASK        0x00000400
#define XAIE2PGBL_CORE_MODULE_CORE_SR_FLOAT_MAC_TINY_FLAG_DEFVAL      0x0
#define XAIE2PGBL_CORE_MODULE_CORE_SR_FLOAT_MAC_INVALID_FLAG_LSB      9
#define XAIE2PGBL_CORE_MODULE_CORE_SR_FLOAT_MAC_INVALID_FLAG_WIDTH    1
#define XAIE2PGBL_CORE_MODULE_CORE_SR_FLOAT_MAC_INVALID_FLAG_MASK     0x00000200
#define XAIE2PGBL_CORE_MODULE_CORE_SR_FLOAT_MAC_INVALID_FLAG_DEFVAL   0x0
#define XAIE2PGBL_CORE_MODULE_CORE_SR_FLOAT_MAC_INFINITY_FLAG_LSB     8
#define XAIE2PGBL_CORE_MODULE_CORE_SR_FLOAT_MAC_INFINITY_FLAG_WIDTH   1
#define XAIE2PGBL_CORE_MODULE_CORE_SR_FLOAT_MAC_INFINITY_FLAG_MASK    0x00000100
#define XAIE2PGBL_CORE_MODULE_CORE_SR_FLOAT_MAC_INFINITY_FLAG_DEFVAL  0x0
#define XAIE2PGBL_CORE_MODULE_CORE_SR_FLOAT_MAC_ZERO_FLAG_LSB         7
#define XAIE2PGBL_CORE_MODULE_CORE_SR_FLOAT_MAC_ZERO_FLAG_WIDTH       1
#define XAIE2PGBL_CORE_MODULE_CORE_SR_FLOAT_MAC_ZERO_FLAG_MASK        0x00000080
#define XAIE2PGBL_CORE_MODULE_CORE_SR_FLOAT_MAC_ZERO_FLAG_DEFVAL      0x0
#define XAIE2PGBL_CORE_MODULE_CORE_SR_UPS_OVERFLOW_LSB                5
#define XAIE2PGBL_CORE_MODULE_CORE_SR_UPS_OVERFLOW_WIDTH              1
#define XAIE2PGBL_CORE_MODULE_CORE_SR_UPS_OVERFLOW_MASK               0x00000020
#define XAIE2PGBL_CORE_MODULE_CORE_SR_UPS_OVERFLOW_DEFVAL             0x0
#define XAIE2PGBL_CORE_MODULE_CORE_SR_SRS_OVERFLOW_LSB                4
#define XAIE2PGBL_CORE_MODULE_CORE_SR_SRS_OVERFLOW_WIDTH              1
#define XAIE2PGBL_CORE_MODULE_CORE_SR_SRS_OVERFLOW_MASK               0x00000010
#define XAIE2PGBL_CORE_MODULE_CORE_SR_SRS_OVERFLOW_DEFVAL             0x0
#define XAIE2PGBL_CORE_MODULE_CORE_SR_MS0_SUCCESS_LSB                 3
#define XAIE2PGBL_CORE_MODULE_CORE_SR_MS0_SUCCESS_WIDTH               1
#define XAIE2PGBL_CORE_MODULE_CORE_SR_MS0_SUCCESS_MASK                0x00000008
#define XAIE2PGBL_CORE_MODULE_CORE_SR_MS0_SUCCESS_DEFVAL              0x0
#define XAIE2PGBL_CORE_MODULE_CORE_SR_SS0_TLAST_LSB                   2
#define XAIE2PGBL_CORE_MODULE_CORE_SR_SS0_TLAST_WIDTH                 1
#define XAIE2PGBL_CORE_MODULE_CORE_SR_SS0_TLAST_MASK                  0x00000004
#define XAIE2PGBL_CORE_MODULE_CORE_SR_SS0_TLAST_DEFVAL                0x0
#define XAIE2PGBL_CORE_MODULE_CORE_SR_SS0_SUCCESS_LSB                 1
#define XAIE2PGBL_CORE_MODULE_CORE_SR_SS0_SUCCESS_WIDTH               1
#define XAIE2PGBL_CORE_MODULE_CORE_SR_SS0_SUCCESS_MASK                0x00000002
#define XAIE2PGBL_CORE_MODULE_CORE_SR_SS0_SUCCESS_DEFVAL              0x0
#define XAIE2PGBL_CORE_MODULE_CORE_SR_CARRY_LSB                       0
#define XAIE2PGBL_CORE_MODULE_CORE_SR_CARRY_WIDTH                     1
#define XAIE2PGBL_CORE_MODULE_CORE_SR_CARRY_MASK                      0x00000001
#define XAIE2PGBL_CORE_MODULE_CORE_SR_CARRY_DEFVAL                    0x0

#define XAIE2PGBL_CORE_MODULE_CORE_R0                                   0x00031000
#define XAIE2PGBL_CORE_MODULE_CORE_R0_WIDTH                             32
#define XAIE2PGBL_CORE_MODULE_CORE_R0_MASK                              0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R0_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_R0_REGISTER_VALUE_WIDTH            32
#define XAIE2PGBL_CORE_MODULE_CORE_R0_REGISTER_VALUE_MASK             0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R0_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_CORE_R1                                   0x00031010
#define XAIE2PGBL_CORE_MODULE_CORE_R1_WIDTH                             32
#define XAIE2PGBL_CORE_MODULE_CORE_R1_MASK                              0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R1_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_R1_REGISTER_VALUE_WIDTH            32
#define XAIE2PGBL_CORE_MODULE_CORE_R1_REGISTER_VALUE_MASK             0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R1_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_CORE_R2                                   0x00031020
#define XAIE2PGBL_CORE_MODULE_CORE_R2_WIDTH                             32
#define XAIE2PGBL_CORE_MODULE_CORE_R2_MASK                              0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R2_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_R2_REGISTER_VALUE_WIDTH            32
#define XAIE2PGBL_CORE_MODULE_CORE_R2_REGISTER_VALUE_MASK             0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R2_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_CORE_R3                                   0x00031030
#define XAIE2PGBL_CORE_MODULE_CORE_R3_WIDTH                             32
#define XAIE2PGBL_CORE_MODULE_CORE_R3_MASK                              0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R3_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_R3_REGISTER_VALUE_WIDTH            32
#define XAIE2PGBL_CORE_MODULE_CORE_R3_REGISTER_VALUE_MASK             0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R3_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_CORE_R4                                   0x00031040
#define XAIE2PGBL_CORE_MODULE_CORE_R4_WIDTH                             32
#define XAIE2PGBL_CORE_MODULE_CORE_R4_MASK                              0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R4_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_R4_REGISTER_VALUE_WIDTH            32
#define XAIE2PGBL_CORE_MODULE_CORE_R4_REGISTER_VALUE_MASK             0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R4_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_CORE_R5                                   0x00031050
#define XAIE2PGBL_CORE_MODULE_CORE_R5_WIDTH                             32
#define XAIE2PGBL_CORE_MODULE_CORE_R5_MASK                              0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R5_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_R5_REGISTER_VALUE_WIDTH            32
#define XAIE2PGBL_CORE_MODULE_CORE_R5_REGISTER_VALUE_MASK             0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R5_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_CORE_R6                                   0x00031060
#define XAIE2PGBL_CORE_MODULE_CORE_R6_WIDTH                             32
#define XAIE2PGBL_CORE_MODULE_CORE_R6_MASK                              0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R6_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_R6_REGISTER_VALUE_WIDTH            32
#define XAIE2PGBL_CORE_MODULE_CORE_R6_REGISTER_VALUE_MASK             0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R6_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_CORE_R7                                   0x00031070
#define XAIE2PGBL_CORE_MODULE_CORE_R7_WIDTH                             32
#define XAIE2PGBL_CORE_MODULE_CORE_R7_MASK                              0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R7_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_R7_REGISTER_VALUE_WIDTH            32
#define XAIE2PGBL_CORE_MODULE_CORE_R7_REGISTER_VALUE_MASK             0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R7_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_CORE_R8                                   0x00031080
#define XAIE2PGBL_CORE_MODULE_CORE_R8_WIDTH                             32
#define XAIE2PGBL_CORE_MODULE_CORE_R8_MASK                              0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R8_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_R8_REGISTER_VALUE_WIDTH            32
#define XAIE2PGBL_CORE_MODULE_CORE_R8_REGISTER_VALUE_MASK             0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R8_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_CORE_R9                                   0x00031090
#define XAIE2PGBL_CORE_MODULE_CORE_R9_WIDTH                             32
#define XAIE2PGBL_CORE_MODULE_CORE_R9_MASK                              0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R9_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_R9_REGISTER_VALUE_WIDTH            32
#define XAIE2PGBL_CORE_MODULE_CORE_R9_REGISTER_VALUE_MASK             0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R9_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_CORE_R10                                  0x000310A0
#define XAIE2PGBL_CORE_MODULE_CORE_R10_WIDTH                            32
#define XAIE2PGBL_CORE_MODULE_CORE_R10_MASK                             0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R10_REGISTER_VALUE_LSB             0
#define XAIE2PGBL_CORE_MODULE_CORE_R10_REGISTER_VALUE_WIDTH           32
#define XAIE2PGBL_CORE_MODULE_CORE_R10_REGISTER_VALUE_MASK            0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R10_REGISTER_VALUE_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_CORE_R11                                  0x000310B0
#define XAIE2PGBL_CORE_MODULE_CORE_R11_WIDTH                            32
#define XAIE2PGBL_CORE_MODULE_CORE_R11_MASK                             0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R11_REGISTER_VALUE_LSB             0
#define XAIE2PGBL_CORE_MODULE_CORE_R11_REGISTER_VALUE_WIDTH           32
#define XAIE2PGBL_CORE_MODULE_CORE_R11_REGISTER_VALUE_MASK            0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R11_REGISTER_VALUE_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_CORE_R12                                  0x000310C0
#define XAIE2PGBL_CORE_MODULE_CORE_R12_WIDTH                            32
#define XAIE2PGBL_CORE_MODULE_CORE_R12_MASK                             0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R12_REGISTER_VALUE_LSB             0
#define XAIE2PGBL_CORE_MODULE_CORE_R12_REGISTER_VALUE_WIDTH           32
#define XAIE2PGBL_CORE_MODULE_CORE_R12_REGISTER_VALUE_MASK            0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R12_REGISTER_VALUE_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_CORE_R13                                  0x000310D0
#define XAIE2PGBL_CORE_MODULE_CORE_R13_WIDTH                            32
#define XAIE2PGBL_CORE_MODULE_CORE_R13_MASK                             0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R13_REGISTER_VALUE_LSB             0
#define XAIE2PGBL_CORE_MODULE_CORE_R13_REGISTER_VALUE_WIDTH           32
#define XAIE2PGBL_CORE_MODULE_CORE_R13_REGISTER_VALUE_MASK            0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R13_REGISTER_VALUE_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_CORE_R14                                  0x000310E0
#define XAIE2PGBL_CORE_MODULE_CORE_R14_WIDTH                            32
#define XAIE2PGBL_CORE_MODULE_CORE_R14_MASK                             0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R14_REGISTER_VALUE_LSB             0
#define XAIE2PGBL_CORE_MODULE_CORE_R14_REGISTER_VALUE_WIDTH           32
#define XAIE2PGBL_CORE_MODULE_CORE_R14_REGISTER_VALUE_MASK            0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R14_REGISTER_VALUE_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_CORE_R15                                  0x000310F0
#define XAIE2PGBL_CORE_MODULE_CORE_R15_WIDTH                            32
#define XAIE2PGBL_CORE_MODULE_CORE_R15_MASK                             0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R15_REGISTER_VALUE_LSB             0
#define XAIE2PGBL_CORE_MODULE_CORE_R15_REGISTER_VALUE_WIDTH           32
#define XAIE2PGBL_CORE_MODULE_CORE_R15_REGISTER_VALUE_MASK            0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R15_REGISTER_VALUE_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_CORE_R16                                  0x00031100
#define XAIE2PGBL_CORE_MODULE_CORE_R16_WIDTH                            32
#define XAIE2PGBL_CORE_MODULE_CORE_R16_MASK                             0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R16_REGISTER_VALUE_LSB             0
#define XAIE2PGBL_CORE_MODULE_CORE_R16_REGISTER_VALUE_WIDTH           32
#define XAIE2PGBL_CORE_MODULE_CORE_R16_REGISTER_VALUE_MASK            0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R16_REGISTER_VALUE_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_CORE_R17                                  0x00031110
#define XAIE2PGBL_CORE_MODULE_CORE_R17_WIDTH                            32
#define XAIE2PGBL_CORE_MODULE_CORE_R17_MASK                             0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R17_REGISTER_VALUE_LSB             0
#define XAIE2PGBL_CORE_MODULE_CORE_R17_REGISTER_VALUE_WIDTH           32
#define XAIE2PGBL_CORE_MODULE_CORE_R17_REGISTER_VALUE_MASK            0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R17_REGISTER_VALUE_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_CORE_R18                                  0x00031120
#define XAIE2PGBL_CORE_MODULE_CORE_R18_WIDTH                            32
#define XAIE2PGBL_CORE_MODULE_CORE_R18_MASK                             0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R18_REGISTER_VALUE_LSB             0
#define XAIE2PGBL_CORE_MODULE_CORE_R18_REGISTER_VALUE_WIDTH           32
#define XAIE2PGBL_CORE_MODULE_CORE_R18_REGISTER_VALUE_MASK            0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R18_REGISTER_VALUE_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_CORE_R19                                  0x00031130
#define XAIE2PGBL_CORE_MODULE_CORE_R19_WIDTH                            32
#define XAIE2PGBL_CORE_MODULE_CORE_R19_MASK                             0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R19_REGISTER_VALUE_LSB             0
#define XAIE2PGBL_CORE_MODULE_CORE_R19_REGISTER_VALUE_WIDTH           32
#define XAIE2PGBL_CORE_MODULE_CORE_R19_REGISTER_VALUE_MASK            0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R19_REGISTER_VALUE_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_CORE_R20                                  0x00031140
#define XAIE2PGBL_CORE_MODULE_CORE_R20_WIDTH                            32
#define XAIE2PGBL_CORE_MODULE_CORE_R20_MASK                             0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R20_REGISTER_VALUE_LSB             0
#define XAIE2PGBL_CORE_MODULE_CORE_R20_REGISTER_VALUE_WIDTH           32
#define XAIE2PGBL_CORE_MODULE_CORE_R20_REGISTER_VALUE_MASK            0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R20_REGISTER_VALUE_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_CORE_R21                                  0x00031150
#define XAIE2PGBL_CORE_MODULE_CORE_R21_WIDTH                            32
#define XAIE2PGBL_CORE_MODULE_CORE_R21_MASK                             0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R21_REGISTER_VALUE_LSB             0
#define XAIE2PGBL_CORE_MODULE_CORE_R21_REGISTER_VALUE_WIDTH           32
#define XAIE2PGBL_CORE_MODULE_CORE_R21_REGISTER_VALUE_MASK            0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R21_REGISTER_VALUE_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_CORE_R22                                  0x00031160
#define XAIE2PGBL_CORE_MODULE_CORE_R22_WIDTH                            32
#define XAIE2PGBL_CORE_MODULE_CORE_R22_MASK                             0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R22_REGISTER_VALUE_LSB             0
#define XAIE2PGBL_CORE_MODULE_CORE_R22_REGISTER_VALUE_WIDTH           32
#define XAIE2PGBL_CORE_MODULE_CORE_R22_REGISTER_VALUE_MASK            0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R22_REGISTER_VALUE_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_CORE_R23                                  0x00031170
#define XAIE2PGBL_CORE_MODULE_CORE_R23_WIDTH                            32
#define XAIE2PGBL_CORE_MODULE_CORE_R23_MASK                             0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R23_REGISTER_VALUE_LSB             0
#define XAIE2PGBL_CORE_MODULE_CORE_R23_REGISTER_VALUE_WIDTH           32
#define XAIE2PGBL_CORE_MODULE_CORE_R23_REGISTER_VALUE_MASK            0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R23_REGISTER_VALUE_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_CORE_R24                                  0x00031180
#define XAIE2PGBL_CORE_MODULE_CORE_R24_WIDTH                            32
#define XAIE2PGBL_CORE_MODULE_CORE_R24_MASK                             0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R24_REGISTER_VALUE_LSB             0
#define XAIE2PGBL_CORE_MODULE_CORE_R24_REGISTER_VALUE_WIDTH           32
#define XAIE2PGBL_CORE_MODULE_CORE_R24_REGISTER_VALUE_MASK            0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R24_REGISTER_VALUE_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_CORE_R25                                  0x00031190
#define XAIE2PGBL_CORE_MODULE_CORE_R25_WIDTH                            32
#define XAIE2PGBL_CORE_MODULE_CORE_R25_MASK                             0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R25_REGISTER_VALUE_LSB             0
#define XAIE2PGBL_CORE_MODULE_CORE_R25_REGISTER_VALUE_WIDTH           32
#define XAIE2PGBL_CORE_MODULE_CORE_R25_REGISTER_VALUE_MASK            0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R25_REGISTER_VALUE_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_CORE_R26                                  0x000311A0
#define XAIE2PGBL_CORE_MODULE_CORE_R26_WIDTH                            32
#define XAIE2PGBL_CORE_MODULE_CORE_R26_MASK                             0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R26_REGISTER_VALUE_LSB             0
#define XAIE2PGBL_CORE_MODULE_CORE_R26_REGISTER_VALUE_WIDTH           32
#define XAIE2PGBL_CORE_MODULE_CORE_R26_REGISTER_VALUE_MASK            0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R26_REGISTER_VALUE_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_CORE_R27                                  0x000311B0
#define XAIE2PGBL_CORE_MODULE_CORE_R27_WIDTH                            32
#define XAIE2PGBL_CORE_MODULE_CORE_R27_MASK                             0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R27_REGISTER_VALUE_LSB             0
#define XAIE2PGBL_CORE_MODULE_CORE_R27_REGISTER_VALUE_WIDTH           32
#define XAIE2PGBL_CORE_MODULE_CORE_R27_REGISTER_VALUE_MASK            0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R27_REGISTER_VALUE_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_CORE_R28                                  0x000311C0
#define XAIE2PGBL_CORE_MODULE_CORE_R28_WIDTH                            32
#define XAIE2PGBL_CORE_MODULE_CORE_R28_MASK                             0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R28_REGISTER_VALUE_LSB             0
#define XAIE2PGBL_CORE_MODULE_CORE_R28_REGISTER_VALUE_WIDTH           32
#define XAIE2PGBL_CORE_MODULE_CORE_R28_REGISTER_VALUE_MASK            0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R28_REGISTER_VALUE_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_CORE_R29                                  0x000311D0
#define XAIE2PGBL_CORE_MODULE_CORE_R29_WIDTH                            32
#define XAIE2PGBL_CORE_MODULE_CORE_R29_MASK                             0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R29_REGISTER_VALUE_LSB             0
#define XAIE2PGBL_CORE_MODULE_CORE_R29_REGISTER_VALUE_WIDTH           32
#define XAIE2PGBL_CORE_MODULE_CORE_R29_REGISTER_VALUE_MASK            0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R29_REGISTER_VALUE_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_CORE_R30                                  0x000311E0
#define XAIE2PGBL_CORE_MODULE_CORE_R30_WIDTH                            32
#define XAIE2PGBL_CORE_MODULE_CORE_R30_MASK                             0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R30_REGISTER_VALUE_LSB             0
#define XAIE2PGBL_CORE_MODULE_CORE_R30_REGISTER_VALUE_WIDTH           32
#define XAIE2PGBL_CORE_MODULE_CORE_R30_REGISTER_VALUE_MASK            0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R30_REGISTER_VALUE_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_CORE_R31                                  0x000311F0
#define XAIE2PGBL_CORE_MODULE_CORE_R31_WIDTH                            32
#define XAIE2PGBL_CORE_MODULE_CORE_R31_MASK                             0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R31_REGISTER_VALUE_LSB             0
#define XAIE2PGBL_CORE_MODULE_CORE_R31_REGISTER_VALUE_WIDTH           32
#define XAIE2PGBL_CORE_MODULE_CORE_R31_REGISTER_VALUE_MASK            0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_R31_REGISTER_VALUE_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_CORE_M0                                   0x00031200
#define XAIE2PGBL_CORE_MODULE_CORE_M0_WIDTH                             32
#define XAIE2PGBL_CORE_MODULE_CORE_M0_MASK                              0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_M0_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_M0_REGISTER_VALUE_WIDTH            20
#define XAIE2PGBL_CORE_MODULE_CORE_M0_REGISTER_VALUE_MASK             0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_M0_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_CORE_M1                                   0x00031210
#define XAIE2PGBL_CORE_MODULE_CORE_M1_WIDTH                             32
#define XAIE2PGBL_CORE_MODULE_CORE_M1_MASK                              0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_M1_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_M1_REGISTER_VALUE_WIDTH            20
#define XAIE2PGBL_CORE_MODULE_CORE_M1_REGISTER_VALUE_MASK             0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_M1_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_CORE_M2                                   0x00031220
#define XAIE2PGBL_CORE_MODULE_CORE_M2_WIDTH                             32
#define XAIE2PGBL_CORE_MODULE_CORE_M2_MASK                              0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_M2_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_M2_REGISTER_VALUE_WIDTH            20
#define XAIE2PGBL_CORE_MODULE_CORE_M2_REGISTER_VALUE_MASK             0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_M2_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_CORE_M3                                   0x00031230
#define XAIE2PGBL_CORE_MODULE_CORE_M3_WIDTH                             32
#define XAIE2PGBL_CORE_MODULE_CORE_M3_MASK                              0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_M3_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_M3_REGISTER_VALUE_WIDTH            20
#define XAIE2PGBL_CORE_MODULE_CORE_M3_REGISTER_VALUE_MASK             0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_M3_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_CORE_M4                                   0x00031240
#define XAIE2PGBL_CORE_MODULE_CORE_M4_WIDTH                             32
#define XAIE2PGBL_CORE_MODULE_CORE_M4_MASK                              0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_M4_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_M4_REGISTER_VALUE_WIDTH            20
#define XAIE2PGBL_CORE_MODULE_CORE_M4_REGISTER_VALUE_MASK             0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_M4_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_CORE_M5                                   0x00031250
#define XAIE2PGBL_CORE_MODULE_CORE_M5_WIDTH                             32
#define XAIE2PGBL_CORE_MODULE_CORE_M5_MASK                              0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_M5_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_M5_REGISTER_VALUE_WIDTH            20
#define XAIE2PGBL_CORE_MODULE_CORE_M5_REGISTER_VALUE_MASK             0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_M5_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_CORE_M6                                   0x00031260
#define XAIE2PGBL_CORE_MODULE_CORE_M6_WIDTH                             32
#define XAIE2PGBL_CORE_MODULE_CORE_M6_MASK                              0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_M6_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_M6_REGISTER_VALUE_WIDTH            20
#define XAIE2PGBL_CORE_MODULE_CORE_M6_REGISTER_VALUE_MASK             0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_M6_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_CORE_M7                                   0x00031270
#define XAIE2PGBL_CORE_MODULE_CORE_M7_WIDTH                             32
#define XAIE2PGBL_CORE_MODULE_CORE_M7_MASK                              0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_M7_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_M7_REGISTER_VALUE_WIDTH            20
#define XAIE2PGBL_CORE_MODULE_CORE_M7_REGISTER_VALUE_MASK             0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_M7_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_CORE_DN0                                  0x00031280
#define XAIE2PGBL_CORE_MODULE_CORE_DN0_WIDTH                            32
#define XAIE2PGBL_CORE_MODULE_CORE_DN0_MASK                             0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_DN0_REGISTER_VALUE_LSB             0
#define XAIE2PGBL_CORE_MODULE_CORE_DN0_REGISTER_VALUE_WIDTH           20
#define XAIE2PGBL_CORE_MODULE_CORE_DN0_REGISTER_VALUE_MASK            0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_DN0_REGISTER_VALUE_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_CORE_DN1                                  0x00031290
#define XAIE2PGBL_CORE_MODULE_CORE_DN1_WIDTH                            32
#define XAIE2PGBL_CORE_MODULE_CORE_DN1_MASK                             0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_DN1_REGISTER_VALUE_LSB             0
#define XAIE2PGBL_CORE_MODULE_CORE_DN1_REGISTER_VALUE_WIDTH           20
#define XAIE2PGBL_CORE_MODULE_CORE_DN1_REGISTER_VALUE_MASK            0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_DN1_REGISTER_VALUE_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_CORE_DN2                                  0x000312A0
#define XAIE2PGBL_CORE_MODULE_CORE_DN2_WIDTH                            32
#define XAIE2PGBL_CORE_MODULE_CORE_DN2_MASK                             0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_DN2_REGISTER_VALUE_LSB             0
#define XAIE2PGBL_CORE_MODULE_CORE_DN2_REGISTER_VALUE_WIDTH           20
#define XAIE2PGBL_CORE_MODULE_CORE_DN2_REGISTER_VALUE_MASK            0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_DN2_REGISTER_VALUE_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_CORE_DN3                                  0x000312B0
#define XAIE2PGBL_CORE_MODULE_CORE_DN3_WIDTH                            32
#define XAIE2PGBL_CORE_MODULE_CORE_DN3_MASK                             0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_DN3_REGISTER_VALUE_LSB             0
#define XAIE2PGBL_CORE_MODULE_CORE_DN3_REGISTER_VALUE_WIDTH           20
#define XAIE2PGBL_CORE_MODULE_CORE_DN3_REGISTER_VALUE_MASK            0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_DN3_REGISTER_VALUE_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_CORE_DN4                                  0x000312C0
#define XAIE2PGBL_CORE_MODULE_CORE_DN4_WIDTH                            32
#define XAIE2PGBL_CORE_MODULE_CORE_DN4_MASK                             0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_DN4_REGISTER_VALUE_LSB             0
#define XAIE2PGBL_CORE_MODULE_CORE_DN4_REGISTER_VALUE_WIDTH           20
#define XAIE2PGBL_CORE_MODULE_CORE_DN4_REGISTER_VALUE_MASK            0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_DN4_REGISTER_VALUE_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_CORE_DN5                                  0x000312D0
#define XAIE2PGBL_CORE_MODULE_CORE_DN5_WIDTH                            32
#define XAIE2PGBL_CORE_MODULE_CORE_DN5_MASK                             0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_DN5_REGISTER_VALUE_LSB             0
#define XAIE2PGBL_CORE_MODULE_CORE_DN5_REGISTER_VALUE_WIDTH           20
#define XAIE2PGBL_CORE_MODULE_CORE_DN5_REGISTER_VALUE_MASK            0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_DN5_REGISTER_VALUE_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_CORE_DN6                                  0x000312E0
#define XAIE2PGBL_CORE_MODULE_CORE_DN6_WIDTH                            32
#define XAIE2PGBL_CORE_MODULE_CORE_DN6_MASK                             0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_DN6_REGISTER_VALUE_LSB             0
#define XAIE2PGBL_CORE_MODULE_CORE_DN6_REGISTER_VALUE_WIDTH           20
#define XAIE2PGBL_CORE_MODULE_CORE_DN6_REGISTER_VALUE_MASK            0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_DN6_REGISTER_VALUE_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_CORE_DN7                                  0x000312F0
#define XAIE2PGBL_CORE_MODULE_CORE_DN7_WIDTH                            32
#define XAIE2PGBL_CORE_MODULE_CORE_DN7_MASK                             0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_DN7_REGISTER_VALUE_LSB             0
#define XAIE2PGBL_CORE_MODULE_CORE_DN7_REGISTER_VALUE_WIDTH           20
#define XAIE2PGBL_CORE_MODULE_CORE_DN7_REGISTER_VALUE_MASK            0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_DN7_REGISTER_VALUE_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_CORE_DJ0                                  0x00031300
#define XAIE2PGBL_CORE_MODULE_CORE_DJ0_WIDTH                            32
#define XAIE2PGBL_CORE_MODULE_CORE_DJ0_MASK                             0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_DJ0_REGISTER_VALUE_LSB             0
#define XAIE2PGBL_CORE_MODULE_CORE_DJ0_REGISTER_VALUE_WIDTH           20
#define XAIE2PGBL_CORE_MODULE_CORE_DJ0_REGISTER_VALUE_MASK            0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_DJ0_REGISTER_VALUE_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_CORE_DJ1                                  0x00031310
#define XAIE2PGBL_CORE_MODULE_CORE_DJ1_WIDTH                            32
#define XAIE2PGBL_CORE_MODULE_CORE_DJ1_MASK                             0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_DJ1_REGISTER_VALUE_LSB             0
#define XAIE2PGBL_CORE_MODULE_CORE_DJ1_REGISTER_VALUE_WIDTH           20
#define XAIE2PGBL_CORE_MODULE_CORE_DJ1_REGISTER_VALUE_MASK            0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_DJ1_REGISTER_VALUE_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_CORE_DJ2                                  0x00031320
#define XAIE2PGBL_CORE_MODULE_CORE_DJ2_WIDTH                            32
#define XAIE2PGBL_CORE_MODULE_CORE_DJ2_MASK                             0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_DJ2_REGISTER_VALUE_LSB             0
#define XAIE2PGBL_CORE_MODULE_CORE_DJ2_REGISTER_VALUE_WIDTH           20
#define XAIE2PGBL_CORE_MODULE_CORE_DJ2_REGISTER_VALUE_MASK            0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_DJ2_REGISTER_VALUE_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_CORE_DJ3                                  0x00031330
#define XAIE2PGBL_CORE_MODULE_CORE_DJ3_WIDTH                            32
#define XAIE2PGBL_CORE_MODULE_CORE_DJ3_MASK                             0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_DJ3_REGISTER_VALUE_LSB             0
#define XAIE2PGBL_CORE_MODULE_CORE_DJ3_REGISTER_VALUE_WIDTH           20
#define XAIE2PGBL_CORE_MODULE_CORE_DJ3_REGISTER_VALUE_MASK            0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_DJ3_REGISTER_VALUE_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_CORE_DJ4                                  0x00031340
#define XAIE2PGBL_CORE_MODULE_CORE_DJ4_WIDTH                            32
#define XAIE2PGBL_CORE_MODULE_CORE_DJ4_MASK                             0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_DJ4_REGISTER_VALUE_LSB             0
#define XAIE2PGBL_CORE_MODULE_CORE_DJ4_REGISTER_VALUE_WIDTH           20
#define XAIE2PGBL_CORE_MODULE_CORE_DJ4_REGISTER_VALUE_MASK            0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_DJ4_REGISTER_VALUE_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_CORE_DJ5                                  0x00031350
#define XAIE2PGBL_CORE_MODULE_CORE_DJ5_WIDTH                            32
#define XAIE2PGBL_CORE_MODULE_CORE_DJ5_MASK                             0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_DJ5_REGISTER_VALUE_LSB             0
#define XAIE2PGBL_CORE_MODULE_CORE_DJ5_REGISTER_VALUE_WIDTH           20
#define XAIE2PGBL_CORE_MODULE_CORE_DJ5_REGISTER_VALUE_MASK            0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_DJ5_REGISTER_VALUE_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_CORE_DJ6                                  0x00031360
#define XAIE2PGBL_CORE_MODULE_CORE_DJ6_WIDTH                            32
#define XAIE2PGBL_CORE_MODULE_CORE_DJ6_MASK                             0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_DJ6_REGISTER_VALUE_LSB             0
#define XAIE2PGBL_CORE_MODULE_CORE_DJ6_REGISTER_VALUE_WIDTH           20
#define XAIE2PGBL_CORE_MODULE_CORE_DJ6_REGISTER_VALUE_MASK            0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_DJ6_REGISTER_VALUE_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_CORE_DJ7                                  0x00031370
#define XAIE2PGBL_CORE_MODULE_CORE_DJ7_WIDTH                            32
#define XAIE2PGBL_CORE_MODULE_CORE_DJ7_MASK                             0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_DJ7_REGISTER_VALUE_LSB             0
#define XAIE2PGBL_CORE_MODULE_CORE_DJ7_REGISTER_VALUE_WIDTH           20
#define XAIE2PGBL_CORE_MODULE_CORE_DJ7_REGISTER_VALUE_MASK            0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_DJ7_REGISTER_VALUE_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_CORE_DC0                                  0x00031380
#define XAIE2PGBL_CORE_MODULE_CORE_DC0_WIDTH                            32
#define XAIE2PGBL_CORE_MODULE_CORE_DC0_MASK                             0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_DC0_REGISTER_VALUE_LSB             0
#define XAIE2PGBL_CORE_MODULE_CORE_DC0_REGISTER_VALUE_WIDTH           20
#define XAIE2PGBL_CORE_MODULE_CORE_DC0_REGISTER_VALUE_MASK            0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_DC0_REGISTER_VALUE_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_CORE_DC1                                  0x00031390
#define XAIE2PGBL_CORE_MODULE_CORE_DC1_WIDTH                            32
#define XAIE2PGBL_CORE_MODULE_CORE_DC1_MASK                             0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_DC1_REGISTER_VALUE_LSB             0
#define XAIE2PGBL_CORE_MODULE_CORE_DC1_REGISTER_VALUE_WIDTH           20
#define XAIE2PGBL_CORE_MODULE_CORE_DC1_REGISTER_VALUE_MASK            0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_DC1_REGISTER_VALUE_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_CORE_DC2                                  0x000313A0
#define XAIE2PGBL_CORE_MODULE_CORE_DC2_WIDTH                            32
#define XAIE2PGBL_CORE_MODULE_CORE_DC2_MASK                             0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_DC2_REGISTER_VALUE_LSB             0
#define XAIE2PGBL_CORE_MODULE_CORE_DC2_REGISTER_VALUE_WIDTH           20
#define XAIE2PGBL_CORE_MODULE_CORE_DC2_REGISTER_VALUE_MASK            0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_DC2_REGISTER_VALUE_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_CORE_DC3                                  0x000313B0
#define XAIE2PGBL_CORE_MODULE_CORE_DC3_WIDTH                            32
#define XAIE2PGBL_CORE_MODULE_CORE_DC3_MASK                             0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_DC3_REGISTER_VALUE_LSB             0
#define XAIE2PGBL_CORE_MODULE_CORE_DC3_REGISTER_VALUE_WIDTH           20
#define XAIE2PGBL_CORE_MODULE_CORE_DC3_REGISTER_VALUE_MASK            0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_DC3_REGISTER_VALUE_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_CORE_DC4                                  0x000313C0
#define XAIE2PGBL_CORE_MODULE_CORE_DC4_WIDTH                            32
#define XAIE2PGBL_CORE_MODULE_CORE_DC4_MASK                             0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_DC4_REGISTER_VALUE_LSB             0
#define XAIE2PGBL_CORE_MODULE_CORE_DC4_REGISTER_VALUE_WIDTH           20
#define XAIE2PGBL_CORE_MODULE_CORE_DC4_REGISTER_VALUE_MASK            0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_DC4_REGISTER_VALUE_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_CORE_DC5                                  0x000313D0
#define XAIE2PGBL_CORE_MODULE_CORE_DC5_WIDTH                            32
#define XAIE2PGBL_CORE_MODULE_CORE_DC5_MASK                             0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_DC5_REGISTER_VALUE_LSB             0
#define XAIE2PGBL_CORE_MODULE_CORE_DC5_REGISTER_VALUE_WIDTH           20
#define XAIE2PGBL_CORE_MODULE_CORE_DC5_REGISTER_VALUE_MASK            0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_DC5_REGISTER_VALUE_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_CORE_DC6                                  0x000313E0
#define XAIE2PGBL_CORE_MODULE_CORE_DC6_WIDTH                            32
#define XAIE2PGBL_CORE_MODULE_CORE_DC6_MASK                             0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_DC6_REGISTER_VALUE_LSB             0
#define XAIE2PGBL_CORE_MODULE_CORE_DC6_REGISTER_VALUE_WIDTH           20
#define XAIE2PGBL_CORE_MODULE_CORE_DC6_REGISTER_VALUE_MASK            0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_DC6_REGISTER_VALUE_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_CORE_DC7                                  0x000313F0
#define XAIE2PGBL_CORE_MODULE_CORE_DC7_WIDTH                            32
#define XAIE2PGBL_CORE_MODULE_CORE_DC7_MASK                             0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_DC7_REGISTER_VALUE_LSB             0
#define XAIE2PGBL_CORE_MODULE_CORE_DC7_REGISTER_VALUE_WIDTH           20
#define XAIE2PGBL_CORE_MODULE_CORE_DC7_REGISTER_VALUE_MASK            0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_DC7_REGISTER_VALUE_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_CORE_P0                                   0x00031400
#define XAIE2PGBL_CORE_MODULE_CORE_P0_WIDTH                             32
#define XAIE2PGBL_CORE_MODULE_CORE_P0_MASK                              0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_P0_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_P0_REGISTER_VALUE_WIDTH            20
#define XAIE2PGBL_CORE_MODULE_CORE_P0_REGISTER_VALUE_MASK             0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_P0_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_CORE_P1                                   0x00031410
#define XAIE2PGBL_CORE_MODULE_CORE_P1_WIDTH                             32
#define XAIE2PGBL_CORE_MODULE_CORE_P1_MASK                              0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_P1_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_P1_REGISTER_VALUE_WIDTH            20
#define XAIE2PGBL_CORE_MODULE_CORE_P1_REGISTER_VALUE_MASK             0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_P1_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_CORE_P2                                   0x00031420
#define XAIE2PGBL_CORE_MODULE_CORE_P2_WIDTH                             32
#define XAIE2PGBL_CORE_MODULE_CORE_P2_MASK                              0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_P2_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_P2_REGISTER_VALUE_WIDTH            20
#define XAIE2PGBL_CORE_MODULE_CORE_P2_REGISTER_VALUE_MASK             0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_P2_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_CORE_P3                                   0x00031430
#define XAIE2PGBL_CORE_MODULE_CORE_P3_WIDTH                             32
#define XAIE2PGBL_CORE_MODULE_CORE_P3_MASK                              0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_P3_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_P3_REGISTER_VALUE_WIDTH            20
#define XAIE2PGBL_CORE_MODULE_CORE_P3_REGISTER_VALUE_MASK             0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_P3_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_CORE_P4                                   0x00031440
#define XAIE2PGBL_CORE_MODULE_CORE_P4_WIDTH                             32
#define XAIE2PGBL_CORE_MODULE_CORE_P4_MASK                              0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_P4_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_P4_REGISTER_VALUE_WIDTH            20
#define XAIE2PGBL_CORE_MODULE_CORE_P4_REGISTER_VALUE_MASK             0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_P4_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_CORE_P5                                   0x00031450
#define XAIE2PGBL_CORE_MODULE_CORE_P5_WIDTH                             32
#define XAIE2PGBL_CORE_MODULE_CORE_P5_MASK                              0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_P5_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_P5_REGISTER_VALUE_WIDTH            20
#define XAIE2PGBL_CORE_MODULE_CORE_P5_REGISTER_VALUE_MASK             0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_P5_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_CORE_P6                                   0x00031460
#define XAIE2PGBL_CORE_MODULE_CORE_P6_WIDTH                             32
#define XAIE2PGBL_CORE_MODULE_CORE_P6_MASK                              0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_P6_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_P6_REGISTER_VALUE_WIDTH            20
#define XAIE2PGBL_CORE_MODULE_CORE_P6_REGISTER_VALUE_MASK             0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_P6_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_CORE_P7                                   0x00031470
#define XAIE2PGBL_CORE_MODULE_CORE_P7_WIDTH                             32
#define XAIE2PGBL_CORE_MODULE_CORE_P7_MASK                              0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_P7_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_P7_REGISTER_VALUE_WIDTH            20
#define XAIE2PGBL_CORE_MODULE_CORE_P7_REGISTER_VALUE_MASK             0x000FFFFF
#define XAIE2PGBL_CORE_MODULE_CORE_P7_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_CORE_S0                                   0x00031480
#define XAIE2PGBL_CORE_MODULE_CORE_S0_WIDTH                             32
#define XAIE2PGBL_CORE_MODULE_CORE_S0_MASK                              0x0000003F
#define XAIE2PGBL_CORE_MODULE_CORE_S0_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_S0_REGISTER_VALUE_WIDTH            6
#define XAIE2PGBL_CORE_MODULE_CORE_S0_REGISTER_VALUE_MASK             0x0000003F
#define XAIE2PGBL_CORE_MODULE_CORE_S0_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_CORE_S1                                   0x00031490
#define XAIE2PGBL_CORE_MODULE_CORE_S1_WIDTH                             32
#define XAIE2PGBL_CORE_MODULE_CORE_S1_MASK                              0x0000003F
#define XAIE2PGBL_CORE_MODULE_CORE_S1_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_S1_REGISTER_VALUE_WIDTH            6
#define XAIE2PGBL_CORE_MODULE_CORE_S1_REGISTER_VALUE_MASK             0x0000003F
#define XAIE2PGBL_CORE_MODULE_CORE_S1_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_CORE_S2                                   0x000314A0
#define XAIE2PGBL_CORE_MODULE_CORE_S2_WIDTH                             32
#define XAIE2PGBL_CORE_MODULE_CORE_S2_MASK                              0x0000003F
#define XAIE2PGBL_CORE_MODULE_CORE_S2_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_S2_REGISTER_VALUE_WIDTH            6
#define XAIE2PGBL_CORE_MODULE_CORE_S2_REGISTER_VALUE_MASK             0x0000003F
#define XAIE2PGBL_CORE_MODULE_CORE_S2_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_CORE_S3                                   0x000314B0
#define XAIE2PGBL_CORE_MODULE_CORE_S3_WIDTH                             32
#define XAIE2PGBL_CORE_MODULE_CORE_S3_MASK                              0x0000003F
#define XAIE2PGBL_CORE_MODULE_CORE_S3_REGISTER_VALUE_LSB              0
#define XAIE2PGBL_CORE_MODULE_CORE_S3_REGISTER_VALUE_WIDTH            6
#define XAIE2PGBL_CORE_MODULE_CORE_S3_REGISTER_VALUE_MASK             0x0000003F
#define XAIE2PGBL_CORE_MODULE_CORE_S3_REGISTER_VALUE_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL0                      0x00031500
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL0_WIDTH                32
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL0_MASK                 0x7F7F7F7F
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL0_CNT1_STOP_EVENT_LSB 24
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL0_CNT1_STOP_EVENT_WIDTH 7
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL0_CNT1_STOP_EVENT_MASK 0x7F000000
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL0_CNT1_STOP_EVENT_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL0_CNT1_START_EVENT_LSB 16
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL0_CNT1_START_EVENT_WIDTH 7
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL0_CNT1_START_EVENT_MASK 0x007F0000
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL0_CNT1_START_EVENT_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL0_CNT0_STOP_EVENT_LSB 8
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL0_CNT0_STOP_EVENT_WIDTH 7
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL0_CNT0_STOP_EVENT_MASK 0x00007F00
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL0_CNT0_STOP_EVENT_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL0_CNT0_START_EVENT_LSB 0
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL0_CNT0_START_EVENT_WIDTH 7
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL0_CNT0_START_EVENT_MASK 0x0000007F
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL0_CNT0_START_EVENT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL1                      0x00031504
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL1_WIDTH                32
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL1_MASK                 0x7F7F7F7F
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL1_CNT3_STOP_EVENT_LSB 24
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL1_CNT3_STOP_EVENT_WIDTH 7
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL1_CNT3_STOP_EVENT_MASK 0x7F000000
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL1_CNT3_STOP_EVENT_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL1_CNT3_START_EVENT_LSB 16
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL1_CNT3_START_EVENT_WIDTH 7
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL1_CNT3_START_EVENT_MASK 0x007F0000
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL1_CNT3_START_EVENT_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL1_CNT2_STOP_EVENT_LSB 8
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL1_CNT2_STOP_EVENT_WIDTH 7
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL1_CNT2_STOP_EVENT_MASK 0x00007F00
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL1_CNT2_STOP_EVENT_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL1_CNT2_START_EVENT_LSB 0
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL1_CNT2_START_EVENT_WIDTH 7
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL1_CNT2_START_EVENT_MASK 0x0000007F
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL1_CNT2_START_EVENT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL2                      0x00031508
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL2_WIDTH                32
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL2_MASK                 0x7F7F7F7F
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL2_CNT3_RESET_EVENT_LSB 24
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL2_CNT3_RESET_EVENT_WIDTH 7
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL2_CNT3_RESET_EVENT_MASK 0x7F000000
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL2_CNT3_RESET_EVENT_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL2_CNT2_RESET_EVENT_LSB 16
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL2_CNT2_RESET_EVENT_WIDTH 7
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL2_CNT2_RESET_EVENT_MASK 0x007F0000
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL2_CNT2_RESET_EVENT_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL2_CNT1_RESET_EVENT_LSB 8
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL2_CNT1_RESET_EVENT_WIDTH 7
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL2_CNT1_RESET_EVENT_MASK 0x00007F00
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL2_CNT1_RESET_EVENT_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL2_CNT0_RESET_EVENT_LSB 0
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL2_CNT0_RESET_EVENT_WIDTH 7
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL2_CNT0_RESET_EVENT_MASK 0x0000007F
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_CONTROL2_CNT0_RESET_EVENT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER0                      0x00031520
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER0_WIDTH                32
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER0_MASK                 0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER0_COUNTER0_VALUE_LSB 0
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER0_COUNTER0_VALUE_WIDTH 32
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER0_COUNTER0_VALUE_MASK 0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER0_COUNTER0_VALUE_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER1                      0x00031524
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER1_WIDTH                32
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER1_MASK                 0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER1_COUNTER0_VALUE_LSB 0
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER1_COUNTER0_VALUE_WIDTH 32
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER1_COUNTER0_VALUE_MASK 0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER1_COUNTER0_VALUE_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER2                      0x00031528
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER2_WIDTH                32
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER2_MASK                 0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER2_COUNTER0_VALUE_LSB 0
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER2_COUNTER0_VALUE_WIDTH 32
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER2_COUNTER0_VALUE_MASK 0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER2_COUNTER0_VALUE_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER3                      0x0003152C
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER3_WIDTH                32
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER3_MASK                 0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER3_COUNTER0_VALUE_LSB 0
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER3_COUNTER0_VALUE_WIDTH 32
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER3_COUNTER0_VALUE_MASK 0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER3_COUNTER0_VALUE_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER0_EVENT_VALUE          0x00031580
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER0_EVENT_VALUE_WIDTH    32
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER0_EVENT_VALUE_MASK     0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER0_EVENT_VALUE_COUNTER_EVENT_VALUE_LSB 0
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER0_EVENT_VALUE_COUNTER_EVENT_VALUE_WIDTH 32
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER0_EVENT_VALUE_COUNTER_EVENT_VALUE_MASK 0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER0_EVENT_VALUE_COUNTER_EVENT_VALUE_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER1_EVENT_VALUE          0x00031584
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER1_EVENT_VALUE_WIDTH    32
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER1_EVENT_VALUE_MASK     0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER1_EVENT_VALUE_COUNTER_EVENT_VALUE_LSB 0
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER1_EVENT_VALUE_COUNTER_EVENT_VALUE_WIDTH 32
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER1_EVENT_VALUE_COUNTER_EVENT_VALUE_MASK 0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER1_EVENT_VALUE_COUNTER_EVENT_VALUE_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER2_EVENT_VALUE          0x00031588
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER2_EVENT_VALUE_WIDTH    32
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER2_EVENT_VALUE_MASK     0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER2_EVENT_VALUE_COUNTER_EVENT_VALUE_LSB 0
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER2_EVENT_VALUE_COUNTER_EVENT_VALUE_WIDTH 32
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER2_EVENT_VALUE_COUNTER_EVENT_VALUE_MASK 0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER2_EVENT_VALUE_COUNTER_EVENT_VALUE_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER3_EVENT_VALUE          0x0003158C
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER3_EVENT_VALUE_WIDTH    32
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER3_EVENT_VALUE_MASK     0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER3_EVENT_VALUE_COUNTER_EVENT_VALUE_LSB 0
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER3_EVENT_VALUE_COUNTER_EVENT_VALUE_WIDTH 32
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER3_EVENT_VALUE_COUNTER_EVENT_VALUE_MASK 0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_PERFORMANCE_COUNTER3_EVENT_VALUE_COUNTER_EVENT_VALUE_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_CORE_CONTROL                              0x00032000
#define XAIE2PGBL_CORE_MODULE_CORE_CONTROL_WIDTH                        32
#define XAIE2PGBL_CORE_MODULE_CORE_CONTROL_MASK                         0x00000003
#define XAIE2PGBL_CORE_MODULE_CORE_CONTROL_RESET_LSB                  1
#define XAIE2PGBL_CORE_MODULE_CORE_CONTROL_RESET_WIDTH                1
#define XAIE2PGBL_CORE_MODULE_CORE_CONTROL_RESET_MASK                 0x00000002
#define XAIE2PGBL_CORE_MODULE_CORE_CONTROL_RESET_DEFVAL               0x1
#define XAIE2PGBL_CORE_MODULE_CORE_CONTROL_ENABLE_LSB                 0
#define XAIE2PGBL_CORE_MODULE_CORE_CONTROL_ENABLE_WIDTH               1
#define XAIE2PGBL_CORE_MODULE_CORE_CONTROL_ENABLE_MASK                0x00000001
#define XAIE2PGBL_CORE_MODULE_CORE_CONTROL_ENABLE_DEFVAL              0x0

#define XAIE2PGBL_CORE_MODULE_CORE_STATUS                               0x00032004
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_WIDTH                         32
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_MASK                          0x003FD7FF
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_CORE_PROCESSOR_BUS_STALL_LSB 21
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_CORE_PROCESSOR_BUS_STALL_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_CORE_PROCESSOR_BUS_STALL_MASK 0x00200000
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_CORE_PROCESSOR_BUS_STALL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_CORE_DONE_LSB               20
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_CORE_DONE_WIDTH             1
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_CORE_DONE_MASK              0x00100000
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_CORE_DONE_DEFVAL            0x0
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_ERROR_HALT_LSB              19
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_ERROR_HALT_WIDTH            1
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_ERROR_HALT_MASK             0x00080000
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_ERROR_HALT_DEFVAL           0x0
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_ECC_SCRUBBING_STALL_LSB     18
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_ECC_SCRUBBING_STALL_WIDTH   1
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_ECC_SCRUBBING_STALL_MASK    0x00040000
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_ECC_SCRUBBING_STALL_DEFVAL  0x0
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_ECC_ERROR_STALL_LSB         17
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_ECC_ERROR_STALL_WIDTH       1
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_ECC_ERROR_STALL_MASK        0x00020000
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_ECC_ERROR_STALL_DEFVAL      0x0
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_DEBUG_HALT_LSB              16
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_DEBUG_HALT_WIDTH            1
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_DEBUG_HALT_MASK             0x00010000
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_DEBUG_HALT_DEFVAL           0x0
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_CASCADE_STALL_MCD_LSB       15
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_CASCADE_STALL_MCD_WIDTH     1
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_CASCADE_STALL_MCD_MASK      0x00008000
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_CASCADE_STALL_MCD_DEFVAL    0x0
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_CASCADE_STALL_SCD_LSB       14
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_CASCADE_STALL_SCD_WIDTH     1
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_CASCADE_STALL_SCD_MASK      0x00004000
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_CASCADE_STALL_SCD_DEFVAL    0x0
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_STREAM_STALL_MS0_LSB        12
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_STREAM_STALL_MS0_WIDTH      1
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_STREAM_STALL_MS0_MASK       0x00001000
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_STREAM_STALL_MS0_DEFVAL     0x0
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_STREAM_STALL_SS0_LSB        10
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_STREAM_STALL_SS0_WIDTH      1
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_STREAM_STALL_SS0_MASK       0x00000400
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_STREAM_STALL_SS0_DEFVAL     0x0
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_LOCK_STALL_E_LSB            9
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_LOCK_STALL_E_WIDTH          1
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_LOCK_STALL_E_MASK           0x00000200
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_LOCK_STALL_E_DEFVAL         0x0
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_LOCK_STALL_N_LSB            8
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_LOCK_STALL_N_WIDTH          1
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_LOCK_STALL_N_MASK           0x00000100
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_LOCK_STALL_N_DEFVAL         0x0
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_LOCK_STALL_W_LSB            7
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_LOCK_STALL_W_WIDTH          1
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_LOCK_STALL_W_MASK           0x00000080
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_LOCK_STALL_W_DEFVAL         0x0
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_LOCK_STALL_S_LSB            6
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_LOCK_STALL_S_WIDTH          1
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_LOCK_STALL_S_MASK           0x00000040
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_LOCK_STALL_S_DEFVAL         0x0
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_MEMORY_STALL_E_LSB          5
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_MEMORY_STALL_E_WIDTH        1
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_MEMORY_STALL_E_MASK         0x00000020
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_MEMORY_STALL_E_DEFVAL       0x0
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_MEMORY_STALL_N_LSB          4
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_MEMORY_STALL_N_WIDTH        1
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_MEMORY_STALL_N_MASK         0x00000010
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_MEMORY_STALL_N_DEFVAL       0x0
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_MEMORY_STALL_W_LSB          3
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_MEMORY_STALL_W_WIDTH        1
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_MEMORY_STALL_W_MASK         0x00000008
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_MEMORY_STALL_W_DEFVAL       0x0
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_MEMORY_STALL_S_LSB          2
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_MEMORY_STALL_S_WIDTH        1
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_MEMORY_STALL_S_MASK         0x00000004
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_MEMORY_STALL_S_DEFVAL       0x0
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_RESET_LSB                   1
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_RESET_WIDTH                 1
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_RESET_MASK                  0x00000002
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_RESET_DEFVAL                0x1
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_ENABLE_LSB                  0
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_ENABLE_WIDTH                1
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_ENABLE_MASK                 0x00000001
#define XAIE2PGBL_CORE_MODULE_CORE_STATUS_ENABLE_DEFVAL               0x0

#define XAIE2PGBL_CORE_MODULE_ENABLE_EVENTS                             0x00032008
#define XAIE2PGBL_CORE_MODULE_ENABLE_EVENTS_WIDTH                       32
#define XAIE2PGBL_CORE_MODULE_ENABLE_EVENTS_MASK                        0x0000FFFF
#define XAIE2PGBL_CORE_MODULE_ENABLE_EVENTS_DISABLE_EVENT_OCCURRED_LSB 15
#define XAIE2PGBL_CORE_MODULE_ENABLE_EVENTS_DISABLE_EVENT_OCCURRED_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_ENABLE_EVENTS_DISABLE_EVENT_OCCURRED_MASK 0x00008000
#define XAIE2PGBL_CORE_MODULE_ENABLE_EVENTS_DISABLE_EVENT_OCCURRED_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_ENABLE_EVENTS_DISABLE_EVENT_LSB         8
#define XAIE2PGBL_CORE_MODULE_ENABLE_EVENTS_DISABLE_EVENT_WIDTH       7
#define XAIE2PGBL_CORE_MODULE_ENABLE_EVENTS_DISABLE_EVENT_MASK        0x00007F00
#define XAIE2PGBL_CORE_MODULE_ENABLE_EVENTS_DISABLE_EVENT_DEFVAL      0x0
#define XAIE2PGBL_CORE_MODULE_ENABLE_EVENTS_ENABLE_EVENT_OCCURRED_LSB 7
#define XAIE2PGBL_CORE_MODULE_ENABLE_EVENTS_ENABLE_EVENT_OCCURRED_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_ENABLE_EVENTS_ENABLE_EVENT_OCCURRED_MASK 0x00000080
#define XAIE2PGBL_CORE_MODULE_ENABLE_EVENTS_ENABLE_EVENT_OCCURRED_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_ENABLE_EVENTS_ENABLE_EVENT_LSB          0
#define XAIE2PGBL_CORE_MODULE_ENABLE_EVENTS_ENABLE_EVENT_WIDTH        7
#define XAIE2PGBL_CORE_MODULE_ENABLE_EVENTS_ENABLE_EVENT_MASK         0x0000007F
#define XAIE2PGBL_CORE_MODULE_ENABLE_EVENTS_ENABLE_EVENT_DEFVAL       0x0

#define XAIE2PGBL_CORE_MODULE_RESET_EVENT                               0x0003200C
#define XAIE2PGBL_CORE_MODULE_RESET_EVENT_WIDTH                         32
#define XAIE2PGBL_CORE_MODULE_RESET_EVENT_MASK                          0x0000007F
#define XAIE2PGBL_CORE_MODULE_RESET_EVENT_RESET_EVENT_LSB             0
#define XAIE2PGBL_CORE_MODULE_RESET_EVENT_RESET_EVENT_WIDTH           7
#define XAIE2PGBL_CORE_MODULE_RESET_EVENT_RESET_EVENT_MASK            0x0000007F
#define XAIE2PGBL_CORE_MODULE_RESET_EVENT_RESET_EVENT_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_DEBUG_CONTROL0                            0x00032010
#define XAIE2PGBL_CORE_MODULE_DEBUG_CONTROL0_WIDTH                      32
#define XAIE2PGBL_CORE_MODULE_DEBUG_CONTROL0_MASK                       0x0000003D
#define XAIE2PGBL_CORE_MODULE_DEBUG_CONTROL0_SINGLE_STEP_COUNT_LSB    2
#define XAIE2PGBL_CORE_MODULE_DEBUG_CONTROL0_SINGLE_STEP_COUNT_WIDTH  4
#define XAIE2PGBL_CORE_MODULE_DEBUG_CONTROL0_SINGLE_STEP_COUNT_MASK   0x0000003C
#define XAIE2PGBL_CORE_MODULE_DEBUG_CONTROL0_SINGLE_STEP_COUNT_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_DEBUG_CONTROL0_DEBUG_HALT_BIT_LSB       0
#define XAIE2PGBL_CORE_MODULE_DEBUG_CONTROL0_DEBUG_HALT_BIT_WIDTH     1
#define XAIE2PGBL_CORE_MODULE_DEBUG_CONTROL0_DEBUG_HALT_BIT_MASK      0x00000001
#define XAIE2PGBL_CORE_MODULE_DEBUG_CONTROL0_DEBUG_HALT_BIT_DEFVAL    0x0

#define XAIE2PGBL_CORE_MODULE_DEBUG_CONTROL1                            0x00032014
#define XAIE2PGBL_CORE_MODULE_DEBUG_CONTROL1_WIDTH                      32
#define XAIE2PGBL_CORE_MODULE_DEBUG_CONTROL1_MASK                       0x7F7F7F7F
#define XAIE2PGBL_CORE_MODULE_DEBUG_CONTROL1_DEBUG_HALT_CORE_EVENT1_LSB 24
#define XAIE2PGBL_CORE_MODULE_DEBUG_CONTROL1_DEBUG_HALT_CORE_EVENT1_WIDTH 7
#define XAIE2PGBL_CORE_MODULE_DEBUG_CONTROL1_DEBUG_HALT_CORE_EVENT1_MASK 0x7F000000
#define XAIE2PGBL_CORE_MODULE_DEBUG_CONTROL1_DEBUG_HALT_CORE_EVENT1_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_DEBUG_CONTROL1_DEBUG_HALT_CORE_EVENT0_LSB 16
#define XAIE2PGBL_CORE_MODULE_DEBUG_CONTROL1_DEBUG_HALT_CORE_EVENT0_WIDTH 7
#define XAIE2PGBL_CORE_MODULE_DEBUG_CONTROL1_DEBUG_HALT_CORE_EVENT0_MASK 0x007F0000
#define XAIE2PGBL_CORE_MODULE_DEBUG_CONTROL1_DEBUG_HALT_CORE_EVENT0_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_DEBUG_CONTROL1_DEBUG_SINGLESTEP_CORE_EVENT_LSB 8
#define XAIE2PGBL_CORE_MODULE_DEBUG_CONTROL1_DEBUG_SINGLESTEP_CORE_EVENT_WIDTH 7
#define XAIE2PGBL_CORE_MODULE_DEBUG_CONTROL1_DEBUG_SINGLESTEP_CORE_EVENT_MASK 0x00007F00
#define XAIE2PGBL_CORE_MODULE_DEBUG_CONTROL1_DEBUG_SINGLESTEP_CORE_EVENT_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_DEBUG_CONTROL1_DEBUG_RESUME_CORE_EVENT_LSB 0
#define XAIE2PGBL_CORE_MODULE_DEBUG_CONTROL1_DEBUG_RESUME_CORE_EVENT_WIDTH 7
#define XAIE2PGBL_CORE_MODULE_DEBUG_CONTROL1_DEBUG_RESUME_CORE_EVENT_MASK 0x0000007F
#define XAIE2PGBL_CORE_MODULE_DEBUG_CONTROL1_DEBUG_RESUME_CORE_EVENT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_DEBUG_CONTROL2                            0x00032018
#define XAIE2PGBL_CORE_MODULE_DEBUG_CONTROL2_WIDTH                      32
#define XAIE2PGBL_CORE_MODULE_DEBUG_CONTROL2_MASK                       0x0000000F
#define XAIE2PGBL_CORE_MODULE_DEBUG_CONTROL2_STREAM_STALL_HALT_LSB    3
#define XAIE2PGBL_CORE_MODULE_DEBUG_CONTROL2_STREAM_STALL_HALT_WIDTH  1
#define XAIE2PGBL_CORE_MODULE_DEBUG_CONTROL2_STREAM_STALL_HALT_MASK   0x00000008
#define XAIE2PGBL_CORE_MODULE_DEBUG_CONTROL2_STREAM_STALL_HALT_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_DEBUG_CONTROL2_LOCK_STALL_HALT_LSB      2
#define XAIE2PGBL_CORE_MODULE_DEBUG_CONTROL2_LOCK_STALL_HALT_WIDTH    1
#define XAIE2PGBL_CORE_MODULE_DEBUG_CONTROL2_LOCK_STALL_HALT_MASK     0x00000004
#define XAIE2PGBL_CORE_MODULE_DEBUG_CONTROL2_LOCK_STALL_HALT_DEFVAL   0x0
#define XAIE2PGBL_CORE_MODULE_DEBUG_CONTROL2_MEMORY_STALL_HALT_LSB    1
#define XAIE2PGBL_CORE_MODULE_DEBUG_CONTROL2_MEMORY_STALL_HALT_WIDTH  1
#define XAIE2PGBL_CORE_MODULE_DEBUG_CONTROL2_MEMORY_STALL_HALT_MASK   0x00000002
#define XAIE2PGBL_CORE_MODULE_DEBUG_CONTROL2_MEMORY_STALL_HALT_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_DEBUG_CONTROL2_PC_EVENT_HALT_LSB        0
#define XAIE2PGBL_CORE_MODULE_DEBUG_CONTROL2_PC_EVENT_HALT_WIDTH      1
#define XAIE2PGBL_CORE_MODULE_DEBUG_CONTROL2_PC_EVENT_HALT_MASK       0x00000001
#define XAIE2PGBL_CORE_MODULE_DEBUG_CONTROL2_PC_EVENT_HALT_DEFVAL     0x0

#define XAIE2PGBL_CORE_MODULE_DEBUG_STATUS                              0x0003201C
#define XAIE2PGBL_CORE_MODULE_DEBUG_STATUS_WIDTH                        32
#define XAIE2PGBL_CORE_MODULE_DEBUG_STATUS_MASK                         0x0000007F
#define XAIE2PGBL_CORE_MODULE_DEBUG_STATUS_DEBUG_EVENT1_HALTED_LSB    6
#define XAIE2PGBL_CORE_MODULE_DEBUG_STATUS_DEBUG_EVENT1_HALTED_WIDTH  1
#define XAIE2PGBL_CORE_MODULE_DEBUG_STATUS_DEBUG_EVENT1_HALTED_MASK   0x00000040
#define XAIE2PGBL_CORE_MODULE_DEBUG_STATUS_DEBUG_EVENT1_HALTED_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_DEBUG_STATUS_DEBUG_EVENT0_HALTED_LSB    5
#define XAIE2PGBL_CORE_MODULE_DEBUG_STATUS_DEBUG_EVENT0_HALTED_WIDTH  1
#define XAIE2PGBL_CORE_MODULE_DEBUG_STATUS_DEBUG_EVENT0_HALTED_MASK   0x00000020
#define XAIE2PGBL_CORE_MODULE_DEBUG_STATUS_DEBUG_EVENT0_HALTED_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_DEBUG_STATUS_STREAM_STALL_HALTED_LSB    4
#define XAIE2PGBL_CORE_MODULE_DEBUG_STATUS_STREAM_STALL_HALTED_WIDTH  1
#define XAIE2PGBL_CORE_MODULE_DEBUG_STATUS_STREAM_STALL_HALTED_MASK   0x00000010
#define XAIE2PGBL_CORE_MODULE_DEBUG_STATUS_STREAM_STALL_HALTED_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_DEBUG_STATUS_LOCK_STALL_HALTED_LSB      3
#define XAIE2PGBL_CORE_MODULE_DEBUG_STATUS_LOCK_STALL_HALTED_WIDTH    1
#define XAIE2PGBL_CORE_MODULE_DEBUG_STATUS_LOCK_STALL_HALTED_MASK     0x00000008
#define XAIE2PGBL_CORE_MODULE_DEBUG_STATUS_LOCK_STALL_HALTED_DEFVAL   0x0
#define XAIE2PGBL_CORE_MODULE_DEBUG_STATUS_MEMORY_STALL_HALTED_LSB    2
#define XAIE2PGBL_CORE_MODULE_DEBUG_STATUS_MEMORY_STALL_HALTED_WIDTH  1
#define XAIE2PGBL_CORE_MODULE_DEBUG_STATUS_MEMORY_STALL_HALTED_MASK   0x00000004
#define XAIE2PGBL_CORE_MODULE_DEBUG_STATUS_MEMORY_STALL_HALTED_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_DEBUG_STATUS_PC_EVENT_HALTED_LSB        1
#define XAIE2PGBL_CORE_MODULE_DEBUG_STATUS_PC_EVENT_HALTED_WIDTH      1
#define XAIE2PGBL_CORE_MODULE_DEBUG_STATUS_PC_EVENT_HALTED_MASK       0x00000002
#define XAIE2PGBL_CORE_MODULE_DEBUG_STATUS_PC_EVENT_HALTED_DEFVAL     0x0
#define XAIE2PGBL_CORE_MODULE_DEBUG_STATUS_DEBUG_HALTED_LSB           0
#define XAIE2PGBL_CORE_MODULE_DEBUG_STATUS_DEBUG_HALTED_WIDTH         1
#define XAIE2PGBL_CORE_MODULE_DEBUG_STATUS_DEBUG_HALTED_MASK          0x00000001
#define XAIE2PGBL_CORE_MODULE_DEBUG_STATUS_DEBUG_HALTED_DEFVAL        0x0

#define XAIE2PGBL_CORE_MODULE_PC_EVENT0                                 0x00032020
#define XAIE2PGBL_CORE_MODULE_PC_EVENT0_WIDTH                           32
#define XAIE2PGBL_CORE_MODULE_PC_EVENT0_MASK                            0x80003FFF
#define XAIE2PGBL_CORE_MODULE_PC_EVENT0_VALID_LSB                     31
#define XAIE2PGBL_CORE_MODULE_PC_EVENT0_VALID_WIDTH                   1
#define XAIE2PGBL_CORE_MODULE_PC_EVENT0_VALID_MASK                    0x80000000
#define XAIE2PGBL_CORE_MODULE_PC_EVENT0_VALID_DEFVAL                  0x0
#define XAIE2PGBL_CORE_MODULE_PC_EVENT0_PC_ADDRESS_LSB                0
#define XAIE2PGBL_CORE_MODULE_PC_EVENT0_PC_ADDRESS_WIDTH              14
#define XAIE2PGBL_CORE_MODULE_PC_EVENT0_PC_ADDRESS_MASK               0x00003FFF
#define XAIE2PGBL_CORE_MODULE_PC_EVENT0_PC_ADDRESS_DEFVAL             0x0

#define XAIE2PGBL_CORE_MODULE_PC_EVENT1                                 0x00032024
#define XAIE2PGBL_CORE_MODULE_PC_EVENT1_WIDTH                           32
#define XAIE2PGBL_CORE_MODULE_PC_EVENT1_MASK                            0x80003FFF
#define XAIE2PGBL_CORE_MODULE_PC_EVENT1_VALID_LSB                     31
#define XAIE2PGBL_CORE_MODULE_PC_EVENT1_VALID_WIDTH                   1
#define XAIE2PGBL_CORE_MODULE_PC_EVENT1_VALID_MASK                    0x80000000
#define XAIE2PGBL_CORE_MODULE_PC_EVENT1_VALID_DEFVAL                  0x0
#define XAIE2PGBL_CORE_MODULE_PC_EVENT1_PC_ADDRESS_LSB                0
#define XAIE2PGBL_CORE_MODULE_PC_EVENT1_PC_ADDRESS_WIDTH              14
#define XAIE2PGBL_CORE_MODULE_PC_EVENT1_PC_ADDRESS_MASK               0x00003FFF
#define XAIE2PGBL_CORE_MODULE_PC_EVENT1_PC_ADDRESS_DEFVAL             0x0

#define XAIE2PGBL_CORE_MODULE_PC_EVENT2                                 0x00032028
#define XAIE2PGBL_CORE_MODULE_PC_EVENT2_WIDTH                           32
#define XAIE2PGBL_CORE_MODULE_PC_EVENT2_MASK                            0x80003FFF
#define XAIE2PGBL_CORE_MODULE_PC_EVENT2_VALID_LSB                     31
#define XAIE2PGBL_CORE_MODULE_PC_EVENT2_VALID_WIDTH                   1
#define XAIE2PGBL_CORE_MODULE_PC_EVENT2_VALID_MASK                    0x80000000
#define XAIE2PGBL_CORE_MODULE_PC_EVENT2_VALID_DEFVAL                  0x0
#define XAIE2PGBL_CORE_MODULE_PC_EVENT2_PC_ADDRESS_LSB                0
#define XAIE2PGBL_CORE_MODULE_PC_EVENT2_PC_ADDRESS_WIDTH              14
#define XAIE2PGBL_CORE_MODULE_PC_EVENT2_PC_ADDRESS_MASK               0x00003FFF
#define XAIE2PGBL_CORE_MODULE_PC_EVENT2_PC_ADDRESS_DEFVAL             0x0

#define XAIE2PGBL_CORE_MODULE_PC_EVENT3                                 0x0003202C
#define XAIE2PGBL_CORE_MODULE_PC_EVENT3_WIDTH                           32
#define XAIE2PGBL_CORE_MODULE_PC_EVENT3_MASK                            0x80003FFF
#define XAIE2PGBL_CORE_MODULE_PC_EVENT3_VALID_LSB                     31
#define XAIE2PGBL_CORE_MODULE_PC_EVENT3_VALID_WIDTH                   1
#define XAIE2PGBL_CORE_MODULE_PC_EVENT3_VALID_MASK                    0x80000000
#define XAIE2PGBL_CORE_MODULE_PC_EVENT3_VALID_DEFVAL                  0x0
#define XAIE2PGBL_CORE_MODULE_PC_EVENT3_PC_ADDRESS_LSB                0
#define XAIE2PGBL_CORE_MODULE_PC_EVENT3_PC_ADDRESS_WIDTH              14
#define XAIE2PGBL_CORE_MODULE_PC_EVENT3_PC_ADDRESS_MASK               0x00003FFF
#define XAIE2PGBL_CORE_MODULE_PC_EVENT3_PC_ADDRESS_DEFVAL             0x0

#define XAIE2PGBL_CORE_MODULE_ERROR_HALT_CONTROL                        0x00032030
#define XAIE2PGBL_CORE_MODULE_ERROR_HALT_CONTROL_WIDTH                  32
#define XAIE2PGBL_CORE_MODULE_ERROR_HALT_CONTROL_MASK                   0x00000001
#define XAIE2PGBL_CORE_MODULE_ERROR_HALT_CONTROL_ERROR_HALT_LSB       0
#define XAIE2PGBL_CORE_MODULE_ERROR_HALT_CONTROL_ERROR_HALT_WIDTH     1
#define XAIE2PGBL_CORE_MODULE_ERROR_HALT_CONTROL_ERROR_HALT_MASK      0x00000001
#define XAIE2PGBL_CORE_MODULE_ERROR_HALT_CONTROL_ERROR_HALT_DEFVAL    0x0

#define XAIE2PGBL_CORE_MODULE_ERROR_HALT_EVENT                          0x00032034
#define XAIE2PGBL_CORE_MODULE_ERROR_HALT_EVENT_WIDTH                    32
#define XAIE2PGBL_CORE_MODULE_ERROR_HALT_EVENT_MASK                     0x0000007F
#define XAIE2PGBL_CORE_MODULE_ERROR_HALT_EVENT_ERROR_HALT_CORE_EVENT_LSB 0
#define XAIE2PGBL_CORE_MODULE_ERROR_HALT_EVENT_ERROR_HALT_CORE_EVENT_WIDTH 7
#define XAIE2PGBL_CORE_MODULE_ERROR_HALT_EVENT_ERROR_HALT_CORE_EVENT_MASK 0x0000007F
#define XAIE2PGBL_CORE_MODULE_ERROR_HALT_EVENT_ERROR_HALT_CORE_EVENT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_CORE_PROCESSOR_BUS                        0x00032038
#define XAIE2PGBL_CORE_MODULE_CORE_PROCESSOR_BUS_WIDTH                  32
#define XAIE2PGBL_CORE_MODULE_CORE_PROCESSOR_BUS_MASK                   0x00000005
#define XAIE2PGBL_CORE_MODULE_CORE_PROCESSOR_BUS_SLVERR_ON_ACCESS_LSB 2
#define XAIE2PGBL_CORE_MODULE_CORE_PROCESSOR_BUS_SLVERR_ON_ACCESS_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_CORE_PROCESSOR_BUS_SLVERR_ON_ACCESS_MASK 0x00000004
#define XAIE2PGBL_CORE_MODULE_CORE_PROCESSOR_BUS_SLVERR_ON_ACCESS_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_CORE_PROCESSOR_BUS_ENABLE_LSB           0
#define XAIE2PGBL_CORE_MODULE_CORE_PROCESSOR_BUS_ENABLE_WIDTH         1
#define XAIE2PGBL_CORE_MODULE_CORE_PROCESSOR_BUS_ENABLE_MASK          0x00000001
#define XAIE2PGBL_CORE_MODULE_CORE_PROCESSOR_BUS_ENABLE_DEFVAL        0x0

#define XAIE2PGBL_CORE_MODULE_ECC_CONTROL                               0x00032100
#define XAIE2PGBL_CORE_MODULE_ECC_CONTROL_WIDTH                         32
#define XAIE2PGBL_CORE_MODULE_ECC_CONTROL_MASK                          0x00000003
#define XAIE2PGBL_CORE_MODULE_ECC_CONTROL_UNSTALL_CORE_LSB            1
#define XAIE2PGBL_CORE_MODULE_ECC_CONTROL_UNSTALL_CORE_WIDTH          1
#define XAIE2PGBL_CORE_MODULE_ECC_CONTROL_UNSTALL_CORE_MASK           0x00000002
#define XAIE2PGBL_CORE_MODULE_ECC_CONTROL_UNSTALL_CORE_DEFVAL         0x0
#define XAIE2PGBL_CORE_MODULE_ECC_CONTROL_STALL_CORE_CONTROL_LSB      0
#define XAIE2PGBL_CORE_MODULE_ECC_CONTROL_STALL_CORE_CONTROL_WIDTH    1
#define XAIE2PGBL_CORE_MODULE_ECC_CONTROL_STALL_CORE_CONTROL_MASK     0x00000001
#define XAIE2PGBL_CORE_MODULE_ECC_CONTROL_STALL_CORE_CONTROL_DEFVAL   0x0

#define XAIE2PGBL_CORE_MODULE_ECC_SCRUBBING_EVENT                       0x00032110
#define XAIE2PGBL_CORE_MODULE_ECC_SCRUBBING_EVENT_WIDTH                 32
#define XAIE2PGBL_CORE_MODULE_ECC_SCRUBBING_EVENT_MASK                  0x0000007F
#define XAIE2PGBL_CORE_MODULE_ECC_SCRUBBING_EVENT_SCRUBBING_EVENT_NUMBER_LSB 0
#define XAIE2PGBL_CORE_MODULE_ECC_SCRUBBING_EVENT_SCRUBBING_EVENT_NUMBER_WIDTH 7
#define XAIE2PGBL_CORE_MODULE_ECC_SCRUBBING_EVENT_SCRUBBING_EVENT_NUMBER_MASK 0x0000007F
#define XAIE2PGBL_CORE_MODULE_ECC_SCRUBBING_EVENT_SCRUBBING_EVENT_NUMBER_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_ECC_FAILING_ADDRESS                       0x00032120
#define XAIE2PGBL_CORE_MODULE_ECC_FAILING_ADDRESS_WIDTH                 32
#define XAIE2PGBL_CORE_MODULE_ECC_FAILING_ADDRESS_MASK                  0x0000FFFF
#define XAIE2PGBL_CORE_MODULE_ECC_FAILING_ADDRESS_CLEAR_FAILING_ADDRESS_LSB 15
#define XAIE2PGBL_CORE_MODULE_ECC_FAILING_ADDRESS_CLEAR_FAILING_ADDRESS_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_ECC_FAILING_ADDRESS_CLEAR_FAILING_ADDRESS_MASK 0x00008000
#define XAIE2PGBL_CORE_MODULE_ECC_FAILING_ADDRESS_CLEAR_FAILING_ADDRESS_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_ECC_FAILING_ADDRESS_ACCESS_TYPE_LSB     14
#define XAIE2PGBL_CORE_MODULE_ECC_FAILING_ADDRESS_ACCESS_TYPE_WIDTH   1
#define XAIE2PGBL_CORE_MODULE_ECC_FAILING_ADDRESS_ACCESS_TYPE_MASK    0x00004000
#define XAIE2PGBL_CORE_MODULE_ECC_FAILING_ADDRESS_ACCESS_TYPE_DEFVAL  0x0
#define XAIE2PGBL_CORE_MODULE_ECC_FAILING_ADDRESS_ECC_ERROR_DETECTION_ADDRESS_LSB 0
#define XAIE2PGBL_CORE_MODULE_ECC_FAILING_ADDRESS_ECC_ERROR_DETECTION_ADDRESS_WIDTH 14
#define XAIE2PGBL_CORE_MODULE_ECC_FAILING_ADDRESS_ECC_ERROR_DETECTION_ADDRESS_MASK 0x00003FFF
#define XAIE2PGBL_CORE_MODULE_ECC_FAILING_ADDRESS_ECC_ERROR_DETECTION_ADDRESS_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_TIMER_CONTROL                             0x00034000
#define XAIE2PGBL_CORE_MODULE_TIMER_CONTROL_WIDTH                       32
#define XAIE2PGBL_CORE_MODULE_TIMER_CONTROL_MASK                        0x80007F00
#define XAIE2PGBL_CORE_MODULE_TIMER_CONTROL_RESET_LSB                 31
#define XAIE2PGBL_CORE_MODULE_TIMER_CONTROL_RESET_WIDTH               1
#define XAIE2PGBL_CORE_MODULE_TIMER_CONTROL_RESET_MASK                0x80000000
#define XAIE2PGBL_CORE_MODULE_TIMER_CONTROL_RESET_DEFVAL              0x0
#define XAIE2PGBL_CORE_MODULE_TIMER_CONTROL_RESET_EVENT_LSB           8
#define XAIE2PGBL_CORE_MODULE_TIMER_CONTROL_RESET_EVENT_WIDTH         7
#define XAIE2PGBL_CORE_MODULE_TIMER_CONTROL_RESET_EVENT_MASK          0x00007F00
#define XAIE2PGBL_CORE_MODULE_TIMER_CONTROL_RESET_EVENT_DEFVAL        0x0

#define XAIE2PGBL_CORE_MODULE_EVENT_GENERATE                            0x00034008
#define XAIE2PGBL_CORE_MODULE_EVENT_GENERATE_WIDTH                      32
#define XAIE2PGBL_CORE_MODULE_EVENT_GENERATE_MASK                       0x0000007F
#define XAIE2PGBL_CORE_MODULE_EVENT_GENERATE_EVENT_LSB                0
#define XAIE2PGBL_CORE_MODULE_EVENT_GENERATE_EVENT_WIDTH              7
#define XAIE2PGBL_CORE_MODULE_EVENT_GENERATE_EVENT_MASK               0x0000007F
#define XAIE2PGBL_CORE_MODULE_EVENT_GENERATE_EVENT_DEFVAL             0x0

#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST0                          0x00034010
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST0_WIDTH                    32
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST0_MASK                     0x0000007F
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST0_EVENT_LSB              0
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST0_EVENT_WIDTH            7
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST0_EVENT_MASK             0x0000007F
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST0_EVENT_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST1                          0x00034014
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST1_WIDTH                    32
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST1_MASK                     0x0000007F
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST1_EVENT_LSB              0
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST1_EVENT_WIDTH            7
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST1_EVENT_MASK             0x0000007F
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST1_EVENT_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST2                          0x00034018
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST2_WIDTH                    32
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST2_MASK                     0x0000007F
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST2_EVENT_LSB              0
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST2_EVENT_WIDTH            7
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST2_EVENT_MASK             0x0000007F
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST2_EVENT_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST3                          0x0003401C
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST3_WIDTH                    32
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST3_MASK                     0x0000007F
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST3_EVENT_LSB              0
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST3_EVENT_WIDTH            7
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST3_EVENT_MASK             0x0000007F
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST3_EVENT_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST4                          0x00034020
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST4_WIDTH                    32
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST4_MASK                     0x0000007F
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST4_EVENT_LSB              0
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST4_EVENT_WIDTH            7
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST4_EVENT_MASK             0x0000007F
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST4_EVENT_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST5                          0x00034024
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST5_WIDTH                    32
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST5_MASK                     0x0000007F
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST5_EVENT_LSB              0
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST5_EVENT_WIDTH            7
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST5_EVENT_MASK             0x0000007F
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST5_EVENT_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST6                          0x00034028
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST6_WIDTH                    32
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST6_MASK                     0x0000007F
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST6_EVENT_LSB              0
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST6_EVENT_WIDTH            7
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST6_EVENT_MASK             0x0000007F
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST6_EVENT_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST7                          0x0003402C
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST7_WIDTH                    32
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST7_MASK                     0x0000007F
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST7_EVENT_LSB              0
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST7_EVENT_WIDTH            7
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST7_EVENT_MASK             0x0000007F
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST7_EVENT_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST8                          0x00034030
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST8_WIDTH                    32
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST8_MASK                     0x0000007F
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST8_EVENT_LSB              0
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST8_EVENT_WIDTH            7
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST8_EVENT_MASK             0x0000007F
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST8_EVENT_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST9                          0x00034034
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST9_WIDTH                    32
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST9_MASK                     0x0000007F
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST9_EVENT_LSB              0
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST9_EVENT_WIDTH            7
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST9_EVENT_MASK             0x0000007F
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST9_EVENT_DEFVAL           0x0

#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST10                         0x00034038
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST10_WIDTH                   32
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST10_MASK                    0x0000007F
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST10_EVENT_LSB             0
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST10_EVENT_WIDTH           7
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST10_EVENT_MASK            0x0000007F
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST10_EVENT_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST11                         0x0003403C
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST11_WIDTH                   32
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST11_MASK                    0x0000007F
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST11_EVENT_LSB             0
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST11_EVENT_WIDTH           7
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST11_EVENT_MASK            0x0000007F
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST11_EVENT_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST12                         0x00034040
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST12_WIDTH                   32
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST12_MASK                    0x0000007F
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST12_EVENT_LSB             0
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST12_EVENT_WIDTH           7
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST12_EVENT_MASK            0x0000007F
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST12_EVENT_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST13                         0x00034044
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST13_WIDTH                   32
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST13_MASK                    0x0000007F
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST13_EVENT_LSB             0
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST13_EVENT_WIDTH           7
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST13_EVENT_MASK            0x0000007F
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST13_EVENT_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST14                         0x00034048
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST14_WIDTH                   32
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST14_MASK                    0x0000007F
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST14_EVENT_LSB             0
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST14_EVENT_WIDTH           7
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST14_EVENT_MASK            0x0000007F
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST14_EVENT_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST15                         0x0003404C
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST15_WIDTH                   32
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST15_MASK                    0x0000007F
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST15_EVENT_LSB             0
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST15_EVENT_WIDTH           7
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST15_EVENT_MASK            0x0000007F
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST15_EVENT_DEFVAL          0x0

#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_SOUTH_SET           0x00034050
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_SOUTH_SET_WIDTH     32
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_SOUTH_SET_MASK      0x0000FFFF
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_SOUTH_SET_SET_LSB 0
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_SOUTH_SET_SET_WIDTH 16
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_SOUTH_SET_SET_MASK 0x0000FFFF
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_SOUTH_SET_SET_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_SOUTH_CLR           0x00034054
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_SOUTH_CLR_WIDTH     32
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_SOUTH_CLR_MASK      0x0000FFFF
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_SOUTH_CLR_CLEAR_LSB 0
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_SOUTH_CLR_CLEAR_WIDTH 16
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_SOUTH_CLR_CLEAR_MASK 0x0000FFFF
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_SOUTH_CLR_CLEAR_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_SOUTH_VALUE         0x00034058
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_SOUTH_VALUE_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_SOUTH_VALUE_MASK    0x0000FFFF
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_SOUTH_VALUE_VALUE_LSB 0
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_SOUTH_VALUE_VALUE_WIDTH 16
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_SOUTH_VALUE_VALUE_MASK 0x0000FFFF
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_SOUTH_VALUE_VALUE_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_WEST_SET            0x00034060
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_WEST_SET_WIDTH      32
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_WEST_SET_MASK       0x0000FFFF
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_WEST_SET_SET_LSB  0
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_WEST_SET_SET_WIDTH 16
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_WEST_SET_SET_MASK 0x0000FFFF
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_WEST_SET_SET_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_WEST_CLR            0x00034064
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_WEST_CLR_WIDTH      32
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_WEST_CLR_MASK       0x0000FFFF
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_WEST_CLR_CLEAR_LSB 0
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_WEST_CLR_CLEAR_WIDTH 16
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_WEST_CLR_CLEAR_MASK 0x0000FFFF
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_WEST_CLR_CLEAR_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_WEST_VALUE          0x00034068
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_WEST_VALUE_WIDTH    32
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_WEST_VALUE_MASK     0x0000FFFF
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_WEST_VALUE_VALUE_LSB 0
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_WEST_VALUE_VALUE_WIDTH 16
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_WEST_VALUE_VALUE_MASK 0x0000FFFF
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_WEST_VALUE_VALUE_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_NORTH_SET           0x00034070
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_NORTH_SET_WIDTH     32
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_NORTH_SET_MASK      0x0000FFFF
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_NORTH_SET_SET_LSB 0
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_NORTH_SET_SET_WIDTH 16
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_NORTH_SET_SET_MASK 0x0000FFFF
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_NORTH_SET_SET_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_NORTH_CLR           0x00034074
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_NORTH_CLR_WIDTH     32
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_NORTH_CLR_MASK      0x0000FFFF
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_NORTH_CLR_CLEAR_LSB 0
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_NORTH_CLR_CLEAR_WIDTH 16
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_NORTH_CLR_CLEAR_MASK 0x0000FFFF
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_NORTH_CLR_CLEAR_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_NORTH_VALUE         0x00034078
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_NORTH_VALUE_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_NORTH_VALUE_MASK    0x0000FFFF
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_NORTH_VALUE_VALUE_LSB 0
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_NORTH_VALUE_VALUE_WIDTH 16
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_NORTH_VALUE_VALUE_MASK 0x0000FFFF
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_NORTH_VALUE_VALUE_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_EAST_SET            0x00034080
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_EAST_SET_WIDTH      32
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_EAST_SET_MASK       0x0000FFFF
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_EAST_SET_SET_LSB  0
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_EAST_SET_SET_WIDTH 16
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_EAST_SET_SET_MASK 0x0000FFFF
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_EAST_SET_SET_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_EAST_CLR            0x00034084
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_EAST_CLR_WIDTH      32
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_EAST_CLR_MASK       0x0000FFFF
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_EAST_CLR_CLEAR_LSB 0
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_EAST_CLR_CLEAR_WIDTH 16
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_EAST_CLR_CLEAR_MASK 0x0000FFFF
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_EAST_CLR_CLEAR_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_EAST_VALUE          0x00034088
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_EAST_VALUE_WIDTH    32
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_EAST_VALUE_MASK     0x0000FFFF
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_EAST_VALUE_VALUE_LSB 0
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_EAST_VALUE_VALUE_WIDTH 16
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_EAST_VALUE_VALUE_MASK 0x0000FFFF
#define XAIE2PGBL_CORE_MODULE_EVENT_BROADCAST_BLOCK_EAST_VALUE_VALUE_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_TRACE_CONTROL0                            0x000340D0
#define XAIE2PGBL_CORE_MODULE_TRACE_CONTROL0_WIDTH                      32
#define XAIE2PGBL_CORE_MODULE_TRACE_CONTROL0_MASK                       0x7F7F0003
#define XAIE2PGBL_CORE_MODULE_TRACE_CONTROL0_TRACE_STOP_EVENT_LSB     24
#define XAIE2PGBL_CORE_MODULE_TRACE_CONTROL0_TRACE_STOP_EVENT_WIDTH   7
#define XAIE2PGBL_CORE_MODULE_TRACE_CONTROL0_TRACE_STOP_EVENT_MASK    0x7F000000
#define XAIE2PGBL_CORE_MODULE_TRACE_CONTROL0_TRACE_STOP_EVENT_DEFVAL  0x0
#define XAIE2PGBL_CORE_MODULE_TRACE_CONTROL0_TRACE_START_EVENT_LSB    16
#define XAIE2PGBL_CORE_MODULE_TRACE_CONTROL0_TRACE_START_EVENT_WIDTH  7
#define XAIE2PGBL_CORE_MODULE_TRACE_CONTROL0_TRACE_START_EVENT_MASK   0x007F0000
#define XAIE2PGBL_CORE_MODULE_TRACE_CONTROL0_TRACE_START_EVENT_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_TRACE_CONTROL0_MODE_LSB                 0
#define XAIE2PGBL_CORE_MODULE_TRACE_CONTROL0_MODE_WIDTH               2
#define XAIE2PGBL_CORE_MODULE_TRACE_CONTROL0_MODE_MASK                0x00000003
#define XAIE2PGBL_CORE_MODULE_TRACE_CONTROL0_MODE_DEFVAL              0x0

#define XAIE2PGBL_CORE_MODULE_TRACE_CONTROL1                            0x000340D4
#define XAIE2PGBL_CORE_MODULE_TRACE_CONTROL1_WIDTH                      32
#define XAIE2PGBL_CORE_MODULE_TRACE_CONTROL1_MASK                       0x0000701F
#define XAIE2PGBL_CORE_MODULE_TRACE_CONTROL1_PACKET_TYPE_LSB          12
#define XAIE2PGBL_CORE_MODULE_TRACE_CONTROL1_PACKET_TYPE_WIDTH        3
#define XAIE2PGBL_CORE_MODULE_TRACE_CONTROL1_PACKET_TYPE_MASK         0x00007000
#define XAIE2PGBL_CORE_MODULE_TRACE_CONTROL1_PACKET_TYPE_DEFVAL       0x0
#define XAIE2PGBL_CORE_MODULE_TRACE_CONTROL1_ID_LSB                   0
#define XAIE2PGBL_CORE_MODULE_TRACE_CONTROL1_ID_WIDTH                 5
#define XAIE2PGBL_CORE_MODULE_TRACE_CONTROL1_ID_MASK                  0x0000001F
#define XAIE2PGBL_CORE_MODULE_TRACE_CONTROL1_ID_DEFVAL                0x0

#define XAIE2PGBL_CORE_MODULE_TRACE_STATUS                              0x000340D8
#define XAIE2PGBL_CORE_MODULE_TRACE_STATUS_WIDTH                        32
#define XAIE2PGBL_CORE_MODULE_TRACE_STATUS_MASK                         0x00000307
#define XAIE2PGBL_CORE_MODULE_TRACE_STATUS_STATE_LSB                  8
#define XAIE2PGBL_CORE_MODULE_TRACE_STATUS_STATE_WIDTH                2
#define XAIE2PGBL_CORE_MODULE_TRACE_STATUS_STATE_MASK                 0x00000300
#define XAIE2PGBL_CORE_MODULE_TRACE_STATUS_STATE_DEFVAL               0x0
#define XAIE2PGBL_CORE_MODULE_TRACE_STATUS_MODE_LSB                   0
#define XAIE2PGBL_CORE_MODULE_TRACE_STATUS_MODE_WIDTH                 3
#define XAIE2PGBL_CORE_MODULE_TRACE_STATUS_MODE_MASK                  0x00000007
#define XAIE2PGBL_CORE_MODULE_TRACE_STATUS_MODE_DEFVAL                0x0

#define XAIE2PGBL_CORE_MODULE_TRACE_EVENT0                              0x000340E0
#define XAIE2PGBL_CORE_MODULE_TRACE_EVENT0_WIDTH                        32
#define XAIE2PGBL_CORE_MODULE_TRACE_EVENT0_MASK                         0x7F7F7F7F
#define XAIE2PGBL_CORE_MODULE_TRACE_EVENT0_TRACE_EVENT3_LSB           24
#define XAIE2PGBL_CORE_MODULE_TRACE_EVENT0_TRACE_EVENT3_WIDTH         7
#define XAIE2PGBL_CORE_MODULE_TRACE_EVENT0_TRACE_EVENT3_MASK          0x7F000000
#define XAIE2PGBL_CORE_MODULE_TRACE_EVENT0_TRACE_EVENT3_DEFVAL        0x0
#define XAIE2PGBL_CORE_MODULE_TRACE_EVENT0_TRACE_EVENT2_LSB           16
#define XAIE2PGBL_CORE_MODULE_TRACE_EVENT0_TRACE_EVENT2_WIDTH         7
#define XAIE2PGBL_CORE_MODULE_TRACE_EVENT0_TRACE_EVENT2_MASK          0x007F0000
#define XAIE2PGBL_CORE_MODULE_TRACE_EVENT0_TRACE_EVENT2_DEFVAL        0x0
#define XAIE2PGBL_CORE_MODULE_TRACE_EVENT0_TRACE_EVENT1_LSB           8
#define XAIE2PGBL_CORE_MODULE_TRACE_EVENT0_TRACE_EVENT1_WIDTH         7
#define XAIE2PGBL_CORE_MODULE_TRACE_EVENT0_TRACE_EVENT1_MASK          0x00007F00
#define XAIE2PGBL_CORE_MODULE_TRACE_EVENT0_TRACE_EVENT1_DEFVAL        0x0
#define XAIE2PGBL_CORE_MODULE_TRACE_EVENT0_TRACE_EVENT0_LSB           0
#define XAIE2PGBL_CORE_MODULE_TRACE_EVENT0_TRACE_EVENT0_WIDTH         7
#define XAIE2PGBL_CORE_MODULE_TRACE_EVENT0_TRACE_EVENT0_MASK          0x0000007F
#define XAIE2PGBL_CORE_MODULE_TRACE_EVENT0_TRACE_EVENT0_DEFVAL        0x0

#define XAIE2PGBL_CORE_MODULE_TRACE_EVENT1                              0x000340E4
#define XAIE2PGBL_CORE_MODULE_TRACE_EVENT1_WIDTH                        32
#define XAIE2PGBL_CORE_MODULE_TRACE_EVENT1_MASK                         0x7F7F7F7F
#define XAIE2PGBL_CORE_MODULE_TRACE_EVENT1_TRACE_EVENT7_LSB           24
#define XAIE2PGBL_CORE_MODULE_TRACE_EVENT1_TRACE_EVENT7_WIDTH         7
#define XAIE2PGBL_CORE_MODULE_TRACE_EVENT1_TRACE_EVENT7_MASK          0x7F000000
#define XAIE2PGBL_CORE_MODULE_TRACE_EVENT1_TRACE_EVENT7_DEFVAL        0x0
#define XAIE2PGBL_CORE_MODULE_TRACE_EVENT1_TRACE_EVENT6_LSB           16
#define XAIE2PGBL_CORE_MODULE_TRACE_EVENT1_TRACE_EVENT6_WIDTH         7
#define XAIE2PGBL_CORE_MODULE_TRACE_EVENT1_TRACE_EVENT6_MASK          0x007F0000
#define XAIE2PGBL_CORE_MODULE_TRACE_EVENT1_TRACE_EVENT6_DEFVAL        0x0
#define XAIE2PGBL_CORE_MODULE_TRACE_EVENT1_TRACE_EVENT5_LSB           8
#define XAIE2PGBL_CORE_MODULE_TRACE_EVENT1_TRACE_EVENT5_WIDTH         7
#define XAIE2PGBL_CORE_MODULE_TRACE_EVENT1_TRACE_EVENT5_MASK          0x00007F00
#define XAIE2PGBL_CORE_MODULE_TRACE_EVENT1_TRACE_EVENT5_DEFVAL        0x0
#define XAIE2PGBL_CORE_MODULE_TRACE_EVENT1_TRACE_EVENT4_LSB           0
#define XAIE2PGBL_CORE_MODULE_TRACE_EVENT1_TRACE_EVENT4_WIDTH         7
#define XAIE2PGBL_CORE_MODULE_TRACE_EVENT1_TRACE_EVENT4_MASK          0x0000007F
#define XAIE2PGBL_CORE_MODULE_TRACE_EVENT1_TRACE_EVENT4_DEFVAL        0x0

#define XAIE2PGBL_CORE_MODULE_TIMER_TRIG_EVENT_LOW_VALUE                0x000340F0
#define XAIE2PGBL_CORE_MODULE_TIMER_TRIG_EVENT_LOW_VALUE_WIDTH          32
#define XAIE2PGBL_CORE_MODULE_TIMER_TRIG_EVENT_LOW_VALUE_MASK           0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_TIMER_TRIG_EVENT_LOW_VALUE_TIMERTRIGLOW_LSB 0
#define XAIE2PGBL_CORE_MODULE_TIMER_TRIG_EVENT_LOW_VALUE_TIMERTRIGLOW_WIDTH 32
#define XAIE2PGBL_CORE_MODULE_TIMER_TRIG_EVENT_LOW_VALUE_TIMERTRIGLOW_MASK 0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_TIMER_TRIG_EVENT_LOW_VALUE_TIMERTRIGLOW_DEFVAL 0xFFFFFFFF

#define XAIE2PGBL_CORE_MODULE_TIMER_TRIG_EVENT_HIGH_VALUE               0x000340F4
#define XAIE2PGBL_CORE_MODULE_TIMER_TRIG_EVENT_HIGH_VALUE_WIDTH         32
#define XAIE2PGBL_CORE_MODULE_TIMER_TRIG_EVENT_HIGH_VALUE_MASK          0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_TIMER_TRIG_EVENT_HIGH_VALUE_TIMERTRIGHIGH_LSB 0
#define XAIE2PGBL_CORE_MODULE_TIMER_TRIG_EVENT_HIGH_VALUE_TIMERTRIGHIGH_WIDTH 32
#define XAIE2PGBL_CORE_MODULE_TIMER_TRIG_EVENT_HIGH_VALUE_TIMERTRIGHIGH_MASK 0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_TIMER_TRIG_EVENT_HIGH_VALUE_TIMERTRIGHIGH_DEFVAL 0xFFFFFFFF

#define XAIE2PGBL_CORE_MODULE_TIMER_LOW                                 0x000340F8
#define XAIE2PGBL_CORE_MODULE_TIMER_LOW_WIDTH                           32
#define XAIE2PGBL_CORE_MODULE_TIMER_LOW_MASK                            0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_TIMER_LOW_TIMERLOW_LSB                  0
#define XAIE2PGBL_CORE_MODULE_TIMER_LOW_TIMERLOW_WIDTH                32
#define XAIE2PGBL_CORE_MODULE_TIMER_LOW_TIMERLOW_MASK                 0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_TIMER_LOW_TIMERLOW_DEFVAL               0x0

#define XAIE2PGBL_CORE_MODULE_TIMER_HIGH                                0x000340FC
#define XAIE2PGBL_CORE_MODULE_TIMER_HIGH_WIDTH                          32
#define XAIE2PGBL_CORE_MODULE_TIMER_HIGH_MASK                           0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_TIMER_HIGH_TIMERHIGH_LSB                0
#define XAIE2PGBL_CORE_MODULE_TIMER_HIGH_TIMERHIGH_WIDTH              32
#define XAIE2PGBL_CORE_MODULE_TIMER_HIGH_TIMERHIGH_MASK               0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_TIMER_HIGH_TIMERHIGH_DEFVAL             0x0

#define XAIE2PGBL_CORE_MODULE_EVENT_STATUS0                             0x00034200
#define XAIE2PGBL_CORE_MODULE_EVENT_STATUS0_WIDTH                       32
#define XAIE2PGBL_CORE_MODULE_EVENT_STATUS0_MASK                        0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_EVENT_STATUS0_EVENT_31_0_STATUS_LSB     0
#define XAIE2PGBL_CORE_MODULE_EVENT_STATUS0_EVENT_31_0_STATUS_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_EVENT_STATUS0_EVENT_31_0_STATUS_MASK    0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_EVENT_STATUS0_EVENT_31_0_STATUS_DEFVAL  0x2

#define XAIE2PGBL_CORE_MODULE_EVENT_STATUS1                             0x00034204
#define XAIE2PGBL_CORE_MODULE_EVENT_STATUS1_WIDTH                       32
#define XAIE2PGBL_CORE_MODULE_EVENT_STATUS1_MASK                        0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_EVENT_STATUS1_EVENT_63_32_STATUS_LSB    0
#define XAIE2PGBL_CORE_MODULE_EVENT_STATUS1_EVENT_63_32_STATUS_WIDTH  32
#define XAIE2PGBL_CORE_MODULE_EVENT_STATUS1_EVENT_63_32_STATUS_MASK   0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_EVENT_STATUS1_EVENT_63_32_STATUS_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_EVENT_STATUS2                             0x00034208
#define XAIE2PGBL_CORE_MODULE_EVENT_STATUS2_WIDTH                       32
#define XAIE2PGBL_CORE_MODULE_EVENT_STATUS2_MASK                        0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_EVENT_STATUS2_EVENT_95_64_STATUS_LSB    0
#define XAIE2PGBL_CORE_MODULE_EVENT_STATUS2_EVENT_95_64_STATUS_WIDTH  32
#define XAIE2PGBL_CORE_MODULE_EVENT_STATUS2_EVENT_95_64_STATUS_MASK   0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_EVENT_STATUS2_EVENT_95_64_STATUS_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_EVENT_STATUS3                             0x0003420C
#define XAIE2PGBL_CORE_MODULE_EVENT_STATUS3_WIDTH                       32
#define XAIE2PGBL_CORE_MODULE_EVENT_STATUS3_MASK                        0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_EVENT_STATUS3_EVENT_127_96_STATUS_LSB   0
#define XAIE2PGBL_CORE_MODULE_EVENT_STATUS3_EVENT_127_96_STATUS_WIDTH 32
#define XAIE2PGBL_CORE_MODULE_EVENT_STATUS3_EVENT_127_96_STATUS_MASK  0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_EVENT_STATUS3_EVENT_127_96_STATUS_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_COMBO_EVENT_INPUTS                        0x00034400
#define XAIE2PGBL_CORE_MODULE_COMBO_EVENT_INPUTS_WIDTH                  32
#define XAIE2PGBL_CORE_MODULE_COMBO_EVENT_INPUTS_MASK                   0x7F7F7F7F
#define XAIE2PGBL_CORE_MODULE_COMBO_EVENT_INPUTS_EVENTD_LSB           24
#define XAIE2PGBL_CORE_MODULE_COMBO_EVENT_INPUTS_EVENTD_WIDTH         7
#define XAIE2PGBL_CORE_MODULE_COMBO_EVENT_INPUTS_EVENTD_MASK          0x7F000000
#define XAIE2PGBL_CORE_MODULE_COMBO_EVENT_INPUTS_EVENTD_DEFVAL        0x0
#define XAIE2PGBL_CORE_MODULE_COMBO_EVENT_INPUTS_EVENTC_LSB           16
#define XAIE2PGBL_CORE_MODULE_COMBO_EVENT_INPUTS_EVENTC_WIDTH         7
#define XAIE2PGBL_CORE_MODULE_COMBO_EVENT_INPUTS_EVENTC_MASK          0x007F0000
#define XAIE2PGBL_CORE_MODULE_COMBO_EVENT_INPUTS_EVENTC_DEFVAL        0x0
#define XAIE2PGBL_CORE_MODULE_COMBO_EVENT_INPUTS_EVENTB_LSB           8
#define XAIE2PGBL_CORE_MODULE_COMBO_EVENT_INPUTS_EVENTB_WIDTH         7
#define XAIE2PGBL_CORE_MODULE_COMBO_EVENT_INPUTS_EVENTB_MASK          0x00007F00
#define XAIE2PGBL_CORE_MODULE_COMBO_EVENT_INPUTS_EVENTB_DEFVAL        0x0
#define XAIE2PGBL_CORE_MODULE_COMBO_EVENT_INPUTS_EVENTA_LSB           0
#define XAIE2PGBL_CORE_MODULE_COMBO_EVENT_INPUTS_EVENTA_WIDTH         7
#define XAIE2PGBL_CORE_MODULE_COMBO_EVENT_INPUTS_EVENTA_MASK          0x0000007F
#define XAIE2PGBL_CORE_MODULE_COMBO_EVENT_INPUTS_EVENTA_DEFVAL        0x0

#define XAIE2PGBL_CORE_MODULE_COMBO_EVENT_CONTROL                       0x00034404
#define XAIE2PGBL_CORE_MODULE_COMBO_EVENT_CONTROL_WIDTH                 32
#define XAIE2PGBL_CORE_MODULE_COMBO_EVENT_CONTROL_MASK                  0x00030303
#define XAIE2PGBL_CORE_MODULE_COMBO_EVENT_CONTROL_COMBO2_LSB          16
#define XAIE2PGBL_CORE_MODULE_COMBO_EVENT_CONTROL_COMBO2_WIDTH        2
#define XAIE2PGBL_CORE_MODULE_COMBO_EVENT_CONTROL_COMBO2_MASK         0x00030000
#define XAIE2PGBL_CORE_MODULE_COMBO_EVENT_CONTROL_COMBO2_DEFVAL       0x0
#define XAIE2PGBL_CORE_MODULE_COMBO_EVENT_CONTROL_COMBO1_LSB          8
#define XAIE2PGBL_CORE_MODULE_COMBO_EVENT_CONTROL_COMBO1_WIDTH        2
#define XAIE2PGBL_CORE_MODULE_COMBO_EVENT_CONTROL_COMBO1_MASK         0x00000300
#define XAIE2PGBL_CORE_MODULE_COMBO_EVENT_CONTROL_COMBO1_DEFVAL       0x0
#define XAIE2PGBL_CORE_MODULE_COMBO_EVENT_CONTROL_COMBO0_LSB          0
#define XAIE2PGBL_CORE_MODULE_COMBO_EVENT_CONTROL_COMBO0_WIDTH        2
#define XAIE2PGBL_CORE_MODULE_COMBO_EVENT_CONTROL_COMBO0_MASK         0x00000003
#define XAIE2PGBL_CORE_MODULE_COMBO_EVENT_CONTROL_COMBO0_DEFVAL       0x0

#define XAIE2PGBL_CORE_MODULE_EDGE_DETECTION_EVENT_CONTROL              0x00034408
#define XAIE2PGBL_CORE_MODULE_EDGE_DETECTION_EVENT_CONTROL_WIDTH        32
#define XAIE2PGBL_CORE_MODULE_EDGE_DETECTION_EVENT_CONTROL_MASK         0x067F067F
#define XAIE2PGBL_CORE_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_1_TRIGGER_FALLING_LSB 26
#define XAIE2PGBL_CORE_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_1_TRIGGER_FALLING_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_1_TRIGGER_FALLING_MASK 0x04000000
#define XAIE2PGBL_CORE_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_1_TRIGGER_FALLING_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_1_TRIGGER_RISING_LSB 25
#define XAIE2PGBL_CORE_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_1_TRIGGER_RISING_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_1_TRIGGER_RISING_MASK 0x02000000
#define XAIE2PGBL_CORE_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_1_TRIGGER_RISING_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_EVENT_1_LSB 16
#define XAIE2PGBL_CORE_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_EVENT_1_WIDTH 7
#define XAIE2PGBL_CORE_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_EVENT_1_MASK 0x007F0000
#define XAIE2PGBL_CORE_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_EVENT_1_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_0_TRIGGER_FALLING_LSB 10
#define XAIE2PGBL_CORE_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_0_TRIGGER_FALLING_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_0_TRIGGER_FALLING_MASK 0x00000400
#define XAIE2PGBL_CORE_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_0_TRIGGER_FALLING_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_0_TRIGGER_RISING_LSB 9
#define XAIE2PGBL_CORE_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_0_TRIGGER_RISING_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_0_TRIGGER_RISING_MASK 0x00000200
#define XAIE2PGBL_CORE_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_0_TRIGGER_RISING_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_EVENT_0_LSB 0
#define XAIE2PGBL_CORE_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_EVENT_0_WIDTH 7
#define XAIE2PGBL_CORE_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_EVENT_0_MASK 0x0000007F
#define XAIE2PGBL_CORE_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_EVENT_0_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE                      0x00034500
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_WIDTH                32
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_MASK                 0x00000FFF
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_EDGE_DETECTION_EVENT_1_LSB 11
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_EDGE_DETECTION_EVENT_1_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_EDGE_DETECTION_EVENT_1_MASK 0x00000800
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_EDGE_DETECTION_EVENT_1_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_EDGE_DETECTION_EVENT_0_LSB 10
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_EDGE_DETECTION_EVENT_0_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_EDGE_DETECTION_EVENT_0_MASK 0x00000400
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_EDGE_DETECTION_EVENT_0_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_COMBO_EVENT_3_LSB  9
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_COMBO_EVENT_3_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_COMBO_EVENT_3_MASK 0x00000200
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_COMBO_EVENT_3_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_COMBO_EVENT_2_LSB  8
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_COMBO_EVENT_2_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_COMBO_EVENT_2_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_COMBO_EVENT_2_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_COMBO_EVENT_1_LSB  7
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_COMBO_EVENT_1_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_COMBO_EVENT_1_MASK 0x00000080
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_COMBO_EVENT_1_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_COMBO_EVENT_0_LSB  6
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_COMBO_EVENT_0_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_COMBO_EVENT_0_MASK 0x00000040
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_COMBO_EVENT_0_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_PERF_CNT3_LSB      5
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_PERF_CNT3_WIDTH    1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_PERF_CNT3_MASK     0x00000020
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_PERF_CNT3_DEFVAL   0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_PERF_CNT2_LSB      4
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_PERF_CNT2_WIDTH    1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_PERF_CNT2_MASK     0x00000010
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_PERF_CNT2_DEFVAL   0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_PERF_CNT1_LSB      3
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_PERF_CNT1_WIDTH    1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_PERF_CNT1_MASK     0x00000008
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_PERF_CNT1_DEFVAL   0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_PERF_CNT0_LSB      2
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_PERF_CNT0_WIDTH    1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_PERF_CNT0_MASK     0x00000004
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_PERF_CNT0_DEFVAL   0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_TIMER_VALUE_REACHED_LSB 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_TIMER_VALUE_REACHED_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_TIMER_VALUE_REACHED_MASK 0x00000002
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_TIMER_VALUE_REACHED_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_TIMER_SYNC_LSB     0
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_TIMER_SYNC_WIDTH   1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_TIMER_SYNC_MASK    0x00000001
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_0_ENABLE_TIMER_SYNC_DEFVAL  0x1

#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_PC_ENABLE                     0x00034504
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_PC_ENABLE_WIDTH               32
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_PC_ENABLE_MASK                0x0000003F
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_PC_ENABLE_PC_RANGE_2_3_LSB  5
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_PC_ENABLE_PC_RANGE_2_3_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_PC_ENABLE_PC_RANGE_2_3_MASK 0x00000020
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_PC_ENABLE_PC_RANGE_2_3_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_PC_ENABLE_PC_RANGE_0_1_LSB  4
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_PC_ENABLE_PC_RANGE_0_1_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_PC_ENABLE_PC_RANGE_0_1_MASK 0x00000010
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_PC_ENABLE_PC_RANGE_0_1_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_PC_ENABLE_PC_3_LSB          3
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_PC_ENABLE_PC_3_WIDTH        1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_PC_ENABLE_PC_3_MASK         0x00000008
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_PC_ENABLE_PC_3_DEFVAL       0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_PC_ENABLE_PC_2_LSB          2
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_PC_ENABLE_PC_2_WIDTH        1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_PC_ENABLE_PC_2_MASK         0x00000004
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_PC_ENABLE_PC_2_DEFVAL       0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_PC_ENABLE_PC_1_LSB          1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_PC_ENABLE_PC_1_WIDTH        1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_PC_ENABLE_PC_1_MASK         0x00000002
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_PC_ENABLE_PC_1_DEFVAL       0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_PC_ENABLE_PC_0_LSB          0
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_PC_ENABLE_PC_0_WIDTH        1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_PC_ENABLE_PC_0_MASK         0x00000001
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_PC_ENABLE_PC_0_DEFVAL       0x1

#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_STALL_ENABLE             0x00034508
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_STALL_ENABLE_WIDTH       32
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_STALL_ENABLE_MASK        0x000001FF
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_STALL_ENABLE_ECC_ERROR_STALL_LSB 8
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_STALL_ENABLE_ECC_ERROR_STALL_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_STALL_ENABLE_ECC_ERROR_STALL_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_STALL_ENABLE_ECC_ERROR_STALL_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_STALL_ENABLE_ECC_SCRUBBING_STALL_LSB 7
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_STALL_ENABLE_ECC_SCRUBBING_STALL_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_STALL_ENABLE_ECC_SCRUBBING_STALL_MASK 0x00000080
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_STALL_ENABLE_ECC_SCRUBBING_STALL_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_STALL_ENABLE_DISABLE_LSB 6
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_STALL_ENABLE_DISABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_STALL_ENABLE_DISABLE_MASK 0x00000040
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_STALL_ENABLE_DISABLE_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_STALL_ENABLE_ACTIVE_LSB 5
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_STALL_ENABLE_ACTIVE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_STALL_ENABLE_ACTIVE_MASK 0x00000020
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_STALL_ENABLE_ACTIVE_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_STALL_ENABLE_DEBUG_LSB 4
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_STALL_ENABLE_DEBUG_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_STALL_ENABLE_DEBUG_MASK 0x00000010
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_STALL_ENABLE_DEBUG_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_STALL_ENABLE_LOCK_STALL_LSB 3
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_STALL_ENABLE_LOCK_STALL_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_STALL_ENABLE_LOCK_STALL_MASK 0x00000008
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_STALL_ENABLE_LOCK_STALL_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_STALL_ENABLE_CASCADE_STALL_LSB 2
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_STALL_ENABLE_CASCADE_STALL_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_STALL_ENABLE_CASCADE_STALL_MASK 0x00000004
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_STALL_ENABLE_CASCADE_STALL_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_STALL_ENABLE_STREAM_STALL_LSB 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_STALL_ENABLE_STREAM_STALL_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_STALL_ENABLE_STREAM_STALL_MASK 0x00000002
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_STALL_ENABLE_STREAM_STALL_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_STALL_ENABLE_MEMORY_STALL_LSB 0
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_STALL_ENABLE_MEMORY_STALL_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_STALL_ENABLE_MEMORY_STALL_MASK 0x00000001
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_STALL_ENABLE_MEMORY_STALL_DEFVAL 0x1

#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE      0x0003450C
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_WIDTH 32
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_MASK 0x00001FFF
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_LOCK_RELEASE_REQ_LSB 12
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_LOCK_RELEASE_REQ_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_LOCK_RELEASE_REQ_MASK 0x00001000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_LOCK_RELEASE_REQ_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_LOCK_ACQUIRE_REQ_LSB 11
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_LOCK_ACQUIRE_REQ_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_LOCK_ACQUIRE_REQ_MASK 0x00000800
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_LOCK_ACQUIRE_REQ_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_CASCADE_PUT_LSB 10
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_CASCADE_PUT_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_CASCADE_PUT_MASK 0x00000400
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_CASCADE_PUT_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_CASCADE_GET_LSB 9
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_CASCADE_GET_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_CASCADE_GET_MASK 0x00000200
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_CASCADE_GET_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_STREAM_PUT_LSB 8
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_STREAM_PUT_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_STREAM_PUT_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_STREAM_PUT_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_STREAM_GET_LSB 7
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_STREAM_GET_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_STREAM_GET_MASK 0x00000080
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_STREAM_GET_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_STORE_LSB 6
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_STORE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_STORE_MASK 0x00000040
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_STORE_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_LOAD_LSB 5
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_LOAD_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_LOAD_MASK 0x00000020
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_LOAD_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_VECTOR_LSB 4
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_VECTOR_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_VECTOR_MASK 0x00000010
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_VECTOR_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_RETURN_LSB 3
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_RETURN_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_RETURN_MASK 0x00000008
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_RETURN_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_CALL_LSB 2
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_CALL_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_CALL_MASK 0x00000004
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_CALL_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_EVENT_1_LSB 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_EVENT_1_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_EVENT_1_MASK 0x00000002
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_EVENT_1_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_EVENT_0_LSB 0
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_EVENT_0_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_EVENT_0_MASK 0x00000001
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_CORE_PROGRAM_FLOW_ENABLE_INSTR_EVENT_0_DEFVAL 0x1

#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE                0x00034510
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_WIDTH          32
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_MASK           0x01FFFFFF
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_PROCESSOR_BUS_ERROR_LSB 24
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_PROCESSOR_BUS_ERROR_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_PROCESSOR_BUS_ERROR_MASK 0x01000000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_PROCESSOR_BUS_ERROR_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_STREAM_SWITCH_PORT_PARITY_ERROR_LSB 23
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_STREAM_SWITCH_PORT_PARITY_ERROR_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_STREAM_SWITCH_PORT_PARITY_ERROR_MASK 0x00800000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_STREAM_SWITCH_PORT_PARITY_ERROR_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_SPARSITY_OVERFLOW_LSB 22
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_SPARSITY_OVERFLOW_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_SPARSITY_OVERFLOW_MASK 0x00400000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_SPARSITY_OVERFLOW_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_INSTR_ERROR_LSB 21
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_INSTR_ERROR_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_INSTR_ERROR_MASK 0x00200000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_INSTR_ERROR_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_INSTR_WARNING_LSB 20
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_INSTR_WARNING_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_INSTR_WARNING_MASK 0x00100000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_INSTR_WARNING_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_LOCK_ACCESS_TO_UNAVAILABLE_LSB 19
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_LOCK_ACCESS_TO_UNAVAILABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_LOCK_ACCESS_TO_UNAVAILABLE_MASK 0x00080000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_LOCK_ACCESS_TO_UNAVAILABLE_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_DM_ACCESS_TO_UNAVAILABLE_LSB 18
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_DM_ACCESS_TO_UNAVAILABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_DM_ACCESS_TO_UNAVAILABLE_MASK 0x00040000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_DM_ACCESS_TO_UNAVAILABLE_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_PM_ADDRESS_OUT_OF_RANGE_LSB 17
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_PM_ADDRESS_OUT_OF_RANGE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_PM_ADDRESS_OUT_OF_RANGE_MASK 0x00020000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_PM_ADDRESS_OUT_OF_RANGE_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_PM_ECC_ERROR_2BIT_LSB 16
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_PM_ECC_ERROR_2BIT_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_PM_ECC_ERROR_2BIT_MASK 0x00010000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_PM_ECC_ERROR_2BIT_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_PM_ECC_ERROR_1BIT_LSB 15
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_PM_ECC_ERROR_1BIT_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_PM_ECC_ERROR_1BIT_MASK 0x00008000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_PM_ECC_ERROR_1BIT_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_PM_ECC_ERROR_SCRUB_2BIT_LSB 14
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_PM_ECC_ERROR_SCRUB_2BIT_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_PM_ECC_ERROR_SCRUB_2BIT_MASK 0x00004000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_PM_ECC_ERROR_SCRUB_2BIT_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_PM_ECC_ERROR_SCRUB_CORRECTED_LSB 13
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_PM_ECC_ERROR_SCRUB_CORRECTED_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_PM_ECC_ERROR_SCRUB_CORRECTED_MASK 0x00002000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_PM_ECC_ERROR_SCRUB_CORRECTED_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_DM_ADDRESS_OUT_OF_RANGE_LSB 12
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_DM_ADDRESS_OUT_OF_RANGE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_DM_ADDRESS_OUT_OF_RANGE_MASK 0x00001000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_DM_ADDRESS_OUT_OF_RANGE_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_INSTRUCTION_DECOMPRESSION_ERROR_LSB 11
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_INSTRUCTION_DECOMPRESSION_ERROR_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_INSTRUCTION_DECOMPRESSION_ERROR_MASK 0x00000800
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_INSTRUCTION_DECOMPRESSION_ERROR_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_AXI_MM_SLAVE_ERROR_LSB 10
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_AXI_MM_SLAVE_ERROR_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_AXI_MM_SLAVE_ERROR_MASK 0x00000400
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_AXI_MM_SLAVE_ERROR_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_CONTROL_PKT_ERROR_LSB 9
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_CONTROL_PKT_ERROR_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_CONTROL_PKT_ERROR_MASK 0x00000200
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_CONTROL_PKT_ERROR_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_STREAM_PKT_PARITY_ERROR_LSB 8
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_STREAM_PKT_PARITY_ERROR_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_STREAM_PKT_PARITY_ERROR_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_STREAM_PKT_PARITY_ERROR_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_PM_REG_ACCESS_FAILURE_LSB 7
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_PM_REG_ACCESS_FAILURE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_PM_REG_ACCESS_FAILURE_MASK 0x00000080
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_PM_REG_ACCESS_FAILURE_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_FP_INF_LSB   5
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_FP_INF_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_FP_INF_MASK  0x00000020
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_FP_INF_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_FP_INVALID_LSB 4
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_FP_INVALID_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_FP_INVALID_MASK 0x00000010
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_FP_INVALID_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_INT_FP_ZERO_LSB 3
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_INT_FP_ZERO_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_INT_FP_ZERO_MASK 0x00000008
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_INT_FP_ZERO_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_FP_HUGE_LSB  2
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_FP_HUGE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_FP_HUGE_MASK 0x00000004
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_FP_HUGE_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_UPS_OVERFLOW_LSB 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_UPS_OVERFLOW_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_UPS_OVERFLOW_MASK 0x00000002
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_UPS_OVERFLOW_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_SRS_OVERFLOW_LSB 0
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_SRS_OVERFLOW_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_SRS_OVERFLOW_MASK 0x00000001
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS0_ENABLE_SRS_OVERFLOW_DEFVAL 0x1

#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE                0x00034514
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_WIDTH          32
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_MASK           0x01FFFFFF
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_PROCESSOR_BUS_ERROR_LSB 24
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_PROCESSOR_BUS_ERROR_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_PROCESSOR_BUS_ERROR_MASK 0x01000000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_PROCESSOR_BUS_ERROR_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_STREAM_SWITCH_PORT_PARITY_ERROR_LSB 23
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_STREAM_SWITCH_PORT_PARITY_ERROR_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_STREAM_SWITCH_PORT_PARITY_ERROR_MASK 0x00800000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_STREAM_SWITCH_PORT_PARITY_ERROR_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_DECOMPRESSION_UNDERFLOW_LSB 22
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_DECOMPRESSION_UNDERFLOW_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_DECOMPRESSION_UNDERFLOW_MASK 0x00400000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_DECOMPRESSION_UNDERFLOW_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_INSTR_ERROR_LSB 21
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_INSTR_ERROR_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_INSTR_ERROR_MASK 0x00200000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_INSTR_ERROR_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_INSTR_WARNING_LSB 20
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_INSTR_WARNING_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_INSTR_WARNING_MASK 0x00100000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_INSTR_WARNING_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_LOCK_ACCESS_TO_UNAVAILABLE_LSB 19
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_LOCK_ACCESS_TO_UNAVAILABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_LOCK_ACCESS_TO_UNAVAILABLE_MASK 0x00080000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_LOCK_ACCESS_TO_UNAVAILABLE_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_DM_ACCESS_TO_UNAVAILABLE_LSB 18
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_DM_ACCESS_TO_UNAVAILABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_DM_ACCESS_TO_UNAVAILABLE_MASK 0x00040000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_DM_ACCESS_TO_UNAVAILABLE_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_PM_ADDRESS_OUT_OF_RANGE_LSB 17
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_PM_ADDRESS_OUT_OF_RANGE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_PM_ADDRESS_OUT_OF_RANGE_MASK 0x00020000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_PM_ADDRESS_OUT_OF_RANGE_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_PM_ECC_ERROR_2BIT_LSB 16
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_PM_ECC_ERROR_2BIT_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_PM_ECC_ERROR_2BIT_MASK 0x00010000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_PM_ECC_ERROR_2BIT_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_PM_ECC_ERROR_1BIT_LSB 15
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_PM_ECC_ERROR_1BIT_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_PM_ECC_ERROR_1BIT_MASK 0x00008000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_PM_ECC_ERROR_1BIT_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_PM_ECC_ERROR_SCRUB_2BIT_LSB 14
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_PM_ECC_ERROR_SCRUB_2BIT_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_PM_ECC_ERROR_SCRUB_2BIT_MASK 0x00004000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_PM_ECC_ERROR_SCRUB_2BIT_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_PM_ECC_ERROR_SCRUB_CORRECTED_LSB 13
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_PM_ECC_ERROR_SCRUB_CORRECTED_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_PM_ECC_ERROR_SCRUB_CORRECTED_MASK 0x00002000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_PM_ECC_ERROR_SCRUB_CORRECTED_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_DM_ADDRESS_OUT_OF_RANGE_LSB 12
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_DM_ADDRESS_OUT_OF_RANGE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_DM_ADDRESS_OUT_OF_RANGE_MASK 0x00001000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_DM_ADDRESS_OUT_OF_RANGE_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_INSTRUCTION_DECOMPRESSION_ERROR_LSB 11
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_INSTRUCTION_DECOMPRESSION_ERROR_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_INSTRUCTION_DECOMPRESSION_ERROR_MASK 0x00000800
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_INSTRUCTION_DECOMPRESSION_ERROR_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_AXI_MM_SLAVE_ERROR_LSB 10
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_AXI_MM_SLAVE_ERROR_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_AXI_MM_SLAVE_ERROR_MASK 0x00000400
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_AXI_MM_SLAVE_ERROR_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_CONTROL_PKT_ERROR_LSB 9
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_CONTROL_PKT_ERROR_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_CONTROL_PKT_ERROR_MASK 0x00000200
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_CONTROL_PKT_ERROR_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_STREAM_PKT_PARITY_ERROR_LSB 8
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_STREAM_PKT_PARITY_ERROR_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_STREAM_PKT_PARITY_ERROR_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_STREAM_PKT_PARITY_ERROR_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_PM_REG_ACCESS_FAILURE_LSB 7
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_PM_REG_ACCESS_FAILURE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_PM_REG_ACCESS_FAILURE_MASK 0x00000080
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_PM_REG_ACCESS_FAILURE_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_FP_INF_LSB   5
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_FP_INF_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_FP_INF_MASK  0x00000020
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_FP_INF_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_FP_INVALID_LSB 4
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_FP_INVALID_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_FP_INVALID_MASK 0x00000010
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_FP_INVALID_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_INT_FP_ZERO_LSB 3
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_INT_FP_ZERO_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_INT_FP_ZERO_MASK 0x00000008
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_INT_FP_ZERO_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_FP_HUGE_LSB  2
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_FP_HUGE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_FP_HUGE_MASK 0x00000004
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_FP_HUGE_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_UPS_OVERFLOW_LSB 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_UPS_OVERFLOW_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_UPS_OVERFLOW_MASK 0x00000002
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_UPS_OVERFLOW_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_SRS_OVERFLOW_LSB 0
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_SRS_OVERFLOW_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_SRS_OVERFLOW_MASK 0x00000001
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_ERRORS1_ENABLE_SRS_OVERFLOW_DEFVAL 0x1

#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE          0x00034518
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_WIDTH    32
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_MASK     0xFFFFFFFF
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_7_LSB 31
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_7_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_7_MASK 0x80000000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_7_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_7_LSB 30
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_7_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_7_MASK 0x40000000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_7_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_7_LSB 29
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_7_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_7_MASK 0x20000000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_7_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_7_LSB 28
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_7_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_7_MASK 0x10000000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_7_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_6_LSB 27
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_6_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_6_MASK 0x08000000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_6_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_6_LSB 26
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_6_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_6_MASK 0x04000000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_6_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_6_LSB 25
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_6_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_6_MASK 0x02000000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_6_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_6_LSB 24
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_6_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_6_MASK 0x01000000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_6_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_5_LSB 23
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_5_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_5_MASK 0x00800000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_5_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_5_LSB 22
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_5_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_5_MASK 0x00400000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_5_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_5_LSB 21
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_5_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_5_MASK 0x00200000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_5_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_5_LSB 20
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_5_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_5_MASK 0x00100000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_5_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_4_LSB 19
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_4_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_4_MASK 0x00080000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_4_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_4_LSB 18
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_4_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_4_MASK 0x00040000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_4_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_4_LSB 17
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_4_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_4_MASK 0x00020000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_4_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_4_LSB 16
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_4_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_4_MASK 0x00010000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_4_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_3_LSB 15
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_3_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_3_MASK 0x00008000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_3_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_3_LSB 14
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_3_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_3_MASK 0x00004000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_3_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_3_LSB 13
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_3_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_3_MASK 0x00002000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_3_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_3_LSB 12
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_3_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_3_MASK 0x00001000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_3_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_2_LSB 11
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_2_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_2_MASK 0x00000800
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_2_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_2_LSB 10
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_2_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_2_MASK 0x00000400
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_2_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_2_LSB 9
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_2_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_2_MASK 0x00000200
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_2_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_2_LSB 8
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_2_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_2_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_2_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_1_LSB 7
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_1_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_1_MASK 0x00000080
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_1_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_1_LSB 6
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_1_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_1_MASK 0x00000040
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_1_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_1_LSB 5
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_1_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_1_MASK 0x00000020
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_1_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_1_LSB 4
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_1_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_1_MASK 0x00000010
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_1_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_0_LSB 3
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_0_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_0_MASK 0x00000008
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_0_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_0_LSB 2
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_0_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_0_MASK 0x00000004
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_0_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_0_LSB 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_0_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_0_MASK 0x00000002
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_0_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_0_LSB 0
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_0_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_0_MASK 0x00000001
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_0_DEFVAL 0x1

#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE              0x0003451C
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_WIDTH        32
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_MASK         0x0000FFFF
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_15_LSB 15
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_15_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_15_MASK 0x00008000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_15_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_14_LSB 14
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_14_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_14_MASK 0x00004000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_14_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_13_LSB 13
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_13_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_13_MASK 0x00002000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_13_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_12_LSB 12
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_12_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_12_MASK 0x00001000
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_12_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_11_LSB 11
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_11_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_11_MASK 0x00000800
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_11_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_10_LSB 10
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_10_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_10_MASK 0x00000400
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_10_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_9_LSB 9
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_9_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_9_MASK 0x00000200
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_9_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_8_LSB 8
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_8_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_8_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_8_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_7_LSB 7
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_7_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_7_MASK 0x00000080
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_7_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_6_LSB 6
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_6_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_6_MASK 0x00000040
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_6_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_5_LSB 5
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_5_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_5_MASK 0x00000020
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_5_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_4_LSB 4
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_4_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_4_MASK 0x00000010
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_4_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_3_LSB 3
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_3_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_3_MASK 0x00000008
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_3_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_2_LSB 2
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_2_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_2_MASK 0x00000004
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_2_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_1_LSB 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_1_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_1_MASK 0x00000002
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_1_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_0_LSB 0
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_0_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_0_MASK 0x00000001
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_0_DEFVAL 0x1

#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_USER_EVENT_ENABLE             0x00034520
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_USER_EVENT_ENABLE_WIDTH       32
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_USER_EVENT_ENABLE_MASK        0x0000000F
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_USER_EVENT_ENABLE_USER_EVENT_3_LSB 3
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_USER_EVENT_ENABLE_USER_EVENT_3_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_USER_EVENT_ENABLE_USER_EVENT_3_MASK 0x00000008
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_USER_EVENT_ENABLE_USER_EVENT_3_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_USER_EVENT_ENABLE_USER_EVENT_2_LSB 2
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_USER_EVENT_ENABLE_USER_EVENT_2_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_USER_EVENT_ENABLE_USER_EVENT_2_MASK 0x00000004
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_USER_EVENT_ENABLE_USER_EVENT_2_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_USER_EVENT_ENABLE_USER_EVENT_1_LSB 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_USER_EVENT_ENABLE_USER_EVENT_1_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_USER_EVENT_ENABLE_USER_EVENT_1_MASK 0x00000002
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_USER_EVENT_ENABLE_USER_EVENT_1_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_USER_EVENT_ENABLE_USER_EVENT_0_LSB 0
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_USER_EVENT_ENABLE_USER_EVENT_0_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_USER_EVENT_ENABLE_USER_EVENT_0_MASK 0x00000001
#define XAIE2PGBL_CORE_MODULE_EVENT_GROUP_USER_EVENT_ENABLE_USER_EVENT_0_DEFVAL 0x1

#define XAIE2PGBL_CORE_MODULE_CSSD_TRIGGER                              0x00036040
#define XAIE2PGBL_CORE_MODULE_CSSD_TRIGGER_WIDTH                        32
#define XAIE2PGBL_CORE_MODULE_CSSD_TRIGGER_MASK                         0x00000001
#define XAIE2PGBL_CORE_MODULE_CSSD_TRIGGER_TRIGGER_LSB                0
#define XAIE2PGBL_CORE_MODULE_CSSD_TRIGGER_TRIGGER_WIDTH              1
#define XAIE2PGBL_CORE_MODULE_CSSD_TRIGGER_TRIGGER_MASK               0x00000001
#define XAIE2PGBL_CORE_MODULE_CSSD_TRIGGER_TRIGGER_DEFVAL             0x0

#define XAIE2PGBL_CORE_MODULE_SPARE_REG                                 0x00036050
#define XAIE2PGBL_CORE_MODULE_SPARE_REG_WIDTH                           32
#define XAIE2PGBL_CORE_MODULE_SPARE_REG_MASK                            0x0000FFFF
#define XAIE2PGBL_CORE_MODULE_SPARE_REG_SPARE_REG_LSB                 0
#define XAIE2PGBL_CORE_MODULE_SPARE_REG_SPARE_REG_WIDTH               16
#define XAIE2PGBL_CORE_MODULE_SPARE_REG_SPARE_REG_MASK                0x0000FFFF
#define XAIE2PGBL_CORE_MODULE_SPARE_REG_SPARE_REG_DEFVAL              0x0

#define XAIE2PGBL_CORE_MODULE_ACCUMULATOR_CONTROL                       0x00036060
#define XAIE2PGBL_CORE_MODULE_ACCUMULATOR_CONTROL_WIDTH                 32
#define XAIE2PGBL_CORE_MODULE_ACCUMULATOR_CONTROL_MASK                  0x00000003
#define XAIE2PGBL_CORE_MODULE_ACCUMULATOR_CONTROL_OUTPUT_LSB          1
#define XAIE2PGBL_CORE_MODULE_ACCUMULATOR_CONTROL_OUTPUT_WIDTH        1
#define XAIE2PGBL_CORE_MODULE_ACCUMULATOR_CONTROL_OUTPUT_MASK         0x00000002
#define XAIE2PGBL_CORE_MODULE_ACCUMULATOR_CONTROL_OUTPUT_DEFVAL       0x0
#define XAIE2PGBL_CORE_MODULE_ACCUMULATOR_CONTROL_INPUT_LSB           0
#define XAIE2PGBL_CORE_MODULE_ACCUMULATOR_CONTROL_INPUT_WIDTH         1
#define XAIE2PGBL_CORE_MODULE_ACCUMULATOR_CONTROL_INPUT_MASK          0x00000001
#define XAIE2PGBL_CORE_MODULE_ACCUMULATOR_CONTROL_INPUT_DEFVAL        0x0

#define XAIE2PGBL_CORE_MODULE_MEMORY_CONTROL                            0x00036070
#define XAIE2PGBL_CORE_MODULE_MEMORY_CONTROL_WIDTH                      32
#define XAIE2PGBL_CORE_MODULE_MEMORY_CONTROL_MASK                       0x00000001
#define XAIE2PGBL_CORE_MODULE_MEMORY_CONTROL_MEMORY_ZEROISATION_LSB   0
#define XAIE2PGBL_CORE_MODULE_MEMORY_CONTROL_MEMORY_ZEROISATION_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_MEMORY_CONTROL_MEMORY_ZEROISATION_MASK  0x00000001
#define XAIE2PGBL_CORE_MODULE_MEMORY_CONTROL_MEMORY_ZEROISATION_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_AIE_CORE0     0x0003F000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_AIE_CORE0_WIDTH 32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_AIE_CORE0_MASK 0xC00000FF
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_AIE_CORE0_MASTER_ENABLE_LSB 31
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_AIE_CORE0_MASTER_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_AIE_CORE0_MASTER_ENABLE_MASK 0x80000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_AIE_CORE0_MASTER_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_AIE_CORE0_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_AIE_CORE0_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_AIE_CORE0_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_AIE_CORE0_PACKET_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_AIE_CORE0_DROP_HEADER_LSB 7
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_AIE_CORE0_DROP_HEADER_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_AIE_CORE0_DROP_HEADER_MASK 0x00000080
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_AIE_CORE0_DROP_HEADER_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_AIE_CORE0_CONFIGURATION_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_AIE_CORE0_CONFIGURATION_WIDTH 7
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_AIE_CORE0_CONFIGURATION_MASK 0x0000007F
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_AIE_CORE0_CONFIGURATION_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_DMA0          0x0003F004
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_DMA0_WIDTH    32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_DMA0_MASK     0xC00000FF
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_DMA0_MASTER_ENABLE_LSB 31
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_DMA0_MASTER_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_DMA0_MASTER_ENABLE_MASK 0x80000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_DMA0_MASTER_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_DMA0_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_DMA0_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_DMA0_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_DMA0_PACKET_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_DMA0_DROP_HEADER_LSB 7
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_DMA0_DROP_HEADER_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_DMA0_DROP_HEADER_MASK 0x00000080
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_DMA0_DROP_HEADER_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_DMA0_CONFIGURATION_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_DMA0_CONFIGURATION_WIDTH 7
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_DMA0_CONFIGURATION_MASK 0x0000007F
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_DMA0_CONFIGURATION_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_DMA1          0x0003F008
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_DMA1_WIDTH    32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_DMA1_MASK     0xC00000FF
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_DMA1_MASTER_ENABLE_LSB 31
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_DMA1_MASTER_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_DMA1_MASTER_ENABLE_MASK 0x80000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_DMA1_MASTER_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_DMA1_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_DMA1_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_DMA1_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_DMA1_PACKET_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_DMA1_DROP_HEADER_LSB 7
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_DMA1_DROP_HEADER_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_DMA1_DROP_HEADER_MASK 0x00000080
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_DMA1_DROP_HEADER_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_DMA1_CONFIGURATION_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_DMA1_CONFIGURATION_WIDTH 7
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_DMA1_CONFIGURATION_MASK 0x0000007F
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_DMA1_CONFIGURATION_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_TILE_CTRL     0x0003F00C
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_TILE_CTRL_WIDTH 32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_TILE_CTRL_MASK 0xC00000FF
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_TILE_CTRL_MASTER_ENABLE_LSB 31
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_TILE_CTRL_MASTER_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_TILE_CTRL_MASTER_ENABLE_MASK 0x80000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_TILE_CTRL_MASTER_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_TILE_CTRL_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_TILE_CTRL_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_TILE_CTRL_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_TILE_CTRL_PACKET_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_TILE_CTRL_DROP_HEADER_LSB 7
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_TILE_CTRL_DROP_HEADER_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_TILE_CTRL_DROP_HEADER_MASK 0x00000080
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_TILE_CTRL_DROP_HEADER_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_TILE_CTRL_CONFIGURATION_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_TILE_CTRL_CONFIGURATION_WIDTH 7
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_TILE_CTRL_CONFIGURATION_MASK 0x0000007F
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_TILE_CTRL_CONFIGURATION_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_FIFO0         0x0003F010
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_FIFO0_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_FIFO0_MASK    0xC00000FF
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_FIFO0_MASTER_ENABLE_LSB 31
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_FIFO0_MASTER_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_FIFO0_MASTER_ENABLE_MASK 0x80000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_FIFO0_MASTER_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_FIFO0_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_FIFO0_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_FIFO0_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_FIFO0_PACKET_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_FIFO0_DROP_HEADER_LSB 7
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_FIFO0_DROP_HEADER_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_FIFO0_DROP_HEADER_MASK 0x00000080
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_FIFO0_DROP_HEADER_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_FIFO0_CONFIGURATION_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_FIFO0_CONFIGURATION_WIDTH 7
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_FIFO0_CONFIGURATION_MASK 0x0000007F
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_FIFO0_CONFIGURATION_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH0        0x0003F014
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH0_WIDTH  32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH0_MASK   0xC00000FF
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH0_MASTER_ENABLE_LSB 31
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH0_MASTER_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH0_MASTER_ENABLE_MASK 0x80000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH0_MASTER_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH0_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH0_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH0_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH0_PACKET_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH0_DROP_HEADER_LSB 7
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH0_DROP_HEADER_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH0_DROP_HEADER_MASK 0x00000080
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH0_DROP_HEADER_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH0_CONFIGURATION_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH0_CONFIGURATION_WIDTH 7
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH0_CONFIGURATION_MASK 0x0000007F
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH0_CONFIGURATION_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH1        0x0003F018
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH1_WIDTH  32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH1_MASK   0xC00000FF
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH1_MASTER_ENABLE_LSB 31
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH1_MASTER_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH1_MASTER_ENABLE_MASK 0x80000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH1_MASTER_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH1_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH1_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH1_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH1_PACKET_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH1_DROP_HEADER_LSB 7
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH1_DROP_HEADER_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH1_DROP_HEADER_MASK 0x00000080
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH1_DROP_HEADER_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH1_CONFIGURATION_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH1_CONFIGURATION_WIDTH 7
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH1_CONFIGURATION_MASK 0x0000007F
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH1_CONFIGURATION_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH2        0x0003F01C
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH2_WIDTH  32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH2_MASK   0xC00000FF
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH2_MASTER_ENABLE_LSB 31
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH2_MASTER_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH2_MASTER_ENABLE_MASK 0x80000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH2_MASTER_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH2_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH2_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH2_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH2_PACKET_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH2_DROP_HEADER_LSB 7
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH2_DROP_HEADER_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH2_DROP_HEADER_MASK 0x00000080
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH2_DROP_HEADER_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH2_CONFIGURATION_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH2_CONFIGURATION_WIDTH 7
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH2_CONFIGURATION_MASK 0x0000007F
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH2_CONFIGURATION_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH3        0x0003F020
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH3_WIDTH  32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH3_MASK   0xC00000FF
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH3_MASTER_ENABLE_LSB 31
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH3_MASTER_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH3_MASTER_ENABLE_MASK 0x80000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH3_MASTER_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH3_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH3_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH3_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH3_PACKET_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH3_DROP_HEADER_LSB 7
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH3_DROP_HEADER_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH3_DROP_HEADER_MASK 0x00000080
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH3_DROP_HEADER_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH3_CONFIGURATION_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH3_CONFIGURATION_WIDTH 7
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH3_CONFIGURATION_MASK 0x0000007F
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH3_CONFIGURATION_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST0         0x0003F024
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST0_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST0_MASK    0xC00000FF
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST0_MASTER_ENABLE_LSB 31
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST0_MASTER_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST0_MASTER_ENABLE_MASK 0x80000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST0_MASTER_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST0_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST0_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST0_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST0_PACKET_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST0_DROP_HEADER_LSB 7
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST0_DROP_HEADER_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST0_DROP_HEADER_MASK 0x00000080
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST0_DROP_HEADER_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST0_CONFIGURATION_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST0_CONFIGURATION_WIDTH 7
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST0_CONFIGURATION_MASK 0x0000007F
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST0_CONFIGURATION_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST1         0x0003F028
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST1_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST1_MASK    0xC00000FF
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST1_MASTER_ENABLE_LSB 31
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST1_MASTER_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST1_MASTER_ENABLE_MASK 0x80000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST1_MASTER_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST1_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST1_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST1_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST1_PACKET_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST1_DROP_HEADER_LSB 7
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST1_DROP_HEADER_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST1_DROP_HEADER_MASK 0x00000080
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST1_DROP_HEADER_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST1_CONFIGURATION_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST1_CONFIGURATION_WIDTH 7
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST1_CONFIGURATION_MASK 0x0000007F
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST1_CONFIGURATION_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST2         0x0003F02C
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST2_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST2_MASK    0xC00000FF
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST2_MASTER_ENABLE_LSB 31
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST2_MASTER_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST2_MASTER_ENABLE_MASK 0x80000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST2_MASTER_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST2_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST2_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST2_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST2_PACKET_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST2_DROP_HEADER_LSB 7
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST2_DROP_HEADER_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST2_DROP_HEADER_MASK 0x00000080
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST2_DROP_HEADER_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST2_CONFIGURATION_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST2_CONFIGURATION_WIDTH 7
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST2_CONFIGURATION_MASK 0x0000007F
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST2_CONFIGURATION_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST3         0x0003F030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST3_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST3_MASK    0xC00000FF
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST3_MASTER_ENABLE_LSB 31
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST3_MASTER_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST3_MASTER_ENABLE_MASK 0x80000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST3_MASTER_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST3_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST3_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST3_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST3_PACKET_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST3_DROP_HEADER_LSB 7
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST3_DROP_HEADER_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST3_DROP_HEADER_MASK 0x00000080
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST3_DROP_HEADER_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST3_CONFIGURATION_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST3_CONFIGURATION_WIDTH 7
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST3_CONFIGURATION_MASK 0x0000007F
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST3_CONFIGURATION_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH0        0x0003F034
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH0_WIDTH  32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH0_MASK   0xC00000FF
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH0_MASTER_ENABLE_LSB 31
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH0_MASTER_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH0_MASTER_ENABLE_MASK 0x80000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH0_MASTER_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH0_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH0_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH0_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH0_PACKET_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH0_DROP_HEADER_LSB 7
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH0_DROP_HEADER_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH0_DROP_HEADER_MASK 0x00000080
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH0_DROP_HEADER_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH0_CONFIGURATION_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH0_CONFIGURATION_WIDTH 7
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH0_CONFIGURATION_MASK 0x0000007F
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH0_CONFIGURATION_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH1        0x0003F038
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH1_WIDTH  32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH1_MASK   0xC00000FF
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH1_MASTER_ENABLE_LSB 31
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH1_MASTER_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH1_MASTER_ENABLE_MASK 0x80000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH1_MASTER_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH1_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH1_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH1_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH1_PACKET_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH1_DROP_HEADER_LSB 7
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH1_DROP_HEADER_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH1_DROP_HEADER_MASK 0x00000080
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH1_DROP_HEADER_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH1_CONFIGURATION_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH1_CONFIGURATION_WIDTH 7
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH1_CONFIGURATION_MASK 0x0000007F
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH1_CONFIGURATION_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH2        0x0003F03C
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH2_WIDTH  32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH2_MASK   0xC00000FF
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH2_MASTER_ENABLE_LSB 31
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH2_MASTER_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH2_MASTER_ENABLE_MASK 0x80000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH2_MASTER_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH2_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH2_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH2_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH2_PACKET_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH2_DROP_HEADER_LSB 7
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH2_DROP_HEADER_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH2_DROP_HEADER_MASK 0x00000080
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH2_DROP_HEADER_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH2_CONFIGURATION_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH2_CONFIGURATION_WIDTH 7
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH2_CONFIGURATION_MASK 0x0000007F
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH2_CONFIGURATION_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH3        0x0003F040
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH3_WIDTH  32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH3_MASK   0xC00000FF
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH3_MASTER_ENABLE_LSB 31
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH3_MASTER_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH3_MASTER_ENABLE_MASK 0x80000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH3_MASTER_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH3_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH3_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH3_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH3_PACKET_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH3_DROP_HEADER_LSB 7
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH3_DROP_HEADER_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH3_DROP_HEADER_MASK 0x00000080
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH3_DROP_HEADER_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH3_CONFIGURATION_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH3_CONFIGURATION_WIDTH 7
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH3_CONFIGURATION_MASK 0x0000007F
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH3_CONFIGURATION_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH4        0x0003F044
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH4_WIDTH  32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH4_MASK   0xC00000FF
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH4_MASTER_ENABLE_LSB 31
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH4_MASTER_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH4_MASTER_ENABLE_MASK 0x80000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH4_MASTER_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH4_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH4_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH4_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH4_PACKET_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH4_DROP_HEADER_LSB 7
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH4_DROP_HEADER_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH4_DROP_HEADER_MASK 0x00000080
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH4_DROP_HEADER_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH4_CONFIGURATION_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH4_CONFIGURATION_WIDTH 7
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH4_CONFIGURATION_MASK 0x0000007F
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH4_CONFIGURATION_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH5        0x0003F048
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH5_WIDTH  32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH5_MASK   0xC00000FF
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH5_MASTER_ENABLE_LSB 31
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH5_MASTER_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH5_MASTER_ENABLE_MASK 0x80000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH5_MASTER_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH5_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH5_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH5_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH5_PACKET_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH5_DROP_HEADER_LSB 7
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH5_DROP_HEADER_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH5_DROP_HEADER_MASK 0x00000080
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH5_DROP_HEADER_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH5_CONFIGURATION_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH5_CONFIGURATION_WIDTH 7
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH5_CONFIGURATION_MASK 0x0000007F
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH5_CONFIGURATION_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST0         0x0003F04C
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST0_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST0_MASK    0xC00000FF
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST0_MASTER_ENABLE_LSB 31
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST0_MASTER_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST0_MASTER_ENABLE_MASK 0x80000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST0_MASTER_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST0_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST0_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST0_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST0_PACKET_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST0_DROP_HEADER_LSB 7
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST0_DROP_HEADER_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST0_DROP_HEADER_MASK 0x00000080
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST0_DROP_HEADER_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST0_CONFIGURATION_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST0_CONFIGURATION_WIDTH 7
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST0_CONFIGURATION_MASK 0x0000007F
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST0_CONFIGURATION_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST1         0x0003F050
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST1_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST1_MASK    0xC00000FF
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST1_MASTER_ENABLE_LSB 31
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST1_MASTER_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST1_MASTER_ENABLE_MASK 0x80000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST1_MASTER_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST1_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST1_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST1_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST1_PACKET_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST1_DROP_HEADER_LSB 7
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST1_DROP_HEADER_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST1_DROP_HEADER_MASK 0x00000080
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST1_DROP_HEADER_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST1_CONFIGURATION_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST1_CONFIGURATION_WIDTH 7
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST1_CONFIGURATION_MASK 0x0000007F
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST1_CONFIGURATION_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST2         0x0003F054
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST2_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST2_MASK    0xC00000FF
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST2_MASTER_ENABLE_LSB 31
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST2_MASTER_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST2_MASTER_ENABLE_MASK 0x80000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST2_MASTER_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST2_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST2_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST2_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST2_PACKET_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST2_DROP_HEADER_LSB 7
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST2_DROP_HEADER_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST2_DROP_HEADER_MASK 0x00000080
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST2_DROP_HEADER_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST2_CONFIGURATION_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST2_CONFIGURATION_WIDTH 7
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST2_CONFIGURATION_MASK 0x0000007F
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST2_CONFIGURATION_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST3         0x0003F058
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST3_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST3_MASK    0xC00000FF
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST3_MASTER_ENABLE_LSB 31
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST3_MASTER_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST3_MASTER_ENABLE_MASK 0x80000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST3_MASTER_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST3_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST3_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST3_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST3_PACKET_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST3_DROP_HEADER_LSB 7
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST3_DROP_HEADER_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST3_DROP_HEADER_MASK 0x00000080
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST3_DROP_HEADER_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST3_CONFIGURATION_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST3_CONFIGURATION_WIDTH 7
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST3_CONFIGURATION_MASK 0x0000007F
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST3_CONFIGURATION_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_AIE_CORE0      0x0003F100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_AIE_CORE0_WIDTH 32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_AIE_CORE0_MASK 0xC0000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_AIE_CORE0_SLAVE_ENABLE_LSB 31
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_AIE_CORE0_SLAVE_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_AIE_CORE0_SLAVE_ENABLE_MASK 0x80000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_AIE_CORE0_SLAVE_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_AIE_CORE0_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_AIE_CORE0_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_AIE_CORE0_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_AIE_CORE0_PACKET_ENABLE_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_DMA_0          0x0003F104
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_DMA_0_WIDTH    32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_DMA_0_MASK     0xC0000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_DMA_0_SLAVE_ENABLE_LSB 31
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_DMA_0_SLAVE_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_DMA_0_SLAVE_ENABLE_MASK 0x80000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_DMA_0_SLAVE_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_DMA_0_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_DMA_0_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_DMA_0_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_DMA_0_PACKET_ENABLE_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_DMA_1          0x0003F108
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_DMA_1_WIDTH    32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_DMA_1_MASK     0xC0000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_DMA_1_SLAVE_ENABLE_LSB 31
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_DMA_1_SLAVE_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_DMA_1_SLAVE_ENABLE_MASK 0x80000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_DMA_1_SLAVE_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_DMA_1_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_DMA_1_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_DMA_1_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_DMA_1_PACKET_ENABLE_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_TILE_CTRL      0x0003F10C
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_TILE_CTRL_WIDTH 32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_TILE_CTRL_MASK 0xC0000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_TILE_CTRL_SLAVE_ENABLE_LSB 31
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_TILE_CTRL_SLAVE_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_TILE_CTRL_SLAVE_ENABLE_MASK 0x80000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_TILE_CTRL_SLAVE_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_TILE_CTRL_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_TILE_CTRL_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_TILE_CTRL_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_TILE_CTRL_PACKET_ENABLE_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_FIFO_0         0x0003F110
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_FIFO_0_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_FIFO_0_MASK    0xC0000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_FIFO_0_SLAVE_ENABLE_LSB 31
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_FIFO_0_SLAVE_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_FIFO_0_SLAVE_ENABLE_MASK 0x80000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_FIFO_0_SLAVE_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_FIFO_0_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_FIFO_0_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_FIFO_0_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_FIFO_0_PACKET_ENABLE_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_0        0x0003F114
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_0_WIDTH  32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_0_MASK   0xC0000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_0_SLAVE_ENABLE_LSB 31
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_0_SLAVE_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_0_SLAVE_ENABLE_MASK 0x80000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_0_SLAVE_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_0_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_0_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_0_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_0_PACKET_ENABLE_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_1        0x0003F118
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_1_WIDTH  32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_1_MASK   0xC0000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_1_SLAVE_ENABLE_LSB 31
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_1_SLAVE_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_1_SLAVE_ENABLE_MASK 0x80000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_1_SLAVE_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_1_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_1_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_1_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_1_PACKET_ENABLE_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_2        0x0003F11C
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_2_WIDTH  32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_2_MASK   0xC0000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_2_SLAVE_ENABLE_LSB 31
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_2_SLAVE_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_2_SLAVE_ENABLE_MASK 0x80000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_2_SLAVE_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_2_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_2_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_2_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_2_PACKET_ENABLE_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_3        0x0003F120
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_3_WIDTH  32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_3_MASK   0xC0000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_3_SLAVE_ENABLE_LSB 31
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_3_SLAVE_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_3_SLAVE_ENABLE_MASK 0x80000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_3_SLAVE_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_3_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_3_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_3_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_3_PACKET_ENABLE_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_4        0x0003F124
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_4_WIDTH  32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_4_MASK   0xC0000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_4_SLAVE_ENABLE_LSB 31
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_4_SLAVE_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_4_SLAVE_ENABLE_MASK 0x80000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_4_SLAVE_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_4_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_4_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_4_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_4_PACKET_ENABLE_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_5        0x0003F128
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_5_WIDTH  32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_5_MASK   0xC0000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_5_SLAVE_ENABLE_LSB 31
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_5_SLAVE_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_5_SLAVE_ENABLE_MASK 0x80000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_5_SLAVE_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_5_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_5_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_5_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_5_PACKET_ENABLE_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_0         0x0003F12C
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_0_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_0_MASK    0xC0000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_0_SLAVE_ENABLE_LSB 31
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_0_SLAVE_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_0_SLAVE_ENABLE_MASK 0x80000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_0_SLAVE_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_0_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_0_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_0_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_0_PACKET_ENABLE_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_1         0x0003F130
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_1_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_1_MASK    0xC0000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_1_SLAVE_ENABLE_LSB 31
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_1_SLAVE_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_1_SLAVE_ENABLE_MASK 0x80000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_1_SLAVE_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_1_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_1_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_1_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_1_PACKET_ENABLE_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_2         0x0003F134
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_2_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_2_MASK    0xC0000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_2_SLAVE_ENABLE_LSB 31
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_2_SLAVE_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_2_SLAVE_ENABLE_MASK 0x80000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_2_SLAVE_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_2_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_2_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_2_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_2_PACKET_ENABLE_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_3         0x0003F138
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_3_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_3_MASK    0xC0000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_3_SLAVE_ENABLE_LSB 31
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_3_SLAVE_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_3_SLAVE_ENABLE_MASK 0x80000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_3_SLAVE_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_3_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_3_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_3_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_3_PACKET_ENABLE_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_0        0x0003F13C
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_0_WIDTH  32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_0_MASK   0xC0000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_0_SLAVE_ENABLE_LSB 31
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_0_SLAVE_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_0_SLAVE_ENABLE_MASK 0x80000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_0_SLAVE_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_0_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_0_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_0_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_0_PACKET_ENABLE_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_1        0x0003F140
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_1_WIDTH  32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_1_MASK   0xC0000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_1_SLAVE_ENABLE_LSB 31
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_1_SLAVE_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_1_SLAVE_ENABLE_MASK 0x80000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_1_SLAVE_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_1_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_1_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_1_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_1_PACKET_ENABLE_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_2        0x0003F144
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_2_WIDTH  32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_2_MASK   0xC0000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_2_SLAVE_ENABLE_LSB 31
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_2_SLAVE_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_2_SLAVE_ENABLE_MASK 0x80000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_2_SLAVE_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_2_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_2_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_2_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_2_PACKET_ENABLE_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_3        0x0003F148
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_3_WIDTH  32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_3_MASK   0xC0000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_3_SLAVE_ENABLE_LSB 31
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_3_SLAVE_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_3_SLAVE_ENABLE_MASK 0x80000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_3_SLAVE_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_3_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_3_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_3_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_3_PACKET_ENABLE_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_0         0x0003F14C
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_0_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_0_MASK    0xC0000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_0_SLAVE_ENABLE_LSB 31
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_0_SLAVE_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_0_SLAVE_ENABLE_MASK 0x80000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_0_SLAVE_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_0_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_0_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_0_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_0_PACKET_ENABLE_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_1         0x0003F150
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_1_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_1_MASK    0xC0000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_1_SLAVE_ENABLE_LSB 31
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_1_SLAVE_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_1_SLAVE_ENABLE_MASK 0x80000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_1_SLAVE_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_1_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_1_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_1_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_1_PACKET_ENABLE_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_2         0x0003F154
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_2_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_2_MASK    0xC0000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_2_SLAVE_ENABLE_LSB 31
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_2_SLAVE_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_2_SLAVE_ENABLE_MASK 0x80000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_2_SLAVE_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_2_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_2_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_2_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_2_PACKET_ENABLE_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_3         0x0003F158
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_3_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_3_MASK    0xC0000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_3_SLAVE_ENABLE_LSB 31
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_3_SLAVE_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_3_SLAVE_ENABLE_MASK 0x80000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_3_SLAVE_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_3_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_3_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_3_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_3_PACKET_ENABLE_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_AIE_TRACE      0x0003F15C
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_AIE_TRACE_WIDTH 32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_AIE_TRACE_MASK 0xC0000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_AIE_TRACE_SLAVE_ENABLE_LSB 31
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_AIE_TRACE_SLAVE_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_AIE_TRACE_SLAVE_ENABLE_MASK 0x80000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_AIE_TRACE_SLAVE_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_AIE_TRACE_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_AIE_TRACE_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_AIE_TRACE_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_AIE_TRACE_PACKET_ENABLE_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_MEM_TRACE      0x0003F160
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_MEM_TRACE_WIDTH 32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_MEM_TRACE_MASK 0xC0000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_MEM_TRACE_SLAVE_ENABLE_LSB 31
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_MEM_TRACE_SLAVE_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_MEM_TRACE_SLAVE_ENABLE_MASK 0x80000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_MEM_TRACE_SLAVE_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_MEM_TRACE_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_MEM_TRACE_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_MEM_TRACE_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_CONFIG_MEM_TRACE_PACKET_ENABLE_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT0       0x0003F200
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT0_WIDTH 32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT0_MASK  0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT0_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT0_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT0_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT0_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT0_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT0_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT0_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT0_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT0_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT0_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT0_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT0_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT0_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT0_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT0_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT0_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT0_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT0_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT0_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT0_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT1       0x0003F204
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT1_WIDTH 32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT1_MASK  0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT1_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT1_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT1_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT1_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT1_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT1_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT1_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT1_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT1_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT1_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT1_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT1_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT1_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT1_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT1_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT1_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT1_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT1_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT1_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT1_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT2       0x0003F208
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT2_WIDTH 32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT2_MASK  0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT2_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT2_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT2_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT2_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT2_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT2_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT2_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT2_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT2_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT2_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT2_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT2_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT2_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT2_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT2_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT2_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT2_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT2_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT2_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT2_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT3       0x0003F20C
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT3_WIDTH 32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT3_MASK  0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT3_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT3_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT3_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT3_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT3_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT3_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT3_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT3_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT3_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT3_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT3_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT3_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT3_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT3_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT3_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT3_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT3_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT3_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT3_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_CORE0_SLOT3_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT0           0x0003F210
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT0_WIDTH     32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT0_MASK      0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT0_ID_LSB  24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT0_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT0_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT0_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT0_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT0_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT0_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT0_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT0_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT0_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT0_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT0_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT0_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT0_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT0_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT0_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT0_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT0_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT0_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT0_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT1           0x0003F214
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT1_WIDTH     32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT1_MASK      0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT1_ID_LSB  24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT1_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT1_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT1_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT1_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT1_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT1_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT1_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT1_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT1_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT1_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT1_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT1_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT1_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT1_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT1_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT1_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT1_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT1_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT1_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT2           0x0003F218
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT2_WIDTH     32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT2_MASK      0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT2_ID_LSB  24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT2_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT2_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT2_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT2_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT2_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT2_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT2_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT2_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT2_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT2_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT2_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT2_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT2_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT2_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT2_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT2_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT2_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT2_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT2_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT3           0x0003F21C
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT3_WIDTH     32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT3_MASK      0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT3_ID_LSB  24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT3_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT3_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT3_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT3_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT3_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT3_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT3_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT3_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT3_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT3_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT3_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT3_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT3_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT3_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT3_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT3_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT3_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT3_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_0_SLOT3_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT0           0x0003F220
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT0_WIDTH     32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT0_MASK      0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT0_ID_LSB  24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT0_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT0_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT0_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT0_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT0_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT0_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT0_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT0_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT0_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT0_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT0_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT0_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT0_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT0_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT0_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT0_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT0_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT0_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT0_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT1           0x0003F224
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT1_WIDTH     32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT1_MASK      0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT1_ID_LSB  24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT1_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT1_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT1_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT1_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT1_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT1_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT1_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT1_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT1_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT1_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT1_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT1_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT1_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT1_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT1_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT1_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT1_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT1_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT1_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT2           0x0003F228
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT2_WIDTH     32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT2_MASK      0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT2_ID_LSB  24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT2_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT2_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT2_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT2_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT2_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT2_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT2_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT2_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT2_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT2_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT2_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT2_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT2_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT2_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT2_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT2_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT2_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT2_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT2_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT3           0x0003F22C
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT3_WIDTH     32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT3_MASK      0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT3_ID_LSB  24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT3_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT3_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT3_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT3_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT3_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT3_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT3_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT3_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT3_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT3_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT3_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT3_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT3_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT3_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT3_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT3_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT3_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT3_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_DMA_1_SLOT3_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT0       0x0003F230
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT0_WIDTH 32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT0_MASK  0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT0_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT0_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT0_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT0_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT0_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT0_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT0_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT0_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT0_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT0_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT0_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT0_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT0_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT0_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT0_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT0_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT0_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT0_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT0_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT0_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT1       0x0003F234
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT1_WIDTH 32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT1_MASK  0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT1_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT1_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT1_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT1_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT1_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT1_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT1_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT1_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT1_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT1_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT1_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT1_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT1_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT1_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT1_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT1_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT1_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT1_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT1_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT1_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT2       0x0003F238
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT2_WIDTH 32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT2_MASK  0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT2_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT2_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT2_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT2_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT2_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT2_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT2_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT2_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT2_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT2_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT2_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT2_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT2_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT2_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT2_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT2_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT2_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT2_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT2_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT2_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT3       0x0003F23C
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT3_WIDTH 32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT3_MASK  0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT3_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT3_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT3_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT3_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT3_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT3_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT3_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT3_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT3_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT3_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT3_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT3_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT3_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT3_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT3_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT3_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT3_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT3_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT3_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_TILE_CTRL_SLOT3_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT0          0x0003F240
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT0_WIDTH    32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT0_MASK     0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT0_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT0_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT0_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT0_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT0_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT0_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT0_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT0_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT0_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT0_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT0_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT0_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT0_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT0_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT0_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT0_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT0_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT0_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT0_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT0_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT1          0x0003F244
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT1_WIDTH    32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT1_MASK     0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT1_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT1_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT1_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT1_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT1_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT1_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT1_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT1_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT1_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT1_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT1_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT1_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT1_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT1_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT1_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT1_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT1_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT1_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT1_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT1_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT2          0x0003F248
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT2_WIDTH    32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT2_MASK     0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT2_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT2_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT2_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT2_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT2_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT2_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT2_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT2_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT2_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT2_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT2_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT2_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT2_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT2_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT2_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT2_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT2_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT2_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT2_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT2_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT3          0x0003F24C
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT3_WIDTH    32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT3_MASK     0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT3_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT3_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT3_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT3_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT3_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT3_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT3_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT3_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT3_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT3_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT3_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT3_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT3_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT3_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT3_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT3_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT3_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT3_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT3_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_FIFO_0_SLOT3_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT0         0x0003F250
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT0_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT0_MASK    0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT0_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT0_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT0_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT0_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT0_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT0_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT0_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT0_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT0_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT0_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT0_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT0_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT0_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT0_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT0_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT0_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT0_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT0_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT0_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT0_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT1         0x0003F254
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT1_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT1_MASK    0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT1_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT1_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT1_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT1_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT1_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT1_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT1_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT1_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT1_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT1_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT1_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT1_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT1_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT1_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT1_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT1_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT1_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT1_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT1_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT1_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT2         0x0003F258
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT2_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT2_MASK    0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT2_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT2_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT2_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT2_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT2_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT2_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT2_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT2_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT2_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT2_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT2_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT2_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT2_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT2_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT2_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT2_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT2_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT2_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT2_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT2_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT3         0x0003F25C
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT3_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT3_MASK    0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT3_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT3_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT3_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT3_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT3_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT3_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT3_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT3_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT3_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT3_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT3_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT3_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT3_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT3_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT3_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT3_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT3_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT3_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT3_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_0_SLOT3_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT0         0x0003F260
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT0_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT0_MASK    0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT0_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT0_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT0_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT0_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT0_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT0_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT0_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT0_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT0_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT0_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT0_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT0_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT0_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT0_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT0_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT0_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT0_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT0_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT0_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT0_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT1         0x0003F264
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT1_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT1_MASK    0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT1_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT1_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT1_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT1_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT1_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT1_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT1_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT1_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT1_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT1_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT1_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT1_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT1_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT1_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT1_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT1_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT1_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT1_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT1_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT1_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT2         0x0003F268
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT2_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT2_MASK    0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT2_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT2_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT2_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT2_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT2_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT2_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT2_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT2_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT2_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT2_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT2_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT2_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT2_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT2_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT2_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT2_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT2_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT2_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT2_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT2_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT3         0x0003F26C
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT3_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT3_MASK    0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT3_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT3_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT3_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT3_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT3_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT3_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT3_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT3_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT3_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT3_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT3_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT3_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT3_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT3_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT3_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT3_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT3_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT3_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT3_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_1_SLOT3_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT0         0x0003F270
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT0_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT0_MASK    0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT0_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT0_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT0_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT0_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT0_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT0_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT0_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT0_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT0_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT0_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT0_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT0_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT0_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT0_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT0_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT0_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT0_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT0_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT0_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT0_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT1         0x0003F274
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT1_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT1_MASK    0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT1_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT1_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT1_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT1_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT1_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT1_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT1_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT1_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT1_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT1_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT1_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT1_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT1_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT1_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT1_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT1_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT1_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT1_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT1_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT1_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT2         0x0003F278
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT2_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT2_MASK    0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT2_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT2_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT2_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT2_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT2_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT2_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT2_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT2_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT2_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT2_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT2_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT2_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT2_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT2_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT2_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT2_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT2_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT2_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT2_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT2_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT3         0x0003F27C
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT3_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT3_MASK    0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT3_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT3_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT3_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT3_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT3_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT3_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT3_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT3_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT3_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT3_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT3_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT3_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT3_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT3_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT3_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT3_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT3_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT3_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT3_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_2_SLOT3_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT0         0x0003F280
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT0_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT0_MASK    0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT0_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT0_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT0_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT0_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT0_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT0_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT0_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT0_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT0_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT0_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT0_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT0_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT0_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT0_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT0_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT0_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT0_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT0_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT0_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT0_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT1         0x0003F284
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT1_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT1_MASK    0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT1_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT1_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT1_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT1_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT1_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT1_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT1_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT1_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT1_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT1_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT1_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT1_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT1_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT1_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT1_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT1_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT1_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT1_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT1_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT1_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT2         0x0003F288
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT2_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT2_MASK    0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT2_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT2_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT2_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT2_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT2_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT2_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT2_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT2_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT2_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT2_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT2_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT2_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT2_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT2_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT2_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT2_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT2_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT2_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT2_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT2_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT3         0x0003F28C
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT3_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT3_MASK    0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT3_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT3_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT3_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT3_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT3_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT3_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT3_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT3_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT3_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT3_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT3_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT3_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT3_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT3_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT3_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT3_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT3_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT3_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT3_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_3_SLOT3_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT0         0x0003F290
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT0_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT0_MASK    0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT0_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT0_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT0_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT0_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT0_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT0_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT0_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT0_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT0_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT0_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT0_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT0_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT0_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT0_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT0_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT0_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT0_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT0_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT0_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT0_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT1         0x0003F294
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT1_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT1_MASK    0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT1_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT1_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT1_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT1_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT1_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT1_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT1_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT1_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT1_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT1_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT1_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT1_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT1_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT1_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT1_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT1_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT1_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT1_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT1_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT1_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT2         0x0003F298
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT2_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT2_MASK    0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT2_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT2_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT2_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT2_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT2_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT2_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT2_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT2_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT2_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT2_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT2_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT2_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT2_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT2_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT2_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT2_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT2_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT2_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT2_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT2_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT3         0x0003F29C
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT3_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT3_MASK    0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT3_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT3_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT3_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT3_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT3_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT3_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT3_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT3_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT3_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT3_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT3_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT3_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT3_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT3_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT3_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT3_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT3_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT3_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT3_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_4_SLOT3_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT0         0x0003F2A0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT0_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT0_MASK    0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT0_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT0_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT0_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT0_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT0_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT0_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT0_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT0_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT0_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT0_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT0_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT0_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT0_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT0_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT0_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT0_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT0_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT0_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT0_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT0_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT1         0x0003F2A4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT1_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT1_MASK    0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT1_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT1_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT1_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT1_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT1_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT1_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT1_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT1_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT1_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT1_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT1_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT1_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT1_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT1_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT1_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT1_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT1_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT1_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT1_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT1_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT2         0x0003F2A8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT2_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT2_MASK    0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT2_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT2_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT2_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT2_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT2_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT2_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT2_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT2_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT2_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT2_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT2_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT2_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT2_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT2_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT2_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT2_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT2_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT2_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT2_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT2_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT3         0x0003F2AC
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT3_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT3_MASK    0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT3_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT3_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT3_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT3_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT3_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT3_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT3_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT3_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT3_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT3_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT3_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT3_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT3_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT3_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT3_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT3_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT3_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT3_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT3_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_SOUTH_5_SLOT3_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT0          0x0003F2B0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT0_WIDTH    32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT0_MASK     0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT0_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT0_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT0_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT0_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT0_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT0_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT0_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT0_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT0_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT0_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT0_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT0_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT0_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT0_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT0_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT0_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT0_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT0_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT0_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT0_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT1          0x0003F2B4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT1_WIDTH    32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT1_MASK     0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT1_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT1_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT1_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT1_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT1_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT1_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT1_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT1_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT1_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT1_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT1_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT1_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT1_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT1_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT1_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT1_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT1_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT1_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT1_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT1_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT2          0x0003F2B8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT2_WIDTH    32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT2_MASK     0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT2_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT2_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT2_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT2_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT2_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT2_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT2_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT2_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT2_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT2_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT2_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT2_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT2_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT2_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT2_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT2_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT2_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT2_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT2_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT2_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT3          0x0003F2BC
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT3_WIDTH    32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT3_MASK     0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT3_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT3_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT3_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT3_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT3_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT3_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT3_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT3_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT3_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT3_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT3_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT3_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT3_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT3_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT3_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT3_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT3_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT3_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT3_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_0_SLOT3_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT0          0x0003F2C0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT0_WIDTH    32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT0_MASK     0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT0_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT0_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT0_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT0_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT0_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT0_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT0_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT0_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT0_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT0_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT0_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT0_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT0_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT0_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT0_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT0_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT0_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT0_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT0_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT0_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT1          0x0003F2C4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT1_WIDTH    32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT1_MASK     0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT1_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT1_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT1_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT1_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT1_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT1_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT1_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT1_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT1_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT1_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT1_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT1_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT1_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT1_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT1_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT1_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT1_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT1_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT1_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT1_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT2          0x0003F2C8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT2_WIDTH    32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT2_MASK     0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT2_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT2_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT2_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT2_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT2_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT2_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT2_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT2_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT2_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT2_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT2_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT2_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT2_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT2_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT2_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT2_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT2_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT2_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT2_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT2_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT3          0x0003F2CC
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT3_WIDTH    32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT3_MASK     0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT3_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT3_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT3_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT3_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT3_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT3_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT3_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT3_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT3_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT3_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT3_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT3_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT3_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT3_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT3_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT3_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT3_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT3_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT3_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_1_SLOT3_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT0          0x0003F2D0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT0_WIDTH    32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT0_MASK     0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT0_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT0_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT0_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT0_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT0_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT0_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT0_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT0_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT0_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT0_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT0_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT0_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT0_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT0_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT0_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT0_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT0_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT0_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT0_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT0_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT1          0x0003F2D4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT1_WIDTH    32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT1_MASK     0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT1_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT1_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT1_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT1_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT1_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT1_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT1_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT1_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT1_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT1_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT1_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT1_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT1_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT1_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT1_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT1_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT1_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT1_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT1_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT1_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT2          0x0003F2D8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT2_WIDTH    32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT2_MASK     0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT2_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT2_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT2_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT2_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT2_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT2_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT2_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT2_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT2_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT2_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT2_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT2_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT2_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT2_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT2_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT2_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT2_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT2_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT2_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT2_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT3          0x0003F2DC
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT3_WIDTH    32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT3_MASK     0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT3_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT3_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT3_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT3_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT3_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT3_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT3_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT3_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT3_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT3_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT3_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT3_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT3_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT3_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT3_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT3_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT3_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT3_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT3_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_2_SLOT3_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT0          0x0003F2E0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT0_WIDTH    32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT0_MASK     0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT0_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT0_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT0_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT0_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT0_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT0_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT0_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT0_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT0_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT0_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT0_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT0_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT0_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT0_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT0_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT0_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT0_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT0_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT0_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT0_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT1          0x0003F2E4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT1_WIDTH    32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT1_MASK     0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT1_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT1_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT1_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT1_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT1_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT1_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT1_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT1_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT1_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT1_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT1_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT1_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT1_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT1_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT1_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT1_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT1_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT1_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT1_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT1_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT2          0x0003F2E8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT2_WIDTH    32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT2_MASK     0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT2_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT2_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT2_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT2_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT2_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT2_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT2_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT2_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT2_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT2_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT2_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT2_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT2_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT2_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT2_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT2_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT2_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT2_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT2_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT2_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT3          0x0003F2EC
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT3_WIDTH    32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT3_MASK     0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT3_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT3_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT3_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT3_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT3_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT3_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT3_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT3_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT3_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT3_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT3_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT3_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT3_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT3_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT3_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT3_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT3_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT3_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT3_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_WEST_3_SLOT3_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT0         0x0003F2F0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT0_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT0_MASK    0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT0_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT0_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT0_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT0_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT0_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT0_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT0_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT0_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT0_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT0_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT0_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT0_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT0_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT0_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT0_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT0_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT0_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT0_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT0_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT0_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT1         0x0003F2F4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT1_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT1_MASK    0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT1_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT1_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT1_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT1_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT1_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT1_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT1_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT1_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT1_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT1_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT1_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT1_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT1_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT1_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT1_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT1_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT1_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT1_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT1_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT1_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT2         0x0003F2F8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT2_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT2_MASK    0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT2_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT2_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT2_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT2_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT2_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT2_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT2_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT2_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT2_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT2_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT2_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT2_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT2_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT2_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT2_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT2_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT2_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT2_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT2_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT2_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT3         0x0003F2FC
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT3_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT3_MASK    0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT3_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT3_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT3_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT3_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT3_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT3_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT3_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT3_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT3_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT3_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT3_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT3_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT3_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT3_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT3_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT3_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT3_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT3_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT3_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_0_SLOT3_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT0         0x0003F300
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT0_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT0_MASK    0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT0_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT0_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT0_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT0_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT0_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT0_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT0_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT0_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT0_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT0_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT0_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT0_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT0_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT0_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT0_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT0_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT0_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT0_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT0_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT0_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT1         0x0003F304
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT1_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT1_MASK    0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT1_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT1_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT1_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT1_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT1_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT1_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT1_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT1_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT1_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT1_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT1_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT1_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT1_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT1_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT1_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT1_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT1_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT1_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT1_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT1_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT2         0x0003F308
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT2_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT2_MASK    0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT2_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT2_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT2_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT2_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT2_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT2_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT2_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT2_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT2_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT2_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT2_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT2_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT2_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT2_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT2_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT2_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT2_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT2_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT2_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT2_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT3         0x0003F30C
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT3_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT3_MASK    0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT3_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT3_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT3_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT3_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT3_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT3_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT3_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT3_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT3_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT3_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT3_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT3_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT3_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT3_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT3_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT3_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT3_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT3_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT3_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_1_SLOT3_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT0         0x0003F310
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT0_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT0_MASK    0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT0_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT0_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT0_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT0_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT0_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT0_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT0_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT0_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT0_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT0_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT0_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT0_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT0_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT0_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT0_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT0_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT0_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT0_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT0_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT0_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT1         0x0003F314
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT1_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT1_MASK    0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT1_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT1_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT1_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT1_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT1_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT1_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT1_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT1_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT1_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT1_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT1_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT1_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT1_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT1_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT1_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT1_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT1_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT1_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT1_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT1_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT2         0x0003F318
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT2_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT2_MASK    0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT2_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT2_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT2_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT2_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT2_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT2_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT2_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT2_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT2_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT2_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT2_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT2_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT2_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT2_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT2_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT2_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT2_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT2_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT2_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT2_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT3         0x0003F31C
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT3_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT3_MASK    0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT3_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT3_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT3_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT3_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT3_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT3_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT3_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT3_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT3_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT3_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT3_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT3_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT3_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT3_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT3_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT3_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT3_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT3_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT3_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_2_SLOT3_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT0         0x0003F320
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT0_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT0_MASK    0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT0_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT0_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT0_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT0_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT0_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT0_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT0_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT0_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT0_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT0_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT0_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT0_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT0_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT0_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT0_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT0_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT0_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT0_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT0_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT0_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT1         0x0003F324
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT1_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT1_MASK    0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT1_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT1_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT1_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT1_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT1_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT1_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT1_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT1_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT1_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT1_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT1_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT1_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT1_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT1_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT1_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT1_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT1_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT1_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT1_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT1_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT2         0x0003F328
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT2_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT2_MASK    0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT2_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT2_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT2_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT2_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT2_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT2_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT2_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT2_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT2_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT2_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT2_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT2_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT2_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT2_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT2_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT2_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT2_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT2_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT2_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT2_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT3         0x0003F32C
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT3_WIDTH   32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT3_MASK    0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT3_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT3_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT3_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT3_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT3_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT3_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT3_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT3_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT3_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT3_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT3_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT3_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT3_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT3_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT3_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT3_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT3_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT3_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT3_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_NORTH_3_SLOT3_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT0          0x0003F330
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT0_WIDTH    32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT0_MASK     0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT0_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT0_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT0_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT0_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT0_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT0_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT0_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT0_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT0_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT0_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT0_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT0_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT0_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT0_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT0_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT0_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT0_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT0_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT0_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT0_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT1          0x0003F334
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT1_WIDTH    32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT1_MASK     0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT1_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT1_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT1_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT1_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT1_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT1_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT1_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT1_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT1_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT1_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT1_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT1_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT1_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT1_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT1_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT1_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT1_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT1_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT1_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT1_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT2          0x0003F338
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT2_WIDTH    32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT2_MASK     0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT2_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT2_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT2_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT2_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT2_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT2_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT2_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT2_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT2_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT2_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT2_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT2_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT2_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT2_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT2_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT2_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT2_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT2_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT2_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT2_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT3          0x0003F33C
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT3_WIDTH    32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT3_MASK     0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT3_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT3_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT3_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT3_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT3_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT3_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT3_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT3_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT3_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT3_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT3_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT3_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT3_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT3_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT3_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT3_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT3_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT3_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT3_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_0_SLOT3_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT0          0x0003F340
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT0_WIDTH    32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT0_MASK     0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT0_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT0_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT0_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT0_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT0_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT0_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT0_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT0_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT0_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT0_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT0_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT0_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT0_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT0_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT0_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT0_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT0_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT0_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT0_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT0_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT1          0x0003F344
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT1_WIDTH    32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT1_MASK     0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT1_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT1_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT1_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT1_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT1_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT1_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT1_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT1_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT1_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT1_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT1_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT1_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT1_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT1_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT1_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT1_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT1_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT1_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT1_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT1_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT2          0x0003F348
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT2_WIDTH    32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT2_MASK     0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT2_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT2_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT2_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT2_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT2_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT2_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT2_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT2_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT2_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT2_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT2_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT2_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT2_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT2_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT2_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT2_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT2_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT2_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT2_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT2_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT3          0x0003F34C
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT3_WIDTH    32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT3_MASK     0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT3_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT3_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT3_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT3_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT3_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT3_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT3_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT3_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT3_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT3_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT3_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT3_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT3_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT3_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT3_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT3_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT3_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT3_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT3_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_1_SLOT3_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT0          0x0003F350
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT0_WIDTH    32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT0_MASK     0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT0_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT0_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT0_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT0_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT0_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT0_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT0_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT0_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT0_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT0_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT0_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT0_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT0_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT0_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT0_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT0_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT0_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT0_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT0_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT0_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT1          0x0003F354
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT1_WIDTH    32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT1_MASK     0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT1_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT1_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT1_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT1_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT1_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT1_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT1_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT1_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT1_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT1_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT1_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT1_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT1_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT1_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT1_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT1_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT1_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT1_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT1_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT1_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT2          0x0003F358
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT2_WIDTH    32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT2_MASK     0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT2_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT2_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT2_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT2_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT2_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT2_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT2_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT2_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT2_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT2_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT2_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT2_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT2_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT2_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT2_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT2_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT2_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT2_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT2_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT2_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT3          0x0003F35C
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT3_WIDTH    32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT3_MASK     0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT3_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT3_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT3_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT3_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT3_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT3_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT3_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT3_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT3_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT3_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT3_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT3_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT3_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT3_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT3_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT3_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT3_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT3_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT3_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_2_SLOT3_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT0          0x0003F360
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT0_WIDTH    32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT0_MASK     0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT0_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT0_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT0_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT0_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT0_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT0_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT0_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT0_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT0_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT0_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT0_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT0_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT0_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT0_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT0_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT0_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT0_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT0_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT0_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT0_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT1          0x0003F364
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT1_WIDTH    32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT1_MASK     0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT1_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT1_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT1_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT1_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT1_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT1_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT1_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT1_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT1_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT1_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT1_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT1_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT1_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT1_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT1_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT1_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT1_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT1_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT1_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT1_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT2          0x0003F368
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT2_WIDTH    32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT2_MASK     0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT2_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT2_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT2_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT2_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT2_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT2_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT2_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT2_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT2_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT2_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT2_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT2_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT2_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT2_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT2_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT2_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT2_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT2_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT2_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT2_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT3          0x0003F36C
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT3_WIDTH    32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT3_MASK     0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT3_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT3_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT3_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT3_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT3_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT3_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT3_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT3_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT3_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT3_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT3_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT3_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT3_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT3_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT3_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT3_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT3_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT3_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT3_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_EAST_3_SLOT3_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT0       0x0003F370
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT0_WIDTH 32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT0_MASK  0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT0_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT0_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT0_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT0_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT0_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT0_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT0_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT0_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT0_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT0_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT0_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT0_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT0_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT0_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT0_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT0_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT0_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT0_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT0_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT0_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT1       0x0003F374
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT1_WIDTH 32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT1_MASK  0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT1_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT1_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT1_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT1_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT1_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT1_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT1_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT1_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT1_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT1_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT1_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT1_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT1_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT1_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT1_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT1_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT1_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT1_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT1_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT1_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT2       0x0003F378
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT2_WIDTH 32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT2_MASK  0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT2_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT2_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT2_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT2_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT2_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT2_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT2_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT2_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT2_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT2_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT2_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT2_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT2_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT2_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT2_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT2_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT2_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT2_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT2_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT2_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT3       0x0003F37C
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT3_WIDTH 32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT3_MASK  0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT3_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT3_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT3_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT3_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT3_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT3_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT3_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT3_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT3_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT3_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT3_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT3_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT3_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT3_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT3_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT3_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT3_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT3_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT3_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_AIE_TRACE_SLOT3_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT0       0x0003F380
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT0_WIDTH 32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT0_MASK  0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT0_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT0_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT0_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT0_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT0_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT0_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT0_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT0_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT0_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT0_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT0_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT0_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT0_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT0_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT0_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT0_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT0_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT0_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT0_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT0_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT1       0x0003F384
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT1_WIDTH 32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT1_MASK  0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT1_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT1_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT1_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT1_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT1_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT1_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT1_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT1_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT1_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT1_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT1_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT1_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT1_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT1_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT1_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT1_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT1_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT1_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT1_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT1_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT2       0x0003F388
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT2_WIDTH 32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT2_MASK  0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT2_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT2_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT2_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT2_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT2_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT2_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT2_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT2_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT2_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT2_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT2_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT2_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT2_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT2_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT2_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT2_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT2_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT2_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT2_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT2_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT3       0x0003F38C
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT3_WIDTH 32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT3_MASK  0x1F1F0137
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT3_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT3_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT3_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT3_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT3_MASK_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT3_MASK_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT3_MASK_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT3_MASK_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT3_ENABLE_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT3_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT3_ENABLE_MASK 0x00000100
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT3_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT3_MSEL_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT3_MSEL_WIDTH 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT3_MSEL_MASK 0x00000030
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT3_MSEL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT3_ARBIT_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT3_ARBIT_WIDTH 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT3_ARBIT_MASK 0x00000007
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_SLAVE_MEM_TRACE_SLOT3_ARBIT_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB0_SLAVE0_1 0x0003F800
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB0_SLAVE0_1_WIDTH 32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB0_SLAVE0_1_MASK 0x3F1F3F1F
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB0_SLAVE0_1_PACKET_COUNT_1_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB0_SLAVE0_1_PACKET_COUNT_1_WIDTH 6
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB0_SLAVE0_1_PACKET_COUNT_1_MASK 0x3F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB0_SLAVE0_1_PACKET_COUNT_1_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB0_SLAVE0_1_SLAVE_ID_1_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB0_SLAVE0_1_SLAVE_ID_1_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB0_SLAVE0_1_SLAVE_ID_1_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB0_SLAVE0_1_SLAVE_ID_1_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB0_SLAVE0_1_PACKET_COUNT_0_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB0_SLAVE0_1_PACKET_COUNT_0_WIDTH 6
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB0_SLAVE0_1_PACKET_COUNT_0_MASK 0x00003F00
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB0_SLAVE0_1_PACKET_COUNT_0_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB0_SLAVE0_1_SLAVE_ID_0_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB0_SLAVE0_1_SLAVE_ID_0_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB0_SLAVE0_1_SLAVE_ID_0_MASK 0x0000001F
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB0_SLAVE0_1_SLAVE_ID_0_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB0_SLAVE2_3 0x0003F804
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB0_SLAVE2_3_WIDTH 32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB0_SLAVE2_3_MASK 0x3F1F3F1F
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB0_SLAVE2_3_PACKET_COUNT_3_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB0_SLAVE2_3_PACKET_COUNT_3_WIDTH 6
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB0_SLAVE2_3_PACKET_COUNT_3_MASK 0x3F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB0_SLAVE2_3_PACKET_COUNT_3_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB0_SLAVE2_3_SLAVE_ID_3_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB0_SLAVE2_3_SLAVE_ID_3_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB0_SLAVE2_3_SLAVE_ID_3_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB0_SLAVE2_3_SLAVE_ID_3_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB0_SLAVE2_3_PACKET_COUNT_2_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB0_SLAVE2_3_PACKET_COUNT_2_WIDTH 6
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB0_SLAVE2_3_PACKET_COUNT_2_MASK 0x00003F00
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB0_SLAVE2_3_PACKET_COUNT_2_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB0_SLAVE2_3_SLAVE_ID_2_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB0_SLAVE2_3_SLAVE_ID_2_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB0_SLAVE2_3_SLAVE_ID_2_MASK 0x0000001F
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB0_SLAVE2_3_SLAVE_ID_2_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB0_CTRL 0x0003F808
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB0_CTRL_WIDTH 32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB0_CTRL_MASK 0x00000001
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB0_CTRL_ENABLE_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB0_CTRL_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB0_CTRL_ENABLE_MASK 0x00000001
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB0_CTRL_ENABLE_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB1_SLAVE0_1 0x0003F810
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB1_SLAVE0_1_WIDTH 32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB1_SLAVE0_1_MASK 0x3F1F3F1F
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB1_SLAVE0_1_PACKET_COUNT_1_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB1_SLAVE0_1_PACKET_COUNT_1_WIDTH 6
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB1_SLAVE0_1_PACKET_COUNT_1_MASK 0x3F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB1_SLAVE0_1_PACKET_COUNT_1_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB1_SLAVE0_1_SLAVE_ID_1_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB1_SLAVE0_1_SLAVE_ID_1_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB1_SLAVE0_1_SLAVE_ID_1_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB1_SLAVE0_1_SLAVE_ID_1_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB1_SLAVE0_1_PACKET_COUNT_0_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB1_SLAVE0_1_PACKET_COUNT_0_WIDTH 6
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB1_SLAVE0_1_PACKET_COUNT_0_MASK 0x00003F00
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB1_SLAVE0_1_PACKET_COUNT_0_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB1_SLAVE0_1_SLAVE_ID_0_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB1_SLAVE0_1_SLAVE_ID_0_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB1_SLAVE0_1_SLAVE_ID_0_MASK 0x0000001F
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB1_SLAVE0_1_SLAVE_ID_0_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB1_SLAVE2_3 0x0003F814
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB1_SLAVE2_3_WIDTH 32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB1_SLAVE2_3_MASK 0x3F1F3F1F
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB1_SLAVE2_3_PACKET_COUNT_3_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB1_SLAVE2_3_PACKET_COUNT_3_WIDTH 6
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB1_SLAVE2_3_PACKET_COUNT_3_MASK 0x3F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB1_SLAVE2_3_PACKET_COUNT_3_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB1_SLAVE2_3_SLAVE_ID_3_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB1_SLAVE2_3_SLAVE_ID_3_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB1_SLAVE2_3_SLAVE_ID_3_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB1_SLAVE2_3_SLAVE_ID_3_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB1_SLAVE2_3_PACKET_COUNT_2_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB1_SLAVE2_3_PACKET_COUNT_2_WIDTH 6
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB1_SLAVE2_3_PACKET_COUNT_2_MASK 0x00003F00
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB1_SLAVE2_3_PACKET_COUNT_2_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB1_SLAVE2_3_SLAVE_ID_2_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB1_SLAVE2_3_SLAVE_ID_2_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB1_SLAVE2_3_SLAVE_ID_2_MASK 0x0000001F
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB1_SLAVE2_3_SLAVE_ID_2_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB1_CTRL 0x0003F818
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB1_CTRL_WIDTH 32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB1_CTRL_MASK 0x00000001
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB1_CTRL_ENABLE_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB1_CTRL_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB1_CTRL_ENABLE_MASK 0x00000001
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_DETERMINISTIC_MERGE_ARB1_CTRL_ENABLE_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_0      0x0003FF00
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_0_WIDTH 32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_0_MASK 0x3F3F3F3F
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_0_PORT_3_MASTER_SLAVE_LSB 29
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_0_PORT_3_MASTER_SLAVE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_0_PORT_3_MASTER_SLAVE_MASK 0x20000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_0_PORT_3_MASTER_SLAVE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_0_PORT_3_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_0_PORT_3_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_0_PORT_3_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_0_PORT_3_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_0_PORT_2_MASTER_SLAVE_LSB 21
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_0_PORT_2_MASTER_SLAVE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_0_PORT_2_MASTER_SLAVE_MASK 0x00200000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_0_PORT_2_MASTER_SLAVE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_0_PORT_2_ID_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_0_PORT_2_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_0_PORT_2_ID_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_0_PORT_2_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_0_PORT_1_MASTER_SLAVE_LSB 13
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_0_PORT_1_MASTER_SLAVE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_0_PORT_1_MASTER_SLAVE_MASK 0x00002000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_0_PORT_1_MASTER_SLAVE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_0_PORT_1_ID_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_0_PORT_1_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_0_PORT_1_ID_MASK 0x00001F00
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_0_PORT_1_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_0_PORT_0_MASTER_SLAVE_LSB 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_0_PORT_0_MASTER_SLAVE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_0_PORT_0_MASTER_SLAVE_MASK 0x00000020
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_0_PORT_0_MASTER_SLAVE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_0_PORT_0_ID_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_0_PORT_0_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_0_PORT_0_ID_MASK 0x0000001F
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_0_PORT_0_ID_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_1      0x0003FF04
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_1_WIDTH 32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_1_MASK 0x3F3F3F3F
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_1_PORT_7_MASTER_SLAVE_LSB 29
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_1_PORT_7_MASTER_SLAVE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_1_PORT_7_MASTER_SLAVE_MASK 0x20000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_1_PORT_7_MASTER_SLAVE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_1_PORT_7_ID_LSB 24
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_1_PORT_7_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_1_PORT_7_ID_MASK 0x1F000000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_1_PORT_7_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_1_PORT_6_MASTER_SLAVE_LSB 21
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_1_PORT_6_MASTER_SLAVE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_1_PORT_6_MASTER_SLAVE_MASK 0x00200000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_1_PORT_6_MASTER_SLAVE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_1_PORT_6_ID_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_1_PORT_6_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_1_PORT_6_ID_MASK 0x001F0000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_1_PORT_6_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_1_PORT_5_MASTER_SLAVE_LSB 13
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_1_PORT_5_MASTER_SLAVE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_1_PORT_5_MASTER_SLAVE_MASK 0x00002000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_1_PORT_5_MASTER_SLAVE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_1_PORT_5_ID_LSB 8
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_1_PORT_5_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_1_PORT_5_ID_MASK 0x00001F00
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_1_PORT_5_ID_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_1_PORT_4_MASTER_SLAVE_LSB 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_1_PORT_4_MASTER_SLAVE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_1_PORT_4_MASTER_SLAVE_MASK 0x00000020
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_1_PORT_4_MASTER_SLAVE_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_1_PORT_4_ID_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_1_PORT_4_ID_WIDTH 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_1_PORT_4_ID_MASK 0x0000001F
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_EVENT_PORT_SELECTION_1_PORT_4_ID_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_STATUS               0x0003FF10
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_STATUS_WIDTH         32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_STATUS_MASK          0x0000000F
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_STATUS_TILE_CONTROL_LSB 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_STATUS_TILE_CONTROL_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_STATUS_TILE_CONTROL_MASK 0x00000008
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_STATUS_TILE_CONTROL_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_STATUS_DMA_1_LSB   2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_STATUS_DMA_1_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_STATUS_DMA_1_MASK  0x00000004
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_STATUS_DMA_1_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_STATUS_DMA_0_LSB   1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_STATUS_DMA_0_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_STATUS_DMA_0_MASK  0x00000002
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_STATUS_DMA_0_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_STATUS_CORE_LSB    0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_STATUS_CORE_WIDTH  1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_STATUS_CORE_MASK   0x00000001
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_STATUS_CORE_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION            0x0003FF20
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_WIDTH      32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_MASK       0x003F003F
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_MEM_TRACE_UPPER_LSB 21
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_MEM_TRACE_UPPER_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_MEM_TRACE_UPPER_MASK 0x00200000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_MEM_TRACE_UPPER_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_AIE_TRACE_UPPER_LSB 20
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_AIE_TRACE_UPPER_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_AIE_TRACE_UPPER_MASK 0x00100000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_AIE_TRACE_UPPER_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_TILE_CONTROL_UPPER_LSB 19
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_TILE_CONTROL_UPPER_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_TILE_CONTROL_UPPER_MASK 0x00080000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_TILE_CONTROL_UPPER_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_DMA_1_UPPER_LSB 18
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_DMA_1_UPPER_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_DMA_1_UPPER_MASK 0x00040000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_DMA_1_UPPER_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_DMA_0_UPPER_LSB 17
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_DMA_0_UPPER_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_DMA_0_UPPER_MASK 0x00020000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_DMA_0_UPPER_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_CORE_UPPER_LSB 16
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_CORE_UPPER_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_CORE_UPPER_MASK 0x00010000
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_CORE_UPPER_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_MEM_TRACE_LOWER_LSB 5
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_MEM_TRACE_LOWER_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_MEM_TRACE_LOWER_MASK 0x00000020
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_MEM_TRACE_LOWER_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_AIE_TRACE_LOWER_LSB 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_AIE_TRACE_LOWER_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_AIE_TRACE_LOWER_MASK 0x00000010
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_AIE_TRACE_LOWER_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_TILE_CONTROL_LOWER_LSB 3
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_TILE_CONTROL_LOWER_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_TILE_CONTROL_LOWER_MASK 0x00000008
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_TILE_CONTROL_LOWER_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_DMA_1_LOWER_LSB 2
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_DMA_1_LOWER_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_DMA_1_LOWER_MASK 0x00000004
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_DMA_1_LOWER_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_DMA_0_LOWER_LSB 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_DMA_0_LOWER_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_DMA_0_LOWER_MASK 0x00000002
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_DMA_0_LOWER_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_CORE_LOWER_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_CORE_LOWER_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_CORE_LOWER_MASK 0x00000001
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_PARITY_INJECTION_CORE_LOWER_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_TILE_CONTROL_PACKET_HANDLER_STATUS        0x0003FF30
#define XAIE2PGBL_CORE_MODULE_TILE_CONTROL_PACKET_HANDLER_STATUS_WIDTH  32
#define XAIE2PGBL_CORE_MODULE_TILE_CONTROL_PACKET_HANDLER_STATUS_MASK   0x0000000F
#define XAIE2PGBL_CORE_MODULE_TILE_CONTROL_PACKET_HANDLER_STATUS_TLAST_ERROR_LSB 3
#define XAIE2PGBL_CORE_MODULE_TILE_CONTROL_PACKET_HANDLER_STATUS_TLAST_ERROR_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_TILE_CONTROL_PACKET_HANDLER_STATUS_TLAST_ERROR_MASK 0x00000008
#define XAIE2PGBL_CORE_MODULE_TILE_CONTROL_PACKET_HANDLER_STATUS_TLAST_ERROR_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_TILE_CONTROL_PACKET_HANDLER_STATUS_SLVERR_ON_ACCESS_LSB 2
#define XAIE2PGBL_CORE_MODULE_TILE_CONTROL_PACKET_HANDLER_STATUS_SLVERR_ON_ACCESS_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_TILE_CONTROL_PACKET_HANDLER_STATUS_SLVERR_ON_ACCESS_MASK 0x00000004
#define XAIE2PGBL_CORE_MODULE_TILE_CONTROL_PACKET_HANDLER_STATUS_SLVERR_ON_ACCESS_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_TILE_CONTROL_PACKET_HANDLER_STATUS_SECOND_HEADER_PARITY_ERROR_LSB 1
#define XAIE2PGBL_CORE_MODULE_TILE_CONTROL_PACKET_HANDLER_STATUS_SECOND_HEADER_PARITY_ERROR_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_TILE_CONTROL_PACKET_HANDLER_STATUS_SECOND_HEADER_PARITY_ERROR_MASK 0x00000002
#define XAIE2PGBL_CORE_MODULE_TILE_CONTROL_PACKET_HANDLER_STATUS_SECOND_HEADER_PARITY_ERROR_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_TILE_CONTROL_PACKET_HANDLER_STATUS_FIRST_HEADER_PARITY_ERROR_LSB 0
#define XAIE2PGBL_CORE_MODULE_TILE_CONTROL_PACKET_HANDLER_STATUS_FIRST_HEADER_PARITY_ERROR_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_TILE_CONTROL_PACKET_HANDLER_STATUS_FIRST_HEADER_PARITY_ERROR_MASK 0x00000001
#define XAIE2PGBL_CORE_MODULE_TILE_CONTROL_PACKET_HANDLER_STATUS_FIRST_HEADER_PARITY_ERROR_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_ADAPTIVE_CLOCK_GATE_STATUS  0x0003FF34
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_ADAPTIVE_CLOCK_GATE_STATUS_WIDTH 32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_ADAPTIVE_CLOCK_GATE_STATUS_MASK 0x00000001
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_ADAPTIVE_CLOCK_GATE_STATUS_ACTIVE_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_ADAPTIVE_CLOCK_GATE_STATUS_ACTIVE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_ADAPTIVE_CLOCK_GATE_STATUS_ACTIVE_MASK 0x00000001
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_ADAPTIVE_CLOCK_GATE_STATUS_ACTIVE_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_ADAPTIVE_CLOCK_GATE_ABORT_PERIOD 0x0003FF38
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_ADAPTIVE_CLOCK_GATE_ABORT_PERIOD_WIDTH 32
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_ADAPTIVE_CLOCK_GATE_ABORT_PERIOD_MASK 0x0000000F
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_ADAPTIVE_CLOCK_GATE_ABORT_PERIOD_ABORT_PERIOD_LSB 0
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_ADAPTIVE_CLOCK_GATE_ABORT_PERIOD_ABORT_PERIOD_WIDTH 4
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_ADAPTIVE_CLOCK_GATE_ABORT_PERIOD_ABORT_PERIOD_MASK 0x0000000F
#define XAIE2PGBL_CORE_MODULE_STREAM_SWITCH_ADAPTIVE_CLOCK_GATE_ABORT_PERIOD_ABORT_PERIOD_DEFVAL 0x7

#define XAIE2PGBL_CORE_MODULE_MODULE_CLOCK_CONTROL                      0x00060000
#define XAIE2PGBL_CORE_MODULE_MODULE_CLOCK_CONTROL_WIDTH                32
#define XAIE2PGBL_CORE_MODULE_MODULE_CLOCK_CONTROL_MASK                 0x00000037
#define XAIE2PGBL_CORE_MODULE_MODULE_CLOCK_CONTROL_DMA_ADAPTIVE_CLOCK_GATE_LSB 5
#define XAIE2PGBL_CORE_MODULE_MODULE_CLOCK_CONTROL_DMA_ADAPTIVE_CLOCK_GATE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_MODULE_CLOCK_CONTROL_DMA_ADAPTIVE_CLOCK_GATE_MASK 0x00000020
#define XAIE2PGBL_CORE_MODULE_MODULE_CLOCK_CONTROL_DMA_ADAPTIVE_CLOCK_GATE_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_MODULE_CLOCK_CONTROL_STREAM_SWITCH_ADAPTIVE_CLOCK_GATE_LSB 4
#define XAIE2PGBL_CORE_MODULE_MODULE_CLOCK_CONTROL_STREAM_SWITCH_ADAPTIVE_CLOCK_GATE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_MODULE_CLOCK_CONTROL_STREAM_SWITCH_ADAPTIVE_CLOCK_GATE_MASK 0x00000010
#define XAIE2PGBL_CORE_MODULE_MODULE_CLOCK_CONTROL_STREAM_SWITCH_ADAPTIVE_CLOCK_GATE_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_MODULE_CLOCK_CONTROL_CORE_MODULE_CLOCK_ENABLE_LSB 2
#define XAIE2PGBL_CORE_MODULE_MODULE_CLOCK_CONTROL_CORE_MODULE_CLOCK_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_MODULE_CLOCK_CONTROL_CORE_MODULE_CLOCK_ENABLE_MASK 0x00000004
#define XAIE2PGBL_CORE_MODULE_MODULE_CLOCK_CONTROL_CORE_MODULE_CLOCK_ENABLE_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_MODULE_CLOCK_CONTROL_MEMORY_MODULE_CLOCK_ENABLE_LSB 1
#define XAIE2PGBL_CORE_MODULE_MODULE_CLOCK_CONTROL_MEMORY_MODULE_CLOCK_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_MODULE_CLOCK_CONTROL_MEMORY_MODULE_CLOCK_ENABLE_MASK 0x00000002
#define XAIE2PGBL_CORE_MODULE_MODULE_CLOCK_CONTROL_MEMORY_MODULE_CLOCK_ENABLE_DEFVAL 0x1
#define XAIE2PGBL_CORE_MODULE_MODULE_CLOCK_CONTROL_STREAM_SWITCH_CLOCK_ENABLE_LSB 0
#define XAIE2PGBL_CORE_MODULE_MODULE_CLOCK_CONTROL_STREAM_SWITCH_CLOCK_ENABLE_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_MODULE_CLOCK_CONTROL_STREAM_SWITCH_CLOCK_ENABLE_MASK 0x00000001
#define XAIE2PGBL_CORE_MODULE_MODULE_CLOCK_CONTROL_STREAM_SWITCH_CLOCK_ENABLE_DEFVAL 0x1

#define XAIE2PGBL_CORE_MODULE_MODULE_RESET_CONTROL                      0x00060010
#define XAIE2PGBL_CORE_MODULE_MODULE_RESET_CONTROL_WIDTH                32
#define XAIE2PGBL_CORE_MODULE_MODULE_RESET_CONTROL_MASK                 0x00000007
#define XAIE2PGBL_CORE_MODULE_MODULE_RESET_CONTROL_CORE_MODULE_RESET_LSB 2
#define XAIE2PGBL_CORE_MODULE_MODULE_RESET_CONTROL_CORE_MODULE_RESET_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_MODULE_RESET_CONTROL_CORE_MODULE_RESET_MASK 0x00000004
#define XAIE2PGBL_CORE_MODULE_MODULE_RESET_CONTROL_CORE_MODULE_RESET_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_MODULE_RESET_CONTROL_MEMORY_MODULE_RESET_LSB 1
#define XAIE2PGBL_CORE_MODULE_MODULE_RESET_CONTROL_MEMORY_MODULE_RESET_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_MODULE_RESET_CONTROL_MEMORY_MODULE_RESET_MASK 0x00000002
#define XAIE2PGBL_CORE_MODULE_MODULE_RESET_CONTROL_MEMORY_MODULE_RESET_DEFVAL 0x0
#define XAIE2PGBL_CORE_MODULE_MODULE_RESET_CONTROL_STREAM_SWITCH_RESET_LSB 0
#define XAIE2PGBL_CORE_MODULE_MODULE_RESET_CONTROL_STREAM_SWITCH_RESET_WIDTH 1
#define XAIE2PGBL_CORE_MODULE_MODULE_RESET_CONTROL_STREAM_SWITCH_RESET_MASK 0x00000001
#define XAIE2PGBL_CORE_MODULE_MODULE_RESET_CONTROL_STREAM_SWITCH_RESET_DEFVAL 0x0

#define XAIE2PGBL_CORE_MODULE_TILE_CONTROL                              0x00060020
#define XAIE2PGBL_CORE_MODULE_TILE_CONTROL_WIDTH                        32
#define XAIE2PGBL_CORE_MODULE_TILE_CONTROL_MASK                         0x0000000F
#define XAIE2PGBL_CORE_MODULE_TILE_CONTROL_ISOLATE_FROM_EAST_LSB      3
#define XAIE2PGBL_CORE_MODULE_TILE_CONTROL_ISOLATE_FROM_EAST_WIDTH    1
#define XAIE2PGBL_CORE_MODULE_TILE_CONTROL_ISOLATE_FROM_EAST_MASK     0x00000008
#define XAIE2PGBL_CORE_MODULE_TILE_CONTROL_ISOLATE_FROM_EAST_DEFVAL   0x1
#define XAIE2PGBL_CORE_MODULE_TILE_CONTROL_ISOLATE_FROM_NORTH_LSB     2
#define XAIE2PGBL_CORE_MODULE_TILE_CONTROL_ISOLATE_FROM_NORTH_WIDTH   1
#define XAIE2PGBL_CORE_MODULE_TILE_CONTROL_ISOLATE_FROM_NORTH_MASK    0x00000004
#define XAIE2PGBL_CORE_MODULE_TILE_CONTROL_ISOLATE_FROM_NORTH_DEFVAL  0x1
#define XAIE2PGBL_CORE_MODULE_TILE_CONTROL_ISOLATE_FROM_WEST_LSB      1
#define XAIE2PGBL_CORE_MODULE_TILE_CONTROL_ISOLATE_FROM_WEST_WIDTH    1
#define XAIE2PGBL_CORE_MODULE_TILE_CONTROL_ISOLATE_FROM_WEST_MASK     0x00000002
#define XAIE2PGBL_CORE_MODULE_TILE_CONTROL_ISOLATE_FROM_WEST_DEFVAL   0x1
#define XAIE2PGBL_CORE_MODULE_TILE_CONTROL_ISOLATE_FROM_SOUTH_LSB     0
#define XAIE2PGBL_CORE_MODULE_TILE_CONTROL_ISOLATE_FROM_SOUTH_WIDTH   1
#define XAIE2PGBL_CORE_MODULE_TILE_CONTROL_ISOLATE_FROM_SOUTH_MASK    0x00000001
#define XAIE2PGBL_CORE_MODULE_TILE_CONTROL_ISOLATE_FROM_SOUTH_DEFVAL  0x1
/** @} */

/* AIE2P memory module register definitions */

/**
 * @name Memory Module register definitions
 * This registers contains memory module information
 * @{
 */
/**
 * Register:XAIE2PGBL_MEMORY_MODULE
 */
#define XAIE2PGBL_MEMORY_MODULE_DATAMEMORY                              0x00000000
#define XAIE2PGBL_MEMORY_MODULE_DATAMEMORY_WIDTH                        256
#define XAIE2PGBL_MEMORY_MODULE_DATAMEMORY_MASK                         0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DATAMEMORY_DATA_LSB                   0
#define XAIE2PGBL_MEMORY_MODULE_DATAMEMORY_DATA_WIDTH                 256
#define XAIE2PGBL_MEMORY_MODULE_DATAMEMORY_DATA_MASK                  0xFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DATAMEMORY_DATA_DEFVAL                0x0

#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_CONTROL0                    0x00011000
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_CONTROL0_WIDTH              32
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_CONTROL0_MASK               0x7F7F7F7F
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_CONTROL0_CNT1_STOP_EVENT_LSB 24
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_CONTROL0_CNT1_STOP_EVENT_WIDTH 7
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_CONTROL0_CNT1_STOP_EVENT_MASK 0x7F000000
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_CONTROL0_CNT1_STOP_EVENT_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_CONTROL0_CNT1_START_EVENT_LSB 16
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_CONTROL0_CNT1_START_EVENT_WIDTH 7
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_CONTROL0_CNT1_START_EVENT_MASK 0x007F0000
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_CONTROL0_CNT1_START_EVENT_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_CONTROL0_CNT0_STOP_EVENT_LSB 8
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_CONTROL0_CNT0_STOP_EVENT_WIDTH 7
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_CONTROL0_CNT0_STOP_EVENT_MASK 0x00007F00
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_CONTROL0_CNT0_STOP_EVENT_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_CONTROL0_CNT0_START_EVENT_LSB 0
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_CONTROL0_CNT0_START_EVENT_WIDTH 7
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_CONTROL0_CNT0_START_EVENT_MASK 0x0000007F
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_CONTROL0_CNT0_START_EVENT_DEFVAL 0x0

#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_CONTROL1                    0x00011008
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_CONTROL1_WIDTH              32
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_CONTROL1_MASK               0x00007F7F
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_CONTROL1_CNT1_RESET_EVENT_LSB 8
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_CONTROL1_CNT1_RESET_EVENT_WIDTH 7
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_CONTROL1_CNT1_RESET_EVENT_MASK 0x00007F00
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_CONTROL1_CNT1_RESET_EVENT_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_CONTROL1_CNT0_RESET_EVENT_LSB 0
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_CONTROL1_CNT0_RESET_EVENT_WIDTH 7
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_CONTROL1_CNT0_RESET_EVENT_MASK 0x0000007F
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_CONTROL1_CNT0_RESET_EVENT_DEFVAL 0x0

#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_COUNTER0                    0x00011020
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_COUNTER0_WIDTH              32
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_COUNTER0_MASK               0xFFFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_COUNTER0_COUNTER0_VALUE_LSB 0
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_COUNTER0_COUNTER0_VALUE_WIDTH 32
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_COUNTER0_COUNTER0_VALUE_MASK 0xFFFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_COUNTER0_COUNTER0_VALUE_DEFVAL 0x0

#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_COUNTER1                    0x00011024
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_COUNTER1_WIDTH              32
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_COUNTER1_MASK               0xFFFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_COUNTER1_COUNTER1_VALUE_LSB 0
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_COUNTER1_COUNTER1_VALUE_WIDTH 32
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_COUNTER1_COUNTER1_VALUE_MASK 0xFFFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_COUNTER1_COUNTER1_VALUE_DEFVAL 0x0

#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_COUNTER0_EVENT_VALUE        0x00011080
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_COUNTER0_EVENT_VALUE_WIDTH  32
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_COUNTER0_EVENT_VALUE_MASK   0xFFFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_COUNTER0_EVENT_VALUE_COUNTER0_EVENT_VALUE_LSB 0
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_COUNTER0_EVENT_VALUE_COUNTER0_EVENT_VALUE_WIDTH 32
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_COUNTER0_EVENT_VALUE_COUNTER0_EVENT_VALUE_MASK 0xFFFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_COUNTER0_EVENT_VALUE_COUNTER0_EVENT_VALUE_DEFVAL 0x0

#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_COUNTER1_EVENT_VALUE        0x00011084
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_COUNTER1_EVENT_VALUE_WIDTH  32
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_COUNTER1_EVENT_VALUE_MASK   0xFFFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_COUNTER1_EVENT_VALUE_COUNTER1_EVENT_VALUE_LSB 0
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_COUNTER1_EVENT_VALUE_COUNTER1_EVENT_VALUE_WIDTH 32
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_COUNTER1_EVENT_VALUE_COUNTER1_EVENT_VALUE_MASK 0xFFFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_PERFORMANCE_COUNTER1_EVENT_VALUE_COUNTER1_EVENT_VALUE_DEFVAL 0x0

#define XAIE2PGBL_MEMORY_MODULE_CHECKBIT_ERROR_GENERATION               0x00012000
#define XAIE2PGBL_MEMORY_MODULE_CHECKBIT_ERROR_GENERATION_WIDTH         32
#define XAIE2PGBL_MEMORY_MODULE_CHECKBIT_ERROR_GENERATION_MASK          0x000000FF
#define XAIE2PGBL_MEMORY_MODULE_CHECKBIT_ERROR_GENERATION_LANE7_LSB   7
#define XAIE2PGBL_MEMORY_MODULE_CHECKBIT_ERROR_GENERATION_LANE7_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_CHECKBIT_ERROR_GENERATION_LANE7_MASK  0x00000080
#define XAIE2PGBL_MEMORY_MODULE_CHECKBIT_ERROR_GENERATION_LANE7_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_CHECKBIT_ERROR_GENERATION_LANE6_LSB   6
#define XAIE2PGBL_MEMORY_MODULE_CHECKBIT_ERROR_GENERATION_LANE6_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_CHECKBIT_ERROR_GENERATION_LANE6_MASK  0x00000040
#define XAIE2PGBL_MEMORY_MODULE_CHECKBIT_ERROR_GENERATION_LANE6_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_CHECKBIT_ERROR_GENERATION_LANE5_LSB   5
#define XAIE2PGBL_MEMORY_MODULE_CHECKBIT_ERROR_GENERATION_LANE5_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_CHECKBIT_ERROR_GENERATION_LANE5_MASK  0x00000020
#define XAIE2PGBL_MEMORY_MODULE_CHECKBIT_ERROR_GENERATION_LANE5_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_CHECKBIT_ERROR_GENERATION_LANE4_LSB   4
#define XAIE2PGBL_MEMORY_MODULE_CHECKBIT_ERROR_GENERATION_LANE4_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_CHECKBIT_ERROR_GENERATION_LANE4_MASK  0x00000010
#define XAIE2PGBL_MEMORY_MODULE_CHECKBIT_ERROR_GENERATION_LANE4_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_CHECKBIT_ERROR_GENERATION_LANE3_LSB   3
#define XAIE2PGBL_MEMORY_MODULE_CHECKBIT_ERROR_GENERATION_LANE3_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_CHECKBIT_ERROR_GENERATION_LANE3_MASK  0x00000008
#define XAIE2PGBL_MEMORY_MODULE_CHECKBIT_ERROR_GENERATION_LANE3_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_CHECKBIT_ERROR_GENERATION_LANE2_LSB   2
#define XAIE2PGBL_MEMORY_MODULE_CHECKBIT_ERROR_GENERATION_LANE2_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_CHECKBIT_ERROR_GENERATION_LANE2_MASK  0x00000004
#define XAIE2PGBL_MEMORY_MODULE_CHECKBIT_ERROR_GENERATION_LANE2_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_CHECKBIT_ERROR_GENERATION_LANE1_LSB   1
#define XAIE2PGBL_MEMORY_MODULE_CHECKBIT_ERROR_GENERATION_LANE1_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_CHECKBIT_ERROR_GENERATION_LANE1_MASK  0x00000002
#define XAIE2PGBL_MEMORY_MODULE_CHECKBIT_ERROR_GENERATION_LANE1_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_CHECKBIT_ERROR_GENERATION_LANE0_LSB   0
#define XAIE2PGBL_MEMORY_MODULE_CHECKBIT_ERROR_GENERATION_LANE0_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_CHECKBIT_ERROR_GENERATION_LANE0_MASK  0x00000001
#define XAIE2PGBL_MEMORY_MODULE_CHECKBIT_ERROR_GENERATION_LANE0_DEFVAL 0x0

#define XAIE2PGBL_MEMORY_MODULE_ECC_SCRUBBING_EVENT                     0x00012110
#define XAIE2PGBL_MEMORY_MODULE_ECC_SCRUBBING_EVENT_WIDTH               32
#define XAIE2PGBL_MEMORY_MODULE_ECC_SCRUBBING_EVENT_MASK                0x0000007F
#define XAIE2PGBL_MEMORY_MODULE_ECC_SCRUBBING_EVENT_SCRUBBING_EVENT_NUMBER_LSB 0
#define XAIE2PGBL_MEMORY_MODULE_ECC_SCRUBBING_EVENT_SCRUBBING_EVENT_NUMBER_WIDTH 7
#define XAIE2PGBL_MEMORY_MODULE_ECC_SCRUBBING_EVENT_SCRUBBING_EVENT_NUMBER_MASK 0x0000007F
#define XAIE2PGBL_MEMORY_MODULE_ECC_SCRUBBING_EVENT_SCRUBBING_EVENT_NUMBER_DEFVAL 0x0

#define XAIE2PGBL_MEMORY_MODULE_ECC_FAILING_ADDRESS                     0x00012120
#define XAIE2PGBL_MEMORY_MODULE_ECC_FAILING_ADDRESS_WIDTH               32
#define XAIE2PGBL_MEMORY_MODULE_ECC_FAILING_ADDRESS_MASK                0x0000BFFF
#define XAIE2PGBL_MEMORY_MODULE_ECC_FAILING_ADDRESS_VALID_LSB         15
#define XAIE2PGBL_MEMORY_MODULE_ECC_FAILING_ADDRESS_VALID_WIDTH       1
#define XAIE2PGBL_MEMORY_MODULE_ECC_FAILING_ADDRESS_VALID_MASK        0x00008000
#define XAIE2PGBL_MEMORY_MODULE_ECC_FAILING_ADDRESS_VALID_DEFVAL      0x0
#define XAIE2PGBL_MEMORY_MODULE_ECC_FAILING_ADDRESS_ECC_ERROR_DETECTION_ADDRESS_LSB 0
#define XAIE2PGBL_MEMORY_MODULE_ECC_FAILING_ADDRESS_ECC_ERROR_DETECTION_ADDRESS_WIDTH 14
#define XAIE2PGBL_MEMORY_MODULE_ECC_FAILING_ADDRESS_ECC_ERROR_DETECTION_ADDRESS_MASK 0x00003FFF
#define XAIE2PGBL_MEMORY_MODULE_ECC_FAILING_ADDRESS_ECC_ERROR_DETECTION_ADDRESS_DEFVAL 0x0

#define XAIE2PGBL_MEMORY_MODULE_PARITY_FAILING_ADDRESS                  0x00012124
#define XAIE2PGBL_MEMORY_MODULE_PARITY_FAILING_ADDRESS_WIDTH            32
#define XAIE2PGBL_MEMORY_MODULE_PARITY_FAILING_ADDRESS_MASK             0x0001FFFF
#define XAIE2PGBL_MEMORY_MODULE_PARITY_FAILING_ADDRESS_VALID_LSB      16
#define XAIE2PGBL_MEMORY_MODULE_PARITY_FAILING_ADDRESS_VALID_WIDTH    1
#define XAIE2PGBL_MEMORY_MODULE_PARITY_FAILING_ADDRESS_VALID_MASK     0x00010000
#define XAIE2PGBL_MEMORY_MODULE_PARITY_FAILING_ADDRESS_VALID_DEFVAL   0x0
#define XAIE2PGBL_MEMORY_MODULE_PARITY_FAILING_ADDRESS_PARITY_ERROR_DETECTION_ADDRESS_LSB 0
#define XAIE2PGBL_MEMORY_MODULE_PARITY_FAILING_ADDRESS_PARITY_ERROR_DETECTION_ADDRESS_WIDTH 16
#define XAIE2PGBL_MEMORY_MODULE_PARITY_FAILING_ADDRESS_PARITY_ERROR_DETECTION_ADDRESS_MASK 0x0000FFFF
#define XAIE2PGBL_MEMORY_MODULE_PARITY_FAILING_ADDRESS_PARITY_ERROR_DETECTION_ADDRESS_DEFVAL 0x0

#define XAIE2PGBL_MEMORY_MODULE_TIMER_CONTROL                           0x00014000
#define XAIE2PGBL_MEMORY_MODULE_TIMER_CONTROL_WIDTH                     32
#define XAIE2PGBL_MEMORY_MODULE_TIMER_CONTROL_MASK                      0x80007F00
#define XAIE2PGBL_MEMORY_MODULE_TIMER_CONTROL_RESET_LSB               31
#define XAIE2PGBL_MEMORY_MODULE_TIMER_CONTROL_RESET_WIDTH             1
#define XAIE2PGBL_MEMORY_MODULE_TIMER_CONTROL_RESET_MASK              0x80000000
#define XAIE2PGBL_MEMORY_MODULE_TIMER_CONTROL_RESET_DEFVAL            0x0
#define XAIE2PGBL_MEMORY_MODULE_TIMER_CONTROL_RESET_EVENT_LSB         8
#define XAIE2PGBL_MEMORY_MODULE_TIMER_CONTROL_RESET_EVENT_WIDTH       7
#define XAIE2PGBL_MEMORY_MODULE_TIMER_CONTROL_RESET_EVENT_MASK        0x00007F00
#define XAIE2PGBL_MEMORY_MODULE_TIMER_CONTROL_RESET_EVENT_DEFVAL      0x0

#define XAIE2PGBL_MEMORY_MODULE_EVENT_GENERATE                          0x00014008
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GENERATE_WIDTH                    32
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GENERATE_MASK                     0x0000007F
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GENERATE_EVENT_LSB              0
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GENERATE_EVENT_WIDTH            7
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GENERATE_EVENT_MASK             0x0000007F
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GENERATE_EVENT_DEFVAL           0x0

#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST0                        0x00014010
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST0_WIDTH                  32
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST0_MASK                   0x0000007F
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST0_EVENT_LSB            0
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST0_EVENT_WIDTH          7
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST0_EVENT_MASK           0x0000007F
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST0_EVENT_DEFVAL         0x0

#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST1                        0x00014014
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST1_WIDTH                  32
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST1_MASK                   0x0000007F
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST1_EVENT_LSB            0
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST1_EVENT_WIDTH          7
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST1_EVENT_MASK           0x0000007F
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST1_EVENT_DEFVAL         0x0

#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST2                        0x00014018
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST2_WIDTH                  32
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST2_MASK                   0x0000007F
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST2_EVENT_LSB            0
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST2_EVENT_WIDTH          7
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST2_EVENT_MASK           0x0000007F
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST2_EVENT_DEFVAL         0x0

#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST3                        0x0001401C
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST3_WIDTH                  32
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST3_MASK                   0x0000007F
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST3_EVENT_LSB            0
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST3_EVENT_WIDTH          7
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST3_EVENT_MASK           0x0000007F
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST3_EVENT_DEFVAL         0x0

#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST4                        0x00014020
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST4_WIDTH                  32
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST4_MASK                   0x0000007F
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST4_EVENT_LSB            0
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST4_EVENT_WIDTH          7
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST4_EVENT_MASK           0x0000007F
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST4_EVENT_DEFVAL         0x0

#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST5                        0x00014024
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST5_WIDTH                  32
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST5_MASK                   0x0000007F
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST5_EVENT_LSB            0
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST5_EVENT_WIDTH          7
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST5_EVENT_MASK           0x0000007F
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST5_EVENT_DEFVAL         0x0

#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST6                        0x00014028
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST6_WIDTH                  32
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST6_MASK                   0x0000007F
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST6_EVENT_LSB            0
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST6_EVENT_WIDTH          7
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST6_EVENT_MASK           0x0000007F
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST6_EVENT_DEFVAL         0x0

#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST7                        0x0001402C
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST7_WIDTH                  32
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST7_MASK                   0x0000007F
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST7_EVENT_LSB            0
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST7_EVENT_WIDTH          7
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST7_EVENT_MASK           0x0000007F
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST7_EVENT_DEFVAL         0x0

#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST8                        0x00014030
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST8_WIDTH                  32
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST8_MASK                   0x0000007F
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST8_EVENT_LSB            0
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST8_EVENT_WIDTH          7
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST8_EVENT_MASK           0x0000007F
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST8_EVENT_DEFVAL         0x0

#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST9                        0x00014034
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST9_WIDTH                  32
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST9_MASK                   0x0000007F
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST9_EVENT_LSB            0
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST9_EVENT_WIDTH          7
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST9_EVENT_MASK           0x0000007F
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST9_EVENT_DEFVAL         0x0

#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST10                       0x00014038
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST10_WIDTH                 32
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST10_MASK                  0x0000007F
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST10_EVENT_LSB           0
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST10_EVENT_WIDTH         7
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST10_EVENT_MASK          0x0000007F
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST10_EVENT_DEFVAL        0x0

#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST11                       0x0001403C
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST11_WIDTH                 32
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST11_MASK                  0x0000007F
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST11_EVENT_LSB           0
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST11_EVENT_WIDTH         7
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST11_EVENT_MASK          0x0000007F
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST11_EVENT_DEFVAL        0x0

#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST12                       0x00014040
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST12_WIDTH                 32
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST12_MASK                  0x0000007F
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST12_EVENT_LSB           0
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST12_EVENT_WIDTH         7
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST12_EVENT_MASK          0x0000007F
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST12_EVENT_DEFVAL        0x0

#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST13                       0x00014044
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST13_WIDTH                 32
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST13_MASK                  0x0000007F
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST13_EVENT_LSB           0
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST13_EVENT_WIDTH         7
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST13_EVENT_MASK          0x0000007F
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST13_EVENT_DEFVAL        0x0

#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST14                       0x00014048
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST14_WIDTH                 32
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST14_MASK                  0x0000007F
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST14_EVENT_LSB           0
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST14_EVENT_WIDTH         7
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST14_EVENT_MASK          0x0000007F
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST14_EVENT_DEFVAL        0x0

#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST15                       0x0001404C
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST15_WIDTH                 32
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST15_MASK                  0x0000007F
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST15_EVENT_LSB           0
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST15_EVENT_WIDTH         7
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST15_EVENT_MASK          0x0000007F
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST15_EVENT_DEFVAL        0x0

#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_SOUTH_SET         0x00014050
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_SOUTH_SET_WIDTH   32
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_SOUTH_SET_MASK    0x0000FFFF
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_SOUTH_SET_SET_LSB 0
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_SOUTH_SET_SET_WIDTH 16
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_SOUTH_SET_SET_MASK 0x0000FFFF
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_SOUTH_SET_SET_DEFVAL 0x0

#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_SOUTH_CLR         0x00014054
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_SOUTH_CLR_WIDTH   32
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_SOUTH_CLR_MASK    0x0000FFFF
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_SOUTH_CLR_CLEAR_LSB 0
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_SOUTH_CLR_CLEAR_WIDTH 16
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_SOUTH_CLR_CLEAR_MASK 0x0000FFFF
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_SOUTH_CLR_CLEAR_DEFVAL 0x0

#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_SOUTH_VALUE       0x00014058
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_SOUTH_VALUE_WIDTH 32
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_SOUTH_VALUE_MASK  0x0000FFFF
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_SOUTH_VALUE_VALUE_LSB 0
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_SOUTH_VALUE_VALUE_WIDTH 16
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_SOUTH_VALUE_VALUE_MASK 0x0000FFFF
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_SOUTH_VALUE_VALUE_DEFVAL 0x0

#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_WEST_SET          0x00014060
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_WEST_SET_WIDTH    32
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_WEST_SET_MASK     0x0000FFFF
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_WEST_SET_SET_LSB 0
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_WEST_SET_SET_WIDTH 16
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_WEST_SET_SET_MASK 0x0000FFFF
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_WEST_SET_SET_DEFVAL 0x0

#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_WEST_CLR          0x00014064
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_WEST_CLR_WIDTH    32
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_WEST_CLR_MASK     0x0000FFFF
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_WEST_CLR_CLEAR_LSB 0
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_WEST_CLR_CLEAR_WIDTH 16
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_WEST_CLR_CLEAR_MASK 0x0000FFFF
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_WEST_CLR_CLEAR_DEFVAL 0x0

#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_WEST_VALUE        0x00014068
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_WEST_VALUE_WIDTH  32
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_WEST_VALUE_MASK   0x0000FFFF
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_WEST_VALUE_VALUE_LSB 0
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_WEST_VALUE_VALUE_WIDTH 16
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_WEST_VALUE_VALUE_MASK 0x0000FFFF
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_WEST_VALUE_VALUE_DEFVAL 0x0

#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_NORTH_SET         0x00014070
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_NORTH_SET_WIDTH   32
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_NORTH_SET_MASK    0x0000FFFF
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_NORTH_SET_SET_LSB 0
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_NORTH_SET_SET_WIDTH 16
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_NORTH_SET_SET_MASK 0x0000FFFF
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_NORTH_SET_SET_DEFVAL 0x0

#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_NORTH_CLR         0x00014074
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_NORTH_CLR_WIDTH   32
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_NORTH_CLR_MASK    0x0000FFFF
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_NORTH_CLR_CLEAR_LSB 0
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_NORTH_CLR_CLEAR_WIDTH 16
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_NORTH_CLR_CLEAR_MASK 0x0000FFFF
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_NORTH_CLR_CLEAR_DEFVAL 0x0

#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_NORTH_VALUE       0x00014078
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_NORTH_VALUE_WIDTH 32
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_NORTH_VALUE_MASK  0x0000FFFF
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_NORTH_VALUE_VALUE_LSB 0
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_NORTH_VALUE_VALUE_WIDTH 16
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_NORTH_VALUE_VALUE_MASK 0x0000FFFF
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_NORTH_VALUE_VALUE_DEFVAL 0x0

#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_EAST_SET          0x00014080
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_EAST_SET_WIDTH    32
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_EAST_SET_MASK     0x0000FFFF
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_EAST_SET_SET_LSB 0
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_EAST_SET_SET_WIDTH 16
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_EAST_SET_SET_MASK 0x0000FFFF
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_EAST_SET_SET_DEFVAL 0x0

#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_EAST_CLR          0x00014084
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_EAST_CLR_WIDTH    32
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_EAST_CLR_MASK     0x0000FFFF
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_EAST_CLR_CLEAR_LSB 0
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_EAST_CLR_CLEAR_WIDTH 16
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_EAST_CLR_CLEAR_MASK 0x0000FFFF
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_EAST_CLR_CLEAR_DEFVAL 0x0

#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_EAST_VALUE        0x00014088
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_EAST_VALUE_WIDTH  32
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_EAST_VALUE_MASK   0x0000FFFF
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_EAST_VALUE_VALUE_LSB 0
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_EAST_VALUE_VALUE_WIDTH 16
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_EAST_VALUE_VALUE_MASK 0x0000FFFF
#define XAIE2PGBL_MEMORY_MODULE_EVENT_BROADCAST_BLOCK_EAST_VALUE_VALUE_DEFVAL 0x0

#define XAIE2PGBL_MEMORY_MODULE_TRACE_CONTROL0                          0x000140D0
#define XAIE2PGBL_MEMORY_MODULE_TRACE_CONTROL0_WIDTH                    32
#define XAIE2PGBL_MEMORY_MODULE_TRACE_CONTROL0_MASK                     0x7F7F0000
#define XAIE2PGBL_MEMORY_MODULE_TRACE_CONTROL0_TRACE_STOP_EVENT_LSB   24
#define XAIE2PGBL_MEMORY_MODULE_TRACE_CONTROL0_TRACE_STOP_EVENT_WIDTH 7
#define XAIE2PGBL_MEMORY_MODULE_TRACE_CONTROL0_TRACE_STOP_EVENT_MASK  0x7F000000
#define XAIE2PGBL_MEMORY_MODULE_TRACE_CONTROL0_TRACE_STOP_EVENT_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_TRACE_CONTROL0_TRACE_START_EVENT_LSB  16
#define XAIE2PGBL_MEMORY_MODULE_TRACE_CONTROL0_TRACE_START_EVENT_WIDTH 7
#define XAIE2PGBL_MEMORY_MODULE_TRACE_CONTROL0_TRACE_START_EVENT_MASK 0x007F0000
#define XAIE2PGBL_MEMORY_MODULE_TRACE_CONTROL0_TRACE_START_EVENT_DEFVAL 0x0

#define XAIE2PGBL_MEMORY_MODULE_TRACE_CONTROL1                          0x000140D4
#define XAIE2PGBL_MEMORY_MODULE_TRACE_CONTROL1_WIDTH                    32
#define XAIE2PGBL_MEMORY_MODULE_TRACE_CONTROL1_MASK                     0x0000701F
#define XAIE2PGBL_MEMORY_MODULE_TRACE_CONTROL1_PACKET_TYPE_LSB        12
#define XAIE2PGBL_MEMORY_MODULE_TRACE_CONTROL1_PACKET_TYPE_WIDTH      3
#define XAIE2PGBL_MEMORY_MODULE_TRACE_CONTROL1_PACKET_TYPE_MASK       0x00007000
#define XAIE2PGBL_MEMORY_MODULE_TRACE_CONTROL1_PACKET_TYPE_DEFVAL     0x0
#define XAIE2PGBL_MEMORY_MODULE_TRACE_CONTROL1_ID_LSB                 0
#define XAIE2PGBL_MEMORY_MODULE_TRACE_CONTROL1_ID_WIDTH               5
#define XAIE2PGBL_MEMORY_MODULE_TRACE_CONTROL1_ID_MASK                0x0000001F
#define XAIE2PGBL_MEMORY_MODULE_TRACE_CONTROL1_ID_DEFVAL              0x0

#define XAIE2PGBL_MEMORY_MODULE_TRACE_STATUS                            0x000140D8
#define XAIE2PGBL_MEMORY_MODULE_TRACE_STATUS_WIDTH                      32
#define XAIE2PGBL_MEMORY_MODULE_TRACE_STATUS_MASK                       0x00000307
#define XAIE2PGBL_MEMORY_MODULE_TRACE_STATUS_STATE_LSB                8
#define XAIE2PGBL_MEMORY_MODULE_TRACE_STATUS_STATE_WIDTH              2
#define XAIE2PGBL_MEMORY_MODULE_TRACE_STATUS_STATE_MASK               0x00000300
#define XAIE2PGBL_MEMORY_MODULE_TRACE_STATUS_STATE_DEFVAL             0x0
#define XAIE2PGBL_MEMORY_MODULE_TRACE_STATUS_MODE_LSB                 0
#define XAIE2PGBL_MEMORY_MODULE_TRACE_STATUS_MODE_WIDTH               3
#define XAIE2PGBL_MEMORY_MODULE_TRACE_STATUS_MODE_MASK                0x00000007
#define XAIE2PGBL_MEMORY_MODULE_TRACE_STATUS_MODE_DEFVAL              0x0

#define XAIE2PGBL_MEMORY_MODULE_TRACE_EVENT0                            0x000140E0
#define XAIE2PGBL_MEMORY_MODULE_TRACE_EVENT0_WIDTH                      32
#define XAIE2PGBL_MEMORY_MODULE_TRACE_EVENT0_MASK                       0x7F7F7F7F
#define XAIE2PGBL_MEMORY_MODULE_TRACE_EVENT0_TRACE_EVENT3_LSB         24
#define XAIE2PGBL_MEMORY_MODULE_TRACE_EVENT0_TRACE_EVENT3_WIDTH       7
#define XAIE2PGBL_MEMORY_MODULE_TRACE_EVENT0_TRACE_EVENT3_MASK        0x7F000000
#define XAIE2PGBL_MEMORY_MODULE_TRACE_EVENT0_TRACE_EVENT3_DEFVAL      0x0
#define XAIE2PGBL_MEMORY_MODULE_TRACE_EVENT0_TRACE_EVENT2_LSB         16
#define XAIE2PGBL_MEMORY_MODULE_TRACE_EVENT0_TRACE_EVENT2_WIDTH       7
#define XAIE2PGBL_MEMORY_MODULE_TRACE_EVENT0_TRACE_EVENT2_MASK        0x007F0000
#define XAIE2PGBL_MEMORY_MODULE_TRACE_EVENT0_TRACE_EVENT2_DEFVAL      0x0
#define XAIE2PGBL_MEMORY_MODULE_TRACE_EVENT0_TRACE_EVENT1_LSB         8
#define XAIE2PGBL_MEMORY_MODULE_TRACE_EVENT0_TRACE_EVENT1_WIDTH       7
#define XAIE2PGBL_MEMORY_MODULE_TRACE_EVENT0_TRACE_EVENT1_MASK        0x00007F00
#define XAIE2PGBL_MEMORY_MODULE_TRACE_EVENT0_TRACE_EVENT1_DEFVAL      0x0
#define XAIE2PGBL_MEMORY_MODULE_TRACE_EVENT0_TRACE_EVENT0_LSB         0
#define XAIE2PGBL_MEMORY_MODULE_TRACE_EVENT0_TRACE_EVENT0_WIDTH       7
#define XAIE2PGBL_MEMORY_MODULE_TRACE_EVENT0_TRACE_EVENT0_MASK        0x0000007F
#define XAIE2PGBL_MEMORY_MODULE_TRACE_EVENT0_TRACE_EVENT0_DEFVAL      0x0

#define XAIE2PGBL_MEMORY_MODULE_TRACE_EVENT1                            0x000140E4
#define XAIE2PGBL_MEMORY_MODULE_TRACE_EVENT1_WIDTH                      32
#define XAIE2PGBL_MEMORY_MODULE_TRACE_EVENT1_MASK                       0x7F7F7F7F
#define XAIE2PGBL_MEMORY_MODULE_TRACE_EVENT1_TRACE_EVENT7_LSB         24
#define XAIE2PGBL_MEMORY_MODULE_TRACE_EVENT1_TRACE_EVENT7_WIDTH       7
#define XAIE2PGBL_MEMORY_MODULE_TRACE_EVENT1_TRACE_EVENT7_MASK        0x7F000000
#define XAIE2PGBL_MEMORY_MODULE_TRACE_EVENT1_TRACE_EVENT7_DEFVAL      0x0
#define XAIE2PGBL_MEMORY_MODULE_TRACE_EVENT1_TRACE_EVENT6_LSB         16
#define XAIE2PGBL_MEMORY_MODULE_TRACE_EVENT1_TRACE_EVENT6_WIDTH       7
#define XAIE2PGBL_MEMORY_MODULE_TRACE_EVENT1_TRACE_EVENT6_MASK        0x007F0000
#define XAIE2PGBL_MEMORY_MODULE_TRACE_EVENT1_TRACE_EVENT6_DEFVAL      0x0
#define XAIE2PGBL_MEMORY_MODULE_TRACE_EVENT1_TRACE_EVENT5_LSB         8
#define XAIE2PGBL_MEMORY_MODULE_TRACE_EVENT1_TRACE_EVENT5_WIDTH       7
#define XAIE2PGBL_MEMORY_MODULE_TRACE_EVENT1_TRACE_EVENT5_MASK        0x00007F00
#define XAIE2PGBL_MEMORY_MODULE_TRACE_EVENT1_TRACE_EVENT5_DEFVAL      0x0
#define XAIE2PGBL_MEMORY_MODULE_TRACE_EVENT1_TRACE_EVENT4_LSB         0
#define XAIE2PGBL_MEMORY_MODULE_TRACE_EVENT1_TRACE_EVENT4_WIDTH       7
#define XAIE2PGBL_MEMORY_MODULE_TRACE_EVENT1_TRACE_EVENT4_MASK        0x0000007F
#define XAIE2PGBL_MEMORY_MODULE_TRACE_EVENT1_TRACE_EVENT4_DEFVAL      0x0

#define XAIE2PGBL_MEMORY_MODULE_TIMER_TRIG_EVENT_LOW_VALUE              0x000140F0
#define XAIE2PGBL_MEMORY_MODULE_TIMER_TRIG_EVENT_LOW_VALUE_WIDTH        32
#define XAIE2PGBL_MEMORY_MODULE_TIMER_TRIG_EVENT_LOW_VALUE_MASK         0xFFFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_TIMER_TRIG_EVENT_LOW_VALUE_TIMERTRIGLOW_LSB 0
#define XAIE2PGBL_MEMORY_MODULE_TIMER_TRIG_EVENT_LOW_VALUE_TIMERTRIGLOW_WIDTH 32
#define XAIE2PGBL_MEMORY_MODULE_TIMER_TRIG_EVENT_LOW_VALUE_TIMERTRIGLOW_MASK 0xFFFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_TIMER_TRIG_EVENT_LOW_VALUE_TIMERTRIGLOW_DEFVAL 0xFFFFFFFF

#define XAIE2PGBL_MEMORY_MODULE_TIMER_TRIG_EVENT_HIGH_VALUE             0x000140F4
#define XAIE2PGBL_MEMORY_MODULE_TIMER_TRIG_EVENT_HIGH_VALUE_WIDTH       32
#define XAIE2PGBL_MEMORY_MODULE_TIMER_TRIG_EVENT_HIGH_VALUE_MASK        0xFFFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_TIMER_TRIG_EVENT_HIGH_VALUE_TIMERTRIGHIGH_LSB 0
#define XAIE2PGBL_MEMORY_MODULE_TIMER_TRIG_EVENT_HIGH_VALUE_TIMERTRIGHIGH_WIDTH 32
#define XAIE2PGBL_MEMORY_MODULE_TIMER_TRIG_EVENT_HIGH_VALUE_TIMERTRIGHIGH_MASK 0xFFFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_TIMER_TRIG_EVENT_HIGH_VALUE_TIMERTRIGHIGH_DEFVAL 0xFFFFFFFF

#define XAIE2PGBL_MEMORY_MODULE_TIMER_LOW                               0x000140F8
#define XAIE2PGBL_MEMORY_MODULE_TIMER_LOW_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_TIMER_LOW_MASK                          0xFFFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_TIMER_LOW_TIMERLOW_LSB                0
#define XAIE2PGBL_MEMORY_MODULE_TIMER_LOW_TIMERLOW_WIDTH              32
#define XAIE2PGBL_MEMORY_MODULE_TIMER_LOW_TIMERLOW_MASK               0xFFFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_TIMER_LOW_TIMERLOW_DEFVAL             0x0

#define XAIE2PGBL_MEMORY_MODULE_TIMER_HIGH                              0x000140FC
#define XAIE2PGBL_MEMORY_MODULE_TIMER_HIGH_WIDTH                        32
#define XAIE2PGBL_MEMORY_MODULE_TIMER_HIGH_MASK                         0xFFFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_TIMER_HIGH_TIMERHIGH_LSB              0
#define XAIE2PGBL_MEMORY_MODULE_TIMER_HIGH_TIMERHIGH_WIDTH            32
#define XAIE2PGBL_MEMORY_MODULE_TIMER_HIGH_TIMERHIGH_MASK             0xFFFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_TIMER_HIGH_TIMERHIGH_DEFVAL           0x0

#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT0                             0x00014100
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT0_WIDTH                       32
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT0_MASK                        0xFFFF07FF
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT0_READ_ACCESS_LSB           31
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT0_READ_ACCESS_WIDTH         1
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT0_READ_ACCESS_MASK          0x80000000
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT0_READ_ACCESS_DEFVAL        0x0
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT0_WRITE_ACCESS_LSB          30
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT0_WRITE_ACCESS_WIDTH        1
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT0_WRITE_ACCESS_MASK         0x40000000
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT0_WRITE_ACCESS_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT0_AXI_ACCESS_LSB            29
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT0_AXI_ACCESS_WIDTH          1
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT0_AXI_ACCESS_MASK           0x20000000
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT0_AXI_ACCESS_DEFVAL         0x0
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT0_DMA_ACCESS_LSB            28
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT0_DMA_ACCESS_WIDTH          1
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT0_DMA_ACCESS_MASK           0x10000000
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT0_DMA_ACCESS_DEFVAL         0x0
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT0_EAST_ACCESS_LSB           27
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT0_EAST_ACCESS_WIDTH         1
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT0_EAST_ACCESS_MASK          0x08000000
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT0_EAST_ACCESS_DEFVAL        0x0
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT0_NORTH_ACCESS_LSB          26
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT0_NORTH_ACCESS_WIDTH        1
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT0_NORTH_ACCESS_MASK         0x04000000
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT0_NORTH_ACCESS_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT0_WEST_ACCESS_LSB           25
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT0_WEST_ACCESS_WIDTH         1
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT0_WEST_ACCESS_MASK          0x02000000
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT0_WEST_ACCESS_DEFVAL        0x0
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT0_SOUTH_ACCESS_LSB          24
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT0_SOUTH_ACCESS_WIDTH        1
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT0_SOUTH_ACCESS_MASK         0x01000000
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT0_SOUTH_ACCESS_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT0_WRITESTROBEMASK_LSB       16
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT0_WRITESTROBEMASK_WIDTH     8
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT0_WRITESTROBEMASK_MASK      0x00FF0000
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT0_WRITESTROBEMASK_DEFVAL    0x0
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT0_ADDRESS_LSB               0
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT0_ADDRESS_WIDTH             11
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT0_ADDRESS_MASK              0x000007FF
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT0_ADDRESS_DEFVAL            0x0

#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT1                             0x00014104
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT1_WIDTH                       32
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT1_MASK                        0xFFFF07FF
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT1_READ_ACCESS_LSB           31
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT1_READ_ACCESS_WIDTH         1
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT1_READ_ACCESS_MASK          0x80000000
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT1_READ_ACCESS_DEFVAL        0x0
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT1_WRITE_ACCESS_LSB          30
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT1_WRITE_ACCESS_WIDTH        1
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT1_WRITE_ACCESS_MASK         0x40000000
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT1_WRITE_ACCESS_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT1_AXI_ACCESS_LSB            29
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT1_AXI_ACCESS_WIDTH          1
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT1_AXI_ACCESS_MASK           0x20000000
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT1_AXI_ACCESS_DEFVAL         0x0
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT1_DMA_ACCESS_LSB            28
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT1_DMA_ACCESS_WIDTH          1
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT1_DMA_ACCESS_MASK           0x10000000
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT1_DMA_ACCESS_DEFVAL         0x0
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT1_EAST_ACCESS_LSB           27
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT1_EAST_ACCESS_WIDTH         1
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT1_EAST_ACCESS_MASK          0x08000000
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT1_EAST_ACCESS_DEFVAL        0x0
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT1_NORTH_ACCESS_LSB          26
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT1_NORTH_ACCESS_WIDTH        1
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT1_NORTH_ACCESS_MASK         0x04000000
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT1_NORTH_ACCESS_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT1_WEST_ACCESS_LSB           25
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT1_WEST_ACCESS_WIDTH         1
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT1_WEST_ACCESS_MASK          0x02000000
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT1_WEST_ACCESS_DEFVAL        0x0
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT1_SOUTH_ACCESS_LSB          24
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT1_SOUTH_ACCESS_WIDTH        1
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT1_SOUTH_ACCESS_MASK         0x01000000
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT1_SOUTH_ACCESS_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT1_WRITESTROBEMASK_LSB       16
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT1_WRITESTROBEMASK_WIDTH     8
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT1_WRITESTROBEMASK_MASK      0x00FF0000
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT1_WRITESTROBEMASK_DEFVAL    0x0
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT1_ADDRESS_LSB               0
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT1_ADDRESS_WIDTH             11
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT1_ADDRESS_MASK              0x000007FF
#define XAIE2PGBL_MEMORY_MODULE_WATCHPOINT1_ADDRESS_DEFVAL            0x0

#define XAIE2PGBL_MEMORY_MODULE_EVENT_STATUS0                           0x00014200
#define XAIE2PGBL_MEMORY_MODULE_EVENT_STATUS0_WIDTH                     32
#define XAIE2PGBL_MEMORY_MODULE_EVENT_STATUS0_MASK                      0xFFFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_EVENT_STATUS0_EVENT_31_0_STATUS_LSB   0
#define XAIE2PGBL_MEMORY_MODULE_EVENT_STATUS0_EVENT_31_0_STATUS_WIDTH 32
#define XAIE2PGBL_MEMORY_MODULE_EVENT_STATUS0_EVENT_31_0_STATUS_MASK  0xFFFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_EVENT_STATUS0_EVENT_31_0_STATUS_DEFVAL 0x2

#define XAIE2PGBL_MEMORY_MODULE_EVENT_STATUS1                           0x00014204
#define XAIE2PGBL_MEMORY_MODULE_EVENT_STATUS1_WIDTH                     32
#define XAIE2PGBL_MEMORY_MODULE_EVENT_STATUS1_MASK                      0xFFFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_EVENT_STATUS1_EVENT_63_32_STATUS_LSB  0
#define XAIE2PGBL_MEMORY_MODULE_EVENT_STATUS1_EVENT_63_32_STATUS_WIDTH 32
#define XAIE2PGBL_MEMORY_MODULE_EVENT_STATUS1_EVENT_63_32_STATUS_MASK 0xFFFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_EVENT_STATUS1_EVENT_63_32_STATUS_DEFVAL 0x0

#define XAIE2PGBL_MEMORY_MODULE_EVENT_STATUS2                           0x00014208
#define XAIE2PGBL_MEMORY_MODULE_EVENT_STATUS2_WIDTH                     32
#define XAIE2PGBL_MEMORY_MODULE_EVENT_STATUS2_MASK                      0xFFFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_EVENT_STATUS2_EVENT_95_64_STATUS_LSB  0
#define XAIE2PGBL_MEMORY_MODULE_EVENT_STATUS2_EVENT_95_64_STATUS_WIDTH 32
#define XAIE2PGBL_MEMORY_MODULE_EVENT_STATUS2_EVENT_95_64_STATUS_MASK 0xFFFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_EVENT_STATUS2_EVENT_95_64_STATUS_DEFVAL 0x0

#define XAIE2PGBL_MEMORY_MODULE_EVENT_STATUS3                           0x0001420C
#define XAIE2PGBL_MEMORY_MODULE_EVENT_STATUS3_WIDTH                     32
#define XAIE2PGBL_MEMORY_MODULE_EVENT_STATUS3_MASK                      0xFFFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_EVENT_STATUS3_EVENT_127_96_STATUS_LSB 0
#define XAIE2PGBL_MEMORY_MODULE_EVENT_STATUS3_EVENT_127_96_STATUS_WIDTH 32
#define XAIE2PGBL_MEMORY_MODULE_EVENT_STATUS3_EVENT_127_96_STATUS_MASK 0xFFFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_EVENT_STATUS3_EVENT_127_96_STATUS_DEFVAL 0x0

#define XAIE2PGBL_MEMORY_MODULE_RESERVED0                               0x00014210
#define XAIE2PGBL_MEMORY_MODULE_RESERVED0_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_RESERVED0_MASK                          0xFFFFFFFF

#define XAIE2PGBL_MEMORY_MODULE_RESERVED1                               0x00014214
#define XAIE2PGBL_MEMORY_MODULE_RESERVED1_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_RESERVED1_MASK                          0xFFFFFFFF

#define XAIE2PGBL_MEMORY_MODULE_RESERVED2                               0x00014218
#define XAIE2PGBL_MEMORY_MODULE_RESERVED2_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_RESERVED2_MASK                          0xFFFFFFFF

#define XAIE2PGBL_MEMORY_MODULE_RESERVED3                               0x0001421C
#define XAIE2PGBL_MEMORY_MODULE_RESERVED3_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_RESERVED3_MASK                          0xFFFFFFFF

#define XAIE2PGBL_MEMORY_MODULE_COMBO_EVENT_INPUTS                      0x00014400
#define XAIE2PGBL_MEMORY_MODULE_COMBO_EVENT_INPUTS_WIDTH                32
#define XAIE2PGBL_MEMORY_MODULE_COMBO_EVENT_INPUTS_MASK                 0x7F7F7F7F
#define XAIE2PGBL_MEMORY_MODULE_COMBO_EVENT_INPUTS_EVENTD_LSB         24
#define XAIE2PGBL_MEMORY_MODULE_COMBO_EVENT_INPUTS_EVENTD_WIDTH       7
#define XAIE2PGBL_MEMORY_MODULE_COMBO_EVENT_INPUTS_EVENTD_MASK        0x7F000000
#define XAIE2PGBL_MEMORY_MODULE_COMBO_EVENT_INPUTS_EVENTD_DEFVAL      0x0
#define XAIE2PGBL_MEMORY_MODULE_COMBO_EVENT_INPUTS_EVENTC_LSB         16
#define XAIE2PGBL_MEMORY_MODULE_COMBO_EVENT_INPUTS_EVENTC_WIDTH       7
#define XAIE2PGBL_MEMORY_MODULE_COMBO_EVENT_INPUTS_EVENTC_MASK        0x007F0000
#define XAIE2PGBL_MEMORY_MODULE_COMBO_EVENT_INPUTS_EVENTC_DEFVAL      0x0
#define XAIE2PGBL_MEMORY_MODULE_COMBO_EVENT_INPUTS_EVENTB_LSB         8
#define XAIE2PGBL_MEMORY_MODULE_COMBO_EVENT_INPUTS_EVENTB_WIDTH       7
#define XAIE2PGBL_MEMORY_MODULE_COMBO_EVENT_INPUTS_EVENTB_MASK        0x00007F00
#define XAIE2PGBL_MEMORY_MODULE_COMBO_EVENT_INPUTS_EVENTB_DEFVAL      0x0
#define XAIE2PGBL_MEMORY_MODULE_COMBO_EVENT_INPUTS_EVENTA_LSB         0
#define XAIE2PGBL_MEMORY_MODULE_COMBO_EVENT_INPUTS_EVENTA_WIDTH       7
#define XAIE2PGBL_MEMORY_MODULE_COMBO_EVENT_INPUTS_EVENTA_MASK        0x0000007F
#define XAIE2PGBL_MEMORY_MODULE_COMBO_EVENT_INPUTS_EVENTA_DEFVAL      0x0

#define XAIE2PGBL_MEMORY_MODULE_COMBO_EVENT_CONTROL                     0x00014404
#define XAIE2PGBL_MEMORY_MODULE_COMBO_EVENT_CONTROL_WIDTH               32
#define XAIE2PGBL_MEMORY_MODULE_COMBO_EVENT_CONTROL_MASK                0x00030303
#define XAIE2PGBL_MEMORY_MODULE_COMBO_EVENT_CONTROL_COMBO2_LSB        16
#define XAIE2PGBL_MEMORY_MODULE_COMBO_EVENT_CONTROL_COMBO2_WIDTH      2
#define XAIE2PGBL_MEMORY_MODULE_COMBO_EVENT_CONTROL_COMBO2_MASK       0x00030000
#define XAIE2PGBL_MEMORY_MODULE_COMBO_EVENT_CONTROL_COMBO2_DEFVAL     0x0
#define XAIE2PGBL_MEMORY_MODULE_COMBO_EVENT_CONTROL_COMBO1_LSB        8
#define XAIE2PGBL_MEMORY_MODULE_COMBO_EVENT_CONTROL_COMBO1_WIDTH      2
#define XAIE2PGBL_MEMORY_MODULE_COMBO_EVENT_CONTROL_COMBO1_MASK       0x00000300
#define XAIE2PGBL_MEMORY_MODULE_COMBO_EVENT_CONTROL_COMBO1_DEFVAL     0x0
#define XAIE2PGBL_MEMORY_MODULE_COMBO_EVENT_CONTROL_COMBO0_LSB        0
#define XAIE2PGBL_MEMORY_MODULE_COMBO_EVENT_CONTROL_COMBO0_WIDTH      2
#define XAIE2PGBL_MEMORY_MODULE_COMBO_EVENT_CONTROL_COMBO0_MASK       0x00000003
#define XAIE2PGBL_MEMORY_MODULE_COMBO_EVENT_CONTROL_COMBO0_DEFVAL     0x0

#define XAIE2PGBL_MEMORY_MODULE_EDGE_DETECTION_EVENT_CONTROL            0x00014408
#define XAIE2PGBL_MEMORY_MODULE_EDGE_DETECTION_EVENT_CONTROL_WIDTH      32
#define XAIE2PGBL_MEMORY_MODULE_EDGE_DETECTION_EVENT_CONTROL_MASK       0x067F067F
#define XAIE2PGBL_MEMORY_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_1_TRIGGER_FALLING_LSB 26
#define XAIE2PGBL_MEMORY_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_1_TRIGGER_FALLING_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_1_TRIGGER_FALLING_MASK 0x04000000
#define XAIE2PGBL_MEMORY_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_1_TRIGGER_FALLING_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_1_TRIGGER_RISING_LSB 25
#define XAIE2PGBL_MEMORY_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_1_TRIGGER_RISING_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_1_TRIGGER_RISING_MASK 0x02000000
#define XAIE2PGBL_MEMORY_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_1_TRIGGER_RISING_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_EVENT_1_LSB 16
#define XAIE2PGBL_MEMORY_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_EVENT_1_WIDTH 7
#define XAIE2PGBL_MEMORY_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_EVENT_1_MASK 0x007F0000
#define XAIE2PGBL_MEMORY_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_EVENT_1_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_0_TRIGGER_FALLING_LSB 10
#define XAIE2PGBL_MEMORY_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_0_TRIGGER_FALLING_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_0_TRIGGER_FALLING_MASK 0x00000400
#define XAIE2PGBL_MEMORY_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_0_TRIGGER_FALLING_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_0_TRIGGER_RISING_LSB 9
#define XAIE2PGBL_MEMORY_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_0_TRIGGER_RISING_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_0_TRIGGER_RISING_MASK 0x00000200
#define XAIE2PGBL_MEMORY_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_0_TRIGGER_RISING_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_EVENT_0_LSB 0
#define XAIE2PGBL_MEMORY_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_EVENT_0_WIDTH 7
#define XAIE2PGBL_MEMORY_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_EVENT_0_MASK 0x0000007F
#define XAIE2PGBL_MEMORY_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_EVENT_0_DEFVAL 0x0

#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_0_ENABLE                    0x00014500
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_0_ENABLE_WIDTH              32
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_0_ENABLE_MASK               0x000003FF
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_0_ENABLE_EDGE_DETECTION_EVENT_1_LSB 9
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_0_ENABLE_EDGE_DETECTION_EVENT_1_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_0_ENABLE_EDGE_DETECTION_EVENT_1_MASK 0x00000200
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_0_ENABLE_EDGE_DETECTION_EVENT_1_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_0_ENABLE_EDGE_DETECTION_EVENT_0_LSB 8
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_0_ENABLE_EDGE_DETECTION_EVENT_0_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_0_ENABLE_EDGE_DETECTION_EVENT_0_MASK 0x00000100
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_0_ENABLE_EDGE_DETECTION_EVENT_0_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_0_ENABLE_COMBO_EVENT_3_LSB 7
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_0_ENABLE_COMBO_EVENT_3_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_0_ENABLE_COMBO_EVENT_3_MASK 0x00000080
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_0_ENABLE_COMBO_EVENT_3_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_0_ENABLE_COMBO_EVENT_2_LSB 6
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_0_ENABLE_COMBO_EVENT_2_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_0_ENABLE_COMBO_EVENT_2_MASK 0x00000040
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_0_ENABLE_COMBO_EVENT_2_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_0_ENABLE_COMBO_EVENT_1_LSB 5
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_0_ENABLE_COMBO_EVENT_1_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_0_ENABLE_COMBO_EVENT_1_MASK 0x00000020
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_0_ENABLE_COMBO_EVENT_1_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_0_ENABLE_COMBO_EVENT_0_LSB 4
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_0_ENABLE_COMBO_EVENT_0_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_0_ENABLE_COMBO_EVENT_0_MASK 0x00000010
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_0_ENABLE_COMBO_EVENT_0_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_0_ENABLE_PERF_CNT1_EVENT_LSB 3
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_0_ENABLE_PERF_CNT1_EVENT_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_0_ENABLE_PERF_CNT1_EVENT_MASK 0x00000008
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_0_ENABLE_PERF_CNT1_EVENT_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_0_ENABLE_PERF_CNT0_EVENT_LSB 2
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_0_ENABLE_PERF_CNT0_EVENT_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_0_ENABLE_PERF_CNT0_EVENT_MASK 0x00000004
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_0_ENABLE_PERF_CNT0_EVENT_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_0_ENABLE_TIMER_VALUE_REACHED_LSB 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_0_ENABLE_TIMER_VALUE_REACHED_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_0_ENABLE_TIMER_VALUE_REACHED_MASK 0x00000002
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_0_ENABLE_TIMER_VALUE_REACHED_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_0_ENABLE_TIMER_SYNC_LSB   0
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_0_ENABLE_TIMER_SYNC_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_0_ENABLE_TIMER_SYNC_MASK  0x00000001
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_0_ENABLE_TIMER_SYNC_DEFVAL 0x1

#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_WATCHPOINT_ENABLE           0x00014504
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_WATCHPOINT_ENABLE_WIDTH     32
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_WATCHPOINT_ENABLE_MASK      0x00000003
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_WATCHPOINT_ENABLE_WATCHPOINT_1_LSB 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_WATCHPOINT_ENABLE_WATCHPOINT_1_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_WATCHPOINT_ENABLE_WATCHPOINT_1_MASK 0x00000002
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_WATCHPOINT_ENABLE_WATCHPOINT_1_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_WATCHPOINT_ENABLE_WATCHPOINT_0_LSB 0
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_WATCHPOINT_ENABLE_WATCHPOINT_0_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_WATCHPOINT_ENABLE_WATCHPOINT_0_MASK 0x00000001
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_WATCHPOINT_ENABLE_WATCHPOINT_0_DEFVAL 0x1

#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE                  0x00014508
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_WIDTH            32
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_MASK             0x00FFFFFF
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_MM2S_1_MEMORY_STARVATION_LSB 23
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_MM2S_1_MEMORY_STARVATION_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_MM2S_1_MEMORY_STARVATION_MASK 0x00800000
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_MM2S_1_MEMORY_STARVATION_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_MM2S_0_MEMORY_STARVATION_LSB 22
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_MM2S_0_MEMORY_STARVATION_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_MM2S_0_MEMORY_STARVATION_MASK 0x00400000
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_MM2S_0_MEMORY_STARVATION_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_MM2S_1_STREAM_BACKPRESSURE_LSB 21
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_MM2S_1_STREAM_BACKPRESSURE_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_MM2S_1_STREAM_BACKPRESSURE_MASK 0x00200000
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_MM2S_1_STREAM_BACKPRESSURE_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_MM2S_0_STREAM_BACKPRESSURE_LSB 20
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_MM2S_0_STREAM_BACKPRESSURE_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_MM2S_0_STREAM_BACKPRESSURE_MASK 0x00100000
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_MM2S_0_STREAM_BACKPRESSURE_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_S2MM_1_MEMORY_BACKPRESSURE_LSB 19
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_S2MM_1_MEMORY_BACKPRESSURE_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_S2MM_1_MEMORY_BACKPRESSURE_MASK 0x00080000
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_S2MM_1_MEMORY_BACKPRESSURE_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_S2MM_0_MEMORY_BACKPRESSURE_LSB 18
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_S2MM_0_MEMORY_BACKPRESSURE_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_S2MM_0_MEMORY_BACKPRESSURE_MASK 0x00040000
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_S2MM_0_MEMORY_BACKPRESSURE_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_S2MM_1_STREAM_STARVATION_LSB 17
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_S2MM_1_STREAM_STARVATION_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_S2MM_1_STREAM_STARVATION_MASK 0x00020000
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_S2MM_1_STREAM_STARVATION_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_S2MM_0_STREAM_STARVATION_LSB 16
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_S2MM_0_STREAM_STARVATION_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_S2MM_0_STREAM_STARVATION_MASK 0x00010000
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_S2MM_0_STREAM_STARVATION_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_MM2S_1_STALLED_LOCK_ACQUIRE_LSB 15
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_MM2S_1_STALLED_LOCK_ACQUIRE_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_MM2S_1_STALLED_LOCK_ACQUIRE_MASK 0x00008000
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_MM2S_1_STALLED_LOCK_ACQUIRE_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_MM2S_0_STALLED_LOCK_ACQUIRE_LSB 14
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_MM2S_0_STALLED_LOCK_ACQUIRE_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_MM2S_0_STALLED_LOCK_ACQUIRE_MASK 0x00004000
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_MM2S_0_STALLED_LOCK_ACQUIRE_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_S2MM_1_STALLED_LOCK_ACQUIRE_LSB 13
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_S2MM_1_STALLED_LOCK_ACQUIRE_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_S2MM_1_STALLED_LOCK_ACQUIRE_MASK 0x00002000
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_S2MM_1_STALLED_LOCK_ACQUIRE_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_S2MM_0_STALLED_LOCK_ACQUIRE_LSB 12
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_S2MM_0_STALLED_LOCK_ACQUIRE_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_S2MM_0_STALLED_LOCK_ACQUIRE_MASK 0x00001000
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_S2MM_0_STALLED_LOCK_ACQUIRE_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_MM2S_1_FINISHED_TASK_LSB 11
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_MM2S_1_FINISHED_TASK_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_MM2S_1_FINISHED_TASK_MASK 0x00000800
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_MM2S_1_FINISHED_TASK_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_MM2S_0_FINISHED_TASK_LSB 10
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_MM2S_0_FINISHED_TASK_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_MM2S_0_FINISHED_TASK_MASK 0x00000400
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_MM2S_0_FINISHED_TASK_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_S2MM_1_FINISHED_TASK_LSB 9
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_S2MM_1_FINISHED_TASK_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_S2MM_1_FINISHED_TASK_MASK 0x00000200
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_S2MM_1_FINISHED_TASK_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_S2MM_0_FINISHED_TASK_LSB 8
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_S2MM_0_FINISHED_TASK_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_S2MM_0_FINISHED_TASK_MASK 0x00000100
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_S2MM_0_FINISHED_TASK_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_MM2S_1_FINISHED_BD_LSB 7
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_MM2S_1_FINISHED_BD_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_MM2S_1_FINISHED_BD_MASK 0x00000080
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_MM2S_1_FINISHED_BD_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_MM2S_0_FINISHED_BD_LSB 6
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_MM2S_0_FINISHED_BD_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_MM2S_0_FINISHED_BD_MASK 0x00000040
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_MM2S_0_FINISHED_BD_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_S2MM_1_FINISHED_BD_LSB 5
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_S2MM_1_FINISHED_BD_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_S2MM_1_FINISHED_BD_MASK 0x00000020
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_S2MM_1_FINISHED_BD_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_S2MM_0_FINISHED_BD_LSB 4
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_S2MM_0_FINISHED_BD_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_S2MM_0_FINISHED_BD_MASK 0x00000010
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_S2MM_0_FINISHED_BD_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_MM2S_1_START_TASK_LSB 3
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_MM2S_1_START_TASK_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_MM2S_1_START_TASK_MASK 0x00000008
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_MM2S_1_START_TASK_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_MM2S_0_START_TASK_LSB 2
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_MM2S_0_START_TASK_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_MM2S_0_START_TASK_MASK 0x00000004
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_MM2S_0_START_TASK_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_S2MM_1_START_TASK_LSB 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_S2MM_1_START_TASK_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_S2MM_1_START_TASK_MASK 0x00000002
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_S2MM_1_START_TASK_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_S2MM_0_START_TASK_LSB 0
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_S2MM_0_START_TASK_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_S2MM_0_START_TASK_MASK 0x00000001
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_DMA_ENABLE_DMA_S2MM_0_START_TASK_DEFVAL 0x1

#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE                 0x0001450C
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_WIDTH           32
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_MASK            0xFFFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL7_EQUAL_TO_VALUE_LSB 31
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL7_EQUAL_TO_VALUE_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL7_EQUAL_TO_VALUE_MASK 0x80000000
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL7_EQUAL_TO_VALUE_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL7_REL_LSB 30
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL7_REL_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL7_REL_MASK 0x40000000
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL7_REL_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL7_ACQ_GE_LSB 29
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL7_ACQ_GE_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL7_ACQ_GE_MASK 0x20000000
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL7_ACQ_GE_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL7_ACQ_EQ_LSB 28
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL7_ACQ_EQ_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL7_ACQ_EQ_MASK 0x10000000
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL7_ACQ_EQ_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL6_EQUAL_TO_VALUE_LSB 27
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL6_EQUAL_TO_VALUE_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL6_EQUAL_TO_VALUE_MASK 0x08000000
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL6_EQUAL_TO_VALUE_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL6_REL_LSB 26
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL6_REL_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL6_REL_MASK 0x04000000
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL6_REL_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL6_ACQ_GE_LSB 25
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL6_ACQ_GE_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL6_ACQ_GE_MASK 0x02000000
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL6_ACQ_GE_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL6_ACQ_EQ_LSB 24
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL6_ACQ_EQ_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL6_ACQ_EQ_MASK 0x01000000
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL6_ACQ_EQ_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL5_EQUAL_TO_VALUE_LSB 23
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL5_EQUAL_TO_VALUE_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL5_EQUAL_TO_VALUE_MASK 0x00800000
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL5_EQUAL_TO_VALUE_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL5_REL_LSB 22
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL5_REL_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL5_REL_MASK 0x00400000
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL5_REL_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL5_ACQ_GE_LSB 21
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL5_ACQ_GE_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL5_ACQ_GE_MASK 0x00200000
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL5_ACQ_GE_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL5_ACQ_EQ_LSB 20
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL5_ACQ_EQ_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL5_ACQ_EQ_MASK 0x00100000
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL5_ACQ_EQ_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL4_EQUAL_TO_VALUE_LSB 19
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL4_EQUAL_TO_VALUE_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL4_EQUAL_TO_VALUE_MASK 0x00080000
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL4_EQUAL_TO_VALUE_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL4_REL_LSB 18
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL4_REL_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL4_REL_MASK 0x00040000
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL4_REL_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL4_ACQ_GE_LSB 17
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL4_ACQ_GE_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL4_ACQ_GE_MASK 0x00020000
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL4_ACQ_GE_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL4_ACQ_EQ_LSB 16
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL4_ACQ_EQ_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL4_ACQ_EQ_MASK 0x00010000
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL4_ACQ_EQ_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL3_EQUAL_TO_VALUE_LSB 15
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL3_EQUAL_TO_VALUE_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL3_EQUAL_TO_VALUE_MASK 0x00008000
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL3_EQUAL_TO_VALUE_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL3_REL_LSB 14
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL3_REL_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL3_REL_MASK 0x00004000
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL3_REL_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL3_ACQ_GE_LSB 13
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL3_ACQ_GE_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL3_ACQ_GE_MASK 0x00002000
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL3_ACQ_GE_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL3_ACQ_EQ_LSB 12
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL3_ACQ_EQ_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL3_ACQ_EQ_MASK 0x00001000
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL3_ACQ_EQ_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL2_EQUAL_TO_VALUE_LSB 11
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL2_EQUAL_TO_VALUE_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL2_EQUAL_TO_VALUE_MASK 0x00000800
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL2_EQUAL_TO_VALUE_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL2_REL_LSB 10
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL2_REL_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL2_REL_MASK 0x00000400
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL2_REL_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL2_ACQ_GE_LSB 9
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL2_ACQ_GE_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL2_ACQ_GE_MASK 0x00000200
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL2_ACQ_GE_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL2_ACQ_EQ_LSB 8
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL2_ACQ_EQ_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL2_ACQ_EQ_MASK 0x00000100
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL2_ACQ_EQ_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL1_EQUAL_TO_VALUE_LSB 7
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL1_EQUAL_TO_VALUE_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL1_EQUAL_TO_VALUE_MASK 0x00000080
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL1_EQUAL_TO_VALUE_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL1_REL_LSB 6
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL1_REL_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL1_REL_MASK 0x00000040
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL1_REL_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL1_ACQ_GE_LSB 5
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL1_ACQ_GE_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL1_ACQ_GE_MASK 0x00000020
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL1_ACQ_GE_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL1_ACQ_EQ_LSB 4
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL1_ACQ_EQ_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL1_ACQ_EQ_MASK 0x00000010
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL1_ACQ_EQ_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL0_EQUAL_TO_VALUE_LSB 3
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL0_EQUAL_TO_VALUE_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL0_EQUAL_TO_VALUE_MASK 0x00000008
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL0_EQUAL_TO_VALUE_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL0_REL_LSB 2
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL0_REL_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL0_REL_MASK 0x00000004
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL0_REL_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL0_ACQ_GE_LSB 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL0_ACQ_GE_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL0_ACQ_GE_MASK 0x00000002
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL0_ACQ_GE_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL0_ACQ_EQ_LSB 0
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL0_ACQ_EQ_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL0_ACQ_EQ_MASK 0x00000001
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL0_ACQ_EQ_DEFVAL 0x1

#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_MEMORY_CONFLICT_ENABLE      0x00014510
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_MEMORY_CONFLICT_ENABLE_WIDTH 32
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_MEMORY_CONFLICT_ENABLE_MASK 0x000000FF
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_MEMORY_CONFLICT_ENABLE_CONFLICT_DM_BANK_7_LSB 7
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_MEMORY_CONFLICT_ENABLE_CONFLICT_DM_BANK_7_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_MEMORY_CONFLICT_ENABLE_CONFLICT_DM_BANK_7_MASK 0x00000080
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_MEMORY_CONFLICT_ENABLE_CONFLICT_DM_BANK_7_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_MEMORY_CONFLICT_ENABLE_CONFLICT_DM_BANK_6_LSB 6
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_MEMORY_CONFLICT_ENABLE_CONFLICT_DM_BANK_6_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_MEMORY_CONFLICT_ENABLE_CONFLICT_DM_BANK_6_MASK 0x00000040
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_MEMORY_CONFLICT_ENABLE_CONFLICT_DM_BANK_6_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_MEMORY_CONFLICT_ENABLE_CONFLICT_DM_BANK_5_LSB 5
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_MEMORY_CONFLICT_ENABLE_CONFLICT_DM_BANK_5_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_MEMORY_CONFLICT_ENABLE_CONFLICT_DM_BANK_5_MASK 0x00000020
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_MEMORY_CONFLICT_ENABLE_CONFLICT_DM_BANK_5_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_MEMORY_CONFLICT_ENABLE_CONFLICT_DM_BANK_4_LSB 4
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_MEMORY_CONFLICT_ENABLE_CONFLICT_DM_BANK_4_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_MEMORY_CONFLICT_ENABLE_CONFLICT_DM_BANK_4_MASK 0x00000010
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_MEMORY_CONFLICT_ENABLE_CONFLICT_DM_BANK_4_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_MEMORY_CONFLICT_ENABLE_CONFLICT_DM_BANK_3_LSB 3
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_MEMORY_CONFLICT_ENABLE_CONFLICT_DM_BANK_3_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_MEMORY_CONFLICT_ENABLE_CONFLICT_DM_BANK_3_MASK 0x00000008
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_MEMORY_CONFLICT_ENABLE_CONFLICT_DM_BANK_3_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_MEMORY_CONFLICT_ENABLE_CONFLICT_DM_BANK_2_LSB 2
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_MEMORY_CONFLICT_ENABLE_CONFLICT_DM_BANK_2_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_MEMORY_CONFLICT_ENABLE_CONFLICT_DM_BANK_2_MASK 0x00000004
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_MEMORY_CONFLICT_ENABLE_CONFLICT_DM_BANK_2_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_MEMORY_CONFLICT_ENABLE_CONFLICT_DM_BANK_1_LSB 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_MEMORY_CONFLICT_ENABLE_CONFLICT_DM_BANK_1_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_MEMORY_CONFLICT_ENABLE_CONFLICT_DM_BANK_1_MASK 0x00000002
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_MEMORY_CONFLICT_ENABLE_CONFLICT_DM_BANK_1_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_MEMORY_CONFLICT_ENABLE_CONFLICT_DM_BANK_0_LSB 0
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_MEMORY_CONFLICT_ENABLE_CONFLICT_DM_BANK_0_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_MEMORY_CONFLICT_ENABLE_CONFLICT_DM_BANK_0_MASK 0x00000001
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_MEMORY_CONFLICT_ENABLE_CONFLICT_DM_BANK_0_DEFVAL 0x1

#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE                0x00014514
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_WIDTH          32
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_MASK           0x0000FFFF
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DMA_TASK_TOKEN_STALL_LSB 15
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DMA_TASK_TOKEN_STALL_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DMA_TASK_TOKEN_STALL_MASK 0x00008000
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DMA_TASK_TOKEN_STALL_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_LOCK_ERROR_LSB 14
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_LOCK_ERROR_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_LOCK_ERROR_MASK 0x00004000
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_LOCK_ERROR_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DMA_MM2S_1_ERROR_LSB 13
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DMA_MM2S_1_ERROR_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DMA_MM2S_1_ERROR_MASK 0x00002000
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DMA_MM2S_1_ERROR_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DMA_MM2S_0_ERROR_LSB 12
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DMA_MM2S_0_ERROR_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DMA_MM2S_0_ERROR_MASK 0x00001000
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DMA_MM2S_0_ERROR_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DMA_S2MM_1_ERROR_LSB 11
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DMA_S2MM_1_ERROR_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DMA_S2MM_1_ERROR_MASK 0x00000800
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DMA_S2MM_1_ERROR_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DMA_S2MM_0_ERROR_LSB 10
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DMA_S2MM_0_ERROR_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DMA_S2MM_0_ERROR_MASK 0x00000400
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DMA_S2MM_0_ERROR_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DM_PARITY_ERROR_BANK_7_LSB 9
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DM_PARITY_ERROR_BANK_7_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DM_PARITY_ERROR_BANK_7_MASK 0x00000200
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DM_PARITY_ERROR_BANK_7_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DM_PARITY_ERROR_BANK_6_LSB 8
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DM_PARITY_ERROR_BANK_6_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DM_PARITY_ERROR_BANK_6_MASK 0x00000100
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DM_PARITY_ERROR_BANK_6_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DM_PARITY_ERROR_BANK_5_LSB 7
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DM_PARITY_ERROR_BANK_5_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DM_PARITY_ERROR_BANK_5_MASK 0x00000080
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DM_PARITY_ERROR_BANK_5_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DM_PARITY_ERROR_BANK_4_LSB 6
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DM_PARITY_ERROR_BANK_4_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DM_PARITY_ERROR_BANK_4_MASK 0x00000040
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DM_PARITY_ERROR_BANK_4_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DM_PARITY_ERROR_BANK_3_LSB 5
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DM_PARITY_ERROR_BANK_3_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DM_PARITY_ERROR_BANK_3_MASK 0x00000020
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DM_PARITY_ERROR_BANK_3_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DM_PARITY_ERROR_BANK_2_LSB 4
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DM_PARITY_ERROR_BANK_2_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DM_PARITY_ERROR_BANK_2_MASK 0x00000010
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DM_PARITY_ERROR_BANK_2_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DM_ECC_ERROR_2BIT_LSB 3
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DM_ECC_ERROR_2BIT_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DM_ECC_ERROR_2BIT_MASK 0x00000008
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DM_ECC_ERROR_2BIT_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DM_ECC_ERROR_1BIT_LSB 2
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DM_ECC_ERROR_1BIT_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DM_ECC_ERROR_1BIT_MASK 0x00000004
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DM_ECC_ERROR_1BIT_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DM_ECC_ERROR_SCRUB_2BIT_LSB 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DM_ECC_ERROR_SCRUB_2BIT_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DM_ECC_ERROR_SCRUB_2BIT_MASK 0x00000002
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DM_ECC_ERROR_SCRUB_2BIT_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DM_ECC_ERROR_SCRUB_CORRECTED_LSB 0
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DM_ECC_ERROR_SCRUB_CORRECTED_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DM_ECC_ERROR_SCRUB_CORRECTED_MASK 0x00000001
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_ERROR_ENABLE_DM_ECC_ERROR_SCRUB_CORRECTED_DEFVAL 0x1

#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE            0x00014518
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_WIDTH      32
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_MASK       0x0000FFFF
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_15_LSB 15
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_15_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_15_MASK 0x00008000
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_15_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_14_LSB 14
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_14_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_14_MASK 0x00004000
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_14_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_13_LSB 13
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_13_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_13_MASK 0x00002000
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_13_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_12_LSB 12
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_12_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_12_MASK 0x00001000
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_12_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_11_LSB 11
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_11_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_11_MASK 0x00000800
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_11_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_10_LSB 10
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_10_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_10_MASK 0x00000400
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_10_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_9_LSB 9
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_9_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_9_MASK 0x00000200
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_9_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_8_LSB 8
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_8_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_8_MASK 0x00000100
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_8_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_7_LSB 7
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_7_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_7_MASK 0x00000080
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_7_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_6_LSB 6
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_6_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_6_MASK 0x00000040
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_6_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_5_LSB 5
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_5_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_5_MASK 0x00000020
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_5_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_4_LSB 4
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_4_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_4_MASK 0x00000010
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_4_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_3_LSB 3
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_3_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_3_MASK 0x00000008
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_3_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_2_LSB 2
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_2_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_2_MASK 0x00000004
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_2_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_1_LSB 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_1_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_1_MASK 0x00000002
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_1_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_0_LSB 0
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_0_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_0_MASK 0x00000001
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_BROADCAST_ENABLE_BROADCAST_0_DEFVAL 0x1

#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_USER_EVENT_ENABLE           0x0001451C
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_USER_EVENT_ENABLE_WIDTH     32
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_USER_EVENT_ENABLE_MASK      0x0000000F
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_USER_EVENT_ENABLE_USER_EVENT_3_LSB 3
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_USER_EVENT_ENABLE_USER_EVENT_3_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_USER_EVENT_ENABLE_USER_EVENT_3_MASK 0x00000008
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_USER_EVENT_ENABLE_USER_EVENT_3_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_USER_EVENT_ENABLE_USER_EVENT_2_LSB 2
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_USER_EVENT_ENABLE_USER_EVENT_2_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_USER_EVENT_ENABLE_USER_EVENT_2_MASK 0x00000004
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_USER_EVENT_ENABLE_USER_EVENT_2_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_USER_EVENT_ENABLE_USER_EVENT_1_LSB 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_USER_EVENT_ENABLE_USER_EVENT_1_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_USER_EVENT_ENABLE_USER_EVENT_1_MASK 0x00000002
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_USER_EVENT_ENABLE_USER_EVENT_1_DEFVAL 0x1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_USER_EVENT_ENABLE_USER_EVENT_0_LSB 0
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_USER_EVENT_ENABLE_USER_EVENT_0_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_USER_EVENT_ENABLE_USER_EVENT_0_MASK 0x00000001
#define XAIE2PGBL_MEMORY_MODULE_EVENT_GROUP_USER_EVENT_ENABLE_USER_EVENT_0_DEFVAL 0x1

#define XAIE2PGBL_MEMORY_MODULE_SPARE_REG                               0x00016000
#define XAIE2PGBL_MEMORY_MODULE_SPARE_REG_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_SPARE_REG_MASK                          0x0000FFFF
#define XAIE2PGBL_MEMORY_MODULE_SPARE_REG_SPARE_REG_LSB               0
#define XAIE2PGBL_MEMORY_MODULE_SPARE_REG_SPARE_REG_WIDTH             16
#define XAIE2PGBL_MEMORY_MODULE_SPARE_REG_SPARE_REG_MASK              0x0000FFFF
#define XAIE2PGBL_MEMORY_MODULE_SPARE_REG_SPARE_REG_DEFVAL            0x0

#define XAIE2PGBL_MEMORY_MODULE_MEMORY_CONTROL                          0x00016010
#define XAIE2PGBL_MEMORY_MODULE_MEMORY_CONTROL_WIDTH                    32
#define XAIE2PGBL_MEMORY_MODULE_MEMORY_CONTROL_MASK                     0x00000001
#define XAIE2PGBL_MEMORY_MODULE_MEMORY_CONTROL_MEMORY_ZEROISATION_LSB 0
#define XAIE2PGBL_MEMORY_MODULE_MEMORY_CONTROL_MEMORY_ZEROISATION_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_MEMORY_CONTROL_MEMORY_ZEROISATION_MASK 0x00000001
#define XAIE2PGBL_MEMORY_MODULE_MEMORY_CONTROL_MEMORY_ZEROISATION_DEFVAL 0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_0                               0x0001D000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_0_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_0_MASK                          0x0FFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_0_BASE_ADDRESS_LSB            14
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_0_BASE_ADDRESS_WIDTH          14
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_0_BASE_ADDRESS_MASK           0x0FFFC000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_0_BASE_ADDRESS_DEFVAL         0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_0_BUFFER_LENGTH_LSB           0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_0_BUFFER_LENGTH_WIDTH         14
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_0_BUFFER_LENGTH_MASK          0x00003FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_0_BUFFER_LENGTH_DEFVAL        0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_1                               0x0001D004
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_1_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_1_MASK                          0xFFFF0000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_1_ENABLE_COMPRESSION_LSB      31
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_1_ENABLE_COMPRESSION_WIDTH    1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_1_ENABLE_COMPRESSION_MASK     0x80000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_1_ENABLE_COMPRESSION_DEFVAL   0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_1_ENABLE_PACKET_LSB           30
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_1_ENABLE_PACKET_WIDTH         1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_1_ENABLE_PACKET_MASK          0x40000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_1_ENABLE_PACKET_DEFVAL        0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_1_OUT_OF_ORDER_BD_ID_LSB      24
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_1_OUT_OF_ORDER_BD_ID_WIDTH    6
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_1_OUT_OF_ORDER_BD_ID_MASK     0x3F000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_1_OUT_OF_ORDER_BD_ID_DEFVAL   0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_1_PACKET_ID_LSB               19
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_1_PACKET_ID_WIDTH             5
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_1_PACKET_ID_MASK              0x00F80000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_1_PACKET_ID_DEFVAL            0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_1_PACKET_TYPE_LSB             16
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_1_PACKET_TYPE_WIDTH           3
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_1_PACKET_TYPE_MASK            0x00070000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_1_PACKET_TYPE_DEFVAL          0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_2                               0x0001D008
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_2_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_2_MASK                          0x03FFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_2_D1_STEPSIZE_LSB             13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_2_D1_STEPSIZE_WIDTH           13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_2_D1_STEPSIZE_MASK            0x03FFE000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_2_D1_STEPSIZE_DEFVAL          0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_2_D0_STEPSIZE_LSB             0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_2_D0_STEPSIZE_WIDTH           13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_2_D0_STEPSIZE_MASK            0x00001FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_2_D0_STEPSIZE_DEFVAL          0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_3                               0x0001D00C
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_3_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_3_MASK                          0x1FFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_3_D1_WRAP_LSB                 21
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_3_D1_WRAP_WIDTH               8
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_3_D1_WRAP_MASK                0x1FE00000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_3_D1_WRAP_DEFVAL              0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_3_D0_WRAP_LSB                 13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_3_D0_WRAP_WIDTH               8
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_3_D0_WRAP_MASK                0x001FE000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_3_D0_WRAP_DEFVAL              0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_3_D2_STEPSIZE_LSB             0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_3_D2_STEPSIZE_WIDTH           13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_3_D2_STEPSIZE_MASK            0x00001FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_3_D2_STEPSIZE_DEFVAL          0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_4                               0x0001D010
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_4_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_4_MASK                          0x01FFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_4_ITERATION_CURRENT_LSB       19
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_4_ITERATION_CURRENT_WIDTH     6
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_4_ITERATION_CURRENT_MASK      0x01F80000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_4_ITERATION_CURRENT_DEFVAL    0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_4_ITERATION_WRAP_LSB          13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_4_ITERATION_WRAP_WIDTH        6
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_4_ITERATION_WRAP_MASK         0x0007E000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_4_ITERATION_WRAP_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_4_ITERATION_STEPSIZE_LSB      0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_4_ITERATION_STEPSIZE_WIDTH    13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_4_ITERATION_STEPSIZE_MASK     0x00001FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_4_ITERATION_STEPSIZE_DEFVAL   0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_5                               0x0001D014
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_5_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_5_MASK                          0xFFFDFFEF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_5_TLAST_SUPPRESS_LSB          31
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_5_TLAST_SUPPRESS_WIDTH        1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_5_TLAST_SUPPRESS_MASK         0x80000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_5_TLAST_SUPPRESS_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_5_NEXT_BD_LSB                 27
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_5_NEXT_BD_WIDTH               4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_5_NEXT_BD_MASK                0x78000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_5_NEXT_BD_DEFVAL              0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_5_USE_NEXT_BD_LSB             26
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_5_USE_NEXT_BD_WIDTH           1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_5_USE_NEXT_BD_MASK            0x04000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_5_USE_NEXT_BD_DEFVAL          0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_5_VALID_BD_LSB                25
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_5_VALID_BD_WIDTH              1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_5_VALID_BD_MASK               0x02000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_5_VALID_BD_DEFVAL             0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_5_LOCK_REL_VALUE_LSB          18
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_5_LOCK_REL_VALUE_WIDTH        7
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_5_LOCK_REL_VALUE_MASK         0x01FC0000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_5_LOCK_REL_VALUE_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_5_LOCK_REL_ID_LSB             13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_5_LOCK_REL_ID_WIDTH           4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_5_LOCK_REL_ID_MASK            0x0001E000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_5_LOCK_REL_ID_DEFVAL          0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_5_LOCK_ACQ_ENABLE_LSB         12
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_5_LOCK_ACQ_ENABLE_WIDTH       1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_5_LOCK_ACQ_ENABLE_MASK        0x00001000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_5_LOCK_ACQ_ENABLE_DEFVAL      0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_5_LOCK_ACQ_VALUE_LSB          5
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_5_LOCK_ACQ_VALUE_WIDTH        7
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_5_LOCK_ACQ_VALUE_MASK         0x00000FE0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_5_LOCK_ACQ_VALUE_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_5_LOCK_ACQ_ID_LSB             0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_5_LOCK_ACQ_ID_WIDTH           4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_5_LOCK_ACQ_ID_MASK            0x0000000F
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD0_5_LOCK_ACQ_ID_DEFVAL          0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_0                               0x0001D020
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_0_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_0_MASK                          0x0FFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_0_BASE_ADDRESS_LSB            14
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_0_BASE_ADDRESS_WIDTH          14
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_0_BASE_ADDRESS_MASK           0x0FFFC000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_0_BASE_ADDRESS_DEFVAL         0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_0_BUFFER_LENGTH_LSB           0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_0_BUFFER_LENGTH_WIDTH         14
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_0_BUFFER_LENGTH_MASK          0x00003FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_0_BUFFER_LENGTH_DEFVAL        0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_1                               0x0001D024
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_1_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_1_MASK                          0xFFFF0000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_1_ENABLE_COMPRESSION_LSB      31
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_1_ENABLE_COMPRESSION_WIDTH    1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_1_ENABLE_COMPRESSION_MASK     0x80000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_1_ENABLE_COMPRESSION_DEFVAL   0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_1_ENABLE_PACKET_LSB           30
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_1_ENABLE_PACKET_WIDTH         1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_1_ENABLE_PACKET_MASK          0x40000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_1_ENABLE_PACKET_DEFVAL        0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_1_OUT_OF_ORDER_BD_ID_LSB      24
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_1_OUT_OF_ORDER_BD_ID_WIDTH    6
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_1_OUT_OF_ORDER_BD_ID_MASK     0x3F000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_1_OUT_OF_ORDER_BD_ID_DEFVAL   0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_1_PACKET_ID_LSB               19
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_1_PACKET_ID_WIDTH             5
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_1_PACKET_ID_MASK              0x00F80000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_1_PACKET_ID_DEFVAL            0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_1_PACKET_TYPE_LSB             16
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_1_PACKET_TYPE_WIDTH           3
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_1_PACKET_TYPE_MASK            0x00070000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_1_PACKET_TYPE_DEFVAL          0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_2                               0x0001D028
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_2_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_2_MASK                          0x03FFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_2_D1_STEPSIZE_LSB             13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_2_D1_STEPSIZE_WIDTH           13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_2_D1_STEPSIZE_MASK            0x03FFE000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_2_D1_STEPSIZE_DEFVAL          0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_2_D0_STEPSIZE_LSB             0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_2_D0_STEPSIZE_WIDTH           13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_2_D0_STEPSIZE_MASK            0x00001FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_2_D0_STEPSIZE_DEFVAL          0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_3                               0x0001D02C
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_3_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_3_MASK                          0x1FFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_3_D1_WRAP_LSB                 21
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_3_D1_WRAP_WIDTH               8
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_3_D1_WRAP_MASK                0x1FE00000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_3_D1_WRAP_DEFVAL              0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_3_D0_WRAP_LSB                 13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_3_D0_WRAP_WIDTH               8
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_3_D0_WRAP_MASK                0x001FE000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_3_D0_WRAP_DEFVAL              0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_3_D2_STEPSIZE_LSB             0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_3_D2_STEPSIZE_WIDTH           13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_3_D2_STEPSIZE_MASK            0x00001FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_3_D2_STEPSIZE_DEFVAL          0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_4                               0x0001D030
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_4_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_4_MASK                          0x01FFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_4_ITERATION_CURRENT_LSB       19
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_4_ITERATION_CURRENT_WIDTH     6
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_4_ITERATION_CURRENT_MASK      0x01F80000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_4_ITERATION_CURRENT_DEFVAL    0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_4_ITERATION_WRAP_LSB          13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_4_ITERATION_WRAP_WIDTH        6
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_4_ITERATION_WRAP_MASK         0x0007E000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_4_ITERATION_WRAP_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_4_ITERATION_STEPSIZE_LSB      0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_4_ITERATION_STEPSIZE_WIDTH    13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_4_ITERATION_STEPSIZE_MASK     0x00001FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_4_ITERATION_STEPSIZE_DEFVAL   0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_5                               0x0001D034
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_5_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_5_MASK                          0xFFFDFFEF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_5_TLAST_SUPPRESS_LSB          31
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_5_TLAST_SUPPRESS_WIDTH        1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_5_TLAST_SUPPRESS_MASK         0x80000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_5_TLAST_SUPPRESS_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_5_NEXT_BD_LSB                 27
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_5_NEXT_BD_WIDTH               4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_5_NEXT_BD_MASK                0x78000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_5_NEXT_BD_DEFVAL              0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_5_USE_NEXT_BD_LSB             26
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_5_USE_NEXT_BD_WIDTH           1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_5_USE_NEXT_BD_MASK            0x04000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_5_USE_NEXT_BD_DEFVAL          0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_5_VALID_BD_LSB                25
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_5_VALID_BD_WIDTH              1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_5_VALID_BD_MASK               0x02000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_5_VALID_BD_DEFVAL             0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_5_LOCK_REL_VALUE_LSB          18
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_5_LOCK_REL_VALUE_WIDTH        7
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_5_LOCK_REL_VALUE_MASK         0x01FC0000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_5_LOCK_REL_VALUE_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_5_LOCK_REL_ID_LSB             13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_5_LOCK_REL_ID_WIDTH           4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_5_LOCK_REL_ID_MASK            0x0001E000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_5_LOCK_REL_ID_DEFVAL          0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_5_LOCK_ACQ_ENABLE_LSB         12
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_5_LOCK_ACQ_ENABLE_WIDTH       1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_5_LOCK_ACQ_ENABLE_MASK        0x00001000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_5_LOCK_ACQ_ENABLE_DEFVAL      0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_5_LOCK_ACQ_VALUE_LSB          5
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_5_LOCK_ACQ_VALUE_WIDTH        7
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_5_LOCK_ACQ_VALUE_MASK         0x00000FE0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_5_LOCK_ACQ_VALUE_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_5_LOCK_ACQ_ID_LSB             0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_5_LOCK_ACQ_ID_WIDTH           4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_5_LOCK_ACQ_ID_MASK            0x0000000F
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD1_5_LOCK_ACQ_ID_DEFVAL          0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_0                               0x0001D040
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_0_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_0_MASK                          0x0FFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_0_BASE_ADDRESS_LSB            14
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_0_BASE_ADDRESS_WIDTH          14
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_0_BASE_ADDRESS_MASK           0x0FFFC000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_0_BASE_ADDRESS_DEFVAL         0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_0_BUFFER_LENGTH_LSB           0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_0_BUFFER_LENGTH_WIDTH         14
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_0_BUFFER_LENGTH_MASK          0x00003FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_0_BUFFER_LENGTH_DEFVAL        0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_1                               0x0001D044
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_1_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_1_MASK                          0xFFFF0000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_1_ENABLE_COMPRESSION_LSB      31
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_1_ENABLE_COMPRESSION_WIDTH    1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_1_ENABLE_COMPRESSION_MASK     0x80000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_1_ENABLE_COMPRESSION_DEFVAL   0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_1_ENABLE_PACKET_LSB           30
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_1_ENABLE_PACKET_WIDTH         1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_1_ENABLE_PACKET_MASK          0x40000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_1_ENABLE_PACKET_DEFVAL        0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_1_OUT_OF_ORDER_BD_ID_LSB      24
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_1_OUT_OF_ORDER_BD_ID_WIDTH    6
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_1_OUT_OF_ORDER_BD_ID_MASK     0x3F000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_1_OUT_OF_ORDER_BD_ID_DEFVAL   0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_1_PACKET_ID_LSB               19
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_1_PACKET_ID_WIDTH             5
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_1_PACKET_ID_MASK              0x00F80000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_1_PACKET_ID_DEFVAL            0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_1_PACKET_TYPE_LSB             16
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_1_PACKET_TYPE_WIDTH           3
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_1_PACKET_TYPE_MASK            0x00070000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_1_PACKET_TYPE_DEFVAL          0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_2                               0x0001D048
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_2_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_2_MASK                          0x03FFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_2_D1_STEPSIZE_LSB             13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_2_D1_STEPSIZE_WIDTH           13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_2_D1_STEPSIZE_MASK            0x03FFE000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_2_D1_STEPSIZE_DEFVAL          0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_2_D0_STEPSIZE_LSB             0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_2_D0_STEPSIZE_WIDTH           13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_2_D0_STEPSIZE_MASK            0x00001FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_2_D0_STEPSIZE_DEFVAL          0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_3                               0x0001D04C
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_3_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_3_MASK                          0x1FFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_3_D1_WRAP_LSB                 21
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_3_D1_WRAP_WIDTH               8
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_3_D1_WRAP_MASK                0x1FE00000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_3_D1_WRAP_DEFVAL              0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_3_D0_WRAP_LSB                 13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_3_D0_WRAP_WIDTH               8
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_3_D0_WRAP_MASK                0x001FE000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_3_D0_WRAP_DEFVAL              0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_3_D2_STEPSIZE_LSB             0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_3_D2_STEPSIZE_WIDTH           13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_3_D2_STEPSIZE_MASK            0x00001FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_3_D2_STEPSIZE_DEFVAL          0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_4                               0x0001D050
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_4_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_4_MASK                          0x01FFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_4_ITERATION_CURRENT_LSB       19
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_4_ITERATION_CURRENT_WIDTH     6
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_4_ITERATION_CURRENT_MASK      0x01F80000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_4_ITERATION_CURRENT_DEFVAL    0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_4_ITERATION_WRAP_LSB          13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_4_ITERATION_WRAP_WIDTH        6
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_4_ITERATION_WRAP_MASK         0x0007E000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_4_ITERATION_WRAP_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_4_ITERATION_STEPSIZE_LSB      0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_4_ITERATION_STEPSIZE_WIDTH    13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_4_ITERATION_STEPSIZE_MASK     0x00001FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_4_ITERATION_STEPSIZE_DEFVAL   0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_5                               0x0001D054
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_5_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_5_MASK                          0xFFFDFFEF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_5_TLAST_SUPPRESS_LSB          31
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_5_TLAST_SUPPRESS_WIDTH        1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_5_TLAST_SUPPRESS_MASK         0x80000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_5_TLAST_SUPPRESS_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_5_NEXT_BD_LSB                 27
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_5_NEXT_BD_WIDTH               4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_5_NEXT_BD_MASK                0x78000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_5_NEXT_BD_DEFVAL              0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_5_USE_NEXT_BD_LSB             26
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_5_USE_NEXT_BD_WIDTH           1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_5_USE_NEXT_BD_MASK            0x04000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_5_USE_NEXT_BD_DEFVAL          0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_5_VALID_BD_LSB                25
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_5_VALID_BD_WIDTH              1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_5_VALID_BD_MASK               0x02000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_5_VALID_BD_DEFVAL             0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_5_LOCK_REL_VALUE_LSB          18
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_5_LOCK_REL_VALUE_WIDTH        7
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_5_LOCK_REL_VALUE_MASK         0x01FC0000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_5_LOCK_REL_VALUE_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_5_LOCK_REL_ID_LSB             13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_5_LOCK_REL_ID_WIDTH           4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_5_LOCK_REL_ID_MASK            0x0001E000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_5_LOCK_REL_ID_DEFVAL          0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_5_LOCK_ACQ_ENABLE_LSB         12
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_5_LOCK_ACQ_ENABLE_WIDTH       1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_5_LOCK_ACQ_ENABLE_MASK        0x00001000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_5_LOCK_ACQ_ENABLE_DEFVAL      0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_5_LOCK_ACQ_VALUE_LSB          5
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_5_LOCK_ACQ_VALUE_WIDTH        7
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_5_LOCK_ACQ_VALUE_MASK         0x00000FE0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_5_LOCK_ACQ_VALUE_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_5_LOCK_ACQ_ID_LSB             0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_5_LOCK_ACQ_ID_WIDTH           4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_5_LOCK_ACQ_ID_MASK            0x0000000F
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD2_5_LOCK_ACQ_ID_DEFVAL          0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_0                               0x0001D060
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_0_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_0_MASK                          0x0FFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_0_BASE_ADDRESS_LSB            14
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_0_BASE_ADDRESS_WIDTH          14
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_0_BASE_ADDRESS_MASK           0x0FFFC000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_0_BASE_ADDRESS_DEFVAL         0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_0_BUFFER_LENGTH_LSB           0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_0_BUFFER_LENGTH_WIDTH         14
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_0_BUFFER_LENGTH_MASK          0x00003FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_0_BUFFER_LENGTH_DEFVAL        0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_1                               0x0001D064
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_1_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_1_MASK                          0xFFFF0000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_1_ENABLE_COMPRESSION_LSB      31
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_1_ENABLE_COMPRESSION_WIDTH    1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_1_ENABLE_COMPRESSION_MASK     0x80000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_1_ENABLE_COMPRESSION_DEFVAL   0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_1_ENABLE_PACKET_LSB           30
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_1_ENABLE_PACKET_WIDTH         1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_1_ENABLE_PACKET_MASK          0x40000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_1_ENABLE_PACKET_DEFVAL        0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_1_OUT_OF_ORDER_BD_ID_LSB      24
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_1_OUT_OF_ORDER_BD_ID_WIDTH    6
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_1_OUT_OF_ORDER_BD_ID_MASK     0x3F000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_1_OUT_OF_ORDER_BD_ID_DEFVAL   0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_1_PACKET_ID_LSB               19
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_1_PACKET_ID_WIDTH             5
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_1_PACKET_ID_MASK              0x00F80000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_1_PACKET_ID_DEFVAL            0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_1_PACKET_TYPE_LSB             16
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_1_PACKET_TYPE_WIDTH           3
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_1_PACKET_TYPE_MASK            0x00070000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_1_PACKET_TYPE_DEFVAL          0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_2                               0x0001D068
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_2_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_2_MASK                          0x03FFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_2_D1_STEPSIZE_LSB             13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_2_D1_STEPSIZE_WIDTH           13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_2_D1_STEPSIZE_MASK            0x03FFE000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_2_D1_STEPSIZE_DEFVAL          0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_2_D0_STEPSIZE_LSB             0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_2_D0_STEPSIZE_WIDTH           13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_2_D0_STEPSIZE_MASK            0x00001FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_2_D0_STEPSIZE_DEFVAL          0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_3                               0x0001D06C
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_3_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_3_MASK                          0x1FFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_3_D1_WRAP_LSB                 21
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_3_D1_WRAP_WIDTH               8
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_3_D1_WRAP_MASK                0x1FE00000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_3_D1_WRAP_DEFVAL              0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_3_D0_WRAP_LSB                 13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_3_D0_WRAP_WIDTH               8
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_3_D0_WRAP_MASK                0x001FE000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_3_D0_WRAP_DEFVAL              0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_3_D2_STEPSIZE_LSB             0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_3_D2_STEPSIZE_WIDTH           13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_3_D2_STEPSIZE_MASK            0x00001FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_3_D2_STEPSIZE_DEFVAL          0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_4                               0x0001D070
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_4_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_4_MASK                          0x01FFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_4_ITERATION_CURRENT_LSB       19
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_4_ITERATION_CURRENT_WIDTH     6
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_4_ITERATION_CURRENT_MASK      0x01F80000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_4_ITERATION_CURRENT_DEFVAL    0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_4_ITERATION_WRAP_LSB          13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_4_ITERATION_WRAP_WIDTH        6
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_4_ITERATION_WRAP_MASK         0x0007E000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_4_ITERATION_WRAP_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_4_ITERATION_STEPSIZE_LSB      0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_4_ITERATION_STEPSIZE_WIDTH    13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_4_ITERATION_STEPSIZE_MASK     0x00001FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_4_ITERATION_STEPSIZE_DEFVAL   0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_5                               0x0001D074
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_5_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_5_MASK                          0xFFFDFFEF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_5_TLAST_SUPPRESS_LSB          31
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_5_TLAST_SUPPRESS_WIDTH        1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_5_TLAST_SUPPRESS_MASK         0x80000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_5_TLAST_SUPPRESS_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_5_NEXT_BD_LSB                 27
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_5_NEXT_BD_WIDTH               4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_5_NEXT_BD_MASK                0x78000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_5_NEXT_BD_DEFVAL              0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_5_USE_NEXT_BD_LSB             26
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_5_USE_NEXT_BD_WIDTH           1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_5_USE_NEXT_BD_MASK            0x04000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_5_USE_NEXT_BD_DEFVAL          0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_5_VALID_BD_LSB                25
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_5_VALID_BD_WIDTH              1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_5_VALID_BD_MASK               0x02000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_5_VALID_BD_DEFVAL             0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_5_LOCK_REL_VALUE_LSB          18
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_5_LOCK_REL_VALUE_WIDTH        7
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_5_LOCK_REL_VALUE_MASK         0x01FC0000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_5_LOCK_REL_VALUE_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_5_LOCK_REL_ID_LSB             13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_5_LOCK_REL_ID_WIDTH           4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_5_LOCK_REL_ID_MASK            0x0001E000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_5_LOCK_REL_ID_DEFVAL          0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_5_LOCK_ACQ_ENABLE_LSB         12
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_5_LOCK_ACQ_ENABLE_WIDTH       1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_5_LOCK_ACQ_ENABLE_MASK        0x00001000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_5_LOCK_ACQ_ENABLE_DEFVAL      0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_5_LOCK_ACQ_VALUE_LSB          5
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_5_LOCK_ACQ_VALUE_WIDTH        7
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_5_LOCK_ACQ_VALUE_MASK         0x00000FE0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_5_LOCK_ACQ_VALUE_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_5_LOCK_ACQ_ID_LSB             0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_5_LOCK_ACQ_ID_WIDTH           4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_5_LOCK_ACQ_ID_MASK            0x0000000F
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD3_5_LOCK_ACQ_ID_DEFVAL          0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_0                               0x0001D080
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_0_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_0_MASK                          0x0FFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_0_BASE_ADDRESS_LSB            14
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_0_BASE_ADDRESS_WIDTH          14
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_0_BASE_ADDRESS_MASK           0x0FFFC000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_0_BASE_ADDRESS_DEFVAL         0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_0_BUFFER_LENGTH_LSB           0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_0_BUFFER_LENGTH_WIDTH         14
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_0_BUFFER_LENGTH_MASK          0x00003FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_0_BUFFER_LENGTH_DEFVAL        0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_1                               0x0001D084
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_1_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_1_MASK                          0xFFFF0000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_1_ENABLE_COMPRESSION_LSB      31
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_1_ENABLE_COMPRESSION_WIDTH    1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_1_ENABLE_COMPRESSION_MASK     0x80000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_1_ENABLE_COMPRESSION_DEFVAL   0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_1_ENABLE_PACKET_LSB           30
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_1_ENABLE_PACKET_WIDTH         1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_1_ENABLE_PACKET_MASK          0x40000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_1_ENABLE_PACKET_DEFVAL        0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_1_OUT_OF_ORDER_BD_ID_LSB      24
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_1_OUT_OF_ORDER_BD_ID_WIDTH    6
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_1_OUT_OF_ORDER_BD_ID_MASK     0x3F000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_1_OUT_OF_ORDER_BD_ID_DEFVAL   0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_1_PACKET_ID_LSB               19
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_1_PACKET_ID_WIDTH             5
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_1_PACKET_ID_MASK              0x00F80000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_1_PACKET_ID_DEFVAL            0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_1_PACKET_TYPE_LSB             16
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_1_PACKET_TYPE_WIDTH           3
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_1_PACKET_TYPE_MASK            0x00070000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_1_PACKET_TYPE_DEFVAL          0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_2                               0x0001D088
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_2_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_2_MASK                          0x03FFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_2_D1_STEPSIZE_LSB             13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_2_D1_STEPSIZE_WIDTH           13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_2_D1_STEPSIZE_MASK            0x03FFE000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_2_D1_STEPSIZE_DEFVAL          0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_2_D0_STEPSIZE_LSB             0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_2_D0_STEPSIZE_WIDTH           13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_2_D0_STEPSIZE_MASK            0x00001FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_2_D0_STEPSIZE_DEFVAL          0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_3                               0x0001D08C
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_3_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_3_MASK                          0x1FFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_3_D1_WRAP_LSB                 21
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_3_D1_WRAP_WIDTH               8
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_3_D1_WRAP_MASK                0x1FE00000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_3_D1_WRAP_DEFVAL              0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_3_D0_WRAP_LSB                 13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_3_D0_WRAP_WIDTH               8
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_3_D0_WRAP_MASK                0x001FE000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_3_D0_WRAP_DEFVAL              0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_3_D2_STEPSIZE_LSB             0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_3_D2_STEPSIZE_WIDTH           13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_3_D2_STEPSIZE_MASK            0x00001FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_3_D2_STEPSIZE_DEFVAL          0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_4                               0x0001D090
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_4_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_4_MASK                          0x01FFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_4_ITERATION_CURRENT_LSB       19
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_4_ITERATION_CURRENT_WIDTH     6
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_4_ITERATION_CURRENT_MASK      0x01F80000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_4_ITERATION_CURRENT_DEFVAL    0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_4_ITERATION_WRAP_LSB          13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_4_ITERATION_WRAP_WIDTH        6
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_4_ITERATION_WRAP_MASK         0x0007E000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_4_ITERATION_WRAP_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_4_ITERATION_STEPSIZE_LSB      0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_4_ITERATION_STEPSIZE_WIDTH    13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_4_ITERATION_STEPSIZE_MASK     0x00001FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_4_ITERATION_STEPSIZE_DEFVAL   0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_5                               0x0001D094
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_5_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_5_MASK                          0xFFFDFFEF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_5_TLAST_SUPPRESS_LSB          31
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_5_TLAST_SUPPRESS_WIDTH        1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_5_TLAST_SUPPRESS_MASK         0x80000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_5_TLAST_SUPPRESS_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_5_NEXT_BD_LSB                 27
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_5_NEXT_BD_WIDTH               4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_5_NEXT_BD_MASK                0x78000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_5_NEXT_BD_DEFVAL              0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_5_USE_NEXT_BD_LSB             26
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_5_USE_NEXT_BD_WIDTH           1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_5_USE_NEXT_BD_MASK            0x04000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_5_USE_NEXT_BD_DEFVAL          0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_5_VALID_BD_LSB                25
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_5_VALID_BD_WIDTH              1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_5_VALID_BD_MASK               0x02000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_5_VALID_BD_DEFVAL             0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_5_LOCK_REL_VALUE_LSB          18
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_5_LOCK_REL_VALUE_WIDTH        7
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_5_LOCK_REL_VALUE_MASK         0x01FC0000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_5_LOCK_REL_VALUE_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_5_LOCK_REL_ID_LSB             13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_5_LOCK_REL_ID_WIDTH           4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_5_LOCK_REL_ID_MASK            0x0001E000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_5_LOCK_REL_ID_DEFVAL          0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_5_LOCK_ACQ_ENABLE_LSB         12
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_5_LOCK_ACQ_ENABLE_WIDTH       1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_5_LOCK_ACQ_ENABLE_MASK        0x00001000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_5_LOCK_ACQ_ENABLE_DEFVAL      0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_5_LOCK_ACQ_VALUE_LSB          5
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_5_LOCK_ACQ_VALUE_WIDTH        7
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_5_LOCK_ACQ_VALUE_MASK         0x00000FE0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_5_LOCK_ACQ_VALUE_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_5_LOCK_ACQ_ID_LSB             0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_5_LOCK_ACQ_ID_WIDTH           4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_5_LOCK_ACQ_ID_MASK            0x0000000F
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD4_5_LOCK_ACQ_ID_DEFVAL          0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_0                               0x0001D0A0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_0_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_0_MASK                          0x0FFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_0_BASE_ADDRESS_LSB            14
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_0_BASE_ADDRESS_WIDTH          14
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_0_BASE_ADDRESS_MASK           0x0FFFC000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_0_BASE_ADDRESS_DEFVAL         0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_0_BUFFER_LENGTH_LSB           0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_0_BUFFER_LENGTH_WIDTH         14
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_0_BUFFER_LENGTH_MASK          0x00003FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_0_BUFFER_LENGTH_DEFVAL        0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_1                               0x0001D0A4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_1_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_1_MASK                          0xFFFF0000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_1_ENABLE_COMPRESSION_LSB      31
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_1_ENABLE_COMPRESSION_WIDTH    1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_1_ENABLE_COMPRESSION_MASK     0x80000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_1_ENABLE_COMPRESSION_DEFVAL   0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_1_ENABLE_PACKET_LSB           30
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_1_ENABLE_PACKET_WIDTH         1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_1_ENABLE_PACKET_MASK          0x40000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_1_ENABLE_PACKET_DEFVAL        0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_1_OUT_OF_ORDER_BD_ID_LSB      24
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_1_OUT_OF_ORDER_BD_ID_WIDTH    6
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_1_OUT_OF_ORDER_BD_ID_MASK     0x3F000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_1_OUT_OF_ORDER_BD_ID_DEFVAL   0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_1_PACKET_ID_LSB               19
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_1_PACKET_ID_WIDTH             5
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_1_PACKET_ID_MASK              0x00F80000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_1_PACKET_ID_DEFVAL            0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_1_PACKET_TYPE_LSB             16
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_1_PACKET_TYPE_WIDTH           3
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_1_PACKET_TYPE_MASK            0x00070000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_1_PACKET_TYPE_DEFVAL          0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_2                               0x0001D0A8
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_2_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_2_MASK                          0x03FFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_2_D1_STEPSIZE_LSB             13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_2_D1_STEPSIZE_WIDTH           13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_2_D1_STEPSIZE_MASK            0x03FFE000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_2_D1_STEPSIZE_DEFVAL          0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_2_D0_STEPSIZE_LSB             0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_2_D0_STEPSIZE_WIDTH           13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_2_D0_STEPSIZE_MASK            0x00001FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_2_D0_STEPSIZE_DEFVAL          0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_3                               0x0001D0AC
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_3_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_3_MASK                          0x1FFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_3_D1_WRAP_LSB                 21
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_3_D1_WRAP_WIDTH               8
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_3_D1_WRAP_MASK                0x1FE00000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_3_D1_WRAP_DEFVAL              0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_3_D0_WRAP_LSB                 13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_3_D0_WRAP_WIDTH               8
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_3_D0_WRAP_MASK                0x001FE000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_3_D0_WRAP_DEFVAL              0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_3_D2_STEPSIZE_LSB             0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_3_D2_STEPSIZE_WIDTH           13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_3_D2_STEPSIZE_MASK            0x00001FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_3_D2_STEPSIZE_DEFVAL          0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_4                               0x0001D0B0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_4_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_4_MASK                          0x01FFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_4_ITERATION_CURRENT_LSB       19
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_4_ITERATION_CURRENT_WIDTH     6
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_4_ITERATION_CURRENT_MASK      0x01F80000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_4_ITERATION_CURRENT_DEFVAL    0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_4_ITERATION_WRAP_LSB          13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_4_ITERATION_WRAP_WIDTH        6
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_4_ITERATION_WRAP_MASK         0x0007E000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_4_ITERATION_WRAP_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_4_ITERATION_STEPSIZE_LSB      0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_4_ITERATION_STEPSIZE_WIDTH    13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_4_ITERATION_STEPSIZE_MASK     0x00001FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_4_ITERATION_STEPSIZE_DEFVAL   0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_5                               0x0001D0B4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_5_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_5_MASK                          0xFFFDFFEF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_5_TLAST_SUPPRESS_LSB          31
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_5_TLAST_SUPPRESS_WIDTH        1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_5_TLAST_SUPPRESS_MASK         0x80000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_5_TLAST_SUPPRESS_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_5_NEXT_BD_LSB                 27
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_5_NEXT_BD_WIDTH               4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_5_NEXT_BD_MASK                0x78000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_5_NEXT_BD_DEFVAL              0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_5_USE_NEXT_BD_LSB             26
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_5_USE_NEXT_BD_WIDTH           1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_5_USE_NEXT_BD_MASK            0x04000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_5_USE_NEXT_BD_DEFVAL          0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_5_VALID_BD_LSB                25
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_5_VALID_BD_WIDTH              1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_5_VALID_BD_MASK               0x02000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_5_VALID_BD_DEFVAL             0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_5_LOCK_REL_VALUE_LSB          18
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_5_LOCK_REL_VALUE_WIDTH        7
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_5_LOCK_REL_VALUE_MASK         0x01FC0000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_5_LOCK_REL_VALUE_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_5_LOCK_REL_ID_LSB             13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_5_LOCK_REL_ID_WIDTH           4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_5_LOCK_REL_ID_MASK            0x0001E000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_5_LOCK_REL_ID_DEFVAL          0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_5_LOCK_ACQ_ENABLE_LSB         12
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_5_LOCK_ACQ_ENABLE_WIDTH       1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_5_LOCK_ACQ_ENABLE_MASK        0x00001000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_5_LOCK_ACQ_ENABLE_DEFVAL      0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_5_LOCK_ACQ_VALUE_LSB          5
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_5_LOCK_ACQ_VALUE_WIDTH        7
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_5_LOCK_ACQ_VALUE_MASK         0x00000FE0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_5_LOCK_ACQ_VALUE_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_5_LOCK_ACQ_ID_LSB             0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_5_LOCK_ACQ_ID_WIDTH           4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_5_LOCK_ACQ_ID_MASK            0x0000000F
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD5_5_LOCK_ACQ_ID_DEFVAL          0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_0                               0x0001D0C0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_0_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_0_MASK                          0x0FFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_0_BASE_ADDRESS_LSB            14
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_0_BASE_ADDRESS_WIDTH          14
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_0_BASE_ADDRESS_MASK           0x0FFFC000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_0_BASE_ADDRESS_DEFVAL         0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_0_BUFFER_LENGTH_LSB           0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_0_BUFFER_LENGTH_WIDTH         14
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_0_BUFFER_LENGTH_MASK          0x00003FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_0_BUFFER_LENGTH_DEFVAL        0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_1                               0x0001D0C4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_1_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_1_MASK                          0xFFFF0000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_1_ENABLE_COMPRESSION_LSB      31
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_1_ENABLE_COMPRESSION_WIDTH    1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_1_ENABLE_COMPRESSION_MASK     0x80000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_1_ENABLE_COMPRESSION_DEFVAL   0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_1_ENABLE_PACKET_LSB           30
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_1_ENABLE_PACKET_WIDTH         1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_1_ENABLE_PACKET_MASK          0x40000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_1_ENABLE_PACKET_DEFVAL        0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_1_OUT_OF_ORDER_BD_ID_LSB      24
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_1_OUT_OF_ORDER_BD_ID_WIDTH    6
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_1_OUT_OF_ORDER_BD_ID_MASK     0x3F000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_1_OUT_OF_ORDER_BD_ID_DEFVAL   0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_1_PACKET_ID_LSB               19
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_1_PACKET_ID_WIDTH             5
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_1_PACKET_ID_MASK              0x00F80000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_1_PACKET_ID_DEFVAL            0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_1_PACKET_TYPE_LSB             16
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_1_PACKET_TYPE_WIDTH           3
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_1_PACKET_TYPE_MASK            0x00070000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_1_PACKET_TYPE_DEFVAL          0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_2                               0x0001D0C8
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_2_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_2_MASK                          0x03FFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_2_D1_STEPSIZE_LSB             13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_2_D1_STEPSIZE_WIDTH           13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_2_D1_STEPSIZE_MASK            0x03FFE000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_2_D1_STEPSIZE_DEFVAL          0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_2_D0_STEPSIZE_LSB             0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_2_D0_STEPSIZE_WIDTH           13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_2_D0_STEPSIZE_MASK            0x00001FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_2_D0_STEPSIZE_DEFVAL          0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_3                               0x0001D0CC
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_3_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_3_MASK                          0x1FFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_3_D1_WRAP_LSB                 21
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_3_D1_WRAP_WIDTH               8
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_3_D1_WRAP_MASK                0x1FE00000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_3_D1_WRAP_DEFVAL              0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_3_D0_WRAP_LSB                 13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_3_D0_WRAP_WIDTH               8
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_3_D0_WRAP_MASK                0x001FE000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_3_D0_WRAP_DEFVAL              0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_3_D2_STEPSIZE_LSB             0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_3_D2_STEPSIZE_WIDTH           13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_3_D2_STEPSIZE_MASK            0x00001FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_3_D2_STEPSIZE_DEFVAL          0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_4                               0x0001D0D0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_4_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_4_MASK                          0x01FFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_4_ITERATION_CURRENT_LSB       19
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_4_ITERATION_CURRENT_WIDTH     6
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_4_ITERATION_CURRENT_MASK      0x01F80000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_4_ITERATION_CURRENT_DEFVAL    0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_4_ITERATION_WRAP_LSB          13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_4_ITERATION_WRAP_WIDTH        6
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_4_ITERATION_WRAP_MASK         0x0007E000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_4_ITERATION_WRAP_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_4_ITERATION_STEPSIZE_LSB      0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_4_ITERATION_STEPSIZE_WIDTH    13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_4_ITERATION_STEPSIZE_MASK     0x00001FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_4_ITERATION_STEPSIZE_DEFVAL   0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_5                               0x0001D0D4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_5_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_5_MASK                          0xFFFDFFEF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_5_TLAST_SUPPRESS_LSB          31
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_5_TLAST_SUPPRESS_WIDTH        1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_5_TLAST_SUPPRESS_MASK         0x80000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_5_TLAST_SUPPRESS_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_5_NEXT_BD_LSB                 27
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_5_NEXT_BD_WIDTH               4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_5_NEXT_BD_MASK                0x78000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_5_NEXT_BD_DEFVAL              0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_5_USE_NEXT_BD_LSB             26
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_5_USE_NEXT_BD_WIDTH           1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_5_USE_NEXT_BD_MASK            0x04000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_5_USE_NEXT_BD_DEFVAL          0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_5_VALID_BD_LSB                25
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_5_VALID_BD_WIDTH              1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_5_VALID_BD_MASK               0x02000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_5_VALID_BD_DEFVAL             0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_5_LOCK_REL_VALUE_LSB          18
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_5_LOCK_REL_VALUE_WIDTH        7
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_5_LOCK_REL_VALUE_MASK         0x01FC0000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_5_LOCK_REL_VALUE_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_5_LOCK_REL_ID_LSB             13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_5_LOCK_REL_ID_WIDTH           4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_5_LOCK_REL_ID_MASK            0x0001E000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_5_LOCK_REL_ID_DEFVAL          0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_5_LOCK_ACQ_ENABLE_LSB         12
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_5_LOCK_ACQ_ENABLE_WIDTH       1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_5_LOCK_ACQ_ENABLE_MASK        0x00001000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_5_LOCK_ACQ_ENABLE_DEFVAL      0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_5_LOCK_ACQ_VALUE_LSB          5
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_5_LOCK_ACQ_VALUE_WIDTH        7
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_5_LOCK_ACQ_VALUE_MASK         0x00000FE0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_5_LOCK_ACQ_VALUE_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_5_LOCK_ACQ_ID_LSB             0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_5_LOCK_ACQ_ID_WIDTH           4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_5_LOCK_ACQ_ID_MASK            0x0000000F
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD6_5_LOCK_ACQ_ID_DEFVAL          0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_0                               0x0001D0E0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_0_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_0_MASK                          0x0FFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_0_BASE_ADDRESS_LSB            14
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_0_BASE_ADDRESS_WIDTH          14
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_0_BASE_ADDRESS_MASK           0x0FFFC000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_0_BASE_ADDRESS_DEFVAL         0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_0_BUFFER_LENGTH_LSB           0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_0_BUFFER_LENGTH_WIDTH         14
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_0_BUFFER_LENGTH_MASK          0x00003FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_0_BUFFER_LENGTH_DEFVAL        0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_1                               0x0001D0E4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_1_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_1_MASK                          0xFFFF0000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_1_ENABLE_COMPRESSION_LSB      31
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_1_ENABLE_COMPRESSION_WIDTH    1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_1_ENABLE_COMPRESSION_MASK     0x80000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_1_ENABLE_COMPRESSION_DEFVAL   0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_1_ENABLE_PACKET_LSB           30
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_1_ENABLE_PACKET_WIDTH         1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_1_ENABLE_PACKET_MASK          0x40000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_1_ENABLE_PACKET_DEFVAL        0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_1_OUT_OF_ORDER_BD_ID_LSB      24
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_1_OUT_OF_ORDER_BD_ID_WIDTH    6
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_1_OUT_OF_ORDER_BD_ID_MASK     0x3F000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_1_OUT_OF_ORDER_BD_ID_DEFVAL   0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_1_PACKET_ID_LSB               19
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_1_PACKET_ID_WIDTH             5
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_1_PACKET_ID_MASK              0x00F80000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_1_PACKET_ID_DEFVAL            0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_1_PACKET_TYPE_LSB             16
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_1_PACKET_TYPE_WIDTH           3
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_1_PACKET_TYPE_MASK            0x00070000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_1_PACKET_TYPE_DEFVAL          0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_2                               0x0001D0E8
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_2_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_2_MASK                          0x03FFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_2_D1_STEPSIZE_LSB             13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_2_D1_STEPSIZE_WIDTH           13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_2_D1_STEPSIZE_MASK            0x03FFE000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_2_D1_STEPSIZE_DEFVAL          0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_2_D0_STEPSIZE_LSB             0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_2_D0_STEPSIZE_WIDTH           13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_2_D0_STEPSIZE_MASK            0x00001FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_2_D0_STEPSIZE_DEFVAL          0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_3                               0x0001D0EC
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_3_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_3_MASK                          0x1FFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_3_D1_WRAP_LSB                 21
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_3_D1_WRAP_WIDTH               8
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_3_D1_WRAP_MASK                0x1FE00000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_3_D1_WRAP_DEFVAL              0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_3_D0_WRAP_LSB                 13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_3_D0_WRAP_WIDTH               8
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_3_D0_WRAP_MASK                0x001FE000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_3_D0_WRAP_DEFVAL              0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_3_D2_STEPSIZE_LSB             0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_3_D2_STEPSIZE_WIDTH           13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_3_D2_STEPSIZE_MASK            0x00001FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_3_D2_STEPSIZE_DEFVAL          0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_4                               0x0001D0F0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_4_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_4_MASK                          0x01FFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_4_ITERATION_CURRENT_LSB       19
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_4_ITERATION_CURRENT_WIDTH     6
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_4_ITERATION_CURRENT_MASK      0x01F80000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_4_ITERATION_CURRENT_DEFVAL    0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_4_ITERATION_WRAP_LSB          13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_4_ITERATION_WRAP_WIDTH        6
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_4_ITERATION_WRAP_MASK         0x0007E000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_4_ITERATION_WRAP_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_4_ITERATION_STEPSIZE_LSB      0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_4_ITERATION_STEPSIZE_WIDTH    13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_4_ITERATION_STEPSIZE_MASK     0x00001FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_4_ITERATION_STEPSIZE_DEFVAL   0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_5                               0x0001D0F4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_5_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_5_MASK                          0xFFFDFFEF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_5_TLAST_SUPPRESS_LSB          31
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_5_TLAST_SUPPRESS_WIDTH        1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_5_TLAST_SUPPRESS_MASK         0x80000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_5_TLAST_SUPPRESS_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_5_NEXT_BD_LSB                 27
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_5_NEXT_BD_WIDTH               4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_5_NEXT_BD_MASK                0x78000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_5_NEXT_BD_DEFVAL              0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_5_USE_NEXT_BD_LSB             26
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_5_USE_NEXT_BD_WIDTH           1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_5_USE_NEXT_BD_MASK            0x04000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_5_USE_NEXT_BD_DEFVAL          0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_5_VALID_BD_LSB                25
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_5_VALID_BD_WIDTH              1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_5_VALID_BD_MASK               0x02000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_5_VALID_BD_DEFVAL             0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_5_LOCK_REL_VALUE_LSB          18
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_5_LOCK_REL_VALUE_WIDTH        7
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_5_LOCK_REL_VALUE_MASK         0x01FC0000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_5_LOCK_REL_VALUE_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_5_LOCK_REL_ID_LSB             13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_5_LOCK_REL_ID_WIDTH           4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_5_LOCK_REL_ID_MASK            0x0001E000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_5_LOCK_REL_ID_DEFVAL          0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_5_LOCK_ACQ_ENABLE_LSB         12
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_5_LOCK_ACQ_ENABLE_WIDTH       1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_5_LOCK_ACQ_ENABLE_MASK        0x00001000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_5_LOCK_ACQ_ENABLE_DEFVAL      0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_5_LOCK_ACQ_VALUE_LSB          5
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_5_LOCK_ACQ_VALUE_WIDTH        7
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_5_LOCK_ACQ_VALUE_MASK         0x00000FE0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_5_LOCK_ACQ_VALUE_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_5_LOCK_ACQ_ID_LSB             0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_5_LOCK_ACQ_ID_WIDTH           4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_5_LOCK_ACQ_ID_MASK            0x0000000F
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD7_5_LOCK_ACQ_ID_DEFVAL          0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_0                               0x0001D100
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_0_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_0_MASK                          0x0FFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_0_BASE_ADDRESS_LSB            14
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_0_BASE_ADDRESS_WIDTH          14
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_0_BASE_ADDRESS_MASK           0x0FFFC000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_0_BASE_ADDRESS_DEFVAL         0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_0_BUFFER_LENGTH_LSB           0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_0_BUFFER_LENGTH_WIDTH         14
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_0_BUFFER_LENGTH_MASK          0x00003FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_0_BUFFER_LENGTH_DEFVAL        0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_1                               0x0001D104
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_1_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_1_MASK                          0xFFFF0000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_1_ENABLE_COMPRESSION_LSB      31
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_1_ENABLE_COMPRESSION_WIDTH    1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_1_ENABLE_COMPRESSION_MASK     0x80000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_1_ENABLE_COMPRESSION_DEFVAL   0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_1_ENABLE_PACKET_LSB           30
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_1_ENABLE_PACKET_WIDTH         1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_1_ENABLE_PACKET_MASK          0x40000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_1_ENABLE_PACKET_DEFVAL        0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_1_OUT_OF_ORDER_BD_ID_LSB      24
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_1_OUT_OF_ORDER_BD_ID_WIDTH    6
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_1_OUT_OF_ORDER_BD_ID_MASK     0x3F000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_1_OUT_OF_ORDER_BD_ID_DEFVAL   0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_1_PACKET_ID_LSB               19
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_1_PACKET_ID_WIDTH             5
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_1_PACKET_ID_MASK              0x00F80000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_1_PACKET_ID_DEFVAL            0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_1_PACKET_TYPE_LSB             16
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_1_PACKET_TYPE_WIDTH           3
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_1_PACKET_TYPE_MASK            0x00070000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_1_PACKET_TYPE_DEFVAL          0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_2                               0x0001D108
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_2_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_2_MASK                          0x03FFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_2_D1_STEPSIZE_LSB             13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_2_D1_STEPSIZE_WIDTH           13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_2_D1_STEPSIZE_MASK            0x03FFE000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_2_D1_STEPSIZE_DEFVAL          0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_2_D0_STEPSIZE_LSB             0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_2_D0_STEPSIZE_WIDTH           13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_2_D0_STEPSIZE_MASK            0x00001FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_2_D0_STEPSIZE_DEFVAL          0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_3                               0x0001D10C
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_3_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_3_MASK                          0x1FFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_3_D1_WRAP_LSB                 21
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_3_D1_WRAP_WIDTH               8
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_3_D1_WRAP_MASK                0x1FE00000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_3_D1_WRAP_DEFVAL              0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_3_D0_WRAP_LSB                 13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_3_D0_WRAP_WIDTH               8
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_3_D0_WRAP_MASK                0x001FE000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_3_D0_WRAP_DEFVAL              0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_3_D2_STEPSIZE_LSB             0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_3_D2_STEPSIZE_WIDTH           13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_3_D2_STEPSIZE_MASK            0x00001FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_3_D2_STEPSIZE_DEFVAL          0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_4                               0x0001D110
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_4_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_4_MASK                          0x01FFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_4_ITERATION_CURRENT_LSB       19
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_4_ITERATION_CURRENT_WIDTH     6
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_4_ITERATION_CURRENT_MASK      0x01F80000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_4_ITERATION_CURRENT_DEFVAL    0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_4_ITERATION_WRAP_LSB          13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_4_ITERATION_WRAP_WIDTH        6
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_4_ITERATION_WRAP_MASK         0x0007E000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_4_ITERATION_WRAP_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_4_ITERATION_STEPSIZE_LSB      0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_4_ITERATION_STEPSIZE_WIDTH    13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_4_ITERATION_STEPSIZE_MASK     0x00001FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_4_ITERATION_STEPSIZE_DEFVAL   0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_5                               0x0001D114
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_5_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_5_MASK                          0xFFFDFFEF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_5_TLAST_SUPPRESS_LSB          31
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_5_TLAST_SUPPRESS_WIDTH        1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_5_TLAST_SUPPRESS_MASK         0x80000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_5_TLAST_SUPPRESS_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_5_NEXT_BD_LSB                 27
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_5_NEXT_BD_WIDTH               4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_5_NEXT_BD_MASK                0x78000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_5_NEXT_BD_DEFVAL              0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_5_USE_NEXT_BD_LSB             26
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_5_USE_NEXT_BD_WIDTH           1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_5_USE_NEXT_BD_MASK            0x04000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_5_USE_NEXT_BD_DEFVAL          0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_5_VALID_BD_LSB                25
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_5_VALID_BD_WIDTH              1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_5_VALID_BD_MASK               0x02000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_5_VALID_BD_DEFVAL             0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_5_LOCK_REL_VALUE_LSB          18
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_5_LOCK_REL_VALUE_WIDTH        7
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_5_LOCK_REL_VALUE_MASK         0x01FC0000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_5_LOCK_REL_VALUE_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_5_LOCK_REL_ID_LSB             13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_5_LOCK_REL_ID_WIDTH           4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_5_LOCK_REL_ID_MASK            0x0001E000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_5_LOCK_REL_ID_DEFVAL          0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_5_LOCK_ACQ_ENABLE_LSB         12
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_5_LOCK_ACQ_ENABLE_WIDTH       1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_5_LOCK_ACQ_ENABLE_MASK        0x00001000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_5_LOCK_ACQ_ENABLE_DEFVAL      0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_5_LOCK_ACQ_VALUE_LSB          5
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_5_LOCK_ACQ_VALUE_WIDTH        7
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_5_LOCK_ACQ_VALUE_MASK         0x00000FE0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_5_LOCK_ACQ_VALUE_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_5_LOCK_ACQ_ID_LSB             0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_5_LOCK_ACQ_ID_WIDTH           4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_5_LOCK_ACQ_ID_MASK            0x0000000F
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD8_5_LOCK_ACQ_ID_DEFVAL          0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_0                               0x0001D120
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_0_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_0_MASK                          0x0FFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_0_BASE_ADDRESS_LSB            14
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_0_BASE_ADDRESS_WIDTH          14
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_0_BASE_ADDRESS_MASK           0x0FFFC000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_0_BASE_ADDRESS_DEFVAL         0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_0_BUFFER_LENGTH_LSB           0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_0_BUFFER_LENGTH_WIDTH         14
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_0_BUFFER_LENGTH_MASK          0x00003FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_0_BUFFER_LENGTH_DEFVAL        0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_1                               0x0001D124
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_1_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_1_MASK                          0xFFFF0000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_1_ENABLE_COMPRESSION_LSB      31
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_1_ENABLE_COMPRESSION_WIDTH    1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_1_ENABLE_COMPRESSION_MASK     0x80000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_1_ENABLE_COMPRESSION_DEFVAL   0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_1_ENABLE_PACKET_LSB           30
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_1_ENABLE_PACKET_WIDTH         1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_1_ENABLE_PACKET_MASK          0x40000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_1_ENABLE_PACKET_DEFVAL        0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_1_OUT_OF_ORDER_BD_ID_LSB      24
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_1_OUT_OF_ORDER_BD_ID_WIDTH    6
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_1_OUT_OF_ORDER_BD_ID_MASK     0x3F000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_1_OUT_OF_ORDER_BD_ID_DEFVAL   0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_1_PACKET_ID_LSB               19
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_1_PACKET_ID_WIDTH             5
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_1_PACKET_ID_MASK              0x00F80000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_1_PACKET_ID_DEFVAL            0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_1_PACKET_TYPE_LSB             16
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_1_PACKET_TYPE_WIDTH           3
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_1_PACKET_TYPE_MASK            0x00070000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_1_PACKET_TYPE_DEFVAL          0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_2                               0x0001D128
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_2_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_2_MASK                          0x03FFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_2_D1_STEPSIZE_LSB             13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_2_D1_STEPSIZE_WIDTH           13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_2_D1_STEPSIZE_MASK            0x03FFE000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_2_D1_STEPSIZE_DEFVAL          0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_2_D0_STEPSIZE_LSB             0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_2_D0_STEPSIZE_WIDTH           13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_2_D0_STEPSIZE_MASK            0x00001FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_2_D0_STEPSIZE_DEFVAL          0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_3                               0x0001D12C
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_3_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_3_MASK                          0x1FFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_3_D1_WRAP_LSB                 21
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_3_D1_WRAP_WIDTH               8
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_3_D1_WRAP_MASK                0x1FE00000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_3_D1_WRAP_DEFVAL              0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_3_D0_WRAP_LSB                 13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_3_D0_WRAP_WIDTH               8
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_3_D0_WRAP_MASK                0x001FE000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_3_D0_WRAP_DEFVAL              0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_3_D2_STEPSIZE_LSB             0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_3_D2_STEPSIZE_WIDTH           13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_3_D2_STEPSIZE_MASK            0x00001FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_3_D2_STEPSIZE_DEFVAL          0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_4                               0x0001D130
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_4_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_4_MASK                          0x01FFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_4_ITERATION_CURRENT_LSB       19
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_4_ITERATION_CURRENT_WIDTH     6
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_4_ITERATION_CURRENT_MASK      0x01F80000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_4_ITERATION_CURRENT_DEFVAL    0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_4_ITERATION_WRAP_LSB          13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_4_ITERATION_WRAP_WIDTH        6
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_4_ITERATION_WRAP_MASK         0x0007E000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_4_ITERATION_WRAP_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_4_ITERATION_STEPSIZE_LSB      0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_4_ITERATION_STEPSIZE_WIDTH    13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_4_ITERATION_STEPSIZE_MASK     0x00001FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_4_ITERATION_STEPSIZE_DEFVAL   0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_5                               0x0001D134
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_5_WIDTH                         32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_5_MASK                          0xFFFDFFEF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_5_TLAST_SUPPRESS_LSB          31
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_5_TLAST_SUPPRESS_WIDTH        1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_5_TLAST_SUPPRESS_MASK         0x80000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_5_TLAST_SUPPRESS_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_5_NEXT_BD_LSB                 27
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_5_NEXT_BD_WIDTH               4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_5_NEXT_BD_MASK                0x78000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_5_NEXT_BD_DEFVAL              0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_5_USE_NEXT_BD_LSB             26
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_5_USE_NEXT_BD_WIDTH           1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_5_USE_NEXT_BD_MASK            0x04000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_5_USE_NEXT_BD_DEFVAL          0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_5_VALID_BD_LSB                25
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_5_VALID_BD_WIDTH              1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_5_VALID_BD_MASK               0x02000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_5_VALID_BD_DEFVAL             0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_5_LOCK_REL_VALUE_LSB          18
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_5_LOCK_REL_VALUE_WIDTH        7
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_5_LOCK_REL_VALUE_MASK         0x01FC0000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_5_LOCK_REL_VALUE_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_5_LOCK_REL_ID_LSB             13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_5_LOCK_REL_ID_WIDTH           4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_5_LOCK_REL_ID_MASK            0x0001E000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_5_LOCK_REL_ID_DEFVAL          0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_5_LOCK_ACQ_ENABLE_LSB         12
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_5_LOCK_ACQ_ENABLE_WIDTH       1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_5_LOCK_ACQ_ENABLE_MASK        0x00001000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_5_LOCK_ACQ_ENABLE_DEFVAL      0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_5_LOCK_ACQ_VALUE_LSB          5
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_5_LOCK_ACQ_VALUE_WIDTH        7
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_5_LOCK_ACQ_VALUE_MASK         0x00000FE0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_5_LOCK_ACQ_VALUE_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_5_LOCK_ACQ_ID_LSB             0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_5_LOCK_ACQ_ID_WIDTH           4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_5_LOCK_ACQ_ID_MASK            0x0000000F
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD9_5_LOCK_ACQ_ID_DEFVAL          0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_0                              0x0001D140
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_0_WIDTH                        32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_0_MASK                         0x0FFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_0_BASE_ADDRESS_LSB           14
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_0_BASE_ADDRESS_WIDTH         14
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_0_BASE_ADDRESS_MASK          0x0FFFC000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_0_BASE_ADDRESS_DEFVAL        0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_0_BUFFER_LENGTH_LSB          0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_0_BUFFER_LENGTH_WIDTH        14
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_0_BUFFER_LENGTH_MASK         0x00003FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_0_BUFFER_LENGTH_DEFVAL       0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_1                              0x0001D144
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_1_WIDTH                        32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_1_MASK                         0xFFFF0000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_1_ENABLE_COMPRESSION_LSB     31
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_1_ENABLE_COMPRESSION_WIDTH   1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_1_ENABLE_COMPRESSION_MASK    0x80000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_1_ENABLE_COMPRESSION_DEFVAL  0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_1_ENABLE_PACKET_LSB          30
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_1_ENABLE_PACKET_WIDTH        1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_1_ENABLE_PACKET_MASK         0x40000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_1_ENABLE_PACKET_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_1_OUT_OF_ORDER_BD_ID_LSB     24
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_1_OUT_OF_ORDER_BD_ID_WIDTH   6
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_1_OUT_OF_ORDER_BD_ID_MASK    0x3F000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_1_OUT_OF_ORDER_BD_ID_DEFVAL  0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_1_PACKET_ID_LSB              19
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_1_PACKET_ID_WIDTH            5
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_1_PACKET_ID_MASK             0x00F80000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_1_PACKET_ID_DEFVAL           0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_1_PACKET_TYPE_LSB            16
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_1_PACKET_TYPE_WIDTH          3
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_1_PACKET_TYPE_MASK           0x00070000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_1_PACKET_TYPE_DEFVAL         0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_2                              0x0001D148
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_2_WIDTH                        32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_2_MASK                         0x03FFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_2_D1_STEPSIZE_LSB            13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_2_D1_STEPSIZE_WIDTH          13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_2_D1_STEPSIZE_MASK           0x03FFE000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_2_D1_STEPSIZE_DEFVAL         0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_2_D0_STEPSIZE_LSB            0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_2_D0_STEPSIZE_WIDTH          13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_2_D0_STEPSIZE_MASK           0x00001FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_2_D0_STEPSIZE_DEFVAL         0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_3                              0x0001D14C
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_3_WIDTH                        32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_3_MASK                         0x1FFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_3_D1_WRAP_LSB                21
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_3_D1_WRAP_WIDTH              8
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_3_D1_WRAP_MASK               0x1FE00000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_3_D1_WRAP_DEFVAL             0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_3_D0_WRAP_LSB                13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_3_D0_WRAP_WIDTH              8
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_3_D0_WRAP_MASK               0x001FE000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_3_D0_WRAP_DEFVAL             0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_3_D2_STEPSIZE_LSB            0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_3_D2_STEPSIZE_WIDTH          13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_3_D2_STEPSIZE_MASK           0x00001FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_3_D2_STEPSIZE_DEFVAL         0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_4                              0x0001D150
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_4_WIDTH                        32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_4_MASK                         0x01FFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_4_ITERATION_CURRENT_LSB      19
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_4_ITERATION_CURRENT_WIDTH    6
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_4_ITERATION_CURRENT_MASK     0x01F80000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_4_ITERATION_CURRENT_DEFVAL   0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_4_ITERATION_WRAP_LSB         13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_4_ITERATION_WRAP_WIDTH       6
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_4_ITERATION_WRAP_MASK        0x0007E000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_4_ITERATION_WRAP_DEFVAL      0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_4_ITERATION_STEPSIZE_LSB     0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_4_ITERATION_STEPSIZE_WIDTH   13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_4_ITERATION_STEPSIZE_MASK    0x00001FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_4_ITERATION_STEPSIZE_DEFVAL  0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_5                              0x0001D154
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_5_WIDTH                        32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_5_MASK                         0xFFFDFFEF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_5_TLAST_SUPPRESS_LSB         31
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_5_TLAST_SUPPRESS_WIDTH       1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_5_TLAST_SUPPRESS_MASK        0x80000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_5_TLAST_SUPPRESS_DEFVAL      0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_5_NEXT_BD_LSB                27
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_5_NEXT_BD_WIDTH              4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_5_NEXT_BD_MASK               0x78000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_5_NEXT_BD_DEFVAL             0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_5_USE_NEXT_BD_LSB            26
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_5_USE_NEXT_BD_WIDTH          1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_5_USE_NEXT_BD_MASK           0x04000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_5_USE_NEXT_BD_DEFVAL         0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_5_VALID_BD_LSB               25
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_5_VALID_BD_WIDTH             1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_5_VALID_BD_MASK              0x02000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_5_VALID_BD_DEFVAL            0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_5_LOCK_REL_VALUE_LSB         18
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_5_LOCK_REL_VALUE_WIDTH       7
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_5_LOCK_REL_VALUE_MASK        0x01FC0000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_5_LOCK_REL_VALUE_DEFVAL      0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_5_LOCK_REL_ID_LSB            13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_5_LOCK_REL_ID_WIDTH          4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_5_LOCK_REL_ID_MASK           0x0001E000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_5_LOCK_REL_ID_DEFVAL         0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_5_LOCK_ACQ_ENABLE_LSB        12
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_5_LOCK_ACQ_ENABLE_WIDTH      1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_5_LOCK_ACQ_ENABLE_MASK       0x00001000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_5_LOCK_ACQ_ENABLE_DEFVAL     0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_5_LOCK_ACQ_VALUE_LSB         5
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_5_LOCK_ACQ_VALUE_WIDTH       7
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_5_LOCK_ACQ_VALUE_MASK        0x00000FE0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_5_LOCK_ACQ_VALUE_DEFVAL      0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_5_LOCK_ACQ_ID_LSB            0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_5_LOCK_ACQ_ID_WIDTH          4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_5_LOCK_ACQ_ID_MASK           0x0000000F
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD10_5_LOCK_ACQ_ID_DEFVAL         0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_0                              0x0001D160
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_0_WIDTH                        32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_0_MASK                         0x0FFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_0_BASE_ADDRESS_LSB           14
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_0_BASE_ADDRESS_WIDTH         14
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_0_BASE_ADDRESS_MASK          0x0FFFC000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_0_BASE_ADDRESS_DEFVAL        0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_0_BUFFER_LENGTH_LSB          0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_0_BUFFER_LENGTH_WIDTH        14
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_0_BUFFER_LENGTH_MASK         0x00003FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_0_BUFFER_LENGTH_DEFVAL       0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_1                              0x0001D164
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_1_WIDTH                        32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_1_MASK                         0xFFFF0000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_1_ENABLE_COMPRESSION_LSB     31
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_1_ENABLE_COMPRESSION_WIDTH   1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_1_ENABLE_COMPRESSION_MASK    0x80000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_1_ENABLE_COMPRESSION_DEFVAL  0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_1_ENABLE_PACKET_LSB          30
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_1_ENABLE_PACKET_WIDTH        1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_1_ENABLE_PACKET_MASK         0x40000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_1_ENABLE_PACKET_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_1_OUT_OF_ORDER_BD_ID_LSB     24
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_1_OUT_OF_ORDER_BD_ID_WIDTH   6
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_1_OUT_OF_ORDER_BD_ID_MASK    0x3F000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_1_OUT_OF_ORDER_BD_ID_DEFVAL  0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_1_PACKET_ID_LSB              19
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_1_PACKET_ID_WIDTH            5
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_1_PACKET_ID_MASK             0x00F80000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_1_PACKET_ID_DEFVAL           0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_1_PACKET_TYPE_LSB            16
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_1_PACKET_TYPE_WIDTH          3
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_1_PACKET_TYPE_MASK           0x00070000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_1_PACKET_TYPE_DEFVAL         0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_2                              0x0001D168
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_2_WIDTH                        32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_2_MASK                         0x03FFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_2_D1_STEPSIZE_LSB            13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_2_D1_STEPSIZE_WIDTH          13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_2_D1_STEPSIZE_MASK           0x03FFE000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_2_D1_STEPSIZE_DEFVAL         0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_2_D0_STEPSIZE_LSB            0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_2_D0_STEPSIZE_WIDTH          13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_2_D0_STEPSIZE_MASK           0x00001FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_2_D0_STEPSIZE_DEFVAL         0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_3                              0x0001D16C
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_3_WIDTH                        32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_3_MASK                         0x1FFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_3_D1_WRAP_LSB                21
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_3_D1_WRAP_WIDTH              8
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_3_D1_WRAP_MASK               0x1FE00000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_3_D1_WRAP_DEFVAL             0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_3_D0_WRAP_LSB                13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_3_D0_WRAP_WIDTH              8
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_3_D0_WRAP_MASK               0x001FE000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_3_D0_WRAP_DEFVAL             0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_3_D2_STEPSIZE_LSB            0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_3_D2_STEPSIZE_WIDTH          13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_3_D2_STEPSIZE_MASK           0x00001FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_3_D2_STEPSIZE_DEFVAL         0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_4                              0x0001D170
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_4_WIDTH                        32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_4_MASK                         0x01FFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_4_ITERATION_CURRENT_LSB      19
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_4_ITERATION_CURRENT_WIDTH    6
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_4_ITERATION_CURRENT_MASK     0x01F80000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_4_ITERATION_CURRENT_DEFVAL   0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_4_ITERATION_WRAP_LSB         13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_4_ITERATION_WRAP_WIDTH       6
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_4_ITERATION_WRAP_MASK        0x0007E000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_4_ITERATION_WRAP_DEFVAL      0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_4_ITERATION_STEPSIZE_LSB     0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_4_ITERATION_STEPSIZE_WIDTH   13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_4_ITERATION_STEPSIZE_MASK    0x00001FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_4_ITERATION_STEPSIZE_DEFVAL  0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_5                              0x0001D174
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_5_WIDTH                        32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_5_MASK                         0xFFFDFFEF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_5_TLAST_SUPPRESS_LSB         31
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_5_TLAST_SUPPRESS_WIDTH       1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_5_TLAST_SUPPRESS_MASK        0x80000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_5_TLAST_SUPPRESS_DEFVAL      0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_5_NEXT_BD_LSB                27
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_5_NEXT_BD_WIDTH              4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_5_NEXT_BD_MASK               0x78000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_5_NEXT_BD_DEFVAL             0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_5_USE_NEXT_BD_LSB            26
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_5_USE_NEXT_BD_WIDTH          1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_5_USE_NEXT_BD_MASK           0x04000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_5_USE_NEXT_BD_DEFVAL         0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_5_VALID_BD_LSB               25
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_5_VALID_BD_WIDTH             1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_5_VALID_BD_MASK              0x02000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_5_VALID_BD_DEFVAL            0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_5_LOCK_REL_VALUE_LSB         18
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_5_LOCK_REL_VALUE_WIDTH       7
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_5_LOCK_REL_VALUE_MASK        0x01FC0000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_5_LOCK_REL_VALUE_DEFVAL      0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_5_LOCK_REL_ID_LSB            13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_5_LOCK_REL_ID_WIDTH          4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_5_LOCK_REL_ID_MASK           0x0001E000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_5_LOCK_REL_ID_DEFVAL         0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_5_LOCK_ACQ_ENABLE_LSB        12
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_5_LOCK_ACQ_ENABLE_WIDTH      1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_5_LOCK_ACQ_ENABLE_MASK       0x00001000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_5_LOCK_ACQ_ENABLE_DEFVAL     0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_5_LOCK_ACQ_VALUE_LSB         5
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_5_LOCK_ACQ_VALUE_WIDTH       7
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_5_LOCK_ACQ_VALUE_MASK        0x00000FE0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_5_LOCK_ACQ_VALUE_DEFVAL      0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_5_LOCK_ACQ_ID_LSB            0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_5_LOCK_ACQ_ID_WIDTH          4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_5_LOCK_ACQ_ID_MASK           0x0000000F
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD11_5_LOCK_ACQ_ID_DEFVAL         0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_0                              0x0001D180
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_0_WIDTH                        32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_0_MASK                         0x0FFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_0_BASE_ADDRESS_LSB           14
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_0_BASE_ADDRESS_WIDTH         14
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_0_BASE_ADDRESS_MASK          0x0FFFC000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_0_BASE_ADDRESS_DEFVAL        0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_0_BUFFER_LENGTH_LSB          0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_0_BUFFER_LENGTH_WIDTH        14
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_0_BUFFER_LENGTH_MASK         0x00003FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_0_BUFFER_LENGTH_DEFVAL       0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_1                              0x0001D184
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_1_WIDTH                        32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_1_MASK                         0xFFFF0000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_1_ENABLE_COMPRESSION_LSB     31
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_1_ENABLE_COMPRESSION_WIDTH   1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_1_ENABLE_COMPRESSION_MASK    0x80000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_1_ENABLE_COMPRESSION_DEFVAL  0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_1_ENABLE_PACKET_LSB          30
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_1_ENABLE_PACKET_WIDTH        1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_1_ENABLE_PACKET_MASK         0x40000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_1_ENABLE_PACKET_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_1_OUT_OF_ORDER_BD_ID_LSB     24
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_1_OUT_OF_ORDER_BD_ID_WIDTH   6
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_1_OUT_OF_ORDER_BD_ID_MASK    0x3F000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_1_OUT_OF_ORDER_BD_ID_DEFVAL  0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_1_PACKET_ID_LSB              19
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_1_PACKET_ID_WIDTH            5
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_1_PACKET_ID_MASK             0x00F80000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_1_PACKET_ID_DEFVAL           0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_1_PACKET_TYPE_LSB            16
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_1_PACKET_TYPE_WIDTH          3
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_1_PACKET_TYPE_MASK           0x00070000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_1_PACKET_TYPE_DEFVAL         0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_2                              0x0001D188
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_2_WIDTH                        32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_2_MASK                         0x03FFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_2_D1_STEPSIZE_LSB            13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_2_D1_STEPSIZE_WIDTH          13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_2_D1_STEPSIZE_MASK           0x03FFE000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_2_D1_STEPSIZE_DEFVAL         0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_2_D0_STEPSIZE_LSB            0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_2_D0_STEPSIZE_WIDTH          13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_2_D0_STEPSIZE_MASK           0x00001FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_2_D0_STEPSIZE_DEFVAL         0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_3                              0x0001D18C
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_3_WIDTH                        32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_3_MASK                         0x1FFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_3_D1_WRAP_LSB                21
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_3_D1_WRAP_WIDTH              8
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_3_D1_WRAP_MASK               0x1FE00000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_3_D1_WRAP_DEFVAL             0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_3_D0_WRAP_LSB                13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_3_D0_WRAP_WIDTH              8
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_3_D0_WRAP_MASK               0x001FE000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_3_D0_WRAP_DEFVAL             0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_3_D2_STEPSIZE_LSB            0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_3_D2_STEPSIZE_WIDTH          13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_3_D2_STEPSIZE_MASK           0x00001FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_3_D2_STEPSIZE_DEFVAL         0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_4                              0x0001D190
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_4_WIDTH                        32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_4_MASK                         0x01FFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_4_ITERATION_CURRENT_LSB      19
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_4_ITERATION_CURRENT_WIDTH    6
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_4_ITERATION_CURRENT_MASK     0x01F80000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_4_ITERATION_CURRENT_DEFVAL   0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_4_ITERATION_WRAP_LSB         13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_4_ITERATION_WRAP_WIDTH       6
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_4_ITERATION_WRAP_MASK        0x0007E000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_4_ITERATION_WRAP_DEFVAL      0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_4_ITERATION_STEPSIZE_LSB     0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_4_ITERATION_STEPSIZE_WIDTH   13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_4_ITERATION_STEPSIZE_MASK    0x00001FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_4_ITERATION_STEPSIZE_DEFVAL  0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_5                              0x0001D194
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_5_WIDTH                        32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_5_MASK                         0xFFFDFFEF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_5_TLAST_SUPPRESS_LSB         31
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_5_TLAST_SUPPRESS_WIDTH       1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_5_TLAST_SUPPRESS_MASK        0x80000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_5_TLAST_SUPPRESS_DEFVAL      0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_5_NEXT_BD_LSB                27
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_5_NEXT_BD_WIDTH              4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_5_NEXT_BD_MASK               0x78000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_5_NEXT_BD_DEFVAL             0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_5_USE_NEXT_BD_LSB            26
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_5_USE_NEXT_BD_WIDTH          1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_5_USE_NEXT_BD_MASK           0x04000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_5_USE_NEXT_BD_DEFVAL         0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_5_VALID_BD_LSB               25
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_5_VALID_BD_WIDTH             1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_5_VALID_BD_MASK              0x02000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_5_VALID_BD_DEFVAL            0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_5_LOCK_REL_VALUE_LSB         18
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_5_LOCK_REL_VALUE_WIDTH       7
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_5_LOCK_REL_VALUE_MASK        0x01FC0000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_5_LOCK_REL_VALUE_DEFVAL      0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_5_LOCK_REL_ID_LSB            13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_5_LOCK_REL_ID_WIDTH          4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_5_LOCK_REL_ID_MASK           0x0001E000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_5_LOCK_REL_ID_DEFVAL         0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_5_LOCK_ACQ_ENABLE_LSB        12
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_5_LOCK_ACQ_ENABLE_WIDTH      1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_5_LOCK_ACQ_ENABLE_MASK       0x00001000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_5_LOCK_ACQ_ENABLE_DEFVAL     0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_5_LOCK_ACQ_VALUE_LSB         5
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_5_LOCK_ACQ_VALUE_WIDTH       7
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_5_LOCK_ACQ_VALUE_MASK        0x00000FE0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_5_LOCK_ACQ_VALUE_DEFVAL      0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_5_LOCK_ACQ_ID_LSB            0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_5_LOCK_ACQ_ID_WIDTH          4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_5_LOCK_ACQ_ID_MASK           0x0000000F
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD12_5_LOCK_ACQ_ID_DEFVAL         0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_0                              0x0001D1A0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_0_WIDTH                        32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_0_MASK                         0x0FFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_0_BASE_ADDRESS_LSB           14
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_0_BASE_ADDRESS_WIDTH         14
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_0_BASE_ADDRESS_MASK          0x0FFFC000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_0_BASE_ADDRESS_DEFVAL        0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_0_BUFFER_LENGTH_LSB          0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_0_BUFFER_LENGTH_WIDTH        14
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_0_BUFFER_LENGTH_MASK         0x00003FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_0_BUFFER_LENGTH_DEFVAL       0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_1                              0x0001D1A4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_1_WIDTH                        32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_1_MASK                         0xFFFF0000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_1_ENABLE_COMPRESSION_LSB     31
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_1_ENABLE_COMPRESSION_WIDTH   1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_1_ENABLE_COMPRESSION_MASK    0x80000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_1_ENABLE_COMPRESSION_DEFVAL  0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_1_ENABLE_PACKET_LSB          30
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_1_ENABLE_PACKET_WIDTH        1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_1_ENABLE_PACKET_MASK         0x40000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_1_ENABLE_PACKET_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_1_OUT_OF_ORDER_BD_ID_LSB     24
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_1_OUT_OF_ORDER_BD_ID_WIDTH   6
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_1_OUT_OF_ORDER_BD_ID_MASK    0x3F000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_1_OUT_OF_ORDER_BD_ID_DEFVAL  0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_1_PACKET_ID_LSB              19
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_1_PACKET_ID_WIDTH            5
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_1_PACKET_ID_MASK             0x00F80000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_1_PACKET_ID_DEFVAL           0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_1_PACKET_TYPE_LSB            16
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_1_PACKET_TYPE_WIDTH          3
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_1_PACKET_TYPE_MASK           0x00070000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_1_PACKET_TYPE_DEFVAL         0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_2                              0x0001D1A8
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_2_WIDTH                        32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_2_MASK                         0x03FFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_2_D1_STEPSIZE_LSB            13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_2_D1_STEPSIZE_WIDTH          13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_2_D1_STEPSIZE_MASK           0x03FFE000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_2_D1_STEPSIZE_DEFVAL         0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_2_D0_STEPSIZE_LSB            0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_2_D0_STEPSIZE_WIDTH          13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_2_D0_STEPSIZE_MASK           0x00001FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_2_D0_STEPSIZE_DEFVAL         0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_3                              0x0001D1AC
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_3_WIDTH                        32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_3_MASK                         0x1FFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_3_D1_WRAP_LSB                21
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_3_D1_WRAP_WIDTH              8
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_3_D1_WRAP_MASK               0x1FE00000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_3_D1_WRAP_DEFVAL             0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_3_D0_WRAP_LSB                13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_3_D0_WRAP_WIDTH              8
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_3_D0_WRAP_MASK               0x001FE000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_3_D0_WRAP_DEFVAL             0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_3_D2_STEPSIZE_LSB            0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_3_D2_STEPSIZE_WIDTH          13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_3_D2_STEPSIZE_MASK           0x00001FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_3_D2_STEPSIZE_DEFVAL         0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_4                              0x0001D1B0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_4_WIDTH                        32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_4_MASK                         0x01FFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_4_ITERATION_CURRENT_LSB      19
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_4_ITERATION_CURRENT_WIDTH    6
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_4_ITERATION_CURRENT_MASK     0x01F80000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_4_ITERATION_CURRENT_DEFVAL   0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_4_ITERATION_WRAP_LSB         13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_4_ITERATION_WRAP_WIDTH       6
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_4_ITERATION_WRAP_MASK        0x0007E000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_4_ITERATION_WRAP_DEFVAL      0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_4_ITERATION_STEPSIZE_LSB     0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_4_ITERATION_STEPSIZE_WIDTH   13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_4_ITERATION_STEPSIZE_MASK    0x00001FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_4_ITERATION_STEPSIZE_DEFVAL  0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_5                              0x0001D1B4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_5_WIDTH                        32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_5_MASK                         0xFFFDFFEF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_5_TLAST_SUPPRESS_LSB         31
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_5_TLAST_SUPPRESS_WIDTH       1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_5_TLAST_SUPPRESS_MASK        0x80000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_5_TLAST_SUPPRESS_DEFVAL      0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_5_NEXT_BD_LSB                27
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_5_NEXT_BD_WIDTH              4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_5_NEXT_BD_MASK               0x78000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_5_NEXT_BD_DEFVAL             0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_5_USE_NEXT_BD_LSB            26
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_5_USE_NEXT_BD_WIDTH          1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_5_USE_NEXT_BD_MASK           0x04000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_5_USE_NEXT_BD_DEFVAL         0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_5_VALID_BD_LSB               25
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_5_VALID_BD_WIDTH             1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_5_VALID_BD_MASK              0x02000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_5_VALID_BD_DEFVAL            0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_5_LOCK_REL_VALUE_LSB         18
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_5_LOCK_REL_VALUE_WIDTH       7
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_5_LOCK_REL_VALUE_MASK        0x01FC0000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_5_LOCK_REL_VALUE_DEFVAL      0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_5_LOCK_REL_ID_LSB            13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_5_LOCK_REL_ID_WIDTH          4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_5_LOCK_REL_ID_MASK           0x0001E000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_5_LOCK_REL_ID_DEFVAL         0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_5_LOCK_ACQ_ENABLE_LSB        12
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_5_LOCK_ACQ_ENABLE_WIDTH      1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_5_LOCK_ACQ_ENABLE_MASK       0x00001000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_5_LOCK_ACQ_ENABLE_DEFVAL     0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_5_LOCK_ACQ_VALUE_LSB         5
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_5_LOCK_ACQ_VALUE_WIDTH       7
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_5_LOCK_ACQ_VALUE_MASK        0x00000FE0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_5_LOCK_ACQ_VALUE_DEFVAL      0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_5_LOCK_ACQ_ID_LSB            0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_5_LOCK_ACQ_ID_WIDTH          4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_5_LOCK_ACQ_ID_MASK           0x0000000F
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD13_5_LOCK_ACQ_ID_DEFVAL         0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_0                              0x0001D1C0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_0_WIDTH                        32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_0_MASK                         0x0FFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_0_BASE_ADDRESS_LSB           14
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_0_BASE_ADDRESS_WIDTH         14
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_0_BASE_ADDRESS_MASK          0x0FFFC000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_0_BASE_ADDRESS_DEFVAL        0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_0_BUFFER_LENGTH_LSB          0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_0_BUFFER_LENGTH_WIDTH        14
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_0_BUFFER_LENGTH_MASK         0x00003FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_0_BUFFER_LENGTH_DEFVAL       0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_1                              0x0001D1C4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_1_WIDTH                        32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_1_MASK                         0xFFFF0000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_1_ENABLE_COMPRESSION_LSB     31
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_1_ENABLE_COMPRESSION_WIDTH   1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_1_ENABLE_COMPRESSION_MASK    0x80000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_1_ENABLE_COMPRESSION_DEFVAL  0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_1_ENABLE_PACKET_LSB          30
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_1_ENABLE_PACKET_WIDTH        1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_1_ENABLE_PACKET_MASK         0x40000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_1_ENABLE_PACKET_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_1_OUT_OF_ORDER_BD_ID_LSB     24
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_1_OUT_OF_ORDER_BD_ID_WIDTH   6
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_1_OUT_OF_ORDER_BD_ID_MASK    0x3F000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_1_OUT_OF_ORDER_BD_ID_DEFVAL  0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_1_PACKET_ID_LSB              19
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_1_PACKET_ID_WIDTH            5
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_1_PACKET_ID_MASK             0x00F80000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_1_PACKET_ID_DEFVAL           0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_1_PACKET_TYPE_LSB            16
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_1_PACKET_TYPE_WIDTH          3
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_1_PACKET_TYPE_MASK           0x00070000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_1_PACKET_TYPE_DEFVAL         0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_2                              0x0001D1C8
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_2_WIDTH                        32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_2_MASK                         0x03FFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_2_D1_STEPSIZE_LSB            13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_2_D1_STEPSIZE_WIDTH          13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_2_D1_STEPSIZE_MASK           0x03FFE000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_2_D1_STEPSIZE_DEFVAL         0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_2_D0_STEPSIZE_LSB            0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_2_D0_STEPSIZE_WIDTH          13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_2_D0_STEPSIZE_MASK           0x00001FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_2_D0_STEPSIZE_DEFVAL         0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_3                              0x0001D1CC
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_3_WIDTH                        32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_3_MASK                         0x1FFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_3_D1_WRAP_LSB                21
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_3_D1_WRAP_WIDTH              8
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_3_D1_WRAP_MASK               0x1FE00000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_3_D1_WRAP_DEFVAL             0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_3_D0_WRAP_LSB                13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_3_D0_WRAP_WIDTH              8
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_3_D0_WRAP_MASK               0x001FE000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_3_D0_WRAP_DEFVAL             0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_3_D2_STEPSIZE_LSB            0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_3_D2_STEPSIZE_WIDTH          13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_3_D2_STEPSIZE_MASK           0x00001FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_3_D2_STEPSIZE_DEFVAL         0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_4                              0x0001D1D0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_4_WIDTH                        32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_4_MASK                         0x01FFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_4_ITERATION_CURRENT_LSB      19
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_4_ITERATION_CURRENT_WIDTH    6
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_4_ITERATION_CURRENT_MASK     0x01F80000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_4_ITERATION_CURRENT_DEFVAL   0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_4_ITERATION_WRAP_LSB         13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_4_ITERATION_WRAP_WIDTH       6
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_4_ITERATION_WRAP_MASK        0x0007E000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_4_ITERATION_WRAP_DEFVAL      0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_4_ITERATION_STEPSIZE_LSB     0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_4_ITERATION_STEPSIZE_WIDTH   13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_4_ITERATION_STEPSIZE_MASK    0x00001FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_4_ITERATION_STEPSIZE_DEFVAL  0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_5                              0x0001D1D4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_5_WIDTH                        32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_5_MASK                         0xFFFDFFEF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_5_TLAST_SUPPRESS_LSB         31
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_5_TLAST_SUPPRESS_WIDTH       1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_5_TLAST_SUPPRESS_MASK        0x80000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_5_TLAST_SUPPRESS_DEFVAL      0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_5_NEXT_BD_LSB                27
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_5_NEXT_BD_WIDTH              4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_5_NEXT_BD_MASK               0x78000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_5_NEXT_BD_DEFVAL             0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_5_USE_NEXT_BD_LSB            26
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_5_USE_NEXT_BD_WIDTH          1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_5_USE_NEXT_BD_MASK           0x04000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_5_USE_NEXT_BD_DEFVAL         0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_5_VALID_BD_LSB               25
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_5_VALID_BD_WIDTH             1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_5_VALID_BD_MASK              0x02000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_5_VALID_BD_DEFVAL            0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_5_LOCK_REL_VALUE_LSB         18
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_5_LOCK_REL_VALUE_WIDTH       7
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_5_LOCK_REL_VALUE_MASK        0x01FC0000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_5_LOCK_REL_VALUE_DEFVAL      0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_5_LOCK_REL_ID_LSB            13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_5_LOCK_REL_ID_WIDTH          4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_5_LOCK_REL_ID_MASK           0x0001E000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_5_LOCK_REL_ID_DEFVAL         0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_5_LOCK_ACQ_ENABLE_LSB        12
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_5_LOCK_ACQ_ENABLE_WIDTH      1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_5_LOCK_ACQ_ENABLE_MASK       0x00001000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_5_LOCK_ACQ_ENABLE_DEFVAL     0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_5_LOCK_ACQ_VALUE_LSB         5
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_5_LOCK_ACQ_VALUE_WIDTH       7
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_5_LOCK_ACQ_VALUE_MASK        0x00000FE0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_5_LOCK_ACQ_VALUE_DEFVAL      0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_5_LOCK_ACQ_ID_LSB            0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_5_LOCK_ACQ_ID_WIDTH          4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_5_LOCK_ACQ_ID_MASK           0x0000000F
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD14_5_LOCK_ACQ_ID_DEFVAL         0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_0                              0x0001D1E0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_0_WIDTH                        32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_0_MASK                         0x0FFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_0_BASE_ADDRESS_LSB           14
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_0_BASE_ADDRESS_WIDTH         14
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_0_BASE_ADDRESS_MASK          0x0FFFC000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_0_BASE_ADDRESS_DEFVAL        0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_0_BUFFER_LENGTH_LSB          0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_0_BUFFER_LENGTH_WIDTH        14
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_0_BUFFER_LENGTH_MASK         0x00003FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_0_BUFFER_LENGTH_DEFVAL       0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_1                              0x0001D1E4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_1_WIDTH                        32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_1_MASK                         0xFFFF0000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_1_ENABLE_COMPRESSION_LSB     31
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_1_ENABLE_COMPRESSION_WIDTH   1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_1_ENABLE_COMPRESSION_MASK    0x80000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_1_ENABLE_COMPRESSION_DEFVAL  0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_1_ENABLE_PACKET_LSB          30
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_1_ENABLE_PACKET_WIDTH        1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_1_ENABLE_PACKET_MASK         0x40000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_1_ENABLE_PACKET_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_1_OUT_OF_ORDER_BD_ID_LSB     24
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_1_OUT_OF_ORDER_BD_ID_WIDTH   6
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_1_OUT_OF_ORDER_BD_ID_MASK    0x3F000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_1_OUT_OF_ORDER_BD_ID_DEFVAL  0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_1_PACKET_ID_LSB              19
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_1_PACKET_ID_WIDTH            5
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_1_PACKET_ID_MASK             0x00F80000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_1_PACKET_ID_DEFVAL           0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_1_PACKET_TYPE_LSB            16
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_1_PACKET_TYPE_WIDTH          3
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_1_PACKET_TYPE_MASK           0x00070000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_1_PACKET_TYPE_DEFVAL         0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_2                              0x0001D1E8
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_2_WIDTH                        32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_2_MASK                         0x03FFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_2_D1_STEPSIZE_LSB            13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_2_D1_STEPSIZE_WIDTH          13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_2_D1_STEPSIZE_MASK           0x03FFE000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_2_D1_STEPSIZE_DEFVAL         0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_2_D0_STEPSIZE_LSB            0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_2_D0_STEPSIZE_WIDTH          13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_2_D0_STEPSIZE_MASK           0x00001FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_2_D0_STEPSIZE_DEFVAL         0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_3                              0x0001D1EC
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_3_WIDTH                        32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_3_MASK                         0x1FFFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_3_D1_WRAP_LSB                21
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_3_D1_WRAP_WIDTH              8
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_3_D1_WRAP_MASK               0x1FE00000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_3_D1_WRAP_DEFVAL             0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_3_D0_WRAP_LSB                13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_3_D0_WRAP_WIDTH              8
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_3_D0_WRAP_MASK               0x001FE000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_3_D0_WRAP_DEFVAL             0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_3_D2_STEPSIZE_LSB            0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_3_D2_STEPSIZE_WIDTH          13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_3_D2_STEPSIZE_MASK           0x00001FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_3_D2_STEPSIZE_DEFVAL         0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_4                              0x0001D1F0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_4_WIDTH                        32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_4_MASK                         0x01FFFFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_4_ITERATION_CURRENT_LSB      19
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_4_ITERATION_CURRENT_WIDTH    6
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_4_ITERATION_CURRENT_MASK     0x01F80000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_4_ITERATION_CURRENT_DEFVAL   0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_4_ITERATION_WRAP_LSB         13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_4_ITERATION_WRAP_WIDTH       6
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_4_ITERATION_WRAP_MASK        0x0007E000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_4_ITERATION_WRAP_DEFVAL      0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_4_ITERATION_STEPSIZE_LSB     0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_4_ITERATION_STEPSIZE_WIDTH   13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_4_ITERATION_STEPSIZE_MASK    0x00001FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_4_ITERATION_STEPSIZE_DEFVAL  0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_5                              0x0001D1F4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_5_WIDTH                        32
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_5_MASK                         0xFFFDFFEF
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_5_TLAST_SUPPRESS_LSB         31
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_5_TLAST_SUPPRESS_WIDTH       1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_5_TLAST_SUPPRESS_MASK        0x80000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_5_TLAST_SUPPRESS_DEFVAL      0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_5_NEXT_BD_LSB                27
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_5_NEXT_BD_WIDTH              4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_5_NEXT_BD_MASK               0x78000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_5_NEXT_BD_DEFVAL             0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_5_USE_NEXT_BD_LSB            26
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_5_USE_NEXT_BD_WIDTH          1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_5_USE_NEXT_BD_MASK           0x04000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_5_USE_NEXT_BD_DEFVAL         0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_5_VALID_BD_LSB               25
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_5_VALID_BD_WIDTH             1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_5_VALID_BD_MASK              0x02000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_5_VALID_BD_DEFVAL            0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_5_LOCK_REL_VALUE_LSB         18
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_5_LOCK_REL_VALUE_WIDTH       7
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_5_LOCK_REL_VALUE_MASK        0x01FC0000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_5_LOCK_REL_VALUE_DEFVAL      0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_5_LOCK_REL_ID_LSB            13
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_5_LOCK_REL_ID_WIDTH          4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_5_LOCK_REL_ID_MASK           0x0001E000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_5_LOCK_REL_ID_DEFVAL         0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_5_LOCK_ACQ_ENABLE_LSB        12
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_5_LOCK_ACQ_ENABLE_WIDTH      1
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_5_LOCK_ACQ_ENABLE_MASK       0x00001000
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_5_LOCK_ACQ_ENABLE_DEFVAL     0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_5_LOCK_ACQ_VALUE_LSB         5
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_5_LOCK_ACQ_VALUE_WIDTH       7
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_5_LOCK_ACQ_VALUE_MASK        0x00000FE0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_5_LOCK_ACQ_VALUE_DEFVAL      0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_5_LOCK_ACQ_ID_LSB            0
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_5_LOCK_ACQ_ID_WIDTH          4
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_5_LOCK_ACQ_ID_MASK           0x0000000F
#define XAIE2PGBL_MEMORY_MODULE_DMA_BD15_5_LOCK_ACQ_ID_DEFVAL         0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_0_CTRL                         0x0001DE00
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_0_CTRL_WIDTH                   32
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_0_CTRL_MASK                    0x0003FF1B
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_0_CTRL_FOT_MODE_LSB          16
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_0_CTRL_FOT_MODE_WIDTH        2
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_0_CTRL_FOT_MODE_MASK         0x00030000
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_0_CTRL_FOT_MODE_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_0_CTRL_CONTROLLER_ID_LSB     8
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_0_CTRL_CONTROLLER_ID_WIDTH   8
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_0_CTRL_CONTROLLER_ID_MASK    0x0000FF00
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_0_CTRL_CONTROLLER_ID_DEFVAL  0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_0_CTRL_DECOMPRESSION_ENABLE_LSB 4
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_0_CTRL_DECOMPRESSION_ENABLE_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_0_CTRL_DECOMPRESSION_ENABLE_MASK 0x00000010
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_0_CTRL_DECOMPRESSION_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_0_CTRL_ENABLE_OUT_OF_ORDER_LSB 3
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_0_CTRL_ENABLE_OUT_OF_ORDER_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_0_CTRL_ENABLE_OUT_OF_ORDER_MASK 0x00000008
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_0_CTRL_ENABLE_OUT_OF_ORDER_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_0_CTRL_RESET_LSB             1
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_0_CTRL_RESET_WIDTH           1
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_0_CTRL_RESET_MASK            0x00000002
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_0_CTRL_RESET_DEFVAL          0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_0_START_QUEUE                  0x0001DE04
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_0_START_QUEUE_WIDTH            32
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_0_START_QUEUE_MASK             0x80FF000F
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_0_START_QUEUE_ENABLE_TOKEN_ISSUE_LSB 31
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_0_START_QUEUE_ENABLE_TOKEN_ISSUE_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_0_START_QUEUE_ENABLE_TOKEN_ISSUE_MASK 0x80000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_0_START_QUEUE_ENABLE_TOKEN_ISSUE_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_0_START_QUEUE_REPEAT_COUNT_LSB 16
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_0_START_QUEUE_REPEAT_COUNT_WIDTH 8
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_0_START_QUEUE_REPEAT_COUNT_MASK 0x00FF0000
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_0_START_QUEUE_REPEAT_COUNT_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_0_START_QUEUE_START_BD_ID_LSB 0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_0_START_QUEUE_START_BD_ID_WIDTH 4
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_0_START_QUEUE_START_BD_ID_MASK 0x0000000F
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_0_START_QUEUE_START_BD_ID_DEFVAL 0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_1_CTRL                         0x0001DE08
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_1_CTRL_WIDTH                   32
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_1_CTRL_MASK                    0x0003FF1B
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_1_CTRL_FOT_MODE_LSB          16
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_1_CTRL_FOT_MODE_WIDTH        2
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_1_CTRL_FOT_MODE_MASK         0x00030000
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_1_CTRL_FOT_MODE_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_1_CTRL_CONTROLLER_ID_LSB     8
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_1_CTRL_CONTROLLER_ID_WIDTH   8
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_1_CTRL_CONTROLLER_ID_MASK    0x0000FF00
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_1_CTRL_CONTROLLER_ID_DEFVAL  0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_1_CTRL_DECOMPRESSION_ENABLE_LSB 4
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_1_CTRL_DECOMPRESSION_ENABLE_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_1_CTRL_DECOMPRESSION_ENABLE_MASK 0x00000010
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_1_CTRL_DECOMPRESSION_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_1_CTRL_ENABLE_OUT_OF_ORDER_LSB 3
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_1_CTRL_ENABLE_OUT_OF_ORDER_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_1_CTRL_ENABLE_OUT_OF_ORDER_MASK 0x00000008
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_1_CTRL_ENABLE_OUT_OF_ORDER_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_1_CTRL_RESET_LSB             1
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_1_CTRL_RESET_WIDTH           1
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_1_CTRL_RESET_MASK            0x00000002
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_1_CTRL_RESET_DEFVAL          0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_1_START_QUEUE                  0x0001DE0C
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_1_START_QUEUE_WIDTH            32
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_1_START_QUEUE_MASK             0x80FF000F
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_1_START_QUEUE_ENABLE_TOKEN_ISSUE_LSB 31
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_1_START_QUEUE_ENABLE_TOKEN_ISSUE_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_1_START_QUEUE_ENABLE_TOKEN_ISSUE_MASK 0x80000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_1_START_QUEUE_ENABLE_TOKEN_ISSUE_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_1_START_QUEUE_REPEAT_COUNT_LSB 16
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_1_START_QUEUE_REPEAT_COUNT_WIDTH 8
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_1_START_QUEUE_REPEAT_COUNT_MASK 0x00FF0000
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_1_START_QUEUE_REPEAT_COUNT_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_1_START_QUEUE_START_BD_ID_LSB 0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_1_START_QUEUE_START_BD_ID_WIDTH 4
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_1_START_QUEUE_START_BD_ID_MASK 0x0000000F
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_1_START_QUEUE_START_BD_ID_DEFVAL 0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_0_CTRL                         0x0001DE10
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_0_CTRL_WIDTH                   32
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_0_CTRL_MASK                    0x0000FF13
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_0_CTRL_CONTROLLER_ID_LSB     8
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_0_CTRL_CONTROLLER_ID_WIDTH   8
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_0_CTRL_CONTROLLER_ID_MASK    0x0000FF00
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_0_CTRL_CONTROLLER_ID_DEFVAL  0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_0_CTRL_COMPRESSION_ENABLE_LSB 4
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_0_CTRL_COMPRESSION_ENABLE_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_0_CTRL_COMPRESSION_ENABLE_MASK 0x00000010
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_0_CTRL_COMPRESSION_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_0_CTRL_RESET_LSB             1
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_0_CTRL_RESET_WIDTH           1
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_0_CTRL_RESET_MASK            0x00000002
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_0_CTRL_RESET_DEFVAL          0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_0_START_QUEUE                  0x0001DE14
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_0_START_QUEUE_WIDTH            32
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_0_START_QUEUE_MASK             0x80FF000F
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_0_START_QUEUE_ENABLE_TOKEN_ISSUE_LSB 31
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_0_START_QUEUE_ENABLE_TOKEN_ISSUE_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_0_START_QUEUE_ENABLE_TOKEN_ISSUE_MASK 0x80000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_0_START_QUEUE_ENABLE_TOKEN_ISSUE_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_0_START_QUEUE_REPEAT_COUNT_LSB 16
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_0_START_QUEUE_REPEAT_COUNT_WIDTH 8
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_0_START_QUEUE_REPEAT_COUNT_MASK 0x00FF0000
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_0_START_QUEUE_REPEAT_COUNT_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_0_START_QUEUE_START_BD_ID_LSB 0
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_0_START_QUEUE_START_BD_ID_WIDTH 4
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_0_START_QUEUE_START_BD_ID_MASK 0x0000000F
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_0_START_QUEUE_START_BD_ID_DEFVAL 0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_1_CTRL                         0x0001DE18
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_1_CTRL_WIDTH                   32
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_1_CTRL_MASK                    0x0000FF13
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_1_CTRL_CONTROLLER_ID_LSB     8
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_1_CTRL_CONTROLLER_ID_WIDTH   8
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_1_CTRL_CONTROLLER_ID_MASK    0x0000FF00
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_1_CTRL_CONTROLLER_ID_DEFVAL  0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_1_CTRL_COMPRESSION_ENABLE_LSB 4
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_1_CTRL_COMPRESSION_ENABLE_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_1_CTRL_COMPRESSION_ENABLE_MASK 0x00000010
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_1_CTRL_COMPRESSION_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_1_CTRL_RESET_LSB             1
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_1_CTRL_RESET_WIDTH           1
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_1_CTRL_RESET_MASK            0x00000002
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_1_CTRL_RESET_DEFVAL          0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_1_START_QUEUE                  0x0001DE1C
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_1_START_QUEUE_WIDTH            32
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_1_START_QUEUE_MASK             0x80FF000F
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_1_START_QUEUE_ENABLE_TOKEN_ISSUE_LSB 31
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_1_START_QUEUE_ENABLE_TOKEN_ISSUE_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_1_START_QUEUE_ENABLE_TOKEN_ISSUE_MASK 0x80000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_1_START_QUEUE_ENABLE_TOKEN_ISSUE_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_1_START_QUEUE_REPEAT_COUNT_LSB 16
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_1_START_QUEUE_REPEAT_COUNT_WIDTH 8
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_1_START_QUEUE_REPEAT_COUNT_MASK 0x00FF0000
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_1_START_QUEUE_REPEAT_COUNT_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_1_START_QUEUE_START_BD_ID_LSB 0
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_1_START_QUEUE_START_BD_ID_WIDTH 4
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_1_START_QUEUE_START_BD_ID_MASK 0x0000000F
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_1_START_QUEUE_START_BD_ID_DEFVAL 0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0                       0x0001DF00
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_WIDTH                 32
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_MASK                  0x0F7C3C3F
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_CUR_BD_LSB          24
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_CUR_BD_WIDTH        4
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_CUR_BD_MASK         0x0F000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_CUR_BD_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_TASK_QUEUE_SIZE_LSB 20
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_TASK_QUEUE_SIZE_WIDTH 3
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_TASK_QUEUE_SIZE_MASK 0x00700000
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_TASK_QUEUE_SIZE_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_CHANNEL_RUNNING_LSB 19
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_CHANNEL_RUNNING_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_CHANNEL_RUNNING_MASK 0x00080000
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_CHANNEL_RUNNING_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_TASK_QUEUE_OVERFLOW_LSB 18
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_TASK_QUEUE_OVERFLOW_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_TASK_QUEUE_OVERFLOW_MASK 0x00040000
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_TASK_QUEUE_OVERFLOW_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_ERROR_FOT_BDS_PER_TASK_LSB 13
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_ERROR_FOT_BDS_PER_TASK_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_ERROR_FOT_BDS_PER_TASK_MASK 0x00002000
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_ERROR_FOT_BDS_PER_TASK_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_ERROR_FOT_LENGTH_EXCEEDED_LSB 12
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_ERROR_FOT_LENGTH_EXCEEDED_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_ERROR_FOT_LENGTH_EXCEEDED_MASK 0x00001000
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_ERROR_FOT_LENGTH_EXCEEDED_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_ERROR_BD_INVALID_LSB 11
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_ERROR_BD_INVALID_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_ERROR_BD_INVALID_MASK 0x00000800
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_ERROR_BD_INVALID_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_ERROR_BD_UNAVAILABLE_LSB 10
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_ERROR_BD_UNAVAILABLE_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_ERROR_BD_UNAVAILABLE_MASK 0x00000400
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_ERROR_BD_UNAVAILABLE_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_STALLED_TCT_OR_COUNT_FIFO_FULL_LSB 5
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_STALLED_TCT_OR_COUNT_FIFO_FULL_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_STALLED_TCT_OR_COUNT_FIFO_FULL_MASK 0x00000020
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_STALLED_TCT_OR_COUNT_FIFO_FULL_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_STALLED_STREAM_STARVATION_LSB 4
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_STALLED_STREAM_STARVATION_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_STALLED_STREAM_STARVATION_MASK 0x00000010
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_STALLED_STREAM_STARVATION_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_STALLED_LOCK_REL_LSB 3
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_STALLED_LOCK_REL_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_STALLED_LOCK_REL_MASK 0x00000008
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_STALLED_LOCK_REL_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_STALLED_LOCK_ACQ_LSB 2
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_STALLED_LOCK_ACQ_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_STALLED_LOCK_ACQ_MASK 0x00000004
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_STALLED_LOCK_ACQ_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_STATUS_LSB          0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_STATUS_WIDTH        2
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_STATUS_MASK         0x00000003
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_0_STATUS_DEFVAL       0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1                       0x0001DF04
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_WIDTH                 32
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_MASK                  0x0F7C3C3F
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_CUR_BD_LSB          24
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_CUR_BD_WIDTH        4
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_CUR_BD_MASK         0x0F000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_CUR_BD_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_TASK_QUEUE_SIZE_LSB 20
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_TASK_QUEUE_SIZE_WIDTH 3
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_TASK_QUEUE_SIZE_MASK 0x00700000
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_TASK_QUEUE_SIZE_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_CHANNEL_RUNNING_LSB 19
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_CHANNEL_RUNNING_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_CHANNEL_RUNNING_MASK 0x00080000
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_CHANNEL_RUNNING_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_TASK_QUEUE_OVERFLOW_LSB 18
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_TASK_QUEUE_OVERFLOW_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_TASK_QUEUE_OVERFLOW_MASK 0x00040000
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_TASK_QUEUE_OVERFLOW_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_ERROR_FOT_BDS_PER_TASK_LSB 13
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_ERROR_FOT_BDS_PER_TASK_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_ERROR_FOT_BDS_PER_TASK_MASK 0x00002000
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_ERROR_FOT_BDS_PER_TASK_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_ERROR_FOT_LENGTH_EXCEEDED_LSB 12
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_ERROR_FOT_LENGTH_EXCEEDED_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_ERROR_FOT_LENGTH_EXCEEDED_MASK 0x00001000
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_ERROR_FOT_LENGTH_EXCEEDED_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_ERROR_BD_INVALID_LSB 11
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_ERROR_BD_INVALID_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_ERROR_BD_INVALID_MASK 0x00000800
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_ERROR_BD_INVALID_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_ERROR_BD_UNAVAILABLE_LSB 10
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_ERROR_BD_UNAVAILABLE_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_ERROR_BD_UNAVAILABLE_MASK 0x00000400
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_ERROR_BD_UNAVAILABLE_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_STALLED_TCT_OR_COUNT_FIFO_FULL_LSB 5
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_STALLED_TCT_OR_COUNT_FIFO_FULL_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_STALLED_TCT_OR_COUNT_FIFO_FULL_MASK 0x00000020
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_STALLED_TCT_OR_COUNT_FIFO_FULL_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_STALLED_STREAM_STARVATION_LSB 4
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_STALLED_STREAM_STARVATION_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_STALLED_STREAM_STARVATION_MASK 0x00000010
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_STALLED_STREAM_STARVATION_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_STALLED_LOCK_REL_LSB 3
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_STALLED_LOCK_REL_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_STALLED_LOCK_REL_MASK 0x00000008
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_STALLED_LOCK_REL_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_STALLED_LOCK_ACQ_LSB 2
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_STALLED_LOCK_ACQ_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_STALLED_LOCK_ACQ_MASK 0x00000004
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_STALLED_LOCK_ACQ_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_STATUS_LSB          0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_STATUS_WIDTH        2
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_STATUS_MASK         0x00000003
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_STATUS_1_STATUS_DEFVAL       0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_0                       0x0001DF10
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_0_WIDTH                 32
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_0_MASK                  0x0F7C083F
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_0_CUR_BD_LSB          24
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_0_CUR_BD_WIDTH        4
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_0_CUR_BD_MASK         0x0F000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_0_CUR_BD_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_0_TASK_QUEUE_SIZE_LSB 20
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_0_TASK_QUEUE_SIZE_WIDTH 3
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_0_TASK_QUEUE_SIZE_MASK 0x00700000
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_0_TASK_QUEUE_SIZE_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_0_CHANNEL_RUNNING_LSB 19
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_0_CHANNEL_RUNNING_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_0_CHANNEL_RUNNING_MASK 0x00080000
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_0_CHANNEL_RUNNING_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_0_TASK_QUEUE_OVERFLOW_LSB 18
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_0_TASK_QUEUE_OVERFLOW_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_0_TASK_QUEUE_OVERFLOW_MASK 0x00040000
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_0_TASK_QUEUE_OVERFLOW_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_0_ERROR_BD_INVALID_LSB 11
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_0_ERROR_BD_INVALID_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_0_ERROR_BD_INVALID_MASK 0x00000800
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_0_ERROR_BD_INVALID_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_0_STALLED_TCT_LSB     5
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_0_STALLED_TCT_WIDTH   1
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_0_STALLED_TCT_MASK    0x00000020
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_0_STALLED_TCT_DEFVAL  0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_0_STALLED_STREAM_BACKPRESSURE_LSB 4
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_0_STALLED_STREAM_BACKPRESSURE_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_0_STALLED_STREAM_BACKPRESSURE_MASK 0x00000010
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_0_STALLED_STREAM_BACKPRESSURE_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_0_STALLED_LOCK_REL_LSB 3
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_0_STALLED_LOCK_REL_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_0_STALLED_LOCK_REL_MASK 0x00000008
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_0_STALLED_LOCK_REL_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_0_STALLED_LOCK_ACQ_LSB 2
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_0_STALLED_LOCK_ACQ_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_0_STALLED_LOCK_ACQ_MASK 0x00000004
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_0_STALLED_LOCK_ACQ_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_0_STATUS_LSB          0
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_0_STATUS_WIDTH        2
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_0_STATUS_MASK         0x00000003
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_0_STATUS_DEFVAL       0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_1                       0x0001DF14
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_1_WIDTH                 32
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_1_MASK                  0x0F7C083F
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_1_CUR_BD_LSB          24
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_1_CUR_BD_WIDTH        4
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_1_CUR_BD_MASK         0x0F000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_1_CUR_BD_DEFVAL       0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_1_TASK_QUEUE_SIZE_LSB 20
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_1_TASK_QUEUE_SIZE_WIDTH 3
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_1_TASK_QUEUE_SIZE_MASK 0x00700000
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_1_TASK_QUEUE_SIZE_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_1_CHANNEL_RUNNING_LSB 19
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_1_CHANNEL_RUNNING_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_1_CHANNEL_RUNNING_MASK 0x00080000
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_1_CHANNEL_RUNNING_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_1_TASK_QUEUE_OVERFLOW_LSB 18
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_1_TASK_QUEUE_OVERFLOW_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_1_TASK_QUEUE_OVERFLOW_MASK 0x00040000
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_1_TASK_QUEUE_OVERFLOW_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_1_ERROR_BD_INVALID_LSB 11
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_1_ERROR_BD_INVALID_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_1_ERROR_BD_INVALID_MASK 0x00000800
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_1_ERROR_BD_INVALID_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_1_STALLED_TCT_LSB     5
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_1_STALLED_TCT_WIDTH   1
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_1_STALLED_TCT_MASK    0x00000020
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_1_STALLED_TCT_DEFVAL  0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_1_STALLED_STREAM_BACKPRESSURE_LSB 4
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_1_STALLED_STREAM_BACKPRESSURE_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_1_STALLED_STREAM_BACKPRESSURE_MASK 0x00000010
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_1_STALLED_STREAM_BACKPRESSURE_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_1_STALLED_LOCK_REL_LSB 3
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_1_STALLED_LOCK_REL_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_1_STALLED_LOCK_REL_MASK 0x00000008
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_1_STALLED_LOCK_REL_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_1_STALLED_LOCK_ACQ_LSB 2
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_1_STALLED_LOCK_ACQ_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_1_STALLED_LOCK_ACQ_MASK 0x00000004
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_1_STALLED_LOCK_ACQ_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_1_STATUS_LSB          0
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_1_STATUS_WIDTH        2
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_1_STATUS_MASK         0x00000003
#define XAIE2PGBL_MEMORY_MODULE_DMA_MM2S_STATUS_1_STATUS_DEFVAL       0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_CURRENT_WRITE_COUNT_0          0x0001DF18
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_CURRENT_WRITE_COUNT_0_WIDTH    32
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_CURRENT_WRITE_COUNT_0_MASK     0x00003FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_CURRENT_WRITE_COUNT_0_CURRENT_WRITE_COUNT_LSB 0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_CURRENT_WRITE_COUNT_0_CURRENT_WRITE_COUNT_WIDTH 14
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_CURRENT_WRITE_COUNT_0_CURRENT_WRITE_COUNT_MASK 0x00003FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_CURRENT_WRITE_COUNT_0_CURRENT_WRITE_COUNT_DEFVAL 0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_CURRENT_WRITE_COUNT_1          0x0001DF1C
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_CURRENT_WRITE_COUNT_1_WIDTH    32
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_CURRENT_WRITE_COUNT_1_MASK     0x00003FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_CURRENT_WRITE_COUNT_1_CURRENT_WRITE_COUNT_LSB 0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_CURRENT_WRITE_COUNT_1_CURRENT_WRITE_COUNT_WIDTH 14
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_CURRENT_WRITE_COUNT_1_CURRENT_WRITE_COUNT_MASK 0x00003FFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_CURRENT_WRITE_COUNT_1_CURRENT_WRITE_COUNT_DEFVAL 0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_FOT_COUNT_FIFO_POP_0           0x0001DF20
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_FOT_COUNT_FIFO_POP_0_WIDTH     32
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_FOT_COUNT_FIFO_POP_0_MASK      0xFF03FFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_FOT_COUNT_FIFO_POP_0_VALID_LSB 31
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_FOT_COUNT_FIFO_POP_0_VALID_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_FOT_COUNT_FIFO_POP_0_VALID_MASK 0x80000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_FOT_COUNT_FIFO_POP_0_VALID_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_FOT_COUNT_FIFO_POP_0_LAST_IN_TASK_LSB 30
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_FOT_COUNT_FIFO_POP_0_LAST_IN_TASK_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_FOT_COUNT_FIFO_POP_0_LAST_IN_TASK_MASK 0x40000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_FOT_COUNT_FIFO_POP_0_LAST_IN_TASK_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_FOT_COUNT_FIFO_POP_0_BD_ID_LSB 24
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_FOT_COUNT_FIFO_POP_0_BD_ID_WIDTH 6
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_FOT_COUNT_FIFO_POP_0_BD_ID_MASK 0x3F000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_FOT_COUNT_FIFO_POP_0_BD_ID_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_FOT_COUNT_FIFO_POP_0_WRITE_COUNT_LSB 0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_FOT_COUNT_FIFO_POP_0_WRITE_COUNT_WIDTH 18
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_FOT_COUNT_FIFO_POP_0_WRITE_COUNT_MASK 0x0003FFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_FOT_COUNT_FIFO_POP_0_WRITE_COUNT_DEFVAL 0x0

#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_FOT_COUNT_FIFO_POP_1           0x0001DF24
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_FOT_COUNT_FIFO_POP_1_WIDTH     32
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_FOT_COUNT_FIFO_POP_1_MASK      0xFF03FFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_FOT_COUNT_FIFO_POP_1_VALID_LSB 31
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_FOT_COUNT_FIFO_POP_1_VALID_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_FOT_COUNT_FIFO_POP_1_VALID_MASK 0x80000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_FOT_COUNT_FIFO_POP_1_VALID_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_FOT_COUNT_FIFO_POP_1_LAST_IN_TASK_LSB 30
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_FOT_COUNT_FIFO_POP_1_LAST_IN_TASK_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_FOT_COUNT_FIFO_POP_1_LAST_IN_TASK_MASK 0x40000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_FOT_COUNT_FIFO_POP_1_LAST_IN_TASK_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_FOT_COUNT_FIFO_POP_1_BD_ID_LSB 24
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_FOT_COUNT_FIFO_POP_1_BD_ID_WIDTH 6
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_FOT_COUNT_FIFO_POP_1_BD_ID_MASK 0x3F000000
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_FOT_COUNT_FIFO_POP_1_BD_ID_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_FOT_COUNT_FIFO_POP_1_WRITE_COUNT_LSB 0
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_FOT_COUNT_FIFO_POP_1_WRITE_COUNT_WIDTH 18
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_FOT_COUNT_FIFO_POP_1_WRITE_COUNT_MASK 0x0003FFFF
#define XAIE2PGBL_MEMORY_MODULE_DMA_S2MM_FOT_COUNT_FIFO_POP_1_WRITE_COUNT_DEFVAL 0x0

#define XAIE2PGBL_MEMORY_MODULE_LOCK0_VALUE                             0x0001F000
#define XAIE2PGBL_MEMORY_MODULE_LOCK0_VALUE_WIDTH                       32
#define XAIE2PGBL_MEMORY_MODULE_LOCK0_VALUE_MASK                        0x0000003F
#define XAIE2PGBL_MEMORY_MODULE_LOCK0_VALUE_LOCK_VALUE_LSB            0
#define XAIE2PGBL_MEMORY_MODULE_LOCK0_VALUE_LOCK_VALUE_WIDTH          6
#define XAIE2PGBL_MEMORY_MODULE_LOCK0_VALUE_LOCK_VALUE_MASK           0x0000003F
#define XAIE2PGBL_MEMORY_MODULE_LOCK0_VALUE_LOCK_VALUE_DEFVAL         0x0

#define XAIE2PGBL_MEMORY_MODULE_LOCK1_VALUE                             0x0001F010
#define XAIE2PGBL_MEMORY_MODULE_LOCK1_VALUE_WIDTH                       32
#define XAIE2PGBL_MEMORY_MODULE_LOCK1_VALUE_MASK                        0x0000003F
#define XAIE2PGBL_MEMORY_MODULE_LOCK1_VALUE_LOCK_VALUE_LSB            0
#define XAIE2PGBL_MEMORY_MODULE_LOCK1_VALUE_LOCK_VALUE_WIDTH          6
#define XAIE2PGBL_MEMORY_MODULE_LOCK1_VALUE_LOCK_VALUE_MASK           0x0000003F
#define XAIE2PGBL_MEMORY_MODULE_LOCK1_VALUE_LOCK_VALUE_DEFVAL         0x0

#define XAIE2PGBL_MEMORY_MODULE_LOCK2_VALUE                             0x0001F020
#define XAIE2PGBL_MEMORY_MODULE_LOCK2_VALUE_WIDTH                       32
#define XAIE2PGBL_MEMORY_MODULE_LOCK2_VALUE_MASK                        0x0000003F
#define XAIE2PGBL_MEMORY_MODULE_LOCK2_VALUE_LOCK_VALUE_LSB            0
#define XAIE2PGBL_MEMORY_MODULE_LOCK2_VALUE_LOCK_VALUE_WIDTH          6
#define XAIE2PGBL_MEMORY_MODULE_LOCK2_VALUE_LOCK_VALUE_MASK           0x0000003F
#define XAIE2PGBL_MEMORY_MODULE_LOCK2_VALUE_LOCK_VALUE_DEFVAL         0x0

#define XAIE2PGBL_MEMORY_MODULE_LOCK3_VALUE                             0x0001F030
#define XAIE2PGBL_MEMORY_MODULE_LOCK3_VALUE_WIDTH                       32
#define XAIE2PGBL_MEMORY_MODULE_LOCK3_VALUE_MASK                        0x0000003F
#define XAIE2PGBL_MEMORY_MODULE_LOCK3_VALUE_LOCK_VALUE_LSB            0
#define XAIE2PGBL_MEMORY_MODULE_LOCK3_VALUE_LOCK_VALUE_WIDTH          6
#define XAIE2PGBL_MEMORY_MODULE_LOCK3_VALUE_LOCK_VALUE_MASK           0x0000003F
#define XAIE2PGBL_MEMORY_MODULE_LOCK3_VALUE_LOCK_VALUE_DEFVAL         0x0

#define XAIE2PGBL_MEMORY_MODULE_LOCK4_VALUE                             0x0001F040
#define XAIE2PGBL_MEMORY_MODULE_LOCK4_VALUE_WIDTH                       32
#define XAIE2PGBL_MEMORY_MODULE_LOCK4_VALUE_MASK                        0x0000003F
#define XAIE2PGBL_MEMORY_MODULE_LOCK4_VALUE_LOCK_VALUE_LSB            0
#define XAIE2PGBL_MEMORY_MODULE_LOCK4_VALUE_LOCK_VALUE_WIDTH          6
#define XAIE2PGBL_MEMORY_MODULE_LOCK4_VALUE_LOCK_VALUE_MASK           0x0000003F
#define XAIE2PGBL_MEMORY_MODULE_LOCK4_VALUE_LOCK_VALUE_DEFVAL         0x0

#define XAIE2PGBL_MEMORY_MODULE_LOCK5_VALUE                             0x0001F050
#define XAIE2PGBL_MEMORY_MODULE_LOCK5_VALUE_WIDTH                       32
#define XAIE2PGBL_MEMORY_MODULE_LOCK5_VALUE_MASK                        0x0000003F
#define XAIE2PGBL_MEMORY_MODULE_LOCK5_VALUE_LOCK_VALUE_LSB            0
#define XAIE2PGBL_MEMORY_MODULE_LOCK5_VALUE_LOCK_VALUE_WIDTH          6
#define XAIE2PGBL_MEMORY_MODULE_LOCK5_VALUE_LOCK_VALUE_MASK           0x0000003F
#define XAIE2PGBL_MEMORY_MODULE_LOCK5_VALUE_LOCK_VALUE_DEFVAL         0x0

#define XAIE2PGBL_MEMORY_MODULE_LOCK6_VALUE                             0x0001F060
#define XAIE2PGBL_MEMORY_MODULE_LOCK6_VALUE_WIDTH                       32
#define XAIE2PGBL_MEMORY_MODULE_LOCK6_VALUE_MASK                        0x0000003F
#define XAIE2PGBL_MEMORY_MODULE_LOCK6_VALUE_LOCK_VALUE_LSB            0
#define XAIE2PGBL_MEMORY_MODULE_LOCK6_VALUE_LOCK_VALUE_WIDTH          6
#define XAIE2PGBL_MEMORY_MODULE_LOCK6_VALUE_LOCK_VALUE_MASK           0x0000003F
#define XAIE2PGBL_MEMORY_MODULE_LOCK6_VALUE_LOCK_VALUE_DEFVAL         0x0

#define XAIE2PGBL_MEMORY_MODULE_LOCK7_VALUE                             0x0001F070
#define XAIE2PGBL_MEMORY_MODULE_LOCK7_VALUE_WIDTH                       32
#define XAIE2PGBL_MEMORY_MODULE_LOCK7_VALUE_MASK                        0x0000003F
#define XAIE2PGBL_MEMORY_MODULE_LOCK7_VALUE_LOCK_VALUE_LSB            0
#define XAIE2PGBL_MEMORY_MODULE_LOCK7_VALUE_LOCK_VALUE_WIDTH          6
#define XAIE2PGBL_MEMORY_MODULE_LOCK7_VALUE_LOCK_VALUE_MASK           0x0000003F
#define XAIE2PGBL_MEMORY_MODULE_LOCK7_VALUE_LOCK_VALUE_DEFVAL         0x0

#define XAIE2PGBL_MEMORY_MODULE_LOCK8_VALUE                             0x0001F080
#define XAIE2PGBL_MEMORY_MODULE_LOCK8_VALUE_WIDTH                       32
#define XAIE2PGBL_MEMORY_MODULE_LOCK8_VALUE_MASK                        0x0000003F
#define XAIE2PGBL_MEMORY_MODULE_LOCK8_VALUE_LOCK_VALUE_LSB            0
#define XAIE2PGBL_MEMORY_MODULE_LOCK8_VALUE_LOCK_VALUE_WIDTH          6
#define XAIE2PGBL_MEMORY_MODULE_LOCK8_VALUE_LOCK_VALUE_MASK           0x0000003F
#define XAIE2PGBL_MEMORY_MODULE_LOCK8_VALUE_LOCK_VALUE_DEFVAL         0x0

#define XAIE2PGBL_MEMORY_MODULE_LOCK9_VALUE                             0x0001F090
#define XAIE2PGBL_MEMORY_MODULE_LOCK9_VALUE_WIDTH                       32
#define XAIE2PGBL_MEMORY_MODULE_LOCK9_VALUE_MASK                        0x0000003F
#define XAIE2PGBL_MEMORY_MODULE_LOCK9_VALUE_LOCK_VALUE_LSB            0
#define XAIE2PGBL_MEMORY_MODULE_LOCK9_VALUE_LOCK_VALUE_WIDTH          6
#define XAIE2PGBL_MEMORY_MODULE_LOCK9_VALUE_LOCK_VALUE_MASK           0x0000003F
#define XAIE2PGBL_MEMORY_MODULE_LOCK9_VALUE_LOCK_VALUE_DEFVAL         0x0

#define XAIE2PGBL_MEMORY_MODULE_LOCK10_VALUE                            0x0001F0A0
#define XAIE2PGBL_MEMORY_MODULE_LOCK10_VALUE_WIDTH                      32
#define XAIE2PGBL_MEMORY_MODULE_LOCK10_VALUE_MASK                       0x0000003F
#define XAIE2PGBL_MEMORY_MODULE_LOCK10_VALUE_LOCK_VALUE_LSB           0
#define XAIE2PGBL_MEMORY_MODULE_LOCK10_VALUE_LOCK_VALUE_WIDTH         6
#define XAIE2PGBL_MEMORY_MODULE_LOCK10_VALUE_LOCK_VALUE_MASK          0x0000003F
#define XAIE2PGBL_MEMORY_MODULE_LOCK10_VALUE_LOCK_VALUE_DEFVAL        0x0

#define XAIE2PGBL_MEMORY_MODULE_LOCK11_VALUE                            0x0001F0B0
#define XAIE2PGBL_MEMORY_MODULE_LOCK11_VALUE_WIDTH                      32
#define XAIE2PGBL_MEMORY_MODULE_LOCK11_VALUE_MASK                       0x0000003F
#define XAIE2PGBL_MEMORY_MODULE_LOCK11_VALUE_LOCK_VALUE_LSB           0
#define XAIE2PGBL_MEMORY_MODULE_LOCK11_VALUE_LOCK_VALUE_WIDTH         6
#define XAIE2PGBL_MEMORY_MODULE_LOCK11_VALUE_LOCK_VALUE_MASK          0x0000003F
#define XAIE2PGBL_MEMORY_MODULE_LOCK11_VALUE_LOCK_VALUE_DEFVAL        0x0

#define XAIE2PGBL_MEMORY_MODULE_LOCK12_VALUE                            0x0001F0C0
#define XAIE2PGBL_MEMORY_MODULE_LOCK12_VALUE_WIDTH                      32
#define XAIE2PGBL_MEMORY_MODULE_LOCK12_VALUE_MASK                       0x0000003F
#define XAIE2PGBL_MEMORY_MODULE_LOCK12_VALUE_LOCK_VALUE_LSB           0
#define XAIE2PGBL_MEMORY_MODULE_LOCK12_VALUE_LOCK_VALUE_WIDTH         6
#define XAIE2PGBL_MEMORY_MODULE_LOCK12_VALUE_LOCK_VALUE_MASK          0x0000003F
#define XAIE2PGBL_MEMORY_MODULE_LOCK12_VALUE_LOCK_VALUE_DEFVAL        0x0

#define XAIE2PGBL_MEMORY_MODULE_LOCK13_VALUE                            0x0001F0D0
#define XAIE2PGBL_MEMORY_MODULE_LOCK13_VALUE_WIDTH                      32
#define XAIE2PGBL_MEMORY_MODULE_LOCK13_VALUE_MASK                       0x0000003F
#define XAIE2PGBL_MEMORY_MODULE_LOCK13_VALUE_LOCK_VALUE_LSB           0
#define XAIE2PGBL_MEMORY_MODULE_LOCK13_VALUE_LOCK_VALUE_WIDTH         6
#define XAIE2PGBL_MEMORY_MODULE_LOCK13_VALUE_LOCK_VALUE_MASK          0x0000003F
#define XAIE2PGBL_MEMORY_MODULE_LOCK13_VALUE_LOCK_VALUE_DEFVAL        0x0

#define XAIE2PGBL_MEMORY_MODULE_LOCK14_VALUE                            0x0001F0E0
#define XAIE2PGBL_MEMORY_MODULE_LOCK14_VALUE_WIDTH                      32
#define XAIE2PGBL_MEMORY_MODULE_LOCK14_VALUE_MASK                       0x0000003F
#define XAIE2PGBL_MEMORY_MODULE_LOCK14_VALUE_LOCK_VALUE_LSB           0
#define XAIE2PGBL_MEMORY_MODULE_LOCK14_VALUE_LOCK_VALUE_WIDTH         6
#define XAIE2PGBL_MEMORY_MODULE_LOCK14_VALUE_LOCK_VALUE_MASK          0x0000003F
#define XAIE2PGBL_MEMORY_MODULE_LOCK14_VALUE_LOCK_VALUE_DEFVAL        0x0

#define XAIE2PGBL_MEMORY_MODULE_LOCK15_VALUE                            0x0001F0F0
#define XAIE2PGBL_MEMORY_MODULE_LOCK15_VALUE_WIDTH                      32
#define XAIE2PGBL_MEMORY_MODULE_LOCK15_VALUE_MASK                       0x0000003F
#define XAIE2PGBL_MEMORY_MODULE_LOCK15_VALUE_LOCK_VALUE_LSB           0
#define XAIE2PGBL_MEMORY_MODULE_LOCK15_VALUE_LOCK_VALUE_WIDTH         6
#define XAIE2PGBL_MEMORY_MODULE_LOCK15_VALUE_LOCK_VALUE_MASK          0x0000003F
#define XAIE2PGBL_MEMORY_MODULE_LOCK15_VALUE_LOCK_VALUE_DEFVAL        0x0

#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_0                 0x0001F100
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_0_WIDTH           32
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_0_MASK            0x000F003F
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_0_LOCK_SELECT_LSB 16
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_0_LOCK_SELECT_WIDTH 4
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_0_LOCK_SELECT_MASK 0x000F0000
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_0_LOCK_SELECT_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_0_LOCK_VALUE_LSB 0
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_0_LOCK_VALUE_WIDTH 6
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_0_LOCK_VALUE_MASK 0x0000003F
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_0_LOCK_VALUE_DEFVAL 0x3F

#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_1                 0x0001F104
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_1_WIDTH           32
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_1_MASK            0x000F003F
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_1_LOCK_SELECT_LSB 16
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_1_LOCK_SELECT_WIDTH 4
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_1_LOCK_SELECT_MASK 0x000F0000
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_1_LOCK_SELECT_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_1_LOCK_VALUE_LSB 0
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_1_LOCK_VALUE_WIDTH 6
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_1_LOCK_VALUE_MASK 0x0000003F
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_1_LOCK_VALUE_DEFVAL 0x3F

#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_2                 0x0001F108
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_2_WIDTH           32
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_2_MASK            0x000F003F
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_2_LOCK_SELECT_LSB 16
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_2_LOCK_SELECT_WIDTH 4
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_2_LOCK_SELECT_MASK 0x000F0000
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_2_LOCK_SELECT_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_2_LOCK_VALUE_LSB 0
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_2_LOCK_VALUE_WIDTH 6
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_2_LOCK_VALUE_MASK 0x0000003F
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_2_LOCK_VALUE_DEFVAL 0x3F

#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_3                 0x0001F10C
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_3_WIDTH           32
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_3_MASK            0x000F003F
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_3_LOCK_SELECT_LSB 16
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_3_LOCK_SELECT_WIDTH 4
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_3_LOCK_SELECT_MASK 0x000F0000
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_3_LOCK_SELECT_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_3_LOCK_VALUE_LSB 0
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_3_LOCK_VALUE_WIDTH 6
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_3_LOCK_VALUE_MASK 0x0000003F
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_3_LOCK_VALUE_DEFVAL 0x3F

#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_4                 0x0001F110
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_4_WIDTH           32
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_4_MASK            0x000F003F
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_4_LOCK_SELECT_LSB 16
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_4_LOCK_SELECT_WIDTH 4
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_4_LOCK_SELECT_MASK 0x000F0000
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_4_LOCK_SELECT_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_4_LOCK_VALUE_LSB 0
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_4_LOCK_VALUE_WIDTH 6
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_4_LOCK_VALUE_MASK 0x0000003F
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_4_LOCK_VALUE_DEFVAL 0x3F

#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_5                 0x0001F114
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_5_WIDTH           32
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_5_MASK            0x000F003F
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_5_LOCK_SELECT_LSB 16
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_5_LOCK_SELECT_WIDTH 4
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_5_LOCK_SELECT_MASK 0x000F0000
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_5_LOCK_SELECT_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_5_LOCK_VALUE_LSB 0
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_5_LOCK_VALUE_WIDTH 6
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_5_LOCK_VALUE_MASK 0x0000003F
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_5_LOCK_VALUE_DEFVAL 0x3F

#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_6                 0x0001F118
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_6_WIDTH           32
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_6_MASK            0x000F003F
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_6_LOCK_SELECT_LSB 16
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_6_LOCK_SELECT_WIDTH 4
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_6_LOCK_SELECT_MASK 0x000F0000
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_6_LOCK_SELECT_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_6_LOCK_VALUE_LSB 0
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_6_LOCK_VALUE_WIDTH 6
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_6_LOCK_VALUE_MASK 0x0000003F
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_6_LOCK_VALUE_DEFVAL 0x3F

#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_7                 0x0001F11C
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_7_WIDTH           32
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_7_MASK            0x000F003F
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_7_LOCK_SELECT_LSB 16
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_7_LOCK_SELECT_WIDTH 4
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_7_LOCK_SELECT_MASK 0x000F0000
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_7_LOCK_SELECT_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_7_LOCK_VALUE_LSB 0
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_7_LOCK_VALUE_WIDTH 6
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_7_LOCK_VALUE_MASK 0x0000003F
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_EVENT_SELECTION_7_LOCK_VALUE_DEFVAL 0x3F

#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW                          0x0001F120
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_WIDTH                    32
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_MASK                     0x0000FFFF
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_15_LSB   15
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_15_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_15_MASK  0x00008000
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_15_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_14_LSB   14
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_14_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_14_MASK  0x00004000
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_14_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_13_LSB   13
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_13_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_13_MASK  0x00002000
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_13_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_12_LSB   12
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_12_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_12_MASK  0x00001000
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_12_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_11_LSB   11
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_11_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_11_MASK  0x00000800
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_11_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_10_LSB   10
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_10_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_10_MASK  0x00000400
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_10_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_9_LSB    9
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_9_WIDTH  1
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_9_MASK   0x00000200
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_9_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_8_LSB    8
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_8_WIDTH  1
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_8_MASK   0x00000100
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_8_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_7_LSB    7
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_7_WIDTH  1
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_7_MASK   0x00000080
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_7_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_6_LSB    6
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_6_WIDTH  1
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_6_MASK   0x00000040
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_6_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_5_LSB    5
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_5_WIDTH  1
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_5_MASK   0x00000020
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_5_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_4_LSB    4
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_4_WIDTH  1
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_4_MASK   0x00000010
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_4_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_3_LSB    3
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_3_WIDTH  1
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_3_MASK   0x00000008
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_3_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_2_LSB    2
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_2_WIDTH  1
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_2_MASK   0x00000004
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_2_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_1_LSB    1
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_1_WIDTH  1
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_1_MASK   0x00000002
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_1_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_0_LSB    0
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_0_WIDTH  1
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_0_MASK   0x00000001
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_OVERFLOW_LOCK_OVERFLOW_0_DEFVAL 0x0

#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW                         0x0001F128
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_WIDTH                   32
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_MASK                    0x0000FFFF
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_15_LSB 15
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_15_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_15_MASK 0x00008000
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_15_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_14_LSB 14
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_14_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_14_MASK 0x00004000
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_14_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_13_LSB 13
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_13_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_13_MASK 0x00002000
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_13_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_12_LSB 12
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_12_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_12_MASK 0x00001000
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_12_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_11_LSB 11
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_11_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_11_MASK 0x00000800
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_11_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_10_LSB 10
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_10_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_10_MASK 0x00000400
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_10_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_9_LSB  9
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_9_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_9_MASK 0x00000200
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_9_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_8_LSB  8
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_8_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_8_MASK 0x00000100
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_8_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_7_LSB  7
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_7_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_7_MASK 0x00000080
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_7_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_6_LSB  6
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_6_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_6_MASK 0x00000040
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_6_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_5_LSB  5
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_5_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_5_MASK 0x00000020
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_5_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_4_LSB  4
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_4_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_4_MASK 0x00000010
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_4_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_3_LSB  3
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_3_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_3_MASK 0x00000008
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_3_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_2_LSB  2
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_2_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_2_MASK 0x00000004
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_2_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_1_LSB  1
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_1_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_1_MASK 0x00000002
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_1_DEFVAL 0x0
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_0_LSB  0
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_0_WIDTH 1
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_0_MASK 0x00000001
#define XAIE2PGBL_MEMORY_MODULE_LOCKS_UNDERFLOW_LOCK_UNDERFLOW_0_DEFVAL 0x0

#define XAIE2PGBL_MEMORY_MODULE_LOCK_REQUEST                            0x00040000
#define XAIE2PGBL_MEMORY_MODULE_LOCK_REQUEST_WIDTH                      32
#define XAIE2PGBL_MEMORY_MODULE_LOCK_REQUEST_MASK                       0x00000001
#define XAIE2PGBL_MEMORY_MODULE_LOCK_REQUEST_REQUEST_RESULT_LSB       0
#define XAIE2PGBL_MEMORY_MODULE_LOCK_REQUEST_REQUEST_RESULT_WIDTH     1
#define XAIE2PGBL_MEMORY_MODULE_LOCK_REQUEST_REQUEST_RESULT_MASK      0x00000001
#define XAIE2PGBL_MEMORY_MODULE_LOCK_REQUEST_REQUEST_RESULT_DEFVAL    0x0
/** @} */

/* AIE2P PL module register definitions */

/**
 * @name Pl Module register definitions
 * This registers contains pl module information
 * @{
 */
/**
 * Register:XAIE2PGBL_PL_MODULE
 */
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_CTRL0                           0x00031000
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_CTRL0_WIDTH                     32
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_CTRL0_MASK                      0x7F7F7F7F
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_CTRL0_CNT1_STOP_EVENT_LSB     24
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_CTRL0_CNT1_STOP_EVENT_WIDTH   7
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_CTRL0_CNT1_STOP_EVENT_MASK    0x7F000000
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_CTRL0_CNT1_STOP_EVENT_DEFVAL  0x0
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_CTRL0_CNT1_START_EVENT_LSB    16
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_CTRL0_CNT1_START_EVENT_WIDTH  7
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_CTRL0_CNT1_START_EVENT_MASK   0x007F0000
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_CTRL0_CNT1_START_EVENT_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_CTRL0_CNT0_STOP_EVENT_LSB     8
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_CTRL0_CNT0_STOP_EVENT_WIDTH   7
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_CTRL0_CNT0_STOP_EVENT_MASK    0x00007F00
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_CTRL0_CNT0_STOP_EVENT_DEFVAL  0x0
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_CTRL0_CNT0_START_EVENT_LSB    0
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_CTRL0_CNT0_START_EVENT_WIDTH  7
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_CTRL0_CNT0_START_EVENT_MASK   0x0000007F
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_CTRL0_CNT0_START_EVENT_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_PERFORMANCE_CTRL1                           0x00031008
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_CTRL1_WIDTH                     32
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_CTRL1_MASK                      0x00007F7F
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_CTRL1_CNT1_RESET_EVENT_LSB    8
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_CTRL1_CNT1_RESET_EVENT_WIDTH  7
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_CTRL1_CNT1_RESET_EVENT_MASK   0x00007F00
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_CTRL1_CNT1_RESET_EVENT_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_CTRL1_CNT0_RESET_EVENT_LSB    0
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_CTRL1_CNT0_RESET_EVENT_WIDTH  7
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_CTRL1_CNT0_RESET_EVENT_MASK   0x0000007F
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_CTRL1_CNT0_RESET_EVENT_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_PERFORMANCE_COUNTER0                        0x00031020
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_COUNTER0_WIDTH                  32
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_COUNTER0_MASK                   0xFFFFFFFF
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_COUNTER0_COUNTER0_VALUE_LSB   0
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_COUNTER0_COUNTER0_VALUE_WIDTH 32
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_COUNTER0_COUNTER0_VALUE_MASK  0xFFFFFFFF
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_COUNTER0_COUNTER0_VALUE_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_PERFORMANCE_COUNTER1                        0x00031024
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_COUNTER1_WIDTH                  32
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_COUNTER1_MASK                   0xFFFFFFFF
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_COUNTER1_COUNTER0_VALUE_LSB   0
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_COUNTER1_COUNTER0_VALUE_WIDTH 32
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_COUNTER1_COUNTER0_VALUE_MASK  0xFFFFFFFF
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_COUNTER1_COUNTER0_VALUE_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_PERFORMANCE_COUNTER0_EVENT_VALUE            0x00031080
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_COUNTER0_EVENT_VALUE_WIDTH      32
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_COUNTER0_EVENT_VALUE_MASK       0xFFFFFFFF
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_COUNTER0_EVENT_VALUE_COUNTER_EVENT_VALUE_LSB 0
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_COUNTER0_EVENT_VALUE_COUNTER_EVENT_VALUE_WIDTH 32
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_COUNTER0_EVENT_VALUE_COUNTER_EVENT_VALUE_MASK 0xFFFFFFFF
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_COUNTER0_EVENT_VALUE_COUNTER_EVENT_VALUE_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_PERFORMANCE_COUNTER1_EVENT_VALUE            0x00031084
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_COUNTER1_EVENT_VALUE_WIDTH      32
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_COUNTER1_EVENT_VALUE_MASK       0xFFFFFFFF
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_COUNTER1_EVENT_VALUE_COUNTER_EVENT_VALUE_LSB 0
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_COUNTER1_EVENT_VALUE_COUNTER_EVENT_VALUE_WIDTH 32
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_COUNTER1_EVENT_VALUE_COUNTER_EVENT_VALUE_MASK 0xFFFFFFFF
#define XAIE2PGBL_PL_MODULE_PERFORMANCE_COUNTER1_EVENT_VALUE_COUNTER_EVENT_VALUE_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_UPSIZER_CONFIG                 0x00033000
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_UPSIZER_CONFIG_WIDTH           32
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_UPSIZER_CONFIG_MASK            0x000001FF
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_UPSIZER_CONFIG_SOUTH4_SOUTH5_128_COMBINE_LSB 8
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_UPSIZER_CONFIG_SOUTH4_SOUTH5_128_COMBINE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_UPSIZER_CONFIG_SOUTH4_SOUTH5_128_COMBINE_MASK 0x00000100
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_UPSIZER_CONFIG_SOUTH4_SOUTH5_128_COMBINE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_UPSIZER_CONFIG_SOUTH5_LSB    7
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_UPSIZER_CONFIG_SOUTH5_WIDTH  1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_UPSIZER_CONFIG_SOUTH5_MASK   0x00000080
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_UPSIZER_CONFIG_SOUTH5_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_UPSIZER_CONFIG_SOUTH4_LSB    6
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_UPSIZER_CONFIG_SOUTH4_WIDTH  1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_UPSIZER_CONFIG_SOUTH4_MASK   0x00000040
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_UPSIZER_CONFIG_SOUTH4_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_UPSIZER_CONFIG_SOUTH2_SOUTH3_128_COMBINE_LSB 5
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_UPSIZER_CONFIG_SOUTH2_SOUTH3_128_COMBINE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_UPSIZER_CONFIG_SOUTH2_SOUTH3_128_COMBINE_MASK 0x00000020
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_UPSIZER_CONFIG_SOUTH2_SOUTH3_128_COMBINE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_UPSIZER_CONFIG_SOUTH3_LSB    4
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_UPSIZER_CONFIG_SOUTH3_WIDTH  1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_UPSIZER_CONFIG_SOUTH3_MASK   0x00000010
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_UPSIZER_CONFIG_SOUTH3_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_UPSIZER_CONFIG_SOUTH2_LSB    3
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_UPSIZER_CONFIG_SOUTH2_WIDTH  1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_UPSIZER_CONFIG_SOUTH2_MASK   0x00000008
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_UPSIZER_CONFIG_SOUTH2_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_UPSIZER_CONFIG_SOUTH0_SOUTH1_128_COMBINE_LSB 2
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_UPSIZER_CONFIG_SOUTH0_SOUTH1_128_COMBINE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_UPSIZER_CONFIG_SOUTH0_SOUTH1_128_COMBINE_MASK 0x00000004
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_UPSIZER_CONFIG_SOUTH0_SOUTH1_128_COMBINE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_UPSIZER_CONFIG_SOUTH1_LSB    1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_UPSIZER_CONFIG_SOUTH1_WIDTH  1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_UPSIZER_CONFIG_SOUTH1_MASK   0x00000002
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_UPSIZER_CONFIG_SOUTH1_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_UPSIZER_CONFIG_SOUTH0_LSB    0
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_UPSIZER_CONFIG_SOUTH0_WIDTH  1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_UPSIZER_CONFIG_SOUTH0_MASK   0x00000001
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_UPSIZER_CONFIG_SOUTH0_DEFVAL 0x1

#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG               0x00033004
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_WIDTH         32
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_MASK          0x00000FFF
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_SOUTH6_SOUTH7_128_COMBINE_LSB 11
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_SOUTH6_SOUTH7_128_COMBINE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_SOUTH6_SOUTH7_128_COMBINE_MASK 0x00000800
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_SOUTH6_SOUTH7_128_COMBINE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_SOUTH7_LSB  10
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_SOUTH7_WIDTH 1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_SOUTH7_MASK 0x00000400
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_SOUTH7_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_SOUTH6_LSB  9
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_SOUTH6_WIDTH 1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_SOUTH6_MASK 0x00000200
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_SOUTH6_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_SOUTH4_SOUTH5_128_COMBINE_LSB 8
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_SOUTH4_SOUTH5_128_COMBINE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_SOUTH4_SOUTH5_128_COMBINE_MASK 0x00000100
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_SOUTH4_SOUTH5_128_COMBINE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_SOUTH5_LSB  7
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_SOUTH5_WIDTH 1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_SOUTH5_MASK 0x00000080
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_SOUTH5_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_SOUTH4_LSB  6
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_SOUTH4_WIDTH 1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_SOUTH4_MASK 0x00000040
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_SOUTH4_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_SOUTH2_SOUTH3_128_COMBINE_LSB 5
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_SOUTH2_SOUTH3_128_COMBINE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_SOUTH2_SOUTH3_128_COMBINE_MASK 0x00000020
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_SOUTH2_SOUTH3_128_COMBINE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_SOUTH3_LSB  4
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_SOUTH3_WIDTH 1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_SOUTH3_MASK 0x00000010
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_SOUTH3_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_SOUTH2_LSB  3
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_SOUTH2_WIDTH 1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_SOUTH2_MASK 0x00000008
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_SOUTH2_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_SOUTH0_SOUTH1_128_COMBINE_LSB 2
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_SOUTH0_SOUTH1_128_COMBINE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_SOUTH0_SOUTH1_128_COMBINE_MASK 0x00000004
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_SOUTH0_SOUTH1_128_COMBINE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_SOUTH1_LSB  1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_SOUTH1_WIDTH 1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_SOUTH1_MASK 0x00000002
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_SOUTH1_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_SOUTH0_LSB  0
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_SOUTH0_WIDTH 1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_SOUTH0_MASK 0x00000001
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_CONFIG_SOUTH0_DEFVAL 0x1

#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_ENABLE               0x00033008
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_ENABLE_WIDTH         32
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_ENABLE_MASK          0x000000FF
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_ENABLE_SOUTH7_LSB  7
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_ENABLE_SOUTH7_WIDTH 1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_ENABLE_SOUTH7_MASK 0x00000080
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_ENABLE_SOUTH7_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_ENABLE_SOUTH6_LSB  6
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_ENABLE_SOUTH6_WIDTH 1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_ENABLE_SOUTH6_MASK 0x00000040
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_ENABLE_SOUTH6_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_ENABLE_SOUTH5_LSB  5
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_ENABLE_SOUTH5_WIDTH 1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_ENABLE_SOUTH5_MASK 0x00000020
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_ENABLE_SOUTH5_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_ENABLE_SOUTH4_LSB  4
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_ENABLE_SOUTH4_WIDTH 1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_ENABLE_SOUTH4_MASK 0x00000010
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_ENABLE_SOUTH4_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_ENABLE_SOUTH3_LSB  3
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_ENABLE_SOUTH3_WIDTH 1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_ENABLE_SOUTH3_MASK 0x00000008
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_ENABLE_SOUTH3_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_ENABLE_SOUTH2_LSB  2
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_ENABLE_SOUTH2_WIDTH 1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_ENABLE_SOUTH2_MASK 0x00000004
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_ENABLE_SOUTH2_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_ENABLE_SOUTH1_LSB  1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_ENABLE_SOUTH1_WIDTH 1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_ENABLE_SOUTH1_MASK 0x00000002
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_ENABLE_SOUTH1_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_ENABLE_SOUTH0_LSB  0
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_ENABLE_SOUTH0_WIDTH 1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_ENABLE_SOUTH0_MASK 0x00000001
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_ENABLE_SOUTH0_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_BYPASS               0x0003300C
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_BYPASS_WIDTH         32
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_BYPASS_MASK          0x0000003F
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_BYPASS_SOUTH6_LSB  5
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_BYPASS_SOUTH6_WIDTH 1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_BYPASS_SOUTH6_MASK 0x00000020
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_BYPASS_SOUTH6_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_BYPASS_SOUTH5_LSB  4
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_BYPASS_SOUTH5_WIDTH 1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_BYPASS_SOUTH5_MASK 0x00000010
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_BYPASS_SOUTH5_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_BYPASS_SOUTH4_LSB  3
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_BYPASS_SOUTH4_WIDTH 1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_BYPASS_SOUTH4_MASK 0x00000008
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_BYPASS_SOUTH4_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_BYPASS_SOUTH2_LSB  2
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_BYPASS_SOUTH2_WIDTH 1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_BYPASS_SOUTH2_MASK 0x00000004
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_BYPASS_SOUTH2_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_BYPASS_SOUTH1_LSB  1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_BYPASS_SOUTH1_WIDTH 1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_BYPASS_SOUTH1_MASK 0x00000002
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_BYPASS_SOUTH1_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_BYPASS_SOUTH0_LSB  0
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_BYPASS_SOUTH0_WIDTH 1
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_BYPASS_SOUTH0_MASK 0x00000001
#define XAIE2PGBL_PL_MODULE_PL_INTERFACE_DOWNSIZER_BYPASS_SOUTH0_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_TIMER_CONTROL                               0x00034000
#define XAIE2PGBL_PL_MODULE_TIMER_CONTROL_WIDTH                         32
#define XAIE2PGBL_PL_MODULE_TIMER_CONTROL_MASK                          0x80007F00
#define XAIE2PGBL_PL_MODULE_TIMER_CONTROL_RESET_LSB                   31
#define XAIE2PGBL_PL_MODULE_TIMER_CONTROL_RESET_WIDTH                 1
#define XAIE2PGBL_PL_MODULE_TIMER_CONTROL_RESET_MASK                  0x80000000
#define XAIE2PGBL_PL_MODULE_TIMER_CONTROL_RESET_DEFVAL                0x0
#define XAIE2PGBL_PL_MODULE_TIMER_CONTROL_RESET_EVENT_LSB             8
#define XAIE2PGBL_PL_MODULE_TIMER_CONTROL_RESET_EVENT_WIDTH           7
#define XAIE2PGBL_PL_MODULE_TIMER_CONTROL_RESET_EVENT_MASK            0x00007F00
#define XAIE2PGBL_PL_MODULE_TIMER_CONTROL_RESET_EVENT_DEFVAL          0x0

#define XAIE2PGBL_PL_MODULE_EVENT_GENERATE                              0x00034008
#define XAIE2PGBL_PL_MODULE_EVENT_GENERATE_WIDTH                        32
#define XAIE2PGBL_PL_MODULE_EVENT_GENERATE_MASK                         0x0000007F
#define XAIE2PGBL_PL_MODULE_EVENT_GENERATE_EVENT_LSB                  0
#define XAIE2PGBL_PL_MODULE_EVENT_GENERATE_EVENT_WIDTH                7
#define XAIE2PGBL_PL_MODULE_EVENT_GENERATE_EVENT_MASK                 0x0000007F
#define XAIE2PGBL_PL_MODULE_EVENT_GENERATE_EVENT_DEFVAL               0x0

#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST0_A                          0x00034010
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST0_A_WIDTH                    32
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST0_A_MASK                     0x0000007F
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST0_A_EVENT_LSB              0
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST0_A_EVENT_WIDTH            7
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST0_A_EVENT_MASK             0x0000007F
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST0_A_EVENT_DEFVAL           0x0

#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST1_A                          0x00034014
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST1_A_WIDTH                    32
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST1_A_MASK                     0x0000007F
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST1_A_EVENT_LSB              0
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST1_A_EVENT_WIDTH            7
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST1_A_EVENT_MASK             0x0000007F
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST1_A_EVENT_DEFVAL           0x0

#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST2_A                          0x00034018
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST2_A_WIDTH                    32
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST2_A_MASK                     0x0000007F
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST2_A_EVENT_LSB              0
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST2_A_EVENT_WIDTH            7
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST2_A_EVENT_MASK             0x0000007F
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST2_A_EVENT_DEFVAL           0x0

#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST3_A                          0x0003401C
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST3_A_WIDTH                    32
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST3_A_MASK                     0x0000007F
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST3_A_EVENT_LSB              0
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST3_A_EVENT_WIDTH            7
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST3_A_EVENT_MASK             0x0000007F
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST3_A_EVENT_DEFVAL           0x0

#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST4_A                          0x00034020
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST4_A_WIDTH                    32
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST4_A_MASK                     0x0000007F
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST4_A_EVENT_LSB              0
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST4_A_EVENT_WIDTH            7
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST4_A_EVENT_MASK             0x0000007F
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST4_A_EVENT_DEFVAL           0x0

#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST5_A                          0x00034024
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST5_A_WIDTH                    32
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST5_A_MASK                     0x0000007F
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST5_A_EVENT_LSB              0
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST5_A_EVENT_WIDTH            7
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST5_A_EVENT_MASK             0x0000007F
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST5_A_EVENT_DEFVAL           0x0

#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST6_A                          0x00034028
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST6_A_WIDTH                    32
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST6_A_MASK                     0x0000007F
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST6_A_EVENT_LSB              0
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST6_A_EVENT_WIDTH            7
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST6_A_EVENT_MASK             0x0000007F
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST6_A_EVENT_DEFVAL           0x0

#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST7_A                          0x0003402C
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST7_A_WIDTH                    32
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST7_A_MASK                     0x0000007F
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST7_A_EVENT_LSB              0
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST7_A_EVENT_WIDTH            7
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST7_A_EVENT_MASK             0x0000007F
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST7_A_EVENT_DEFVAL           0x0

#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST8_A                          0x00034030
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST8_A_WIDTH                    32
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST8_A_MASK                     0x0000007F
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST8_A_EVENT_LSB              0
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST8_A_EVENT_WIDTH            7
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST8_A_EVENT_MASK             0x0000007F
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST8_A_EVENT_DEFVAL           0x0

#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST9_A                          0x00034034
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST9_A_WIDTH                    32
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST9_A_MASK                     0x0000007F
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST9_A_EVENT_LSB              0
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST9_A_EVENT_WIDTH            7
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST9_A_EVENT_MASK             0x0000007F
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST9_A_EVENT_DEFVAL           0x0

#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST10_A                         0x00034038
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST10_A_WIDTH                   32
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST10_A_MASK                    0x0000007F
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST10_A_EVENT_LSB             0
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST10_A_EVENT_WIDTH           7
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST10_A_EVENT_MASK            0x0000007F
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST10_A_EVENT_DEFVAL          0x0

#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST11_A                         0x0003403C
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST11_A_WIDTH                   32
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST11_A_MASK                    0x0000007F
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST11_A_EVENT_LSB             0
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST11_A_EVENT_WIDTH           7
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST11_A_EVENT_MASK            0x0000007F
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST11_A_EVENT_DEFVAL          0x0

#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST12_A                         0x00034040
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST12_A_WIDTH                   32
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST12_A_MASK                    0x0000007F
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST12_A_EVENT_LSB             0
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST12_A_EVENT_WIDTH           7
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST12_A_EVENT_MASK            0x0000007F
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST12_A_EVENT_DEFVAL          0x0

#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST13_A                         0x00034044
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST13_A_WIDTH                   32
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST13_A_MASK                    0x0000007F
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST13_A_EVENT_LSB             0
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST13_A_EVENT_WIDTH           7
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST13_A_EVENT_MASK            0x0000007F
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST13_A_EVENT_DEFVAL          0x0

#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST14_A                         0x00034048
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST14_A_WIDTH                   32
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST14_A_MASK                    0x0000007F
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST14_A_EVENT_LSB             0
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST14_A_EVENT_WIDTH           7
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST14_A_EVENT_MASK            0x0000007F
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST14_A_EVENT_DEFVAL          0x0

#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST15_A                         0x0003404C
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST15_A_WIDTH                   32
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST15_A_MASK                    0x0000007F
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST15_A_EVENT_LSB             0
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST15_A_EVENT_WIDTH           7
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST15_A_EVENT_MASK            0x0000007F
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST15_A_EVENT_DEFVAL          0x0

#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_SOUTH_SET           0x00034050
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_SOUTH_SET_WIDTH     32
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_SOUTH_SET_MASK      0x0000FFFF
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_SOUTH_SET_SET_LSB 0
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_SOUTH_SET_SET_WIDTH 16
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_SOUTH_SET_SET_MASK 0x0000FFFF
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_SOUTH_SET_SET_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_SOUTH_CLR           0x00034054
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_SOUTH_CLR_WIDTH     32
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_SOUTH_CLR_MASK      0x0000FFFF
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_SOUTH_CLR_CLEAR_LSB 0
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_SOUTH_CLR_CLEAR_WIDTH 16
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_SOUTH_CLR_CLEAR_MASK 0x0000FFFF
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_SOUTH_CLR_CLEAR_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_SOUTH_VALUE         0x00034058
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_SOUTH_VALUE_WIDTH   32
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_SOUTH_VALUE_MASK    0x0000FFFF
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_SOUTH_VALUE_VALUE_LSB 0
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_SOUTH_VALUE_VALUE_WIDTH 16
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_SOUTH_VALUE_VALUE_MASK 0x0000FFFF
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_SOUTH_VALUE_VALUE_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_WEST_SET            0x00034060
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_WEST_SET_WIDTH      32
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_WEST_SET_MASK       0x0000FFFF
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_WEST_SET_SET_LSB  0
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_WEST_SET_SET_WIDTH 16
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_WEST_SET_SET_MASK 0x0000FFFF
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_WEST_SET_SET_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_WEST_CLR            0x00034064
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_WEST_CLR_WIDTH      32
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_WEST_CLR_MASK       0x0000FFFF
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_WEST_CLR_CLEAR_LSB 0
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_WEST_CLR_CLEAR_WIDTH 16
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_WEST_CLR_CLEAR_MASK 0x0000FFFF
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_WEST_CLR_CLEAR_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_WEST_VALUE          0x00034068
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_WEST_VALUE_WIDTH    32
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_WEST_VALUE_MASK     0x0000FFFF
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_WEST_VALUE_VALUE_LSB 0
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_WEST_VALUE_VALUE_WIDTH 16
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_WEST_VALUE_VALUE_MASK 0x0000FFFF
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_WEST_VALUE_VALUE_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_NORTH_SET           0x00034070
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_NORTH_SET_WIDTH     32
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_NORTH_SET_MASK      0x0000FFFF
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_NORTH_SET_SET_LSB 0
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_NORTH_SET_SET_WIDTH 16
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_NORTH_SET_SET_MASK 0x0000FFFF
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_NORTH_SET_SET_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_NORTH_CLR           0x00034074
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_NORTH_CLR_WIDTH     32
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_NORTH_CLR_MASK      0x0000FFFF
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_NORTH_CLR_CLEAR_LSB 0
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_NORTH_CLR_CLEAR_WIDTH 16
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_NORTH_CLR_CLEAR_MASK 0x0000FFFF
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_NORTH_CLR_CLEAR_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_NORTH_VALUE         0x00034078
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_NORTH_VALUE_WIDTH   32
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_NORTH_VALUE_MASK    0x0000FFFF
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_NORTH_VALUE_VALUE_LSB 0
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_NORTH_VALUE_VALUE_WIDTH 16
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_NORTH_VALUE_VALUE_MASK 0x0000FFFF
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_NORTH_VALUE_VALUE_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_EAST_SET            0x00034080
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_EAST_SET_WIDTH      32
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_EAST_SET_MASK       0x0000FFFF
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_EAST_SET_SET_LSB  0
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_EAST_SET_SET_WIDTH 16
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_EAST_SET_SET_MASK 0x0000FFFF
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_EAST_SET_SET_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_EAST_CLR            0x00034084
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_EAST_CLR_WIDTH      32
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_EAST_CLR_MASK       0x0000FFFF
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_EAST_CLR_CLEAR_LSB 0
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_EAST_CLR_CLEAR_WIDTH 16
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_EAST_CLR_CLEAR_MASK 0x0000FFFF
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_EAST_CLR_CLEAR_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_EAST_VALUE          0x00034088
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_EAST_VALUE_WIDTH    32
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_EAST_VALUE_MASK     0x0000FFFF
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_EAST_VALUE_VALUE_LSB 0
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_EAST_VALUE_VALUE_WIDTH 16
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_EAST_VALUE_VALUE_MASK 0x0000FFFF
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_A_BLOCK_EAST_VALUE_VALUE_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_SOUTH_SET           0x00034090
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_SOUTH_SET_WIDTH     32
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_SOUTH_SET_MASK      0x0000FFFF
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_SOUTH_SET_SET_LSB 0
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_SOUTH_SET_SET_WIDTH 16
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_SOUTH_SET_SET_MASK 0x0000FFFF
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_SOUTH_SET_SET_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_SOUTH_CLR           0x00034094
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_SOUTH_CLR_WIDTH     32
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_SOUTH_CLR_MASK      0x0000FFFF
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_SOUTH_CLR_CLEAR_LSB 0
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_SOUTH_CLR_CLEAR_WIDTH 16
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_SOUTH_CLR_CLEAR_MASK 0x0000FFFF
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_SOUTH_CLR_CLEAR_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_SOUTH_VALUE         0x00034098
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_SOUTH_VALUE_WIDTH   32
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_SOUTH_VALUE_MASK    0x0000FFFF
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_SOUTH_VALUE_VALUE_LSB 0
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_SOUTH_VALUE_VALUE_WIDTH 16
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_SOUTH_VALUE_VALUE_MASK 0x0000FFFF
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_SOUTH_VALUE_VALUE_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_WEST_SET            0x000340A0
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_WEST_SET_WIDTH      32
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_WEST_SET_MASK       0x0000FFFF
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_WEST_SET_SET_LSB  0
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_WEST_SET_SET_WIDTH 16
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_WEST_SET_SET_MASK 0x0000FFFF
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_WEST_SET_SET_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_WEST_CLR            0x000340A4
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_WEST_CLR_WIDTH      32
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_WEST_CLR_MASK       0x0000FFFF
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_WEST_CLR_CLEAR_LSB 0
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_WEST_CLR_CLEAR_WIDTH 16
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_WEST_CLR_CLEAR_MASK 0x0000FFFF
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_WEST_CLR_CLEAR_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_WEST_VALUE          0x000340A8
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_WEST_VALUE_WIDTH    32
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_WEST_VALUE_MASK     0x0000FFFF
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_WEST_VALUE_VALUE_LSB 0
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_WEST_VALUE_VALUE_WIDTH 16
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_WEST_VALUE_VALUE_MASK 0x0000FFFF
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_WEST_VALUE_VALUE_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_NORTH_SET           0x000340B0
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_NORTH_SET_WIDTH     32
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_NORTH_SET_MASK      0x0000FFFF
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_NORTH_SET_SET_LSB 0
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_NORTH_SET_SET_WIDTH 16
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_NORTH_SET_SET_MASK 0x0000FFFF
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_NORTH_SET_SET_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_NORTH_CLR           0x000340B4
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_NORTH_CLR_WIDTH     32
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_NORTH_CLR_MASK      0x0000FFFF
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_NORTH_CLR_CLEAR_LSB 0
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_NORTH_CLR_CLEAR_WIDTH 16
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_NORTH_CLR_CLEAR_MASK 0x0000FFFF
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_NORTH_CLR_CLEAR_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_NORTH_VALUE         0x000340B8
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_NORTH_VALUE_WIDTH   32
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_NORTH_VALUE_MASK    0x0000FFFF
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_NORTH_VALUE_VALUE_LSB 0
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_NORTH_VALUE_VALUE_WIDTH 16
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_NORTH_VALUE_VALUE_MASK 0x0000FFFF
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_NORTH_VALUE_VALUE_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_EAST_SET            0x000340C0
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_EAST_SET_WIDTH      32
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_EAST_SET_MASK       0x0000FFFF
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_EAST_SET_SET_LSB  0
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_EAST_SET_SET_WIDTH 16
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_EAST_SET_SET_MASK 0x0000FFFF
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_EAST_SET_SET_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_EAST_CLR            0x000340C4
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_EAST_CLR_WIDTH      32
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_EAST_CLR_MASK       0x0000FFFF
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_EAST_CLR_CLEAR_LSB 0
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_EAST_CLR_CLEAR_WIDTH 16
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_EAST_CLR_CLEAR_MASK 0x0000FFFF
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_EAST_CLR_CLEAR_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_EAST_VALUE          0x000340C8
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_EAST_VALUE_WIDTH    32
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_EAST_VALUE_MASK     0x0000FFFF
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_EAST_VALUE_VALUE_LSB 0
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_EAST_VALUE_VALUE_WIDTH 16
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_EAST_VALUE_VALUE_MASK 0x0000FFFF
#define XAIE2PGBL_PL_MODULE_EVENT_BROADCAST_B_BLOCK_EAST_VALUE_VALUE_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_TRACE_CONTROL0                              0x000340D0
#define XAIE2PGBL_PL_MODULE_TRACE_CONTROL0_WIDTH                        32
#define XAIE2PGBL_PL_MODULE_TRACE_CONTROL0_MASK                         0x7F7F0000
#define XAIE2PGBL_PL_MODULE_TRACE_CONTROL0_TRACE_STOP_EVENT_LSB       24
#define XAIE2PGBL_PL_MODULE_TRACE_CONTROL0_TRACE_STOP_EVENT_WIDTH     7
#define XAIE2PGBL_PL_MODULE_TRACE_CONTROL0_TRACE_STOP_EVENT_MASK      0x7F000000
#define XAIE2PGBL_PL_MODULE_TRACE_CONTROL0_TRACE_STOP_EVENT_DEFVAL    0x0
#define XAIE2PGBL_PL_MODULE_TRACE_CONTROL0_TRACE_START_EVENT_LSB      16
#define XAIE2PGBL_PL_MODULE_TRACE_CONTROL0_TRACE_START_EVENT_WIDTH    7
#define XAIE2PGBL_PL_MODULE_TRACE_CONTROL0_TRACE_START_EVENT_MASK     0x007F0000
#define XAIE2PGBL_PL_MODULE_TRACE_CONTROL0_TRACE_START_EVENT_DEFVAL   0x0

#define XAIE2PGBL_PL_MODULE_TRACE_CONTROL1                              0x000340D4
#define XAIE2PGBL_PL_MODULE_TRACE_CONTROL1_WIDTH                        32
#define XAIE2PGBL_PL_MODULE_TRACE_CONTROL1_MASK                         0x0000701F
#define XAIE2PGBL_PL_MODULE_TRACE_CONTROL1_PACKET_TYPE_LSB            12
#define XAIE2PGBL_PL_MODULE_TRACE_CONTROL1_PACKET_TYPE_WIDTH          3
#define XAIE2PGBL_PL_MODULE_TRACE_CONTROL1_PACKET_TYPE_MASK           0x00007000
#define XAIE2PGBL_PL_MODULE_TRACE_CONTROL1_PACKET_TYPE_DEFVAL         0x0
#define XAIE2PGBL_PL_MODULE_TRACE_CONTROL1_ID_LSB                     0
#define XAIE2PGBL_PL_MODULE_TRACE_CONTROL1_ID_WIDTH                   5
#define XAIE2PGBL_PL_MODULE_TRACE_CONTROL1_ID_MASK                    0x0000001F
#define XAIE2PGBL_PL_MODULE_TRACE_CONTROL1_ID_DEFVAL                  0x0

#define XAIE2PGBL_PL_MODULE_TRACE_STATUS                                0x000340D8
#define XAIE2PGBL_PL_MODULE_TRACE_STATUS_WIDTH                          32
#define XAIE2PGBL_PL_MODULE_TRACE_STATUS_MASK                           0x00000307
#define XAIE2PGBL_PL_MODULE_TRACE_STATUS_STATE_LSB                    8
#define XAIE2PGBL_PL_MODULE_TRACE_STATUS_STATE_WIDTH                  2
#define XAIE2PGBL_PL_MODULE_TRACE_STATUS_STATE_MASK                   0x00000300
#define XAIE2PGBL_PL_MODULE_TRACE_STATUS_STATE_DEFVAL                 0x0
#define XAIE2PGBL_PL_MODULE_TRACE_STATUS_MODE_LSB                     0
#define XAIE2PGBL_PL_MODULE_TRACE_STATUS_MODE_WIDTH                   3
#define XAIE2PGBL_PL_MODULE_TRACE_STATUS_MODE_MASK                    0x00000007
#define XAIE2PGBL_PL_MODULE_TRACE_STATUS_MODE_DEFVAL                  0x0

#define XAIE2PGBL_PL_MODULE_TRACE_EVENT0                                0x000340E0
#define XAIE2PGBL_PL_MODULE_TRACE_EVENT0_WIDTH                          32
#define XAIE2PGBL_PL_MODULE_TRACE_EVENT0_MASK                           0x7F7F7F7F
#define XAIE2PGBL_PL_MODULE_TRACE_EVENT0_TRACE_EVENT3_LSB             24
#define XAIE2PGBL_PL_MODULE_TRACE_EVENT0_TRACE_EVENT3_WIDTH           7
#define XAIE2PGBL_PL_MODULE_TRACE_EVENT0_TRACE_EVENT3_MASK            0x7F000000
#define XAIE2PGBL_PL_MODULE_TRACE_EVENT0_TRACE_EVENT3_DEFVAL          0x0
#define XAIE2PGBL_PL_MODULE_TRACE_EVENT0_TRACE_EVENT2_LSB             16
#define XAIE2PGBL_PL_MODULE_TRACE_EVENT0_TRACE_EVENT2_WIDTH           7
#define XAIE2PGBL_PL_MODULE_TRACE_EVENT0_TRACE_EVENT2_MASK            0x007F0000
#define XAIE2PGBL_PL_MODULE_TRACE_EVENT0_TRACE_EVENT2_DEFVAL          0x0
#define XAIE2PGBL_PL_MODULE_TRACE_EVENT0_TRACE_EVENT1_LSB             8
#define XAIE2PGBL_PL_MODULE_TRACE_EVENT0_TRACE_EVENT1_WIDTH           7
#define XAIE2PGBL_PL_MODULE_TRACE_EVENT0_TRACE_EVENT1_MASK            0x00007F00
#define XAIE2PGBL_PL_MODULE_TRACE_EVENT0_TRACE_EVENT1_DEFVAL          0x0
#define XAIE2PGBL_PL_MODULE_TRACE_EVENT0_TRACE_EVENT0_LSB             0
#define XAIE2PGBL_PL_MODULE_TRACE_EVENT0_TRACE_EVENT0_WIDTH           7
#define XAIE2PGBL_PL_MODULE_TRACE_EVENT0_TRACE_EVENT0_MASK            0x0000007F
#define XAIE2PGBL_PL_MODULE_TRACE_EVENT0_TRACE_EVENT0_DEFVAL          0x0

#define XAIE2PGBL_PL_MODULE_TRACE_EVENT1                                0x000340E4
#define XAIE2PGBL_PL_MODULE_TRACE_EVENT1_WIDTH                          32
#define XAIE2PGBL_PL_MODULE_TRACE_EVENT1_MASK                           0x7F7F7F7F
#define XAIE2PGBL_PL_MODULE_TRACE_EVENT1_TRACE_EVENT7_LSB             24
#define XAIE2PGBL_PL_MODULE_TRACE_EVENT1_TRACE_EVENT7_WIDTH           7
#define XAIE2PGBL_PL_MODULE_TRACE_EVENT1_TRACE_EVENT7_MASK            0x7F000000
#define XAIE2PGBL_PL_MODULE_TRACE_EVENT1_TRACE_EVENT7_DEFVAL          0x0
#define XAIE2PGBL_PL_MODULE_TRACE_EVENT1_TRACE_EVENT6_LSB             16
#define XAIE2PGBL_PL_MODULE_TRACE_EVENT1_TRACE_EVENT6_WIDTH           7
#define XAIE2PGBL_PL_MODULE_TRACE_EVENT1_TRACE_EVENT6_MASK            0x007F0000
#define XAIE2PGBL_PL_MODULE_TRACE_EVENT1_TRACE_EVENT6_DEFVAL          0x0
#define XAIE2PGBL_PL_MODULE_TRACE_EVENT1_TRACE_EVENT5_LSB             8
#define XAIE2PGBL_PL_MODULE_TRACE_EVENT1_TRACE_EVENT5_WIDTH           7
#define XAIE2PGBL_PL_MODULE_TRACE_EVENT1_TRACE_EVENT5_MASK            0x00007F00
#define XAIE2PGBL_PL_MODULE_TRACE_EVENT1_TRACE_EVENT5_DEFVAL          0x0
#define XAIE2PGBL_PL_MODULE_TRACE_EVENT1_TRACE_EVENT4_LSB             0
#define XAIE2PGBL_PL_MODULE_TRACE_EVENT1_TRACE_EVENT4_WIDTH           7
#define XAIE2PGBL_PL_MODULE_TRACE_EVENT1_TRACE_EVENT4_MASK            0x0000007F
#define XAIE2PGBL_PL_MODULE_TRACE_EVENT1_TRACE_EVENT4_DEFVAL          0x0

#define XAIE2PGBL_PL_MODULE_TIMER_TRIG_EVENT_LOW_VALUE                  0x000340F0
#define XAIE2PGBL_PL_MODULE_TIMER_TRIG_EVENT_LOW_VALUE_WIDTH            32
#define XAIE2PGBL_PL_MODULE_TIMER_TRIG_EVENT_LOW_VALUE_MASK             0xFFFFFFFF
#define XAIE2PGBL_PL_MODULE_TIMER_TRIG_EVENT_LOW_VALUE_TIMERTRIGLOW_LSB 0
#define XAIE2PGBL_PL_MODULE_TIMER_TRIG_EVENT_LOW_VALUE_TIMERTRIGLOW_WIDTH 32
#define XAIE2PGBL_PL_MODULE_TIMER_TRIG_EVENT_LOW_VALUE_TIMERTRIGLOW_MASK 0xFFFFFFFF
#define XAIE2PGBL_PL_MODULE_TIMER_TRIG_EVENT_LOW_VALUE_TIMERTRIGLOW_DEFVAL 0xFFFFFFFF

#define XAIE2PGBL_PL_MODULE_TIMER_TRIG_EVENT_HIGH_VALUE                 0x000340F4
#define XAIE2PGBL_PL_MODULE_TIMER_TRIG_EVENT_HIGH_VALUE_WIDTH           32
#define XAIE2PGBL_PL_MODULE_TIMER_TRIG_EVENT_HIGH_VALUE_MASK            0xFFFFFFFF
#define XAIE2PGBL_PL_MODULE_TIMER_TRIG_EVENT_HIGH_VALUE_TIMERTRIGHIGH_LSB 0
#define XAIE2PGBL_PL_MODULE_TIMER_TRIG_EVENT_HIGH_VALUE_TIMERTRIGHIGH_WIDTH 32
#define XAIE2PGBL_PL_MODULE_TIMER_TRIG_EVENT_HIGH_VALUE_TIMERTRIGHIGH_MASK 0xFFFFFFFF
#define XAIE2PGBL_PL_MODULE_TIMER_TRIG_EVENT_HIGH_VALUE_TIMERTRIGHIGH_DEFVAL 0xFFFFFFFF

#define XAIE2PGBL_PL_MODULE_TIMER_LOW                                   0x000340F8
#define XAIE2PGBL_PL_MODULE_TIMER_LOW_WIDTH                             32
#define XAIE2PGBL_PL_MODULE_TIMER_LOW_MASK                              0xFFFFFFFF
#define XAIE2PGBL_PL_MODULE_TIMER_LOW_TIMERLOW_LSB                    0
#define XAIE2PGBL_PL_MODULE_TIMER_LOW_TIMERLOW_WIDTH                  32
#define XAIE2PGBL_PL_MODULE_TIMER_LOW_TIMERLOW_MASK                   0xFFFFFFFF
#define XAIE2PGBL_PL_MODULE_TIMER_LOW_TIMERLOW_DEFVAL                 0x0

#define XAIE2PGBL_PL_MODULE_TIMER_HIGH                                  0x000340FC
#define XAIE2PGBL_PL_MODULE_TIMER_HIGH_WIDTH                            32
#define XAIE2PGBL_PL_MODULE_TIMER_HIGH_MASK                             0xFFFFFFFF
#define XAIE2PGBL_PL_MODULE_TIMER_HIGH_TIMERHIGH_LSB                  0
#define XAIE2PGBL_PL_MODULE_TIMER_HIGH_TIMERHIGH_WIDTH                32
#define XAIE2PGBL_PL_MODULE_TIMER_HIGH_TIMERHIGH_MASK                 0xFFFFFFFF
#define XAIE2PGBL_PL_MODULE_TIMER_HIGH_TIMERHIGH_DEFVAL               0x0

#define XAIE2PGBL_PL_MODULE_EVENT_STATUS0                               0x00034200
#define XAIE2PGBL_PL_MODULE_EVENT_STATUS0_WIDTH                         32
#define XAIE2PGBL_PL_MODULE_EVENT_STATUS0_MASK                          0xFFFFFFFF
#define XAIE2PGBL_PL_MODULE_EVENT_STATUS0_EVENT_31_0_STATUS_LSB       0
#define XAIE2PGBL_PL_MODULE_EVENT_STATUS0_EVENT_31_0_STATUS_WIDTH     32
#define XAIE2PGBL_PL_MODULE_EVENT_STATUS0_EVENT_31_0_STATUS_MASK      0xFFFFFFFF
#define XAIE2PGBL_PL_MODULE_EVENT_STATUS0_EVENT_31_0_STATUS_DEFVAL    0x2

#define XAIE2PGBL_PL_MODULE_EVENT_STATUS1                               0x00034204
#define XAIE2PGBL_PL_MODULE_EVENT_STATUS1_WIDTH                         32
#define XAIE2PGBL_PL_MODULE_EVENT_STATUS1_MASK                          0xFFFFFFFF
#define XAIE2PGBL_PL_MODULE_EVENT_STATUS1_EVENT_63_32_STATUS_LSB      0
#define XAIE2PGBL_PL_MODULE_EVENT_STATUS1_EVENT_63_32_STATUS_WIDTH    32
#define XAIE2PGBL_PL_MODULE_EVENT_STATUS1_EVENT_63_32_STATUS_MASK     0xFFFFFFFF
#define XAIE2PGBL_PL_MODULE_EVENT_STATUS1_EVENT_63_32_STATUS_DEFVAL   0x0

#define XAIE2PGBL_PL_MODULE_EVENT_STATUS2                               0x00034208
#define XAIE2PGBL_PL_MODULE_EVENT_STATUS2_WIDTH                         32
#define XAIE2PGBL_PL_MODULE_EVENT_STATUS2_MASK                          0xFFFFFFFF
#define XAIE2PGBL_PL_MODULE_EVENT_STATUS2_EVENT_95_64_STATUS_LSB      0
#define XAIE2PGBL_PL_MODULE_EVENT_STATUS2_EVENT_95_64_STATUS_WIDTH    32
#define XAIE2PGBL_PL_MODULE_EVENT_STATUS2_EVENT_95_64_STATUS_MASK     0xFFFFFFFF
#define XAIE2PGBL_PL_MODULE_EVENT_STATUS2_EVENT_95_64_STATUS_DEFVAL   0x0

#define XAIE2PGBL_PL_MODULE_EVENT_STATUS3                               0x0003420C
#define XAIE2PGBL_PL_MODULE_EVENT_STATUS3_WIDTH                         32
#define XAIE2PGBL_PL_MODULE_EVENT_STATUS3_MASK                          0xFFFFFFFF
#define XAIE2PGBL_PL_MODULE_EVENT_STATUS3_EVENT_127_96_STATUS_LSB     0
#define XAIE2PGBL_PL_MODULE_EVENT_STATUS3_EVENT_127_96_STATUS_WIDTH   32
#define XAIE2PGBL_PL_MODULE_EVENT_STATUS3_EVENT_127_96_STATUS_MASK    0xFFFFFFFF
#define XAIE2PGBL_PL_MODULE_EVENT_STATUS3_EVENT_127_96_STATUS_DEFVAL  0x0

#define XAIE2PGBL_PL_MODULE_RESERVED0                                   0x00034210
#define XAIE2PGBL_PL_MODULE_RESERVED0_WIDTH                             32
#define XAIE2PGBL_PL_MODULE_RESERVED0_MASK                              0xFFFFFFFF

#define XAIE2PGBL_PL_MODULE_RESERVED1                                   0x00034214
#define XAIE2PGBL_PL_MODULE_RESERVED1_WIDTH                             32
#define XAIE2PGBL_PL_MODULE_RESERVED1_MASK                              0xFFFFFFFF

#define XAIE2PGBL_PL_MODULE_RESERVED2                                   0x00034218
#define XAIE2PGBL_PL_MODULE_RESERVED2_WIDTH                             32
#define XAIE2PGBL_PL_MODULE_RESERVED2_MASK                              0xFFFFFFFF

#define XAIE2PGBL_PL_MODULE_RESERVED3                                   0x0003421C
#define XAIE2PGBL_PL_MODULE_RESERVED3_WIDTH                             32
#define XAIE2PGBL_PL_MODULE_RESERVED3_MASK                              0xFFFFFFFF

#define XAIE2PGBL_PL_MODULE_COMBO_EVENT_INPUTS                          0x00034400
#define XAIE2PGBL_PL_MODULE_COMBO_EVENT_INPUTS_WIDTH                    32
#define XAIE2PGBL_PL_MODULE_COMBO_EVENT_INPUTS_MASK                     0x7F7F7F7F
#define XAIE2PGBL_PL_MODULE_COMBO_EVENT_INPUTS_EVENTD_LSB             24
#define XAIE2PGBL_PL_MODULE_COMBO_EVENT_INPUTS_EVENTD_WIDTH           7
#define XAIE2PGBL_PL_MODULE_COMBO_EVENT_INPUTS_EVENTD_MASK            0x7F000000
#define XAIE2PGBL_PL_MODULE_COMBO_EVENT_INPUTS_EVENTD_DEFVAL          0x0
#define XAIE2PGBL_PL_MODULE_COMBO_EVENT_INPUTS_EVENTC_LSB             16
#define XAIE2PGBL_PL_MODULE_COMBO_EVENT_INPUTS_EVENTC_WIDTH           7
#define XAIE2PGBL_PL_MODULE_COMBO_EVENT_INPUTS_EVENTC_MASK            0x007F0000
#define XAIE2PGBL_PL_MODULE_COMBO_EVENT_INPUTS_EVENTC_DEFVAL          0x0
#define XAIE2PGBL_PL_MODULE_COMBO_EVENT_INPUTS_EVENTB_LSB             8
#define XAIE2PGBL_PL_MODULE_COMBO_EVENT_INPUTS_EVENTB_WIDTH           7
#define XAIE2PGBL_PL_MODULE_COMBO_EVENT_INPUTS_EVENTB_MASK            0x00007F00
#define XAIE2PGBL_PL_MODULE_COMBO_EVENT_INPUTS_EVENTB_DEFVAL          0x0
#define XAIE2PGBL_PL_MODULE_COMBO_EVENT_INPUTS_EVENTA_LSB             0
#define XAIE2PGBL_PL_MODULE_COMBO_EVENT_INPUTS_EVENTA_WIDTH           7
#define XAIE2PGBL_PL_MODULE_COMBO_EVENT_INPUTS_EVENTA_MASK            0x0000007F
#define XAIE2PGBL_PL_MODULE_COMBO_EVENT_INPUTS_EVENTA_DEFVAL          0x0

#define XAIE2PGBL_PL_MODULE_COMBO_EVENT_CONTROL                         0x00034404
#define XAIE2PGBL_PL_MODULE_COMBO_EVENT_CONTROL_WIDTH                   32
#define XAIE2PGBL_PL_MODULE_COMBO_EVENT_CONTROL_MASK                    0x00030303
#define XAIE2PGBL_PL_MODULE_COMBO_EVENT_CONTROL_COMBO2_LSB            16
#define XAIE2PGBL_PL_MODULE_COMBO_EVENT_CONTROL_COMBO2_WIDTH          2
#define XAIE2PGBL_PL_MODULE_COMBO_EVENT_CONTROL_COMBO2_MASK           0x00030000
#define XAIE2PGBL_PL_MODULE_COMBO_EVENT_CONTROL_COMBO2_DEFVAL         0x0
#define XAIE2PGBL_PL_MODULE_COMBO_EVENT_CONTROL_COMBO1_LSB            8
#define XAIE2PGBL_PL_MODULE_COMBO_EVENT_CONTROL_COMBO1_WIDTH          2
#define XAIE2PGBL_PL_MODULE_COMBO_EVENT_CONTROL_COMBO1_MASK           0x00000300
#define XAIE2PGBL_PL_MODULE_COMBO_EVENT_CONTROL_COMBO1_DEFVAL         0x0
#define XAIE2PGBL_PL_MODULE_COMBO_EVENT_CONTROL_COMBO0_LSB            0
#define XAIE2PGBL_PL_MODULE_COMBO_EVENT_CONTROL_COMBO0_WIDTH          2
#define XAIE2PGBL_PL_MODULE_COMBO_EVENT_CONTROL_COMBO0_MASK           0x00000003
#define XAIE2PGBL_PL_MODULE_COMBO_EVENT_CONTROL_COMBO0_DEFVAL         0x0

#define XAIE2PGBL_PL_MODULE_EDGE_DETECTION_EVENT_CONTROL                0x00034408
#define XAIE2PGBL_PL_MODULE_EDGE_DETECTION_EVENT_CONTROL_WIDTH          32
#define XAIE2PGBL_PL_MODULE_EDGE_DETECTION_EVENT_CONTROL_MASK           0x067F067F
#define XAIE2PGBL_PL_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_1_TRIGGER_FALLING_LSB 26
#define XAIE2PGBL_PL_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_1_TRIGGER_FALLING_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_1_TRIGGER_FALLING_MASK 0x04000000
#define XAIE2PGBL_PL_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_1_TRIGGER_FALLING_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_1_TRIGGER_RISING_LSB 25
#define XAIE2PGBL_PL_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_1_TRIGGER_RISING_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_1_TRIGGER_RISING_MASK 0x02000000
#define XAIE2PGBL_PL_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_1_TRIGGER_RISING_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_EVENT_1_LSB 16
#define XAIE2PGBL_PL_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_EVENT_1_WIDTH 7
#define XAIE2PGBL_PL_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_EVENT_1_MASK 0x007F0000
#define XAIE2PGBL_PL_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_EVENT_1_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_0_TRIGGER_FALLING_LSB 10
#define XAIE2PGBL_PL_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_0_TRIGGER_FALLING_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_0_TRIGGER_FALLING_MASK 0x00000400
#define XAIE2PGBL_PL_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_0_TRIGGER_FALLING_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_0_TRIGGER_RISING_LSB 9
#define XAIE2PGBL_PL_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_0_TRIGGER_RISING_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_0_TRIGGER_RISING_MASK 0x00000200
#define XAIE2PGBL_PL_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_0_TRIGGER_RISING_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_EVENT_0_LSB 0
#define XAIE2PGBL_PL_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_EVENT_0_WIDTH 7
#define XAIE2PGBL_PL_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_EVENT_0_MASK 0x0000007F
#define XAIE2PGBL_PL_MODULE_EDGE_DETECTION_EVENT_CONTROL_EDGE_DETECTION_EVENT_0_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_0_ENABLE                        0x00034500
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_0_ENABLE_WIDTH                  32
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_0_ENABLE_MASK                   0x000003FF
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_0_ENABLE_EDGE_DETECTION_EVENT_1_LSB 9
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_0_ENABLE_EDGE_DETECTION_EVENT_1_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_0_ENABLE_EDGE_DETECTION_EVENT_1_MASK 0x00000200
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_0_ENABLE_EDGE_DETECTION_EVENT_1_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_0_ENABLE_EDGE_DETECTION_EVENT_0_LSB 8
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_0_ENABLE_EDGE_DETECTION_EVENT_0_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_0_ENABLE_EDGE_DETECTION_EVENT_0_MASK 0x00000100
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_0_ENABLE_EDGE_DETECTION_EVENT_0_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_0_ENABLE_COMBO_EVENT_3_LSB    7
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_0_ENABLE_COMBO_EVENT_3_WIDTH  1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_0_ENABLE_COMBO_EVENT_3_MASK   0x00000080
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_0_ENABLE_COMBO_EVENT_3_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_0_ENABLE_COMBO_EVENT_2_LSB    6
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_0_ENABLE_COMBO_EVENT_2_WIDTH  1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_0_ENABLE_COMBO_EVENT_2_MASK   0x00000040
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_0_ENABLE_COMBO_EVENT_2_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_0_ENABLE_COMBO_EVENT_1_LSB    5
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_0_ENABLE_COMBO_EVENT_1_WIDTH  1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_0_ENABLE_COMBO_EVENT_1_MASK   0x00000020
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_0_ENABLE_COMBO_EVENT_1_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_0_ENABLE_COMBO_EVENT_0_LSB    4
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_0_ENABLE_COMBO_EVENT_0_WIDTH  1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_0_ENABLE_COMBO_EVENT_0_MASK   0x00000010
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_0_ENABLE_COMBO_EVENT_0_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_0_ENABLE_PERF_CNT1_LSB        3
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_0_ENABLE_PERF_CNT1_WIDTH      1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_0_ENABLE_PERF_CNT1_MASK       0x00000008
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_0_ENABLE_PERF_CNT1_DEFVAL     0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_0_ENABLE_PERF_CNT0_LSB        2
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_0_ENABLE_PERF_CNT0_WIDTH      1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_0_ENABLE_PERF_CNT0_MASK       0x00000004
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_0_ENABLE_PERF_CNT0_DEFVAL     0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_0_ENABLE_TIMER_VALUE_REACHED_LSB 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_0_ENABLE_TIMER_VALUE_REACHED_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_0_ENABLE_TIMER_VALUE_REACHED_MASK 0x00000002
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_0_ENABLE_TIMER_VALUE_REACHED_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_0_ENABLE_TIMER_SYNC_LSB       0
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_0_ENABLE_TIMER_SYNC_WIDTH     1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_0_ENABLE_TIMER_SYNC_MASK      0x00000001
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_0_ENABLE_TIMER_SYNC_DEFVAL    0x1

#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE             0x00034504
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_WIDTH       32
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_MASK        0x00FFFFFF
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_MM2S_1_MEMORY_STARVATION_LSB 23
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_MM2S_1_MEMORY_STARVATION_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_MM2S_1_MEMORY_STARVATION_MASK 0x00800000
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_MM2S_1_MEMORY_STARVATION_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_MM2S_0_MEMORY_STARVATION_LSB 22
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_MM2S_0_MEMORY_STARVATION_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_MM2S_0_MEMORY_STARVATION_MASK 0x00400000
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_MM2S_0_MEMORY_STARVATION_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_MM2S_1_STREAM_BACKPRESSURE_LSB 21
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_MM2S_1_STREAM_BACKPRESSURE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_MM2S_1_STREAM_BACKPRESSURE_MASK 0x00200000
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_MM2S_1_STREAM_BACKPRESSURE_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_MM2S_0_STREAM_BACKPRESSURE_LSB 20
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_MM2S_0_STREAM_BACKPRESSURE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_MM2S_0_STREAM_BACKPRESSURE_MASK 0x00100000
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_MM2S_0_STREAM_BACKPRESSURE_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_S2MM_1_MEMORY_BACKPRESSURE_LSB 19
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_S2MM_1_MEMORY_BACKPRESSURE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_S2MM_1_MEMORY_BACKPRESSURE_MASK 0x00080000
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_S2MM_1_MEMORY_BACKPRESSURE_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_S2MM_0_MEMORY_BACKPRESSURE_LSB 18
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_S2MM_0_MEMORY_BACKPRESSURE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_S2MM_0_MEMORY_BACKPRESSURE_MASK 0x00040000
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_S2MM_0_MEMORY_BACKPRESSURE_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_S2MM_1_STREAM_STARVATION_LSB 17
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_S2MM_1_STREAM_STARVATION_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_S2MM_1_STREAM_STARVATION_MASK 0x00020000
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_S2MM_1_STREAM_STARVATION_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_S2MM_0_STREAM_STARVATION_LSB 16
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_S2MM_0_STREAM_STARVATION_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_S2MM_0_STREAM_STARVATION_MASK 0x00010000
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_S2MM_0_STREAM_STARVATION_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_MM2S_1_STALLED_LOCK_ACQUIRE_LSB 15
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_MM2S_1_STALLED_LOCK_ACQUIRE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_MM2S_1_STALLED_LOCK_ACQUIRE_MASK 0x00008000
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_MM2S_1_STALLED_LOCK_ACQUIRE_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_MM2S_0_STALLED_LOCK_ACQUIRE_LSB 14
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_MM2S_0_STALLED_LOCK_ACQUIRE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_MM2S_0_STALLED_LOCK_ACQUIRE_MASK 0x00004000
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_MM2S_0_STALLED_LOCK_ACQUIRE_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_S2MM_1_STALLED_LOCK_ACQUIRE_LSB 13
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_S2MM_1_STALLED_LOCK_ACQUIRE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_S2MM_1_STALLED_LOCK_ACQUIRE_MASK 0x00002000
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_S2MM_1_STALLED_LOCK_ACQUIRE_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_S2MM_0_STALLED_LOCK_ACQUIRE_LSB 12
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_S2MM_0_STALLED_LOCK_ACQUIRE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_S2MM_0_STALLED_LOCK_ACQUIRE_MASK 0x00001000
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_S2MM_0_STALLED_LOCK_ACQUIRE_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_MM2S_1_FINISHED_TASK_LSB 11
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_MM2S_1_FINISHED_TASK_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_MM2S_1_FINISHED_TASK_MASK 0x00000800
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_MM2S_1_FINISHED_TASK_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_MM2S_0_FINISHED_TASK_LSB 10
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_MM2S_0_FINISHED_TASK_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_MM2S_0_FINISHED_TASK_MASK 0x00000400
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_MM2S_0_FINISHED_TASK_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_S2MM_1_FINISHED_TASK_LSB 9
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_S2MM_1_FINISHED_TASK_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_S2MM_1_FINISHED_TASK_MASK 0x00000200
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_S2MM_1_FINISHED_TASK_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_S2MM_0_FINISHED_TASK_LSB 8
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_S2MM_0_FINISHED_TASK_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_S2MM_0_FINISHED_TASK_MASK 0x00000100
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_S2MM_0_FINISHED_TASK_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_MM2S_1_FINISHED_BD_LSB 7
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_MM2S_1_FINISHED_BD_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_MM2S_1_FINISHED_BD_MASK 0x00000080
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_MM2S_1_FINISHED_BD_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_MM2S_0_FINISHED_BD_LSB 6
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_MM2S_0_FINISHED_BD_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_MM2S_0_FINISHED_BD_MASK 0x00000040
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_MM2S_0_FINISHED_BD_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_S2MM_1_FINISHED_BD_LSB 5
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_S2MM_1_FINISHED_BD_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_S2MM_1_FINISHED_BD_MASK 0x00000020
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_S2MM_1_FINISHED_BD_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_S2MM_0_FINISHED_BD_LSB 4
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_S2MM_0_FINISHED_BD_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_S2MM_0_FINISHED_BD_MASK 0x00000010
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_S2MM_0_FINISHED_BD_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_MM2S_1_START_TASK_LSB 3
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_MM2S_1_START_TASK_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_MM2S_1_START_TASK_MASK 0x00000008
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_MM2S_1_START_TASK_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_MM2S_0_START_TASK_LSB 2
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_MM2S_0_START_TASK_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_MM2S_0_START_TASK_MASK 0x00000004
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_MM2S_0_START_TASK_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_S2MM_1_START_TASK_LSB 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_S2MM_1_START_TASK_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_S2MM_1_START_TASK_MASK 0x00000002
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_S2MM_1_START_TASK_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_S2MM_0_START_TASK_LSB 0
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_S2MM_0_START_TASK_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_S2MM_0_START_TASK_MASK 0x00000001
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_DMA_ACTIVITY_ENABLE_DMA_S2MM_0_START_TASK_DEFVAL 0x1

#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE                     0x00034508
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_WIDTH               32
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_MASK                0x00FFFFFF
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL5_EQUAL_TO_VALUE_LSB 23
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL5_EQUAL_TO_VALUE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL5_EQUAL_TO_VALUE_MASK 0x00800000
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL5_EQUAL_TO_VALUE_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL5_REL_LSB 22
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL5_REL_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL5_REL_MASK 0x00400000
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL5_REL_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL5_ACQ_GE_LSB 21
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL5_ACQ_GE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL5_ACQ_GE_MASK 0x00200000
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL5_ACQ_GE_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL5_ACQ_EQ_LSB 20
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL5_ACQ_EQ_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL5_ACQ_EQ_MASK 0x00100000
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL5_ACQ_EQ_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL4_EQUAL_TO_VALUE_LSB 19
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL4_EQUAL_TO_VALUE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL4_EQUAL_TO_VALUE_MASK 0x00080000
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL4_EQUAL_TO_VALUE_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL4_REL_LSB 18
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL4_REL_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL4_REL_MASK 0x00040000
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL4_REL_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL4_ACQ_GE_LSB 17
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL4_ACQ_GE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL4_ACQ_GE_MASK 0x00020000
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL4_ACQ_GE_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL4_ACQ_EQ_LSB 16
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL4_ACQ_EQ_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL4_ACQ_EQ_MASK 0x00010000
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL4_ACQ_EQ_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL3_EQUAL_TO_VALUE_LSB 15
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL3_EQUAL_TO_VALUE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL3_EQUAL_TO_VALUE_MASK 0x00008000
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL3_EQUAL_TO_VALUE_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL3_REL_LSB 14
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL3_REL_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL3_REL_MASK 0x00004000
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL3_REL_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL3_ACQ_GE_LSB 13
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL3_ACQ_GE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL3_ACQ_GE_MASK 0x00002000
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL3_ACQ_GE_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL3_ACQ_EQ_LSB 12
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL3_ACQ_EQ_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL3_ACQ_EQ_MASK 0x00001000
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL3_ACQ_EQ_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL2_EQUAL_TO_VALUE_LSB 11
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL2_EQUAL_TO_VALUE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL2_EQUAL_TO_VALUE_MASK 0x00000800
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL2_EQUAL_TO_VALUE_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL2_REL_LSB 10
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL2_REL_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL2_REL_MASK 0x00000400
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL2_REL_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL2_ACQ_GE_LSB 9
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL2_ACQ_GE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL2_ACQ_GE_MASK 0x00000200
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL2_ACQ_GE_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL2_ACQ_EQ_LSB 8
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL2_ACQ_EQ_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL2_ACQ_EQ_MASK 0x00000100
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL2_ACQ_EQ_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL1_EQUAL_TO_VALUE_LSB 7
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL1_EQUAL_TO_VALUE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL1_EQUAL_TO_VALUE_MASK 0x00000080
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL1_EQUAL_TO_VALUE_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL1_REL_LSB 6
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL1_REL_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL1_REL_MASK 0x00000040
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL1_REL_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL1_ACQ_GE_LSB 5
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL1_ACQ_GE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL1_ACQ_GE_MASK 0x00000020
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL1_ACQ_GE_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL1_ACQ_EQ_LSB 4
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL1_ACQ_EQ_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL1_ACQ_EQ_MASK 0x00000010
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL1_ACQ_EQ_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL0_EQUAL_TO_VALUE_LSB 3
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL0_EQUAL_TO_VALUE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL0_EQUAL_TO_VALUE_MASK 0x00000008
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL0_EQUAL_TO_VALUE_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL0_REL_LSB 2
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL0_REL_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL0_REL_MASK 0x00000004
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL0_REL_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL0_ACQ_GE_LSB 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL0_ACQ_GE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL0_ACQ_GE_MASK 0x00000002
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL0_ACQ_GE_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL0_ACQ_EQ_LSB 0
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL0_ACQ_EQ_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL0_ACQ_EQ_MASK 0x00000001
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_LOCK_ENABLE_LOCK_SEL0_ACQ_EQ_DEFVAL 0x1

#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE                   0x0003450C
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_WIDTH             32
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_MASK              0x00000FFF
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_DMA_TASK_TOKEN_STALL_LSB 11
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_DMA_TASK_TOKEN_STALL_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_DMA_TASK_TOKEN_STALL_MASK 0x00000800
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_DMA_TASK_TOKEN_STALL_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_LOCK_ERROR_LSB  10
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_LOCK_ERROR_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_LOCK_ERROR_MASK 0x00000400
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_LOCK_ERROR_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_DMA_MM2S_ERROR_LSB 9
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_DMA_MM2S_ERROR_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_DMA_MM2S_ERROR_MASK 0x00000200
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_DMA_MM2S_ERROR_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_DMA_S2MM_ERROR_LSB 8
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_DMA_S2MM_ERROR_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_DMA_S2MM_ERROR_MASK 0x00000100
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_DMA_S2MM_ERROR_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_AXI_MM_BYTE_STROBE_ERROR_LSB 7
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_AXI_MM_BYTE_STROBE_ERROR_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_AXI_MM_BYTE_STROBE_ERROR_MASK 0x00000080
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_AXI_MM_BYTE_STROBE_ERROR_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_AXI_MM_UNSECURE_ACCESS_IN_SECURE_MODE_LSB 6
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_AXI_MM_UNSECURE_ACCESS_IN_SECURE_MODE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_AXI_MM_UNSECURE_ACCESS_IN_SECURE_MODE_MASK 0x00000040
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_AXI_MM_UNSECURE_ACCESS_IN_SECURE_MODE_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_AXI_MM_UNSUPPORTED_TRAFFIC_LSB 5
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_AXI_MM_UNSUPPORTED_TRAFFIC_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_AXI_MM_UNSUPPORTED_TRAFFIC_MASK 0x00000020
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_AXI_MM_UNSUPPORTED_TRAFFIC_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_AXI_MM_SLAVE_NSU_ERROR_LSB 4
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_AXI_MM_SLAVE_NSU_ERROR_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_AXI_MM_SLAVE_NSU_ERROR_MASK 0x00000010
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_AXI_MM_SLAVE_NSU_ERROR_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_AXI_MM_DECODE_NSU_ERROR_LSB 3
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_AXI_MM_DECODE_NSU_ERROR_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_AXI_MM_DECODE_NSU_ERROR_MASK 0x00000008
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_AXI_MM_DECODE_NSU_ERROR_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_STREAM_SWITCH_PORT_PARITY_ERROR_LSB 2
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_STREAM_SWITCH_PORT_PARITY_ERROR_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_STREAM_SWITCH_PORT_PARITY_ERROR_MASK 0x00000004
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_STREAM_SWITCH_PORT_PARITY_ERROR_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_CONTROL_PKT_ERROR_LSB 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_CONTROL_PKT_ERROR_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_CONTROL_PKT_ERROR_MASK 0x00000002
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_CONTROL_PKT_ERROR_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_AXI_MM_SLAVE_TILE_ERROR_LSB 0
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_AXI_MM_SLAVE_TILE_ERROR_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_AXI_MM_SLAVE_TILE_ERROR_MASK 0x00000001
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_ERRORS_ENABLE_AXI_MM_SLAVE_TILE_ERROR_DEFVAL 0x1

#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE            0x00034510
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_WIDTH      32
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_MASK       0xFFFFFFFF
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_7_LSB 31
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_7_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_7_MASK 0x80000000
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_7_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_7_LSB 30
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_7_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_7_MASK 0x40000000
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_7_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_7_LSB 29
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_7_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_7_MASK 0x20000000
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_7_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_7_LSB 28
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_7_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_7_MASK 0x10000000
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_7_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_6_LSB 27
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_6_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_6_MASK 0x08000000
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_6_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_6_LSB 26
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_6_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_6_MASK 0x04000000
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_6_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_6_LSB 25
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_6_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_6_MASK 0x02000000
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_6_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_6_LSB 24
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_6_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_6_MASK 0x01000000
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_6_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_5_LSB 23
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_5_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_5_MASK 0x00800000
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_5_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_5_LSB 22
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_5_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_5_MASK 0x00400000
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_5_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_5_LSB 21
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_5_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_5_MASK 0x00200000
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_5_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_5_LSB 20
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_5_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_5_MASK 0x00100000
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_5_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_4_LSB 19
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_4_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_4_MASK 0x00080000
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_4_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_4_LSB 18
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_4_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_4_MASK 0x00040000
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_4_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_4_LSB 17
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_4_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_4_MASK 0x00020000
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_4_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_4_LSB 16
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_4_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_4_MASK 0x00010000
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_4_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_3_LSB 15
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_3_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_3_MASK 0x00008000
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_3_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_3_LSB 14
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_3_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_3_MASK 0x00004000
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_3_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_3_LSB 13
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_3_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_3_MASK 0x00002000
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_3_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_3_LSB 12
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_3_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_3_MASK 0x00001000
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_3_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_2_LSB 11
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_2_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_2_MASK 0x00000800
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_2_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_2_LSB 10
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_2_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_2_MASK 0x00000400
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_2_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_2_LSB 9
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_2_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_2_MASK 0x00000200
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_2_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_2_LSB 8
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_2_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_2_MASK 0x00000100
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_2_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_1_LSB 7
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_1_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_1_MASK 0x00000080
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_1_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_1_LSB 6
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_1_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_1_MASK 0x00000040
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_1_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_1_LSB 5
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_1_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_1_MASK 0x00000020
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_1_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_1_LSB 4
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_1_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_1_MASK 0x00000010
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_1_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_0_LSB 3
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_0_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_0_MASK 0x00000008
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_TLAST_0_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_0_LSB 2
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_0_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_0_MASK 0x00000004
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_STALLED_0_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_0_LSB 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_0_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_0_MASK 0x00000002
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_RUNNING_0_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_0_LSB 0
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_0_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_0_MASK 0x00000001
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_STREAM_SWITCH_ENABLE_PORT_IDLE_0_DEFVAL 0x1

#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE              0x00034514
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_WIDTH        32
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_MASK         0x0000FFFF
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_15_LSB 15
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_15_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_15_MASK 0x00008000
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_15_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_14_LSB 14
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_14_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_14_MASK 0x00004000
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_14_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_13_LSB 13
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_13_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_13_MASK 0x00002000
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_13_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_12_LSB 12
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_12_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_12_MASK 0x00001000
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_12_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_11_LSB 11
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_11_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_11_MASK 0x00000800
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_11_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_10_LSB 10
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_10_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_10_MASK 0x00000400
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_10_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_9_LSB 9
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_9_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_9_MASK 0x00000200
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_9_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_8_LSB 8
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_8_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_8_MASK 0x00000100
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_8_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_7_LSB 7
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_7_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_7_MASK 0x00000080
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_7_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_6_LSB 6
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_6_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_6_MASK 0x00000040
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_6_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_5_LSB 5
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_5_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_5_MASK 0x00000020
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_5_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_4_LSB 4
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_4_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_4_MASK 0x00000010
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_4_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_3_LSB 3
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_3_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_3_MASK 0x00000008
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_3_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_2_LSB 2
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_2_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_2_MASK 0x00000004
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_2_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_1_LSB 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_1_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_1_MASK 0x00000002
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_1_DEFVAL 0x1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_0_LSB 0
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_0_WIDTH 1
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_0_MASK 0x00000001
#define XAIE2PGBL_PL_MODULE_EVENT_GROUP_BROADCAST_A_ENABLE_BROADCAST_A_0_DEFVAL 0x1

#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_MASK_A       0x00035000
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_MASK_A_WIDTH 32
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_MASK_A_MASK  0x000FFFFF
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_MASK_A_IRQ_MASK_A_LSB 0
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_MASK_A_IRQ_MASK_A_WIDTH 20
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_MASK_A_IRQ_MASK_A_MASK 0x000FFFFF
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_MASK_A_IRQ_MASK_A_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_ENABLE_A     0x00035004
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_ENABLE_A_WIDTH 32
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_ENABLE_A_MASK 0x000FFFFF
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_ENABLE_A_ENABLE_A_LSB 0
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_ENABLE_A_ENABLE_A_WIDTH 20
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_ENABLE_A_ENABLE_A_MASK 0x000FFFFF
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_ENABLE_A_ENABLE_A_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_DISABLE_A    0x00035008
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_DISABLE_A_WIDTH 32
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_DISABLE_A_MASK 0x000FFFFF
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_DISABLE_A_DISABLE_A_LSB 0
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_DISABLE_A_DISABLE_A_WIDTH 20
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_DISABLE_A_DISABLE_A_MASK 0x000FFFFF
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_DISABLE_A_DISABLE_A_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_STATUS_A     0x0003500C
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_STATUS_A_WIDTH 32
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_STATUS_A_MASK 0x000FFFFF
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_STATUS_A_STATUS_A_LSB 0
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_STATUS_A_STATUS_A_WIDTH 20
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_STATUS_A_STATUS_A_MASK 0x000FFFFF
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_STATUS_A_STATUS_A_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_NO_A     0x00035010
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_NO_A_WIDTH 32
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_NO_A_MASK 0x0000000F
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_NO_A_IRQ_NO_A_LSB 0
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_NO_A_IRQ_NO_A_WIDTH 4
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_NO_A_IRQ_NO_A_MASK 0x0000000F
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_NO_A_IRQ_NO_A_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_EVENT_A  0x00035014
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_EVENT_A_WIDTH 32
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_EVENT_A_MASK 0x7F7F7F7F
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_EVENT_A_IRQ_EVENT3_LSB 24
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_EVENT_A_IRQ_EVENT3_WIDTH 7
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_EVENT_A_IRQ_EVENT3_MASK 0x7F000000
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_EVENT_A_IRQ_EVENT3_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_EVENT_A_IRQ_EVENT2_LSB 16
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_EVENT_A_IRQ_EVENT2_WIDTH 7
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_EVENT_A_IRQ_EVENT2_MASK 0x007F0000
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_EVENT_A_IRQ_EVENT2_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_EVENT_A_IRQ_EVENT1_LSB 8
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_EVENT_A_IRQ_EVENT1_WIDTH 7
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_EVENT_A_IRQ_EVENT1_MASK 0x00007F00
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_EVENT_A_IRQ_EVENT1_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_EVENT_A_IRQ_EVENT0_LSB 0
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_EVENT_A_IRQ_EVENT0_WIDTH 7
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_EVENT_A_IRQ_EVENT0_MASK 0x0000007F
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_EVENT_A_IRQ_EVENT0_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_BLOCK_NORTH_IN_A_SET 0x00035018
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_BLOCK_NORTH_IN_A_SET_WIDTH 32
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_BLOCK_NORTH_IN_A_SET_MASK 0x0000FFFF
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_BLOCK_NORTH_IN_A_SET_SET_LSB 0
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_BLOCK_NORTH_IN_A_SET_SET_WIDTH 16
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_BLOCK_NORTH_IN_A_SET_SET_MASK 0x0000FFFF
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_BLOCK_NORTH_IN_A_SET_SET_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_BLOCK_NORTH_IN_A_CLEAR 0x0003501C
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_BLOCK_NORTH_IN_A_CLEAR_WIDTH 32
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_BLOCK_NORTH_IN_A_CLEAR_MASK 0x0000FFFF
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_BLOCK_NORTH_IN_A_CLEAR_CLEAR_LSB 0
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_BLOCK_NORTH_IN_A_CLEAR_CLEAR_WIDTH 16
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_BLOCK_NORTH_IN_A_CLEAR_CLEAR_MASK 0x0000FFFF
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_BLOCK_NORTH_IN_A_CLEAR_CLEAR_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_BLOCK_NORTH_IN_A_VALUE 0x00035020
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_BLOCK_NORTH_IN_A_VALUE_WIDTH 32
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_BLOCK_NORTH_IN_A_VALUE_MASK 0x0000FFFF
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_BLOCK_NORTH_IN_A_VALUE_VALUE_LSB 0
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_BLOCK_NORTH_IN_A_VALUE_VALUE_WIDTH 16
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_BLOCK_NORTH_IN_A_VALUE_VALUE_MASK 0x0000FFFF
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_BLOCK_NORTH_IN_A_VALUE_VALUE_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_MASK_B       0x00035030
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_MASK_B_WIDTH 32
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_MASK_B_MASK  0x000FFFFF
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_MASK_B_IRQ_MASK_B_LSB 0
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_MASK_B_IRQ_MASK_B_WIDTH 20
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_MASK_B_IRQ_MASK_B_MASK 0x000FFFFF
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_MASK_B_IRQ_MASK_B_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_ENABLE_B     0x00035034
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_ENABLE_B_WIDTH 32
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_ENABLE_B_MASK 0x000FFFFF
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_ENABLE_B_ENABLE_B_LSB 0
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_ENABLE_B_ENABLE_B_WIDTH 20
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_ENABLE_B_ENABLE_B_MASK 0x000FFFFF
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_ENABLE_B_ENABLE_B_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_DISABLE_B    0x00035038
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_DISABLE_B_WIDTH 32
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_DISABLE_B_MASK 0x000FFFFF
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_DISABLE_B_DISABLE_B_LSB 0
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_DISABLE_B_DISABLE_B_WIDTH 20
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_DISABLE_B_DISABLE_B_MASK 0x000FFFFF
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_DISABLE_B_DISABLE_B_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_STATUS_B     0x0003503C
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_STATUS_B_WIDTH 32
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_STATUS_B_MASK 0x000FFFFF
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_STATUS_B_STATUS_B_LSB 0
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_STATUS_B_STATUS_B_WIDTH 20
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_STATUS_B_STATUS_B_MASK 0x000FFFFF
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_STATUS_B_STATUS_B_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_NO_B     0x00035040
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_NO_B_WIDTH 32
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_NO_B_MASK 0x0000000F
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_NO_B_IRQ_NO_B_LSB 0
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_NO_B_IRQ_NO_B_WIDTH 4
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_NO_B_IRQ_NO_B_MASK 0x0000000F
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_NO_B_IRQ_NO_B_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_EVENT_B  0x00035044
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_EVENT_B_WIDTH 32
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_EVENT_B_MASK 0x7F7F7F7F
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_EVENT_B_IRQ_EVENT3_LSB 24
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_EVENT_B_IRQ_EVENT3_WIDTH 7
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_EVENT_B_IRQ_EVENT3_MASK 0x7F000000
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_EVENT_B_IRQ_EVENT3_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_EVENT_B_IRQ_EVENT2_LSB 16
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_EVENT_B_IRQ_EVENT2_WIDTH 7
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_EVENT_B_IRQ_EVENT2_MASK 0x007F0000
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_EVENT_B_IRQ_EVENT2_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_EVENT_B_IRQ_EVENT1_LSB 8
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_EVENT_B_IRQ_EVENT1_WIDTH 7
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_EVENT_B_IRQ_EVENT1_MASK 0x00007F00
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_EVENT_B_IRQ_EVENT1_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_EVENT_B_IRQ_EVENT0_LSB 0
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_EVENT_B_IRQ_EVENT0_WIDTH 7
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_EVENT_B_IRQ_EVENT0_MASK 0x0000007F
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_IRQ_EVENT_B_IRQ_EVENT0_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_BLOCK_NORTH_IN_B_SET 0x00035048
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_BLOCK_NORTH_IN_B_SET_WIDTH 32
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_BLOCK_NORTH_IN_B_SET_MASK 0x0000FFFF
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_BLOCK_NORTH_IN_B_SET_SET_LSB 0
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_BLOCK_NORTH_IN_B_SET_SET_WIDTH 16
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_BLOCK_NORTH_IN_B_SET_SET_MASK 0x0000FFFF
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_BLOCK_NORTH_IN_B_SET_SET_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_BLOCK_NORTH_IN_B_CLEAR 0x0003504C
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_BLOCK_NORTH_IN_B_CLEAR_WIDTH 32
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_BLOCK_NORTH_IN_B_CLEAR_MASK 0x0000FFFF
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_BLOCK_NORTH_IN_B_CLEAR_CLEAR_LSB 0
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_BLOCK_NORTH_IN_B_CLEAR_CLEAR_WIDTH 16
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_BLOCK_NORTH_IN_B_CLEAR_CLEAR_MASK 0x0000FFFF
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_BLOCK_NORTH_IN_B_CLEAR_CLEAR_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_BLOCK_NORTH_IN_B_VALUE 0x00035050
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_BLOCK_NORTH_IN_B_VALUE_WIDTH 32
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_BLOCK_NORTH_IN_B_VALUE_MASK 0x0000FFFF
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_BLOCK_NORTH_IN_B_VALUE_VALUE_LSB 0
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_BLOCK_NORTH_IN_B_VALUE_VALUE_WIDTH 16
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_BLOCK_NORTH_IN_B_VALUE_VALUE_MASK 0x0000FFFF
#define XAIE2PGBL_PL_MODULE_INTERRUPT_CONTROLLER_1ST_LEVEL_BLOCK_NORTH_IN_B_VALUE_VALUE_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_BISR_CACHE_CTRL                             0x00036000
#define XAIE2PGBL_PL_MODULE_BISR_CACHE_CTRL_WIDTH                       32
#define XAIE2PGBL_PL_MODULE_BISR_CACHE_CTRL_MASK                        0x00000011
#define XAIE2PGBL_PL_MODULE_BISR_CACHE_CTRL_CLEAR_LSB                 4
#define XAIE2PGBL_PL_MODULE_BISR_CACHE_CTRL_CLEAR_WIDTH               1
#define XAIE2PGBL_PL_MODULE_BISR_CACHE_CTRL_CLEAR_MASK                0x00000010
#define XAIE2PGBL_PL_MODULE_BISR_CACHE_CTRL_CLEAR_DEFVAL              0x0
#define XAIE2PGBL_PL_MODULE_BISR_CACHE_CTRL_TRIGGER_LSB               0
#define XAIE2PGBL_PL_MODULE_BISR_CACHE_CTRL_TRIGGER_WIDTH             1
#define XAIE2PGBL_PL_MODULE_BISR_CACHE_CTRL_TRIGGER_MASK              0x00000001
#define XAIE2PGBL_PL_MODULE_BISR_CACHE_CTRL_TRIGGER_DEFVAL            0x0

#define XAIE2PGBL_PL_MODULE_BISR_CACHE_STATUS                           0x00036008
#define XAIE2PGBL_PL_MODULE_BISR_CACHE_STATUS_WIDTH                     32
#define XAIE2PGBL_PL_MODULE_BISR_CACHE_STATUS_MASK                      0x00000003
#define XAIE2PGBL_PL_MODULE_BISR_CACHE_STATUS_PASS_LSB                1
#define XAIE2PGBL_PL_MODULE_BISR_CACHE_STATUS_PASS_WIDTH              1
#define XAIE2PGBL_PL_MODULE_BISR_CACHE_STATUS_PASS_MASK               0x00000002
#define XAIE2PGBL_PL_MODULE_BISR_CACHE_STATUS_PASS_DEFVAL             0x0
#define XAIE2PGBL_PL_MODULE_BISR_CACHE_STATUS_DONE_LSB                0
#define XAIE2PGBL_PL_MODULE_BISR_CACHE_STATUS_DONE_WIDTH              1
#define XAIE2PGBL_PL_MODULE_BISR_CACHE_STATUS_DONE_MASK               0x00000001
#define XAIE2PGBL_PL_MODULE_BISR_CACHE_STATUS_DONE_DEFVAL             0x0

#define XAIE2PGBL_PL_MODULE_BISR_CACHE_DATA0                            0x00036010
#define XAIE2PGBL_PL_MODULE_BISR_CACHE_DATA0_WIDTH                      32
#define XAIE2PGBL_PL_MODULE_BISR_CACHE_DATA0_MASK                       0xFFFFFFFF
#define XAIE2PGBL_PL_MODULE_BISR_CACHE_DATA0_DATA_LSB                 0
#define XAIE2PGBL_PL_MODULE_BISR_CACHE_DATA0_DATA_WIDTH               32
#define XAIE2PGBL_PL_MODULE_BISR_CACHE_DATA0_DATA_MASK                0xFFFFFFFF
#define XAIE2PGBL_PL_MODULE_BISR_CACHE_DATA0_DATA_DEFVAL              0x0

#define XAIE2PGBL_PL_MODULE_BISR_CACHE_DATA1                            0x00036014
#define XAIE2PGBL_PL_MODULE_BISR_CACHE_DATA1_WIDTH                      32
#define XAIE2PGBL_PL_MODULE_BISR_CACHE_DATA1_MASK                       0xFFFFFFFF
#define XAIE2PGBL_PL_MODULE_BISR_CACHE_DATA1_DATA_LSB                 0
#define XAIE2PGBL_PL_MODULE_BISR_CACHE_DATA1_DATA_WIDTH               32
#define XAIE2PGBL_PL_MODULE_BISR_CACHE_DATA1_DATA_MASK                0xFFFFFFFF
#define XAIE2PGBL_PL_MODULE_BISR_CACHE_DATA1_DATA_DEFVAL              0x0

#define XAIE2PGBL_PL_MODULE_BISR_CACHE_DATA2                            0x00036018
#define XAIE2PGBL_PL_MODULE_BISR_CACHE_DATA2_WIDTH                      32
#define XAIE2PGBL_PL_MODULE_BISR_CACHE_DATA2_MASK                       0xFFFFFFFF
#define XAIE2PGBL_PL_MODULE_BISR_CACHE_DATA2_DATA_LSB                 0
#define XAIE2PGBL_PL_MODULE_BISR_CACHE_DATA2_DATA_WIDTH               32
#define XAIE2PGBL_PL_MODULE_BISR_CACHE_DATA2_DATA_MASK                0xFFFFFFFF
#define XAIE2PGBL_PL_MODULE_BISR_CACHE_DATA2_DATA_DEFVAL              0x0

#define XAIE2PGBL_PL_MODULE_BISR_CACHE_DATA3                            0x0003601C
#define XAIE2PGBL_PL_MODULE_BISR_CACHE_DATA3_WIDTH                      32
#define XAIE2PGBL_PL_MODULE_BISR_CACHE_DATA3_MASK                       0xFFFFFFFF
#define XAIE2PGBL_PL_MODULE_BISR_CACHE_DATA3_DATA_LSB                 0
#define XAIE2PGBL_PL_MODULE_BISR_CACHE_DATA3_DATA_WIDTH               32
#define XAIE2PGBL_PL_MODULE_BISR_CACHE_DATA3_DATA_MASK                0xFFFFFFFF
#define XAIE2PGBL_PL_MODULE_BISR_CACHE_DATA3_DATA_DEFVAL              0x0

#define XAIE2PGBL_PL_MODULE_BISR_TEST_DATA0                             0x00036020
#define XAIE2PGBL_PL_MODULE_BISR_TEST_DATA0_WIDTH                       32
#define XAIE2PGBL_PL_MODULE_BISR_TEST_DATA0_MASK                        0xFFFFFFFF
#define XAIE2PGBL_PL_MODULE_BISR_TEST_DATA0_DATA_LSB                  0
#define XAIE2PGBL_PL_MODULE_BISR_TEST_DATA0_DATA_WIDTH                32
#define XAIE2PGBL_PL_MODULE_BISR_TEST_DATA0_DATA_MASK                 0xFFFFFFFF
#define XAIE2PGBL_PL_MODULE_BISR_TEST_DATA0_DATA_DEFVAL               0x0

#define XAIE2PGBL_PL_MODULE_BISR_TEST_DATA1                             0x00036024
#define XAIE2PGBL_PL_MODULE_BISR_TEST_DATA1_WIDTH                       32
#define XAIE2PGBL_PL_MODULE_BISR_TEST_DATA1_MASK                        0xFFFFFFFF
#define XAIE2PGBL_PL_MODULE_BISR_TEST_DATA1_DATA_LSB                  0
#define XAIE2PGBL_PL_MODULE_BISR_TEST_DATA1_DATA_WIDTH                32
#define XAIE2PGBL_PL_MODULE_BISR_TEST_DATA1_DATA_MASK                 0xFFFFFFFF
#define XAIE2PGBL_PL_MODULE_BISR_TEST_DATA1_DATA_DEFVAL               0x0

#define XAIE2PGBL_PL_MODULE_BISR_TEST_DATA2                             0x00036028
#define XAIE2PGBL_PL_MODULE_BISR_TEST_DATA2_WIDTH                       32
#define XAIE2PGBL_PL_MODULE_BISR_TEST_DATA2_MASK                        0xFFFFFFFF
#define XAIE2PGBL_PL_MODULE_BISR_TEST_DATA2_DATA_LSB                  0
#define XAIE2PGBL_PL_MODULE_BISR_TEST_DATA2_DATA_WIDTH                32
#define XAIE2PGBL_PL_MODULE_BISR_TEST_DATA2_DATA_MASK                 0xFFFFFFFF
#define XAIE2PGBL_PL_MODULE_BISR_TEST_DATA2_DATA_DEFVAL               0x0

#define XAIE2PGBL_PL_MODULE_BISR_TEST_DATA3                             0x0003602C
#define XAIE2PGBL_PL_MODULE_BISR_TEST_DATA3_WIDTH                       32
#define XAIE2PGBL_PL_MODULE_BISR_TEST_DATA3_MASK                        0xFFFFFFFF
#define XAIE2PGBL_PL_MODULE_BISR_TEST_DATA3_DATA_LSB                  0
#define XAIE2PGBL_PL_MODULE_BISR_TEST_DATA3_DATA_WIDTH                32
#define XAIE2PGBL_PL_MODULE_BISR_TEST_DATA3_DATA_MASK                 0xFFFFFFFF
#define XAIE2PGBL_PL_MODULE_BISR_TEST_DATA3_DATA_DEFVAL               0x0

#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_TILE_CTRL       0x0003F000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_TILE_CTRL_WIDTH 32
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_TILE_CTRL_MASK  0xC00000FF
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_TILE_CTRL_MASTER_ENABLE_LSB 31
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_TILE_CTRL_MASTER_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_TILE_CTRL_MASTER_ENABLE_MASK 0x80000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_TILE_CTRL_MASTER_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_TILE_CTRL_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_TILE_CTRL_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_TILE_CTRL_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_TILE_CTRL_PACKET_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_TILE_CTRL_DROP_HEADER_LSB 7
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_TILE_CTRL_DROP_HEADER_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_TILE_CTRL_DROP_HEADER_MASK 0x00000080
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_TILE_CTRL_DROP_HEADER_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_TILE_CTRL_CONFIGURATION_LSB 0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_TILE_CTRL_CONFIGURATION_WIDTH 7
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_TILE_CTRL_CONFIGURATION_MASK 0x0000007F
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_TILE_CTRL_CONFIGURATION_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_FIFO0           0x0003F004
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_FIFO0_WIDTH     32
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_FIFO0_MASK      0xC00000FF
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_FIFO0_MASTER_ENABLE_LSB 31
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_FIFO0_MASTER_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_FIFO0_MASTER_ENABLE_MASK 0x80000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_FIFO0_MASTER_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_FIFO0_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_FIFO0_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_FIFO0_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_FIFO0_PACKET_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_FIFO0_DROP_HEADER_LSB 7
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_FIFO0_DROP_HEADER_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_FIFO0_DROP_HEADER_MASK 0x00000080
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_FIFO0_DROP_HEADER_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_FIFO0_CONFIGURATION_LSB 0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_FIFO0_CONFIGURATION_WIDTH 7
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_FIFO0_CONFIGURATION_MASK 0x0000007F
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_FIFO0_CONFIGURATION_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH0          0x0003F008
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH0_WIDTH    32
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH0_MASK     0xC00000FF
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH0_MASTER_ENABLE_LSB 31
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH0_MASTER_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH0_MASTER_ENABLE_MASK 0x80000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH0_MASTER_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH0_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH0_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH0_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH0_PACKET_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH0_DROP_HEADER_LSB 7
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH0_DROP_HEADER_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH0_DROP_HEADER_MASK 0x00000080
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH0_DROP_HEADER_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH0_CONFIGURATION_LSB 0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH0_CONFIGURATION_WIDTH 7
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH0_CONFIGURATION_MASK 0x0000007F
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH0_CONFIGURATION_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH1          0x0003F00C
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH1_WIDTH    32
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH1_MASK     0xC00000FF
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH1_MASTER_ENABLE_LSB 31
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH1_MASTER_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH1_MASTER_ENABLE_MASK 0x80000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH1_MASTER_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH1_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH1_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH1_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH1_PACKET_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH1_DROP_HEADER_LSB 7
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH1_DROP_HEADER_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH1_DROP_HEADER_MASK 0x00000080
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH1_DROP_HEADER_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH1_CONFIGURATION_LSB 0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH1_CONFIGURATION_WIDTH 7
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH1_CONFIGURATION_MASK 0x0000007F
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH1_CONFIGURATION_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH2          0x0003F010
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH2_WIDTH    32
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH2_MASK     0xC00000FF
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH2_MASTER_ENABLE_LSB 31
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH2_MASTER_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH2_MASTER_ENABLE_MASK 0x80000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH2_MASTER_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH2_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH2_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH2_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH2_PACKET_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH2_DROP_HEADER_LSB 7
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH2_DROP_HEADER_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH2_DROP_HEADER_MASK 0x00000080
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH2_DROP_HEADER_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH2_CONFIGURATION_LSB 0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH2_CONFIGURATION_WIDTH 7
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH2_CONFIGURATION_MASK 0x0000007F
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH2_CONFIGURATION_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH3          0x0003F014
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH3_WIDTH    32
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH3_MASK     0xC00000FF
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH3_MASTER_ENABLE_LSB 31
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH3_MASTER_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH3_MASTER_ENABLE_MASK 0x80000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH3_MASTER_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH3_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH3_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH3_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH3_PACKET_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH3_DROP_HEADER_LSB 7
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH3_DROP_HEADER_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH3_DROP_HEADER_MASK 0x00000080
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH3_DROP_HEADER_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH3_CONFIGURATION_LSB 0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH3_CONFIGURATION_WIDTH 7
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH3_CONFIGURATION_MASK 0x0000007F
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH3_CONFIGURATION_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH4          0x0003F018
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH4_WIDTH    32
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH4_MASK     0xC00000FF
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH4_MASTER_ENABLE_LSB 31
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH4_MASTER_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH4_MASTER_ENABLE_MASK 0x80000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH4_MASTER_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH4_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH4_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH4_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH4_PACKET_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH4_DROP_HEADER_LSB 7
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH4_DROP_HEADER_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH4_DROP_HEADER_MASK 0x00000080
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH4_DROP_HEADER_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH4_CONFIGURATION_LSB 0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH4_CONFIGURATION_WIDTH 7
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH4_CONFIGURATION_MASK 0x0000007F
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH4_CONFIGURATION_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH5          0x0003F01C
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH5_WIDTH    32
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH5_MASK     0xC00000FF
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH5_MASTER_ENABLE_LSB 31
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH5_MASTER_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH5_MASTER_ENABLE_MASK 0x80000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH5_MASTER_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH5_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH5_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH5_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH5_PACKET_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH5_DROP_HEADER_LSB 7
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH5_DROP_HEADER_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH5_DROP_HEADER_MASK 0x00000080
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH5_DROP_HEADER_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH5_CONFIGURATION_LSB 0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH5_CONFIGURATION_WIDTH 7
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH5_CONFIGURATION_MASK 0x0000007F
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_SOUTH5_CONFIGURATION_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST0           0x0003F020
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST0_WIDTH     32
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST0_MASK      0xC00000FF
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST0_MASTER_ENABLE_LSB 31
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST0_MASTER_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST0_MASTER_ENABLE_MASK 0x80000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST0_MASTER_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST0_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST0_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST0_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST0_PACKET_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST0_DROP_HEADER_LSB 7
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST0_DROP_HEADER_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST0_DROP_HEADER_MASK 0x00000080
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST0_DROP_HEADER_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST0_CONFIGURATION_LSB 0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST0_CONFIGURATION_WIDTH 7
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST0_CONFIGURATION_MASK 0x0000007F
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST0_CONFIGURATION_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST1           0x0003F024
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST1_WIDTH     32
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST1_MASK      0xC00000FF
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST1_MASTER_ENABLE_LSB 31
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST1_MASTER_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST1_MASTER_ENABLE_MASK 0x80000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST1_MASTER_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST1_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST1_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST1_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST1_PACKET_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST1_DROP_HEADER_LSB 7
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST1_DROP_HEADER_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST1_DROP_HEADER_MASK 0x00000080
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST1_DROP_HEADER_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST1_CONFIGURATION_LSB 0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST1_CONFIGURATION_WIDTH 7
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST1_CONFIGURATION_MASK 0x0000007F
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST1_CONFIGURATION_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST2           0x0003F028
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST2_WIDTH     32
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST2_MASK      0xC00000FF
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST2_MASTER_ENABLE_LSB 31
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST2_MASTER_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST2_MASTER_ENABLE_MASK 0x80000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST2_MASTER_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST2_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST2_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST2_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST2_PACKET_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST2_DROP_HEADER_LSB 7
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST2_DROP_HEADER_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST2_DROP_HEADER_MASK 0x00000080
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST2_DROP_HEADER_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST2_CONFIGURATION_LSB 0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST2_CONFIGURATION_WIDTH 7
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST2_CONFIGURATION_MASK 0x0000007F
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST2_CONFIGURATION_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST3           0x0003F02C
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST3_WIDTH     32
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST3_MASK      0xC00000FF
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST3_MASTER_ENABLE_LSB 31
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST3_MASTER_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST3_MASTER_ENABLE_MASK 0x80000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST3_MASTER_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST3_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST3_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST3_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST3_PACKET_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST3_DROP_HEADER_LSB 7
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST3_DROP_HEADER_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST3_DROP_HEADER_MASK 0x00000080
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST3_DROP_HEADER_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST3_CONFIGURATION_LSB 0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST3_CONFIGURATION_WIDTH 7
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST3_CONFIGURATION_MASK 0x0000007F
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_WEST3_CONFIGURATION_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH0          0x0003F030
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH0_WIDTH    32
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH0_MASK     0xC00000FF
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH0_MASTER_ENABLE_LSB 31
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH0_MASTER_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH0_MASTER_ENABLE_MASK 0x80000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH0_MASTER_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH0_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH0_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH0_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH0_PACKET_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH0_DROP_HEADER_LSB 7
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH0_DROP_HEADER_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH0_DROP_HEADER_MASK 0x00000080
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH0_DROP_HEADER_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH0_CONFIGURATION_LSB 0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH0_CONFIGURATION_WIDTH 7
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH0_CONFIGURATION_MASK 0x0000007F
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH0_CONFIGURATION_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH1          0x0003F034
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH1_WIDTH    32
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH1_MASK     0xC00000FF
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH1_MASTER_ENABLE_LSB 31
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH1_MASTER_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH1_MASTER_ENABLE_MASK 0x80000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH1_MASTER_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH1_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH1_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH1_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH1_PACKET_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH1_DROP_HEADER_LSB 7
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH1_DROP_HEADER_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH1_DROP_HEADER_MASK 0x00000080
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH1_DROP_HEADER_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH1_CONFIGURATION_LSB 0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH1_CONFIGURATION_WIDTH 7
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH1_CONFIGURATION_MASK 0x0000007F
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH1_CONFIGURATION_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH2          0x0003F038
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH2_WIDTH    32
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH2_MASK     0xC00000FF
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH2_MASTER_ENABLE_LSB 31
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH2_MASTER_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH2_MASTER_ENABLE_MASK 0x80000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH2_MASTER_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH2_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH2_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH2_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH2_PACKET_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH2_DROP_HEADER_LSB 7
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH2_DROP_HEADER_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH2_DROP_HEADER_MASK 0x00000080
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH2_DROP_HEADER_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH2_CONFIGURATION_LSB 0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH2_CONFIGURATION_WIDTH 7
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH2_CONFIGURATION_MASK 0x0000007F
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH2_CONFIGURATION_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH3          0x0003F03C
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH3_WIDTH    32
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH3_MASK     0xC00000FF
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH3_MASTER_ENABLE_LSB 31
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH3_MASTER_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH3_MASTER_ENABLE_MASK 0x80000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH3_MASTER_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH3_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH3_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH3_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH3_PACKET_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH3_DROP_HEADER_LSB 7
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH3_DROP_HEADER_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH3_DROP_HEADER_MASK 0x00000080
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH3_DROP_HEADER_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH3_CONFIGURATION_LSB 0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH3_CONFIGURATION_WIDTH 7
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH3_CONFIGURATION_MASK 0x0000007F
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH3_CONFIGURATION_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH4          0x0003F040
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH4_WIDTH    32
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH4_MASK     0xC00000FF
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH4_MASTER_ENABLE_LSB 31
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH4_MASTER_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH4_MASTER_ENABLE_MASK 0x80000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH4_MASTER_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH4_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH4_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH4_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH4_PACKET_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH4_DROP_HEADER_LSB 7
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH4_DROP_HEADER_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH4_DROP_HEADER_MASK 0x00000080
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH4_DROP_HEADER_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH4_CONFIGURATION_LSB 0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH4_CONFIGURATION_WIDTH 7
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH4_CONFIGURATION_MASK 0x0000007F
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH4_CONFIGURATION_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH5          0x0003F044
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH5_WIDTH    32
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH5_MASK     0xC00000FF
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH5_MASTER_ENABLE_LSB 31
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH5_MASTER_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH5_MASTER_ENABLE_MASK 0x80000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH5_MASTER_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH5_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH5_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH5_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH5_PACKET_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH5_DROP_HEADER_LSB 7
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH5_DROP_HEADER_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH5_DROP_HEADER_MASK 0x00000080
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH5_DROP_HEADER_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH5_CONFIGURATION_LSB 0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH5_CONFIGURATION_WIDTH 7
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH5_CONFIGURATION_MASK 0x0000007F
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_NORTH5_CONFIGURATION_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST0           0x0003F048
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST0_WIDTH     32
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST0_MASK      0xC00000FF
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST0_MASTER_ENABLE_LSB 31
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST0_MASTER_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST0_MASTER_ENABLE_MASK 0x80000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST0_MASTER_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST0_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST0_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST0_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST0_PACKET_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST0_DROP_HEADER_LSB 7
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST0_DROP_HEADER_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST0_DROP_HEADER_MASK 0x00000080
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST0_DROP_HEADER_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST0_CONFIGURATION_LSB 0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST0_CONFIGURATION_WIDTH 7
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST0_CONFIGURATION_MASK 0x0000007F
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST0_CONFIGURATION_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST1           0x0003F04C
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST1_WIDTH     32
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST1_MASK      0xC00000FF
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST1_MASTER_ENABLE_LSB 31
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST1_MASTER_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST1_MASTER_ENABLE_MASK 0x80000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST1_MASTER_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST1_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST1_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST1_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST1_PACKET_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST1_DROP_HEADER_LSB 7
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST1_DROP_HEADER_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST1_DROP_HEADER_MASK 0x00000080
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST1_DROP_HEADER_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST1_CONFIGURATION_LSB 0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST1_CONFIGURATION_WIDTH 7
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST1_CONFIGURATION_MASK 0x0000007F
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST1_CONFIGURATION_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST2           0x0003F050
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST2_WIDTH     32
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST2_MASK      0xC00000FF
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST2_MASTER_ENABLE_LSB 31
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST2_MASTER_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST2_MASTER_ENABLE_MASK 0x80000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST2_MASTER_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST2_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST2_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST2_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST2_PACKET_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST2_DROP_HEADER_LSB 7
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST2_DROP_HEADER_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST2_DROP_HEADER_MASK 0x00000080
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST2_DROP_HEADER_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST2_CONFIGURATION_LSB 0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST2_CONFIGURATION_WIDTH 7
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST2_CONFIGURATION_MASK 0x0000007F
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST2_CONFIGURATION_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST3           0x0003F054
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST3_WIDTH     32
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST3_MASK      0xC00000FF
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST3_MASTER_ENABLE_LSB 31
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST3_MASTER_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST3_MASTER_ENABLE_MASK 0x80000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST3_MASTER_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST3_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST3_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST3_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST3_PACKET_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST3_DROP_HEADER_LSB 7
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST3_DROP_HEADER_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST3_DROP_HEADER_MASK 0x00000080
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST3_DROP_HEADER_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST3_CONFIGURATION_LSB 0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST3_CONFIGURATION_WIDTH 7
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST3_CONFIGURATION_MASK 0x0000007F
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_MASTER_CONFIG_EAST3_CONFIGURATION_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_TILE_CTRL        0x0003F100
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_TILE_CTRL_WIDTH  32
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_TILE_CTRL_MASK   0xC0000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_TILE_CTRL_SLAVE_ENABLE_LSB 31
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_TILE_CTRL_SLAVE_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_TILE_CTRL_SLAVE_ENABLE_MASK 0x80000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_TILE_CTRL_SLAVE_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_TILE_CTRL_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_TILE_CTRL_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_TILE_CTRL_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_TILE_CTRL_PACKET_ENABLE_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_FIFO_0           0x0003F104
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_FIFO_0_WIDTH     32
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_FIFO_0_MASK      0xC0000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_FIFO_0_SLAVE_ENABLE_LSB 31
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_FIFO_0_SLAVE_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_FIFO_0_SLAVE_ENABLE_MASK 0x80000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_FIFO_0_SLAVE_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_FIFO_0_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_FIFO_0_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_FIFO_0_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_FIFO_0_PACKET_ENABLE_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_0          0x0003F108
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_0_WIDTH    32
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_0_MASK     0xC0000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_0_SLAVE_ENABLE_LSB 31
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_0_SLAVE_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_0_SLAVE_ENABLE_MASK 0x80000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_0_SLAVE_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_0_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_0_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_0_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_0_PACKET_ENABLE_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_1          0x0003F10C
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_1_WIDTH    32
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_1_MASK     0xC0000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_1_SLAVE_ENABLE_LSB 31
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_1_SLAVE_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_1_SLAVE_ENABLE_MASK 0x80000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_1_SLAVE_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_1_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_1_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_1_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_1_PACKET_ENABLE_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_2          0x0003F110
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_2_WIDTH    32
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_2_MASK     0xC0000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_2_SLAVE_ENABLE_LSB 31
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_2_SLAVE_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_2_SLAVE_ENABLE_MASK 0x80000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_2_SLAVE_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_2_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_2_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_2_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_2_PACKET_ENABLE_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_3          0x0003F114
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_3_WIDTH    32
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_3_MASK     0xC0000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_3_SLAVE_ENABLE_LSB 31
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_3_SLAVE_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_3_SLAVE_ENABLE_MASK 0x80000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_3_SLAVE_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_3_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_3_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_3_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_3_PACKET_ENABLE_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_4          0x0003F118
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_4_WIDTH    32
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_4_MASK     0xC0000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_4_SLAVE_ENABLE_LSB 31
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_4_SLAVE_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_4_SLAVE_ENABLE_MASK 0x80000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_4_SLAVE_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_4_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_4_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_4_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_4_PACKET_ENABLE_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_5          0x0003F11C
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_5_WIDTH    32
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_5_MASK     0xC0000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_5_SLAVE_ENABLE_LSB 31
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_5_SLAVE_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_5_SLAVE_ENABLE_MASK 0x80000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_5_SLAVE_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_5_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_5_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_5_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_5_PACKET_ENABLE_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_6          0x0003F120
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_6_WIDTH    32
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_6_MASK     0xC0000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_6_SLAVE_ENABLE_LSB 31
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_6_SLAVE_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_6_SLAVE_ENABLE_MASK 0x80000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_6_SLAVE_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_6_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_6_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_6_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_6_PACKET_ENABLE_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_7          0x0003F124
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_7_WIDTH    32
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_7_MASK     0xC0000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_7_SLAVE_ENABLE_LSB 31
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_7_SLAVE_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_7_SLAVE_ENABLE_MASK 0x80000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_7_SLAVE_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_7_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_7_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_7_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_SOUTH_7_PACKET_ENABLE_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_0           0x0003F128
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_0_WIDTH     32
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_0_MASK      0xC0000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_0_SLAVE_ENABLE_LSB 31
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_0_SLAVE_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_0_SLAVE_ENABLE_MASK 0x80000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_0_SLAVE_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_0_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_0_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_0_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_0_PACKET_ENABLE_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_1           0x0003F12C
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_1_WIDTH     32
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_1_MASK      0xC0000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_1_SLAVE_ENABLE_LSB 31
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_1_SLAVE_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_1_SLAVE_ENABLE_MASK 0x80000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_1_SLAVE_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_1_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_1_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_1_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_1_PACKET_ENABLE_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_2           0x0003F130
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_2_WIDTH     32
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_2_MASK      0xC0000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_2_SLAVE_ENABLE_LSB 31
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_2_SLAVE_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_2_SLAVE_ENABLE_MASK 0x80000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_2_SLAVE_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_2_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_2_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_2_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_2_PACKET_ENABLE_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_3           0x0003F134
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_3_WIDTH     32
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_3_MASK      0xC0000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_3_SLAVE_ENABLE_LSB 31
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_3_SLAVE_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_3_SLAVE_ENABLE_MASK 0x80000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_3_SLAVE_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_3_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_3_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_3_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_WEST_3_PACKET_ENABLE_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_0          0x0003F138
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_0_WIDTH    32
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_0_MASK     0xC0000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_0_SLAVE_ENABLE_LSB 31
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_0_SLAVE_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_0_SLAVE_ENABLE_MASK 0x80000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_0_SLAVE_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_0_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_0_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_0_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_0_PACKET_ENABLE_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_1          0x0003F13C
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_1_WIDTH    32
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_1_MASK     0xC0000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_1_SLAVE_ENABLE_LSB 31
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_1_SLAVE_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_1_SLAVE_ENABLE_MASK 0x80000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_1_SLAVE_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_1_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_1_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_1_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_1_PACKET_ENABLE_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_2          0x0003F140
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_2_WIDTH    32
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_2_MASK     0xC0000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_2_SLAVE_ENABLE_LSB 31
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_2_SLAVE_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_2_SLAVE_ENABLE_MASK 0x80000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_2_SLAVE_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_2_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_2_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_2_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_2_PACKET_ENABLE_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_3          0x0003F144
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_3_WIDTH    32
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_3_MASK     0xC0000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_3_SLAVE_ENABLE_LSB 31
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_3_SLAVE_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_3_SLAVE_ENABLE_MASK 0x80000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_3_SLAVE_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_3_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_3_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_3_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_NORTH_3_PACKET_ENABLE_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_0           0x0003F148
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_0_WIDTH     32
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_0_MASK      0xC0000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_0_SLAVE_ENABLE_LSB 31
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_0_SLAVE_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_0_SLAVE_ENABLE_MASK 0x80000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_0_SLAVE_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_0_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_0_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_0_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_0_PACKET_ENABLE_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_1           0x0003F14C
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_1_WIDTH     32
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_1_MASK      0xC0000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_1_SLAVE_ENABLE_LSB 31
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_1_SLAVE_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_1_SLAVE_ENABLE_MASK 0x80000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_1_SLAVE_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_1_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_1_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_1_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_1_PACKET_ENABLE_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_2           0x0003F150
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_2_WIDTH     32
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_2_MASK      0xC0000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_2_SLAVE_ENABLE_LSB 31
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_2_SLAVE_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_2_SLAVE_ENABLE_MASK 0x80000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_2_SLAVE_ENABLE_DEFVAL 0x0
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_2_PACKET_ENABLE_LSB 30
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_2_PACKET_ENABLE_WIDTH 1
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_2_PACKET_ENABLE_MASK 0x40000000
#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_2_PACKET_ENABLE_DEFVAL 0x0

#define XAIE2PGBL_PL_MODULE_STREAM_SWITCH_SLAVE_CONFIG_EAST_3           0x0003F154
#define XAIE2